<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_brickfield', language 'id', version '5.1'.
 *
 * @package     tool_brickfield
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessibility'] = 'Aksesibilitas';
$string['accessibilitydisabled'] = 'Toolkit aksesibilitas Brickfield tidak diaktifkan di situs ini. Hubungi administrator situs Anda untuk mengaktifkan.';
$string['accessibilityreport'] = 'Perangkat aksesibilitas';
$string['accessibilitytool'] = 'Alat aksesibilitas Brickfield';
$string['accessibilitytools'] = 'Alat aksesibilitas Brickfield';
$string['activate'] = 'Mengaktifkan';
$string['activated'] = 'Pengaya sudah aktif dan siap digunakan.';
$string['activationform'] = 'Pendaftaran Brickfield';
$string['activationheader'] = 'Aktivasi Brickfield';
$string['activationinfo'] = '<p> Untuk menggunakan pengaya ini, Anda harus memberikan kunci yang valid untuk situs ini dalam formulir ini. </p> <p> Harap <a href = "{$a}" data-action = "send_info" target = " _blank "> mendaftar di Brickfield Portal (terbuka di jendela baru) </a> untuk menerima kunci tersebut jika Anda belum memilikinya. </p> <p> Setelah diaktifkan, kunci Anda akan divalidasi melalui tugas cron terjadwal. </p>';
$string['activityresults:pluginname'] = 'Laporan alat aksesibilitas rincian aktivitas';
$string['activityresults:toolname'] = 'Ringkasan rincian aktivitas';
$string['activityresults:toolshortname'] = 'Rincian aktivitas';
$string['advanced:pluginname'] = 'Laporan alat aksesibilitas lanjutan';
$string['advanced:toolname'] = 'Ringkasan lanjutan';
$string['advanced:toolshortname'] = 'Lanjutan';
$string['allcourses'] = 'Semua kursus yang ditinjau ({$a})';
$string['allcoursescat'] = 'Semua kursus yang ditinjau untuk kategori {$a->catname} ({$a->count})';
$string['analysis:byrequest'] = 'Atas permintaan';
$string['analysis:disabled'] = 'Dinonaktifkan';
$string['analysistype'] = 'Aktifkan permintaan analisis';
$string['analysistype_desc'] = 'Izinkan analisis aksesibilitas konten diminta';
$string['analysistypedisabled'] = 'Analisis konten dinonaktifkan';
$string['bannercontentone'] = 'Perangkat Aksesibilitas Perusahaan memiliki serangkaian fitur lengkap untuk membantu organisasi Anda meningkatkan aksesibilitas kursus Anda. <a href="{$a}"> Hubungi Brickfield Education Labs </a> untuk memesan demo gratis tentang fitur lanjutan.';
$string['bannercontenttwo'] = 'Bangun platform pengajaran dan pembelajaran yang efektif dan inklusif dengan menemukan konten yang tidak memenuhi pedoman, memperbaiki masalah, dan menguji konten kursus Moodle Anda di masa mendatang dengan berkas yang dapat diakses, editor, dan fitur yang disempurnakan.';
$string['bannerheadingone'] = 'Tingkatkan ke Perangkat Aksesibilitas Perusahaan';
$string['batch'] = 'Batas massal';
$string['brickfield'] = 'Perangkat Brickfield';
$string['brickfield:viewcoursetools'] = 'Lihat laporan per kursus';
$string['brickfield:viewsystemtools'] = 'Lihat laporan untuk semua kursus';
$string['bulkprocesscaches'] = 'Proses singgahan massal';
$string['bulkprocesscourses'] = 'Proses pemeriksaan aksesibilitas batch massal';
$string['buttonone'] = 'Dapatkan demo gratis';
$string['cachepending'] = 'Data ringkasan sedang disusun';
$string['checkdesc:alinksdontopennewwindow'] = 'Tautan yang membuka jendela baru harus memperingatkan pengguna sebelumnya.';
$string['checkdesc:amustcontaintext'] = 'Tautan harus berisi teks agar dapat dipahami.';
$string['checkdesc:areadontopennewwindow'] = 'Area, yang digunakan dalam peta gambar, membuka jendela baru harus memperingatkan pengguna sebelumnya.';
$string['checkdesc:areahasaltvalue'] = 'Area, yang digunakan dalam peta gambar, tidak boleh melewatkan teks alt (alternatif), mirip dengan gambar.';
$string['checkdesc:asuspiciouslinktext'] = 'Teks tautan harus deskriptif dan memberikan konteks tentang tujuannya.';
$string['checkdesc:basefontisnotused'] = 'Elemen Basefont (biasanya digunakan untuk pemformatan) tidak dapat diakses dan tidak boleh digunakan.';
$string['checkdesc:blinkisnotused'] = 'Elemen Blink, yang berkedip dan mati, tidak dapat diakses dan tidak boleh digunakan.';
$string['checkdesc:boldisnotused'] = 'Elemen Bold (b) tidak boleh digunakan; "strong" harus digunakan sebagai gantinya.';
$string['checkdesc:contenttoolong'] = 'Panjang konten halaman keseluruhan tidak boleh melebihi 500 kata.';
$string['checkdesc:csstexthascontrast'] = 'Kontras warna antara teks dan latar belakang terlalu rendah.';
$string['checkdesc:embedhasassociatednoembed'] = 'Elemen yang disematkan (untuk menyematkan multimedia) tidak boleh kehilangan elemen "noembed" yang sesuai.';
$string['checkdesc:headerh3'] = 'Header yang mengikuti setelah header H3 (opsi editor header besar) tidak boleh merusak hierarki judul halaman.';
$string['checkdesc:headershavetext'] = 'Header harus berisi teks agar dapat dipahami.';
$string['checkdesc:iisnotused'] = 'Italic (i) tidak boleh digunakan; "em" harus digunakan sebagai gantinya.';
$string['checkdesc:imgaltisdifferent'] = 'Teks alt (alternatif) gambar tidak boleh berupa nama berkas gambar.';
$string['checkdesc:imgaltistoolong'] = 'Pastikan teks alt (alternatif) gambar cukup ringkas untuk mendeskripsikan gambar.';
$string['checkdesc:imgaltnotemptyinanchor'] = 'Teks alt (alternatif) gambar tidak boleh kosong, terutama jika gambar memiliki tautan ke tempat lain.';
$string['checkdesc:imgaltnotplaceholder'] = 'Teks alt (alternatif) gambar tidak boleh berupa teks placeholder sederhana, seperti "gambar".';
$string['checkdesc:imghasalt'] = 'Teks alt (alternatif) gambar tidak boleh hilang untuk elemen gambar, kecuali hanya dekoratif tanpa arti.';
$string['checkdesc:imgwithmaphasusemap'] = 'Peta gambar, dengan area yang dapat diklik, membutuhkan elemen "usermap" dan "map" yang cocok.';
$string['checkdesc:legendtextnotempty'] = 'Elemen legenda, digunakan untuk membuat teks pada elemen fieldset, harus berisi teks.';
$string['checkdesc:marqueeisnotused'] = 'Elemen marquee (pengguliran otomatis) tidak dapat diakses dan tidak boleh digunakan.';
$string['checkdesc:noheadings'] = 'Tidak ada header yang membuat konten kurang terstruktur dan lebih sulit dibaca.';
$string['checkdesc:objectmusthaveembed'] = 'Elemen objek (untuk menyematkan sumber daya eksternal) tidak boleh kehilangan elemen "embed" yang sesuai.';
$string['checkdesc:objectmusthavetitle'] = 'Elemen objek (untuk menyematkan sumber daya eksternal) tidak boleh kehilangan deskripsi "title" yang sesuai.';
$string['checkdesc:objectmusthavevalidtitle'] = 'Elemen objek (untuk menyematkan sumber daya eksternal) harus memiliki "titles" yang sesuai dengan teks.';
$string['checkdesc:strikeisnotused'] = 'Elemen Strike (strike-through) tidak boleh digunakan; "del" (dihapus) harus digunakan sebagai gantinya.';
$string['checkdesc:tabledatashouldhaveth'] = 'Tabel idealnya tidak boleh kehilangan header.';
$string['checkdesc:tablesummarydoesnotduplicatecaption'] = 'Ringkasan tabel dan keterangan gambar tidak boleh identik.';
$string['checkdesc:tabletdshouldnotmerge'] = 'Tabel idealnya tidak boleh memiliki sel gabungan.';
$string['checkdesc:tablethshouldhavescope'] = 'Cakupan baris atau kolom tabel (digunakan untuk memetakan baris dan kolom ke setiap sel) harus dideklarasikan.';
$string['checkidvalidation'] = 'Tugas untuk memeriksa checkid yang tidak valid';
$string['checkscompleted'] = 'Pemeriksaan selesai: {$a}';
$string['checktype'] = 'Periksa grup';
$string['checktype:form'] = 'Formulir';
$string['checktype:image'] = 'Gambar';
$string['checktype:layout'] = 'Tata letak';
$string['checktype:link'] = 'Tautan';
$string['checktype:media'] = 'Media';
$string['checktype:table'] = 'Tabel';
$string['checktype:text'] = 'Teks';
$string['checktyperesults:pluginname'] = 'Laporan alat aksesibilitas tipe konten';
$string['checktyperesults:toolname'] = 'Ringkasan tipe konten';
$string['checktyperesults:toolshortname'] = 'Tipe konten';
$string['cmpercent'] = 'Persentase keseluruhan aktivitas';
$string['cmpercenterrors'] = 'Persentase keseluruhan kesalahan';
$string['cmpercenttitle'] = 'Keseluruhan% perincian aktivitas versus kesalahan';
$string['confirmationmessage'] = 'kursus ini telah dijadwalkan untuk analisis. Analisis akan diselesaikan paling cepat pada {$a}. Periksa kembali setelah itu.';
$string['contactadmin'] = 'Silakan hubungi administrator Anda untuk menyelesaikan pendaftaran.';
$string['contactus'] = 'Hubungi kami';
$string['contentfive'] = 'Secara otomatis memperbaiki tag HTML lama.';
$string['contentfour'] = 'Identifikasi aktivitas mana yang memiliki masalah aksesibilitas paling banyak untuk memprioritaskan upaya.';
$string['contentone'] = 'Secara otomatis mengevaluasi konten dan penilaian kursus Anda untuk masalah aksesibilitas.';
$string['contentsix'] = 'Memberi pengajar kiat tepat waktu untuk membuat konten yang lebih baik.';
$string['contentthree'] = 'Berikan siswa Anda konten dalam format yang dapat diakses termasuk Audio, ePub, dan Braille Elektronik.';
$string['contenttwo'] = 'Pembaruan massal teks yang tidak jelas atau hilang untuk tautan web, deskripsi gambar, dan terjemahan video.';
$string['contenttypeerrors'] = 'Hasil total tes konten aktivitas per kursus dan per jenis konten.';
$string['contentyperesults'] = 'Total lulus/gagal untuk area konten per kursus.';
$string['contextid'] = 'Contextid';
$string['core_course'] = 'Kursus';
$string['core_question'] = 'Bank soal';
$string['count'] = 'Hitung';
$string['country'] = 'Negara';
$string['country_help'] = 'Negara situs';
$string['coursecount'] = 'Jumlah kursus';
$string['deletehistoricaldata'] = 'Hapus hasil pemeriksaan riwayat';
$string['dependency'] = 'Tergantung pada';
$string['emptycategory'] = 'Tidak ada kursus yang ditemukan untuk kategori {$a}';
$string['emptytagcourses'] = 'Tidak ada hasil yang ditemukan untuk kursus dengan tagar terkonfigurasi';
$string['enableaccessibilitytools'] = 'Aktifkan alat aksesibilitas';
$string['enableaccessibilitytools_desc'] = 'Perangkat aksesibilitas membantu mengidentifikasi masalah aksesibilitas dalam kursus.';
$string['error:nocoursespecified'] = 'Laporan ringkasan ini membutuhkan id kursus yang valid. Silakan akses perangkat aksesibilitas dari dalam kursus, melalui menu aksi, yang kemudian akan memberikan id kursus yang diperlukan.';
$string['errorlink'] = 'Edit Model galat untuk {$a}';
$string['errors'] = 'Galat: {$a}';
$string['errors:pluginname'] = 'Alat aksesibilitas daftar kesalahan';
$string['errors:toolname'] = 'Ringkasan daftar kesalahan';
$string['errors:toolshortname'] = 'Daftar kesalahan';
$string['eventanalysis_requested'] = 'Analisis konten diminta';
$string['eventanalysis_requesteddesc'] = 'Analisis konten diminta untuk kursus {$a}.';
$string['eventreport_downloaded'] = 'Ringkasan aksesibilitas diunduh';
$string['eventreport_downloadeddesc'] = 'Ringkasan aksesibilitas diunduh untuk ID kursus {$a}.';
$string['eventreport_viewed'] = 'Laporan aksesibilitas dilihat';
$string['eventreport_vieweddesc'] = 'Laporan aksesibilitas dilihat untuk id kursus {$a->course}, id kategori {$a->category}, tab {$a->tab}.';
$string['failed'] = 'Gagal';
$string['failedcount'] = 'Gagal: {$a}';
$string['footerheading'] = 'Bagian footer';
$string['fullcachedone'] = 'Nonaktifkan untuk jalankan ulang singgahan';
$string['hashcorrect'] = 'Kode yang dimasukkan benar.';
$string['hashincorrect'] = 'Kode yang dimasukkan salah.';
$string['headingfive'] = 'Perbaikan HTML';
$string['headingfour'] = 'Fokus usaha';
$string['headingone'] = 'Evaluasi konten';
$string['headingsix'] = 'Dukungan kinerja';
$string['headingthree'] = 'Format berkas yang dapat diakses';
$string['headingtwo'] = 'Remidiasi';
$string['hideshow'] = 'Sembunyikan/tampilkan';
$string['icon:analytics-custom'] = 'Ikon analitik';
$string['icon:file-edit-custom'] = 'Edit berkas ikon';
$string['icon:hands-helping-custom'] = 'Ikon tangan membantu';
$string['icon:search-plus-custom'] = 'Ikon pencarian';
$string['icon:tools-custom'] = 'Ikon peralatan';
$string['icon:wand-magic-custom'] = 'Ikon tongkat sihir';
$string['inactive'] = 'Pengaya tidak aktif dan tidak dapat digunakan. Silakan masukkan kunci registrasi yang valid, dan tekan "Aktifkan".';
$string['innercontextid'] = 'Inner contextid';
$string['installed'] = 'Pengaya terpasang';
$string['installedcli'] = 'Pengaya diinstal melalui baris perintah';
$string['installeddescription'] = 'Pengaya telah diinstal, alihkan ke formulir aktivasi.';
$string['invalidaccessibilitytool'] = 'Sub-pengaya aksesibilitas yang tidak valid diminta.';
$string['invalidcategoryid'] = 'Kategori tidak valid, harap periksa masukan Anda';
$string['invalidcourseid'] = 'Kursus tidak valid, harap periksa masukan Anda';
$string['invalidlinkphrases'] = 'klik | klik di sini| di sini | selengkapnya | selengkapnya di sini | info | info di sini | informasi | informasi di sini | baca selengkapnya | baca selengkapnya di sini | informasi lebih lanjut | informasi lebih lanjut di sini | keterangan lebih lanjut | detail lebih lanjut di sini';
$string['language'] = 'Bahasa';
$string['language_help'] = 'Bahasa situs';
$string['messageprovider:warningcheckid'] = 'Peringatan checkid tidak valid';
$string['mobileservice'] = 'Layanan seluler diaktifkan ({$a})';
$string['module'] = 'Modul';
$string['modulename'] = 'Nama';
$string['moreinfo'] = 'Informasi lanjutan';
$string['newwindowphrases'] = 'jendela baru|jendela-baru|jendela_baru';
$string['noerrorsfound'] = 'Tidak ada kesalahan aksesibilitas umum yang ditemukan untuk parameter pencarian Anda. Selamat!';
$string['norecords'] = 'Tidak ada catatan relevan yang ditemukan untuk parameter pencarian Anda.';
$string['notregistered'] = 'Perangkat aksesibilitas Anda perlu didaftarkan.';
$string['notvalidated'] = 'Perangkat aksesibilitas Anda berfungsi saat divalidasi.';
$string['numcourses'] = 'Jumlah kursus ({$a})';
$string['numfactivities'] = 'Jumlah aktivitas ({$a})';
$string['numfiles'] = 'Jumlah berkas ({$a})';
$string['numinstances'] = 'Jumlah model';
$string['numusers'] = 'Jumlah pengguna ({$a})';
$string['pagedesc:checktype'] = '<p> Untuk meringkas dan menganalisis hasil dari berbagai pemeriksaan yang dilakukan, kami mengelompokkan pemeriksaan tersebut ke dalam jenis konten yang berbeda. Karenanya, semua hasil pemeriksaan aksesibilitas terkait gambar ada di grup jenis konten "Gambar", semua hasil pemeriksaan aksesibilitas terkait tata letak ada di grup jenis konten "Tata letak", dan seterusnya. </p> <p> Aktivitas disertakan baik sebagai aktivitas, sumber daya, atau area konten yang berkaitan dengan kursus itu sendiri. </p> <p> Halaman bagan tipe konten menampilkan perincian kesalahan per grup jenis konten: Gambar, Tata Letak, Tautan, Media, Tabel, dan Teks. </ p>';
$string['pagedesc:pertarget'] = '<p> Untuk meringkas dan menganalisis hasil pemeriksaan per aktivitas, kami mengelompokkan hasil pemeriksaan ini ke dalam berbagai aktivitas yang terdeteksi. </p> <p> Aktivitas termasuk baik aktivitas, sumber, atau area konten lain yang berkaitan dengan kursus diri. Setiap aktivitas tanpa kesalahan yang terdeteksi dihitung sebagai lulus, setiap aktivitas dengan satu atau beberapa kesalahan terdeteksi dianggap gagal. Rasio yang diteruskan ke aktivitas yang gagal kemudian ditampilkan. </p> <p> Halaman diagram perincian aktivitas menampilkan rasio yang diteruskan ke instance yang gagal secara total, per aktivitas, seperti tugas, kursus, label, dll. </p>';
$string['pagedesctitle:checktype'] = 'Penjuelasan jenis konten';
$string['pagedesctitle:pertarget'] = 'Penjelasan rincian aktivitas';
$string['passed'] = 'Lulus';
$string['passedcount'] = 'Lulus: {$a}';
$string['passrate'] = 'Tingkat kelulusan: {$a}%';
$string['pdf:filename'] = 'Brickfield_Summaryreport_CourseID-{$a}';
$string['percheckerrors'] = 'Jumlah tes dan kesalahan khusus per pemeriksaan per kursus.';
$string['perpage'] = 'Item per halaman';
$string['pluginname'] = 'Perangkat aksesibilitas';
$string['printable:downloadpdf'] = 'Unduh PDF';
$string['printable:pluginname'] = 'Laporan alat aksesibilitas laporan ringkasan';
$string['printable:printreport'] = 'Laporan cetak';
$string['printable:toolname'] = 'Rangkuman laporan';
$string['printable:toolshortname'] = 'Rangkuman laporan';
$string['privacy:metadata'] = 'Pengaya laporan pemeriksaan aksesibilitas tidak menyimpan data pribadi apa pun.';
$string['processanalysisrequests'] = 'Proses permintaan analisis konten';
$string['registernow'] = 'Silakan daftar sekarang.';
$string['registration'] = 'Formulir pendaftaran';
$string['registrationinfo'] = '<p> Proses pendaftaran ini memungkinkan Anda menggunakan versi permulaan perangkat aksesibilitas Brickfield untuk situs Moodle terdaftar Anda. </p> <p> Penggunaan ini tunduk pada <a href = "{$a}" target = "_ blank" > Syarat dan ketentuan Brickfield Education Labs (terbuka di jendela baru) </a> dan yang Anda setujui, dengan menggunakan produk ini. </p>';
$string['release'] = 'Rilis Moodle ({$a})';
$string['remaining'] = '({$a} kesalahan tersisa)';
$string['response:0'] = 'URL ini tidak mengarah ke mana pun';
$string['response:404'] = 'Halaman URL ini tidak ditemukan';
$string['schedule:blocknotscheduled'] = '<p> Kursus ini belum dijadwalkan untuk analisis, untuk menemukan masalah aksesibilitas umum. </p>';
$string['schedule:notscheduled'] = '<p> Kursus ini belum dijadwalkan untuk analisis guna menemukan masalah aksesibilitas umum. </p> <p> Dengan mengklik tombol "Kirim untuk analisis", Anda mengonfirmasi bahwa Anda menginginkan semua konten HTML kursus yang relevan, seperti Deskripsi bagian kursus, deskripsi aktivitas, pertanyaan, halaman, dan lainnya, yang akan dijadwalkan untuk analisis. </p> <p> Analisis ini akan melakukan beberapa pemeriksaan aksesibilitas umum pada konten HTML kursus Anda, dan hasilnya kemudian akan ditampilkan pada aksesibilitas ini halaman laporan perangkat. Analisis akan diproses di latar belakang, berdasarkan tugas yang dijadwalkan, sehingga kecepatan penyelesaiannya akan bergantung pada setelan waktu tugas dan jadwal pelaksanaan tugas. </p>';
$string['schedule:requestanalysis'] = 'Ajukan untuk dianalisis';
$string['schedule:scheduled'] = 'Kursus ini telah dijadwalkan untuk analisis.';
$string['schedule:sitenotscheduled'] = '<p> Konten global (kursus independen) belum dijadwalkan untuk analisis untuk menemukan masalah aksesibilitas umum. </p> <p> Dengan mengklik tombol "Kirim untuk analisis", Anda mengonfirmasi bahwa Anda menginginkan semua produk global Anda yang relevan. konten (kursus independen) yang akan dijadwalkan untuk analisis. </p> <p> Analisis ini akan melakukan beberapa pemeriksaan aksesibilitas umum pada konten ini, dan hasilnya kemudian akan ditampilkan pada halaman laporan perangkat aksesibilitas ini. Analisis akan diproses di latar belakang, berdasarkan tugas yang dijadwalkan, sehingga kecepatan penyelesaiannya akan bergantung pada setelan waktu tugas dan jadwal pelaksanaan tugas. </p>';
$string['schedule:sitescheduled'] = 'Konten global (kursus independen) telah dijadwalkan untuk analisis.';
$string['secretkey'] = 'Kunci API';
$string['secretkey_help'] = 'Kode ini diterima melalui surel setelah pendaftaran.';
$string['sendfollowinginfo'] = '<p> Informasi berikut akan dikirim secara berkala untuk berkontribusi hanya pada statistik keseluruhan. Ini tidak akan dipublikasikan di daftar pusat mana pun. </p> {$a}';
$string['settings'] = 'Setelan perangkat aksesibilitas';
$string['sitehash'] = 'Kunci rahasia';
$string['sitehash_help'] = 'Kode ini diterima melalui surel setelah pendaftaran.';
$string['taberrors'] = 'Cek kesalahan';
$string['targetavetitle'] = 'Kesalahan rata-rata per aktivitas';
$string['targetpercentage'] = 'Persentase model  lulus/bukan per aktivitas';
$string['targetratio'] = 'Rasio kelulusan aktivitas';
$string['tblcheck'] = 'Periksa';
$string['tblcheckexample'] = 'Contoh';
$string['tblcheckfailed'] = 'Pengecekan gagal';
$string['tblchecksummary'] = 'Ringkasan';
$string['tbledit'] = 'Edit';
$string['tblerrorcount'] = 'Galat';
$string['tblhtmlcode'] = 'Kode HTML yang sudah ada';
$string['tblinstance'] = 'Model';
$string['tblline'] = 'Baris';
$string['tbloverallpercentage'] = 'Galat keseluruhan %';
$string['tblpercentage'] = 'Presentase';
$string['tblpreview'] = 'Pratinjau';
$string['tbltarget'] = 'Aktivitas';
$string['tblupdateto'] = 'Perbarui ke';
$string['titleactivityresultsall'] = 'Hasil per aktivitas: semua kursus yang ditinjau ({$a->count} kursus)';
$string['titleactivityresultspartial'] = 'Hasil per aktivitas: kursus {$a->name}';
$string['titleall'] = 'Detail kesalahan: semua kursus yang ditinjau ({$a->count} kursus)';
$string['titlechecktyperesultsall'] = 'Hasil per jenis konten: semua kursus yang ditinjau ({$a->count} kursus)';
$string['titlechecktyperesultspartial'] = 'Hasil per jenis konten: kursus {$a->name}';
$string['titleerrorsall'] = 'Detail kesalahan: semua kursus yang ditinjau ({$a->count} kursus)';
$string['titleerrorscount'] = 'Detail kesalahan: (menampilkan kesalahan {$a} pertama)';
$string['titleerrorspartial'] = 'Detail kesalahan: kursus {$a->name}';
$string['titlepartial'] = 'Detail kesalahan: kursus {$a->name}';
$string['titleprintableall'] = 'Kursus {$a->name}';
$string['titleprintablepartial'] = 'Kursus {$a->name}';
$string['tools'] = 'Laporan';
$string['toperrors'] = 'Kesalahan teratas';
$string['toptargets'] = 'Aktivitas gagal';
$string['totalactivities'] = 'Total aktivitas';
$string['totalactivitiescount'] = 'Total aktivitas: {$a}';
$string['totalareas'] = 'Total area';
$string['totalerrors'] = 'Total kesalahan';
$string['totalgrouperrors'] = 'Total (jumlah) kesalahan per tipe konten';
$string['updatesummarydata'] = 'Perbarui data ringkasan situs';
$string['usersmobileregistered'] = 'Jumlah pengguna dengan perangkat seluler terdaftar ({$a})';
$string['validationerror'] = 'Validasi kunci registrasi gagal. Pastikan URL dan kunci situs terdaftar Anda sudah benar.';
$string['warningcheckidbody'] = 'Ada masalah dengan pemeriksaan Brickfield yang aktif tetapi tidak terdaftar dalam basis data. Tolong investigasi.';
$string['warningcheckidsubject'] = 'Peringatan checkID Perangkat Brickfield';
