<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'grouptool', language 'sr_lt', version '5.1'.
 *
 * @package     grouptool
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activated_group'] = 'Aktivirana grupa';
$string['activated_groups'] = 'Aktivirane grupe!';
$string['active'] = 'Aktivna grupa';
$string['activegroups'] = 'Aktivne grupe';
$string['add_member'] = 'Dodaj korisnika <strong>{$a->username}</strong> u grupu <strong>{$a->groupname}</strong>';
$string['added_member'] = 'Korisnik <strong>{$a->username}</strong> je dodat u grupu <strong>{$a->groupname}</strong>';
$string['administration'] = 'Administracija';
$string['administration_alt'] = 'Kreiranje grupe(a) i podešavanja za aktivne grupe ove instance';
$string['agroups'] = 'Aktivne grupe';
$string['ajax_edit_size_help'] = 'Sačuvajte novu veličinu pomoću tastera &lt;Enter&gt, upotrebite taster &lt;ESC&gt ako želite da odustanete, ostavite prazno kako biste obrisali individualnu veličinu';
$string['all_groups_full'] = 'Nije moguće prijaviti korisnika <strong>{$a}</strong> ni u jednu grupu jer su sve popunjene!';
$string['allow_multiple'] = 'Višestruke prijave';
$string['allow_multiple_help'] = 'Omogućite polaznicima da se prijave u više od 1 grupe istovremeno. Morate da navedete koliko grupa moraju da izaberu najmanje (= minimum groups to choose) i koliko grupa im je dozvoljeno da izaberu maksimalno (= maximum groups to choose).';
$string['allow_reg'] = 'Omogućite samostalnu prijavu';
$string['allow_reg_help'] = 'Omogućite samostalnu prijavu za polaznike kako bi oni mogli samostalno da se prijave u aktivne, dole izabrane, grupe.';
$string['allow_unreg'] = 'Dozvoli odjavu iz grupe';
$string['allow_unreg_help'] = 'Omogućite polaznicima da se odjave iz grupe ili da pređu u neke druge grupe, pre (opciono) definisanog krajnjeg roka.';
$string['allowed'] = 'Dozvoljeno';
$string['already_marked'] = 'Ova grupa je već označena za prijavljivanje!';
$string['already_member'] = 'Korisnik<strong>{$a->username}</strong> je već član grupe <strong>{$a->groupname}</strong>';
$string['already_occupied'] = 'Mesto u grupi <strong>{$a->grpname}</strong> je zauzeto pošto se drugi korisnik ranije već prijavio u ovu grupu. Potražite drugu grupu!';
$string['already_queued'] = 'Korisnik <strong>{$a->username}</strong> je već listi čekanje za upis u grupu <strong>{$a->groupname}</strong>!';
$string['already_registered'] = 'Korisnik<strong>{$a->username}</strong> se već prijavio u grupu <strong>{$a->groupname}</strong>!';
$string['alwaysshowdescription'] = 'Uvek prikaži opis';
$string['alwaysshowdescription_help'] = 'Ako je ova opcija onemogućena, gornji opis zadatka će postati vidljiv polaznicima samo od datuma”Početak prijavljivanja”.';
$string['asterisk_marks_moodle_registrations'] = 'Korisnici sa zvezdicom (*) kao prefiksom su se već prijavili u odgovarajuću Moodle grupu';
$string['availabledate'] = 'Početak prijavljivanja';
$string['availabledate_help'] = 'Početak perioda prijavljivanja u grupe. Nakon ovog datuma polaznici mogu da se prijave u odabrane grupe (ako je to omogućeno).';
$string['availabledateno'] = 'Uvek dostupno';
$string['calendaravailable'] = 'Otvara se prijava {$a}';
$string['calendardue'] = 'Rok za prijavu u grupe je {$a}';
$string['cant_enrol'] = 'Nije moguće automatski upisati korisnika na kurs.';
$string['cfg_addinstanceset_head'] = 'Dodatna podešavanja instance';
$string['cfg_addinstanceset_head_info'] = 'Dodatna podešavanja alata za grupu.';
$string['cfg_admin_head'] = 'Podrazumevana podešavanja za karticu Administracija';
$string['cfg_admin_head_info'] = 'Standardne podešavanja za karticu administracije u prikazu alata za grupe.';
$string['cfg_allow_multiple'] = 'Višestruke prijave';
$string['cfg_allow_multiple_desc'] = 'Omogućite, standardno, polaznicima da se prijave u više od 1 grupe istovremeno.';
$string['cfg_allow_reg'] = 'Dozvolite samostalnu prijavu';
$string['cfg_allow_reg_desc'] = 'Omogućite, standardno, polaznicima da se sami prijave';
$string['cfg_allow_unreg'] = 'Dozvolite odjavu iz grupe';
$string['cfg_allow_unreg_desc'] = 'Da li korisnici mogu da se sami odjave i promene grupe?';
$string['cfg_choose_max'] = 'Izaberite maksimalan broj grupa';
$string['cfg_choose_max_desc'] = 'U koliko grupa bi, standardno, korisnici mogli da se prijave istovremeno?';
$string['cfg_choose_min'] = 'Izaberite minimalni broj grupa';
$string['cfg_choose_min_desc'] = 'Koliko minimalno grupa, standardno, korisnici mogu da izaberu?';
$string['cfg_force_dereg'] = 'Obavezno odjavljivanje u alatu za grupu';
$string['cfg_force_dereg_desc'] = 'Obavezno odjavljivanje ne samo iz alata za grupe već i iz Moodle-grupe.';
$string['cfg_force_importreg'] = 'Obavezno prijavljivanje u alatu za grupu';
$string['cfg_force_importreg_desc'] = 'Pomoću alata za grupe primorajte korisnike (uvezene putem Moodle-grupa) da se obavezno prijave i u toj instanci alata za grupe.';
$string['cfg_groups_queues_limit'] = 'Broj mesta na listi čekanja po grupi';
$string['cfg_groups_queues_limit_desc'] = 'Određuje, standardno, koliko različitih polaznika može biti stavljeno na listu čekanje za upis u grupu istovremeno.';
$string['cfg_grpsize'] = 'Globalna standardna veličina grupe';
$string['cfg_grpsize_desc'] = 'Standardna veličina grupe koja se koristi svuda u alatu za grupu';
$string['cfg_ifgroupdeleted'] = 'Ako se grupe obrišu';
$string['cfg_ifgroupdeleted_desc'] = 'Da li obrisane grupe treba ponovo da budu kreirane za instancu alata za grupe ili reference u alatu za grupu (uključujući podatke o grupi, prijavama i redosledu) treba obrisati? Napomena: Ako izaberete opciju ”ponovo kreiraj grupu“, onda će grupe automatski ponovo biti kreirane, nakon brisanja pod ”Administracija kursa / Učesnici / Grupe”.';
$string['cfg_ifmemberadded'] = 'Ako su članovi grupe dodati';
$string['cfg_ifmemberadded_desc'] = 'Da li novi članovi grupe, dodati preko Moodle grupa, takođe treba da budu prijavljeni u alatu za grupe ili treba da budu ignorisani?';
$string['cfg_ifmemberremoved'] = 'Ako su članovi grupe uklonjeni';
$string['cfg_ifmemberremoved_desc'] = 'Da li bi prijave pomoću alata za grupe trebalo da budu obrisane ako su korisnici obrisani iz odgovarajuće Moodle-grupe?';
$string['cfg_immediate_reg'] = 'Neposredna prijava';
$string['cfg_immediate_reg_desc'] = 'Da li svaka prijava treba da se prosledi Moodle-grupama?';
$string['cfg_importfields'] = 'Uporedite polja za uvoz/odjavu';
$string['cfg_importfields_desc'] = 'Definiše koja polja u tabeli korisnika treba da se uporede sa podacima prilikom uvoza/odjave korisnika. Polja se pretražuju jedno po jedno dok se ne pronađe jedinstveno podudaranje. Moguće /korisne vrednosti su na primer: korisničko ime, ID broj, e-adresa. PAŽNJA: tačni nazivi polja se ne proveravaju. Dozvoljeni znakovi: a-z, A-Z i \',\'';
$string['cfg_instance_head'] = 'Podrazumevana podešavanja instance';
$string['cfg_instance_head_info'] = 'Podrazumevana podešavanja za nove instance alata za grupe.';
$string['cfg_max_queues'] = 'Maksimalan broj istovremenih mesta na listama čekanja, po učesniku';
$string['cfg_max_queues_desc'] = 'Određuje u koliko različitih grupa se korisnik, standardno, može naći na listi čekanja.';
$string['cfg_moodlesync_head'] = 'Ponašanje prilikom sinhronizacije';
$string['cfg_moodlesync_head_info'] = 'Kako bi alati za grupe trebalo da se ponašaju ako se članovi Moodle grupe dodaju/obrišu ili ako se obrišu pojedinačne grupe';
$string['cfg_name_scheme'] = 'Standardni nazivi shema';
$string['cfg_name_scheme_desc'] = 'Standardni nazivi shema koji se koriste za kreiranje grupe';
$string['cfg_show_add_info'] = 'Prikažite dodatne informacije o grupi prilikom samostalnog prijavljivanja';
$string['cfg_show_add_info_desc'] = 'Prikažite dodatne informacije o Moodle grupi kao što su opisi ili slike na kartici za prijavu';
$string['cfg_show_members'] = 'Prikaži članove grupe';
$string['cfg_show_members_desc'] = 'Određuje da li članovi grupe, standardno, treba da budu vidljivi';
$string['cfg_use_individual'] = 'Koristite individualnu veličinu';
$string['cfg_use_individual_desc'] = 'Da li, standardno, treba koristiti veličinu individualne grupe za svaku grupu';
$string['cfg_use_queue'] = 'Koristite liste čekanja';
$string['cfg_use_queue_desc'] = 'Da li, standardno, treba koristiti liste čekanja za upis u grupe koje su popunjene';
$string['cfg_use_size'] = 'Koristite veličinu grupe';
$string['cfg_use_size_desc'] = 'Da li veličina grupe treba, standardno, da bude ograničena';
$string['cfg_users_queues_limit'] = 'Broj mesta na listi čekanje po korisniku';
$string['cfg_users_queues_limit_desc'] = 'Određuje u koliko različitih grupa se korisnik, standardno, može naći na listi čekanja.';
$string['change_group'] = 'Promeni grupu';
$string['change_group_to'] = 'Da li želite da nastavite sa promenom grupe u <strong>{$a->groupname}</strong>?';
$string['change_group_to_success'] = 'Promena grupe je uspela! Korisnik <strong>{$a->username}</strong> sada je prebačen u grupu <strong>{$a->groupname}</strong>!';
$string['changes_saved'] = 'Promene su sačuvane';
$string['checkbox_control_header'] = 'Poništite izbor/izaberite grupe i grupisanja';
$string['checkbox_control_header_help'] = '<p>Korišćenjem ove funkcije možete aktivirati/deaktivirati grupe jednog ili više grupisanja unutar vašeg alata za grupe:<ol><li>U polju za višestruki izbor možete izabrati "Sve" (sve dostupne grupe biće aktivirane/deaktivirane), jedno grupisanje ili više grupisanja (prelaskom na izbor biše stavki tako što ćete upotrebiti ikonicu pored i kombinaciju tastera Ctrl + Click).</li><li>Koristite jednu od sledećih opcija "Izaberite/ Poništite izbor/ Invertujte izbor":<ul><li><b> Izaberite:</b> Grupe unutar izabranih grupisanja biće aktivirane.</li><li><b>Поништите избор:</b> Grupe unutar izabranih grupisanja biće deaktivirane.</li>
<li><b>Инвертујте избор:</b> Sve grupe unutar neizabranih grupisanja biće aktivirane. </li> </ul></li><li>Potvrdite svoj izbor klikom na dugme " Nastavi ".</li></ol></p>';
$string['choose'] = 'Izaberite...';
$string['choose_group'] = 'Morate izabrati ciljnu grupu!';
$string['choose_max'] = 'Maksimalan broj grupa koje možete da birate';
$string['choose_max_text'] = 'Broj grupa koji možete da birate: {$a}</strong>!';
$string['choose_min'] = 'Minimalan broj grupa koje možete da birate';
$string['choose_min_max_text'] = 'Morate da izaberete između <strong>{$a->min}</strong> i <strong>{$a->max}</strong> grupe/a!';
$string['choose_min_text'] = 'Minimalan broj grupa koji morate da izaberete: <strong>{$a}</strong>';
$string['choose_minmax_title'] = 'Grupe koje treba izabrati';
$string['choose_targetgroup_import'] = 'Uvezite u grupu(e)';
$string['choose_targetgroup_unregister'] = 'Odjavi se iz grupe(a)';
$string['chooseactivity'] = 'Morate da izaberete aktivnost pre nego što podaci budu prikazani!';
$string['completiondetail:register'] = 'Prijavite se u grupe: {$a}';
$string['completionregister'] = 'Polaznik mora biti prijavljen u grupe:';
$string['condition_prevent_access'] = 'Trenutni uslovi vas sprečavaju da pristupite instanci alata za grupe!';
$string['confirm_delete'] = 'Upravo ćete potpuno obrisati grupu. Ovo će nepovratno ukloniti sve članove iz ove grupe. Da li ste SIGURNI da želite da nastavite?';
$string['confirm_delete_title'] = 'Da li zaista želite da obrišete ovaj element?';
$string['copied_grade_feedback'] = 'Grupno ocenjivanje<br />
+Predao: polaznik <strong>{$a->student}</strong><br />
+Ocenio: predavač <strong>{$a->teacher}</strong><br />
+Datum/vreme: <strong>{$a->date}</strong><br />
+Povratne informacije: <strong>{$a->feedback}</strong>';
$string['copy'] = 'Kopiraj';
$string['copy_chosen'] = 'Kopiraj izabrano';
$string['copy_grade_confirm'] = 'Nastaviti sa kopiranjem ove ocene?';
$string['copy_grade_overwrite_confirm'] = 'Nastaviti sa kopiranjem ove ocene? Postojeće prethodne ocene će biti zamenjene!';
$string['copy_grades_confirm'] = 'Nastaviti sa kopiranjem ovih ocena?';
$string['copy_grades_errors'] = 'Došlo je do najmanje 1 greške prilikom kopiranja ocena:';
$string['copy_grades_overwrite_confirm'] = 'Nastaviti sa kopiranjem ovih ocena? Postojeće prethodne ocene će biti zamenjene!';
$string['copy_grades_success'] = 'Sledeće ocene su uspešno ažurirane:';
$string['copy_refgrades_feedback'] = 'Kopirajte referentne ocene i povratne informacije za izabrane grupe drugih članova grupe';
$string['copygrade'] = 'Kopiraj ocenu';
$string['could_not_add'] = 'Nije moguće dodati korisnika <strong>{$a->username}</strong> u grupu <strong>{$a->groupname}</strong>';
$string['couldnt_move_down'] = 'Nije moguće pomeriti grupu nadole!';
$string['couldnt_move_up'] = 'Nije moguće pomeriti grupu nagore!';
$string['createGroups'] = 'Kreirajte grupe';
$string['create_1_person_groups'] = 'Kreirajte grupe sa 1 osobom';
$string['create_1_person_groups_help'] = 'Kreirajte grupe sa jednom osobom - ovde se kreira grupa za svakog izabranog korisnika. Pored oznaka # i @ možete koristiti sledeće oznake koje će biti zamenjene korisničkim podacima:<ul><li>[username] - korisničko ime korisnika</li><li>[firstname] - ime korisnika</li><li>[lastname] - prezime korisnika</li><li>[idnumber] - ID broj korisnika</li></ul>Ako neki podaci nedostaju, oznaka će biti zamenjena sa tagnameXX gde XX predstavlja broj grupe.';
$string['create_assign_groupings'] = 'Kreirajte /dodelite grupisanje';
$string['create_fromto_groups'] = 'Kreirajte grupe sa brojevima iz intervala (tj. od 34 do 89), <strong>bez automatske raspodele</strong> članova grupe';
$string['create_fromto_groups_help'] = 'Kreirajte grupe sa brojevima iz intervala (tj. od 34 do 89) - koristite ovaj režim za kreiranje (nedostajućih) grupa (tj. Grupa 4, Grupa 5, Grupa 6). Samo unesite ograničenja i koliko cifara želite da koristite, barem za nazive grupa (tj. 1, 01, 001, 0001...). Moguće je definisati određenu veličinu grupe pomoću opcije ”Broj članova grupe M”. Neće biti <strong>automatske raspodele</strong> članova grupe.';
$string['create_groupings_confirm'] = 'Želite li da nastavite da kreirate grupisanje kao što je prethodno prikazano?';
$string['create_groupings_confirm_problem'] = 'Došlo je do najmanje 1 greške (pogledajte gore prikazan pregled)!';
$string['create_groups_confirm'] = 'Želite li da nastavite da kreirate grupe kao što je prethodno prikazano?';
$string['create_groups_confirm_problem'] = 'Prilikom pokušaja kreiranja novih grupa na osnovu sheme datog nazive došlo je do konflikta - pogledajte pregled - Moodle grupe moraju imati jedinstvene nazive. Konflikt može biti zbog postojećih grupa sa istim nazivom ili greške u sintaksi u šemi za davanje naziva grupama (... npr. prazno , nedostaje simbol #).';
$string['create_n_m_groups'] = 'Kreirajte N grupa za M članova, <strong>bez automatskog dodeljivanja</strong> članova grupe';
$string['create_n_m_groups_help'] = 'Kreirajte N grupa za M članova - kreirajte pomoću ovog metoda određeni broj grupa (N grupa) sa određenom veličinom grupe (M članova), npr. sedam grupa sa po tri člana u svakoj. Neće biti <strong>automatske raspodele</strong> članova grupe.';
$string['createinsertgrouping'] = 'Dodaj u grupisanje';
$string['deactivated_group'] = 'Deaktivirana grupa';
$string['deactivated_groups'] = 'Deaktivirane grupe!';
$string['define_amount_groups'] = 'Definišite broj grupa N';
$string['define_amount_groups_help'] = 'Definišite broj grupa N - birate korisnike, sa odgovarajućom ulogom, koje želite da koristite za kreiranje grupe i unosite željeni broj grupa u tekstualno polje Broj grupa N. U polje \'Shema naziva\' možete uneti shemu naziva za grupe koristeći simbole:<ul><li># (biće zamenjen brojem grupe) i</li><li>@ (biće zamenjen slovnim prikazom broja grupe)</li></ul>Zatim se izabrani korisnici raspoređuju u željeni broj grupa.';
$string['define_amount_members'] = 'Definišite broj članova grupe  M';
$string['define_amount_members_help'] = 'Definišite broj članova grupe M - Ovde alatu za grupe dajete informaciju koliko članova bi svaka grupa, idealno, trebalo da ima. Potreban broj grupa će automatski biti izračunat. Ukoliko označite da želite da sprečite da poslednju grupa bude sa premalo korisnika, onda će korisnici iz ove grupi biti preraspoređeni na ostale grupe, ukoliko njena popunjenost ispod 70%.';
$string['delete_reference'] = 'Obriši iz alata za grupe';
$string['description'] = 'Opis';
$string['deselect'] = 'Poništite izbo';
$string['determinismerror'] = 'Datum završetka prijavljivanja ne može biti pre datuma početka prijavljivanja u grupe, ili u prošlosti.';
$string['digits'] = 'Minimalan broj cifara';
$string['disabled'] = 'Onemogućeno';
$string['drag'] = 'Premesti';
$string['due'] = 'Alat za grupe - krajnji rok';
$string['duedate'] = 'Završetak privljivanja';
$string['duedate_help'] = 'Završetak perioda prijavljivanja u grupe. Nakon ovog datuma polaznici nisu više u mogućnosti da se prijave u grupe i predavač dobija pristup funkciji razrešavanja lista čekanja za upis u grupe.';
$string['duedateno'] = 'Bez krajnjeg roka';
$string['error_activating_group'] = 'Greška prilikom aktiviranja grupe <strong>{$a->groupid}</strong> u alatu za grupe <strong>{$a->grouptoolid}</strong>!';
$string['error_at'] = 'Greška u';
$string['error_deactivating_group'] = 'Greška priliko deaktiviranja grupe <strong>{$a->groupid}</strong> u alatu za grupe <strong>{$a->grouptoolid}</strong>!';
$string['error_getting_data'] = 'Greška pri preuzimanju podataka o grupi! Podatke nije poslala nijedna grupa ili su dobijeni podaci za više grupa!';
$string['error_saving_new_order'] = 'Greška prilikom pokušaja da se sačuva novi redosled нови редослед za grupe: <strong>{$a}</strong>';
$string['eventagrpcreated'] = 'Aktivna grupa je kreirana';
$string['eventagrpdeleted'] = 'Aktivna grupa je ozbrisana';
$string['eventagrpsupdated'] = 'Aktivne grupe su ažurirane';
$string['eventdequeuingstarted'] = 'Počelo je uklanjanje polaznika sa liste čekanja';
$string['eventgroupcreationstarted'] = 'Kreiranje grupe je započeto';
$string['eventgroupgraded'] = 'Grupa je ocenjena';
$string['eventgroupingscreated'] = 'Kreirana su grupisanja';
$string['eventgrouprecreated'] = 'Grupa je iznova kreirana';
$string['eventoverviewexported'] = 'Pregled izvezenog spiska korisnika';
$string['eventqueueentrycreated'] = 'Zapis na listi čekanja je kreiran';
$string['eventqueueentrydeleted'] = 'Zapis na listi čekanja je obrisan';
$string['eventregistrationcreated'] = 'Prijava je kreirana';
$string['eventregistrationdeleted'] = 'Prijava je obrisana';
$string['eventregistrationpushstarted'] = 'Počela je prijava';
$string['eventuserimported'] = 'Korisnik je uvezen';
$string['eventuserlistexported'] = 'Izvezen spisak korisnika';
$string['eventusermoved'] = 'Korisnik je premešten';
$string['exceedgroupqueuelimit'] = 'Prekoračenje dozvoljenog broja mesta na listi čekanja za upis u grupu';
$string['exceedgroupsize'] = 'Prekoračenje veličine grupe!';
$string['exceeduserqueuelimit'] = 'Prekoračenje broja korisnika na listi čekanja';
$string['exceeduserreglimit'] = 'Prekoračenje broja korisnika prijavljenih za grupu';
$string['feedbackplural'] = 'Povratne informacije';
$string['filters_legend'] = 'Filtrirajte podatke';
$string['filterunoccupied'] = 'Prikaži samo grupe sa slobodnim mestima';
$string['followchanges'] = 'Pratite promene';
$string['forceregistration'] = 'Obavezna prijava pomoću alata za grupe';
$string['forceregistration_help'] = 'Imajte na umu da se grupe unutar alata za grupe fundamentalno razlikuju od standardnih grupa na Moodle kursu. Označite polje za potvrdu ako želite da uvezete korisnike u grupu alata za grupe kao i u standardnu Moodle grupu.';
$string['found_multiple'] = 'Nije moguće identifikovati jedinstvenog korisnika, pronađeno je više korisnika:';
$string['free'] = 'Slobodnih mesta';
$string['fromgttoerror'] = 'Vrednost \'do\' mora biti veća ili jednaka vrednosti \'od\'';
$string['fullgroup'] = 'Grupa je puna';
$string['general_information'] = 'Opšte informacije';
$string['general_registration_exception'] = 'Prilikom prijave u grupu došlo je do opšteg izuzetka i nije moguće automatski utvrditi zbog čega!';
$string['global_userstats'] = '<strong>{$a->reg_users}</strong> od ukupno <strong>{$a->users}</strong> korisnika je prijavljeno u grupe. Bez prijave je još uvek <strong>{$a->notreg_users}</strong> korisnik/a.';
$string['grading'] = 'Ocenjivanje';
$string['grading_activity_title'] = 'Aktivnost';
$string['grading_alt'] = 'Alati za kopiranje ocena jednog člana grupe na sve ostale u grupi, bilo za jednu grupu ili za skup grupa.';
$string['grading_filter_select_title'] = 'Grupa ili grupe';
$string['grading_filter_select_title_help'] = 'Izaberite koju grupu ili grupe želite da koristite:<ul><li>Bez konflikata - sve grupe, u kojima je samo 1 član grupe dobio ocenu za za izabranu aktivnost</li><li>Sve - sve grupe</li><li>"Naziv grupe" - samo posebno odabrana grupa</li></ul>';
$string['grading_grouping_select_title'] = 'Filtiranje grupisanja';
$string['group_administration'] = 'Administracija grupa';
$string['group_administration_alt'] = 'Administracija (aktivnih) grupa i grupisanja';
$string['group_assign_error'] = 'Nije moguće dodeliti grupu!';
$string['group_assign_error_prev'] = 'Nije moguće dodeliti grupu!';
$string['group_creation'] = 'Kreirajte grupe';
$string['group_creation_alt'] = 'Kreirajte grupe';
$string['group_creation_failed'] = 'Kreiranje grupa nije uspelo!';
$string['group_creation_success'] = 'Uspešno kreirane grupe!';
$string['group_not_found'] = 'Grupa <strong>{$a->groupid}</strong> nije pronađena u alatu za grupe <strong>{$a->grouptoolid}</strong>!';
$string['group_not_in_grouping'] = 'Izabrana grupa nije član odabranog grupisanja!';
$string['group_or_member_count'] = 'Broj grupa/članova';
$string['group_places'] = 'Broj mesta u grupi';
$string['group_places_help'] = 'Polje \'broj mesta u grupi\' daje informacije (razdvojeno obrnutom kosom crtom) prvo o ukupnom broju mesta u grupi, zatim o broju slobodnih mesta i treće o broju mesta u grupi koja su već zauzeta.';
$string['groupchange_from_non_unique_reg'] = 'Nije moguće promeniti grupu jer prethodna grupa nije jedinstvena!';
$string['groupcreation'] = 'Kreiranje grupe';
$string['groupcreationmode'] = 'Režim';
$string['groupfromtodigits'] = 'Od, do &amp; cifre u nazivima grupa:';
$string['groupinfo'] = 'Informacije o grupi';
$string['grouping_assign_error'] = 'Nije moguće uspešno dodeliti grupisanje:';
$string['grouping_assign_error_prev'] = 'Ne može uspešno biti dodeljeno grupisanju:';
$string['grouping_assign_success'] = 'Uspešno su dodeljeni grupisanju:';
$string['grouping_assign_success_prev'] = 'Može se uspešno dodeliti:';
$string['grouping_creation_error'] = 'Nije moguće kreirati grupisanje!';
$string['grouping_creation_error_prev'] = 'Nije moguće kreirati grupisanje!';
$string['grouping_creation_only_success'] = 'Grupisanje je uspešno kreirano!';
$string['grouping_creation_only_success_prev'] = 'Grupisanje se može uspešno kreirati!';
$string['grouping_creation_success'] = 'Uspešno je kreirano grupisanje i njemu dodeljena grupa <strong>{$a}</strong>';
$string['grouping_creation_success_prev'] = 'Može uspešno da se kreira grupisanje i njemu dodeli grupа <strong>{$a}</strong>';
$string['grouping_exists_error'] = 'Nije bilo moguće kreirati grupisanje jer već postoji grupisanje sa ovim nazivom!';
$string['grouping_exists_error_prev'] = 'Nije moguće kreirati grupisanje jer već postoji grupisanje sa ovim nazivom!';
$string['groupings_created_and_groups_added'] = 'Grupisanje je kreirano i/ili grupe dodate!';
$string['groupingscreation'] = 'Kreirajte i dodelite grupisanja';
$string['groupingselect'] = 'Grupisanja za izabrane grupe';
$string['groupingselect_help'] = 'Kreirajte grupisanje za izabrane grupe:<ul>
<li>Kreirajte JEDNO grupisanje za sve izabrane grupe. Naziv grupisanja se može slobodno birati.</li>
<li>Kreirajte grupisanje za SVAKU izabranu grupu. Grupisanje će biti nazvano prema odgovarajućoj grupi.</li>
<li>Dodajte izabrane grupe u postojeće grupisanje</li></ul>';
$string['groupnamelength'] = 'Naziv grupe je predugačak!';
$string['groupoverview'] = 'Pregled grupe';
$string['groups_created'] = 'Grupe su uspešno kreirane!';
$string['groups_queues_limit'] = 'Broj mesta na listi čekanja po grupi';
$string['groups_queues_limit_help'] = 'Ograničava broj dostupnih mesta na listi čekanja po grupi, ako je grupa aktivirana';
$string['groupselection'] = 'Izbor grupe';
$string['groupselection_help'] = 'Izaberite grupe/osobe za koje želite da kopirate izabranu referentnu ocenu i povratnu informaciju tako što ćete aktivirati odgovarajuća polja za potvrdu. Ako je prikazana samo 1 grupa, birate izvor za kopiranje izabrane ocene koristeći odgovarajuće dugme desno od unosa.';
$string['groupsize'] = 'Veličina grupe';
$string['groupsize_gets_enabled'] = 'Ako nastavite, veličina grupe biće automatski omogućena. Sprečite ovo ponašanje korišćenjem 0 kao <strong>{$a->field}</strong>';
$string['groupsize_individual_gets_enabled'] = 'Ako nastavite, individualna veličina grupa biće automatski omogućena. Sprečite ovo ponašanje korišćenjem 0 kao <strong>{$a->field}</strong> kako ne biste uopšte koristili veličinu grupe ili upotrebite <strong>{$a->globalsize}</strong> kako biste omogućili samo globalnu veličinu grupa!';
$string['groupstatus'] = 'Status';
$string['groupstatus_help'] = 'Trenutni status grupe je vizuelizovan bojom:<ul><li>Zeleno - aktivna grupa. Grupa je dodeljena ovom alatu za grupe. Ako je samostalna prijava aktivna, polaznici mogu da se prijave u ovu grupu.</li><li>Sivo - neaktivna grupa. Grupa nije dostupna u ovom alatu za grupe.</li></ul>Klikom na simbol statusa, isti se može promeniti.';
$string['grouptool'] = 'Alat za grupe';
$string['grouptool:addinstance'] = 'Dodavanje instance Alata za grupe na kurs';
$string['grouptool:administrate_deregistration'] = 'Administriranje odjave';
$string['grouptool:administrate_groups'] = 'Administracija (aktivnih) grupa i grupisanja';
$string['grouptool:administrate_registration'] = 'Administriranje prijave';
$string['grouptool:create_groupings'] = 'Kreiranje grupisanja pomoću alata za grupe.';
$string['grouptool:create_groups'] = 'Kreiranje grupa pomoću alata za grupe.';
$string['grouptool:export'] = 'Izvezite podatke o grupama i prijavama u različite formate';
$string['grouptool:grade'] = 'Kopirajte ocene člana grupe ostalim članovima grupe';
$string['grouptool:grade_own_group'] = 'Kopirajte ocene člana grupe ostalim članovima grupe ako sam ja dao originalnu ocenu';
$string['grouptool:move_students'] = 'Premesti polaznike u druge grupe.';
$string['grouptool:preview'] = 'Prikaži pregled prijava';
$string['grouptool:register'] = 'Prijavite se u aktivu grupu pomoću alata za grupu';
$string['grouptool:register_students'] = 'Prijavite polaznike u aktivnu grupu koristeći alat za grupu. (Takođe se koristi za rešavanje lista čekanja)';
$string['grouptool:unregister_students'] = 'Odjavljivanje polaznika iz grupa pomoću alata za grupe.';
$string['grouptool:view'] = 'Prikaz alata za grupe';
$string['grouptool:view_description'] = 'Prikaz opisa alata za grupe';
$string['grouptool:view_groups'] = 'Prikaz aktivnih grupa';
$string['grouptool:view_own_registration'] = 'Prikaz sopstvenih prijava';
$string['grouptool:view_registrations'] = 'Pogledajte ko je prijavljen / na listi čekanja, i u kojoj aktivnoj grupi pomoću alat za grupe';
$string['grouptool:view_regs_course_overview'] = 'Prikaz spiska korisnika koja sadrži imena onih koji su prijavljeni / na listi čekanja u kojoj aktivnoj grupi, pomoću alata za grupe.';
$string['grouptool:view_regs_course_view'] = 'Prikaz spiska korisnika koja sadrži imena onih koji su prijavljeni / na listi čekanja, i u kojoj aktivnoj grupi, pomoću alata za grupe.';
$string['grouptool:view_regs_group_overview'] = 'Prikaz grupisanog spiska koja sadrži imena onih koji su prijavljeni / na listi čekanja, i u kojoj aktivnoj grupi pomoću alat za grupe.';
$string['grouptool:view_regs_group_view'] = 'Prikaz grupisanog spiska koja sadrži imena onih koji su prijavljeni / na listi čekanja, i u kojoj aktivnoj grupi, pomoću alat za grupe.';
$string['grouptoolfieldset'] = 'Podešavanje instance';
$string['grouptoolname'] = 'Naziv alata za grupe';
$string['grouptoolname_help'] = 'Naziv instance alata za grupe';
$string['groupuser_import'] = 'Uvezite korisnike grupe';
$string['groupuser_unregister'] = 'Odjavite korisnike grupe';
$string['grp_marked'] = 'Označeno za prijavljivanje';
$string['grpsizezeroerror'] = 'Veličina grupe mora biti veća ili jednaka 1. Slova ili drugi znaci nisu dozvoljeni.';
$string['ifgroupdeleted'] = 'Ako se grupe obrišu';
$string['ifgroupdeleted_help'] = 'Da li obrisane grupe treba ponovo da se kreiraju za instancu alata za grupe, odnosno da li treba da se obrišu reference u alatu za grupu (dodatni podaci o grupi, prijave i lista čekanja)? Napomena: Ako izaberete"kreiraj grupu ponovo“, grupe će automatski biti ponovo kreirane nakon brisanja pod "Administracija kursa / Korisnici / Grupe".';
$string['ifmemberadded'] = 'Ako se članovi grupe budu dodati';
$string['ifmemberadded_help'] = 'Da li novi članovi grupe koji su dodati preko Moodlea, takođe treba da budu prijavljeni u alatu za grupe ili ih treba ignorisati?';
$string['ifmemberremoved'] = 'Ako članovi grupe budu uklonjeni';
$string['ifmemberremoved_help'] = 'Da li bi prijave pomoću alata za grupe trebalo da budu obrisane ako su korisnici obrisani iz odgovarajuće Moodle grupe';
$string['ignorechanges'] = 'Ignorišite promene';
$string['ignored_not_found_users'] = 'Nije moguće dodati najmanje jednog korisnika u grupu!';
$string['ignored_not_found_users_unregister'] = 'Najmanje jedan korisnik nije pronađen!';
$string['ignoring_not_found_users'] = 'Najmanje jedan korisnik nije pronađen u bazi podataka. Svi takvi korisnici će biti ignorisani!';
$string['immediate_reg'] = 'Neposredna prijava';
$string['immediate_reg_help'] = 'Ako je omogućeno, prijave/odjave će biti prosleđene Moodle-sistemu. Ako nije omogućeno, prijave se keširaju u alatu za grupe i predavač ih može proslediti Moodle sistemu.';
$string['import'] = 'Uvoz';
$string['import_conflict_user_queued'] = 'Korisnik <strong>{$a->fullname}</strong> se već nalazi na listi čekanja za upis u grupu <strong>{$a->groupname}</strong>!';
$string['import_desc'] = 'Uvezite korisnike u odgovrajuće grupe pomoću spiska ID brojeva';
$string['import_in_inactive_group_rejected'] = 'Prijava za grupu <strong>{$a}</strong> pomoću alata za grupe je odbijena usled njene neaktivnosti. Aktivirajte grupu u ovom alatu za grupu kako biste omogućili prijavu.';
$string['import_in_inactive_group_warning'] = 'Napomena: grupa <strong>{$a}</strong> je trenutno neaktivna u kontekstu alata za grupe i stoga neće biti prikazana.';
$string['import_progress_completed'] = 'Uvoz je završen';
$string['import_progress_import'] = 'Uvezi korisnika';
$string['import_progress_preview_completed'] = 'Pregled uvoza je završen';
$string['import_progress_search'] = 'Pretražite korisnike';
$string['import_progress_start'] = 'Započnite uvoz';
$string['import_skipped'] = 'Preskočen korisnik <strong>{$a->fullname}</strong> za grupu <strong>{$a->groupname}</strong>!';
$string['import_user'] = 'Uvoz korisnika <strong>{$a->fullname}</strong> (<strong>{$a->idnumber}</strong>) u grupu <strong>{$a->groupname}</strong> je uspeo.';
$string['import_user_prev'] = 'Uvoz korisnika <strong>{$a->fullname}</strong> (<strong>{$a->idnumber}</strong>) u grupu <strong>{$a->groupname}</strong>.';
$string['import_user_problem'] = 'Problem tokom uvoza korisnika <strong>{$a->fullname}</strong> (<strong>{$a->idnumber}</strong> - <strong>{$a->id}</strong>) u grupu <strong>{$a->groupname}</strong>.';
$string['importbutton'] = 'Uvezite korisnike';
$string['inactive'] = 'Neaktivna grupa';
$string['inactivegroups'] = 'Neaktivne grupe';
$string['inactivegroups_hide'] = 'Sakrij neaktivne grupe';
$string['inactivegroups_show'] = 'Prikaži neaktivne grupe';
$string['includedeleted'] = 'Uključi obrisane korisnike';
$string['includedeleted_help'] = 'Ako je označeno, obrisani korisnici neće biti filtrirani na spisku. Obrisani nalozi tj. korisnici ne mogu biti upisani na kurs tokom uvoza.';
$string['includeonlyactiveenrol'] = 'Uključi samo aktivne polaznike';
$string['includeonlyactiveenrol_help'] = 'Ako je ova opcija omogućena, suspendovani korisnici neće biti uključeni u grupe.';
$string['incomplete_only_label'] = 'Prikažite samo grupe kojima nedostaju ocene';
$string['incorrect_tab'] = 'Pogrešna kartica, ova kartica nije dostupna!';
$string['individual_size_info'] = 'Veličina grupe u podešavanjima alata za grupe';
$string['intro'] = 'Opis';
$string['invert'] = 'Invertujte izbor';
$string['landscape'] = 'Horizontalno';
$string['limit'] = 'limit';
$string['loading'] = 'učitavanje...';
$string['manage_members'] = 'Upravljanje korisnicima';
$string['max_queues_reached'] = 'Dostignut je maksimalni broj mesta na listi čekanja!';
$string['max_regs_reached'] = 'Dostignut maksimalan broj prijavljenih!';
$string['maxmembers'] = 'Globalna veličina grupe';
$string['messageprovider:grouptool_moveupreg'] = 'Prijava korisnika sa liste čekanja za upis u grupu';
$string['missing_source_selection'] = 'Nije izabran izvor!';
$string['modulename'] = 'Alat za grupe';
$string['modulename_help'] = 'Modul ”Alat za grupe” služi za različite zadatke koji su vezani za grupe:<ul><li>modul omogućava kreiranje grupa u različitim režimima (broj grupa/članova grupe, grupe sa jednom osobom, interval grupa), kao i grupisanja za svaku grupu;</li><li>štaviše, može se koristiti kako bi se polaznicima pružila mogućnost da se prijave u određene grupe tokom definisanog vremenskog perioda;</li><li>modul, takođe, ima mogućnost grupnog ocenjivanja - tj. kopiranja ocena aktivnosti sa jednog na ostale članove grupe;</li><li>увоз корисника у групе путем списка ID бројева;</li><li>pregled svih grupa na kursu uključujući sve prijave, članove, liste čekanja za upis itd., kao i mogućnost izvoza ovih podataka u datoteke u različitim formatima (PDF/XLSX/ODS/TXT);</li><li>spisak svih korisnika na kursu (koji se može eksportovati), uključujući njihove prijave, liste čekanja za upis itd.</li></ul><p>(!) Imajte na umu da se grupe unutar alata za grupe fundamentalno razlikuju od standardnih grupa na Moodle kursu. Kako biste osigurali konzistentnost između različitih tipova grupa, podesite parametre u sekciji "Ponašanje prilikom promena u Moodleu” na ”pratiti promene”.</p><p><a href="https://academic-moodle-cooperation.org/anleitungen/gruppenverwaltung-selbstanmeldung-zu-gruppen-einrichten/?lng=en" target="_blank">Alat za grupe: podesite samostalnu prijavu i grupe</a></p> <p><a href="https://academic-moodle-cooperation.org/anleitungen/gruppenverwaltung-gruppenadministration/?lng=en" target="_blank">Grupni alat: Administracija grupe</a></p><p><a href="https://academic-moodle-cooperation.org/anleitungen/gruppenverwaltung-wartelisten-und-mehrfache-anmeldungen/?lng=en" target="_blank"> Alat za grupe: liste čekanja i višestruke prijave</a></p><p><a href="https://academic-moodle-cooperation.org/anleitungen/gruppenverwaltung-import-und-austragen-von-vielen-studierenden/?lng=en" target="_blank">Alat za grupe: uvoz i odjava više studenata</a></p>';
$string['modulenameplural'] = 'Alati za grupe';
$string['moodlesync'] = 'Ponašanje prilikom promena u Moodleu';
$string['moodlesync_help'] = 'Kako bi alati za grupe trebalo da se ponašaju ako se članovi Moodle grupa dodaju/obrišu ili ako se obrišu pojedinačne grupe';
$string['moreregsthanpossible'] = 'Broj prijava koji je potreban za završetak aktivnosti, ne može biti veći od maksimalno dozvoljenog broja prijava';
$string['move'] = 'Premesti';
$string['move_help'] = '[Nedostaje tekst jezičkog stringa]';
$string['move_user'] = 'Premestite korisnika sa liste čekanja u grupu';
$string['movedown'] = 'Pomeri 1 mesto nadole';
$string['moveup'] = 'Pomeri 1 mesto nagore';
$string['multiple'] = 'Upravljanje korisnicima grupe';
$string['multiple_desc'] = 'Višestruke prijave/odjave';
$string['must_specify_groupingname'] = 'Morate da navedete naziv za grupisanje!';
$string['mustbegt0'] = 'Minimalan broj grupa koje možete da birate mora biti veći ili jednak 1. Slova ili drugi znaci nisu dozvoljeni.';
$string['mustbegtoeqmin'] = 'Mora biti veći ili jednak minimumu';
$string['mustbeposint'] = 'Maksimalan broj grupa koje možete da birate mora biti veći ili jednak 1. Slova ili drugi znaci nisu dozvoljeni.';
$string['mygroups_only_label'] = 'Prikaži samo izvore koje sam ocenio';
$string['myoverview_registrations_missing'] = 'Nedostaju prijave';
$string['name_scheme_tags'] = '<span class="tag firstname">[firstname]</span><span class="tag lastname">[lastname]</span><span class="tag idnumber">[idnumber]</span><span class="tag username">[username]</span><span class="tag alpha">@</span><span class="tag number">#</span>';
$string['nameschemenotunique'] = 'Nazivi grupa iz ove šeme naziva nisu jedinstveni (<strong>{$a}</strong>). Izaberite drugi naziv ili koristite znak # (numerički indeks) odnosno @ (abecedni indeks) kako biste kreirali jedinstvene nazive grupa.';
$string['namingscheme'] = 'Shema naziva grupe';
$string['namingscheme_help'] = '<p>Shema naziva grupa definieš kako će grupe biti nazvane automatski kada se dodaju nove grupe.</p><p>Molimo vas, imajte na umu sledeće:<br /><ol><li>Naziv grupe mora da bude jedinstven unutar vašeg kursa. </li><li>Ukoliko želite da kreirate više grupa odjednom, morate da koristite oznake kako biste kreirali jedinstvena imena. </li></ol></p><p>Svaka od ovih oznaka biće zamenjena u konačnim nazivima grupa. Oznake u uglastim zagradama ( [ ] ) tiču se podataka o korisniku, dok će simboli # i @ biti zamenjeni serijskim brojem grupe. Ako je JavaScript omogućen možete jednostavno da kliknete na oznake kako biste ih dodali shemi naziva. Imajte na umu da nazivi grupa moraju biti jedinstveni na svakom kursu i stoga ćete možda morati da menjate shemu naziva sve dok ne bude podesili shemu sa jedinstvenim nazivima.</p>';
$string['no_active_groups'] = 'Nema aktivnih grupa';
$string['no_conflictfree_to_display'] = 'Nema grupa sa jedinstvenim nazivom koje mogu da budu prikazane. Umesto toga pokušavamo da prikažemo sve grupe!';
$string['no_data_to_display'] = 'Nema podataka o grupi/ama za prikaz!';
$string['no_grades_present'] = 'Nema ocena za prikaz';
$string['no_groupmembers_to_display'] = 'Nema članova grupe za prikaz. Zato pokušavamo da umesto toga prikažemo sve grupe!';
$string['no_groups_to_display'] = 'Nema grupa za prikaz';
$string['no_queues_to_resolve'] = 'Nema liste čekanja koju treba razrešiti!';
$string['no_registrations'] = 'Bez prijava';
$string['no_target_selected'] = 'Ne postoji odredište za izabranu operaciju kopiranja. Morate da izaberete najmanje 1 odredište!';
$string['no_users_to_display'] = 'Nema korisnika za prikaz!';
$string['noaccess'] = 'Nemate pristup ovom modulu (možda ne pripadate pravoj grupi?)!';
$string['nobody_queued'] = 'Niko nije bio na listi čekanja';
$string['nodeletion'] = 'Brisanje ove grupe je onemogućeno, jer je bar jedna instanca alata za grupe na ovom kursu podešena tako da ponovo kreira grupu nakon brisanja!';
$string['nogroupingselected'] = 'Nije izabrano nijedno grupisanje!';
$string['nogroups'] = 'Nema grupa na ovom kursu.';
$string['nogroupsactive'] = 'Nema aktivnih grupa u ovom alatu za grupe.';
$string['nogroupschoose'] = 'Izaberite grupe';
$string['nogroupscreate'] = 'Kreirajte grupe';
$string['nogroupscreated'] = 'Nije kreirana nijedna grupa, jer nema korisnika na kursu';
$string['nogroupsgrouping'] = 'Nema grupa u ovomj grupisanju.';
$string['nogroupsinactive'] = 'Nema neaktivnih grupa u ovom alatu za grupe.';
$string['nogrouptools'] = 'Nema alata za grupe!';
$string['nonconflicting'] = 'Bez konflikta';
$string['noregistrationdue'] = 'neograničeno';
$string['nosmallgroups'] = 'Sprečite male grupe';
$string['nosmallgroups_help'] = 'Ako je ova opcija omogućena, onda će barem 70% svake grupa biti popunjeno! Ako bi neka (tačnije, poslednja) grupa bila popunjena manje od 70% korisnici ove grupe biće raspoređeni u druge grupe, što će za posledicu imati da te grupe imaju više članova nego što je navedeno!';
$string['not_allowed_to_show_members'] = 'Nemate dozvolu da vidite ove informacije!';
$string['not_graded_by_me'] = 'Ocenio drugi korisnik';
$string['not_in_queue_or_registered'] = 'Korisnik <strong>{$a->username}</strong> nije prijavljen/a niti se nalazi na listi čekanja za upis u grupu <strong>{$a->groupname}</strong>';
$string['not_permitted'] = 'Nije dozvoljeno';
$string['not_registered'] = 'Još niste prijavljeni!';
$string['not_synced_reg_present'] = 'nisu prisutne sinhronizovane prijave';
$string['notenoughregs'] = 'Korisniku je potrebno više prijava!';
$string['nothing_to_push'] = 'Ništa za prosleđivanje!';
$string['notification:group_recreated'] = 'Grupa<a href="{$a->groupurl}" title="{$a->groupname}">{$a->groupname}</a> je ponovo kreirana jer je alat za grupe <a href="{$a->grouptoolurl}" title="{$a->grouptoolname}">{$a->grouptoolname}</a> podešen tako da ponovo kreira obrisane grupe.';
$string['notification:registrations_recreated'] = 'Članovi grupe <a href="{$a->groupurl}" title="{$a->groupname}">{$a->groupname}</a> su ponovo dodati jer je alat za grupe <a href="{$a->grouptoolurl}" title="{$a->grouptoolname}">$a->grouptoolname}</a> podešen tako da ponovo kreira obrisane grupe. Sama grupa je ponovo kreirana od strane druge instance alata za grupe.';
$string['nowhere_queued'] = 'Nije na listi čekanja';
$string['number_of_groups'] = 'Broj grupa N';
$string['number_of_members'] = 'Broj članova grupe M';
$string['number_of_students'] = 'Broj polaznika';
$string['occupied'] = 'Zauzeto';
$string['onenewgrouping'] = 'U JEDNO novo grupisanje';
$string['onenewgroupingpergroup'] = 'Jedno grupisanje PO grupi';
$string['open_group_message'] = 'Otvorite grupne poruke';
$string['orientation'] = 'PDF-orijentacija';
$string['outdated'] = 'zastarelo';
$string['overflowwarning'] = 'Ako nastavite sa uvozom, veličina grupe u instanci <strong>{$a->instancename}</strong> biće premašena!';
$string['overview'] = 'Pregled';
$string['overview_alt'] = 'Pregled grupa i članova grupa';
$string['overview_tab'] = 'Grupe';
$string['overview_tab_alt'] = 'Otvorite karticu za grupe';
$string['overwrite_label'] = 'Zamenite postojeće ocene';
$string['place_allocated_in_group_success'] = 'Grupa <strong>{$a->groupname}</strong> je uspešno obeležena za prijavljivanje';
$string['places'] = 'Mesta';
$string['pluginadministration'] = 'Administracija grupnih alata';
$string['pluginname'] = 'Alat za grupe';
$string['portrait'] = 'Vertikalno';
$string['preview'] = 'Pregled';
$string['privacy:metadata:agrpid'] = 'Identifikator reprezentacije Moodle grupe u alatu za grupe.';
$string['privacy:metadata:enrolexplanation'] = 'Alat za grupe upisuje korisnike koji već nisu upisani na kurs tokom uvoza kako bi mogao da ih doda u grupu(e).';
$string['privacy:metadata:gradesexplanation'] = 'Alat za grupe može da kopira ocene jednog korisnika drugim članovima iste grupe';
$string['privacy:metadata:groupexplanation'] = 'Alat za grupe upravlja članovima Moodle grupa.';
$string['privacy:metadata:messageexplanation'] = 'Alat za grupe šalje poruke korisnicima koji se sa liste čekanja na upis prebacuju među prijavljene korisnike.';
$string['privacy:metadata:mod_grouptool_group_filter'] = 'Za koju grupu filtrirati?';
$string['privacy:metadata:mod_grouptool_mygroups_only'] = 'Treba li uzeti u obzir/prikazati samo sopstvene grupe.';
$string['privacy:metadata:modified_by'] = 'Identifikator korisnika ako ga je neko drugi izmenio.';
$string['privacy:metadata:queued'] = 'Sadrži sve korisnike na listi čekanja.';
$string['privacy:metadata:registered'] = 'Sadrži korisnike prijavljene u grupu i korisnike označene za prijavu.';
$string['privacy:metadata:timestamp'] = 'Datum i vreme kada je zapis poslednji put izmenjen.';
$string['privacy:metadata:userid'] = 'Identifikator korisnika.';
$string['queue'] = 'Lista čekanja';
$string['queue_and_multiple_reg_title'] = 'Liste čekanja i višestruke prijave';
$string['queue_in_group'] = 'Da li želite da nastavite sa stavljanjem korisnika <strong>{$a->username}</strong> na listu čekanja za upis u grupu <strong>{$a->groupname}</strong>?';
$string['queue_in_group_success'] = 'Korisnik <strong>{$a->username}</strong> je uspešno stavljen/a na listu čekanja za upis u grupu <strong>{$a->groupname}</strong>!';
$string['queue_places'] = 'Mesta na listi za čekanje';
$string['queue_you_in_group'] = 'Da li želite da budete stavljeni na listu čekanja za upis u grupu <strong>{$a->groupname}</strong>?';
$string['queue_you_in_group_success'] = 'Uspešno ste dodati na listu čekanja za upis u grupu <strong>{$a->groupname}</strong>!';
$string['queued'] = 'Na listi čekanja';
$string['queued_in_group_info'] = 'Korisnik {$a->username}</strong> je uspešno stavljen na listu čekanja za upis u grupu <strong>{$a->groupname}</strong>';
$string['queued_on_rank'] = 'Na listi čekanja na mestu #{$a}';
$string['queueing_is'] = 'Na listi čekanja je';
$string['queues'] = 'Liste čekanja';
$string['queues_max'] = 'Maksimalan broj istovremenih mesta na listama čekanja, po učesniku';
$string['queuesgrp'] = 'Lista čekanja i maksimalan broj mesta na listi';
$string['queuesgrp_help'] = 'Ako su liste čekanja omogućene, polaznici koji pokušavaju da se prijave u grupu koja je popunjena, ostaju da čekaju dok se neko ne odjavi iz te grupe. Nakon isteka roka predavač ima mogućnost da polaznike premesti u druge grupe, ako se oni i dalje nalaze na listi čekanja, gde se grupe popunjavaju prema trenutnoj poziciji polaznika na listi. Trebalo bi da definišete maksimalan broj grupa u kojima se korisnik može naći na listi čekanja.<br />Ovo podešavanje ograničava maksimalan broj istovremenih upisa na liste čekanja za svaku osobu u ovom alatu za grupu.';
$string['queuesizeerror'] = 'Broj mesta na listi čekanja mora biti celobrojna vrednost veća ili jednaka 0. Slova ili drugi znaci nisu dozvoljeni.';
$string['queuespresent'] = 'Liste čekanja već postoje! Ako nastavite ove liste će biti obrisano. Za nastavak pritisnite ponovo dugme \'Sačuvaj\'!';
$string['queuespresenterror'] = 'Postoje korisnici na listama čekanja. Ne možete deaktivirati liste čekanja dok vidite šta ćete sa tim korisnicima.';
$string['rank'] = 'Rang';
$string['recreate_group'] = 'Ponovo kreirajte grupu';
$string['reference_grade_feedback'] = 'Referentna ocena / Povratne informacije';
$string['refresh_table_button'] = 'Osveži pregled';
$string['reg_in_full_group'] = 'Prijava korisnika <strong>{$a->username}</strong> u grupu <strong>{$a->groupname}</strong> nije moguća jer su sva mesta u grupi popunjena!';
$string['reg_not_open'] = 'Prijava trenutno nije moguća. Možda je rok za prijavu istekao ili uopšte nije dozvoljeno prijavljivanje.';
$string['reg_you_in_full_group'] = 'Prijava u grupu <strong>{$a->groupname}</strong> nije moguća jer su sva mesta u grupi popunjena!';
$string['register'] = 'Prijavite se';
$string['register_in_group'] = 'Da li ste sigurni da želite da prijavite korisnika <strong>{$a->username}</strong> u grupu <strong>{$a->groupname}</strong>?';
$string['register_in_group_success'] = 'Korisnik <strong>{$a->username}</strong> se uspešno prijavio/la u grupu <strong>{$a->groupname}</strong>!';
$string['register_you_in_group'] = 'Da li ste sigurni da želite da se prijavite u grupu <strong>{$a->groupname}</strong>?';
$string['register_you_in_group_success'] = 'Uspešno ste se prijavili u grupu <strong>{$a->groupname}</strong>!';
$string['register_you_in_group_successmail'] = 'Uspešno ste se prijavili u grupu <strong>{$a->groupname}</strong>!';
$string['register_you_in_group_successmailhtml'] = 'Uspešno ste se prijavili u grupu <strong>{$a->groupname}</strong>!';
$string['registered'] = 'Registrovan';
$string['registered_in_group_info'] = 'Korisno {$a->username} je prijavljen u grupu <strong>{$a->groupname}</strong>';
$string['registered_on_rank'] = 'Prijavljen/a. za grupu na mestu #{$a}';
$string['registration_details'] = 'Detaljni podaci o registracji';
$string['registration_missing'] = 'Nedostaje 1 prijava';
$string['registration_period_end'] = 'Kraj prijave za';
$string['registration_period_start'] = 'Početak prijave za';
$string['registrationdue'] = 'Završetak privljivanja';
$string['registrationnotification'] = '{$a->course->shortname} -> {$a->modulenameplural} -> {$a->grouptoolname----------------------------------------------------------{$a->message}----------------------------------------------------------';
$string['registrations'] = 'Grupa-prijave';
$string['registrations_missing'] = 'Broj prijava koje nedostaju: {$a}';
$string['regpresent'] = 'Korisnik je već {$a}';
$string['rename_failed'] = 'Preimenovanje nije uspelo!';
$string['renamed_group'] = 'Preimenovana grupa!';
$string['report'] = 'Izveštaj alata za grupe';
$string['require_registration'] = 'Zahtevaj prijave';
$string['require_registration_help'] = 'Minimalni broj grupa u koje polaznici treba da se prijave kako bi ovu aktivnost označili kao završenu. Mesta na listama čekanja za upis u grupe se, po pravilu, ne uzimaju u obzir. Ako je broj veći od 1, potrebno je aktivirati opciju ”Višestruke prijave”, a opcija ”Maksimalan broj grupa koje možete da birate“ treba da bude veći ili jednak ovoj vrednosti';
$string['reset_agrps'] = 'Resetujte aktivne grupe';
$string['reset_agrps_help'] = 'Resetuje sve grupe na kursu tj. proglašava ih neaktivnim za alat za grupe. Ovo će takođe obrisati sve prijave za upis u grupe kao i liste čekanja za upis u grupe na ovomg kursu!';
$string['reset_queues'] = 'Resetujte liste čekanja';
$string['reset_queues_help'] = 'Liste čekanja se automatski brišu ako se aktivne grupe resetuju.';
$string['reset_registrations'] = 'Resetujte prijave';
$string['reset_registrations_help'] = 'Prijave se automatski brišu ako se aktivne grupe resetuju.';
$string['reset_transparent_unreg'] = 'Odjavite sve odbačene članove grupe';
$string['reset_transparent_unreg_help'] = 'Uklonite sve korisnike iz onih grupa koje je alat za grupe prikazao aktivnim';
$string['resize'] = 'Promenite veličinu grupe';
$string['resized_group'] = 'Promenjena veličina grupe!';
$string['resolve_queue'] = 'Rešite liste čekanja';
$string['resolve_queue_legend'] = 'Rešite liste čekanja';
$string['resolve_queue_title'] = 'Razrešite liste čekanja';
$string['search:activity'] = 'Alat za grupe – informacije o aktivnosti';
$string['select'] = 'Izaberite';
$string['selected'] = 'Izabrano';
$string['selectfromcohort'] = 'Izaberite članove iz kohorte';
$string['selectfromgroup'] = 'Izaberite članove iz grupe';
$string['selectfromgroup_help'] = 'Raspodelite samo članove date grupe u novokreirane grupe';
$string['selectfromgrouping'] = 'Izaberite članove iz grupisanja';
$string['selectfromgrouping_help'] = 'Raspodelite samo članove datog grupisanja u novokreirane grupe';
$string['selectmultiple'] = 'izaberite više';
$string['selectsingle'] = 'izaberite jednu';
$string['selfregistration'] = 'Prijavljivanje';
$string['selfregistration_alt'] = 'Registrujte se u jednu ili više grupa (u zavisnosti od podešavanja)';
$string['setactive'] = 'Aktiviraj';
$string['setinactive'] = 'Deaktiviraj';
$string['settingspage'] = 'Uredite podešavanja grupe';
$string['show_members'] = 'Prikaži članove grupe';
$string['show_members_help'] = 'Omogućava polaznicima da (pod određenim okolnostima) vide ko je već prijavljen u grupu.<br />
<ul>
    <li><strong>Sopstvene grupe - posle roka:</strong> prikazuje samo članove onih grupa u kojima je korisnik član, nakon isteka roka za prijavu</li>
    <li><strong>Sopstvene grupe - nakon prijave:</strong> prikazuje članove onih grupa u kojima je korisnik član, nakon što se on/ona prijavio/la odnosno, nakon što ga/ju je neko drugi prijavio</li>
    <li><strong>Da:</strong> prikazuje sve članove grupa</li>
</ul>';
$string['showafterdue'] = 'Sve grupe - posle roka';
$string['showownafterdue'] = 'Sopstvene grupe - posle roka';
$string['showownafterreg'] = 'Sopstvene grupe - nakon prijave';
$string['size'] = 'Veličina grupe';
$string['size_grp'] = 'Podešavanja veličine grupe';
$string['size_grp_help'] = 'Ako je aktivirana veličina grupe, maksimalni broj članova za svaku grupu se ograničava.';
$string['size_help'] = 'Prikazuje trenutnu veličinu grupe i da li se veličina grupe obrađuje pojedinačno za svaku grupu.';
$string['skip_user_import'] = 'Preskoči uvoz korisnika';
$string['skipped'] = 'Preskočeno';
$string['sortlist_no_data'] = 'U ovom trenutku nema grupa!';
$string['source'] = 'Izvor';
$string['source_missing'] = 'Nema izvora za kopiranje!';
$string['sources_missing'] = 'Postoji najmanje 1 grupa bez izabranog izvora iz kojeg treba kopirati!';
$string['start'] = 'Započni';
$string['status'] = 'Status';
$string['status_help'] = '<ul><li><strong>✔</strong> prijavljen u Moodle-grupu i alatu za grupe</li><li><strong>?</strong> prijavljen u Moodle-grupu ali ne i u alatu za grupe</li><li><strong>+</strong> prijavljen u alatu za grupe ali ne i u Moodle-grupu</li><li><strong>1, 2, 3...</strong> na lisiti čekanja u alatu za grupe</li></ul>';
$string['successfully_deleted_groups'] = 'Grupe su uspešno obrisane!';
$string['swapped_groups'] = 'Zamenjene grupe <strong>{$a->a}</strong> (redosled <strong>{$a->aorder}</strong>) i <strong>{$a->b}</strong> (redosled <strong>{$a->border}</strong>)!';
$string['switched_to_all_groups'] = 'Promenjen grupni filter na sve grupe!';
$string['target'] = 'Odredište';
$string['too_many_queue_places'] = 'Nije moguće dodati korisnika <strong>{$a->username}</strong> na listu čekanja za upis u grupu <strong>{$a->groupname}</strong> zato što je već na listama čekanja za previše grupa!';
$string['too_many_regs'] = 'Korisnik je već prijavljen/na listi čekanja u previše grupa!';
$string['toolessregspresent'] = 'Najmanje 1 korisnik je prijavljen u premalo grupa, stoga minimalni broj grupa koji se može birati mora biti najviše {$a}.';
$string['toomanyregs'] = 'Pažnja: U najmanje jednoj grupi ima više članova nego što je navedeno u podešavanjima za veličinu grupe.<br />Smanjite broj članova u grupama pre nego što promenite veličinu grupe.';
$string['toomanyregspresent'] = 'Najmanje 1 korisnik je prijavljen u previše grupa, stoga maksimalan broj grupa koji se može birati mora biti najmanje {$a}.';
$string['total'] = 'Ukupno';
$string['unqueue'] = 'Uklonite sa liste čekanja';
$string['unqueue_from_group'] = 'Da li želite da nastavite sa uklanjanjem korisnika <strong>{$a->username}</strong> sa liste čekanja na upis u grupu <strong>{$a->groupname}</strong>?';
$string['unqueue_from_group_success'] = 'Korisnik <strong>{$a->username}</strong> je uspešno uklonjen/a sa liste čekanja ѕa upis u grupu <strong>{$a->groupname}</strong>!';
$string['unqueue_you_from_group'] = 'Nastavite uklanjanje korisnika sa liste čekanja za grupu <strong>{$a->groupname}</strong>?';
$string['unqueue_you_from_group_success'] = 'Uspešno ste uklonjeni sa liste čekanja za upis u grupu <strong>{$a->groupname}</strong>!';
$string['unreg'] = 'Odjava';
$string['unreg_from_group'] = 'Nastavite sa odjavom korisnika <strong>{$a->username}</strong> iz grupe <strong>{$a->groupname}</strong>?';
$string['unreg_from_group_success'] = 'Korisnik <strong>{$a->username}</strong> je uspešno odjavljen/a iz grupe <strong>{$a->groupname}</strong>!';
$string['unreg_is'] = 'Odjava';
$string['unreg_not_allowed'] = 'Odjava nije dozvoljena!';
$string['unreg_you_from_group'] = 'Nastavite sa odjavljivanjem iz grupe <strong>{$a->groupname}</strong>?';
$string['unreg_you_from_group_success'] = 'Uspešno ste odjavljeni iz grupe <strong>{$a->groupname}</strong>!';
$string['unregfrommgroups'] = 'Obavezna odjava iz alata za grupe';
$string['unregfrommgroups_help'] = 'Odjavite korisnike ne samo iz alata za grupe, već i iz Moodle grupe.';
$string['unregister'] = 'Odjava';
$string['unregister_conflict_user_not_in_group'] = 'Korisnik <strong>{$a->fullname}</strong> nije u grupi <strong>{$a->groupname}</strong>!';
$string['unregister_desc'] = 'Odjavite više korisnika';
$string['unregister_from_inactive_group_warning'] = 'Napomena: grupa <strong>{$a}</strong> je trenutno neaktivna u kontekstu alata za grupe i stoga neće biti prikazana.';
$string['unregister_in_inactive_group_warning'] = 'Napomena: grupa <strong>{$a}</strong> je trenutno neaktivna u kontekstu alata za grupe i stoga neće biti prikazana.';
$string['unregister_progress_completed'] = 'Odjava je završena';
$string['unregister_progress_preview_completed'] = 'Pregled odjave je završen';
$string['unregister_progress_start'] = 'Započnite odjavu';
$string['unregister_progress_unregister'] = 'Odjavite korisnika';
$string['unregister_skipped'] = 'Preskočen je korisnik <strong>{$a->fullname}</strong> za grupu <strong>{$a->groupname}</strong>!';
$string['unregister_user'] = 'Odjava korisnika <strong>{$a->fullname}</strong> (<strong>{$a->idnumber}</strong>) iz grupe <strong>{$a->groupname}</strong> je uspela.';
$string['unregister_user_from_moodle_group'] = 'Odjava korisnika <strong>{$a->fullname}</strong> (<strong>{$a->idnumber}</strong>) iz Moodle grupe <strong>{$a->groupname}</strong> je uspela.';
$string['unregister_user_not_in_group'] = 'Korisnik <strong>{$a->fullname}</strong> (<strong>{$a->idnumber}</strong>) nije u Moodle grupi <strong>{$a->groupname}</strong>!';
$string['unregister_user_only_in_moodle_group'] = 'Korisnik <strong>{$a->fullname}</strong> je samo u Moodle grupi <strong>{$a->groupname}</strong> ali ne i u grupi alata za grupe!';
$string['unregister_user_prev'] = 'Odjava korisnika <strong>{$a->fullname}</strong> (<strong>{$a->idnumber}</strong>) iz grupe <strong>{$a->groupname}</strong>.';
$string['unregisterbutton'] = 'Odjavite korisnike';
$string['update_grouplist_success'] = 'Uspešno ažurirane aktivne grupe!';
$string['updatemdlgrps'] = 'Prijavite se u Moodle grupe';
$string['uptodate'] = 'ažurno';
$string['use_all_or_chosen'] = 'Koristite sve ili izabrane';
$string['use_all_or_chosen_help'] = 'Izaberite "Sve" kako biste kreirali grupisanje za svaku grupu na kursu. Koristite "Izabrane" kako biste kreirali grupisanja samo za označene grupe.';
$string['use_individual'] = 'Koristite individualnu veličinu  po grupi';
$string['use_individual_help'] = 'Zameni globalnu veličinu grupe individualnom vrednošću za svaku grupu. Ovo se podešava putem spiska sa grupama koji se može sortirati na dnu.';
$string['use_queue'] = 'Koristite liste čekanja';
$string['use_queue_help'] = 'Polaznici mogu da se prijave na listu čekanja za grupe koje su već popunjene. Ovo podešavanje se može koristiti samo ako je omogućena samostalna prijava polaznika i podešeno ograničenje veličine grupe.';
$string['use_size'] = 'Aktiviraj';
$string['user'] = 'Korisnik';
$string['user_has_too_less_regs'] = 'Odjavljivanje/uklanjanje sa liste čekanja nije moguće jer je korisnik <strong>{$a->username}</strong> prijavljen/a , odnosno na listi čekanja u premalo grupa!';
$string['user_is_deleted'] = 'Pronađeni korisnički nalog (sa ID oznakom <strong>{$a->id}</strong>, i pod imenom <strong>{$a->fullname}</strong>) je već obrisan. Stoga upis na ovaj kurs nije moguć.';
$string['user_move_prev'] = 'Korisnik <strong>{$a->user}</strong> biće prebačen/a sa liste čekanja za upis u grupu <strong>{$a->from_group}</strong> u grupu <strong>{$a->to_group}</strong>!';
$string['user_moved'] = 'Korisnik <strong>{$a->user}</strong> je premešten/a sa liste čekanja ya upis u grupu <strong>{$a->from_group}</strong> u grupu <strong>{$a->to_group}</strong>!';
$string['user_not_found'] = 'Korisnik <strong>{$a}</strong> nije pronađen!';
$string['userlist'] = 'Spisak korisnika';
$string['userlist_alt'] = 'Pogledajte spisak korisnika i njihove prijave. Izvezite podatke o korisnicima i njihovim grupama u različitim formatima (PDF, običan tekst, Excel, itd.).';
$string['userlist_help'] = 'Spisak ID brojeva odvojenih pomoću jednog ili više sledećih znakova<ul><li>[,] zarez </li><li>[;] tačka i zarez
</li><li>[ ] razmak </li><li>[\\n] novi red </li><li>[\\r] znak za početak reda</li><li>[\\t] tabulator </li></ul>';
$string['userlist_tab'] = 'Kursevi';
$string['userlist_tab_alt'] = 'Otvorite karticu za kurseve';
$string['users_queues_limit'] = 'Broj mesta na listi čekanje po korisniku';
$string['users_queues_limit_help'] = 'Ograničava broj dostupnih mesta na listi čekanja po korisniku ako su liste aktivirane';
$string['users_tab'] = 'Učesnici';
$string['users_tab_alt'] = 'Prikaži učesnike';
$string['view_registrations'] = 'Prikaz prijava';
$string['viewmoodlegroups'] = 'Moodle grupe';
$string['with_selection'] = 'Sa izabranim...';
$string['you_are_already_marked'] = 'Već ste označili grupu <strong>{$a->groupname}</strong> za prijavu!';
$string['you_are_already_queued'] = 'Već ste na listi čekanja za upis u grupu <strong>{$a->groupname}</strong>!';
$string['you_are_already_registered'] = 'Već ste prijavljeni u grupu <strong>{$a->groupname}</strong>!';
$string['you_are_not_in_queue_or_registered'] = 'Niste prijavljeni niti na listi čekanja za upis u grupu <strong>{$a->groupname}</strong>';
$string['you_change_group_to_success'] = 'Promena grupe je uspela! Sada ste prijavljeni u grupu <strong>{$a->groupname}</strong>!';
$string['you_have_too_less_regs'] = 'Odjavljivanje/uklanjanje sa liste čekanja nije moguće jer ste prijavljeni/na listi čekanja u premalo grupa!';
$string['you_have_too_many_queue_places'] = 'Nije moguće dodati vas na listu čekanja za upis u grupu <strong>{$a->groupname}</strong> zato što ste već na listama čekanja za previše grupa!';
$string['your_place_allocated_in_group_success'] = 'Uspešno ste označili grupu <strong>{$a->groupname}</strong>> za prijavljivanje';
