<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_dynamicrule', language 'ja', version '5.1'.
 *
 * @package     tool_dynamicrule
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['active'] = 'アクティブ';
$string['activerules'] = 'アクティブなルール';
$string['addcondition'] = '条件を追加する';
$string['addconditions'] = 'このルールに条件を追加する';
$string['addoutcome'] = 'アクションを追加する';
$string['addoutcomes'] = 'このルールにアクションを追加する';
$string['any'] = 'すべて';
$string['applyon'] = '適用対象';
$string['archive'] = 'アーカイブ';
$string['archived'] = 'アーカイブ済';
$string['archivedrules'] = 'アーカイブされたルール';
$string['availableplaceholders'] = '利用可能なプレースホルダー';
$string['body'] = '本文';
$string['cachedef_conditions'] = 'ダイナミック・ルールの条件とリッスンする必要があるイベントのリストを格納する';
$string['cannotdisablerule'] = 'このルール \'{$a}\' を無効にする十分な権限がありません。';
$string['cannotdisablesharedrule'] = '共有ルール \'{$a}\' は、共有スペースからのみ無効にできます。';
$string['cannotenablecomponentrule'] = 'ルール \'{$a}\' がアクションを持ち、エラーを含んでいなければ有効にできます。';
$string['cannotenablerule'] = 'ルール \'{$a}\' が条件とアクションを持ち、エラーを含んでいなければ有効にできます。';
$string['cannotenablesharedrule'] = '共有ルール \'{$a}\' は共有スペースからのみ有効にできます。';
$string['cohort'] = 'コーホート';
$string['conditioncohortmember'] = 'ユーザはコーホートのメンバーです';
$string['conditioncohortmemberdescription'] = 'コーホート \'{$a}\' のメンバーであるユーザ';
$string['conditioncohortmemberdescriptionwithdate'] = 'コーホート \'{$a->name}\' のメンバーであるユーザ<br />
以降のコーホートに追加: \'{$a->conditiondate}\'';
$string['conditioncohortnotmember'] = 'コーホートのメンバーではない';
$string['conditioncohortnotmemberdescription'] = 'コーホート \'{$a}\' のメンバーではないユーザ';
$string['conditioncompetencydescription'] = 'アーカイブ済みの \'{$a}\' を持っているユーザ';
$string['conditioncompetencyselector'] = 'コンピテンシーを選択';
$string['conditioncompetencyselector_help'] = 'コンピテンシーを選択すると、そのコンピテンシーを達成したユーザを検索できます';
$string['conditioncompetencytitle'] = 'ユーザはアーカイブ済みのコンピテンシーを持っています';
$string['conditioncoursecompleted'] = 'コース完了';
$string['conditioncoursecompletedafter'] = '{$a} 以降の完了日';
$string['conditioncoursecompletedbefore'] = '{$a} 以前の完了日';
$string['conditioncoursecompleteddescription'] = 'コース \'{$a}\' を完了したユーザ';
$string['conditioncoursecompletedgradeany'] = 'すべてのコース評定';
$string['conditioncoursecompletedgradegreaterthan'] = '{$a}% 以上のコース評定';
$string['conditioncoursecompletedgradelessthan'] = '{$a}% 以下のコース評定';
$string['conditioncoursecompletedgraderange'] = '{$a->value}% から {$a->value2}% の間のコース評定';
$string['conditioncourselastaccess'] = 'コース最終アクセス';
$string['conditioncourselastaccessdescriptionafter'] = '{$a->conditiondate} 以降に \'{$a->coursename}\' に最後にアクセスしたユーザ';
$string['conditioncourselastaccessdescriptionbefore'] = '{$a->conditiondate} 以前に \'{$a->coursename}\' に最後にアクセスしたユーザ';
$string['conditioncourselastaccessdescriptionbeforelast'] = '{$a->conditiondate} の間に \'{$a->coursename}\' にアクセスしていないユーザ';
$string['conditioncourselastaccessdescriptionever'] = '1回でも \'{$a->coursename}\' にログインしたことのあるユーザ';
$string['conditioncourselastaccessdescriptioninlast'] = '直近の {$a->conditiondate} に \'{$a->coursename}\' へアクセスしたユーザ';
$string['conditioncourselastaccessdescriptionnever'] = '\'{$a->coursename}\' にアクセスしたことがないユーザ';
$string['conditioncourselastaccessnotice'] = 'この条件はコースに登録されているユーザに適用されます。';
$string['conditioncoursenotcompleted'] = '完了していないコース';
$string['conditioncoursenotcompleteddescription'] = 'コース \'{$a}\' を完了していないユーザ';
$string['conditioncoursenotcompletedformnotice'] = 'この条件は、コースへの登録の有無に関わらず、利用者に適用されます。';
$string['conditioncriteria'] = 'クライテリア';
$string['conditioncriterianotavailableyet'] = '利用不可';
$string['conditionisbroken'] = 'この条件にはエラーがあります';
$string['conditionisnotavailable'] = 'この条件は利用不可です';
$string['conditionnotsaved'] = '条件が保存されていません。';
$string['conditionruledate'] = '{$a->startdate} から';
$string['conditionruledateuntil'] = '{$a->startdate} から {$a->enddate} まで';
$string['conditions'] = '条件';
$string['conditionusercreated'] = 'ユーザが作成されてからの時間';
$string['conditionusercreateddescriptionbefore'] = '直近 {$a} に作成されたユーザ';
$string['conditionusercreateddescriptionover'] = '直近 {$a} より前に作成されたユーザ';
$string['conditionuserenrolled'] = 'ユーザがエンロールされました';
$string['conditionuserenrolleddescription'] = 'コース \'{$a->course}\' に登録されているユーザ<br />
登録方法: \'{$a->enrol}\'';
$string['conditionuserenrolleddescriptionwithdate'] = 'コース \'{$a->course}\' に登録されているユーザ<br />
登録方法: \'{$a->enrol}\'<br />
登録開始日以降 \'{$a->conditiondate}\'';
$string['conditionuserfirstlogindescriptionever'] = '初回ログインが一度でもあるユーザ';
$string['conditionuserfirstlogindescriptioninlast'] = '最近 {$a} に初回ログインしたユーザ';
$string['conditionuserfirstlogindescriptionover'] = '{$a->startdate} から {$a->enddate} の間に最初にログインしたユーザ';
$string['conditionuserlastlogin'] = 'ユーザの最終ログイン';
$string['conditionuserlastlogindescriptionbefore'] = '直近 {$a} より前にログインしたユーザ';
$string['conditionuserlastlogindescriptionever'] = '一度でもログインしたことのあるユーザ';
$string['conditionuserlastlogindescriptioninlast'] = '直近 {$a} 以内にログインしたユーザ';
$string['conditionuserlastlogindescriptionnever'] = '一度もログインしたことのないユーザ';
$string['conditionusernotenrolled'] = '登録されていないユーザ';
$string['conditionusernotenrolleddescription'] = 'コース \'{$a->course}\' に登録されていないユーザ<br />登録方法: \'{$a->enrol}\'';
$string['conditionuserprofilefield'] = 'ユーザプロファイルフィールド';
$string['conditionuserprofilefielddescription'] = 'プロファイルフィールド \'{$a->fieldname}\' の値が \'{$a->fieldvalue}\' であるユーザ';
$string['conditionuserprofilefielddescriptiontext'] = 'プロファイルフィールド \'{$a->fieldname}\' の値が {$a->fieldvalue} であるユーザ';
$string['confirmarchiverule'] = '本当にルール \'{$a}\' をアーカイブしますか？アーカイブされたダイナミックルールは、現在および将来のレポートでも使用できます。';
$string['confirmdeletecondition'] = '本当に条件 \'{$a}\' と関連するすべてのデータを削除しますか？この操作は元に戻せません。';
$string['confirmdeleteoutcome'] = '本当にアクション \'{$a}\' と関連するすべてのデータを削除しますか？この操作は元に戻せません。';
$string['confirmdeleterule'] = '本当にルール \'{$a}\' と関連するすべてのデータを削除しますか？この操作は元に戻せません。';
$string['confirmduplicaterule'] = '本当にルール \'{$a}\' を複製しますか？';
$string['confirmduplicateruleconflicts'] = 'このルールには非共有ルールで使用できないエンティティが含まれているため省略されます：';
$string['confirmeditrule'] = '過去にこのルールにマッチしたユーザがいるため、ルールのアクションのみ編集可能です。条件を変更するためにはこのルールを複製してください。';
$string['confirmenablecomponentrule'] = '本当にこのルールを有効にしますか？有効にすると {$a} ユーザに影響します。';
$string['confirmenablerule'] = '少なくとも1人のユーザがこのルールの影響を受けると、条件がロックされます。本当にこのルールを有効にしますか？';
$string['countmatchingusers'] = '{$a} 合計一致数';
$string['coursecompletiondate'] = '完了日';
$string['coursegrade'] = 'コース評定';
$string['coursegrade_help'] = 'パーセンテージを選択し、指定された範囲内でコース評定を達成したユーザをマッチングさせます。評点は小数点以下5桁で四捨五入されます。大小比較は厳密です。';
$string['courseinternalid'] = 'URLで使用される内部コースID';
$string['courselastaccesstime'] = 'このユーザのコース最終アクセス';
$string['courselastaccesstime_help'] = 'このルールはマッチしたユーザに一度だけ適用されますので、しばらくコースにアクセスしていないユーザへの定期的なリマインダーには使用できませんので注意してください。<br />また、一度コースに登録されたユーザはすぐに「アクセスしたことがない」という条件にマッチする可能性があることに注意してください。';
$string['courseurl'] = 'コースURL';
$string['creationdate'] = '作成日';
$string['creationdate_help'] = '指定した期間内に作成されたユーザをマッチさせるために、現在の日付からの相対的な日付を選択することができます。';
$string['dateinthefuture'] = '未来に';
$string['dateinthepast'] = '過去に';
$string['datelast'] = '最後の {$a} 日';
$string['datelastdays'] = '最後の…日';
$string['datelastplural'] = '最後の {$a} 日';
$string['datenext'] = '次の {$a} 日';
$string['datenextdays'] = '次の…日';
$string['datenextplural'] = '次の {$a} 日';
$string['datetypeever'] = '今までに1度でもある';
$string['datetypeinlast'] = '直近';
$string['datetypenever'] = '1度もない';
$string['datetypenone'] = '設定しない';
$string['datetypepast'] = '直近〇〇より前';
$string['datetyperange'] = 'レンジ';
$string['deletecondition'] = '条件の削除';
$string['deleteoutcome'] = 'アクションの削除';
$string['disablerulemsg'] = 'ルールの無効化';
$string['duplicate'] = '複製';
$string['dynamicrule:manage'] = 'ダイナミックルールの管理';
$string['editanyway'] = 'とにかく編集';
$string['editcondition'] = '条件の編集';
$string['editdetails'] = 'ルール \'{$a}\' の詳細を編集';
$string['editoutcome'] = 'アクションの編集';
$string['editrulename'] = 'ルール \'{$a}\' の名前を編集';
$string['enable'] = '有効';
$string['enabled'] = '有効化済み';
$string['enablehelp'] = '有効なルール';
$string['enablehelp_help'] = 'ルールを有効にするには、少なくとも1つの条件と1つのアクションが必要です。条件やアクションにエラーを含んではいけません。';
$string['enablehelpmodal'] = '有効なルール';
$string['enablehelpmodal_help'] = 'ルールを有効にするには、少なくとも1つのアクションが必要です。';
$string['enablerulemsg'] = '有効なルール';
$string['enddate'] = '終了日';
$string['enddate_help'] = '選択した終了日は、このルールを評価するための最終期限として使用されます。';
$string['errorbadgehasextracriteria'] = 'このバッジには、手動による発行の他にもう一つ必要なクライテリアがあるため、ダイナミックルールによる発行はできません。';
$string['errorbadgenopermission'] = 'このバッジを発行するために必要なロールがありません。';
$string['errorcannotcreate'] = 'ルールを作成する権限がありません。';
$string['errorcannoteditaftermatchedusers'] = 'ページの読み込み後、このルールに一致したユーザが1人以上存在します。条件はこれ以上編集も削除もできません。';
$string['errorcannotmanage'] = 'このルールを管理する権限がありません。';
$string['errorcannotmanagecondition'] = 'この条件を管理する権限がありません。';
$string['errorcannotmanageoutcome'] = 'このアクションを管理する権限がありません。';
$string['errorcohortnotamember'] = 'ユーザがこのコーホートのメンバーでないため、ユーザをコーホートから削除できません。';
$string['errorcompletionnotenabled'] = 'このコースでは完了が有効化されていません';
$string['errorinvalidbadge'] = '無効なバッジ';
$string['errorinvalidbody'] = '無効な通知本文';
$string['errorinvalidcertificatetenant'] = 'このテナントでは認定証が利用できません';
$string['errorinvalidcohort'] = '無効なコーホート';
$string['errorinvalidcohorttenant'] = 'このテナントではコーホートが利用できません';
$string['errorinvalidcompetency'] = '無効なコンピテンシー';
$string['errorinvalidcourse'] = '無効なコース';
$string['errorinvalidcoursetenant'] = 'このテナントではコースが利用できません';
$string['errorinvaliddates'] = '無効な開始日と終了日';
$string['errorinvalidenrolmentmethod'] = 'このコースは登録方法が選択されていないか、有効になっていません';
$string['errorinvalidlearningplan'] = '無効な学習プラン';
$string['errorinvalidoperator'] = '無効な演算子。';
$string['errorinvalidsubject'] = '無効な通知件名';
$string['errorinvaliduserfirstlogin'] = '無効な初回ログイン日';
$string['errorinvaliduserfirstlogintype'] = '無効な初回ログインタイプ';
$string['errorinvaliduserlastcourseaccess'] = '無効なコース最終アクセス日';
$string['errorinvaliduserlastlogin'] = '無効な最終ログイン日';
$string['errorinvaliduserlastlogintype'] = '無効な最終ログインタイプ';
$string['errorinvaliduserprofilefield'] = '無効なプロファイルフィールド';
$string['errorinvaliduserprofilefieldvalue'] = '無効なプロファイルフィールドの値';
$string['errorinvalidvalue'] = '無効な値';
$string['errornopermissionissuecertificate'] = 'この認定証を発行する権限がありません';
$string['eventconditionadded'] = 'ダイナミックルールの条件が追加されました';
$string['eventconditiondeleted'] = 'ダイナミックルールのコンディションが削除されました';
$string['eventconditionupdated'] = 'ダイナミックルールのコンディションがアップデートされました';
$string['eventoutcomeadded'] = 'ダイナミックルールのアクションが追加されました';
$string['eventoutcomedeleted'] = 'ダイナミックルールのアクションが削除されました';
$string['eventoutcomeupdated'] = 'ダイナミックルールのアクションがアップデートされました';
$string['eventrulearchived'] = 'ダイナミックルールがアーカイブされました';
$string['eventrulecreated'] = 'ダイナミックルールが作成されました';
$string['eventruledeleted'] = 'ダイナミックルールが削除されました';
$string['eventruleunarchived'] = 'ダイナミックルールのアーカイブが解除されました';
$string['eventruleupdated'] = 'ダイナミックルールが更新されました';
$string['ever'] = '今までに';
$string['exporterdescription'] = 'ダイナミックルールの定義、条件、アクション';
$string['exportselectactive'] = 'すべてのダイナミックルールを選択（アーカイブを除く）';
$string['exportselectall'] = 'すべてのダイナミックルールを選択（アーカイブを含む）';
$string['exportselectenabled'] = 'すべての有効なダイナミックルールを選択する';
$string['exportsettings'] = 'ルールの定義、条件、アクション';
$string['exportsettings_help'] = 'すべてのルールは、元の状態にかかわらず、インポートされると無効になります。';
$string['field'] = 'フィールド';
$string['filterrulename'] = 'ルール名';
$string['firstlogin'] = 'ユーザの初回ログイン';
$string['firstlogin_help'] = '設定された期間内または現在の日付に関連する期間に初めてログインしたユーザ、および任意の時点で初めてログインしたユーザ、または一度もログインしたことがないユーザを選択できます。';
$string['future'] = '将来';
$string['general'] = '一般';
$string['greaterthan'] = 'より大きい';
$string['importlogerror'] = 'ルール \'{$a}\' をインポートできません';
$string['importlogerrorinvalidcondition'] = 'ルール条件の欠落または無効';
$string['importlogerrorinvalidoutcome'] = 'ルール結果の欠落または無効';
$string['importlogsuccess'] = '新しいルール \'{$a->name}\' を条件  {$a->conditionscount} とアクション {$a->outcomescount} で作成しました。';
$string['importlogsuccesslink'] = '新しいルール  \'<a href="{$a->url}">{$a->name}</a>\' を条件  {$a->conditionscount} とアクション {$a->outcomescount} で作成しました。';
$string['importselectall'] = 'このファイル内のすべてのダイナミックルールを選択する';
$string['importselectspecified'] = '手動で選択…';
$string['includesuspendedusers'] = '一時停止ユーザを含む';
$string['includesuspendedusers_help'] = 'チェックした場合、ルールはこのサイトでアカウントが停止されたユーザに対しても条件を判断し、マッチしたすべてのユーザにアクションを適用しようとします。例えば、通知を受け取らないなどです。';
$string['lastlogin'] = 'ユーザの最終ログイン';
$string['lastlogin_help'] = '現在の日付からの相対的な日付、または一度もログインしていないユーザを選択できます。';
$string['lessthan'] = '未満';
$string['limitreached'] = 'ダイナミックルールの上限に達しました';
$string['limitreacheddescr'] = 'このサイトのダイナミックルールの数が上限に達しました。アーカイブされたルールもこの上限にカウントされますのでご注意ください。';
$string['limitreachednumdescr'] = 'このサイトでは {$a} 個のダイナミックルールしか作成できません。アーカイブされたルールもこの制限にカウントされることに注意してください。';
$string['managebadges'] = 'バッジの管理';
$string['managecohorts'] = 'コーホートの管理';
$string['managecompetencies'] = 'コンピテンシーの管理';
$string['match'] = '一致';
$string['matchedtime'] = '一致した日時';
$string['matchlimitinvalid'] = 'ルールは少なくとも1つのトリガーを必要とします。';
$string['matchstatus'] = 'ステータス';
$string['matchstatusdone'] = '完了';
$string['matchstatuserror'] = '失敗';
$string['matchstatuspending'] = '保留中';
$string['matchstatusprogress'] = '進行中';
$string['messageprovider:notificationoutcome'] = 'ダイナミックルールツールの通知アクション';
$string['missingcondition'] = '条件の欠落';
$string['missingconditiondescr'] = '条件 \'{$a->condition}\' がプラグイン \'{$a->plugin}\' に存在しません。';
$string['missingoutcome'] = 'アクションの欠落';
$string['missingoutcomedescr'] = 'アクション \'{$a->outcome}\' がプラグイン \'{$a->plugin}\' に存在しません。';
$string['newnameforrule'] = 'ルール \'{$a}\' の新しい名前';
$string['newrule'] = '新しいルール';
$string['noavailablebadges'] = '使用可能なバッジはありません';
$string['noavailablecohorts'] = '使用可能なコーホートはありません';
$string['noavailablecompetencies'] = '使用可能なコンピテンシーはありません';
$string['noavailablecompletioncourses'] = '完了が有効になっているコースはありません';
$string['noavailableenrolledcourses'] = '参加者リストにアクセスできるコースがありません';
$string['noruleconditions'] = 'このルールには条件が設定されていません';
$string['noruleoutcomes'] = 'このルールにはアクションが設定されていません';
$string['operatorafter'] = '以降';
$string['operatoranytime'] = 'いつでも';
$string['operatorbefore'] = '以前';
$string['outcomeactivatedesc'] = '影響を受けるすべてのユーザを有効化';
$string['outcomebadge'] = 'バッジを授与';
$string['outcomebadgedescription'] = 'バッジ \'{$a}\' をユーザに授与';
$string['outcomecertificate'] = '認定証の発行';
$string['outcomecertificatedescription'] = 'ユーザへの認定証 \'{$a}\' の発行';
$string['outcomecohort'] = 'コーホートへ追加';
$string['outcomecohortbroken'] = 'コーホートID \'{$a}\' は存在しません';
$string['outcomecohortdescription'] = 'コーホート \'{$a}\' にユーザを追加する';
$string['outcomecohortremove'] = 'コーホートから除外';
$string['outcomecohortremovedescription'] = 'コーホート \'{$a}\' からユーザを除外する';
$string['outcomecompetency'] = '受賞コンピテンシー';
$string['outcomecompetencybroken'] = 'コンピテンシー ID \'{$a}\' は存在しません';
$string['outcomecompetencydescription'] = 'コンピテンシー \'{$a}\' をユーザへ授与する';
$string['outcomedeletedesc'] = '影響を受けるすべてのユーザを削除';
$string['outcomedeleteuser'] = 'ユーザを削除';
$string['outcomedeleteuserdescription'] = 'ユーザを削除し、システムから完全に削除します。';
$string['outcomedeleteuserwarning'] = '警告: この操作により、ルール作成者が削除される可能性があります。それにより、すべてのデータが削除される場合があります（元に戻すことはできません）。慎重に進めてください。';
$string['outcomeisbroken'] = 'このアクションにはエラーが含まれています';
$string['outcomeisnotavailable'] = 'このアクションは利用できません';
$string['outcomelearningplan'] = '学習プランを割り当てる';
$string['outcomelearningplanbroken'] = '学習プランテンプレートID \'{$a}\' は存在しません';
$string['outcomelearningplandescription'] = '学習プランテンプレート \'{$a}\' をユーザに割り当てる';
$string['outcomelearningplanunassign'] = '学習プランから割り当てを解除';
$string['outcomelearningplanunassigndescription'] = 'ユーザから学習プランテンプレート \'{$a}\' の割り当てを解除する';
$string['outcomenotification'] = '通知';
$string['outcomenotificationdescription'] = '通知 \'{$a}\' をユーザに送る';
$string['outcomenotsaved'] = 'アクションは保存されていません';
$string['outcomes'] = 'アクション';
$string['outcomesuspenddesc'] = '影響を受けるすべてのユーザを停止';
$string['outcomesuspenduser'] = 'ユーザを停止';
$string['outcomesuspenduserdescription'] = 'ユーザを停止し、ログインや通知の受信ができないようにします。';
$string['outcomesuspenduserwarning'] = '警告: この操作によりルール作成者が停止され、システムにアクセスできなくなる可能性があります。慎重に進めてください。';
$string['outcomeunsuspenduser'] = 'ユーザを有効化';
$string['outcomeunsuspenduserdescription'] = 'ユーザを有効化し、ログインや通知の受信ができるようにします。';
$string['past'] = '過去';
$string['per'] = 'あたり';
$string['placeholdersdesc'] = 'プレースホルダー';
$string['placeholdersdesc_help'] = '例えば、 {{userfullname}} プレースホルダはユーザに配信される通知の中でユーザのフルネームに置き換えられます。';
$string['pluginname'] = 'ダイナミックルール';
$string['previewcoursefullname'] = 'コースフルネーム';
$string['previewcourseshortname'] = 'コース省略名';
$string['privacy:metadata:tool_dynamicrule_match'] = '特定のルール条件にマッチするユーザに関する情報。マッチングの結果、ユーザはルールで定義されたアクションの影響を受けます。';
$string['privacy:metadata:tool_dynamicrule_match:matchedtime'] = 'ユーザがルール条件にマッチしたことを示すタイムスタンプ';
$string['privacy:metadata:tool_dynamicrule_match:ruleid'] = 'ルールのID';
$string['privacy:metadata:tool_dynamicrule_match:unmatchedtime'] = 'アクションが適用された後、ユーザがルール条件に一致しなくなったことを示すタイムスタンプ';
$string['privacy:metadata:tool_dynamicrule_match:userid'] = 'ルール条件にマッチしたユーザのID';
$string['quarter'] = '四半期';
$string['range'] = 'レンジ';
$string['reg_wpdynamicrules'] = 'ダイナミックルールの数 ({$a})';
$string['rolemanager'] = 'ダイナミックルールマネージャー';
$string['rolemanagerdescription'] = '現在のテナント内でのダイナミックルールの作成と編集を許可する';
$string['rulearchive'] = 'アーカイブ';
$string['ruleeditactions'] = 'アクションの編集';
$string['rulematchfreq'] = 'ルールアクションの制限';
$string['rulematchfreq_help'] = 'ユーザがルール条件に一致すると、すぐにアクションが適用されます。ユーザが引き続き条件に一致する場合、これらのアクションは再度適用されません。ただし、ユーザが条件に一致しなくなった後、再び条件に一致した場合は、アクションが再び適用されることがあります。この設定は、アクションの最大適用回数を定義します。';
$string['rulematchfreqdesc0'] = 'これ以上の適用はできません';
$string['rulematchfreqdesc1'] = '時間';
$string['rulematchfreqenable'] = '各ユーザにアクションを適用する回数を制限する';
$string['rulename'] = '名前';
$string['rulenamecopy'] = '{$a->name} コピー {$a->number}';
$string['rulenotfound'] = 'ルールが見つかりません';
$string['ruleselectitemarchived'] = '{$a} （アーカイブ済み）';
$string['ruleunarchive'] = 'アーカイブ解除';
$string['ruleviewreport'] = 'レポートを閲覧';
$string['scheduledtask'] = 'スケジュールタスク';
$string['seedetails'] = '詳細を見る';
$string['seemore'] = '詳細…';
$string['select'] = '選択';
$string['selectbadge'] = 'バッジを選択';
$string['selectbadge_help'] = 'ダイナミックルールによる授与の対象となるのは、「ロールによる手動発行」基準を使用したサイトバッジのみです。';
$string['selectcertificate'] = '認定証を選択';
$string['selectcompetency'] = 'コンピテンシーを選択';
$string['selectcompetency_help'] = '作成するコンピテンシーを選択';
$string['selectlearningplan'] = '学習プランを選択';
$string['selectlearningplan_help'] = '学習プランテンプレートを選択';
$string['sendto'] = '送信先';
$string['sendtodptlead'] = '部門リーダー';
$string['sendtomanager'] = 'マネージャー';
$string['sendtomanualmanager'] = '手動で割り当てられたマネージャー';
$string['sendtomatching'] = '一致するユーザ';
$string['sitelink'] = 'サイトリンク';
$string['sitelinkspecific'] = 'テナント専用サイトリンク';
$string['siteshortname'] = 'サイト省略名';
$string['startdate'] = '開始日';
$string['startdate_help'] = '選択した開始日は、ルール評価の開始時点となります。「コース完了」などの条件に影響を与えるイベントは、選択した日付の前後いつでも発生する可能性があります。';
$string['subject'] = '件名';
$string['tagarea_tool_dynamicrule'] = 'ダイナミックルール';
$string['taskprocessrules'] = 'プロセスルール';
$string['timeadded'] = 'この日時以降に追加されたコーホート';
$string['timecreated'] = '作成されました';
$string['timeenrolled'] = '登録開始日時は以下の通りです';
$string['timeprocessed'] = '処理日時';
$string['toomanybadgestoshow'] = 'バッジが多すぎて表示できません';
$string['toomanycertificatestoshow'] = '認定証 ({$a}) が多すぎて表示できません';
$string['toomanycohortstoshow'] = 'コーホート ({$a}) が多すぎて表示できません';
$string['toomanycompetenciestoshow'] = 'コンピテンシー ({$a}) が多すぎて表示できません';
$string['toomanylptoshow'] = '学習プラン ({$a}) が多すぎて表示できません';
$string['uneditabledescription'] = '({$a}) （詳細は利用不可）';
$string['userdetailshidden'] = '詳細は隠されています';
$string['userfirstlogin'] = 'ユーザ初回ログイン';
$string['viewmatchingusers'] = '一致しているユーザを表示';
$string['warningchangeswillnotapplymatchedusers'] = 'この変更は、過去にこのルールに合致したユーザには適用されません。';
