<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'icontent', language 'ja', version '5.1'.
 *
 * @package     icontent
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = '操作';
$string['addafter'] = '新しいページを追加する';
$string['addnewpage'] = '新しいページを追加する';
$string['addquestion'] = '新しい質問を追加する';
$string['advance'] = '次へ';
$string['alldoubts'] = 'すべての質問';
$string['answers'] = '回答';
$string['answersevaluatedinfo'] = '<i class="fa fa-info-circle"></i> 評定された回答はこのリストには表示されません。再評定するには {$a}。';
$string['answerthequestions'] = '質問に回答する';
$string['attempt'] = '受験';
$string['attemptsallowed'] = '許可される受験数';
$string['attemptsallowedhelp'] = '許可される受験数';
$string['attemptsallowedhelp_help'] = '許可される受験数を設定するオプションを選択してください。';
$string['bgcolor'] = '背景色';
$string['bgcolorhelp'] = '背景色';
$string['bgcolorhelp_help'] = 'すべてのページの背景としてデフォルト色が設定されます。';
$string['bgcolorpagehelp'] = '背景色';
$string['bgcolorpagehelp_help'] = '実ページの背景としてデフォルト色が設定されます。';
$string['bgimage'] = '背景イメージ';
$string['bgimagehelp'] = '背景のイメージです。';
$string['bgimagehelp_help'] = 'すべてのページの背景となる標準イメージです。';
$string['bgimagepagehelp'] = '背景イメージ';
$string['bgimagepagehelp_help'] = '実ページの背景となる標準イメージです。';
$string['bordercolor'] = '枠線色';
$string['bordercolorhelp'] = '枠線色';
$string['bordercolorhelp_help'] = 'フィールドをクリックして、それぞれのページの枠線のデフォルト色を選択してください。';
$string['bordercolorpagehelp'] = '枠線色';
$string['bordercolorpagehelp_help'] = 'フィールドをクリックして、実ページの枠線のデフォルト色を選択してください。';
$string['borderwidth'] = '枠線幅';
$string['borderwidthhelp'] = '枠線幅';
$string['borderwidthhelp_help'] = 'それぞれのページの端までのデフォルト幅を選択してください。';
$string['borderwidthpagehelp'] = '枠線幅';
$string['borderwidthpagehelp_help'] = '実ページの端までのデフォルト幅を選択してください。';
$string['calculated'] = '計算';
$string['calculatedmulti'] = '複数計算';
$string['calculatedsimple'] = '単純計算';
$string['choiceone'] = '選択:';
$string['choiceoneoption'] = 'オプションを選択する:';
$string['choiceoneormore'] = '{$a} オプションを選択する:';
$string['clickhere'] = 'ここをクリックする:';
$string['collumns2'] = '2カラムまで';
$string['collumns3'] = '3カラムまで';
$string['collumns4'] = '4カラムまで';
$string['collumns5'] = '5カラムまで';
$string['comments'] = 'コメント';
$string['confdeleteattempt'] = 'ページ {$a->pagenum} の受験を削除する';
$string['confpagedelete'] = 'このページおよび関連するすべてのファイルおよびレコードを削除してもよろしいですか?';
$string['confpagenotedelete'] = '<i class="fa fa-exclamation-triangle"></i> このノートおよびすべての返信を削除してもよろしいですか?<span class="label label-warning">{$a} 返信</span>';
$string['copyright'] = '著作権';
$string['copyright_help'] = '著作権に関するクレジットを追加するための予約スペースです。';
$string['coverpage'] = 'カバーページ';
$string['coverpage_help'] = '表示されるコンテンツのカバーページを作成する場合、有効にしてください。このオプションを有効にした場合、コンテンツフィールドに簡単な説明を追加してください。この説明は表紙に表示されます。説明が500文字を超える場合、[続きを読む]ボタンが1つ追加されます。';
$string['createdby'] = '作成者';
$string['description'] = '説明';
$string['displayed'] = '表示ページ';
$string['displayedhelp'] = '表示';
$string['displayedhelp_help'] = 'この設定を有効にした場合、ページが表示されます。';
$string['doubt'] = '質問 <span id="messagedoubt">{$a}</span>';
$string['doubtandnotes'] = 'あなたのノートおよび質問';
$string['doubts'] = '質問';
$string['doubtstotutor'] = 'チュータに送信済みの質問';
$string['doubttutor'] = 'チュータにのみ質問する';
$string['edit'] = '編集';
$string['editcurrentpage'] = '現在のページを編集する';
$string['editingpage'] = 'ページを編集する';
$string['effects'] = '効果';
$string['emptyquestionbank'] = '<i class="fa fa-exclamation-triangle"></i>バンク質問は空です。';
$string['erroridnotfound'] = '<i class="fa fa-exclamation-triangle"></i> あなたはパラメータを指定する必要があります。{$a}';
$string['essay'] = '作文';
$string['evaluate'] = '評価';
$string['evaluative'] = '評価項目';
$string['evaluative_help'] = 'この機能を有効にした場合、評価項目となります。';
$string['eventnotecreated'] = 'ノートが作成されました。';
$string['eventnotedeleted'] = 'ノートが削除されました。';
$string['eventnotelikecreated'] = 'ノート「いいね」が作成されました。';
$string['eventnotelikedeleted'] = 'ノート「いいね」が削除されました。';
$string['eventnotereplied'] = 'ノートに返信されました。';
$string['eventnoteupdated'] = 'ノートが更新されました。';
$string['eventpagecreated'] = 'ページが作成されました。';
$string['eventpagedeleted'] = 'ページが削除されました。';
$string['eventpageupdated'] = 'ページが更新されました。';
$string['eventpageviewed'] = 'ページが閲覧されました。';
$string['eventquestionattemptcreated'] = '質問が作成されました。';
$string['eventquestionattemptdeleted'] = '質問が削除されました。';
$string['eventquestionpageviewed'] = 'addquestionpageが表示されました。';
$string['eventquestiontoevaluatecreated'] = '評価マニュアルに関する質問';
$string['expandnotesarea'] = 'ノートエリアを拡張する';
$string['expandnotesarea_help'] = '拡張されたノートエリアを表示するにはチェックしてください。';
$string['expandquestionsarea'] = '質問エリアを拡張する';
$string['expandquestionsarea_help'] = '拡張された質問エリアを表示するにはチェックしてください。';
$string['featured'] = '注目';
$string['fluid'] = '可変';
$string['goback'] = '最後';
$string['grade'] = '評定';
$string['gradingscale'] = '評点 (0 - {$a})';
$string['highcontrast'] = 'ハイコントラスト';
$string['highlighted'] = 'ハイライト';
$string['highlights'] = 'ハイライト';
$string['icontent'] = 'コンテンツ';
$string['icontent:addinstance'] = '新しいコンテンツページを追加する';
$string['icontent:answerquestionstryagain'] = 'ページ上の質問に無制限に回答できるようにする';
$string['icontent:checkboxdoubttutornotes'] = 'チューターへの質問';
$string['icontent:checkboxfeaturednotes'] = 'ノートを注目マークする';
$string['icontent:checkboxprivatenotes'] = 'ノートを非公開にする';
$string['icontent:edit'] = 'コンテンツページを編集する';
$string['icontent:editnotes'] = 'ノートを編集する';
$string['icontent:grade'] = '評定レポートを閲覧する';
$string['icontent:likenotes'] = 'ノートに「いいね」する';
$string['icontent:manage'] = 'インタラクティブiコンテンツを管理する';
$string['icontent:newquestion'] = '新しい質問を追加する';
$string['icontent:removenotes'] = 'ノートを削除する';
$string['icontent:replynotes'] = 'ノートに返信する';
$string['icontent:view'] = 'インタラクティブiコンテンツを閲覧する';
$string['icontent:viewnotes'] = 'ノートを閲覧する';
$string['icontentfieldset'] = 'カスタムフィールドセット例';
$string['icontentmenu'] = 'コンテンツページメニュー';
$string['icontentname'] = 'コンテンツページ名';
$string['icontentname_help'] = 'これはicontentnameフィールドに関連付けられたヘルプツールチップのiコンテンツです。Markdown構文がサポートされています。';
$string['infomaxquestionperpage'] = '<i class="fa fa-info-circle"></i> 1ページに3件まで質問を追加できます。';
$string['labelprogressbar'] = '{$a}% 完了';
$string['lastmodifiedby'] = '最終更新';
$string['layout'] = 'ページレイアウト';
$string['layouthelp'] = 'ページのレイアウトです。';
$string['layouthelp_help'] = 'レイアウトを選択してください。';
$string['like'] = 'いいね ({$a})';
$string['likes'] = 'いいね';
$string['listdoubts'] = '質問一覧';
$string['manualgrading'] = '手動評定';
$string['manualreview'] = '手動レビュー';
$string['manualreviewofparticipant'] = '参加者 {$a} の受験を手動レビューする';
$string['match'] = '一致';
$string['maximumdigits'] = '最大 {$a} 桁';
$string['maxnotesperpages'] = '1ページあたりの最大ノート数';
$string['maxnotesperpageshelp'] = '1ページあたりの最大ノート数です。';
$string['maxnotesperpageshelp_help'] = '1ページあたりの最大ノート数を入力してください。整数のみを入力してください。';
$string['maxpages'] = '最大ページ数';
$string['maxpageshelp'] = '最大ページ数';
$string['maxpageshelp_help'] = '最大ページ数を入力してください。整数のみを入力してください。重要な点は通信教育での最大ページ数を35ページとすることです。';
$string['modulename'] = 'コンテンツページ';
$string['modulename_help'] = 'Moodle用プラグイン (コンテンツページ) は受講者、チュータ、教師および技術者がユーザビリティおよびアクセシビリティの基準に従ってコースにコンテンツを追加できるよう設計されています。
このツールはテキスト、イメージ、マルチメディア等を追加する良い習慣を示す役割を果たします。コンテンツはページに分散されるため、コンテンツの監視が疲れるものにならないようにしています。プラグインにはブックマークも実装されているため、最新ログに基づいて参加者を特定できます。さらに参加者がページ上で学習したコンテンツにフィードバックを提供すること、他のユーザからのコメントを楽しみながら返信すること、そして、公開または非公開ノートを含めることができます。
このプラグインは扱われたコンテンツに関する質問の起動も可能にしているため、参加者と仮想学習プラットフォーム間のより良い相互作用を提供します。この機能は評定項目になったり、行動計画で定義されたコースで利用可能な項目に関する分割ノートを起動したりできます。説明した拡張機能は完全にレスポンシブであり、どのデバイスからでもアクセスできます。';
$string['modulenameplural'] = 'コンテンツページ';
$string['msgaddquestionpage'] = '質問が正常に追加されました!';
$string['msgconfirmdeleteattempt'] = '<i class="fa fa-exclamation-triangle"></i> 受験内に <span class="label label-warning"> {$a->totalanswers} 件の回答</span> が見つかりました。本当にこのページの受験を削除してもよろしいですか?';
$string['msgstatusdisplay'] = '受験が記録されているため、あなたは質問を追加または削除できません。';
$string['msgsucess'] = 'データが正常に記録されました!';
$string['msgsucessevaluate'] = '{$a} の評定を正常に完了しました!';
$string['msgsucessexclusion'] = 'レコードが正常に削除されました。';
$string['multianswer'] = '複数回答';
$string['multichoice'] = '多肢選択';
$string['mylistcomments'] = 'マイコメントリスト';
$string['next'] = '次へ';
$string['nextpage'] = '次のページ';
$string['noeffect'] = '効果なし';
$string['nonotes'] = 'このページにノートはありません。';
$string['norecordsfound'] = '<i class="fa fa-info-circle"></i> レコードは見つかりませんでした。';
$string['note'] = 'ノート <span id="messagenotes">{$a}</span>';
$string['notedon'] = 'ノート記録';
$string['numerical'] = '数値';
$string['page'] = '<span>ページ <em>{$a}</em></span>';
$string['pagenotfound'] = '<i class="fa fa-exclamation-triangle" aria-hidden="true"></i> このiコンテンツのインスタンスにページは見つかりませんでした。';
$string['pagetitle'] = 'ページタイトル';
$string['partialresult'] = '部分結果';
$string['pluginadministration'] = 'コンテンツページ管理';
$string['pluginname'] = 'コンテンツページ';
$string['preview'] = 'プレビュー';
$string['previous'] = '前へ';
$string['previouspage'] = '前のページ';
$string['private'] = 'プライベート';
$string['privates'] = 'プライベート';
$string['progressbar'] = '進捗バー';
$string['progressbar_help'] = 'この設定を有効にした場合、レッスンページ下部におおよその完了率を示すバーが表示されます。';
$string['questions'] = '質問';
$string['random'] = 'ランダム';
$string['reassess'] = '再評定';
$string['remove'] = '削除';
$string['removenote'] = 'ノートを削除する';
$string['removenotes'] = 'ノートを削除する';
$string['reply'] = '返信';
$string['respond'] = '回答';
$string['result'] = '結果';
$string['resultlastattempt'] = '前回の受験結果';
$string['results'] = '結果';
$string['rightanswers'] = '正解';
$string['save'] = '保存';
$string['send'] = '送信';
$string['sendallandfinish'] = 'すべてを送信して終了する';
$string['sendanswers'] = '回答を送信する';
$string['sendattemp'] = '受験を送信する';
$string['shortanswer'] = '短い回答';
$string['showbgimage'] = '背景イメージを表示する';
$string['showbgimage_help'] = '背景イメージを表示するかどうか選択してください。';
$string['showless'] = '表示を減らす';
$string['showmore'] = 'さらに表示する';
$string['shownotesarea'] = 'ノートエリアを表示する';
$string['shownotesarea_help'] = 'ノートエリアを表示するには「Yes」を選択してください。';
$string['showtitle'] = 'タイトルを表示する';
$string['showtitle_help'] = 'ページタイトルを表示/秘匿します。';
$string['state'] = '状態';
$string['statusview'] = 'ステータス表示';
$string['strattempttitle'] = '「ページ {$a->pagenum} タイトル {$a->title} 」内の受験';
$string['strmanualgrading'] = '手動評定が必要な質問のある学生';
$string['strmaxgrade'] = '最大1,00';
$string['stropenanswer'] = '<span class="label label-info">{$a} 件の回答が評定待ちです。</span>';
$string['strstate'] = '終了 <br /> 送信 {$a}';
$string['strtoevaluate'] = '{$a->fraction} / {$a->maxfraction} ({$a->percentage}%). {$a->openanswer}';
$string['summary'] = '概要';
$string['summaryattempts'] = '受験概要';
$string['toevaluate'] = '評定';
$string['toreassess'] = '再評定';
$string['totalanswers'] = '合計回答数';
$string['transitioneffect'] = 'トランジション';
$string['transitioneffecthelp'] = 'トランジション効果';
$string['transitioneffecthelp_help'] = '現在のページの遷移タイプを選択してください。';
$string['truefalse'] = '〇/×';
$string['tryagain'] = 'もう一度';
$string['type'] = 'タイプ';
$string['unlike'] = 'いいね解除 ({$a})';
$string['usemaxgrade'] = '最大評点';
$string['usemaxgrade_help'] = 'アピールが評価項目である場合、あなたはこの活動で利用可能な最高評点を知らせることができます。';
$string['writedoubt'] = '質問を入力してください。';
$string['writenotes'] = 'ノートを入力してください。';
