<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'ai', language 'ja', version '5.1'.
 *
 * @package     ai
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['acceptai'] = '承諾して続行する';
$string['action'] = 'アクション';
$string['action_explain_text'] = 'テキストを要約する';
$string['action_explain_text_desc'] = 'コースページのテキストコンテンツを説明します。';
$string['action_explain_text_help'] = '主要な考え方を展開、複雑な概念を簡素化、文脈を追加することでテキストをより理解しやすくするための説明を提供します。';
$string['action_explain_text_instruction'] = 'あなたはユーザからテキスト入力を受け取ります。あなたのタスクは入力されたテキストを説明することです。以下のガイドラインに従ってください:
    1. 詳しく説明する: 重要なアイデアおよび概念について詳しく説明して、説明に深みを持たせてください。
    2. 単純化する: 複雑な用語または考え方をより単純な構成要素に分解して、学習者を含む幅広いオーディエンスが理解しやすいようにしてください。
    3. 文脈を説明する: 何かが起きる理由、仕組みまたは目的を説明してください。適切な場合、理解を深めるために関連する例または類推を含めてください。
    4. 論理的に整理する: 基本的な考え方から説明して、細かい説明に移行してください。

重要なインストラクション:
    1. 概要をプレインテキストのみで返してください。
    2. マークダウンのフォーマット、挨拶または決まり文句は含めないでください。
    3. 明瞭さ、簡潔さおよびアクセシビリティを重視してください。

説明が読みやすく、オリジナルテキストの要点が効果的に伝わるようにしてください。';
$string['action_generate_image'] = 'イメージを生成する';
$string['action_generate_image_desc'] = 'テキストプロンプトに基づいて画像を生成します。';
$string['action_generate_image_help'] = 'プロンプトに基づいてイメージを生成します。';
$string['action_generate_text'] = 'テキストを生成する';
$string['action_generate_text_desc'] = 'テキストプロンプトに基づいてテキストを生成します。';
$string['action_generate_text_help'] = 'プロンプトに基づいてテキストを生成します。';
$string['action_generate_text_instruction'] = 'あなたはユーザからテキスト入力を受け取ります。あなたのタスクは、ユーザのリクエストに基づいてテキストを生成することです。以下の重要なインストラクションに従ってください:
    1. 要約をプレインテキストのみで返してください。
    2. マークダウンの書式、挨拶および決まり文句は含めないでください。';
$string['action_summarise_text'] = 'テキストを要約する';
$string['action_summarise_text_desc'] = 'コースページのテキストコンテンツを要約します。';
$string['action_summarise_text_help'] = 'ページコンテンツの簡単な要約を作成します。';
$string['action_summarise_text_instruction'] = 'あなたはユーザからテキスト入力を受け取ります。あなたのタスクは提供されたテキストを要約することです。以下のガイドラインに従ってください:
    1. 要約する: 長い文章を要点をまとめて短くしてください。
    2. 単純化する: 複雑な情報を特に学習者にとって理解しやすくしてください。

重要なインストラクション:
    1. 要約はプレインテキストのみで返してください。
    2. マークダウンの書式、挨拶および決まり文句を含めないでください。
    3. 明瞭さ、簡潔さ、およびアクセシビリティを重視してください。

要約は読みやすく、かつ原文の要点を効果的に伝えるようにしてください。';
$string['action_translate_text'] = 'テキストを翻訳する';
$string['action_translate_text_desc'] = '提供されたテキストをある言語から別の言語に翻訳します。';
$string['actionsettingprovider'] = '{$a} アクション設定';
$string['actionsettingprovider_desc'] = 'これらの設定は {$a->providername} がどのようにアクション {$a->actionname} を実行するか制御します。';
$string['actionsettings'] = 'アクション設定';
$string['actionsettings_desc'] = 'これらの設定はこのプロバイダインスタンスに対するAIのアクションをコントロールします。';
$string['ai'] = 'AI';
$string['aiactionregister'] = 'AIアクションレジスタ';
$string['aiactionshdr'] = 'この活動のAI機能を選択してください:';
$string['aiplacements'] = 'AI配置';
$string['aipolicyacceptance'] = 'AIポリシー承諾';
$string['aipolicyregister'] = 'AIポリシー登録';
$string['aiproviders'] = 'AIプロバイダ';
$string['aireports'] = 'すべてのレポート';
$string['aitools'] = 'AIツール';
$string['aitoolsincourseactivitydesc'] = 'この設定を有効にした場合、あなたは利用可能なAI機能を指定できます。';
$string['aitoolsincoursedesc'] = 'この設定を有効にした場合、このコースの活動でAIツールが利用可能となります。AIツールはそれぞれの設定で設定できます。';
$string['aitoolsnotenabled'] = 'この活動で利用可能なAI機能を指定するにはコース設定に移動してAIツールを有効にしてください。';
$string['aiusage'] = 'AI利用';
$string['aiusagepolicy'] = 'AI利用ポリシー';
$string['availableplacements'] = 'AIアクションが利用可能な場所を選択する';
$string['availableplacements_desc'] = '配置はAIアクションがサイト内でどのようにどこで使用できるか定義します。あなたは設定によりそれぞれの配置で利用可能なアクションを選択できます。';
$string['availableproviders'] = 'あなたのLMSに接続されているAIプロバイダを管理する';
$string['availableproviders_desc'] = 'AIプロバイダはテキスト要約または画像生成等、「アクション」を通じてあなたのサイトにAI機能を追加します。<br/>
あなたはそれぞれのプロバイダの設定でアクションを管理できます。';
$string['btninstancecreate'] = 'インスタンスを作成する';
$string['btninstanceupdate'] = 'インスタンスを更新する';
$string['completiontokens'] = '完了トークン';
$string['completiontokens_help'] = '完了トークンとはあなたの入力に対するレスポンスとしてAIモデルが生成するテキスト単位です。長いレスポンスはより多くのトークンを使用するため、より多くのコストがかかる可能性があります。';
$string['configureprovider'] = 'プロバイダインスタンスを設定する';
$string['contentwatermark'] = 'Generated by AI';
$string['createnewprovider'] = '新しいプロバイダインスタンスを作成する';
$string['dateaccepted'] = '承諾日';
$string['declineaipolicy'] = '拒否';
$string['enableaitoolsincourse'] = 'このコースでのAIツール使用を許可する';
$string['enableaitoolsincourseactivity'] = 'この活動でのAIツール使用を許可する';
$string['enableglobalratelimit'] = 'サイト全体のレート制限を設定する';
$string['enableglobalratelimit_help'] = 'AIプロバイダが1時間ごとにサイト全体で受信できるリクエスト数を制限します。';
$string['enableuserratelimit'] = 'ユーザレート制限を設定する';
$string['enableuserratelimit_help'] = 'それぞれのユーザが1時間ごとにAI APIプロバイダにリクエストできる回数を制限します。';
$string['error:400'] = 'Bad request';
$string['error:401'] = 'Unauthorised';
$string['error:401:upstreamless'] = 'AIサービスに接続できません。後ほど再度お試しください。';
$string['error:404'] = 'Not found';
$string['error:404:upstreamless'] = 'AIサービスは一時的に利用できません。後ほど再度お試しください。';
$string['error:429'] = 'Too many requests';
$string['error:429:internalsitewide'] = 'AIは1時間に送信できるサイト全体のリクエストの最大数に達しました。後で再度お試しください。';
$string['error:429:internaluser'] = 'あなたは1時間に送信できるAIリクエストの最大数に達しました。後で再度お試しください。';
$string['error:429:upstreamless'] = 'このAIサービスはリクエストの制限に達しました。後で再度お試しください。';
$string['error:500'] = 'Internal server error';
$string['error:503'] = 'Service unavailable';
$string['error:actionnotfound'] = 'アクション「 {$a} 」はサポートされていません。';
$string['error:defaultmessage'] = 'あなたのリクエストの処理中にエラーが発生しました。後ほど再度お試しください。';
$string['error:defaultmessageshort'] = '後ほど再度お試しください。';
$string['error:defaultname'] = '何か問題が発生しました。';
$string['error:noproviders'] = 'この操作を処理できるプロバイダを利用できません。';
$string['error:providernotfound'] = 'AIプロバイダインスタンスが見つかりません。';
$string['error:unknown'] = '不明なエラー';
$string['globalratelimit'] = 'サイト全体の最大リクエスト数';
$string['globalratelimit_help'] = '1時間に許可されるサイト全体のリクエスト数です。';
$string['manageaiplacements'] = 'AI配置を管理する';
$string['manageaiproviders'] = 'AIプロバイダを管理する';
$string['noproviders'] = 'このアクションは利用できません。このアクションのために設定された<a href="{$a}">AI プロバイダ</a>はありません。';
$string['off'] = 'OFF';
$string['on'] = 'ON';
$string['placement'] = '配置';
$string['placementactionsettings'] = 'アクション';
$string['placementactionsettings_desc'] = 'この配置で利用可能なAIアクションです。';
$string['placementsettings'] = '配置別設定';
$string['placementsettings_desc'] = 'これらの設定はAI配置がどのようにAIサービスに接続するか、および関連する操作を制御します。';
$string['privacy:metadata:ai_action_explain_text'] = 'ユーザによる説明テキストのリクエストを保存するテーブルです。';
$string['privacy:metadata:ai_action_explain_text:completiontoken'] = 'テキストを説明するために使用される完了トークンです。';
$string['privacy:metadata:ai_action_explain_text:fingerprint'] = 'モデルおよびコンテンツの状態/バージョンを表すユニークなハッシュです。';
$string['privacy:metadata:ai_action_explain_text:generatedcontent'] = '入力プロンプトに基づいてAIモデルが生成した実際のテキストです。';
$string['privacy:metadata:ai_action_explain_text:prompt'] = '説明テキストリクエストのプロンプトです。';
$string['privacy:metadata:ai_action_explain_text:prompttokens'] = 'テキストを説明するために使用されるプロンプトトークンです。';
$string['privacy:metadata:ai_action_explain_text:responseid'] = 'レスポンスのIDです。';
$string['privacy:metadata:ai_action_generate_image'] = 'ユーザによる画像生成リクエストを格納するテーブルです。';
$string['privacy:metadata:ai_action_generate_image:aspectratio'] = '生成される画像の縦横比です。';
$string['privacy:metadata:ai_action_generate_image:numberimages'] = '生成された画像数です。';
$string['privacy:metadata:ai_action_generate_image:prompt'] = '画像生成リクエストのプロンプトです。';
$string['privacy:metadata:ai_action_generate_image:quality'] = '生成された画像のクオリティです。';
$string['privacy:metadata:ai_action_generate_image:revisedprompt'] = '生成された画像の修正プロンプトです。';
$string['privacy:metadata:ai_action_generate_image:sourceurl'] = '生成された画像のソースURLです。';
$string['privacy:metadata:ai_action_generate_image:style'] = '生成された画像のスタイルです。';
$string['privacy:metadata:ai_action_generate_text'] = 'ユーザによるテキスト生成リクエストを格納するテーブルです。';
$string['privacy:metadata:ai_action_generate_text:completiontoken'] = 'テキストを生成するために使用される補完トークンです。';
$string['privacy:metadata:ai_action_generate_text:fingerprint'] = 'モデルおよびコンテンツの状態/バージョンを表すユニークなハッシュです。';
$string['privacy:metadata:ai_action_generate_text:generatedcontent'] = '入力プロンプトに基づいてAIモデルが生成した実際のテキストです。';
$string['privacy:metadata:ai_action_generate_text:prompt'] = 'テキスト生成リクエストのプロンプトです。';
$string['privacy:metadata:ai_action_generate_text:prompttokens'] = 'テキストを生成するために使用されるプロンプトトークンです。';
$string['privacy:metadata:ai_action_generate_text:responseid'] = 'レスポンスのIDです。';
$string['privacy:metadata:ai_action_register'] = 'ユーザによるアクションリクエストを格納するテーブルです。';
$string['privacy:metadata:ai_action_register:actionid'] = 'アクションリクエストのIDです。';
$string['privacy:metadata:ai_action_register:actionname'] = 'リクエストのアクション名です。';
$string['privacy:metadata:ai_action_register:model'] = 'レスポンスの生成に使用されたモデルです。';
$string['privacy:metadata:ai_action_register:provider'] = 'リクエストを処理したプロバイダ名です。';
$string['privacy:metadata:ai_action_register:success'] = 'アクションリクエストの状態です。';
$string['privacy:metadata:ai_action_register:timecompleted'] = 'リクエストの完了時間です。';
$string['privacy:metadata:ai_action_register:timecreated'] = 'リクエストの作成時間です。';
$string['privacy:metadata:ai_action_register:userid'] = 'リクエストしたユーザのIDです。';
$string['privacy:metadata:ai_action_summarise_text'] = 'ユーザによる要約テキスト要求を格納するテーブルです。';
$string['privacy:metadata:ai_action_summarise_text:completiontoken'] = 'テキストを要約するために使用される完了トークンです。';
$string['privacy:metadata:ai_action_summarise_text:fingerprint'] = 'モデルおよびコンテンツの状態/バージョンを表すユニークなハッシュです。';
$string['privacy:metadata:ai_action_summarise_text:generatedcontent'] = '入力プロンプトに基づいてAIモデルが生成した実際のテキストです。';
$string['privacy:metadata:ai_action_summarise_text:prompt'] = 'テキスト要約リクエストのプロンプトです。';
$string['privacy:metadata:ai_action_summarise_text:prompttokens'] = 'テキストの要約に使われたプロンプトトークンです。';
$string['privacy:metadata:ai_action_summarise_text:responseid'] = 'レスポンスのIDです。';
$string['privacy:metadata:ai_policy_register'] = 'それぞれのユーザのAIポリシーの受け入れ状況を格納するテーブルです。';
$string['privacy:metadata:ai_policy_register:contextid'] = 'データが保存されたコンテクストのIDです。';
$string['privacy:metadata:ai_policy_register:timeaccepted'] = 'ユーザがAIポリシーを承認した時間です。';
$string['privacy:metadata:ai_policy_register:userid'] = 'データを保存したユーザのIDです。';
$string['prompttokens'] = 'プロンプトトークン';
$string['prompttokens_help'] = 'プロンプトトークンはあなたがAIモデルに送る入力を構成するテキスト単位です。長い入力はより多くのトークンを使用するため、より多くのコストがかかる可能性があります。';
$string['provider'] = 'プロバイダ';
$string['provideractionsettings'] = 'アクション';
$string['provideractionsettings_desc'] = 'あなたのサイト上で {$a} が実行できるアクションを選択および設定します。';
$string['providerinstanceactionupdated'] = '{$a} アクション設定が更新されました。';
$string['providerinstancecreated'] = '{$a} AIプロバイダインスタンスが作成されました。';
$string['providerinstancedelete'] = 'AIプロバイダインスタンスを削除する';
$string['providerinstancedeleteconfirm'] = 'あなたはAIプロバイダインスタンス「 {$a->name} ({$a->provider}) 」を削除しようとしています。本当によろしいですか?';
$string['providerinstancedeleted'] = '{$a} AIプロバイダインスタンスが削除されました。';
$string['providerinstancedeletefailed'] = '{$a}  AIプロバイダインスタンスを削除できません。プロバイダが使用中か、データベースに問題があります。プライベートがアクティブかどうか確認するか、データベース管理者にお問い合わせください。';
$string['providerinstancedisablefailed'] = '{$a}  AIプロバイダインスタンスを無効にできません。プロバイダが使用中か、データベースに問題があります。プライベートがアクティブかどうか確認するか、データベース管理者にお問い合わせください。';
$string['providerinstanceupdated'] = '{$a} AIプロバイダインスタンスが更新されました。';
$string['providermoveddown'] = '{$a} が下に移動しました。';
$string['providermovedup'] = '{$a} が上に移動しました。';
$string['providername'] = 'インスタンス名';
$string['providers'] = 'プロバイダ';
$string['providersettings'] = '設定';
$string['providertype'] = 'AIプロバイダプラグインを選択する';
$string['timegenerated'] = '生成時間';
$string['unknownvalue'] = '—';
$string['userpolicy'] = '<h4>新しいAI機能へようこそ!</h4
<p>この人工知能 (AI) 機能は外部大規模言語モデル (LLM) のみに基づいており、あなたの学習および指導体験を向上させます。あなたがこれらのAIサービス利用を開始する前にこの利用ポリシをお読みください。</p>

<h4><strong>AI生成コンテンツの精度</strong></h4>
<p>AIは有用な提案および情報を提供できますが、その正確性は異なる場合があります。提供された情報が正確で、完全で、あなたの特定の状況に適しているかどうか、常に再確認する必要があります。</p>

<h4><strong>あなたのデータの処理方法</strong></h4>
<p>このAI機能は外部の大規模言語モデル (LLM) を使用しています。あなたがこの機能を使用する場合、あなたが共有するすべての情報または個人データはそれらLLMのプライバシポリシーに従って取り扱われます。LLMがあなたのデータをどのように取り扱うかを理解するためにLLMのプライバシポリシーをお読みになることをお勧めします。さらに、あなたのAI機能との相互作用の記録が当サイトに保存される場合があります。</p>
<p>あなたのデータがどのように処理されるかについて質問がある場合、教師または学習組織にご確認ください。</p>
<p>続行することにより、あなたはこのポリシーを理解して同意したものとみなされます。</p>';
$string['userratelimit'] = 'ユーザあたりの最大リクエスト数';
$string['userratelimit_help'] = 'ユーザごとに1時間に許可されるリクエスト数です。';
