
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `moodle511`
--
-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]adminpresets`
--

CREATE TABLE `[[dbprefix]]adminpresets` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `userid` bigint NOT NULL,
  `name` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `comments` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `site` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `author` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `moodleversion` varchar(20) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `moodlerelease` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `iscore` tinyint(1) NOT NULL DEFAULT '0',
  `timecreated` bigint NOT NULL DEFAULT '0',
  `timeimported` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Table to store presets data' AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]adminpresets`
--

INSERT INTO `[[dbprefix]]adminpresets` VALUES
(1, 0, 'Starter', 'Moodle with all of the most popular features, including Assignment, Feedback, Forum, H5P, Quiz and Completion tracking.', '[[softurl]]', '', '', '', 1, [[timestamp]], 0),
(2, 0, 'Full', 'All the Starter features plus External (LTI) tool, SCORM, Workshop, Analytics, Badges, Competencies, Learning plans and lots more.', '[[softurl]]', '', '', '', 2, [[timestamp]], 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]adminpresets_app`
--

CREATE TABLE `[[dbprefix]]adminpresets_app` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `adminpresetid` bigint NOT NULL,
  `userid` bigint NOT NULL,
  `time` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]admiapp_adm_ix` (`adminpresetid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Applied presets';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]adminpresets_app_it`
--

CREATE TABLE `[[dbprefix]]adminpresets_app_it` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `adminpresetapplyid` bigint NOT NULL,
  `configlogid` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]admiappit_con_ix` (`configlogid`),
  KEY `[[dbprefix]]admiappit_adm_ix` (`adminpresetapplyid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Admin presets applied items. To maintain the relation with c';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]adminpresets_app_it_a`
--

CREATE TABLE `[[dbprefix]]adminpresets_app_it_a` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `adminpresetapplyid` bigint NOT NULL,
  `configlogid` bigint NOT NULL,
  `itemname` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]admiappita_con_ix` (`configlogid`),
  KEY `[[dbprefix]]admiappita_adm_ix` (`adminpresetapplyid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Attributes of the applied items';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]adminpresets_app_plug`
--

CREATE TABLE `[[dbprefix]]adminpresets_app_plug` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `adminpresetapplyid` bigint NOT NULL,
  `plugin` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `name` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `value` smallint NOT NULL DEFAULT '0',
  `oldvalue` smallint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]admiappplug_adm_ix` (`adminpresetapplyid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Admin presets plugins applied';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]adminpresets_it`
--

CREATE TABLE `[[dbprefix]]adminpresets_it` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `adminpresetid` bigint NOT NULL,
  `plugin` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `name` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `value` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]admiit_adm_ix` (`adminpresetid`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Table to store settings' AUTO_INCREMENT=23 ;

--
-- Dumping data for table `[[dbprefix]]adminpresets_it`
--

INSERT INTO `[[dbprefix]]adminpresets_it` VALUES
(1, 1, 'none', 'usecomments', '0'),
(2, 1, 'none', 'usetags', '0'),
(3, 1, 'none', 'enablenotes', '0'),
(4, 1, 'none', 'enableblogs', '0'),
(5, 1, 'none', 'enablebadges', '0'),
(6, 1, 'none', 'enableanalytics', '0'),
(7, 1, 'core_competency', 'enabled', '0'),
(8, 1, 'core_competency', 'pushcourseratingstouserplans', '0'),
(9, 1, 'tool_dataprivacy', 'showdataretentionsummary', '0'),
(10, 1, 'none', 'forum_maxattachments', '3'),
(11, 1, 'none', 'guestloginbutton', '0'),
(12, 2, 'none', 'usecomments', '1'),
(13, 2, 'none', 'usetags', '1'),
(14, 2, 'none', 'enablenotes', '1'),
(15, 2, 'none', 'enableblogs', '1'),
(16, 2, 'none', 'enablebadges', '1'),
(17, 2, 'none', 'enableanalytics', '0'),
(18, 2, 'core_competency', 'enabled', '1'),
(19, 2, 'core_competency', 'pushcourseratingstouserplans', '1'),
(20, 2, 'tool_dataprivacy', 'showdataretentionsummary', '1'),
(21, 2, 'none', 'forum_maxattachments', '9'),
(22, 2, 'none', 'guestloginbutton', '1');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]adminpresets_it_a`
--

CREATE TABLE `[[dbprefix]]adminpresets_it_a` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `itemid` bigint NOT NULL,
  `name` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `value` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]admiita_ite_ix` (`itemid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Admin presets items attributes. For settings with attributes';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]adminpresets_plug`
--

CREATE TABLE `[[dbprefix]]adminpresets_plug` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `adminpresetid` bigint NOT NULL,
  `plugin` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `name` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `enabled` smallint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]admiplug_adm_ix` (`adminpresetid`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Admin presets plugins status, to store information about whe' AUTO_INCREMENT=106 ;

--
-- Dumping data for table `[[dbprefix]]adminpresets_plug`
--

INSERT INTO `[[dbprefix]]adminpresets_plug` VALUES
(1, 1, 'mod', 'data', 0),
(2, 1, 'mod', 'lti', 0),
(3, 1, 'mod', 'imscp', 0),
(4, 1, 'mod', 'lesson', 0),
(5, 1, 'mod', 'scorm', 0),
(6, 1, 'mod', 'wiki', 0),
(7, 1, 'mod', 'workshop', 0),
(8, 1, 'availability', 'grouping', 0),
(9, 1, 'availability', 'profile', 0),
(10, 1, 'block', 'activity_modules', 0),
(11, 1, 'block', 'blog_menu', 0),
(12, 1, 'block', 'blog_tags', 0),
(13, 1, 'block', 'comments', 0),
(14, 1, 'block', 'completionstatus', 0),
(15, 1, 'block', 'course_summary', 0),
(16, 1, 'block', 'course_list', 0),
(17, 1, 'block', 'tag_flickr', 0),
(18, 1, 'block', 'globalsearch', 0),
(19, 1, 'block', 'badges', 0),
(20, 1, 'block', 'lp', 0),
(21, 1, 'block', 'myprofile', 0),
(22, 1, 'block', 'login', 0),
(23, 1, 'block', 'site_main_menu', 0),
(24, 1, 'block', 'mentees', 0),
(25, 1, 'block', 'private_files', 0),
(26, 1, 'block', 'blog_recent', 0),
(27, 1, 'block', 'rss_client', 0),
(28, 1, 'block', 'search_forums', 0),
(29, 1, 'block', 'selfcompletion', 0),
(30, 1, 'block', 'social_activities', 0),
(31, 1, 'block', 'tags', 0),
(32, 1, 'block', 'tag_youtube', 0),
(33, 1, 'block', 'feedback', 0),
(34, 1, 'block', 'online_users', 0),
(35, 1, 'block', 'recentlyaccessedcourses', 0),
(36, 1, 'block', 'starredcourses', 0),
(37, 1, 'dataformat', 'json', 0),
(38, 1, 'enrol', 'cohort', 0),
(39, 1, 'enrol', 'guest', 0),
(40, 1, 'filter', 'mathjaxloader', -9999),
(41, 1, 'filter', 'activitynames', -9999),
(42, 1, 'qbehaviour', 'adaptivenopenalty', 0),
(43, 1, 'qbehaviour', 'deferredcbm', 0),
(44, 1, 'qbehaviour', 'immediatecbm', 0),
(45, 1, 'qtype', 'calculated', 0),
(46, 1, 'qtype', 'calculatedmulti', 0),
(47, 1, 'qtype', 'calculatedsimple', 0),
(48, 1, 'qtype', 'ddmarker', 0),
(49, 1, 'qtype', 'ddimageortext', 0),
(50, 1, 'qtype', 'multianswer', 0),
(51, 1, 'qtype', 'numerical', 0),
(52, 1, 'qtype', 'randomsamatch', 0),
(53, 1, 'repository', 'local', 0),
(54, 1, 'repository', 'url', 0),
(55, 1, 'repository', 'wikimedia', 0),
(56, 2, 'mod', 'data', 1),
(57, 2, 'mod', 'lti', 1),
(58, 2, 'mod', 'imscp', 1),
(59, 2, 'mod', 'lesson', 1),
(60, 2, 'mod', 'scorm', 1),
(61, 2, 'mod', 'wiki', 1),
(62, 2, 'mod', 'workshop', 1),
(63, 2, 'availability', 'grouping', 1),
(64, 2, 'availability', 'profile', 1),
(65, 2, 'block', 'activity_modules', 1),
(66, 2, 'block', 'blog_menu', 1),
(67, 2, 'block', 'blog_tags', 1),
(68, 2, 'block', 'comments', 1),
(69, 2, 'block', 'completionstatus', 1),
(70, 2, 'block', 'course_list', 1),
(71, 2, 'block', 'tag_flickr', 1),
(72, 2, 'block', 'globalsearch', 1),
(73, 2, 'block', 'badges', 1),
(74, 2, 'block', 'lp', 1),
(75, 2, 'block', 'myprofile', 1),
(76, 2, 'block', 'login', 1),
(77, 2, 'block', 'site_main_menu', 1),
(78, 2, 'block', 'mentees', 1),
(79, 2, 'block', 'private_files', 1),
(80, 2, 'block', 'blog_recent', 1),
(81, 2, 'block', 'search_forums', 1),
(82, 2, 'block', 'social_activities', 1),
(83, 2, 'block', 'tags', 1),
(84, 2, 'block', 'online_users', 1),
(85, 2, 'block', 'recentlyaccessedcourses', 1),
(86, 2, 'block', 'starredcourses', 1),
(87, 2, 'dataformat', 'json', 1),
(88, 2, 'enrol', 'cohort', 1),
(89, 2, 'enrol', 'guest', 1),
(90, 2, 'filter', 'mathjaxloader', 1),
(91, 2, 'filter', 'activitynames', 1),
(92, 2, 'qbehaviour', 'adaptivenopenalty', 1),
(93, 2, 'qbehaviour', 'deferredcbm', 1),
(94, 2, 'qbehaviour', 'immediatecbm', 1),
(95, 2, 'qtype', 'calculated', 1),
(96, 2, 'qtype', 'calculatedmulti', 1),
(97, 2, 'qtype', 'calculatedsimple', 1),
(98, 2, 'qtype', 'ddmarker', 1),
(99, 2, 'qtype', 'ddimageortext', 1),
(100, 2, 'qtype', 'multianswer', 1),
(101, 2, 'qtype', 'numerical', 1),
(102, 2, 'qtype', 'randomsamatch', 1),
(103, 2, 'repository', 'local', 1),
(104, 2, 'repository', 'url', 1),
(105, 2, 'repository', 'wikimedia', 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]ai_action_explain_text`
--

CREATE TABLE `[[dbprefix]]ai_action_explain_text` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `prompt` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `responseid` varchar(128) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `fingerprint` varchar(128) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `generatedcontent` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `finishreason` varchar(128) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `prompttokens` bigint DEFAULT NULL,
  `completiontoken` bigint DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores specific data about explain text actions.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]ai_action_generate_image`
--

CREATE TABLE `[[dbprefix]]ai_action_generate_image` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `prompt` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `numberimages` bigint NOT NULL,
  `quality` varchar(21) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `aspectratio` varchar(20) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `style` varchar(20) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `sourceurl` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `revisedprompt` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores specific data about generate image actions';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]ai_action_generate_text`
--

CREATE TABLE `[[dbprefix]]ai_action_generate_text` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `prompt` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `responseid` varchar(128) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `fingerprint` varchar(128) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `generatedcontent` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `finishreason` varchar(128) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `prompttokens` bigint DEFAULT NULL,
  `completiontoken` bigint DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores specific data about generate text actions.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]ai_action_register`
--

CREATE TABLE `[[dbprefix]]ai_action_register` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `actionname` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `actionid` bigint NOT NULL,
  `success` tinyint(1) NOT NULL DEFAULT '0',
  `userid` bigint NOT NULL,
  `contextid` bigint NOT NULL,
  `provider` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `errorcode` smallint DEFAULT NULL,
  `errormessage` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `timecreated` bigint NOT NULL,
  `timecompleted` bigint DEFAULT NULL,
  `model` varchar(50) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]aiactiregi_actact_uix` (`actionname`,`actionid`),
  KEY `[[dbprefix]]aiactiregi_actpro_ix` (`actionname`,`provider`),
  KEY `[[dbprefix]]aiactiregi_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores information about processed ai actions.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]ai_action_summarise_text`
--

CREATE TABLE `[[dbprefix]]ai_action_summarise_text` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `prompt` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `responseid` varchar(128) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `fingerprint` varchar(128) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `generatedcontent` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `finishreason` varchar(128) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `prompttokens` bigint DEFAULT NULL,
  `completiontoken` bigint DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores specific data about summarise text actions.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]ai_policy_register`
--

CREATE TABLE `[[dbprefix]]ai_policy_register` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `userid` bigint NOT NULL,
  `contextid` bigint NOT NULL,
  `timeaccepted` bigint NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]aipoliregi_use_uix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Register of users who have accepted this sites AI usage poli';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]ai_providers`
--

CREATE TABLE `[[dbprefix]]ai_providers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `provider` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `enabled` tinyint(1) NOT NULL DEFAULT '1',
  `config` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `actionconfig` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]aiprov_pro_ix` (`provider`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='AI provider instances';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]analytics_indicator_calc`
--

CREATE TABLE `[[dbprefix]]analytics_indicator_calc` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `starttime` bigint NOT NULL,
  `endtime` bigint NOT NULL,
  `contextid` bigint NOT NULL,
  `sampleorigin` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `sampleid` bigint NOT NULL,
  `indicator` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `value` decimal(10,2) DEFAULT NULL,
  `timecreated` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]analindicalc_staendco_ix` (`starttime`,`endtime`,`contextid`),
  KEY `[[dbprefix]]analindicalc_con_ix` (`contextid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stored indicator calculations';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]analytics_models`
--

CREATE TABLE `[[dbprefix]]analytics_models` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `enabled` tinyint(1) NOT NULL DEFAULT '0',
  `trained` tinyint(1) NOT NULL DEFAULT '0',
  `name` varchar(1333) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `target` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `indicators` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `timesplitting` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `predictionsprocessor` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `version` bigint NOT NULL,
  `contextids` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `timecreated` bigint DEFAULT NULL,
  `timemodified` bigint NOT NULL,
  `usermodified` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]analmode_enatra_ix` (`enabled`,`trained`),
  KEY `[[dbprefix]]analmode_use_ix` (`usermodified`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Analytic models.' AUTO_INCREMENT=6 ;

--
-- Dumping data for table `[[dbprefix]]analytics_models`
--

INSERT INTO `[[dbprefix]]analytics_models` VALUES
(1, 0, 0, NULL, '\\core_course\\analytics\\target\\course_dropout', '["\\\\core\\\\analytics\\\\indicator\\\\any_access_after_end","\\\\core\\\\analytics\\\\indicator\\\\any_access_before_start","\\\\core\\\\analytics\\\\indicator\\\\any_write_action_in_course","\\\\core\\\\analytics\\\\indicator\\\\read_actions","\\\\core_course\\\\analytics\\\\indicator\\\\completion_enabled","\\\\core_course\\\\analytics\\\\indicator\\\\potential_cognitive_depth","\\\\core_course\\\\analytics\\\\indicator\\\\potential_social_breadth","\\\\mod_assign\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_assign\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_book\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_book\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_choice\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_choice\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_data\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_data\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_feedback\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_feedback\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_folder\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_folder\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_forum\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_forum\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_glossary\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_glossary\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_imscp\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_imscp\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_label\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_label\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_lesson\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_lesson\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_lti\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_lti\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_page\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_page\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_quiz\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_quiz\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_resource\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_resource\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_scorm\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_scorm\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_url\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_url\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_wiki\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_wiki\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_workshop\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_workshop\\\\analytics\\\\indicator\\\\social_breadth"]', NULL, NULL, [[timestamp]], NULL, [[timestamp]], [[timestamp]], 0),
(2, 1, 1, NULL, '\\core_course\\analytics\\target\\no_teaching', '["\\\\core_course\\\\analytics\\\\indicator\\\\no_teacher","\\\\core_course\\\\analytics\\\\indicator\\\\no_student"]', '\\core\\analytics\\time_splitting\\single_range', NULL, [[timestamp]], NULL, [[timestamp]], [[timestamp]], 0),
(3, 1, 1, NULL, '\\core_user\\analytics\\target\\upcoming_activities_due', '["\\\\core_course\\\\analytics\\\\indicator\\\\activities_due"]', '\\core\\analytics\\time_splitting\\upcoming_week', NULL, [[timestamp]], NULL, [[timestamp]], [[timestamp]], 0),
(4, 1, 1, NULL, '\\core_course\\analytics\\target\\no_access_since_course_start', '["\\\\core\\\\analytics\\\\indicator\\\\any_course_access"]', '\\core\\analytics\\time_splitting\\one_month_after_start', NULL, [[timestamp]], NULL, [[timestamp]], [[timestamp]], 0),
(5, 1, 1, NULL, '\\core_course\\analytics\\target\\no_recent_accesses', '["\\\\core\\\\analytics\\\\indicator\\\\any_course_access"]', '\\core\\analytics\\time_splitting\\past_month', NULL, [[timestamp]], NULL, [[timestamp]], [[timestamp]], 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]analytics_models_log`
--

CREATE TABLE `[[dbprefix]]analytics_models_log` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `modelid` bigint NOT NULL,
  `version` bigint NOT NULL,
  `evaluationmode` varchar(50) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `target` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `indicators` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `timesplitting` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `score` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `info` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `dir` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `timecreated` bigint NOT NULL,
  `usermodified` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]analmodelog_mod_ix` (`modelid`),
  KEY `[[dbprefix]]analmodelog_use_ix` (`usermodified`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Analytic models changes during evaluation.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]analytics_predictions`
--

CREATE TABLE `[[dbprefix]]analytics_predictions` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `modelid` bigint NOT NULL,
  `contextid` bigint NOT NULL,
  `sampleid` bigint NOT NULL,
  `rangeindex` mediumint NOT NULL,
  `prediction` decimal(10,2) NOT NULL,
  `predictionscore` decimal(10,5) NOT NULL,
  `calculations` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `timecreated` bigint NOT NULL DEFAULT '0',
  `timestart` bigint DEFAULT NULL,
  `timeend` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]analpred_modcon_ix` (`modelid`,`contextid`),
  KEY `[[dbprefix]]analpred_mod_ix` (`modelid`),
  KEY `[[dbprefix]]analpred_con_ix` (`contextid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Predictions';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]analytics_prediction_actions`
--

CREATE TABLE `[[dbprefix]]analytics_prediction_actions` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `predictionid` bigint NOT NULL,
  `userid` bigint NOT NULL,
  `actionname` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `timecreated` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]analpredacti_preuseac_ix` (`predictionid`,`userid`,`actionname`),
  KEY `[[dbprefix]]analpredacti_pre_ix` (`predictionid`),
  KEY `[[dbprefix]]analpredacti_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Register of user actions over predictions.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]analytics_predict_samples`
--

CREATE TABLE `[[dbprefix]]analytics_predict_samples` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `modelid` bigint NOT NULL,
  `analysableid` bigint NOT NULL,
  `timesplitting` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `rangeindex` bigint NOT NULL,
  `sampleids` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `timecreated` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]analpredsamp_modanati_ix` (`modelid`,`analysableid`,`timesplitting`,`rangeindex`),
  KEY `[[dbprefix]]analpredsamp_mod_ix` (`modelid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Samples already used for predictions.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]analytics_train_samples`
--

CREATE TABLE `[[dbprefix]]analytics_train_samples` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `modelid` bigint NOT NULL,
  `analysableid` bigint NOT NULL,
  `timesplitting` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `sampleids` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `timecreated` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]analtraisamp_modanati_ix` (`modelid`,`analysableid`,`timesplitting`),
  KEY `[[dbprefix]]analtraisamp_mod_ix` (`modelid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Samples used for training';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]analytics_used_analysables`
--

CREATE TABLE `[[dbprefix]]analytics_used_analysables` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `modelid` bigint NOT NULL,
  `action` varchar(50) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `analysableid` bigint NOT NULL,
  `firstanalysis` bigint NOT NULL,
  `timeanalysed` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]analusedanal_modact_ix` (`modelid`,`action`),
  KEY `[[dbprefix]]analusedanal_ana_ix` (`analysableid`),
  KEY `[[dbprefix]]analusedanal_mod_ix` (`modelid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='List of analysables used by each model';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]analytics_used_files`
--

CREATE TABLE `[[dbprefix]]analytics_used_files` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `modelid` bigint NOT NULL DEFAULT '0',
  `fileid` bigint NOT NULL DEFAULT '0',
  `action` varchar(50) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `time` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]analusedfile_modactfi_ix` (`modelid`,`action`,`fileid`),
  KEY `[[dbprefix]]analusedfile_mod_ix` (`modelid`),
  KEY `[[dbprefix]]analusedfile_fil_ix` (`fileid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Files that have already been used for training and predictio';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]assign`
--

CREATE TABLE `[[dbprefix]]assign` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `course` bigint NOT NULL DEFAULT '0',
  `name` varchar(1333) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `intro` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `introformat` smallint NOT NULL DEFAULT '0',
  `alwaysshowdescription` tinyint NOT NULL DEFAULT '0',
  `nosubmissions` tinyint NOT NULL DEFAULT '0',
  `submissiondrafts` tinyint NOT NULL DEFAULT '0',
  `sendnotifications` tinyint NOT NULL DEFAULT '0',
  `sendlatenotifications` tinyint NOT NULL DEFAULT '0',
  `duedate` bigint NOT NULL DEFAULT '0',
  `allowsubmissionsfromdate` bigint NOT NULL DEFAULT '0',
  `grade` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  `requiresubmissionstatement` tinyint NOT NULL DEFAULT '0',
  `completionsubmit` tinyint NOT NULL DEFAULT '0',
  `cutoffdate` bigint NOT NULL DEFAULT '0',
  `gradingduedate` bigint NOT NULL DEFAULT '0',
  `teamsubmission` tinyint NOT NULL DEFAULT '0',
  `requireallteammemberssubmit` tinyint NOT NULL DEFAULT '0',
  `teamsubmissiongroupingid` bigint NOT NULL DEFAULT '0',
  `blindmarking` tinyint NOT NULL DEFAULT '0',
  `hidegrader` tinyint NOT NULL DEFAULT '0',
  `revealidentities` tinyint NOT NULL DEFAULT '0',
  `attemptreopenmethod` varchar(10) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT 'untilpass',
  `maxattempts` mediumint NOT NULL DEFAULT '1',
  `markingworkflow` tinyint NOT NULL DEFAULT '0',
  `markingallocation` tinyint NOT NULL DEFAULT '0',
  `markinganonymous` tinyint NOT NULL DEFAULT '0',
  `sendstudentnotifications` tinyint NOT NULL DEFAULT '1',
  `preventsubmissionnotingroup` tinyint NOT NULL DEFAULT '0',
  `activity` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `activityformat` smallint NOT NULL DEFAULT '0',
  `timelimit` bigint NOT NULL DEFAULT '0',
  `submissionattachments` tinyint NOT NULL DEFAULT '0',
  `gradepenalty` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]assi_cou_ix` (`course`),
  KEY `[[dbprefix]]assi_tea_ix` (`teamsubmissiongroupingid`),
  KEY `[[dbprefix]]assi_gra_ix` (`gradepenalty`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='This table saves information about an instance of mod_assign' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]assignfeedback_comments`
--

CREATE TABLE `[[dbprefix]]assignfeedback_comments` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `assignment` bigint NOT NULL DEFAULT '0',
  `grade` bigint NOT NULL DEFAULT '0',
  `commenttext` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `commentformat` smallint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]assicomm_ass_ix` (`assignment`),
  KEY `[[dbprefix]]assicomm_gra_ix` (`grade`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Text feedback for submitted assignments';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]assignfeedback_editpdf_annot`
--

CREATE TABLE `[[dbprefix]]assignfeedback_editpdf_annot` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `gradeid` bigint NOT NULL DEFAULT '0',
  `pageno` bigint NOT NULL DEFAULT '0',
  `x` bigint DEFAULT '0',
  `y` bigint DEFAULT '0',
  `endx` bigint DEFAULT '0',
  `endy` bigint DEFAULT '0',
  `path` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `type` varchar(10) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT 'line',
  `colour` varchar(10) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT 'black',
  `draft` tinyint NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]assieditanno_grapag_ix` (`gradeid`,`pageno`),
  KEY `[[dbprefix]]assieditanno_gra_ix` (`gradeid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='stores annotations added to pdfs submitted by students';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]assignfeedback_editpdf_cmnt`
--

CREATE TABLE `[[dbprefix]]assignfeedback_editpdf_cmnt` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `gradeid` bigint NOT NULL DEFAULT '0',
  `x` bigint DEFAULT '0',
  `y` bigint DEFAULT '0',
  `width` bigint DEFAULT '120',
  `rawtext` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `pageno` bigint NOT NULL DEFAULT '0',
  `colour` varchar(10) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT 'black',
  `draft` tinyint NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]assieditcmnt_grapag_ix` (`gradeid`,`pageno`),
  KEY `[[dbprefix]]assieditcmnt_gra_ix` (`gradeid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores comments added to pdfs';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]assignfeedback_editpdf_quick`
--

CREATE TABLE `[[dbprefix]]assignfeedback_editpdf_quick` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `userid` bigint NOT NULL DEFAULT '0',
  `rawtext` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `width` bigint NOT NULL DEFAULT '120',
  `colour` varchar(10) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT 'yellow',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]assieditquic_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores teacher specified quicklist comments';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]assignfeedback_editpdf_rot`
--

CREATE TABLE `[[dbprefix]]assignfeedback_editpdf_rot` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `gradeid` bigint NOT NULL DEFAULT '0',
  `pageno` bigint NOT NULL DEFAULT '0',
  `pathnamehash` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `isrotated` tinyint(1) NOT NULL DEFAULT '0',
  `degree` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]assieditrot_grapag_uix` (`gradeid`,`pageno`),
  KEY `[[dbprefix]]assieditrot_gra_ix` (`gradeid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores rotation information of a page.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]assignfeedback_file`
--

CREATE TABLE `[[dbprefix]]assignfeedback_file` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `assignment` bigint NOT NULL DEFAULT '0',
  `grade` bigint NOT NULL DEFAULT '0',
  `numfiles` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]assifile_ass2_ix` (`assignment`),
  KEY `[[dbprefix]]assifile_gra_ix` (`grade`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores info about the number of files submitted by a student';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]assignsubmission_file`
--

CREATE TABLE `[[dbprefix]]assignsubmission_file` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `assignment` bigint NOT NULL DEFAULT '0',
  `submission` bigint NOT NULL DEFAULT '0',
  `numfiles` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]assifile_ass_ix` (`assignment`),
  KEY `[[dbprefix]]assifile_sub_ix` (`submission`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Info about file submissions for assignments';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]assignsubmission_onlinetext`
--

CREATE TABLE `[[dbprefix]]assignsubmission_onlinetext` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `assignment` bigint NOT NULL DEFAULT '0',
  `submission` bigint NOT NULL DEFAULT '0',
  `onlinetext` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `onlineformat` smallint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]assionli_ass_ix` (`assignment`),
  KEY `[[dbprefix]]assionli_sub_ix` (`submission`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Info about onlinetext submission';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]assign_grades`
--

CREATE TABLE `[[dbprefix]]assign_grades` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `assignment` bigint NOT NULL DEFAULT '0',
  `userid` bigint NOT NULL DEFAULT '0',
  `timecreated` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  `grader` bigint NOT NULL DEFAULT '0',
  `grade` decimal(10,5) DEFAULT '0.00000',
  `penalty` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `attemptnumber` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]assigrad_assuseatt_uix` (`assignment`,`userid`,`attemptnumber`),
  KEY `[[dbprefix]]assigrad_use_ix` (`userid`),
  KEY `[[dbprefix]]assigrad_att_ix` (`attemptnumber`),
  KEY `[[dbprefix]]assigrad_ass_ix` (`assignment`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Grading information about a single assignment submission.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]assign_overrides`
--

CREATE TABLE `[[dbprefix]]assign_overrides` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `assignid` bigint NOT NULL DEFAULT '0',
  `groupid` bigint DEFAULT NULL,
  `userid` bigint DEFAULT NULL,
  `sortorder` bigint DEFAULT NULL,
  `allowsubmissionsfromdate` bigint DEFAULT NULL,
  `duedate` bigint DEFAULT NULL,
  `cutoffdate` bigint DEFAULT NULL,
  `timelimit` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]assiover_ass_ix` (`assignid`),
  KEY `[[dbprefix]]assiover_gro_ix` (`groupid`),
  KEY `[[dbprefix]]assiover_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='The overrides to assign settings.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]assign_plugin_config`
--

CREATE TABLE `[[dbprefix]]assign_plugin_config` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `assignment` bigint NOT NULL DEFAULT '0',
  `plugin` varchar(28) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `subtype` varchar(28) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `name` varchar(28) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `value` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]assiplugconf_plu_ix` (`plugin`),
  KEY `[[dbprefix]]assiplugconf_sub_ix` (`subtype`),
  KEY `[[dbprefix]]assiplugconf_nam_ix` (`name`),
  KEY `[[dbprefix]]assiplugconf_ass_ix` (`assignment`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Config data for an instance of a plugin in an assignment.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]assign_submission`
--

CREATE TABLE `[[dbprefix]]assign_submission` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `assignment` bigint NOT NULL DEFAULT '0',
  `userid` bigint NOT NULL DEFAULT '0',
  `timecreated` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  `timestarted` bigint DEFAULT NULL,
  `status` varchar(10) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `groupid` bigint NOT NULL DEFAULT '0',
  `attemptnumber` bigint NOT NULL DEFAULT '0',
  `latest` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]assisubm_assusegroat_uix` (`assignment`,`userid`,`groupid`,`attemptnumber`),
  KEY `[[dbprefix]]assisubm_use_ix` (`userid`),
  KEY `[[dbprefix]]assisubm_att_ix` (`attemptnumber`),
  KEY `[[dbprefix]]assisubm_assusegrolat_ix` (`assignment`,`userid`,`groupid`,`latest`),
  KEY `[[dbprefix]]assisubm_ass_ix` (`assignment`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='This table keeps information about student interactions with';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]assign_user_flags`
--

CREATE TABLE `[[dbprefix]]assign_user_flags` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `userid` bigint NOT NULL DEFAULT '0',
  `assignment` bigint NOT NULL DEFAULT '0',
  `locked` bigint NOT NULL DEFAULT '0',
  `mailed` smallint NOT NULL DEFAULT '0',
  `extensionduedate` bigint NOT NULL DEFAULT '0',
  `workflowstate` varchar(20) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `allocatedmarker` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]assiuserflag_mai_ix` (`mailed`),
  KEY `[[dbprefix]]assiuserflag_use_ix` (`userid`),
  KEY `[[dbprefix]]assiuserflag_ass_ix` (`assignment`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='List of flags that can be set for a single user in a single ' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]assign_user_mapping`
--

CREATE TABLE `[[dbprefix]]assign_user_mapping` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `assignment` bigint NOT NULL DEFAULT '0',
  `userid` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]assiusermapp_ass_ix` (`assignment`),
  KEY `[[dbprefix]]assiusermapp_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Map an assignment specific id number to a user' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]auth_lti_linked_login`
--

CREATE TABLE `[[dbprefix]]auth_lti_linked_login` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `userid` bigint NOT NULL,
  `issuer` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `issuer256` varchar(64) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `sub` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `sub256` varchar(64) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]authltilinklogi_usei_uix` (`userid`,`issuer256`,`sub256`),
  KEY `[[dbprefix]]authltilinklogi_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Accounts linked to a users Moodle account.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]auth_oauth2_linked_login`
--

CREATE TABLE `[[dbprefix]]auth_oauth2_linked_login` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  `usermodified` bigint NOT NULL,
  `userid` bigint NOT NULL,
  `issuerid` bigint NOT NULL,
  `username` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `email` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `confirmtoken` varchar(64) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `confirmtokenexpires` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]authoautlinklogi_use_uix` (`userid`,`issuerid`,`username`),
  KEY `[[dbprefix]]authoautlinklogi_issu_ix` (`issuerid`,`username`),
  KEY `[[dbprefix]]authoautlinklogi_use_ix` (`usermodified`),
  KEY `[[dbprefix]]authoautlinklogi_use2_ix` (`userid`),
  KEY `[[dbprefix]]authoautlinklogi_iss_ix` (`issuerid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Accounts linked to a users Moodle account.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]backup_controllers`
--

CREATE TABLE `[[dbprefix]]backup_controllers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `backupid` varchar(32) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `operation` varchar(20) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT 'backup',
  `type` varchar(10) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `itemid` bigint NOT NULL,
  `format` varchar(20) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `interactive` smallint NOT NULL,
  `purpose` smallint NOT NULL,
  `userid` bigint NOT NULL,
  `status` smallint NOT NULL,
  `execution` smallint NOT NULL,
  `executiontime` bigint NOT NULL,
  `checksum` varchar(32) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  `progress` decimal(15,14) NOT NULL DEFAULT '0.00000000000000',
  `controller` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]backcont_bac_uix` (`backupid`),
  KEY `[[dbprefix]]backcont_typite_ix` (`type`,`itemid`),
  KEY `[[dbprefix]]backcont_useite_ix` (`userid`,`itemid`),
  KEY `[[dbprefix]]backcont_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='To store the backup_controllers as they are used';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]backup_courses`
--

CREATE TABLE `[[dbprefix]]backup_courses` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `courseid` bigint NOT NULL DEFAULT '0',
  `laststarttime` bigint NOT NULL DEFAULT '0',
  `lastendtime` bigint NOT NULL DEFAULT '0',
  `laststatus` varchar(1) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '5',
  `nextstarttime` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]backcour_cou_uix` (`courseid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='To store every course backup status';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]backup_logs`
--

CREATE TABLE `[[dbprefix]]backup_logs` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `backupid` varchar(32) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `loglevel` smallint NOT NULL,
  `message` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `timecreated` bigint NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]backlogs_bacid_uix` (`backupid`,`id`),
  KEY `[[dbprefix]]backlogs_bac_ix` (`backupid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='To store all the logs from backup and restore operations (by';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]badge`
--

CREATE TABLE `[[dbprefix]]badge` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(1333) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `description` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `timecreated` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  `usercreated` bigint NOT NULL,
  `usermodified` bigint NOT NULL,
  `issuername` varchar(1333) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `issuerurl` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `issuercontact` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `expiredate` bigint DEFAULT NULL,
  `expireperiod` bigint DEFAULT NULL,
  `type` tinyint(1) NOT NULL DEFAULT '1',
  `courseid` bigint DEFAULT NULL,
  `message` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `messagesubject` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `attachment` tinyint(1) NOT NULL DEFAULT '1',
  `notification` tinyint(1) NOT NULL DEFAULT '1',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `nextcron` bigint DEFAULT NULL,
  `version` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `language` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `imagecaption` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]badg_typ_ix` (`type`),
  KEY `[[dbprefix]]badg_cou_ix` (`courseid`),
  KEY `[[dbprefix]]badg_use_ix` (`usermodified`),
  KEY `[[dbprefix]]badg_use2_ix` (`usercreated`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Defines badge' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]badge_alignment`
--

CREATE TABLE `[[dbprefix]]badge_alignment` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `badgeid` bigint NOT NULL DEFAULT '0',
  `targetname` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `targeturl` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `targetdescription` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `targetframework` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `targetcode` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]badgalig_bad_ix` (`badgeid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Defines alignment for badges';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]badge_backpack`
--

CREATE TABLE `[[dbprefix]]badge_backpack` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `userid` bigint NOT NULL DEFAULT '0',
  `email` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `backpackuid` bigint NOT NULL,
  `autosync` tinyint(1) NOT NULL DEFAULT '0',
  `password` varchar(50) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `externalbackpackid` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]badgback_useext_uix` (`userid`,`externalbackpackid`),
  KEY `[[dbprefix]]badgback_use_ix` (`userid`),
  KEY `[[dbprefix]]badgback_ext_ix` (`externalbackpackid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Defines settings for connecting external backpack' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]badge_backpack_oauth2`
--

CREATE TABLE `[[dbprefix]]badge_backpack_oauth2` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `usermodified` bigint NOT NULL DEFAULT '0',
  `timecreated` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  `userid` bigint NOT NULL,
  `issuerid` bigint NOT NULL,
  `externalbackpackid` bigint NOT NULL,
  `token` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `refreshtoken` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `expires` bigint DEFAULT NULL,
  `scope` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]badgbackoaut_use_ix` (`usermodified`),
  KEY `[[dbprefix]]badgbackoaut_use2_ix` (`userid`),
  KEY `[[dbprefix]]badgbackoaut_iss_ix` (`issuerid`),
  KEY `[[dbprefix]]badgbackoaut_ext_ix` (`externalbackpackid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Default comment for the table, please edit me';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]badge_criteria`
--

CREATE TABLE `[[dbprefix]]badge_criteria` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `badgeid` bigint NOT NULL DEFAULT '0',
  `criteriatype` bigint DEFAULT NULL,
  `method` tinyint(1) NOT NULL DEFAULT '1',
  `description` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `descriptionformat` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]badgcrit_badcri_uix` (`badgeid`,`criteriatype`),
  KEY `[[dbprefix]]badgcrit_cri_ix` (`criteriatype`),
  KEY `[[dbprefix]]badgcrit_bad_ix` (`badgeid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Defines criteria for issuing badges' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]badge_criteria_met`
--

CREATE TABLE `[[dbprefix]]badge_criteria_met` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `issuedid` bigint DEFAULT NULL,
  `critid` bigint NOT NULL,
  `userid` bigint NOT NULL,
  `datemet` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]badgcritmet_cri_ix` (`critid`),
  KEY `[[dbprefix]]badgcritmet_use_ix` (`userid`),
  KEY `[[dbprefix]]badgcritmet_iss_ix` (`issuedid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Defines criteria that were met for an issued badge';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]badge_criteria_param`
--

CREATE TABLE `[[dbprefix]]badge_criteria_param` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `critid` bigint NOT NULL,
  `name` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `value` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]badgcritpara_cri_ix` (`critid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Defines parameters for badges criteria';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]badge_endorsement`
--

CREATE TABLE `[[dbprefix]]badge_endorsement` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `badgeid` bigint NOT NULL DEFAULT '0',
  `issuername` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `issuerurl` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `issueremail` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `claimid` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `claimcomment` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `dateissued` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]badgendo_bad_ix` (`badgeid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Defines endorsement for badge';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]badge_external`
--

CREATE TABLE `[[dbprefix]]badge_external` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `backpackid` bigint NOT NULL,
  `collectionid` bigint NOT NULL,
  `entityid` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `assertion` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]badgexte_bac_ix` (`backpackid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Setting for external badges display';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]badge_external_backpack`
--

CREATE TABLE `[[dbprefix]]badge_external_backpack` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `backpackapiurl` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `backpackweburl` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `apiversion` varchar(12) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `sortorder` bigint NOT NULL DEFAULT '0',
  `oauth2_issuerid` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]badgexteback_bac_uix` (`backpackapiurl`),
  UNIQUE KEY `[[dbprefix]]badgexteback_bac2_uix` (`backpackweburl`),
  KEY `[[dbprefix]]badgexteback_oau_ix` (`oauth2_issuerid`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Defines settings for site level backpacks that a user can co' AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]badge_external_backpack`
--

INSERT INTO `[[dbprefix]]badge_external_backpack` VALUES
(1, 'https://api.badgr.io/v2', 'https://badgr.io', '2', 1, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]badge_external_identifier`
--

CREATE TABLE `[[dbprefix]]badge_external_identifier` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `sitebackpackid` bigint NOT NULL,
  `internalid` varchar(128) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `externalid` varchar(128) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `type` varchar(16) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]badgexteiden_sitinte_uix` (`sitebackpackid`,`internalid`,`externalid`,`type`),
  KEY `[[dbprefix]]badgexteiden_sit_ix` (`sitebackpackid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Setting for external badges mappings';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]badge_issued`
--

CREATE TABLE `[[dbprefix]]badge_issued` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `badgeid` bigint NOT NULL DEFAULT '0',
  `userid` bigint NOT NULL DEFAULT '0',
  `uniquehash` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `dateissued` bigint NOT NULL DEFAULT '0',
  `dateexpire` bigint DEFAULT NULL,
  `visible` tinyint(1) NOT NULL DEFAULT '0',
  `issuernotified` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]badgissu_baduse_uix` (`badgeid`,`userid`),
  KEY `[[dbprefix]]badgissu_bad_ix` (`badgeid`),
  KEY `[[dbprefix]]badgissu_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Defines issued badges';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]badge_manual_award`
--

CREATE TABLE `[[dbprefix]]badge_manual_award` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `badgeid` bigint NOT NULL,
  `recipientid` bigint NOT NULL,
  `issuerid` bigint NOT NULL,
  `issuerrole` bigint NOT NULL,
  `datemet` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]badgmanuawar_bad_ix` (`badgeid`),
  KEY `[[dbprefix]]badgmanuawar_rec_ix` (`recipientid`),
  KEY `[[dbprefix]]badgmanuawar_iss_ix` (`issuerid`),
  KEY `[[dbprefix]]badgmanuawar_iss2_ix` (`issuerrole`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Track manual award criteria for badges';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]badge_related`
--

CREATE TABLE `[[dbprefix]]badge_related` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `badgeid` bigint NOT NULL DEFAULT '0',
  `relatedbadgeid` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]badgrela_badrel_uix` (`badgeid`,`relatedbadgeid`),
  KEY `[[dbprefix]]badgrela_bad_ix` (`badgeid`),
  KEY `[[dbprefix]]badgrela_rel_ix` (`relatedbadgeid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Defines badge related for badges';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]bigbluebuttonbn`
--

CREATE TABLE `[[dbprefix]]bigbluebuttonbn` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `type` tinyint NOT NULL DEFAULT '0',
  `course` bigint NOT NULL DEFAULT '0',
  `name` varchar(1333) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `intro` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `introformat` smallint NOT NULL DEFAULT '1',
  `meetingid` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `moderatorpass` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `viewerpass` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `wait` tinyint(1) NOT NULL DEFAULT '0',
  `record` tinyint(1) NOT NULL DEFAULT '0',
  `recordallfromstart` tinyint(1) NOT NULL DEFAULT '0',
  `recordhidebutton` tinyint(1) NOT NULL DEFAULT '0',
  `welcome` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `voicebridge` mediumint NOT NULL DEFAULT '0',
  `openingtime` bigint NOT NULL DEFAULT '0',
  `closingtime` bigint NOT NULL DEFAULT '0',
  `timecreated` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  `presentation` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `participants` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `userlimit` smallint NOT NULL DEFAULT '0',
  `recordings_html` tinyint(1) NOT NULL DEFAULT '0',
  `recordings_deleted` tinyint(1) NOT NULL DEFAULT '1',
  `recordings_imported` tinyint(1) NOT NULL DEFAULT '0',
  `recordings_preview` tinyint(1) NOT NULL DEFAULT '0',
  `clienttype` tinyint(1) NOT NULL DEFAULT '0',
  `muteonstart` tinyint(1) NOT NULL DEFAULT '0',
  `disablecam` tinyint(1) NOT NULL DEFAULT '0',
  `disablemic` tinyint(1) NOT NULL DEFAULT '0',
  `disableprivatechat` tinyint(1) NOT NULL DEFAULT '0',
  `disablepublicchat` tinyint(1) NOT NULL DEFAULT '0',
  `disablenote` tinyint(1) NOT NULL DEFAULT '0',
  `hideuserlist` tinyint(1) NOT NULL DEFAULT '0',
  `completionattendance` int NOT NULL DEFAULT '0',
  `completionengagementchats` int NOT NULL DEFAULT '0',
  `completionengagementtalks` int NOT NULL DEFAULT '0',
  `completionengagementraisehand` int NOT NULL DEFAULT '0',
  `completionengagementpollvotes` int NOT NULL DEFAULT '0',
  `completionengagementemojis` int NOT NULL DEFAULT '0',
  `guestallowed` tinyint DEFAULT '0',
  `mustapproveuser` tinyint DEFAULT '1',
  `guestlinkuid` varchar(1024) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `guestpassword` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `showpresentation` tinyint(1) NOT NULL DEFAULT '1',
  `grade` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='The bigbluebuttonbn table to store information about a meeti';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]bigbluebuttonbn_logs`
--

CREATE TABLE `[[dbprefix]]bigbluebuttonbn_logs` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `courseid` bigint NOT NULL,
  `bigbluebuttonbnid` bigint NOT NULL,
  `userid` bigint DEFAULT NULL,
  `timecreated` bigint NOT NULL DEFAULT '0',
  `meetingid` varchar(256) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `log` varchar(32) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `meta` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]bigblogs_cou_ix` (`courseid`),
  KEY `[[dbprefix]]bigblogs_log_ix` (`log`),
  KEY `[[dbprefix]]bigblogs_coubiguselog_ix` (`courseid`,`bigbluebuttonbnid`,`userid`,`log`),
  KEY `[[dbprefix]]bigblogs_uselog_ix` (`userid`,`log`),
  KEY `[[dbprefix]]bigblogs_coubig_ix` (`courseid`,`bigbluebuttonbnid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='The bigbluebuttonbn table to store meeting activity events';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]bigbluebuttonbn_recordings`
--

CREATE TABLE `[[dbprefix]]bigbluebuttonbn_recordings` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `courseid` bigint NOT NULL,
  `bigbluebuttonbnid` bigint NOT NULL,
  `groupid` bigint DEFAULT NULL,
  `recordingid` varchar(64) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `headless` tinyint(1) NOT NULL DEFAULT '0',
  `imported` tinyint(1) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `importeddata` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `timecreated` bigint NOT NULL DEFAULT '0',
  `usermodified` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]bigbreco_cou_ix` (`courseid`),
  KEY `[[dbprefix]]bigbreco_rec_ix` (`recordingid`),
  KEY `[[dbprefix]]bigbreco_big_ix` (`bigbluebuttonbnid`),
  KEY `[[dbprefix]]bigbreco_use_ix` (`usermodified`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='The bigbluebuttonbn table to store references to recordings';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]block`
--

CREATE TABLE `[[dbprefix]]block` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(40) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `cron` bigint NOT NULL DEFAULT '0',
  `lastcron` bigint NOT NULL DEFAULT '0',
  `visible` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]bloc_nam_uix` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='contains all installed blocks' AUTO_INCREMENT=42 ;

--
-- Dumping data for table `[[dbprefix]]block`
--

INSERT INTO `[[dbprefix]]block` VALUES
(1, 'accessreview', 0, 0, 1),
(2, 'activity_modules', 0, 0, 1),
(3, 'activity_results', 0, 0, 1),
(4, 'admin_bookmarks', 0, 0, 1),
(5, 'badges', 0, 0, 1),
(6, 'blog_menu', 0, 0, 1),
(7, 'blog_recent', 0, 0, 1),
(8, 'blog_tags', 0, 0, 1),
(9, 'calendar_month', 0, 0, 1),
(10, 'calendar_upcoming', 0, 0, 1),
(11, 'comments', 0, 0, 1),
(12, 'completionstatus', 0, 0, 1),
(13, 'course_list', 0, 0, 1),
(14, 'course_summary', 0, 0, 0),
(15, 'feedback', 0, 0, 0),
(16, 'globalsearch', 0, 0, 1),
(17, 'glossary_random', 0, 0, 1),
(18, 'html', 0, 0, 1),
(19, 'login', 0, 0, 1),
(20, 'lp', 0, 0, 1),
(21, 'mentees', 0, 0, 1),
(22, 'myoverview', 0, 0, 1),
(23, 'myprofile', 0, 0, 1),
(24, 'navigation', 0, 0, 1),
(25, 'news_items', 0, 0, 1),
(26, 'online_users', 0, 0, 1),
(27, 'private_files', 0, 0, 1),
(28, 'recent_activity', 0, 0, 1),
(29, 'recentlyaccessedcourses', 0, 0, 1),
(30, 'recentlyaccesseditems', 0, 0, 1),
(31, 'rss_client', 0, 0, 0),
(32, 'search_forums', 0, 0, 1),
(33, 'selfcompletion', 0, 0, 0),
(34, 'settings', 0, 0, 1),
(35, 'site_main_menu', 0, 0, 1),
(36, 'social_activities', 0, 0, 1),
(37, 'starredcourses', 0, 0, 1),
(38, 'tag_flickr', 0, 0, 1),
(39, 'tag_youtube', 0, 0, 0),
(40, 'tags', 0, 0, 1),
(41, 'timeline', 0, 0, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]block_instances`
--

CREATE TABLE `[[dbprefix]]block_instances` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `blockname` varchar(40) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `parentcontextid` bigint NOT NULL,
  `showinsubcontexts` smallint NOT NULL,
  `requiredbytheme` smallint NOT NULL DEFAULT '0',
  `pagetypepattern` varchar(64) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `subpagepattern` varchar(16) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `defaultregion` varchar(16) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `defaultweight` bigint NOT NULL,
  `configdata` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]blocinst_parshopagsub_ix` (`parentcontextid`,`showinsubcontexts`,`pagetypepattern`,`subpagepattern`),
  KEY `[[dbprefix]]blocinst_tim_ix` (`timemodified`),
  KEY `[[dbprefix]]blocinst_blo_ix` (`blockname`),
  KEY `[[dbprefix]]blocinst_par_ix` (`parentcontextid`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='This table stores block instances. The type of block this is' AUTO_INCREMENT=9 ;

--
-- Dumping data for table `[[dbprefix]]block_instances`
--

INSERT INTO `[[dbprefix]]block_instances` VALUES
(1, 'admin_bookmarks', 1, 0, 0, 'admin-*', NULL, 'side-pre', 2, '', [[timestamp]], [[timestamp]]),
(2, 'recentlyaccesseditems', 1, 0, 0, 'my-index', '2', 'side-post', 0, '', [[timestamp]], [[timestamp]]),
(3, 'timeline', 1, 0, 0, 'my-index', '2', 'content', 0, '', [[timestamp]], [[timestamp]]),
(4, 'calendar_month', 1, 0, 0, 'my-index', '2', 'content', 1, '', [[timestamp]], [[timestamp]]),
(5, 'myoverview', 1, 0, 0, 'my-index', '3', 'content', 0, '', [[timestamp]], [[timestamp]]),
(6, 'recentlyaccesseditems', 5, 0, 0, 'my-index', '4', 'side-post', 0, '', [[timestamp]], [[timestamp]]),
(7, 'timeline', 5, 0, 0, 'my-index', '4', 'content', 0, '', [[timestamp]], [[timestamp]]),
(8, 'calendar_month', 5, 0, 0, 'my-index', '4', 'content', 1, '', [[timestamp]], [[timestamp]]);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]block_positions`
--

CREATE TABLE `[[dbprefix]]block_positions` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `blockinstanceid` bigint NOT NULL,
  `contextid` bigint NOT NULL,
  `pagetype` varchar(64) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `subpage` varchar(16) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `visible` smallint NOT NULL,
  `region` varchar(16) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `weight` bigint NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]blocposi_bloconpagsu_uix` (`blockinstanceid`,`contextid`,`pagetype`,`subpage`),
  KEY `[[dbprefix]]blocposi_blo_ix` (`blockinstanceid`),
  KEY `[[dbprefix]]blocposi_con_ix` (`contextid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores the position of a sticky block_instance on a another ' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]block_recentlyaccesseditems`
--

CREATE TABLE `[[dbprefix]]block_recentlyaccesseditems` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `courseid` bigint NOT NULL,
  `cmid` bigint NOT NULL,
  `userid` bigint NOT NULL,
  `timeaccess` bigint NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]blocrece_usecoucmi_uix` (`userid`,`courseid`,`cmid`),
  KEY `[[dbprefix]]blocrece_use_ix` (`userid`),
  KEY `[[dbprefix]]blocrece_cou_ix` (`courseid`),
  KEY `[[dbprefix]]blocrece_cmi_ix` (`cmid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Most recently accessed items accessed by a user' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]block_recent_activity`
--

CREATE TABLE `[[dbprefix]]block_recent_activity` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `courseid` bigint NOT NULL,
  `cmid` bigint NOT NULL,
  `timecreated` bigint NOT NULL,
  `userid` bigint NOT NULL,
  `action` tinyint(1) NOT NULL,
  `modname` varchar(20) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]blocreceacti_coutim_ix` (`courseid`,`timecreated`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Recent activity block';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]block_rss_client`
--

CREATE TABLE `[[dbprefix]]block_rss_client` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `userid` bigint NOT NULL DEFAULT '0',
  `title` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `preferredtitle` varchar(64) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `description` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `shared` tinyint NOT NULL DEFAULT '0',
  `url` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `skiptime` bigint NOT NULL DEFAULT '0',
  `skipuntil` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Remote news feed information. Contains the news feed id, the';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]blog_association`
--

CREATE TABLE `[[dbprefix]]blog_association` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `contextid` bigint NOT NULL,
  `blogid` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]blogasso_con_ix` (`contextid`),
  KEY `[[dbprefix]]blogasso_blo_ix` (`blogid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Associations of blog entries with courses and module instanc' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]blog_external`
--

CREATE TABLE `[[dbprefix]]blog_external` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `userid` bigint NOT NULL,
  `name` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `description` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `url` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `filtertags` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `failedlastsync` tinyint(1) NOT NULL DEFAULT '0',
  `timemodified` bigint DEFAULT NULL,
  `timefetched` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]blogexte_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='External blog links used for RSS copying of blog entries to ' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]book`
--

CREATE TABLE `[[dbprefix]]book` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `course` bigint NOT NULL DEFAULT '0',
  `name` varchar(1333) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `intro` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `introformat` smallint NOT NULL DEFAULT '0',
  `numbering` smallint NOT NULL DEFAULT '0',
  `navstyle` smallint NOT NULL DEFAULT '1',
  `customtitles` tinyint NOT NULL DEFAULT '0',
  `revision` bigint NOT NULL DEFAULT '0',
  `timecreated` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]book_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Defines book';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]book_chapters`
--

CREATE TABLE `[[dbprefix]]book_chapters` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `bookid` bigint NOT NULL DEFAULT '0',
  `pagenum` bigint NOT NULL DEFAULT '0',
  `subchapter` bigint NOT NULL DEFAULT '0',
  `title` varchar(1333) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `content` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `contentformat` smallint NOT NULL DEFAULT '0',
  `hidden` tinyint NOT NULL DEFAULT '0',
  `timecreated` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  `importsrc` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]bookchap_boo_ix` (`bookid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Defines book_chapters';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cache_filters`
--

CREATE TABLE `[[dbprefix]]cache_filters` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `filter` varchar(32) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `version` bigint NOT NULL DEFAULT '0',
  `md5key` varchar(32) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `rawtext` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `timemodified` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]cachfilt_filmd5_ix` (`filter`,`md5key`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='For keeping information about cached data' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cache_flags`
--

CREATE TABLE `[[dbprefix]]cache_flags` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `flagtype` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `name` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `timemodified` bigint NOT NULL DEFAULT '0',
  `value` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `expiry` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]cachflag_fla_ix` (`flagtype`),
  KEY `[[dbprefix]]cachflag_nam_ix` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Cache of time-sensitive flags' AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]cache_flags`
--

INSERT INTO `[[dbprefix]]cache_flags` VALUES
(1, 'userpreferenceschanged', '2', [[timestamp]], '1', [[timestamp]]);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]capabilities`
--

CREATE TABLE `[[dbprefix]]capabilities` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `captype` varchar(50) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `contextlevel` bigint NOT NULL DEFAULT '0',
  `component` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `riskbitmask` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]capa_nam_uix` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='this defines all capabilities' AUTO_INCREMENT=757 ;

--
-- Dumping data for table `[[dbprefix]]capabilities`
--

INSERT INTO `[[dbprefix]]capabilities` VALUES
(1, 'moodle/site:config', 'write', 10, 'moodle', 62),
(2, 'moodle/site:configview', 'read', 10, 'moodle', 0),
(3, 'moodle/site:readallmessages', 'read', 10, 'moodle', 8),
(4, 'moodle/site:manageallmessaging', 'write', 10, 'moodle', 8),
(5, 'moodle/site:deleteanymessage', 'write', 10, 'moodle', 32),
(6, 'moodle/site:sendmessage', 'write', 10, 'moodle', 16),
(7, 'moodle/site:senderrormessage', 'write', 10, 'moodle', 16),
(8, 'moodle/site:deleteownmessage', 'write', 10, 'moodle', 0),
(9, 'moodle/site:approvecourse', 'write', 40, 'moodle', 4),
(10, 'moodle/backup:backupcourse', 'write', 50, 'moodle', 28),
(11, 'moodle/backup:backupsection', 'write', 50, 'moodle', 28),
(12, 'moodle/backup:backupactivity', 'write', 70, 'moodle', 28),
(13, 'moodle/backup:backuptargetimport', 'read', 50, 'moodle', 28),
(14, 'moodle/backup:downloadfile', 'write', 50, 'moodle', 28),
(15, 'moodle/backup:configure', 'write', 50, 'moodle', 28),
(16, 'moodle/backup:userinfo', 'read', 50, 'moodle', 8),
(17, 'moodle/backup:anonymise', 'read', 50, 'moodle', 8),
(18, 'moodle/restore:restorecourse', 'write', 50, 'moodle', 28),
(19, 'moodle/restore:restoresection', 'write', 50, 'moodle', 28),
(20, 'moodle/restore:restoreactivity', 'write', 50, 'moodle', 28),
(21, 'moodle/restore:viewautomatedfilearea', 'write', 50, 'moodle', 28),
(22, 'moodle/restore:restoretargetimport', 'write', 50, 'moodle', 28),
(23, 'moodle/restore:uploadfile', 'write', 50, 'moodle', 28),
(24, 'moodle/restore:configure', 'write', 50, 'moodle', 28),
(25, 'moodle/restore:rolldates', 'write', 50, 'moodle', 0),
(26, 'moodle/restore:userinfo', 'write', 50, 'moodle', 30),
(27, 'moodle/restore:createuser', 'write', 10, 'moodle', 24),
(28, 'moodle/site:manageblocks', 'write', 80, 'moodle', 20),
(29, 'moodle/site:accessallgroups', 'read', 70, 'moodle', 0),
(30, 'moodle/site:viewanonymousevents', 'read', 70, 'moodle', 8),
(31, 'moodle/site:viewfullnames', 'read', 70, 'moodle', 0),
(32, 'moodle/site:viewuseridentity', 'read', 70, 'moodle', 0),
(33, 'moodle/site:viewreports', 'read', 50, 'moodle', 8),
(34, 'moodle/site:trustcontent', 'write', 70, 'moodle', 4),
(35, 'moodle/site:uploadusers', 'write', 10, 'moodle', 24),
(36, 'moodle/filter:manage', 'write', 50, 'moodle', 0),
(37, 'moodle/user:create', 'write', 10, 'moodle', 24),
(38, 'moodle/user:delete', 'write', 10, 'moodle', 40),
(39, 'moodle/user:update', 'write', 10, 'moodle', 24),
(40, 'moodle/user:viewdetails', 'read', 50, 'moodle', 0),
(41, 'moodle/user:viewprofilepictures', 'read', 10, 'moodle', 0),
(42, 'moodle/user:viewalldetails', 'read', 30, 'moodle', 8),
(43, 'moodle/user:viewlastip', 'read', 30, 'moodle', 8),
(44, 'moodle/user:viewhiddendetails', 'read', 50, 'moodle', 8),
(45, 'moodle/user:loginas', 'write', 50, 'moodle', 30),
(46, 'moodle/user:managesyspages', 'write', 10, 'moodle', 0),
(47, 'moodle/user:manageblocks', 'write', 30, 'moodle', 0),
(48, 'moodle/user:manageownblocks', 'write', 10, 'moodle', 0),
(49, 'moodle/user:manageownfiles', 'write', 10, 'moodle', 0),
(50, 'moodle/user:ignoreuserquota', 'write', 10, 'moodle', 0),
(51, 'moodle/my:configsyspages', 'write', 10, 'moodle', 0),
(52, 'moodle/role:assign', 'write', 50, 'moodle', 28),
(53, 'moodle/role:review', 'read', 50, 'moodle', 8),
(54, 'moodle/role:override', 'write', 50, 'moodle', 28),
(55, 'moodle/role:safeoverride', 'write', 50, 'moodle', 16),
(56, 'moodle/role:manage', 'write', 10, 'moodle', 28),
(57, 'moodle/role:switchroles', 'read', 50, 'moodle', 12),
(58, 'moodle/category:manage', 'write', 40, 'moodle', 4),
(59, 'moodle/category:viewcourselist', 'read', 40, 'moodle', 0),
(60, 'moodle/category:viewhiddencategories', 'read', 40, 'moodle', 0),
(61, 'moodle/cohort:manage', 'write', 40, 'moodle', 0),
(62, 'moodle/cohort:assign', 'write', 40, 'moodle', 0),
(63, 'moodle/cohort:view', 'read', 50, 'moodle', 0),
(64, 'moodle/cohort:configurecustomfields', 'write', 10, 'moodle', 16),
(65, 'moodle/group:configurecustomfields', 'write', 10, 'moodle', 16),
(66, 'moodle/course:create', 'write', 40, 'moodle', 4),
(67, 'moodle/course:creategroupconversations', 'write', 50, 'moodle', 4),
(68, 'moodle/course:request', 'write', 40, 'moodle', 0),
(69, 'moodle/course:delete', 'write', 50, 'moodle', 32),
(70, 'moodle/course:update', 'write', 50, 'moodle', 4),
(71, 'moodle/course:view', 'read', 50, 'moodle', 0),
(72, 'moodle/course:enrolreview', 'read', 50, 'moodle', 8),
(73, 'moodle/course:enrolconfig', 'write', 50, 'moodle', 8),
(74, 'moodle/course:reviewotherusers', 'read', 50, 'moodle', 0),
(75, 'moodle/course:bulkmessaging', 'write', 50, 'moodle', 16),
(76, 'moodle/course:viewhiddenuserfields', 'read', 50, 'moodle', 8),
(77, 'moodle/course:viewhiddencourses', 'read', 50, 'moodle', 0),
(78, 'moodle/course:visibility', 'write', 50, 'moodle', 0),
(79, 'moodle/course:managefiles', 'write', 50, 'moodle', 4),
(80, 'moodle/course:ignoreavailabilityrestrictions', 'read', 70, 'moodle', 0),
(81, 'moodle/course:ignorefilesizelimits', 'write', 50, 'moodle', 0),
(82, 'moodle/course:manageactivities', 'write', 70, 'moodle', 4),
(83, 'moodle/course:activityvisibility', 'write', 70, 'moodle', 0),
(84, 'moodle/course:viewhiddenactivities', 'read', 70, 'moodle', 0),
(85, 'moodle/course:viewparticipants', 'read', 50, 'moodle', 0),
(86, 'moodle/course:viewoverview', 'read', 50, 'moodle', 0),
(87, 'moodle/course:changefullname', 'write', 50, 'moodle', 4),
(88, 'moodle/course:changeshortname', 'write', 50, 'moodle', 4),
(89, 'moodle/course:changelockedcustomfields', 'write', 50, 'moodle', 16),
(90, 'moodle/course:configurecustomfields', 'write', 10, 'moodle', 16),
(91, 'moodle/course:renameroles', 'write', 50, 'moodle', 0),
(92, 'moodle/course:changeidnumber', 'write', 50, 'moodle', 4),
(93, 'moodle/course:changecategory', 'write', 50, 'moodle', 4),
(94, 'moodle/course:changesummary', 'write', 50, 'moodle', 4),
(95, 'moodle/course:setforcedlanguage', 'write', 50, 'moodle', 0),
(96, 'moodle/site:viewparticipants', 'read', 10, 'moodle', 0),
(97, 'moodle/course:isincompletionreports', 'read', 50, 'moodle', 0),
(98, 'moodle/course:viewscales', 'read', 50, 'moodle', 0),
(99, 'moodle/course:managescales', 'write', 50, 'moodle', 0),
(100, 'moodle/course:managegroups', 'write', 50, 'moodle', 4),
(101, 'moodle/course:viewhiddengroups', 'READ', 50, 'moodle', 8),
(102, 'moodle/course:reset', 'write', 50, 'moodle', 32),
(103, 'moodle/course:viewsuspendedusers', 'read', 50, 'moodle', 0),
(104, 'moodle/course:tag', 'write', 50, 'moodle', 16),
(105, 'moodle/blog:view', 'read', 10, 'moodle', 0),
(106, 'moodle/blog:search', 'read', 10, 'moodle', 0),
(107, 'moodle/blog:viewdrafts', 'read', 10, 'moodle', 8),
(108, 'moodle/blog:create', 'write', 10, 'moodle', 16),
(109, 'moodle/blog:manageentries', 'write', 10, 'moodle', 16),
(110, 'moodle/blog:manageexternal', 'write', 10, 'moodle', 16),
(111, 'moodle/calendar:manageownentries', 'write', 50, 'moodle', 16),
(112, 'moodle/calendar:managegroupentries', 'write', 50, 'moodle', 16),
(113, 'moodle/calendar:manageentries', 'write', 50, 'moodle', 16),
(114, 'moodle/user:editprofile', 'write', 30, 'moodle', 24),
(115, 'moodle/user:editownprofile', 'write', 10, 'moodle', 16),
(116, 'moodle/user:changeownpassword', 'write', 10, 'moodle', 0),
(117, 'moodle/user:readuserposts', 'read', 30, 'moodle', 0),
(118, 'moodle/user:readuserblogs', 'read', 30, 'moodle', 0),
(119, 'moodle/user:viewuseractivitiesreport', 'read', 30, 'moodle', 8),
(120, 'moodle/user:editmessageprofile', 'write', 30, 'moodle', 16),
(121, 'moodle/user:editownmessageprofile', 'write', 10, 'moodle', 0),
(122, 'moodle/question:managecategory', 'write', 50, 'moodle', 20),
(123, 'moodle/question:add', 'write', 50, 'moodle', 20),
(124, 'moodle/question:editmine', 'write', 50, 'moodle', 20),
(125, 'moodle/question:editall', 'write', 50, 'moodle', 20),
(126, 'moodle/question:viewmine', 'read', 50, 'moodle', 0),
(127, 'moodle/question:viewall', 'read', 50, 'moodle', 0),
(128, 'moodle/question:usemine', 'read', 50, 'moodle', 0),
(129, 'moodle/question:useall', 'read', 50, 'moodle', 0),
(130, 'moodle/question:movemine', 'write', 50, 'moodle', 0),
(131, 'moodle/question:moveall', 'write', 50, 'moodle', 0),
(132, 'moodle/question:config', 'write', 10, 'moodle', 2),
(133, 'moodle/question:flag', 'write', 50, 'moodle', 0),
(134, 'moodle/question:tagmine', 'write', 50, 'moodle', 0),
(135, 'moodle/question:tagall', 'write', 50, 'moodle', 0),
(136, 'moodle/site:doclinks', 'read', 10, 'moodle', 0),
(137, 'moodle/course:sectionvisibility', 'write', 50, 'moodle', 0),
(138, 'moodle/course:useremail', 'write', 50, 'moodle', 0),
(139, 'moodle/course:viewhiddensections', 'read', 50, 'moodle', 0),
(140, 'moodle/course:setcurrentsection', 'write', 50, 'moodle', 0),
(141, 'moodle/course:movesections', 'write', 50, 'moodle', 0),
(142, 'moodle/site:mnetlogintoremote', 'read', 10, 'moodle', 0),
(143, 'moodle/grade:viewall', 'read', 50, 'moodle', 8),
(144, 'moodle/grade:view', 'read', 50, 'moodle', 0),
(145, 'moodle/grade:viewhidden', 'read', 50, 'moodle', 8),
(146, 'moodle/grade:import', 'write', 50, 'moodle', 12),
(147, 'moodle/grade:export', 'read', 50, 'moodle', 8),
(148, 'moodle/grade:manage', 'write', 50, 'moodle', 12),
(149, 'moodle/grade:edit', 'write', 50, 'moodle', 12),
(150, 'moodle/grade:managegradingforms', 'write', 50, 'moodle', 12),
(151, 'moodle/grade:sharegradingforms', 'write', 10, 'moodle', 4),
(152, 'moodle/grade:managesharedforms', 'write', 10, 'moodle', 4),
(153, 'moodle/grade:manageoutcomes', 'write', 50, 'moodle', 0),
(154, 'moodle/grade:manageletters', 'write', 50, 'moodle', 0),
(155, 'moodle/grade:hide', 'write', 50, 'moodle', 0),
(156, 'moodle/grade:lock', 'write', 50, 'moodle', 0),
(157, 'moodle/grade:unlock', 'write', 50, 'moodle', 0),
(158, 'moodle/my:manageblocks', 'write', 10, 'moodle', 0),
(159, 'moodle/notes:view', 'read', 50, 'moodle', 0),
(160, 'moodle/notes:manage', 'write', 50, 'moodle', 16),
(161, 'moodle/tag:manage', 'write', 10, 'moodle', 16),
(162, 'moodle/tag:edit', 'write', 10, 'moodle', 16),
(163, 'moodle/tag:flag', 'write', 10, 'moodle', 16),
(164, 'moodle/tag:editblocks', 'write', 10, 'moodle', 0),
(165, 'moodle/block:view', 'read', 80, 'moodle', 0),
(166, 'moodle/block:edit', 'write', 80, 'moodle', 20),
(167, 'moodle/portfolio:export', 'read', 10, 'moodle', 0),
(168, 'moodle/comment:view', 'read', 50, 'moodle', 0),
(169, 'moodle/comment:post', 'write', 50, 'moodle', 24),
(170, 'moodle/comment:delete', 'write', 50, 'moodle', 32),
(171, 'moodle/webservice:createtoken', 'write', 10, 'moodle', 62),
(172, 'moodle/webservice:managealltokens', 'write', 10, 'moodle', 42),
(173, 'moodle/webservice:createmobiletoken', 'write', 10, 'moodle', 24),
(174, 'moodle/rating:view', 'read', 50, 'moodle', 0),
(175, 'moodle/rating:viewany', 'read', 50, 'moodle', 8),
(176, 'moodle/rating:viewall', 'read', 50, 'moodle', 8),
(177, 'moodle/rating:rate', 'write', 50, 'moodle', 0),
(178, 'moodle/course:markcomplete', 'write', 50, 'moodle', 0),
(179, 'moodle/course:overridecompletion', 'write', 50, 'moodle', 0),
(180, 'moodle/badges:manageglobalsettings', 'write', 10, 'moodle', 34),
(181, 'moodle/badges:viewbadges', 'read', 50, 'moodle', 0),
(182, 'moodle/badges:manageownbadges', 'write', 30, 'moodle', 0),
(183, 'moodle/badges:viewotherbadges', 'read', 30, 'moodle', 0),
(184, 'moodle/badges:earnbadge', 'write', 50, 'moodle', 0),
(185, 'moodle/badges:createbadge', 'write', 50, 'moodle', 16),
(186, 'moodle/badges:deletebadge', 'write', 50, 'moodle', 32),
(187, 'moodle/badges:configuredetails', 'write', 50, 'moodle', 16),
(188, 'moodle/badges:configurecriteria', 'write', 50, 'moodle', 4),
(189, 'moodle/badges:configuremessages', 'write', 50, 'moodle', 16),
(190, 'moodle/badges:awardbadge', 'write', 50, 'moodle', 16),
(191, 'moodle/badges:revokebadge', 'write', 50, 'moodle', 16),
(192, 'moodle/badges:viewawarded', 'read', 50, 'moodle', 8),
(193, 'moodle/site:forcelanguage', 'read', 10, 'moodle', 0),
(194, 'moodle/search:query', 'read', 10, 'moodle', 0),
(195, 'moodle/competency:competencymanage', 'write', 40, 'moodle', 0),
(196, 'moodle/competency:competencyview', 'read', 40, 'moodle', 0),
(197, 'moodle/competency:competencygrade', 'write', 50, 'moodle', 0),
(198, 'moodle/competency:coursecompetencymanage', 'write', 50, 'moodle', 0),
(199, 'moodle/competency:coursecompetencyconfigure', 'write', 70, 'moodle', 0),
(200, 'moodle/competency:coursecompetencygradable', 'read', 50, 'moodle', 0),
(201, 'moodle/competency:coursecompetencyview', 'read', 50, 'moodle', 0),
(202, 'moodle/competency:evidencedelete', 'write', 30, 'moodle', 0),
(203, 'moodle/competency:planmanage', 'write', 30, 'moodle', 0),
(204, 'moodle/competency:planmanagedraft', 'write', 30, 'moodle', 0),
(205, 'moodle/competency:planmanageown', 'write', 30, 'moodle', 0),
(206, 'moodle/competency:planmanageowndraft', 'write', 30, 'moodle', 0),
(207, 'moodle/competency:planview', 'read', 30, 'moodle', 0),
(208, 'moodle/competency:planviewdraft', 'read', 30, 'moodle', 0),
(209, 'moodle/competency:planviewown', 'read', 30, 'moodle', 0),
(210, 'moodle/competency:planviewowndraft', 'read', 30, 'moodle', 0),
(211, 'moodle/competency:planrequestreview', 'write', 30, 'moodle', 0),
(212, 'moodle/competency:planrequestreviewown', 'write', 30, 'moodle', 0),
(213, 'moodle/competency:planreview', 'write', 30, 'moodle', 0),
(214, 'moodle/competency:plancomment', 'write', 30, 'moodle', 0),
(215, 'moodle/competency:plancommentown', 'write', 30, 'moodle', 0),
(216, 'moodle/competency:usercompetencyview', 'read', 30, 'moodle', 0),
(217, 'moodle/competency:usercompetencyrequestreview', 'write', 30, 'moodle', 0),
(218, 'moodle/competency:usercompetencyrequestreviewown', 'write', 30, 'moodle', 0),
(219, 'moodle/competency:usercompetencyreview', 'write', 30, 'moodle', 0),
(220, 'moodle/competency:usercompetencycomment', 'write', 30, 'moodle', 0),
(221, 'moodle/competency:usercompetencycommentown', 'write', 30, 'moodle', 0),
(222, 'moodle/competency:templatemanage', 'write', 40, 'moodle', 0),
(223, 'moodle/analytics:listinsights', 'read', 50, 'moodle', 8),
(224, 'moodle/analytics:managemodels', 'write', 10, 'moodle', 2),
(225, 'moodle/competency:templateview', 'read', 40, 'moodle', 0),
(226, 'moodle/competency:userevidencemanage', 'write', 30, 'moodle', 0),
(227, 'moodle/competency:userevidencemanageown', 'write', 30, 'moodle', 0),
(228, 'moodle/competency:userevidenceview', 'read', 30, 'moodle', 0),
(229, 'moodle/site:maintenanceaccess', 'write', 10, 'moodle', 0),
(230, 'moodle/site:messageanyuser', 'write', 10, 'moodle', 16),
(231, 'moodle/site:managecontextlocks', 'write', 70, 'moodle', 0),
(232, 'moodle/course:togglecompletion', 'write', 70, 'moodle', 0),
(233, 'moodle/analytics:listowninsights', 'read', 10, 'moodle', 0),
(234, 'moodle/h5p:setdisplayoptions', 'write', 70, 'moodle', 0),
(235, 'moodle/h5p:deploy', 'write', 70, 'moodle', 4),
(236, 'moodle/h5p:updatelibraries', 'write', 70, 'moodle', 4),
(237, 'moodle/course:recommendactivity', 'write', 10, 'moodle', 0),
(238, 'moodle/contentbank:access', 'read', 50, 'moodle', 0),
(239, 'moodle/contentbank:upload', 'write', 50, 'moodle', 16),
(240, 'moodle/contentbank:deleteanycontent', 'write', 50, 'moodle', 32),
(241, 'moodle/contentbank:deleteowncontent', 'write', 50, 'moodle', 0),
(242, 'moodle/contentbank:manageanycontent', 'write', 50, 'moodle', 32),
(243, 'moodle/contentbank:manageowncontent', 'write', 50, 'moodle', 0),
(244, 'moodle/contentbank:useeditor', 'write', 50, 'moodle', 16),
(245, 'moodle/contentbank:downloadcontent', 'read', 50, 'moodle', 0),
(246, 'moodle/contentbank:copyanycontent', 'write', 50, 'moodle', 16),
(247, 'moodle/contentbank:copycontent', 'write', 50, 'moodle', 16),
(248, 'moodle/contentbank:configurecustomfields', 'write', 50, 'moodle', 16),
(249, 'moodle/contentbank:changelockedcustomfields', 'write', 50, 'moodle', 16),
(250, 'moodle/course:downloadcoursecontent', 'read', 50, 'moodle', 0),
(251, 'moodle/course:configuredownloadcontent', 'write', 50, 'moodle', 0),
(252, 'moodle/payment:manageaccounts', 'write', 50, 'moodle', 42),
(253, 'moodle/payment:viewpayments', 'read', 50, 'moodle', 8),
(254, 'moodle/contentbank:viewunlistedcontent', 'read', 50, 'moodle', 0),
(255, 'moodle/reportbuilder:view', 'read', 10, 'moodle', 0),
(256, 'moodle/reportbuilder:viewall', 'read', 10, 'moodle', 0),
(257, 'moodle/reportbuilder:edit', 'write', 10, 'moodle', 0),
(258, 'moodle/reportbuilder:editall', 'write', 10, 'moodle', 0),
(259, 'moodle/reportbuilder:configurecustomfields', 'write', 10, 'moodle', 0),
(260, 'moodle/reportbuilder:scheduleviewas', 'read', 10, 'moodle', 0),
(261, 'moodle/moodlenet:shareactivity', 'read', 50, 'moodle', 0),
(262, 'moodle/course:configurecoursecommunication', 'write', 50, 'moodle', 0),
(263, 'moodle/moodlenet:sharecourse', 'read', 50, 'moodle', 0),
(264, 'moodle/course:editcoursewelcomemessage', 'write', 50, 'moodle', 0),
(265, 'moodle/ai:fetchanyuserpolicystatus', 'write', 10, 'moodle', 0),
(266, 'moodle/ai:acceptpolicy', 'write', 10, 'moodle', 0),
(267, 'moodle/ai:fetchpolicy', 'read', 10, 'moodle', 0),
(268, 'moodle/ai:viewaipolicyacceptancereport', 'read', 10, 'moodle', 8),
(269, 'moodle/ai:viewaiusagereport', 'read', 10, 'moodle', 8),
(270, 'moodle/customfield:configureshared', 'write', 10, 'moodle', 0),
(271, 'aiplacement/courseassist:summarise_text', 'write', 50, 'aiplacement_courseassist', 0),
(272, 'aiplacement/courseassist:explain_text', 'write', 50, 'aiplacement_courseassist', 0),
(273, 'aiplacement/editor:generate_image', 'write', 50, 'aiplacement_editor', 0),
(274, 'aiplacement/editor:generate_text', 'write', 50, 'aiplacement_editor', 0),
(275, 'mod/assign:view', 'read', 70, 'mod_assign', 0),
(276, 'mod/assign:submit', 'write', 70, 'mod_assign', 0),
(277, 'mod/assign:grade', 'write', 70, 'mod_assign', 4),
(278, 'mod/assign:exportownsubmission', 'read', 70, 'mod_assign', 0),
(279, 'mod/assign:addinstance', 'write', 50, 'mod_assign', 4),
(280, 'mod/assign:editothersubmission', 'write', 70, 'mod_assign', 41),
(281, 'mod/assign:grantextension', 'write', 70, 'mod_assign', 0),
(282, 'mod/assign:revealidentities', 'write', 70, 'mod_assign', 0),
(283, 'mod/assign:reviewgrades', 'write', 70, 'mod_assign', 0),
(284, 'mod/assign:releasegrades', 'write', 70, 'mod_assign', 0),
(285, 'mod/assign:managegrades', 'write', 70, 'mod_assign', 0),
(286, 'mod/assign:manageallocations', 'write', 70, 'mod_assign', 0),
(287, 'mod/assign:viewgrades', 'read', 70, 'mod_assign', 0),
(288, 'mod/assign:viewblinddetails', 'write', 70, 'mod_assign', 8),
(289, 'mod/assign:receivegradernotifications', 'read', 70, 'mod_assign', 0),
(290, 'mod/assign:manageoverrides', 'write', 70, 'mod_assign', 0),
(291, 'mod/assign:showhiddengrader', 'read', 70, 'mod_assign', 0),
(292, 'mod/assign:viewownsubmissionsummary', 'read', 70, 'mod_assign', 0),
(293, 'mod/bigbluebuttonbn:addinstance', 'write', 50, 'mod_bigbluebuttonbn', 4),
(294, 'mod/bigbluebuttonbn:addinstancewithmeeting', 'write', 70, 'mod_bigbluebuttonbn', 0),
(295, 'mod/bigbluebuttonbn:addinstancewithrecording', 'write', 70, 'mod_bigbluebuttonbn', 0),
(296, 'mod/bigbluebuttonbn:join', 'read', 70, 'mod_bigbluebuttonbn', 0),
(297, 'mod/bigbluebuttonbn:view', 'read', 70, 'mod_bigbluebuttonbn', 0),
(298, 'mod/bigbluebuttonbn:managerecordings', 'write', 70, 'mod_bigbluebuttonbn', 0),
(299, 'mod/bigbluebuttonbn:viewallrecordingformats', 'read', 70, 'mod_bigbluebuttonbn', 0),
(300, 'mod/bigbluebuttonbn:publishrecordings', 'write', 70, 'mod_bigbluebuttonbn', 0),
(301, 'mod/bigbluebuttonbn:unpublishrecordings', 'write', 70, 'mod_bigbluebuttonbn', 0),
(302, 'mod/bigbluebuttonbn:protectrecordings', 'write', 70, 'mod_bigbluebuttonbn', 0),
(303, 'mod/bigbluebuttonbn:unprotectrecordings', 'write', 70, 'mod_bigbluebuttonbn', 0),
(304, 'mod/bigbluebuttonbn:deleterecordings', 'write', 70, 'mod_bigbluebuttonbn', 0),
(305, 'mod/bigbluebuttonbn:importrecordings', 'write', 70, 'mod_bigbluebuttonbn', 0),
(306, 'mod/bigbluebuttonbn:seepresentation', 'read', 70, 'mod_bigbluebuttonbn', 0),
(307, 'mod/book:addinstance', 'write', 50, 'mod_book', 4),
(308, 'mod/book:read', 'read', 70, 'mod_book', 0),
(309, 'mod/book:viewhiddenchapters', 'read', 70, 'mod_book', 0),
(310, 'mod/book:edit', 'write', 70, 'mod_book', 4),
(311, 'mod/choice:addinstance', 'write', 50, 'mod_choice', 4),
(312, 'mod/choice:choose', 'write', 70, 'mod_choice', 0),
(313, 'mod/choice:readresponses', 'read', 70, 'mod_choice', 0),
(314, 'mod/choice:deleteresponses', 'write', 70, 'mod_choice', 0),
(315, 'mod/choice:downloadresponses', 'read', 70, 'mod_choice', 0),
(316, 'mod/choice:view', 'read', 70, 'mod_choice', 0),
(317, 'mod/data:addinstance', 'write', 50, 'mod_data', 4),
(318, 'mod/data:viewentry', 'read', 70, 'mod_data', 0),
(319, 'mod/data:writeentry', 'write', 70, 'mod_data', 16),
(320, 'mod/data:rate', 'write', 70, 'mod_data', 0),
(321, 'mod/data:viewrating', 'read', 70, 'mod_data', 0),
(322, 'mod/data:viewanyrating', 'read', 70, 'mod_data', 8),
(323, 'mod/data:viewallratings', 'read', 70, 'mod_data', 8),
(324, 'mod/data:approve', 'write', 70, 'mod_data', 16),
(325, 'mod/data:manageentries', 'write', 70, 'mod_data', 16),
(326, 'mod/data:managetemplates', 'write', 70, 'mod_data', 20),
(327, 'mod/data:viewalluserpresets', 'read', 70, 'mod_data', 0),
(328, 'mod/data:manageuserpresets', 'write', 70, 'mod_data', 20),
(329, 'mod/data:exportentry', 'read', 70, 'mod_data', 8),
(330, 'mod/data:exportownentry', 'read', 70, 'mod_data', 0),
(331, 'mod/data:exportallentries', 'read', 70, 'mod_data', 8),
(332, 'mod/data:exportuserinfo', 'read', 70, 'mod_data', 8),
(333, 'mod/data:view', 'read', 70, 'mod_data', 0),
(334, 'mod/feedback:addinstance', 'write', 50, 'mod_feedback', 4),
(335, 'mod/feedback:view', 'read', 70, 'mod_feedback', 0),
(336, 'mod/feedback:complete', 'write', 70, 'mod_feedback', 16),
(337, 'mod/feedback:viewanalysepage', 'read', 70, 'mod_feedback', 8),
(338, 'mod/feedback:deletesubmissions', 'write', 70, 'mod_feedback', 0),
(339, 'mod/feedback:mapcourse', 'write', 70, 'mod_feedback', 0),
(340, 'mod/feedback:edititems', 'write', 70, 'mod_feedback', 20),
(341, 'mod/feedback:createprivatetemplate', 'write', 70, 'mod_feedback', 16),
(342, 'mod/feedback:createpublictemplate', 'write', 70, 'mod_feedback', 16),
(343, 'mod/feedback:deletetemplate', 'write', 70, 'mod_feedback', 0),
(344, 'mod/feedback:viewreports', 'read', 70, 'mod_feedback', 8),
(345, 'mod/feedback:receivemail', 'read', 70, 'mod_feedback', 8),
(346, 'mod/folder:addinstance', 'write', 50, 'mod_folder', 4),
(347, 'mod/folder:view', 'read', 70, 'mod_folder', 0),
(348, 'mod/folder:managefiles', 'write', 70, 'mod_folder', 20),
(349, 'mod/forum:addinstance', 'write', 50, 'mod_forum', 4),
(350, 'mod/forum:viewdiscussion', 'read', 70, 'mod_forum', 0),
(351, 'mod/forum:viewhiddentimedposts', 'read', 70, 'mod_forum', 0),
(352, 'mod/forum:startdiscussion', 'write', 70, 'mod_forum', 16),
(353, 'mod/forum:replypost', 'write', 70, 'mod_forum', 16),
(354, 'mod/forum:addnews', 'write', 70, 'mod_forum', 16),
(355, 'mod/forum:replynews', 'write', 70, 'mod_forum', 16),
(356, 'mod/forum:viewrating', 'read', 70, 'mod_forum', 0),
(357, 'mod/forum:viewanyrating', 'read', 70, 'mod_forum', 8),
(358, 'mod/forum:viewallratings', 'read', 70, 'mod_forum', 8),
(359, 'mod/forum:rate', 'write', 70, 'mod_forum', 0),
(360, 'mod/forum:postprivatereply', 'write', 70, 'mod_forum', 0),
(361, 'mod/forum:readprivatereplies', 'read', 70, 'mod_forum', 0),
(362, 'mod/forum:createattachment', 'write', 70, 'mod_forum', 16),
(363, 'mod/forum:deleteownpost', 'write', 70, 'mod_forum', 0),
(364, 'mod/forum:deleteanypost', 'write', 70, 'mod_forum', 0),
(365, 'mod/forum:splitdiscussions', 'write', 70, 'mod_forum', 0),
(366, 'mod/forum:movediscussions', 'write', 70, 'mod_forum', 0),
(367, 'mod/forum:pindiscussions', 'write', 70, 'mod_forum', 0),
(368, 'mod/forum:editanypost', 'write', 70, 'mod_forum', 16),
(369, 'mod/forum:viewqandawithoutposting', 'read', 70, 'mod_forum', 0),
(370, 'mod/forum:viewsubscribers', 'read', 70, 'mod_forum', 0),
(371, 'mod/forum:managesubscriptions', 'write', 70, 'mod_forum', 16),
(372, 'mod/forum:postwithoutthrottling', 'write', 70, 'mod_forum', 16),
(373, 'mod/forum:exportdiscussion', 'read', 70, 'mod_forum', 8),
(374, 'mod/forum:exportforum', 'read', 70, 'mod_forum', 8),
(375, 'mod/forum:exportpost', 'read', 70, 'mod_forum', 8),
(376, 'mod/forum:exportownpost', 'read', 70, 'mod_forum', 8),
(377, 'mod/forum:addquestion', 'write', 70, 'mod_forum', 16),
(378, 'mod/forum:allowforcesubscribe', 'read', 70, 'mod_forum', 0),
(379, 'mod/forum:canposttomygroups', 'write', 70, 'mod_forum', 0),
(380, 'mod/forum:canoverridediscussionlock', 'write', 70, 'mod_forum', 0),
(381, 'mod/forum:canoverridecutoff', 'write', 70, 'mod_forum', 0),
(382, 'mod/forum:cantogglefavourite', 'write', 70, 'mod_forum', 0),
(383, 'mod/forum:grade', 'write', 70, 'mod_forum', 0),
(384, 'mod/forum:canmailnow', 'write', 70, 'mod_forum', 16),
(385, 'mod/glossary:addinstance', 'write', 50, 'mod_glossary', 4),
(386, 'mod/glossary:view', 'read', 70, 'mod_glossary', 0),
(387, 'mod/glossary:write', 'write', 70, 'mod_glossary', 16),
(388, 'mod/glossary:manageentries', 'write', 70, 'mod_glossary', 16),
(389, 'mod/glossary:managecategories', 'write', 70, 'mod_glossary', 16),
(390, 'mod/glossary:comment', 'write', 70, 'mod_glossary', 16),
(391, 'mod/glossary:managecomments', 'write', 70, 'mod_glossary', 16),
(392, 'mod/glossary:import', 'write', 70, 'mod_glossary', 16),
(393, 'mod/glossary:export', 'read', 70, 'mod_glossary', 0),
(394, 'mod/glossary:approve', 'write', 70, 'mod_glossary', 16),
(395, 'mod/glossary:rate', 'write', 70, 'mod_glossary', 0),
(396, 'mod/glossary:viewrating', 'read', 70, 'mod_glossary', 0),
(397, 'mod/glossary:viewanyrating', 'read', 70, 'mod_glossary', 8),
(398, 'mod/glossary:viewallratings', 'read', 70, 'mod_glossary', 8),
(399, 'mod/glossary:exportentry', 'read', 70, 'mod_glossary', 8),
(400, 'mod/glossary:exportownentry', 'read', 70, 'mod_glossary', 0),
(401, 'mod/h5pactivity:view', 'read', 70, 'mod_h5pactivity', 0),
(402, 'mod/h5pactivity:addinstance', 'write', 50, 'mod_h5pactivity', 0),
(403, 'mod/h5pactivity:submit', 'write', 70, 'mod_h5pactivity', 0),
(404, 'mod/h5pactivity:reviewattempts', 'read', 70, 'mod_h5pactivity', 0),
(405, 'mod/imscp:view', 'read', 70, 'mod_imscp', 0),
(406, 'mod/imscp:addinstance', 'write', 50, 'mod_imscp', 4),
(407, 'mod/label:addinstance', 'write', 50, 'mod_label', 4),
(408, 'mod/label:view', 'read', 70, 'mod_label', 0),
(409, 'mod/lesson:addinstance', 'write', 50, 'mod_lesson', 4),
(410, 'mod/lesson:edit', 'write', 70, 'mod_lesson', 4),
(411, 'mod/lesson:grade', 'write', 70, 'mod_lesson', 20),
(412, 'mod/lesson:viewreports', 'read', 70, 'mod_lesson', 8),
(413, 'mod/lesson:manage', 'write', 70, 'mod_lesson', 0),
(414, 'mod/lesson:manageoverrides', 'write', 70, 'mod_lesson', 0),
(415, 'mod/lesson:view', 'read', 70, 'mod_lesson', 0),
(416, 'mod/lti:view', 'read', 70, 'mod_lti', 0),
(417, 'mod/lti:addinstance', 'write', 50, 'mod_lti', 4),
(418, 'mod/lti:manage', 'write', 70, 'mod_lti', 8),
(419, 'mod/lti:admin', 'write', 70, 'mod_lti', 8),
(420, 'mod/lti:addcoursetool', 'write', 50, 'mod_lti', 0),
(421, 'mod/lti:addpreconfiguredinstance', 'write', 50, 'mod_lti', 0),
(422, 'mod/lti:requesttooladd', 'write', 50, 'mod_lti', 0),
(423, 'mod/page:view', 'read', 70, 'mod_page', 0),
(424, 'mod/page:addinstance', 'write', 50, 'mod_page', 4),
(425, 'mod/qbank:view', 'read', 70, 'mod_qbank', 0),
(426, 'mod/qbank:addinstance', 'write', 50, 'mod_qbank', 4),
(427, 'mod/quiz:view', 'read', 70, 'mod_quiz', 0),
(428, 'mod/quiz:addinstance', 'write', 50, 'mod_quiz', 4),
(429, 'mod/quiz:attempt', 'write', 70, 'mod_quiz', 16),
(430, 'mod/quiz:reviewmyattempts', 'read', 70, 'mod_quiz', 0),
(431, 'mod/quiz:manage', 'write', 70, 'mod_quiz', 16),
(432, 'mod/quiz:manageoverrides', 'write', 70, 'mod_quiz', 0),
(433, 'mod/quiz:viewoverrides', 'read', 70, 'mod_quiz', 0),
(434, 'mod/quiz:preview', 'write', 70, 'mod_quiz', 0),
(435, 'mod/quiz:grade', 'write', 70, 'mod_quiz', 20),
(436, 'mod/quiz:regrade', 'write', 70, 'mod_quiz', 16),
(437, 'mod/quiz:viewreports', 'read', 70, 'mod_quiz', 8),
(438, 'mod/quiz:deleteattempts', 'write', 70, 'mod_quiz', 32),
(439, 'mod/quiz:reopenattempts', 'write', 70, 'mod_quiz', 0),
(440, 'mod/quiz:ignoretimelimits', 'read', 70, 'mod_quiz', 0),
(441, 'mod/quiz:emailconfirmsubmission', 'read', 70, 'mod_quiz', 0),
(442, 'mod/quiz:emailnotifysubmission', 'read', 70, 'mod_quiz', 0),
(443, 'mod/quiz:emailwarnoverdue', 'read', 70, 'mod_quiz', 0),
(444, 'mod/quiz:emailnotifyattemptgraded', 'read', 70, 'mod_quiz', 0),
(445, 'mod/resource:view', 'read', 70, 'mod_resource', 0),
(446, 'mod/resource:addinstance', 'write', 50, 'mod_resource', 4),
(447, 'mod/scorm:addinstance', 'write', 50, 'mod_scorm', 4),
(448, 'mod/scorm:viewreport', 'read', 70, 'mod_scorm', 0),
(449, 'mod/scorm:skipview', 'read', 70, 'mod_scorm', 0),
(450, 'mod/scorm:savetrack', 'write', 70, 'mod_scorm', 0),
(451, 'mod/scorm:viewscores', 'read', 70, 'mod_scorm', 0),
(452, 'mod/scorm:deleteresponses', 'write', 70, 'mod_scorm', 0),
(453, 'mod/scorm:deleteownresponses', 'write', 70, 'mod_scorm', 0),
(454, 'mod/subsection:addinstance', 'write', 50, 'mod_subsection', 4),
(455, 'mod/url:view', 'read', 70, 'mod_url', 0),
(456, 'mod/url:addinstance', 'write', 50, 'mod_url', 4),
(457, 'mod/wiki:addinstance', 'write', 50, 'mod_wiki', 4),
(458, 'mod/wiki:viewpage', 'read', 70, 'mod_wiki', 0),
(459, 'mod/wiki:editpage', 'write', 70, 'mod_wiki', 16),
(460, 'mod/wiki:createpage', 'write', 70, 'mod_wiki', 16),
(461, 'mod/wiki:viewcomment', 'read', 70, 'mod_wiki', 0),
(462, 'mod/wiki:editcomment', 'write', 70, 'mod_wiki', 16),
(463, 'mod/wiki:managecomment', 'write', 70, 'mod_wiki', 0),
(464, 'mod/wiki:managefiles', 'write', 70, 'mod_wiki', 0),
(465, 'mod/wiki:overridelock', 'write', 70, 'mod_wiki', 0),
(466, 'mod/wiki:managewiki', 'write', 70, 'mod_wiki', 0),
(467, 'mod/workshop:view', 'read', 70, 'mod_workshop', 0),
(468, 'mod/workshop:addinstance', 'write', 50, 'mod_workshop', 4),
(469, 'mod/workshop:switchphase', 'write', 70, 'mod_workshop', 0),
(470, 'mod/workshop:editdimensions', 'write', 70, 'mod_workshop', 4),
(471, 'mod/workshop:submit', 'write', 70, 'mod_workshop', 0),
(472, 'mod/workshop:peerassess', 'write', 70, 'mod_workshop', 0),
(473, 'mod/workshop:manageexamples', 'write', 70, 'mod_workshop', 0),
(474, 'mod/workshop:allocate', 'write', 70, 'mod_workshop', 0),
(475, 'mod/workshop:publishsubmissions', 'write', 70, 'mod_workshop', 0),
(476, 'mod/workshop:viewauthornames', 'read', 70, 'mod_workshop', 0),
(477, 'mod/workshop:viewreviewernames', 'read', 70, 'mod_workshop', 0),
(478, 'mod/workshop:viewallsubmissions', 'read', 70, 'mod_workshop', 0),
(479, 'mod/workshop:viewpublishedsubmissions', 'read', 70, 'mod_workshop', 0),
(480, 'mod/workshop:viewauthorpublished', 'read', 70, 'mod_workshop', 0),
(481, 'mod/workshop:viewallassessments', 'read', 70, 'mod_workshop', 0),
(482, 'mod/workshop:overridegrades', 'write', 70, 'mod_workshop', 0),
(483, 'mod/workshop:ignoredeadlines', 'write', 70, 'mod_workshop', 0),
(484, 'mod/workshop:deletesubmissions', 'write', 70, 'mod_workshop', 0),
(485, 'mod/workshop:exportsubmissions', 'read', 70, 'mod_workshop', 0),
(486, 'auth/oauth2:managelinkedlogins', 'write', 30, 'auth_oauth2', 0),
(487, 'communication/matrix:moderator', 'read', 50, 'communication_matrix', 0),
(488, 'enrol/category:synchronised', 'write', 10, 'enrol_category', 0),
(489, 'enrol/category:config', 'write', 50, 'enrol_category', 0),
(490, 'enrol/cohort:config', 'write', 50, 'enrol_cohort', 0),
(491, 'enrol/cohort:unenrol', 'write', 50, 'enrol_cohort', 0),
(492, 'enrol/database:unenrol', 'write', 50, 'enrol_database', 0),
(493, 'enrol/database:config', 'write', 50, 'enrol_database', 0),
(494, 'enrol/fee:config', 'write', 50, 'enrol_fee', 0),
(495, 'enrol/fee:manage', 'write', 50, 'enrol_fee', 0),
(496, 'enrol/fee:unenrol', 'write', 50, 'enrol_fee', 0),
(497, 'enrol/fee:unenrolself', 'write', 50, 'enrol_fee', 0),
(498, 'enrol/flatfile:manage', 'write', 50, 'enrol_flatfile', 0),
(499, 'enrol/flatfile:unenrol', 'write', 50, 'enrol_flatfile', 0),
(500, 'enrol/guest:config', 'write', 50, 'enrol_guest', 0),
(501, 'enrol/imsenterprise:config', 'write', 50, 'enrol_imsenterprise', 0),
(502, 'enrol/ldap:manage', 'write', 50, 'enrol_ldap', 0),
(503, 'enrol/lti:config', 'write', 50, 'enrol_lti', 0),
(504, 'enrol/lti:unenrol', 'write', 50, 'enrol_lti', 0),
(505, 'enrol/manual:config', 'write', 50, 'enrol_manual', 0),
(506, 'enrol/manual:enrol', 'write', 50, 'enrol_manual', 0),
(507, 'enrol/manual:manage', 'write', 50, 'enrol_manual', 0),
(508, 'enrol/manual:unenrol', 'write', 50, 'enrol_manual', 0),
(509, 'enrol/manual:unenrolself', 'write', 50, 'enrol_manual', 0),
(510, 'enrol/meta:config', 'write', 50, 'enrol_meta', 0),
(511, 'enrol/meta:selectaslinked', 'read', 50, 'enrol_meta', 0),
(512, 'enrol/meta:unenrol', 'write', 50, 'enrol_meta', 0),
(513, 'enrol/paypal:config', 'write', 50, 'enrol_paypal', 0),
(514, 'enrol/paypal:manage', 'write', 50, 'enrol_paypal', 0),
(515, 'enrol/paypal:unenrol', 'write', 50, 'enrol_paypal', 0),
(516, 'enrol/paypal:unenrolself', 'write', 50, 'enrol_paypal', 0),
(517, 'enrol/self:config', 'write', 50, 'enrol_self', 0),
(518, 'enrol/self:manage', 'write', 50, 'enrol_self', 0),
(519, 'enrol/self:holdkey', 'write', 50, 'enrol_self', 0),
(520, 'enrol/self:unenrolself', 'write', 50, 'enrol_self', 0),
(521, 'enrol/self:unenrol', 'write', 50, 'enrol_self', 0),
(522, 'enrol/self:enrolself', 'write', 50, 'enrol_self', 0),
(523, 'message/airnotifier:managedevice', 'write', 10, 'message_airnotifier', 0),
(524, 'block/accessreview:addinstance', 'write', 80, 'block_accessreview', 0),
(525, 'block/accessreview:view', 'read', 80, 'block_accessreview', 0),
(526, 'block/activity_modules:addinstance', 'write', 80, 'block_activity_modules', 20),
(527, 'block/activity_results:addinstance', 'write', 80, 'block_activity_results', 20),
(528, 'block/admin_bookmarks:myaddinstance', 'write', 10, 'block_admin_bookmarks', 0),
(529, 'block/admin_bookmarks:addinstance', 'write', 80, 'block_admin_bookmarks', 20),
(530, 'block/badges:addinstance', 'read', 80, 'block_badges', 0),
(531, 'block/badges:myaddinstance', 'read', 10, 'block_badges', 8),
(532, 'block/blog_menu:addinstance', 'write', 80, 'block_blog_menu', 20),
(533, 'block/blog_recent:addinstance', 'write', 80, 'block_blog_recent', 20),
(534, 'block/blog_tags:addinstance', 'write', 80, 'block_blog_tags', 20),
(535, 'block/calendar_month:myaddinstance', 'write', 10, 'block_calendar_month', 0),
(536, 'block/calendar_month:addinstance', 'write', 80, 'block_calendar_month', 20),
(537, 'block/calendar_upcoming:myaddinstance', 'write', 10, 'block_calendar_upcoming', 0),
(538, 'block/calendar_upcoming:addinstance', 'write', 80, 'block_calendar_upcoming', 20),
(539, 'block/comments:myaddinstance', 'write', 10, 'block_comments', 0),
(540, 'block/comments:addinstance', 'write', 80, 'block_comments', 20),
(541, 'block/completionstatus:addinstance', 'write', 80, 'block_completionstatus', 20),
(542, 'block/course_list:myaddinstance', 'write', 10, 'block_course_list', 0),
(543, 'block/course_list:addinstance', 'write', 80, 'block_course_list', 20),
(544, 'block/course_summary:addinstance', 'write', 80, 'block_course_summary', 20),
(545, 'block/feedback:addinstance', 'write', 80, 'block_feedback', 20),
(546, 'block/globalsearch:myaddinstance', 'write', 10, 'block_globalsearch', 0),
(547, 'block/globalsearch:addinstance', 'write', 80, 'block_globalsearch', 0),
(548, 'block/glossary_random:myaddinstance', 'write', 10, 'block_glossary_random', 0),
(549, 'block/glossary_random:addinstance', 'write', 80, 'block_glossary_random', 20),
(550, 'block/html:myaddinstance', 'write', 10, 'block_html', 0),
(551, 'block/html:addinstance', 'write', 80, 'block_html', 20),
(552, 'block/login:addinstance', 'write', 80, 'block_login', 20),
(553, 'block/lp:addinstance', 'write', 10, 'block_lp', 0),
(554, 'block/lp:myaddinstance', 'write', 10, 'block_lp', 0),
(555, 'block/mentees:myaddinstance', 'write', 10, 'block_mentees', 0),
(556, 'block/mentees:addinstance', 'write', 80, 'block_mentees', 20),
(557, 'block/myoverview:myaddinstance', 'write', 10, 'block_myoverview', 0),
(558, 'block/myprofile:myaddinstance', 'write', 10, 'block_myprofile', 0),
(559, 'block/myprofile:addinstance', 'write', 80, 'block_myprofile', 20),
(560, 'block/navigation:myaddinstance', 'write', 10, 'block_navigation', 0),
(561, 'block/navigation:addinstance', 'write', 80, 'block_navigation', 20),
(562, 'block/news_items:myaddinstance', 'write', 10, 'block_news_items', 0),
(563, 'block/news_items:addinstance', 'write', 80, 'block_news_items', 20),
(564, 'block/online_users:myaddinstance', 'write', 10, 'block_online_users', 0),
(565, 'block/online_users:addinstance', 'write', 80, 'block_online_users', 20),
(566, 'block/online_users:viewlist', 'read', 80, 'block_online_users', 0),
(567, 'block/private_files:myaddinstance', 'write', 10, 'block_private_files', 0),
(568, 'block/private_files:addinstance', 'write', 80, 'block_private_files', 20),
(569, 'block/recent_activity:addinstance', 'write', 80, 'block_recent_activity', 20),
(570, 'block/recent_activity:viewaddupdatemodule', 'read', 50, 'block_recent_activity', 0),
(571, 'block/recent_activity:viewdeletemodule', 'read', 50, 'block_recent_activity', 0),
(572, 'block/recentlyaccessedcourses:myaddinstance', 'write', 10, 'block_recentlyaccessedcourses', 0),
(573, 'block/recentlyaccesseditems:myaddinstance', 'write', 10, 'block_recentlyaccesseditems', 0),
(574, 'block/rss_client:myaddinstance', 'write', 10, 'block_rss_client', 0),
(575, 'block/rss_client:addinstance', 'write', 80, 'block_rss_client', 20),
(576, 'block/rss_client:manageownfeeds', 'write', 80, 'block_rss_client', 0),
(577, 'block/rss_client:manageanyfeeds', 'write', 80, 'block_rss_client', 16),
(578, 'block/search_forums:addinstance', 'write', 80, 'block_search_forums', 20),
(579, 'block/selfcompletion:addinstance', 'write', 80, 'block_selfcompletion', 20),
(580, 'block/settings:myaddinstance', 'write', 10, 'block_settings', 0),
(581, 'block/settings:addinstance', 'write', 80, 'block_settings', 20),
(582, 'block/site_main_menu:addinstance', 'write', 80, 'block_site_main_menu', 20),
(583, 'block/social_activities:addinstance', 'write', 80, 'block_social_activities', 20),
(584, 'block/starredcourses:myaddinstance', 'write', 10, 'block_starredcourses', 0),
(585, 'block/tag_flickr:addinstance', 'write', 80, 'block_tag_flickr', 20),
(586, 'block/tag_youtube:addinstance', 'write', 80, 'block_tag_youtube', 20),
(587, 'block/tags:myaddinstance', 'write', 10, 'block_tags', 0),
(588, 'block/tags:addinstance', 'write', 80, 'block_tags', 20),
(589, 'block/timeline:myaddinstance', 'write', 10, 'block_timeline', 0),
(590, 'report/completion:view', 'read', 50, 'report_completion', 8),
(591, 'report/courseoverview:view', 'read', 10, 'report_courseoverview', 8),
(592, 'report/log:view', 'read', 50, 'report_log', 8),
(593, 'report/log:viewtoday', 'read', 50, 'report_log', 8),
(594, 'report/loglive:view', 'read', 50, 'report_loglive', 8),
(595, 'report/outline:view', 'read', 50, 'report_outline', 8),
(596, 'report/outline:viewuserreport', 'read', 50, 'report_outline', 8),
(597, 'report/participation:view', 'read', 50, 'report_participation', 8),
(598, 'report/performance:view', 'read', 10, 'report_performance', 2),
(599, 'report/progress:view', 'read', 50, 'report_progress', 8),
(600, 'report/questioninstances:view', 'read', 10, 'report_questioninstances', 0),
(601, 'report/security:view', 'read', 10, 'report_security', 2),
(602, 'report/stats:view', 'read', 50, 'report_stats', 8),
(603, 'report/status:view', 'read', 10, 'report_status', 2),
(604, 'report/usersessions:manageownsessions', 'write', 30, 'report_usersessions', 0),
(605, 'gradeexport/ods:view', 'read', 50, 'gradeexport_ods', 8),
(606, 'gradeexport/ods:publish', 'read', 50, 'gradeexport_ods', 8),
(607, 'gradeexport/txt:view', 'read', 50, 'gradeexport_txt', 8),
(608, 'gradeexport/txt:publish', 'read', 50, 'gradeexport_txt', 8),
(609, 'gradeexport/xls:view', 'read', 50, 'gradeexport_xls', 8),
(610, 'gradeexport/xls:publish', 'read', 50, 'gradeexport_xls', 8),
(611, 'gradeexport/xml:view', 'read', 50, 'gradeexport_xml', 8),
(612, 'gradeexport/xml:publish', 'read', 50, 'gradeexport_xml', 8),
(613, 'gradeimport/csv:view', 'write', 50, 'gradeimport_csv', 0),
(614, 'gradeimport/direct:view', 'write', 50, 'gradeimport_direct', 0),
(615, 'gradeimport/xml:view', 'write', 50, 'gradeimport_xml', 0),
(616, 'gradeimport/xml:publish', 'write', 50, 'gradeimport_xml', 0),
(617, 'gradepenalty/duedate:manage', 'write', 10, 'gradepenalty_duedate', 0),
(618, 'gradereport/grader:view', 'read', 50, 'gradereport_grader', 8),
(619, 'gradereport/history:view', 'read', 50, 'gradereport_history', 8),
(620, 'gradereport/outcomes:view', 'read', 50, 'gradereport_outcomes', 8),
(621, 'gradereport/overview:view', 'read', 50, 'gradereport_overview', 8),
(622, 'gradereport/singleview:view', 'read', 50, 'gradereport_singleview', 8),
(623, 'gradereport/summary:view', 'read', 50, 'gradereport_summary', 8),
(624, 'gradereport/user:view', 'read', 50, 'gradereport_user', 8),
(625, 'webservice/rest:use', 'read', 50, 'webservice_rest', 0),
(626, 'webservice/soap:use', 'read', 50, 'webservice_soap', 0),
(627, 'repository/areafiles:view', 'read', 70, 'repository_areafiles', 0),
(628, 'repository/contentbank:view', 'read', 70, 'repository_contentbank', 0),
(629, 'repository/contentbank:accesscoursecontent', 'read', 50, 'repository_contentbank', 0),
(630, 'repository/contentbank:accesscoursecategorycontent', 'read', 40, 'repository_contentbank', 0),
(631, 'repository/contentbank:accessgeneralcontent', 'read', 40, 'repository_contentbank', 0),
(632, 'repository/coursefiles:view', 'read', 70, 'repository_coursefiles', 0),
(633, 'repository/dropbox:view', 'read', 70, 'repository_dropbox', 0),
(634, 'repository/equella:view', 'read', 70, 'repository_equella', 0),
(635, 'repository/filesystem:view', 'read', 70, 'repository_filesystem', 0),
(636, 'repository/flickr:view', 'read', 70, 'repository_flickr', 0),
(637, 'repository/flickr_public:view', 'read', 70, 'repository_flickr_public', 0),
(638, 'repository/googledocs:view', 'read', 70, 'repository_googledocs', 0),
(639, 'repository/local:view', 'read', 70, 'repository_local', 0),
(640, 'repository/merlot:view', 'read', 70, 'repository_merlot', 0),
(641, 'repository/nextcloud:view', 'read', 70, 'repository_nextcloud', 0),
(642, 'repository/onedrive:view', 'read', 70, 'repository_onedrive', 0),
(643, 'repository/recent:view', 'read', 70, 'repository_recent', 0),
(644, 'repository/s3:view', 'read', 70, 'repository_s3', 0),
(645, 'repository/upload:view', 'read', 70, 'repository_upload', 0),
(646, 'repository/url:view', 'read', 70, 'repository_url', 0),
(647, 'repository/user:view', 'read', 70, 'repository_user', 0),
(648, 'repository/webdav:view', 'read', 70, 'repository_webdav', 0),
(649, 'repository/wikimedia:view', 'read', 70, 'repository_wikimedia', 0),
(650, 'repository/youtube:view', 'read', 70, 'repository_youtube', 0),
(651, 'moodle/question:commentmine', 'write', 50, 'qbank_comment', 0),
(652, 'moodle/question:commentall', 'write', 50, 'qbank_comment', 0),
(653, 'qbank/customfields:changelockedcustomfields', 'write', 50, 'qbank_customfields', 16),
(654, 'qbank/customfields:configurecustomfields', 'write', 10, 'qbank_customfields', 16),
(655, 'qbank/customfields:viewhiddencustomfields', 'read', 50, 'qbank_customfields', 0),
(656, 'tool/brickfield:viewcoursetools', 'read', 50, 'tool_brickfield', 8),
(657, 'tool/brickfield:viewsystemtools', 'read', 10, 'tool_brickfield', 2),
(658, 'tool/customlang:view', 'read', 10, 'tool_customlang', 2),
(659, 'tool/customlang:edit', 'write', 10, 'tool_customlang', 6),
(660, 'tool/customlang:export', 'read', 10, 'tool_customlang', 2),
(661, 'tool/dataprivacy:managedatarequests', 'write', 10, 'tool_dataprivacy', 60),
(662, 'tool/dataprivacy:requestdeleteforotheruser', 'write', 10, 'tool_dataprivacy', 60),
(663, 'tool/dataprivacy:managedataregistry', 'write', 10, 'tool_dataprivacy', 60),
(664, 'tool/dataprivacy:makedatarequestsforchildren', 'write', 30, 'tool_dataprivacy', 24),
(665, 'tool/dataprivacy:makedatadeletionrequestsforchildren', 'write', 30, 'tool_dataprivacy', 24),
(666, 'tool/dataprivacy:downloadownrequest', 'read', 30, 'tool_dataprivacy', 0),
(667, 'tool/dataprivacy:downloadallrequests', 'read', 30, 'tool_dataprivacy', 8),
(668, 'tool/dataprivacy:requestdelete', 'write', 30, 'tool_dataprivacy', 32),
(669, 'tool/lpmigrate:frameworksmigrate', 'write', 10, 'tool_lpmigrate', 0),
(670, 'tool/mfa:mfaaccess', 'write', 30, 'tool_mfa', 0),
(671, 'tool/monitor:subscribe', 'read', 50, 'tool_monitor', 8),
(672, 'tool/monitor:managerules', 'write', 50, 'tool_monitor', 4),
(673, 'tool/monitor:managetool', 'write', 10, 'tool_monitor', 4),
(674, 'tool/policy:accept', 'write', 10, 'tool_policy', 0),
(675, 'tool/policy:acceptbehalf', 'write', 30, 'tool_policy', 8),
(676, 'tool/policy:managedocs', 'write', 10, 'tool_policy', 0),
(677, 'tool/policy:viewacceptances', 'read', 10, 'tool_policy', 0),
(678, 'tool/recyclebin:deleteitems', 'write', 50, 'tool_recyclebin', 32),
(679, 'tool/recyclebin:restoreitems', 'write', 50, 'tool_recyclebin', 0),
(680, 'tool/recyclebin:viewitems', 'read', 50, 'tool_recyclebin', 0),
(681, 'tool/uploadcourse:use', 'write', 40, 'tool_uploadcourse', 16),
(682, 'tool/uploaduser:uploaduserpictures', 'write', 10, 'tool_uploaduser', 16),
(683, 'tool/usertours:managetours', 'write', 10, 'tool_usertours', 4),
(684, 'contenttype/h5p:access', 'read', 50, 'contenttype_h5p', 0),
(685, 'contenttype/h5p:upload', 'write', 50, 'contenttype_h5p', 16),
(686, 'contenttype/h5p:useeditor', 'write', 50, 'contenttype_h5p', 16),
(687, 'booktool/exportimscp:export', 'read', 70, 'booktool_exportimscp', 0),
(688, 'booktool/importhtml:import', 'write', 70, 'booktool_importhtml', 4),
(689, 'booktool/print:print', 'read', 70, 'booktool_print', 0),
(690, 'forumreport/summary:view', 'read', 70, 'forumreport_summary', 0),
(691, 'forumreport/summary:viewall', 'read', 70, 'forumreport_summary', 8),
(692, 'quiz/grading:viewstudentnames', 'read', 70, 'quiz_grading', 0),
(693, 'quiz/grading:viewidnumber', 'read', 70, 'quiz_grading', 0),
(694, 'quiz/statistics:view', 'read', 70, 'quiz_statistics', 0),
(695, 'quizaccess/seb:managetemplates', 'write', 10, 'quizaccess_seb', 0),
(696, 'quizaccess/seb:bypassseb', 'read', 70, 'quizaccess_seb', 0),
(697, 'quizaccess/seb:manage_seb_requiresafeexambrowser', 'write', 70, 'quizaccess_seb', 0),
(698, 'quizaccess/seb:manage_seb_configuremanually', 'read', 70, 'quizaccess_seb', 0),
(699, 'quizaccess/seb:manage_seb_usesebclientconfig', 'read', 70, 'quizaccess_seb', 0),
(700, 'quizaccess/seb:manage_seb_templateid', 'read', 70, 'quizaccess_seb', 0),
(701, 'quizaccess/seb:manage_filemanager_sebconfigfile', 'write', 70, 'quizaccess_seb', 0),
(702, 'quizaccess/seb:manage_seb_showsebdownloadlink', 'write', 70, 'quizaccess_seb', 0),
(703, 'quizaccess/seb:manage_seb_allowedbrowserexamkeys', 'write', 70, 'quizaccess_seb', 0),
(704, 'quizaccess/seb:manage_seb_linkquitseb', 'write', 70, 'quizaccess_seb', 0),
(705, 'quizaccess/seb:manage_seb_userconfirmquit', 'write', 70, 'quizaccess_seb', 0),
(706, 'quizaccess/seb:manage_seb_allowuserquitseb', 'write', 70, 'quizaccess_seb', 0),
(707, 'quizaccess/seb:manage_seb_quitpassword', 'write', 70, 'quizaccess_seb', 0),
(708, 'quizaccess/seb:manage_seb_allowreloadinexam', 'write', 70, 'quizaccess_seb', 0),
(709, 'quizaccess/seb:manage_seb_showsebtaskbar', 'write', 70, 'quizaccess_seb', 0),
(710, 'quizaccess/seb:manage_seb_showreloadbutton', 'write', 70, 'quizaccess_seb', 0),
(711, 'quizaccess/seb:manage_seb_showtime', 'write', 70, 'quizaccess_seb', 0),
(712, 'quizaccess/seb:manage_seb_showkeyboardlayout', 'write', 70, 'quizaccess_seb', 0),
(713, 'quizaccess/seb:manage_seb_showwificontrol', 'write', 70, 'quizaccess_seb', 0),
(714, 'quizaccess/seb:manage_seb_enableaudiocontrol', 'write', 70, 'quizaccess_seb', 0),
(715, 'quizaccess/seb:manage_seb_muteonstartup', 'write', 70, 'quizaccess_seb', 0),
(716, 'quizaccess/seb:manage_seb_allowcapturecamera', 'write', 70, 'quizaccess_seb', 0),
(717, 'quizaccess/seb:manage_seb_allowcapturemicrophone', 'write', 70, 'quizaccess_seb', 0),
(718, 'quizaccess/seb:manage_seb_allowspellchecking', 'write', 70, 'quizaccess_seb', 0),
(719, 'quizaccess/seb:manage_seb_activateurlfiltering', 'write', 70, 'quizaccess_seb', 0),
(720, 'quizaccess/seb:manage_seb_filterembeddedcontent', 'write', 70, 'quizaccess_seb', 0),
(721, 'quizaccess/seb:manage_seb_expressionsallowed', 'write', 70, 'quizaccess_seb', 0),
(722, 'quizaccess/seb:manage_seb_regexallowed', 'write', 70, 'quizaccess_seb', 0),
(723, 'quizaccess/seb:manage_seb_expressionsblocked', 'write', 70, 'quizaccess_seb', 0),
(724, 'quizaccess/seb:manage_seb_regexblocked', 'write', 70, 'quizaccess_seb', 0),
(725, 'tiny/accessibilitychecker:use', 'read', 70, 'tiny_accessibilitychecker', 0),
(726, 'tiny/autosave:use', 'read', 70, 'tiny_autosave', 0),
(727, 'tiny/equation:use', 'read', 70, 'tiny_equation', 0),
(728, 'tiny/h5p:addembed', 'write', 70, 'tiny_h5p', 0),
(729, 'tiny/h5p:use', 'read', 70, 'tiny_h5p', 0),
(730, 'tiny/html:use', 'read', 70, 'tiny_html', 0),
(731, 'tiny/link:use', 'read', 70, 'tiny_link', 0),
(732, 'tiny/media:use', 'read', 70, 'tiny_media', 0),
(733, 'tiny/noautolink:use', 'read', 70, 'tiny_noautolink', 0),
(734, 'tiny/premium:use', 'read', 70, 'tiny_premium', 0),
(735, 'tiny/premium:usea11ychecker', 'read', 70, 'tiny_premium', 0),
(736, 'tiny/premium:useadvtable', 'read', 70, 'tiny_premium', 0),
(737, 'tiny/premium:usetypography', 'read', 70, 'tiny_premium', 0),
(738, 'tiny/premium:usecasechange', 'read', 70, 'tiny_premium', 0),
(739, 'tiny/premium:usechecklist', 'read', 70, 'tiny_premium', 0),
(740, 'tiny/premium:useeditimage', 'read', 70, 'tiny_premium', 0),
(741, 'tiny/premium:useexport', 'read', 70, 'tiny_premium', 0),
(742, 'tiny/premium:usefootnotes', 'read', 70, 'tiny_premium', 0),
(743, 'tiny/premium:useformatpainter', 'read', 70, 'tiny_premium', 0),
(744, 'tiny/premium:uselinkchecker', 'read', 70, 'tiny_premium', 0),
(745, 'tiny/premium:usepageembed', 'read', 70, 'tiny_premium', 0),
(746, 'tiny/premium:usepermanentpen', 'read', 70, 'tiny_premium', 0),
(747, 'tiny/premium:usepowerpaste', 'read', 70, 'tiny_premium', 0),
(748, 'tiny/premium:usetinymcespellchecker', 'read', 70, 'tiny_premium', 0),
(749, 'tiny/premium:useautocorrect', 'read', 70, 'tiny_premium', 0),
(750, 'tiny/premium:usetableofcontents', 'read', 70, 'tiny_premium', 0),
(751, 'tiny/premium:usemath', 'read', 70, 'tiny_premium', 0),
(752, 'tiny/recordrtc:recordaudio', 'write', 70, 'tiny_recordrtc', 0),
(753, 'tiny/recordrtc:recordvideo', 'write', 70, 'tiny_recordrtc', 0),
(754, 'tiny/recordrtc:recordscreen', 'write', 70, 'tiny_recordrtc', 0),
(755, 'tiny/recordrtc:use', 'read', 70, 'tiny_recordrtc', 0),
(756, 'factor/capability:cannotpassfactor', 'read', 10, 'factor_capability', 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]choice`
--

CREATE TABLE `[[dbprefix]]choice` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `course` bigint NOT NULL DEFAULT '0',
  `name` varchar(1333) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `intro` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `introformat` smallint NOT NULL DEFAULT '0',
  `publish` tinyint NOT NULL DEFAULT '0',
  `showresults` tinyint NOT NULL DEFAULT '0',
  `display` smallint NOT NULL DEFAULT '0',
  `allowupdate` tinyint NOT NULL DEFAULT '0',
  `allowmultiple` tinyint NOT NULL DEFAULT '0',
  `showunanswered` tinyint NOT NULL DEFAULT '0',
  `includeinactive` tinyint NOT NULL DEFAULT '1',
  `limitanswers` tinyint NOT NULL DEFAULT '0',
  `timeopen` bigint NOT NULL DEFAULT '0',
  `timeclose` bigint NOT NULL DEFAULT '0',
  `showpreview` tinyint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  `completionsubmit` tinyint(1) NOT NULL DEFAULT '0',
  `showavailable` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]choi_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Available choices are stored here';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]choice_answers`
--

CREATE TABLE `[[dbprefix]]choice_answers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `choiceid` bigint NOT NULL DEFAULT '0',
  `userid` bigint NOT NULL DEFAULT '0',
  `optionid` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]choiansw_use_ix` (`userid`),
  KEY `[[dbprefix]]choiansw_cho_ix` (`choiceid`),
  KEY `[[dbprefix]]choiansw_opt_ix` (`optionid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='choices performed by users';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]choice_options`
--

CREATE TABLE `[[dbprefix]]choice_options` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `choiceid` bigint NOT NULL DEFAULT '0',
  `text` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `maxanswers` bigint DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]choiopti_cho_ix` (`choiceid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='available options to choice';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cohort`
--

CREATE TABLE `[[dbprefix]]cohort` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `contextid` bigint NOT NULL,
  `name` varchar(254) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `idnumber` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `description` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `descriptionformat` tinyint NOT NULL,
  `visible` tinyint(1) NOT NULL DEFAULT '1',
  `component` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  `theme` varchar(50) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]coho_con_ix` (`contextid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Each record represents one cohort (aka site-wide group).' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cohort_members`
--

CREATE TABLE `[[dbprefix]]cohort_members` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `cohortid` bigint NOT NULL DEFAULT '0',
  `userid` bigint NOT NULL DEFAULT '0',
  `timeadded` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]cohomemb_cohuse_uix` (`cohortid`,`userid`),
  KEY `[[dbprefix]]cohomemb_coh_ix` (`cohortid`),
  KEY `[[dbprefix]]cohomemb_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Link a user to a cohort.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]comments`
--

CREATE TABLE `[[dbprefix]]comments` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `contextid` bigint NOT NULL,
  `component` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `commentarea` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `itemid` bigint NOT NULL,
  `content` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `format` tinyint NOT NULL DEFAULT '0',
  `userid` bigint NOT NULL,
  `timecreated` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]comm_concomite_ix` (`contextid`,`commentarea`,`itemid`),
  KEY `[[dbprefix]]comm_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='moodle comments module';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]communication`
--

CREATE TABLE `[[dbprefix]]communication` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `contextid` bigint NOT NULL,
  `instanceid` bigint NOT NULL,
  `component` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `instancetype` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `provider` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `roomname` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `avatarfilename` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `avatarsynced` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]comm_con_ix` (`contextid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Communication records';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]communication_customlink`
--

CREATE TABLE `[[dbprefix]]communication_customlink` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `commid` bigint NOT NULL,
  `url` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]commcust_com_ix` (`commid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores the link associated with a custom link communication ';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]communication_user`
--

CREATE TABLE `[[dbprefix]]communication_user` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `commid` bigint NOT NULL,
  `userid` bigint NOT NULL,
  `synced` tinyint(1) NOT NULL DEFAULT '0',
  `deleted` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]commuser_com_ix` (`commid`),
  KEY `[[dbprefix]]commuser_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Communication user records mapping';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]competency`
--

CREATE TABLE `[[dbprefix]]competency` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `shortname` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `description` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `descriptionformat` smallint NOT NULL DEFAULT '0',
  `idnumber` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `competencyframeworkid` bigint NOT NULL,
  `parentid` bigint NOT NULL DEFAULT '0',
  `path` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `sortorder` bigint NOT NULL,
  `ruletype` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `ruleoutcome` tinyint NOT NULL DEFAULT '0',
  `ruleconfig` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `scaleid` bigint DEFAULT NULL,
  `scaleconfiguration` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  `usermodified` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]comp_comidn_uix` (`competencyframeworkid`,`idnumber`),
  KEY `[[dbprefix]]comp_rul_ix` (`ruleoutcome`),
  KEY `[[dbprefix]]comp_sca_ix` (`scaleid`),
  KEY `[[dbprefix]]comp_use_ix` (`usermodified`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='This table contains the master record of each competency in ';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]competency_coursecomp`
--

CREATE TABLE `[[dbprefix]]competency_coursecomp` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `courseid` bigint NOT NULL,
  `competencyid` bigint NOT NULL,
  `ruleoutcome` tinyint NOT NULL,
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  `usermodified` bigint NOT NULL,
  `sortorder` bigint NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]compcour_coucom_uix` (`courseid`,`competencyid`),
  KEY `[[dbprefix]]compcour_courul_ix` (`courseid`,`ruleoutcome`),
  KEY `[[dbprefix]]compcour_cou2_ix` (`courseid`),
  KEY `[[dbprefix]]compcour_com_ix` (`competencyid`),
  KEY `[[dbprefix]]compcour_use2_ix` (`usermodified`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Link a competency to a course.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]competency_coursecompsetting`
--

CREATE TABLE `[[dbprefix]]competency_coursecompsetting` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `courseid` bigint NOT NULL,
  `pushratingstouserplans` tinyint DEFAULT NULL,
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  `usermodified` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]compcour_cou_uix` (`courseid`),
  KEY `[[dbprefix]]compcour_use_ix` (`usermodified`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='This table contains the course specific settings for compete';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]competency_evidence`
--

CREATE TABLE `[[dbprefix]]competency_evidence` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `usercompetencyid` bigint NOT NULL,
  `contextid` bigint NOT NULL,
  `action` tinyint NOT NULL,
  `actionuserid` bigint DEFAULT NULL,
  `descidentifier` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `desccomponent` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `desca` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `url` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `grade` bigint DEFAULT NULL,
  `note` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  `usermodified` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]compevid_use_ix` (`usercompetencyid`),
  KEY `[[dbprefix]]compevid_con_ix` (`contextid`),
  KEY `[[dbprefix]]compevid_act_ix` (`actionuserid`),
  KEY `[[dbprefix]]compevid_use2_ix` (`usermodified`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='The evidence linked to a user competency';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]competency_framework`
--

CREATE TABLE `[[dbprefix]]competency_framework` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `shortname` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `contextid` bigint NOT NULL,
  `idnumber` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `description` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `descriptionformat` smallint NOT NULL DEFAULT '0',
  `scaleid` bigint DEFAULT NULL,
  `scaleconfiguration` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `visible` tinyint NOT NULL DEFAULT '1',
  `taxonomies` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  `usermodified` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]compfram_idn_uix` (`idnumber`),
  KEY `[[dbprefix]]compfram_con_ix` (`contextid`),
  KEY `[[dbprefix]]compfram_sca_ix` (`scaleid`),
  KEY `[[dbprefix]]compfram_use_ix` (`usermodified`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='List of competency frameworks.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]competency_modulecomp`
--

CREATE TABLE `[[dbprefix]]competency_modulecomp` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `cmid` bigint NOT NULL,
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  `usermodified` bigint NOT NULL,
  `sortorder` bigint NOT NULL,
  `competencyid` bigint NOT NULL,
  `ruleoutcome` tinyint NOT NULL,
  `overridegrade` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]compmodu_cmicom_uix` (`cmid`,`competencyid`),
  KEY `[[dbprefix]]compmodu_cmirul_ix` (`cmid`,`ruleoutcome`),
  KEY `[[dbprefix]]compmodu_cmi_ix` (`cmid`),
  KEY `[[dbprefix]]compmodu_com_ix` (`competencyid`),
  KEY `[[dbprefix]]compmodu_use_ix` (`usermodified`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Link a competency to a module.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]competency_plan`
--

CREATE TABLE `[[dbprefix]]competency_plan` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `description` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `descriptionformat` smallint NOT NULL DEFAULT '0',
  `userid` bigint NOT NULL,
  `templateid` bigint DEFAULT NULL,
  `origtemplateid` bigint DEFAULT NULL,
  `status` tinyint(1) NOT NULL,
  `duedate` bigint DEFAULT '0',
  `reviewerid` bigint DEFAULT NULL,
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL DEFAULT '0',
  `usermodified` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]compplan_usesta_ix` (`userid`,`status`),
  KEY `[[dbprefix]]compplan_tem_ix` (`templateid`),
  KEY `[[dbprefix]]compplan_stadue_ix` (`status`,`duedate`),
  KEY `[[dbprefix]]compplan_use_ix` (`usermodified`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Learning plans' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]competency_plancomp`
--

CREATE TABLE `[[dbprefix]]competency_plancomp` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `planid` bigint NOT NULL,
  `competencyid` bigint NOT NULL,
  `sortorder` bigint DEFAULT NULL,
  `timecreated` bigint NOT NULL,
  `timemodified` bigint DEFAULT NULL,
  `usermodified` bigint NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]compplan_placom_uix` (`planid`,`competencyid`),
  KEY `[[dbprefix]]compplan_use2_ix` (`usermodified`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Plan competencies';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]competency_relatedcomp`
--

CREATE TABLE `[[dbprefix]]competency_relatedcomp` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `competencyid` bigint NOT NULL,
  `relatedcompetencyid` bigint NOT NULL,
  `timecreated` bigint NOT NULL,
  `timemodified` bigint DEFAULT NULL,
  `usermodified` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]comprela_com_ix` (`competencyid`),
  KEY `[[dbprefix]]comprela_rel_ix` (`relatedcompetencyid`),
  KEY `[[dbprefix]]comprela_use_ix` (`usermodified`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Related competencies';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]competency_template`
--

CREATE TABLE `[[dbprefix]]competency_template` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `shortname` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `contextid` bigint NOT NULL,
  `description` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `descriptionformat` smallint NOT NULL DEFAULT '0',
  `visible` tinyint NOT NULL DEFAULT '1',
  `duedate` bigint DEFAULT NULL,
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  `usermodified` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]comptemp_con_ix` (`contextid`),
  KEY `[[dbprefix]]comptemp_use_ix` (`usermodified`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Learning plan templates.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]competency_templatecohort`
--

CREATE TABLE `[[dbprefix]]competency_templatecohort` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `templateid` bigint NOT NULL,
  `cohortid` bigint NOT NULL,
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  `usermodified` bigint NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]comptemp_temcoh_uix` (`templateid`,`cohortid`),
  KEY `[[dbprefix]]comptemp_tem2_ix` (`templateid`),
  KEY `[[dbprefix]]comptemp_use3_ix` (`usermodified`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Default comment for the table, please edit me';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]competency_templatecomp`
--

CREATE TABLE `[[dbprefix]]competency_templatecomp` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `templateid` bigint NOT NULL,
  `competencyid` bigint NOT NULL,
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  `usermodified` bigint NOT NULL,
  `sortorder` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]comptemp_tem_ix` (`templateid`),
  KEY `[[dbprefix]]comptemp_com_ix` (`competencyid`),
  KEY `[[dbprefix]]comptemp_use2_ix` (`usermodified`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Link a competency to a learning plan template.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]competency_usercomp`
--

CREATE TABLE `[[dbprefix]]competency_usercomp` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `userid` bigint NOT NULL,
  `competencyid` bigint NOT NULL,
  `status` tinyint NOT NULL DEFAULT '0',
  `reviewerid` bigint DEFAULT NULL,
  `proficiency` tinyint DEFAULT NULL,
  `grade` bigint DEFAULT NULL,
  `timecreated` bigint NOT NULL,
  `timemodified` bigint DEFAULT NULL,
  `usermodified` bigint NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]compuser_usecom_uix` (`userid`,`competencyid`),
  KEY `[[dbprefix]]compuser_use_ix` (`usermodified`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='User competencies';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]competency_usercompcourse`
--

CREATE TABLE `[[dbprefix]]competency_usercompcourse` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `userid` bigint NOT NULL,
  `courseid` bigint NOT NULL,
  `competencyid` bigint NOT NULL,
  `proficiency` tinyint DEFAULT NULL,
  `grade` bigint DEFAULT NULL,
  `timecreated` bigint NOT NULL,
  `timemodified` bigint DEFAULT NULL,
  `usermodified` bigint NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]compuser_usecoucom_uix` (`userid`,`courseid`,`competencyid`),
  KEY `[[dbprefix]]compuser_use2_ix` (`usermodified`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='User competencies in a course';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]competency_usercompplan`
--

CREATE TABLE `[[dbprefix]]competency_usercompplan` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `userid` bigint NOT NULL,
  `competencyid` bigint NOT NULL,
  `planid` bigint NOT NULL,
  `proficiency` tinyint DEFAULT NULL,
  `grade` bigint DEFAULT NULL,
  `sortorder` bigint DEFAULT NULL,
  `timecreated` bigint NOT NULL,
  `timemodified` bigint DEFAULT NULL,
  `usermodified` bigint NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]compuser_usecompla_uix` (`userid`,`competencyid`,`planid`),
  KEY `[[dbprefix]]compuser_use3_ix` (`usermodified`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='User competencies plans';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]competency_userevidence`
--

CREATE TABLE `[[dbprefix]]competency_userevidence` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `userid` bigint NOT NULL,
  `name` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `description` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `descriptionformat` tinyint(1) NOT NULL,
  `url` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  `usermodified` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]compuser_use4_ix` (`userid`),
  KEY `[[dbprefix]]compuser_use5_ix` (`usermodified`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='The evidence of prior learning';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]competency_userevidencecomp`
--

CREATE TABLE `[[dbprefix]]competency_userevidencecomp` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `userevidenceid` bigint NOT NULL,
  `competencyid` bigint NOT NULL,
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  `usermodified` bigint NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]compuser_usecom2_uix` (`userevidenceid`,`competencyid`),
  KEY `[[dbprefix]]compuser_use6_ix` (`userevidenceid`),
  KEY `[[dbprefix]]compuser_use7_ix` (`usermodified`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Relationship between user evidence and competencies';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]config`
--

CREATE TABLE `[[dbprefix]]config` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `value` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]conf_nam_uix` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Moodle configuration variables' AUTO_INCREMENT=587 ;

--
-- Dumping data for table `[[dbprefix]]config`
--

INSERT INTO `[[dbprefix]]config` VALUES
(2, 'rolesactive', '1'),
(3, 'auth', 'email'),
(4, 'enrol_plugins_enabled', 'manual,guest,self,cohort'),
(5, 'theme', 'boost'),
(6, 'filter_multilang_converted', '1'),
(7, 'siteidentifier', '[[siteidentifier]][[domhost]]'),
(8, 'backup_version', '2008111700'),
(9, 'backup_release', '2.0 dev'),
(10, 'mnet_dispatcher_mode', 'off'),
(11, 'sessiontimeout', '28800'),
(12, 'stringfilters', ''),
(13, 'filterall', '0'),
(14, 'texteditors', 'tiny,textarea'),
(15, 'antiviruses', ''),
(16, 'media_plugins_sortorder', 'videojs,youtube'),
(17, 'upgrade_extracreditweightsstepignored', '1'),
(18, 'upgrade_calculatedgradeitemsignored', '1'),
(19, 'upgrade_letterboundarycourses', '1'),
(20, 'format_plugins_sortorder', 'topics,weeks,singleactivity,social'),
(21, 'mnet_localhost_id', '1'),
(22, 'mnet_all_hosts_id', '2'),
(23, 'siteguest', '1'),
(24, 'siteadmins', '2'),
(25, 'themerev', '[[timestamp]]'),
(26, 'jsrev', '[[timestamp]]'),
(27, 'templaterev', '[[timestamp]]'),
(28, 'gdversion', '2'),
(29, 'licenses', 'unknown,allrightsreserved,public,cc-4.0,cc-nc-4.0,cc-nd-4.0,cc-nc-nd-4.0,cc-nc-sa-4.0,cc-sa-4.0'),
(30, 'sitedefaultlicense', 'unknown'),
(31, 'version', '2025100601'),
(32, 'enableuserfeedback', '0'),
(33, 'userfeedback_nextreminder', '1'),
(34, 'userfeedback_remindafter', '90'),
(35, 'enableoutcomes', '0'),
(36, 'usecomments', '1'),
(37, 'usetags', '1'),
(38, 'enablenotes', '1'),
(39, 'enableportfolios', '0'),
(40, 'enablewebservices', '0'),
(41, 'enablestats', '0'),
(42, 'enablerssfeeds', '0'),
(43, 'enableblogs', '1'),
(44, 'enablecompletion', '1'),
(45, 'enableavailability', '1'),
(46, 'enableplagiarism', '0'),
(47, 'enablebadges', '1'),
(48, 'enableglobalsearch', '0'),
(49, 'allowstealth', '0'),
(50, 'enableanalytics', '0'),
(51, 'messaging', '1'),
(52, 'enablecustomreports', '1'),
(53, 'allowemojipicker', '1'),
(54, 'userfiltersdefault', 'realname'),
(55, 'defaultpreference_maildisplay', '2'),
(56, 'defaultpreference_mailformat', '1'),
(57, 'defaultpreference_maildigest', '0'),
(58, 'defaultpreference_autosubscribe', '1'),
(59, 'defaultpreference_trackforums', '0'),
(60, 'defaultpreference_core_contentbank_visibility', '1'),
(61, 'enroladminnewcourse', '1'),
(62, 'autologinguests', '0'),
(63, 'hiddenuserfields', ''),
(64, 'showuseridentity', 'email'),
(65, 'fullnamedisplay', 'language'),
(66, 'alternativefullnameformat', 'language'),
(67, 'maxusersperpage', '100'),
(68, 'enablegravatar', '0'),
(69, 'gravatardefaulturl', 'mm'),
(70, 'agedigitalconsentverification', '0'),
(71, 'agedigitalconsentmap', '*, 16\nAT, 14\nBE, 13\nBG, 14\nCY, 14\nCZ, 15\nDK, 13\nEE, 13\nES, 14\nFI, 13\nFR, 15\nGB, 13\nGR, 15\nIT, 14\nLT, 14\nLV, 13\nMT, 13\nNO, 13\nPT, 13\nSE, 13\nUS, 13'),
(72, 'sitepolicy', ''),
(73, 'sitepolicyguest', ''),
(74, 'activitychooseractivefooter', 'tool_moodlenet'),
(75, 'enableasyncbackup', '1'),
(76, 'downloadcoursecontentallowed', '0'),
(77, 'maxsizeperdownloadcoursefile', '52428800'),
(78, 'enablecourserequests', '1'),
(79, 'defaultrequestcategory', '1'),
(80, 'lockrequestcategory', '0'),
(81, 'courserequestnotify', ''),
(82, 'grade_report_showonlyactiveenrol', '1'),
(83, 'grade_report_quickgrading', '1'),
(84, 'grade_report_meanselection', '1'),
(85, 'grade_report_showaverages', '1'),
(86, 'grade_report_showranges', '0'),
(87, 'grade_report_showuserimage', '1'),
(88, 'grade_report_shownumberofgrades', '0'),
(89, 'grade_report_averagesdisplaytype', 'inherit'),
(90, 'grade_report_rangesdisplaytype', 'inherit'),
(91, 'grade_report_averagesdecimalpoints', 'inherit'),
(92, 'grade_report_rangesdecimalpoints', 'inherit'),
(93, 'grade_report_historyperpage', '50'),
(94, 'grade_report_overview_showrank', '0'),
(95, 'grade_report_overview_showtotalsifcontainhidden', '0'),
(96, 'grade_report_user_showrank', '0'),
(97, 'grade_report_user_showpercentage', '1'),
(98, 'grade_report_user_showgrade', '1'),
(99, 'grade_report_user_showfeedback', '1'),
(100, 'grade_report_user_showrange', '1'),
(101, 'grade_report_user_showweight', '1'),
(102, 'grade_report_user_showaverage', '0'),
(103, 'grade_report_user_showlettergrade', '0'),
(104, 'grade_report_user_rangedecimals', '0'),
(105, 'grade_report_user_showhiddenitems', '1'),
(106, 'grade_report_user_showtotalsifcontainhidden', '0'),
(107, 'grade_report_user_showcontributiontocoursetotal', '1'),
(108, 'gradepenalty_enabledmodules', ''),
(109, 'grade_profilereport', 'user'),
(110, 'grade_aggregationposition', '1'),
(111, 'grade_includescalesinaggregation', '1'),
(112, 'grade_hiddenasdate', '0'),
(113, 'gradepublishing', '0'),
(114, 'grade_export_exportfeedback', '0'),
(115, 'grade_export_displaytype', '1'),
(116, 'grade_export_decimalpoints', '2'),
(117, 'grade_export_userprofilefields', 'firstname,lastname,idnumber,institution,department,email'),
(118, 'grade_export_customprofilefields', ''),
(119, 'recovergradesdefault', '0'),
(120, 'gradeexport', ''),
(121, 'gradeexport_default', 'ods'),
(122, 'unlimitedgrades', '0'),
(123, 'grade_report_showmin', '1'),
(124, 'gradepointmax', '100'),
(125, 'gradepointdefault', '100'),
(126, 'grade_minmaxtouse', '1'),
(127, 'grade_mygrades_report', 'overview'),
(128, 'gradereport_mygradeurl', ''),
(129, 'grade_hideforcedsettings', '1'),
(130, 'grade_aggregation', '13'),
(131, 'grade_aggregation_flag', '0'),
(132, 'grade_aggregations_visible', '13'),
(133, 'grade_aggregateonlygraded', '1'),
(134, 'grade_aggregateonlygraded_flag', '0'),
(135, 'grade_aggregateoutcomes', '0'),
(136, 'grade_aggregateoutcomes_flag', '0'),
(137, 'grade_keephigh', '0'),
(138, 'grade_keephigh_flag', '1'),
(139, 'grade_droplow', '0'),
(140, 'grade_droplow_flag', '0'),
(141, 'grade_overridecat', '1'),
(142, 'grade_displaytype', '1'),
(143, 'grade_decimalpoints', '2'),
(144, 'badges_defaultissuername', ''),
(145, 'badges_defaultissuercontact', ''),
(146, 'badges_badgesalt', 'badges[[timestamp]]'),
(147, 'badges_allowcoursebadges', '1'),
(148, 'badges_allowexternalbackpack', '1'),
(149, 'badges_canvasregions', 'Australia|https://au.badgr.io|https://api.au.badgr.io/v2\nCanada|https://ca.badgr.io|https://api.ca.badgr.io/v2\nEurope|https://eu.badgr.io|https://api.eu.badgr.io/v2\nSingapore|https://sg.badgr.io|https://api.sg.badgr.io/v2\nUnited States|https://badgr.io|https://api.badgr.io/v2'),
(150, 'rememberuserlicensepref', '1'),
(152, 'forcetimezone', '99'),
(153, 'country', '0'),
(154, 'defaultcity', ''),
(155, 'allcountrycodes', ''),
(156, 'geoip2file', '[[softdatadir]]/geoip/GeoIP-City.mmdb'),
(157, 'geoipdbedition', 'GeoLite2-City'),
(158, 'geoipmaxmindaccid', ''),
(159, 'geoipmaxmindlicensekey', ''),
(160, 'googlemapkey3', ''),
(161, 'geopluginapikey', ''),
(162, 'autolang', '1'),
(163, 'lang', '[[language]]'),
(164, 'autolangusercreation', '1'),
(165, 'langmenu', '1'),
(166, 'langlist', ''),
(167, 'langrev', '[[timestamp]]'),
(168, 'langcache', '1'),
(169, 'langstringcache', '1'),
(170, 'locale', ''),
(171, 'latinexcelexport', '0'),
(172, 'enablepdfexportfont', '0'),
(173, 'messagingallusers', '0'),
(174, 'messagingdefaultpressenter', '1'),
(175, 'messagingdeletereadnotificationsdelay', '604800'),
(176, 'messagingdeleteallnotificationsdelay', '2620800'),
(177, 'messagingallowemailoverride', '0'),
(178, 'requiremodintro', '0'),
(180, 'authloginviaemail', '0'),
(181, 'allowaccountssameemail', '0'),
(182, 'authpreventaccountcreation', '0'),
(183, 'loginpageautofocus', '0'),
(184, 'guestloginbutton', '1'),
(185, 'limitconcurrentlogins', '0'),
(186, 'alternateloginurl', ''),
(187, 'showloginform', '1'),
(188, 'forgottenpasswordurl', ''),
(189, 'auth_instructions', ''),
(190, 'allowemailaddresses', ''),
(191, 'denyemailaddresses', ''),
(192, 'verifychangedemail', '1'),
(193, 'enableloginrecaptcha', '0'),
(194, 'enableforgotpasswordrecaptcha', '0'),
(195, 'recaptchapublickey', ''),
(196, 'recaptchaprivatekey', ''),
(197, 'loginpasswordtoggle', '2'),
(198, 'filteruploadedfiles', '0'),
(199, 'filtermatchoneperpage', '0'),
(200, 'filtermatchonepertext', '0'),
(201, 'filternavigationwithsystemcontext', '1'),
(202, 'media_default_width', '640'),
(203, 'media_default_height', '360'),
(204, 'portfolio_moderate_filesize_threshold', '1048576'),
(205, 'portfolio_high_filesize_threshold', '5242880'),
(206, 'portfolio_moderate_db_threshold', '20'),
(207, 'portfolio_high_db_threshold', '50'),
(208, 'questiondefaultssave', '1'),
(209, 'repositorycacheexpire', '120'),
(210, 'repositorygetfiletimeout', '30'),
(211, 'repositorysyncfiletimeout', '1'),
(212, 'repositorysyncimagetimeout', '3'),
(213, 'repositoryallowexternallinks', '1'),
(214, 'legacyfilesinnewcourses', '0'),
(215, 'legacyfilesaddallowed', '1'),
(216, 'searchengine', 'simpledb'),
(217, 'searchindexwhendisabled', '0'),
(218, 'searchindextime', '600'),
(219, 'searchallavailablecourses', '0'),
(220, 'searchincludeallcourses', '0'),
(221, 'searchenablecategories', '0'),
(222, 'searchdefaultcategory', 'core-all'),
(223, 'searchhideallcategory', '0'),
(224, 'searchmaxtopresults', '3'),
(225, 'searchteacherroles', ''),
(226, 'searchenginequeryonly', ''),
(227, 'searchbannerenable', '0'),
(228, 'searchbanner', ''),
(229, 'allowbeforeblock', '0'),
(230, 'allowedip', ''),
(231, 'blockedip', ''),
(232, 'protectusernames', '1'),
(233, 'forcelogin', '0'),
(234, 'forceloginforprofiles', '1'),
(235, 'forceloginforprofileimage', '0'),
(236, 'opentowebcrawlers', '0'),
(237, 'allowindexing', '0'),
(238, 'maxbytes', '0'),
(239, 'userquota', '104857600'),
(240, 'allowobjectembed', '0'),
(241, 'enabletrusttext', '0'),
(242, 'maxeditingtime', '1800'),
(243, 'extendedusernamechars', '0'),
(244, 'keeptagnamecase', '1'),
(245, 'profilesforenrolledusersonly', '1'),
(246, 'cronclionly', '1'),
(247, 'cronremotepassword', ''),
(248, 'lockoutthreshold', '0'),
(249, 'lockoutwindow', '1800'),
(250, 'lockoutduration', '1800'),
(251, 'passwordpolicy', '1'),
(252, 'minpasswordlength', '8'),
(253, 'minpassworddigits', '1'),
(254, 'minpasswordlower', '1'),
(255, 'minpasswordupper', '1'),
(256, 'minpasswordnonalphanum', '1'),
(257, 'maxconsecutiveidentchars', '0'),
(258, 'passwordpolicycheckonlogin', '0'),
(259, 'passwordreuselimit', '0'),
(260, 'pwresettime', '1800'),
(261, 'passwordchangelogout', '1'),
(262, 'passwordchangetokendeletion', '0'),
(263, 'tokenduration', '7257600'),
(264, 'groupenrolmentkeypolicy', '1'),
(265, 'disableuserimages', '0'),
(266, 'emailchangeconfirmation', '1'),
(267, 'rememberusername', '2'),
(268, 'strictformsrequired', '0'),
(269, 'cookiesecure', '1'),
(270, 'allowframembedding', '0'),
(271, 'curlsecurityblockedhosts', '127.0.0.0/8\n192.168.0.0/16\n10.0.0.0/8\n172.16.0.0/12\n0.0.0.0\nlocalhost\n169.254.169.254\n0000::1'),
(272, 'curlsecurityallowedport', '443\n80'),
(273, 'referrerpolicy', 'default'),
(274, 'displayloginfailures', '0'),
(275, 'notifyloginfailures', ''),
(276, 'notifyloginthreshold', '10'),
(277, 'calendartype', 'gregorian'),
(278, 'calendar_adminseesall', '0'),
(279, 'calendar_site_timeformat', '0'),
(280, 'calendar_startwday', '1'),
(281, 'calendar_weekend', '65'),
(282, 'calendar_lookahead', '21'),
(283, 'calendar_maxevents', '10'),
(284, 'enablecalendarexport', '1'),
(285, 'calendar_customexport', '1'),
(286, 'calendar_exportlookahead', '365'),
(287, 'calendar_exportlookback', '5'),
(288, 'calendar_exportsalt', '[[export_salt]]'),
(289, 'calendar_showicalsource', '1'),
(290, 'useblogassociations', '1'),
(291, 'bloglevel', '4'),
(292, 'useexternalblogs', '1'),
(293, 'externalblogcrontime', '86400'),
(294, 'maxexternalblogsperuser', '1'),
(295, 'blogusecomments', '1'),
(296, 'blogshowcommentscount', '1'),
(297, 'enabledashboard', '1'),
(298, 'defaulthomepage', '1'),
(299, 'allowguestmymoodle', '1'),
(300, 'navshowfullcoursenames', '0'),
(301, 'navshowcategories', '1'),
(302, 'navshowmycoursecategories', '0'),
(303, 'navshowallcourses', '0'),
(304, 'navsortmycoursessort', 'sortorder'),
(305, 'navsortmycourseshiddenlast', '1'),
(306, 'navcourselimit', '10'),
(307, 'usesitenameforsitepages', '0'),
(308, 'linkadmincategories', '1'),
(309, 'navshowfrontpagemods', '1'),
(310, 'navadduserpostslinks', '1'),
(311, 'sitenameintitle', 'shortname'),
(312, 'formatstringstriptags', '1'),
(313, 'emoticons', '[{"text":":-)","imagename":"s\\/smiley","imagecomponent":"core","altidentifier":"smiley","altcomponent":"core_pix"},{"text":":)","imagename":"s\\/smiley","imagecomponent":"core","altidentifier":"smiley","altcomponent":"core_pix"},{"text":":-D","imagename":"s\\/biggrin","imagecomponent":"core","altidentifier":"biggrin","altcomponent":"core_pix"},{"text":";-)","imagename":"s\\/wink","imagecomponent":"core","altidentifier":"wink","altcomponent":"core_pix"},{"text":":-\\/","imagename":"s\\/mixed","imagecomponent":"core","altidentifier":"mixed","altcomponent":"core_pix"},{"text":"V-.","imagename":"s\\/thoughtful","imagecomponent":"core","altidentifier":"thoughtful","altcomponent":"core_pix"},{"text":":-P","imagename":"s\\/tongueout","imagecomponent":"core","altidentifier":"tongueout","altcomponent":"core_pix"},{"text":":-p","imagename":"s\\/tongueout","imagecomponent":"core","altidentifier":"tongueout","altcomponent":"core_pix"},{"text":"B-)","imagename":"s\\/cool","imagecomponent":"core","altidentifier":"cool","altcomponent":"core_pix"},{"text":"^-)","imagename":"s\\/approve","imagecomponent":"core","altidentifier":"approve","altcomponent":"core_pix"},{"text":"8-)","imagename":"s\\/wideeyes","imagecomponent":"core","altidentifier":"wideeyes","altcomponent":"core_pix"},{"text":":o)","imagename":"s\\/clown","imagecomponent":"core","altidentifier":"clown","altcomponent":"core_pix"},{"text":":-(","imagename":"s\\/sad","imagecomponent":"core","altidentifier":"sad","altcomponent":"core_pix"},{"text":":(","imagename":"s\\/sad","imagecomponent":"core","altidentifier":"sad","altcomponent":"core_pix"},{"text":"8-.","imagename":"s\\/shy","imagecomponent":"core","altidentifier":"shy","altcomponent":"core_pix"},{"text":":-I","imagename":"s\\/blush","imagecomponent":"core","altidentifier":"blush","altcomponent":"core_pix"},{"text":":-X","imagename":"s\\/kiss","imagecomponent":"core","altidentifier":"kiss","altcomponent":"core_pix"},{"text":"8-o","imagename":"s\\/surprise","imagecomponent":"core","altidentifier":"surprise","altcomponent":"core_pix"},{"text":"P-|","imagename":"s\\/blackeye","imagecomponent":"core","altidentifier":"blackeye","altcomponent":"core_pix"},{"text":"8-[","imagename":"s\\/angry","imagecomponent":"core","altidentifier":"angry","altcomponent":"core_pix"},{"text":"(grr)","imagename":"s\\/angry","imagecomponent":"core","altidentifier":"angry","altcomponent":"core_pix"},{"text":"xx-P","imagename":"s\\/dead","imagecomponent":"core","altidentifier":"dead","altcomponent":"core_pix"},{"text":"|-.","imagename":"s\\/sleepy","imagecomponent":"core","altidentifier":"sleepy","altcomponent":"core_pix"},{"text":"}-]","imagename":"s\\/evil","imagecomponent":"core","altidentifier":"evil","altcomponent":"core_pix"},{"text":"(h)","imagename":"s\\/heart","imagecomponent":"core","altidentifier":"heart","altcomponent":"core_pix"},{"text":"(heart)","imagename":"s\\/heart","imagecomponent":"core","altidentifier":"heart","altcomponent":"core_pix"},{"text":"(y)","imagename":"s\\/yes","imagecomponent":"core","altidentifier":"yes","altcomponent":"core"},{"text":"(n)","imagename":"s\\/no","imagecomponent":"core","altidentifier":"no","altcomponent":"core"},{"text":"(martin)","imagename":"s\\/martin","imagecomponent":"core","altidentifier":"martin","altcomponent":"core_pix"},{"text":"( )","imagename":"s\\/egg","imagecomponent":"core","altidentifier":"egg","altcomponent":"core_pix"}]'),
(314, 'docroot', 'https://docs.moodle.org'),
(315, 'doclang', ''),
(316, 'doctonewwindow', '0'),
(317, 'coursecreationguide', 'https://moodle.academy/coursequickstart'),
(318, 'coursecontactduplicates', '0'),
(319, 'courselistshortnames', '0'),
(320, 'coursesperpage', '20'),
(321, 'courseswithsummarieslimit', '10'),
(322, 'courseoverviewfileslimit', '1'),
(323, 'courseoverviewfilesext', 'web_image'),
(324, 'coursegraceperiodbefore', '0'),
(325, 'coursegraceperiodafter', '0'),
(326, 'yuicomboloading', '1'),
(327, 'cachejs', '1'),
(328, 'additionalhtmlhead', ''),
(329, 'additionalhtmltopofbody', ''),
(330, 'additionalhtmlfooter', ''),
(331, 'cachetemplates', '1'),
(332, 'themelist', ''),
(333, 'themedesignermode', '0'),
(334, 'allowuserthemes', '0'),
(335, 'allowcoursethemes', '0'),
(336, 'allowcategorythemes', '0'),
(337, 'allowcohortthemes', '0'),
(338, 'allowthemechangeonurl', '0'),
(339, 'allowuserblockhiding', '1'),
(340, 'langmenuinsecurelayout', '0'),
(341, 'logininfoinsecurelayout', '0'),
(342, 'navfilter', '0'),
(343, 'custommenuitems', ''),
(344, 'customusermenuitems', 'profile,moodle|/user/profile.php\ngrades,grades|/grade/report/mygrades.php\ncalendar,core_calendar|/calendar/view.php?view=month\nprivatefiles,moodle|/user/files.php\nreports,core_reportbuilder|/reportbuilder/index.php'),
(345, 'file_redactor_exifremoverenabled', '1'),
(346, 'file_redactor_exifremovertoolpath', ''),
(347, 'file_redactor_exifremoverremovetags', 'gps'),
(348, 'file_redactor_exifremovermimetype', 'image/jpeg\nimage/tiff'),
(349, 'cron_enabled', '1'),
(350, 'cron_keepalive', '180'),
(351, 'task_scheduled_concurrency_limit', '3'),
(352, 'task_scheduled_max_runtime', '1800'),
(353, 'task_adhoc_concurrency_limit', '3'),
(354, 'task_adhoc_max_runtime', '1800'),
(355, 'task_adhoc_failed_retention', '2419200'),
(356, 'task_logmode', '1'),
(357, 'task_logtostdout', '1'),
(358, 'task_logretention', '2419200'),
(359, 'task_logretainruns', '20'),
(360, 'smtphosts', ''),
(361, 'smtpsecure', ''),
(362, 'smtpauthtype', 'LOGIN'),
(363, 'smtpuser', ''),
(364, 'smtppass', ''),
(365, 'smtpmaxbulk', '1'),
(366, 'noreplyaddress', '[[admin_email]]'),
(367, 'allowedemaildomains', ''),
(368, 'divertallemailsto', ''),
(369, 'divertallemailsexcept', ''),
(370, 'emaildkimselector', ''),
(371, 'sitemailcharset', '0'),
(372, 'allowusermailcharset', '0'),
(373, 'allowattachments', '1'),
(374, 'mailnewline', 'LF'),
(375, 'emailfromvia', '1'),
(376, 'emailsubjectprefix', ''),
(377, 'emailheaders', ''),
(378, 'enablewsdocumentation', '0'),
(379, 'pathtophp', ''),
(380, 'pathtodu', ''),
(381, 'aspellpath', ''),
(382, 'pathtodot', ''),
(383, 'pathtogs', '/usr/bin/gs'),
(384, 'pathtopdftoppm', ''),
(385, 'pathtopython', ''),
(386, 'supportname', 'Admin User'),
(387, 'supportpage', ''),
(388, 'supportavailability', '1'),
(389, 'servicespage', ''),
(390, 'dbsessions', '0'),
(391, 'sessiontimeoutwarning', '1200'),
(392, 'sessioncookie', ''),
(393, 'sessioncookiepath', ''),
(394, 'sessioncookiedomain', ''),
(395, 'statsfirstrun', 'none'),
(396, 'statsmaxruntime', '0'),
(397, 'statsruntimedays', '31'),
(398, 'statsuserthreshold', '0'),
(399, 'slasharguments', '1'),
(400, 'getremoteaddrconf', '3'),
(401, 'reverseproxyignore', ''),
(402, 'proxyhost', ''),
(403, 'proxyport', '0'),
(404, 'proxytype', 'HTTP'),
(405, 'proxyuser', ''),
(406, 'proxypassword', ''),
(407, 'proxybypass', 'localhost,127.0.0.1'),
(408, 'proxylogunsafe', '0'),
(409, 'proxyfixunsafe', '0'),
(410, 'maintenance_enabled', '0'),
(411, 'maintenance_message', ''),
(412, 'deleteunconfirmed', '168'),
(413, 'deleteincompleteusers', '0'),
(414, 'disablegradehistory', '0'),
(415, 'gradehistorylifetime', '0'),
(416, 'tempdatafoldercleanup', '168'),
(417, 'xapicleanupperiod', '4838400'),
(418, 'filescleanupperiod', '86400'),
(419, 'extramemorylimit', '512M'),
(420, 'maxtimelimit', '0'),
(421, 'curlcache', '120'),
(422, 'curltimeoutkbitrate', '56'),
(423, 'updateautocheck', '1'),
(424, 'updateminmaturity', '200'),
(425, 'updatenotifybuilds', '0'),
(426, 'customreportslimit', '0'),
(427, 'customreportsliveediting', '1'),
(428, 'dndallowtextandlinks', '0'),
(429, 'pathtosassc', ''),
(430, 'contextlocking', '0'),
(431, 'contextlockappliestoadmin', '1'),
(432, 'forceclean', '0'),
(433, 'enablecourserelativedates', '0'),
(434, 'enablesharingtomoodlenet', '0'),
(435, 'enablecommunicationsubsystem', '0'),
(436, 'debug', '0'),
(437, 'debugdisplay', '0'),
(438, 'perfdebug', '7'),
(439, 'debugstringids', '0'),
(440, 'debugsqltrace', '0'),
(441, 'debugvalidators', '0'),
(442, 'debugpageinfo', '0'),
(443, 'debugtemplateinfo', '0'),
(444, 'profilingenabled', '0'),
(445, 'profilingincluded', ''),
(446, 'profilingexcluded', ''),
(447, 'profilingautofrec', '0'),
(448, 'profilingallowme', '0'),
(449, 'profilingallowall', '0'),
(450, 'profilingslow', '0'),
(451, 'profilinglifetime', '1440'),
(452, 'profilingimportprefix', '(I)'),
(453, 'release', '5.1.1 (Build: 20251208)'),
(454, 'localcachedirpurged', '[[timestamp]]'),
(455, 'scheduledtaskreset', '[[timestamp]]'),
(456, 'paygw_plugins_sortorder', 'paypal'),
(457, 'allversionshash', 'cc555dfed23266dad3dcfeee43d1ff1b2f7ece9d'),
(458, 'allcomponenthash', '[[allcomponenthash]]'),
(459, 'registrationpending', '1'),
(461, 'branch', '501'),
(462, 'scorm_updatetimelast', '[[timestamp]]'),
(463, 'enableaccessibilitytools', '1'),
(464, 'notloggedinroleid', '6'),
(465, 'guestroleid', '6'),
(466, 'defaultuserroleid', '7'),
(467, 'creatornewroleid', '3'),
(468, 'restorernewroleid', '3'),
(469, 'sitepolicyhandler', ''),
(470, 'gradebookroles', '5'),
(471, 'h5plibraryhandler', 'h5plib_v127'),
(472, 'airnotifierurl', 'https://messages.moodle.net'),
(473, 'airnotifierport', '443'),
(474, 'airnotifiermobileappname', 'com.moodle.moodlemobile'),
(475, 'airnotifierappname', 'commoodlemoodlemobile'),
(476, 'airnotifieraccesskey', ''),
(477, 'bigbluebuttonbn_server_url', ''),
(478, 'bigbluebuttonbn_shared_secret', ''),
(479, 'bigbluebuttonbn_checksum_algorithm', 'SHA256'),
(480, 'bigbluebuttonbn_poll_interval', '5'),
(481, 'bigbluebuttonbn_welcome_default', ''),
(482, 'bigbluebuttonbn_welcome_editable', '1'),
(483, 'bigbluebuttonbn_recording_default', '1'),
(484, 'bigbluebuttonbn_recording_refresh_period', '300'),
(485, 'bigbluebuttonbn_recording_editable', '1'),
(486, 'bigbluebuttonbn_recording_all_from_start_default', '0'),
(487, 'bigbluebuttonbn_recording_all_from_start_editable', '0'),
(488, 'bigbluebuttonbn_recording_hide_button_default', '0'),
(489, 'bigbluebuttonbn_recording_hide_button_editable', '0'),
(490, 'bigbluebuttonbn_recording_safe_formats', 'video,presentation'),
(491, 'bigbluebuttonbn_importrecordings_enabled', '0'),
(492, 'bigbluebuttonbn_importrecordings_from_deleted_enabled', '0'),
(493, 'bigbluebuttonbn_recordings_deleted_default', '1'),
(494, 'bigbluebuttonbn_recordings_deleted_editable', '0'),
(495, 'bigbluebuttonbn_recordings_imported_default', '0'),
(496, 'bigbluebuttonbn_recordings_imported_editable', '1'),
(497, 'bigbluebuttonbn_recordings_preview_default', '1'),
(498, 'bigbluebuttonbn_recordings_preview_editable', '0'),
(499, 'bigbluebuttonbn_recordings_asc_sort', '0'),
(500, 'bigbluebuttonbn_recording_protect_editable', '1'),
(501, 'bigbluebuttonbn_waitformoderator_default', '0'),
(502, 'bigbluebuttonbn_waitformoderator_editable', '1'),
(503, 'bigbluebuttonbn_waitformoderator_ping_interval', '10'),
(504, 'bigbluebuttonbn_waitformoderator_cache_ttl', '60'),
(505, 'bigbluebuttonbn_voicebridge_editable', '0'),
(506, 'bigbluebuttonbn_preuploadpresentation_editable', '0'),
(507, 'bigbluebuttonbn_userlimit_default', '0'),
(508, 'bigbluebuttonbn_userlimit_editable', '0'),
(509, 'bigbluebuttonbn_participant_moderator_default', '0'),
(510, 'bigbluebuttonbn_muteonstart_default', '0'),
(511, 'bigbluebuttonbn_muteonstart_editable', '0'),
(512, 'bigbluebuttonbn_disablecam_default', '0'),
(513, 'bigbluebuttonbn_disablecam_editable', '1'),
(514, 'bigbluebuttonbn_disablemic_default', '0'),
(515, 'bigbluebuttonbn_disablemic_editable', '1'),
(516, 'bigbluebuttonbn_disableprivatechat_default', '0'),
(517, 'bigbluebuttonbn_disableprivatechat_editable', '1'),
(518, 'bigbluebuttonbn_disablepublicchat_default', '0'),
(519, 'bigbluebuttonbn_disablepublicchat_editable', '1'),
(520, 'bigbluebuttonbn_disablenote_default', '0'),
(521, 'bigbluebuttonbn_disablenote_editable', '1'),
(522, 'bigbluebuttonbn_hideuserlist_default', '0'),
(523, 'bigbluebuttonbn_hideuserlist_editable', '1'),
(524, 'bigbluebuttonbn_recordingready_enabled', '0'),
(525, 'bigbluebuttonbn_profile_picture_enabled', '0'),
(526, 'bigbluebuttonbn_meetingevents_enabled', '0'),
(527, 'bigbluebuttonbn_guestaccess_enabled', '0'),
(528, 'data_enablerssfeeds', '0'),
(529, 'feedback_allowfullanonymous', '0'),
(530, 'forum_displaymode', '3'),
(531, 'forum_shortpost', '300'),
(532, 'forum_longpost', '600'),
(533, 'forum_manydiscussions', '100'),
(534, 'forum_maxbytes', '512000'),
(535, 'forum_maxattachments', '9'),
(536, 'forum_subscription', '0'),
(537, 'forum_trackingtype', '1'),
(538, 'forum_trackreadposts', '1'),
(539, 'forum_allowforcedreadtracking', '0'),
(540, 'forum_oldpostdays', '14'),
(541, 'forum_usermarksread', '0'),
(542, 'forum_cleanreadtime', '2'),
(543, 'digestmailtime', '17'),
(544, 'forum_enablerssfeeds', '0'),
(545, 'forum_enabletimedposts', '1'),
(546, 'forum_announcementmaxbytes', '512000'),
(547, 'forum_announcementmaxattachments', '1'),
(548, 'forum_announcementsubscription', '1'),
(549, 'glossary_entbypage', '10'),
(550, 'glossary_dupentries', '0'),
(551, 'glossary_allowcomments', '0'),
(552, 'glossary_linkbydefault', '1'),
(553, 'glossary_defaultapproval', '1'),
(554, 'glossary_enablerssfeeds', '0'),
(555, 'glossary_linkentries', '0'),
(556, 'glossary_casesensitive', '0'),
(557, 'glossary_fullmatch', '0'),
(558, 'block_course_list_adminview', 'all'),
(559, 'block_course_list_hideallcourseslink', '0'),
(560, 'block_online_users_timetosee', '5'),
(561, 'block_online_users_onlinestatushiding', '1'),
(562, 'block_rss_client_num_entries', '5'),
(563, 'block_rss_client_timeout', '30'),
(564, 'block_html_allowcssclasses', '0'),
(565, 'pathtounoconv', '/usr/bin/unoconv'),
(566, 'filter_multilang_force_old', '0'),
(567, 'profileroles', '5,4,3'),
(568, 'coursecontact', '3'),
(569, 'frontpage', '6'),
(570, 'frontpageloggedin', '6'),
(571, 'maxcategorydepth', '2'),
(572, 'frontpagecourselimit', '200'),
(573, 'commentsperpage', '15'),
(574, 'defaultfrontpageroleid', '8'),
(575, 'messageinbound_enabled', '0'),
(576, 'messageinbound_mailbox', ''),
(577, 'messageinbound_domain', ''),
(578, 'messageinbound_host', ''),
(579, 'messageinbound_hostssl', 'ssl'),
(580, 'messageinbound_hostuser', ''),
(581, 'messageinbound_hostpass', ''),
(582, 'mobilecssurl', ''),
(583, 'enablemobilewebservice', '0'),
(584, 'timezone', 'America/New_York'),
(585, 'registerauth', ''),
(586, 'supportemail', '[[support_email]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]config_log`
--

CREATE TABLE `[[dbprefix]]config_log` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `userid` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  `plugin` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `name` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `value` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `oldvalue` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]conflog_tim_ix` (`timemodified`),
  KEY `[[dbprefix]]conflog_use_ix` (`userid`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Changes done in server configuration through admin UI' AUTO_INCREMENT=1811 ;

--
-- Dumping data for table `[[dbprefix]]config_log`
--

INSERT INTO `[[dbprefix]]config_log` VALUES
(1, 0, [[timestamp]], NULL, 'enableuserfeedback', '0', NULL),
(2, 0, [[timestamp]], NULL, 'userfeedback_nextreminder', '1', NULL),
(3, 0, [[timestamp]], NULL, 'userfeedback_remindafter', '90', NULL),
(4, 0, [[timestamp]], NULL, 'enableoutcomes', '0', NULL),
(5, 0, [[timestamp]], NULL, 'usecomments', '1', NULL),
(6, 0, [[timestamp]], NULL, 'usetags', '1', NULL),
(7, 0, [[timestamp]], NULL, 'enablenotes', '1', NULL),
(8, 0, [[timestamp]], NULL, 'enableportfolios', '0', NULL),
(9, 0, [[timestamp]], NULL, 'enablewebservices', '0', NULL),
(10, 0, [[timestamp]], NULL, 'enablestats', '0', NULL),
(11, 0, [[timestamp]], NULL, 'enablerssfeeds', '0', NULL),
(12, 0, [[timestamp]], NULL, 'enableblogs', '1', NULL),
(13, 0, [[timestamp]], NULL, 'enablecompletion', '1', NULL),
(14, 0, [[timestamp]], NULL, 'enableavailability', '1', NULL),
(15, 0, [[timestamp]], NULL, 'enableplagiarism', '0', NULL),
(16, 0, [[timestamp]], NULL, 'enablebadges', '1', NULL),
(17, 0, [[timestamp]], NULL, 'enableglobalsearch', '0', NULL),
(18, 0, [[timestamp]], NULL, 'allowstealth', '0', NULL),
(19, 0, [[timestamp]], NULL, 'enableanalytics', '0', NULL),
(20, 0, [[timestamp]], 'core_competency', 'enabled', '1', NULL),
(21, 0, [[timestamp]], NULL, 'messaging', '1', NULL),
(22, 0, [[timestamp]], NULL, 'enablecustomreports', '1', NULL),
(23, 0, [[timestamp]], NULL, 'allowemojipicker', '1', NULL),
(24, 0, [[timestamp]], NULL, 'userfiltersdefault', 'realname', NULL),
(25, 0, [[timestamp]], NULL, 'defaultpreference_maildisplay', '2', NULL),
(26, 0, [[timestamp]], NULL, 'defaultpreference_mailformat', '1', NULL),
(27, 0, [[timestamp]], NULL, 'defaultpreference_maildigest', '0', NULL),
(28, 0, [[timestamp]], NULL, 'defaultpreference_autosubscribe', '1', NULL),
(29, 0, [[timestamp]], NULL, 'defaultpreference_trackforums', '0', NULL),
(30, 0, [[timestamp]], NULL, 'defaultpreference_core_contentbank_visibility', '1', NULL),
(31, 0, [[timestamp]], NULL, 'enroladminnewcourse', '1', NULL),
(32, 0, [[timestamp]], NULL, 'autologinguests', '0', NULL),
(33, 0, [[timestamp]], NULL, 'hiddenuserfields', '', NULL),
(34, 0, [[timestamp]], NULL, 'showuseridentity', 'email', NULL),
(35, 0, [[timestamp]], NULL, 'fullnamedisplay', 'language', NULL),
(36, 0, [[timestamp]], NULL, 'alternativefullnameformat', 'language', NULL),
(37, 0, [[timestamp]], NULL, 'maxusersperpage', '100', NULL),
(38, 0, [[timestamp]], NULL, 'enablegravatar', '0', NULL),
(39, 0, [[timestamp]], NULL, 'gravatardefaulturl', 'mm', NULL),
(40, 0, [[timestamp]], NULL, 'agedigitalconsentverification', '0', NULL),
(41, 0, [[timestamp]], NULL, 'agedigitalconsentmap', '*, 16\nAT, 14\nBE, 13\nBG, 14\nCY, 14\nCZ, 15\nDK, 13\nEE, 13\nES, 14\nFI, 13\nFR, 15\nGB, 13\nGR, 15\nIT, 14\nLT, 14\nLV, 13\nMT, 13\nNO, 13\nPT, 13\nSE, 13\nUS, 13', NULL),
(42, 0, [[timestamp]], NULL, 'sitepolicy', '', NULL),
(43, 0, [[timestamp]], NULL, 'sitepolicyguest', '', NULL),
(44, 0, [[timestamp]], 'moodlecourse', 'visible', '1', NULL),
(45, 0, [[timestamp]], 'moodlecourse', 'downloadcontentsitedefault', '0', NULL),
(46, 0, [[timestamp]], 'moodlecourse', 'participantsperpage', '20', NULL),
(47, 0, [[timestamp]], 'moodlecourse', 'format', 'topics', NULL),
(48, 0, [[timestamp]], 'moodlecourse', 'maxsections', '52', NULL),
(49, 0, [[timestamp]], 'moodlecourse', 'numsections', '4', NULL),
(50, 0, [[timestamp]], 'moodlecourse', 'hiddensections', '1', NULL),
(51, 0, [[timestamp]], 'moodlecourse', 'coursedisplay', '0', NULL),
(52, 0, [[timestamp]], 'moodlecourse', 'courseenddateenabled', '1', NULL),
(53, 0, [[timestamp]], 'moodlecourse', 'courseduration', '31536000', NULL),
(54, 0, [[timestamp]], 'moodlecourse', 'lang', '', NULL),
(55, 0, [[timestamp]], 'moodlecourse', 'newsitems', '5', NULL),
(56, 0, [[timestamp]], 'moodlecourse', 'showgrades', '1', NULL),
(57, 0, [[timestamp]], 'moodlecourse', 'showreports', '0', NULL),
(58, 0, [[timestamp]], 'moodlecourse', 'showactivitydates', '1', NULL),
(59, 0, [[timestamp]], 'moodlecourse', 'maxbytes', '0', NULL),
(60, 0, [[timestamp]], 'moodlecourse', 'enablecompletion', '1', NULL),
(61, 0, [[timestamp]], 'moodlecourse', 'showcompletionconditions', '1', NULL),
(62, 0, [[timestamp]], 'moodlecourse', 'groupmode', '0', NULL),
(63, 0, [[timestamp]], 'moodlecourse', 'groupmodeforce', '0', NULL),
(64, 0, [[timestamp]], 'moodlecourse', 'coursecommunicationprovider', 'none', NULL),
(65, 0, [[timestamp]], NULL, 'activitychooseractivefooter', 'hidden', NULL),
(66, 0, [[timestamp]], 'backup', 'loglifetime', '30', NULL),
(67, 0, [[timestamp]], 'backup', 'backup_general_users', '1', NULL),
(68, 0, [[timestamp]], 'backup', 'backup_general_users_locked', '', NULL),
(69, 0, [[timestamp]], 'backup', 'backup_general_anonymize', '0', NULL),
(70, 0, [[timestamp]], 'backup', 'backup_general_anonymize_locked', '', NULL),
(71, 0, [[timestamp]], 'backup', 'backup_general_role_assignments', '1', NULL),
(72, 0, [[timestamp]], 'backup', 'backup_general_role_assignments_locked', '', NULL),
(73, 0, [[timestamp]], 'backup', 'backup_general_activities', '1', NULL),
(74, 0, [[timestamp]], 'backup', 'backup_general_activities_locked', '', NULL),
(75, 0, [[timestamp]], 'backup', 'backup_general_blocks', '1', NULL),
(76, 0, [[timestamp]], 'backup', 'backup_general_blocks_locked', '', NULL),
(77, 0, [[timestamp]], 'backup', 'backup_general_files', '1', NULL),
(78, 0, [[timestamp]], 'backup', 'backup_general_files_locked', '', NULL),
(79, 0, [[timestamp]], 'backup', 'backup_general_filters', '1', NULL),
(80, 0, [[timestamp]], 'backup', 'backup_general_filters_locked', '', NULL),
(81, 0, [[timestamp]], 'backup', 'backup_general_comments', '1', NULL),
(82, 0, [[timestamp]], 'backup', 'backup_general_comments_locked', '', NULL),
(83, 0, [[timestamp]], 'backup', 'backup_general_badges', '1', NULL),
(84, 0, [[timestamp]], 'backup', 'backup_general_badges_locked', '', NULL),
(85, 0, [[timestamp]], 'backup', 'backup_general_calendarevents', '1', NULL),
(86, 0, [[timestamp]], 'backup', 'backup_general_calendarevents_locked', '', NULL),
(87, 0, [[timestamp]], 'backup', 'backup_general_userscompletion', '1', NULL),
(88, 0, [[timestamp]], 'backup', 'backup_general_userscompletion_locked', '', NULL),
(89, 0, [[timestamp]], 'backup', 'backup_general_logs', '0', NULL),
(90, 0, [[timestamp]], 'backup', 'backup_general_logs_locked', '', NULL),
(91, 0, [[timestamp]], 'backup', 'backup_general_histories', '0', NULL),
(92, 0, [[timestamp]], 'backup', 'backup_general_histories_locked', '', NULL),
(93, 0, [[timestamp]], 'backup', 'backup_general_groups', '1', NULL),
(94, 0, [[timestamp]], 'backup', 'backup_general_groups_locked', '', NULL),
(95, 0, [[timestamp]], 'backup', 'backup_general_competencies', '1', NULL),
(96, 0, [[timestamp]], 'backup', 'backup_general_competencies_locked', '', NULL),
(97, 0, [[timestamp]], 'backup', 'backup_general_customfield', '1', NULL),
(98, 0, [[timestamp]], 'backup', 'backup_general_customfield_locked', '', NULL),
(99, 0, [[timestamp]], 'backup', 'backup_general_contentbankcontent', '1', NULL),
(100, 0, [[timestamp]], 'backup', 'backup_general_contentbankcontent_locked', '', NULL),
(101, 0, [[timestamp]], 'backup', 'backup_general_xapistate', '1', NULL),
(102, 0, [[timestamp]], 'backup', 'backup_general_xapistate_locked', '', NULL),
(103, 0, [[timestamp]], 'backup', 'backup_general_legacyfiles', '1', NULL),
(104, 0, [[timestamp]], 'backup', 'backup_general_legacyfiles_locked', '', NULL),
(105, 0, [[timestamp]], 'backup', 'import_general_maxresults', '10', NULL),
(106, 0, [[timestamp]], 'backup', 'import_general_duplicate_admin_allowed', '0', NULL),
(107, 0, [[timestamp]], 'backup', 'backup_import_permissions', '0', NULL),
(108, 0, [[timestamp]], 'backup', 'backup_import_permissions_locked', '', NULL),
(109, 0, [[timestamp]], 'backup', 'backup_import_activities', '1', NULL),
(110, 0, [[timestamp]], 'backup', 'backup_import_activities_locked', '', NULL),
(111, 0, [[timestamp]], 'backup', 'backup_import_blocks', '1', NULL),
(112, 0, [[timestamp]], 'backup', 'backup_import_blocks_locked', '', NULL),
(113, 0, [[timestamp]], 'backup', 'backup_import_filters', '1', NULL),
(114, 0, [[timestamp]], 'backup', 'backup_import_filters_locked', '', NULL),
(115, 0, [[timestamp]], 'backup', 'backup_import_badges', '0', NULL),
(116, 0, [[timestamp]], 'backup', 'backup_import_badges_locked', '', NULL),
(117, 0, [[timestamp]], 'backup', 'backup_import_calendarevents', '1', NULL),
(118, 0, [[timestamp]], 'backup', 'backup_import_calendarevents_locked', '', NULL),
(119, 0, [[timestamp]], 'backup', 'backup_import_groups', '1', NULL),
(120, 0, [[timestamp]], 'backup', 'backup_import_groups_locked', '', NULL),
(121, 0, [[timestamp]], 'backup', 'backup_import_competencies', '1', NULL),
(122, 0, [[timestamp]], 'backup', 'backup_import_competencies_locked', '', NULL),
(123, 0, [[timestamp]], 'backup', 'backup_import_customfield', '1', NULL),
(124, 0, [[timestamp]], 'backup', 'backup_import_customfield_locked', '', NULL),
(125, 0, [[timestamp]], 'backup', 'backup_import_contentbankcontent', '1', NULL),
(126, 0, [[timestamp]], 'backup', 'backup_import_contentbankcontent_locked', '', NULL),
(127, 0, [[timestamp]], 'backup', 'backup_import_legacyfiles', '1', NULL),
(128, 0, [[timestamp]], 'backup', 'backup_import_legacyfiles_locked', '', NULL),
(129, 0, [[timestamp]], 'backup', 'backup_auto_active', '0', NULL),
(130, 0, [[timestamp]], 'backup', 'backup_auto_weekdays', '0000000', NULL),
(131, 0, [[timestamp]], 'backup', 'backup_auto_hour', '0', NULL),
(132, 0, [[timestamp]], 'backup', 'backup_auto_minute', '0', NULL),
(133, 0, [[timestamp]], 'backup', 'backup_auto_storage', '0', NULL),
(134, 0, [[timestamp]], 'backup', 'backup_auto_destination', '', NULL),
(135, 0, [[timestamp]], 'backup', 'backup_auto_max_kept', '1', NULL),
(136, 0, [[timestamp]], 'backup', 'backup_auto_delete_days', '0', NULL),
(137, 0, [[timestamp]], 'backup', 'backup_auto_min_kept', '0', NULL),
(138, 0, [[timestamp]], 'backup', 'backup_shortname', '0', NULL),
(139, 0, [[timestamp]], 'backup', 'backup_auto_skip_hidden', '1', NULL),
(140, 0, [[timestamp]], 'backup', 'backup_auto_skip_modif_days', '30', NULL),
(141, 0, [[timestamp]], 'backup', 'backup_auto_skip_modif_prev', '0', NULL),
(142, 0, [[timestamp]], 'backup', 'backup_auto_users', '1', NULL),
(143, 0, [[timestamp]], 'backup', 'backup_auto_role_assignments', '1', NULL),
(144, 0, [[timestamp]], 'backup', 'backup_auto_activities', '1', NULL),
(145, 0, [[timestamp]], 'backup', 'backup_auto_blocks', '1', NULL),
(146, 0, [[timestamp]], 'backup', 'backup_auto_files', '1', NULL),
(147, 0, [[timestamp]], 'backup', 'backup_auto_filters', '1', NULL),
(148, 0, [[timestamp]], 'backup', 'backup_auto_comments', '1', NULL),
(149, 0, [[timestamp]], 'backup', 'backup_auto_badges', '1', NULL),
(150, 0, [[timestamp]], 'backup', 'backup_auto_calendarevents', '1', NULL),
(151, 0, [[timestamp]], 'backup', 'backup_auto_userscompletion', '1', NULL),
(152, 0, [[timestamp]], 'backup', 'backup_auto_logs', '0', NULL),
(153, 0, [[timestamp]], 'backup', 'backup_auto_histories', '0', NULL),
(154, 0, [[timestamp]], 'backup', 'backup_auto_groups', '1', NULL),
(155, 0, [[timestamp]], 'backup', 'backup_auto_competencies', '1', NULL),
(156, 0, [[timestamp]], 'backup', 'backup_auto_customfield', '1', NULL),
(157, 0, [[timestamp]], 'backup', 'backup_auto_contentbankcontent', '1', NULL),
(158, 0, [[timestamp]], 'backup', 'backup_auto_xapistate', '1', NULL),
(159, 0, [[timestamp]], 'backup', 'backup_auto_legacyfiles', '1', NULL),
(160, 0, [[timestamp]], 'restore', 'restore_general_users', '1', NULL),
(161, 0, [[timestamp]], 'restore', 'restore_general_users_locked', '', NULL),
(162, 0, [[timestamp]], 'restore', 'restore_general_enrolments', '1', NULL),
(163, 0, [[timestamp]], 'restore', 'restore_general_enrolments_locked', '', NULL),
(164, 0, [[timestamp]], 'restore', 'restore_general_role_assignments', '1', NULL),
(165, 0, [[timestamp]], 'restore', 'restore_general_role_assignments_locked', '', NULL),
(166, 0, [[timestamp]], 'restore', 'restore_general_permissions', '1', NULL),
(167, 0, [[timestamp]], 'restore', 'restore_general_permissions_locked', '', NULL),
(168, 0, [[timestamp]], 'restore', 'restore_general_activities', '1', NULL),
(169, 0, [[timestamp]], 'restore', 'restore_general_activities_locked', '', NULL),
(170, 0, [[timestamp]], 'restore', 'restore_general_blocks', '1', NULL),
(171, 0, [[timestamp]], 'restore', 'restore_general_blocks_locked', '', NULL),
(172, 0, [[timestamp]], 'restore', 'restore_general_filters', '1', NULL),
(173, 0, [[timestamp]], 'restore', 'restore_general_filters_locked', '', NULL),
(174, 0, [[timestamp]], 'restore', 'restore_general_comments', '1', NULL),
(175, 0, [[timestamp]], 'restore', 'restore_general_comments_locked', '', NULL),
(176, 0, [[timestamp]], 'restore', 'restore_general_badges', '1', NULL),
(177, 0, [[timestamp]], 'restore', 'restore_general_badges_locked', '', NULL),
(178, 0, [[timestamp]], 'restore', 'restore_general_calendarevents', '1', NULL),
(179, 0, [[timestamp]], 'restore', 'restore_general_calendarevents_locked', '', NULL),
(180, 0, [[timestamp]], 'restore', 'restore_general_userscompletion', '1', NULL),
(181, 0, [[timestamp]], 'restore', 'restore_general_userscompletion_locked', '', NULL),
(182, 0, [[timestamp]], 'restore', 'restore_general_logs', '1', NULL),
(183, 0, [[timestamp]], 'restore', 'restore_general_logs_locked', '', NULL),
(184, 0, [[timestamp]], 'restore', 'restore_general_histories', '1', NULL),
(185, 0, [[timestamp]], 'restore', 'restore_general_histories_locked', '', NULL),
(186, 0, [[timestamp]], 'restore', 'restore_general_groups', '1', NULL),
(187, 0, [[timestamp]], 'restore', 'restore_general_groups_locked', '', NULL),
(188, 0, [[timestamp]], 'restore', 'restore_general_competencies', '1', NULL),
(189, 0, [[timestamp]], 'restore', 'restore_general_competencies_locked', '', NULL),
(190, 0, [[timestamp]], 'restore', 'restore_general_customfield', '1', NULL),
(191, 0, [[timestamp]], 'restore', 'restore_general_customfield_locked', '', NULL),
(192, 0, [[timestamp]], 'restore', 'restore_general_contentbankcontent', '1', NULL),
(193, 0, [[timestamp]], 'restore', 'restore_general_contentbankcontent_locked', '', NULL),
(194, 0, [[timestamp]], 'restore', 'restore_general_xapistate', '1', NULL),
(195, 0, [[timestamp]], 'restore', 'restore_general_xapistate_locked', '', NULL),
(196, 0, [[timestamp]], 'restore', 'restore_general_legacyfiles', '1', NULL),
(197, 0, [[timestamp]], 'restore', 'restore_general_legacyfiles_locked', '', NULL),
(198, 0, [[timestamp]], 'restore', 'restore_merge_overwrite_conf', '0', NULL),
(199, 0, [[timestamp]], 'restore', 'restore_merge_overwrite_conf_locked', '', NULL),
(200, 0, [[timestamp]], 'restore', 'restore_merge_course_fullname', '1', NULL),
(201, 0, [[timestamp]], 'restore', 'restore_merge_course_fullname_locked', '', NULL),
(202, 0, [[timestamp]], 'restore', 'restore_merge_course_shortname', '1', NULL),
(203, 0, [[timestamp]], 'restore', 'restore_merge_course_shortname_locked', '', NULL),
(204, 0, [[timestamp]], 'restore', 'restore_merge_course_startdate', '1', NULL),
(205, 0, [[timestamp]], 'restore', 'restore_merge_course_startdate_locked', '', NULL),
(206, 0, [[timestamp]], 'restore', 'restore_replace_overwrite_conf', '0', NULL),
(207, 0, [[timestamp]], 'restore', 'restore_replace_overwrite_conf_locked', '', NULL),
(208, 0, [[timestamp]], 'restore', 'restore_replace_course_fullname', '1', NULL),
(209, 0, [[timestamp]], 'restore', 'restore_replace_course_fullname_locked', '', NULL),
(210, 0, [[timestamp]], 'restore', 'restore_replace_course_shortname', '1', NULL),
(211, 0, [[timestamp]], 'restore', 'restore_replace_course_shortname_locked', '', NULL),
(212, 0, [[timestamp]], 'restore', 'restore_replace_course_startdate', '1', NULL),
(213, 0, [[timestamp]], 'restore', 'restore_replace_course_startdate_locked', '', NULL),
(214, 0, [[timestamp]], 'restore', 'restore_replace_keep_roles_and_enrolments', '0', NULL),
(215, 0, [[timestamp]], 'restore', 'restore_replace_keep_roles_and_enrolments_locked', '', NULL),
(216, 0, [[timestamp]], 'restore', 'restore_replace_keep_groups_and_groupings', '0', NULL),
(217, 0, [[timestamp]], 'restore', 'restore_replace_keep_groups_and_groupings_locked', '', NULL),
(218, 0, [[timestamp]], NULL, 'enableasyncbackup', '1', NULL),
(219, 0, [[timestamp]], 'backup', 'backup_async_message_users', '1', NULL),
(220, 0, [[timestamp]], 'backup', 'backup_async_message_subject', 'Moodle {operation} completed successfully', NULL),
(221, 0, [[timestamp]], 'backup', 'backup_async_message', 'Your {operation} (ID: {backupid}) has completed successfully. You can access it here: <a href="{link}">{link}</a>.', NULL),
(222, 0, [[timestamp]], NULL, 'downloadcoursecontentallowed', '0', NULL),
(223, 0, [[timestamp]], NULL, 'maxsizeperdownloadcoursefile', '52428800', NULL),
(224, 0, [[timestamp]], NULL, 'enablecourserequests', '1', NULL),
(225, 0, [[timestamp]], NULL, 'defaultrequestcategory', '1', NULL),
(226, 0, [[timestamp]], NULL, 'lockrequestcategory', '0', NULL),
(227, 0, [[timestamp]], NULL, 'courserequestnotify', '', NULL),
(228, 0, [[timestamp]], NULL, 'grade_report_showonlyactiveenrol', '1', NULL),
(229, 0, [[timestamp]], NULL, 'grade_report_quickgrading', '1', NULL),
(230, 0, [[timestamp]], NULL, 'grade_report_meanselection', '1', NULL),
(231, 0, [[timestamp]], NULL, 'grade_report_showaverages', '1', NULL),
(232, 0, [[timestamp]], NULL, 'grade_report_showranges', '0', NULL),
(233, 0, [[timestamp]], NULL, 'grade_report_showuserimage', '1', NULL),
(234, 0, [[timestamp]], NULL, 'grade_report_shownumberofgrades', '0', NULL),
(235, 0, [[timestamp]], NULL, 'grade_report_averagesdisplaytype', 'inherit', NULL),
(236, 0, [[timestamp]], NULL, 'grade_report_rangesdisplaytype', 'inherit', NULL),
(237, 0, [[timestamp]], NULL, 'grade_report_averagesdecimalpoints', 'inherit', NULL),
(238, 0, [[timestamp]], NULL, 'grade_report_rangesdecimalpoints', 'inherit', NULL),
(239, 0, [[timestamp]], NULL, 'grade_report_historyperpage', '50', NULL),
(240, 0, [[timestamp]], NULL, 'grade_report_overview_showrank', '0', NULL),
(241, 0, [[timestamp]], NULL, 'grade_report_overview_showtotalsifcontainhidden', '0', NULL),
(242, 0, [[timestamp]], NULL, 'grade_report_user_showrank', '0', NULL),
(243, 0, [[timestamp]], NULL, 'grade_report_user_showpercentage', '1', NULL),
(244, 0, [[timestamp]], NULL, 'grade_report_user_showgrade', '1', NULL),
(245, 0, [[timestamp]], NULL, 'grade_report_user_showfeedback', '1', NULL),
(246, 0, [[timestamp]], NULL, 'grade_report_user_showrange', '1', NULL),
(247, 0, [[timestamp]], NULL, 'grade_report_user_showweight', '1', NULL),
(248, 0, [[timestamp]], NULL, 'grade_report_user_showaverage', '0', NULL),
(249, 0, [[timestamp]], NULL, 'grade_report_user_showlettergrade', '0', NULL),
(250, 0, [[timestamp]], NULL, 'grade_report_user_rangedecimals', '0', NULL),
(251, 0, [[timestamp]], NULL, 'grade_report_user_showhiddenitems', '1', NULL),
(252, 0, [[timestamp]], NULL, 'grade_report_user_showtotalsifcontainhidden', '0', NULL),
(253, 0, [[timestamp]], NULL, 'grade_report_user_showcontributiontocoursetotal', '1', NULL),
(254, 0, [[timestamp]], NULL, 'gradepenalty_enabledmodules', '', NULL),
(255, 0, [[timestamp]], NULL, 'grade_profilereport', 'user', NULL),
(256, 0, [[timestamp]], NULL, 'grade_aggregationposition', '1', NULL),
(257, 0, [[timestamp]], NULL, 'grade_includescalesinaggregation', '1', NULL),
(258, 0, [[timestamp]], NULL, 'grade_hiddenasdate', '0', NULL),
(259, 0, [[timestamp]], NULL, 'gradepublishing', '0', NULL),
(260, 0, [[timestamp]], NULL, 'grade_export_exportfeedback', '0', NULL),
(261, 0, [[timestamp]], NULL, 'grade_export_displaytype', '1', NULL),
(262, 0, [[timestamp]], NULL, 'grade_export_decimalpoints', '2', NULL),
(263, 0, [[timestamp]], NULL, 'grade_export_userprofilefields', 'firstname,lastname,idnumber,institution,department,email', NULL),
(264, 0, [[timestamp]], NULL, 'grade_export_customprofilefields', '', NULL),
(265, 0, [[timestamp]], NULL, 'recovergradesdefault', '0', NULL),
(266, 0, [[timestamp]], NULL, 'gradeexport', '', NULL),
(267, 0, [[timestamp]], NULL, 'gradeexport_default', 'ods', NULL),
(268, 0, [[timestamp]], NULL, 'unlimitedgrades', '0', NULL),
(269, 0, [[timestamp]], NULL, 'grade_report_showmin', '1', NULL),
(270, 0, [[timestamp]], NULL, 'gradepointmax', '100', NULL),
(271, 0, [[timestamp]], NULL, 'gradepointdefault', '100', NULL),
(272, 0, [[timestamp]], NULL, 'grade_minmaxtouse', '1', NULL),
(273, 0, [[timestamp]], NULL, 'grade_mygrades_report', 'overview', NULL),
(274, 0, [[timestamp]], NULL, 'gradereport_mygradeurl', '', NULL),
(275, 0, [[timestamp]], NULL, 'grade_hideforcedsettings', '1', NULL),
(276, 0, [[timestamp]], NULL, 'grade_aggregation', '13', NULL),
(277, 0, [[timestamp]], NULL, 'grade_aggregation_flag', '0', NULL),
(278, 0, [[timestamp]], NULL, 'grade_aggregations_visible', '13', NULL),
(279, 0, [[timestamp]], NULL, 'grade_aggregateonlygraded', '1', NULL),
(280, 0, [[timestamp]], NULL, 'grade_aggregateonlygraded_flag', '0', NULL),
(281, 0, [[timestamp]], NULL, 'grade_aggregateoutcomes', '0', NULL),
(282, 0, [[timestamp]], NULL, 'grade_aggregateoutcomes_flag', '0', NULL),
(283, 0, [[timestamp]], NULL, 'grade_keephigh', '0', NULL),
(284, 0, [[timestamp]], NULL, 'grade_keephigh_flag', '1', NULL),
(285, 0, [[timestamp]], NULL, 'grade_droplow', '0', NULL),
(286, 0, [[timestamp]], NULL, 'grade_droplow_flag', '0', NULL),
(287, 0, [[timestamp]], NULL, 'grade_overridecat', '1', NULL),
(288, 0, [[timestamp]], NULL, 'grade_displaytype', '1', NULL),
(289, 0, [[timestamp]], NULL, 'grade_decimalpoints', '2', NULL),
(290, 0, [[timestamp]], 'analytics', 'modeinstruction', '', NULL),
(291, 0, [[timestamp]], 'analytics', 'percentonline', '0', NULL),
(292, 0, [[timestamp]], 'analytics', 'typeinstitution', '', NULL),
(293, 0, [[timestamp]], 'analytics', 'levelinstitution', '', NULL),
(294, 0, [[timestamp]], 'analytics', 'predictionsprocessor', '\\mlbackend_python\\processor', NULL),
(295, 0, [[timestamp]], 'analytics', 'defaulttimesplittingsevaluation', '\\core\\analytics\\time_splitting\\quarters_accum,\\core\\analytics\\time_splitting\\quarters,\\core\\analytics\\time_splitting\\single_range', NULL),
(296, 0, [[timestamp]], 'analytics', 'modeloutputdir', '', NULL),
(297, 0, [[timestamp]], 'analytics', 'onlycli', '1', NULL),
(298, 0, [[timestamp]], 'analytics', 'modeltimelimit', '1200', NULL),
(299, 0, [[timestamp]], 'analytics', 'calclifetime', '35', NULL),
(300, 0, [[timestamp]], NULL, 'badges_defaultissuername', '', NULL),
(301, 0, [[timestamp]], NULL, 'badges_defaultissuercontact', '', NULL),
(302, 0, [[timestamp]], NULL, 'badges_badgesalt', 'badges[[timestamp]]', NULL),
(303, 0, [[timestamp]], NULL, 'badges_allowcoursebadges', '1', NULL),
(304, 0, [[timestamp]], NULL, 'badges_allowexternalbackpack', '1', NULL),
(305, 0, [[timestamp]], NULL, 'badges_canvasregions', 'Australia|https://au.badgr.io|https://api.au.badgr.io/v2\nCanada|https://ca.badgr.io|https://api.ca.badgr.io/v2\nEurope|https://eu.badgr.io|https://api.eu.badgr.io/v2\nSingapore|https://sg.badgr.io|https://api.sg.badgr.io/v2\nUnited States|https://badgr.io|https://api.badgr.io/v2', NULL),
(306, 0, [[timestamp]], 'core_h5p', 'h5pcustomcss', '', NULL),
(307, 0, [[timestamp]], NULL, 'rememberuserlicensepref', '1', NULL),
(308, 0, [[timestamp]], NULL, 'timezone', 'America/New_York', NULL),
(309, 0, [[timestamp]], NULL, 'forcetimezone', '99', NULL),
(310, 0, [[timestamp]], NULL, 'country', '0', NULL),
(311, 0, [[timestamp]], NULL, 'defaultcity', '', NULL),
(312, 0, [[timestamp]], NULL, 'allcountrycodes', '', NULL),
(313, 0, [[timestamp]], NULL, 'geoip2file', '[[softdatadir]]/geoip/GeoIP-City.mmdb', NULL),
(314, 0, [[timestamp]], NULL, 'geoipdbedition', 'GeoLite2-City', NULL),
(315, 0, [[timestamp]], NULL, 'geoipmaxmindaccid', '', NULL),
(316, 0, [[timestamp]], NULL, 'geoipmaxmindlicensekey', '', NULL),
(317, 0, [[timestamp]], NULL, 'googlemapkey3', '', NULL),
(318, 0, [[timestamp]], NULL, 'geopluginapikey', '', NULL),
(319, 0, [[timestamp]], NULL, 'autolang', '1', NULL),
(320, 0, [[timestamp]], NULL, 'lang', 'en', NULL),
(321, 0, [[timestamp]], NULL, 'autolangusercreation', '1', NULL),
(322, 0, [[timestamp]], NULL, 'langmenu', '1', NULL),
(323, 0, [[timestamp]], NULL, 'langlist', '', NULL),
(324, 0, [[timestamp]], NULL, 'langcache', '1', NULL),
(325, 0, [[timestamp]], NULL, 'langstringcache', '1', NULL),
(326, 0, [[timestamp]], NULL, 'locale', '', NULL),
(327, 0, [[timestamp]], NULL, 'latinexcelexport', '0', NULL),
(328, 0, [[timestamp]], NULL, 'enablepdfexportfont', '0', NULL),
(329, 0, [[timestamp]], NULL, 'messagingallusers', '0', NULL),
(330, 0, [[timestamp]], NULL, 'messagingdefaultpressenter', '1', NULL),
(331, 0, [[timestamp]], NULL, 'messagingdeletereadnotificationsdelay', '604800', NULL),
(332, 0, [[timestamp]], NULL, 'messagingdeleteallnotificationsdelay', '2620800', NULL),
(333, 0, [[timestamp]], NULL, 'messagingallowemailoverride', '0', NULL),
(334, 0, [[timestamp]], NULL, 'requiremodintro', '0', NULL),
(335, 0, [[timestamp]], 'antivirus', 'notifyemail', '', NULL),
(336, 0, [[timestamp]], 'antivirus', 'notifylevel', '2', NULL),
(337, 0, [[timestamp]], 'antivirus', 'threshold', '1200', NULL),
(338, 0, [[timestamp]], 'antivirus', 'enablequarantine', '0', NULL),
(339, 0, [[timestamp]], 'antivirus', 'quarantinetime', '2419200', NULL),
(340, 0, [[timestamp]], NULL, 'registerauth', '', NULL),
(341, 0, [[timestamp]], NULL, 'authloginviaemail', '0', NULL),
(342, 0, [[timestamp]], NULL, 'allowaccountssameemail', '0', NULL),
(343, 0, [[timestamp]], NULL, 'authpreventaccountcreation', '0', NULL),
(344, 0, [[timestamp]], NULL, 'loginpageautofocus', '0', NULL),
(345, 0, [[timestamp]], NULL, 'guestloginbutton', '1', NULL),
(346, 0, [[timestamp]], NULL, 'limitconcurrentlogins', '0', NULL),
(347, 0, [[timestamp]], NULL, 'alternateloginurl', '', NULL),
(348, 0, [[timestamp]], NULL, 'showloginform', '1', NULL),
(349, 0, [[timestamp]], NULL, 'forgottenpasswordurl', '', NULL),
(350, 0, [[timestamp]], NULL, 'auth_instructions', '', NULL),
(351, 0, [[timestamp]], NULL, 'allowemailaddresses', '', NULL),
(352, 0, [[timestamp]], NULL, 'denyemailaddresses', '', NULL),
(353, 0, [[timestamp]], NULL, 'verifychangedemail', '1', NULL),
(354, 0, [[timestamp]], NULL, 'enableloginrecaptcha', '0', NULL),
(355, 0, [[timestamp]], NULL, 'enableforgotpasswordrecaptcha', '0', NULL),
(356, 0, [[timestamp]], NULL, 'recaptchapublickey', '', NULL),
(357, 0, [[timestamp]], NULL, 'recaptchaprivatekey', '', NULL),
(358, 0, [[timestamp]], NULL, 'loginpasswordtoggle', '2', NULL),
(359, 0, [[timestamp]], 'cachestore_apcu', 'testperformance', '0', NULL),
(360, 0, [[timestamp]], 'cachestore_redis', 'test_clustermode', '0', NULL),
(361, 0, [[timestamp]], 'cachestore_redis', 'test_server', '', NULL),
(362, 0, [[timestamp]], 'cachestore_redis', 'test_encryption', '0', NULL),
(363, 0, [[timestamp]], 'cachestore_redis', 'test_cafile', '', NULL),
(364, 0, [[timestamp]], 'cachestore_redis', 'test_password', '', NULL),
(365, 0, [[timestamp]], 'cachestore_redis', 'test_ttl', '0', NULL),
(366, 0, [[timestamp]], NULL, 'filteruploadedfiles', '0', NULL),
(367, 0, [[timestamp]], NULL, 'filtermatchoneperpage', '0', NULL),
(368, 0, [[timestamp]], NULL, 'filtermatchonepertext', '0', NULL),
(369, 0, [[timestamp]], NULL, 'filternavigationwithsystemcontext', '1', NULL),
(370, 0, [[timestamp]], NULL, 'media_default_width', '640', NULL),
(371, 0, [[timestamp]], NULL, 'media_default_height', '360', NULL),
(372, 0, [[timestamp]], NULL, 'portfolio_moderate_filesize_threshold', '1048576', NULL),
(373, 0, [[timestamp]], NULL, 'portfolio_high_filesize_threshold', '5242880', NULL),
(374, 0, [[timestamp]], NULL, 'portfolio_moderate_db_threshold', '20', NULL),
(375, 0, [[timestamp]], NULL, 'portfolio_high_db_threshold', '50', NULL),
(376, 0, [[timestamp]], 'question_preview', 'behaviour', 'deferredfeedback', NULL),
(377, 0, [[timestamp]], 'question_preview', 'correctness', '1', NULL),
(378, 0, [[timestamp]], 'question_preview', 'marks', '2', NULL),
(379, 0, [[timestamp]], 'question_preview', 'markdp', '2', NULL),
(380, 0, [[timestamp]], 'question_preview', 'feedback', '1', NULL),
(381, 0, [[timestamp]], 'question_preview', 'generalfeedback', '1', NULL),
(382, 0, [[timestamp]], 'question_preview', 'rightanswer', '1', NULL),
(383, 0, [[timestamp]], 'question_preview', 'history', '0', NULL),
(384, 0, [[timestamp]], NULL, 'questiondefaultssave', '1', NULL),
(385, 0, [[timestamp]], NULL, 'repositorycacheexpire', '120', NULL),
(386, 0, [[timestamp]], NULL, 'repositorygetfiletimeout', '30', NULL),
(387, 0, [[timestamp]], NULL, 'repositorysyncfiletimeout', '1', NULL),
(388, 0, [[timestamp]], NULL, 'repositorysyncimagetimeout', '3', NULL),
(389, 0, [[timestamp]], NULL, 'repositoryallowexternallinks', '1', NULL),
(390, 0, [[timestamp]], NULL, 'legacyfilesinnewcourses', '0', NULL),
(391, 0, [[timestamp]], NULL, 'legacyfilesaddallowed', '1', NULL),
(392, 0, [[timestamp]], NULL, 'searchengine', 'simpledb', NULL),
(393, 0, [[timestamp]], NULL, 'searchindexwhendisabled', '0', NULL),
(394, 0, [[timestamp]], NULL, 'searchindextime', '600', NULL),
(395, 0, [[timestamp]], NULL, 'searchallavailablecourses', '0', NULL),
(396, 0, [[timestamp]], NULL, 'searchincludeallcourses', '0', NULL),
(397, 0, [[timestamp]], NULL, 'searchenablecategories', '0', NULL),
(398, 0, [[timestamp]], NULL, 'searchdefaultcategory', 'core-all', NULL),
(399, 0, [[timestamp]], NULL, 'searchhideallcategory', '0', NULL),
(400, 0, [[timestamp]], NULL, 'searchmaxtopresults', '3', NULL),
(401, 0, [[timestamp]], NULL, 'searchteacherroles', '', NULL),
(402, 0, [[timestamp]], NULL, 'searchenginequeryonly', '', NULL),
(403, 0, [[timestamp]], NULL, 'searchbannerenable', '0', NULL),
(404, 0, [[timestamp]], NULL, 'searchbanner', '', NULL),
(405, 0, [[timestamp]], NULL, 'allowbeforeblock', '0', NULL),
(406, 0, [[timestamp]], NULL, 'allowedip', '', NULL),
(407, 0, [[timestamp]], NULL, 'blockedip', '', NULL),
(408, 0, [[timestamp]], NULL, 'protectusernames', '1', NULL),
(409, 0, [[timestamp]], NULL, 'forcelogin', '0', NULL),
(410, 0, [[timestamp]], NULL, 'forceloginforprofiles', '1', NULL),
(411, 0, [[timestamp]], NULL, 'forceloginforprofileimage', '0', NULL),
(412, 0, [[timestamp]], NULL, 'opentowebcrawlers', '0', NULL),
(413, 0, [[timestamp]], NULL, 'allowindexing', '0', NULL),
(414, 0, [[timestamp]], NULL, 'maxbytes', '0', NULL),
(415, 0, [[timestamp]], NULL, 'userquota', '104857600', NULL),
(416, 0, [[timestamp]], NULL, 'allowobjectembed', '0', NULL),
(417, 0, [[timestamp]], NULL, 'enabletrusttext', '0', NULL),
(418, 0, [[timestamp]], NULL, 'maxeditingtime', '1800', NULL),
(419, 0, [[timestamp]], NULL, 'extendedusernamechars', '0', NULL),
(420, 0, [[timestamp]], NULL, 'keeptagnamecase', '1', NULL),
(421, 0, [[timestamp]], NULL, 'profilesforenrolledusersonly', '1', NULL),
(422, 0, [[timestamp]], NULL, 'cronclionly', '1', NULL),
(423, 0, [[timestamp]], NULL, 'cronremotepassword', '', NULL),
(424, 0, [[timestamp]], 'tool_task', 'enablerunnow', '1', NULL),
(425, 0, [[timestamp]], NULL, 'lockoutthreshold', '0', NULL),
(426, 0, [[timestamp]], NULL, 'lockoutwindow', '1800', NULL),
(427, 0, [[timestamp]], NULL, 'lockoutduration', '1800', NULL),
(428, 0, [[timestamp]], NULL, 'passwordpolicy', '1', NULL),
(429, 0, [[timestamp]], NULL, 'minpasswordlength', '8', NULL),
(430, 0, [[timestamp]], NULL, 'minpassworddigits', '1', NULL),
(431, 0, [[timestamp]], NULL, 'minpasswordlower', '1', NULL),
(432, 0, [[timestamp]], NULL, 'minpasswordupper', '1', NULL),
(433, 0, [[timestamp]], NULL, 'minpasswordnonalphanum', '1', NULL),
(434, 0, [[timestamp]], NULL, 'maxconsecutiveidentchars', '0', NULL),
(435, 0, [[timestamp]], NULL, 'passwordpolicycheckonlogin', '0', NULL),
(436, 0, [[timestamp]], NULL, 'passwordreuselimit', '0', NULL),
(437, 0, [[timestamp]], NULL, 'pwresettime', '1800', NULL),
(438, 0, [[timestamp]], NULL, 'passwordchangelogout', '1', NULL),
(439, 0, [[timestamp]], NULL, 'passwordchangetokendeletion', '0', NULL),
(440, 0, [[timestamp]], NULL, 'tokenduration', '7257600', NULL),
(441, 0, [[timestamp]], NULL, 'groupenrolmentkeypolicy', '1', NULL),
(442, 0, [[timestamp]], NULL, 'disableuserimages', '0', NULL),
(443, 0, [[timestamp]], NULL, 'emailchangeconfirmation', '1', NULL),
(444, 0, [[timestamp]], NULL, 'rememberusername', '2', NULL),
(445, 0, [[timestamp]], NULL, 'strictformsrequired', '0', NULL),
(446, 0, [[timestamp]], 'adminpresets', 'sensiblesettings', 'recaptchapublickey@@none, recaptchaprivatekey@@none, googlemapkey3@@none, secretphrase@@url, cronremotepassword@@none, smtpuser@@none, smtppass@@none, proxypassword@@none, quizpassword@@quiz, allowedip@@none, blockedip@@none, dbpass@@logstore_database, messageinbound_hostpass@@none, pass@@auth_db, bind_pw@@auth_ldap, dbpass@@enrol_database, bind_pw@@enrol_ldap, server_password@@search_solr, ssl_keypassword@@search_solr, alternateserver_password@@search_solr, alternatessl_keypassword@@search_solr, test_password@@cachestore_redis, password@@mlbackend_python, badges_badgesalt@@none, calendar_exportsalt@@none, bigbluebuttonbn_shared_secret@@none, apikey@@tiny_premium, matrixaccesstoken@@communication_matrix, api_secret@@factor_sms', NULL),
(447, 0, [[timestamp]], NULL, 'cookiesecure', '1', NULL),
(448, 0, [[timestamp]], NULL, 'allowframembedding', '0', NULL),
(449, 0, [[timestamp]], NULL, 'curlsecurityblockedhosts', '127.0.0.0/8\n192.168.0.0/16\n10.0.0.0/8\n172.16.0.0/12\n0.0.0.0\nlocalhost\n169.254.169.254\n0000::1', NULL),
(450, 0, [[timestamp]], NULL, 'curlsecurityallowedport', '443\n80', NULL),
(451, 0, [[timestamp]], NULL, 'referrerpolicy', 'default', NULL),
(452, 0, [[timestamp]], NULL, 'displayloginfailures', '0', NULL),
(453, 0, [[timestamp]], NULL, 'notifyloginfailures', '', NULL),
(454, 0, [[timestamp]], NULL, 'notifyloginthreshold', '10', NULL),
(455, 0, [[timestamp]], 'theme_boost', 'unaddableblocks', 'navigation,settings,course_list', NULL),
(456, 0, [[timestamp]], 'theme_boost', 'preset', 'default.scss', NULL),
(457, 0, [[timestamp]], 'theme_boost', 'presetfiles', '', NULL),
(458, 0, [[timestamp]], 'theme_boost', 'backgroundimage', '', NULL),
(459, 0, [[timestamp]], 'theme_boost', 'loginbackgroundimage', '', NULL),
(460, 0, [[timestamp]], 'theme_boost', 'brandcolor', '', NULL),
(461, 0, [[timestamp]], 'theme_boost', 'scsspre', '', NULL),
(462, 0, [[timestamp]], 'theme_boost', 'scss', '', NULL),
(463, 0, [[timestamp]], 'theme_classic', 'navbardark', '0', NULL),
(464, 0, [[timestamp]], 'theme_classic', 'unaddableblocks', '', NULL),
(465, 0, [[timestamp]], 'theme_classic', 'preset', 'default.scss', NULL),
(466, 0, [[timestamp]], 'theme_classic', 'presetfiles', '', NULL),
(467, 0, [[timestamp]], 'theme_classic', 'backgroundimage', '', NULL),
(468, 0, [[timestamp]], 'theme_classic', 'loginbackgroundimage', '', NULL),
(469, 0, [[timestamp]], 'theme_classic', 'brandcolor', '', NULL),
(470, 0, [[timestamp]], 'theme_classic', 'scsspre', '', NULL),
(471, 0, [[timestamp]], 'theme_classic', 'scss', '', NULL),
(472, 0, [[timestamp]], 'core_admin', 'logo', '', NULL),
(473, 0, [[timestamp]], 'core_admin', 'logocompact', '', NULL),
(474, 0, [[timestamp]], 'core_admin', 'favicon', '', NULL),
(475, 0, [[timestamp]], 'core_admin', 'coursecolor1', '#81ecec', NULL),
(476, 0, [[timestamp]], 'core_admin', 'coursecolor2', '#74b9ff', NULL),
(477, 0, [[timestamp]], 'core_admin', 'coursecolor3', '#a29bfe', NULL),
(478, 0, [[timestamp]], 'core_admin', 'coursecolor4', '#dfe6e9', NULL),
(479, 0, [[timestamp]], 'core_admin', 'coursecolor5', '#00b894', NULL),
(480, 0, [[timestamp]], 'core_admin', 'coursecolor6', '#0984e3', NULL),
(481, 0, [[timestamp]], 'core_admin', 'coursecolor7', '#b2bec3', NULL),
(482, 0, [[timestamp]], 'core_admin', 'coursecolor8', '#fdcb6e', NULL),
(483, 0, [[timestamp]], 'core_admin', 'coursecolor9', '#fd79a8', NULL),
(484, 0, [[timestamp]], 'core_admin', 'coursecolor10', '#6c5ce7', NULL),
(485, 0, [[timestamp]], NULL, 'calendartype', 'gregorian', NULL),
(486, 0, [[timestamp]], NULL, 'calendar_adminseesall', '0', NULL),
(487, 0, [[timestamp]], NULL, 'calendar_site_timeformat', '0', NULL),
(488, 0, [[timestamp]], NULL, 'calendar_startwday', '1', NULL),
(489, 0, [[timestamp]], NULL, 'calendar_weekend', '65', NULL),
(490, 0, [[timestamp]], NULL, 'calendar_lookahead', '21', NULL),
(491, 0, [[timestamp]], NULL, 'calendar_maxevents', '10', NULL),
(492, 0, [[timestamp]], NULL, 'enablecalendarexport', '1', NULL),
(493, 0, [[timestamp]], NULL, 'calendar_customexport', '1', NULL),
(494, 0, [[timestamp]], NULL, 'calendar_exportlookahead', '365', NULL),
(495, 0, [[timestamp]], NULL, 'calendar_exportlookback', '5', NULL),
(496, 0, [[timestamp]], NULL, 'calendar_exportsalt', '[[export_salt_old]]', NULL),
(497, 0, [[timestamp]], NULL, 'calendar_showicalsource', '1', NULL),
(498, 0, [[timestamp]], NULL, 'useblogassociations', '1', NULL),
(499, 0, [[timestamp]], NULL, 'bloglevel', '4', NULL),
(500, 0, [[timestamp]], NULL, 'useexternalblogs', '1', NULL),
(501, 0, [[timestamp]], NULL, 'externalblogcrontime', '86400', NULL),
(502, 0, [[timestamp]], NULL, 'maxexternalblogsperuser', '1', NULL),
(503, 0, [[timestamp]], NULL, 'blogusecomments', '1', NULL),
(504, 0, [[timestamp]], NULL, 'blogshowcommentscount', '1', NULL),
(505, 0, [[timestamp]], NULL, 'enabledashboard', '1', NULL),
(506, 0, [[timestamp]], NULL, 'defaulthomepage', '1', NULL),
(507, 0, [[timestamp]], NULL, 'allowguestmymoodle', '1', NULL),
(508, 0, [[timestamp]], NULL, 'navshowfullcoursenames', '0', NULL),
(509, 0, [[timestamp]], NULL, 'navshowcategories', '1', NULL),
(510, 0, [[timestamp]], NULL, 'navshowmycoursecategories', '0', NULL),
(511, 0, [[timestamp]], NULL, 'navshowallcourses', '0', NULL),
(512, 0, [[timestamp]], NULL, 'navsortmycoursessort', 'sortorder', NULL),
(513, 0, [[timestamp]], NULL, 'navsortmycourseshiddenlast', '1', NULL),
(514, 0, [[timestamp]], NULL, 'navcourselimit', '10', NULL),
(515, 0, [[timestamp]], NULL, 'usesitenameforsitepages', '0', NULL),
(516, 0, [[timestamp]], NULL, 'linkadmincategories', '1', NULL),
(517, 0, [[timestamp]], NULL, 'navshowfrontpagemods', '1', NULL),
(518, 0, [[timestamp]], NULL, 'navadduserpostslinks', '1', NULL),
(519, 0, [[timestamp]], NULL, 'sitenameintitle', 'shortname', NULL),
(520, 0, [[timestamp]], NULL, 'formatstringstriptags', '1', NULL),
(521, 0, [[timestamp]], NULL, 'emoticons', '[{"text":":-)","imagename":"s\\/smiley","imagecomponent":"core","altidentifier":"smiley","altcomponent":"core_pix"},{"text":":)","imagename":"s\\/smiley","imagecomponent":"core","altidentifier":"smiley","altcomponent":"core_pix"},{"text":":-D","imagename":"s\\/biggrin","imagecomponent":"core","altidentifier":"biggrin","altcomponent":"core_pix"},{"text":";-)","imagename":"s\\/wink","imagecomponent":"core","altidentifier":"wink","altcomponent":"core_pix"},{"text":":-\\/","imagename":"s\\/mixed","imagecomponent":"core","altidentifier":"mixed","altcomponent":"core_pix"},{"text":"V-.","imagename":"s\\/thoughtful","imagecomponent":"core","altidentifier":"thoughtful","altcomponent":"core_pix"},{"text":":-P","imagename":"s\\/tongueout","imagecomponent":"core","altidentifier":"tongueout","altcomponent":"core_pix"},{"text":":-p","imagename":"s\\/tongueout","imagecomponent":"core","altidentifier":"tongueout","altcomponent":"core_pix"},{"text":"B-)","imagename":"s\\/cool","imagecomponent":"core","altidentifier":"cool","altcomponent":"core_pix"},{"text":"^-)","imagename":"s\\/approve","imagecomponent":"core","altidentifier":"approve","altcomponent":"core_pix"},{"text":"8-)","imagename":"s\\/wideeyes","imagecomponent":"core","altidentifier":"wideeyes","altcomponent":"core_pix"},{"text":":o)","imagename":"s\\/clown","imagecomponent":"core","altidentifier":"clown","altcomponent":"core_pix"},{"text":":-(","imagename":"s\\/sad","imagecomponent":"core","altidentifier":"sad","altcomponent":"core_pix"},{"text":":(","imagename":"s\\/sad","imagecomponent":"core","altidentifier":"sad","altcomponent":"core_pix"},{"text":"8-.","imagename":"s\\/shy","imagecomponent":"core","altidentifier":"shy","altcomponent":"core_pix"},{"text":":-I","imagename":"s\\/blush","imagecomponent":"core","altidentifier":"blush","altcomponent":"core_pix"},{"text":":-X","imagename":"s\\/kiss","imagecomponent":"core","altidentifier":"kiss","altcomponent":"core_pix"},{"text":"8-o","imagename":"s\\/surprise","imagecomponent":"core","altidentifier":"surprise","altcomponent":"core_pix"},{"text":"P-|","imagename":"s\\/blackeye","imagecomponent":"core","altidentifier":"blackeye","altcomponent":"core_pix"},{"text":"8-[","imagename":"s\\/angry","imagecomponent":"core","altidentifier":"angry","altcomponent":"core_pix"},{"text":"(grr)","imagename":"s\\/angry","imagecomponent":"core","altidentifier":"angry","altcomponent":"core_pix"},{"text":"xx-P","imagename":"s\\/dead","imagecomponent":"core","altidentifier":"dead","altcomponent":"core_pix"},{"text":"|-.","imagename":"s\\/sleepy","imagecomponent":"core","altidentifier":"sleepy","altcomponent":"core_pix"},{"text":"}-]","imagename":"s\\/evil","imagecomponent":"core","altidentifier":"evil","altcomponent":"core_pix"},{"text":"(h)","imagename":"s\\/heart","imagecomponent":"core","altidentifier":"heart","altcomponent":"core_pix"},{"text":"(heart)","imagename":"s\\/heart","imagecomponent":"core","altidentifier":"heart","altcomponent":"core_pix"},{"text":"(y)","imagename":"s\\/yes","imagecomponent":"core","altidentifier":"yes","altcomponent":"core"},{"text":"(n)","imagename":"s\\/no","imagecomponent":"core","altidentifier":"no","altcomponent":"core"},{"text":"(martin)","imagename":"s\\/martin","imagecomponent":"core","altidentifier":"martin","altcomponent":"core_pix"},{"text":"( )","imagename":"s\\/egg","imagecomponent":"core","altidentifier":"egg","altcomponent":"core_pix"}]', NULL),
(522, 0, [[timestamp]], NULL, 'docroot', 'https://docs.moodle.org', NULL),
(523, 0, [[timestamp]], NULL, 'doclang', '', NULL),
(524, 0, [[timestamp]], NULL, 'doctonewwindow', '0', NULL),
(525, 0, [[timestamp]], NULL, 'coursecreationguide', 'https://moodle.academy/coursequickstart', NULL),
(526, 0, [[timestamp]], NULL, 'coursecontactduplicates', '0', NULL),
(527, 0, [[timestamp]], NULL, 'courselistshortnames', '0', NULL),
(528, 0, [[timestamp]], NULL, 'coursesperpage', '20', NULL),
(529, 0, [[timestamp]], NULL, 'courseswithsummarieslimit', '10', NULL),
(530, 0, [[timestamp]], NULL, 'courseoverviewfileslimit', '1', NULL),
(531, 0, [[timestamp]], NULL, 'courseoverviewfilesext', 'web_image', NULL),
(532, 0, [[timestamp]], NULL, 'coursegraceperiodbefore', '0', NULL),
(533, 0, [[timestamp]], NULL, 'coursegraceperiodafter', '0', NULL),
(534, 0, [[timestamp]], NULL, 'yuicomboloading', '1', NULL),
(535, 0, [[timestamp]], NULL, 'cachejs', '1', NULL),
(536, 0, [[timestamp]], NULL, 'additionalhtmlhead', '', NULL),
(537, 0, [[timestamp]], NULL, 'additionalhtmltopofbody', '', NULL),
(538, 0, [[timestamp]], NULL, 'additionalhtmlfooter', '', NULL),
(539, 0, [[timestamp]], NULL, 'cachetemplates', '1', NULL),
(540, 0, [[timestamp]], NULL, 'themelist', '', NULL),
(541, 0, [[timestamp]], NULL, 'themedesignermode', '0', NULL),
(542, 0, [[timestamp]], NULL, 'allowuserthemes', '0', NULL),
(543, 0, [[timestamp]], NULL, 'allowcoursethemes', '0', NULL),
(544, 0, [[timestamp]], NULL, 'allowcategorythemes', '0', NULL),
(545, 0, [[timestamp]], NULL, 'allowcohortthemes', '0', NULL),
(546, 0, [[timestamp]], NULL, 'allowthemechangeonurl', '0', NULL),
(547, 0, [[timestamp]], NULL, 'allowuserblockhiding', '1', NULL),
(548, 0, [[timestamp]], NULL, 'langmenuinsecurelayout', '0', NULL),
(549, 0, [[timestamp]], NULL, 'logininfoinsecurelayout', '0', NULL),
(550, 0, [[timestamp]], NULL, 'navfilter', '0', NULL),
(551, 0, [[timestamp]], NULL, 'custommenuitems', '', NULL),
(552, 0, [[timestamp]], NULL, 'customusermenuitems', 'profile,moodle|/user/profile.php\ngrades,grades|/grade/report/mygrades.php\ncalendar,core_calendar|/calendar/view.php?view=month\nprivatefiles,moodle|/user/files.php\nreports,core_reportbuilder|/reportbuilder/index.php', NULL),
(553, 0, [[timestamp]], NULL, 'file_redactor_exifremoverenabled', '1', NULL),
(554, 0, [[timestamp]], NULL, 'file_redactor_exifremovertoolpath', '', NULL),
(555, 0, [[timestamp]], NULL, 'file_redactor_exifremoverremovetags', 'gps', NULL),
(556, 0, [[timestamp]], NULL, 'file_redactor_exifremovermimetype', 'image/jpeg\nimage/tiff', NULL),
(557, 0, [[timestamp]], NULL, 'cron_enabled', '1', NULL),
(558, 0, [[timestamp]], NULL, 'cron_keepalive', '180', NULL),
(559, 0, [[timestamp]], NULL, 'task_scheduled_concurrency_limit', '3', NULL),
(560, 0, [[timestamp]], NULL, 'task_scheduled_max_runtime', '1800', NULL),
(561, 0, [[timestamp]], NULL, 'task_adhoc_concurrency_limit', '3', NULL),
(562, 0, [[timestamp]], NULL, 'task_adhoc_max_runtime', '1800', NULL),
(563, 0, [[timestamp]], NULL, 'task_adhoc_failed_retention', '2419200', NULL),
(564, 0, [[timestamp]], NULL, 'task_logmode', '1', NULL),
(565, 0, [[timestamp]], NULL, 'task_logtostdout', '1', NULL),
(566, 0, [[timestamp]], NULL, 'task_logretention', '2419200', NULL),
(567, 0, [[timestamp]], NULL, 'task_logretainruns', '20', NULL),
(568, 0, [[timestamp]], NULL, 'smtphosts', '', NULL),
(569, 0, [[timestamp]], NULL, 'smtpsecure', '', NULL),
(570, 0, [[timestamp]], NULL, 'smtpauthtype', 'LOGIN', NULL),
(571, 0, [[timestamp]], NULL, 'smtpuser', '', NULL),
(572, 0, [[timestamp]], NULL, 'smtppass', '', NULL),
(573, 0, [[timestamp]], NULL, 'smtpmaxbulk', '1', NULL),
(574, 0, [[timestamp]], NULL, 'noreplyaddress', '[[admin_email]]', NULL),
(575, 0, [[timestamp]], NULL, 'allowedemaildomains', '', NULL),
(576, 0, [[timestamp]], NULL, 'divertallemailsto', '', NULL),
(577, 0, [[timestamp]], NULL, 'divertallemailsexcept', '', NULL),
(578, 0, [[timestamp]], NULL, 'emaildkimselector', '', NULL),
(579, 0, [[timestamp]], NULL, 'sitemailcharset', '0', NULL),
(580, 0, [[timestamp]], NULL, 'allowusermailcharset', '0', NULL),
(581, 0, [[timestamp]], NULL, 'allowattachments', '1', NULL),
(582, 0, [[timestamp]], NULL, 'mailnewline', 'LF', NULL),
(583, 0, [[timestamp]], NULL, 'emailfromvia', '1', NULL),
(584, 0, [[timestamp]], NULL, 'emailsubjectprefix', '', NULL),
(585, 0, [[timestamp]], NULL, 'emailheaders', '', NULL),
(586, 0, [[timestamp]], NULL, 'enablewsdocumentation', '0', NULL),
(587, 0, [[timestamp]], NULL, 'pathtophp', '', NULL),
(588, 0, [[timestamp]], NULL, 'pathtodu', '', NULL),
(589, 0, [[timestamp]], NULL, 'aspellpath', '', NULL),
(590, 0, [[timestamp]], NULL, 'pathtodot', '', NULL),
(591, 0, [[timestamp]], NULL, 'pathtogs', '/usr/bin/gs', NULL),
(592, 0, [[timestamp]], NULL, 'pathtopdftoppm', '', NULL),
(593, 0, [[timestamp]], NULL, 'pathtopython', '', NULL),
(594, 0, [[timestamp]], NULL, 'supportname', 'Admin User', NULL),
(595, 0, [[timestamp]], NULL, 'supportpage', '', NULL),
(596, 0, [[timestamp]], NULL, 'supportavailability', '1', NULL),
(597, 0, [[timestamp]], NULL, 'servicespage', '', NULL),
(598, 0, [[timestamp]], NULL, 'dbsessions', '0', NULL),
(599, 0, [[timestamp]], NULL, 'sessiontimeoutwarning', '1200', NULL),
(600, 0, [[timestamp]], NULL, 'sessioncookie', '', NULL),
(601, 0, [[timestamp]], NULL, 'sessioncookiepath', '', NULL),
(602, 0, [[timestamp]], NULL, 'sessioncookiedomain', '', NULL),
(603, 0, [[timestamp]], NULL, 'statsfirstrun', 'none', NULL),
(604, 0, [[timestamp]], NULL, 'statsmaxruntime', '0', NULL),
(605, 0, [[timestamp]], NULL, 'statsruntimedays', '31', NULL),
(606, 0, [[timestamp]], NULL, 'statsuserthreshold', '0', NULL),
(607, 0, [[timestamp]], NULL, 'slasharguments', '1', NULL),
(608, 0, [[timestamp]], NULL, 'getremoteaddrconf', '3', NULL),
(609, 0, [[timestamp]], NULL, 'reverseproxyignore', '', NULL),
(610, 0, [[timestamp]], NULL, 'proxyhost', '', NULL),
(611, 0, [[timestamp]], NULL, 'proxyport', '0', NULL),
(612, 0, [[timestamp]], NULL, 'proxytype', 'HTTP', NULL),
(613, 0, [[timestamp]], NULL, 'proxyuser', '', NULL),
(614, 0, [[timestamp]], NULL, 'proxypassword', '', NULL),
(615, 0, [[timestamp]], NULL, 'proxybypass', 'localhost,127.0.0.1', NULL),
(616, 0, [[timestamp]], NULL, 'proxylogunsafe', '0', NULL),
(617, 0, [[timestamp]], NULL, 'proxyfixunsafe', '0', NULL),
(618, 0, [[timestamp]], NULL, 'maintenance_enabled', '0', NULL),
(619, 0, [[timestamp]], NULL, 'maintenance_message', '', NULL),
(620, 0, [[timestamp]], NULL, 'deleteunconfirmed', '168', NULL),
(621, 0, [[timestamp]], NULL, 'deleteincompleteusers', '0', NULL),
(622, 0, [[timestamp]], NULL, 'disablegradehistory', '0', NULL),
(623, 0, [[timestamp]], NULL, 'gradehistorylifetime', '0', NULL),
(624, 0, [[timestamp]], NULL, 'tempdatafoldercleanup', '168', NULL),
(625, 0, [[timestamp]], NULL, 'xapicleanupperiod', '4838400', NULL),
(626, 0, [[timestamp]], NULL, 'filescleanupperiod', '86400', NULL),
(627, 0, [[timestamp]], NULL, 'extramemorylimit', '512M', NULL),
(628, 0, [[timestamp]], NULL, 'maxtimelimit', '0', NULL),
(629, 0, [[timestamp]], NULL, 'curlcache', '120', NULL),
(630, 0, [[timestamp]], NULL, 'curltimeoutkbitrate', '56', NULL),
(631, 0, [[timestamp]], NULL, 'updateautocheck', '1', NULL),
(632, 0, [[timestamp]], NULL, 'updateminmaturity', '200', NULL),
(633, 0, [[timestamp]], NULL, 'updatenotifybuilds', '0', NULL),
(634, 0, [[timestamp]], NULL, 'customreportslimit', '0', NULL),
(635, 0, [[timestamp]], NULL, 'customreportsliveediting', '1', NULL),
(636, 0, [[timestamp]], NULL, 'dndallowtextandlinks', '0', NULL),
(637, 0, [[timestamp]], NULL, 'pathtosassc', '', NULL),
(638, 0, [[timestamp]], NULL, 'contextlocking', '0', NULL),
(639, 0, [[timestamp]], NULL, 'contextlockappliestoadmin', '1', NULL),
(640, 0, [[timestamp]], NULL, 'forceclean', '0', NULL),
(641, 0, [[timestamp]], NULL, 'enablecourserelativedates', '0', NULL),
(642, 0, [[timestamp]], NULL, 'enablesharingtomoodlenet', '0', NULL),
(643, 0, [[timestamp]], NULL, 'enablecommunicationsubsystem', '0', NULL),
(644, 0, [[timestamp]], NULL, 'debug', '0', NULL),
(645, 0, [[timestamp]], NULL, 'debugdisplay', '0', NULL),
(646, 0, [[timestamp]], NULL, 'perfdebug', '7', NULL),
(647, 0, [[timestamp]], NULL, 'debugstringids', '0', NULL),
(648, 0, [[timestamp]], NULL, 'debugsqltrace', '0', NULL),
(649, 0, [[timestamp]], NULL, 'debugvalidators', '0', NULL),
(650, 0, [[timestamp]], NULL, 'debugpageinfo', '0', NULL),
(651, 0, [[timestamp]], NULL, 'debugtemplateinfo', '0', NULL),
(652, 0, [[timestamp]], NULL, 'profilingenabled', '0', NULL),
(653, 0, [[timestamp]], NULL, 'profilingincluded', '', NULL),
(654, 0, [[timestamp]], NULL, 'profilingexcluded', '', NULL),
(655, 0, [[timestamp]], NULL, 'profilingautofrec', '0', NULL),
(656, 0, [[timestamp]], NULL, 'profilingallowme', '0', NULL),
(657, 0, [[timestamp]], NULL, 'profilingallowall', '0', NULL),
(658, 0, [[timestamp]], NULL, 'profilingslow', '0', NULL),
(659, 0, [[timestamp]], NULL, 'profilinglifetime', '1440', NULL),
(660, 0, [[timestamp]], NULL, 'profilingimportprefix', '(I)', NULL),
(661, 0, [[timestamp]], 'core_competency', 'pushcourseratingstouserplans', '1', NULL),
(662, 0, [[timestamp]], 'core', 'sms', '0', '1'),
(663, 0, [[timestamp]], 'activitynames', 'filter_active', '1', ''),
(664, 0, [[timestamp]], 'core_filter', 'order', 'activitynames', 'activitynames'),
(665, 0, [[timestamp]], 'displayh5p', 'filter_active', '1', ''),
(666, 0, [[timestamp]], 'core_filter', 'order', 'displayh5p, activitynames', 'activitynames, displayh5p'),
(667, 0, [[timestamp]], 'emoticon', 'filter_active', '1', ''),
(668, 0, [[timestamp]], 'mathjaxloader', 'filter_active', '1', ''),
(669, 0, [[timestamp]], 'core_filter', 'order', 'displayh5p, activitynames, mathjaxloader, emoticon', 'displayh5p, activitynames, emoticon, mathjaxloader'),
(670, 0, [[timestamp]], 'mediaplugin', 'filter_active', '1', ''),
(671, 0, [[timestamp]], 'urltolink', 'filter_active', '1', ''),
(672, 0, [[timestamp]], 'core_filter', 'order', 'displayh5p, activitynames, mathjaxloader, emoticon, urltolink, mediaplugin', 'displayh5p, activitynames, mathjaxloader, emoticon, mediaplugin, urltolink'),
(673, 0, [[timestamp]], 'format_social', 'disabled', '1', '0'),
(674, 0, [[timestamp]], 'tiny_noautolink', 'disabled', '1', '0'),
(675, 2, [[timestamp]], NULL, 'enableaccessibilitytools', '1', NULL),
(676, 2, [[timestamp]], 'tool_moodlenet', 'enablemoodlenet', '1', NULL),
(677, 2, [[timestamp]], NULL, 'notloggedinroleid', '6', NULL),
(678, 2, [[timestamp]], NULL, 'guestroleid', '6', NULL),
(679, 2, [[timestamp]], NULL, 'defaultuserroleid', '7', NULL),
(680, 2, [[timestamp]], NULL, 'creatornewroleid', '3', NULL),
(681, 2, [[timestamp]], NULL, 'restorernewroleid', '3', NULL),
(682, 2, [[timestamp]], 'tool_dataprivacy', 'contactdataprotectionofficer', '0', NULL),
(683, 2, [[timestamp]], 'tool_dataprivacy', 'automaticdataexportapproval', '0', NULL),
(684, 2, [[timestamp]], 'tool_dataprivacy', 'automaticdatadeletionapproval', '0', NULL),
(685, 2, [[timestamp]], 'tool_dataprivacy', 'automaticdeletionrequests', '1', NULL),
(686, 2, [[timestamp]], 'tool_dataprivacy', 'privacyrequestexpiry', '604800', NULL),
(687, 2, [[timestamp]], 'tool_dataprivacy', 'requireallenddatesforuserdeletion', '1', NULL),
(688, 2, [[timestamp]], 'tool_dataprivacy', 'showdataretentionsummary', '1', NULL),
(689, 2, [[timestamp]], 'tool_dataprivacy', 'allowfiltering', '0', NULL),
(690, 2, [[timestamp]], 'tool_log', 'exportlog', '1', NULL);
INSERT INTO `[[dbprefix]]config_log` VALUES
(691, 2, [[timestamp]], NULL, 'sitepolicyhandler', '', NULL),
(692, 2, [[timestamp]], NULL, 'gradebookroles', '5', NULL),
(693, 2, [[timestamp]], NULL, 'h5plibraryhandler', 'h5plib_v127', NULL),
(694, 2, [[timestamp]], NULL, 'airnotifierurl', 'https://messages.moodle.net', NULL),
(695, 2, [[timestamp]], NULL, 'airnotifierport', '443', NULL),
(696, 2, [[timestamp]], NULL, 'airnotifiermobileappname', 'com.moodle.moodlemobile', NULL),
(697, 2, [[timestamp]], NULL, 'airnotifierappname', 'commoodlemoodlemobile', NULL),
(698, 2, [[timestamp]], NULL, 'airnotifieraccesskey', '', NULL),
(699, 2, [[timestamp]], 'message_airnotifier', 'encryptnotifications', '0', NULL),
(700, 2, [[timestamp]], 'message_airnotifier', 'encryptprocessing', '0', NULL),
(701, 2, [[timestamp]], 'assign', 'feedback_plugin_for_gradebook', 'assignfeedback_comments', NULL),
(702, 2, [[timestamp]], 'assign', 'showrecentsubmissions', '0', NULL),
(703, 2, [[timestamp]], 'assign', 'submissionreceipts', '1', NULL),
(704, 2, [[timestamp]], 'assign', 'submissionstatement', 'This submission is my own work, except where I have acknowledged the use of the works of other people.', NULL),
(705, 2, [[timestamp]], 'assign', 'submissionstatementteamsubmission', 'This submission is the work of my group, except where we have acknowledged the use of the works of other people.', NULL),
(706, 2, [[timestamp]], 'assign', 'submissionstatementteamsubmissionallsubmit', 'This submission is my own work as a group member, except where I have acknowledged the use of the works of other people.', NULL),
(707, 2, [[timestamp]], 'assign', 'maxperpage', '-1', NULL),
(708, 2, [[timestamp]], 'assign', 'alwaysshowdescription', '1', NULL),
(709, 2, [[timestamp]], 'assign', 'alwaysshowdescription_adv', '', NULL),
(710, 2, [[timestamp]], 'assign', 'alwaysshowdescription_locked', '', NULL),
(711, 2, [[timestamp]], 'assign', 'allowsubmissionsfromdate', '0', NULL),
(712, 2, [[timestamp]], 'assign', 'allowsubmissionsfromdate_enabled', '1', NULL),
(713, 2, [[timestamp]], 'assign', 'allowsubmissionsfromdate_adv', '', NULL),
(714, 2, [[timestamp]], 'assign', 'duedate', '604800', NULL),
(715, 2, [[timestamp]], 'assign', 'duedate_enabled', '1', NULL),
(716, 2, [[timestamp]], 'assign', 'duedate_adv', '', NULL),
(717, 2, [[timestamp]], 'assign', 'cutoffdate', '1209600', NULL),
(718, 2, [[timestamp]], 'assign', 'cutoffdate_enabled', '', NULL),
(719, 2, [[timestamp]], 'assign', 'cutoffdate_adv', '', NULL),
(720, 2, [[timestamp]], 'assign', 'enabletimelimit', '0', NULL),
(721, 2, [[timestamp]], 'mod_assign', 'defaultgradetype', '1', NULL),
(722, 2, [[timestamp]], 'mod_assign', 'defaultgradescale', '', NULL),
(723, 2, [[timestamp]], 'assign', 'gradingduedate', '1209600', NULL),
(724, 2, [[timestamp]], 'assign', 'gradingduedate_enabled', '1', NULL),
(725, 2, [[timestamp]], 'assign', 'gradingduedate_adv', '', NULL),
(726, 2, [[timestamp]], 'assign', 'submissiondrafts', '0', NULL),
(727, 2, [[timestamp]], 'assign', 'submissiondrafts_adv', '', NULL),
(728, 2, [[timestamp]], 'assign', 'submissiondrafts_locked', '', NULL),
(729, 2, [[timestamp]], 'assign', 'requiresubmissionstatement', '0', NULL),
(730, 2, [[timestamp]], 'assign', 'requiresubmissionstatement_adv', '', NULL),
(731, 2, [[timestamp]], 'assign', 'requiresubmissionstatement_locked', '', NULL),
(732, 2, [[timestamp]], 'assign', 'maxattempts', '1', NULL),
(733, 2, [[timestamp]], 'assign', 'maxattempts_adv', '', NULL),
(734, 2, [[timestamp]], 'assign', 'maxattempts_locked', '', NULL),
(735, 2, [[timestamp]], 'assign', 'attemptreopenmethod', 'untilpass', NULL),
(736, 2, [[timestamp]], 'assign', 'attemptreopenmethod_adv', '', NULL),
(737, 2, [[timestamp]], 'assign', 'attemptreopenmethod_locked', '', NULL),
(738, 2, [[timestamp]], 'assign', 'teamsubmission', '0', NULL),
(739, 2, [[timestamp]], 'assign', 'teamsubmission_adv', '', NULL),
(740, 2, [[timestamp]], 'assign', 'teamsubmission_locked', '', NULL),
(741, 2, [[timestamp]], 'assign', 'preventsubmissionnotingroup', '0', NULL),
(742, 2, [[timestamp]], 'assign', 'preventsubmissionnotingroup_adv', '', NULL),
(743, 2, [[timestamp]], 'assign', 'preventsubmissionnotingroup_locked', '', NULL),
(744, 2, [[timestamp]], 'assign', 'requireallteammemberssubmit', '0', NULL),
(745, 2, [[timestamp]], 'assign', 'requireallteammemberssubmit_adv', '', NULL),
(746, 2, [[timestamp]], 'assign', 'requireallteammemberssubmit_locked', '', NULL),
(747, 2, [[timestamp]], 'assign', 'teamsubmissiongroupingid', '', NULL),
(748, 2, [[timestamp]], 'assign', 'teamsubmissiongroupingid_adv', '', NULL),
(749, 2, [[timestamp]], 'assign', 'sendnotifications', '0', NULL),
(750, 2, [[timestamp]], 'assign', 'sendnotifications_adv', '', NULL),
(751, 2, [[timestamp]], 'assign', 'sendnotifications_locked', '', NULL),
(752, 2, [[timestamp]], 'assign', 'sendlatenotifications', '0', NULL),
(753, 2, [[timestamp]], 'assign', 'sendlatenotifications_adv', '', NULL),
(754, 2, [[timestamp]], 'assign', 'sendlatenotifications_locked', '', NULL),
(755, 2, [[timestamp]], 'assign', 'sendstudentnotifications', '1', NULL),
(756, 2, [[timestamp]], 'assign', 'sendstudentnotifications_adv', '', NULL),
(757, 2, [[timestamp]], 'assign', 'sendstudentnotifications_locked', '', NULL),
(758, 2, [[timestamp]], 'assign', 'blindmarking', '0', NULL),
(759, 2, [[timestamp]], 'assign', 'blindmarking_adv', '', NULL),
(760, 2, [[timestamp]], 'assign', 'blindmarking_locked', '', NULL),
(761, 2, [[timestamp]], 'assign', 'hidegrader', '0', NULL),
(762, 2, [[timestamp]], 'assign', 'hidegrader_adv', '', NULL),
(763, 2, [[timestamp]], 'assign', 'hidegrader_locked', '', NULL),
(764, 2, [[timestamp]], 'assign', 'markingworkflow', '0', NULL),
(765, 2, [[timestamp]], 'assign', 'markingworkflow_adv', '', NULL),
(766, 2, [[timestamp]], 'assign', 'markingworkflow_locked', '', NULL),
(767, 2, [[timestamp]], 'assign', 'markingallocation', '0', NULL),
(768, 2, [[timestamp]], 'assign', 'markingallocation_adv', '', NULL),
(769, 2, [[timestamp]], 'assign', 'markingallocation_locked', '', NULL),
(770, 2, [[timestamp]], 'assign', 'markinganonymous', '0', NULL),
(771, 2, [[timestamp]], 'assign', 'markinganonymous_adv', '', NULL),
(772, 2, [[timestamp]], 'assign', 'markinganonymous_locked', '', NULL),
(773, 2, [[timestamp]], 'assignsubmission_file', 'default', '1', NULL),
(774, 2, [[timestamp]], 'assignsubmission_file', 'maxfiles', '20', NULL),
(775, 2, [[timestamp]], 'assignsubmission_file', 'filetypes', '', NULL),
(776, 2, [[timestamp]], 'assignsubmission_file', 'maxbytes', '0', NULL),
(777, 2, [[timestamp]], 'assignsubmission_onlinetext', 'default', '0', NULL),
(778, 2, [[timestamp]], 'assignfeedback_comments', 'default', '1', NULL),
(779, 2, [[timestamp]], 'assignfeedback_comments', 'inline', '0', NULL),
(780, 2, [[timestamp]], 'assignfeedback_comments', 'inline_adv', '', NULL),
(781, 2, [[timestamp]], 'assignfeedback_comments', 'inline_locked', '', NULL),
(782, 2, [[timestamp]], 'assignfeedback_editpdf', 'default', '1', NULL),
(783, 2, [[timestamp]], 'assignfeedback_editpdf', 'stamps', '', NULL),
(784, 2, [[timestamp]], 'assignfeedback_file', 'default', '0', NULL),
(785, 2, [[timestamp]], 'assignfeedback_offline', 'default', '0', NULL),
(786, 2, [[timestamp]], NULL, 'bigbluebuttonbn_server_url', '', NULL),
(787, 2, [[timestamp]], NULL, 'bigbluebuttonbn_shared_secret', '', NULL),
(788, 2, [[timestamp]], NULL, 'bigbluebuttonbn_checksum_algorithm', 'SHA256', NULL),
(789, 2, [[timestamp]], NULL, 'bigbluebuttonbn_poll_interval', '5', NULL),
(790, 2, [[timestamp]], NULL, 'bigbluebuttonbn_welcome_default', '', NULL),
(791, 2, [[timestamp]], NULL, 'bigbluebuttonbn_welcome_editable', '1', NULL),
(792, 2, [[timestamp]], NULL, 'bigbluebuttonbn_recording_default', '1', NULL),
(793, 2, [[timestamp]], NULL, 'bigbluebuttonbn_recording_refresh_period', '300', NULL),
(794, 2, [[timestamp]], NULL, 'bigbluebuttonbn_recording_editable', '1', NULL),
(795, 2, [[timestamp]], NULL, 'bigbluebuttonbn_recording_all_from_start_default', '0', NULL),
(796, 2, [[timestamp]], NULL, 'bigbluebuttonbn_recording_all_from_start_editable', '0', NULL),
(797, 2, [[timestamp]], NULL, 'bigbluebuttonbn_recording_hide_button_default', '0', NULL),
(798, 2, [[timestamp]], NULL, 'bigbluebuttonbn_recording_hide_button_editable', '0', NULL),
(799, 2, [[timestamp]], NULL, 'bigbluebuttonbn_recording_safe_formats', 'video,presentation', NULL),
(800, 2, [[timestamp]], NULL, 'bigbluebuttonbn_importrecordings_enabled', '0', NULL),
(801, 2, [[timestamp]], NULL, 'bigbluebuttonbn_importrecordings_from_deleted_enabled', '0', NULL),
(802, 2, [[timestamp]], NULL, 'bigbluebuttonbn_recordings_deleted_default', '1', NULL),
(803, 2, [[timestamp]], NULL, 'bigbluebuttonbn_recordings_deleted_editable', '0', NULL),
(804, 2, [[timestamp]], NULL, 'bigbluebuttonbn_recordings_imported_default', '0', NULL),
(805, 2, [[timestamp]], NULL, 'bigbluebuttonbn_recordings_imported_editable', '1', NULL),
(806, 2, [[timestamp]], NULL, 'bigbluebuttonbn_recordings_preview_default', '1', NULL),
(807, 2, [[timestamp]], NULL, 'bigbluebuttonbn_recordings_preview_editable', '0', NULL),
(808, 2, [[timestamp]], NULL, 'bigbluebuttonbn_recordings_asc_sort', '0', NULL),
(809, 2, [[timestamp]], NULL, 'bigbluebuttonbn_recording_protect_editable', '1', NULL),
(810, 2, [[timestamp]], NULL, 'bigbluebuttonbn_waitformoderator_default', '0', NULL),
(811, 2, [[timestamp]], NULL, 'bigbluebuttonbn_waitformoderator_editable', '1', NULL),
(812, 2, [[timestamp]], NULL, 'bigbluebuttonbn_waitformoderator_ping_interval', '10', NULL),
(813, 2, [[timestamp]], NULL, 'bigbluebuttonbn_waitformoderator_cache_ttl', '60', NULL),
(814, 2, [[timestamp]], NULL, 'bigbluebuttonbn_voicebridge_editable', '0', NULL),
(815, 2, [[timestamp]], NULL, 'bigbluebuttonbn_preuploadpresentation_editable', '0', NULL),
(816, 2, [[timestamp]], 'mod_bigbluebuttonbn', 'presentationdefault', '', NULL),
(817, 2, [[timestamp]], 'mod_bigbluebuttonbn', 'showpresentation_default', '1', NULL),
(818, 2, [[timestamp]], 'mod_bigbluebuttonbn', 'showpresentation_editable', '0', NULL),
(819, 2, [[timestamp]], NULL, 'bigbluebuttonbn_userlimit_default', '0', NULL),
(820, 2, [[timestamp]], NULL, 'bigbluebuttonbn_userlimit_editable', '0', NULL),
(821, 2, [[timestamp]], NULL, 'bigbluebuttonbn_participant_moderator_default', '0', NULL),
(822, 2, [[timestamp]], NULL, 'bigbluebuttonbn_muteonstart_default', '0', NULL),
(823, 2, [[timestamp]], NULL, 'bigbluebuttonbn_muteonstart_editable', '0', NULL),
(824, 2, [[timestamp]], NULL, 'bigbluebuttonbn_disablecam_default', '0', NULL),
(825, 2, [[timestamp]], NULL, 'bigbluebuttonbn_disablecam_editable', '1', NULL),
(826, 2, [[timestamp]], NULL, 'bigbluebuttonbn_disablemic_default', '0', NULL),
(827, 2, [[timestamp]], NULL, 'bigbluebuttonbn_disablemic_editable', '1', NULL),
(828, 2, [[timestamp]], NULL, 'bigbluebuttonbn_disableprivatechat_default', '0', NULL),
(829, 2, [[timestamp]], NULL, 'bigbluebuttonbn_disableprivatechat_editable', '1', NULL),
(830, 2, [[timestamp]], NULL, 'bigbluebuttonbn_disablepublicchat_default', '0', NULL),
(831, 2, [[timestamp]], NULL, 'bigbluebuttonbn_disablepublicchat_editable', '1', NULL),
(832, 2, [[timestamp]], NULL, 'bigbluebuttonbn_disablenote_default', '0', NULL),
(833, 2, [[timestamp]], NULL, 'bigbluebuttonbn_disablenote_editable', '1', NULL),
(834, 2, [[timestamp]], NULL, 'bigbluebuttonbn_hideuserlist_default', '0', NULL),
(835, 2, [[timestamp]], NULL, 'bigbluebuttonbn_hideuserlist_editable', '1', NULL),
(836, 2, [[timestamp]], NULL, 'bigbluebuttonbn_recordingready_enabled', '0', NULL),
(837, 2, [[timestamp]], NULL, 'bigbluebuttonbn_profile_picture_enabled', '0', NULL),
(838, 2, [[timestamp]], NULL, 'bigbluebuttonbn_meetingevents_enabled', '0', NULL),
(839, 2, [[timestamp]], NULL, 'bigbluebuttonbn_guestaccess_enabled', '0', NULL),
(840, 2, [[timestamp]], 'book', 'numberingoptions', '0,1,2,3', NULL),
(841, 2, [[timestamp]], 'book', 'numbering', '1', NULL),
(842, 2, [[timestamp]], NULL, 'data_enablerssfeeds', '0', NULL),
(843, 2, [[timestamp]], NULL, 'feedback_allowfullanonymous', '0', NULL),
(844, 2, [[timestamp]], 'resource', 'framesize', '130', NULL),
(845, 2, [[timestamp]], 'resource', 'displayoptions', '0,1,4,5,6', NULL),
(846, 2, [[timestamp]], 'resource', 'printintro', '1', NULL),
(847, 2, [[timestamp]], 'resource', 'display', '0', NULL),
(848, 2, [[timestamp]], 'resource', 'showsize', '0', NULL),
(849, 2, [[timestamp]], 'resource', 'showtype', '1', NULL),
(850, 2, [[timestamp]], 'resource', 'showdate', '0', NULL),
(851, 2, [[timestamp]], 'resource', 'popupwidth', '620', NULL),
(852, 2, [[timestamp]], 'resource', 'popupheight', '450', NULL),
(853, 2, [[timestamp]], 'resource', 'filterfiles', '0', NULL),
(854, 2, [[timestamp]], 'folder', 'showexpanded', '1', NULL),
(855, 2, [[timestamp]], 'folder', 'maxsizetodownload', '0', NULL),
(856, 2, [[timestamp]], NULL, 'forum_displaymode', '3', NULL),
(857, 2, [[timestamp]], NULL, 'forum_shortpost', '300', NULL),
(858, 2, [[timestamp]], NULL, 'forum_longpost', '600', NULL),
(859, 2, [[timestamp]], NULL, 'forum_manydiscussions', '100', NULL),
(860, 2, [[timestamp]], NULL, 'forum_maxbytes', '512000', NULL),
(861, 2, [[timestamp]], NULL, 'forum_maxattachments', '9', NULL),
(862, 2, [[timestamp]], NULL, 'forum_subscription', '0', NULL),
(863, 2, [[timestamp]], NULL, 'forum_trackingtype', '1', NULL),
(864, 2, [[timestamp]], NULL, 'forum_trackreadposts', '1', NULL),
(865, 2, [[timestamp]], NULL, 'forum_allowforcedreadtracking', '0', NULL),
(866, 2, [[timestamp]], NULL, 'forum_oldpostdays', '14', NULL),
(867, 2, [[timestamp]], NULL, 'forum_usermarksread', '0', NULL),
(868, 2, [[timestamp]], NULL, 'forum_cleanreadtime', '2', NULL),
(869, 2, [[timestamp]], NULL, 'digestmailtime', '17', NULL),
(870, 2, [[timestamp]], NULL, 'forum_enablerssfeeds', '0', NULL),
(871, 2, [[timestamp]], NULL, 'forum_enabletimedposts', '1', NULL),
(872, 2, [[timestamp]], NULL, 'forum_announcementmaxbytes', '512000', NULL),
(873, 2, [[timestamp]], NULL, 'forum_announcementmaxattachments', '1', NULL),
(874, 2, [[timestamp]], NULL, 'forum_announcementsubscription', '1', NULL),
(875, 2, [[timestamp]], NULL, 'glossary_entbypage', '10', NULL),
(876, 2, [[timestamp]], NULL, 'glossary_dupentries', '0', NULL),
(877, 2, [[timestamp]], NULL, 'glossary_allowcomments', '0', NULL),
(878, 2, [[timestamp]], NULL, 'glossary_linkbydefault', '1', NULL),
(879, 2, [[timestamp]], NULL, 'glossary_defaultapproval', '1', NULL),
(880, 2, [[timestamp]], NULL, 'glossary_enablerssfeeds', '0', NULL),
(881, 2, [[timestamp]], NULL, 'glossary_linkentries', '0', NULL),
(882, 2, [[timestamp]], NULL, 'glossary_casesensitive', '0', NULL),
(883, 2, [[timestamp]], NULL, 'glossary_fullmatch', '0', NULL),
(884, 2, [[timestamp]], 'mod_h5pactivity', 'enablesavestate', '1', NULL),
(885, 2, [[timestamp]], 'mod_h5pactivity', 'savestatefreq', '60', NULL),
(886, 2, [[timestamp]], 'imscp', 'keepold', '1', NULL),
(887, 2, [[timestamp]], 'imscp', 'keepold_adv', '', NULL),
(888, 2, [[timestamp]], 'mod_lesson', 'mediafile', '', NULL),
(889, 2, [[timestamp]], 'mod_lesson', 'mediafile_adv', '1', NULL),
(890, 2, [[timestamp]], 'mod_lesson', 'mediawidth', '640', NULL),
(891, 2, [[timestamp]], 'mod_lesson', 'mediaheight', '480', NULL),
(892, 2, [[timestamp]], 'mod_lesson', 'mediaclose', '0', NULL),
(893, 2, [[timestamp]], 'mod_lesson', 'progressbar', '0', NULL),
(894, 2, [[timestamp]], 'mod_lesson', 'progressbar_adv', '', NULL),
(895, 2, [[timestamp]], 'mod_lesson', 'ongoing', '0', NULL),
(896, 2, [[timestamp]], 'mod_lesson', 'ongoing_adv', '1', NULL),
(897, 2, [[timestamp]], 'mod_lesson', 'displayleftmenu', '0', NULL),
(898, 2, [[timestamp]], 'mod_lesson', 'displayleftmenu_adv', '', NULL),
(899, 2, [[timestamp]], 'mod_lesson', 'displayleftif', '0', NULL),
(900, 2, [[timestamp]], 'mod_lesson', 'displayleftif_adv', '1', NULL),
(901, 2, [[timestamp]], 'mod_lesson', 'slideshow', '0', NULL),
(902, 2, [[timestamp]], 'mod_lesson', 'slideshow_adv', '1', NULL),
(903, 2, [[timestamp]], 'mod_lesson', 'slideshowwidth', '640', NULL),
(904, 2, [[timestamp]], 'mod_lesson', 'slideshowheight', '480', NULL),
(905, 2, [[timestamp]], 'mod_lesson', 'slideshowbgcolor', '#FFFFFF', NULL),
(906, 2, [[timestamp]], 'mod_lesson', 'maxanswers', '5', NULL),
(907, 2, [[timestamp]], 'mod_lesson', 'maxanswers_adv', '1', NULL),
(908, 2, [[timestamp]], 'mod_lesson', 'defaultfeedback', '0', NULL),
(909, 2, [[timestamp]], 'mod_lesson', 'defaultfeedback_adv', '1', NULL),
(910, 2, [[timestamp]], 'mod_lesson', 'activitylink', '', NULL),
(911, 2, [[timestamp]], 'mod_lesson', 'activitylink_adv', '1', NULL),
(912, 2, [[timestamp]], 'mod_lesson', 'timelimit', '0', NULL),
(913, 2, [[timestamp]], 'mod_lesson', 'timelimit_adv', '', NULL),
(914, 2, [[timestamp]], 'mod_lesson', 'password', '0', NULL),
(915, 2, [[timestamp]], 'mod_lesson', 'password_adv', '1', NULL),
(916, 2, [[timestamp]], 'mod_lesson', 'modattempts', '0', NULL),
(917, 2, [[timestamp]], 'mod_lesson', 'modattempts_adv', '', NULL),
(918, 2, [[timestamp]], 'mod_lesson', 'displayreview', '0', NULL),
(919, 2, [[timestamp]], 'mod_lesson', 'displayreview_adv', '', NULL),
(920, 2, [[timestamp]], 'mod_lesson', 'maximumnumberofattempts', '1', NULL),
(921, 2, [[timestamp]], 'mod_lesson', 'maximumnumberofattempts_adv', '', NULL),
(922, 2, [[timestamp]], 'mod_lesson', 'defaultnextpage', '0', NULL),
(923, 2, [[timestamp]], 'mod_lesson', 'defaultnextpage_adv', '1', NULL),
(924, 2, [[timestamp]], 'mod_lesson', 'numberofpagestoshow', '1', NULL),
(925, 2, [[timestamp]], 'mod_lesson', 'numberofpagestoshow_adv', '1', NULL),
(926, 2, [[timestamp]], 'mod_lesson', 'practice', '0', NULL),
(927, 2, [[timestamp]], 'mod_lesson', 'practice_adv', '', NULL),
(928, 2, [[timestamp]], 'mod_lesson', 'customscoring', '1', NULL),
(929, 2, [[timestamp]], 'mod_lesson', 'customscoring_adv', '1', NULL),
(930, 2, [[timestamp]], 'mod_lesson', 'retakesallowed', '0', NULL),
(931, 2, [[timestamp]], 'mod_lesson', 'retakesallowed_adv', '', NULL),
(932, 2, [[timestamp]], 'mod_lesson', 'handlingofretakes', '0', NULL),
(933, 2, [[timestamp]], 'mod_lesson', 'handlingofretakes_adv', '1', NULL),
(934, 2, [[timestamp]], 'mod_lesson', 'minimumnumberofquestions', '0', NULL),
(935, 2, [[timestamp]], 'mod_lesson', 'minimumnumberofquestions_adv', '1', NULL),
(936, 2, [[timestamp]], 'page', 'displayoptions', '5', NULL),
(937, 2, [[timestamp]], 'page', 'printintro', '0', NULL),
(938, 2, [[timestamp]], 'page', 'printlastmodified', '1', NULL),
(939, 2, [[timestamp]], 'page', 'display', '5', NULL),
(940, 2, [[timestamp]], 'page', 'popupwidth', '620', NULL),
(941, 2, [[timestamp]], 'page', 'popupheight', '450', NULL),
(942, 2, [[timestamp]], 'quiz', 'notifyattemptgradeddelay', '18000', NULL),
(943, 2, [[timestamp]], 'quiz', 'precreateperiod', '0', NULL),
(944, 2, [[timestamp]], 'quiz', 'graceperiodmin', '60', NULL),
(945, 2, [[timestamp]], 'quiz', 'initialnumfeedbacks', '2', NULL),
(946, 2, [[timestamp]], 'quiz', 'autosaveperiod', '60', NULL),
(947, 2, [[timestamp]], 'quiz', 'timelimit', '0', NULL),
(948, 2, [[timestamp]], 'quiz', 'timelimit_adv', '', NULL),
(949, 2, [[timestamp]], 'quiz', 'timelimit_locked', '', NULL),
(950, 2, [[timestamp]], 'quiz', 'overduehandling', 'autosubmit', NULL),
(951, 2, [[timestamp]], 'quiz', 'overduehandling_adv', '', NULL),
(952, 2, [[timestamp]], 'quiz', 'overduehandling_locked', '', NULL),
(953, 2, [[timestamp]], 'quiz', 'graceperiod', '86400', NULL),
(954, 2, [[timestamp]], 'quiz', 'graceperiod_adv', '', NULL),
(955, 2, [[timestamp]], 'quiz', 'graceperiod_locked', '', NULL),
(956, 2, [[timestamp]], 'quiz', 'precreateattempts', '0', NULL),
(957, 2, [[timestamp]], 'quiz', 'precreateattempts_adv', '1', NULL),
(958, 2, [[timestamp]], 'quiz', 'precreateattempts_locked', '1', NULL),
(959, 2, [[timestamp]], 'quiz', 'attempts', '0', NULL),
(960, 2, [[timestamp]], 'quiz', 'attempts_adv', '', NULL),
(961, 2, [[timestamp]], 'quiz', 'attempts_locked', '', NULL),
(962, 2, [[timestamp]], 'quiz', 'grademethod', '1', NULL),
(963, 2, [[timestamp]], 'quiz', 'grademethod_adv', '', NULL),
(964, 2, [[timestamp]], 'quiz', 'grademethod_locked', '', NULL),
(965, 2, [[timestamp]], 'quiz', 'maximumgrade', '10', NULL),
(966, 2, [[timestamp]], 'quiz', 'maximumgrade_locked', '', NULL),
(967, 2, [[timestamp]], 'quiz', 'questionsperpage', '1', NULL),
(968, 2, [[timestamp]], 'quiz', 'questionsperpage_adv', '', NULL),
(969, 2, [[timestamp]], 'quiz', 'questionsperpage_locked', '', NULL),
(970, 2, [[timestamp]], 'quiz', 'navmethod', 'free', NULL),
(971, 2, [[timestamp]], 'quiz', 'navmethod_adv', '1', NULL),
(972, 2, [[timestamp]], 'quiz', 'navmethod_locked', '', NULL),
(973, 2, [[timestamp]], 'quiz', 'shuffleanswers', '1', NULL),
(974, 2, [[timestamp]], 'quiz', 'shuffleanswers_adv', '', NULL),
(975, 2, [[timestamp]], 'quiz', 'shuffleanswers_locked', '', NULL),
(976, 2, [[timestamp]], 'quiz', 'preferredbehaviour', 'deferredfeedback', NULL),
(977, 2, [[timestamp]], 'quiz', 'preferredbehaviour_locked', '', NULL),
(978, 2, [[timestamp]], 'quiz', 'canredoquestions', '0', NULL),
(979, 2, [[timestamp]], 'quiz', 'canredoquestions_adv', '1', NULL),
(980, 2, [[timestamp]], 'quiz', 'canredoquestions_locked', '', NULL),
(981, 2, [[timestamp]], 'quiz', 'attemptonlast', '0', NULL),
(982, 2, [[timestamp]], 'quiz', 'attemptonlast_adv', '1', NULL),
(983, 2, [[timestamp]], 'quiz', 'attemptonlast_locked', '', NULL),
(984, 2, [[timestamp]], 'quiz', 'reviewattempt', '69904', NULL),
(985, 2, [[timestamp]], 'quiz', 'reviewcorrectness', '69904', NULL),
(986, 2, [[timestamp]], 'quiz', 'reviewmaxmarks', '69904', NULL),
(987, 2, [[timestamp]], 'quiz', 'reviewmarks', '69904', NULL),
(988, 2, [[timestamp]], 'quiz', 'reviewspecificfeedback', '69904', NULL),
(989, 2, [[timestamp]], 'quiz', 'reviewgeneralfeedback', '69904', NULL),
(990, 2, [[timestamp]], 'quiz', 'reviewrightanswer', '69904', NULL),
(991, 2, [[timestamp]], 'quiz', 'reviewoverallfeedback', '4368', NULL),
(992, 2, [[timestamp]], 'quiz', 'showuserpicture', '0', NULL),
(993, 2, [[timestamp]], 'quiz', 'showuserpicture_adv', '', NULL),
(994, 2, [[timestamp]], 'quiz', 'showuserpicture_locked', '', NULL),
(995, 2, [[timestamp]], 'quiz', 'decimalpoints', '2', NULL),
(996, 2, [[timestamp]], 'quiz', 'decimalpoints_adv', '', NULL),
(997, 2, [[timestamp]], 'quiz', 'decimalpoints_locked', '', NULL),
(998, 2, [[timestamp]], 'quiz', 'questiondecimalpoints', '-1', NULL),
(999, 2, [[timestamp]], 'quiz', 'questiondecimalpoints_adv', '', NULL),
(1000, 2, [[timestamp]], 'quiz', 'questiondecimalpoints_locked', '', NULL),
(1001, 2, [[timestamp]], 'quiz', 'showblocks', '0', NULL),
(1002, 2, [[timestamp]], 'quiz', 'showblocks_adv', '1', NULL),
(1003, 2, [[timestamp]], 'quiz', 'showblocks_locked', '', NULL),
(1004, 2, [[timestamp]], 'quiz', 'quizpassword', '', NULL),
(1005, 2, [[timestamp]], 'quiz', 'quizpassword_adv', '', NULL),
(1006, 2, [[timestamp]], 'quiz', 'quizpassword_required', '', NULL),
(1007, 2, [[timestamp]], 'quiz', 'quizpassword_locked', '', NULL),
(1008, 2, [[timestamp]], 'quiz', 'subnet', '', NULL),
(1009, 2, [[timestamp]], 'quiz', 'subnet_adv', '1', NULL),
(1010, 2, [[timestamp]], 'quiz', 'subnet_locked', '', NULL),
(1011, 2, [[timestamp]], 'quiz', 'delay1', '0', NULL),
(1012, 2, [[timestamp]], 'quiz', 'delay1_adv', '1', NULL),
(1013, 2, [[timestamp]], 'quiz', 'delay1_locked', '', NULL),
(1014, 2, [[timestamp]], 'quiz', 'delay2', '0', NULL),
(1015, 2, [[timestamp]], 'quiz', 'delay2_adv', '1', NULL),
(1016, 2, [[timestamp]], 'quiz', 'delay2_locked', '', NULL),
(1017, 2, [[timestamp]], 'quiz', 'browsersecurity', '-', NULL),
(1018, 2, [[timestamp]], 'quiz', 'browsersecurity_adv', '1', NULL),
(1019, 2, [[timestamp]], 'quiz', 'browsersecurity_locked', '', NULL),
(1020, 2, [[timestamp]], 'quiz_statistics', 'getstatslocktimeout', '900', NULL),
(1021, 2, [[timestamp]], 'quizaccess_seb', 'autoreconfigureseb', '1', NULL),
(1022, 2, [[timestamp]], 'quizaccess_seb', 'showseblinks', 'seb,http', NULL),
(1023, 2, [[timestamp]], 'quizaccess_seb', 'downloadlink', 'https://safeexambrowser.org/download_en.html', NULL),
(1024, 2, [[timestamp]], 'quizaccess_seb', 'quizpasswordrequired', '0', NULL),
(1025, 2, [[timestamp]], 'quizaccess_seb', 'displayblocksbeforestart', '0', NULL),
(1026, 2, [[timestamp]], 'quizaccess_seb', 'displayblockswhenfinished', '1', NULL),
(1027, 2, [[timestamp]], 'scorm', 'displaycoursestructure', '0', NULL),
(1028, 2, [[timestamp]], 'scorm', 'displaycoursestructure_adv', '', NULL),
(1029, 2, [[timestamp]], 'scorm', 'popup', '0', NULL),
(1030, 2, [[timestamp]], 'scorm', 'popup_adv', '', NULL),
(1031, 2, [[timestamp]], 'scorm', 'framewidth', '100', NULL),
(1032, 2, [[timestamp]], 'scorm', 'framewidth_adv', '1', NULL),
(1033, 2, [[timestamp]], 'scorm', 'frameheight', '500', NULL),
(1034, 2, [[timestamp]], 'scorm', 'frameheight_adv', '1', NULL),
(1035, 2, [[timestamp]], 'scorm', 'winoptgrp_adv', '1', NULL),
(1036, 2, [[timestamp]], 'scorm', 'scrollbars', '0', NULL),
(1037, 2, [[timestamp]], 'scorm', 'directories', '0', NULL),
(1038, 2, [[timestamp]], 'scorm', 'location', '0', NULL),
(1039, 2, [[timestamp]], 'scorm', 'menubar', '0', NULL),
(1040, 2, [[timestamp]], 'scorm', 'toolbar', '0', NULL),
(1041, 2, [[timestamp]], 'scorm', 'status', '0', NULL),
(1042, 2, [[timestamp]], 'scorm', 'skipview', '0', NULL),
(1043, 2, [[timestamp]], 'scorm', 'skipview_adv', '1', NULL),
(1044, 2, [[timestamp]], 'scorm', 'hidebrowse', '0', NULL),
(1045, 2, [[timestamp]], 'scorm', 'hidebrowse_adv', '1', NULL),
(1046, 2, [[timestamp]], 'scorm', 'hidetoc', '0', NULL),
(1047, 2, [[timestamp]], 'scorm', 'hidetoc_adv', '1', NULL),
(1048, 2, [[timestamp]], 'scorm', 'nav', '1', NULL),
(1049, 2, [[timestamp]], 'scorm', 'nav_adv', '1', NULL),
(1050, 2, [[timestamp]], 'scorm', 'navpositionleft', '-100', NULL),
(1051, 2, [[timestamp]], 'scorm', 'navpositionleft_adv', '1', NULL),
(1052, 2, [[timestamp]], 'scorm', 'navpositiontop', '-100', NULL),
(1053, 2, [[timestamp]], 'scorm', 'navpositiontop_adv', '1', NULL),
(1054, 2, [[timestamp]], 'scorm', 'collapsetocwinsize', '767', NULL),
(1055, 2, [[timestamp]], 'scorm', 'collapsetocwinsize_adv', '1', NULL),
(1056, 2, [[timestamp]], 'scorm', 'displayattemptstatus', '1', NULL),
(1057, 2, [[timestamp]], 'scorm', 'displayattemptstatus_adv', '', NULL),
(1058, 2, [[timestamp]], 'scorm', 'grademethod', '1', NULL),
(1059, 2, [[timestamp]], 'scorm', 'maxgrade', '100', NULL),
(1060, 2, [[timestamp]], 'scorm', 'maxattempt', '0', NULL),
(1061, 2, [[timestamp]], 'scorm', 'whatgrade', '0', NULL),
(1062, 2, [[timestamp]], 'scorm', 'forcecompleted', '0', NULL),
(1063, 2, [[timestamp]], 'scorm', 'forcenewattempt', '0', NULL),
(1064, 2, [[timestamp]], 'scorm', 'autocommit', '0', NULL),
(1065, 2, [[timestamp]], 'scorm', 'masteryoverride', '1', NULL),
(1066, 2, [[timestamp]], 'scorm', 'lastattemptlock', '0', NULL),
(1067, 2, [[timestamp]], 'scorm', 'auto', '0', NULL),
(1068, 2, [[timestamp]], 'scorm', 'updatefreq', '0', NULL),
(1069, 2, [[timestamp]], 'scorm', 'scormstandard', '0', NULL),
(1070, 2, [[timestamp]], 'scorm', 'allowtypeexternal', '0', NULL),
(1071, 2, [[timestamp]], 'scorm', 'allowtypelocalsync', '0', NULL),
(1072, 2, [[timestamp]], 'scorm', 'allowtypeexternalaicc', '0', NULL),
(1073, 2, [[timestamp]], 'scorm', 'allowaicchacp', '0', NULL),
(1074, 2, [[timestamp]], 'scorm', 'aicchacptimeout', '30', NULL),
(1075, 2, [[timestamp]], 'scorm', 'aicchacpkeepsessiondata', '1', NULL),
(1076, 2, [[timestamp]], 'scorm', 'aiccuserid', '1', NULL),
(1077, 2, [[timestamp]], 'scorm', 'forcejavascript', '1', NULL),
(1078, 2, [[timestamp]], 'scorm', 'allowapidebug', '0', NULL),
(1079, 2, [[timestamp]], 'scorm', 'apidebugmask', '.*', NULL),
(1080, 2, [[timestamp]], 'scorm', 'protectpackagedownloads', '0', NULL),
(1081, 2, [[timestamp]], 'label', 'dndresizewidth', '400', NULL),
(1082, 2, [[timestamp]], 'label', 'dndresizeheight', '400', NULL),
(1083, 2, [[timestamp]], 'url', 'framesize', '130', NULL),
(1084, 2, [[timestamp]], 'url', 'secretphrase', '', NULL),
(1085, 2, [[timestamp]], 'url', 'allowvariables', '0', NULL),
(1086, 2, [[timestamp]], 'url', 'rolesinparams', '0', NULL),
(1087, 2, [[timestamp]], 'url', 'displayoptions', '0,1,5,6', NULL),
(1088, 2, [[timestamp]], 'url', 'printintro', '1', NULL),
(1089, 2, [[timestamp]], 'url', 'display', '0', NULL),
(1090, 2, [[timestamp]], 'url', 'popupwidth', '620', NULL),
(1091, 2, [[timestamp]], 'url', 'popupheight', '450', NULL),
(1092, 2, [[timestamp]], 'workshop', 'grade', '80', NULL),
(1093, 2, [[timestamp]], 'workshop', 'gradinggrade', '20', NULL),
(1094, 2, [[timestamp]], 'workshop', 'gradedecimals', '0', NULL),
(1095, 2, [[timestamp]], 'workshop', 'maxbytes', '0', NULL),
(1096, 2, [[timestamp]], 'workshop', 'strategy', 'accumulative', NULL),
(1097, 2, [[timestamp]], 'workshop', 'examplesmode', '0', NULL),
(1098, 2, [[timestamp]], 'workshopallocation_random', 'numofreviews', '5', NULL),
(1099, 2, [[timestamp]], 'workshopform_numerrors', 'grade0', 'No', NULL),
(1100, 2, [[timestamp]], 'workshopform_numerrors', 'grade1', 'Yes', NULL),
(1101, 2, [[timestamp]], 'workshopeval_best', 'comparison', '5', NULL),
(1102, 2, [[timestamp]], 'tool_brickfield', 'analysistype', '0', NULL),
(1103, 2, [[timestamp]], 'tool_brickfield', 'deletehistoricaldata', '1', NULL),
(1104, 2, [[timestamp]], 'tool_brickfield', 'batch', '1000', NULL),
(1105, 2, [[timestamp]], 'tool_brickfield', 'perpage', '50', NULL),
(1106, 2, [[timestamp]], 'tool_mfa', 'enabled', '0', NULL),
(1107, 2, [[timestamp]], 'tool_mfa', 'lockout', '10', NULL),
(1108, 2, [[timestamp]], 'tool_mfa', 'debugmode', '0', NULL),
(1109, 2, [[timestamp]], 'tool_mfa', 'redir_exclusions', '', NULL),
(1110, 2, [[timestamp]], 'tool_mfa', 'guidance', '0', NULL),
(1111, 2, [[timestamp]], 'tool_mfa', 'guidancecontent', '', NULL),
(1112, 2, [[timestamp]], 'tool_mfa', 'guidancefiles', '', NULL),
(1113, 2, [[timestamp]], 'factor_admin', 'enabled', '0', NULL),
(1114, 2, [[timestamp]], 'factor_admin', 'weight', '100', NULL),
(1115, 2, [[timestamp]], 'factor_auth', 'enabled', '0', NULL),
(1116, 2, [[timestamp]], 'factor_auth', 'weight', '100', NULL),
(1117, 2, [[timestamp]], 'factor_auth', 'goodauth', '', NULL),
(1118, 2, [[timestamp]], 'factor_capability', 'enabled', '0', NULL),
(1119, 2, [[timestamp]], 'factor_capability', 'weight', '100', NULL),
(1120, 2, [[timestamp]], 'factor_capability', 'adminpasses', '1', NULL),
(1121, 2, [[timestamp]], 'factor_cohort', 'enabled', '0', NULL),
(1122, 2, [[timestamp]], 'factor_cohort', 'weight', '100', NULL),
(1123, 2, [[timestamp]], 'factor_email', 'enabled', '1', NULL),
(1124, 2, [[timestamp]], 'factor_email', 'weight', '100', NULL),
(1125, 2, [[timestamp]], 'factor_email', 'duration', '1800', NULL),
(1126, 2, [[timestamp]], 'factor_email', 'suspend', '0', NULL),
(1127, 2, [[timestamp]], 'factor_grace', 'enabled', '0', NULL),
(1128, 2, [[timestamp]], 'factor_grace', 'weight', '100', NULL),
(1129, 2, [[timestamp]], 'factor_grace', 'forcesetup', '0', NULL),
(1130, 2, [[timestamp]], 'factor_grace', 'graceperiod', '604800', NULL),
(1131, 2, [[timestamp]], 'factor_grace', 'ignorelist', '', NULL),
(1132, 2, [[timestamp]], 'factor_grace', 'customwarning', '', NULL),
(1133, 2, [[timestamp]], 'factor_iprange', 'enabled', '0', NULL),
(1134, 2, [[timestamp]], 'factor_iprange', 'weight', '100', NULL),
(1135, 2, [[timestamp]], 'factor_iprange', 'safeips', '', NULL),
(1136, 2, [[timestamp]], 'factor_nosetup', 'enabled', '0', NULL),
(1137, 2, [[timestamp]], 'factor_nosetup', 'weight', '100', NULL),
(1138, 2, [[timestamp]], 'factor_role', 'enabled', '0', NULL),
(1139, 2, [[timestamp]], 'factor_role', 'weight', '100', NULL),
(1140, 2, [[timestamp]], 'factor_role', 'roles', 'admin', NULL),
(1141, 2, [[timestamp]], 'factor_sms', 'smsgateway', '0', NULL),
(1142, 2, [[timestamp]], 'factor_sms', 'enabled', '0', NULL),
(1143, 2, [[timestamp]], 'factor_sms', 'weight', '100', NULL),
(1144, 2, [[timestamp]], 'factor_sms', 'duration', '1800', NULL),
(1145, 2, [[timestamp]], 'factor_token', 'enabled', '0', NULL),
(1146, 2, [[timestamp]], 'factor_token', 'weight', '100', NULL),
(1147, 2, [[timestamp]], 'factor_token', 'expiry', '86400', NULL),
(1148, 2, [[timestamp]], 'factor_token', 'expireovernight', '1', NULL),
(1149, 2, [[timestamp]], 'factor_totp', 'enabled', '0', NULL),
(1150, 2, [[timestamp]], 'factor_totp', 'weight', '100', NULL),
(1151, 2, [[timestamp]], 'factor_totp', 'window', '15', NULL),
(1152, 2, [[timestamp]], 'factor_totp', 'totplink', '1', NULL),
(1153, 2, [[timestamp]], 'factor_webauthn', 'enabled', '0', NULL),
(1154, 2, [[timestamp]], 'factor_webauthn', 'weight', '100', NULL),
(1155, 2, [[timestamp]], 'factor_webauthn', 'authenticatortypes', 'usb,nfc,ble,hybrid,internal', NULL),
(1156, 2, [[timestamp]], 'factor_webauthn', 'userverification', 'preferred', NULL),
(1157, 2, [[timestamp]], 'tool_recyclebin', 'coursebinenable', '1', NULL),
(1158, 2, [[timestamp]], 'tool_recyclebin', 'coursebinexpiry', '604800', NULL),
(1159, 2, [[timestamp]], 'tool_recyclebin', 'categorybinenable', '1', NULL),
(1160, 2, [[timestamp]], 'tool_recyclebin', 'categorybinexpiry', '604800', NULL),
(1161, 2, [[timestamp]], 'tool_recyclebin', 'autohide', '1', NULL),
(1162, 2, [[timestamp]], 'antivirus_clamav', 'runningmethod', 'commandline', NULL),
(1163, 2, [[timestamp]], 'antivirus_clamav', 'pathtoclam', '', NULL),
(1164, 2, [[timestamp]], 'antivirus_clamav', 'pathtounixsocket', '', NULL),
(1165, 2, [[timestamp]], 'antivirus_clamav', 'tcpsockethost', '', NULL),
(1166, 2, [[timestamp]], 'antivirus_clamav', 'tcpsocketport', '3310', NULL),
(1167, 2, [[timestamp]], 'antivirus_clamav', 'clamfailureonupload', 'tryagain', NULL),
(1168, 2, [[timestamp]], 'antivirus_clamav', 'tries', '1', NULL),
(1169, 2, [[timestamp]], 'auth_email', 'recaptcha', '0', NULL),
(1170, 2, [[timestamp]], 'auth_email', 'field_lock_firstname', 'unlocked', NULL),
(1171, 2, [[timestamp]], 'auth_email', 'field_lock_lastname', 'unlocked', NULL),
(1172, 2, [[timestamp]], 'auth_email', 'field_lock_email', 'unlocked', NULL),
(1173, 2, [[timestamp]], 'auth_email', 'field_lock_city', 'unlocked', NULL),
(1174, 2, [[timestamp]], 'auth_email', 'field_lock_country', 'unlocked', NULL),
(1175, 2, [[timestamp]], 'auth_email', 'field_lock_lang', 'unlocked', NULL),
(1176, 2, [[timestamp]], 'auth_email', 'field_lock_description', 'unlocked', NULL),
(1177, 2, [[timestamp]], 'auth_email', 'field_lock_idnumber', 'unlocked', NULL),
(1178, 2, [[timestamp]], 'auth_email', 'field_lock_institution', 'unlocked', NULL),
(1179, 2, [[timestamp]], 'auth_email', 'field_lock_department', 'unlocked', NULL),
(1180, 2, [[timestamp]], 'auth_email', 'field_lock_phone1', 'unlocked', NULL),
(1181, 2, [[timestamp]], 'auth_email', 'field_lock_phone2', 'unlocked', NULL),
(1182, 2, [[timestamp]], 'auth_email', 'field_lock_address', 'unlocked', NULL),
(1183, 2, [[timestamp]], 'auth_email', 'field_lock_firstnamephonetic', 'unlocked', NULL),
(1184, 2, [[timestamp]], 'auth_email', 'field_lock_lastnamephonetic', 'unlocked', NULL),
(1185, 2, [[timestamp]], 'auth_email', 'field_lock_middlename', 'unlocked', NULL),
(1186, 2, [[timestamp]], 'auth_email', 'field_lock_alternatename', 'unlocked', NULL),
(1187, 2, [[timestamp]], 'auth_db', 'host', '127.0.0.1', NULL),
(1188, 2, [[timestamp]], 'auth_db', 'type', 'mysqli', NULL),
(1189, 2, [[timestamp]], 'auth_db', 'sybasequoting', '0', NULL),
(1190, 2, [[timestamp]], 'auth_db', 'name', '', NULL),
(1191, 2, [[timestamp]], 'auth_db', 'user', '', NULL),
(1192, 2, [[timestamp]], 'auth_db', 'pass', '', NULL),
(1193, 2, [[timestamp]], 'auth_db', 'table', '', NULL),
(1194, 2, [[timestamp]], 'auth_db', 'fielduser', '', NULL),
(1195, 2, [[timestamp]], 'auth_db', 'fieldpass', '', NULL),
(1196, 2, [[timestamp]], 'auth_db', 'passtype', 'plaintext', NULL),
(1197, 2, [[timestamp]], 'auth_db', 'extencoding', 'utf-8', NULL),
(1198, 2, [[timestamp]], 'auth_db', 'setupsql', '', NULL),
(1199, 2, [[timestamp]], 'auth_db', 'debugauthdb', '0', NULL),
(1200, 2, [[timestamp]], 'auth_db', 'changepasswordurl', '', NULL),
(1201, 2, [[timestamp]], 'auth_db', 'removeuser', '0', NULL),
(1202, 2, [[timestamp]], 'auth_db', 'updateusers', '0', NULL),
(1203, 2, [[timestamp]], 'auth_db', 'field_map_firstname', '', NULL),
(1204, 2, [[timestamp]], 'auth_db', 'field_updatelocal_firstname', 'oncreate', NULL),
(1205, 2, [[timestamp]], 'auth_db', 'field_updateremote_firstname', '0', NULL),
(1206, 2, [[timestamp]], 'auth_db', 'field_lock_firstname', 'unlocked', NULL),
(1207, 2, [[timestamp]], 'auth_db', 'field_map_lastname', '', NULL),
(1208, 2, [[timestamp]], 'auth_db', 'field_updatelocal_lastname', 'oncreate', NULL),
(1209, 2, [[timestamp]], 'auth_db', 'field_updateremote_lastname', '0', NULL),
(1210, 2, [[timestamp]], 'auth_db', 'field_lock_lastname', 'unlocked', NULL),
(1211, 2, [[timestamp]], 'auth_db', 'field_map_email', '', NULL),
(1212, 2, [[timestamp]], 'auth_db', 'field_updatelocal_email', 'oncreate', NULL),
(1213, 2, [[timestamp]], 'auth_db', 'field_updateremote_email', '0', NULL),
(1214, 2, [[timestamp]], 'auth_db', 'field_lock_email', 'unlocked', NULL),
(1215, 2, [[timestamp]], 'auth_db', 'field_map_city', '', NULL),
(1216, 2, [[timestamp]], 'auth_db', 'field_updatelocal_city', 'oncreate', NULL),
(1217, 2, [[timestamp]], 'auth_db', 'field_updateremote_city', '0', NULL),
(1218, 2, [[timestamp]], 'auth_db', 'field_lock_city', 'unlocked', NULL),
(1219, 2, [[timestamp]], 'auth_db', 'field_map_country', '', NULL),
(1220, 2, [[timestamp]], 'auth_db', 'field_updatelocal_country', 'oncreate', NULL),
(1221, 2, [[timestamp]], 'auth_db', 'field_updateremote_country', '0', NULL),
(1222, 2, [[timestamp]], 'auth_db', 'field_lock_country', 'unlocked', NULL),
(1223, 2, [[timestamp]], 'auth_db', 'field_map_lang', '', NULL),
(1224, 2, [[timestamp]], 'auth_db', 'field_updatelocal_lang', 'oncreate', NULL),
(1225, 2, [[timestamp]], 'auth_db', 'field_updateremote_lang', '0', NULL),
(1226, 2, [[timestamp]], 'auth_db', 'field_lock_lang', 'unlocked', NULL),
(1227, 2, [[timestamp]], 'auth_db', 'field_map_description', '', NULL),
(1228, 2, [[timestamp]], 'auth_db', 'field_updatelocal_description', 'oncreate', NULL),
(1229, 2, [[timestamp]], 'auth_db', 'field_updateremote_description', '0', NULL),
(1230, 2, [[timestamp]], 'auth_db', 'field_lock_description', 'unlocked', NULL),
(1231, 2, [[timestamp]], 'auth_db', 'field_map_idnumber', '', NULL),
(1232, 2, [[timestamp]], 'auth_db', 'field_updatelocal_idnumber', 'oncreate', NULL),
(1233, 2, [[timestamp]], 'auth_db', 'field_updateremote_idnumber', '0', NULL),
(1234, 2, [[timestamp]], 'auth_db', 'field_lock_idnumber', 'unlocked', NULL),
(1235, 2, [[timestamp]], 'auth_db', 'field_map_institution', '', NULL),
(1236, 2, [[timestamp]], 'auth_db', 'field_updatelocal_institution', 'oncreate', NULL),
(1237, 2, [[timestamp]], 'auth_db', 'field_updateremote_institution', '0', NULL),
(1238, 2, [[timestamp]], 'auth_db', 'field_lock_institution', 'unlocked', NULL),
(1239, 2, [[timestamp]], 'auth_db', 'field_map_department', '', NULL),
(1240, 2, [[timestamp]], 'auth_db', 'field_updatelocal_department', 'oncreate', NULL),
(1241, 2, [[timestamp]], 'auth_db', 'field_updateremote_department', '0', NULL),
(1242, 2, [[timestamp]], 'auth_db', 'field_lock_department', 'unlocked', NULL),
(1243, 2, [[timestamp]], 'auth_db', 'field_map_phone1', '', NULL),
(1244, 2, [[timestamp]], 'auth_db', 'field_updatelocal_phone1', 'oncreate', NULL),
(1245, 2, [[timestamp]], 'auth_db', 'field_updateremote_phone1', '0', NULL),
(1246, 2, [[timestamp]], 'auth_db', 'field_lock_phone1', 'unlocked', NULL),
(1247, 2, [[timestamp]], 'auth_db', 'field_map_phone2', '', NULL),
(1248, 2, [[timestamp]], 'auth_db', 'field_updatelocal_phone2', 'oncreate', NULL),
(1249, 2, [[timestamp]], 'auth_db', 'field_updateremote_phone2', '0', NULL),
(1250, 2, [[timestamp]], 'auth_db', 'field_lock_phone2', 'unlocked', NULL),
(1251, 2, [[timestamp]], 'auth_db', 'field_map_address', '', NULL),
(1252, 2, [[timestamp]], 'auth_db', 'field_updatelocal_address', 'oncreate', NULL),
(1253, 2, [[timestamp]], 'auth_db', 'field_updateremote_address', '0', NULL),
(1254, 2, [[timestamp]], 'auth_db', 'field_lock_address', 'unlocked', NULL),
(1255, 2, [[timestamp]], 'auth_db', 'field_map_firstnamephonetic', '', NULL),
(1256, 2, [[timestamp]], 'auth_db', 'field_updatelocal_firstnamephonetic', 'oncreate', NULL),
(1257, 2, [[timestamp]], 'auth_db', 'field_updateremote_firstnamephonetic', '0', NULL),
(1258, 2, [[timestamp]], 'auth_db', 'field_lock_firstnamephonetic', 'unlocked', NULL),
(1259, 2, [[timestamp]], 'auth_db', 'field_map_lastnamephonetic', '', NULL),
(1260, 2, [[timestamp]], 'auth_db', 'field_updatelocal_lastnamephonetic', 'oncreate', NULL),
(1261, 2, [[timestamp]], 'auth_db', 'field_updateremote_lastnamephonetic', '0', NULL),
(1262, 2, [[timestamp]], 'auth_db', 'field_lock_lastnamephonetic', 'unlocked', NULL),
(1263, 2, [[timestamp]], 'auth_db', 'field_map_middlename', '', NULL),
(1264, 2, [[timestamp]], 'auth_db', 'field_updatelocal_middlename', 'oncreate', NULL),
(1265, 2, [[timestamp]], 'auth_db', 'field_updateremote_middlename', '0', NULL),
(1266, 2, [[timestamp]], 'auth_db', 'field_lock_middlename', 'unlocked', NULL),
(1267, 2, [[timestamp]], 'auth_db', 'field_map_alternatename', '', NULL),
(1268, 2, [[timestamp]], 'auth_db', 'field_updatelocal_alternatename', 'oncreate', NULL),
(1269, 2, [[timestamp]], 'auth_db', 'field_updateremote_alternatename', '0', NULL),
(1270, 2, [[timestamp]], 'auth_db', 'field_lock_alternatename', 'unlocked', NULL),
(1271, 2, [[timestamp]], 'auth_ldap', 'host_url', '', NULL),
(1272, 2, [[timestamp]], 'auth_ldap', 'ldap_version', '3', NULL),
(1273, 2, [[timestamp]], 'auth_ldap', 'start_tls', '0', NULL),
(1274, 2, [[timestamp]], 'auth_ldap', 'ldapencoding', 'utf-8', NULL),
(1275, 2, [[timestamp]], 'auth_ldap', 'pagesize', '250', NULL),
(1276, 2, [[timestamp]], 'auth_ldap', 'preventpassindb', '0', NULL),
(1277, 2, [[timestamp]], 'auth_ldap', 'bind_dn', '', NULL),
(1278, 2, [[timestamp]], 'auth_ldap', 'bind_pw', '', NULL),
(1279, 2, [[timestamp]], 'auth_ldap', 'user_type', 'default', NULL),
(1280, 2, [[timestamp]], 'auth_ldap', 'contexts', '', NULL),
(1281, 2, [[timestamp]], 'auth_ldap', 'search_sub', '0', NULL),
(1282, 2, [[timestamp]], 'auth_ldap', 'opt_deref', '0', NULL),
(1283, 2, [[timestamp]], 'auth_ldap', 'user_attribute', '', NULL),
(1284, 2, [[timestamp]], 'auth_ldap', 'suspended_attribute', '', NULL),
(1285, 2, [[timestamp]], 'auth_ldap', 'memberattribute', '', NULL),
(1286, 2, [[timestamp]], 'auth_ldap', 'memberattribute_isdn', '0', NULL),
(1287, 2, [[timestamp]], 'auth_ldap', 'objectclass', '', NULL),
(1288, 2, [[timestamp]], 'auth_ldap', 'forcechangepassword', '0', NULL),
(1289, 2, [[timestamp]], 'auth_ldap', 'stdchangepassword', '0', NULL),
(1290, 2, [[timestamp]], 'auth_ldap', 'passtype', 'plaintext', NULL),
(1291, 2, [[timestamp]], 'auth_ldap', 'changepasswordurl', '', NULL),
(1292, 2, [[timestamp]], 'auth_ldap', 'expiration', '0', NULL),
(1293, 2, [[timestamp]], 'auth_ldap', 'expiration_warning', '', NULL),
(1294, 2, [[timestamp]], 'auth_ldap', 'expireattr', '', NULL),
(1295, 2, [[timestamp]], 'auth_ldap', 'gracelogins', '0', NULL),
(1296, 2, [[timestamp]], 'auth_ldap', 'graceattr', '', NULL),
(1297, 2, [[timestamp]], 'auth_ldap', 'auth_user_create', '0', NULL),
(1298, 2, [[timestamp]], 'auth_ldap', 'create_context', '', NULL),
(1299, 2, [[timestamp]], 'auth_ldap', 'managercontext', '', NULL),
(1300, 2, [[timestamp]], 'auth_ldap', 'coursecreatorcontext', '', NULL),
(1301, 2, [[timestamp]], 'auth_ldap', 'removeuser', '0', NULL),
(1302, 2, [[timestamp]], 'auth_ldap', 'sync_suspended', '0', NULL),
(1303, 2, [[timestamp]], 'auth_ldap', 'sync_updateuserchunk', '1000', NULL),
(1304, 2, [[timestamp]], 'auth_ldap', 'ntlmsso_enabled', '0', NULL),
(1305, 2, [[timestamp]], 'auth_ldap', 'ntlmsso_subnet', '', NULL),
(1306, 2, [[timestamp]], 'auth_ldap', 'ntlmsso_ie_fastpath', '0', NULL),
(1307, 2, [[timestamp]], 'auth_ldap', 'ntlmsso_type', 'ntlm', NULL),
(1308, 2, [[timestamp]], 'auth_ldap', 'ntlmsso_remoteuserformat', '', NULL),
(1309, 2, [[timestamp]], 'auth_ldap', 'field_map_firstname', '', NULL),
(1310, 2, [[timestamp]], 'auth_ldap', 'field_updatelocal_firstname', 'oncreate', NULL),
(1311, 2, [[timestamp]], 'auth_ldap', 'field_updateremote_firstname', '0', NULL),
(1312, 2, [[timestamp]], 'auth_ldap', 'field_lock_firstname', 'unlocked', NULL),
(1313, 2, [[timestamp]], 'auth_ldap', 'field_map_lastname', '', NULL),
(1314, 2, [[timestamp]], 'auth_ldap', 'field_updatelocal_lastname', 'oncreate', NULL),
(1315, 2, [[timestamp]], 'auth_ldap', 'field_updateremote_lastname', '0', NULL),
(1316, 2, [[timestamp]], 'auth_ldap', 'field_lock_lastname', 'unlocked', NULL),
(1317, 2, [[timestamp]], 'auth_ldap', 'field_map_email', '', NULL),
(1318, 2, [[timestamp]], 'auth_ldap', 'field_updatelocal_email', 'oncreate', NULL),
(1319, 2, [[timestamp]], 'auth_ldap', 'field_updateremote_email', '0', NULL),
(1320, 2, [[timestamp]], 'auth_ldap', 'field_lock_email', 'unlocked', NULL),
(1321, 2, [[timestamp]], 'auth_ldap', 'field_map_city', '', NULL),
(1322, 2, [[timestamp]], 'auth_ldap', 'field_updatelocal_city', 'oncreate', NULL),
(1323, 2, [[timestamp]], 'auth_ldap', 'field_updateremote_city', '0', NULL),
(1324, 2, [[timestamp]], 'auth_ldap', 'field_lock_city', 'unlocked', NULL),
(1325, 2, [[timestamp]], 'auth_ldap', 'field_map_country', '', NULL),
(1326, 2, [[timestamp]], 'auth_ldap', 'field_updatelocal_country', 'oncreate', NULL),
(1327, 2, [[timestamp]], 'auth_ldap', 'field_updateremote_country', '0', NULL),
(1328, 2, [[timestamp]], 'auth_ldap', 'field_lock_country', 'unlocked', NULL),
(1329, 2, [[timestamp]], 'auth_ldap', 'field_map_lang', '', NULL),
(1330, 2, [[timestamp]], 'auth_ldap', 'field_updatelocal_lang', 'oncreate', NULL),
(1331, 2, [[timestamp]], 'auth_ldap', 'field_updateremote_lang', '0', NULL),
(1332, 2, [[timestamp]], 'auth_ldap', 'field_lock_lang', 'unlocked', NULL),
(1333, 2, [[timestamp]], 'auth_ldap', 'field_map_description', '', NULL),
(1334, 2, [[timestamp]], 'auth_ldap', 'field_updatelocal_description', 'oncreate', NULL),
(1335, 2, [[timestamp]], 'auth_ldap', 'field_updateremote_description', '0', NULL),
(1336, 2, [[timestamp]], 'auth_ldap', 'field_lock_description', 'unlocked', NULL),
(1337, 2, [[timestamp]], 'auth_ldap', 'field_map_idnumber', '', NULL),
(1338, 2, [[timestamp]], 'auth_ldap', 'field_updatelocal_idnumber', 'oncreate', NULL),
(1339, 2, [[timestamp]], 'auth_ldap', 'field_updateremote_idnumber', '0', NULL),
(1340, 2, [[timestamp]], 'auth_ldap', 'field_lock_idnumber', 'unlocked', NULL),
(1341, 2, [[timestamp]], 'auth_ldap', 'field_map_institution', '', NULL),
(1342, 2, [[timestamp]], 'auth_ldap', 'field_updatelocal_institution', 'oncreate', NULL),
(1343, 2, [[timestamp]], 'auth_ldap', 'field_updateremote_institution', '0', NULL),
(1344, 2, [[timestamp]], 'auth_ldap', 'field_lock_institution', 'unlocked', NULL),
(1345, 2, [[timestamp]], 'auth_ldap', 'field_map_department', '', NULL),
(1346, 2, [[timestamp]], 'auth_ldap', 'field_updatelocal_department', 'oncreate', NULL),
(1347, 2, [[timestamp]], 'auth_ldap', 'field_updateremote_department', '0', NULL),
(1348, 2, [[timestamp]], 'auth_ldap', 'field_lock_department', 'unlocked', NULL),
(1349, 2, [[timestamp]], 'auth_ldap', 'field_map_phone1', '', NULL),
(1350, 2, [[timestamp]], 'auth_ldap', 'field_updatelocal_phone1', 'oncreate', NULL),
(1351, 2, [[timestamp]], 'auth_ldap', 'field_updateremote_phone1', '0', NULL),
(1352, 2, [[timestamp]], 'auth_ldap', 'field_lock_phone1', 'unlocked', NULL),
(1353, 2, [[timestamp]], 'auth_ldap', 'field_map_phone2', '', NULL),
(1354, 2, [[timestamp]], 'auth_ldap', 'field_updatelocal_phone2', 'oncreate', NULL),
(1355, 2, [[timestamp]], 'auth_ldap', 'field_updateremote_phone2', '0', NULL),
(1356, 2, [[timestamp]], 'auth_ldap', 'field_lock_phone2', 'unlocked', NULL),
(1357, 2, [[timestamp]], 'auth_ldap', 'field_map_address', '', NULL),
(1358, 2, [[timestamp]], 'auth_ldap', 'field_updatelocal_address', 'oncreate', NULL),
(1359, 2, [[timestamp]], 'auth_ldap', 'field_updateremote_address', '0', NULL),
(1360, 2, [[timestamp]], 'auth_ldap', 'field_lock_address', 'unlocked', NULL),
(1361, 2, [[timestamp]], 'auth_ldap', 'field_map_firstnamephonetic', '', NULL),
(1362, 2, [[timestamp]], 'auth_ldap', 'field_updatelocal_firstnamephonetic', 'oncreate', NULL),
(1363, 2, [[timestamp]], 'auth_ldap', 'field_updateremote_firstnamephonetic', '0', NULL),
(1364, 2, [[timestamp]], 'auth_ldap', 'field_lock_firstnamephonetic', 'unlocked', NULL),
(1365, 2, [[timestamp]], 'auth_ldap', 'field_map_lastnamephonetic', '', NULL),
(1366, 2, [[timestamp]], 'auth_ldap', 'field_updatelocal_lastnamephonetic', 'oncreate', NULL),
(1367, 2, [[timestamp]], 'auth_ldap', 'field_updateremote_lastnamephonetic', '0', NULL),
(1368, 2, [[timestamp]], 'auth_ldap', 'field_lock_lastnamephonetic', 'unlocked', NULL),
(1369, 2, [[timestamp]], 'auth_ldap', 'field_map_middlename', '', NULL),
(1370, 2, [[timestamp]], 'auth_ldap', 'field_updatelocal_middlename', 'oncreate', NULL),
(1371, 2, [[timestamp]], 'auth_ldap', 'field_updateremote_middlename', '0', NULL),
(1372, 2, [[timestamp]], 'auth_ldap', 'field_lock_middlename', 'unlocked', NULL),
(1373, 2, [[timestamp]], 'auth_ldap', 'field_map_alternatename', '', NULL),
(1374, 2, [[timestamp]], 'auth_ldap', 'field_updatelocal_alternatename', 'oncreate', NULL),
(1375, 2, [[timestamp]], 'auth_ldap', 'field_updateremote_alternatename', '0', NULL),
(1376, 2, [[timestamp]], 'auth_ldap', 'field_lock_alternatename', 'unlocked', NULL),
(1377, 2, [[timestamp]], 'auth_manual', 'expiration', '0', NULL),
(1378, 2, [[timestamp]], 'auth_manual', 'expirationtime', '30', NULL),
(1379, 2, [[timestamp]], 'auth_manual', 'expiration_warning', '0', NULL),
(1380, 2, [[timestamp]], 'auth_manual', 'field_lock_firstname', 'unlocked', NULL),
(1381, 2, [[timestamp]], 'auth_manual', 'field_lock_lastname', 'unlocked', NULL),
(1382, 2, [[timestamp]], 'auth_manual', 'field_lock_email', 'unlocked', NULL),
(1383, 2, [[timestamp]], 'auth_manual', 'field_lock_city', 'unlocked', NULL),
(1384, 2, [[timestamp]], 'auth_manual', 'field_lock_country', 'unlocked', NULL),
(1385, 2, [[timestamp]], 'auth_manual', 'field_lock_lang', 'unlocked', NULL),
(1386, 2, [[timestamp]], 'auth_manual', 'field_lock_description', 'unlocked', NULL),
(1387, 2, [[timestamp]], 'auth_manual', 'field_lock_idnumber', 'unlocked', NULL),
(1388, 2, [[timestamp]], 'auth_manual', 'field_lock_institution', 'unlocked', NULL),
(1389, 2, [[timestamp]], 'auth_manual', 'field_lock_department', 'unlocked', NULL),
(1390, 2, [[timestamp]], 'auth_manual', 'field_lock_phone1', 'unlocked', NULL),
(1391, 2, [[timestamp]], 'auth_manual', 'field_lock_phone2', 'unlocked', NULL),
(1392, 2, [[timestamp]], 'auth_manual', 'field_lock_address', 'unlocked', NULL),
(1393, 2, [[timestamp]], 'auth_manual', 'field_lock_firstnamephonetic', 'unlocked', NULL),
(1394, 2, [[timestamp]], 'auth_manual', 'field_lock_lastnamephonetic', 'unlocked', NULL),
(1395, 2, [[timestamp]], 'auth_manual', 'field_lock_middlename', 'unlocked', NULL),
(1396, 2, [[timestamp]], 'auth_manual', 'field_lock_alternatename', 'unlocked', NULL),
(1397, 2, [[timestamp]], 'auth_none', 'field_lock_firstname', 'unlocked', NULL),
(1398, 2, [[timestamp]], 'auth_none', 'field_lock_lastname', 'unlocked', NULL),
(1399, 2, [[timestamp]], 'auth_none', 'field_lock_email', 'unlocked', NULL),
(1400, 2, [[timestamp]], 'auth_none', 'field_lock_city', 'unlocked', NULL),
(1401, 2, [[timestamp]], 'auth_none', 'field_lock_country', 'unlocked', NULL),
(1402, 2, [[timestamp]], 'auth_none', 'field_lock_lang', 'unlocked', NULL),
(1403, 2, [[timestamp]], 'auth_none', 'field_lock_description', 'unlocked', NULL),
(1404, 2, [[timestamp]], 'auth_none', 'field_lock_idnumber', 'unlocked', NULL),
(1405, 2, [[timestamp]], 'auth_none', 'field_lock_institution', 'unlocked', NULL),
(1406, 2, [[timestamp]], 'auth_none', 'field_lock_department', 'unlocked', NULL),
(1407, 2, [[timestamp]], 'auth_none', 'field_lock_phone1', 'unlocked', NULL),
(1408, 2, [[timestamp]], 'auth_none', 'field_lock_phone2', 'unlocked', NULL),
(1409, 2, [[timestamp]], 'auth_none', 'field_lock_address', 'unlocked', NULL),
(1410, 2, [[timestamp]], 'auth_none', 'field_lock_firstnamephonetic', 'unlocked', NULL),
(1411, 2, [[timestamp]], 'auth_none', 'field_lock_lastnamephonetic', 'unlocked', NULL),
(1412, 2, [[timestamp]], 'auth_none', 'field_lock_middlename', 'unlocked', NULL),
(1413, 2, [[timestamp]], 'auth_none', 'field_lock_alternatename', 'unlocked', NULL),
(1414, 2, [[timestamp]], 'auth_oauth2', 'field_lock_firstname', 'unlocked', NULL),
(1415, 2, [[timestamp]], 'auth_oauth2', 'field_lock_lastname', 'unlocked', NULL),
(1416, 2, [[timestamp]], 'auth_oauth2', 'field_lock_email', 'unlocked', NULL),
(1417, 2, [[timestamp]], 'auth_oauth2', 'field_lock_city', 'unlocked', NULL),
(1418, 2, [[timestamp]], 'auth_oauth2', 'field_lock_country', 'unlocked', NULL),
(1419, 2, [[timestamp]], 'auth_oauth2', 'field_lock_lang', 'unlocked', NULL),
(1420, 2, [[timestamp]], 'auth_oauth2', 'field_lock_description', 'unlocked', NULL),
(1421, 2, [[timestamp]], 'auth_oauth2', 'field_lock_idnumber', 'unlocked', NULL),
(1422, 2, [[timestamp]], 'auth_oauth2', 'field_lock_institution', 'unlocked', NULL),
(1423, 2, [[timestamp]], 'auth_oauth2', 'field_lock_department', 'unlocked', NULL),
(1424, 2, [[timestamp]], 'auth_oauth2', 'field_lock_phone1', 'unlocked', NULL),
(1425, 2, [[timestamp]], 'auth_oauth2', 'field_lock_phone2', 'unlocked', NULL),
(1426, 2, [[timestamp]], 'auth_oauth2', 'field_lock_address', 'unlocked', NULL);
INSERT INTO `[[dbprefix]]config_log` VALUES
(1427, 2, [[timestamp]], 'auth_oauth2', 'field_lock_firstnamephonetic', 'unlocked', NULL),
(1428, 2, [[timestamp]], 'auth_oauth2', 'field_lock_lastnamephonetic', 'unlocked', NULL),
(1429, 2, [[timestamp]], 'auth_oauth2', 'field_lock_middlename', 'unlocked', NULL),
(1430, 2, [[timestamp]], 'auth_oauth2', 'field_lock_alternatename', 'unlocked', NULL),
(1431, 2, [[timestamp]], 'auth_shibboleth', 'user_attribute', '', NULL),
(1432, 2, [[timestamp]], 'auth_shibboleth', 'convert_data', '', NULL),
(1433, 2, [[timestamp]], 'auth_shibboleth', 'alt_login', 'off', NULL),
(1434, 2, [[timestamp]], 'auth_shibboleth', 'organization_selection', 'urn:mace:organization1:providerID, Example Organization 1\n        https://another.idp-id.com/shibboleth, Other Example Organization, /Shibboleth.sso/DS/SWITCHaai\n        urn:mace:organization2:providerID, Example Organization 2, /Shibboleth.sso/WAYF/SWITCHaai', NULL),
(1435, 2, [[timestamp]], 'auth_shibboleth', 'logout_handler', '', NULL),
(1436, 2, [[timestamp]], 'auth_shibboleth', 'logout_return_url', '', NULL),
(1437, 2, [[timestamp]], 'auth_shibboleth', 'login_name', 'Shibboleth Login', NULL),
(1438, 2, [[timestamp]], 'auth_shibboleth', 'auth_logo', '', NULL),
(1439, 2, [[timestamp]], 'auth_shibboleth', 'auth_instructions', 'Use the <a href="[[softurl]]/auth/shibboleth/index.php">Shibboleth login</a> to get access via Shibboleth, if your institution supports it. Otherwise, use the normal login form shown here.', NULL),
(1440, 2, [[timestamp]], 'auth_shibboleth', 'changepasswordurl', '', NULL),
(1441, 2, [[timestamp]], 'auth_shibboleth', 'field_map_firstname', '', NULL),
(1442, 2, [[timestamp]], 'auth_shibboleth', 'field_updatelocal_firstname', 'oncreate', NULL),
(1443, 2, [[timestamp]], 'auth_shibboleth', 'field_lock_firstname', 'unlocked', NULL),
(1444, 2, [[timestamp]], 'auth_shibboleth', 'field_map_lastname', '', NULL),
(1445, 2, [[timestamp]], 'auth_shibboleth', 'field_updatelocal_lastname', 'oncreate', NULL),
(1446, 2, [[timestamp]], 'auth_shibboleth', 'field_lock_lastname', 'unlocked', NULL),
(1447, 2, [[timestamp]], 'auth_shibboleth', 'field_map_email', '', NULL),
(1448, 2, [[timestamp]], 'auth_shibboleth', 'field_updatelocal_email', 'oncreate', NULL),
(1449, 2, [[timestamp]], 'auth_shibboleth', 'field_lock_email', 'unlocked', NULL),
(1450, 2, [[timestamp]], 'auth_shibboleth', 'field_map_city', '', NULL),
(1451, 2, [[timestamp]], 'auth_shibboleth', 'field_updatelocal_city', 'oncreate', NULL),
(1452, 2, [[timestamp]], 'auth_shibboleth', 'field_lock_city', 'unlocked', NULL),
(1453, 2, [[timestamp]], 'auth_shibboleth', 'field_map_country', '', NULL),
(1454, 2, [[timestamp]], 'auth_shibboleth', 'field_updatelocal_country', 'oncreate', NULL),
(1455, 2, [[timestamp]], 'auth_shibboleth', 'field_lock_country', 'unlocked', NULL),
(1456, 2, [[timestamp]], 'auth_shibboleth', 'field_map_lang', '', NULL),
(1457, 2, [[timestamp]], 'auth_shibboleth', 'field_updatelocal_lang', 'oncreate', NULL),
(1458, 2, [[timestamp]], 'auth_shibboleth', 'field_lock_lang', 'unlocked', NULL),
(1459, 2, [[timestamp]], 'auth_shibboleth', 'field_map_description', '', NULL),
(1460, 2, [[timestamp]], 'auth_shibboleth', 'field_updatelocal_description', 'oncreate', NULL),
(1461, 2, [[timestamp]], 'auth_shibboleth', 'field_lock_description', 'unlocked', NULL),
(1462, 2, [[timestamp]], 'auth_shibboleth', 'field_map_idnumber', '', NULL),
(1463, 2, [[timestamp]], 'auth_shibboleth', 'field_updatelocal_idnumber', 'oncreate', NULL),
(1464, 2, [[timestamp]], 'auth_shibboleth', 'field_lock_idnumber', 'unlocked', NULL),
(1465, 2, [[timestamp]], 'auth_shibboleth', 'field_map_institution', '', NULL),
(1466, 2, [[timestamp]], 'auth_shibboleth', 'field_updatelocal_institution', 'oncreate', NULL),
(1467, 2, [[timestamp]], 'auth_shibboleth', 'field_lock_institution', 'unlocked', NULL),
(1468, 2, [[timestamp]], 'auth_shibboleth', 'field_map_department', '', NULL),
(1469, 2, [[timestamp]], 'auth_shibboleth', 'field_updatelocal_department', 'oncreate', NULL),
(1470, 2, [[timestamp]], 'auth_shibboleth', 'field_lock_department', 'unlocked', NULL),
(1471, 2, [[timestamp]], 'auth_shibboleth', 'field_map_phone1', '', NULL),
(1472, 2, [[timestamp]], 'auth_shibboleth', 'field_updatelocal_phone1', 'oncreate', NULL),
(1473, 2, [[timestamp]], 'auth_shibboleth', 'field_lock_phone1', 'unlocked', NULL),
(1474, 2, [[timestamp]], 'auth_shibboleth', 'field_map_phone2', '', NULL),
(1475, 2, [[timestamp]], 'auth_shibboleth', 'field_updatelocal_phone2', 'oncreate', NULL),
(1476, 2, [[timestamp]], 'auth_shibboleth', 'field_lock_phone2', 'unlocked', NULL),
(1477, 2, [[timestamp]], 'auth_shibboleth', 'field_map_address', '', NULL),
(1478, 2, [[timestamp]], 'auth_shibboleth', 'field_updatelocal_address', 'oncreate', NULL),
(1479, 2, [[timestamp]], 'auth_shibboleth', 'field_lock_address', 'unlocked', NULL),
(1480, 2, [[timestamp]], 'auth_shibboleth', 'field_map_firstnamephonetic', '', NULL),
(1481, 2, [[timestamp]], 'auth_shibboleth', 'field_updatelocal_firstnamephonetic', 'oncreate', NULL),
(1482, 2, [[timestamp]], 'auth_shibboleth', 'field_lock_firstnamephonetic', 'unlocked', NULL),
(1483, 2, [[timestamp]], 'auth_shibboleth', 'field_map_lastnamephonetic', '', NULL),
(1484, 2, [[timestamp]], 'auth_shibboleth', 'field_updatelocal_lastnamephonetic', 'oncreate', NULL),
(1485, 2, [[timestamp]], 'auth_shibboleth', 'field_lock_lastnamephonetic', 'unlocked', NULL),
(1486, 2, [[timestamp]], 'auth_shibboleth', 'field_map_middlename', '', NULL),
(1487, 2, [[timestamp]], 'auth_shibboleth', 'field_updatelocal_middlename', 'oncreate', NULL),
(1488, 2, [[timestamp]], 'auth_shibboleth', 'field_lock_middlename', 'unlocked', NULL),
(1489, 2, [[timestamp]], 'auth_shibboleth', 'field_map_alternatename', '', NULL),
(1490, 2, [[timestamp]], 'auth_shibboleth', 'field_updatelocal_alternatename', 'oncreate', NULL),
(1491, 2, [[timestamp]], 'auth_shibboleth', 'field_lock_alternatename', 'unlocked', NULL),
(1492, 2, [[timestamp]], 'block_accessreview', 'whattoshow', 'showboth', NULL),
(1493, 2, [[timestamp]], 'block_accessreview', 'errordisplay', 'showint', NULL),
(1494, 2, [[timestamp]], 'block_accessreview', 'toolpage', 'errors', NULL),
(1495, 2, [[timestamp]], 'block_activity_results', 'config_showbest', '3', NULL),
(1496, 2, [[timestamp]], 'block_activity_results', 'config_showbest_locked', '', NULL),
(1497, 2, [[timestamp]], 'block_activity_results', 'config_showworst', '0', NULL),
(1498, 2, [[timestamp]], 'block_activity_results', 'config_showworst_locked', '', NULL),
(1499, 2, [[timestamp]], 'block_activity_results', 'config_usegroups', '0', NULL),
(1500, 2, [[timestamp]], 'block_activity_results', 'config_usegroups_locked', '', NULL),
(1501, 2, [[timestamp]], 'block_activity_results', 'config_nameformat', '1', NULL),
(1502, 2, [[timestamp]], 'block_activity_results', 'config_nameformat_locked', '', NULL),
(1503, 2, [[timestamp]], 'block_activity_results', 'config_gradeformat', '1', NULL),
(1504, 2, [[timestamp]], 'block_activity_results', 'config_gradeformat_locked', '', NULL),
(1505, 2, [[timestamp]], 'block_activity_results', 'config_decimalpoints', '2', NULL),
(1506, 2, [[timestamp]], 'block_activity_results', 'config_decimalpoints_locked', '', NULL),
(1507, 2, [[timestamp]], 'block_myoverview', 'displaycategories', '1', NULL),
(1508, 2, [[timestamp]], 'block_myoverview', 'layouts', 'card,list,summary', NULL),
(1509, 2, [[timestamp]], 'block_myoverview', 'displaygroupingallincludinghidden', '0', NULL),
(1510, 2, [[timestamp]], 'block_myoverview', 'displaygroupingall', '1', NULL),
(1511, 2, [[timestamp]], 'block_myoverview', 'displaygroupinginprogress', '1', NULL),
(1512, 2, [[timestamp]], 'block_myoverview', 'displaygroupingpast', '1', NULL),
(1513, 2, [[timestamp]], 'block_myoverview', 'displaygroupingfuture', '1', NULL),
(1514, 2, [[timestamp]], 'block_myoverview', 'displaygroupingcustomfield', '0', NULL),
(1515, 2, [[timestamp]], 'block_myoverview', 'customfiltergrouping', '', NULL),
(1516, 2, [[timestamp]], 'block_myoverview', 'displaygroupingfavourites', '1', NULL),
(1517, 2, [[timestamp]], 'block_myoverview', 'displaygroupinghidden', '1', NULL),
(1518, 2, [[timestamp]], NULL, 'block_course_list_adminview', 'all', NULL),
(1519, 2, [[timestamp]], NULL, 'block_course_list_hideallcourseslink', '0', NULL),
(1520, 2, [[timestamp]], NULL, 'block_online_users_timetosee', '5', NULL),
(1521, 2, [[timestamp]], NULL, 'block_online_users_onlinestatushiding', '1', NULL),
(1522, 2, [[timestamp]], 'block_recentlyaccessedcourses', 'displaycategories', '1', NULL),
(1523, 2, [[timestamp]], NULL, 'block_rss_client_num_entries', '5', NULL),
(1524, 2, [[timestamp]], NULL, 'block_rss_client_timeout', '30', NULL),
(1525, 2, [[timestamp]], 'block_starredcourses', 'displaycategories', '1', NULL),
(1526, 2, [[timestamp]], NULL, 'block_html_allowcssclasses', '0', NULL),
(1527, 2, [[timestamp]], 'block_tag_youtube', 'apikey', '', NULL),
(1528, 2, [[timestamp]], 'format_topics', 'indentation', '1', NULL),
(1529, 2, [[timestamp]], 'format_singleactivity', 'activitytype', 'forum', NULL),
(1530, 2, [[timestamp]], 'format_weeks', 'indentation', '1', NULL),
(1531, 2, [[timestamp]], 'format_weeks', 'maxinitialsections', '52', NULL),
(1532, 2, [[timestamp]], 'fileconverter_googledrive', 'issuerid', '', NULL),
(1533, 2, [[timestamp]], NULL, 'pathtounoconv', '/usr/bin/unoconv', NULL),
(1534, 2, [[timestamp]], 'enrol_cohort', 'roleid', '5', NULL),
(1535, 2, [[timestamp]], 'enrol_cohort', 'unenrolaction', '0', NULL),
(1536, 2, [[timestamp]], 'enrol_meta', 'nosyncroleids', '', NULL),
(1537, 2, [[timestamp]], 'enrol_meta', 'syncall', '1', NULL),
(1538, 2, [[timestamp]], 'enrol_meta', 'unenrolaction', '3', NULL),
(1539, 2, [[timestamp]], 'enrol_meta', 'coursesort', 'sortorder', NULL),
(1540, 2, [[timestamp]], 'enrol_fee', 'expiredaction', '3', NULL),
(1541, 2, [[timestamp]], 'enrol_fee', 'status', '1', NULL),
(1542, 2, [[timestamp]], 'enrol_fee', 'cost', '0', NULL),
(1543, 2, [[timestamp]], 'enrol_fee', 'currency', 'USD', NULL),
(1544, 2, [[timestamp]], 'enrol_fee', 'roleid', '5', NULL),
(1545, 2, [[timestamp]], 'enrol_fee', 'enrolperiod', '0', NULL),
(1546, 2, [[timestamp]], 'enrol_database', 'dbtype', '', NULL),
(1547, 2, [[timestamp]], 'enrol_database', 'dbhost', 'localhost', NULL),
(1548, 2, [[timestamp]], 'enrol_database', 'dbuser', '', NULL),
(1549, 2, [[timestamp]], 'enrol_database', 'dbpass', '', NULL),
(1550, 2, [[timestamp]], 'enrol_database', 'dbname', '', NULL),
(1551, 2, [[timestamp]], 'enrol_database', 'dbencoding', 'utf-8', NULL),
(1552, 2, [[timestamp]], 'enrol_database', 'dbsetupsql', '', NULL),
(1553, 2, [[timestamp]], 'enrol_database', 'dbsybasequoting', '0', NULL),
(1554, 2, [[timestamp]], 'enrol_database', 'debugdb', '0', NULL),
(1555, 2, [[timestamp]], 'enrol_database', 'localcoursefield', 'idnumber', NULL),
(1556, 2, [[timestamp]], 'enrol_database', 'localuserfield', 'idnumber', NULL),
(1557, 2, [[timestamp]], 'enrol_database', 'localrolefield', 'shortname', NULL),
(1558, 2, [[timestamp]], 'enrol_database', 'localcategoryfield', 'id', NULL),
(1559, 2, [[timestamp]], 'enrol_database', 'remoteenroltable', '', NULL),
(1560, 2, [[timestamp]], 'enrol_database', 'remotecoursefield', '', NULL),
(1561, 2, [[timestamp]], 'enrol_database', 'remoteuserfield', '', NULL),
(1562, 2, [[timestamp]], 'enrol_database', 'remoterolefield', '', NULL),
(1563, 2, [[timestamp]], 'enrol_database', 'remoteotheruserfield', '', NULL),
(1564, 2, [[timestamp]], 'enrol_database', 'defaultrole', '5', NULL),
(1565, 2, [[timestamp]], 'enrol_database', 'ignorehiddencourses', '0', NULL),
(1566, 2, [[timestamp]], 'enrol_database', 'unenrolaction', '0', NULL),
(1567, 2, [[timestamp]], 'enrol_database', 'newcoursetable', '', NULL),
(1568, 2, [[timestamp]], 'enrol_database', 'newcoursefullname', 'fullname', NULL),
(1569, 2, [[timestamp]], 'enrol_database', 'newcourseshortname', 'shortname', NULL),
(1570, 2, [[timestamp]], 'enrol_database', 'newcourseidnumber', 'idnumber', NULL),
(1571, 2, [[timestamp]], 'enrol_database', 'newcoursestartdate', '', NULL),
(1572, 2, [[timestamp]], 'enrol_database', 'newcourseenddate', '', NULL),
(1573, 2, [[timestamp]], 'enrol_database', 'newcoursecategory', '', NULL),
(1574, 2, [[timestamp]], 'enrol_database', 'defaultcategory', '1', NULL),
(1575, 2, [[timestamp]], 'enrol_database', 'templatecourse', '', NULL),
(1576, 2, [[timestamp]], 'enrol_flatfile', 'location', '', NULL),
(1577, 2, [[timestamp]], 'enrol_flatfile', 'encoding', 'UTF-8', NULL),
(1578, 2, [[timestamp]], 'enrol_flatfile', 'mailstudents', '0', NULL),
(1579, 2, [[timestamp]], 'enrol_flatfile', 'mailteachers', '0', NULL),
(1580, 2, [[timestamp]], 'enrol_flatfile', 'mailadmins', '0', NULL),
(1581, 2, [[timestamp]], 'enrol_flatfile', 'unenrolaction', '3', NULL),
(1582, 2, [[timestamp]], 'enrol_flatfile', 'expiredaction', '3', NULL),
(1583, 2, [[timestamp]], 'enrol_guest', 'requirepassword', '0', NULL),
(1584, 2, [[timestamp]], 'enrol_guest', 'usepasswordpolicy', '0', NULL),
(1585, 2, [[timestamp]], 'enrol_guest', 'showhint', '0', NULL),
(1586, 2, [[timestamp]], 'enrol_guest', 'defaultenrol', '1', NULL),
(1587, 2, [[timestamp]], 'enrol_guest', 'status', '1', NULL),
(1588, 2, [[timestamp]], 'enrol_guest', 'status_adv', '', NULL),
(1589, 2, [[timestamp]], 'enrol_imsenterprise', 'imsfilelocation', '', NULL),
(1590, 2, [[timestamp]], 'enrol_imsenterprise', 'logtolocation', '', NULL),
(1591, 2, [[timestamp]], 'enrol_imsenterprise', 'mailadmins', '0', NULL),
(1592, 2, [[timestamp]], 'enrol_imsenterprise', 'createnewusers', '0', NULL),
(1593, 2, [[timestamp]], 'enrol_imsenterprise', 'imsupdateusers', '0', NULL),
(1594, 2, [[timestamp]], 'enrol_imsenterprise', 'imsdeleteusers', '0', NULL),
(1595, 2, [[timestamp]], 'enrol_imsenterprise', 'fixcaseusernames', '0', NULL),
(1596, 2, [[timestamp]], 'enrol_imsenterprise', 'fixcasepersonalnames', '0', NULL),
(1597, 2, [[timestamp]], 'enrol_imsenterprise', 'imssourcedidfallback', '0', NULL),
(1598, 2, [[timestamp]], 'enrol_imsenterprise', 'imsrolemap01', '5', NULL),
(1599, 2, [[timestamp]], 'enrol_imsenterprise', 'imsrolemap02', '3', NULL),
(1600, 2, [[timestamp]], 'enrol_imsenterprise', 'imsrolemap03', '3', NULL),
(1601, 2, [[timestamp]], 'enrol_imsenterprise', 'imsrolemap04', '5', NULL),
(1602, 2, [[timestamp]], 'enrol_imsenterprise', 'imsrolemap05', '0', NULL),
(1603, 2, [[timestamp]], 'enrol_imsenterprise', 'imsrolemap06', '4', NULL),
(1604, 2, [[timestamp]], 'enrol_imsenterprise', 'imsrolemap07', '0', NULL),
(1605, 2, [[timestamp]], 'enrol_imsenterprise', 'imsrolemap08', '4', NULL),
(1606, 2, [[timestamp]], 'enrol_imsenterprise', 'truncatecoursecodes', '0', NULL),
(1607, 2, [[timestamp]], 'enrol_imsenterprise', 'createnewcourses', '0', NULL),
(1608, 2, [[timestamp]], 'enrol_imsenterprise', 'updatecourses', '0', NULL),
(1609, 2, [[timestamp]], 'enrol_imsenterprise', 'createnewcategories', '0', NULL),
(1610, 2, [[timestamp]], 'enrol_imsenterprise', 'nestedcategories', '0', NULL),
(1611, 2, [[timestamp]], 'enrol_imsenterprise', 'categoryidnumber', '0', NULL),
(1612, 2, [[timestamp]], 'enrol_imsenterprise', 'categoryseparator', '', NULL),
(1613, 2, [[timestamp]], 'enrol_imsenterprise', 'imsunenrol', '0', NULL),
(1614, 2, [[timestamp]], 'enrol_imsenterprise', 'unenrolaction', '0', NULL),
(1615, 2, [[timestamp]], 'enrol_imsenterprise', 'imscoursemapshortname', 'coursecode', NULL),
(1616, 2, [[timestamp]], 'enrol_imsenterprise', 'imscoursemapfullname', 'short', NULL),
(1617, 2, [[timestamp]], 'enrol_imsenterprise', 'imscoursemapsummary', 'ignore', NULL),
(1618, 2, [[timestamp]], 'enrol_imsenterprise', 'imsrestricttarget', '', NULL),
(1619, 2, [[timestamp]], 'enrol_imsenterprise', 'imscapitafix', '0', NULL),
(1620, 2, [[timestamp]], 'enrol_ldap', 'host_url', '', NULL),
(1621, 2, [[timestamp]], 'enrol_ldap', 'start_tls', '0', NULL),
(1622, 2, [[timestamp]], 'enrol_ldap', 'ldap_version', '3', NULL),
(1623, 2, [[timestamp]], 'enrol_ldap', 'ldapencoding', 'utf-8', NULL),
(1624, 2, [[timestamp]], 'enrol_ldap', 'pagesize', '250', NULL),
(1625, 2, [[timestamp]], 'enrol_ldap', 'bind_dn', '', NULL),
(1626, 2, [[timestamp]], 'enrol_ldap', 'bind_pw', '', NULL),
(1627, 2, [[timestamp]], 'enrol_ldap', 'course_search_sub', '0', NULL),
(1628, 2, [[timestamp]], 'enrol_ldap', 'memberattribute_isdn', '0', NULL),
(1629, 2, [[timestamp]], 'enrol_ldap', 'user_contexts', '', NULL),
(1630, 2, [[timestamp]], 'enrol_ldap', 'user_search_sub', '0', NULL),
(1631, 2, [[timestamp]], 'enrol_ldap', 'user_type', 'default', NULL),
(1632, 2, [[timestamp]], 'enrol_ldap', 'opt_deref', '0', NULL),
(1633, 2, [[timestamp]], 'enrol_ldap', 'idnumber_attribute', '', NULL),
(1634, 2, [[timestamp]], 'enrol_ldap', 'objectclass', '', NULL),
(1635, 2, [[timestamp]], 'enrol_ldap', 'course_idnumber', '', NULL),
(1636, 2, [[timestamp]], 'enrol_ldap', 'course_shortname', '', NULL),
(1637, 2, [[timestamp]], 'enrol_ldap', 'course_fullname', '', NULL),
(1638, 2, [[timestamp]], 'enrol_ldap', 'course_summary', '', NULL),
(1639, 2, [[timestamp]], 'enrol_ldap', 'ignorehiddencourses', '0', NULL),
(1640, 2, [[timestamp]], 'enrol_ldap', 'unenrolaction', '0', NULL),
(1641, 2, [[timestamp]], 'enrol_ldap', 'autocreate', '0', NULL),
(1642, 2, [[timestamp]], 'enrol_ldap', 'category', '1', NULL),
(1643, 2, [[timestamp]], 'enrol_ldap', 'template', '', NULL),
(1644, 2, [[timestamp]], 'enrol_ldap', 'course_shortname_updateonsync', '0', NULL),
(1645, 2, [[timestamp]], 'enrol_ldap', 'course_fullname_updateonsync', '0', NULL),
(1646, 2, [[timestamp]], 'enrol_ldap', 'course_summary_updateonsync', '0', NULL),
(1647, 2, [[timestamp]], 'enrol_ldap', 'nested_groups', '0', NULL),
(1648, 2, [[timestamp]], 'enrol_ldap', 'group_memberofattribute', '', NULL),
(1649, 2, [[timestamp]], 'enrol_manual', 'expiredaction', '1', NULL),
(1650, 2, [[timestamp]], 'enrol_manual', 'expirynotifyhour', '6', NULL),
(1651, 2, [[timestamp]], 'enrol_manual', 'defaultenrol', '1', NULL),
(1652, 2, [[timestamp]], 'enrol_manual', 'status', '0', NULL),
(1653, 2, [[timestamp]], 'enrol_manual', 'roleid', '5', NULL),
(1654, 2, [[timestamp]], 'enrol_manual', 'enrolstart', '4', NULL),
(1655, 2, [[timestamp]], 'enrol_manual', 'enrolperiod', '0', NULL),
(1656, 2, [[timestamp]], 'enrol_manual', 'expirynotify', '0', NULL),
(1657, 2, [[timestamp]], 'enrol_manual', 'expirythreshold', '86400', NULL),
(1658, 2, [[timestamp]], 'enrol_manual', 'sendcoursewelcomemessage', '1', NULL),
(1659, 2, [[timestamp]], 'enrol_paypal', 'paypalbusiness', '', NULL),
(1660, 2, [[timestamp]], 'enrol_paypal', 'mailstudents', '0', NULL),
(1661, 2, [[timestamp]], 'enrol_paypal', 'mailteachers', '0', NULL),
(1662, 2, [[timestamp]], 'enrol_paypal', 'mailadmins', '0', NULL),
(1663, 2, [[timestamp]], 'enrol_paypal', 'expiredaction', '3', NULL),
(1664, 2, [[timestamp]], 'enrol_paypal', 'status', '1', NULL),
(1665, 2, [[timestamp]], 'enrol_paypal', 'cost', '0', NULL),
(1666, 2, [[timestamp]], 'enrol_paypal', 'currency', 'USD', NULL),
(1667, 2, [[timestamp]], 'enrol_paypal', 'roleid', '5', NULL),
(1668, 2, [[timestamp]], 'enrol_paypal', 'enrolperiod', '0', NULL),
(1669, 2, [[timestamp]], 'enrol_lti', 'emaildisplay', '2', NULL),
(1670, 2, [[timestamp]], 'enrol_lti', 'city', '', NULL),
(1671, 2, [[timestamp]], 'enrol_lti', 'country', '', NULL),
(1672, 2, [[timestamp]], 'enrol_lti', 'timezone', '99', NULL),
(1673, 2, [[timestamp]], 'enrol_lti', 'lang', 'en', NULL),
(1674, 2, [[timestamp]], 'enrol_lti', 'institution', '', NULL),
(1675, 2, [[timestamp]], 'enrol_self', 'requirepassword', '0', NULL),
(1676, 2, [[timestamp]], 'enrol_self', 'usepasswordpolicy', '0', NULL),
(1677, 2, [[timestamp]], 'enrol_self', 'showhint', '0', NULL),
(1678, 2, [[timestamp]], 'enrol_self', 'expiredaction', '1', NULL),
(1679, 2, [[timestamp]], 'enrol_self', 'expirynotifyhour', '6', NULL),
(1680, 2, [[timestamp]], 'enrol_self', 'defaultenrol', '1', NULL),
(1681, 2, [[timestamp]], 'enrol_self', 'status', '1', NULL),
(1682, 2, [[timestamp]], 'enrol_self', 'newenrols', '1', NULL),
(1683, 2, [[timestamp]], 'enrol_self', 'groupkey', '0', NULL),
(1684, 2, [[timestamp]], 'enrol_self', 'roleid', '5', NULL),
(1685, 2, [[timestamp]], 'enrol_self', 'enrolperiod', '0', NULL),
(1686, 2, [[timestamp]], 'enrol_self', 'expirynotify', '0', NULL),
(1687, 2, [[timestamp]], 'enrol_self', 'expirythreshold', '86400', NULL),
(1688, 2, [[timestamp]], 'enrol_self', 'longtimenosee', '0', NULL),
(1689, 2, [[timestamp]], 'enrol_self', 'maxenrolled', '0', NULL),
(1690, 2, [[timestamp]], 'enrol_self', 'sendcoursewelcomemessage', '1', NULL),
(1691, 2, [[timestamp]], 'filter_urltolink', 'formats', '1,4,0', NULL),
(1692, 2, [[timestamp]], 'filter_urltolink', 'embedimages', '1', NULL),
(1693, 2, [[timestamp]], 'filter_emoticon', 'formats', '1,4,0', NULL),
(1694, 2, [[timestamp]], 'filter_displayh5p', 'allowedsources', '', NULL),
(1695, 2, [[timestamp]], 'filter_mathjaxloader', 'httpsurl', 'https://cdn.jsdelivr.net/npm/mathjax@3.2.2/es5/tex-mml-chtml.js', NULL),
(1696, 2, [[timestamp]], 'filter_mathjaxloader', 'texfiltercompatibility', '0', NULL),
(1697, 2, [[timestamp]], 'filter_mathjaxloader', 'mathjaxconfig', '', NULL),
(1698, 2, [[timestamp]], 'filter_mathjaxloader', 'additionaldelimiters', '', NULL),
(1699, 2, [[timestamp]], NULL, 'filter_multilang_force_old', '0', NULL),
(1700, 2, [[timestamp]], 'filter_tex', 'latexpreamble', '\\usepackage[latin1]{inputenc}\n\\usepackage{amsmath}\n\\usepackage{amsfonts}\n\\RequirePackage{amsmath,amssymb,latexsym}\n', NULL),
(1701, 2, [[timestamp]], 'filter_tex', 'latexbackground', '#FFFFFF', NULL),
(1702, 2, [[timestamp]], 'filter_tex', 'density', '120', NULL),
(1703, 2, [[timestamp]], 'filter_tex', 'pathlatex', '[[default_filter_tex_pathlatex]]', NULL),
(1704, 2, [[timestamp]], 'filter_tex', 'pathdvips', '[[default_filter_tex_pathdvips]]', NULL),
(1705, 2, [[timestamp]], 'filter_tex', 'pathconvert', '[[default_filter_tex_pathconvert]]', NULL),
(1706, 2, [[timestamp]], 'filter_tex', 'pathdvisvgm', '[[default_filter_tex_dvisvgm]]', NULL),
(1707, 2, [[timestamp]], 'filter_tex', 'pathmimetex', '', NULL),
(1708, 2, [[timestamp]], 'filter_tex', 'convertformat', 'gif', NULL),
(1709, 2, [[timestamp]], 'logstore_database', 'dbdriver', '', NULL),
(1710, 2, [[timestamp]], 'logstore_database', 'dbhost', '', NULL),
(1711, 2, [[timestamp]], 'logstore_database', 'dbuser', '', NULL),
(1712, 2, [[timestamp]], 'logstore_database', 'dbpass', '', NULL),
(1713, 2, [[timestamp]], 'logstore_database', 'dbname', '', NULL),
(1714, 2, [[timestamp]], 'logstore_database', 'dbtable', '', NULL),
(1715, 2, [[timestamp]], 'logstore_database', 'dbpersist', '0', NULL),
(1716, 2, [[timestamp]], 'logstore_database', 'dbsocket', '', NULL),
(1717, 2, [[timestamp]], 'logstore_database', 'dbport', '', NULL),
(1718, 2, [[timestamp]], 'logstore_database', 'dbschema', '', NULL),
(1719, 2, [[timestamp]], 'logstore_database', 'dbcollation', '', NULL),
(1720, 2, [[timestamp]], 'logstore_database', 'dbhandlesoptions', '0', NULL),
(1721, 2, [[timestamp]], 'logstore_database', 'buffersize', '50', NULL),
(1722, 2, [[timestamp]], 'logstore_database', 'jsonformat', '1', NULL),
(1723, 2, [[timestamp]], 'logstore_database', 'logguests', '0', NULL),
(1724, 2, [[timestamp]], 'logstore_database', 'includelevels', '1,2,0', NULL),
(1725, 2, [[timestamp]], 'logstore_database', 'includeactions', 'c,r,u,d', NULL),
(1726, 2, [[timestamp]], 'logstore_standard', 'logguests', '1', NULL),
(1727, 2, [[timestamp]], 'logstore_standard', 'jsonformat', '1', NULL),
(1728, 2, [[timestamp]], 'logstore_standard', 'loglifetime', '0', NULL),
(1729, 2, [[timestamp]], 'logstore_standard', 'buffersize', '50', NULL),
(1730, 2, [[timestamp]], 'mlbackend_python', 'useserver', '0', NULL),
(1731, 2, [[timestamp]], 'mlbackend_python', 'host', '', NULL),
(1732, 2, [[timestamp]], 'mlbackend_python', 'port', '0', NULL),
(1733, 2, [[timestamp]], 'mlbackend_python', 'secure', '0', NULL),
(1734, 2, [[timestamp]], 'mlbackend_python', 'username', 'default', NULL),
(1735, 2, [[timestamp]], 'mlbackend_python', 'password', '', NULL),
(1736, 2, [[timestamp]], 'media_videojs', 'videoextensions', 'html_video,media_source,.f4v,.flv', NULL),
(1737, 2, [[timestamp]], 'media_videojs', 'audioextensions', 'html_audio', NULL),
(1738, 2, [[timestamp]], 'media_videojs', 'youtube', '1', NULL),
(1739, 2, [[timestamp]], 'media_videojs', 'videocssclass', 'video-js', NULL),
(1740, 2, [[timestamp]], 'media_videojs', 'audiocssclass', 'video-js', NULL),
(1741, 2, [[timestamp]], 'media_videojs', 'limitsize', '1', NULL),
(1742, 2, [[timestamp]], 'media_vimeo', 'donottrack', '0', NULL),
(1743, 2, [[timestamp]], 'media_youtube', 'nocookie', '0', NULL),
(1744, 2, [[timestamp]], 'paygw_paypal', 'surcharge', '0', NULL),
(1745, 2, [[timestamp]], 'qtype_multichoice', 'answerhowmany', '1', NULL),
(1746, 2, [[timestamp]], 'qtype_multichoice', 'shuffleanswers', '1', NULL),
(1747, 2, [[timestamp]], 'qtype_multichoice', 'answernumbering', 'abc', NULL),
(1748, 2, [[timestamp]], 'qtype_multichoice', 'showstandardinstruction', '0', NULL),
(1749, 2, [[timestamp]], 'qtype_ordering', 'defaultanswerformat', '0', NULL),
(1750, 2, [[timestamp]], 'editor_tiny', 'branding', '1', NULL),
(1751, 2, [[timestamp]], 'editor_tiny', 'extended_valid_elements', 'script[*],p[*],i[*]', NULL),
(1752, 2, [[timestamp]], 'editor_tiny', 'package_source', '1', NULL),
(1753, 2, [[timestamp]], 'editor_tiny', 'package_source_standalone_path', '', NULL),
(1754, 2, [[timestamp]], 'tiny_equation', 'librarygroup1', '\n\\cdot\n\\times\n\\ast\n\\div\n\\diamond\n\\pm\n\\mp\n\\oplus\n\\ominus\n\\otimes\n\\oslash\n\\odot\n\\circ\n\\bullet\n\\asymp\n\\equiv\n\\subseteq\n\\supseteq\n\\leq\n\\geq\n\\preceq\n\\succeq\n\\sim\n\\simeq\n\\approx\n\\subset\n\\supset\n\\ll\n\\gg\n\\prec\n\\succ\n\\infty\n\\in\n\\ni\n\\forall\n\\exists\n\\neq\n', NULL),
(1755, 2, [[timestamp]], 'tiny_equation', 'librarygroup2', '\n\\leftarrow\n\\rightarrow\n\\uparrow\n\\downarrow\n\\leftrightarrow\n\\nearrow\n\\searrow\n\\swarrow\n\\nwarrow\n\\Leftarrow\n\\Rightarrow\n\\Uparrow\n\\Downarrow\n\\Leftrightarrow\n', NULL),
(1756, 2, [[timestamp]], 'tiny_equation', 'librarygroup3', '\n\\alpha\n\\beta\n\\gamma\n\\delta\n\\epsilon\n\\zeta\n\\eta\n\\theta\n\\iota\n\\kappa\n\\lambda\n\\mu\n\\nu\n\\xi\n\\pi\n\\rho\n\\sigma\n\\tau\n\\upsilon\n\\phi\n\\chi\n\\psi\n\\omega\n\\Gamma\n\\Delta\n\\Theta\n\\Lambda\n\\Xi\n\\Pi\n\\Sigma\n\\Upsilon\n\\Phi\n\\Psi\n\\Omega\n', NULL),
(1757, 2, [[timestamp]], 'tiny_equation', 'librarygroup4', '\n\\sum{a,b}\n\\sqrt[a]{b+c}\n\\int_{a}^{b}{c}\n\\iint_{a}^{b}{c}\n\\iiint_{a}^{b}{c}\n\\oint{a}\n(a)\n[a]\n\\lbrace{a}\\rbrace\n\\left| \\begin{matrix} a_1 & a_2 \\\\ a_3 & a_4 \\end{matrix} \\right|\n\\frac{a}{b+c}\n\\vec{a}\n\\binom {a} {b}\n{a \\brack b}\n{a \\brace b}\n', NULL),
(1758, 2, [[timestamp]], 'tiny_premium', 'plugin_source', '1', NULL),
(1759, 2, [[timestamp]], 'tiny_premium', 'apikey', '', NULL),
(1760, 2, [[timestamp]], 'tiny_recordrtc', 'allowedtypes', 'audio,video', NULL),
(1761, 2, [[timestamp]], 'tiny_recordrtc', 'audiobitrate', '128000', NULL),
(1762, 2, [[timestamp]], 'tiny_recordrtc', 'videobitrate', '2500000', NULL),
(1763, 2, [[timestamp]], 'tiny_recordrtc', 'screenbitrate', '2500000', NULL),
(1764, 2, [[timestamp]], 'tiny_recordrtc', 'audiotimelimit', '120', NULL),
(1765, 2, [[timestamp]], 'tiny_recordrtc', 'videotimelimit', '120', NULL),
(1766, 2, [[timestamp]], 'tiny_recordrtc', 'screentimelimit', '120', NULL),
(1767, 2, [[timestamp]], 'tiny_recordrtc', 'screensize', '1280,720', NULL),
(1768, 2, [[timestamp]], 'tiny_recordrtc', 'allowedpausing', '0', NULL),
(1769, 2, [[timestamp]], 'tiny_recordrtc', 'audiortcformat', '0', NULL),
(1770, 2, [[timestamp]], NULL, 'profileroles', '5,4,3', NULL),
(1771, 2, [[timestamp]], NULL, 'coursecontact', '3', NULL),
(1772, 2, [[timestamp]], NULL, 'frontpage', '6', NULL),
(1773, 2, [[timestamp]], NULL, 'frontpageloggedin', '6', NULL),
(1774, 2, [[timestamp]], NULL, 'maxcategorydepth', '2', NULL),
(1775, 2, [[timestamp]], NULL, 'frontpagecourselimit', '200', NULL),
(1776, 2, [[timestamp]], NULL, 'commentsperpage', '15', NULL),
(1777, 2, [[timestamp]], NULL, 'defaultfrontpageroleid', '8', NULL),
(1778, 2, [[timestamp]], NULL, 'messageinbound_enabled', '0', NULL),
(1779, 2, [[timestamp]], NULL, 'messageinbound_mailbox', '', NULL),
(1780, 2, [[timestamp]], NULL, 'messageinbound_domain', '', NULL),
(1781, 2, [[timestamp]], NULL, 'messageinbound_host', '', NULL),
(1782, 2, [[timestamp]], NULL, 'messageinbound_hostssl', 'ssl', NULL),
(1783, 2, [[timestamp]], NULL, 'messageinbound_hostuser', '', NULL),
(1784, 2, [[timestamp]], NULL, 'messageinbound_hostpass', '', NULL),
(1785, 2, [[timestamp]], 'tool_mobile', 'apppolicy', '', NULL),
(1786, 2, [[timestamp]], 'tool_mobile', 'typeoflogin', '1', NULL),
(1787, 2, [[timestamp]], 'tool_mobile', 'autologout', '0', NULL),
(1788, 2, [[timestamp]], 'tool_mobile', 'autologouttime', '86400', NULL),
(1789, 2, [[timestamp]], 'tool_mobile', 'qrcodetype', '1', NULL),
(1790, 2, [[timestamp]], 'tool_mobile', 'qrkeyttl', '600', NULL),
(1791, 2, [[timestamp]], 'tool_mobile', 'qrsameipcheck', '1', NULL),
(1792, 2, [[timestamp]], 'tool_mobile', 'forcedurlscheme', 'moodlemobile', NULL),
(1793, 2, [[timestamp]], 'tool_mobile', 'minimumversion', '', NULL),
(1794, 2, [[timestamp]], 'tool_mobile', 'autologinmintimebetweenreq', '360', NULL),
(1795, 2, [[timestamp]], NULL, 'mobilecssurl', '', NULL),
(1796, 2, [[timestamp]], 'tool_mobile', 'enablesmartappbanners', '0', NULL),
(1797, 2, [[timestamp]], 'tool_mobile', 'iosappid', '633359593', NULL),
(1798, 2, [[timestamp]], 'tool_mobile', 'androidappid', 'com.moodle.moodlemobile', NULL),
(1799, 2, [[timestamp]], 'tool_mobile', 'setuplink', 'https://download.moodle.org/mobile', NULL),
(1800, 2, [[timestamp]], 'tool_mobile', 'forcelogout', '0', NULL),
(1801, 2, [[timestamp]], 'tool_mobile', 'disabledfeatures', '', NULL),
(1802, 2, [[timestamp]], 'tool_mobile', 'custommenuitems', '', NULL),
(1803, 2, [[timestamp]], 'tool_mobile', 'filetypeexclusionlist', '', NULL),
(1804, 2, [[timestamp]], 'tool_mobile', 'customlangstrings', '', NULL),
(1805, 2, [[timestamp]], NULL, 'enablemobilewebservice', '0', NULL),
(1806, 2, [[timestamp]], 'tool_moodlenet', 'defaultmoodlenetname', 'MoodleNet Central', NULL),
(1807, 2, [[timestamp]], 'tool_moodlenet', 'defaultmoodlenet', 'https://moodle.net', NULL),
(1808, 2, [[timestamp]], NULL, 'timezone', 'America/New_York', NULL),
(1809, 2, [[timestamp]], NULL, 'registerauth', '', NULL),
(1810, 2, [[timestamp]], NULL, 'supportemail', '[[support_email]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]config_plugins`
--

CREATE TABLE `[[dbprefix]]config_plugins` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `plugin` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT 'core',
  `name` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `value` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]confplug_plunam_uix` (`plugin`,`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Moodle modules and plugins configuration variables' AUTO_INCREMENT=2053 ;

--
-- Dumping data for table `[[dbprefix]]config_plugins`
--

INSERT INTO `[[dbprefix]]config_plugins` VALUES
(1, 'question', 'multichoice_sortorder', '1'),
(2, 'question', 'truefalse_sortorder', '2'),
(3, 'question', 'match_sortorder', '3'),
(4, 'question', 'shortanswer_sortorder', '4'),
(5, 'question', 'numerical_sortorder', '5'),
(6, 'question', 'essay_sortorder', '6'),
(7, 'core_competency', 'enabled', '1'),
(8, 'moodlecourse', 'visible', '1'),
(9, 'moodlecourse', 'downloadcontentsitedefault', '0'),
(10, 'moodlecourse', 'participantsperpage', '20'),
(11, 'moodlecourse', 'format', 'topics'),
(12, 'moodlecourse', 'maxsections', '52'),
(13, 'moodlecourse', 'numsections', '4'),
(14, 'moodlecourse', 'hiddensections', '1'),
(15, 'moodlecourse', 'coursedisplay', '0'),
(16, 'moodlecourse', 'courseenddateenabled', '1'),
(17, 'moodlecourse', 'courseduration', '31536000'),
(18, 'moodlecourse', 'lang', ''),
(19, 'moodlecourse', 'newsitems', '5'),
(20, 'moodlecourse', 'showgrades', '1'),
(21, 'moodlecourse', 'showreports', '0'),
(22, 'moodlecourse', 'showactivitydates', '1'),
(23, 'moodlecourse', 'maxbytes', '0'),
(24, 'moodlecourse', 'enablecompletion', '1'),
(25, 'moodlecourse', 'showcompletionconditions', '1'),
(26, 'moodlecourse', 'groupmode', '0'),
(27, 'moodlecourse', 'groupmodeforce', '0'),
(28, 'moodlecourse', 'coursecommunicationprovider', 'none'),
(29, 'backup', 'loglifetime', '30'),
(30, 'backup', 'backup_general_users', '1'),
(31, 'backup', 'backup_general_users_locked', ''),
(32, 'backup', 'backup_general_anonymize', '0'),
(33, 'backup', 'backup_general_anonymize_locked', ''),
(34, 'backup', 'backup_general_role_assignments', '1'),
(35, 'backup', 'backup_general_role_assignments_locked', ''),
(36, 'backup', 'backup_general_activities', '1'),
(37, 'backup', 'backup_general_activities_locked', ''),
(38, 'backup', 'backup_general_blocks', '1'),
(39, 'backup', 'backup_general_blocks_locked', ''),
(40, 'backup', 'backup_general_files', '1'),
(41, 'backup', 'backup_general_files_locked', ''),
(42, 'backup', 'backup_general_filters', '1'),
(43, 'backup', 'backup_general_filters_locked', ''),
(44, 'backup', 'backup_general_comments', '1'),
(45, 'backup', 'backup_general_comments_locked', ''),
(46, 'backup', 'backup_general_badges', '1'),
(47, 'backup', 'backup_general_badges_locked', ''),
(48, 'backup', 'backup_general_calendarevents', '1'),
(49, 'backup', 'backup_general_calendarevents_locked', ''),
(50, 'backup', 'backup_general_userscompletion', '1'),
(51, 'backup', 'backup_general_userscompletion_locked', ''),
(52, 'backup', 'backup_general_logs', '0'),
(53, 'backup', 'backup_general_logs_locked', ''),
(54, 'backup', 'backup_general_histories', '0'),
(55, 'backup', 'backup_general_histories_locked', ''),
(56, 'backup', 'backup_general_groups', '1'),
(57, 'backup', 'backup_general_groups_locked', ''),
(58, 'backup', 'backup_general_competencies', '1'),
(59, 'backup', 'backup_general_competencies_locked', ''),
(60, 'backup', 'backup_general_customfield', '1'),
(61, 'backup', 'backup_general_customfield_locked', ''),
(62, 'backup', 'backup_general_contentbankcontent', '1'),
(63, 'backup', 'backup_general_contentbankcontent_locked', ''),
(64, 'backup', 'backup_general_xapistate', '1'),
(65, 'backup', 'backup_general_xapistate_locked', ''),
(66, 'backup', 'backup_general_legacyfiles', '1'),
(67, 'backup', 'backup_general_legacyfiles_locked', ''),
(68, 'backup', 'import_general_maxresults', '10'),
(69, 'backup', 'import_general_duplicate_admin_allowed', '0'),
(70, 'backup', 'backup_import_permissions', '0'),
(71, 'backup', 'backup_import_permissions_locked', ''),
(72, 'backup', 'backup_import_activities', '1'),
(73, 'backup', 'backup_import_activities_locked', ''),
(74, 'backup', 'backup_import_blocks', '1'),
(75, 'backup', 'backup_import_blocks_locked', ''),
(76, 'backup', 'backup_import_filters', '1'),
(77, 'backup', 'backup_import_filters_locked', ''),
(78, 'backup', 'backup_import_badges', '0'),
(79, 'backup', 'backup_import_badges_locked', ''),
(80, 'backup', 'backup_import_calendarevents', '1'),
(81, 'backup', 'backup_import_calendarevents_locked', ''),
(82, 'backup', 'backup_import_groups', '1'),
(83, 'backup', 'backup_import_groups_locked', ''),
(84, 'backup', 'backup_import_competencies', '1'),
(85, 'backup', 'backup_import_competencies_locked', ''),
(86, 'backup', 'backup_import_customfield', '1'),
(87, 'backup', 'backup_import_customfield_locked', ''),
(88, 'backup', 'backup_import_contentbankcontent', '1'),
(89, 'backup', 'backup_import_contentbankcontent_locked', ''),
(90, 'backup', 'backup_import_legacyfiles', '1'),
(91, 'backup', 'backup_import_legacyfiles_locked', ''),
(92, 'backup', 'backup_auto_active', '0'),
(93, 'backup', 'backup_auto_weekdays', '0000000'),
(94, 'backup', 'backup_auto_hour', '0'),
(95, 'backup', 'backup_auto_minute', '0'),
(96, 'backup', 'backup_auto_storage', '0'),
(97, 'backup', 'backup_auto_destination', ''),
(98, 'backup', 'backup_auto_max_kept', '1'),
(99, 'backup', 'backup_auto_delete_days', '0'),
(100, 'backup', 'backup_auto_min_kept', '0'),
(101, 'backup', 'backup_shortname', '0'),
(102, 'backup', 'backup_auto_skip_hidden', '1'),
(103, 'backup', 'backup_auto_skip_modif_days', '30'),
(104, 'backup', 'backup_auto_skip_modif_prev', '0'),
(105, 'backup', 'backup_auto_users', '1'),
(106, 'backup', 'backup_auto_role_assignments', '1'),
(107, 'backup', 'backup_auto_activities', '1'),
(108, 'backup', 'backup_auto_blocks', '1'),
(109, 'backup', 'backup_auto_files', '1'),
(110, 'backup', 'backup_auto_filters', '1'),
(111, 'backup', 'backup_auto_comments', '1'),
(112, 'backup', 'backup_auto_badges', '1'),
(113, 'backup', 'backup_auto_calendarevents', '1'),
(114, 'backup', 'backup_auto_userscompletion', '1'),
(115, 'backup', 'backup_auto_logs', '0'),
(116, 'backup', 'backup_auto_histories', '0'),
(117, 'backup', 'backup_auto_groups', '1'),
(118, 'backup', 'backup_auto_competencies', '1'),
(119, 'backup', 'backup_auto_customfield', '1'),
(120, 'backup', 'backup_auto_contentbankcontent', '1'),
(121, 'backup', 'backup_auto_xapistate', '1'),
(122, 'backup', 'backup_auto_legacyfiles', '1'),
(123, 'restore', 'restore_general_users', '1'),
(124, 'restore', 'restore_general_users_locked', ''),
(125, 'restore', 'restore_general_enrolments', '1'),
(126, 'restore', 'restore_general_enrolments_locked', ''),
(127, 'restore', 'restore_general_role_assignments', '1'),
(128, 'restore', 'restore_general_role_assignments_locked', ''),
(129, 'restore', 'restore_general_permissions', '1'),
(130, 'restore', 'restore_general_permissions_locked', ''),
(131, 'restore', 'restore_general_activities', '1'),
(132, 'restore', 'restore_general_activities_locked', ''),
(133, 'restore', 'restore_general_blocks', '1'),
(134, 'restore', 'restore_general_blocks_locked', ''),
(135, 'restore', 'restore_general_filters', '1'),
(136, 'restore', 'restore_general_filters_locked', ''),
(137, 'restore', 'restore_general_comments', '1'),
(138, 'restore', 'restore_general_comments_locked', ''),
(139, 'restore', 'restore_general_badges', '1'),
(140, 'restore', 'restore_general_badges_locked', ''),
(141, 'restore', 'restore_general_calendarevents', '1'),
(142, 'restore', 'restore_general_calendarevents_locked', ''),
(143, 'restore', 'restore_general_userscompletion', '1'),
(144, 'restore', 'restore_general_userscompletion_locked', ''),
(145, 'restore', 'restore_general_logs', '1'),
(146, 'restore', 'restore_general_logs_locked', ''),
(147, 'restore', 'restore_general_histories', '1'),
(148, 'restore', 'restore_general_histories_locked', ''),
(149, 'restore', 'restore_general_groups', '1'),
(150, 'restore', 'restore_general_groups_locked', ''),
(151, 'restore', 'restore_general_competencies', '1'),
(152, 'restore', 'restore_general_competencies_locked', ''),
(153, 'restore', 'restore_general_customfield', '1'),
(154, 'restore', 'restore_general_customfield_locked', ''),
(155, 'restore', 'restore_general_contentbankcontent', '1'),
(156, 'restore', 'restore_general_contentbankcontent_locked', ''),
(157, 'restore', 'restore_general_xapistate', '1'),
(158, 'restore', 'restore_general_xapistate_locked', ''),
(159, 'restore', 'restore_general_legacyfiles', '1'),
(160, 'restore', 'restore_general_legacyfiles_locked', ''),
(161, 'restore', 'restore_merge_overwrite_conf', '0'),
(162, 'restore', 'restore_merge_overwrite_conf_locked', ''),
(163, 'restore', 'restore_merge_course_fullname', '1'),
(164, 'restore', 'restore_merge_course_fullname_locked', ''),
(165, 'restore', 'restore_merge_course_shortname', '1'),
(166, 'restore', 'restore_merge_course_shortname_locked', ''),
(167, 'restore', 'restore_merge_course_startdate', '1'),
(168, 'restore', 'restore_merge_course_startdate_locked', ''),
(169, 'restore', 'restore_replace_overwrite_conf', '0'),
(170, 'restore', 'restore_replace_overwrite_conf_locked', ''),
(171, 'restore', 'restore_replace_course_fullname', '1'),
(172, 'restore', 'restore_replace_course_fullname_locked', ''),
(173, 'restore', 'restore_replace_course_shortname', '1'),
(174, 'restore', 'restore_replace_course_shortname_locked', ''),
(175, 'restore', 'restore_replace_course_startdate', '1'),
(176, 'restore', 'restore_replace_course_startdate_locked', ''),
(177, 'restore', 'restore_replace_keep_roles_and_enrolments', '0'),
(178, 'restore', 'restore_replace_keep_roles_and_enrolments_locked', ''),
(179, 'restore', 'restore_replace_keep_groups_and_groupings', '0'),
(180, 'restore', 'restore_replace_keep_groups_and_groupings_locked', ''),
(181, 'backup', 'backup_async_message_users', '1'),
(182, 'backup', 'backup_async_message_subject', 'Moodle {operation} completed successfully'),
(183, 'backup', 'backup_async_message', 'Your {operation} (ID: {backupid}) has completed successfully. You can access it here: <a href="{link}">{link}</a>.'),
(184, 'analytics', 'modeinstruction', ''),
(185, 'analytics', 'percentonline', '0'),
(186, 'analytics', 'typeinstitution', ''),
(187, 'analytics', 'levelinstitution', ''),
(188, 'analytics', 'predictionsprocessor', '\\mlbackend_python\\processor'),
(189, 'analytics', 'defaulttimesplittingsevaluation', '\\core\\analytics\\time_splitting\\quarters_accum,\\core\\analytics\\time_splitting\\quarters,\\core\\analytics\\time_splitting\\single_range'),
(190, 'analytics', 'modeloutputdir', ''),
(191, 'analytics', 'onlycli', '1'),
(192, 'analytics', 'modeltimelimit', '1200'),
(193, 'analytics', 'calclifetime', '35'),
(194, 'core_h5p', 'h5pcustomcss', ''),
(195, 'antivirus', 'notifyemail', ''),
(196, 'antivirus', 'notifylevel', '2'),
(197, 'antivirus', 'threshold', '1200'),
(198, 'antivirus', 'enablequarantine', '0'),
(199, 'antivirus', 'quarantinetime', '2419200'),
(200, 'cachestore_apcu', 'testperformance', '0'),
(201, 'cachestore_redis', 'test_clustermode', '0'),
(202, 'cachestore_redis', 'test_server', ''),
(203, 'cachestore_redis', 'test_encryption', '0'),
(204, 'cachestore_redis', 'test_cafile', ''),
(205, 'cachestore_redis', 'test_password', ''),
(206, 'cachestore_redis', 'test_ttl', '0'),
(207, 'question_preview', 'behaviour', 'deferredfeedback'),
(208, 'question_preview', 'correctness', '1'),
(209, 'question_preview', 'marks', '2'),
(210, 'question_preview', 'markdp', '2'),
(211, 'question_preview', 'feedback', '1'),
(212, 'question_preview', 'generalfeedback', '1'),
(213, 'question_preview', 'rightanswer', '1'),
(214, 'question_preview', 'history', '0'),
(215, 'tool_task', 'enablerunnow', '1'),
(216, 'adminpresets', 'sensiblesettings', 'recaptchapublickey@@none, recaptchaprivatekey@@none, googlemapkey3@@none, secretphrase@@url, cronremotepassword@@none, smtpuser@@none, smtppass@@none, proxypassword@@none, quizpassword@@quiz, allowedip@@none, blockedip@@none, dbpass@@logstore_database, messageinbound_hostpass@@none, pass@@auth_db, bind_pw@@auth_ldap, dbpass@@enrol_database, bind_pw@@enrol_ldap, server_password@@search_solr, ssl_keypassword@@search_solr, alternateserver_password@@search_solr, alternatessl_keypassword@@search_solr, test_password@@cachestore_redis, password@@mlbackend_python, badges_badgesalt@@none, calendar_exportsalt@@none, bigbluebuttonbn_shared_secret@@none, apikey@@tiny_premium, matrixaccesstoken@@communication_matrix, api_secret@@factor_sms'),
(217, 'theme_boost', 'unaddableblocks', 'navigation,settings,course_list'),
(218, 'theme_boost', 'preset', 'default.scss'),
(219, 'theme_boost', 'presetfiles', ''),
(220, 'theme_boost', 'backgroundimage', ''),
(221, 'theme_boost', 'loginbackgroundimage', ''),
(222, 'theme_boost', 'brandcolor', ''),
(223, 'theme_boost', 'scsspre', ''),
(224, 'theme_boost', 'scss', ''),
(225, 'theme_classic', 'navbardark', '0'),
(226, 'theme_classic', 'unaddableblocks', ''),
(227, 'theme_classic', 'preset', 'default.scss'),
(228, 'theme_classic', 'presetfiles', ''),
(229, 'theme_classic', 'backgroundimage', ''),
(230, 'theme_classic', 'loginbackgroundimage', ''),
(231, 'theme_classic', 'brandcolor', ''),
(232, 'theme_classic', 'scsspre', ''),
(233, 'theme_classic', 'scss', ''),
(234, 'core_admin', 'logo', ''),
(235, 'core_admin', 'logocompact', ''),
(236, 'core_admin', 'favicon', ''),
(237, 'core_admin', 'coursecolor1', '#81ecec'),
(238, 'core_admin', 'coursecolor2', '#74b9ff'),
(239, 'core_admin', 'coursecolor3', '#a29bfe'),
(240, 'core_admin', 'coursecolor4', '#dfe6e9'),
(241, 'core_admin', 'coursecolor5', '#00b894'),
(242, 'core_admin', 'coursecolor6', '#0984e3'),
(243, 'core_admin', 'coursecolor7', '#b2bec3'),
(244, 'core_admin', 'coursecolor8', '#fdcb6e'),
(245, 'core_admin', 'coursecolor9', '#fd79a8'),
(246, 'core_admin', 'coursecolor10', '#6c5ce7'),
(247, 'core_competency', 'pushcourseratingstouserplans', '1'),
(248, 'aiplacement_courseassist', 'version', '2025100600'),
(249, 'aiplacement_editor', 'version', '2025100600'),
(250, 'aiprovider_azureai', 'version', '2025100600'),
(251, 'aiprovider_deepseek', 'version', '2025100600'),
(252, 'aiprovider_ollama', 'version', '2025100600'),
(253, 'aiprovider_openai', 'version', '2025100600'),
(254, 'antivirus_clamav', 'version', '2025100600'),
(255, 'availability_completion', 'version', '2025100600'),
(256, 'availability_date', 'version', '2025100600'),
(257, 'availability_grade', 'version', '2025100600'),
(258, 'availability_group', 'version', '2025100600'),
(259, 'availability_grouping', 'version', '2025100600'),
(260, 'availability_profile', 'version', '2025100600'),
(261, 'qtype_calculated', 'version', '2025100600'),
(262, 'qtype_calculatedmulti', 'version', '2025100600'),
(263, 'qtype_calculatedsimple', 'version', '2025100600'),
(264, 'qtype_ddimageortext', 'version', '2025100600'),
(265, 'qtype_ddmarker', 'version', '2025100600'),
(266, 'qtype_ddwtos', 'version', '2025100600'),
(267, 'qtype_description', 'version', '2025100600'),
(268, 'qtype_essay', 'version', '2025100600'),
(269, 'qtype_gapselect', 'version', '2025100600'),
(270, 'qtype_match', 'version', '2025100600'),
(271, 'qtype_missingtype', 'version', '2025100600'),
(272, 'qtype_multianswer', 'version', '2025100600'),
(273, 'qtype_multichoice', 'version', '2025100600'),
(274, 'qtype_numerical', 'version', '2025100600'),
(275, 'qtype_ordering', 'version', '2025100600'),
(276, 'qtype_random', 'version', '2025100600'),
(277, 'qtype_randomsamatch', 'version', '2025100600'),
(278, 'qtype_shortanswer', 'version', '2025100600'),
(279, 'qtype_truefalse', 'version', '2025100600'),
(280, 'mod_assign', 'version', '2025100600'),
(281, 'mod_bigbluebuttonbn', 'version', '2025100600'),
(283, 'mod_book', 'version', '2025100600'),
(284, 'mod_choice', 'version', '2025100600'),
(285, 'mod_data', 'version', '2025100600'),
(286, 'mod_feedback', 'version', '2025100600'),
(288, 'mod_folder', 'version', '2025100600'),
(290, 'mod_forum', 'version', '2025100600'),
(291, 'mod_glossary', 'version', '2025100600'),
(292, 'mod_h5pactivity', 'version', '2025100600'),
(293, 'mod_imscp', 'version', '2025100600'),
(295, 'mod_label', 'version', '2025100600'),
(296, 'mod_lesson', 'version', '2025100600'),
(297, 'mod_lti', 'version', '2025100600'),
(299, 'mod_lti', 'kid', '[[kid]]'),
(300, 'mod_lti', 'privatekey', '[[privatekey]]'),
(301, 'mod_page', 'version', '2025100600'),
(303, 'mod_qbank', 'version', '2025100600'),
(305, 'mod_quiz', 'version', '2025100600'),
(306, 'mod_resource', 'version', '2025100600'),
(307, 'mod_scorm', 'version', '2025100600'),
(308, 'mod_subsection', 'version', '2025100600'),
(309, 'mod_url', 'version', '2025100600'),
(311, 'mod_wiki', 'version', '2025100600'),
(313, 'mod_workshop', 'version', '2025100600'),
(314, 'auth_db', 'version', '2025100600'),
(316, 'auth_email', 'version', '2025100600'),
(317, 'auth_ldap', 'version', '2025100600'),
(319, 'auth_lti', 'version', '2025100600'),
(320, 'auth_manual', 'version', '2025100600'),
(321, 'auth_nologin', 'version', '2025100600'),
(322, 'auth_none', 'version', '2025100600'),
(323, 'auth_oauth2', 'version', '2025100600'),
(324, 'auth_shibboleth', 'version', '2025100600'),
(326, 'auth_webservice', 'version', '2025100600'),
(327, 'calendartype_gregorian', 'version', '2025100600'),
(328, 'communication_customlink', 'version', '2025100600'),
(329, 'communication_matrix', 'version', '2025100600'),
(330, 'customfield_checkbox', 'version', '2025100600'),
(331, 'customfield_date', 'version', '2025100600'),
(332, 'customfield_number', 'version', '2025100600'),
(333, 'customfield_select', 'version', '2025100600'),
(334, 'customfield_text', 'version', '2025100600'),
(335, 'customfield_textarea', 'version', '2025100600'),
(336, 'enrol_category', 'version', '2025100600'),
(338, 'enrol_cohort', 'version', '2025100600'),
(339, 'enrol_database', 'version', '2025100600'),
(341, 'enrol_fee', 'version', '2025100600'),
(342, 'enrol_flatfile', 'version', '2025100600'),
(344, 'enrol_flatfile', 'map_1', 'manager'),
(345, 'enrol_flatfile', 'map_2', 'coursecreator'),
(346, 'enrol_flatfile', 'map_3', 'editingteacher'),
(347, 'enrol_flatfile', 'map_4', 'teacher'),
(348, 'enrol_flatfile', 'map_5', 'student'),
(349, 'enrol_flatfile', 'map_6', 'guest'),
(350, 'enrol_flatfile', 'map_7', 'user'),
(351, 'enrol_flatfile', 'map_8', 'frontpage'),
(352, 'enrol_guest', 'version', '2025100600'),
(353, 'enrol_imsenterprise', 'version', '2025100600'),
(355, 'enrol_ldap', 'version', '2025100600'),
(357, 'enrol_lti', 'version', '2025100600'),
(359, 'enrol_lti', 'lti_13_kid', '[[enrol_lti_kid]]'),
(360, 'enrol_lti', 'lti_13_privatekey', '[[enrol_lti_privatekey]]'),
(361, 'enrol_manual', 'version', '2025100600'),
(363, 'enrol_meta', 'version', '2025100600'),
(365, 'enrol_paypal', 'version', '2025100600'),
(366, 'enrol_self', 'version', '2025100600'),
(368, 'message_airnotifier', 'version', '2025100600'),
(370, 'message', 'airnotifier_provider_enrol_flatfile_flatfile_enrolment_locked', '0'),
(371, 'message', 'airnotifier_provider_enrol_imsenterprise_imsenterprise_enrolment_locked', '0'),
(372, 'message', 'airnotifier_provider_enrol_manual_expiry_notification_locked', '0'),
(373, 'message', 'airnotifier_provider_enrol_paypal_paypal_enrolment_locked', '0'),
(374, 'message', 'airnotifier_provider_enrol_self_expiry_notification_locked', '0'),
(375, 'message', 'airnotifier_provider_mod_assign_assign_notification_locked', '0'),
(376, 'message', 'airnotifier_provider_mod_assign_assign_due_soon_locked', '0'),
(377, 'message', 'message_provider_mod_assign_assign_due_soon_enabled', 'popup,email,airnotifier'),
(378, 'message', 'airnotifier_provider_mod_assign_assign_overdue_locked', '0'),
(379, 'message', 'message_provider_mod_assign_assign_overdue_enabled', 'popup,email,airnotifier'),
(380, 'message', 'airnotifier_provider_mod_assign_assign_due_digest_locked', '0'),
(381, 'message', 'message_provider_mod_assign_assign_due_digest_enabled', 'popup,email,airnotifier'),
(382, 'message', 'airnotifier_provider_mod_bigbluebuttonbn_recording_ready_locked', '0'),
(383, 'message', 'airnotifier_provider_mod_bigbluebuttonbn_instance_updated_locked', '0'),
(384, 'message', 'airnotifier_provider_mod_feedback_submission_locked', '0'),
(385, 'message', 'airnotifier_provider_mod_feedback_message_locked', '0'),
(386, 'message', 'airnotifier_provider_mod_forum_posts_locked', '0'),
(387, 'message', 'message_provider_mod_forum_posts_enabled', 'popup,email,airnotifier'),
(388, 'message', 'airnotifier_provider_mod_forum_digests_locked', '0'),
(389, 'message', 'airnotifier_provider_mod_lesson_graded_essay_locked', '0'),
(390, 'message', 'message_provider_mod_lesson_graded_essay_enabled', 'popup,email,airnotifier'),
(391, 'message', 'airnotifier_provider_mod_quiz_submission_locked', '0'),
(392, 'message', 'airnotifier_provider_mod_quiz_confirmation_locked', '0'),
(393, 'message', 'message_provider_mod_quiz_confirmation_enabled', 'popup,email,airnotifier'),
(394, 'message', 'airnotifier_provider_mod_quiz_attempt_overdue_locked', '0'),
(395, 'message', 'message_provider_mod_quiz_attempt_overdue_enabled', 'popup,email,airnotifier'),
(396, 'message', 'airnotifier_provider_mod_quiz_attempt_grading_complete_locked', '0'),
(397, 'message', 'message_provider_mod_quiz_attempt_grading_complete_enabled', 'popup,email,airnotifier'),
(398, 'message', 'airnotifier_provider_mod_quiz_quiz_open_soon_locked', '0'),
(399, 'message', 'message_provider_mod_quiz_quiz_open_soon_enabled', 'popup,email,airnotifier'),
(400, 'message', 'airnotifier_provider_moodle_newlogin_locked', '0'),
(401, 'message', 'message_provider_moodle_newlogin_enabled', 'popup,email,airnotifier'),
(402, 'message', 'airnotifier_provider_moodle_notices_locked', '0'),
(403, 'message', 'airnotifier_provider_moodle_errors_locked', '0'),
(404, 'message', 'airnotifier_provider_moodle_availableupdate_locked', '0'),
(405, 'message', 'airnotifier_provider_moodle_instantmessage_locked', '0'),
(406, 'message', 'airnotifier_provider_moodle_backup_locked', '0'),
(407, 'message', 'airnotifier_provider_moodle_courserequested_locked', '0'),
(408, 'message', 'airnotifier_provider_moodle_courserequestapproved_locked', '0'),
(409, 'message', 'message_provider_moodle_courserequestapproved_enabled', 'popup,email,airnotifier'),
(410, 'message', 'airnotifier_provider_moodle_courserequestrejected_locked', '0'),
(411, 'message', 'message_provider_moodle_courserequestrejected_enabled', 'popup,email,airnotifier'),
(412, 'message', 'airnotifier_provider_moodle_coursecompleted_locked', '0'),
(413, 'message', 'message_provider_moodle_coursecompleted_enabled', 'popup,email,airnotifier'),
(414, 'message', 'airnotifier_provider_moodle_coursecontentupdated_locked', '0'),
(415, 'message', 'message_provider_moodle_coursecontentupdated_enabled', 'popup,email,airnotifier'),
(416, 'message', 'airnotifier_provider_moodle_badgerecipientnotice_locked', '0'),
(417, 'message', 'message_provider_moodle_badgerecipientnotice_enabled', 'popup,email,airnotifier'),
(418, 'message', 'airnotifier_provider_moodle_badgecreatornotice_locked', '0'),
(419, 'message', 'airnotifier_provider_moodle_competencyplancomment_locked', '0'),
(420, 'message', 'airnotifier_provider_moodle_competencyusercompcomment_locked', '0'),
(421, 'message', 'airnotifier_provider_moodle_insights_locked', '0'),
(422, 'message', 'message_provider_moodle_insights_enabled', 'popup,email,airnotifier'),
(423, 'message', 'airnotifier_provider_moodle_messagecontactrequests_locked', '0'),
(424, 'message', 'message_provider_moodle_messagecontactrequests_enabled', 'email,airnotifier'),
(425, 'message', 'airnotifier_provider_moodle_asyncbackupnotification_locked', '0'),
(426, 'message', 'airnotifier_provider_moodle_gradenotifications_locked', '0'),
(427, 'message', 'airnotifier_provider_moodle_infected_locked', '0'),
(428, 'message', 'airnotifier_provider_moodle_reportbuilderschedule_locked', '0'),
(429, 'message', 'airnotifier_provider_moodle_failedtaskmaxdelay_locked', '0'),
(430, 'message', 'airnotifier_provider_moodle_enrolcoursewelcomemessage_locked', '0'),
(431, 'message', 'message_provider_moodle_enrolcoursewelcomemessage_enabled', 'popup,email,airnotifier'),
(432, 'message_email', 'version', '2025100600'),
(434, 'message', 'email_provider_enrol_flatfile_flatfile_enrolment_locked', '0'),
(435, 'message', 'message_provider_enrol_flatfile_flatfile_enrolment_enabled', 'popup,email'),
(436, 'message', 'email_provider_enrol_imsenterprise_imsenterprise_enrolment_locked', '0'),
(437, 'message', 'message_provider_enrol_imsenterprise_imsenterprise_enrolment_enabled', 'popup,email'),
(438, 'message', 'email_provider_enrol_manual_expiry_notification_locked', '0'),
(439, 'message', 'message_provider_enrol_manual_expiry_notification_enabled', 'popup,email'),
(440, 'message', 'email_provider_enrol_paypal_paypal_enrolment_locked', '0'),
(441, 'message', 'message_provider_enrol_paypal_paypal_enrolment_enabled', 'popup,email'),
(442, 'message', 'email_provider_enrol_self_expiry_notification_locked', '0'),
(443, 'message', 'message_provider_enrol_self_expiry_notification_enabled', 'popup,email'),
(444, 'message', 'email_provider_mod_assign_assign_notification_locked', '0'),
(445, 'message', 'message_provider_mod_assign_assign_notification_enabled', 'popup,email'),
(446, 'message', 'email_provider_mod_assign_assign_due_soon_locked', '0'),
(447, 'message', 'email_provider_mod_assign_assign_overdue_locked', '0'),
(448, 'message', 'email_provider_mod_assign_assign_due_digest_locked', '0'),
(449, 'message', 'email_provider_mod_bigbluebuttonbn_recording_ready_locked', '0'),
(450, 'message', 'message_provider_mod_bigbluebuttonbn_recording_ready_enabled', 'popup,email'),
(451, 'message', 'email_provider_mod_bigbluebuttonbn_instance_updated_locked', '0'),
(452, 'message', 'message_provider_mod_bigbluebuttonbn_instance_updated_enabled', 'popup,email'),
(453, 'message', 'email_provider_mod_feedback_submission_locked', '0'),
(454, 'message', 'message_provider_mod_feedback_submission_enabled', 'popup,email'),
(455, 'message', 'email_provider_mod_feedback_message_locked', '0'),
(456, 'message', 'message_provider_mod_feedback_message_enabled', 'popup,email'),
(457, 'message', 'email_provider_mod_forum_posts_locked', '0'),
(458, 'message', 'email_provider_mod_forum_digests_locked', '0'),
(459, 'message', 'message_provider_mod_forum_digests_enabled', 'popup,email'),
(460, 'message', 'email_provider_mod_lesson_graded_essay_locked', '0'),
(461, 'message', 'email_provider_mod_quiz_submission_locked', '0'),
(462, 'message', 'message_provider_mod_quiz_submission_enabled', 'popup,email'),
(463, 'message', 'email_provider_mod_quiz_confirmation_locked', '0'),
(464, 'message', 'email_provider_mod_quiz_attempt_overdue_locked', '0'),
(465, 'message', 'email_provider_mod_quiz_attempt_grading_complete_locked', '0'),
(466, 'message', 'email_provider_mod_quiz_quiz_open_soon_locked', '0'),
(467, 'message', 'email_provider_moodle_newlogin_locked', '0'),
(468, 'message', 'email_provider_moodle_notices_locked', '0'),
(469, 'message', 'message_provider_moodle_notices_enabled', 'popup,email'),
(470, 'message', 'email_provider_moodle_errors_locked', '0'),
(471, 'message', 'message_provider_moodle_errors_enabled', 'popup,email'),
(472, 'message', 'email_provider_moodle_availableupdate_locked', '0'),
(473, 'message', 'message_provider_moodle_availableupdate_enabled', 'popup,email'),
(474, 'message', 'email_provider_moodle_instantmessage_locked', '0'),
(475, 'message', 'message_provider_moodle_instantmessage_enabled', 'popup,email'),
(476, 'message', 'email_provider_moodle_backup_locked', '0'),
(477, 'message', 'message_provider_moodle_backup_enabled', 'popup,email'),
(478, 'message', 'email_provider_moodle_courserequested_locked', '0'),
(479, 'message', 'message_provider_moodle_courserequested_enabled', 'popup,email'),
(480, 'message', 'email_provider_moodle_courserequestapproved_locked', '0'),
(481, 'message', 'email_provider_moodle_courserequestrejected_locked', '0'),
(482, 'message', 'email_provider_moodle_coursecompleted_locked', '0'),
(483, 'message', 'email_provider_moodle_coursecontentupdated_locked', '0'),
(484, 'message', 'email_provider_moodle_badgerecipientnotice_locked', '0'),
(485, 'message', 'email_provider_moodle_badgecreatornotice_locked', '0'),
(486, 'message', 'message_provider_moodle_badgecreatornotice_enabled', 'popup,email'),
(487, 'message', 'email_provider_moodle_competencyplancomment_locked', '0'),
(488, 'message', 'message_provider_moodle_competencyplancomment_enabled', 'popup,email'),
(489, 'message', 'email_provider_moodle_competencyusercompcomment_locked', '0'),
(490, 'message', 'message_provider_moodle_competencyusercompcomment_enabled', 'popup,email'),
(491, 'message', 'email_provider_moodle_insights_locked', '0'),
(492, 'message', 'email_provider_moodle_messagecontactrequests_locked', '0'),
(493, 'message', 'email_provider_moodle_asyncbackupnotification_locked', '0'),
(494, 'message', 'message_provider_moodle_asyncbackupnotification_enabled', 'popup,email'),
(495, 'message', 'email_provider_moodle_gradenotifications_locked', '0'),
(496, 'message', 'message_provider_moodle_gradenotifications_enabled', 'popup,email'),
(497, 'message', 'email_provider_moodle_infected_locked', '0'),
(498, 'message', 'message_provider_moodle_infected_enabled', 'popup,email'),
(499, 'message', 'email_provider_moodle_reportbuilderschedule_locked', '1'),
(500, 'message', 'message_provider_moodle_reportbuilderschedule_enabled', 'popup,email'),
(501, 'message', 'email_provider_moodle_failedtaskmaxdelay_locked', '0'),
(502, 'message', 'message_provider_moodle_failedtaskmaxdelay_enabled', 'popup,email'),
(503, 'message', 'email_provider_moodle_enrolcoursewelcomemessage_locked', '0'),
(504, 'message_popup', 'version', '2025100600'),
(506, 'message', 'popup_provider_enrol_flatfile_flatfile_enrolment_locked', '0'),
(507, 'message', 'popup_provider_enrol_imsenterprise_imsenterprise_enrolment_locked', '0'),
(508, 'message', 'popup_provider_enrol_manual_expiry_notification_locked', '0'),
(509, 'message', 'popup_provider_enrol_paypal_paypal_enrolment_locked', '0'),
(510, 'message', 'popup_provider_enrol_self_expiry_notification_locked', '0'),
(511, 'message', 'popup_provider_mod_assign_assign_notification_locked', '0'),
(512, 'message', 'popup_provider_mod_assign_assign_due_soon_locked', '0'),
(513, 'message', 'popup_provider_mod_assign_assign_overdue_locked', '0'),
(514, 'message', 'popup_provider_mod_assign_assign_due_digest_locked', '0'),
(515, 'message', 'popup_provider_mod_bigbluebuttonbn_recording_ready_locked', '0'),
(516, 'message', 'popup_provider_mod_bigbluebuttonbn_instance_updated_locked', '0'),
(517, 'message', 'popup_provider_mod_feedback_submission_locked', '0'),
(518, 'message', 'popup_provider_mod_feedback_message_locked', '0'),
(519, 'message', 'popup_provider_mod_forum_posts_locked', '0'),
(520, 'message', 'popup_provider_mod_forum_digests_locked', '0'),
(521, 'message', 'popup_provider_mod_lesson_graded_essay_locked', '0'),
(522, 'message', 'popup_provider_mod_quiz_submission_locked', '0'),
(523, 'message', 'popup_provider_mod_quiz_confirmation_locked', '0'),
(524, 'message', 'popup_provider_mod_quiz_attempt_overdue_locked', '0'),
(525, 'message', 'popup_provider_mod_quiz_attempt_grading_complete_locked', '0'),
(526, 'message', 'popup_provider_mod_quiz_quiz_open_soon_locked', '0'),
(527, 'message', 'popup_provider_moodle_newlogin_locked', '0'),
(528, 'message', 'popup_provider_moodle_notices_locked', '0'),
(529, 'message', 'popup_provider_moodle_errors_locked', '0'),
(530, 'message', 'popup_provider_moodle_availableupdate_locked', '0'),
(531, 'message', 'popup_provider_moodle_instantmessage_locked', '0'),
(532, 'message', 'popup_provider_moodle_backup_locked', '0'),
(533, 'message', 'popup_provider_moodle_courserequested_locked', '0'),
(534, 'message', 'popup_provider_moodle_courserequestapproved_locked', '0'),
(535, 'message', 'popup_provider_moodle_courserequestrejected_locked', '0'),
(536, 'message', 'popup_provider_moodle_coursecompleted_locked', '0'),
(537, 'message', 'popup_provider_moodle_coursecontentupdated_locked', '0'),
(538, 'message', 'popup_provider_moodle_badgerecipientnotice_locked', '0'),
(539, 'message', 'popup_provider_moodle_badgecreatornotice_locked', '0'),
(540, 'message', 'popup_provider_moodle_competencyplancomment_locked', '0'),
(541, 'message', 'popup_provider_moodle_competencyusercompcomment_locked', '0'),
(542, 'message', 'popup_provider_moodle_insights_locked', '0'),
(543, 'message', 'popup_provider_moodle_messagecontactrequests_locked', '0'),
(544, 'message', 'popup_provider_moodle_asyncbackupnotification_locked', '0'),
(545, 'message', 'popup_provider_moodle_gradenotifications_locked', '0'),
(546, 'message', 'popup_provider_moodle_infected_locked', '0'),
(547, 'message', 'popup_provider_moodle_reportbuilderschedule_locked', '0'),
(548, 'message', 'popup_provider_moodle_failedtaskmaxdelay_locked', '0'),
(549, 'message', 'popup_provider_moodle_enrolcoursewelcomemessage_locked', '0'),
(550, 'message_sms', 'version', '2025100600'),
(552, 'message', 'sms_provider_enrol_flatfile_flatfile_enrolment_locked', '1'),
(553, 'message', 'sms_provider_enrol_imsenterprise_imsenterprise_enrolment_locked', '1'),
(554, 'message', 'sms_provider_enrol_manual_expiry_notification_locked', '1'),
(555, 'message', 'sms_provider_enrol_paypal_paypal_enrolment_locked', '1'),
(556, 'message', 'sms_provider_enrol_self_expiry_notification_locked', '1'),
(557, 'message', 'sms_provider_mod_assign_assign_notification_locked', '1'),
(558, 'message', 'sms_provider_mod_assign_assign_due_soon_locked', '1'),
(559, 'message', 'sms_provider_mod_assign_assign_overdue_locked', '1'),
(560, 'message', 'sms_provider_mod_assign_assign_due_digest_locked', '1'),
(561, 'message', 'sms_provider_mod_bigbluebuttonbn_recording_ready_locked', '1'),
(562, 'message', 'sms_provider_mod_bigbluebuttonbn_instance_updated_locked', '1'),
(563, 'message', 'sms_provider_mod_feedback_submission_locked', '1'),
(564, 'message', 'sms_provider_mod_feedback_message_locked', '1'),
(565, 'message', 'sms_provider_mod_forum_posts_locked', '1'),
(566, 'message', 'sms_provider_mod_forum_digests_locked', '1'),
(567, 'message', 'sms_provider_mod_lesson_graded_essay_locked', '1'),
(568, 'message', 'sms_provider_mod_quiz_submission_locked', '1'),
(569, 'message', 'sms_provider_mod_quiz_confirmation_locked', '1'),
(570, 'message', 'sms_provider_mod_quiz_attempt_overdue_locked', '1'),
(571, 'message', 'sms_provider_mod_quiz_attempt_grading_complete_locked', '1'),
(572, 'message', 'sms_provider_mod_quiz_quiz_open_soon_locked', '1'),
(573, 'message', 'sms_provider_moodle_newlogin_locked', '1'),
(574, 'message', 'sms_provider_moodle_notices_locked', '1'),
(575, 'message', 'sms_provider_moodle_errors_locked', '1'),
(576, 'message', 'sms_provider_moodle_availableupdate_locked', '1'),
(577, 'message', 'sms_provider_moodle_instantmessage_locked', '1'),
(578, 'message', 'sms_provider_moodle_backup_locked', '1'),
(579, 'message', 'sms_provider_moodle_courserequested_locked', '1'),
(580, 'message', 'sms_provider_moodle_courserequestapproved_locked', '1'),
(581, 'message', 'sms_provider_moodle_courserequestrejected_locked', '1'),
(582, 'message', 'sms_provider_moodle_coursecompleted_locked', '1'),
(583, 'message', 'sms_provider_moodle_coursecontentupdated_locked', '1'),
(584, 'message', 'sms_provider_moodle_badgerecipientnotice_locked', '1'),
(585, 'message', 'sms_provider_moodle_badgecreatornotice_locked', '1'),
(586, 'message', 'sms_provider_moodle_competencyplancomment_locked', '1'),
(587, 'message', 'sms_provider_moodle_competencyusercompcomment_locked', '1'),
(588, 'message', 'sms_provider_moodle_insights_locked', '1'),
(589, 'message', 'sms_provider_moodle_messagecontactrequests_locked', '1'),
(590, 'message', 'sms_provider_moodle_asyncbackupnotification_locked', '1'),
(591, 'message', 'sms_provider_moodle_gradenotifications_locked', '1'),
(592, 'message', 'sms_provider_moodle_infected_locked', '1'),
(593, 'message', 'sms_provider_moodle_reportbuilderschedule_locked', '1'),
(594, 'message', 'sms_provider_moodle_failedtaskmaxdelay_locked', '1'),
(595, 'message', 'sms_provider_moodle_enrolcoursewelcomemessage_locked', '1'),
(596, 'block_accessreview', 'version', '2025100600'),
(597, 'block_activity_modules', 'version', '2025100600'),
(598, 'block_activity_results', 'version', '2025100600'),
(599, 'block_admin_bookmarks', 'version', '2025100600'),
(600, 'block_badges', 'version', '2025100600'),
(601, 'block_blog_menu', 'version', '2025100600'),
(602, 'block_blog_recent', 'version', '2025100600'),
(603, 'block_blog_tags', 'version', '2025100600'),
(604, 'block_calendar_month', 'version', '2025100600'),
(605, 'block_calendar_upcoming', 'version', '2025100600'),
(606, 'block_comments', 'version', '2025100600'),
(607, 'block_completionstatus', 'version', '2025100600'),
(608, 'block_course_list', 'version', '2025100600'),
(609, 'block_course_summary', 'version', '2025100600'),
(611, 'block_feedback', 'version', '2025100600'),
(613, 'block_globalsearch', 'version', '2025100600'),
(614, 'block_glossary_random', 'version', '2025100600'),
(615, 'block_html', 'version', '2025100600'),
(616, 'block_login', 'version', '2025100600'),
(617, 'block_lp', 'version', '2025100600'),
(618, 'block_mentees', 'version', '2025100600'),
(619, 'block_myoverview', 'version', '2025100600'),
(620, 'block_myprofile', 'version', '2025100600'),
(621, 'block_navigation', 'version', '2025100600'),
(622, 'block_news_items', 'version', '2025100600'),
(623, 'block_online_users', 'version', '2025100600'),
(624, 'block_private_files', 'version', '2025100600'),
(625, 'block_recent_activity', 'version', '2025100600'),
(626, 'block_recentlyaccessedcourses', 'version', '2025100600'),
(628, 'block_recentlyaccesseditems', 'version', '2025100600'),
(629, 'block_rss_client', 'version', '2025100600'),
(631, 'block_search_forums', 'version', '2025100600'),
(632, 'block_selfcompletion', 'version', '2025100600'),
(634, 'block_settings', 'version', '2025100600'),
(635, 'block_site_main_menu', 'version', '2025100600'),
(636, 'block_social_activities', 'version', '2025100600'),
(637, 'block_starredcourses', 'version', '2025100600'),
(638, 'block_tag_flickr', 'version', '2025100600'),
(639, 'block_tag_youtube', 'version', '2025100600'),
(641, 'block_tags', 'version', '2025100600'),
(642, 'block_timeline', 'version', '2025100600'),
(644, 'media_html5audio', 'version', '2025100600'),
(645, 'media_html5video', 'version', '2025100600'),
(646, 'media_videojs', 'version', '2025100600'),
(647, 'media_vimeo', 'version', '2025100600'),
(648, 'media_youtube', 'version', '2025100600'),
(649, 'filter_activitynames', 'version', '2025100600'),
(651, 'filter_algebra', 'version', '2025100600'),
(652, 'filter_codehighlighter', 'version', '2025100600'),
(653, 'filter_data', 'version', '2025100600'),
(655, 'filter_displayh5p', 'version', '2025100600'),
(657, 'filter_emailprotect', 'version', '2025100600'),
(658, 'filter_emoticon', 'version', '2025100600'),
(660, 'filter_glossary', 'version', '2025100600'),
(662, 'filter_mathjaxloader', 'version', '2025100600'),
(664, 'filter_mediaplugin', 'version', '2025100600'),
(666, 'filter_multilang', 'version', '2025100600'),
(667, 'filter_tex', 'version', '2025100600'),
(669, 'filter_urltolink', 'version', '2025100600'),
(671, 'editor_textarea', 'version', '2025100600'),
(672, 'editor_tiny', 'version', '2025100600'),
(674, 'format_singleactivity', 'version', '2025100600'),
(675, 'format_social', 'version', '2025100600'),
(677, 'format_social', 'disabled', '1'),
(678, 'format_topics', 'version', '2025100600'),
(679, 'format_weeks', 'version', '2025100600'),
(680, 'dataformat_csv', 'version', '2025100600'),
(681, 'dataformat_excel', 'version', '2025100600'),
(682, 'dataformat_html', 'version', '2025100600'),
(683, 'dataformat_json', 'version', '2025100600'),
(684, 'dataformat_ods', 'version', '2025100600'),
(685, 'dataformat_pdf', 'version', '2025100600'),
(686, 'profilefield_checkbox', 'version', '2025100600'),
(687, 'profilefield_datetime', 'version', '2025100600'),
(688, 'profilefield_menu', 'version', '2025100600'),
(689, 'profilefield_social', 'version', '2025100600'),
(690, 'profilefield_text', 'version', '2025100600'),
(691, 'profilefield_textarea', 'version', '2025100600'),
(692, 'report_backups', 'version', '2025100600'),
(693, 'report_competency', 'version', '2025100600'),
(694, 'report_completion', 'version', '2025100600'),
(696, 'report_configlog', 'version', '2025100600'),
(697, 'report_courseoverview', 'version', '2025100600'),
(698, 'report_eventlist', 'version', '2025100600'),
(699, 'report_infectedfiles', 'version', '2025100600'),
(700, 'report_insights', 'version', '2025100600'),
(701, 'report_log', 'version', '2025100600'),
(703, 'report_loglive', 'version', '2025100600'),
(704, 'report_outline', 'version', '2025100600'),
(706, 'report_participation', 'version', '2025100600'),
(708, 'report_performance', 'version', '2025100600'),
(709, 'report_progress', 'version', '2025100600'),
(711, 'report_questioninstances', 'version', '2025100600'),
(712, 'report_security', 'version', '2025100600'),
(713, 'report_stats', 'version', '2025100600'),
(715, 'report_status', 'version', '2025100600'),
(716, 'report_themeusage', 'version', '2025100600'),
(717, 'report_usersessions', 'version', '2025100600'),
(718, 'gradeexport_ods', 'version', '2025100600'),
(719, 'gradeexport_txt', 'version', '2025100600'),
(720, 'gradeexport_xls', 'version', '2025100600'),
(721, 'gradeexport_xml', 'version', '2025100600'),
(722, 'gradeimport_csv', 'version', '2025100600'),
(723, 'gradeimport_direct', 'version', '2025100600'),
(724, 'gradeimport_xml', 'version', '2025100600'),
(725, 'gradepenalty_duedate', 'version', '2025100600'),
(727, 'gradereport_grader', 'version', '2025100600'),
(728, 'gradereport_history', 'version', '2025100600'),
(729, 'gradereport_outcomes', 'version', '2025100600'),
(730, 'gradereport_overview', 'version', '2025100600'),
(731, 'gradereport_singleview', 'version', '2025100600'),
(732, 'gradereport_summary', 'version', '2025100600'),
(733, 'gradereport_user', 'version', '2025100600'),
(734, 'gradingform_guide', 'version', '2025100600'),
(735, 'gradingform_rubric', 'version', '2025100600'),
(736, 'mlbackend_python', 'version', '2025100600'),
(737, 'webservice_rest', 'version', '2025100600'),
(738, 'webservice_soap', 'version', '2025100600'),
(739, 'repository_areafiles', 'version', '2025100600'),
(741, 'areafiles', 'enablecourseinstances', '0'),
(742, 'areafiles', 'enableuserinstances', '0'),
(743, 'repository_contentbank', 'version', '2025100600'),
(745, 'contentbank', 'enablecourseinstances', '0'),
(746, 'contentbank', 'enableuserinstances', '0'),
(747, 'repository_coursefiles', 'version', '2025100600'),
(748, 'repository_dropbox', 'version', '2025100600'),
(749, 'repository_equella', 'version', '2025100600'),
(750, 'repository_filesystem', 'version', '2025100600'),
(751, 'repository_flickr', 'version', '2025100600'),
(752, 'repository_flickr_public', 'version', '2025100600'),
(753, 'repository_googledocs', 'version', '2025100600'),
(754, 'repository_local', 'version', '2025100600'),
(756, 'local', 'enablecourseinstances', '0'),
(757, 'local', 'enableuserinstances', '0'),
(758, 'repository_merlot', 'version', '2025100600'),
(759, 'repository_nextcloud', 'version', '2025100600'),
(760, 'repository_onedrive', 'version', '2025100600'),
(761, 'repository_recent', 'version', '2025100600'),
(763, 'recent', 'enablecourseinstances', '0'),
(764, 'recent', 'enableuserinstances', '0'),
(765, 'repository_s3', 'version', '2025100600'),
(766, 'repository_upload', 'version', '2025100600'),
(768, 'upload', 'enablecourseinstances', '0'),
(769, 'upload', 'enableuserinstances', '0'),
(770, 'repository_url', 'version', '2025100600'),
(772, 'url', 'enablecourseinstances', '0'),
(773, 'url', 'enableuserinstances', '0'),
(774, 'repository_user', 'version', '2025100600'),
(776, 'user', 'enablecourseinstances', '0'),
(777, 'user', 'enableuserinstances', '0'),
(778, 'repository_webdav', 'version', '2025100600'),
(779, 'repository_wikimedia', 'version', '2025100600'),
(781, 'wikimedia', 'enablecourseinstances', '0'),
(782, 'wikimedia', 'enableuserinstances', '0'),
(783, 'repository_youtube', 'version', '2025100600'),
(785, 'portfolio_download', 'version', '2025100600'),
(786, 'portfolio_flickr', 'version', '2025100600'),
(787, 'portfolio_googledocs', 'version', '2025100600'),
(788, 'search_simpledb', 'version', '2025100600'),
(790, 'search_solr', 'version', '2025100600'),
(791, 'qbank_bulkmove', 'version', '2025100600'),
(792, 'qbank_columnsortorder', 'version', '2025100600'),
(793, 'qbank_comment', 'version', '2025100600'),
(794, 'qbank_customfields', 'version', '2025100600'),
(795, 'qbank_deletequestion', 'version', '2025100600'),
(796, 'qbank_editquestion', 'version', '2025100600'),
(797, 'qbank_exportquestions', 'version', '2025100600'),
(798, 'qbank_exporttoxml', 'version', '2025100600'),
(799, 'qbank_history', 'version', '2025100600'),
(800, 'qbank_importquestions', 'version', '2025100600'),
(801, 'qbank_managecategories', 'version', '2025100600'),
(802, 'qbank_previewquestion', 'version', '2025100600'),
(803, 'qbank_statistics', 'version', '2025100600'),
(804, 'qbank_tagquestion', 'version', '2025100600'),
(805, 'qbank_usage', 'version', '2025100600'),
(806, 'qbank_viewcreator', 'version', '2025100600'),
(807, 'qbank_viewquestionname', 'version', '2025100600'),
(808, 'qbank_viewquestiontext', 'version', '2025100600'),
(809, 'qbank_viewquestiontype', 'version', '2025100600'),
(810, 'qbehaviour_adaptive', 'version', '2025100600'),
(811, 'qbehaviour_adaptivenopenalty', 'version', '2025100600'),
(812, 'qbehaviour_deferredcbm', 'version', '2025100600'),
(813, 'qbehaviour_deferredfeedback', 'version', '2025100600'),
(814, 'qbehaviour_immediatecbm', 'version', '2025100600'),
(815, 'qbehaviour_immediatefeedback', 'version', '2025100600'),
(816, 'qbehaviour_informationitem', 'version', '2025100600'),
(817, 'qbehaviour_interactive', 'version', '2025100600'),
(818, 'qbehaviour_interactivecountback', 'version', '2025100600'),
(819, 'qbehaviour_manualgraded', 'version', '2025100600'),
(821, 'question', 'disabledbehaviours', 'manualgraded'),
(822, 'qbehaviour_missing', 'version', '2025100600'),
(823, 'qformat_aiken', 'version', '2025100600'),
(824, 'qformat_blackboard_six', 'version', '2025100600'),
(825, 'qformat_gift', 'version', '2025100600'),
(826, 'qformat_missingword', 'version', '2025100600'),
(827, 'qformat_multianswer', 'version', '2025100600'),
(828, 'qformat_xhtml', 'version', '2025100600'),
(829, 'qformat_xml', 'version', '2025100600'),
(830, 'tool_admin_presets', 'version', '2025100600'),
(831, 'tool_analytics', 'version', '2025100600'),
(832, 'tool_availabilityconditions', 'version', '2025100600'),
(833, 'tool_behat', 'version', '2025100600'),
(834, 'tool_brickfield', 'version', '2025100600'),
(836, 'tool_capability', 'version', '2025100600'),
(837, 'tool_cohortroles', 'version', '2025100600'),
(838, 'tool_componentlibrary', 'version', '2025100600'),
(839, 'tool_customlang', 'version', '2025100600'),
(841, 'tool_dataprivacy', 'version', '2025100600'),
(842, 'message', 'airnotifier_provider_tool_dataprivacy_contactdataprotectionofficer_locked', '0'),
(843, 'message', 'email_provider_tool_dataprivacy_contactdataprotectionofficer_locked', '0'),
(844, 'message', 'popup_provider_tool_dataprivacy_contactdataprotectionofficer_locked', '0'),
(845, 'message', 'sms_provider_tool_dataprivacy_contactdataprotectionofficer_locked', '1'),
(846, 'message', 'message_provider_tool_dataprivacy_contactdataprotectionofficer_enabled', 'email,popup'),
(847, 'message', 'airnotifier_provider_tool_dataprivacy_datarequestprocessingresults_locked', '0'),
(848, 'message', 'email_provider_tool_dataprivacy_datarequestprocessingresults_locked', '0'),
(849, 'message', 'popup_provider_tool_dataprivacy_datarequestprocessingresults_locked', '0'),
(850, 'message', 'sms_provider_tool_dataprivacy_datarequestprocessingresults_locked', '1'),
(851, 'message', 'message_provider_tool_dataprivacy_datarequestprocessingresults_enabled', 'email,popup'),
(852, 'message', 'airnotifier_provider_tool_dataprivacy_notifyexceptions_locked', '0'),
(853, 'message', 'email_provider_tool_dataprivacy_notifyexceptions_locked', '0');
INSERT INTO `[[dbprefix]]config_plugins` VALUES
(854, 'message', 'popup_provider_tool_dataprivacy_notifyexceptions_locked', '0'),
(855, 'message', 'sms_provider_tool_dataprivacy_notifyexceptions_locked', '1'),
(856, 'message', 'message_provider_tool_dataprivacy_notifyexceptions_enabled', 'email,popup'),
(857, 'tool_dbtransfer', 'version', '2025100600'),
(858, 'tool_filetypes', 'version', '2025100600'),
(859, 'tool_generator', 'version', '2025100600'),
(860, 'tool_httpsreplace', 'version', '2025100600'),
(861, 'tool_installaddon', 'version', '2025100600'),
(862, 'tool_langimport', 'version', '2025100600'),
(863, 'tool_licensemanager', 'version', '2025100600'),
(864, 'tool_log', 'version', '2025100600'),
(866, 'tool_log', 'enabled_stores', 'logstore_standard'),
(867, 'tool_lp', 'version', '2025100600'),
(868, 'tool_lpimportcsv', 'version', '2025100600'),
(869, 'tool_lpmigrate', 'version', '2025100600'),
(870, 'tool_messageinbound', 'version', '2025100600'),
(871, 'message', 'airnotifier_provider_tool_messageinbound_invalidrecipienthandler_locked', '0'),
(872, 'message', 'email_provider_tool_messageinbound_invalidrecipienthandler_locked', '0'),
(873, 'message', 'popup_provider_tool_messageinbound_invalidrecipienthandler_locked', '0'),
(874, 'message', 'sms_provider_tool_messageinbound_invalidrecipienthandler_locked', '1'),
(875, 'message', 'message_provider_tool_messageinbound_invalidrecipienthandler_enabled', 'email,popup'),
(876, 'message', 'airnotifier_provider_tool_messageinbound_messageprocessingerror_locked', '0'),
(877, 'message', 'email_provider_tool_messageinbound_messageprocessingerror_locked', '0'),
(878, 'message', 'popup_provider_tool_messageinbound_messageprocessingerror_locked', '0'),
(879, 'message', 'sms_provider_tool_messageinbound_messageprocessingerror_locked', '1'),
(880, 'message', 'message_provider_tool_messageinbound_messageprocessingerror_enabled', 'email,popup'),
(881, 'message', 'airnotifier_provider_tool_messageinbound_messageprocessingsuccess_locked', '0'),
(882, 'message', 'email_provider_tool_messageinbound_messageprocessingsuccess_locked', '0'),
(883, 'message', 'popup_provider_tool_messageinbound_messageprocessingsuccess_locked', '0'),
(884, 'message', 'sms_provider_tool_messageinbound_messageprocessingsuccess_locked', '1'),
(885, 'message', 'message_provider_tool_messageinbound_messageprocessingsuccess_enabled', 'email,popup'),
(886, 'tool_mfa', 'version', '2025100600'),
(887, 'tool_mobile', 'version', '2025100600'),
(888, 'tool_monitor', 'version', '2025100600'),
(889, 'message', 'airnotifier_provider_tool_monitor_notification_locked', '0'),
(890, 'message', 'email_provider_tool_monitor_notification_locked', '0'),
(891, 'message', 'popup_provider_tool_monitor_notification_locked', '0'),
(892, 'message', 'sms_provider_tool_monitor_notification_locked', '1'),
(893, 'message', 'message_provider_tool_monitor_notification_enabled', 'email,popup'),
(894, 'tool_moodlenet', 'version', '2025100600'),
(896, 'tool_multilangupgrade', 'version', '2025100600'),
(897, 'tool_oauth2', 'version', '2025100600'),
(898, 'tool_phpunit', 'version', '2025100600'),
(899, 'tool_policy', 'version', '2025100600'),
(900, 'tool_profiling', 'version', '2025100600'),
(901, 'tool_recyclebin', 'version', '2025100600'),
(902, 'tool_replace', 'version', '2025100600'),
(903, 'tool_spamcleaner', 'version', '2025100600'),
(904, 'tool_task', 'version', '2025100600'),
(905, 'tool_templatelibrary', 'version', '2025100600'),
(906, 'tool_unsuproles', 'version', '2025100600'),
(908, 'tool_uploadcourse', 'version', '2025100600'),
(909, 'tool_uploaduser', 'version', '2025100600'),
(910, 'tool_usertours', 'version', '2025100600'),
(912, 'tool_xmldb', 'version', '2025100600'),
(913, 'cachestore_apcu', 'version', '2025100600'),
(914, 'cachestore_file', 'version', '2025100600'),
(915, 'cachestore_redis', 'version', '2025100600'),
(916, 'cachestore_session', 'version', '2025100600'),
(917, 'cachestore_static', 'version', '2025100600'),
(918, 'cachelock_file', 'version', '2025100600'),
(919, 'fileconverter_googledrive', 'version', '2025100600'),
(920, 'fileconverter_unoconv', 'version', '2025100600'),
(922, 'contenttype_h5p', 'version', '2025100600'),
(923, 'theme_boost', 'version', '2025100600'),
(924, 'theme_classic', 'version', '2025100600'),
(925, 'h5plib_v127', 'version', '2025100600'),
(926, 'paygw_paypal', 'version', '2025100600'),
(928, 'smsgateway_aws', 'version', '2025100600'),
(929, 'smsgateway_modica', 'version', '2025100600'),
(930, 'assignsubmission_comments', 'version', '2025100600'),
(932, 'assignsubmission_file', 'sortorder', '1'),
(933, 'assignsubmission_comments', 'sortorder', '2'),
(934, 'assignsubmission_onlinetext', 'sortorder', '0'),
(935, 'assignsubmission_file', 'version', '2025100600'),
(936, 'assignsubmission_onlinetext', 'version', '2025100600'),
(938, 'assignfeedback_comments', 'version', '2025100600'),
(940, 'assignfeedback_comments', 'sortorder', '0'),
(941, 'assignfeedback_editpdf', 'sortorder', '1'),
(942, 'assignfeedback_file', 'sortorder', '3'),
(943, 'assignfeedback_offline', 'sortorder', '2'),
(944, 'assignfeedback_editpdf', 'version', '2025100600'),
(946, 'assignfeedback_file', 'version', '2025100600'),
(948, 'assignfeedback_offline', 'version', '2025100600'),
(949, 'booktool_exportimscp', 'version', '2025100600'),
(950, 'booktool_importhtml', 'version', '2025100600'),
(951, 'booktool_print', 'version', '2025100600'),
(952, 'datafield_checkbox', 'version', '2025100600'),
(953, 'datafield_date', 'version', '2025100600'),
(954, 'datafield_file', 'version', '2025100600'),
(955, 'datafield_latlong', 'version', '2025100600'),
(956, 'datafield_menu', 'version', '2025100600'),
(957, 'datafield_multimenu', 'version', '2025100600'),
(958, 'datafield_number', 'version', '2025100600'),
(959, 'datafield_picture', 'version', '2025100600'),
(960, 'datafield_radiobutton', 'version', '2025100600'),
(961, 'datafield_text', 'version', '2025100600'),
(962, 'datafield_textarea', 'version', '2025100600'),
(963, 'datafield_url', 'version', '2025100600'),
(964, 'datapreset_imagegallery', 'version', '2025100600'),
(965, 'datapreset_journal', 'version', '2025100600'),
(966, 'datapreset_proposals', 'version', '2025100600'),
(967, 'datapreset_resources', 'version', '2025100600'),
(968, 'forumreport_summary', 'version', '2025100600'),
(969, 'ltiservice_basicoutcomes', 'version', '2025100600'),
(970, 'ltiservice_gradebookservices', 'version', '2025100600'),
(971, 'ltiservice_memberships', 'version', '2025100600'),
(972, 'ltiservice_profile', 'version', '2025100600'),
(973, 'ltiservice_toolproxy', 'version', '2025100600'),
(974, 'ltiservice_toolsettings', 'version', '2025100600'),
(975, 'quiz_grading', 'version', '2025100600'),
(977, 'quiz_overview', 'version', '2025100600'),
(979, 'quiz_responses', 'version', '2025100600'),
(981, 'quiz_statistics', 'version', '2025100601'),
(983, 'quizaccess_delaybetweenattempts', 'version', '2025100600'),
(984, 'quizaccess_ipaddress', 'version', '2025100600'),
(985, 'quizaccess_numattempts', 'version', '2025100600'),
(986, 'quizaccess_offlineattempts', 'version', '2025100600'),
(987, 'quizaccess_openclosedate', 'version', '2025100600'),
(988, 'quizaccess_password', 'version', '2025100600'),
(989, 'quizaccess_seb', 'version', '2025100600'),
(991, 'quizaccess_securewindow', 'version', '2025100600'),
(992, 'quizaccess_timelimit', 'version', '2025100600'),
(993, 'scormreport_basic', 'version', '2025100600'),
(994, 'scormreport_graphs', 'version', '2025100600'),
(995, 'scormreport_interactions', 'version', '2025100600'),
(996, 'scormreport_objectives', 'version', '2025100600'),
(997, 'workshopform_accumulative', 'version', '2025100600'),
(999, 'workshopform_comments', 'version', '2025100600'),
(1001, 'workshopform_numerrors', 'version', '2025100600'),
(1003, 'workshopform_rubric', 'version', '2025100600'),
(1005, 'workshopallocation_manual', 'version', '2025100600'),
(1006, 'workshopallocation_random', 'version', '2025100600'),
(1007, 'workshopallocation_scheduled', 'version', '2025100600'),
(1008, 'workshopeval_best', 'version', '2025100600'),
(1009, 'tiny_accessibilitychecker', 'version', '2025100600'),
(1010, 'tiny_aiplacement', 'version', '2025100600'),
(1011, 'tiny_autosave', 'version', '2025100600'),
(1012, 'tiny_equation', 'version', '2025100600'),
(1013, 'tiny_h5p', 'version', '2025100600'),
(1014, 'tiny_html', 'version', '2025100600'),
(1015, 'tiny_link', 'version', '2025100600'),
(1016, 'tiny_media', 'version', '2025100600'),
(1017, 'tiny_noautolink', 'version', '2025100600'),
(1019, 'tiny_noautolink', 'disabled', '1'),
(1020, 'tiny_premium', 'version', '2025100600'),
(1021, 'tiny_recordrtc', 'version', '2025100600'),
(1022, 'logstore_database', 'version', '2025100600'),
(1023, 'logstore_standard', 'version', '2025100600'),
(1024, 'factor_admin', 'version', '2025100600'),
(1025, 'factor_auth', 'version', '2025100600'),
(1026, 'factor_capability', 'version', '2025100600'),
(1027, 'factor_cohort', 'version', '2025100600'),
(1028, 'factor_email', 'version', '2025100600'),
(1030, 'tool_mfa', 'factor_order', 'email'),
(1031, 'factor_grace', 'version', '2025100600'),
(1032, 'factor_iprange', 'version', '2025100600'),
(1033, 'factor_nosetup', 'version', '2025100600'),
(1034, 'factor_role', 'version', '2025100600'),
(1035, 'factor_sms', 'version', '2025100600'),
(1036, 'factor_token', 'version', '2025100600'),
(1037, 'factor_totp', 'version', '2025100600'),
(1038, 'factor_webauthn', 'version', '2025100600'),
(1039, 'tool_task', 'lastcronstart', '[[timestamp]]'),
(1040, 'tool_task', 'lastcroninterval', '61'),
(1041, 'tool_moodlenet', 'enablemoodlenet', '1'),
(1042, 'tool_dataprivacy', 'contactdataprotectionofficer', '0'),
(1043, 'tool_dataprivacy', 'automaticdataexportapproval', '0'),
(1044, 'tool_dataprivacy', 'automaticdatadeletionapproval', '0'),
(1045, 'tool_dataprivacy', 'automaticdeletionrequests', '1'),
(1046, 'tool_dataprivacy', 'privacyrequestexpiry', '604800'),
(1047, 'tool_dataprivacy', 'requireallenddatesforuserdeletion', '1'),
(1048, 'tool_dataprivacy', 'showdataretentionsummary', '1'),
(1049, 'tool_dataprivacy', 'allowfiltering', '0'),
(1050, 'tool_log', 'exportlog', '1'),
(1051, 'message_airnotifier', 'encryptnotifications', '0'),
(1052, 'message_airnotifier', 'encryptprocessing', '0'),
(1053, 'assign', 'feedback_plugin_for_gradebook', 'assignfeedback_comments'),
(1054, 'assign', 'showrecentsubmissions', '0'),
(1055, 'assign', 'submissionreceipts', '1'),
(1056, 'assign', 'submissionstatement', 'This submission is my own work, except where I have acknowledged the use of the works of other people.'),
(1057, 'assign', 'submissionstatementteamsubmission', 'This submission is the work of my group, except where we have acknowledged the use of the works of other people.'),
(1058, 'assign', 'submissionstatementteamsubmissionallsubmit', 'This submission is my own work as a group member, except where I have acknowledged the use of the works of other people.'),
(1059, 'assign', 'maxperpage', '-1'),
(1060, 'assign', 'alwaysshowdescription', '1'),
(1061, 'assign', 'alwaysshowdescription_adv', ''),
(1062, 'assign', 'alwaysshowdescription_locked', ''),
(1063, 'assign', 'allowsubmissionsfromdate', '0'),
(1064, 'assign', 'allowsubmissionsfromdate_enabled', '1'),
(1065, 'assign', 'allowsubmissionsfromdate_adv', ''),
(1066, 'assign', 'duedate', '604800'),
(1067, 'assign', 'duedate_enabled', '1'),
(1068, 'assign', 'duedate_adv', ''),
(1069, 'assign', 'cutoffdate', '1209600'),
(1070, 'assign', 'cutoffdate_enabled', ''),
(1071, 'assign', 'cutoffdate_adv', ''),
(1072, 'assign', 'enabletimelimit', '0'),
(1073, 'mod_assign', 'defaultgradetype', '1'),
(1074, 'mod_assign', 'defaultgradescale', ''),
(1075, 'assign', 'gradingduedate', '1209600'),
(1076, 'assign', 'gradingduedate_enabled', '1'),
(1077, 'assign', 'gradingduedate_adv', ''),
(1078, 'assign', 'submissiondrafts', '0'),
(1079, 'assign', 'submissiondrafts_adv', ''),
(1080, 'assign', 'submissiondrafts_locked', ''),
(1081, 'assign', 'requiresubmissionstatement', '0'),
(1082, 'assign', 'requiresubmissionstatement_adv', ''),
(1083, 'assign', 'requiresubmissionstatement_locked', ''),
(1084, 'assign', 'maxattempts', '1'),
(1085, 'assign', 'maxattempts_adv', ''),
(1086, 'assign', 'maxattempts_locked', ''),
(1087, 'assign', 'attemptreopenmethod', 'untilpass'),
(1088, 'assign', 'attemptreopenmethod_adv', ''),
(1089, 'assign', 'attemptreopenmethod_locked', ''),
(1090, 'assign', 'teamsubmission', '0'),
(1091, 'assign', 'teamsubmission_adv', ''),
(1092, 'assign', 'teamsubmission_locked', ''),
(1093, 'assign', 'preventsubmissionnotingroup', '0'),
(1094, 'assign', 'preventsubmissionnotingroup_adv', ''),
(1095, 'assign', 'preventsubmissionnotingroup_locked', ''),
(1096, 'assign', 'requireallteammemberssubmit', '0'),
(1097, 'assign', 'requireallteammemberssubmit_adv', ''),
(1098, 'assign', 'requireallteammemberssubmit_locked', ''),
(1099, 'assign', 'teamsubmissiongroupingid', ''),
(1100, 'assign', 'teamsubmissiongroupingid_adv', ''),
(1101, 'assign', 'sendnotifications', '0'),
(1102, 'assign', 'sendnotifications_adv', ''),
(1103, 'assign', 'sendnotifications_locked', ''),
(1104, 'assign', 'sendlatenotifications', '0'),
(1105, 'assign', 'sendlatenotifications_adv', ''),
(1106, 'assign', 'sendlatenotifications_locked', ''),
(1107, 'assign', 'sendstudentnotifications', '1'),
(1108, 'assign', 'sendstudentnotifications_adv', ''),
(1109, 'assign', 'sendstudentnotifications_locked', ''),
(1110, 'assign', 'blindmarking', '0'),
(1111, 'assign', 'blindmarking_adv', ''),
(1112, 'assign', 'blindmarking_locked', ''),
(1113, 'assign', 'hidegrader', '0'),
(1114, 'assign', 'hidegrader_adv', ''),
(1115, 'assign', 'hidegrader_locked', ''),
(1116, 'assign', 'markingworkflow', '0'),
(1117, 'assign', 'markingworkflow_adv', ''),
(1118, 'assign', 'markingworkflow_locked', ''),
(1119, 'assign', 'markingallocation', '0'),
(1120, 'assign', 'markingallocation_adv', ''),
(1121, 'assign', 'markingallocation_locked', ''),
(1122, 'assign', 'markinganonymous', '0'),
(1123, 'assign', 'markinganonymous_adv', ''),
(1124, 'assign', 'markinganonymous_locked', ''),
(1125, 'assignsubmission_file', 'default', '1'),
(1126, 'assignsubmission_file', 'maxfiles', '20'),
(1127, 'assignsubmission_file', 'filetypes', ''),
(1128, 'assignsubmission_file', 'maxbytes', '0'),
(1129, 'assignsubmission_onlinetext', 'default', '0'),
(1130, 'assignfeedback_comments', 'default', '1'),
(1131, 'assignfeedback_comments', 'inline', '0'),
(1132, 'assignfeedback_comments', 'inline_adv', ''),
(1133, 'assignfeedback_comments', 'inline_locked', ''),
(1134, 'assignfeedback_editpdf', 'default', '1'),
(1135, 'assignfeedback_editpdf', 'stamps', ''),
(1136, 'assignfeedback_file', 'default', '0'),
(1137, 'assignfeedback_offline', 'default', '0'),
(1138, 'mod_bigbluebuttonbn', 'presentationdefault', ''),
(1139, 'mod_bigbluebuttonbn', 'showpresentation_default', '1'),
(1140, 'mod_bigbluebuttonbn', 'showpresentation_editable', '0'),
(1141, 'book', 'numberingoptions', '0,1,2,3'),
(1142, 'book', 'numbering', '1'),
(1143, 'resource', 'framesize', '130'),
(1144, 'resource', 'displayoptions', '0,1,4,5,6'),
(1145, 'resource', 'printintro', '1'),
(1146, 'resource', 'display', '0'),
(1147, 'resource', 'showsize', '0'),
(1148, 'resource', 'showtype', '1'),
(1149, 'resource', 'showdate', '0'),
(1150, 'resource', 'popupwidth', '620'),
(1151, 'resource', 'popupheight', '450'),
(1152, 'resource', 'filterfiles', '0'),
(1153, 'folder', 'showexpanded', '1'),
(1154, 'folder', 'maxsizetodownload', '0'),
(1155, 'mod_h5pactivity', 'enablesavestate', '1'),
(1156, 'mod_h5pactivity', 'savestatefreq', '60'),
(1157, 'imscp', 'keepold', '1'),
(1158, 'imscp', 'keepold_adv', ''),
(1159, 'mod_lesson', 'mediafile', ''),
(1160, 'mod_lesson', 'mediafile_adv', '1'),
(1161, 'mod_lesson', 'mediawidth', '640'),
(1162, 'mod_lesson', 'mediaheight', '480'),
(1163, 'mod_lesson', 'mediaclose', '0'),
(1164, 'mod_lesson', 'progressbar', '0'),
(1165, 'mod_lesson', 'progressbar_adv', ''),
(1166, 'mod_lesson', 'ongoing', '0'),
(1167, 'mod_lesson', 'ongoing_adv', '1'),
(1168, 'mod_lesson', 'displayleftmenu', '0'),
(1169, 'mod_lesson', 'displayleftmenu_adv', ''),
(1170, 'mod_lesson', 'displayleftif', '0'),
(1171, 'mod_lesson', 'displayleftif_adv', '1'),
(1172, 'mod_lesson', 'slideshow', '0'),
(1173, 'mod_lesson', 'slideshow_adv', '1'),
(1174, 'mod_lesson', 'slideshowwidth', '640'),
(1175, 'mod_lesson', 'slideshowheight', '480'),
(1176, 'mod_lesson', 'slideshowbgcolor', '#FFFFFF'),
(1177, 'mod_lesson', 'maxanswers', '5'),
(1178, 'mod_lesson', 'maxanswers_adv', '1'),
(1179, 'mod_lesson', 'defaultfeedback', '0'),
(1180, 'mod_lesson', 'defaultfeedback_adv', '1'),
(1181, 'mod_lesson', 'activitylink', ''),
(1182, 'mod_lesson', 'activitylink_adv', '1'),
(1183, 'mod_lesson', 'timelimit', '0'),
(1184, 'mod_lesson', 'timelimit_adv', ''),
(1185, 'mod_lesson', 'password', '0'),
(1186, 'mod_lesson', 'password_adv', '1'),
(1187, 'mod_lesson', 'modattempts', '0'),
(1188, 'mod_lesson', 'modattempts_adv', ''),
(1189, 'mod_lesson', 'displayreview', '0'),
(1190, 'mod_lesson', 'displayreview_adv', ''),
(1191, 'mod_lesson', 'maximumnumberofattempts', '1'),
(1192, 'mod_lesson', 'maximumnumberofattempts_adv', ''),
(1193, 'mod_lesson', 'defaultnextpage', '0'),
(1194, 'mod_lesson', 'defaultnextpage_adv', '1'),
(1195, 'mod_lesson', 'numberofpagestoshow', '1'),
(1196, 'mod_lesson', 'numberofpagestoshow_adv', '1'),
(1197, 'mod_lesson', 'practice', '0'),
(1198, 'mod_lesson', 'practice_adv', ''),
(1199, 'mod_lesson', 'customscoring', '1'),
(1200, 'mod_lesson', 'customscoring_adv', '1'),
(1201, 'mod_lesson', 'retakesallowed', '0'),
(1202, 'mod_lesson', 'retakesallowed_adv', ''),
(1203, 'mod_lesson', 'handlingofretakes', '0'),
(1204, 'mod_lesson', 'handlingofretakes_adv', '1'),
(1205, 'mod_lesson', 'minimumnumberofquestions', '0'),
(1206, 'mod_lesson', 'minimumnumberofquestions_adv', '1'),
(1207, 'page', 'displayoptions', '5'),
(1208, 'page', 'printintro', '0'),
(1209, 'page', 'printlastmodified', '1'),
(1210, 'page', 'display', '5'),
(1211, 'page', 'popupwidth', '620'),
(1212, 'page', 'popupheight', '450'),
(1213, 'quiz', 'notifyattemptgradeddelay', '18000'),
(1214, 'quiz', 'precreateperiod', '0'),
(1215, 'quiz', 'graceperiodmin', '60'),
(1216, 'quiz', 'initialnumfeedbacks', '2'),
(1217, 'quiz', 'autosaveperiod', '60'),
(1218, 'quiz', 'timelimit', '0'),
(1219, 'quiz', 'timelimit_adv', ''),
(1220, 'quiz', 'timelimit_locked', ''),
(1221, 'quiz', 'overduehandling', 'autosubmit'),
(1222, 'quiz', 'overduehandling_adv', ''),
(1223, 'quiz', 'overduehandling_locked', ''),
(1224, 'quiz', 'graceperiod', '86400'),
(1225, 'quiz', 'graceperiod_adv', ''),
(1226, 'quiz', 'graceperiod_locked', ''),
(1227, 'quiz', 'precreateattempts', '0'),
(1228, 'quiz', 'precreateattempts_adv', '1'),
(1229, 'quiz', 'precreateattempts_locked', '1'),
(1230, 'quiz', 'attempts', '0'),
(1231, 'quiz', 'attempts_adv', ''),
(1232, 'quiz', 'attempts_locked', ''),
(1233, 'quiz', 'grademethod', '1'),
(1234, 'quiz', 'grademethod_adv', ''),
(1235, 'quiz', 'grademethod_locked', ''),
(1236, 'quiz', 'maximumgrade', '10'),
(1237, 'quiz', 'maximumgrade_locked', ''),
(1238, 'quiz', 'questionsperpage', '1'),
(1239, 'quiz', 'questionsperpage_adv', ''),
(1240, 'quiz', 'questionsperpage_locked', ''),
(1241, 'quiz', 'navmethod', 'free'),
(1242, 'quiz', 'navmethod_adv', '1'),
(1243, 'quiz', 'navmethod_locked', ''),
(1244, 'quiz', 'shuffleanswers', '1'),
(1245, 'quiz', 'shuffleanswers_adv', ''),
(1246, 'quiz', 'shuffleanswers_locked', ''),
(1247, 'quiz', 'preferredbehaviour', 'deferredfeedback'),
(1248, 'quiz', 'preferredbehaviour_locked', ''),
(1249, 'quiz', 'canredoquestions', '0'),
(1250, 'quiz', 'canredoquestions_adv', '1'),
(1251, 'quiz', 'canredoquestions_locked', ''),
(1252, 'quiz', 'attemptonlast', '0'),
(1253, 'quiz', 'attemptonlast_adv', '1'),
(1254, 'quiz', 'attemptonlast_locked', ''),
(1255, 'quiz', 'reviewattempt', '69904'),
(1256, 'quiz', 'reviewcorrectness', '69904'),
(1257, 'quiz', 'reviewmaxmarks', '69904'),
(1258, 'quiz', 'reviewmarks', '69904'),
(1259, 'quiz', 'reviewspecificfeedback', '69904'),
(1260, 'quiz', 'reviewgeneralfeedback', '69904'),
(1261, 'quiz', 'reviewrightanswer', '69904'),
(1262, 'quiz', 'reviewoverallfeedback', '4368'),
(1263, 'quiz', 'showuserpicture', '0'),
(1264, 'quiz', 'showuserpicture_adv', ''),
(1265, 'quiz', 'showuserpicture_locked', ''),
(1266, 'quiz', 'decimalpoints', '2'),
(1267, 'quiz', 'decimalpoints_adv', ''),
(1268, 'quiz', 'decimalpoints_locked', ''),
(1269, 'quiz', 'questiondecimalpoints', '-1'),
(1270, 'quiz', 'questiondecimalpoints_adv', ''),
(1271, 'quiz', 'questiondecimalpoints_locked', ''),
(1272, 'quiz', 'showblocks', '0'),
(1273, 'quiz', 'showblocks_adv', '1'),
(1274, 'quiz', 'showblocks_locked', ''),
(1275, 'quiz', 'quizpassword', ''),
(1276, 'quiz', 'quizpassword_adv', ''),
(1277, 'quiz', 'quizpassword_required', ''),
(1278, 'quiz', 'quizpassword_locked', ''),
(1279, 'quiz', 'subnet', ''),
(1280, 'quiz', 'subnet_adv', '1'),
(1281, 'quiz', 'subnet_locked', ''),
(1282, 'quiz', 'delay1', '0'),
(1283, 'quiz', 'delay1_adv', '1'),
(1284, 'quiz', 'delay1_locked', ''),
(1285, 'quiz', 'delay2', '0'),
(1286, 'quiz', 'delay2_adv', '1'),
(1287, 'quiz', 'delay2_locked', ''),
(1288, 'quiz', 'browsersecurity', '-'),
(1289, 'quiz', 'browsersecurity_adv', '1'),
(1290, 'quiz', 'browsersecurity_locked', ''),
(1291, 'quiz_statistics', 'getstatslocktimeout', '900'),
(1292, 'quizaccess_seb', 'autoreconfigureseb', '1'),
(1293, 'quizaccess_seb', 'showseblinks', 'seb,http'),
(1294, 'quizaccess_seb', 'downloadlink', 'https://safeexambrowser.org/download_en.html'),
(1295, 'quizaccess_seb', 'quizpasswordrequired', '0'),
(1296, 'quizaccess_seb', 'displayblocksbeforestart', '0'),
(1297, 'quizaccess_seb', 'displayblockswhenfinished', '1'),
(1298, 'scorm', 'displaycoursestructure', '0'),
(1299, 'scorm', 'displaycoursestructure_adv', ''),
(1300, 'scorm', 'popup', '0'),
(1301, 'scorm', 'popup_adv', ''),
(1302, 'scorm', 'framewidth', '100'),
(1303, 'scorm', 'framewidth_adv', '1'),
(1304, 'scorm', 'frameheight', '500'),
(1305, 'scorm', 'frameheight_adv', '1'),
(1306, 'scorm', 'winoptgrp_adv', '1'),
(1307, 'scorm', 'scrollbars', '0'),
(1308, 'scorm', 'directories', '0'),
(1309, 'scorm', 'location', '0'),
(1310, 'scorm', 'menubar', '0'),
(1311, 'scorm', 'toolbar', '0'),
(1312, 'scorm', 'status', '0'),
(1313, 'scorm', 'skipview', '0'),
(1314, 'scorm', 'skipview_adv', '1'),
(1315, 'scorm', 'hidebrowse', '0'),
(1316, 'scorm', 'hidebrowse_adv', '1'),
(1317, 'scorm', 'hidetoc', '0'),
(1318, 'scorm', 'hidetoc_adv', '1'),
(1319, 'scorm', 'nav', '1'),
(1320, 'scorm', 'nav_adv', '1'),
(1321, 'scorm', 'navpositionleft', '-100'),
(1322, 'scorm', 'navpositionleft_adv', '1'),
(1323, 'scorm', 'navpositiontop', '-100'),
(1324, 'scorm', 'navpositiontop_adv', '1'),
(1325, 'scorm', 'collapsetocwinsize', '767'),
(1326, 'scorm', 'collapsetocwinsize_adv', '1'),
(1327, 'scorm', 'displayattemptstatus', '1'),
(1328, 'scorm', 'displayattemptstatus_adv', ''),
(1329, 'scorm', 'grademethod', '1'),
(1330, 'scorm', 'maxgrade', '100'),
(1331, 'scorm', 'maxattempt', '0'),
(1332, 'scorm', 'whatgrade', '0'),
(1333, 'scorm', 'forcecompleted', '0'),
(1334, 'scorm', 'forcenewattempt', '0'),
(1335, 'scorm', 'autocommit', '0'),
(1336, 'scorm', 'masteryoverride', '1'),
(1337, 'scorm', 'lastattemptlock', '0'),
(1338, 'scorm', 'auto', '0'),
(1339, 'scorm', 'updatefreq', '0'),
(1340, 'scorm', 'scormstandard', '0'),
(1341, 'scorm', 'allowtypeexternal', '0'),
(1342, 'scorm', 'allowtypelocalsync', '0'),
(1343, 'scorm', 'allowtypeexternalaicc', '0'),
(1344, 'scorm', 'allowaicchacp', '0'),
(1345, 'scorm', 'aicchacptimeout', '30'),
(1346, 'scorm', 'aicchacpkeepsessiondata', '1'),
(1347, 'scorm', 'aiccuserid', '1'),
(1348, 'scorm', 'forcejavascript', '1'),
(1349, 'scorm', 'allowapidebug', '0'),
(1350, 'scorm', 'apidebugmask', '.*'),
(1351, 'scorm', 'protectpackagedownloads', '0'),
(1352, 'label', 'dndresizewidth', '400'),
(1353, 'label', 'dndresizeheight', '400'),
(1354, 'url', 'framesize', '130'),
(1355, 'url', 'secretphrase', ''),
(1356, 'url', 'allowvariables', '0'),
(1357, 'url', 'rolesinparams', '0'),
(1358, 'url', 'displayoptions', '0,1,5,6'),
(1359, 'url', 'printintro', '1'),
(1360, 'url', 'display', '0'),
(1361, 'url', 'popupwidth', '620'),
(1362, 'url', 'popupheight', '450'),
(1363, 'workshop', 'grade', '80'),
(1364, 'workshop', 'gradinggrade', '20'),
(1365, 'workshop', 'gradedecimals', '0'),
(1366, 'workshop', 'maxbytes', '0'),
(1367, 'workshop', 'strategy', 'accumulative'),
(1368, 'workshop', 'examplesmode', '0'),
(1369, 'workshopallocation_random', 'numofreviews', '5'),
(1370, 'workshopform_numerrors', 'grade0', 'No'),
(1371, 'workshopform_numerrors', 'grade1', 'Yes'),
(1372, 'workshopeval_best', 'comparison', '5'),
(1373, 'tool_brickfield', 'analysistype', '0'),
(1374, 'tool_brickfield', 'deletehistoricaldata', '1'),
(1375, 'tool_brickfield', 'batch', '1000'),
(1376, 'tool_brickfield', 'perpage', '50'),
(1377, 'tool_mfa', 'enabled', '0'),
(1378, 'tool_mfa', 'lockout', '10'),
(1379, 'tool_mfa', 'debugmode', '0'),
(1380, 'tool_mfa', 'redir_exclusions', ''),
(1381, 'tool_mfa', 'guidance', '0'),
(1382, 'tool_mfa', 'guidancecontent', ''),
(1383, 'tool_mfa', 'guidancefiles', ''),
(1384, 'factor_admin', 'enabled', '0'),
(1385, 'factor_admin', 'weight', '100'),
(1386, 'factor_auth', 'enabled', '0'),
(1387, 'factor_auth', 'weight', '100'),
(1388, 'factor_auth', 'goodauth', ''),
(1389, 'factor_capability', 'enabled', '0'),
(1390, 'factor_capability', 'weight', '100'),
(1391, 'factor_capability', 'adminpasses', '1'),
(1392, 'factor_cohort', 'enabled', '0'),
(1393, 'factor_cohort', 'weight', '100'),
(1394, 'factor_email', 'enabled', '1'),
(1395, 'factor_email', 'weight', '100'),
(1396, 'factor_email', 'duration', '1800'),
(1397, 'factor_email', 'suspend', '0'),
(1398, 'factor_grace', 'enabled', '0'),
(1399, 'factor_grace', 'weight', '100'),
(1400, 'factor_grace', 'forcesetup', '0'),
(1401, 'factor_grace', 'graceperiod', '604800'),
(1402, 'factor_grace', 'ignorelist', ''),
(1403, 'factor_grace', 'customwarning', ''),
(1404, 'factor_iprange', 'enabled', '0'),
(1405, 'factor_iprange', 'weight', '100'),
(1406, 'factor_iprange', 'safeips', ''),
(1407, 'factor_nosetup', 'enabled', '0'),
(1408, 'factor_nosetup', 'weight', '100'),
(1409, 'factor_role', 'enabled', '0'),
(1410, 'factor_role', 'weight', '100'),
(1411, 'factor_role', 'roles', 'admin'),
(1412, 'factor_sms', 'smsgateway', '0'),
(1413, 'factor_sms', 'enabled', '0'),
(1414, 'factor_sms', 'weight', '100'),
(1415, 'factor_sms', 'duration', '1800'),
(1416, 'factor_token', 'enabled', '0'),
(1417, 'factor_token', 'weight', '100'),
(1418, 'factor_token', 'expiry', '86400'),
(1419, 'factor_token', 'expireovernight', '1'),
(1420, 'factor_totp', 'enabled', '0'),
(1421, 'factor_totp', 'weight', '100'),
(1422, 'factor_totp', 'window', '15'),
(1423, 'factor_totp', 'totplink', '1'),
(1424, 'factor_webauthn', 'enabled', '0'),
(1425, 'factor_webauthn', 'weight', '100'),
(1426, 'factor_webauthn', 'authenticatortypes', 'usb,nfc,ble,hybrid,internal'),
(1427, 'factor_webauthn', 'userverification', 'preferred'),
(1428, 'tool_recyclebin', 'coursebinenable', '1'),
(1429, 'tool_recyclebin', 'coursebinexpiry', '604800'),
(1430, 'tool_recyclebin', 'categorybinenable', '1'),
(1431, 'tool_recyclebin', 'categorybinexpiry', '604800'),
(1432, 'tool_recyclebin', 'autohide', '1'),
(1433, 'antivirus_clamav', 'runningmethod', 'commandline'),
(1434, 'antivirus_clamav', 'pathtoclam', ''),
(1435, 'antivirus_clamav', 'pathtounixsocket', ''),
(1436, 'antivirus_clamav', 'tcpsockethost', ''),
(1437, 'antivirus_clamav', 'tcpsocketport', '3310'),
(1438, 'antivirus_clamav', 'clamfailureonupload', 'tryagain'),
(1439, 'antivirus_clamav', 'tries', '1'),
(1440, 'auth_email', 'recaptcha', '0'),
(1441, 'auth_email', 'field_lock_firstname', 'unlocked'),
(1442, 'auth_email', 'field_lock_lastname', 'unlocked'),
(1443, 'auth_email', 'field_lock_email', 'unlocked'),
(1444, 'auth_email', 'field_lock_city', 'unlocked'),
(1445, 'auth_email', 'field_lock_country', 'unlocked'),
(1446, 'auth_email', 'field_lock_lang', 'unlocked'),
(1447, 'auth_email', 'field_lock_description', 'unlocked'),
(1448, 'auth_email', 'field_lock_idnumber', 'unlocked'),
(1449, 'auth_email', 'field_lock_institution', 'unlocked'),
(1450, 'auth_email', 'field_lock_department', 'unlocked'),
(1451, 'auth_email', 'field_lock_phone1', 'unlocked'),
(1452, 'auth_email', 'field_lock_phone2', 'unlocked'),
(1453, 'auth_email', 'field_lock_address', 'unlocked'),
(1454, 'auth_email', 'field_lock_firstnamephonetic', 'unlocked'),
(1455, 'auth_email', 'field_lock_lastnamephonetic', 'unlocked'),
(1456, 'auth_email', 'field_lock_middlename', 'unlocked'),
(1457, 'auth_email', 'field_lock_alternatename', 'unlocked'),
(1458, 'auth_db', 'host', '127.0.0.1'),
(1459, 'auth_db', 'type', 'mysqli'),
(1460, 'auth_db', 'sybasequoting', '0'),
(1461, 'auth_db', 'name', ''),
(1462, 'auth_db', 'user', ''),
(1463, 'auth_db', 'pass', ''),
(1464, 'auth_db', 'table', ''),
(1465, 'auth_db', 'fielduser', ''),
(1466, 'auth_db', 'fieldpass', ''),
(1467, 'auth_db', 'passtype', 'plaintext'),
(1468, 'auth_db', 'extencoding', 'utf-8'),
(1469, 'auth_db', 'setupsql', ''),
(1470, 'auth_db', 'debugauthdb', '0'),
(1471, 'auth_db', 'changepasswordurl', ''),
(1472, 'auth_db', 'removeuser', '0'),
(1473, 'auth_db', 'updateusers', '0'),
(1474, 'auth_db', 'field_map_firstname', ''),
(1475, 'auth_db', 'field_updatelocal_firstname', 'oncreate'),
(1476, 'auth_db', 'field_updateremote_firstname', '0'),
(1477, 'auth_db', 'field_lock_firstname', 'unlocked'),
(1478, 'auth_db', 'field_map_lastname', ''),
(1479, 'auth_db', 'field_updatelocal_lastname', 'oncreate'),
(1480, 'auth_db', 'field_updateremote_lastname', '0'),
(1481, 'auth_db', 'field_lock_lastname', 'unlocked'),
(1482, 'auth_db', 'field_map_email', ''),
(1483, 'auth_db', 'field_updatelocal_email', 'oncreate'),
(1484, 'auth_db', 'field_updateremote_email', '0'),
(1485, 'auth_db', 'field_lock_email', 'unlocked'),
(1486, 'auth_db', 'field_map_city', ''),
(1487, 'auth_db', 'field_updatelocal_city', 'oncreate'),
(1488, 'auth_db', 'field_updateremote_city', '0'),
(1489, 'auth_db', 'field_lock_city', 'unlocked'),
(1490, 'auth_db', 'field_map_country', ''),
(1491, 'auth_db', 'field_updatelocal_country', 'oncreate'),
(1492, 'auth_db', 'field_updateremote_country', '0'),
(1493, 'auth_db', 'field_lock_country', 'unlocked'),
(1494, 'auth_db', 'field_map_lang', ''),
(1495, 'auth_db', 'field_updatelocal_lang', 'oncreate'),
(1496, 'auth_db', 'field_updateremote_lang', '0'),
(1497, 'auth_db', 'field_lock_lang', 'unlocked'),
(1498, 'auth_db', 'field_map_description', ''),
(1499, 'auth_db', 'field_updatelocal_description', 'oncreate'),
(1500, 'auth_db', 'field_updateremote_description', '0'),
(1501, 'auth_db', 'field_lock_description', 'unlocked'),
(1502, 'auth_db', 'field_map_idnumber', ''),
(1503, 'auth_db', 'field_updatelocal_idnumber', 'oncreate'),
(1504, 'auth_db', 'field_updateremote_idnumber', '0'),
(1505, 'auth_db', 'field_lock_idnumber', 'unlocked'),
(1506, 'auth_db', 'field_map_institution', ''),
(1507, 'auth_db', 'field_updatelocal_institution', 'oncreate'),
(1508, 'auth_db', 'field_updateremote_institution', '0'),
(1509, 'auth_db', 'field_lock_institution', 'unlocked'),
(1510, 'auth_db', 'field_map_department', ''),
(1511, 'auth_db', 'field_updatelocal_department', 'oncreate'),
(1512, 'auth_db', 'field_updateremote_department', '0'),
(1513, 'auth_db', 'field_lock_department', 'unlocked'),
(1514, 'auth_db', 'field_map_phone1', ''),
(1515, 'auth_db', 'field_updatelocal_phone1', 'oncreate'),
(1516, 'auth_db', 'field_updateremote_phone1', '0'),
(1517, 'auth_db', 'field_lock_phone1', 'unlocked'),
(1518, 'auth_db', 'field_map_phone2', ''),
(1519, 'auth_db', 'field_updatelocal_phone2', 'oncreate'),
(1520, 'auth_db', 'field_updateremote_phone2', '0'),
(1521, 'auth_db', 'field_lock_phone2', 'unlocked'),
(1522, 'auth_db', 'field_map_address', ''),
(1523, 'auth_db', 'field_updatelocal_address', 'oncreate'),
(1524, 'auth_db', 'field_updateremote_address', '0'),
(1525, 'auth_db', 'field_lock_address', 'unlocked'),
(1526, 'auth_db', 'field_map_firstnamephonetic', ''),
(1527, 'auth_db', 'field_updatelocal_firstnamephonetic', 'oncreate'),
(1528, 'auth_db', 'field_updateremote_firstnamephonetic', '0'),
(1529, 'auth_db', 'field_lock_firstnamephonetic', 'unlocked'),
(1530, 'auth_db', 'field_map_lastnamephonetic', ''),
(1531, 'auth_db', 'field_updatelocal_lastnamephonetic', 'oncreate'),
(1532, 'auth_db', 'field_updateremote_lastnamephonetic', '0'),
(1533, 'auth_db', 'field_lock_lastnamephonetic', 'unlocked'),
(1534, 'auth_db', 'field_map_middlename', ''),
(1535, 'auth_db', 'field_updatelocal_middlename', 'oncreate'),
(1536, 'auth_db', 'field_updateremote_middlename', '0'),
(1537, 'auth_db', 'field_lock_middlename', 'unlocked'),
(1538, 'auth_db', 'field_map_alternatename', ''),
(1539, 'auth_db', 'field_updatelocal_alternatename', 'oncreate'),
(1540, 'auth_db', 'field_updateremote_alternatename', '0'),
(1541, 'auth_db', 'field_lock_alternatename', 'unlocked'),
(1542, 'auth_ldap', 'host_url', ''),
(1543, 'auth_ldap', 'ldap_version', '3'),
(1544, 'auth_ldap', 'start_tls', '0'),
(1545, 'auth_ldap', 'ldapencoding', 'utf-8'),
(1546, 'auth_ldap', 'pagesize', '250'),
(1547, 'auth_ldap', 'preventpassindb', '0'),
(1548, 'auth_ldap', 'bind_dn', ''),
(1549, 'auth_ldap', 'bind_pw', ''),
(1550, 'auth_ldap', 'user_type', 'default'),
(1551, 'auth_ldap', 'contexts', ''),
(1552, 'auth_ldap', 'search_sub', '0'),
(1553, 'auth_ldap', 'opt_deref', '0'),
(1554, 'auth_ldap', 'user_attribute', ''),
(1555, 'auth_ldap', 'suspended_attribute', ''),
(1556, 'auth_ldap', 'memberattribute', ''),
(1557, 'auth_ldap', 'memberattribute_isdn', '0'),
(1558, 'auth_ldap', 'objectclass', ''),
(1559, 'auth_ldap', 'forcechangepassword', '0'),
(1560, 'auth_ldap', 'stdchangepassword', '0'),
(1561, 'auth_ldap', 'passtype', 'plaintext'),
(1562, 'auth_ldap', 'changepasswordurl', ''),
(1563, 'auth_ldap', 'expiration', '0'),
(1564, 'auth_ldap', 'expiration_warning', ''),
(1565, 'auth_ldap', 'expireattr', ''),
(1566, 'auth_ldap', 'gracelogins', '0'),
(1567, 'auth_ldap', 'graceattr', ''),
(1568, 'auth_ldap', 'auth_user_create', '0'),
(1569, 'auth_ldap', 'create_context', ''),
(1570, 'auth_ldap', 'managercontext', ''),
(1571, 'auth_ldap', 'coursecreatorcontext', ''),
(1572, 'auth_ldap', 'removeuser', '0'),
(1573, 'auth_ldap', 'sync_suspended', '0'),
(1574, 'auth_ldap', 'sync_updateuserchunk', '1000'),
(1575, 'auth_ldap', 'ntlmsso_enabled', '0'),
(1576, 'auth_ldap', 'ntlmsso_subnet', ''),
(1577, 'auth_ldap', 'ntlmsso_ie_fastpath', '0'),
(1578, 'auth_ldap', 'ntlmsso_type', 'ntlm'),
(1579, 'auth_ldap', 'ntlmsso_remoteuserformat', ''),
(1580, 'auth_ldap', 'field_map_firstname', ''),
(1581, 'auth_ldap', 'field_updatelocal_firstname', 'oncreate'),
(1582, 'auth_ldap', 'field_updateremote_firstname', '0'),
(1583, 'auth_ldap', 'field_lock_firstname', 'unlocked'),
(1584, 'auth_ldap', 'field_map_lastname', ''),
(1585, 'auth_ldap', 'field_updatelocal_lastname', 'oncreate'),
(1586, 'auth_ldap', 'field_updateremote_lastname', '0'),
(1587, 'auth_ldap', 'field_lock_lastname', 'unlocked'),
(1588, 'auth_ldap', 'field_map_email', ''),
(1589, 'auth_ldap', 'field_updatelocal_email', 'oncreate'),
(1590, 'auth_ldap', 'field_updateremote_email', '0'),
(1591, 'auth_ldap', 'field_lock_email', 'unlocked'),
(1592, 'auth_ldap', 'field_map_city', ''),
(1593, 'auth_ldap', 'field_updatelocal_city', 'oncreate'),
(1594, 'auth_ldap', 'field_updateremote_city', '0'),
(1595, 'auth_ldap', 'field_lock_city', 'unlocked'),
(1596, 'auth_ldap', 'field_map_country', ''),
(1597, 'auth_ldap', 'field_updatelocal_country', 'oncreate'),
(1598, 'auth_ldap', 'field_updateremote_country', '0'),
(1599, 'auth_ldap', 'field_lock_country', 'unlocked'),
(1600, 'auth_ldap', 'field_map_lang', ''),
(1601, 'auth_ldap', 'field_updatelocal_lang', 'oncreate'),
(1602, 'auth_ldap', 'field_updateremote_lang', '0'),
(1603, 'auth_ldap', 'field_lock_lang', 'unlocked'),
(1604, 'auth_ldap', 'field_map_description', ''),
(1605, 'auth_ldap', 'field_updatelocal_description', 'oncreate'),
(1606, 'auth_ldap', 'field_updateremote_description', '0'),
(1607, 'auth_ldap', 'field_lock_description', 'unlocked'),
(1608, 'auth_ldap', 'field_map_idnumber', ''),
(1609, 'auth_ldap', 'field_updatelocal_idnumber', 'oncreate'),
(1610, 'auth_ldap', 'field_updateremote_idnumber', '0'),
(1611, 'auth_ldap', 'field_lock_idnumber', 'unlocked'),
(1612, 'auth_ldap', 'field_map_institution', ''),
(1613, 'auth_ldap', 'field_updatelocal_institution', 'oncreate'),
(1614, 'auth_ldap', 'field_updateremote_institution', '0'),
(1615, 'auth_ldap', 'field_lock_institution', 'unlocked'),
(1616, 'auth_ldap', 'field_map_department', ''),
(1617, 'auth_ldap', 'field_updatelocal_department', 'oncreate'),
(1618, 'auth_ldap', 'field_updateremote_department', '0'),
(1619, 'auth_ldap', 'field_lock_department', 'unlocked'),
(1620, 'auth_ldap', 'field_map_phone1', ''),
(1621, 'auth_ldap', 'field_updatelocal_phone1', 'oncreate'),
(1622, 'auth_ldap', 'field_updateremote_phone1', '0'),
(1623, 'auth_ldap', 'field_lock_phone1', 'unlocked'),
(1624, 'auth_ldap', 'field_map_phone2', ''),
(1625, 'auth_ldap', 'field_updatelocal_phone2', 'oncreate'),
(1626, 'auth_ldap', 'field_updateremote_phone2', '0'),
(1627, 'auth_ldap', 'field_lock_phone2', 'unlocked'),
(1628, 'auth_ldap', 'field_map_address', ''),
(1629, 'auth_ldap', 'field_updatelocal_address', 'oncreate'),
(1630, 'auth_ldap', 'field_updateremote_address', '0'),
(1631, 'auth_ldap', 'field_lock_address', 'unlocked'),
(1632, 'auth_ldap', 'field_map_firstnamephonetic', ''),
(1633, 'auth_ldap', 'field_updatelocal_firstnamephonetic', 'oncreate'),
(1634, 'auth_ldap', 'field_updateremote_firstnamephonetic', '0'),
(1635, 'auth_ldap', 'field_lock_firstnamephonetic', 'unlocked'),
(1636, 'auth_ldap', 'field_map_lastnamephonetic', ''),
(1637, 'auth_ldap', 'field_updatelocal_lastnamephonetic', 'oncreate'),
(1638, 'auth_ldap', 'field_updateremote_lastnamephonetic', '0'),
(1639, 'auth_ldap', 'field_lock_lastnamephonetic', 'unlocked'),
(1640, 'auth_ldap', 'field_map_middlename', ''),
(1641, 'auth_ldap', 'field_updatelocal_middlename', 'oncreate'),
(1642, 'auth_ldap', 'field_updateremote_middlename', '0'),
(1643, 'auth_ldap', 'field_lock_middlename', 'unlocked'),
(1644, 'auth_ldap', 'field_map_alternatename', ''),
(1645, 'auth_ldap', 'field_updatelocal_alternatename', 'oncreate'),
(1646, 'auth_ldap', 'field_updateremote_alternatename', '0'),
(1647, 'auth_ldap', 'field_lock_alternatename', 'unlocked'),
(1648, 'auth_manual', 'expiration', '0'),
(1649, 'auth_manual', 'expirationtime', '30'),
(1650, 'auth_manual', 'expiration_warning', '0'),
(1651, 'auth_manual', 'field_lock_firstname', 'unlocked'),
(1652, 'auth_manual', 'field_lock_lastname', 'unlocked'),
(1653, 'auth_manual', 'field_lock_email', 'unlocked'),
(1654, 'auth_manual', 'field_lock_city', 'unlocked'),
(1655, 'auth_manual', 'field_lock_country', 'unlocked'),
(1656, 'auth_manual', 'field_lock_lang', 'unlocked'),
(1657, 'auth_manual', 'field_lock_description', 'unlocked'),
(1658, 'auth_manual', 'field_lock_idnumber', 'unlocked'),
(1659, 'auth_manual', 'field_lock_institution', 'unlocked'),
(1660, 'auth_manual', 'field_lock_department', 'unlocked'),
(1661, 'auth_manual', 'field_lock_phone1', 'unlocked'),
(1662, 'auth_manual', 'field_lock_phone2', 'unlocked'),
(1663, 'auth_manual', 'field_lock_address', 'unlocked'),
(1664, 'auth_manual', 'field_lock_firstnamephonetic', 'unlocked'),
(1665, 'auth_manual', 'field_lock_lastnamephonetic', 'unlocked'),
(1666, 'auth_manual', 'field_lock_middlename', 'unlocked'),
(1667, 'auth_manual', 'field_lock_alternatename', 'unlocked'),
(1668, 'auth_none', 'field_lock_firstname', 'unlocked'),
(1669, 'auth_none', 'field_lock_lastname', 'unlocked'),
(1670, 'auth_none', 'field_lock_email', 'unlocked'),
(1671, 'auth_none', 'field_lock_city', 'unlocked'),
(1672, 'auth_none', 'field_lock_country', 'unlocked'),
(1673, 'auth_none', 'field_lock_lang', 'unlocked'),
(1674, 'auth_none', 'field_lock_description', 'unlocked'),
(1675, 'auth_none', 'field_lock_idnumber', 'unlocked'),
(1676, 'auth_none', 'field_lock_institution', 'unlocked'),
(1677, 'auth_none', 'field_lock_department', 'unlocked'),
(1678, 'auth_none', 'field_lock_phone1', 'unlocked'),
(1679, 'auth_none', 'field_lock_phone2', 'unlocked'),
(1680, 'auth_none', 'field_lock_address', 'unlocked'),
(1681, 'auth_none', 'field_lock_firstnamephonetic', 'unlocked'),
(1682, 'auth_none', 'field_lock_lastnamephonetic', 'unlocked'),
(1683, 'auth_none', 'field_lock_middlename', 'unlocked'),
(1684, 'auth_none', 'field_lock_alternatename', 'unlocked'),
(1685, 'auth_oauth2', 'field_lock_firstname', 'unlocked'),
(1686, 'auth_oauth2', 'field_lock_lastname', 'unlocked'),
(1687, 'auth_oauth2', 'field_lock_email', 'unlocked'),
(1688, 'auth_oauth2', 'field_lock_city', 'unlocked'),
(1689, 'auth_oauth2', 'field_lock_country', 'unlocked'),
(1690, 'auth_oauth2', 'field_lock_lang', 'unlocked'),
(1691, 'auth_oauth2', 'field_lock_description', 'unlocked'),
(1692, 'auth_oauth2', 'field_lock_idnumber', 'unlocked'),
(1693, 'auth_oauth2', 'field_lock_institution', 'unlocked'),
(1694, 'auth_oauth2', 'field_lock_department', 'unlocked'),
(1695, 'auth_oauth2', 'field_lock_phone1', 'unlocked'),
(1696, 'auth_oauth2', 'field_lock_phone2', 'unlocked'),
(1697, 'auth_oauth2', 'field_lock_address', 'unlocked'),
(1698, 'auth_oauth2', 'field_lock_firstnamephonetic', 'unlocked'),
(1699, 'auth_oauth2', 'field_lock_lastnamephonetic', 'unlocked'),
(1700, 'auth_oauth2', 'field_lock_middlename', 'unlocked'),
(1701, 'auth_oauth2', 'field_lock_alternatename', 'unlocked'),
(1702, 'auth_shibboleth', 'user_attribute', ''),
(1703, 'auth_shibboleth', 'convert_data', ''),
(1704, 'auth_shibboleth', 'alt_login', 'off'),
(1705, 'auth_shibboleth', 'organization_selection', 'urn:mace:organization1:providerID, Example Organization 1\n        https://another.idp-id.com/shibboleth, Other Example Organization, /Shibboleth.sso/DS/SWITCHaai\n        urn:mace:organization2:providerID, Example Organization 2, /Shibboleth.sso/WAYF/SWITCHaai'),
(1706, 'auth_shibboleth', 'logout_handler', ''),
(1707, 'auth_shibboleth', 'logout_return_url', ''),
(1708, 'auth_shibboleth', 'login_name', 'Shibboleth Login'),
(1709, 'auth_shibboleth', 'auth_logo', ''),
(1710, 'auth_shibboleth', 'auth_instructions', 'Use the <a href="[[softurl]]/auth/shibboleth/index.php">Shibboleth login</a> to get access via Shibboleth, if your institution supports it. Otherwise, use the normal login form shown here.'),
(1711, 'auth_shibboleth', 'changepasswordurl', ''),
(1712, 'auth_shibboleth', 'field_map_firstname', ''),
(1713, 'auth_shibboleth', 'field_updatelocal_firstname', 'oncreate'),
(1714, 'auth_shibboleth', 'field_lock_firstname', 'unlocked'),
(1715, 'auth_shibboleth', 'field_map_lastname', ''),
(1716, 'auth_shibboleth', 'field_updatelocal_lastname', 'oncreate'),
(1717, 'auth_shibboleth', 'field_lock_lastname', 'unlocked'),
(1718, 'auth_shibboleth', 'field_map_email', ''),
(1719, 'auth_shibboleth', 'field_updatelocal_email', 'oncreate'),
(1720, 'auth_shibboleth', 'field_lock_email', 'unlocked'),
(1721, 'auth_shibboleth', 'field_map_city', ''),
(1722, 'auth_shibboleth', 'field_updatelocal_city', 'oncreate'),
(1723, 'auth_shibboleth', 'field_lock_city', 'unlocked'),
(1724, 'auth_shibboleth', 'field_map_country', ''),
(1725, 'auth_shibboleth', 'field_updatelocal_country', 'oncreate'),
(1726, 'auth_shibboleth', 'field_lock_country', 'unlocked'),
(1727, 'auth_shibboleth', 'field_map_lang', ''),
(1728, 'auth_shibboleth', 'field_updatelocal_lang', 'oncreate'),
(1729, 'auth_shibboleth', 'field_lock_lang', 'unlocked'),
(1730, 'auth_shibboleth', 'field_map_description', ''),
(1731, 'auth_shibboleth', 'field_updatelocal_description', 'oncreate'),
(1732, 'auth_shibboleth', 'field_lock_description', 'unlocked'),
(1733, 'auth_shibboleth', 'field_map_idnumber', ''),
(1734, 'auth_shibboleth', 'field_updatelocal_idnumber', 'oncreate'),
(1735, 'auth_shibboleth', 'field_lock_idnumber', 'unlocked'),
(1736, 'auth_shibboleth', 'field_map_institution', ''),
(1737, 'auth_shibboleth', 'field_updatelocal_institution', 'oncreate'),
(1738, 'auth_shibboleth', 'field_lock_institution', 'unlocked'),
(1739, 'auth_shibboleth', 'field_map_department', ''),
(1740, 'auth_shibboleth', 'field_updatelocal_department', 'oncreate'),
(1741, 'auth_shibboleth', 'field_lock_department', 'unlocked'),
(1742, 'auth_shibboleth', 'field_map_phone1', ''),
(1743, 'auth_shibboleth', 'field_updatelocal_phone1', 'oncreate'),
(1744, 'auth_shibboleth', 'field_lock_phone1', 'unlocked'),
(1745, 'auth_shibboleth', 'field_map_phone2', ''),
(1746, 'auth_shibboleth', 'field_updatelocal_phone2', 'oncreate'),
(1747, 'auth_shibboleth', 'field_lock_phone2', 'unlocked'),
(1748, 'auth_shibboleth', 'field_map_address', ''),
(1749, 'auth_shibboleth', 'field_updatelocal_address', 'oncreate'),
(1750, 'auth_shibboleth', 'field_lock_address', 'unlocked'),
(1751, 'auth_shibboleth', 'field_map_firstnamephonetic', ''),
(1752, 'auth_shibboleth', 'field_updatelocal_firstnamephonetic', 'oncreate'),
(1753, 'auth_shibboleth', 'field_lock_firstnamephonetic', 'unlocked'),
(1754, 'auth_shibboleth', 'field_map_lastnamephonetic', ''),
(1755, 'auth_shibboleth', 'field_updatelocal_lastnamephonetic', 'oncreate'),
(1756, 'auth_shibboleth', 'field_lock_lastnamephonetic', 'unlocked'),
(1757, 'auth_shibboleth', 'field_map_middlename', ''),
(1758, 'auth_shibboleth', 'field_updatelocal_middlename', 'oncreate'),
(1759, 'auth_shibboleth', 'field_lock_middlename', 'unlocked'),
(1760, 'auth_shibboleth', 'field_map_alternatename', ''),
(1761, 'auth_shibboleth', 'field_updatelocal_alternatename', 'oncreate'),
(1762, 'auth_shibboleth', 'field_lock_alternatename', 'unlocked'),
(1763, 'block_accessreview', 'whattoshow', 'showboth'),
(1764, 'block_accessreview', 'errordisplay', 'showint'),
(1765, 'block_accessreview', 'toolpage', 'errors'),
(1766, 'block_activity_results', 'config_showbest', '3'),
(1767, 'block_activity_results', 'config_showbest_locked', ''),
(1768, 'block_activity_results', 'config_showworst', '0'),
(1769, 'block_activity_results', 'config_showworst_locked', ''),
(1770, 'block_activity_results', 'config_usegroups', '0'),
(1771, 'block_activity_results', 'config_usegroups_locked', ''),
(1772, 'block_activity_results', 'config_nameformat', '1'),
(1773, 'block_activity_results', 'config_nameformat_locked', ''),
(1774, 'block_activity_results', 'config_gradeformat', '1'),
(1775, 'block_activity_results', 'config_gradeformat_locked', ''),
(1776, 'block_activity_results', 'config_decimalpoints', '2'),
(1777, 'block_activity_results', 'config_decimalpoints_locked', ''),
(1778, 'block_myoverview', 'displaycategories', '1'),
(1779, 'block_myoverview', 'layouts', 'card,list,summary'),
(1780, 'block_myoverview', 'displaygroupingallincludinghidden', '0'),
(1781, 'block_myoverview', 'displaygroupingall', '1'),
(1782, 'block_myoverview', 'displaygroupinginprogress', '1'),
(1783, 'block_myoverview', 'displaygroupingpast', '1'),
(1784, 'block_myoverview', 'displaygroupingfuture', '1'),
(1785, 'block_myoverview', 'displaygroupingcustomfield', '0'),
(1786, 'block_myoverview', 'customfiltergrouping', ''),
(1787, 'block_myoverview', 'displaygroupingfavourites', '1'),
(1788, 'block_myoverview', 'displaygroupinghidden', '1'),
(1789, 'block_recentlyaccessedcourses', 'displaycategories', '1'),
(1790, 'block_starredcourses', 'displaycategories', '1'),
(1791, 'block_tag_youtube', 'apikey', ''),
(1792, 'format_topics', 'indentation', '1'),
(1793, 'format_singleactivity', 'activitytype', 'forum'),
(1794, 'format_weeks', 'indentation', '1'),
(1795, 'format_weeks', 'maxinitialsections', '52'),
(1796, 'fileconverter_googledrive', 'issuerid', ''),
(1797, 'enrol_cohort', 'roleid', '5'),
(1798, 'enrol_cohort', 'unenrolaction', '0'),
(1799, 'enrol_meta', 'nosyncroleids', ''),
(1800, 'enrol_meta', 'syncall', '1'),
(1801, 'enrol_meta', 'unenrolaction', '3'),
(1802, 'enrol_meta', 'coursesort', 'sortorder'),
(1803, 'enrol_fee', 'expiredaction', '3'),
(1804, 'enrol_fee', 'status', '1'),
(1805, 'enrol_fee', 'cost', '0'),
(1806, 'enrol_fee', 'currency', 'USD'),
(1807, 'enrol_fee', 'roleid', '5'),
(1808, 'enrol_fee', 'enrolperiod', '0'),
(1809, 'enrol_database', 'dbtype', ''),
(1810, 'enrol_database', 'dbhost', 'localhost'),
(1811, 'enrol_database', 'dbuser', ''),
(1812, 'enrol_database', 'dbpass', ''),
(1813, 'enrol_database', 'dbname', ''),
(1814, 'enrol_database', 'dbencoding', 'utf-8'),
(1815, 'enrol_database', 'dbsetupsql', ''),
(1816, 'enrol_database', 'dbsybasequoting', '0'),
(1817, 'enrol_database', 'debugdb', '0'),
(1818, 'enrol_database', 'localcoursefield', 'idnumber'),
(1819, 'enrol_database', 'localuserfield', 'idnumber'),
(1820, 'enrol_database', 'localrolefield', 'shortname'),
(1821, 'enrol_database', 'localcategoryfield', 'id'),
(1822, 'enrol_database', 'remoteenroltable', ''),
(1823, 'enrol_database', 'remotecoursefield', ''),
(1824, 'enrol_database', 'remoteuserfield', ''),
(1825, 'enrol_database', 'remoterolefield', ''),
(1826, 'enrol_database', 'remoteotheruserfield', ''),
(1827, 'enrol_database', 'defaultrole', '5'),
(1828, 'enrol_database', 'ignorehiddencourses', '0'),
(1829, 'enrol_database', 'unenrolaction', '0'),
(1830, 'enrol_database', 'newcoursetable', ''),
(1831, 'enrol_database', 'newcoursefullname', 'fullname'),
(1832, 'enrol_database', 'newcourseshortname', 'shortname'),
(1833, 'enrol_database', 'newcourseidnumber', 'idnumber'),
(1834, 'enrol_database', 'newcoursestartdate', ''),
(1835, 'enrol_database', 'newcourseenddate', ''),
(1836, 'enrol_database', 'newcoursecategory', ''),
(1837, 'enrol_database', 'defaultcategory', '1'),
(1838, 'enrol_database', 'templatecourse', ''),
(1839, 'enrol_flatfile', 'location', ''),
(1840, 'enrol_flatfile', 'encoding', 'UTF-8'),
(1841, 'enrol_flatfile', 'mailstudents', '0'),
(1842, 'enrol_flatfile', 'mailteachers', '0'),
(1843, 'enrol_flatfile', 'mailadmins', '0'),
(1844, 'enrol_flatfile', 'unenrolaction', '3'),
(1845, 'enrol_flatfile', 'expiredaction', '3'),
(1846, 'enrol_guest', 'requirepassword', '0'),
(1847, 'enrol_guest', 'usepasswordpolicy', '0'),
(1848, 'enrol_guest', 'showhint', '0'),
(1849, 'enrol_guest', 'defaultenrol', '1'),
(1850, 'enrol_guest', 'status', '1'),
(1851, 'enrol_guest', 'status_adv', ''),
(1852, 'enrol_imsenterprise', 'imsfilelocation', ''),
(1853, 'enrol_imsenterprise', 'logtolocation', ''),
(1854, 'enrol_imsenterprise', 'mailadmins', '0'),
(1855, 'enrol_imsenterprise', 'createnewusers', '0'),
(1856, 'enrol_imsenterprise', 'imsupdateusers', '0'),
(1857, 'enrol_imsenterprise', 'imsdeleteusers', '0'),
(1858, 'enrol_imsenterprise', 'fixcaseusernames', '0'),
(1859, 'enrol_imsenterprise', 'fixcasepersonalnames', '0'),
(1860, 'enrol_imsenterprise', 'imssourcedidfallback', '0'),
(1861, 'enrol_imsenterprise', 'imsrolemap01', '5'),
(1862, 'enrol_imsenterprise', 'imsrolemap02', '3'),
(1863, 'enrol_imsenterprise', 'imsrolemap03', '3'),
(1864, 'enrol_imsenterprise', 'imsrolemap04', '5'),
(1865, 'enrol_imsenterprise', 'imsrolemap05', '0'),
(1866, 'enrol_imsenterprise', 'imsrolemap06', '4'),
(1867, 'enrol_imsenterprise', 'imsrolemap07', '0'),
(1868, 'enrol_imsenterprise', 'imsrolemap08', '4'),
(1869, 'enrol_imsenterprise', 'truncatecoursecodes', '0'),
(1870, 'enrol_imsenterprise', 'createnewcourses', '0'),
(1871, 'enrol_imsenterprise', 'updatecourses', '0'),
(1872, 'enrol_imsenterprise', 'createnewcategories', '0'),
(1873, 'enrol_imsenterprise', 'nestedcategories', '0'),
(1874, 'enrol_imsenterprise', 'categoryidnumber', '0'),
(1875, 'enrol_imsenterprise', 'categoryseparator', ''),
(1876, 'enrol_imsenterprise', 'imsunenrol', '0'),
(1877, 'enrol_imsenterprise', 'unenrolaction', '0'),
(1878, 'enrol_imsenterprise', 'imscoursemapshortname', 'coursecode');
INSERT INTO `[[dbprefix]]config_plugins` VALUES
(1879, 'enrol_imsenterprise', 'imscoursemapfullname', 'short'),
(1880, 'enrol_imsenterprise', 'imscoursemapsummary', 'ignore'),
(1881, 'enrol_imsenterprise', 'imsrestricttarget', ''),
(1882, 'enrol_imsenterprise', 'imscapitafix', '0'),
(1883, 'enrol_ldap', 'host_url', ''),
(1884, 'enrol_ldap', 'start_tls', '0'),
(1885, 'enrol_ldap', 'ldap_version', '3'),
(1886, 'enrol_ldap', 'ldapencoding', 'utf-8'),
(1887, 'enrol_ldap', 'pagesize', '250'),
(1888, 'enrol_ldap', 'bind_dn', ''),
(1889, 'enrol_ldap', 'bind_pw', ''),
(1890, 'enrol_ldap', 'course_search_sub', '0'),
(1891, 'enrol_ldap', 'memberattribute_isdn', '0'),
(1892, 'enrol_ldap', 'user_contexts', ''),
(1893, 'enrol_ldap', 'user_search_sub', '0'),
(1894, 'enrol_ldap', 'user_type', 'default'),
(1895, 'enrol_ldap', 'opt_deref', '0'),
(1896, 'enrol_ldap', 'idnumber_attribute', ''),
(1897, 'enrol_ldap', 'objectclass', ''),
(1898, 'enrol_ldap', 'course_idnumber', ''),
(1899, 'enrol_ldap', 'course_shortname', ''),
(1900, 'enrol_ldap', 'course_fullname', ''),
(1901, 'enrol_ldap', 'course_summary', ''),
(1902, 'enrol_ldap', 'ignorehiddencourses', '0'),
(1903, 'enrol_ldap', 'unenrolaction', '0'),
(1904, 'enrol_ldap', 'autocreate', '0'),
(1905, 'enrol_ldap', 'category', '1'),
(1906, 'enrol_ldap', 'template', ''),
(1907, 'enrol_ldap', 'course_shortname_updateonsync', '0'),
(1908, 'enrol_ldap', 'course_fullname_updateonsync', '0'),
(1909, 'enrol_ldap', 'course_summary_updateonsync', '0'),
(1910, 'enrol_ldap', 'nested_groups', '0'),
(1911, 'enrol_ldap', 'group_memberofattribute', ''),
(1912, 'enrol_manual', 'expiredaction', '1'),
(1913, 'enrol_manual', 'expirynotifyhour', '6'),
(1914, 'enrol_manual', 'defaultenrol', '1'),
(1915, 'enrol_manual', 'status', '0'),
(1916, 'enrol_manual', 'roleid', '5'),
(1917, 'enrol_manual', 'enrolstart', '4'),
(1918, 'enrol_manual', 'enrolperiod', '0'),
(1919, 'enrol_manual', 'expirynotify', '0'),
(1920, 'enrol_manual', 'expirythreshold', '86400'),
(1921, 'enrol_manual', 'sendcoursewelcomemessage', '1'),
(1922, 'enrol_paypal', 'paypalbusiness', ''),
(1923, 'enrol_paypal', 'mailstudents', '0'),
(1924, 'enrol_paypal', 'mailteachers', '0'),
(1925, 'enrol_paypal', 'mailadmins', '0'),
(1926, 'enrol_paypal', 'expiredaction', '3'),
(1927, 'enrol_paypal', 'status', '1'),
(1928, 'enrol_paypal', 'cost', '0'),
(1929, 'enrol_paypal', 'currency', 'USD'),
(1930, 'enrol_paypal', 'roleid', '5'),
(1931, 'enrol_paypal', 'enrolperiod', '0'),
(1932, 'enrol_lti', 'emaildisplay', '2'),
(1933, 'enrol_lti', 'city', ''),
(1934, 'enrol_lti', 'country', ''),
(1935, 'enrol_lti', 'timezone', '99'),
(1936, 'enrol_lti', 'lang', 'en'),
(1937, 'enrol_lti', 'institution', ''),
(1938, 'enrol_self', 'requirepassword', '0'),
(1939, 'enrol_self', 'usepasswordpolicy', '0'),
(1940, 'enrol_self', 'showhint', '0'),
(1941, 'enrol_self', 'expiredaction', '1'),
(1942, 'enrol_self', 'expirynotifyhour', '6'),
(1943, 'enrol_self', 'defaultenrol', '1'),
(1944, 'enrol_self', 'status', '1'),
(1945, 'enrol_self', 'newenrols', '1'),
(1946, 'enrol_self', 'groupkey', '0'),
(1947, 'enrol_self', 'roleid', '5'),
(1948, 'enrol_self', 'enrolperiod', '0'),
(1949, 'enrol_self', 'expirynotify', '0'),
(1950, 'enrol_self', 'expirythreshold', '86400'),
(1951, 'enrol_self', 'longtimenosee', '0'),
(1952, 'enrol_self', 'maxenrolled', '0'),
(1953, 'enrol_self', 'sendcoursewelcomemessage', '1'),
(1954, 'filter_urltolink', 'formats', '1,4,0'),
(1955, 'filter_urltolink', 'embedimages', '1'),
(1956, 'filter_emoticon', 'formats', '1,4,0'),
(1957, 'filter_displayh5p', 'allowedsources', ''),
(1958, 'filter_mathjaxloader', 'httpsurl', 'https://cdn.jsdelivr.net/npm/mathjax@3.2.2/es5/tex-mml-chtml.js'),
(1959, 'filter_mathjaxloader', 'texfiltercompatibility', '0'),
(1960, 'filter_mathjaxloader', 'mathjaxconfig', ''),
(1961, 'filter_mathjaxloader', 'additionaldelimiters', ''),
(1962, 'filter_tex', 'latexpreamble', '\\usepackage[latin1]{inputenc}\n\\usepackage{amsmath}\n\\usepackage{amsfonts}\n\\RequirePackage{amsmath,amssymb,latexsym}\n'),
(1963, 'filter_tex', 'latexbackground', '#FFFFFF'),
(1964, 'filter_tex', 'density', '120'),
(1965, 'filter_tex', 'pathlatex', '[[default_filter_tex_pathlatex]]'),
(1966, 'filter_tex', 'pathdvips', '[[default_filter_tex_pathdvips]]'),
(1967, 'filter_tex', 'pathconvert', '[[default_filter_tex_pathconvert]]'),
(1968, 'filter_tex', 'pathdvisvgm', '[[default_filter_tex_dvisvgm]]'),
(1969, 'filter_tex', 'pathmimetex', ''),
(1970, 'filter_tex', 'convertformat', 'gif'),
(1971, 'logstore_database', 'dbdriver', ''),
(1972, 'logstore_database', 'dbhost', ''),
(1973, 'logstore_database', 'dbuser', ''),
(1974, 'logstore_database', 'dbpass', ''),
(1975, 'logstore_database', 'dbname', ''),
(1976, 'logstore_database', 'dbtable', ''),
(1977, 'logstore_database', 'dbpersist', '0'),
(1978, 'logstore_database', 'dbsocket', ''),
(1979, 'logstore_database', 'dbport', ''),
(1980, 'logstore_database', 'dbschema', ''),
(1981, 'logstore_database', 'dbcollation', ''),
(1982, 'logstore_database', 'dbhandlesoptions', '0'),
(1983, 'logstore_database', 'buffersize', '50'),
(1984, 'logstore_database', 'jsonformat', '1'),
(1985, 'logstore_database', 'logguests', '0'),
(1986, 'logstore_database', 'includelevels', '1,2,0'),
(1987, 'logstore_database', 'includeactions', 'c,r,u,d'),
(1988, 'logstore_standard', 'logguests', '1'),
(1989, 'logstore_standard', 'jsonformat', '1'),
(1990, 'logstore_standard', 'loglifetime', '0'),
(1991, 'logstore_standard', 'buffersize', '50'),
(1992, 'mlbackend_python', 'useserver', '0'),
(1993, 'mlbackend_python', 'host', ''),
(1994, 'mlbackend_python', 'port', '0'),
(1995, 'mlbackend_python', 'secure', '0'),
(1996, 'mlbackend_python', 'username', 'default'),
(1997, 'mlbackend_python', 'password', ''),
(1998, 'media_videojs', 'videoextensions', 'html_video,media_source,.f4v,.flv'),
(1999, 'media_videojs', 'audioextensions', 'html_audio'),
(2000, 'media_videojs', 'youtube', '1'),
(2001, 'media_videojs', 'videocssclass', 'video-js'),
(2002, 'media_videojs', 'audiocssclass', 'video-js'),
(2003, 'media_videojs', 'limitsize', '1'),
(2004, 'media_vimeo', 'donottrack', '0'),
(2005, 'media_youtube', 'nocookie', '0'),
(2006, 'paygw_paypal', 'surcharge', '0'),
(2007, 'qtype_multichoice', 'answerhowmany', '1'),
(2008, 'qtype_multichoice', 'shuffleanswers', '1'),
(2009, 'qtype_multichoice', 'answernumbering', 'abc'),
(2010, 'qtype_multichoice', 'showstandardinstruction', '0'),
(2011, 'qtype_ordering', 'defaultanswerformat', '0'),
(2012, 'editor_tiny', 'branding', '1'),
(2013, 'editor_tiny', 'extended_valid_elements', 'script[*],p[*],i[*]'),
(2014, 'editor_tiny', 'package_source', '1'),
(2015, 'editor_tiny', 'package_source_standalone_path', ''),
(2016, 'tiny_equation', 'librarygroup1', '\n\\cdot\n\\times\n\\ast\n\\div\n\\diamond\n\\pm\n\\mp\n\\oplus\n\\ominus\n\\otimes\n\\oslash\n\\odot\n\\circ\n\\bullet\n\\asymp\n\\equiv\n\\subseteq\n\\supseteq\n\\leq\n\\geq\n\\preceq\n\\succeq\n\\sim\n\\simeq\n\\approx\n\\subset\n\\supset\n\\ll\n\\gg\n\\prec\n\\succ\n\\infty\n\\in\n\\ni\n\\forall\n\\exists\n\\neq\n'),
(2017, 'tiny_equation', 'librarygroup2', '\n\\leftarrow\n\\rightarrow\n\\uparrow\n\\downarrow\n\\leftrightarrow\n\\nearrow\n\\searrow\n\\swarrow\n\\nwarrow\n\\Leftarrow\n\\Rightarrow\n\\Uparrow\n\\Downarrow\n\\Leftrightarrow\n'),
(2018, 'tiny_equation', 'librarygroup3', '\n\\alpha\n\\beta\n\\gamma\n\\delta\n\\epsilon\n\\zeta\n\\eta\n\\theta\n\\iota\n\\kappa\n\\lambda\n\\mu\n\\nu\n\\xi\n\\pi\n\\rho\n\\sigma\n\\tau\n\\upsilon\n\\phi\n\\chi\n\\psi\n\\omega\n\\Gamma\n\\Delta\n\\Theta\n\\Lambda\n\\Xi\n\\Pi\n\\Sigma\n\\Upsilon\n\\Phi\n\\Psi\n\\Omega\n'),
(2019, 'tiny_equation', 'librarygroup4', '\n\\sum{a,b}\n\\sqrt[a]{b+c}\n\\int_{a}^{b}{c}\n\\iint_{a}^{b}{c}\n\\iiint_{a}^{b}{c}\n\\oint{a}\n(a)\n[a]\n\\lbrace{a}\\rbrace\n\\left| \\begin{matrix} a_1 & a_2 \\\\ a_3 & a_4 \\end{matrix} \\right|\n\\frac{a}{b+c}\n\\vec{a}\n\\binom {a} {b}\n{a \\brack b}\n{a \\brace b}\n'),
(2020, 'tiny_premium', 'plugin_source', '1'),
(2021, 'tiny_premium', 'apikey', ''),
(2022, 'tiny_recordrtc', 'allowedtypes', 'audio,video'),
(2023, 'tiny_recordrtc', 'audiobitrate', '128000'),
(2024, 'tiny_recordrtc', 'videobitrate', '2500000'),
(2025, 'tiny_recordrtc', 'screenbitrate', '2500000'),
(2026, 'tiny_recordrtc', 'audiotimelimit', '120'),
(2027, 'tiny_recordrtc', 'videotimelimit', '120'),
(2028, 'tiny_recordrtc', 'screentimelimit', '120'),
(2029, 'tiny_recordrtc', 'screensize', '1280,720'),
(2030, 'tiny_recordrtc', 'allowedpausing', '0'),
(2031, 'tiny_recordrtc', 'audiortcformat', '0'),
(2032, 'tool_mobile', 'apppolicy', ''),
(2033, 'tool_mobile', 'typeoflogin', '1'),
(2034, 'tool_mobile', 'autologout', '0'),
(2035, 'tool_mobile', 'autologouttime', '86400'),
(2036, 'tool_mobile', 'qrcodetype', '1'),
(2037, 'tool_mobile', 'qrkeyttl', '600'),
(2038, 'tool_mobile', 'qrsameipcheck', '1'),
(2039, 'tool_mobile', 'forcedurlscheme', 'moodlemobile'),
(2040, 'tool_mobile', 'minimumversion', ''),
(2041, 'tool_mobile', 'autologinmintimebetweenreq', '360'),
(2042, 'tool_mobile', 'enablesmartappbanners', '0'),
(2043, 'tool_mobile', 'iosappid', '633359593'),
(2044, 'tool_mobile', 'androidappid', 'com.moodle.moodlemobile'),
(2045, 'tool_mobile', 'setuplink', 'https://download.moodle.org/mobile'),
(2046, 'tool_mobile', 'forcelogout', '0'),
(2047, 'tool_mobile', 'disabledfeatures', ''),
(2048, 'tool_mobile', 'custommenuitems', ''),
(2049, 'tool_mobile', 'filetypeexclusionlist', ''),
(2050, 'tool_mobile', 'customlangstrings', ''),
(2051, 'tool_moodlenet', 'defaultmoodlenetname', 'MoodleNet Central'),
(2052, 'tool_moodlenet', 'defaultmoodlenet', 'https://moodle.net');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]contentbank_content`
--

CREATE TABLE `[[dbprefix]]contentbank_content` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `contenttype` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `contextid` bigint NOT NULL,
  `visibility` tinyint(1) NOT NULL DEFAULT '1',
  `instanceid` bigint DEFAULT NULL,
  `configdata` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `usercreated` bigint NOT NULL,
  `usermodified` bigint DEFAULT NULL,
  `timecreated` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]contcont_nam_ix` (`name`),
  KEY `[[dbprefix]]contcont_conconins_ix` (`contextid`,`contenttype`,`instanceid`),
  KEY `[[dbprefix]]contcont_con_ix` (`contextid`),
  KEY `[[dbprefix]]contcont_use_ix` (`usermodified`),
  KEY `[[dbprefix]]contcont_use2_ix` (`usercreated`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='This table stores content data in the content bank.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]context`
--

CREATE TABLE `[[dbprefix]]context` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `contextlevel` bigint NOT NULL DEFAULT '0',
  `instanceid` bigint NOT NULL DEFAULT '0',
  `path` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `depth` tinyint NOT NULL DEFAULT '0',
  `locked` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]cont_conins_uix` (`contextlevel`,`instanceid`),
  KEY `[[dbprefix]]cont_ins_ix` (`instanceid`),
  KEY `[[dbprefix]]cont_pat_ix` (`path`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='one of these must be set' AUTO_INCREMENT=14 ;

--
-- Dumping data for table `[[dbprefix]]context`
--

INSERT INTO `[[dbprefix]]context` VALUES
(1, 10, 0, '/1', 1, 0),
(2, 50, 1, '/1/2', 2, 0),
(3, 40, 1, '/1/3', 2, 0),
(4, 30, 1, '/1/4', 2, 0),
(5, 30, 2, '/1/5', 2, 0),
(6, 80, 1, '/1/6', 2, 0),
(7, 80, 2, '/1/7', 2, 0),
(8, 80, 3, '/1/8', 2, 0),
(9, 80, 4, '/1/9', 2, 0),
(10, 80, 5, '/1/10', 2, 0),
(11, 80, 6, '/1/5/11', 3, 0),
(12, 80, 7, '/1/5/12', 3, 0),
(13, 80, 8, '/1/5/13', 3, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]context_temp`
--

CREATE TABLE `[[dbprefix]]context_temp` (
  `id` bigint NOT NULL,
  `path` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `depth` tinyint NOT NULL,
  `locked` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Used by build_context_path() in upgrade and cron to keep con';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]course`
--

CREATE TABLE `[[dbprefix]]course` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `category` bigint NOT NULL DEFAULT '0',
  `sortorder` bigint NOT NULL DEFAULT '0',
  `fullname` varchar(1333) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `shortname` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `idnumber` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `summary` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `summaryformat` tinyint NOT NULL DEFAULT '0',
  `format` varchar(21) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT 'topics',
  `showgrades` tinyint NOT NULL DEFAULT '1',
  `newsitems` mediumint NOT NULL DEFAULT '1',
  `startdate` bigint NOT NULL DEFAULT '0',
  `enddate` bigint NOT NULL DEFAULT '0',
  `relativedatesmode` tinyint(1) NOT NULL DEFAULT '0',
  `marker` bigint NOT NULL DEFAULT '0',
  `maxbytes` bigint NOT NULL DEFAULT '0',
  `legacyfiles` smallint NOT NULL DEFAULT '0',
  `showreports` smallint NOT NULL DEFAULT '0',
  `visible` tinyint(1) NOT NULL DEFAULT '1',
  `visibleold` tinyint(1) NOT NULL DEFAULT '1',
  `downloadcontent` tinyint(1) DEFAULT NULL,
  `groupmode` smallint NOT NULL DEFAULT '0',
  `groupmodeforce` smallint NOT NULL DEFAULT '0',
  `defaultgroupingid` bigint NOT NULL DEFAULT '0',
  `lang` varchar(30) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `calendartype` varchar(30) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `theme` varchar(50) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `timecreated` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  `requested` tinyint(1) NOT NULL DEFAULT '0',
  `enablecompletion` tinyint(1) NOT NULL DEFAULT '0',
  `completionnotify` tinyint(1) NOT NULL DEFAULT '0',
  `cacherev` bigint NOT NULL DEFAULT '0',
  `originalcourseid` bigint DEFAULT NULL,
  `showactivitydates` tinyint(1) NOT NULL DEFAULT '0',
  `showcompletionconditions` tinyint(1) DEFAULT NULL,
  `pdfexportfont` varchar(50) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `enableaitools` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]cour_cat_ix` (`category`),
  KEY `[[dbprefix]]cour_idn_ix` (`idnumber`),
  KEY `[[dbprefix]]cour_sho_ix` (`shortname`),
  KEY `[[dbprefix]]cour_sor_ix` (`sortorder`),
  KEY `[[dbprefix]]cour_ori_ix` (`originalcourseid`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Central course table' AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]course`
--

INSERT INTO `[[dbprefix]]course` VALUES
(1, 0, 0, '[[site_name]]', '[[site_desc]]', '', '', 0, 'site', 1, 3, 0, 0, 0, 0, 0, 0, 0, 1, 1, NULL, 0, 0, 0, '', '', '', [[timestamp]], [[timestamp]], 0, 0, 0, [[timestamp]], NULL, 0, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]course_categories`
--

CREATE TABLE `[[dbprefix]]course_categories` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `idnumber` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `description` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `descriptionformat` tinyint NOT NULL DEFAULT '0',
  `parent` bigint NOT NULL DEFAULT '0',
  `sortorder` bigint NOT NULL DEFAULT '0',
  `coursecount` bigint NOT NULL DEFAULT '0',
  `visible` tinyint(1) NOT NULL DEFAULT '1',
  `visibleold` tinyint(1) NOT NULL DEFAULT '1',
  `timemodified` bigint NOT NULL DEFAULT '0',
  `depth` bigint NOT NULL DEFAULT '0',
  `path` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `theme` varchar(50) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]courcate_par_ix` (`parent`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Course categories' AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]course_categories`
--

INSERT INTO `[[dbprefix]]course_categories` VALUES
(1, 'Category 1', NULL, NULL, 1, 0, 10000, 0, 1, 1, [[timestamp]], 1, '/1', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]course_completions`
--

CREATE TABLE `[[dbprefix]]course_completions` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `userid` bigint NOT NULL DEFAULT '0',
  `course` bigint NOT NULL DEFAULT '0',
  `timeenrolled` bigint NOT NULL DEFAULT '0',
  `timestarted` bigint NOT NULL DEFAULT '0',
  `timecompleted` bigint DEFAULT NULL,
  `reaggregate` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]courcomp_usecou_uix` (`userid`,`course`),
  KEY `[[dbprefix]]courcomp_use_ix` (`userid`),
  KEY `[[dbprefix]]courcomp_cou_ix` (`course`),
  KEY `[[dbprefix]]courcomp_tim_ix` (`timecompleted`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Course completion records' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]course_completion_aggr_methd`
--

CREATE TABLE `[[dbprefix]]course_completion_aggr_methd` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `course` bigint NOT NULL DEFAULT '0',
  `criteriatype` bigint DEFAULT NULL,
  `method` tinyint(1) NOT NULL DEFAULT '0',
  `value` decimal(10,5) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]courcompaggrmeth_cou_uix` (`course`,`criteriatype`),
  KEY `[[dbprefix]]courcompaggrmeth_cou_ix` (`course`),
  KEY `[[dbprefix]]courcompaggrmeth_cri_ix` (`criteriatype`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Course completion aggregation methods for criteria';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]course_completion_criteria`
--

CREATE TABLE `[[dbprefix]]course_completion_criteria` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `course` bigint NOT NULL DEFAULT '0',
  `criteriatype` bigint NOT NULL DEFAULT '0',
  `module` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `moduleinstance` bigint DEFAULT NULL,
  `courseinstance` bigint DEFAULT NULL,
  `enrolperiod` bigint DEFAULT NULL,
  `timeend` bigint DEFAULT NULL,
  `gradepass` decimal(10,5) DEFAULT NULL,
  `role` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]courcompcrit_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Course completion criteria' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]course_completion_crit_compl`
--

CREATE TABLE `[[dbprefix]]course_completion_crit_compl` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `userid` bigint NOT NULL DEFAULT '0',
  `course` bigint NOT NULL DEFAULT '0',
  `criteriaid` bigint NOT NULL DEFAULT '0',
  `gradefinal` decimal(10,5) DEFAULT NULL,
  `unenroled` bigint DEFAULT NULL,
  `timecompleted` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]courcompcritcomp_use_uix` (`userid`,`course`,`criteriaid`),
  KEY `[[dbprefix]]courcompcritcomp_use_ix` (`userid`),
  KEY `[[dbprefix]]courcompcritcomp_cou_ix` (`course`),
  KEY `[[dbprefix]]courcompcritcomp_cri_ix` (`criteriaid`),
  KEY `[[dbprefix]]courcompcritcomp_tim_ix` (`timecompleted`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Course completion user records' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]course_completion_defaults`
--

CREATE TABLE `[[dbprefix]]course_completion_defaults` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `course` bigint NOT NULL,
  `module` bigint NOT NULL,
  `completion` tinyint(1) NOT NULL DEFAULT '0',
  `completionview` tinyint(1) NOT NULL DEFAULT '0',
  `completionusegrade` tinyint(1) NOT NULL DEFAULT '0',
  `completionpassgrade` tinyint(1) NOT NULL DEFAULT '0',
  `completionexpected` bigint NOT NULL DEFAULT '0',
  `customrules` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]courcompdefa_coumod_uix` (`course`,`module`),
  KEY `[[dbprefix]]courcompdefa_mod_ix` (`module`),
  KEY `[[dbprefix]]courcompdefa_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Default settings for activities completion';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]course_format_options`
--

CREATE TABLE `[[dbprefix]]course_format_options` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `courseid` bigint NOT NULL,
  `format` varchar(21) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `sectionid` bigint NOT NULL DEFAULT '0',
  `name` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `value` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]courformopti_coufors_uix` (`courseid`,`format`,`sectionid`,`name`),
  KEY `[[dbprefix]]courformopti_cou_ix` (`courseid`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores format-specific options for the course or course sect' AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]course_format_options`
--

INSERT INTO `[[dbprefix]]course_format_options` VALUES
(1, 1, 'site', 0, 'numsections', '1');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]course_modules`
--

CREATE TABLE `[[dbprefix]]course_modules` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `course` bigint NOT NULL DEFAULT '0',
  `module` bigint NOT NULL DEFAULT '0',
  `instance` bigint NOT NULL DEFAULT '0',
  `section` bigint NOT NULL DEFAULT '0',
  `idnumber` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `added` bigint NOT NULL DEFAULT '0',
  `score` smallint NOT NULL DEFAULT '0',
  `indent` mediumint NOT NULL DEFAULT '0',
  `visible` tinyint(1) NOT NULL DEFAULT '1',
  `visibleoncoursepage` tinyint(1) NOT NULL DEFAULT '1',
  `visibleold` tinyint(1) NOT NULL DEFAULT '1',
  `groupmode` smallint NOT NULL DEFAULT '0',
  `groupingid` bigint NOT NULL DEFAULT '0',
  `completion` tinyint(1) NOT NULL DEFAULT '0',
  `completiongradeitemnumber` bigint DEFAULT NULL,
  `completionview` tinyint(1) NOT NULL DEFAULT '0',
  `completionexpected` bigint NOT NULL DEFAULT '0',
  `completionpassgrade` tinyint(1) NOT NULL DEFAULT '0',
  `showdescription` tinyint(1) NOT NULL DEFAULT '0',
  `availability` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `deletioninprogress` tinyint(1) NOT NULL DEFAULT '0',
  `downloadcontent` tinyint(1) DEFAULT '1',
  `lang` varchar(30) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `enableaitools` tinyint(1) DEFAULT NULL,
  `enabledaiactions` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]courmodu_vis_ix` (`visible`),
  KEY `[[dbprefix]]courmodu_cou_ix` (`course`),
  KEY `[[dbprefix]]courmodu_mod_ix` (`module`),
  KEY `[[dbprefix]]courmodu_ins_ix` (`instance`),
  KEY `[[dbprefix]]courmodu_idncou_ix` (`idnumber`,`course`),
  KEY `[[dbprefix]]courmodu_gro_ix` (`groupingid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='course_modules table retrofitted from MySQL' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]course_modules_completion`
--

CREATE TABLE `[[dbprefix]]course_modules_completion` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `coursemoduleid` bigint NOT NULL,
  `userid` bigint NOT NULL,
  `completionstate` tinyint(1) NOT NULL,
  `overrideby` bigint DEFAULT NULL,
  `timemodified` bigint NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]courmoducomp_usecou_uix` (`userid`,`coursemoduleid`),
  KEY `[[dbprefix]]courmoducomp_cou_ix` (`coursemoduleid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores the completion state (completed or not completed, etc' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]course_modules_viewed`
--

CREATE TABLE `[[dbprefix]]course_modules_viewed` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `coursemoduleid` bigint NOT NULL,
  `userid` bigint NOT NULL,
  `timecreated` bigint NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]courmoduview_usecou_uix` (`userid`,`coursemoduleid`),
  KEY `[[dbprefix]]courmoduview_cou_ix` (`coursemoduleid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Tracks the completion viewed (viewed with cmid/userid and ot';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]course_published`
--

CREATE TABLE `[[dbprefix]]course_published` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `huburl` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `courseid` bigint NOT NULL,
  `timepublished` bigint NOT NULL,
  `enrollable` tinyint(1) NOT NULL DEFAULT '1',
  `hubcourseid` bigint NOT NULL,
  `status` tinyint(1) DEFAULT '0',
  `timechecked` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]courpubl_hub_ix` (`hubcourseid`),
  KEY `[[dbprefix]]courpubl_cou_ix` (`courseid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Information about how and when an local courses were publish';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]course_request`
--

CREATE TABLE `[[dbprefix]]course_request` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `fullname` varchar(1333) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `shortname` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `summary` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `summaryformat` tinyint NOT NULL DEFAULT '0',
  `category` bigint NOT NULL DEFAULT '0',
  `reason` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `requester` bigint NOT NULL DEFAULT '0',
  `password` varchar(50) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]courrequ_sho_ix` (`shortname`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='course requests';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]course_sections`
--

CREATE TABLE `[[dbprefix]]course_sections` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `course` bigint NOT NULL DEFAULT '0',
  `section` bigint NOT NULL DEFAULT '0',
  `name` varchar(1333) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `summary` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `summaryformat` tinyint NOT NULL DEFAULT '0',
  `sequence` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `visible` tinyint(1) NOT NULL DEFAULT '1',
  `availability` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `component` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `itemid` bigint DEFAULT NULL,
  `timemodified` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]coursect_cousec_uix` (`course`,`section`),
  KEY `[[dbprefix]]coursect_comite_ix` (`component`,`itemid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='to define the sections for each course' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]customfield_category`
--

CREATE TABLE `[[dbprefix]]customfield_category` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(1333) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `description` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `descriptionformat` bigint DEFAULT NULL,
  `sortorder` bigint DEFAULT NULL,
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  `component` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `area` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `itemid` bigint NOT NULL DEFAULT '0',
  `contextid` bigint DEFAULT NULL,
  `shared` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]custcate_comareitesor_ix` (`component`,`area`,`itemid`,`sortorder`),
  KEY `[[dbprefix]]custcate_con_ix` (`contextid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='core_customfield category table' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]customfield_data`
--

CREATE TABLE `[[dbprefix]]customfield_data` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `fieldid` bigint NOT NULL,
  `instanceid` bigint NOT NULL,
  `intvalue` bigint DEFAULT NULL,
  `decvalue` decimal(10,5) DEFAULT NULL,
  `shortcharvalue` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `charvalue` varchar(1333) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `value` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `valueformat` bigint NOT NULL,
  `valuetrust` tinyint NOT NULL DEFAULT '0',
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  `contextid` bigint DEFAULT NULL,
  `component` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `area` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `itemid` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]custdata_insfiecomar_uix` (`instanceid`,`fieldid`,`component`,`area`,`itemid`),
  KEY `[[dbprefix]]custdata_fieint_ix` (`fieldid`,`intvalue`),
  KEY `[[dbprefix]]custdata_fiesho_ix` (`fieldid`,`shortcharvalue`),
  KEY `[[dbprefix]]custdata_fiedec_ix` (`fieldid`,`decvalue`),
  KEY `[[dbprefix]]custdata_fie_ix` (`fieldid`),
  KEY `[[dbprefix]]custdata_con_ix` (`contextid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='core_customfield data table';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]customfield_field`
--

CREATE TABLE `[[dbprefix]]customfield_field` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `shortname` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `name` varchar(1333) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `type` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `description` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `descriptionformat` bigint DEFAULT NULL,
  `sortorder` bigint DEFAULT NULL,
  `categoryid` bigint DEFAULT NULL,
  `configdata` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]custfiel_catsor_ix` (`categoryid`,`sortorder`),
  KEY `[[dbprefix]]custfiel_cat_ix` (`categoryid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='core_customfield field table' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]customfield_shared`
--

CREATE TABLE `[[dbprefix]]customfield_shared` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `categoryid` bigint NOT NULL,
  `component` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `area` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `itemid` bigint NOT NULL DEFAULT '0',
  `usermodified` bigint NOT NULL DEFAULT '0',
  `timecreated` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]custshar_catcomareit_uix` (`categoryid`,`component`,`area`,`itemid`),
  KEY `[[dbprefix]]custshar_cat_ix` (`categoryid`),
  KEY `[[dbprefix]]custshar_use_ix` (`usermodified`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='core_customfield shared category table';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]data`
--

CREATE TABLE `[[dbprefix]]data` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `course` bigint NOT NULL DEFAULT '0',
  `name` varchar(1333) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `intro` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `introformat` smallint NOT NULL DEFAULT '0',
  `comments` smallint NOT NULL DEFAULT '0',
  `timeavailablefrom` bigint NOT NULL DEFAULT '0',
  `timeavailableto` bigint NOT NULL DEFAULT '0',
  `timeviewfrom` bigint NOT NULL DEFAULT '0',
  `timeviewto` bigint NOT NULL DEFAULT '0',
  `requiredentries` int NOT NULL DEFAULT '0',
  `requiredentriestoview` int NOT NULL DEFAULT '0',
  `maxentries` int NOT NULL DEFAULT '0',
  `rssarticles` smallint NOT NULL DEFAULT '0',
  `singletemplate` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `listtemplate` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `listtemplateheader` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `listtemplatefooter` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `addtemplate` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `rsstemplate` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `rsstitletemplate` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `csstemplate` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `jstemplate` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `asearchtemplate` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `approval` smallint NOT NULL DEFAULT '0',
  `manageapproved` smallint NOT NULL DEFAULT '1',
  `scale` bigint NOT NULL DEFAULT '0',
  `assessed` bigint NOT NULL DEFAULT '0',
  `assesstimestart` bigint NOT NULL DEFAULT '0',
  `assesstimefinish` bigint NOT NULL DEFAULT '0',
  `defaultsort` bigint NOT NULL DEFAULT '0',
  `defaultsortdir` smallint NOT NULL DEFAULT '0',
  `editany` smallint NOT NULL DEFAULT '0',
  `notification` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  `config` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `completionentries` bigint DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]data_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='all database activities';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]data_content`
--

CREATE TABLE `[[dbprefix]]data_content` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `fieldid` bigint NOT NULL DEFAULT '0',
  `recordid` bigint NOT NULL DEFAULT '0',
  `content` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `content1` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `content2` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `content3` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `content4` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]datacont_rec_ix` (`recordid`),
  KEY `[[dbprefix]]datacont_fie_ix` (`fieldid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='the content introduced in each record/fields';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]data_fields`
--

CREATE TABLE `[[dbprefix]]data_fields` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `dataid` bigint NOT NULL DEFAULT '0',
  `type` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `name` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `description` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `required` tinyint(1) NOT NULL DEFAULT '0',
  `param1` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `param2` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `param3` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `param4` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `param5` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `param6` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `param7` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `param8` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `param9` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `param10` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]datafiel_typdat_ix` (`type`,`dataid`),
  KEY `[[dbprefix]]datafiel_dat_ix` (`dataid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='every field available';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]data_records`
--

CREATE TABLE `[[dbprefix]]data_records` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `userid` bigint NOT NULL DEFAULT '0',
  `groupid` bigint NOT NULL DEFAULT '0',
  `dataid` bigint NOT NULL DEFAULT '0',
  `timecreated` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  `approved` smallint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]datareco_dat_ix` (`dataid`),
  KEY `[[dbprefix]]datareco_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='every record introduced';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]enrol`
--

CREATE TABLE `[[dbprefix]]enrol` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `enrol` varchar(20) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `status` bigint NOT NULL DEFAULT '0',
  `courseid` bigint NOT NULL,
  `sortorder` bigint NOT NULL DEFAULT '0',
  `name` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `enrolperiod` bigint DEFAULT '0',
  `enrolstartdate` bigint DEFAULT '0',
  `enrolenddate` bigint DEFAULT '0',
  `expirynotify` tinyint(1) DEFAULT '0',
  `expirythreshold` bigint DEFAULT '0',
  `notifyall` tinyint(1) DEFAULT '0',
  `password` varchar(50) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `cost` varchar(20) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `currency` varchar(3) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `roleid` bigint DEFAULT '0',
  `customint1` bigint DEFAULT NULL,
  `customint2` bigint DEFAULT NULL,
  `customint3` bigint DEFAULT NULL,
  `customint4` bigint DEFAULT NULL,
  `customint5` bigint DEFAULT NULL,
  `customint6` bigint DEFAULT NULL,
  `customint7` bigint DEFAULT NULL,
  `customint8` bigint DEFAULT NULL,
  `customchar1` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `customchar2` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `customchar3` varchar(1333) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `customdec1` decimal(12,7) DEFAULT NULL,
  `customdec2` decimal(12,7) DEFAULT NULL,
  `customtext1` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `customtext2` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `customtext3` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `customtext4` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `timecreated` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]enro_enr_ix` (`enrol`),
  KEY `[[dbprefix]]enro_cou_ix` (`courseid`),
  KEY `[[dbprefix]]enro_rol_ix` (`roleid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Instances of enrolment plugins used in courses, fields marke' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]enrol_flatfile`
--

CREATE TABLE `[[dbprefix]]enrol_flatfile` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `action` varchar(30) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `roleid` bigint NOT NULL,
  `userid` bigint NOT NULL,
  `courseid` bigint NOT NULL,
  `timestart` bigint NOT NULL DEFAULT '0',
  `timeend` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]enroflat_cou_ix` (`courseid`),
  KEY `[[dbprefix]]enroflat_use_ix` (`userid`),
  KEY `[[dbprefix]]enroflat_rol_ix` (`roleid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='enrol_flatfile table retrofitted from MySQL';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]enrol_lti_app_registration`
--

CREATE TABLE `[[dbprefix]]enrol_lti_app_registration` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `platformid` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `clientid` varchar(1333) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `uniqueid` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `platformclienthash` varchar(64) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `platformuniqueidhash` varchar(64) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `authenticationrequesturl` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `jwksurl` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `accesstokenurl` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]enroltiappregi_uni_uix` (`uniqueid`),
  UNIQUE KEY `[[dbprefix]]enroltiappregi_pla_uix` (`platformclienthash`),
  UNIQUE KEY `[[dbprefix]]enroltiappregi_pla2_uix` (`platformuniqueidhash`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Details of each application that has been registered with th';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]enrol_lti_context`
--

CREATE TABLE `[[dbprefix]]enrol_lti_context` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `contextid` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `ltideploymentid` bigint NOT NULL,
  `type` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]enrolticont_lticon_uix` (`ltideploymentid`,`contextid`),
  KEY `[[dbprefix]]enrolticont_lti_ix` (`ltideploymentid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Each row represents a context in the platform, where resourc';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]enrol_lti_deployment`
--

CREATE TABLE `[[dbprefix]]enrol_lti_deployment` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `deploymentid` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `platformid` bigint NOT NULL,
  `legacyconsumerkey` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]enroltidepl_pladep_uix` (`platformid`,`deploymentid`),
  KEY `[[dbprefix]]enroltidepl_pla_ix` (`platformid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Each row represents a deployment of a tool within a platform';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]enrol_lti_lti2_consumer`
--

CREATE TABLE `[[dbprefix]]enrol_lti_lti2_consumer` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(50) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `consumerkey256` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `consumerkey` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `secret` varchar(1024) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `ltiversion` varchar(10) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `consumername` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `consumerversion` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `consumerguid` varchar(1024) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `profile` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `toolproxy` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `settings` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `protected` tinyint(1) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `enablefrom` bigint DEFAULT NULL,
  `enableuntil` bigint DEFAULT NULL,
  `lastaccess` bigint DEFAULT NULL,
  `created` bigint NOT NULL,
  `updated` bigint NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]enroltilti2cons_con_uix` (`consumerkey256`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='LTI consumers interacting with moodle';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]enrol_lti_lti2_context`
--

CREATE TABLE `[[dbprefix]]enrol_lti_lti2_context` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `consumerid` bigint NOT NULL,
  `lticontextkey` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `type` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `settings` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `created` bigint NOT NULL,
  `updated` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]enroltilti2cont_con_ix` (`consumerid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Information about a specific LTI contexts from the consumers';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]enrol_lti_lti2_nonce`
--

CREATE TABLE `[[dbprefix]]enrol_lti_lti2_nonce` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `consumerid` bigint NOT NULL,
  `value` varchar(64) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `expires` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]enroltilti2nonc_con_ix` (`consumerid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Nonce used for authentication between moodle and a consumer';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]enrol_lti_lti2_resource_link`
--

CREATE TABLE `[[dbprefix]]enrol_lti_lti2_resource_link` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `contextid` bigint DEFAULT NULL,
  `consumerid` bigint DEFAULT NULL,
  `ltiresourcelinkkey` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `settings` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `primaryresourcelinkid` bigint DEFAULT NULL,
  `shareapproved` tinyint(1) DEFAULT NULL,
  `created` bigint NOT NULL,
  `updated` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]enroltilti2resolink_c_ix` (`contextid`),
  KEY `[[dbprefix]]enroltilti2resolink_p_ix` (`primaryresourcelinkid`),
  KEY `[[dbprefix]]enroltilti2resolink_2_ix` (`consumerid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Link from the consumer to the tool';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]enrol_lti_lti2_share_key`
--

CREATE TABLE `[[dbprefix]]enrol_lti_lti2_share_key` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `sharekey` varchar(32) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `resourcelinkid` bigint NOT NULL,
  `autoapprove` tinyint(1) NOT NULL,
  `expires` bigint NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]enroltilti2sharkey_s_uix` (`sharekey`),
  UNIQUE KEY `[[dbprefix]]enroltilti2sharkey_r_uix` (`resourcelinkid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Resource link share key';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]enrol_lti_lti2_tool_proxy`
--

CREATE TABLE `[[dbprefix]]enrol_lti_lti2_tool_proxy` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `toolproxykey` varchar(32) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `consumerid` bigint NOT NULL,
  `toolproxy` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `created` bigint NOT NULL,
  `updated` bigint NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]enroltilti2toolprox__uix` (`toolproxykey`),
  KEY `[[dbprefix]]enroltilti2toolprox_c_ix` (`consumerid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='A tool proxy between moodle and a consumer';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]enrol_lti_lti2_user_result`
--

CREATE TABLE `[[dbprefix]]enrol_lti_lti2_user_result` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `resourcelinkid` bigint NOT NULL,
  `ltiuserkey` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `ltiresultsourcedid` varchar(1024) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `created` bigint NOT NULL,
  `updated` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]enroltilti2userresu_r_ix` (`resourcelinkid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Results for each user for each resource link';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]enrol_lti_resource_link`
--

CREATE TABLE `[[dbprefix]]enrol_lti_resource_link` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `resourcelinkid` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `ltideploymentid` bigint NOT NULL,
  `resourceid` bigint NOT NULL,
  `lticontextid` bigint DEFAULT NULL,
  `lineitemsservice` varchar(1333) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `lineitemservice` varchar(1333) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `lineitemscope` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `resultscope` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `scorescope` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `contextmembershipsurl` varchar(1333) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `nrpsserviceversions` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]enroltiresolink_resl_uix` (`resourcelinkid`,`ltideploymentid`),
  KEY `[[dbprefix]]enroltiresolink_lti_ix` (`ltideploymentid`),
  KEY `[[dbprefix]]enroltiresolink_lti2_ix` (`lticontextid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Each row represents a resource link for a platform and deplo';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]enrol_lti_tools`
--

CREATE TABLE `[[dbprefix]]enrol_lti_tools` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `enrolid` bigint NOT NULL,
  `contextid` bigint NOT NULL,
  `ltiversion` varchar(15) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT 'LTI-1p3',
  `institution` varchar(40) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `lang` varchar(30) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT 'en',
  `timezone` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '99',
  `maxenrolled` bigint NOT NULL DEFAULT '0',
  `maildisplay` tinyint NOT NULL DEFAULT '2',
  `city` varchar(120) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `country` varchar(2) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `gradesync` tinyint(1) NOT NULL DEFAULT '0',
  `gradesynccompletion` tinyint(1) NOT NULL DEFAULT '0',
  `membersync` tinyint(1) NOT NULL DEFAULT '0',
  `membersyncmode` tinyint(1) NOT NULL DEFAULT '0',
  `roleinstructor` bigint NOT NULL,
  `rolelearner` bigint NOT NULL,
  `secret` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `uuid` varchar(36) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `provisioningmodelearner` tinyint DEFAULT NULL,
  `provisioningmodeinstructor` tinyint DEFAULT NULL,
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]enroltitool_uui_uix` (`uuid`),
  KEY `[[dbprefix]]enroltitool_enr_ix` (`enrolid`),
  KEY `[[dbprefix]]enroltitool_con_ix` (`contextid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='List of tools provided to the remote system';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]enrol_lti_tool_consumer_map`
--

CREATE TABLE `[[dbprefix]]enrol_lti_tool_consumer_map` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `toolid` bigint NOT NULL,
  `consumerid` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]enroltitoolconsmap_to_ix` (`toolid`),
  KEY `[[dbprefix]]enroltitoolconsmap_co_ix` (`consumerid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Table that maps the published tool to tool consumers.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]enrol_lti_users`
--

CREATE TABLE `[[dbprefix]]enrol_lti_users` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `userid` bigint NOT NULL,
  `toolid` bigint NOT NULL,
  `serviceurl` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `sourceid` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `ltideploymentid` bigint DEFAULT NULL,
  `consumerkey` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `consumersecret` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `membershipsurl` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `membershipsid` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `lastgrade` decimal(10,5) DEFAULT NULL,
  `lastaccess` bigint DEFAULT NULL,
  `timecreated` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]enroltiuser_use_ix` (`userid`),
  KEY `[[dbprefix]]enroltiuser_too_ix` (`toolid`),
  KEY `[[dbprefix]]enroltiuser_lti_ix` (`ltideploymentid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='User access log and gradeback data';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]enrol_lti_user_resource_link`
--

CREATE TABLE `[[dbprefix]]enrol_lti_user_resource_link` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `ltiuserid` bigint NOT NULL,
  `resourcelinkid` bigint NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]enroltiuserresolink__uix` (`ltiuserid`,`resourcelinkid`),
  KEY `[[dbprefix]]enroltiuserresolink_l_ix` (`ltiuserid`),
  KEY `[[dbprefix]]enroltiuserresolink_r_ix` (`resourcelinkid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Join table mapping users to resource links as this is a many';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]enrol_paypal`
--

CREATE TABLE `[[dbprefix]]enrol_paypal` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `business` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `receiver_email` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `receiver_id` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `item_name` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `courseid` bigint NOT NULL DEFAULT '0',
  `userid` bigint NOT NULL DEFAULT '0',
  `instanceid` bigint NOT NULL DEFAULT '0',
  `memo` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `tax` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `option_name1` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `option_selection1_x` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `option_name2` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `option_selection2_x` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `payment_status` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `pending_reason` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `reason_code` varchar(30) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `txn_id` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `parent_txn_id` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `payment_type` varchar(30) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `timeupdated` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]enropayp_bus_ix` (`business`),
  KEY `[[dbprefix]]enropayp_rec_ix` (`receiver_email`),
  KEY `[[dbprefix]]enropayp_cou_ix` (`courseid`),
  KEY `[[dbprefix]]enropayp_use_ix` (`userid`),
  KEY `[[dbprefix]]enropayp_ins_ix` (`instanceid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Holds all known information about PayPal transactions';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]event`
--

CREATE TABLE `[[dbprefix]]event` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `description` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `format` smallint NOT NULL DEFAULT '0',
  `categoryid` bigint NOT NULL DEFAULT '0',
  `courseid` bigint NOT NULL DEFAULT '0',
  `groupid` bigint NOT NULL DEFAULT '0',
  `userid` bigint NOT NULL DEFAULT '0',
  `repeatid` bigint NOT NULL DEFAULT '0',
  `component` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `modulename` varchar(20) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `instance` bigint NOT NULL DEFAULT '0',
  `type` smallint NOT NULL DEFAULT '0',
  `eventtype` varchar(20) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `timestart` bigint NOT NULL DEFAULT '0',
  `timeduration` bigint NOT NULL DEFAULT '0',
  `timesort` bigint DEFAULT NULL,
  `visible` smallint NOT NULL DEFAULT '1',
  `uuid` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `sequence` bigint NOT NULL DEFAULT '1',
  `timemodified` bigint NOT NULL DEFAULT '0',
  `subscriptionid` bigint DEFAULT NULL,
  `priority` bigint DEFAULT NULL,
  `location` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]even_cou_ix` (`courseid`),
  KEY `[[dbprefix]]even_use_ix` (`userid`),
  KEY `[[dbprefix]]even_tim_ix` (`timestart`),
  KEY `[[dbprefix]]even_tim2_ix` (`timeduration`),
  KEY `[[dbprefix]]even_uui_ix` (`uuid`),
  KEY `[[dbprefix]]even_typtim_ix` (`type`,`timesort`),
  KEY `[[dbprefix]]even_grocoucatvisuse_ix` (`groupid`,`courseid`,`categoryid`,`visible`,`userid`),
  KEY `[[dbprefix]]even_eve_ix` (`eventtype`),
  KEY `[[dbprefix]]even_comeveins_ix` (`component`,`eventtype`,`instance`),
  KEY `[[dbprefix]]even_modinseve_ix` (`modulename`,`instance`,`eventtype`),
  KEY `[[dbprefix]]even_cat_ix` (`categoryid`),
  KEY `[[dbprefix]]even_sub_ix` (`subscriptionid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='For everything with a time associated to it' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]events_handlers`
--

CREATE TABLE `[[dbprefix]]events_handlers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `eventname` varchar(166) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `component` varchar(166) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `handlerfile` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `handlerfunction` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `schedule` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `status` bigint NOT NULL DEFAULT '0',
  `internal` tinyint NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]evenhand_evecom_uix` (`eventname`,`component`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='This table is for storing which components requests what typ';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]events_queue`
--

CREATE TABLE `[[dbprefix]]events_queue` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `eventdata` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `stackdump` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `userid` bigint DEFAULT NULL,
  `timecreated` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]evenqueu_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='This table is for storing queued events. It stores only one ';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]events_queue_handlers`
--

CREATE TABLE `[[dbprefix]]events_queue_handlers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `queuedeventid` bigint NOT NULL,
  `handlerid` bigint NOT NULL,
  `status` bigint DEFAULT NULL,
  `errormessage` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `timemodified` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]evenqueuhand_que_ix` (`queuedeventid`),
  KEY `[[dbprefix]]evenqueuhand_han_ix` (`handlerid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='This is the list of queued handlers for processing. The even';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]event_subscriptions`
--

CREATE TABLE `[[dbprefix]]event_subscriptions` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `url` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `categoryid` bigint NOT NULL DEFAULT '0',
  `courseid` bigint NOT NULL DEFAULT '0',
  `groupid` bigint NOT NULL DEFAULT '0',
  `userid` bigint NOT NULL DEFAULT '0',
  `eventtype` varchar(20) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `pollinterval` bigint NOT NULL DEFAULT '0',
  `lastupdated` bigint DEFAULT NULL,
  `name` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]evensubs_cou_ix` (`courseid`),
  KEY `[[dbprefix]]evensubs_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Tracks subscriptions to remote calendars.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]external_functions`
--

CREATE TABLE `[[dbprefix]]external_functions` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(200) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `classname` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `methodname` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `classpath` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `component` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `capabilities` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `services` varchar(1333) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]extefunc_nam_uix` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='list of all external functions' AUTO_INCREMENT=761 ;

--
-- Dumping data for table `[[dbprefix]]external_functions`
--

INSERT INTO `[[dbprefix]]external_functions` VALUES
(1, 'core_auth_confirm_user', 'core_auth_external', 'confirm_user', NULL, 'moodle', '', NULL),
(2, 'core_auth_request_password_reset', 'core_auth_external', 'request_password_reset', NULL, 'moodle', '', NULL),
(3, 'core_auth_is_minor', 'core_auth_external', 'is_minor', NULL, 'moodle', '', NULL),
(4, 'core_auth_is_age_digital_consent_verification_enabled', 'core_auth_external', 'is_age_digital_consent_verification_enabled', NULL, 'moodle', '', NULL),
(5, 'core_auth_resend_confirmation_email', 'core_auth_external', 'resend_confirmation_email', NULL, 'moodle', '', NULL),
(6, 'core_backup_get_async_backup_progress', 'core_backup_external', 'get_async_backup_progress', 'backup/externallib.php', 'moodle', '', NULL),
(7, 'core_backup_get_async_backup_links_backup', 'core_backup_external', 'get_async_backup_links_backup', 'backup/externallib.php', 'moodle', '', NULL),
(8, 'core_backup_get_async_backup_links_restore', 'core_backup_external', 'get_async_backup_links_restore', 'backup/externallib.php', 'moodle', '', NULL),
(9, 'core_backup_get_copy_progress', 'core_backup_external', 'get_copy_progress', 'backup/externallib.php', 'moodle', '', NULL),
(10, 'core_backup_submit_copy_form', 'core_backup_external', 'submit_copy_form', 'backup/externallib.php', 'moodle', '', NULL),
(11, 'core_badges_disable_badges', 'core_badges\\external\\disable_badges', 'execute', NULL, 'moodle', '', NULL),
(12, 'core_badges_enable_badges', 'core_badges\\external\\enable_badges', 'execute', NULL, 'moodle', '', NULL),
(13, 'core_badges_get_badge', 'core_badges\\external\\get_badge', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(14, 'core_badges_get_user_badges', 'core_badges_external', 'get_user_badges', NULL, 'moodle', 'moodle/badges:viewotherbadges', 'moodle_mobile_app'),
(15, 'core_badges_get_user_badge_by_hash', 'core_badges\\external\\get_user_badge_by_hash', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(16, 'core_blog_get_entries', 'core_blog\\external', 'get_entries', NULL, 'moodle', '', 'moodle_mobile_app'),
(17, 'core_blog_view_entries', 'core_blog\\external', 'view_entries', NULL, 'moodle', '', 'moodle_mobile_app'),
(18, 'core_blog_get_access_information', '\\core_blog\\external\\get_access_information', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(19, 'core_blog_add_entry', '\\core_blog\\external\\add_entry', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(20, 'core_blog_delete_entry', '\\core_blog\\external\\delete_entry', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(21, 'core_blog_prepare_entry_for_edition', '\\core_blog\\external\\prepare_entry_for_edition', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(22, 'core_blog_update_entry', '\\core_blog\\external\\update_entry', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(23, 'core_calendar_get_calendar_monthly_view', 'core_calendar_external', 'get_calendar_monthly_view', 'calendar/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(24, 'core_calendar_get_calendar_day_view', 'core_calendar_external', 'get_calendar_day_view', 'calendar/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(25, 'core_calendar_get_calendar_upcoming_view', 'core_calendar_external', 'get_calendar_upcoming_view', 'calendar/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(26, 'core_calendar_update_event_start_day', 'core_calendar_external', 'update_event_start_day', 'calendar/externallib.php', 'moodle', 'moodle/calendar:manageentries, moodle/calendar:manageownentries, moodle/calendar:managegroupentries', 'moodle_mobile_app'),
(27, 'core_calendar_create_calendar_events', 'core_calendar_external', 'create_calendar_events', 'calendar/externallib.php', 'moodle', 'moodle/calendar:manageentries, moodle/calendar:manageownentries, moodle/calendar:managegroupentries', 'moodle_mobile_app'),
(28, 'core_calendar_delete_calendar_events', 'core_calendar_external', 'delete_calendar_events', 'calendar/externallib.php', 'moodle', 'moodle/calendar:manageentries, moodle/calendar:manageownentries, moodle/calendar:managegroupentries', 'moodle_mobile_app'),
(29, 'core_calendar_get_calendar_events', 'core_calendar_external', 'get_calendar_events', 'calendar/externallib.php', 'moodle', 'moodle/calendar:manageentries, moodle/calendar:manageownentries, moodle/calendar:managegroupentries', 'moodle_mobile_app'),
(30, 'core_calendar_get_action_events_by_timesort', 'core_calendar_external', 'get_calendar_action_events_by_timesort', 'calendar/externallib.php', 'moodle', 'moodle/calendar:manageentries, moodle/calendar:manageownentries, moodle/calendar:managegroupentries', 'moodle_mobile_app'),
(31, 'core_calendar_get_action_events_by_course', 'core_calendar_external', 'get_calendar_action_events_by_course', 'calendar/externallib.php', 'moodle', 'moodle/calendar:manageentries, moodle/calendar:manageownentries, moodle/calendar:managegroupentries', 'moodle_mobile_app'),
(32, 'core_calendar_get_action_events_by_courses', 'core_calendar_external', 'get_calendar_action_events_by_courses', 'calendar/externallib.php', 'moodle', 'moodle/calendar:manageentries, moodle/calendar:manageownentries, moodle/calendar:managegroupentries', 'moodle_mobile_app'),
(33, 'core_calendar_get_calendar_event_by_id', 'core_calendar_external', 'get_calendar_event_by_id', 'calendar/externallib.php', 'moodle', 'moodle/calendar:manageentries, moodle/calendar:manageownentries, moodle/calendar:managegroupentries', 'moodle_mobile_app'),
(34, 'core_calendar_submit_create_update_form', 'core_calendar_external', 'submit_create_update_form', 'calendar/externallib.php', 'moodle', 'moodle/calendar:manageentries, moodle/calendar:manageownentries, moodle/calendar:managegroupentries', 'moodle_mobile_app'),
(35, 'core_calendar_get_calendar_access_information', 'core_calendar_external', 'get_calendar_access_information', 'calendar/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(36, 'core_calendar_get_allowed_event_types', 'core_calendar_external', 'get_allowed_event_types', 'calendar/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(37, 'core_calendar_get_timestamps', 'core_calendar_external', 'get_timestamps', 'calendar/externallib.php', 'moodle', '', NULL),
(38, 'core_calendar_get_calendar_export_token', 'core_calendar\\external\\export\\token', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(39, 'core_calendar_delete_subscription', 'core_calendar\\external\\subscription\\delete', 'execute', NULL, 'moodle', '', NULL),
(40, 'core_check_get_result_admintree', 'core\\check\\external\\get_result_admintree', 'execute', NULL, 'moodle', '', NULL),
(41, 'core_cohort_add_cohort_members', 'core_cohort_external', 'add_cohort_members', 'cohort/externallib.php', 'moodle', 'moodle/cohort:assign', NULL),
(42, 'core_cohort_create_cohorts', 'core_cohort_external', 'create_cohorts', 'cohort/externallib.php', 'moodle', 'moodle/cohort:manage', NULL),
(43, 'core_cohort_delete_cohort_members', 'core_cohort_external', 'delete_cohort_members', 'cohort/externallib.php', 'moodle', 'moodle/cohort:assign', NULL),
(44, 'core_cohort_delete_cohorts', 'core_cohort_external', 'delete_cohorts', 'cohort/externallib.php', 'moodle', 'moodle/cohort:manage', NULL),
(45, 'core_cohort_get_cohort_members', 'core_cohort_external', 'get_cohort_members', 'cohort/externallib.php', 'moodle', 'moodle/cohort:view', NULL),
(46, 'core_cohort_search_cohorts', 'core_cohort_external', 'search_cohorts', 'cohort/externallib.php', 'moodle', 'moodle/cohort:view', NULL),
(47, 'core_cohort_get_cohorts', 'core_cohort_external', 'get_cohorts', 'cohort/externallib.php', 'moodle', 'moodle/cohort:view', NULL),
(48, 'core_cohort_update_cohorts', 'core_cohort_external', 'update_cohorts', 'cohort/externallib.php', 'moodle', 'moodle/cohort:manage', NULL),
(49, 'core_comment_get_comments', 'core_comment_external', 'get_comments', NULL, 'moodle', 'moodle/comment:view', 'moodle_mobile_app'),
(50, 'core_comment_add_comments', 'core_comment_external', 'add_comments', NULL, 'moodle', '', 'moodle_mobile_app'),
(51, 'core_comment_delete_comments', 'core_comment_external', 'delete_comments', NULL, 'moodle', '', 'moodle_mobile_app'),
(52, 'core_completion_get_activities_completion_status', 'core_completion_external', 'get_activities_completion_status', NULL, 'moodle', '', 'moodle_mobile_app'),
(53, 'core_completion_get_course_completion_status', 'core_completion_external', 'get_course_completion_status', NULL, 'moodle', 'report/completion:view', 'moodle_mobile_app'),
(54, 'core_completion_mark_course_self_completed', 'core_completion_external', 'mark_course_self_completed', NULL, 'moodle', '', 'moodle_mobile_app'),
(55, 'core_completion_update_activity_completion_status_manually', 'core_completion_external', 'update_activity_completion_status_manually', NULL, 'moodle', '', 'moodle_mobile_app'),
(56, 'core_completion_override_activity_completion_status', 'core_completion_external', 'override_activity_completion_status', NULL, 'moodle', 'moodle/course:overridecompletion', NULL),
(57, 'core_course_create_categories', 'core_course_external', 'create_categories', 'course/externallib.php', 'moodle', 'moodle/category:manage', NULL),
(58, 'core_course_create_courses', 'core_course_external', 'create_courses', 'course/externallib.php', 'moodle', 'moodle/course:create, moodle/course:visibility', NULL),
(59, 'core_course_delete_categories', 'core_course_external', 'delete_categories', 'course/externallib.php', 'moodle', 'moodle/category:manage', NULL),
(60, 'core_course_delete_courses', 'core_course_external', 'delete_courses', 'course/externallib.php', 'moodle', 'moodle/course:delete', NULL),
(61, 'core_course_delete_modules', 'core_course_external', 'delete_modules', 'course/externallib.php', 'moodle', 'moodle/course:manageactivities', NULL),
(62, 'core_course_duplicate_course', 'core_course_external', 'duplicate_course', 'course/externallib.php', 'moodle', 'moodle/backup:backupcourse, moodle/restore:restorecourse, moodle/course:create', NULL),
(63, 'core_course_get_categories', 'core_course_external', 'get_categories', 'course/externallib.php', 'moodle', 'moodle/category:viewhiddencategories', 'moodle_mobile_app'),
(64, 'core_course_get_contents', 'core_course_external', 'get_course_contents', 'course/externallib.php', 'moodle', 'moodle/course:update, moodle/course:viewhiddencourses', 'moodle_mobile_app'),
(65, 'core_course_get_course_module', 'core_course_external', 'get_course_module', 'course/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(66, 'core_course_get_course_module_by_instance', 'core_course_external', 'get_course_module_by_instance', 'course/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(67, 'core_course_get_module', 'core_course_external', 'get_module', 'course/externallib.php', 'moodle', '', NULL),
(68, 'core_courseformat_file_handlers', 'core_courseformat\\external\\file_handlers', 'execute', NULL, 'moodle', '', NULL),
(69, 'core_courseformat_get_state', 'core_courseformat\\external\\get_state', 'execute', NULL, 'moodle', '', NULL),
(70, 'core_courseformat_get_section_content_items', 'core_courseformat\\external\\get_section_content_items', 'execute', NULL, 'moodle', '', NULL),
(71, 'core_courseformat_get_overview_information', 'core_courseformat\\external\\get_overview_information', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(72, 'core_courseformat_log_view_overview_information', 'core_courseformat\\external\\log_view_overview_information', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(73, 'core_courseformat_new_module', 'core_courseformat\\external\\new_module', 'execute', NULL, 'moodle', 'moodle/course:manageactivities', NULL),
(74, 'core_courseformat_update_course', 'core_courseformat\\external\\update_course', 'execute', NULL, 'moodle', 'moodle/course:sectionvisibility, moodle/course:activityvisibility', NULL),
(75, 'core_courseformat_create_module', 'core_courseformat\\external\\create_module', 'execute', NULL, 'moodle', 'moodle/course:manageactivities', NULL),
(76, 'core_course_edit_module', 'core_course_external', 'edit_module', 'course/externallib.php', 'moodle', '', NULL),
(77, 'core_course_edit_section', 'core_course_external', 'edit_section', 'course/externallib.php', 'moodle', '', NULL),
(78, 'core_course_get_courses', 'core_course_external', 'get_courses', 'course/externallib.php', 'moodle', 'moodle/course:view, moodle/course:update, moodle/course:viewhiddencourses', 'moodle_mobile_app'),
(79, 'core_course_import_course', 'core_course_external', 'import_course', 'course/externallib.php', 'moodle', 'moodle/backup:backuptargetimport, moodle/restore:restoretargetimport', NULL),
(80, 'core_course_search_courses', 'core_course_external', 'search_courses', 'course/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(81, 'core_course_update_categories', 'core_course_external', 'update_categories', 'course/externallib.php', 'moodle', 'moodle/category:manage', NULL),
(82, 'core_course_update_courses', 'core_course_external', 'update_courses', 'course/externallib.php', 'moodle', 'moodle/course:update, moodle/course:changecategory, moodle/course:changefullname, moodle/course:changeshortname, moodle/course:changeidnumber, moodle/course:changesummary, moodle/course:visibility', NULL),
(83, 'core_course_view_course', 'core_course_external', 'view_course', 'course/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(84, 'core_course_get_user_navigation_options', 'core_course_external', 'get_user_navigation_options', 'course/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(85, 'core_course_get_user_administration_options', 'core_course_external', 'get_user_administration_options', 'course/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(86, 'core_course_get_courses_by_field', 'core_course_external', 'get_courses_by_field', 'course/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(87, 'core_course_check_updates', 'core_course_external', 'check_updates', 'course/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(88, 'core_course_get_updates_since', 'core_course_external', 'get_updates_since', 'course/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(89, 'core_course_get_enrolled_courses_by_timeline_classification', 'core_course_external', 'get_enrolled_courses_by_timeline_classification', 'course/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(90, 'core_course_get_enrolled_courses_with_action_events_by_timeline_classification', '\\core_course\\external\\get_enrolled_courses_with_action_events_by_timeline_classification', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(91, 'core_course_get_recent_courses', 'core_course_external', 'get_recent_courses', 'course/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(92, 'core_course_set_favourite_courses', 'core_course_external', 'set_favourite_courses', 'course/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(93, 'core_course_get_enrolled_users_by_cmid', 'core_course_external', 'get_enrolled_users_by_cmid', 'course/externallib.php', 'moodle', '', NULL),
(94, 'core_course_add_content_item_to_user_favourites', 'core_course_external', 'add_content_item_to_user_favourites', 'course/externallib.php', 'moodle', '', NULL),
(95, 'core_course_remove_content_item_from_user_favourites', 'core_course_external', 'remove_content_item_from_user_favourites', 'course/externallib.php', 'moodle', '', NULL),
(96, 'core_course_get_course_content_items', 'core_course_external', 'get_course_content_items', 'course/externallib.php', 'moodle', '', NULL),
(97, 'core_course_get_activity_chooser_footer', 'core_course_external', 'get_activity_chooser_footer', 'course/externallib.php', 'moodle', '', NULL),
(98, 'core_course_toggle_activity_recommendation', 'core_course_external', 'toggle_activity_recommendation', 'course/externallib.php', 'moodle', '', NULL),
(99, 'core_course_view_module_instance_list', 'core_course\\external\\view_module_instance_list', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(100, 'core_enrol_get_course_enrolment_methods', 'core_enrol_external', 'get_course_enrolment_methods', 'enrol/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(101, 'core_enrol_get_enrolled_users', 'core_enrol_external', 'get_enrolled_users', 'enrol/externallib.php', 'moodle', 'moodle/user:viewdetails, moodle/user:viewhiddendetails, moodle/course:useremail, moodle/user:update, moodle/site:accessallgroups', 'moodle_mobile_app'),
(102, 'core_enrol_get_enrolled_users_with_capability', 'core_enrol_external', 'get_enrolled_users_with_capability', 'enrol/externallib.php', 'moodle', '', NULL),
(103, 'core_enrol_get_potential_users', 'core_enrol_external', 'get_potential_users', 'enrol/externallib.php', 'moodle', 'moodle/course:enrolreview', NULL),
(104, 'core_enrol_search_users', 'core_enrol_external', 'search_users', 'enrol/externallib.php', 'moodle', 'moodle/course:viewparticipants', 'moodle_mobile_app'),
(105, 'core_enrol_get_users_courses', 'core_enrol_external', 'get_users_courses', 'enrol/externallib.php', 'moodle', 'moodle/course:viewparticipants', 'moodle_mobile_app'),
(106, 'core_enrol_submit_user_enrolment_form', 'core_enrol_external', 'submit_user_enrolment_form', 'enrol/externallib.php', 'moodle', '', NULL),
(107, 'core_enrol_unenrol_user_enrolment', 'core_enrol_external', 'unenrol_user_enrolment', 'enrol/externallib.php', 'moodle', '', NULL),
(108, 'core_fetch_notifications', 'core_external', 'fetch_notifications', 'lib/external/externallib.php', 'moodle', '', NULL),
(109, 'core_session_touch', 'core\\session\\external', 'touch_session', NULL, 'moodle', '', NULL),
(110, 'core_session_time_remaining', 'core\\session\\external', 'time_remaining', NULL, 'moodle', '', NULL),
(111, 'core_files_get_files', 'core_files_external', 'get_files', 'files/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(112, 'core_files_upload', 'core_files_external', 'upload', 'files/externallib.php', 'moodle', '', NULL),
(113, 'core_files_delete_draft_files', 'core_files\\external\\delete\\draft', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(114, 'core_files_get_unused_draft_itemid', 'core_files\\external\\get\\unused_draft', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(115, 'core_form_get_filetypes_browser_data', 'core_form\\external', 'get_filetypes_browser_data', NULL, 'moodle', '', NULL),
(116, 'core_form_dynamic_form', 'core_form\\external\\dynamic_form', 'execute', NULL, 'moodle', '', NULL),
(117, 'core_get_component_strings', 'core_external', 'get_component_strings', 'lib/external/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(118, 'core_get_fragment', 'core_external', 'get_fragment', 'lib/external/externallib.php', 'moodle', '', NULL),
(119, 'core_get_string', 'core_external', 'get_string', 'lib/external/externallib.php', 'moodle', '', NULL),
(120, 'core_get_strings', 'core_external', 'get_strings', 'lib/external/externallib.php', 'moodle', '', NULL),
(121, 'core_get_user_dates', 'core_external', 'get_user_dates', 'lib/external/externallib.php', 'moodle', '', NULL),
(122, 'core_grades_update_grades', 'core_grades_external', 'update_grades', NULL, 'moodle', '', NULL),
(123, 'core_grades_grader_gradingpanel_point_fetch', 'core_grades\\grades\\grader\\gradingpanel\\point\\external\\fetch', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(124, 'core_grades_grader_gradingpanel_point_store', 'core_grades\\grades\\grader\\gradingpanel\\point\\external\\store', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(125, 'core_grades_grader_gradingpanel_scale_fetch', 'core_grades\\grades\\grader\\gradingpanel\\scale\\external\\fetch', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(126, 'core_grades_grader_gradingpanel_scale_store', 'core_grades\\grades\\grader\\gradingpanel\\scale\\external\\store', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(127, 'core_grades_create_gradecategories', 'core_grades\\external\\create_gradecategories', 'execute', NULL, 'moodle', 'moodle/grade:manage', NULL),
(128, 'core_grades_get_enrolled_users_for_selector', 'core_grades\\external\\get_enrolled_users_for_selector', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(129, 'core_grades_get_groups_for_selector', 'core_group\\external\\get_groups_for_selector', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(130, 'core_grades_get_feedback', 'core_grades\\external\\get_feedback', 'execute', NULL, 'moodle', '', NULL),
(131, 'core_grades_get_gradeitems', 'core_grades\\external\\get_gradeitems', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(132, 'core_grades_get_grade_tree', 'core_grades\\external\\get_grade_tree', 'execute', NULL, 'moodle', '', NULL),
(133, 'core_grades_get_gradable_users', 'core_grades\\external\\get_gradable_users', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(134, 'core_grading_get_definitions', 'core_grading_external', 'get_definitions', NULL, 'moodle', '', NULL),
(135, 'core_grading_get_gradingform_instances', 'core_grading_external', 'get_gradingform_instances', NULL, 'moodle', '', NULL),
(136, 'core_grading_save_definitions', 'core_grading_external', 'save_definitions', NULL, 'moodle', '', NULL),
(137, 'core_group_add_group_members', 'core_group_external', 'add_group_members', 'group/externallib.php', 'moodle', 'moodle/course:managegroups', NULL),
(138, 'core_group_assign_grouping', 'core_group_external', 'assign_grouping', 'group/externallib.php', 'moodle', '', NULL),
(139, 'core_group_create_groupings', 'core_group_external', 'create_groupings', 'group/externallib.php', 'moodle', '', NULL),
(140, 'core_group_create_groups', 'core_group_external', 'create_groups', 'group/externallib.php', 'moodle', 'moodle/course:managegroups', NULL),
(141, 'core_group_delete_group_members', 'core_group_external', 'delete_group_members', 'group/externallib.php', 'moodle', 'moodle/course:managegroups', NULL),
(142, 'core_group_delete_groupings', 'core_group_external', 'delete_groupings', 'group/externallib.php', 'moodle', '', NULL),
(143, 'core_group_delete_groups', 'core_group_external', 'delete_groups', 'group/externallib.php', 'moodle', 'moodle/course:managegroups', NULL),
(144, 'core_group_get_activity_allowed_groups', 'core_group_external', 'get_activity_allowed_groups', 'group/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(145, 'core_group_get_activity_groupmode', 'core_group_external', 'get_activity_groupmode', 'group/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(146, 'core_group_get_course_groupings', 'core_group_external', 'get_course_groupings', 'group/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(147, 'core_group_get_course_groups', 'core_group_external', 'get_course_groups', 'group/externallib.php', 'moodle', 'moodle/course:managegroups', 'moodle_mobile_app'),
(148, 'core_group_get_course_user_groups', 'core_group_external', 'get_course_user_groups', 'group/externallib.php', 'moodle', 'moodle/course:managegroups', 'moodle_mobile_app'),
(149, 'core_group_get_group_members', 'core_group_external', 'get_group_members', 'group/externallib.php', 'moodle', 'moodle/course:managegroups', NULL),
(150, 'core_group_get_groupings', 'core_group_external', 'get_groupings', 'group/externallib.php', 'moodle', '', NULL),
(151, 'core_group_get_groups', 'core_group_external', 'get_groups', 'group/externallib.php', 'moodle', 'moodle/course:managegroups', NULL),
(152, 'core_group_get_groups_for_selector', 'core_group\\external\\get_groups_for_selector', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(153, 'core_group_unassign_grouping', 'core_group_external', 'unassign_grouping', 'group/externallib.php', 'moodle', '', NULL),
(154, 'core_group_update_groupings', 'core_group_external', 'update_groupings', 'group/externallib.php', 'moodle', '', NULL),
(155, 'core_group_update_groups', 'core_group_external', 'update_groups', 'group/externallib.php', 'moodle', 'moodle/course:managegroups', NULL),
(156, 'core_message_mute_conversations', 'core_message_external', 'mute_conversations', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(157, 'core_message_unmute_conversations', 'core_message_external', 'unmute_conversations', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(158, 'core_message_block_user', 'core_message_external', 'block_user', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(159, 'core_message_get_contact_requests', 'core_message_external', 'get_contact_requests', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(160, 'core_message_create_contact_request', 'core_message_external', 'create_contact_request', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(161, 'core_message_confirm_contact_request', 'core_message_external', 'confirm_contact_request', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(162, 'core_message_decline_contact_request', 'core_message_external', 'decline_contact_request', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(163, 'core_message_get_received_contact_requests_count', 'core_message_external', 'get_received_contact_requests_count', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(164, 'core_message_delete_contacts', 'core_message_external', 'delete_contacts', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(165, 'core_message_delete_conversations_by_id', 'core_message_external', 'delete_conversations_by_id', 'message/externallib.php', 'moodle', 'moodle/site:deleteownmessage', 'moodle_mobile_app'),
(166, 'core_message_delete_message', 'core_message_external', 'delete_message', 'message/externallib.php', 'moodle', 'moodle/site:deleteownmessage', 'moodle_mobile_app'),
(167, 'core_message_get_blocked_users', 'core_message_external', 'get_blocked_users', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(168, 'core_message_data_for_messagearea_search_messages', 'core_message_external', 'data_for_messagearea_search_messages', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(169, 'core_message_message_search_users', 'core_message_external', 'message_search_users', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(170, 'core_message_get_user_contacts', 'core_message_external', 'get_user_contacts', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(171, 'core_message_get_conversations', 'core_message_external', 'get_conversations', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(172, 'core_message_get_conversation', 'core_message_external', 'get_conversation', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(173, 'core_message_get_conversation_between_users', 'core_message_external', 'get_conversation_between_users', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(174, 'core_message_get_self_conversation', 'core_message_external', 'get_self_conversation', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(175, 'core_message_get_messages', 'core_message_external', 'get_messages', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(176, 'core_message_get_conversation_counts', 'core_message_external', 'get_conversation_counts', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(177, 'core_message_get_unread_conversation_counts', 'core_message_external', 'get_unread_conversation_counts', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(178, 'core_message_get_conversation_members', 'core_message_external', 'get_conversation_members', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(179, 'core_message_get_member_info', 'core_message_external', 'get_member_info', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(180, 'core_message_get_unread_conversations_count', 'core_message_external', 'get_unread_conversations_count', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(181, 'core_message_mark_all_notifications_as_read', 'core_message_external', 'mark_all_notifications_as_read', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(182, 'core_message_mark_all_conversation_messages_as_read', 'core_message_external', 'mark_all_conversation_messages_as_read', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(183, 'core_message_mark_message_read', 'core_message_external', 'mark_message_read', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(184, 'core_message_mark_notification_read', 'core_message_external', 'mark_notification_read', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(185, 'core_message_message_processor_config_form', 'core_message_external', 'message_processor_config_form', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(186, 'core_message_get_message_processor', 'core_message_external', 'get_message_processor', 'message/externallib.php', 'moodle', '', NULL),
(187, 'core_message_search_contacts', 'core_message_external', 'search_contacts', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(188, 'core_message_send_instant_messages', 'core_message_external', 'send_instant_messages', 'message/externallib.php', 'moodle', 'moodle/site:sendmessage', 'moodle_mobile_app'),
(189, 'core_message_send_messages_to_conversation', 'core_message_external', 'send_messages_to_conversation', 'message/externallib.php', 'moodle', 'moodle/site:sendmessage', 'moodle_mobile_app'),
(190, 'core_message_get_conversation_messages', 'core_message_external', 'get_conversation_messages', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(191, 'core_message_unblock_user', 'core_message_external', 'unblock_user', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(192, 'core_message_get_user_notification_preferences', 'core_message_external', 'get_user_notification_preferences', 'message/externallib.php', 'moodle', 'moodle/user:editownmessageprofile', 'moodle_mobile_app'),
(193, 'core_message_get_user_message_preferences', 'core_message_external', 'get_user_message_preferences', 'message/externallib.php', 'moodle', 'moodle/user:editownmessageprofile', 'moodle_mobile_app'),
(194, 'core_message_set_favourite_conversations', 'core_message_external', 'set_favourite_conversations', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(195, 'core_message_unset_favourite_conversations', 'core_message_external', 'unset_favourite_conversations', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(196, 'core_message_delete_message_for_all_users', 'core_message_external', 'delete_message_for_all_users', 'message/externallib.php', 'moodle', 'moodle/site:deleteanymessage', 'moodle_mobile_app'),
(197, 'core_message_get_unread_notification_count', '\\core_message\\external\\get_unread_notification_count', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(198, 'core_message_set_default_notification', 'core_message\\external\\message_set_default_notification', 'execute', NULL, 'moodle', 'moodle/site:config', NULL),
(199, 'core_my_view_page', '\\core_my\\external\\view_page', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(200, 'core_notes_create_notes', 'core_notes_external', 'create_notes', 'notes/externallib.php', 'moodle', 'moodle/notes:manage', 'moodle_mobile_app'),
(201, 'core_notes_delete_notes', 'core_notes_external', 'delete_notes', 'notes/externallib.php', 'moodle', 'moodle/notes:manage', 'moodle_mobile_app'),
(202, 'core_notes_get_course_notes', 'core_notes_external', 'get_course_notes', 'notes/externallib.php', 'moodle', 'moodle/notes:view', 'moodle_mobile_app'),
(203, 'core_notes_get_notes', 'core_notes_external', 'get_notes', 'notes/externallib.php', 'moodle', 'moodle/notes:view', NULL),
(204, 'core_notes_update_notes', 'core_notes_external', 'update_notes', 'notes/externallib.php', 'moodle', 'moodle/notes:manage', NULL),
(205, 'core_notes_view_notes', 'core_notes_external', 'view_notes', 'notes/externallib.php', 'moodle', 'moodle/notes:view', 'moodle_mobile_app'),
(206, 'core_output_load_template', 'core\\output\\external', 'load_template', NULL, 'moodle', '', NULL),
(207, 'core_output_load_template_with_dependencies', 'core\\output\\external', 'load_template_with_dependencies', NULL, 'moodle', '', NULL),
(208, 'core_output_load_fontawesome_icon_system_map', 'core\\external\\output\\icon_system\\load_fontawesome_map', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(209, 'core_question_update_flag', 'core_question_external', 'update_flag', NULL, 'moodle', 'moodle/question:flag', 'moodle_mobile_app'),
(210, 'core_question_get_random_question_summaries', 'core_question_external', 'get_random_question_summaries', NULL, 'moodle', '', NULL),
(211, 'core_rating_get_item_ratings', 'core_rating_external', 'get_item_ratings', NULL, 'moodle', 'moodle/rating:view', 'moodle_mobile_app'),
(212, 'core_rating_add_rating', 'core_rating_external', 'add_rating', NULL, 'moodle', 'moodle/rating:rate', 'moodle_mobile_app'),
(213, 'core_role_assign_roles', 'core_role_external', 'assign_roles', 'enrol/externallib.php', 'moodle', 'moodle/role:assign', NULL),
(214, 'core_role_unassign_roles', 'core_role_external', 'unassign_roles', 'enrol/externallib.php', 'moodle', 'moodle/role:assign', NULL),
(215, 'core_search_get_relevant_users', '\\core_search\\external', 'get_relevant_users', NULL, 'moodle', '', NULL),
(216, 'core_search_get_results', '\\core_search\\external\\get_results', 'execute', NULL, 'moodle', 'moodle/search:query', 'moodle_mobile_app'),
(217, 'core_search_get_search_areas_list', '\\core_search\\external\\get_search_areas_list', 'execute', NULL, 'moodle', 'moodle/search:query', 'moodle_mobile_app'),
(218, 'core_search_view_results', '\\core_search\\external\\view_results', 'execute', NULL, 'moodle', 'moodle/search:query', 'moodle_mobile_app'),
(219, 'core_search_get_top_results', '\\core_search\\external\\get_top_results', 'execute', NULL, 'moodle', 'moodle/search:query', 'moodle_mobile_app'),
(220, 'core_tag_get_tagindex', 'core_tag_external', 'get_tagindex', NULL, 'moodle', '', 'moodle_mobile_app'),
(221, 'core_tag_get_tags', 'core_tag_external', 'get_tags', NULL, 'moodle', '', NULL),
(222, 'core_tag_update_tags', 'core_tag_external', 'update_tags', NULL, 'moodle', '', NULL),
(223, 'core_tag_get_tagindex_per_area', 'core_tag_external', 'get_tagindex_per_area', NULL, 'moodle', '', 'moodle_mobile_app'),
(224, 'core_tag_get_tag_areas', 'core_tag_external', 'get_tag_areas', NULL, 'moodle', '', 'moodle_mobile_app'),
(225, 'core_tag_get_tag_collections', 'core_tag_external', 'get_tag_collections', NULL, 'moodle', '', 'moodle_mobile_app'),
(226, 'core_tag_get_tag_cloud', 'core_tag_external', 'get_tag_cloud', NULL, 'moodle', '', 'moodle_mobile_app'),
(227, 'core_update_inplace_editable', 'core_external', 'update_inplace_editable', 'lib/external/externallib.php', 'moodle', '', NULL),
(228, 'core_user_add_user_device', 'core_user_external', 'add_user_device', 'user/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(229, 'core_user_update_user_device_public_key', '\\core_user\\external\\update_user_device_public_key', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(230, 'core_user_add_user_private_files', 'core_user_external', 'add_user_private_files', 'user/externallib.php', 'moodle', 'moodle/user:manageownfiles', 'moodle_mobile_app'),
(231, 'core_user_create_users', 'core_user_external', 'create_users', 'user/externallib.php', 'moodle', 'moodle/user:create', NULL),
(232, 'core_user_delete_users', 'core_user_external', 'delete_users', 'user/externallib.php', 'moodle', 'moodle/user:delete', NULL),
(233, 'core_user_get_course_user_profiles', 'core_user_external', 'get_course_user_profiles', 'user/externallib.php', 'moodle', 'moodle/user:viewdetails, moodle/user:viewhiddendetails, moodle/course:useremail, moodle/user:update, moodle/site:accessallgroups', 'moodle_mobile_app'),
(234, 'core_user_get_users', 'core_user_external', 'get_users', 'user/externallib.php', 'moodle', 'moodle/user:viewdetails, moodle/user:viewhiddendetails, moodle/course:useremail, moodle/user:update', NULL),
(235, 'core_user_get_users_by_field', 'core_user_external', 'get_users_by_field', 'user/externallib.php', 'moodle', 'moodle/user:viewdetails, moodle/user:viewhiddendetails, moodle/course:useremail, moodle/user:update', 'moodle_mobile_app'),
(236, 'core_user_search_identity', '\\core_user\\external\\search_identity', 'execute', NULL, 'moodle', 'moodle/user:viewalldetails', NULL),
(237, 'core_user_remove_user_device', 'core_user_external', 'remove_user_device', 'user/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(238, 'core_user_update_users', 'core_user_external', 'update_users', 'user/externallib.php', 'moodle', 'moodle/user:update', NULL),
(239, 'core_user_update_user_preferences', 'core_user_external', 'update_user_preferences', 'user/externallib.php', 'moodle', 'moodle/user:editownmessageprofile, moodle/user:editmessageprofile', 'moodle_mobile_app'),
(240, 'core_user_view_user_list', 'core_user_external', 'view_user_list', 'user/externallib.php', 'moodle', 'moodle/course:viewparticipants', 'moodle_mobile_app'),
(241, 'core_user_view_user_profile', 'core_user_external', 'view_user_profile', 'user/externallib.php', 'moodle', 'moodle/user:viewdetails', 'moodle_mobile_app'),
(242, 'core_user_get_user_preferences', 'core_user_external', 'get_user_preferences', 'user/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(243, 'core_user_update_picture', 'core_user_external', 'update_picture', 'user/externallib.php', 'moodle', 'moodle/user:editownprofile, moodle/user:editprofile', 'moodle_mobile_app'),
(244, 'core_user_set_user_preferences', 'core_user_external', 'set_user_preferences', 'user/externallib.php', 'moodle', 'moodle/site:config', 'moodle_mobile_app'),
(245, 'core_user_agree_site_policy', 'core_user_external', 'agree_site_policy', 'user/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(246, 'core_user_get_private_files_info', 'core_user_external', 'get_private_files_info', 'user/externallib.php', 'moodle', 'moodle/user:manageownfiles', 'moodle_mobile_app'),
(247, 'core_user_prepare_private_files_for_edition', '\\core_user\\external\\prepare_private_files_for_edition', 'execute', NULL, 'moodle', 'moodle/user:manageownfiles', 'moodle_mobile_app'),
(248, 'core_user_update_private_files', '\\core_user\\external\\update_private_files', 'execute', NULL, 'moodle', 'moodle/user:manageownfiles', 'moodle_mobile_app'),
(249, 'core_competency_create_competency_framework', 'core_competency\\external', 'create_competency_framework', NULL, 'moodle', 'moodle/competency:competencymanage', NULL),
(250, 'core_competency_read_competency_framework', 'core_competency\\external', 'read_competency_framework', NULL, 'moodle', 'moodle/competency:competencyview', NULL),
(251, 'core_competency_duplicate_competency_framework', 'core_competency\\external', 'duplicate_competency_framework', NULL, 'moodle', 'moodle/competency:competencymanage', NULL),
(252, 'core_competency_delete_competency_framework', 'core_competency\\external', 'delete_competency_framework', NULL, 'moodle', 'moodle/competency:competencymanage', NULL),
(253, 'core_competency_update_competency_framework', 'core_competency\\external', 'update_competency_framework', NULL, 'moodle', 'moodle/competency:competencymanage', NULL),
(254, 'core_competency_list_competency_frameworks', 'core_competency\\external', 'list_competency_frameworks', NULL, 'moodle', 'moodle/competency:competencyview', NULL),
(255, 'core_competency_count_competency_frameworks', 'core_competency\\external', 'count_competency_frameworks', NULL, 'moodle', 'moodle/competency:competencyview', NULL),
(256, 'core_competency_competency_framework_viewed', 'core_competency\\external', 'competency_framework_viewed', NULL, 'moodle', 'moodle/competency:competencyview', NULL),
(257, 'core_competency_create_competency', 'core_competency\\external', 'create_competency', NULL, 'moodle', 'moodle/competency:competencymanage', NULL),
(258, 'core_competency_read_competency', 'core_competency\\external', 'read_competency', NULL, 'moodle', 'moodle/competency:competencyview', NULL),
(259, 'core_competency_competency_viewed', 'core_competency\\external', 'competency_viewed', NULL, 'moodle', 'moodle/competency:competencyview', 'moodle_mobile_app'),
(260, 'core_competency_delete_competency', 'core_competency\\external', 'delete_competency', NULL, 'moodle', 'moodle/competency:competencymanage', NULL),
(261, 'core_competency_update_competency', 'core_competency\\external', 'update_competency', NULL, 'moodle', 'moodle/competency:competencymanage', NULL),
(262, 'core_competency_list_competencies', 'core_competency\\external', 'list_competencies', NULL, 'moodle', 'moodle/competency:competencyview', NULL),
(263, 'core_competency_list_competencies_in_template', 'core_competency\\external', 'list_competencies_in_template', NULL, 'moodle', 'moodle/competency:competencyview', NULL),
(264, 'core_competency_count_competencies', 'core_competency\\external', 'count_competencies', NULL, 'moodle', 'moodle/competency:competencyview', NULL),
(265, 'core_competency_count_competencies_in_template', 'core_competency\\external', 'count_competencies_in_template', NULL, 'moodle', 'moodle/competency:competencyview', NULL),
(266, 'core_competency_search_competencies', 'core_competency\\external', 'search_competencies', NULL, 'moodle', 'moodle/competency:competencyview', NULL),
(267, 'core_competency_set_parent_competency', 'core_competency\\external', 'set_parent_competency', NULL, 'moodle', 'moodle/competency:competencymanage', NULL),
(268, 'core_competency_move_up_competency', 'core_competency\\external', 'move_up_competency', NULL, 'moodle', 'moodle/competency:competencymanage', NULL),
(269, 'core_competency_move_down_competency', 'core_competency\\external', 'move_down_competency', NULL, 'moodle', 'moodle/competency:competencymanage', NULL),
(270, 'core_competency_list_course_module_competencies', 'core_competency\\external', 'list_course_module_competencies', NULL, 'moodle', 'moodle/competency:coursecompetencyview', NULL),
(271, 'core_competency_count_course_module_competencies', 'core_competency\\external', 'count_course_module_competencies', NULL, 'moodle', 'moodle/competency:coursecompetencyview', NULL),
(272, 'core_competency_list_course_competencies', 'core_competency\\external', 'list_course_competencies', NULL, 'moodle', 'moodle/competency:coursecompetencyview', 'moodle_mobile_app'),
(273, 'core_competency_count_competencies_in_course', 'core_competency\\external', 'count_competencies_in_course', NULL, 'moodle', 'moodle/competency:coursecompetencyview', NULL),
(274, 'core_competency_count_courses_using_competency', 'core_competency\\external', 'count_courses_using_competency', NULL, 'moodle', 'moodle/competency:coursecompetencyview', NULL),
(275, 'core_competency_add_competency_to_course', 'core_competency\\external', 'add_competency_to_course', NULL, 'moodle', 'moodle/competency:coursecompetencymanage', NULL),
(276, 'core_competency_add_competency_to_template', 'core_competency\\external', 'add_competency_to_template', NULL, 'moodle', 'moodle/competency:templatemanage', NULL),
(277, 'core_competency_remove_competency_from_course', 'core_competency\\external', 'remove_competency_from_course', NULL, 'moodle', 'moodle/competency:coursecompetencymanage', NULL),
(278, 'core_competency_set_course_competency_ruleoutcome', 'core_competency\\external', 'set_course_competency_ruleoutcome', NULL, 'moodle', 'moodle/competency:coursecompetencymanage', NULL),
(279, 'core_competency_remove_competency_from_template', 'core_competency\\external', 'remove_competency_from_template', NULL, 'moodle', 'moodle/competency:templatemanage', NULL),
(280, 'core_competency_reorder_course_competency', 'core_competency\\external', 'reorder_course_competency', NULL, 'moodle', 'moodle/competency:coursecompetencymanage', NULL),
(281, 'core_competency_reorder_template_competency', 'core_competency\\external', 'reorder_template_competency', NULL, 'moodle', 'moodle/competency:templatemanage', NULL),
(282, 'core_competency_create_template', 'core_competency\\external', 'create_template', NULL, 'moodle', 'moodle/competency:templatemanage', NULL),
(283, 'core_competency_duplicate_template', 'core_competency\\external', 'duplicate_template', NULL, 'moodle', 'moodle/competency:templatemanage', NULL),
(284, 'core_competency_read_template', 'core_competency\\external', 'read_template', NULL, 'moodle', 'moodle/competency:templateview', NULL),
(285, 'core_competency_delete_template', 'core_competency\\external', 'delete_template', NULL, 'moodle', 'moodle/competency:templatemanage', NULL),
(286, 'core_competency_update_template', 'core_competency\\external', 'update_template', NULL, 'moodle', 'moodle/competency:templatemanage', NULL),
(287, 'core_competency_list_templates', 'core_competency\\external', 'list_templates', NULL, 'moodle', 'moodle/competency:templateview', NULL),
(288, 'core_competency_list_templates_using_competency', 'core_competency\\external', 'list_templates_using_competency', NULL, 'moodle', 'moodle/competency:templateview', NULL),
(289, 'core_competency_count_templates', 'core_competency\\external', 'count_templates', NULL, 'moodle', 'moodle/competency:templateview', NULL),
(290, 'core_competency_count_templates_using_competency', 'core_competency\\external', 'count_templates_using_competency', NULL, 'moodle', 'moodle/competency:templateview', NULL),
(291, 'core_competency_create_plan', 'core_competency\\external', 'create_plan', NULL, 'moodle', 'moodle/competency:planmanage', NULL),
(292, 'core_competency_update_plan', 'core_competency\\external', 'update_plan', NULL, 'moodle', 'moodle/competency:planmanage', NULL),
(293, 'core_competency_complete_plan', 'core_competency\\external', 'complete_plan', NULL, 'moodle', 'moodle/competency:planmanage', NULL),
(294, 'core_competency_reopen_plan', 'core_competency\\external', 'reopen_plan', NULL, 'moodle', 'moodle/competency:planmanage', NULL),
(295, 'core_competency_read_plan', 'core_competency\\external', 'read_plan', NULL, 'moodle', 'moodle/competency:planviewown', NULL),
(296, 'core_competency_delete_plan', 'core_competency\\external', 'delete_plan', NULL, 'moodle', 'moodle/competency:planmanage', NULL),
(297, 'core_competency_list_user_plans', 'core_competency\\external', 'list_user_plans', NULL, 'moodle', 'moodle/competency:planviewown', NULL),
(298, 'core_competency_list_plan_competencies', 'core_competency\\external', 'list_plan_competencies', NULL, 'moodle', 'moodle/competency:planviewown', NULL),
(299, 'core_competency_add_competency_to_plan', 'core_competency\\external', 'add_competency_to_plan', NULL, 'moodle', 'moodle/competency:planmanage', NULL),
(300, 'core_competency_remove_competency_from_plan', 'core_competency\\external', 'remove_competency_from_plan', NULL, 'moodle', 'moodle/competency:planmanage', NULL),
(301, 'core_competency_reorder_plan_competency', 'core_competency\\external', 'reorder_plan_competency', NULL, 'moodle', 'moodle/competency:planmanage', NULL),
(302, 'core_competency_plan_request_review', 'core_competency\\external', 'plan_request_review', NULL, 'moodle', 'moodle/competency:planmanagedraft', NULL),
(303, 'core_competency_plan_start_review', 'core_competency\\external', 'plan_start_review', NULL, 'moodle', 'moodle/competency:planmanage', NULL),
(304, 'core_competency_plan_stop_review', 'core_competency\\external', 'plan_stop_review', NULL, 'moodle', 'moodle/competency:planmanage', NULL),
(305, 'core_competency_plan_cancel_review_request', 'core_competency\\external', 'plan_cancel_review_request', NULL, 'moodle', 'moodle/competency:planmanagedraft', NULL),
(306, 'core_competency_approve_plan', 'core_competency\\external', 'approve_plan', NULL, 'moodle', 'moodle/competency:planmanage', NULL),
(307, 'core_competency_unapprove_plan', 'core_competency\\external', 'unapprove_plan', NULL, 'moodle', 'moodle/competency:planmanage', NULL),
(308, 'core_competency_template_has_related_data', 'core_competency\\external', 'template_has_related_data', NULL, 'moodle', 'moodle/competency:templateview', NULL),
(309, 'core_competency_get_scale_values', 'core_competency\\external', 'get_scale_values', NULL, 'moodle', 'moodle/competency:competencymanage', 'moodle_mobile_app'),
(310, 'core_competency_add_related_competency', 'core_competency\\external', 'add_related_competency', NULL, 'moodle', 'moodle/competency:competencymanage', NULL),
(311, 'core_competency_remove_related_competency', 'core_competency\\external', 'remove_related_competency', NULL, 'moodle', 'moodle/competency:competencymanage', NULL),
(312, 'core_competency_read_user_evidence', 'core_competency\\external', 'read_user_evidence', NULL, 'moodle', 'moodle/competency:userevidenceview', NULL),
(313, 'core_competency_delete_user_evidence', 'core_competency\\external', 'delete_user_evidence', NULL, 'moodle', 'moodle/competency:userevidencemanageown', NULL),
(314, 'core_competency_create_user_evidence_competency', 'core_competency\\external', 'create_user_evidence_competency', NULL, 'moodle', 'moodle/competency:userevidencemanageown, moodle/competency:competencyview', NULL),
(315, 'core_competency_delete_user_evidence_competency', 'core_competency\\external', 'delete_user_evidence_competency', NULL, 'moodle', 'moodle/competency:userevidencemanageown', NULL),
(316, 'core_competency_user_competency_cancel_review_request', 'core_competency\\external', 'user_competency_cancel_review_request', NULL, 'moodle', 'moodle/competency:userevidencemanageown', NULL),
(317, 'core_competency_user_competency_request_review', 'core_competency\\external', 'user_competency_request_review', NULL, 'moodle', 'moodle/competency:userevidencemanageown', NULL),
(318, 'core_competency_user_competency_start_review', 'core_competency\\external', 'user_competency_start_review', NULL, 'moodle', 'moodle/competency:competencygrade', NULL),
(319, 'core_competency_user_competency_stop_review', 'core_competency\\external', 'user_competency_stop_review', NULL, 'moodle', 'moodle/competency:competencygrade', NULL),
(320, 'core_competency_user_competency_viewed', 'core_competency\\external', 'user_competency_viewed', NULL, 'moodle', 'moodle/competency:usercompetencyview', 'moodle_mobile_app'),
(321, 'core_competency_user_competency_viewed_in_plan', 'core_competency\\external', 'user_competency_viewed_in_plan', NULL, 'moodle', 'moodle/competency:usercompetencyview', 'moodle_mobile_app');
INSERT INTO `[[dbprefix]]external_functions` VALUES
(322, 'core_competency_user_competency_viewed_in_course', 'core_competency\\external', 'user_competency_viewed_in_course', NULL, 'moodle', 'moodle/competency:usercompetencyview', 'moodle_mobile_app'),
(323, 'core_competency_user_competency_plan_viewed', 'core_competency\\external', 'user_competency_plan_viewed', NULL, 'moodle', 'moodle/competency:usercompetencyview', 'moodle_mobile_app'),
(324, 'core_competency_grade_competency', 'core_competency\\external', 'grade_competency', NULL, 'moodle', 'moodle/competency:competencygrade', NULL),
(325, 'core_competency_grade_competency_in_plan', 'core_competency\\external', 'grade_competency_in_plan', NULL, 'moodle', 'moodle/competency:competencygrade', NULL),
(326, 'core_competency_grade_competency_in_course', 'core_competency\\external', 'grade_competency_in_course', NULL, 'moodle', 'moodle/competency:competencygrade', 'moodle_mobile_app'),
(327, 'core_competency_unlink_plan_from_template', 'core_competency\\external', 'unlink_plan_from_template', NULL, 'moodle', 'moodle/competency:planmanage', NULL),
(328, 'core_competency_template_viewed', 'core_competency\\external', 'template_viewed', NULL, 'moodle', 'moodle/competency:templateview', NULL),
(329, 'core_competency_request_review_of_user_evidence_linked_competencies', 'core_competency\\external', 'request_review_of_user_evidence_linked_competencies', NULL, 'moodle', 'moodle/competency:userevidencemanageown', NULL),
(330, 'core_competency_update_course_competency_settings', 'core_competency\\external', 'update_course_competency_settings', NULL, 'moodle', 'moodle/competency:coursecompetencyconfigure', NULL),
(331, 'core_competency_delete_evidence', 'core_competency\\external', 'delete_evidence', NULL, 'moodle', 'moodle/competency:evidencedelete', 'moodle_mobile_app'),
(332, 'core_webservice_get_site_info', 'core_webservice_external', 'get_site_info', 'webservice/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(333, 'core_block_get_course_blocks', 'core_block_external', 'get_course_blocks', NULL, 'moodle', '', 'moodle_mobile_app'),
(334, 'core_block_get_dashboard_blocks', 'core_block_external', 'get_dashboard_blocks', NULL, 'moodle', '', 'moodle_mobile_app'),
(335, 'core_block_fetch_addable_blocks', 'core_block\\external\\fetch_addable_blocks', 'execute', NULL, 'moodle', 'moodle/site:manageblocks', 'moodle_mobile_app'),
(336, 'core_filters_get_available_in_context', 'core_filters\\external\\get_available_in_context', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(337, 'core_filters_get_all_states', 'core_filters\\external\\get_all_states', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(338, 'core_customfield_delete_field', 'core_customfield_external', 'delete_field', 'customfield/externallib.php', 'moodle', '', NULL),
(339, 'core_customfield_reload_template', 'core_customfield_external', 'reload_template', 'customfield/externallib.php', 'moodle', '', NULL),
(340, 'core_customfield_create_category', 'core_customfield_external', 'create_category', 'customfield/externallib.php', 'moodle', '', NULL),
(341, 'core_customfield_delete_category', 'core_customfield_external', 'delete_category', 'customfield/externallib.php', 'moodle', '', NULL),
(342, 'core_customfield_move_field', 'core_customfield_external', 'move_field', 'customfield/externallib.php', 'moodle', '', NULL),
(343, 'core_customfield_move_category', 'core_customfield_external', 'move_category', 'customfield/externallib.php', 'moodle', '', NULL),
(344, 'core_customfield_toggle_shared', 'core_customfield\\external\\toggle_shared_category', 'execute', NULL, 'moodle', '', NULL),
(345, 'core_h5p_get_trusted_h5p_file', 'core_h5p\\external', 'get_trusted_h5p_file', NULL, 'moodle', '', 'moodle_mobile_app'),
(346, 'core_table_get_dynamic_table_content', 'core_table\\external\\dynamic\\get', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(347, 'core_xapi_statement_post', 'core_xapi\\external\\post_statement', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(348, 'core_xapi_post_state', 'core_xapi\\external\\post_state', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(349, 'core_xapi_get_state', 'core_xapi\\external\\get_state', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(350, 'core_xapi_get_states', 'core_xapi\\external\\get_states', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(351, 'core_xapi_delete_state', 'core_xapi\\external\\delete_state', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(352, 'core_xapi_delete_states', 'core_xapi\\external\\delete_states', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(353, 'core_contentbank_delete_content', 'core_contentbank\\external\\delete_content', 'execute', NULL, 'moodle', 'moodle/contentbank:deleteanycontent', NULL),
(354, 'core_contentbank_rename_content', 'core_contentbank\\external\\rename_content', 'execute', NULL, 'moodle', 'moodle/contentbank:manageowncontent', NULL),
(355, 'core_contentbank_copy_content', 'core_contentbank\\external\\copy_content', 'execute', NULL, 'moodle', 'moodle/contentbank:copycontent, moodle/contentbank:copyanycontent', NULL),
(356, 'core_contentbank_set_content_visibility', 'core_contentbank\\external\\set_content_visibility', 'execute', NULL, 'moodle', 'moodle/contentbank:manageowncontent', NULL),
(357, 'core_create_userfeedback_action_record', 'core\\external\\record_userfeedback_action', 'execute', NULL, 'moodle', '', NULL),
(358, 'core_payment_get_available_gateways', 'core_payment\\external\\get_available_gateways', 'execute', NULL, 'moodle', '', NULL),
(359, 'core_reportbuilder_filters_reset', 'core_reportbuilder\\external\\filters\\reset', 'execute', NULL, 'moodle', '', NULL),
(360, 'core_reportbuilder_set_filters', 'core_reportbuilder\\external\\filters\\set', 'execute', NULL, 'moodle', '', NULL),
(361, 'core_dynamic_tabs_get_content', 'core\\external\\dynamic_tabs_get_content', 'execute', NULL, 'moodle', '', NULL),
(362, 'core_change_editmode', 'core\\external\\editmode', 'change_editmode', NULL, 'moodle', '', NULL),
(363, 'core_reportbuilder_reports_delete', 'core_reportbuilder\\external\\reports\\delete', 'execute', NULL, 'moodle', '', NULL),
(364, 'core_reportbuilder_reports_get', 'core_reportbuilder\\external\\reports\\get', 'execute', NULL, 'moodle', '', NULL),
(365, 'core_reportbuilder_list_reports', 'core_reportbuilder\\external\\reports\\listing', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(366, 'core_reportbuilder_retrieve_report', 'core_reportbuilder\\external\\reports\\retrieve', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(367, 'core_reportbuilder_retrieve_system_report', 'core_reportbuilder\\external\\systemreports\\retrieve', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(368, 'core_reportbuilder_can_view_system_report', 'core_reportbuilder\\external\\systemreports\\can_view', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(369, 'core_reportbuilder_view_report', 'core_reportbuilder\\external\\reports\\view', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(370, 'core_reportbuilder_columns_add', 'core_reportbuilder\\external\\columns\\add', 'execute', NULL, 'moodle', '', NULL),
(371, 'core_reportbuilder_columns_delete', 'core_reportbuilder\\external\\columns\\delete', 'execute', NULL, 'moodle', '', NULL),
(372, 'core_reportbuilder_columns_reorder', 'core_reportbuilder\\external\\columns\\reorder', 'execute', NULL, 'moodle', '', NULL),
(373, 'core_reportbuilder_columns_sort_get', 'core_reportbuilder\\external\\columns\\sort\\get', 'execute', NULL, 'moodle', '', NULL),
(374, 'core_reportbuilder_columns_sort_reorder', 'core_reportbuilder\\external\\columns\\sort\\reorder', 'execute', NULL, 'moodle', '', NULL),
(375, 'core_reportbuilder_columns_sort_toggle', 'core_reportbuilder\\external\\columns\\sort\\toggle', 'execute', NULL, 'moodle', '', NULL),
(376, 'core_reportbuilder_conditions_add', 'core_reportbuilder\\external\\conditions\\add', 'execute', NULL, 'moodle', '', NULL),
(377, 'core_reportbuilder_conditions_delete', 'core_reportbuilder\\external\\conditions\\delete', 'execute', NULL, 'moodle', '', NULL),
(378, 'core_reportbuilder_conditions_reorder', 'core_reportbuilder\\external\\conditions\\reorder', 'execute', NULL, 'moodle', '', NULL),
(379, 'core_reportbuilder_conditions_reset', 'core_reportbuilder\\external\\conditions\\reset', 'execute', NULL, 'moodle', '', NULL),
(380, 'core_reportbuilder_filters_add', 'core_reportbuilder\\external\\filters\\add', 'execute', NULL, 'moodle', '', NULL),
(381, 'core_reportbuilder_filters_delete', 'core_reportbuilder\\external\\filters\\delete', 'execute', NULL, 'moodle', '', NULL),
(382, 'core_reportbuilder_filters_reorder', 'core_reportbuilder\\external\\filters\\reorder', 'execute', NULL, 'moodle', '', NULL),
(383, 'core_reportbuilder_audiences_delete', 'core_reportbuilder\\external\\audiences\\delete', 'execute', NULL, 'moodle', '', NULL),
(384, 'core_reportbuilder_schedules_delete', 'core_reportbuilder\\external\\schedules\\delete', 'execute', NULL, 'moodle', '', NULL),
(385, 'core_reportbuilder_schedules_send', 'core_reportbuilder\\external\\schedules\\send', 'execute', NULL, 'moodle', '', NULL),
(386, 'core_reportbuilder_schedules_toggle', 'core_reportbuilder\\external\\schedules\\toggle', 'execute', NULL, 'moodle', '', NULL),
(387, 'core_admin_set_plugin_state', 'core_admin\\external\\set_plugin_state', 'execute', NULL, 'moodle', '', NULL),
(388, 'core_admin_set_plugin_order', 'core_admin\\external\\set_plugin_order', 'execute', NULL, 'moodle', '', NULL),
(389, 'core_admin_set_block_protection', 'core_admin\\external\\set_block_protection', 'execute', NULL, 'moodle', '', NULL),
(390, 'core_moodlenet_send_activity', 'core\\external\\moodlenet_send_activity', 'execute', NULL, 'moodle', '', NULL),
(391, 'core_moodlenet_get_share_info_activity', 'core\\external\\moodlenet_get_share_info_activity', 'execute', NULL, 'moodle', '', NULL),
(392, 'core_moodlenet_auth_check', 'core\\external\\moodlenet_auth_check', 'execute', NULL, 'moodle', '', NULL),
(393, 'core_moodlenet_get_shared_course_info', 'core\\external\\moodlenet_get_shared_course_info', 'execute', NULL, 'moodle', '', NULL),
(394, 'core_moodlenet_send_course', 'core\\external\\moodlenet_send_course', 'execute', NULL, 'moodle', '', NULL),
(395, 'core_output_poll_stored_progress', 'core\\external\\output\\poll_stored_progress', 'execute', NULL, 'moodle', '', NULL),
(396, 'core_ai_delete_provider_instance', 'core_ai\\external\\delete_provider_instance', 'execute', NULL, 'moodle', '', NULL),
(397, 'core_ai_set_policy_status', 'core_ai\\external\\set_policy_status', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(398, 'core_ai_get_policy_status', 'core_ai\\external\\get_policy_status', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(399, 'core_ai_set_action', 'core_ai\\external\\set_action', 'execute', NULL, 'moodle', '', NULL),
(400, 'core_ai_set_provider_status', 'core_ai\\external\\set_provider_status', 'execute', NULL, 'moodle', '', NULL),
(401, 'core_ai_set_provider_order', 'core_ai\\external\\set_provider_order', 'execute', NULL, 'moodle', '', NULL),
(402, 'core_sms_set_gateway_status', 'core_sms\\external\\sms_gateway_status', 'execute', NULL, 'moodle', '', NULL),
(403, 'core_question_move_questions', '\\core_question\\external\\move_questions', 'execute', NULL, 'moodle', '', NULL),
(404, 'core_question_search_shared_banks', '\\core_question\\external\\search_shared_banks', 'execute', NULL, 'moodle', '', NULL),
(405, 'core_message_set_unsent_message', 'core_message\\external\\set_unsent_message', 'execute', NULL, 'moodle', '', NULL),
(406, 'core_message_get_unsent_message', 'core_message\\external\\get_unsent_message', 'execute', NULL, 'moodle', '', NULL),
(407, 'aiplacement_courseassist_summarise_text', 'aiplacement_courseassist\\external\\summarise_text', 'execute', NULL, 'aiplacement_courseassist', '', 'moodle_mobile_app'),
(408, 'aiplacement_courseassist_explain_text', 'aiplacement_courseassist\\external\\explain_text', 'execute', NULL, 'aiplacement_courseassist', '', 'moodle_mobile_app'),
(409, 'aiplacement_editor_generate_image', 'aiplacement_editor\\external\\generate_image', 'execute', NULL, 'aiplacement_editor', '', 'moodle_mobile_app'),
(410, 'aiplacement_editor_generate_text', 'aiplacement_editor\\external\\generate_text', 'execute', NULL, 'aiplacement_editor', '', 'moodle_mobile_app'),
(411, 'mod_assign_copy_previous_attempt', 'mod_assign_external', 'copy_previous_attempt', 'mod/assign/externallib.php', 'mod_assign', 'mod/assign:view, mod/assign:submit', NULL),
(412, 'mod_assign_get_grades', 'mod_assign_external', 'get_grades', 'mod/assign/externallib.php', 'mod_assign', '', 'moodle_mobile_app'),
(413, 'mod_assign_get_assignments', 'mod_assign_external', 'get_assignments', 'mod/assign/externallib.php', 'mod_assign', '', 'moodle_mobile_app'),
(414, 'mod_assign_get_submissions', 'mod_assign_external', 'get_submissions', 'mod/assign/externallib.php', 'mod_assign', '', 'moodle_mobile_app'),
(415, 'mod_assign_get_user_flags', 'mod_assign_external', 'get_user_flags', 'mod/assign/externallib.php', 'mod_assign', '', 'moodle_mobile_app'),
(416, 'mod_assign_set_user_flags', 'mod_assign_external', 'set_user_flags', 'mod/assign/externallib.php', 'mod_assign', 'mod/assign:grade', 'moodle_mobile_app'),
(417, 'mod_assign_get_user_mappings', 'mod_assign_external', 'get_user_mappings', 'mod/assign/externallib.php', 'mod_assign', '', 'moodle_mobile_app'),
(418, 'mod_assign_revert_submissions_to_draft', 'mod_assign_external', 'revert_submissions_to_draft', 'mod/assign/externallib.php', 'mod_assign', '', 'moodle_mobile_app'),
(419, 'mod_assign_lock_submissions', 'mod_assign_external', 'lock_submissions', 'mod/assign/externallib.php', 'mod_assign', '', 'moodle_mobile_app'),
(420, 'mod_assign_unlock_submissions', 'mod_assign_external', 'unlock_submissions', 'mod/assign/externallib.php', 'mod_assign', '', 'moodle_mobile_app'),
(421, 'mod_assign_save_submission', 'mod_assign_external', 'save_submission', 'mod/assign/externallib.php', 'mod_assign', '', 'moodle_mobile_app'),
(422, 'mod_assign_submit_for_grading', 'mod_assign_external', 'submit_for_grading', 'mod/assign/externallib.php', 'mod_assign', '', 'moodle_mobile_app'),
(423, 'mod_assign_save_grade', 'mod_assign_external', 'save_grade', 'mod/assign/externallib.php', 'mod_assign', '', 'moodle_mobile_app'),
(424, 'mod_assign_save_grades', 'mod_assign_external', 'save_grades', 'mod/assign/externallib.php', 'mod_assign', '', 'moodle_mobile_app'),
(425, 'mod_assign_save_user_extensions', 'mod_assign_external', 'save_user_extensions', 'mod/assign/externallib.php', 'mod_assign', '', 'moodle_mobile_app'),
(426, 'mod_assign_reveal_identities', 'mod_assign_external', 'reveal_identities', 'mod/assign/externallib.php', 'mod_assign', '', 'moodle_mobile_app'),
(427, 'mod_assign_view_grading_table', 'mod_assign_external', 'view_grading_table', 'mod/assign/externallib.php', 'mod_assign', 'mod/assign:view, mod/assign:viewgrades', 'moodle_mobile_app'),
(428, 'mod_assign_view_submission_status', 'mod_assign_external', 'view_submission_status', 'mod/assign/externallib.php', 'mod_assign', 'mod/assign:view', 'moodle_mobile_app'),
(429, 'mod_assign_get_submission_status', 'mod_assign_external', 'get_submission_status', 'mod/assign/externallib.php', 'mod_assign', 'mod/assign:view', 'moodle_mobile_app'),
(430, 'mod_assign_list_participants', 'mod_assign_external', 'list_participants', 'mod/assign/externallib.php', 'mod_assign', 'mod/assign:view, mod/assign:viewgrades', 'moodle_mobile_app'),
(431, 'mod_assign_submit_grading_form', 'mod_assign_external', 'submit_grading_form', 'mod/assign/externallib.php', 'mod_assign', 'mod/assign:grade', 'moodle_mobile_app'),
(432, 'mod_assign_get_participant', 'mod_assign_external', 'get_participant', 'mod/assign/externallib.php', 'mod_assign', 'mod/assign:view, mod/assign:viewgrades', 'moodle_mobile_app'),
(433, 'mod_assign_view_assign', 'mod_assign_external', 'view_assign', 'mod/assign/externallib.php', 'mod_assign', 'mod/assign:view', 'moodle_mobile_app'),
(434, 'mod_assign_start_submission', 'mod_assign\\external\\start_submission', 'execute', NULL, 'mod_assign', 'mod/assign:view', 'moodle_mobile_app'),
(435, 'mod_assign_remove_submission', 'mod_assign\\external\\remove_submission', 'execute', NULL, 'mod_assign', 'mod/assign:submit', 'moodle_mobile_app'),
(436, 'mod_bigbluebuttonbn_can_join', 'mod_bigbluebuttonbn\\external\\can_join', 'execute', NULL, 'mod_bigbluebuttonbn', 'mod/bigbluebuttonbn:view', 'moodle_mobile_app'),
(437, 'mod_bigbluebuttonbn_get_recordings', 'mod_bigbluebuttonbn\\external\\get_recordings', 'execute', NULL, 'mod_bigbluebuttonbn', 'mod/bigbluebuttonbn:view', 'moodle_mobile_app'),
(438, 'mod_bigbluebuttonbn_get_recordings_to_import', 'mod_bigbluebuttonbn\\external\\get_recordings_to_import', 'execute', NULL, 'mod_bigbluebuttonbn', 'mod/bigbluebuttonbn:importrecordings', 'moodle_mobile_app'),
(439, 'mod_bigbluebuttonbn_update_recording', 'mod_bigbluebuttonbn\\external\\update_recording', 'execute', NULL, 'mod_bigbluebuttonbn', 'mod/bigbluebuttonbn:managerecordings', 'moodle_mobile_app'),
(440, 'mod_bigbluebuttonbn_end_meeting', 'mod_bigbluebuttonbn\\external\\end_meeting', 'execute', NULL, 'mod_bigbluebuttonbn', 'mod/bigbluebuttonbn:join', 'moodle_mobile_app'),
(441, 'mod_bigbluebuttonbn_completion_validate', 'mod_bigbluebuttonbn\\external\\completion_validate', 'execute', NULL, 'mod_bigbluebuttonbn', 'mod/bigbluebuttonbn:view', 'moodle_mobile_app'),
(442, 'mod_bigbluebuttonbn_meeting_info', 'mod_bigbluebuttonbn\\external\\meeting_info', 'execute', NULL, 'mod_bigbluebuttonbn', 'mod/bigbluebuttonbn:view', 'moodle_mobile_app'),
(443, 'mod_bigbluebuttonbn_get_bigbluebuttonbns_by_courses', 'mod_bigbluebuttonbn\\external\\get_bigbluebuttonbns_by_courses', 'execute', NULL, 'mod_bigbluebuttonbn', 'mod/bigbluebuttonbn:view', 'moodle_mobile_app'),
(444, 'mod_bigbluebuttonbn_view_bigbluebuttonbn', 'mod_bigbluebuttonbn\\external\\view_bigbluebuttonbn', 'execute', NULL, 'mod_bigbluebuttonbn', 'mod/bigbluebuttonbn:view', 'moodle_mobile_app'),
(445, 'mod_bigbluebuttonbn_get_join_url', 'mod_bigbluebuttonbn\\external\\get_join_url', 'execute', NULL, 'mod_bigbluebuttonbn', 'mod/bigbluebuttonbn:join', 'moodle_mobile_app'),
(446, 'mod_book_view_book', 'mod_book_external', 'view_book', NULL, 'mod_book', 'mod/book:read', 'moodle_mobile_app'),
(447, 'mod_book_get_books_by_courses', 'mod_book_external', 'get_books_by_courses', NULL, 'mod_book', '', 'moodle_mobile_app'),
(448, 'mod_choice_get_choice_results', 'mod_choice_external', 'get_choice_results', NULL, 'mod_choice', '', 'moodle_mobile_app'),
(449, 'mod_choice_get_choice_options', 'mod_choice_external', 'get_choice_options', NULL, 'mod_choice', 'mod/choice:choose', 'moodle_mobile_app'),
(450, 'mod_choice_submit_choice_response', 'mod_choice_external', 'submit_choice_response', NULL, 'mod_choice', 'mod/choice:choose', 'moodle_mobile_app'),
(451, 'mod_choice_view_choice', 'mod_choice_external', 'view_choice', NULL, 'mod_choice', '', 'moodle_mobile_app'),
(452, 'mod_choice_get_choices_by_courses', 'mod_choice_external', 'get_choices_by_courses', NULL, 'mod_choice', '', 'moodle_mobile_app'),
(453, 'mod_choice_delete_choice_responses', 'mod_choice_external', 'delete_choice_responses', NULL, 'mod_choice', 'mod/choice:choose', 'moodle_mobile_app'),
(454, 'mod_data_get_databases_by_courses', 'mod_data_external', 'get_databases_by_courses', NULL, 'mod_data', 'mod/data:viewentry', 'moodle_mobile_app'),
(455, 'mod_data_view_database', 'mod_data_external', 'view_database', NULL, 'mod_data', 'mod/data:viewentry', 'moodle_mobile_app'),
(456, 'mod_data_get_data_access_information', 'mod_data_external', 'get_data_access_information', NULL, 'mod_data', 'mod/data:viewentry', 'moodle_mobile_app'),
(457, 'mod_data_get_entries', 'mod_data_external', 'get_entries', NULL, 'mod_data', 'mod/data:viewentry', 'moodle_mobile_app'),
(458, 'mod_data_get_entry', 'mod_data_external', 'get_entry', NULL, 'mod_data', 'mod/data:viewentry', 'moodle_mobile_app'),
(459, 'mod_data_get_fields', 'mod_data_external', 'get_fields', NULL, 'mod_data', 'mod/data:viewentry', 'moodle_mobile_app'),
(460, 'mod_data_search_entries', 'mod_data_external', 'search_entries', NULL, 'mod_data', 'mod/data:viewentry', 'moodle_mobile_app'),
(461, 'mod_data_approve_entry', 'mod_data_external', 'approve_entry', NULL, 'mod_data', 'mod/data:approve', 'moodle_mobile_app'),
(462, 'mod_data_delete_entry', 'mod_data_external', 'delete_entry', NULL, 'mod_data', 'mod/data:manageentries', 'moodle_mobile_app'),
(463, 'mod_data_add_entry', 'mod_data_external', 'add_entry', NULL, 'mod_data', 'mod/data:writeentry', 'moodle_mobile_app'),
(464, 'mod_data_update_entry', 'mod_data_external', 'update_entry', NULL, 'mod_data', 'mod/data:writeentry', 'moodle_mobile_app'),
(465, 'mod_data_delete_saved_preset', 'mod_data\\external\\delete_saved_preset', 'execute', NULL, 'mod_data', 'mod/data:manageuserpresets', NULL),
(466, 'mod_data_get_mapping_information', 'mod_data\\external\\get_mapping_information', 'execute', NULL, 'mod_data', 'mod/data:managetemplates', NULL),
(467, 'mod_feedback_get_feedbacks_by_courses', 'mod_feedback_external', 'get_feedbacks_by_courses', NULL, 'mod_feedback', 'mod/feedback:view', 'moodle_mobile_app'),
(468, 'mod_feedback_get_feedback_access_information', 'mod_feedback_external', 'get_feedback_access_information', NULL, 'mod_feedback', 'mod/feedback:view', 'moodle_mobile_app'),
(469, 'mod_feedback_view_feedback', 'mod_feedback_external', 'view_feedback', NULL, 'mod_feedback', 'mod/feedback:view', 'moodle_mobile_app'),
(470, 'mod_feedback_get_current_completed_tmp', 'mod_feedback_external', 'get_current_completed_tmp', NULL, 'mod_feedback', 'mod/feedback:view', 'moodle_mobile_app'),
(471, 'mod_feedback_get_items', 'mod_feedback_external', 'get_items', NULL, 'mod_feedback', 'mod/feedback:view', 'moodle_mobile_app'),
(472, 'mod_feedback_launch_feedback', 'mod_feedback_external', 'launch_feedback', NULL, 'mod_feedback', 'mod/feedback:complete', 'moodle_mobile_app'),
(473, 'mod_feedback_get_page_items', 'mod_feedback_external', 'get_page_items', NULL, 'mod_feedback', 'mod/feedback:complete', 'moodle_mobile_app'),
(474, 'mod_feedback_process_page', 'mod_feedback_external', 'process_page', NULL, 'mod_feedback', 'mod/feedback:complete', 'moodle_mobile_app'),
(475, 'mod_feedback_get_analysis', 'mod_feedback_external', 'get_analysis', NULL, 'mod_feedback', 'mod/feedback:viewanalysepage', 'moodle_mobile_app'),
(476, 'mod_feedback_get_unfinished_responses', 'mod_feedback_external', 'get_unfinished_responses', NULL, 'mod_feedback', 'mod/feedback:view', 'moodle_mobile_app'),
(477, 'mod_feedback_get_finished_responses', 'mod_feedback_external', 'get_finished_responses', NULL, 'mod_feedback', 'mod/feedback:view', 'moodle_mobile_app'),
(478, 'mod_feedback_get_non_respondents', 'mod_feedback_external', 'get_non_respondents', NULL, 'mod_feedback', 'mod/feedback:viewreports', 'moodle_mobile_app'),
(479, 'mod_feedback_get_responses_analysis', 'mod_feedback_external', 'get_responses_analysis', NULL, 'mod_feedback', 'mod/feedback:viewreports', 'moodle_mobile_app'),
(480, 'mod_feedback_get_last_completed', 'mod_feedback_external', 'get_last_completed', NULL, 'mod_feedback', 'mod/feedback:view', 'moodle_mobile_app'),
(481, 'mod_feedback_questions_reorder', 'mod_feedback\\external\\questions\\reorder', 'execute', NULL, 'mod_feedback', 'mod/feedback:edititems', NULL),
(482, 'mod_folder_view_folder', 'mod_folder_external', 'view_folder', NULL, 'mod_folder', 'mod/folder:view', 'moodle_mobile_app'),
(483, 'mod_folder_get_folders_by_courses', 'mod_folder_external', 'get_folders_by_courses', NULL, 'mod_folder', 'mod/folder:view', 'moodle_mobile_app'),
(484, 'mod_forum_get_forums_by_courses', 'mod_forum_external', 'get_forums_by_courses', 'mod/forum/externallib.php', 'mod_forum', 'mod/forum:viewdiscussion', 'moodle_mobile_app'),
(485, 'mod_forum_get_discussion_posts', 'mod_forum_external', 'get_discussion_posts', 'mod/forum/externallib.php', 'mod_forum', 'mod/forum:viewdiscussion, mod/forum:viewqandawithoutposting', 'moodle_mobile_app'),
(486, 'mod_forum_get_forum_discussions', 'mod_forum_external', 'get_forum_discussions', 'mod/forum/externallib.php', 'mod_forum', 'mod/forum:viewdiscussion, mod/forum:viewqandawithoutposting', 'moodle_mobile_app'),
(487, 'mod_forum_view_forum', 'mod_forum_external', 'view_forum', 'mod/forum/externallib.php', 'mod_forum', 'mod/forum:viewdiscussion', 'moodle_mobile_app'),
(488, 'mod_forum_view_forum_discussion', 'mod_forum_external', 'view_forum_discussion', 'mod/forum/externallib.php', 'mod_forum', 'mod/forum:viewdiscussion', 'moodle_mobile_app'),
(489, 'mod_forum_add_discussion_post', 'mod_forum_external', 'add_discussion_post', 'mod/forum/externallib.php', 'mod_forum', 'mod/forum:replypost', 'moodle_mobile_app'),
(490, 'mod_forum_add_discussion', 'mod_forum_external', 'add_discussion', 'mod/forum/externallib.php', 'mod_forum', 'mod/forum:startdiscussion', 'moodle_mobile_app'),
(491, 'mod_forum_can_add_discussion', 'mod_forum_external', 'can_add_discussion', 'mod/forum/externallib.php', 'mod_forum', '', 'moodle_mobile_app'),
(492, 'mod_forum_get_forum_access_information', 'mod_forum_external', 'get_forum_access_information', NULL, 'mod_forum', '', 'moodle_mobile_app'),
(493, 'mod_forum_set_subscription_state', 'mod_forum_external', 'set_subscription_state', 'mod/forum/externallib.php', 'mod_forum', '', 'moodle_mobile_app'),
(494, 'mod_forum_set_lock_state', 'mod_forum_external', 'set_lock_state', 'mod/forum/externallib.php', 'mod_forum', 'moodle/course:manageactivities', 'moodle_mobile_app'),
(495, 'mod_forum_toggle_favourite_state', 'mod_forum_external', 'toggle_favourite_state', 'mod/forum/externallib.php', 'mod_forum', '', 'moodle_mobile_app'),
(496, 'mod_forum_set_pin_state', 'mod_forum_external', 'set_pin_state', 'mod/forum/externallib.php', 'mod_forum', '', 'moodle_mobile_app'),
(497, 'mod_forum_delete_post', 'mod_forum_external', 'delete_post', 'mod/forum/externallib.php', 'mod_forum', '', 'moodle_mobile_app'),
(498, 'mod_forum_get_discussion_posts_by_userid', 'mod_forum_external', 'get_discussion_posts_by_userid', 'mod/forum/externallib.php', 'mod_forum', 'mod/forum:viewdiscussion, mod/forum:viewqandawithoutposting', NULL),
(499, 'mod_forum_get_discussion_post', 'mod_forum_external', 'get_discussion_post', 'mod/forum/externallib.php', 'mod_forum', '', 'moodle_mobile_app'),
(500, 'mod_forum_prepare_draft_area_for_post', 'mod_forum_external', 'prepare_draft_area_for_post', 'mod/forum/externallib.php', 'mod_forum', '', 'moodle_mobile_app'),
(501, 'mod_forum_update_discussion_post', 'mod_forum_external', 'update_discussion_post', 'mod/forum/externallib.php', 'mod_forum', '', 'moodle_mobile_app'),
(502, 'mod_forum_set_forum_subscription', 'mod_forum\\external\\set_forum_subscription', 'execute', NULL, 'mod_forum', '', 'moodle_mobile_app'),
(503, 'mod_forum_set_forum_tracking', 'mod_forum\\external\\set_forum_tracking', 'execute', NULL, 'mod_forum', '', 'moodle_mobile_app'),
(504, 'mod_glossary_get_glossaries_by_courses', 'mod_glossary_external', 'get_glossaries_by_courses', NULL, 'mod_glossary', 'mod/glossary:view', 'moodle_mobile_app'),
(505, 'mod_glossary_view_glossary', 'mod_glossary_external', 'view_glossary', NULL, 'mod_glossary', 'mod/glossary:view', 'moodle_mobile_app'),
(506, 'mod_glossary_view_entry', 'mod_glossary_external', 'view_entry', NULL, 'mod_glossary', 'mod/glossary:view', 'moodle_mobile_app'),
(507, 'mod_glossary_get_entries_by_letter', 'mod_glossary_external', 'get_entries_by_letter', NULL, 'mod_glossary', 'mod/glossary:view', 'moodle_mobile_app'),
(508, 'mod_glossary_get_entries_by_date', 'mod_glossary_external', 'get_entries_by_date', NULL, 'mod_glossary', 'mod/glossary:view', 'moodle_mobile_app'),
(509, 'mod_glossary_get_categories', 'mod_glossary_external', 'get_categories', NULL, 'mod_glossary', 'mod/glossary:view', 'moodle_mobile_app'),
(510, 'mod_glossary_get_entries_by_category', 'mod_glossary_external', 'get_entries_by_category', NULL, 'mod_glossary', 'mod/glossary:view', 'moodle_mobile_app'),
(511, 'mod_glossary_get_authors', 'mod_glossary_external', 'get_authors', NULL, 'mod_glossary', 'mod/glossary:view', 'moodle_mobile_app'),
(512, 'mod_glossary_get_entries_by_author', 'mod_glossary_external', 'get_entries_by_author', NULL, 'mod_glossary', 'mod/glossary:view', 'moodle_mobile_app'),
(513, 'mod_glossary_get_entries_by_author_id', 'mod_glossary_external', 'get_entries_by_author_id', NULL, 'mod_glossary', 'mod/glossary:view', 'moodle_mobile_app'),
(514, 'mod_glossary_get_entries_by_search', 'mod_glossary_external', 'get_entries_by_search', NULL, 'mod_glossary', 'mod/glossary:view', 'moodle_mobile_app'),
(515, 'mod_glossary_get_entries_by_term', 'mod_glossary_external', 'get_entries_by_term', NULL, 'mod_glossary', 'mod/glossary:view', 'moodle_mobile_app'),
(516, 'mod_glossary_get_entries_to_approve', 'mod_glossary_external', 'get_entries_to_approve', NULL, 'mod_glossary', 'mod/glossary:approve', 'moodle_mobile_app'),
(517, 'mod_glossary_get_entry_by_id', 'mod_glossary_external', 'get_entry_by_id', NULL, 'mod_glossary', 'mod/glossary:view', 'moodle_mobile_app'),
(518, 'mod_glossary_add_entry', 'mod_glossary_external', 'add_entry', NULL, 'mod_glossary', 'mod/glossary:write', 'moodle_mobile_app'),
(519, 'mod_glossary_delete_entry', 'mod_glossary\\external\\delete_entry', 'execute', NULL, 'mod_glossary', '', 'moodle_mobile_app'),
(520, 'mod_glossary_update_entry', 'mod_glossary\\external\\update_entry', 'execute', NULL, 'mod_glossary', '', 'moodle_mobile_app'),
(521, 'mod_glossary_prepare_entry_for_edition', 'mod_glossary\\external\\prepare_entry', 'execute', NULL, 'mod_glossary', '', 'moodle_mobile_app'),
(522, 'mod_h5pactivity_get_h5pactivity_access_information', 'mod_h5pactivity\\external\\get_h5pactivity_access_information', 'execute', NULL, 'mod_h5pactivity', 'mod/h5pactivity:view', 'moodle_mobile_app'),
(523, 'mod_h5pactivity_view_h5pactivity', 'mod_h5pactivity\\external\\view_h5pactivity', 'execute', NULL, 'mod_h5pactivity', 'mod/h5pactivity:view', 'moodle_mobile_app'),
(524, 'mod_h5pactivity_get_attempts', 'mod_h5pactivity\\external\\get_attempts', 'execute', NULL, 'mod_h5pactivity', 'mod/h5pactivity:view', 'moodle_mobile_app'),
(525, 'mod_h5pactivity_get_results', 'mod_h5pactivity\\external\\get_results', 'execute', NULL, 'mod_h5pactivity', 'mod/h5pactivity:view', 'moodle_mobile_app'),
(526, 'mod_h5pactivity_get_h5pactivities_by_courses', 'mod_h5pactivity\\external\\get_h5pactivities_by_courses', 'execute', NULL, 'mod_h5pactivity', 'mod/h5pactivity:view', 'moodle_mobile_app'),
(527, 'mod_h5pactivity_log_report_viewed', 'mod_h5pactivity\\external\\log_report_viewed', 'execute', NULL, 'mod_h5pactivity', '', 'moodle_mobile_app'),
(528, 'mod_h5pactivity_get_user_attempts', 'mod_h5pactivity\\external\\get_user_attempts', 'execute', NULL, 'mod_h5pactivity', 'mod/h5pactivity:reviewattempts', 'moodle_mobile_app'),
(529, 'mod_imscp_view_imscp', 'mod_imscp_external', 'view_imscp', NULL, 'mod_imscp', 'mod/imscp:view', 'moodle_mobile_app'),
(530, 'mod_imscp_get_imscps_by_courses', 'mod_imscp_external', 'get_imscps_by_courses', NULL, 'mod_imscp', 'mod/imscp:view', 'moodle_mobile_app'),
(531, 'mod_label_get_labels_by_courses', 'mod_label_external', 'get_labels_by_courses', NULL, 'mod_label', 'mod/label:view', 'moodle_mobile_app'),
(532, 'mod_lesson_get_lessons_by_courses', 'mod_lesson_external', 'get_lessons_by_courses', NULL, 'mod_lesson', 'mod/lesson:view', 'moodle_mobile_app'),
(533, 'mod_lesson_get_lesson_access_information', 'mod_lesson_external', 'get_lesson_access_information', NULL, 'mod_lesson', 'mod/lesson:view', 'moodle_mobile_app'),
(534, 'mod_lesson_view_lesson', 'mod_lesson_external', 'view_lesson', NULL, 'mod_lesson', 'mod/lesson:view', 'moodle_mobile_app'),
(535, 'mod_lesson_get_questions_attempts', 'mod_lesson_external', 'get_questions_attempts', NULL, 'mod_lesson', 'mod/lesson:view', 'moodle_mobile_app'),
(536, 'mod_lesson_get_user_grade', 'mod_lesson_external', 'get_user_grade', NULL, 'mod_lesson', 'mod/lesson:view', 'moodle_mobile_app'),
(537, 'mod_lesson_get_user_attempt_grade', 'mod_lesson_external', 'get_user_attempt_grade', NULL, 'mod_lesson', 'mod/lesson:view', 'moodle_mobile_app'),
(538, 'mod_lesson_get_content_pages_viewed', 'mod_lesson_external', 'get_content_pages_viewed', NULL, 'mod_lesson', 'mod/lesson:view', 'moodle_mobile_app'),
(539, 'mod_lesson_get_user_timers', 'mod_lesson_external', 'get_user_timers', NULL, 'mod_lesson', 'mod/lesson:view', 'moodle_mobile_app'),
(540, 'mod_lesson_get_pages', 'mod_lesson_external', 'get_pages', NULL, 'mod_lesson', 'mod/lesson:view', 'moodle_mobile_app'),
(541, 'mod_lesson_launch_attempt', 'mod_lesson_external', 'launch_attempt', NULL, 'mod_lesson', 'mod/lesson:view', 'moodle_mobile_app'),
(542, 'mod_lesson_get_page_data', 'mod_lesson_external', 'get_page_data', NULL, 'mod_lesson', 'mod/lesson:view', 'moodle_mobile_app'),
(543, 'mod_lesson_process_page', 'mod_lesson_external', 'process_page', NULL, 'mod_lesson', 'mod/lesson:view', 'moodle_mobile_app'),
(544, 'mod_lesson_finish_attempt', 'mod_lesson_external', 'finish_attempt', NULL, 'mod_lesson', 'mod/lesson:view', 'moodle_mobile_app'),
(545, 'mod_lesson_get_attempts_overview', 'mod_lesson_external', 'get_attempts_overview', NULL, 'mod_lesson', 'mod/lesson:viewreports', 'moodle_mobile_app'),
(546, 'mod_lesson_get_user_attempt', 'mod_lesson_external', 'get_user_attempt', NULL, 'mod_lesson', 'mod/lesson:viewreports', 'moodle_mobile_app'),
(547, 'mod_lesson_get_pages_possible_jumps', 'mod_lesson_external', 'get_pages_possible_jumps', NULL, 'mod_lesson', 'mod/lesson:view', 'moodle_mobile_app'),
(548, 'mod_lesson_get_lesson', 'mod_lesson_external', 'get_lesson', NULL, 'mod_lesson', 'mod/lesson:view', 'moodle_mobile_app'),
(549, 'mod_lti_get_tool_launch_data', 'mod_lti_external', 'get_tool_launch_data', NULL, 'mod_lti', 'mod/lti:view', 'moodle_mobile_app'),
(550, 'mod_lti_get_ltis_by_courses', 'mod_lti_external', 'get_ltis_by_courses', NULL, 'mod_lti', 'mod/lti:view', 'moodle_mobile_app'),
(551, 'mod_lti_view_lti', 'mod_lti_external', 'view_lti', NULL, 'mod_lti', 'mod/lti:view', 'moodle_mobile_app'),
(552, 'mod_lti_get_tool_proxies', 'mod_lti_external', 'get_tool_proxies', NULL, 'mod_lti', 'moodle/site:config', NULL),
(553, 'mod_lti_create_tool_proxy', 'mod_lti_external', 'create_tool_proxy', NULL, 'mod_lti', 'moodle/site:config', NULL),
(554, 'mod_lti_delete_tool_proxy', 'mod_lti_external', 'delete_tool_proxy', NULL, 'mod_lti', 'moodle/site:config', NULL),
(555, 'mod_lti_get_tool_proxy_registration_request', 'mod_lti_external', 'get_tool_proxy_registration_request', NULL, 'mod_lti', 'moodle/site:config', NULL),
(556, 'mod_lti_get_tool_types', 'mod_lti_external', 'get_tool_types', NULL, 'mod_lti', 'moodle/site:config', NULL),
(557, 'mod_lti_get_tool_types_and_proxies', 'mod_lti\\external\\get_tool_types_and_proxies', 'execute', NULL, 'mod_lti', 'moodle/site:config', NULL),
(558, 'mod_lti_get_tool_types_and_proxies_count', 'mod_lti\\external\\get_tool_types_and_proxies_count', 'execute', NULL, 'mod_lti', 'moodle/site:config', NULL),
(559, 'mod_lti_create_tool_type', 'mod_lti_external', 'create_tool_type', NULL, 'mod_lti', 'moodle/site:config', NULL),
(560, 'mod_lti_update_tool_type', 'mod_lti_external', 'update_tool_type', NULL, 'mod_lti', 'moodle/site:config', NULL),
(561, 'mod_lti_delete_tool_type', 'mod_lti_external', 'delete_tool_type', NULL, 'mod_lti', 'moodle/site:config', NULL),
(562, 'mod_lti_delete_course_tool_type', 'mod_lti\\external\\delete_course_tool_type', 'execute', NULL, 'mod_lti', 'mod/lti:addcoursetool', NULL),
(563, 'mod_lti_toggle_showinactivitychooser', 'mod_lti\\external\\toggle_showinactivitychooser', 'execute', NULL, 'mod_lti', 'mod/lti:addcoursetool', NULL),
(564, 'mod_lti_is_cartridge', 'mod_lti_external', 'is_cartridge', NULL, 'mod_lti', 'moodle/site:config', NULL),
(565, 'mod_page_view_page', 'mod_page_external', 'view_page', NULL, 'mod_page', 'mod/page:view', 'moodle_mobile_app'),
(566, 'mod_page_get_pages_by_courses', 'mod_page_external', 'get_pages_by_courses', NULL, 'mod_page', 'mod/page:view', 'moodle_mobile_app'),
(567, 'mod_quiz_get_quizzes_by_courses', 'mod_quiz_external', 'get_quizzes_by_courses', NULL, 'mod_quiz', 'mod/quiz:view', 'moodle_mobile_app'),
(568, 'mod_quiz_view_quiz', 'mod_quiz_external', 'view_quiz', NULL, 'mod_quiz', 'mod/quiz:view', 'moodle_mobile_app'),
(569, 'mod_quiz_get_user_attempts', 'mod_quiz_external', 'get_user_attempts', NULL, 'mod_quiz', 'mod/quiz:view', 'moodle_mobile_app'),
(570, 'mod_quiz_get_user_quiz_attempts', 'mod_quiz_external', 'get_user_quiz_attempts', NULL, 'mod_quiz', 'mod/quiz:view', 'moodle_mobile_app'),
(571, 'mod_quiz_get_user_best_grade', 'mod_quiz_external', 'get_user_best_grade', NULL, 'mod_quiz', 'mod/quiz:view', 'moodle_mobile_app'),
(572, 'mod_quiz_get_combined_review_options', 'mod_quiz_external', 'get_combined_review_options', NULL, 'mod_quiz', 'mod/quiz:view', 'moodle_mobile_app'),
(573, 'mod_quiz_start_attempt', 'mod_quiz_external', 'start_attempt', NULL, 'mod_quiz', 'mod/quiz:attempt', 'moodle_mobile_app'),
(574, 'mod_quiz_get_attempt_data', 'mod_quiz_external', 'get_attempt_data', NULL, 'mod_quiz', 'mod/quiz:attempt', 'moodle_mobile_app'),
(575, 'mod_quiz_get_attempt_summary', 'mod_quiz_external', 'get_attempt_summary', NULL, 'mod_quiz', 'mod/quiz:attempt', 'moodle_mobile_app'),
(576, 'mod_quiz_save_attempt', 'mod_quiz_external', 'save_attempt', NULL, 'mod_quiz', 'mod/quiz:attempt', 'moodle_mobile_app'),
(577, 'mod_quiz_process_attempt', 'mod_quiz_external', 'process_attempt', NULL, 'mod_quiz', 'mod/quiz:attempt', 'moodle_mobile_app'),
(578, 'mod_quiz_get_attempt_review', 'mod_quiz_external', 'get_attempt_review', NULL, 'mod_quiz', 'mod/quiz:reviewmyattempts', 'moodle_mobile_app'),
(579, 'mod_quiz_view_attempt', 'mod_quiz_external', 'view_attempt', NULL, 'mod_quiz', 'mod/quiz:attempt', 'moodle_mobile_app'),
(580, 'mod_quiz_view_attempt_summary', 'mod_quiz_external', 'view_attempt_summary', NULL, 'mod_quiz', 'mod/quiz:attempt', 'moodle_mobile_app'),
(581, 'mod_quiz_view_attempt_review', 'mod_quiz_external', 'view_attempt_review', NULL, 'mod_quiz', 'mod/quiz:reviewmyattempts', 'moodle_mobile_app'),
(582, 'mod_quiz_get_quiz_feedback_for_grade', 'mod_quiz_external', 'get_quiz_feedback_for_grade', NULL, 'mod_quiz', 'mod/quiz:view', 'moodle_mobile_app'),
(583, 'mod_quiz_get_quiz_access_information', 'mod_quiz_external', 'get_quiz_access_information', NULL, 'mod_quiz', 'mod/quiz:view', 'moodle_mobile_app'),
(584, 'mod_quiz_get_attempt_access_information', 'mod_quiz_external', 'get_attempt_access_information', NULL, 'mod_quiz', 'mod/quiz:view', 'moodle_mobile_app'),
(585, 'mod_quiz_get_quiz_required_qtypes', 'mod_quiz_external', 'get_quiz_required_qtypes', NULL, 'mod_quiz', 'mod/quiz:view', 'moodle_mobile_app'),
(586, 'mod_quiz_set_question_version', 'mod_quiz\\external\\submit_question_version', 'execute', NULL, 'mod_quiz', 'mod/quiz:view', NULL),
(587, 'mod_quiz_reopen_attempt', 'mod_quiz\\external\\reopen_attempt', 'execute', NULL, 'mod_quiz', 'mod/quiz:reopenattempts', NULL),
(588, 'mod_quiz_get_reopen_attempt_confirmation', 'mod_quiz\\external\\get_reopen_attempt_confirmation', 'execute', NULL, 'mod_quiz', 'mod/quiz:reopenattempts', NULL),
(589, 'mod_quiz_add_random_questions', 'mod_quiz\\external\\add_random_questions', 'execute', NULL, 'mod_quiz', 'mod/quiz:manage', NULL),
(590, 'mod_quiz_update_filter_condition', 'mod_quiz\\external\\update_filter_condition', 'execute', NULL, 'mod_quiz', 'mod/quiz:manage', NULL),
(591, 'mod_quiz_save_overrides', 'mod_quiz\\external\\save_overrides', 'execute', NULL, 'mod_quiz', 'mod/quiz:manageoverrides', NULL),
(592, 'mod_quiz_delete_overrides', 'mod_quiz\\external\\delete_overrides', 'execute', NULL, 'mod_quiz', 'mod/quiz:manageoverrides', NULL),
(593, 'mod_quiz_get_overrides', 'mod_quiz\\external\\get_overrides', 'execute', NULL, 'mod_quiz', 'mod/quiz:manageoverrides', NULL),
(594, 'mod_quiz_create_grade_items', 'mod_quiz\\external\\create_grade_items', 'execute', NULL, 'mod_quiz', 'mod/quiz:manage', NULL),
(595, 'mod_quiz_delete_grade_items', 'mod_quiz\\external\\delete_grade_items', 'execute', NULL, 'mod_quiz', 'mod/quiz:manage', NULL),
(596, 'mod_quiz_update_grade_items', 'mod_quiz\\external\\update_grade_items', 'execute', NULL, 'mod_quiz', 'mod/quiz:manage', NULL),
(597, 'mod_quiz_update_slots', 'mod_quiz\\external\\update_slots', 'execute', NULL, 'mod_quiz', 'mod/quiz:manage', NULL),
(598, 'mod_quiz_get_edit_grading_page_data', 'mod_quiz\\external\\get_edit_grading_page_data', 'execute', NULL, 'mod_quiz', 'mod/quiz:manage', NULL),
(599, 'mod_quiz_create_grade_item_per_section', 'mod_quiz\\external\\create_grade_item_per_section', 'execute', NULL, 'mod_quiz', 'mod/quiz:manage', NULL),
(600, 'mod_resource_view_resource', 'mod_resource_external', 'view_resource', NULL, 'mod_resource', 'mod/resource:view', 'moodle_mobile_app'),
(601, 'mod_resource_get_resources_by_courses', 'mod_resource_external', 'get_resources_by_courses', NULL, 'mod_resource', 'mod/resource:view', 'moodle_mobile_app'),
(602, 'mod_scorm_view_scorm', 'mod_scorm_external', 'view_scorm', NULL, 'mod_scorm', '', 'moodle_mobile_app'),
(603, 'mod_scorm_get_scorm_attempt_count', 'mod_scorm_external', 'get_scorm_attempt_count', NULL, 'mod_scorm', '', 'moodle_mobile_app'),
(604, 'mod_scorm_get_scorm_scoes', 'mod_scorm_external', 'get_scorm_scoes', NULL, 'mod_scorm', '', 'moodle_mobile_app'),
(605, 'mod_scorm_get_scorm_user_data', 'mod_scorm_external', 'get_scorm_user_data', NULL, 'mod_scorm', '', 'moodle_mobile_app'),
(606, 'mod_scorm_insert_scorm_tracks', 'mod_scorm_external', 'insert_scorm_tracks', NULL, 'mod_scorm', 'mod/scorm:savetrack', 'moodle_mobile_app'),
(607, 'mod_scorm_get_scorm_sco_tracks', 'mod_scorm_external', 'get_scorm_sco_tracks', NULL, 'mod_scorm', '', 'moodle_mobile_app'),
(608, 'mod_scorm_get_scorms_by_courses', 'mod_scorm_external', 'get_scorms_by_courses', NULL, 'mod_scorm', '', 'moodle_mobile_app'),
(609, 'mod_scorm_launch_sco', 'mod_scorm_external', 'launch_sco', NULL, 'mod_scorm', '', 'moodle_mobile_app'),
(610, 'mod_scorm_get_scorm_access_information', 'mod_scorm_external', 'get_scorm_access_information', NULL, 'mod_scorm', '', 'moodle_mobile_app'),
(611, 'mod_url_view_url', 'mod_url_external', 'view_url', NULL, 'mod_url', 'mod/url:view', 'moodle_mobile_app'),
(612, 'mod_url_get_urls_by_courses', 'mod_url_external', 'get_urls_by_courses', NULL, 'mod_url', 'mod/url:view', 'moodle_mobile_app'),
(613, 'mod_wiki_get_wikis_by_courses', 'mod_wiki_external', 'get_wikis_by_courses', NULL, 'mod_wiki', 'mod/wiki:viewpage', 'moodle_mobile_app'),
(614, 'mod_wiki_view_wiki', 'mod_wiki_external', 'view_wiki', NULL, 'mod_wiki', 'mod/wiki:viewpage', 'moodle_mobile_app'),
(615, 'mod_wiki_view_page', 'mod_wiki_external', 'view_page', NULL, 'mod_wiki', 'mod/wiki:viewpage', 'moodle_mobile_app'),
(616, 'mod_wiki_get_subwikis', 'mod_wiki_external', 'get_subwikis', NULL, 'mod_wiki', 'mod/wiki:viewpage', 'moodle_mobile_app'),
(617, 'mod_wiki_get_subwiki_pages', 'mod_wiki_external', 'get_subwiki_pages', NULL, 'mod_wiki', 'mod/wiki:viewpage', 'moodle_mobile_app'),
(618, 'mod_wiki_get_subwiki_files', 'mod_wiki_external', 'get_subwiki_files', NULL, 'mod_wiki', 'mod/wiki:viewpage', 'moodle_mobile_app'),
(619, 'mod_wiki_get_page_contents', 'mod_wiki_external', 'get_page_contents', NULL, 'mod_wiki', 'mod/wiki:viewpage', 'moodle_mobile_app'),
(620, 'mod_wiki_get_page_for_editing', 'mod_wiki_external', 'get_page_for_editing', NULL, 'mod_wiki', 'mod/wiki:editpage', 'moodle_mobile_app'),
(621, 'mod_wiki_new_page', 'mod_wiki_external', 'new_page', NULL, 'mod_wiki', 'mod/wiki:editpage', 'moodle_mobile_app'),
(622, 'mod_wiki_edit_page', 'mod_wiki_external', 'edit_page', NULL, 'mod_wiki', 'mod/wiki:editpage', 'moodle_mobile_app'),
(623, 'mod_workshop_get_workshops_by_courses', 'mod_workshop_external', 'get_workshops_by_courses', NULL, 'mod_workshop', 'mod/workshop:view', 'moodle_mobile_app'),
(624, 'mod_workshop_get_workshop_access_information', 'mod_workshop_external', 'get_workshop_access_information', NULL, 'mod_workshop', 'mod/workshop:view', 'moodle_mobile_app'),
(625, 'mod_workshop_get_user_plan', 'mod_workshop_external', 'get_user_plan', NULL, 'mod_workshop', 'mod/workshop:view', 'moodle_mobile_app'),
(626, 'mod_workshop_view_workshop', 'mod_workshop_external', 'view_workshop', NULL, 'mod_workshop', 'mod/workshop:view', 'moodle_mobile_app'),
(627, 'mod_workshop_add_submission', 'mod_workshop_external', 'add_submission', NULL, 'mod_workshop', 'mod/workshop:submit', 'moodle_mobile_app'),
(628, 'mod_workshop_update_submission', 'mod_workshop_external', 'update_submission', NULL, 'mod_workshop', 'mod/workshop:submit', 'moodle_mobile_app'),
(629, 'mod_workshop_delete_submission', 'mod_workshop_external', 'delete_submission', NULL, 'mod_workshop', 'mod/workshop:submit', 'moodle_mobile_app'),
(630, 'mod_workshop_get_submissions', 'mod_workshop_external', 'get_submissions', NULL, 'mod_workshop', '', 'moodle_mobile_app'),
(631, 'mod_workshop_get_submission', 'mod_workshop_external', 'get_submission', NULL, 'mod_workshop', '', 'moodle_mobile_app'),
(632, 'mod_workshop_get_submission_assessments', 'mod_workshop_external', 'get_submission_assessments', NULL, 'mod_workshop', '', 'moodle_mobile_app'),
(633, 'mod_workshop_get_assessment', 'mod_workshop_external', 'get_assessment', NULL, 'mod_workshop', '', 'moodle_mobile_app'),
(634, 'mod_workshop_get_assessment_form_definition', 'mod_workshop_external', 'get_assessment_form_definition', NULL, 'mod_workshop', '', 'moodle_mobile_app'),
(635, 'mod_workshop_get_reviewer_assessments', 'mod_workshop_external', 'get_reviewer_assessments', NULL, 'mod_workshop', '', 'moodle_mobile_app'),
(636, 'mod_workshop_update_assessment', 'mod_workshop_external', 'update_assessment', NULL, 'mod_workshop', '', 'moodle_mobile_app'),
(637, 'mod_workshop_get_grades', 'mod_workshop_external', 'get_grades', NULL, 'mod_workshop', '', 'moodle_mobile_app'),
(638, 'mod_workshop_evaluate_assessment', 'mod_workshop_external', 'evaluate_assessment', NULL, 'mod_workshop', '', 'moodle_mobile_app'),
(639, 'mod_workshop_get_grades_report', 'mod_workshop_external', 'get_grades_report', NULL, 'mod_workshop', '', 'moodle_mobile_app'),
(640, 'mod_workshop_view_submission', 'mod_workshop_external', 'view_submission', NULL, 'mod_workshop', 'mod/workshop:view', 'moodle_mobile_app'),
(641, 'mod_workshop_evaluate_submission', 'mod_workshop_external', 'evaluate_submission', NULL, 'mod_workshop', '', 'moodle_mobile_app'),
(642, 'auth_email_get_signup_settings', 'auth_email_external', 'get_signup_settings', NULL, 'auth_email', '', NULL),
(643, 'auth_email_signup_user', 'auth_email_external', 'signup_user', NULL, 'auth_email', '', NULL),
(644, 'customfield_number_recalculate_value', 'customfield_number\\external\\recalculate', 'execute', NULL, 'customfield_number', '', NULL),
(645, 'enrol_guest_get_instance_info', 'enrol_guest_external', 'get_instance_info', NULL, 'enrol_guest', '', 'moodle_mobile_app'),
(646, 'enrol_guest_validate_password', 'enrol_guest\\external\\validate_password', 'execute', NULL, 'enrol_guest', '', 'moodle_mobile_app'),
(647, 'enrol_manual_enrol_users', 'enrol_manual_external', 'enrol_users', 'enrol/manual/externallib.php', 'enrol_manual', 'enrol/manual:enrol', NULL),
(648, 'enrol_manual_unenrol_users', 'enrol_manual_external', 'unenrol_users', 'enrol/manual/externallib.php', 'enrol_manual', 'enrol/manual:unenrol', NULL),
(649, 'enrol_meta_add_instances', 'enrol_meta\\external\\add_instances', 'execute', NULL, 'enrol_meta', 'enrol/meta:config', NULL),
(650, 'enrol_meta_delete_instances', 'enrol_meta\\external\\delete_instances', 'execute', NULL, 'enrol_meta', 'enrol/meta:config', NULL),
(651, 'enrol_self_get_instance_info', 'enrol_self_external', 'get_instance_info', 'enrol/self/externallib.php', 'enrol_self', '', 'moodle_mobile_app'),
(652, 'enrol_self_enrol_user', 'enrol_self_external', 'enrol_user', 'enrol/self/externallib.php', 'enrol_self', '', 'moodle_mobile_app'),
(653, 'message_airnotifier_is_system_configured', 'message_airnotifier_external', 'is_system_configured', 'message/output/airnotifier/externallib.php', 'message_airnotifier', '', 'moodle_mobile_app'),
(654, 'message_airnotifier_are_notification_preferences_configured', 'message_airnotifier_external', 'are_notification_preferences_configured', 'message/output/airnotifier/externallib.php', 'message_airnotifier', '', 'moodle_mobile_app'),
(655, 'message_airnotifier_get_user_devices', 'message_airnotifier_external', 'get_user_devices', 'message/output/airnotifier/externallib.php', 'message_airnotifier', '', 'moodle_mobile_app'),
(656, 'message_airnotifier_enable_device', 'message_airnotifier_external', 'enable_device', 'message/output/airnotifier/externallib.php', 'message_airnotifier', 'message/airnotifier:managedevice', 'moodle_mobile_app'),
(657, 'message_popup_get_popup_notifications', 'message_popup_external', 'get_popup_notifications', 'message/output/popup/externallib.php', 'message_popup', '', 'moodle_mobile_app'),
(658, 'message_popup_get_unread_popup_notification_count', 'message_popup_external', 'get_unread_popup_notification_count', 'message/output/popup/externallib.php', 'message_popup', '', 'moodle_mobile_app'),
(659, 'block_accessreview_get_module_data', 'block_accessreview\\external\\get_module_data', 'execute', NULL, 'block_accessreview', 'block/accessreview:view', NULL),
(660, 'block_accessreview_get_section_data', 'block_accessreview\\external\\get_section_data', 'execute', NULL, 'block_accessreview', 'block/accessreview:view', NULL),
(661, 'block_recentlyaccesseditems_get_recent_items', 'block_recentlyaccesseditems\\external', 'get_recent_items', NULL, 'block_recentlyaccesseditems', '', 'moodle_mobile_app'),
(662, 'block_starredcourses_get_starred_courses', 'block_starredcourses_external', 'get_starred_courses', 'block/starredcourses/classes/external.php', 'block_starredcourses', '', 'moodle_mobile_app'),
(663, 'media_videojs_get_language', 'media_videojs\\external\\get_language', 'execute', NULL, 'media_videojs', '', NULL),
(664, 'editor_tiny_get_configuration', 'editor_tiny\\external\\get_configuration', 'execute', NULL, 'editor_tiny', '', 'moodle_mobile_app'),
(665, 'report_competency_data_for_report', 'report_competency\\external', 'data_for_report', NULL, 'report_competency', 'moodle/competency:coursecompetencyview', NULL);
INSERT INTO `[[dbprefix]]external_functions` VALUES
(666, 'report_insights_action_executed', 'report_insights\\external', 'action_executed', NULL, 'report_insights', '', 'moodle_mobile_app'),
(667, 'gradereport_grader_get_users_in_report', 'gradereport_grader\\external\\get_users_in_report', 'execute', NULL, 'gradereport_grader', 'gradereport/grader:view', 'moodle_mobile_app'),
(668, 'gradereport_overview_get_course_grades', 'gradereport_overview_external', 'get_course_grades', NULL, 'gradereport_overview', '', 'moodle_mobile_app'),
(669, 'gradereport_overview_view_grade_report', 'gradereport_overview_external', 'view_grade_report', NULL, 'gradereport_overview', 'gradereport/overview:view', 'moodle_mobile_app'),
(670, 'gradereport_singleview_get_grade_items_for_search_widget', 'gradereport_singleview\\external\\singleview', 'get_grade_items_for_search_widget', NULL, 'gradereport_singleview', 'gradereport/singleview:view', 'moodle_mobile_app'),
(671, 'gradereport_user_get_grades_table', 'gradereport_user\\external\\user', 'get_grades_table', NULL, 'gradereport_user', 'gradereport/user:view', 'moodle_mobile_app'),
(672, 'gradereport_user_view_grade_report', 'gradereport_user\\external\\user', 'view_grade_report', NULL, 'gradereport_user', 'gradereport/user:view', 'moodle_mobile_app'),
(673, 'gradereport_user_get_grade_items', 'gradereport_user\\external\\user', 'get_grade_items', NULL, 'gradereport_user', 'gradereport/user:view', 'moodle_mobile_app'),
(674, 'gradereport_user_get_access_information', 'gradereport_user\\external\\get_access_information', 'execute', NULL, 'gradereport_user', '', 'moodle_mobile_app'),
(675, 'gradingform_guide_grader_gradingpanel_fetch', 'gradingform_guide\\grades\\grader\\gradingpanel\\external\\fetch', 'execute', NULL, 'gradingform_guide', '', NULL),
(676, 'gradingform_guide_grader_gradingpanel_store', 'gradingform_guide\\grades\\grader\\gradingpanel\\external\\store', 'execute', NULL, 'gradingform_guide', '', NULL),
(677, 'gradingform_rubric_grader_gradingpanel_fetch', 'gradingform_rubric\\grades\\grader\\gradingpanel\\external\\fetch', 'execute', NULL, 'gradingform_rubric', '', NULL),
(678, 'gradingform_rubric_grader_gradingpanel_store', 'gradingform_rubric\\grades\\grader\\gradingpanel\\external\\store', 'execute', NULL, 'gradingform_rubric', '', NULL),
(679, 'qbank_columnsortorder_set_columnbank_order', 'qbank_columnsortorder\\external\\set_columnbank_order', 'execute', NULL, 'qbank_columnsortorder', '', NULL),
(680, 'qbank_columnsortorder_set_hidden_columns', 'qbank_columnsortorder\\external\\set_hidden_columns', 'execute', NULL, 'qbank_columnsortorder', '', NULL),
(681, 'qbank_columnsortorder_set_column_size', 'qbank_columnsortorder\\external\\set_column_size', 'execute', NULL, 'qbank_columnsortorder', '', NULL),
(682, 'qbank_editquestion_set_status', 'qbank_editquestion\\external\\update_question_version_status', 'execute', NULL, 'qbank_editquestion', '', NULL),
(683, 'qbank_managecategories_move_category', 'qbank_managecategories\\external\\move_category', 'execute', NULL, 'qbank_managecategories', 'moodle/question:managecategory', NULL),
(684, 'qbank_tagquestion_submit_tags_form', 'qbank_tagquestion\\external\\submit_tags', 'execute', NULL, 'qbank_tagquestion', '', NULL),
(685, 'qbank_viewquestiontext_set_question_text_format', 'qbank_viewquestiontext\\external\\set_question_text_format', 'execute', NULL, 'qbank_viewquestiontext', '', NULL),
(686, 'tool_admin_presets_delete_preset', 'tool_admin_presets\\external\\delete_preset', 'execute', NULL, 'tool_admin_presets', '', NULL),
(687, 'tool_analytics_potential_contexts', 'tool_analytics\\external', 'potential_contexts', NULL, 'tool_analytics', '', 'moodle_mobile_app'),
(688, 'tool_behat_get_entity_generator', 'tool_behat\\external\\get_entity_generator', 'execute', NULL, 'tool_behat', 'moodle/site:config', NULL),
(689, 'tool_dataprivacy_cancel_data_request', 'tool_dataprivacy\\external', 'cancel_data_request', NULL, 'tool_dataprivacy', '', 'moodle_mobile_app'),
(690, 'tool_dataprivacy_contact_dpo', 'tool_dataprivacy\\external', 'contact_dpo', NULL, 'tool_dataprivacy', '', 'moodle_mobile_app'),
(691, 'tool_dataprivacy_mark_complete', 'tool_dataprivacy\\external', 'mark_complete', NULL, 'tool_dataprivacy', 'tool/dataprivacy:managedatarequests', NULL),
(692, 'tool_dataprivacy_get_data_request', 'tool_dataprivacy\\external', 'get_data_request', NULL, 'tool_dataprivacy', 'tool/dataprivacy:managedatarequests', NULL),
(693, 'tool_dataprivacy_approve_data_request', 'tool_dataprivacy\\external', 'approve_data_request', NULL, 'tool_dataprivacy', 'tool/dataprivacy:managedatarequests', NULL),
(694, 'tool_dataprivacy_submit_selected_courses_form', 'tool_dataprivacy\\external\\submit_selected_courses_form', 'execute', NULL, 'tool_dataprivacy', 'tool/dataprivacy:managedatarequests', NULL),
(695, 'tool_dataprivacy_bulk_approve_data_requests', 'tool_dataprivacy\\external', 'bulk_approve_data_requests', NULL, 'tool_dataprivacy', 'tool/dataprivacy:managedatarequests', NULL),
(696, 'tool_dataprivacy_deny_data_request', 'tool_dataprivacy\\external', 'deny_data_request', NULL, 'tool_dataprivacy', 'tool/dataprivacy:managedatarequests', NULL),
(697, 'tool_dataprivacy_bulk_deny_data_requests', 'tool_dataprivacy\\external', 'bulk_deny_data_requests', NULL, 'tool_dataprivacy', 'tool/dataprivacy:managedatarequests', NULL),
(698, 'tool_dataprivacy_get_users', 'tool_dataprivacy\\external', 'get_users', NULL, 'tool_dataprivacy', 'tool/dataprivacy:managedatarequests', NULL),
(699, 'tool_dataprivacy_create_purpose_form', 'tool_dataprivacy\\external', 'create_purpose_form', NULL, 'tool_dataprivacy', '', NULL),
(700, 'tool_dataprivacy_create_category_form', 'tool_dataprivacy\\external', 'create_category_form', NULL, 'tool_dataprivacy', '', NULL),
(701, 'tool_dataprivacy_delete_purpose', 'tool_dataprivacy\\external', 'delete_purpose', NULL, 'tool_dataprivacy', '', NULL),
(702, 'tool_dataprivacy_delete_category', 'tool_dataprivacy\\external', 'delete_category', NULL, 'tool_dataprivacy', '', NULL),
(703, 'tool_dataprivacy_set_contextlevel_form', 'tool_dataprivacy\\external', 'set_contextlevel_form', NULL, 'tool_dataprivacy', '', NULL),
(704, 'tool_dataprivacy_set_context_form', 'tool_dataprivacy\\external', 'set_context_form', NULL, 'tool_dataprivacy', '', NULL),
(705, 'tool_dataprivacy_tree_extra_branches', 'tool_dataprivacy\\external', 'tree_extra_branches', NULL, 'tool_dataprivacy', '', NULL),
(706, 'tool_dataprivacy_confirm_contexts_for_deletion', 'tool_dataprivacy\\external', 'confirm_contexts_for_deletion', NULL, 'tool_dataprivacy', '', NULL),
(707, 'tool_dataprivacy_set_context_defaults', 'tool_dataprivacy\\external', 'set_context_defaults', NULL, 'tool_dataprivacy', 'tool/dataprivacy:managedataregistry', NULL),
(708, 'tool_dataprivacy_get_category_options', 'tool_dataprivacy\\external', 'get_category_options', NULL, 'tool_dataprivacy', 'tool/dataprivacy:managedataregistry', NULL),
(709, 'tool_dataprivacy_get_purpose_options', 'tool_dataprivacy\\external', 'get_purpose_options', NULL, 'tool_dataprivacy', 'tool/dataprivacy:managedataregistry', NULL),
(710, 'tool_dataprivacy_get_activity_options', 'tool_dataprivacy\\external', 'get_activity_options', NULL, 'tool_dataprivacy', 'tool/dataprivacy:managedataregistry', NULL),
(711, 'tool_dataprivacy_get_access_information', '\\tool_dataprivacy\\external\\get_access_information', 'execute', NULL, 'tool_dataprivacy', '', 'moodle_mobile_app'),
(712, 'tool_dataprivacy_create_data_request', '\\tool_dataprivacy\\external\\create_data_request', 'execute', NULL, 'tool_dataprivacy', '', 'moodle_mobile_app'),
(713, 'tool_dataprivacy_get_data_requests', '\\tool_dataprivacy\\external\\get_data_requests', 'execute', NULL, 'tool_dataprivacy', '', 'moodle_mobile_app'),
(714, 'tool_lp_data_for_competency_frameworks_manage_page', 'tool_lp\\external', 'data_for_competency_frameworks_manage_page', NULL, 'tool_lp', 'moodle/competency:competencyview', NULL),
(715, 'tool_lp_data_for_competency_summary', 'tool_lp\\external', 'data_for_competency_summary', NULL, 'tool_lp', 'moodle/competency:competencyview', NULL),
(716, 'tool_lp_data_for_competencies_manage_page', 'tool_lp\\external', 'data_for_competencies_manage_page', NULL, 'tool_lp', 'moodle/competency:competencyview', NULL),
(717, 'tool_lp_list_courses_using_competency', 'tool_lp\\external', 'list_courses_using_competency', NULL, 'tool_lp', 'moodle/competency:coursecompetencyview', NULL),
(718, 'tool_lp_data_for_course_competencies_page', 'tool_lp\\external', 'data_for_course_competencies_page', NULL, 'tool_lp', 'moodle/competency:coursecompetencyview', 'moodle_mobile_app'),
(719, 'tool_lp_data_for_template_competencies_page', 'tool_lp\\external', 'data_for_template_competencies_page', NULL, 'tool_lp', 'moodle/competency:templateview', NULL),
(720, 'tool_lp_data_for_templates_manage_page', 'tool_lp\\external', 'data_for_templates_manage_page', NULL, 'tool_lp', 'moodle/competency:templateview', NULL),
(721, 'tool_lp_data_for_plans_page', 'tool_lp\\external', 'data_for_plans_page', NULL, 'tool_lp', 'moodle/competency:planviewown', 'moodle_mobile_app'),
(722, 'tool_lp_data_for_plan_page', 'tool_lp\\external', 'data_for_plan_page', NULL, 'tool_lp', 'moodle/competency:planview', 'moodle_mobile_app'),
(723, 'tool_lp_data_for_related_competencies_section', 'tool_lp\\external', 'data_for_related_competencies_section', NULL, 'tool_lp', 'moodle/competency:competencyview', NULL),
(724, 'tool_lp_search_users', 'tool_lp\\external', 'search_users', NULL, 'tool_lp', 'moodle/competency:templatemanage', NULL),
(725, 'tool_lp_search_cohorts', 'core_cohort_external', 'search_cohorts', 'cohort/externallib.php', 'tool_lp', 'moodle/cohort:view', NULL),
(726, 'tool_lp_data_for_user_evidence_list_page', 'tool_lp\\external', 'data_for_user_evidence_list_page', NULL, 'tool_lp', 'moodle/competency:userevidenceview', 'moodle_mobile_app'),
(727, 'tool_lp_data_for_user_evidence_page', 'tool_lp\\external', 'data_for_user_evidence_page', NULL, 'tool_lp', 'moodle/competency:userevidenceview', 'moodle_mobile_app'),
(728, 'tool_lp_data_for_user_competency_summary', 'tool_lp\\external', 'data_for_user_competency_summary', NULL, 'tool_lp', 'moodle/competency:planview', 'moodle_mobile_app'),
(729, 'tool_lp_data_for_user_competency_summary_in_plan', 'tool_lp\\external', 'data_for_user_competency_summary_in_plan', NULL, 'tool_lp', 'moodle/competency:planview', 'moodle_mobile_app'),
(730, 'tool_lp_data_for_user_competency_summary_in_course', 'tool_lp\\external', 'data_for_user_competency_summary_in_course', NULL, 'tool_lp', 'moodle/competency:coursecompetencyview', 'moodle_mobile_app'),
(731, 'tool_mobile_get_plugins_supporting_mobile', 'tool_mobile\\external', 'get_plugins_supporting_mobile', NULL, 'tool_mobile', '', 'moodle_mobile_app'),
(732, 'tool_mobile_get_public_config', 'tool_mobile\\external', 'get_public_config', NULL, 'tool_mobile', '', 'moodle_mobile_app'),
(733, 'tool_mobile_get_config', 'tool_mobile\\external', 'get_config', NULL, 'tool_mobile', '', 'moodle_mobile_app'),
(734, 'tool_mobile_get_autologin_key', 'tool_mobile\\external', 'get_autologin_key', NULL, 'tool_mobile', '', 'moodle_mobile_app'),
(735, 'tool_mobile_get_content', 'tool_mobile\\external', 'get_content', NULL, 'tool_mobile', '', 'moodle_mobile_app'),
(736, 'tool_mobile_call_external_functions', 'tool_mobile\\external', 'call_external_functions', NULL, 'tool_mobile', '', 'moodle_mobile_app'),
(737, 'tool_mobile_validate_subscription_key', 'tool_mobile\\external', 'validate_subscription_key', NULL, 'tool_mobile', '', 'moodle_mobile_app'),
(738, 'tool_mobile_get_tokens_for_qr_login', 'tool_mobile\\external', 'get_tokens_for_qr_login', NULL, 'tool_mobile', '', 'moodle_mobile_app'),
(739, 'tool_moodlenet_verify_webfinger', 'tool_moodlenet\\external', 'verify_webfinger', NULL, 'tool_moodlenet', '', 'moodle_mobile_app'),
(740, 'tool_moodlenet_search_courses', 'tool_moodlenet\\external', 'search_courses', NULL, 'tool_moodlenet', '', 'moodle_mobile_app'),
(741, 'tool_policy_get_policy_version', 'tool_policy\\external', 'get_policy_version', NULL, 'tool_policy', '', NULL),
(742, 'tool_policy_submit_accept_on_behalf', 'tool_policy\\external', 'submit_accept_on_behalf', NULL, 'tool_policy', '', NULL),
(743, 'tool_policy_get_user_acceptances', '\\tool_policy\\external\\get_user_acceptances', 'execute', NULL, 'tool_policy', '', 'moodle_mobile_app'),
(744, 'tool_policy_set_acceptances_status', '\\tool_policy\\external\\set_acceptances_status', 'execute', NULL, 'tool_policy', '', 'moodle_mobile_app'),
(745, 'tool_templatelibrary_list_templates', 'tool_templatelibrary\\external', 'list_templates', NULL, 'tool_templatelibrary', '', NULL),
(746, 'tool_templatelibrary_load_canonical_template', 'tool_templatelibrary\\external', 'load_canonical_template', NULL, 'tool_templatelibrary', '', NULL),
(747, 'tool_usertours_fetch_and_start_tour', 'tool_usertours\\external\\tour', 'fetch_and_start_tour', NULL, 'tool_usertours', '', NULL),
(748, 'tool_usertours_step_shown', 'tool_usertours\\external\\tour', 'step_shown', NULL, 'tool_usertours', '', NULL),
(749, 'tool_usertours_complete_tour', 'tool_usertours\\external\\tour', 'complete_tour', NULL, 'tool_usertours', '', NULL),
(750, 'tool_usertours_reset_tour', 'tool_usertours\\external\\tour', 'reset_tour', NULL, 'tool_usertours', '', NULL),
(751, 'tool_xmldb_invoke_move_action', 'tool_xmldb_external', 'invoke_move_action', NULL, 'tool_xmldb', '', NULL),
(752, 'paygw_paypal_get_config_for_js', 'paygw_paypal\\external\\get_config_for_js', 'execute', NULL, 'paygw_paypal', '', NULL),
(753, 'paygw_paypal_create_transaction_complete', 'paygw_paypal\\external\\transaction_complete', 'execute', NULL, 'paygw_paypal', '', NULL),
(754, 'quizaccess_seb_validate_quiz_keys', 'quizaccess_seb\\external\\validate_quiz_keys', 'execute', NULL, 'quizaccess_seb', '', NULL),
(755, 'tiny_autosave_resume_session', 'tiny_autosave\\external\\resume_autosave_session', 'execute', NULL, 'tiny_autosave', '', NULL),
(756, 'tiny_autosave_reset_session', 'tiny_autosave\\external\\reset_autosave_session', 'execute', NULL, 'tiny_autosave', '', NULL),
(757, 'tiny_autosave_update_session', 'tiny_autosave\\external\\update_autosave_session_content', 'execute', NULL, 'tiny_autosave', '', NULL),
(758, 'tiny_equation_filter', 'tiny_equation\\external\\filter', 'execute', NULL, 'tiny_equation', '', NULL),
(759, 'tiny_media_preview', 'tiny_media\\external\\preview', 'execute', NULL, 'tiny_media', '', NULL),
(760, 'tiny_premium_get_api_key', 'tiny_premium\\external\\get_api_key', 'execute', NULL, 'tiny_premium', '', 'moodle_mobile_app');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]external_services`
--

CREATE TABLE `[[dbprefix]]external_services` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(200) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `enabled` tinyint(1) NOT NULL,
  `requiredcapability` varchar(150) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `restrictedusers` tinyint(1) NOT NULL,
  `component` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `timecreated` bigint NOT NULL,
  `timemodified` bigint DEFAULT NULL,
  `shortname` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `downloadfiles` tinyint(1) NOT NULL DEFAULT '0',
  `uploadfiles` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]exteserv_nam_uix` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='built in and custom external services' AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]external_services`
--

INSERT INTO `[[dbprefix]]external_services` VALUES
(1, 'Moodle mobile web service', 0, NULL, 0, 'moodle', [[timestamp]], [[timestamp]], 'moodle_mobile_app', 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]external_services_functions`
--

CREATE TABLE `[[dbprefix]]external_services_functions` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `externalserviceid` bigint NOT NULL,
  `functionname` varchar(200) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]exteservfunc_ext_ix` (`externalserviceid`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='lists functions available in each service group' AUTO_INCREMENT=431 ;

--
-- Dumping data for table `[[dbprefix]]external_services_functions`
--

INSERT INTO `[[dbprefix]]external_services_functions` VALUES
(1, 1, 'core_badges_get_badge'),
(2, 1, 'core_badges_get_user_badges'),
(3, 1, 'core_badges_get_user_badge_by_hash'),
(4, 1, 'core_blog_get_entries'),
(5, 1, 'core_blog_view_entries'),
(6, 1, 'core_blog_get_access_information'),
(7, 1, 'core_blog_add_entry'),
(8, 1, 'core_blog_delete_entry'),
(9, 1, 'core_blog_prepare_entry_for_edition'),
(10, 1, 'core_blog_update_entry'),
(11, 1, 'core_calendar_get_calendar_monthly_view'),
(12, 1, 'core_calendar_get_calendar_day_view'),
(13, 1, 'core_calendar_get_calendar_upcoming_view'),
(14, 1, 'core_calendar_update_event_start_day'),
(15, 1, 'core_calendar_create_calendar_events'),
(16, 1, 'core_calendar_delete_calendar_events'),
(17, 1, 'core_calendar_get_calendar_events'),
(18, 1, 'core_calendar_get_action_events_by_timesort'),
(19, 1, 'core_calendar_get_action_events_by_course'),
(20, 1, 'core_calendar_get_action_events_by_courses'),
(21, 1, 'core_calendar_get_calendar_event_by_id'),
(22, 1, 'core_calendar_submit_create_update_form'),
(23, 1, 'core_calendar_get_calendar_access_information'),
(24, 1, 'core_calendar_get_allowed_event_types'),
(25, 1, 'core_calendar_get_calendar_export_token'),
(26, 1, 'core_comment_get_comments'),
(27, 1, 'core_comment_add_comments'),
(28, 1, 'core_comment_delete_comments'),
(29, 1, 'core_completion_get_activities_completion_status'),
(30, 1, 'core_completion_get_course_completion_status'),
(31, 1, 'core_completion_mark_course_self_completed'),
(32, 1, 'core_completion_update_activity_completion_status_manually'),
(33, 1, 'core_course_get_categories'),
(34, 1, 'core_course_get_contents'),
(35, 1, 'core_course_get_course_module'),
(36, 1, 'core_course_get_course_module_by_instance'),
(37, 1, 'core_courseformat_get_overview_information'),
(38, 1, 'core_courseformat_log_view_overview_information'),
(39, 1, 'core_course_get_courses'),
(40, 1, 'core_course_search_courses'),
(41, 1, 'core_course_view_course'),
(42, 1, 'core_course_get_user_navigation_options'),
(43, 1, 'core_course_get_user_administration_options'),
(44, 1, 'core_course_get_courses_by_field'),
(45, 1, 'core_course_check_updates'),
(46, 1, 'core_course_get_updates_since'),
(47, 1, 'core_course_get_enrolled_courses_by_timeline_classification'),
(48, 1, 'core_course_get_enrolled_courses_with_action_events_by_timeline_classification'),
(49, 1, 'core_course_get_recent_courses'),
(50, 1, 'core_course_set_favourite_courses'),
(51, 1, 'core_course_view_module_instance_list'),
(52, 1, 'core_enrol_get_course_enrolment_methods'),
(53, 1, 'core_enrol_get_enrolled_users'),
(54, 1, 'core_enrol_search_users'),
(55, 1, 'core_enrol_get_users_courses'),
(56, 1, 'core_files_get_files'),
(57, 1, 'core_files_delete_draft_files'),
(58, 1, 'core_files_get_unused_draft_itemid'),
(59, 1, 'core_get_component_strings'),
(60, 1, 'core_grades_grader_gradingpanel_point_fetch'),
(61, 1, 'core_grades_grader_gradingpanel_point_store'),
(62, 1, 'core_grades_grader_gradingpanel_scale_fetch'),
(63, 1, 'core_grades_grader_gradingpanel_scale_store'),
(64, 1, 'core_grades_get_enrolled_users_for_selector'),
(65, 1, 'core_grades_get_groups_for_selector'),
(66, 1, 'core_grades_get_gradeitems'),
(67, 1, 'core_grades_get_gradable_users'),
(68, 1, 'core_group_get_activity_allowed_groups'),
(69, 1, 'core_group_get_activity_groupmode'),
(70, 1, 'core_group_get_course_groupings'),
(71, 1, 'core_group_get_course_groups'),
(72, 1, 'core_group_get_course_user_groups'),
(73, 1, 'core_group_get_groups_for_selector'),
(74, 1, 'core_message_mute_conversations'),
(75, 1, 'core_message_unmute_conversations'),
(76, 1, 'core_message_block_user'),
(77, 1, 'core_message_get_contact_requests'),
(78, 1, 'core_message_create_contact_request'),
(79, 1, 'core_message_confirm_contact_request'),
(80, 1, 'core_message_decline_contact_request'),
(81, 1, 'core_message_get_received_contact_requests_count'),
(82, 1, 'core_message_delete_contacts'),
(83, 1, 'core_message_delete_conversations_by_id'),
(84, 1, 'core_message_delete_message'),
(85, 1, 'core_message_get_blocked_users'),
(86, 1, 'core_message_data_for_messagearea_search_messages'),
(87, 1, 'core_message_message_search_users'),
(88, 1, 'core_message_get_user_contacts'),
(89, 1, 'core_message_get_conversations'),
(90, 1, 'core_message_get_conversation'),
(91, 1, 'core_message_get_conversation_between_users'),
(92, 1, 'core_message_get_self_conversation'),
(93, 1, 'core_message_get_messages'),
(94, 1, 'core_message_get_conversation_counts'),
(95, 1, 'core_message_get_unread_conversation_counts'),
(96, 1, 'core_message_get_conversation_members'),
(97, 1, 'core_message_get_member_info'),
(98, 1, 'core_message_get_unread_conversations_count'),
(99, 1, 'core_message_mark_all_notifications_as_read'),
(100, 1, 'core_message_mark_all_conversation_messages_as_read'),
(101, 1, 'core_message_mark_message_read'),
(102, 1, 'core_message_mark_notification_read'),
(103, 1, 'core_message_message_processor_config_form'),
(104, 1, 'core_message_search_contacts'),
(105, 1, 'core_message_send_instant_messages'),
(106, 1, 'core_message_send_messages_to_conversation'),
(107, 1, 'core_message_get_conversation_messages'),
(108, 1, 'core_message_unblock_user'),
(109, 1, 'core_message_get_user_notification_preferences'),
(110, 1, 'core_message_get_user_message_preferences'),
(111, 1, 'core_message_set_favourite_conversations'),
(112, 1, 'core_message_unset_favourite_conversations'),
(113, 1, 'core_message_delete_message_for_all_users'),
(114, 1, 'core_message_get_unread_notification_count'),
(115, 1, 'core_my_view_page'),
(116, 1, 'core_notes_create_notes'),
(117, 1, 'core_notes_delete_notes'),
(118, 1, 'core_notes_get_course_notes'),
(119, 1, 'core_notes_view_notes'),
(120, 1, 'core_output_load_fontawesome_icon_system_map'),
(121, 1, 'core_question_update_flag'),
(122, 1, 'core_rating_get_item_ratings'),
(123, 1, 'core_rating_add_rating'),
(124, 1, 'core_search_get_results'),
(125, 1, 'core_search_get_search_areas_list'),
(126, 1, 'core_search_view_results'),
(127, 1, 'core_search_get_top_results'),
(128, 1, 'core_tag_get_tagindex'),
(129, 1, 'core_tag_get_tagindex_per_area'),
(130, 1, 'core_tag_get_tag_areas'),
(131, 1, 'core_tag_get_tag_collections'),
(132, 1, 'core_tag_get_tag_cloud'),
(133, 1, 'core_user_add_user_device'),
(134, 1, 'core_user_update_user_device_public_key'),
(135, 1, 'core_user_add_user_private_files'),
(136, 1, 'core_user_get_course_user_profiles'),
(137, 1, 'core_user_get_users_by_field'),
(138, 1, 'core_user_remove_user_device'),
(139, 1, 'core_user_update_user_preferences'),
(140, 1, 'core_user_view_user_list'),
(141, 1, 'core_user_view_user_profile'),
(142, 1, 'core_user_get_user_preferences'),
(143, 1, 'core_user_update_picture'),
(144, 1, 'core_user_set_user_preferences'),
(145, 1, 'core_user_agree_site_policy'),
(146, 1, 'core_user_get_private_files_info'),
(147, 1, 'core_user_prepare_private_files_for_edition'),
(148, 1, 'core_user_update_private_files'),
(149, 1, 'core_competency_competency_viewed'),
(150, 1, 'core_competency_list_course_competencies'),
(151, 1, 'core_competency_get_scale_values'),
(152, 1, 'core_competency_user_competency_viewed'),
(153, 1, 'core_competency_user_competency_viewed_in_plan'),
(154, 1, 'core_competency_user_competency_viewed_in_course'),
(155, 1, 'core_competency_user_competency_plan_viewed'),
(156, 1, 'core_competency_grade_competency_in_course'),
(157, 1, 'core_competency_delete_evidence'),
(158, 1, 'core_webservice_get_site_info'),
(159, 1, 'core_block_get_course_blocks'),
(160, 1, 'core_block_get_dashboard_blocks'),
(161, 1, 'core_block_fetch_addable_blocks'),
(162, 1, 'core_filters_get_available_in_context'),
(163, 1, 'core_filters_get_all_states'),
(164, 1, 'core_h5p_get_trusted_h5p_file'),
(165, 1, 'core_table_get_dynamic_table_content'),
(166, 1, 'core_xapi_statement_post'),
(167, 1, 'core_xapi_post_state'),
(168, 1, 'core_xapi_get_state'),
(169, 1, 'core_xapi_get_states'),
(170, 1, 'core_xapi_delete_state'),
(171, 1, 'core_xapi_delete_states'),
(172, 1, 'core_reportbuilder_list_reports'),
(173, 1, 'core_reportbuilder_retrieve_report'),
(174, 1, 'core_reportbuilder_retrieve_system_report'),
(175, 1, 'core_reportbuilder_can_view_system_report'),
(176, 1, 'core_reportbuilder_view_report'),
(177, 1, 'core_ai_set_policy_status'),
(178, 1, 'core_ai_get_policy_status'),
(179, 1, 'aiplacement_courseassist_summarise_text'),
(180, 1, 'aiplacement_courseassist_explain_text'),
(181, 1, 'aiplacement_editor_generate_image'),
(182, 1, 'aiplacement_editor_generate_text'),
(183, 1, 'mod_assign_get_grades'),
(184, 1, 'mod_assign_get_assignments'),
(185, 1, 'mod_assign_get_submissions'),
(186, 1, 'mod_assign_get_user_flags'),
(187, 1, 'mod_assign_set_user_flags'),
(188, 1, 'mod_assign_get_user_mappings'),
(189, 1, 'mod_assign_revert_submissions_to_draft'),
(190, 1, 'mod_assign_lock_submissions'),
(191, 1, 'mod_assign_unlock_submissions'),
(192, 1, 'mod_assign_save_submission'),
(193, 1, 'mod_assign_submit_for_grading'),
(194, 1, 'mod_assign_save_grade'),
(195, 1, 'mod_assign_save_grades'),
(196, 1, 'mod_assign_save_user_extensions'),
(197, 1, 'mod_assign_reveal_identities'),
(198, 1, 'mod_assign_view_grading_table'),
(199, 1, 'mod_assign_view_submission_status'),
(200, 1, 'mod_assign_get_submission_status'),
(201, 1, 'mod_assign_list_participants'),
(202, 1, 'mod_assign_submit_grading_form'),
(203, 1, 'mod_assign_get_participant'),
(204, 1, 'mod_assign_view_assign'),
(205, 1, 'mod_assign_start_submission'),
(206, 1, 'mod_assign_remove_submission'),
(207, 1, 'mod_bigbluebuttonbn_can_join'),
(208, 1, 'mod_bigbluebuttonbn_get_recordings'),
(209, 1, 'mod_bigbluebuttonbn_get_recordings_to_import'),
(210, 1, 'mod_bigbluebuttonbn_update_recording'),
(211, 1, 'mod_bigbluebuttonbn_end_meeting'),
(212, 1, 'mod_bigbluebuttonbn_completion_validate'),
(213, 1, 'mod_bigbluebuttonbn_meeting_info'),
(214, 1, 'mod_bigbluebuttonbn_get_bigbluebuttonbns_by_courses'),
(215, 1, 'mod_bigbluebuttonbn_view_bigbluebuttonbn'),
(216, 1, 'mod_bigbluebuttonbn_get_join_url'),
(217, 1, 'mod_book_view_book'),
(218, 1, 'mod_book_get_books_by_courses'),
(219, 1, 'mod_choice_get_choice_results'),
(220, 1, 'mod_choice_get_choice_options'),
(221, 1, 'mod_choice_submit_choice_response'),
(222, 1, 'mod_choice_view_choice'),
(223, 1, 'mod_choice_get_choices_by_courses'),
(224, 1, 'mod_choice_delete_choice_responses'),
(225, 1, 'mod_data_get_databases_by_courses'),
(226, 1, 'mod_data_view_database'),
(227, 1, 'mod_data_get_data_access_information'),
(228, 1, 'mod_data_get_entries'),
(229, 1, 'mod_data_get_entry'),
(230, 1, 'mod_data_get_fields'),
(231, 1, 'mod_data_search_entries'),
(232, 1, 'mod_data_approve_entry'),
(233, 1, 'mod_data_delete_entry'),
(234, 1, 'mod_data_add_entry'),
(235, 1, 'mod_data_update_entry'),
(236, 1, 'mod_feedback_get_feedbacks_by_courses'),
(237, 1, 'mod_feedback_get_feedback_access_information'),
(238, 1, 'mod_feedback_view_feedback'),
(239, 1, 'mod_feedback_get_current_completed_tmp'),
(240, 1, 'mod_feedback_get_items'),
(241, 1, 'mod_feedback_launch_feedback'),
(242, 1, 'mod_feedback_get_page_items'),
(243, 1, 'mod_feedback_process_page'),
(244, 1, 'mod_feedback_get_analysis'),
(245, 1, 'mod_feedback_get_unfinished_responses'),
(246, 1, 'mod_feedback_get_finished_responses'),
(247, 1, 'mod_feedback_get_non_respondents'),
(248, 1, 'mod_feedback_get_responses_analysis'),
(249, 1, 'mod_feedback_get_last_completed'),
(250, 1, 'mod_folder_view_folder'),
(251, 1, 'mod_folder_get_folders_by_courses'),
(252, 1, 'mod_forum_get_forums_by_courses'),
(253, 1, 'mod_forum_get_discussion_posts'),
(254, 1, 'mod_forum_get_forum_discussions'),
(255, 1, 'mod_forum_view_forum'),
(256, 1, 'mod_forum_view_forum_discussion'),
(257, 1, 'mod_forum_add_discussion_post'),
(258, 1, 'mod_forum_add_discussion'),
(259, 1, 'mod_forum_can_add_discussion'),
(260, 1, 'mod_forum_get_forum_access_information'),
(261, 1, 'mod_forum_set_subscription_state'),
(262, 1, 'mod_forum_set_lock_state'),
(263, 1, 'mod_forum_toggle_favourite_state'),
(264, 1, 'mod_forum_set_pin_state'),
(265, 1, 'mod_forum_delete_post'),
(266, 1, 'mod_forum_get_discussion_post'),
(267, 1, 'mod_forum_prepare_draft_area_for_post'),
(268, 1, 'mod_forum_update_discussion_post'),
(269, 1, 'mod_forum_set_forum_subscription'),
(270, 1, 'mod_forum_set_forum_tracking'),
(271, 1, 'mod_glossary_get_glossaries_by_courses'),
(272, 1, 'mod_glossary_view_glossary'),
(273, 1, 'mod_glossary_view_entry'),
(274, 1, 'mod_glossary_get_entries_by_letter'),
(275, 1, 'mod_glossary_get_entries_by_date'),
(276, 1, 'mod_glossary_get_categories'),
(277, 1, 'mod_glossary_get_entries_by_category'),
(278, 1, 'mod_glossary_get_authors'),
(279, 1, 'mod_glossary_get_entries_by_author'),
(280, 1, 'mod_glossary_get_entries_by_author_id'),
(281, 1, 'mod_glossary_get_entries_by_search'),
(282, 1, 'mod_glossary_get_entries_by_term'),
(283, 1, 'mod_glossary_get_entries_to_approve'),
(284, 1, 'mod_glossary_get_entry_by_id'),
(285, 1, 'mod_glossary_add_entry'),
(286, 1, 'mod_glossary_delete_entry'),
(287, 1, 'mod_glossary_update_entry'),
(288, 1, 'mod_glossary_prepare_entry_for_edition'),
(289, 1, 'mod_h5pactivity_get_h5pactivity_access_information'),
(290, 1, 'mod_h5pactivity_view_h5pactivity'),
(291, 1, 'mod_h5pactivity_get_attempts'),
(292, 1, 'mod_h5pactivity_get_results'),
(293, 1, 'mod_h5pactivity_get_h5pactivities_by_courses'),
(294, 1, 'mod_h5pactivity_log_report_viewed'),
(295, 1, 'mod_h5pactivity_get_user_attempts'),
(296, 1, 'mod_imscp_view_imscp'),
(297, 1, 'mod_imscp_get_imscps_by_courses'),
(298, 1, 'mod_label_get_labels_by_courses'),
(299, 1, 'mod_lesson_get_lessons_by_courses'),
(300, 1, 'mod_lesson_get_lesson_access_information'),
(301, 1, 'mod_lesson_view_lesson'),
(302, 1, 'mod_lesson_get_questions_attempts'),
(303, 1, 'mod_lesson_get_user_grade'),
(304, 1, 'mod_lesson_get_user_attempt_grade'),
(305, 1, 'mod_lesson_get_content_pages_viewed'),
(306, 1, 'mod_lesson_get_user_timers'),
(307, 1, 'mod_lesson_get_pages'),
(308, 1, 'mod_lesson_launch_attempt'),
(309, 1, 'mod_lesson_get_page_data'),
(310, 1, 'mod_lesson_process_page'),
(311, 1, 'mod_lesson_finish_attempt'),
(312, 1, 'mod_lesson_get_attempts_overview'),
(313, 1, 'mod_lesson_get_user_attempt'),
(314, 1, 'mod_lesson_get_pages_possible_jumps'),
(315, 1, 'mod_lesson_get_lesson'),
(316, 1, 'mod_lti_get_tool_launch_data'),
(317, 1, 'mod_lti_get_ltis_by_courses'),
(318, 1, 'mod_lti_view_lti'),
(319, 1, 'mod_page_view_page'),
(320, 1, 'mod_page_get_pages_by_courses'),
(321, 1, 'mod_quiz_get_quizzes_by_courses'),
(322, 1, 'mod_quiz_view_quiz'),
(323, 1, 'mod_quiz_get_user_attempts'),
(324, 1, 'mod_quiz_get_user_quiz_attempts'),
(325, 1, 'mod_quiz_get_user_best_grade'),
(326, 1, 'mod_quiz_get_combined_review_options'),
(327, 1, 'mod_quiz_start_attempt'),
(328, 1, 'mod_quiz_get_attempt_data'),
(329, 1, 'mod_quiz_get_attempt_summary'),
(330, 1, 'mod_quiz_save_attempt'),
(331, 1, 'mod_quiz_process_attempt'),
(332, 1, 'mod_quiz_get_attempt_review'),
(333, 1, 'mod_quiz_view_attempt'),
(334, 1, 'mod_quiz_view_attempt_summary'),
(335, 1, 'mod_quiz_view_attempt_review'),
(336, 1, 'mod_quiz_get_quiz_feedback_for_grade'),
(337, 1, 'mod_quiz_get_quiz_access_information'),
(338, 1, 'mod_quiz_get_attempt_access_information'),
(339, 1, 'mod_quiz_get_quiz_required_qtypes'),
(340, 1, 'mod_resource_view_resource'),
(341, 1, 'mod_resource_get_resources_by_courses'),
(342, 1, 'mod_scorm_view_scorm'),
(343, 1, 'mod_scorm_get_scorm_attempt_count'),
(344, 1, 'mod_scorm_get_scorm_scoes'),
(345, 1, 'mod_scorm_get_scorm_user_data'),
(346, 1, 'mod_scorm_insert_scorm_tracks'),
(347, 1, 'mod_scorm_get_scorm_sco_tracks'),
(348, 1, 'mod_scorm_get_scorms_by_courses'),
(349, 1, 'mod_scorm_launch_sco'),
(350, 1, 'mod_scorm_get_scorm_access_information'),
(351, 1, 'mod_url_view_url'),
(352, 1, 'mod_url_get_urls_by_courses'),
(353, 1, 'mod_wiki_get_wikis_by_courses'),
(354, 1, 'mod_wiki_view_wiki'),
(355, 1, 'mod_wiki_view_page'),
(356, 1, 'mod_wiki_get_subwikis'),
(357, 1, 'mod_wiki_get_subwiki_pages'),
(358, 1, 'mod_wiki_get_subwiki_files'),
(359, 1, 'mod_wiki_get_page_contents'),
(360, 1, 'mod_wiki_get_page_for_editing'),
(361, 1, 'mod_wiki_new_page'),
(362, 1, 'mod_wiki_edit_page'),
(363, 1, 'mod_workshop_get_workshops_by_courses'),
(364, 1, 'mod_workshop_get_workshop_access_information'),
(365, 1, 'mod_workshop_get_user_plan'),
(366, 1, 'mod_workshop_view_workshop'),
(367, 1, 'mod_workshop_add_submission'),
(368, 1, 'mod_workshop_update_submission'),
(369, 1, 'mod_workshop_delete_submission'),
(370, 1, 'mod_workshop_get_submissions'),
(371, 1, 'mod_workshop_get_submission'),
(372, 1, 'mod_workshop_get_submission_assessments'),
(373, 1, 'mod_workshop_get_assessment'),
(374, 1, 'mod_workshop_get_assessment_form_definition'),
(375, 1, 'mod_workshop_get_reviewer_assessments'),
(376, 1, 'mod_workshop_update_assessment'),
(377, 1, 'mod_workshop_get_grades'),
(378, 1, 'mod_workshop_evaluate_assessment'),
(379, 1, 'mod_workshop_get_grades_report'),
(380, 1, 'mod_workshop_view_submission'),
(381, 1, 'mod_workshop_evaluate_submission'),
(382, 1, 'enrol_guest_get_instance_info'),
(383, 1, 'enrol_guest_validate_password'),
(384, 1, 'enrol_self_get_instance_info'),
(385, 1, 'enrol_self_enrol_user'),
(386, 1, 'message_airnotifier_is_system_configured'),
(387, 1, 'message_airnotifier_are_notification_preferences_configured'),
(388, 1, 'message_airnotifier_get_user_devices'),
(389, 1, 'message_airnotifier_enable_device'),
(390, 1, 'message_popup_get_popup_notifications'),
(391, 1, 'message_popup_get_unread_popup_notification_count'),
(392, 1, 'block_recentlyaccesseditems_get_recent_items'),
(393, 1, 'block_starredcourses_get_starred_courses'),
(394, 1, 'editor_tiny_get_configuration'),
(395, 1, 'report_insights_action_executed'),
(396, 1, 'gradereport_grader_get_users_in_report'),
(397, 1, 'gradereport_overview_get_course_grades'),
(398, 1, 'gradereport_overview_view_grade_report'),
(399, 1, 'gradereport_singleview_get_grade_items_for_search_widget'),
(400, 1, 'gradereport_user_get_grades_table'),
(401, 1, 'gradereport_user_view_grade_report'),
(402, 1, 'gradereport_user_get_grade_items'),
(403, 1, 'gradereport_user_get_access_information'),
(404, 1, 'tool_analytics_potential_contexts'),
(405, 1, 'tool_dataprivacy_cancel_data_request'),
(406, 1, 'tool_dataprivacy_contact_dpo'),
(407, 1, 'tool_dataprivacy_get_access_information'),
(408, 1, 'tool_dataprivacy_create_data_request'),
(409, 1, 'tool_dataprivacy_get_data_requests'),
(410, 1, 'tool_lp_data_for_course_competencies_page'),
(411, 1, 'tool_lp_data_for_plans_page'),
(412, 1, 'tool_lp_data_for_plan_page'),
(413, 1, 'tool_lp_data_for_user_evidence_list_page'),
(414, 1, 'tool_lp_data_for_user_evidence_page'),
(415, 1, 'tool_lp_data_for_user_competency_summary'),
(416, 1, 'tool_lp_data_for_user_competency_summary_in_plan'),
(417, 1, 'tool_lp_data_for_user_competency_summary_in_course'),
(418, 1, 'tool_mobile_get_plugins_supporting_mobile'),
(419, 1, 'tool_mobile_get_public_config'),
(420, 1, 'tool_mobile_get_config'),
(421, 1, 'tool_mobile_get_autologin_key'),
(422, 1, 'tool_mobile_get_content'),
(423, 1, 'tool_mobile_call_external_functions'),
(424, 1, 'tool_mobile_validate_subscription_key'),
(425, 1, 'tool_mobile_get_tokens_for_qr_login'),
(426, 1, 'tool_moodlenet_verify_webfinger'),
(427, 1, 'tool_moodlenet_search_courses'),
(428, 1, 'tool_policy_get_user_acceptances'),
(429, 1, 'tool_policy_set_acceptances_status'),
(430, 1, 'tiny_premium_get_api_key');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]external_services_users`
--

CREATE TABLE `[[dbprefix]]external_services_users` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `externalserviceid` bigint NOT NULL,
  `userid` bigint NOT NULL,
  `iprestriction` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `validuntil` bigint DEFAULT NULL,
  `timecreated` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]exteservuser_ext_ix` (`externalserviceid`),
  KEY `[[dbprefix]]exteservuser_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='users allowed to use services with restricted users flag' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]external_tokens`
--

CREATE TABLE `[[dbprefix]]external_tokens` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `token` varchar(128) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `privatetoken` varchar(64) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `tokentype` smallint NOT NULL,
  `userid` bigint NOT NULL,
  `externalserviceid` bigint NOT NULL,
  `sid` varchar(128) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `contextid` bigint NOT NULL,
  `creatorid` bigint NOT NULL DEFAULT '1',
  `iprestriction` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `validuntil` bigint DEFAULT NULL,
  `timecreated` bigint NOT NULL,
  `lastaccess` bigint DEFAULT NULL,
  `name` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]extetoke_tok_ix` (`token`),
  KEY `[[dbprefix]]extetoke_sid_ix` (`sid`),
  KEY `[[dbprefix]]extetoke_use_ix` (`userid`),
  KEY `[[dbprefix]]extetoke_ext_ix` (`externalserviceid`),
  KEY `[[dbprefix]]extetoke_con_ix` (`contextid`),
  KEY `[[dbprefix]]extetoke_cre_ix` (`creatorid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Security tokens for accessing of external services' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]favourite`
--

CREATE TABLE `[[dbprefix]]favourite` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `component` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `itemtype` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `itemid` bigint NOT NULL,
  `contextid` bigint NOT NULL,
  `userid` bigint NOT NULL,
  `ordering` bigint DEFAULT NULL,
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]favo_comiteiteconuse_uix` (`component`,`itemtype`,`itemid`,`contextid`,`userid`),
  KEY `[[dbprefix]]favo_con_ix` (`contextid`),
  KEY `[[dbprefix]]favo_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores the relationship between an arbitrary item (itemtype,';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]feedback`
--

CREATE TABLE `[[dbprefix]]feedback` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `course` bigint NOT NULL DEFAULT '0',
  `name` varchar(1333) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `intro` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `introformat` smallint NOT NULL DEFAULT '0',
  `anonymous` tinyint(1) NOT NULL DEFAULT '1',
  `email_notification` tinyint(1) NOT NULL DEFAULT '1',
  `multiple_submit` tinyint(1) NOT NULL DEFAULT '1',
  `autonumbering` tinyint(1) NOT NULL DEFAULT '1',
  `site_after_submit` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `page_after_submit` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `page_after_submitformat` tinyint NOT NULL DEFAULT '0',
  `publish_stats` tinyint(1) NOT NULL DEFAULT '0',
  `timeopen` bigint NOT NULL DEFAULT '0',
  `timeclose` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  `completionsubmit` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]feed_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='all feedbacks';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]feedback_completed`
--

CREATE TABLE `[[dbprefix]]feedback_completed` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `feedback` bigint NOT NULL DEFAULT '0',
  `userid` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  `random_response` bigint NOT NULL DEFAULT '0',
  `anonymous_response` tinyint(1) NOT NULL DEFAULT '0',
  `courseid` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]feedcomp_use_ix` (`userid`),
  KEY `[[dbprefix]]feedcomp_fee_ix` (`feedback`),
  KEY `[[dbprefix]]feedcomp_cou_ix` (`courseid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='filled out feedback';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]feedback_completedtmp`
--

CREATE TABLE `[[dbprefix]]feedback_completedtmp` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `feedback` bigint NOT NULL DEFAULT '0',
  `userid` bigint NOT NULL DEFAULT '0',
  `guestid` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `timemodified` bigint NOT NULL DEFAULT '0',
  `random_response` bigint NOT NULL DEFAULT '0',
  `anonymous_response` tinyint(1) NOT NULL DEFAULT '0',
  `courseid` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]feedcomp_use2_ix` (`userid`),
  KEY `[[dbprefix]]feedcomp_fee2_ix` (`feedback`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='filled out feedback';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]feedback_item`
--

CREATE TABLE `[[dbprefix]]feedback_item` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `feedback` bigint NOT NULL DEFAULT '0',
  `template` bigint NOT NULL DEFAULT '0',
  `name` varchar(1333) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `label` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `presentation` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `typ` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `hasvalue` tinyint(1) NOT NULL DEFAULT '0',
  `position` smallint NOT NULL DEFAULT '0',
  `required` tinyint(1) NOT NULL DEFAULT '0',
  `dependitem` bigint NOT NULL DEFAULT '0',
  `dependvalue` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `options` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]feeditem_fee_ix` (`feedback`),
  KEY `[[dbprefix]]feeditem_tem_ix` (`template`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='feedback_items';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]feedback_sitecourse_map`
--

CREATE TABLE `[[dbprefix]]feedback_sitecourse_map` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `feedbackid` bigint NOT NULL DEFAULT '0',
  `courseid` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]feedsitemap_cou_ix` (`courseid`),
  KEY `[[dbprefix]]feedsitemap_fee_ix` (`feedbackid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='feedback sitecourse map';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]feedback_template`
--

CREATE TABLE `[[dbprefix]]feedback_template` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `course` bigint NOT NULL DEFAULT '0',
  `ispublic` tinyint(1) NOT NULL DEFAULT '0',
  `name` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]feedtemp_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='templates of feedbackstructures';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]feedback_value`
--

CREATE TABLE `[[dbprefix]]feedback_value` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `course_id` bigint NOT NULL DEFAULT '0',
  `item` bigint NOT NULL DEFAULT '0',
  `completed` bigint NOT NULL DEFAULT '0',
  `tmp_completed` bigint NOT NULL DEFAULT '0',
  `value` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]feedvalu_comitecou_uix` (`completed`,`item`,`course_id`),
  KEY `[[dbprefix]]feedvalu_cou_ix` (`course_id`),
  KEY `[[dbprefix]]feedvalu_ite_ix` (`item`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='values of the completeds';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]feedback_valuetmp`
--

CREATE TABLE `[[dbprefix]]feedback_valuetmp` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `course_id` bigint NOT NULL DEFAULT '0',
  `item` bigint NOT NULL DEFAULT '0',
  `completed` bigint NOT NULL DEFAULT '0',
  `tmp_completed` bigint NOT NULL DEFAULT '0',
  `value` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]feedvalu_comitecou2_uix` (`completed`,`item`,`course_id`),
  KEY `[[dbprefix]]feedvalu_cou2_ix` (`course_id`),
  KEY `[[dbprefix]]feedvalu_ite2_ix` (`item`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='values of the completedstmp';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]files`
--

CREATE TABLE `[[dbprefix]]files` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `contenthash` varchar(40) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `pathnamehash` varchar(40) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `contextid` bigint NOT NULL,
  `component` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `filearea` varchar(50) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `itemid` bigint NOT NULL,
  `filepath` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `filename` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `userid` bigint DEFAULT NULL,
  `filesize` bigint NOT NULL,
  `mimetype` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `status` bigint NOT NULL DEFAULT '0',
  `source` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `author` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `license` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  `sortorder` bigint NOT NULL DEFAULT '0',
  `referencefileid` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]file_pat_uix` (`pathnamehash`),
  KEY `[[dbprefix]]file_comfilconite_ix` (`component`,`filearea`,`contextid`,`itemid`),
  KEY `[[dbprefix]]file_con_ix` (`contenthash`),
  KEY `[[dbprefix]]file_lic_ix` (`license`),
  KEY `[[dbprefix]]file_fil_ix` (`filename`),
  KEY `[[dbprefix]]file_con2_ix` (`contextid`),
  KEY `[[dbprefix]]file_use_ix` (`userid`),
  KEY `[[dbprefix]]file_ref_ix` (`referencefileid`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='description of files, content is stored in sha1 file pool' AUTO_INCREMENT=6 ;

--
-- Dumping data for table `[[dbprefix]]files`
--

INSERT INTO `[[dbprefix]]files` VALUES
(1, '5f8e911d0da441e36f47c5c46f4393269211ca56', '508e674d49c30d4fde325fe6c7f6fd3d56b247e1', 1, 'assignfeedback_editpdf', 'stamps', 0, '/', 'smile.png', 2, 1085, 'image/png', 0, NULL, NULL, NULL, [[timestamp]], [[timestamp]], 0, NULL),
(2, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '70b7cdade7b4e27d4e83f0cdaad10d6a3c0cccb5', 1, 'assignfeedback_editpdf', 'stamps', 0, '/', '.', 2, 0, NULL, 0, NULL, NULL, NULL, [[timestamp]], [[timestamp]], 0, NULL),
(3, '75c101cb8cb34ea573cd25ac38f8157b1de901b8', '68317eab56c67d32aeaee5acf509a0c4aa828b6b', 1, 'assignfeedback_editpdf', 'stamps', 0, '/', 'sad.png', 2, 966, 'image/png', 0, NULL, NULL, NULL, [[timestamp]], [[timestamp]], 0, NULL),
(4, '0c5190a24c3943966541401c883eacaa20ca20cb', '695a55ff780e61c9e59428aa425430b0d6bde53b', 1, 'assignfeedback_editpdf', 'stamps', 0, '/', 'tick.png', 2, 1039, 'image/png', 0, NULL, NULL, NULL, [[timestamp]], [[timestamp]], 0, NULL),
(5, '8c96a486d5801e0f4ab8c411f561f1c687e1f865', '373e63af262a9b8466ba8632551520be793c37ff', 1, 'assignfeedback_editpdf', 'stamps', 0, '/', 'cross.png', 2, 861, 'image/png', 0, NULL, NULL, NULL, [[timestamp]], [[timestamp]], 0, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]files_reference`
--

CREATE TABLE `[[dbprefix]]files_reference` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `repositoryid` bigint NOT NULL,
  `lastsync` bigint DEFAULT NULL,
  `reference` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `referencehash` varchar(40) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]filerefe_refrep_uix` (`referencehash`,`repositoryid`),
  KEY `[[dbprefix]]filerefe_rep_ix` (`repositoryid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Store files references' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]file_conversion`
--

CREATE TABLE `[[dbprefix]]file_conversion` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `usermodified` bigint NOT NULL,
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  `sourcefileid` bigint NOT NULL,
  `targetformat` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `status` bigint DEFAULT '0',
  `statusmessage` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `converter` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `destfileid` bigint DEFAULT NULL,
  `data` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]fileconv_sou_ix` (`sourcefileid`),
  KEY `[[dbprefix]]fileconv_des_ix` (`destfileid`),
  KEY `[[dbprefix]]fileconv_use_ix` (`usermodified`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Table to track file conversions.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]filter_active`
--

CREATE TABLE `[[dbprefix]]filter_active` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `filter` varchar(32) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `contextid` bigint NOT NULL,
  `active` smallint NOT NULL,
  `sortorder` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]filtacti_confil_uix` (`contextid`,`filter`),
  KEY `[[dbprefix]]filtacti_con_ix` (`contextid`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores information about which filters are active in which c' AUTO_INCREMENT=7 ;

--
-- Dumping data for table `[[dbprefix]]filter_active`
--

INSERT INTO `[[dbprefix]]filter_active` VALUES
(1, 'activitynames', 1, 1, 2),
(2, 'displayh5p', 1, 1, 1),
(3, 'emoticon', 1, 1, 4),
(4, 'mathjaxloader', 1, 1, 3),
(5, 'mediaplugin', 1, 1, 6),
(6, 'urltolink', 1, 1, 5);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]filter_config`
--

CREATE TABLE `[[dbprefix]]filter_config` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `filter` varchar(32) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `contextid` bigint NOT NULL,
  `name` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `value` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]filtconf_confilnam_uix` (`contextid`,`filter`,`name`),
  KEY `[[dbprefix]]filtconf_con_ix` (`contextid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores per-context configuration settings for filters which ' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]folder`
--

CREATE TABLE `[[dbprefix]]folder` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `course` bigint NOT NULL DEFAULT '0',
  `name` varchar(1333) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `intro` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `introformat` smallint NOT NULL DEFAULT '0',
  `revision` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  `display` smallint NOT NULL DEFAULT '0',
  `showexpanded` tinyint(1) NOT NULL DEFAULT '1',
  `showdownloadfolder` tinyint(1) NOT NULL DEFAULT '1',
  `forcedownload` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]fold_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='each record is one folder resource';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]forum`
--

CREATE TABLE `[[dbprefix]]forum` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `course` bigint NOT NULL DEFAULT '0',
  `type` varchar(20) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT 'general',
  `name` varchar(1333) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `intro` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `introformat` smallint NOT NULL DEFAULT '0',
  `duedate` bigint NOT NULL DEFAULT '0',
  `cutoffdate` bigint NOT NULL DEFAULT '0',
  `assessed` bigint NOT NULL DEFAULT '0',
  `assesstimestart` bigint NOT NULL DEFAULT '0',
  `assesstimefinish` bigint NOT NULL DEFAULT '0',
  `scale` bigint NOT NULL DEFAULT '0',
  `grade_forum` bigint NOT NULL DEFAULT '0',
  `grade_forum_notify` smallint NOT NULL DEFAULT '0',
  `maxbytes` bigint NOT NULL DEFAULT '0',
  `maxattachments` bigint NOT NULL DEFAULT '1',
  `forcesubscribe` tinyint(1) NOT NULL DEFAULT '0',
  `trackingtype` tinyint NOT NULL DEFAULT '1',
  `rsstype` tinyint NOT NULL DEFAULT '0',
  `rssarticles` tinyint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  `warnafter` bigint NOT NULL DEFAULT '0',
  `blockafter` bigint NOT NULL DEFAULT '0',
  `blockperiod` bigint NOT NULL DEFAULT '0',
  `completiondiscussions` int NOT NULL DEFAULT '0',
  `completionreplies` int NOT NULL DEFAULT '0',
  `completionposts` int NOT NULL DEFAULT '0',
  `displaywordcount` tinyint(1) NOT NULL DEFAULT '0',
  `lockdiscussionafter` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]foru_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Forums contain and structure discussion';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]forum_digests`
--

CREATE TABLE `[[dbprefix]]forum_digests` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `userid` bigint NOT NULL,
  `forum` bigint NOT NULL,
  `maildigest` tinyint(1) NOT NULL DEFAULT '-1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]forudige_forusemai_uix` (`forum`,`userid`,`maildigest`),
  KEY `[[dbprefix]]forudige_use_ix` (`userid`),
  KEY `[[dbprefix]]forudige_for_ix` (`forum`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Keeps track of user mail delivery preferences for each forum';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]forum_discussions`
--

CREATE TABLE `[[dbprefix]]forum_discussions` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `course` bigint NOT NULL DEFAULT '0',
  `forum` bigint NOT NULL DEFAULT '0',
  `name` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `firstpost` bigint NOT NULL DEFAULT '0',
  `userid` bigint NOT NULL DEFAULT '0',
  `groupid` bigint NOT NULL DEFAULT '-1',
  `assessed` tinyint(1) NOT NULL DEFAULT '1',
  `timemodified` bigint NOT NULL DEFAULT '0',
  `usermodified` bigint NOT NULL DEFAULT '0',
  `timestart` bigint NOT NULL DEFAULT '0',
  `timeend` bigint NOT NULL DEFAULT '0',
  `pinned` tinyint(1) NOT NULL DEFAULT '0',
  `timelocked` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]forudisc_use_ix` (`userid`),
  KEY `[[dbprefix]]forudisc_cou_ix` (`course`),
  KEY `[[dbprefix]]forudisc_for_ix` (`forum`),
  KEY `[[dbprefix]]forudisc_use2_ix` (`usermodified`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Forums are composed of discussions' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]forum_discussion_subs`
--

CREATE TABLE `[[dbprefix]]forum_discussion_subs` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `forum` bigint NOT NULL,
  `userid` bigint NOT NULL,
  `discussion` bigint NOT NULL,
  `preference` bigint NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]forudiscsubs_usedis_uix` (`userid`,`discussion`),
  KEY `[[dbprefix]]forudiscsubs_for_ix` (`forum`),
  KEY `[[dbprefix]]forudiscsubs_use_ix` (`userid`),
  KEY `[[dbprefix]]forudiscsubs_dis_ix` (`discussion`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Users may choose to subscribe and unsubscribe from specific ';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]forum_grades`
--

CREATE TABLE `[[dbprefix]]forum_grades` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `forum` bigint NOT NULL,
  `itemnumber` bigint NOT NULL,
  `userid` bigint NOT NULL,
  `grade` decimal(10,5) DEFAULT NULL,
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]forugrad_foriteuse_uix` (`forum`,`itemnumber`,`userid`),
  KEY `[[dbprefix]]forugrad_use_ix` (`userid`),
  KEY `[[dbprefix]]forugrad_for_ix` (`forum`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Grading data for forum instances';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]forum_posts`
--

CREATE TABLE `[[dbprefix]]forum_posts` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `discussion` bigint NOT NULL DEFAULT '0',
  `parent` bigint NOT NULL DEFAULT '0',
  `userid` bigint NOT NULL DEFAULT '0',
  `created` bigint NOT NULL DEFAULT '0',
  `modified` bigint NOT NULL DEFAULT '0',
  `mailed` tinyint NOT NULL DEFAULT '0',
  `subject` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `message` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `messageformat` tinyint NOT NULL DEFAULT '0',
  `messagetrust` tinyint NOT NULL DEFAULT '0',
  `attachment` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `totalscore` smallint NOT NULL DEFAULT '0',
  `mailnow` bigint NOT NULL DEFAULT '0',
  `deleted` tinyint(1) NOT NULL DEFAULT '0',
  `privatereplyto` bigint NOT NULL DEFAULT '0',
  `wordcount` bigint DEFAULT NULL,
  `charcount` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]forupost_use_ix` (`userid`),
  KEY `[[dbprefix]]forupost_cre_ix` (`created`),
  KEY `[[dbprefix]]forupost_mai_ix` (`mailed`),
  KEY `[[dbprefix]]forupost_pri_ix` (`privatereplyto`),
  KEY `[[dbprefix]]forupost_dis_ix` (`discussion`),
  KEY `[[dbprefix]]forupost_par_ix` (`parent`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='All posts are stored in this table' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]forum_queue`
--

CREATE TABLE `[[dbprefix]]forum_queue` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `userid` bigint NOT NULL DEFAULT '0',
  `discussionid` bigint NOT NULL DEFAULT '0',
  `postid` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]foruqueu_use_ix` (`userid`),
  KEY `[[dbprefix]]foruqueu_dis_ix` (`discussionid`),
  KEY `[[dbprefix]]foruqueu_pos_ix` (`postid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='For keeping track of posts that will be mailed in digest for' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]forum_read`
--

CREATE TABLE `[[dbprefix]]forum_read` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `userid` bigint NOT NULL DEFAULT '0',
  `forumid` bigint NOT NULL DEFAULT '0',
  `discussionid` bigint NOT NULL DEFAULT '0',
  `postid` bigint NOT NULL DEFAULT '0',
  `firstread` bigint NOT NULL DEFAULT '0',
  `lastread` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]foruread_foruse_ix` (`forumid`,`userid`),
  KEY `[[dbprefix]]foruread_disuse_ix` (`discussionid`,`userid`),
  KEY `[[dbprefix]]foruread_posuse_ix` (`postid`,`userid`),
  KEY `[[dbprefix]]foruread_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Tracks each users read posts';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]forum_subscriptions`
--

CREATE TABLE `[[dbprefix]]forum_subscriptions` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `userid` bigint NOT NULL DEFAULT '0',
  `forum` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]forusubs_usefor_uix` (`userid`,`forum`),
  KEY `[[dbprefix]]forusubs_use_ix` (`userid`),
  KEY `[[dbprefix]]forusubs_for_ix` (`forum`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Keeps track of who is subscribed to what forum';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]forum_track_prefs`
--

CREATE TABLE `[[dbprefix]]forum_track_prefs` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `userid` bigint NOT NULL DEFAULT '0',
  `forumid` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]forutracpref_usefor_ix` (`userid`,`forumid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Tracks each users untracked forums';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]glossary`
--

CREATE TABLE `[[dbprefix]]glossary` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `course` bigint NOT NULL DEFAULT '0',
  `name` varchar(1333) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `intro` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `introformat` smallint NOT NULL DEFAULT '0',
  `allowduplicatedentries` tinyint NOT NULL DEFAULT '0',
  `displayformat` varchar(50) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT 'dictionary',
  `mainglossary` tinyint NOT NULL DEFAULT '0',
  `showspecial` tinyint NOT NULL DEFAULT '1',
  `showalphabet` tinyint NOT NULL DEFAULT '1',
  `showall` tinyint NOT NULL DEFAULT '1',
  `allowcomments` tinyint NOT NULL DEFAULT '0',
  `allowprintview` tinyint NOT NULL DEFAULT '1',
  `usedynalink` tinyint NOT NULL DEFAULT '1',
  `defaultapproval` tinyint NOT NULL DEFAULT '1',
  `approvaldisplayformat` varchar(50) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT 'default',
  `globalglossary` tinyint NOT NULL DEFAULT '0',
  `entbypage` smallint NOT NULL DEFAULT '10',
  `editalways` tinyint NOT NULL DEFAULT '0',
  `rsstype` tinyint NOT NULL DEFAULT '0',
  `rssarticles` tinyint NOT NULL DEFAULT '0',
  `assessed` bigint NOT NULL DEFAULT '0',
  `assesstimestart` bigint NOT NULL DEFAULT '0',
  `assesstimefinish` bigint NOT NULL DEFAULT '0',
  `scale` bigint NOT NULL DEFAULT '0',
  `timecreated` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  `completionentries` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]glos_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='all glossaries' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]glossary_alias`
--

CREATE TABLE `[[dbprefix]]glossary_alias` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `entryid` bigint NOT NULL DEFAULT '0',
  `alias` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]glosalia_ent_ix` (`entryid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='entries alias';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]glossary_categories`
--

CREATE TABLE `[[dbprefix]]glossary_categories` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `glossaryid` bigint NOT NULL DEFAULT '0',
  `name` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `usedynalink` tinyint NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]gloscate_glo_ix` (`glossaryid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='all categories for glossary entries' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]glossary_entries`
--

CREATE TABLE `[[dbprefix]]glossary_entries` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `glossaryid` bigint NOT NULL DEFAULT '0',
  `userid` bigint NOT NULL DEFAULT '0',
  `concept` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `definition` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `definitionformat` tinyint NOT NULL DEFAULT '0',
  `definitiontrust` tinyint NOT NULL DEFAULT '0',
  `attachment` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `timecreated` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  `teacherentry` tinyint NOT NULL DEFAULT '0',
  `sourceglossaryid` bigint NOT NULL DEFAULT '0',
  `usedynalink` tinyint NOT NULL DEFAULT '1',
  `casesensitive` tinyint NOT NULL DEFAULT '0',
  `fullmatch` tinyint NOT NULL DEFAULT '1',
  `approved` tinyint NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]glosentr_use_ix` (`userid`),
  KEY `[[dbprefix]]glosentr_con_ix` (`concept`),
  KEY `[[dbprefix]]glosentr_glo_ix` (`glossaryid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='all glossary entries';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]glossary_entries_categories`
--

CREATE TABLE `[[dbprefix]]glossary_entries_categories` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `categoryid` bigint NOT NULL DEFAULT '0',
  `entryid` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]glosentrcate_cat_ix` (`categoryid`),
  KEY `[[dbprefix]]glosentrcate_ent_ix` (`entryid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='categories of each glossary entry';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]glossary_formats`
--

CREATE TABLE `[[dbprefix]]glossary_formats` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(50) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `popupformatname` varchar(50) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `visible` tinyint NOT NULL DEFAULT '1',
  `showgroup` tinyint NOT NULL DEFAULT '1',
  `showtabs` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `defaultmode` varchar(50) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `defaulthook` varchar(50) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `sortkey` varchar(50) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `sortorder` varchar(50) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Setting of the display formats' AUTO_INCREMENT=8 ;

--
-- Dumping data for table `[[dbprefix]]glossary_formats`
--

INSERT INTO `[[dbprefix]]glossary_formats` VALUES
(1, 'continuous', 'continuous', 1, 1, 'standard,category,date', '', '', '', ''),
(2, 'dictionary', 'dictionary', 1, 1, 'standard', '', '', '', ''),
(3, 'encyclopedia', 'encyclopedia', 1, 1, 'standard,category,date,author', '', '', '', ''),
(4, 'entrylist', 'entrylist', 1, 1, 'standard,category,date,author', '', '', '', ''),
(5, 'faq', 'faq', 1, 1, 'standard,category,date,author', '', '', '', ''),
(6, 'fullwithauthor', 'fullwithauthor', 1, 1, 'standard,category,date,author', '', '', '', ''),
(7, 'fullwithoutauthor', 'fullwithoutauthor', 1, 1, 'standard,category,date', '', '', '', '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]gradepenalty_duedate_rule`
--

CREATE TABLE `[[dbprefix]]gradepenalty_duedate_rule` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `contextid` bigint NOT NULL,
  `sortorder` bigint NOT NULL DEFAULT '0',
  `overdueby` bigint NOT NULL,
  `penalty` double(10,0) NOT NULL,
  `usermodified` bigint NOT NULL DEFAULT '0',
  `timecreated` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]gradduedrule_con_ix` (`contextid`),
  KEY `[[dbprefix]]gradduedrule_use_ix` (`usermodified`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Penalty rules' AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]gradepenalty_duedate_rule`
--

INSERT INTO `[[dbprefix]]gradepenalty_duedate_rule` VALUES
(1, 1, 0, 1, 0, 0, [[timestamp]], [[timestamp]]);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]grade_categories`
--

CREATE TABLE `[[dbprefix]]grade_categories` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `courseid` bigint NOT NULL,
  `parent` bigint DEFAULT NULL,
  `depth` bigint NOT NULL DEFAULT '0',
  `path` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `fullname` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `aggregation` bigint NOT NULL DEFAULT '0',
  `keephigh` bigint NOT NULL DEFAULT '0',
  `droplow` bigint NOT NULL DEFAULT '0',
  `aggregateonlygraded` tinyint(1) NOT NULL DEFAULT '0',
  `aggregateoutcomes` tinyint(1) NOT NULL DEFAULT '0',
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  `hidden` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]gradcate_cou_ix` (`courseid`),
  KEY `[[dbprefix]]gradcate_par_ix` (`parent`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='This table keeps information about categories, used for grou';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]grade_categories_history`
--

CREATE TABLE `[[dbprefix]]grade_categories_history` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `action` bigint NOT NULL DEFAULT '0',
  `oldid` bigint NOT NULL,
  `source` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `timemodified` bigint DEFAULT NULL,
  `loggeduser` bigint DEFAULT NULL,
  `courseid` bigint NOT NULL,
  `parent` bigint DEFAULT NULL,
  `depth` bigint NOT NULL DEFAULT '0',
  `path` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `fullname` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `aggregation` bigint NOT NULL DEFAULT '0',
  `keephigh` bigint NOT NULL DEFAULT '0',
  `droplow` bigint NOT NULL DEFAULT '0',
  `aggregateonlygraded` tinyint(1) NOT NULL DEFAULT '0',
  `aggregateoutcomes` tinyint(1) NOT NULL DEFAULT '0',
  `aggregatesubcats` tinyint(1) NOT NULL DEFAULT '0',
  `hidden` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]gradcatehist_act_ix` (`action`),
  KEY `[[dbprefix]]gradcatehist_tim_ix` (`timemodified`),
  KEY `[[dbprefix]]gradcatehist_old_ix` (`oldid`),
  KEY `[[dbprefix]]gradcatehist_cou_ix` (`courseid`),
  KEY `[[dbprefix]]gradcatehist_par_ix` (`parent`),
  KEY `[[dbprefix]]gradcatehist_log_ix` (`loggeduser`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='History of grade_categories';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]grade_grades`
--

CREATE TABLE `[[dbprefix]]grade_grades` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `itemid` bigint NOT NULL,
  `userid` bigint NOT NULL,
  `rawgrade` decimal(10,5) DEFAULT NULL,
  `rawgrademax` decimal(10,5) NOT NULL DEFAULT '100.00000',
  `rawgrademin` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `rawscaleid` bigint DEFAULT NULL,
  `usermodified` bigint DEFAULT NULL,
  `finalgrade` decimal(10,5) DEFAULT NULL,
  `hidden` bigint NOT NULL DEFAULT '0',
  `locked` bigint NOT NULL DEFAULT '0',
  `locktime` bigint NOT NULL DEFAULT '0',
  `exported` bigint NOT NULL DEFAULT '0',
  `overridden` bigint NOT NULL DEFAULT '0',
  `excluded` bigint NOT NULL DEFAULT '0',
  `feedback` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `feedbackformat` bigint NOT NULL DEFAULT '0',
  `information` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `informationformat` bigint NOT NULL DEFAULT '0',
  `timecreated` bigint DEFAULT NULL,
  `timemodified` bigint DEFAULT NULL,
  `aggregationstatus` varchar(10) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT 'unknown',
  `aggregationweight` decimal(10,5) DEFAULT NULL,
  `deductedmark` decimal(10,5) NOT NULL DEFAULT '0.00000',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]gradgrad_useite_uix` (`userid`,`itemid`),
  KEY `[[dbprefix]]gradgrad_locloc_ix` (`locked`,`locktime`),
  KEY `[[dbprefix]]gradgrad_ite_ix` (`itemid`),
  KEY `[[dbprefix]]gradgrad_use_ix` (`userid`),
  KEY `[[dbprefix]]gradgrad_raw_ix` (`rawscaleid`),
  KEY `[[dbprefix]]gradgrad_use2_ix` (`usermodified`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='grade_grades  This table keeps individual grades for each us' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]grade_grades_history`
--

CREATE TABLE `[[dbprefix]]grade_grades_history` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `action` bigint NOT NULL DEFAULT '0',
  `oldid` bigint NOT NULL,
  `source` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `timemodified` bigint DEFAULT NULL,
  `loggeduser` bigint DEFAULT NULL,
  `itemid` bigint NOT NULL,
  `userid` bigint NOT NULL,
  `rawgrade` decimal(10,5) DEFAULT NULL,
  `rawgrademax` decimal(10,5) NOT NULL DEFAULT '100.00000',
  `rawgrademin` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `rawscaleid` bigint DEFAULT NULL,
  `usermodified` bigint DEFAULT NULL,
  `finalgrade` decimal(10,5) DEFAULT NULL,
  `hidden` bigint NOT NULL DEFAULT '0',
  `locked` bigint NOT NULL DEFAULT '0',
  `locktime` bigint NOT NULL DEFAULT '0',
  `exported` bigint NOT NULL DEFAULT '0',
  `overridden` bigint NOT NULL DEFAULT '0',
  `excluded` bigint NOT NULL DEFAULT '0',
  `feedback` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `feedbackformat` bigint NOT NULL DEFAULT '0',
  `information` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `informationformat` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]gradgradhist_act_ix` (`action`),
  KEY `[[dbprefix]]gradgradhist_tim_ix` (`timemodified`),
  KEY `[[dbprefix]]gradgradhist_useiteti_ix` (`userid`,`itemid`,`timemodified`),
  KEY `[[dbprefix]]gradgradhist_old_ix` (`oldid`),
  KEY `[[dbprefix]]gradgradhist_ite_ix` (`itemid`),
  KEY `[[dbprefix]]gradgradhist_use_ix` (`userid`),
  KEY `[[dbprefix]]gradgradhist_raw_ix` (`rawscaleid`),
  KEY `[[dbprefix]]gradgradhist_use2_ix` (`usermodified`),
  KEY `[[dbprefix]]gradgradhist_log_ix` (`loggeduser`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='History table';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]grade_import_newitem`
--

CREATE TABLE `[[dbprefix]]grade_import_newitem` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `itemname` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `importcode` bigint NOT NULL,
  `importer` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]gradimponewi_imp_ix` (`importer`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='temporary table for storing new grade_item names from grade ';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]grade_import_values`
--

CREATE TABLE `[[dbprefix]]grade_import_values` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `itemid` bigint DEFAULT NULL,
  `newgradeitem` bigint DEFAULT NULL,
  `userid` bigint NOT NULL,
  `finalgrade` decimal(10,5) DEFAULT NULL,
  `feedback` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `importcode` bigint NOT NULL,
  `importer` bigint DEFAULT NULL,
  `importonlyfeedback` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]gradimpovalu_ite_ix` (`itemid`),
  KEY `[[dbprefix]]gradimpovalu_new_ix` (`newgradeitem`),
  KEY `[[dbprefix]]gradimpovalu_imp_ix` (`importer`),
  KEY `[[dbprefix]]gradimpovalu_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Temporary table for importing grades';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]grade_items`
--

CREATE TABLE `[[dbprefix]]grade_items` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `courseid` bigint DEFAULT NULL,
  `categoryid` bigint DEFAULT NULL,
  `itemname` varchar(1333) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `itemtype` varchar(30) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `itemmodule` varchar(30) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `iteminstance` bigint DEFAULT NULL,
  `itemnumber` bigint DEFAULT NULL,
  `iteminfo` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `idnumber` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `calculation` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `gradetype` smallint NOT NULL DEFAULT '1',
  `grademax` decimal(10,5) NOT NULL DEFAULT '100.00000',
  `grademin` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `scaleid` bigint DEFAULT NULL,
  `outcomeid` bigint DEFAULT NULL,
  `gradepass` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `multfactor` decimal(10,5) NOT NULL DEFAULT '1.00000',
  `plusfactor` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `aggregationcoef` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `aggregationcoef2` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `sortorder` bigint NOT NULL DEFAULT '0',
  `display` bigint NOT NULL DEFAULT '0',
  `decimals` tinyint(1) DEFAULT NULL,
  `hidden` bigint NOT NULL DEFAULT '0',
  `locked` bigint NOT NULL DEFAULT '0',
  `locktime` bigint NOT NULL DEFAULT '0',
  `needsupdate` bigint NOT NULL DEFAULT '0',
  `weightoverride` tinyint(1) NOT NULL DEFAULT '0',
  `timecreated` bigint DEFAULT NULL,
  `timemodified` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]graditem_locloc_ix` (`locked`,`locktime`),
  KEY `[[dbprefix]]graditem_itenee_ix` (`itemtype`,`needsupdate`),
  KEY `[[dbprefix]]graditem_gra_ix` (`gradetype`),
  KEY `[[dbprefix]]graditem_idncou_ix` (`idnumber`,`courseid`),
  KEY `[[dbprefix]]graditem_iteiteitecou_ix` (`itemtype`,`itemmodule`,`iteminstance`,`courseid`),
  KEY `[[dbprefix]]graditem_cou_ix` (`courseid`),
  KEY `[[dbprefix]]graditem_cat_ix` (`categoryid`),
  KEY `[[dbprefix]]graditem_sca_ix` (`scaleid`),
  KEY `[[dbprefix]]graditem_out_ix` (`outcomeid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='This table keeps information about gradeable items (ie colum' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]grade_items_history`
--

CREATE TABLE `[[dbprefix]]grade_items_history` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `action` bigint NOT NULL DEFAULT '0',
  `oldid` bigint NOT NULL,
  `source` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `timemodified` bigint DEFAULT NULL,
  `loggeduser` bigint DEFAULT NULL,
  `courseid` bigint DEFAULT NULL,
  `categoryid` bigint DEFAULT NULL,
  `itemname` varchar(1333) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `itemtype` varchar(30) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `itemmodule` varchar(30) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `iteminstance` bigint DEFAULT NULL,
  `itemnumber` bigint DEFAULT NULL,
  `iteminfo` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `idnumber` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `calculation` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `gradetype` smallint NOT NULL DEFAULT '1',
  `grademax` decimal(10,5) NOT NULL DEFAULT '100.00000',
  `grademin` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `scaleid` bigint DEFAULT NULL,
  `outcomeid` bigint DEFAULT NULL,
  `gradepass` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `multfactor` decimal(10,5) NOT NULL DEFAULT '1.00000',
  `plusfactor` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `aggregationcoef` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `aggregationcoef2` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `sortorder` bigint NOT NULL DEFAULT '0',
  `hidden` bigint NOT NULL DEFAULT '0',
  `locked` bigint NOT NULL DEFAULT '0',
  `locktime` bigint NOT NULL DEFAULT '0',
  `needsupdate` bigint NOT NULL DEFAULT '0',
  `display` bigint NOT NULL DEFAULT '0',
  `decimals` tinyint(1) DEFAULT NULL,
  `weightoverride` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]graditemhist_act_ix` (`action`),
  KEY `[[dbprefix]]graditemhist_tim_ix` (`timemodified`),
  KEY `[[dbprefix]]graditemhist_old_ix` (`oldid`),
  KEY `[[dbprefix]]graditemhist_cou_ix` (`courseid`),
  KEY `[[dbprefix]]graditemhist_cat_ix` (`categoryid`),
  KEY `[[dbprefix]]graditemhist_sca_ix` (`scaleid`),
  KEY `[[dbprefix]]graditemhist_out_ix` (`outcomeid`),
  KEY `[[dbprefix]]graditemhist_log_ix` (`loggeduser`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='History of grade_items';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]grade_letters`
--

CREATE TABLE `[[dbprefix]]grade_letters` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `contextid` bigint NOT NULL,
  `lowerboundary` decimal(10,5) NOT NULL,
  `letter` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]gradlett_conlowlet_uix` (`contextid`,`lowerboundary`,`letter`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Repository for grade letters, for courses and other moodle e';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]grade_outcomes`
--

CREATE TABLE `[[dbprefix]]grade_outcomes` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `courseid` bigint DEFAULT NULL,
  `shortname` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `fullname` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `scaleid` bigint DEFAULT NULL,
  `description` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `descriptionformat` tinyint NOT NULL DEFAULT '0',
  `timecreated` bigint DEFAULT NULL,
  `timemodified` bigint DEFAULT NULL,
  `usermodified` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]gradoutc_cousho_uix` (`courseid`,`shortname`),
  KEY `[[dbprefix]]gradoutc_cou_ix` (`courseid`),
  KEY `[[dbprefix]]gradoutc_sca_ix` (`scaleid`),
  KEY `[[dbprefix]]gradoutc_use_ix` (`usermodified`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='This table describes the outcomes used in the system. An out';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]grade_outcomes_courses`
--

CREATE TABLE `[[dbprefix]]grade_outcomes_courses` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `courseid` bigint NOT NULL,
  `outcomeid` bigint NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]gradoutccour_couout_uix` (`courseid`,`outcomeid`),
  KEY `[[dbprefix]]gradoutccour_cou_ix` (`courseid`),
  KEY `[[dbprefix]]gradoutccour_out_ix` (`outcomeid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='stores what outcomes are used in what courses.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]grade_outcomes_history`
--

CREATE TABLE `[[dbprefix]]grade_outcomes_history` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `action` bigint NOT NULL DEFAULT '0',
  `oldid` bigint NOT NULL,
  `source` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `timemodified` bigint DEFAULT NULL,
  `loggeduser` bigint DEFAULT NULL,
  `courseid` bigint DEFAULT NULL,
  `shortname` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `fullname` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `scaleid` bigint DEFAULT NULL,
  `description` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `descriptionformat` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]gradoutchist_act_ix` (`action`),
  KEY `[[dbprefix]]gradoutchist_tim_ix` (`timemodified`),
  KEY `[[dbprefix]]gradoutchist_old_ix` (`oldid`),
  KEY `[[dbprefix]]gradoutchist_cou_ix` (`courseid`),
  KEY `[[dbprefix]]gradoutchist_sca_ix` (`scaleid`),
  KEY `[[dbprefix]]gradoutchist_log_ix` (`loggeduser`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='History table';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]grade_settings`
--

CREATE TABLE `[[dbprefix]]grade_settings` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `courseid` bigint NOT NULL,
  `name` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `value` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]gradsett_counam_uix` (`courseid`,`name`),
  KEY `[[dbprefix]]gradsett_cou_ix` (`courseid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='gradebook settings';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]gradingform_guide_comments`
--

CREATE TABLE `[[dbprefix]]gradingform_guide_comments` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `definitionid` bigint NOT NULL,
  `sortorder` bigint NOT NULL,
  `description` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `descriptionformat` tinyint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]gradguidcomm_def_ix` (`definitionid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='frequently used comments used in marking guide';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]gradingform_guide_criteria`
--

CREATE TABLE `[[dbprefix]]gradingform_guide_criteria` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `definitionid` bigint NOT NULL,
  `sortorder` bigint NOT NULL,
  `shortname` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `description` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `descriptionformat` tinyint DEFAULT NULL,
  `descriptionmarkers` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `descriptionmarkersformat` tinyint DEFAULT NULL,
  `maxscore` decimal(10,5) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]gradguidcrit_def_ix` (`definitionid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores the rows of the criteria grid.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]gradingform_guide_fillings`
--

CREATE TABLE `[[dbprefix]]gradingform_guide_fillings` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `instanceid` bigint NOT NULL,
  `criterionid` bigint NOT NULL,
  `remark` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `remarkformat` tinyint DEFAULT NULL,
  `score` decimal(10,5) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]gradguidfill_inscri_uix` (`instanceid`,`criterionid`),
  KEY `[[dbprefix]]gradguidfill_ins_ix` (`instanceid`),
  KEY `[[dbprefix]]gradguidfill_cri_ix` (`criterionid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores the data of how the guide is filled by a particular r';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]gradingform_rubric_criteria`
--

CREATE TABLE `[[dbprefix]]gradingform_rubric_criteria` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `definitionid` bigint NOT NULL,
  `sortorder` bigint NOT NULL,
  `description` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `descriptionformat` tinyint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]gradrubrcrit_def_ix` (`definitionid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores the rows of the rubric grid.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]gradingform_rubric_fillings`
--

CREATE TABLE `[[dbprefix]]gradingform_rubric_fillings` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `instanceid` bigint NOT NULL,
  `criterionid` bigint NOT NULL,
  `levelid` bigint DEFAULT NULL,
  `remark` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `remarkformat` tinyint DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]gradrubrfill_inscri_uix` (`instanceid`,`criterionid`),
  KEY `[[dbprefix]]gradrubrfill_lev_ix` (`levelid`),
  KEY `[[dbprefix]]gradrubrfill_ins_ix` (`instanceid`),
  KEY `[[dbprefix]]gradrubrfill_cri_ix` (`criterionid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores the data of how the rubric is filled by a particular ';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]gradingform_rubric_levels`
--

CREATE TABLE `[[dbprefix]]gradingform_rubric_levels` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `criterionid` bigint NOT NULL,
  `score` decimal(10,5) NOT NULL,
  `definition` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `definitionformat` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]gradrubrleve_cri_ix` (`criterionid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores the columns of the rubric grid.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]grading_areas`
--

CREATE TABLE `[[dbprefix]]grading_areas` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `contextid` bigint NOT NULL,
  `component` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `areaname` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `activemethod` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]gradarea_concomare_uix` (`contextid`,`component`,`areaname`),
  KEY `[[dbprefix]]gradarea_con_ix` (`contextid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Identifies gradable areas where advanced grading can happen.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]grading_definitions`
--

CREATE TABLE `[[dbprefix]]grading_definitions` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `areaid` bigint NOT NULL,
  `method` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `name` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `description` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `descriptionformat` tinyint DEFAULT NULL,
  `status` bigint NOT NULL DEFAULT '0',
  `copiedfromid` bigint DEFAULT NULL,
  `timecreated` bigint NOT NULL,
  `usercreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  `usermodified` bigint NOT NULL,
  `timecopied` bigint DEFAULT '0',
  `options` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]graddefi_aremet_uix` (`areaid`,`method`),
  KEY `[[dbprefix]]graddefi_are_ix` (`areaid`),
  KEY `[[dbprefix]]graddefi_use_ix` (`usermodified`),
  KEY `[[dbprefix]]graddefi_use2_ix` (`usercreated`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Contains the basic information about an advanced grading for';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]grading_instances`
--

CREATE TABLE `[[dbprefix]]grading_instances` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `definitionid` bigint NOT NULL,
  `raterid` bigint NOT NULL,
  `itemid` bigint DEFAULT NULL,
  `rawgrade` decimal(10,5) DEFAULT NULL,
  `status` bigint NOT NULL DEFAULT '0',
  `feedback` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `feedbackformat` tinyint DEFAULT NULL,
  `timemodified` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]gradinst_def_ix` (`definitionid`),
  KEY `[[dbprefix]]gradinst_rat_ix` (`raterid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Grading form instance is an assessment record for one gradab';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]groupings`
--

CREATE TABLE `[[dbprefix]]groupings` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `courseid` bigint NOT NULL DEFAULT '0',
  `name` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `idnumber` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `description` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `descriptionformat` tinyint NOT NULL DEFAULT '0',
  `configdata` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `timecreated` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]grou_idn2_ix` (`idnumber`),
  KEY `[[dbprefix]]grou_cou2_ix` (`courseid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='A grouping is a collection of groups. WAS: groups_groupings';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]groupings_groups`
--

CREATE TABLE `[[dbprefix]]groupings_groups` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `groupingid` bigint NOT NULL DEFAULT '0',
  `groupid` bigint NOT NULL DEFAULT '0',
  `timeadded` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]grougrou_gro_ix` (`groupingid`),
  KEY `[[dbprefix]]grougrou_gro2_ix` (`groupid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Link a grouping to a group (note, groups can be in multiple ';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]groups`
--

CREATE TABLE `[[dbprefix]]groups` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `courseid` bigint NOT NULL,
  `idnumber` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `name` varchar(254) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `description` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `descriptionformat` tinyint NOT NULL DEFAULT '0',
  `enrolmentkey` varchar(50) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `picture` bigint NOT NULL DEFAULT '0',
  `visibility` tinyint(1) NOT NULL DEFAULT '0',
  `participation` tinyint(1) NOT NULL DEFAULT '1',
  `timecreated` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]grou_idn_ix` (`idnumber`),
  KEY `[[dbprefix]]grou_cou_ix` (`courseid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Each record represents a group.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]groups_members`
--

CREATE TABLE `[[dbprefix]]groups_members` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `groupid` bigint NOT NULL DEFAULT '0',
  `userid` bigint NOT NULL DEFAULT '0',
  `timeadded` bigint NOT NULL DEFAULT '0',
  `component` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `itemid` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]groumemb_usegro_uix` (`userid`,`groupid`),
  KEY `[[dbprefix]]groumemb_gro_ix` (`groupid`),
  KEY `[[dbprefix]]groumemb_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Link a user to a group.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]h5p`
--

CREATE TABLE `[[dbprefix]]h5p` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `jsoncontent` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `mainlibraryid` bigint NOT NULL,
  `displayoptions` smallint DEFAULT NULL,
  `pathnamehash` varchar(40) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `contenthash` varchar(40) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `filtered` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `timecreated` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]h5p_pat_ix` (`pathnamehash`),
  KEY `[[dbprefix]]h5p_mai_ix` (`mainlibraryid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores H5P content information';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]h5pactivity`
--

CREATE TABLE `[[dbprefix]]h5pactivity` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `course` bigint NOT NULL,
  `name` varchar(1333) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  `intro` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `introformat` smallint NOT NULL DEFAULT '0',
  `grade` bigint DEFAULT '0',
  `displayoptions` smallint NOT NULL DEFAULT '0',
  `enabletracking` tinyint(1) NOT NULL DEFAULT '1',
  `grademethod` smallint NOT NULL DEFAULT '1',
  `reviewmode` smallint DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]h5pa_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores the h5pactivity activity module instances.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]h5pactivity_attempts`
--

CREATE TABLE `[[dbprefix]]h5pactivity_attempts` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `h5pactivityid` bigint NOT NULL,
  `userid` bigint NOT NULL,
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  `attempt` mediumint NOT NULL DEFAULT '1',
  `rawscore` bigint DEFAULT '0',
  `maxscore` bigint DEFAULT '0',
  `scaled` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `duration` bigint DEFAULT '0',
  `completion` tinyint(1) DEFAULT NULL,
  `success` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]h5paatte_h5puseatt_uix` (`h5pactivityid`,`userid`,`attempt`),
  KEY `[[dbprefix]]h5paatte_tim_ix` (`timecreated`),
  KEY `[[dbprefix]]h5paatte_h5ptim_ix` (`h5pactivityid`,`timecreated`),
  KEY `[[dbprefix]]h5paatte_h5puse_ix` (`h5pactivityid`,`userid`),
  KEY `[[dbprefix]]h5paatte_h5p_ix` (`h5pactivityid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Users attempts inside H5P activities';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]h5pactivity_attempts_results`
--

CREATE TABLE `[[dbprefix]]h5pactivity_attempts_results` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `attemptid` bigint NOT NULL,
  `subcontent` varchar(128) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `timecreated` bigint NOT NULL,
  `interactiontype` varchar(128) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `description` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `correctpattern` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `response` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `additionals` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `rawscore` bigint NOT NULL DEFAULT '0',
  `maxscore` bigint NOT NULL DEFAULT '0',
  `duration` bigint DEFAULT '0',
  `completion` tinyint(1) DEFAULT NULL,
  `success` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]h5paatteresu_atttim_ix` (`attemptid`,`timecreated`),
  KEY `[[dbprefix]]h5paatteresu_att_ix` (`attemptid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='H5Pactivities_attempts tracking info';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]h5p_contents_libraries`
--

CREATE TABLE `[[dbprefix]]h5p_contents_libraries` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `h5pid` bigint NOT NULL,
  `libraryid` bigint NOT NULL,
  `dependencytype` varchar(10) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `dropcss` tinyint(1) NOT NULL,
  `weight` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]h5pcontlibr_h5p_ix` (`h5pid`),
  KEY `[[dbprefix]]h5pcontlibr_lib_ix` (`libraryid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Store which library is used in which content.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]h5p_libraries`
--

CREATE TABLE `[[dbprefix]]h5p_libraries` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `machinename` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `title` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `majorversion` smallint NOT NULL,
  `minorversion` smallint NOT NULL,
  `patchversion` smallint NOT NULL,
  `runnable` tinyint(1) NOT NULL,
  `fullscreen` tinyint(1) NOT NULL DEFAULT '0',
  `embedtypes` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `preloadedjs` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `preloadedcss` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `droplibrarycss` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `semantics` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `addto` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `coremajor` smallint DEFAULT NULL,
  `coreminor` smallint DEFAULT NULL,
  `metadatasettings` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `tutorial` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `example` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `enabled` tinyint(1) DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]h5plibr_macmajminpatr_ix` (`machinename`,`majorversion`,`minorversion`,`patchversion`,`runnable`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores information about libraries used by H5P content.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]h5p_libraries_cachedassets`
--

CREATE TABLE `[[dbprefix]]h5p_libraries_cachedassets` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `libraryid` bigint NOT NULL,
  `hash` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]h5plibrcach_lib_ix` (`libraryid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='H5P cached library assets';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]h5p_library_dependencies`
--

CREATE TABLE `[[dbprefix]]h5p_library_dependencies` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `libraryid` bigint NOT NULL,
  `requiredlibraryid` bigint NOT NULL,
  `dependencytype` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]h5plibrdepe_lib_ix` (`libraryid`),
  KEY `[[dbprefix]]h5plibrdepe_req_ix` (`requiredlibraryid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores H5P library dependencies';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]imscp`
--

CREATE TABLE `[[dbprefix]]imscp` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `course` bigint NOT NULL DEFAULT '0',
  `name` varchar(1333) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `intro` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `introformat` smallint NOT NULL DEFAULT '0',
  `revision` bigint NOT NULL DEFAULT '0',
  `keepold` bigint NOT NULL DEFAULT '-1',
  `structure` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `timemodified` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]imsc_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='each record is one imscp resource';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]infected_files`
--

CREATE TABLE `[[dbprefix]]infected_files` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `filename` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `quarantinedfile` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `userid` bigint NOT NULL,
  `reason` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `timecreated` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]infefile_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Table to store infected file details.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]label`
--

CREATE TABLE `[[dbprefix]]label` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `course` bigint NOT NULL DEFAULT '0',
  `name` varchar(1333) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `intro` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `introformat` smallint DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]labe_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Defines labels';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lesson`
--

CREATE TABLE `[[dbprefix]]lesson` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `course` bigint NOT NULL DEFAULT '0',
  `name` varchar(1333) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `intro` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `introformat` smallint NOT NULL DEFAULT '0',
  `practice` smallint NOT NULL DEFAULT '0',
  `modattempts` smallint NOT NULL DEFAULT '0',
  `usepassword` smallint NOT NULL DEFAULT '0',
  `password` varchar(32) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `dependency` bigint NOT NULL DEFAULT '0',
  `conditions` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `grade` bigint NOT NULL DEFAULT '0',
  `custom` smallint NOT NULL DEFAULT '0',
  `ongoing` smallint NOT NULL DEFAULT '0',
  `usemaxgrade` smallint NOT NULL DEFAULT '0',
  `maxanswers` smallint NOT NULL DEFAULT '4',
  `maxattempts` smallint NOT NULL DEFAULT '5',
  `review` smallint NOT NULL DEFAULT '0',
  `nextpagedefault` smallint NOT NULL DEFAULT '0',
  `feedback` smallint NOT NULL DEFAULT '1',
  `minquestions` smallint NOT NULL DEFAULT '0',
  `maxpages` smallint NOT NULL DEFAULT '0',
  `timelimit` bigint NOT NULL DEFAULT '0',
  `retake` smallint NOT NULL DEFAULT '1',
  `activitylink` bigint NOT NULL DEFAULT '0',
  `mediafile` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `mediaheight` bigint NOT NULL DEFAULT '100',
  `mediawidth` bigint NOT NULL DEFAULT '650',
  `mediaclose` smallint NOT NULL DEFAULT '0',
  `slideshow` smallint NOT NULL DEFAULT '0',
  `width` bigint NOT NULL DEFAULT '640',
  `height` bigint NOT NULL DEFAULT '480',
  `bgcolor` varchar(7) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '#FFFFFF',
  `displayleft` smallint NOT NULL DEFAULT '0',
  `displayleftif` smallint NOT NULL DEFAULT '0',
  `progressbar` smallint NOT NULL DEFAULT '0',
  `available` bigint NOT NULL DEFAULT '0',
  `deadline` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  `completionendreached` tinyint(1) DEFAULT '0',
  `completiontimespent` bigint DEFAULT '0',
  `allowofflineattempts` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]less_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Defines lesson';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lesson_answers`
--

CREATE TABLE `[[dbprefix]]lesson_answers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `lessonid` bigint NOT NULL DEFAULT '0',
  `pageid` bigint NOT NULL DEFAULT '0',
  `jumpto` bigint NOT NULL DEFAULT '0',
  `grade` smallint NOT NULL DEFAULT '0',
  `score` bigint NOT NULL DEFAULT '0',
  `flags` smallint NOT NULL DEFAULT '0',
  `timecreated` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  `answer` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `answerformat` tinyint NOT NULL DEFAULT '0',
  `response` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `responseformat` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]lessansw_les_ix` (`lessonid`),
  KEY `[[dbprefix]]lessansw_pag_ix` (`pageid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Defines lesson_answers';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lesson_attempts`
--

CREATE TABLE `[[dbprefix]]lesson_attempts` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `lessonid` bigint NOT NULL DEFAULT '0',
  `pageid` bigint NOT NULL DEFAULT '0',
  `userid` bigint NOT NULL DEFAULT '0',
  `answerid` bigint NOT NULL DEFAULT '0',
  `retry` smallint NOT NULL DEFAULT '0',
  `correct` bigint NOT NULL DEFAULT '0',
  `useranswer` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `timeseen` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]lessatte_use_ix` (`userid`),
  KEY `[[dbprefix]]lessatte_les_ix` (`lessonid`),
  KEY `[[dbprefix]]lessatte_pag_ix` (`pageid`),
  KEY `[[dbprefix]]lessatte_ans_ix` (`answerid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Defines lesson_attempts';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lesson_branch`
--

CREATE TABLE `[[dbprefix]]lesson_branch` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `lessonid` bigint NOT NULL DEFAULT '0',
  `userid` bigint NOT NULL DEFAULT '0',
  `pageid` bigint NOT NULL DEFAULT '0',
  `retry` bigint NOT NULL DEFAULT '0',
  `flag` smallint NOT NULL DEFAULT '0',
  `timeseen` bigint NOT NULL DEFAULT '0',
  `nextpageid` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]lessbran_use_ix` (`userid`),
  KEY `[[dbprefix]]lessbran_les_ix` (`lessonid`),
  KEY `[[dbprefix]]lessbran_pag_ix` (`pageid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='branches for each lesson/user';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lesson_grades`
--

CREATE TABLE `[[dbprefix]]lesson_grades` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `lessonid` bigint NOT NULL DEFAULT '0',
  `userid` bigint NOT NULL DEFAULT '0',
  `grade` double NOT NULL DEFAULT '0',
  `late` smallint NOT NULL DEFAULT '0',
  `completed` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]lessgrad_use_ix` (`userid`),
  KEY `[[dbprefix]]lessgrad_les_ix` (`lessonid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Defines lesson_grades';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lesson_overrides`
--

CREATE TABLE `[[dbprefix]]lesson_overrides` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `lessonid` bigint NOT NULL DEFAULT '0',
  `groupid` bigint DEFAULT NULL,
  `userid` bigint DEFAULT NULL,
  `available` bigint DEFAULT NULL,
  `deadline` bigint DEFAULT NULL,
  `timelimit` bigint DEFAULT NULL,
  `review` smallint DEFAULT NULL,
  `maxattempts` smallint DEFAULT NULL,
  `retake` smallint DEFAULT NULL,
  `password` varchar(32) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]lessover_les_ix` (`lessonid`),
  KEY `[[dbprefix]]lessover_gro_ix` (`groupid`),
  KEY `[[dbprefix]]lessover_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='The overrides to lesson settings.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lesson_pages`
--

CREATE TABLE `[[dbprefix]]lesson_pages` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `lessonid` bigint NOT NULL DEFAULT '0',
  `prevpageid` bigint NOT NULL DEFAULT '0',
  `nextpageid` bigint NOT NULL DEFAULT '0',
  `qtype` smallint NOT NULL DEFAULT '0',
  `qoption` smallint NOT NULL DEFAULT '0',
  `layout` smallint NOT NULL DEFAULT '1',
  `display` smallint NOT NULL DEFAULT '1',
  `timecreated` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  `title` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `contents` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `contentsformat` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]lesspage_les_ix` (`lessonid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Defines lesson_pages';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lesson_timer`
--

CREATE TABLE `[[dbprefix]]lesson_timer` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `lessonid` bigint NOT NULL DEFAULT '0',
  `userid` bigint NOT NULL DEFAULT '0',
  `starttime` bigint NOT NULL DEFAULT '0',
  `lessontime` bigint NOT NULL DEFAULT '0',
  `completed` tinyint(1) DEFAULT '0',
  `timemodifiedoffline` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]lesstime_use_ix` (`userid`),
  KEY `[[dbprefix]]lesstime_les_ix` (`lessonid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='lesson timer for each lesson';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]license`
--

CREATE TABLE `[[dbprefix]]license` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `shortname` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `fullname` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `source` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT '1',
  `version` bigint NOT NULL DEFAULT '0',
  `custom` tinyint(1) NOT NULL DEFAULT '0',
  `sortorder` mediumint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='store licenses used by moodle' AUTO_INCREMENT=10 ;

--
-- Dumping data for table `[[dbprefix]]license`
--

INSERT INTO `[[dbprefix]]license` VALUES
(1, 'unknown', 'Licence not specified', '', 1, 2010033100, 0, 1),
(2, 'allrightsreserved', 'All rights reserved', 'https://en.wikipedia.org/wiki/All_rights_reserved', 1, 2010033100, 0, 2),
(3, 'public', 'Public domain', 'https://en.wikipedia.org/wiki/Public_domain', 1, 2010033100, 0, 3),
(4, 'cc-4.0', 'Creative Commons - 4.0 International', 'https://creativecommons.org/licenses/by/4.0/', 1, 2022120100, 0, 4),
(5, 'cc-nc-4.0', 'Creative Commons - NonCommercial 4.0 International', 'https://creativecommons.org/licenses/by-nc/4.0/', 1, 2022120100, 0, 5),
(6, 'cc-nd-4.0', 'Creative Commons - NoDerivatives 4.0 International', 'https://creativecommons.org/licenses/by-nd/4.0/', 1, 2022120100, 0, 6),
(7, 'cc-nc-nd-4.0', 'Creative Commons - NonCommercial-NoDerivatives 4.0 International', 'https://creativecommons.org/licenses/by-nc-nd/4.0/', 1, 2022120100, 0, 7),
(8, 'cc-nc-sa-4.0', 'Creative Commons - NonCommercial-ShareAlike 4.0 International', 'https://creativecommons.org/licenses/by-nc-sa/4.0/', 1, 2022120100, 0, 8),
(9, 'cc-sa-4.0', 'Creative Commons - ShareAlike 4.0 International', 'https://creativecommons.org/licenses/by-sa/4.0/', 1, 2022120100, 0, 9);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lock_db`
--

CREATE TABLE `[[dbprefix]]lock_db` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `resourcekey` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `expires` bigint DEFAULT NULL,
  `owner` varchar(36) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]lockdb_res_uix` (`resourcekey`),
  KEY `[[dbprefix]]lockdb_exp_ix` (`expires`),
  KEY `[[dbprefix]]lockdb_own_ix` (`owner`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores active and inactive lock types for db locking method.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]log`
--

CREATE TABLE `[[dbprefix]]log` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `time` bigint NOT NULL DEFAULT '0',
  `userid` bigint NOT NULL DEFAULT '0',
  `ip` varchar(45) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `course` bigint NOT NULL DEFAULT '0',
  `module` varchar(20) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `cmid` bigint NOT NULL DEFAULT '0',
  `action` varchar(40) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `url` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `info` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]log_coumodact_ix` (`course`,`module`,`action`),
  KEY `[[dbprefix]]log_tim_ix` (`time`),
  KEY `[[dbprefix]]log_act_ix` (`action`),
  KEY `[[dbprefix]]log_usecou_ix` (`userid`,`course`),
  KEY `[[dbprefix]]log_cmi_ix` (`cmid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Every action is logged as far as possible';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]logstore_standard_log`
--

CREATE TABLE `[[dbprefix]]logstore_standard_log` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `eventname` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `component` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `action` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `target` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `objecttable` varchar(50) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `objectid` bigint DEFAULT NULL,
  `crud` varchar(1) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `edulevel` tinyint(1) NOT NULL,
  `contextid` bigint NOT NULL,
  `contextlevel` bigint NOT NULL,
  `contextinstanceid` bigint NOT NULL,
  `userid` bigint NOT NULL,
  `courseid` bigint DEFAULT NULL,
  `relateduserid` bigint DEFAULT NULL,
  `anonymous` tinyint(1) NOT NULL DEFAULT '0',
  `other` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `timecreated` bigint NOT NULL,
  `origin` varchar(10) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `ip` varchar(45) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `realuserid` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]logsstanlog_tim_ix` (`timecreated`),
  KEY `[[dbprefix]]logsstanlog_couanotim_ix` (`courseid`,`anonymous`,`timecreated`),
  KEY `[[dbprefix]]logsstanlog_useconcon_ix` (`userid`,`contextlevel`,`contextinstanceid`,`crud`,`edulevel`,`timecreated`),
  KEY `[[dbprefix]]logsstanlog_con_ix` (`contextid`),
  KEY `[[dbprefix]]logsstanlog_use_ix` (`userid`),
  KEY `[[dbprefix]]logsstanlog_cou_ix` (`courseid`),
  KEY `[[dbprefix]]logsstanlog_rea_ix` (`realuserid`),
  KEY `[[dbprefix]]logsstanlog_rel_ix` (`relateduserid`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Standard log table' AUTO_INCREMENT=1 ;

--
-- Dumping data for table `[[dbprefix]]logstore_standard_log`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]log_display`
--

CREATE TABLE `[[dbprefix]]log_display` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `module` varchar(20) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `action` varchar(40) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `mtable` varchar(30) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `field` varchar(200) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `component` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]logdisp_modact_uix` (`module`,`action`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='For a particular module/action, specifies a moodle table/fie' AUTO_INCREMENT=184 ;

--
-- Dumping data for table `[[dbprefix]]log_display`
--

INSERT INTO `[[dbprefix]]log_display` VALUES
(1, 'course', 'user report', 'user', 'CONCAT(firstname, '' '', lastname)', 'moodle'),
(2, 'course', 'view', 'course', 'fullname', 'moodle'),
(3, 'course', 'view section', 'course_sections', 'name', 'moodle'),
(4, 'course', 'update', 'course', 'fullname', 'moodle'),
(5, 'course', 'hide', 'course', 'fullname', 'moodle'),
(6, 'course', 'show', 'course', 'fullname', 'moodle'),
(7, 'course', 'move', 'course', 'fullname', 'moodle'),
(8, 'course', 'enrol', 'course', 'fullname', 'moodle'),
(9, 'course', 'unenrol', 'course', 'fullname', 'moodle'),
(10, 'course', 'report log', 'course', 'fullname', 'moodle'),
(11, 'course', 'report live', 'course', 'fullname', 'moodle'),
(12, 'course', 'report outline', 'course', 'fullname', 'moodle'),
(13, 'course', 'report participation', 'course', 'fullname', 'moodle'),
(14, 'course', 'report stats', 'course', 'fullname', 'moodle'),
(15, 'category', 'add', 'course_categories', 'name', 'moodle'),
(16, 'category', 'hide', 'course_categories', 'name', 'moodle'),
(17, 'category', 'move', 'course_categories', 'name', 'moodle'),
(18, 'category', 'show', 'course_categories', 'name', 'moodle'),
(19, 'category', 'update', 'course_categories', 'name', 'moodle'),
(20, 'message', 'write', 'user', 'CONCAT(firstname, '' '', lastname)', 'moodle'),
(21, 'message', 'read', 'user', 'CONCAT(firstname, '' '', lastname)', 'moodle'),
(22, 'message', 'add contact', 'user', 'CONCAT(firstname, '' '', lastname)', 'moodle'),
(23, 'message', 'remove contact', 'user', 'CONCAT(firstname, '' '', lastname)', 'moodle'),
(24, 'message', 'block contact', 'user', 'CONCAT(firstname, '' '', lastname)', 'moodle'),
(25, 'message', 'unblock contact', 'user', 'CONCAT(firstname, '' '', lastname)', 'moodle'),
(26, 'group', 'view', 'groups', 'name', 'moodle'),
(27, 'tag', 'update', 'tag', 'name', 'moodle'),
(28, 'tag', 'flag', 'tag', 'name', 'moodle'),
(29, 'user', 'view', 'user', 'CONCAT(firstname, '' '', lastname)', 'moodle'),
(30, 'assign', 'add', 'assign', 'name', 'mod_assign'),
(31, 'assign', 'delete mod', 'assign', 'name', 'mod_assign'),
(32, 'assign', 'download all submissions', 'assign', 'name', 'mod_assign'),
(33, 'assign', 'grade submission', 'assign', 'name', 'mod_assign'),
(34, 'assign', 'lock submission', 'assign', 'name', 'mod_assign'),
(35, 'assign', 'reveal identities', 'assign', 'name', 'mod_assign'),
(36, 'assign', 'revert submission to draft', 'assign', 'name', 'mod_assign'),
(37, 'assign', 'set marking workflow state', 'assign', 'name', 'mod_assign'),
(38, 'assign', 'submission statement accepted', 'assign', 'name', 'mod_assign'),
(39, 'assign', 'submit', 'assign', 'name', 'mod_assign'),
(40, 'assign', 'submit for grading', 'assign', 'name', 'mod_assign'),
(41, 'assign', 'unlock submission', 'assign', 'name', 'mod_assign'),
(42, 'assign', 'update', 'assign', 'name', 'mod_assign'),
(43, 'assign', 'upload', 'assign', 'name', 'mod_assign'),
(44, 'assign', 'view', 'assign', 'name', 'mod_assign'),
(45, 'assign', 'view all', 'course', 'fullname', 'mod_assign'),
(46, 'assign', 'view confirm submit assignment form', 'assign', 'name', 'mod_assign'),
(47, 'assign', 'view grading form', 'assign', 'name', 'mod_assign'),
(48, 'assign', 'view submission', 'assign', 'name', 'mod_assign'),
(49, 'assign', 'view submission grading table', 'assign', 'name', 'mod_assign'),
(50, 'assign', 'view submit assignment form', 'assign', 'name', 'mod_assign'),
(51, 'assign', 'view feedback', 'assign', 'name', 'mod_assign'),
(52, 'assign', 'view batch set marking workflow state', 'assign', 'name', 'mod_assign'),
(53, 'bigbluebuttonbn', 'add', 'bigbluebuttonbn', 'name', 'mod_bigbluebuttonbn'),
(54, 'bigbluebuttonbn', 'update', 'bigbluebuttonbn', 'name', 'mod_bigbluebuttonbn'),
(55, 'bigbluebuttonbn', 'view', 'bigbluebuttonbn', 'name', 'mod_bigbluebuttonbn'),
(56, 'bigbluebuttonbn', 'view all', 'bigbluebuttonbn', 'name', 'mod_bigbluebuttonbn'),
(57, 'bigbluebuttonbn', 'create', 'bigbluebuttonbn', 'name', 'mod_bigbluebuttonbn'),
(58, 'bigbluebuttonbn', 'end', 'bigbluebuttonbn', 'name', 'mod_bigbluebuttonbn'),
(59, 'bigbluebuttonbn', 'join', 'bigbluebuttonbn', 'name', 'mod_bigbluebuttonbn'),
(60, 'bigbluebuttonbn', 'left', 'bigbluebuttonbn', 'name', 'mod_bigbluebuttonbn'),
(61, 'bigbluebuttonbn', 'publish', 'bigbluebuttonbn', 'name', 'mod_bigbluebuttonbn'),
(62, 'bigbluebuttonbn', 'unpublish', 'bigbluebuttonbn', 'name', 'mod_bigbluebuttonbn'),
(63, 'bigbluebuttonbn', 'delete', 'bigbluebuttonbn', 'name', 'mod_bigbluebuttonbn'),
(64, 'book', 'add', 'book', 'name', 'mod_book'),
(65, 'book', 'update', 'book', 'name', 'mod_book'),
(66, 'book', 'view', 'book', 'name', 'mod_book'),
(67, 'book', 'add chapter', 'book_chapters', 'title', 'mod_book'),
(68, 'book', 'update chapter', 'book_chapters', 'title', 'mod_book'),
(69, 'book', 'view chapter', 'book_chapters', 'title', 'mod_book'),
(70, 'choice', 'view', 'choice', 'name', 'mod_choice'),
(71, 'choice', 'update', 'choice', 'name', 'mod_choice'),
(72, 'choice', 'add', 'choice', 'name', 'mod_choice'),
(73, 'choice', 'report', 'choice', 'name', 'mod_choice'),
(74, 'choice', 'choose', 'choice', 'name', 'mod_choice'),
(75, 'choice', 'choose again', 'choice', 'name', 'mod_choice'),
(76, 'data', 'view', 'data', 'name', 'mod_data'),
(77, 'data', 'add', 'data', 'name', 'mod_data'),
(78, 'data', 'update', 'data', 'name', 'mod_data'),
(79, 'data', 'record delete', 'data', 'name', 'mod_data'),
(80, 'data', 'fields add', 'data_fields', 'name', 'mod_data'),
(81, 'data', 'fields update', 'data_fields', 'name', 'mod_data'),
(82, 'data', 'templates saved', 'data', 'name', 'mod_data'),
(83, 'data', 'templates def', 'data', 'name', 'mod_data'),
(84, 'feedback', 'startcomplete', 'feedback', 'name', 'mod_feedback'),
(85, 'feedback', 'submit', 'feedback', 'name', 'mod_feedback'),
(86, 'feedback', 'delete', 'feedback', 'name', 'mod_feedback'),
(87, 'feedback', 'view', 'feedback', 'name', 'mod_feedback'),
(88, 'feedback', 'view all', 'course', 'shortname', 'mod_feedback'),
(89, 'folder', 'view', 'folder', 'name', 'mod_folder'),
(90, 'folder', 'view all', 'folder', 'name', 'mod_folder'),
(91, 'folder', 'update', 'folder', 'name', 'mod_folder'),
(92, 'folder', 'add', 'folder', 'name', 'mod_folder'),
(93, 'forum', 'add', 'forum', 'name', 'mod_forum'),
(94, 'forum', 'update', 'forum', 'name', 'mod_forum'),
(95, 'forum', 'add discussion', 'forum_discussions', 'name', 'mod_forum'),
(96, 'forum', 'add post', 'forum_posts', 'subject', 'mod_forum'),
(97, 'forum', 'update post', 'forum_posts', 'subject', 'mod_forum'),
(98, 'forum', 'user report', 'user', 'CONCAT(firstname, '' '', lastname)', 'mod_forum'),
(99, 'forum', 'move discussion', 'forum_discussions', 'name', 'mod_forum'),
(100, 'forum', 'view subscribers', 'forum', 'name', 'mod_forum'),
(101, 'forum', 'view discussion', 'forum_discussions', 'name', 'mod_forum'),
(102, 'forum', 'view forum', 'forum', 'name', 'mod_forum'),
(103, 'forum', 'subscribe', 'forum', 'name', 'mod_forum'),
(104, 'forum', 'unsubscribe', 'forum', 'name', 'mod_forum'),
(105, 'forum', 'pin discussion', 'forum_discussions', 'name', 'mod_forum'),
(106, 'forum', 'unpin discussion', 'forum_discussions', 'name', 'mod_forum'),
(107, 'glossary', 'add', 'glossary', 'name', 'mod_glossary'),
(108, 'glossary', 'update', 'glossary', 'name', 'mod_glossary'),
(109, 'glossary', 'view', 'glossary', 'name', 'mod_glossary'),
(110, 'glossary', 'view all', 'glossary', 'name', 'mod_glossary'),
(111, 'glossary', 'add entry', 'glossary', 'name', 'mod_glossary'),
(112, 'glossary', 'update entry', 'glossary', 'name', 'mod_glossary'),
(113, 'glossary', 'add category', 'glossary', 'name', 'mod_glossary'),
(114, 'glossary', 'update category', 'glossary', 'name', 'mod_glossary'),
(115, 'glossary', 'delete category', 'glossary', 'name', 'mod_glossary'),
(116, 'glossary', 'approve entry', 'glossary', 'name', 'mod_glossary'),
(117, 'glossary', 'disapprove entry', 'glossary', 'name', 'mod_glossary'),
(118, 'glossary', 'view entry', 'glossary_entries', 'concept', 'mod_glossary'),
(119, 'imscp', 'view', 'imscp', 'name', 'mod_imscp'),
(120, 'imscp', 'view all', 'imscp', 'name', 'mod_imscp'),
(121, 'imscp', 'update', 'imscp', 'name', 'mod_imscp'),
(122, 'imscp', 'add', 'imscp', 'name', 'mod_imscp'),
(123, 'label', 'add', 'label', 'name', 'mod_label'),
(124, 'label', 'update', 'label', 'name', 'mod_label'),
(125, 'lesson', 'start', 'lesson', 'name', 'mod_lesson'),
(126, 'lesson', 'end', 'lesson', 'name', 'mod_lesson'),
(127, 'lesson', 'view', 'lesson_pages', 'title', 'mod_lesson'),
(128, 'lti', 'view', 'lti', 'name', 'mod_lti'),
(129, 'lti', 'launch', 'lti', 'name', 'mod_lti'),
(130, 'lti', 'view all', 'lti', 'name', 'mod_lti'),
(131, 'page', 'view', 'page', 'name', 'mod_page'),
(132, 'page', 'view all', 'page', 'name', 'mod_page'),
(133, 'page', 'update', 'page', 'name', 'mod_page'),
(134, 'page', 'add', 'page', 'name', 'mod_page'),
(135, 'quiz', 'add', 'quiz', 'name', 'mod_quiz'),
(136, 'quiz', 'update', 'quiz', 'name', 'mod_quiz'),
(137, 'quiz', 'view', 'quiz', 'name', 'mod_quiz'),
(138, 'quiz', 'report', 'quiz', 'name', 'mod_quiz'),
(139, 'quiz', 'attempt', 'quiz', 'name', 'mod_quiz'),
(140, 'quiz', 'submit', 'quiz', 'name', 'mod_quiz'),
(141, 'quiz', 'review', 'quiz', 'name', 'mod_quiz'),
(142, 'quiz', 'editquestions', 'quiz', 'name', 'mod_quiz'),
(143, 'quiz', 'preview', 'quiz', 'name', 'mod_quiz'),
(144, 'quiz', 'start attempt', 'quiz', 'name', 'mod_quiz'),
(145, 'quiz', 'close attempt', 'quiz', 'name', 'mod_quiz'),
(146, 'quiz', 'continue attempt', 'quiz', 'name', 'mod_quiz'),
(147, 'quiz', 'edit override', 'quiz', 'name', 'mod_quiz'),
(148, 'quiz', 'delete override', 'quiz', 'name', 'mod_quiz'),
(149, 'quiz', 'view summary', 'quiz', 'name', 'mod_quiz'),
(150, 'resource', 'view', 'resource', 'name', 'mod_resource'),
(151, 'resource', 'view all', 'resource', 'name', 'mod_resource'),
(152, 'resource', 'update', 'resource', 'name', 'mod_resource'),
(153, 'resource', 'add', 'resource', 'name', 'mod_resource'),
(154, 'scorm', 'view', 'scorm', 'name', 'mod_scorm'),
(155, 'scorm', 'review', 'scorm', 'name', 'mod_scorm'),
(156, 'scorm', 'update', 'scorm', 'name', 'mod_scorm'),
(157, 'scorm', 'add', 'scorm', 'name', 'mod_scorm'),
(158, 'url', 'view', 'url', 'name', 'mod_url'),
(159, 'url', 'view all', 'url', 'name', 'mod_url'),
(160, 'url', 'update', 'url', 'name', 'mod_url'),
(161, 'url', 'add', 'url', 'name', 'mod_url'),
(162, 'workshop', 'add', 'workshop', 'name', 'mod_workshop'),
(163, 'workshop', 'update', 'workshop', 'name', 'mod_workshop'),
(164, 'workshop', 'view', 'workshop', 'name', 'mod_workshop'),
(165, 'workshop', 'view all', 'workshop', 'name', 'mod_workshop'),
(166, 'workshop', 'add submission', 'workshop_submissions', 'title', 'mod_workshop'),
(167, 'workshop', 'update submission', 'workshop_submissions', 'title', 'mod_workshop'),
(168, 'workshop', 'view submission', 'workshop_submissions', 'title', 'mod_workshop'),
(169, 'workshop', 'add assessment', 'workshop_submissions', 'title', 'mod_workshop'),
(170, 'workshop', 'update assessment', 'workshop_submissions', 'title', 'mod_workshop'),
(171, 'workshop', 'add example', 'workshop_submissions', 'title', 'mod_workshop'),
(172, 'workshop', 'update example', 'workshop_submissions', 'title', 'mod_workshop'),
(173, 'workshop', 'view example', 'workshop_submissions', 'title', 'mod_workshop'),
(174, 'workshop', 'add reference assessment', 'workshop_submissions', 'title', 'mod_workshop'),
(175, 'workshop', 'update reference assessment', 'workshop_submissions', 'title', 'mod_workshop'),
(176, 'workshop', 'add example assessment', 'workshop_submissions', 'title', 'mod_workshop'),
(177, 'workshop', 'update example assessment', 'workshop_submissions', 'title', 'mod_workshop'),
(178, 'workshop', 'update aggregate grades', 'workshop', 'name', 'mod_workshop'),
(179, 'workshop', 'update clear aggregated grades', 'workshop', 'name', 'mod_workshop'),
(180, 'workshop', 'update clear assessments', 'workshop', 'name', 'mod_workshop'),
(181, 'book', 'exportimscp', 'book', 'name', 'booktool_exportimscp'),
(182, 'book', 'print', 'book', 'name', 'booktool_print'),
(183, 'book', 'print chapter', 'book_chapters', 'title', 'booktool_print');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]log_queries`
--

CREATE TABLE `[[dbprefix]]log_queries` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `qtype` mediumint NOT NULL,
  `sqltext` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `sqlparams` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `error` mediumint NOT NULL DEFAULT '0',
  `info` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `backtrace` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `exectime` decimal(10,5) NOT NULL,
  `timelogged` bigint NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Logged database queries.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lti`
--

CREATE TABLE `[[dbprefix]]lti` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `course` bigint NOT NULL DEFAULT '0',
  `name` varchar(1333) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `intro` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `introformat` smallint DEFAULT '0',
  `timecreated` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  `typeid` bigint DEFAULT NULL,
  `toolurl` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `securetoolurl` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `instructorchoicesendname` tinyint(1) DEFAULT NULL,
  `instructorchoicesendemailaddr` tinyint(1) DEFAULT NULL,
  `instructorchoiceallowroster` tinyint(1) DEFAULT NULL,
  `instructorchoiceallowsetting` tinyint(1) DEFAULT NULL,
  `instructorcustomparameters` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `instructorchoiceacceptgrades` tinyint(1) DEFAULT NULL,
  `grade` bigint NOT NULL DEFAULT '100',
  `launchcontainer` tinyint NOT NULL DEFAULT '1',
  `resourcekey` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `password` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `debuglaunch` tinyint(1) NOT NULL DEFAULT '0',
  `showtitlelaunch` tinyint(1) NOT NULL DEFAULT '0',
  `showdescriptionlaunch` tinyint(1) NOT NULL DEFAULT '0',
  `servicesalt` varchar(40) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `icon` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `secureicon` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]lti_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='This table contains Basic LTI activities instances';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]ltiservice_gradebookservices`
--

CREATE TABLE `[[dbprefix]]ltiservice_gradebookservices` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `gradeitemid` bigint NOT NULL,
  `courseid` bigint NOT NULL,
  `toolproxyid` bigint DEFAULT NULL,
  `typeid` bigint DEFAULT NULL,
  `baseurl` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `ltilinkid` bigint DEFAULT NULL,
  `resourceid` varchar(512) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `tag` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `subreviewurl` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `subreviewparams` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]ltisgrad_lti_ix` (`ltilinkid`),
  KEY `[[dbprefix]]ltisgrad_gracou_ix` (`gradeitemid`,`courseid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='This file records the grade items created by the LTI Gradebo';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lti_access_tokens`
--

CREATE TABLE `[[dbprefix]]lti_access_tokens` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `typeid` bigint NOT NULL,
  `scope` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `token` varchar(128) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `validuntil` bigint NOT NULL,
  `timecreated` bigint NOT NULL,
  `lastaccess` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]ltiaccetoke_tok_uix` (`token`),
  KEY `[[dbprefix]]ltiaccetoke_typ_ix` (`typeid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Security tokens for accessing of LTI services';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lti_coursevisible`
--

CREATE TABLE `[[dbprefix]]lti_coursevisible` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `typeid` bigint NOT NULL,
  `courseid` bigint NOT NULL,
  `coursevisible` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]lticour_cou_ix` (`courseid`),
  KEY `[[dbprefix]]lticour_typ_ix` (`typeid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Table to store coursevisible setting for site tool on course';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lti_submission`
--

CREATE TABLE `[[dbprefix]]lti_submission` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `ltiid` bigint NOT NULL,
  `userid` bigint NOT NULL,
  `datesubmitted` bigint NOT NULL,
  `dateupdated` bigint NOT NULL,
  `gradepercent` decimal(10,5) NOT NULL,
  `originalgrade` decimal(10,5) NOT NULL,
  `launchid` bigint NOT NULL,
  `state` tinyint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]ltisubm_lti_ix` (`ltiid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Keeps track of individual submissions for LTI activities.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lti_tool_proxies`
--

CREATE TABLE `[[dbprefix]]lti_tool_proxies` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT 'Tool Provider',
  `regurl` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `state` tinyint NOT NULL DEFAULT '1',
  `guid` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `secret` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `vendorcode` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `capabilityoffered` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `serviceoffered` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `toolproxy` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `createdby` bigint NOT NULL,
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]ltitoolprox_gui_uix` (`guid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='LTI tool proxy registrations' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lti_tool_settings`
--

CREATE TABLE `[[dbprefix]]lti_tool_settings` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `toolproxyid` bigint NOT NULL,
  `typeid` bigint DEFAULT NULL,
  `course` bigint DEFAULT NULL,
  `coursemoduleid` bigint DEFAULT NULL,
  `settings` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]ltitoolsett_too_ix` (`toolproxyid`),
  KEY `[[dbprefix]]ltitoolsett_typ_ix` (`typeid`),
  KEY `[[dbprefix]]ltitoolsett_cou_ix` (`course`),
  KEY `[[dbprefix]]ltitoolsett_cou2_ix` (`coursemoduleid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='LTI tool setting values';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lti_types`
--

CREATE TABLE `[[dbprefix]]lti_types` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT 'basiclti Activity',
  `baseurl` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `tooldomain` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `state` tinyint NOT NULL DEFAULT '2',
  `course` bigint NOT NULL,
  `coursevisible` tinyint(1) NOT NULL DEFAULT '0',
  `ltiversion` varchar(10) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `clientid` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `toolproxyid` bigint DEFAULT NULL,
  `enabledcapability` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `parameter` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `icon` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `secureicon` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `createdby` bigint NOT NULL,
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  `description` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]ltitype_cli_uix` (`clientid`),
  KEY `[[dbprefix]]ltitype_cou_ix` (`course`),
  KEY `[[dbprefix]]ltitype_too_ix` (`tooldomain`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Basic LTI pre-configured activities' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lti_types_categories`
--

CREATE TABLE `[[dbprefix]]lti_types_categories` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `typeid` bigint NOT NULL,
  `categoryid` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]ltitypecate_typ_ix` (`typeid`),
  KEY `[[dbprefix]]ltitypecate_cat_ix` (`categoryid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Link LTI types to course categories';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lti_types_config`
--

CREATE TABLE `[[dbprefix]]lti_types_config` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `typeid` bigint NOT NULL,
  `name` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `value` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]ltitypeconf_typ_ix` (`typeid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Basic LTI types configuration';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]matrix_room`
--

CREATE TABLE `[[dbprefix]]matrix_room` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `commid` bigint NOT NULL,
  `roomid` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `topic` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]matrroom_com_ix` (`commid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores the matrix room information associated with the commu';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]message`
--

CREATE TABLE `[[dbprefix]]message` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `useridfrom` bigint NOT NULL DEFAULT '0',
  `useridto` bigint NOT NULL DEFAULT '0',
  `subject` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `fullmessage` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `fullmessageformat` smallint DEFAULT '0',
  `fullmessagehtml` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `smallmessage` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `notification` tinyint(1) DEFAULT '0',
  `contexturl` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `contexturlname` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `timecreated` bigint NOT NULL DEFAULT '0',
  `timeuserfromdeleted` bigint NOT NULL DEFAULT '0',
  `timeusertodeleted` bigint NOT NULL DEFAULT '0',
  `component` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `eventtype` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `customdata` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]mess_useusetimtim_ix` (`useridfrom`,`useridto`,`timeuserfromdeleted`,`timeusertodeleted`),
  KEY `[[dbprefix]]mess_usetimnot_ix` (`useridfrom`,`timeuserfromdeleted`,`notification`),
  KEY `[[dbprefix]]mess_usetimnot2_ix` (`useridto`,`timeusertodeleted`,`notification`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores all unread messages' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]messageinbound_datakeys`
--

CREATE TABLE `[[dbprefix]]messageinbound_datakeys` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `handler` bigint NOT NULL,
  `datavalue` bigint NOT NULL,
  `datakey` varchar(64) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `timecreated` bigint NOT NULL,
  `expires` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]messdata_handat_uix` (`handler`,`datavalue`),
  KEY `[[dbprefix]]messdata_han_ix` (`handler`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Inbound Message data item secret keys.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]messageinbound_handlers`
--

CREATE TABLE `[[dbprefix]]messageinbound_handlers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `component` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `classname` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `defaultexpiration` bigint NOT NULL DEFAULT '86400',
  `validateaddress` tinyint(1) NOT NULL DEFAULT '1',
  `enabled` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]messhand_cla_uix` (`classname`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Inbound Message Handler definitions.' AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]messageinbound_handlers`
--

INSERT INTO `[[dbprefix]]messageinbound_handlers` VALUES
(1, 'core', '\\core\\message\\inbound\\private_files_handler', 0, 1, 0),
(2, 'mod_forum', '\\mod_forum\\message\\inbound\\reply_handler', 604800, 1, 0),
(3, 'tool_messageinbound', '\\tool_messageinbound\\message\\inbound\\invalid_recipient_handler', 604800, 0, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]messageinbound_messagelist`
--

CREATE TABLE `[[dbprefix]]messageinbound_messagelist` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `messageid` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `userid` bigint NOT NULL,
  `address` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `timecreated` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]messmess_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='A list of message IDs for existing replies';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]messages`
--

CREATE TABLE `[[dbprefix]]messages` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `useridfrom` bigint NOT NULL,
  `conversationid` bigint NOT NULL,
  `subject` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `fullmessage` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `fullmessageformat` tinyint(1) NOT NULL DEFAULT '0',
  `fullmessagehtml` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `smallmessage` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `timecreated` bigint NOT NULL,
  `fullmessagetrust` tinyint NOT NULL DEFAULT '0',
  `customdata` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]mess_contim_ix` (`conversationid`,`timecreated`),
  KEY `[[dbprefix]]mess_use_ix` (`useridfrom`),
  KEY `[[dbprefix]]mess_con_ix` (`conversationid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores all messages' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]message_airnotifier_devices`
--

CREATE TABLE `[[dbprefix]]message_airnotifier_devices` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `userdeviceid` bigint NOT NULL,
  `enable` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]messairndevi_use_uix` (`userdeviceid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Store information about the devices registered in Airnotifie';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]message_contacts`
--

CREATE TABLE `[[dbprefix]]message_contacts` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `userid` bigint NOT NULL,
  `contactid` bigint NOT NULL,
  `timecreated` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]messcont_usecon_uix` (`userid`,`contactid`),
  KEY `[[dbprefix]]messcont_use_ix` (`userid`),
  KEY `[[dbprefix]]messcont_con_ix` (`contactid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Maintains lists of contacts between users' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]message_contact_requests`
--

CREATE TABLE `[[dbprefix]]message_contact_requests` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `userid` bigint NOT NULL,
  `requesteduserid` bigint NOT NULL,
  `timecreated` bigint NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]messcontrequ_usereq_uix` (`userid`,`requesteduserid`),
  KEY `[[dbprefix]]messcontrequ_use_ix` (`userid`),
  KEY `[[dbprefix]]messcontrequ_req_ix` (`requesteduserid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Maintains list of contact requests between users' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]message_conversations`
--

CREATE TABLE `[[dbprefix]]message_conversations` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `type` bigint NOT NULL DEFAULT '1',
  `name` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `convhash` varchar(40) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `component` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `itemtype` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `itemid` bigint DEFAULT NULL,
  `contextid` bigint DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT '0',
  `timecreated` bigint NOT NULL,
  `timemodified` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]messconv_typ_ix` (`type`),
  KEY `[[dbprefix]]messconv_con_ix` (`convhash`),
  KEY `[[dbprefix]]messconv_comiteitecon_ix` (`component`,`itemtype`,`itemid`,`contextid`),
  KEY `[[dbprefix]]messconv_con2_ix` (`contextid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores all message conversations' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]message_conversation_actions`
--

CREATE TABLE `[[dbprefix]]message_conversation_actions` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `userid` bigint NOT NULL,
  `conversationid` bigint NOT NULL,
  `action` bigint NOT NULL,
  `timecreated` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]messconvacti_use_ix` (`userid`),
  KEY `[[dbprefix]]messconvacti_con_ix` (`conversationid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores all per-user actions on individual conversations';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]message_conversation_members`
--

CREATE TABLE `[[dbprefix]]message_conversation_members` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `conversationid` bigint NOT NULL,
  `userid` bigint NOT NULL,
  `timecreated` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]messconvmemb_con_ix` (`conversationid`),
  KEY `[[dbprefix]]messconvmemb_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores all members in a conversations' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]message_email_messages`
--

CREATE TABLE `[[dbprefix]]message_email_messages` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `useridto` bigint NOT NULL,
  `conversationid` bigint NOT NULL,
  `messageid` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]messemaimess_use_ix` (`useridto`),
  KEY `[[dbprefix]]messemaimess_con_ix` (`conversationid`),
  KEY `[[dbprefix]]messemaimess_mes_ix` (`messageid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Keeps track of what emails to send in an email digest';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]message_popup`
--

CREATE TABLE `[[dbprefix]]message_popup` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `messageid` bigint NOT NULL,
  `isread` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]messpopu_mesisr_uix` (`messageid`,`isread`),
  KEY `[[dbprefix]]messpopu_isr_ix` (`isread`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Keep state of notifications for the popup message processor';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]message_popup_notifications`
--

CREATE TABLE `[[dbprefix]]message_popup_notifications` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `notificationid` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]messpopunoti_not_ix` (`notificationid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='List of notifications to display in the message output popup' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]message_processors`
--

CREATE TABLE `[[dbprefix]]message_processors` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(166) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `enabled` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='List of message output plugins' AUTO_INCREMENT=5 ;

--
-- Dumping data for table `[[dbprefix]]message_processors`
--

INSERT INTO `[[dbprefix]]message_processors` VALUES
(1, 'airnotifier', 1),
(2, 'email', 1),
(3, 'popup', 1),
(4, 'sms', 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]message_providers`
--

CREATE TABLE `[[dbprefix]]message_providers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `component` varchar(200) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `capability` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]messprov_comnam_uix` (`component`,`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='This table stores the message providers (modules and core sy' AUTO_INCREMENT=52 ;

--
-- Dumping data for table `[[dbprefix]]message_providers`
--

INSERT INTO `[[dbprefix]]message_providers` VALUES
(1, 'newlogin', 'moodle', NULL),
(2, 'notices', 'moodle', 'moodle/site:config'),
(3, 'errors', 'moodle', 'moodle/site:config'),
(4, 'availableupdate', 'moodle', 'moodle/site:config'),
(5, 'instantmessage', 'moodle', NULL),
(6, 'backup', 'moodle', 'moodle/site:config'),
(7, 'courserequested', 'moodle', 'moodle/site:approvecourse'),
(8, 'courserequestapproved', 'moodle', 'moodle/course:request'),
(9, 'courserequestrejected', 'moodle', 'moodle/course:request'),
(10, 'coursecompleted', 'moodle', NULL),
(11, 'coursecontentupdated', 'moodle', NULL),
(12, 'badgerecipientnotice', 'moodle', 'moodle/badges:earnbadge'),
(13, 'badgecreatornotice', 'moodle', NULL),
(14, 'competencyplancomment', 'moodle', NULL),
(15, 'competencyusercompcomment', 'moodle', NULL),
(16, 'insights', 'moodle', NULL),
(17, 'messagecontactrequests', 'moodle', NULL),
(18, 'asyncbackupnotification', 'moodle', NULL),
(19, 'gradenotifications', 'moodle', NULL),
(20, 'infected', 'moodle', 'moodle/site:config'),
(21, 'reportbuilderschedule', 'moodle', NULL),
(22, 'failedtaskmaxdelay', 'moodle', 'moodle/site:config'),
(23, 'enrolcoursewelcomemessage', 'moodle', NULL),
(24, 'assign_notification', 'mod_assign', NULL),
(25, 'assign_due_soon', 'mod_assign', NULL),
(26, 'assign_overdue', 'mod_assign', NULL),
(27, 'assign_due_digest', 'mod_assign', NULL),
(28, 'recording_ready', 'mod_bigbluebuttonbn', NULL),
(29, 'instance_updated', 'mod_bigbluebuttonbn', NULL),
(30, 'submission', 'mod_feedback', NULL),
(31, 'message', 'mod_feedback', NULL),
(32, 'posts', 'mod_forum', NULL),
(33, 'digests', 'mod_forum', NULL),
(34, 'graded_essay', 'mod_lesson', NULL),
(35, 'submission', 'mod_quiz', 'mod/quiz:emailnotifysubmission'),
(36, 'confirmation', 'mod_quiz', 'mod/quiz:emailconfirmsubmission'),
(37, 'attempt_overdue', 'mod_quiz', 'mod/quiz:emailwarnoverdue'),
(38, 'attempt_grading_complete', 'mod_quiz', 'mod/quiz:emailnotifyattemptgraded'),
(39, 'quiz_open_soon', 'mod_quiz', NULL),
(40, 'flatfile_enrolment', 'enrol_flatfile', NULL),
(41, 'imsenterprise_enrolment', 'enrol_imsenterprise', NULL),
(42, 'expiry_notification', 'enrol_manual', NULL),
(43, 'paypal_enrolment', 'enrol_paypal', NULL),
(44, 'expiry_notification', 'enrol_self', NULL),
(45, 'contactdataprotectionofficer', 'tool_dataprivacy', 'tool/dataprivacy:managedatarequests'),
(46, 'datarequestprocessingresults', 'tool_dataprivacy', NULL),
(47, 'notifyexceptions', 'tool_dataprivacy', 'tool/dataprivacy:managedatarequests'),
(48, 'invalidrecipienthandler', 'tool_messageinbound', NULL),
(49, 'messageprocessingerror', 'tool_messageinbound', NULL),
(50, 'messageprocessingsuccess', 'tool_messageinbound', NULL),
(51, 'notification', 'tool_monitor', 'tool/monitor:subscribe');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]message_read`
--

CREATE TABLE `[[dbprefix]]message_read` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `useridfrom` bigint NOT NULL DEFAULT '0',
  `useridto` bigint NOT NULL DEFAULT '0',
  `subject` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `fullmessage` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `fullmessageformat` smallint DEFAULT '0',
  `fullmessagehtml` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `smallmessage` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `notification` tinyint(1) DEFAULT '0',
  `contexturl` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `contexturlname` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `timecreated` bigint NOT NULL DEFAULT '0',
  `timeread` bigint NOT NULL DEFAULT '0',
  `timeuserfromdeleted` bigint NOT NULL DEFAULT '0',
  `timeusertodeleted` bigint NOT NULL DEFAULT '0',
  `component` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `eventtype` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]messread_useusetimtim_ix` (`useridfrom`,`useridto`,`timeuserfromdeleted`,`timeusertodeleted`),
  KEY `[[dbprefix]]messread_nottim_ix` (`notification`,`timeread`),
  KEY `[[dbprefix]]messread_usetimnot_ix` (`useridfrom`,`timeuserfromdeleted`,`notification`),
  KEY `[[dbprefix]]messread_usetimnot2_ix` (`useridto`,`timeusertodeleted`,`notification`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores all messages that have been read' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]message_users_blocked`
--

CREATE TABLE `[[dbprefix]]message_users_blocked` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `userid` bigint NOT NULL,
  `blockeduserid` bigint NOT NULL,
  `timecreated` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]messuserbloc_useblo_uix` (`userid`,`blockeduserid`),
  KEY `[[dbprefix]]messuserbloc_use_ix` (`userid`),
  KEY `[[dbprefix]]messuserbloc_blo_ix` (`blockeduserid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Maintains lists of blocked users' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]message_user_actions`
--

CREATE TABLE `[[dbprefix]]message_user_actions` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `userid` bigint NOT NULL,
  `messageid` bigint NOT NULL,
  `action` bigint NOT NULL,
  `timecreated` bigint NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]messuseracti_usemesa_uix` (`userid`,`messageid`,`action`),
  KEY `[[dbprefix]]messuseracti_use_ix` (`userid`),
  KEY `[[dbprefix]]messuseracti_mes_ix` (`messageid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores all per-user actions on individual messages' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mnet_application`
--

CREATE TABLE `[[dbprefix]]mnet_application` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(50) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `display_name` varchar(50) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `xmlrpc_server_url` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `sso_land_url` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `sso_jump_url` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Information about applications on remote hosts' AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]mnet_application`
--

INSERT INTO `[[dbprefix]]mnet_application` VALUES
(1, 'moodle', 'Moodle', '/mnet/xmlrpc/server.php', '/auth/mnet/land.php', '/auth/mnet/jump.php'),
(2, 'mahara', 'Mahara', '/api/xmlrpc/server.php', '/auth/xmlrpc/land.php', '/auth/xmlrpc/jump.php');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mnet_host`
--

CREATE TABLE `[[dbprefix]]mnet_host` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `deleted` tinyint(1) NOT NULL DEFAULT '0',
  `wwwroot` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `ip_address` varchar(45) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `name` varchar(80) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `public_key` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `public_key_expires` bigint NOT NULL DEFAULT '0',
  `transport` tinyint NOT NULL DEFAULT '0',
  `portno` mediumint NOT NULL DEFAULT '0',
  `last_connect_time` bigint NOT NULL DEFAULT '0',
  `last_log_id` bigint NOT NULL DEFAULT '0',
  `force_theme` tinyint(1) NOT NULL DEFAULT '0',
  `theme` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `applicationid` bigint NOT NULL DEFAULT '1',
  `sslverification` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]mnethost_las_ix` (`last_log_id`),
  KEY `[[dbprefix]]mnethost_app_ix` (`applicationid`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Information about the local and remote hosts for RPC' AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]mnet_host`
--

INSERT INTO `[[dbprefix]]mnet_host` VALUES
(1, 0, '[[softurl]]', '[[serverip]]', '', '', 0, 0, 0, 0, 0, 0, NULL, 1, 0),
(2, 0, '', '', 'All Hosts', '', 0, 0, 0, 0, 0, 0, NULL, 1, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mnet_host2service`
--

CREATE TABLE `[[dbprefix]]mnet_host2service` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `hostid` bigint NOT NULL DEFAULT '0',
  `serviceid` bigint NOT NULL DEFAULT '0',
  `publish` tinyint(1) NOT NULL DEFAULT '0',
  `subscribe` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]mnethost_hosser_uix` (`hostid`,`serviceid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Information about the services for a given host';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mnet_log`
--

CREATE TABLE `[[dbprefix]]mnet_log` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `hostid` bigint NOT NULL DEFAULT '0',
  `remoteid` bigint NOT NULL DEFAULT '0',
  `time` bigint NOT NULL DEFAULT '0',
  `userid` bigint NOT NULL DEFAULT '0',
  `ip` varchar(45) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `course` bigint NOT NULL DEFAULT '0',
  `coursename` varchar(40) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `module` varchar(20) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `cmid` bigint NOT NULL DEFAULT '0',
  `action` varchar(40) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `url` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `info` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]mnetlog_hosusecou_ix` (`hostid`,`userid`,`course`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Store session data from users migrating to other sites';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mnet_remote_rpc`
--

CREATE TABLE `[[dbprefix]]mnet_remote_rpc` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `functionname` varchar(40) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `xmlrpcpath` varchar(80) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `plugintype` varchar(20) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `pluginname` varchar(20) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `enabled` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='This table describes functions that might be called remotely' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mnet_remote_service2rpc`
--

CREATE TABLE `[[dbprefix]]mnet_remote_service2rpc` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `serviceid` bigint NOT NULL DEFAULT '0',
  `rpcid` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]mnetremoserv_rpcser_uix` (`rpcid`,`serviceid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Group functions or methods under a service';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mnet_rpc`
--

CREATE TABLE `[[dbprefix]]mnet_rpc` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `functionname` varchar(40) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `xmlrpcpath` varchar(80) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `plugintype` varchar(20) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `pluginname` varchar(20) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `enabled` tinyint(1) NOT NULL DEFAULT '0',
  `help` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `profile` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `filename` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `classname` varchar(150) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `static` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]mnetrpc_enaxml_ix` (`enabled`,`xmlrpcpath`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Functions or methods that we may publish or subscribe to' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mnet_service`
--

CREATE TABLE `[[dbprefix]]mnet_service` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(40) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `description` varchar(40) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `apiversion` varchar(10) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `offer` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='A service is a group of functions';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mnet_service2rpc`
--

CREATE TABLE `[[dbprefix]]mnet_service2rpc` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `serviceid` bigint NOT NULL DEFAULT '0',
  `rpcid` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]mnetserv_rpcser_uix` (`rpcid`,`serviceid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Group functions or methods under a service';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mnet_session`
--

CREATE TABLE `[[dbprefix]]mnet_session` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `userid` bigint NOT NULL DEFAULT '0',
  `username` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `token` varchar(40) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `mnethostid` bigint NOT NULL DEFAULT '0',
  `useragent` varchar(40) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `confirm_timeout` bigint NOT NULL DEFAULT '0',
  `session_id` varchar(40) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `expires` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]mnetsess_tok_uix` (`token`),
  KEY `[[dbprefix]]mnetsess_use_ix` (`userid`),
  KEY `[[dbprefix]]mnetsess_mne_ix` (`mnethostid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Store session data from users migrating to other sites';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mnet_sso_access_control`
--

CREATE TABLE `[[dbprefix]]mnet_sso_access_control` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `username` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `mnet_host_id` bigint NOT NULL DEFAULT '0',
  `accessctrl` varchar(20) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT 'allow',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]mnetssoaccecont_mneu_uix` (`mnet_host_id`,`username`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Users by host permitted (or not) to login from a remote prov';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]modules`
--

CREATE TABLE `[[dbprefix]]modules` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(20) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `cron` bigint NOT NULL DEFAULT '0',
  `lastcron` bigint NOT NULL DEFAULT '0',
  `search` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `visible` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]modu_nam_ix` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='modules available in the site' AUTO_INCREMENT=24 ;

--
-- Dumping data for table `[[dbprefix]]modules`
--

INSERT INTO `[[dbprefix]]modules` VALUES
(1, 'assign', 0, 0, '', 1),
(2, 'bigbluebuttonbn', 0, 0, '', 0),
(3, 'book', 0, 0, '', 1),
(4, 'choice', 0, 0, '', 1),
(5, 'data', 0, 0, '', 1),
(6, 'feedback', 0, 0, '', 1),
(7, 'folder', 0, 0, '', 1),
(8, 'forum', 0, 0, '', 1),
(9, 'glossary', 0, 0, '', 1),
(10, 'h5pactivity', 0, 0, '', 1),
(11, 'imscp', 0, 0, '', 1),
(12, 'label', 0, 0, '', 1),
(13, 'lesson', 0, 0, '', 1),
(14, 'lti', 0, 0, '', 1),
(15, 'page', 0, 0, '', 1),
(16, 'qbank', 0, 0, '', 1),
(17, 'quiz', 0, 0, '', 1),
(18, 'resource', 0, 0, '', 1),
(19, 'scorm', 0, 0, '', 1),
(20, 'subsection', 0, 0, '', 1),
(21, 'url', 0, 0, '', 1),
(22, 'wiki', 0, 0, '', 1),
(23, 'workshop', 0, 0, '', 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]moodlenet_share_progress`
--

CREATE TABLE `[[dbprefix]]moodlenet_share_progress` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `type` tinyint NOT NULL,
  `courseid` bigint NOT NULL,
  `cmid` bigint DEFAULT NULL,
  `userid` bigint NOT NULL,
  `timecreated` bigint NOT NULL,
  `resourceurl` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `status` tinyint DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Records MoodleNet share progress';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]my_pages`
--

CREATE TABLE `[[dbprefix]]my_pages` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `userid` bigint DEFAULT '0',
  `name` varchar(200) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `private` tinyint(1) NOT NULL DEFAULT '1',
  `sortorder` mediumint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]mypage_usepri_ix` (`userid`,`private`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Extra user pages for the My Moodle system' AUTO_INCREMENT=5 ;

--
-- Dumping data for table `[[dbprefix]]my_pages`
--

INSERT INTO `[[dbprefix]]my_pages` VALUES
(1, NULL, '__default', 0, 0),
(2, NULL, '__default', 1, 0),
(3, NULL, '__courses', 0, 0),
(4, 2, '__default', 1, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]notifications`
--

CREATE TABLE `[[dbprefix]]notifications` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `useridfrom` bigint NOT NULL,
  `useridto` bigint NOT NULL,
  `subject` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `fullmessage` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `fullmessageformat` tinyint(1) NOT NULL DEFAULT '0',
  `fullmessagehtml` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `smallmessage` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `component` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `eventtype` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `contexturl` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `contexturlname` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `timeread` bigint DEFAULT NULL,
  `timecreated` bigint NOT NULL,
  `customdata` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]noti_use_ix` (`useridfrom`),
  KEY `[[dbprefix]]noti_tim_ix` (`timecreated`),
  KEY `[[dbprefix]]noti_tim2_ix` (`timeread`),
  KEY `[[dbprefix]]noti_use2_ix` (`useridto`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores all notifications' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]oauth2_access_token`
--

CREATE TABLE `[[dbprefix]]oauth2_access_token` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  `usermodified` bigint NOT NULL,
  `issuerid` bigint NOT NULL,
  `token` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `expires` bigint NOT NULL,
  `scope` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]oautaccetoke_iss_uix` (`issuerid`),
  KEY `[[dbprefix]]oautaccetoke_use_ix` (`usermodified`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores access tokens for system accounts in order to be able';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]oauth2_endpoint`
--

CREATE TABLE `[[dbprefix]]oauth2_endpoint` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  `usermodified` bigint NOT NULL,
  `name` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `url` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `issuerid` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]oautendp_iss_ix` (`issuerid`),
  KEY `[[dbprefix]]oautendp_use_ix` (`usermodified`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Describes the named endpoint for an oauth2 service.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]oauth2_issuer`
--

CREATE TABLE `[[dbprefix]]oauth2_issuer` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  `usermodified` bigint NOT NULL,
  `name` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `image` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `baseurl` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `clientid` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `clientsecret` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `loginscopes` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `loginscopesoffline` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `loginparams` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `loginparamsoffline` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `alloweddomains` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `scopessupported` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `enabled` tinyint NOT NULL DEFAULT '1',
  `showonloginpage` tinyint NOT NULL DEFAULT '1',
  `basicauth` tinyint NOT NULL DEFAULT '0',
  `sortorder` bigint NOT NULL,
  `requireconfirmation` tinyint NOT NULL DEFAULT '1',
  `servicetype` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `loginpagename` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `systememail` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Details for an oauth 2 connect identity issuer.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]oauth2_refresh_token`
--

CREATE TABLE `[[dbprefix]]oauth2_refresh_token` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  `userid` bigint NOT NULL,
  `issuerid` bigint NOT NULL,
  `token` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `scopehash` varchar(40) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]oautrefrtoke_useisss_uix` (`userid`,`issuerid`,`scopehash`),
  KEY `[[dbprefix]]oautrefrtoke_iss_ix` (`issuerid`),
  KEY `[[dbprefix]]oautrefrtoke_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores refresh tokens which can be exchanged for access toke';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]oauth2_system_account`
--

CREATE TABLE `[[dbprefix]]oauth2_system_account` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  `usermodified` bigint NOT NULL,
  `issuerid` bigint NOT NULL,
  `refreshtoken` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `grantedscopes` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `email` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `username` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]oautsystacco_iss_uix` (`issuerid`),
  KEY `[[dbprefix]]oautsystacco_use_ix` (`usermodified`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stored details used to get an access token as a system user ';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]oauth2_user_field_mapping`
--

CREATE TABLE `[[dbprefix]]oauth2_user_field_mapping` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `timemodified` bigint NOT NULL,
  `timecreated` bigint NOT NULL,
  `usermodified` bigint NOT NULL,
  `issuerid` bigint NOT NULL,
  `externalfield` varchar(500) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `internalfield` varchar(64) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]oautuserfielmapp_iss_uix` (`issuerid`,`internalfield`),
  KEY `[[dbprefix]]oautuserfielmapp_iss_ix` (`issuerid`),
  KEY `[[dbprefix]]oautuserfielmapp_use_ix` (`usermodified`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Mapping of oauth user fields to moodle fields.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]page`
--

CREATE TABLE `[[dbprefix]]page` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `course` bigint NOT NULL DEFAULT '0',
  `name` varchar(1333) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `intro` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `introformat` smallint NOT NULL DEFAULT '0',
  `content` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `contentformat` smallint NOT NULL DEFAULT '0',
  `legacyfiles` smallint NOT NULL DEFAULT '0',
  `legacyfileslast` bigint DEFAULT NULL,
  `display` smallint NOT NULL DEFAULT '0',
  `displayoptions` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `revision` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]page_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Each record is one page and its config data';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]paygw_paypal`
--

CREATE TABLE `[[dbprefix]]paygw_paypal` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `paymentid` bigint NOT NULL,
  `pp_orderid` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT 'The ID of the order in PayPal',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]paygpayp_pay_uix` (`paymentid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores PayPal related information';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]payments`
--

CREATE TABLE `[[dbprefix]]payments` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `component` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `paymentarea` varchar(50) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `itemid` bigint NOT NULL,
  `userid` bigint NOT NULL,
  `amount` varchar(20) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `currency` varchar(3) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `accountid` bigint NOT NULL,
  `gateway` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `timecreated` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]paym_gat_ix` (`gateway`),
  KEY `[[dbprefix]]paym_compayite_ix` (`component`,`paymentarea`,`itemid`),
  KEY `[[dbprefix]]paym_use_ix` (`userid`),
  KEY `[[dbprefix]]paym_acc_ix` (`accountid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores information about payments';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]payment_accounts`
--

CREATE TABLE `[[dbprefix]]payment_accounts` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `idnumber` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `contextid` bigint NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT '0',
  `archived` tinyint(1) NOT NULL DEFAULT '0',
  `timecreated` bigint DEFAULT NULL,
  `timemodified` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]paymacco_con_ix` (`contextid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Payment accounts';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]payment_gateways`
--

CREATE TABLE `[[dbprefix]]payment_gateways` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `accountid` bigint NOT NULL,
  `gateway` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `enabled` tinyint(1) NOT NULL DEFAULT '1',
  `config` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]paymgate_acc_ix` (`accountid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Configuration for one gateway for one payment account';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]portfolio_instance`
--

CREATE TABLE `[[dbprefix]]portfolio_instance` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `plugin` varchar(50) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `name` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `visible` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='base table (not including config data) for instances of port' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]portfolio_instance_config`
--

CREATE TABLE `[[dbprefix]]portfolio_instance_config` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `instance` bigint NOT NULL,
  `name` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `value` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]portinstconf_nam_ix` (`name`),
  KEY `[[dbprefix]]portinstconf_ins_ix` (`instance`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='config for portfolio plugin instances';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]portfolio_instance_user`
--

CREATE TABLE `[[dbprefix]]portfolio_instance_user` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `instance` bigint NOT NULL,
  `userid` bigint NOT NULL,
  `name` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `value` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]portinstuser_ins_ix` (`instance`),
  KEY `[[dbprefix]]portinstuser_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='user data for portfolio instances.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]portfolio_log`
--

CREATE TABLE `[[dbprefix]]portfolio_log` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `userid` bigint NOT NULL,
  `time` bigint NOT NULL,
  `portfolio` bigint NOT NULL,
  `caller_class` varchar(150) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `caller_file` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `caller_component` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `caller_sha1` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `tempdataid` bigint NOT NULL DEFAULT '0',
  `returnurl` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `continueurl` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]portlog_use_ix` (`userid`),
  KEY `[[dbprefix]]portlog_por_ix` (`portfolio`),
  KEY `[[dbprefix]]portlog_tem_ix` (`tempdataid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='log of portfolio transfers (used to later check for duplicat';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]portfolio_tempdata`
--

CREATE TABLE `[[dbprefix]]portfolio_tempdata` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `data` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `expirytime` bigint NOT NULL,
  `userid` bigint NOT NULL,
  `instance` bigint DEFAULT '0',
  `queued` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]porttemp_use_ix` (`userid`),
  KEY `[[dbprefix]]porttemp_ins_ix` (`instance`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='stores temporary data for portfolio exports. the id of this ';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]post`
--

CREATE TABLE `[[dbprefix]]post` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `module` varchar(20) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `userid` bigint NOT NULL DEFAULT '0',
  `courseid` bigint NOT NULL DEFAULT '0',
  `groupid` bigint NOT NULL DEFAULT '0',
  `moduleid` bigint NOT NULL DEFAULT '0',
  `coursemoduleid` bigint NOT NULL DEFAULT '0',
  `subject` varchar(128) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `summary` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `content` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `uniquehash` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `rating` bigint NOT NULL DEFAULT '0',
  `format` bigint NOT NULL DEFAULT '0',
  `summaryformat` tinyint NOT NULL DEFAULT '0',
  `attachment` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `publishstate` varchar(20) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT 'draft',
  `lastmodified` bigint NOT NULL DEFAULT '0',
  `created` bigint NOT NULL DEFAULT '0',
  `usermodified` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]post_iduse_uix` (`id`,`userid`),
  KEY `[[dbprefix]]post_las_ix` (`lastmodified`),
  KEY `[[dbprefix]]post_mod_ix` (`module`),
  KEY `[[dbprefix]]post_sub_ix` (`subject`),
  KEY `[[dbprefix]]post_use_ix` (`usermodified`),
  KEY `[[dbprefix]]post_cou_ix` (`courseid`),
  KEY `[[dbprefix]]post_cou2_ix` (`coursemoduleid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Generic post table to hold data blog entries etc in differen';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]profiling`
--

CREATE TABLE `[[dbprefix]]profiling` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `runid` varchar(32) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `url` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `data` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `totalexecutiontime` bigint NOT NULL,
  `totalcputime` bigint NOT NULL,
  `totalcalls` bigint NOT NULL,
  `totalmemory` bigint NOT NULL,
  `runreference` tinyint NOT NULL DEFAULT '0',
  `runcomment` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `timecreated` bigint NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]prof_run_uix` (`runid`),
  KEY `[[dbprefix]]prof_urlrun_ix` (`url`,`runreference`),
  KEY `[[dbprefix]]prof_timrun_ix` (`timecreated`,`runreference`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores the results of all the profiling runs';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]qbank`
--

CREATE TABLE `[[dbprefix]]qbank` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `course` bigint NOT NULL,
  `name` varchar(1333) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `timecreated` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  `intro` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `introformat` smallint NOT NULL DEFAULT '0',
  `type` varchar(40) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]qban_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores the qbank activity module instances.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]qtype_ddimageortext`
--

CREATE TABLE `[[dbprefix]]qtype_ddimageortext` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `questionid` bigint NOT NULL DEFAULT '0',
  `shuffleanswers` smallint NOT NULL DEFAULT '1',
  `correctfeedback` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `correctfeedbackformat` tinyint NOT NULL DEFAULT '0',
  `partiallycorrectfeedback` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `partiallycorrectfeedbackformat` tinyint NOT NULL DEFAULT '0',
  `incorrectfeedback` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `incorrectfeedbackformat` tinyint NOT NULL DEFAULT '0',
  `shownumcorrect` tinyint NOT NULL DEFAULT '0',
  `dropzonevisibility` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]qtypddim_que_ix` (`questionid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Defines drag and drop (text or images onto a background imag';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]qtype_ddimageortext_drags`
--

CREATE TABLE `[[dbprefix]]qtype_ddimageortext_drags` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `questionid` bigint NOT NULL DEFAULT '0',
  `no` bigint NOT NULL DEFAULT '0',
  `draggroup` bigint NOT NULL DEFAULT '0',
  `infinite` smallint NOT NULL DEFAULT '0',
  `label` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]qtypddimdrag_que_ix` (`questionid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Images to drag. Actual file names are not stored here we use';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]qtype_ddimageortext_drops`
--

CREATE TABLE `[[dbprefix]]qtype_ddimageortext_drops` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `questionid` bigint NOT NULL DEFAULT '0',
  `no` bigint NOT NULL DEFAULT '0',
  `xleft` bigint NOT NULL DEFAULT '0',
  `ytop` bigint NOT NULL DEFAULT '0',
  `choice` bigint NOT NULL DEFAULT '0',
  `label` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]qtypddimdrop_que_ix` (`questionid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Drop boxes';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]qtype_ddmarker`
--

CREATE TABLE `[[dbprefix]]qtype_ddmarker` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `questionid` bigint NOT NULL DEFAULT '0',
  `shuffleanswers` smallint NOT NULL DEFAULT '1',
  `correctfeedback` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `correctfeedbackformat` tinyint NOT NULL DEFAULT '0',
  `partiallycorrectfeedback` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `partiallycorrectfeedbackformat` tinyint NOT NULL DEFAULT '0',
  `incorrectfeedback` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `incorrectfeedbackformat` tinyint NOT NULL DEFAULT '0',
  `shownumcorrect` tinyint NOT NULL DEFAULT '0',
  `showmisplaced` smallint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]qtypddma_que_ix` (`questionid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Defines drag and drop (text or images onto a background imag';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]qtype_ddmarker_drags`
--

CREATE TABLE `[[dbprefix]]qtype_ddmarker_drags` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `questionid` bigint NOT NULL DEFAULT '0',
  `no` bigint NOT NULL DEFAULT '0',
  `label` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `infinite` smallint NOT NULL DEFAULT '0',
  `noofdrags` bigint NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]qtypddmadrag_que_ix` (`questionid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Labels for markers to drag.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]qtype_ddmarker_drops`
--

CREATE TABLE `[[dbprefix]]qtype_ddmarker_drops` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `questionid` bigint NOT NULL DEFAULT '0',
  `no` bigint NOT NULL DEFAULT '0',
  `shape` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `coords` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `choice` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]qtypddmadrop_que_ix` (`questionid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='drop regions';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]qtype_essay_options`
--

CREATE TABLE `[[dbprefix]]qtype_essay_options` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `questionid` bigint NOT NULL,
  `responseformat` varchar(16) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT 'editor',
  `responserequired` tinyint NOT NULL DEFAULT '1',
  `responsefieldlines` smallint NOT NULL DEFAULT '15',
  `minwordlimit` bigint DEFAULT NULL,
  `maxwordlimit` bigint DEFAULT NULL,
  `attachments` smallint NOT NULL DEFAULT '0',
  `attachmentsrequired` smallint NOT NULL DEFAULT '0',
  `graderinfo` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `graderinfoformat` smallint NOT NULL DEFAULT '0',
  `responsetemplate` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `responsetemplateformat` smallint NOT NULL DEFAULT '0',
  `maxbytes` bigint NOT NULL DEFAULT '0',
  `filetypeslist` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]qtypessaopti_que_uix` (`questionid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Extra options for essay questions.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]qtype_match_options`
--

CREATE TABLE `[[dbprefix]]qtype_match_options` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `questionid` bigint NOT NULL DEFAULT '0',
  `shuffleanswers` smallint NOT NULL DEFAULT '1',
  `correctfeedback` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `correctfeedbackformat` tinyint NOT NULL DEFAULT '0',
  `partiallycorrectfeedback` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `partiallycorrectfeedbackformat` tinyint NOT NULL DEFAULT '0',
  `incorrectfeedback` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `incorrectfeedbackformat` tinyint NOT NULL DEFAULT '0',
  `shownumcorrect` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]qtypmatcopti_que_uix` (`questionid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Defines the question-type specific options for matching ques';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]qtype_match_subquestions`
--

CREATE TABLE `[[dbprefix]]qtype_match_subquestions` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `questionid` bigint NOT NULL DEFAULT '0',
  `questiontext` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `questiontextformat` tinyint NOT NULL DEFAULT '0',
  `answertext` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]qtypmatcsubq_que_ix` (`questionid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='The subquestions that make up a matching question';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]qtype_multichoice_options`
--

CREATE TABLE `[[dbprefix]]qtype_multichoice_options` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `questionid` bigint NOT NULL DEFAULT '0',
  `layout` smallint NOT NULL DEFAULT '0',
  `single` smallint NOT NULL DEFAULT '0',
  `shuffleanswers` smallint NOT NULL DEFAULT '1',
  `correctfeedback` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `correctfeedbackformat` tinyint NOT NULL DEFAULT '0',
  `partiallycorrectfeedback` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `partiallycorrectfeedbackformat` tinyint NOT NULL DEFAULT '0',
  `incorrectfeedback` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `incorrectfeedbackformat` tinyint NOT NULL DEFAULT '0',
  `answernumbering` varchar(10) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT 'abc',
  `shownumcorrect` tinyint NOT NULL DEFAULT '0',
  `showstandardinstruction` tinyint NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]qtypmultopti_que_uix` (`questionid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Options for multiple choice questions';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]qtype_ordering_options`
--

CREATE TABLE `[[dbprefix]]qtype_ordering_options` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `questionid` bigint NOT NULL DEFAULT '0',
  `layouttype` tinyint NOT NULL DEFAULT '0',
  `selecttype` tinyint NOT NULL DEFAULT '0',
  `selectcount` smallint NOT NULL DEFAULT '2',
  `gradingtype` tinyint NOT NULL DEFAULT '0',
  `showgrading` tinyint NOT NULL DEFAULT '0',
  `numberingstyle` varchar(10) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT 'none',
  `correctfeedback` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `correctfeedbackformat` tinyint NOT NULL DEFAULT '0',
  `incorrectfeedback` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `incorrectfeedbackformat` tinyint NOT NULL DEFAULT '0',
  `partiallycorrectfeedback` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `partiallycorrectfeedbackformat` tinyint NOT NULL DEFAULT '0',
  `shownumcorrect` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]qtypordeopti_que_uix` (`questionid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Options for ordering questions';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]qtype_randomsamatch_options`
--

CREATE TABLE `[[dbprefix]]qtype_randomsamatch_options` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `questionid` bigint NOT NULL DEFAULT '0',
  `choose` bigint NOT NULL DEFAULT '4',
  `subcats` tinyint NOT NULL DEFAULT '1',
  `correctfeedback` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `correctfeedbackformat` tinyint NOT NULL DEFAULT '0',
  `partiallycorrectfeedback` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `partiallycorrectfeedbackformat` tinyint NOT NULL DEFAULT '0',
  `incorrectfeedback` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `incorrectfeedbackformat` tinyint NOT NULL DEFAULT '0',
  `shownumcorrect` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]qtyprandopti_que_uix` (`questionid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Info about a random short-answer matching question';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]qtype_shortanswer_options`
--

CREATE TABLE `[[dbprefix]]qtype_shortanswer_options` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `questionid` bigint NOT NULL DEFAULT '0',
  `usecase` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]qtypshoropti_que_uix` (`questionid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Options for short answer questions';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question`
--

CREATE TABLE `[[dbprefix]]question` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `parent` bigint NOT NULL DEFAULT '0',
  `name` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `questiontext` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `questiontextformat` tinyint NOT NULL DEFAULT '0',
  `generalfeedback` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `generalfeedbackformat` tinyint NOT NULL DEFAULT '0',
  `defaultmark` decimal(12,7) NOT NULL DEFAULT '1.0000000',
  `penalty` decimal(12,7) NOT NULL DEFAULT '0.3333333',
  `qtype` varchar(20) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `length` bigint NOT NULL DEFAULT '1',
  `stamp` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `timecreated` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  `createdby` bigint DEFAULT NULL,
  `modifiedby` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]ques_qty_ix` (`qtype`),
  KEY `[[dbprefix]]ques_par_ix` (`parent`),
  KEY `[[dbprefix]]ques_cre_ix` (`createdby`),
  KEY `[[dbprefix]]ques_mod_ix` (`modifiedby`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='This table stores the definition of one version of a questio';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_answers`
--

CREATE TABLE `[[dbprefix]]question_answers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `question` bigint NOT NULL DEFAULT '0',
  `answer` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `answerformat` tinyint NOT NULL DEFAULT '0',
  `fraction` decimal(12,7) NOT NULL DEFAULT '0.0000000',
  `feedback` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `feedbackformat` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quesansw_que_ix` (`question`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Answers, with a fractional grade (0-1) and feedback';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_attempts`
--

CREATE TABLE `[[dbprefix]]question_attempts` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `questionusageid` bigint NOT NULL,
  `slot` bigint NOT NULL,
  `behaviour` varchar(32) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `questionid` bigint NOT NULL,
  `variant` bigint NOT NULL DEFAULT '1',
  `maxmark` decimal(12,7) NOT NULL,
  `minfraction` decimal(12,7) NOT NULL,
  `maxfraction` decimal(12,7) NOT NULL DEFAULT '1.0000000',
  `flagged` tinyint(1) NOT NULL DEFAULT '0',
  `questionsummary` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `rightanswer` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `responsesummary` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `timemodified` bigint NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]quesatte_queslo_uix` (`questionusageid`,`slot`),
  KEY `[[dbprefix]]quesatte_beh_ix` (`behaviour`),
  KEY `[[dbprefix]]quesatte_que_ix` (`questionid`),
  KEY `[[dbprefix]]quesatte_que2_ix` (`questionusageid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Each row here corresponds to an attempt at one question, as ' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_attempt_steps`
--

CREATE TABLE `[[dbprefix]]question_attempt_steps` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `questionattemptid` bigint NOT NULL,
  `sequencenumber` bigint NOT NULL,
  `state` varchar(13) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `fraction` decimal(12,7) DEFAULT NULL,
  `timecreated` bigint NOT NULL,
  `userid` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]quesattestep_queseq_uix` (`questionattemptid`,`sequencenumber`),
  KEY `[[dbprefix]]quesattestep_que_ix` (`questionattemptid`),
  KEY `[[dbprefix]]quesattestep_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores one step in in a question attempt. As well as the dat' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_attempt_step_data`
--

CREATE TABLE `[[dbprefix]]question_attempt_step_data` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `attemptstepid` bigint NOT NULL,
  `name` varchar(32) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `value` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quesattestepdata_att_ix` (`attemptstepid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Each question_attempt_step has an associative array of the d';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_bank_entries`
--

CREATE TABLE `[[dbprefix]]question_bank_entries` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `questioncategoryid` bigint NOT NULL DEFAULT '0',
  `idnumber` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `ownerid` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]quesbankentr_queidn_uix` (`questioncategoryid`,`idnumber`),
  KEY `[[dbprefix]]quesbankentr_que_ix` (`questioncategoryid`),
  KEY `[[dbprefix]]quesbankentr_own_ix` (`ownerid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Each question bank entry. This table has one row for each qu';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_calculated`
--

CREATE TABLE `[[dbprefix]]question_calculated` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `question` bigint NOT NULL DEFAULT '0',
  `answer` bigint NOT NULL DEFAULT '0',
  `tolerance` varchar(20) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '0.0',
  `tolerancetype` bigint NOT NULL DEFAULT '1',
  `correctanswerlength` bigint NOT NULL DEFAULT '2',
  `correctanswerformat` bigint NOT NULL DEFAULT '2',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quescalc_ans_ix` (`answer`),
  KEY `[[dbprefix]]quescalc_que_ix` (`question`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Options for questions of type calculated';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_calculated_options`
--

CREATE TABLE `[[dbprefix]]question_calculated_options` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `question` bigint NOT NULL DEFAULT '0',
  `synchronize` tinyint NOT NULL DEFAULT '0',
  `single` smallint NOT NULL DEFAULT '0',
  `shuffleanswers` smallint NOT NULL DEFAULT '0',
  `correctfeedback` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `correctfeedbackformat` tinyint NOT NULL DEFAULT '0',
  `partiallycorrectfeedback` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `partiallycorrectfeedbackformat` tinyint NOT NULL DEFAULT '0',
  `incorrectfeedback` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `incorrectfeedbackformat` tinyint NOT NULL DEFAULT '0',
  `answernumbering` varchar(10) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT 'abc',
  `shownumcorrect` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quescalcopti_que_ix` (`question`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Options for questions of type calculated';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_categories`
--

CREATE TABLE `[[dbprefix]]question_categories` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(1333) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `contextid` bigint NOT NULL DEFAULT '0',
  `info` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `infoformat` tinyint NOT NULL DEFAULT '0',
  `stamp` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `parent` bigint NOT NULL DEFAULT '0',
  `sortorder` bigint NOT NULL DEFAULT '999',
  `idnumber` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]quescate_consta_uix` (`contextid`,`stamp`),
  UNIQUE KEY `[[dbprefix]]quescate_conidn_uix` (`contextid`,`idnumber`),
  KEY `[[dbprefix]]quescate_con_ix` (`contextid`),
  KEY `[[dbprefix]]quescate_par_ix` (`parent`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Categories are for grouping questions' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_datasets`
--

CREATE TABLE `[[dbprefix]]question_datasets` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `question` bigint NOT NULL DEFAULT '0',
  `datasetdefinition` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quesdata_quedat_ix` (`question`,`datasetdefinition`),
  KEY `[[dbprefix]]quesdata_que_ix` (`question`),
  KEY `[[dbprefix]]quesdata_dat_ix` (`datasetdefinition`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Many-many relation between questions and dataset definitions';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_dataset_definitions`
--

CREATE TABLE `[[dbprefix]]question_dataset_definitions` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `category` bigint NOT NULL DEFAULT '0',
  `name` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `type` bigint NOT NULL DEFAULT '0',
  `options` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `itemcount` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quesdatadefi_cat_ix` (`category`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Organises and stores properties for dataset items';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_dataset_items`
--

CREATE TABLE `[[dbprefix]]question_dataset_items` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `definition` bigint NOT NULL DEFAULT '0',
  `itemnumber` bigint NOT NULL DEFAULT '0',
  `value` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quesdataitem_def_ix` (`definition`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Individual dataset items';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_ddwtos`
--

CREATE TABLE `[[dbprefix]]question_ddwtos` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `questionid` bigint NOT NULL DEFAULT '0',
  `shuffleanswers` smallint NOT NULL DEFAULT '1',
  `correctfeedback` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `correctfeedbackformat` tinyint NOT NULL DEFAULT '0',
  `partiallycorrectfeedback` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `partiallycorrectfeedbackformat` tinyint NOT NULL DEFAULT '0',
  `incorrectfeedback` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `incorrectfeedbackformat` tinyint NOT NULL DEFAULT '0',
  `shownumcorrect` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quesddwt_que_ix` (`questionid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Defines drag and drop (words into sentences) questions';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_gapselect`
--

CREATE TABLE `[[dbprefix]]question_gapselect` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `questionid` bigint NOT NULL DEFAULT '0',
  `shuffleanswers` smallint NOT NULL DEFAULT '1',
  `correctfeedback` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `correctfeedbackformat` tinyint NOT NULL DEFAULT '0',
  `partiallycorrectfeedback` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `partiallycorrectfeedbackformat` tinyint NOT NULL DEFAULT '0',
  `incorrectfeedback` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `incorrectfeedbackformat` tinyint NOT NULL DEFAULT '0',
  `shownumcorrect` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quesgaps_que_ix` (`questionid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Defines select missing words questions';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_hints`
--

CREATE TABLE `[[dbprefix]]question_hints` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `questionid` bigint NOT NULL,
  `hint` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `hintformat` smallint NOT NULL DEFAULT '0',
  `shownumcorrect` tinyint(1) DEFAULT NULL,
  `clearwrong` tinyint(1) DEFAULT NULL,
  `options` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]queshint_que_ix` (`questionid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores the the part of the question definition that gives di';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_multianswer`
--

CREATE TABLE `[[dbprefix]]question_multianswer` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `question` bigint NOT NULL DEFAULT '0',
  `sequence` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quesmult_que_ix` (`question`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Options for multianswer questions';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_numerical`
--

CREATE TABLE `[[dbprefix]]question_numerical` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `question` bigint NOT NULL DEFAULT '0',
  `answer` bigint NOT NULL DEFAULT '0',
  `tolerance` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '0.0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quesnume_ans_ix` (`answer`),
  KEY `[[dbprefix]]quesnume_que_ix` (`question`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Options for numerical questions.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_numerical_options`
--

CREATE TABLE `[[dbprefix]]question_numerical_options` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `question` bigint NOT NULL DEFAULT '0',
  `showunits` smallint NOT NULL DEFAULT '0',
  `unitsleft` smallint NOT NULL DEFAULT '0',
  `unitgradingtype` smallint NOT NULL DEFAULT '0',
  `unitpenalty` decimal(12,7) NOT NULL DEFAULT '0.1000000',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quesnumeopti_que_ix` (`question`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Options for questions of type numerical This table is also u';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_numerical_units`
--

CREATE TABLE `[[dbprefix]]question_numerical_units` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `question` bigint NOT NULL DEFAULT '0',
  `multiplier` decimal(38,19) NOT NULL DEFAULT '1.0000000000000000000',
  `unit` varchar(50) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]quesnumeunit_queuni_uix` (`question`,`unit`),
  KEY `[[dbprefix]]quesnumeunit_que_ix` (`question`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Optional unit options for numerical questions. This table is';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_references`
--

CREATE TABLE `[[dbprefix]]question_references` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `usingcontextid` bigint NOT NULL DEFAULT '0',
  `component` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `questionarea` varchar(50) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `itemid` bigint DEFAULT NULL,
  `questionbankentryid` bigint NOT NULL DEFAULT '0',
  `version` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]quesrefe_usicomqueit_uix` (`usingcontextid`,`component`,`questionarea`,`itemid`),
  KEY `[[dbprefix]]quesrefe_usi_ix` (`usingcontextid`),
  KEY `[[dbprefix]]quesrefe_que_ix` (`questionbankentryid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Records where a specific question is used.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_response_analysis`
--

CREATE TABLE `[[dbprefix]]question_response_analysis` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `hashcode` varchar(40) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `whichtries` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `timemodified` bigint NOT NULL,
  `questionid` bigint NOT NULL,
  `variant` bigint DEFAULT NULL,
  `subqid` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `aid` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `response` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `credit` decimal(15,5) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quesrespanal_has_ix` (`hashcode`),
  KEY `[[dbprefix]]quesrespanal_que_ix` (`questionid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Analysis of student responses given to questions.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_response_count`
--

CREATE TABLE `[[dbprefix]]question_response_count` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `analysisid` bigint NOT NULL,
  `try` bigint NOT NULL,
  `rcount` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quesrespcoun_ana_ix` (`analysisid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Count for each responses for each try at a question.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_set_references`
--

CREATE TABLE `[[dbprefix]]question_set_references` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `usingcontextid` bigint NOT NULL DEFAULT '0',
  `component` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `questionarea` varchar(50) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `itemid` bigint DEFAULT NULL,
  `questionscontextid` bigint NOT NULL DEFAULT '0',
  `filtercondition` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]quessetrefe_usicomqu_uix` (`usingcontextid`,`component`,`questionarea`,`itemid`),
  KEY `[[dbprefix]]quessetrefe_usi_ix` (`usingcontextid`),
  KEY `[[dbprefix]]quessetrefe_que_ix` (`questionscontextid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Records where groups of questions are used.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_statistics`
--

CREATE TABLE `[[dbprefix]]question_statistics` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `hashcode` varchar(40) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `timemodified` bigint NOT NULL,
  `questionid` bigint NOT NULL,
  `slot` bigint DEFAULT NULL,
  `subquestion` smallint NOT NULL,
  `variant` bigint DEFAULT NULL,
  `s` bigint NOT NULL DEFAULT '0',
  `effectiveweight` decimal(15,5) DEFAULT NULL,
  `negcovar` tinyint NOT NULL DEFAULT '0',
  `discriminationindex` decimal(15,5) DEFAULT NULL,
  `discriminativeefficiency` decimal(15,5) DEFAULT NULL,
  `sd` decimal(15,10) DEFAULT NULL,
  `facility` decimal(15,10) DEFAULT NULL,
  `subquestions` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `maxmark` decimal(12,7) DEFAULT NULL,
  `positions` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `randomguessscore` decimal(12,7) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quesstat_has_ix` (`hashcode`),
  KEY `[[dbprefix]]quesstat_que_ix` (`questionid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Statistics for individual questions used in an activity.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_truefalse`
--

CREATE TABLE `[[dbprefix]]question_truefalse` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `question` bigint NOT NULL DEFAULT '0',
  `trueanswer` bigint NOT NULL DEFAULT '0',
  `falseanswer` bigint NOT NULL DEFAULT '0',
  `showstandardinstruction` tinyint NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]questrue_que_ix` (`question`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Options for True-False questions';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_usages`
--

CREATE TABLE `[[dbprefix]]question_usages` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `contextid` bigint NOT NULL,
  `component` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `preferredbehaviour` varchar(32) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quesusag_con_ix` (`contextid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='This table''s main purpose it to assign a unique id to each a' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_versions`
--

CREATE TABLE `[[dbprefix]]question_versions` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `questionbankentryid` bigint NOT NULL DEFAULT '0',
  `version` bigint NOT NULL DEFAULT '1',
  `questionid` bigint NOT NULL DEFAULT '0',
  `status` varchar(10) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT 'ready',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quesvers_que_ix` (`questionbankentryid`),
  KEY `[[dbprefix]]quesvers_que2_ix` (`questionid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='A join table linking the different question version definiti';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]quiz`
--

CREATE TABLE `[[dbprefix]]quiz` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `course` bigint NOT NULL DEFAULT '0',
  `name` varchar(1333) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `intro` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `introformat` smallint NOT NULL DEFAULT '0',
  `timeopen` bigint NOT NULL DEFAULT '0',
  `timeclose` bigint NOT NULL DEFAULT '0',
  `timelimit` bigint NOT NULL DEFAULT '0',
  `overduehandling` varchar(16) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT 'autoabandon',
  `graceperiod` bigint NOT NULL DEFAULT '0',
  `preferredbehaviour` varchar(32) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `canredoquestions` smallint NOT NULL DEFAULT '0',
  `attempts` mediumint NOT NULL DEFAULT '0',
  `attemptonlast` smallint NOT NULL DEFAULT '0',
  `grademethod` smallint NOT NULL DEFAULT '1',
  `decimalpoints` smallint NOT NULL DEFAULT '2',
  `questiondecimalpoints` smallint NOT NULL DEFAULT '-1',
  `reviewattempt` mediumint NOT NULL DEFAULT '0',
  `reviewcorrectness` mediumint NOT NULL DEFAULT '0',
  `reviewmaxmarks` mediumint NOT NULL DEFAULT '0',
  `reviewmarks` mediumint NOT NULL DEFAULT '0',
  `reviewspecificfeedback` mediumint NOT NULL DEFAULT '0',
  `reviewgeneralfeedback` mediumint NOT NULL DEFAULT '0',
  `reviewrightanswer` mediumint NOT NULL DEFAULT '0',
  `reviewoverallfeedback` mediumint NOT NULL DEFAULT '0',
  `questionsperpage` bigint NOT NULL DEFAULT '0',
  `navmethod` varchar(16) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT 'free',
  `shuffleanswers` smallint NOT NULL DEFAULT '0',
  `sumgrades` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `grade` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `timecreated` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  `password` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `subnet` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `browsersecurity` varchar(32) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `delay1` bigint NOT NULL DEFAULT '0',
  `delay2` bigint NOT NULL DEFAULT '0',
  `showuserpicture` smallint NOT NULL DEFAULT '0',
  `showblocks` smallint NOT NULL DEFAULT '0',
  `completionattemptsexhausted` tinyint(1) DEFAULT '0',
  `completionminattempts` bigint NOT NULL DEFAULT '0',
  `allowofflineattempts` tinyint(1) DEFAULT '0',
  `precreateattempts` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quiz_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='The settings for each quiz.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]quizaccess_seb_quizsettings`
--

CREATE TABLE `[[dbprefix]]quizaccess_seb_quizsettings` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `quizid` bigint NOT NULL,
  `cmid` bigint NOT NULL,
  `templateid` bigint NOT NULL,
  `requiresafeexambrowser` tinyint(1) NOT NULL,
  `showsebtaskbar` tinyint(1) DEFAULT NULL,
  `showwificontrol` tinyint(1) DEFAULT NULL,
  `showreloadbutton` tinyint(1) DEFAULT NULL,
  `showtime` tinyint(1) DEFAULT NULL,
  `showkeyboardlayout` tinyint(1) DEFAULT NULL,
  `allowuserquitseb` tinyint(1) DEFAULT NULL,
  `quitpassword` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `linkquitseb` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `userconfirmquit` tinyint(1) DEFAULT NULL,
  `enableaudiocontrol` tinyint(1) DEFAULT NULL,
  `muteonstartup` tinyint(1) DEFAULT NULL,
  `allowcapturecamera` tinyint(1) DEFAULT NULL,
  `allowcapturemicrophone` tinyint(1) DEFAULT NULL,
  `allowspellchecking` tinyint(1) DEFAULT NULL,
  `allowreloadinexam` tinyint(1) DEFAULT NULL,
  `activateurlfiltering` tinyint(1) DEFAULT NULL,
  `filterembeddedcontent` tinyint(1) DEFAULT NULL,
  `expressionsallowed` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `regexallowed` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `expressionsblocked` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `regexblocked` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `allowedbrowserexamkeys` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `showsebdownloadlink` tinyint(1) DEFAULT NULL,
  `usermodified` bigint NOT NULL DEFAULT '0',
  `timecreated` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]quizsebquiz_qui_uix` (`quizid`),
  UNIQUE KEY `[[dbprefix]]quizsebquiz_cmi_uix` (`cmid`),
  KEY `[[dbprefix]]quizsebquiz_tem_ix` (`templateid`),
  KEY `[[dbprefix]]quizsebquiz_use_ix` (`usermodified`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores the quiz level Safe Exam Browser configuration.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]quizaccess_seb_template`
--

CREATE TABLE `[[dbprefix]]quizaccess_seb_template` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `description` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `content` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `sortorder` bigint NOT NULL,
  `usermodified` bigint NOT NULL DEFAULT '0',
  `timecreated` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quizsebtemp_use_ix` (`usermodified`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Templates for Safe Exam Browser configuration.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]quiz_attempts`
--

CREATE TABLE `[[dbprefix]]quiz_attempts` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `quiz` bigint NOT NULL DEFAULT '0',
  `userid` bigint NOT NULL DEFAULT '0',
  `attempt` mediumint NOT NULL DEFAULT '0',
  `uniqueid` bigint NOT NULL DEFAULT '0',
  `layout` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `currentpage` bigint NOT NULL DEFAULT '0',
  `preview` smallint NOT NULL DEFAULT '0',
  `state` varchar(16) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT 'inprogress',
  `timestart` bigint NOT NULL DEFAULT '0',
  `timefinish` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  `timemodifiedoffline` bigint NOT NULL DEFAULT '0',
  `timecheckstate` bigint DEFAULT '0',
  `sumgrades` decimal(10,5) DEFAULT NULL,
  `gradednotificationsenttime` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]quizatte_quiuseatt_uix` (`quiz`,`userid`,`attempt`),
  UNIQUE KEY `[[dbprefix]]quizatte_uni_uix` (`uniqueid`),
  KEY `[[dbprefix]]quizatte_statim_ix` (`state`,`timecheckstate`),
  KEY `[[dbprefix]]quizatte_qui_ix` (`quiz`),
  KEY `[[dbprefix]]quizatte_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores users attempts at quizzes.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]quiz_feedback`
--

CREATE TABLE `[[dbprefix]]quiz_feedback` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `quizid` bigint NOT NULL DEFAULT '0',
  `feedbacktext` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `feedbacktextformat` tinyint NOT NULL DEFAULT '0',
  `mingrade` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `maxgrade` decimal(10,5) NOT NULL DEFAULT '0.00000',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quizfeed_qui_ix` (`quizid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Feedback given to students based on which grade band their o';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]quiz_grades`
--

CREATE TABLE `[[dbprefix]]quiz_grades` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `quiz` bigint NOT NULL DEFAULT '0',
  `userid` bigint NOT NULL DEFAULT '0',
  `grade` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `timemodified` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quizgrad_use_ix` (`userid`),
  KEY `[[dbprefix]]quizgrad_qui_ix` (`quiz`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores the overall grade for each user on the quiz, based on';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]quiz_grade_items`
--

CREATE TABLE `[[dbprefix]]quiz_grade_items` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `quizid` bigint NOT NULL,
  `sortorder` bigint NOT NULL,
  `name` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]quizgraditem_quisor_uix` (`quizid`,`sortorder`),
  KEY `[[dbprefix]]quizgraditem_qui_ix` (`quizid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Where a quiz supports mulitple grades, this table stores wha';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]quiz_overrides`
--

CREATE TABLE `[[dbprefix]]quiz_overrides` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `quiz` bigint NOT NULL DEFAULT '0',
  `groupid` bigint DEFAULT NULL,
  `userid` bigint DEFAULT NULL,
  `timeopen` bigint DEFAULT NULL,
  `timeclose` bigint DEFAULT NULL,
  `timelimit` bigint DEFAULT NULL,
  `attempts` mediumint DEFAULT NULL,
  `password` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quizover_qui_ix` (`quiz`),
  KEY `[[dbprefix]]quizover_gro_ix` (`groupid`),
  KEY `[[dbprefix]]quizover_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='The overrides to quiz settings on a per-user and per-group b' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]quiz_overview_regrades`
--

CREATE TABLE `[[dbprefix]]quiz_overview_regrades` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `questionusageid` bigint NOT NULL,
  `slot` bigint NOT NULL,
  `newfraction` decimal(12,7) DEFAULT NULL,
  `oldfraction` decimal(12,7) DEFAULT NULL,
  `regraded` smallint NOT NULL,
  `timemodified` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quizoverregr_queslo_ix` (`questionusageid`,`slot`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='This table records which question attempts need regrading an';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]quiz_reports`
--

CREATE TABLE `[[dbprefix]]quiz_reports` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `displayorder` bigint NOT NULL,
  `capability` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]quizrepo_nam_uix` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Lists all the installed quiz reports and their display order' AUTO_INCREMENT=5 ;

--
-- Dumping data for table `[[dbprefix]]quiz_reports`
--

INSERT INTO `[[dbprefix]]quiz_reports` VALUES
(1, 'grading', 6000, 'mod/quiz:grade'),
(2, 'overview', 10000, NULL),
(3, 'responses', 9000, NULL),
(4, 'statistics', 8000, 'quiz/statistics:view');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]quiz_sections`
--

CREATE TABLE `[[dbprefix]]quiz_sections` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `quizid` bigint NOT NULL,
  `firstslot` bigint NOT NULL,
  `heading` varchar(1333) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `shufflequestions` smallint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]quizsect_quifir_uix` (`quizid`,`firstslot`),
  KEY `[[dbprefix]]quizsect_qui_ix` (`quizid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores sections of a quiz with section name (heading), from ';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]quiz_slots`
--

CREATE TABLE `[[dbprefix]]quiz_slots` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `slot` bigint NOT NULL,
  `quizid` bigint NOT NULL DEFAULT '0',
  `page` bigint NOT NULL,
  `displaynumber` varchar(16) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `requireprevious` smallint NOT NULL DEFAULT '0',
  `maxmark` decimal(12,7) NOT NULL DEFAULT '0.0000000',
  `quizgradeitemid` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]quizslot_quislo_uix` (`quizid`,`slot`),
  KEY `[[dbprefix]]quizslot_qui_ix` (`quizid`),
  KEY `[[dbprefix]]quizslot_qui2_ix` (`quizgradeitemid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores the question used in a quiz, with the order, and for ';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]quiz_statistics`
--

CREATE TABLE `[[dbprefix]]quiz_statistics` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `hashcode` varchar(40) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `whichattempts` smallint NOT NULL,
  `timemodified` bigint NOT NULL,
  `firstattemptscount` bigint NOT NULL,
  `highestattemptscount` bigint NOT NULL,
  `lastattemptscount` bigint NOT NULL,
  `allattemptscount` bigint NOT NULL,
  `firstattemptsavg` decimal(15,5) DEFAULT NULL,
  `highestattemptsavg` decimal(15,5) DEFAULT NULL,
  `lastattemptsavg` decimal(15,5) DEFAULT NULL,
  `allattemptsavg` decimal(15,5) DEFAULT NULL,
  `median` decimal(15,5) DEFAULT NULL,
  `standarddeviation` decimal(15,5) DEFAULT NULL,
  `skewness` decimal(15,10) DEFAULT NULL,
  `kurtosis` decimal(15,5) DEFAULT NULL,
  `cic` decimal(15,10) DEFAULT NULL,
  `errorratio` decimal(15,10) DEFAULT NULL,
  `standarderror` decimal(15,10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quizstat_has_ix` (`hashcode`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='table to cache results from analysis done in statistics repo';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]rating`
--

CREATE TABLE `[[dbprefix]]rating` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `contextid` bigint NOT NULL,
  `component` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `ratingarea` varchar(50) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `itemid` bigint NOT NULL,
  `scaleid` bigint NOT NULL,
  `rating` bigint NOT NULL,
  `userid` bigint NOT NULL,
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]rati_comratconite_ix` (`component`,`ratingarea`,`contextid`,`itemid`),
  KEY `[[dbprefix]]rati_con_ix` (`contextid`),
  KEY `[[dbprefix]]rati_use_ix` (`userid`),
  KEY `[[dbprefix]]rati_sca_ix` (`scaleid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='moodle ratings';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]registration_hubs`
--

CREATE TABLE `[[dbprefix]]registration_hubs` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `token` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `hubname` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `huburl` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `confirmed` tinyint(1) NOT NULL DEFAULT '0',
  `secret` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `timemodified` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='hub where the site is registered on with their associated to';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]reportbuilder_audience`
--

CREATE TABLE `[[dbprefix]]reportbuilder_audience` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `reportid` bigint NOT NULL,
  `heading` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `classname` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `configdata` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `usercreated` bigint NOT NULL DEFAULT '0',
  `usermodified` bigint NOT NULL DEFAULT '0',
  `timecreated` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]repoaudi_rep_ix` (`reportid`),
  KEY `[[dbprefix]]repoaudi_use_ix` (`usercreated`),
  KEY `[[dbprefix]]repoaudi_use2_ix` (`usermodified`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Defines report audience';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]reportbuilder_column`
--

CREATE TABLE `[[dbprefix]]reportbuilder_column` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `reportid` bigint NOT NULL DEFAULT '0',
  `uniqueidentifier` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `aggregation` varchar(32) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `heading` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `columnorder` bigint NOT NULL,
  `sortenabled` tinyint(1) NOT NULL DEFAULT '0',
  `sortdirection` tinyint(1) NOT NULL,
  `sortorder` bigint DEFAULT NULL,
  `usercreated` bigint NOT NULL DEFAULT '0',
  `usermodified` bigint NOT NULL DEFAULT '0',
  `timecreated` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]repocolu_rep_ix` (`reportid`),
  KEY `[[dbprefix]]repocolu_use_ix` (`usercreated`),
  KEY `[[dbprefix]]repocolu_use2_ix` (`usermodified`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Table to represent a report column';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]reportbuilder_filter`
--

CREATE TABLE `[[dbprefix]]reportbuilder_filter` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `reportid` bigint NOT NULL DEFAULT '0',
  `uniqueidentifier` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `heading` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `iscondition` tinyint(1) NOT NULL DEFAULT '0',
  `filterorder` bigint NOT NULL,
  `usercreated` bigint NOT NULL DEFAULT '0',
  `usermodified` bigint NOT NULL DEFAULT '0',
  `timecreated` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]repofilt_repuniisc_uix` (`reportid`,`uniqueidentifier`,`iscondition`),
  KEY `[[dbprefix]]repofilt_rep_ix` (`reportid`),
  KEY `[[dbprefix]]repofilt_use_ix` (`usercreated`),
  KEY `[[dbprefix]]repofilt_use2_ix` (`usermodified`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Table to represent a report filter/condition';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]reportbuilder_report`
--

CREATE TABLE `[[dbprefix]]reportbuilder_report` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `source` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `type` tinyint NOT NULL DEFAULT '0',
  `uniquerows` tinyint(1) NOT NULL DEFAULT '0',
  `conditiondata` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `settingsdata` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `contextid` bigint NOT NULL,
  `component` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `area` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `itemid` bigint NOT NULL DEFAULT '0',
  `usercreated` bigint NOT NULL DEFAULT '0',
  `usermodified` bigint NOT NULL DEFAULT '0',
  `timecreated` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]reporepo_use_ix` (`usercreated`),
  KEY `[[dbprefix]]reporepo_use2_ix` (`usermodified`),
  KEY `[[dbprefix]]reporepo_con_ix` (`contextid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Table to represent a report';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]reportbuilder_schedule`
--

CREATE TABLE `[[dbprefix]]reportbuilder_schedule` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `reportid` bigint NOT NULL DEFAULT '0',
  `name` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `enabled` tinyint(1) NOT NULL DEFAULT '1',
  `audiences` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `classname` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `configdata` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `format` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `userviewas` bigint NOT NULL DEFAULT '0',
  `timescheduled` bigint NOT NULL DEFAULT '0',
  `recurrence` bigint NOT NULL DEFAULT '0',
  `timelastsent` bigint NOT NULL DEFAULT '0',
  `timenextsend` bigint NOT NULL DEFAULT '0',
  `usercreated` bigint NOT NULL DEFAULT '0',
  `usermodified` bigint NOT NULL DEFAULT '0',
  `timecreated` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]reposche_rep_ix` (`reportid`),
  KEY `[[dbprefix]]reposche_use_ix` (`userviewas`),
  KEY `[[dbprefix]]reposche_use2_ix` (`usercreated`),
  KEY `[[dbprefix]]reposche_use3_ix` (`usermodified`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Table to represent a report schedule' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]reportbuilder_user_filter`
--

CREATE TABLE `[[dbprefix]]reportbuilder_user_filter` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `reportid` bigint NOT NULL DEFAULT '0',
  `filterdata` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `usercreated` bigint NOT NULL DEFAULT '0',
  `usermodified` bigint NOT NULL DEFAULT '0',
  `timecreated` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]repouserfilt_repuse_uix` (`reportid`,`usercreated`),
  KEY `[[dbprefix]]repouserfilt_rep_ix` (`reportid`),
  KEY `[[dbprefix]]repouserfilt_use_ix` (`usercreated`),
  KEY `[[dbprefix]]repouserfilt_use2_ix` (`usermodified`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Defines user report filter';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]repository`
--

CREATE TABLE `[[dbprefix]]repository` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `type` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `visible` tinyint(1) DEFAULT '1',
  `sortorder` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='This table contains one entry for every configured external ' AUTO_INCREMENT=9 ;

--
-- Dumping data for table `[[dbprefix]]repository`
--

INSERT INTO `[[dbprefix]]repository` VALUES
(1, 'areafiles', 1, 1),
(2, 'contentbank', 1, 2),
(3, 'local', 1, 3),
(4, 'recent', 1, 4),
(5, 'upload', 1, 5),
(6, 'url', 1, 6),
(7, 'user', 1, 7),
(8, 'wikimedia', 1, 8);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]repository_instances`
--

CREATE TABLE `[[dbprefix]]repository_instances` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `typeid` bigint NOT NULL,
  `userid` bigint NOT NULL DEFAULT '0',
  `contextid` bigint NOT NULL,
  `username` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `password` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `timecreated` bigint DEFAULT NULL,
  `timemodified` bigint DEFAULT NULL,
  `readonly` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]repoinst_use_ix` (`userid`),
  KEY `[[dbprefix]]repoinst_con_ix` (`contextid`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='This table contains one entry for every configured external ' AUTO_INCREMENT=9 ;

--
-- Dumping data for table `[[dbprefix]]repository_instances`
--

INSERT INTO `[[dbprefix]]repository_instances` VALUES
(1, '', 1, 0, 1, NULL, NULL, [[timestamp]], [[timestamp]], 0),
(2, '', 2, 0, 1, NULL, NULL, [[timestamp]], [[timestamp]], 0),
(3, '', 3, 0, 1, NULL, NULL, [[timestamp]], [[timestamp]], 0),
(4, '', 4, 0, 1, NULL, NULL, [[timestamp]], [[timestamp]], 0),
(5, '', 5, 0, 1, NULL, NULL, [[timestamp]], [[timestamp]], 0),
(6, '', 6, 0, 1, NULL, NULL, [[timestamp]], [[timestamp]], 0),
(7, '', 7, 0, 1, NULL, NULL, [[timestamp]], [[timestamp]], 0),
(8, '', 8, 0, 1, NULL, NULL, [[timestamp]], [[timestamp]], 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]repository_instance_config`
--

CREATE TABLE `[[dbprefix]]repository_instance_config` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `instanceid` bigint NOT NULL,
  `name` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `value` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='The config for intances' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]repository_onedrive_access`
--

CREATE TABLE `[[dbprefix]]repository_onedrive_access` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `timemodified` bigint NOT NULL,
  `timecreated` bigint NOT NULL,
  `usermodified` bigint NOT NULL,
  `permissionid` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `itemid` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]repoonedacce_use_ix` (`usermodified`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='List of temporary access grants.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]resource`
--

CREATE TABLE `[[dbprefix]]resource` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `course` bigint NOT NULL DEFAULT '0',
  `name` varchar(1333) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `intro` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `introformat` smallint NOT NULL DEFAULT '0',
  `tobemigrated` smallint NOT NULL DEFAULT '0',
  `legacyfiles` smallint NOT NULL DEFAULT '0',
  `legacyfileslast` bigint DEFAULT NULL,
  `display` smallint NOT NULL DEFAULT '0',
  `displayoptions` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `filterfiles` smallint NOT NULL DEFAULT '0',
  `revision` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]reso_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Each record is one resource and its config data';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]resource_old`
--

CREATE TABLE `[[dbprefix]]resource_old` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `course` bigint NOT NULL DEFAULT '0',
  `name` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `type` varchar(30) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `reference` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `intro` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `introformat` smallint NOT NULL DEFAULT '0',
  `alltext` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `popup` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `options` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `timemodified` bigint NOT NULL DEFAULT '0',
  `oldid` bigint NOT NULL,
  `cmid` bigint DEFAULT NULL,
  `newmodule` varchar(50) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `newid` bigint DEFAULT NULL,
  `migrated` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]resoold_old_uix` (`oldid`),
  KEY `[[dbprefix]]resoold_cmi_ix` (`cmid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='backup of all old resource instances from 1.9';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]role`
--

CREATE TABLE `[[dbprefix]]role` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `shortname` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `description` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `sortorder` bigint NOT NULL DEFAULT '0',
  `archetype` varchar(30) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]role_sor_uix` (`sortorder`),
  UNIQUE KEY `[[dbprefix]]role_sho_uix` (`shortname`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='moodle roles' AUTO_INCREMENT=9 ;

--
-- Dumping data for table `[[dbprefix]]role`
--

INSERT INTO `[[dbprefix]]role` VALUES
(1, '', 'manager', '', 1, 'manager'),
(2, '', 'coursecreator', '', 2, 'coursecreator'),
(3, '', 'editingteacher', '', 3, 'editingteacher'),
(4, '', 'teacher', '', 4, 'teacher'),
(5, '', 'student', '', 5, 'student'),
(6, '', 'guest', '', 6, 'guest'),
(7, '', 'user', '', 7, 'user'),
(8, '', 'frontpage', '', 8, 'frontpage');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]role_allow_assign`
--

CREATE TABLE `[[dbprefix]]role_allow_assign` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `roleid` bigint NOT NULL DEFAULT '0',
  `allowassign` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]rolealloassi_rolall_uix` (`roleid`,`allowassign`),
  KEY `[[dbprefix]]rolealloassi_rol_ix` (`roleid`),
  KEY `[[dbprefix]]rolealloassi_all_ix` (`allowassign`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='this defines what role can assign what role' AUTO_INCREMENT=8 ;

--
-- Dumping data for table `[[dbprefix]]role_allow_assign`
--

INSERT INTO `[[dbprefix]]role_allow_assign` VALUES
(1, 1, 1),
(2, 1, 2),
(3, 1, 3),
(4, 1, 4),
(5, 1, 5),
(6, 3, 4),
(7, 3, 5);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]role_allow_override`
--

CREATE TABLE `[[dbprefix]]role_allow_override` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `roleid` bigint NOT NULL DEFAULT '0',
  `allowoverride` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]rolealloover_rolall_uix` (`roleid`,`allowoverride`),
  KEY `[[dbprefix]]rolealloover_rol_ix` (`roleid`),
  KEY `[[dbprefix]]rolealloover_all_ix` (`allowoverride`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='this defines what role can override what role' AUTO_INCREMENT=12 ;

--
-- Dumping data for table `[[dbprefix]]role_allow_override`
--

INSERT INTO `[[dbprefix]]role_allow_override` VALUES
(1, 1, 1),
(2, 1, 2),
(3, 1, 3),
(4, 1, 4),
(5, 1, 5),
(6, 1, 6),
(7, 1, 7),
(8, 1, 8),
(9, 3, 4),
(10, 3, 5),
(11, 3, 6);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]role_allow_switch`
--

CREATE TABLE `[[dbprefix]]role_allow_switch` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `roleid` bigint NOT NULL,
  `allowswitch` bigint NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]rolealloswit_rolall_uix` (`roleid`,`allowswitch`),
  KEY `[[dbprefix]]rolealloswit_rol_ix` (`roleid`),
  KEY `[[dbprefix]]rolealloswit_all_ix` (`allowswitch`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='This table stores which which other roles a user is allowed ' AUTO_INCREMENT=10 ;

--
-- Dumping data for table `[[dbprefix]]role_allow_switch`
--

INSERT INTO `[[dbprefix]]role_allow_switch` VALUES
(1, 1, 3),
(2, 1, 4),
(3, 1, 5),
(4, 1, 6),
(5, 3, 4),
(6, 3, 5),
(7, 3, 6),
(8, 4, 5),
(9, 4, 6);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]role_allow_view`
--

CREATE TABLE `[[dbprefix]]role_allow_view` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `roleid` bigint NOT NULL,
  `allowview` bigint NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]rolealloview_rolall_uix` (`roleid`,`allowview`),
  KEY `[[dbprefix]]rolealloview_rol_ix` (`roleid`),
  KEY `[[dbprefix]]rolealloview_all_ix` (`allowview`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='This table stores which which other roles a user is allowed ' AUTO_INCREMENT=25 ;

--
-- Dumping data for table `[[dbprefix]]role_allow_view`
--

INSERT INTO `[[dbprefix]]role_allow_view` VALUES
(1, 1, 1),
(2, 1, 2),
(3, 1, 3),
(4, 1, 4),
(5, 1, 5),
(6, 1, 6),
(7, 1, 7),
(8, 1, 8),
(9, 2, 2),
(10, 2, 3),
(11, 2, 4),
(12, 2, 5),
(13, 3, 2),
(14, 3, 3),
(15, 3, 4),
(16, 3, 5),
(17, 4, 2),
(18, 4, 3),
(19, 4, 4),
(20, 4, 5),
(21, 5, 2),
(22, 5, 3),
(23, 5, 4),
(24, 5, 5);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]role_assignments`
--

CREATE TABLE `[[dbprefix]]role_assignments` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `roleid` bigint NOT NULL DEFAULT '0',
  `contextid` bigint NOT NULL DEFAULT '0',
  `userid` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  `modifierid` bigint NOT NULL DEFAULT '0',
  `component` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `itemid` bigint NOT NULL DEFAULT '0',
  `sortorder` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]roleassi_sor_ix` (`sortorder`),
  KEY `[[dbprefix]]roleassi_rolcon_ix` (`roleid`,`contextid`),
  KEY `[[dbprefix]]roleassi_useconrol_ix` (`userid`,`contextid`,`roleid`),
  KEY `[[dbprefix]]roleassi_comiteuse_ix` (`component`,`itemid`,`userid`),
  KEY `[[dbprefix]]roleassi_rol_ix` (`roleid`),
  KEY `[[dbprefix]]roleassi_con_ix` (`contextid`),
  KEY `[[dbprefix]]roleassi_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='assigning roles in different context' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]role_capabilities`
--

CREATE TABLE `[[dbprefix]]role_capabilities` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `contextid` bigint NOT NULL DEFAULT '0',
  `roleid` bigint NOT NULL DEFAULT '0',
  `capability` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `permission` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  `modifierid` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]rolecapa_rolconcap_uix` (`roleid`,`contextid`,`capability`),
  KEY `[[dbprefix]]rolecapa_rol_ix` (`roleid`),
  KEY `[[dbprefix]]rolecapa_con_ix` (`contextid`),
  KEY `[[dbprefix]]rolecapa_mod_ix` (`modifierid`),
  KEY `[[dbprefix]]rolecapa_cap_ix` (`capability`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='permission has to be signed, overriding a capability for a p' AUTO_INCREMENT=1528 ;

--
-- Dumping data for table `[[dbprefix]]role_capabilities`
--

INSERT INTO `[[dbprefix]]role_capabilities` VALUES
(1, 1, 1, 'moodle/site:configview', 1, [[timestamp]], 0),
(2, 1, 2, 'moodle/site:configview', 1, [[timestamp]], 0),
(3, 1, 1, 'moodle/site:readallmessages', 1, [[timestamp]], 0),
(4, 1, 3, 'moodle/site:readallmessages', 1, [[timestamp]], 0),
(5, 1, 1, 'moodle/site:manageallmessaging', 1, [[timestamp]], 0),
(6, 1, 1, 'moodle/site:deleteanymessage', 1, [[timestamp]], 0),
(7, 1, 1, 'moodle/site:sendmessage', 1, [[timestamp]], 0),
(8, 1, 7, 'moodle/site:sendmessage', 1, [[timestamp]], 0),
(9, 1, 7, 'moodle/site:senderrormessage', 1, [[timestamp]], 0),
(10, 1, 7, 'moodle/site:deleteownmessage', 1, [[timestamp]], 0),
(11, 1, 1, 'moodle/site:approvecourse', 1, [[timestamp]], 0),
(12, 1, 3, 'moodle/backup:backupcourse', 1, [[timestamp]], 0),
(13, 1, 1, 'moodle/backup:backupcourse', 1, [[timestamp]], 0),
(14, 1, 3, 'moodle/backup:backupsection', 1, [[timestamp]], 0),
(15, 1, 1, 'moodle/backup:backupsection', 1, [[timestamp]], 0),
(16, 1, 3, 'moodle/backup:backupactivity', 1, [[timestamp]], 0),
(17, 1, 1, 'moodle/backup:backupactivity', 1, [[timestamp]], 0),
(18, 1, 3, 'moodle/backup:backuptargetimport', 1, [[timestamp]], 0),
(19, 1, 1, 'moodle/backup:backuptargetimport', 1, [[timestamp]], 0),
(20, 1, 3, 'moodle/backup:downloadfile', 1, [[timestamp]], 0),
(21, 1, 1, 'moodle/backup:downloadfile', 1, [[timestamp]], 0),
(22, 1, 3, 'moodle/backup:configure', 1, [[timestamp]], 0),
(23, 1, 1, 'moodle/backup:configure', 1, [[timestamp]], 0),
(24, 1, 1, 'moodle/backup:userinfo', 1, [[timestamp]], 0),
(25, 1, 1, 'moodle/backup:anonymise', 1, [[timestamp]], 0),
(26, 1, 3, 'moodle/restore:restorecourse', 1, [[timestamp]], 0),
(27, 1, 1, 'moodle/restore:restorecourse', 1, [[timestamp]], 0),
(28, 1, 3, 'moodle/restore:restoresection', 1, [[timestamp]], 0),
(29, 1, 1, 'moodle/restore:restoresection', 1, [[timestamp]], 0),
(30, 1, 3, 'moodle/restore:restoreactivity', 1, [[timestamp]], 0),
(31, 1, 1, 'moodle/restore:restoreactivity', 1, [[timestamp]], 0),
(32, 1, 3, 'moodle/restore:viewautomatedfilearea', 1, [[timestamp]], 0),
(33, 1, 1, 'moodle/restore:viewautomatedfilearea', 1, [[timestamp]], 0),
(34, 1, 3, 'moodle/restore:restoretargetimport', 1, [[timestamp]], 0),
(35, 1, 1, 'moodle/restore:restoretargetimport', 1, [[timestamp]], 0),
(36, 1, 3, 'moodle/restore:uploadfile', 1, [[timestamp]], 0),
(37, 1, 1, 'moodle/restore:uploadfile', 1, [[timestamp]], 0),
(38, 1, 3, 'moodle/restore:configure', 1, [[timestamp]], 0),
(39, 1, 1, 'moodle/restore:configure', 1, [[timestamp]], 0),
(40, 1, 2, 'moodle/restore:rolldates', 1, [[timestamp]], 0),
(41, 1, 1, 'moodle/restore:rolldates', 1, [[timestamp]], 0),
(42, 1, 1, 'moodle/restore:userinfo', 1, [[timestamp]], 0),
(43, 1, 1, 'moodle/restore:createuser', 1, [[timestamp]], 0),
(44, 1, 3, 'moodle/site:manageblocks', 1, [[timestamp]], 0),
(45, 1, 1, 'moodle/site:manageblocks', 1, [[timestamp]], 0),
(46, 1, 3, 'moodle/site:accessallgroups', 1, [[timestamp]], 0),
(47, 1, 1, 'moodle/site:accessallgroups', 1, [[timestamp]], 0),
(48, 1, 1, 'moodle/site:viewanonymousevents', 1, [[timestamp]], 0),
(49, 1, 4, 'moodle/site:viewfullnames', 1, [[timestamp]], 0),
(50, 1, 3, 'moodle/site:viewfullnames', 1, [[timestamp]], 0),
(51, 1, 1, 'moodle/site:viewfullnames', 1, [[timestamp]], 0),
(52, 1, 4, 'moodle/site:viewuseridentity', 1, [[timestamp]], 0),
(53, 1, 3, 'moodle/site:viewuseridentity', 1, [[timestamp]], 0),
(54, 1, 1, 'moodle/site:viewuseridentity', 1, [[timestamp]], 0),
(55, 1, 4, 'moodle/site:viewreports', 1, [[timestamp]], 0),
(56, 1, 3, 'moodle/site:viewreports', 1, [[timestamp]], 0),
(57, 1, 1, 'moodle/site:viewreports', 1, [[timestamp]], 0),
(58, 1, 3, 'moodle/site:trustcontent', 1, [[timestamp]], 0),
(59, 1, 1, 'moodle/site:trustcontent', 1, [[timestamp]], 0),
(60, 1, 1, 'moodle/site:uploadusers', 1, [[timestamp]], 0),
(61, 1, 3, 'moodle/filter:manage', 1, [[timestamp]], 0),
(62, 1, 1, 'moodle/filter:manage', 1, [[timestamp]], 0),
(63, 1, 1, 'moodle/user:create', 1, [[timestamp]], 0),
(64, 1, 1, 'moodle/user:delete', 1, [[timestamp]], 0),
(65, 1, 1, 'moodle/user:update', 1, [[timestamp]], 0),
(66, 1, 6, 'moodle/user:viewdetails', 1, [[timestamp]], 0),
(67, 1, 5, 'moodle/user:viewdetails', 1, [[timestamp]], 0),
(68, 1, 4, 'moodle/user:viewdetails', 1, [[timestamp]], 0),
(69, 1, 3, 'moodle/user:viewdetails', 1, [[timestamp]], 0),
(70, 1, 1, 'moodle/user:viewdetails', 1, [[timestamp]], 0),
(71, 1, 6, 'moodle/user:viewprofilepictures', 1, [[timestamp]], 0),
(72, 1, 7, 'moodle/user:viewprofilepictures', 1, [[timestamp]], 0),
(73, 1, 1, 'moodle/user:viewalldetails', 1, [[timestamp]], 0),
(74, 1, 1, 'moodle/user:viewlastip', 1, [[timestamp]], 0),
(75, 1, 4, 'moodle/user:viewhiddendetails', 1, [[timestamp]], 0),
(76, 1, 3, 'moodle/user:viewhiddendetails', 1, [[timestamp]], 0),
(77, 1, 1, 'moodle/user:viewhiddendetails', 1, [[timestamp]], 0),
(78, 1, 1, 'moodle/user:loginas', 1, [[timestamp]], 0),
(79, 1, 1, 'moodle/user:managesyspages', 1, [[timestamp]], 0),
(80, 1, 7, 'moodle/user:manageownblocks', 1, [[timestamp]], 0),
(81, 1, 7, 'moodle/user:manageownfiles', 1, [[timestamp]], 0),
(82, 1, 1, 'moodle/my:configsyspages', 1, [[timestamp]], 0),
(83, 1, 3, 'moodle/role:assign', 1, [[timestamp]], 0),
(84, 1, 1, 'moodle/role:assign', 1, [[timestamp]], 0),
(85, 1, 4, 'moodle/role:review', 1, [[timestamp]], 0),
(86, 1, 3, 'moodle/role:review', 1, [[timestamp]], 0),
(87, 1, 1, 'moodle/role:review', 1, [[timestamp]], 0),
(88, 1, 1, 'moodle/role:override', 1, [[timestamp]], 0),
(89, 1, 3, 'moodle/role:safeoverride', 1, [[timestamp]], 0),
(90, 1, 1, 'moodle/role:manage', 1, [[timestamp]], 0),
(91, 1, 3, 'moodle/role:switchroles', 1, [[timestamp]], 0),
(92, 1, 1, 'moodle/role:switchroles', 1, [[timestamp]], 0),
(93, 1, 1, 'moodle/category:manage', 1, [[timestamp]], 0),
(94, 1, 6, 'moodle/category:viewcourselist', 1, [[timestamp]], 0),
(95, 1, 7, 'moodle/category:viewcourselist', 1, [[timestamp]], 0),
(96, 1, 2, 'moodle/category:viewhiddencategories', 1, [[timestamp]], 0),
(97, 1, 1, 'moodle/category:viewhiddencategories', 1, [[timestamp]], 0),
(98, 1, 1, 'moodle/cohort:manage', 1, [[timestamp]], 0),
(99, 1, 1, 'moodle/cohort:assign', 1, [[timestamp]], 0),
(100, 1, 3, 'moodle/cohort:view', 1, [[timestamp]], 0),
(101, 1, 1, 'moodle/cohort:view', 1, [[timestamp]], 0),
(102, 1, 2, 'moodle/course:create', 1, [[timestamp]], 0),
(103, 1, 1, 'moodle/course:create', 1, [[timestamp]], 0),
(104, 1, 3, 'moodle/course:creategroupconversations', 1, [[timestamp]], 0),
(105, 1, 1, 'moodle/course:creategroupconversations', 1, [[timestamp]], 0),
(106, 1, 1, 'moodle/course:delete', 1, [[timestamp]], 0),
(107, 1, 3, 'moodle/course:update', 1, [[timestamp]], 0),
(108, 1, 1, 'moodle/course:update', 1, [[timestamp]], 0),
(109, 1, 1, 'moodle/course:view', 1, [[timestamp]], 0),
(110, 1, 3, 'moodle/course:enrolreview', 1, [[timestamp]], 0),
(111, 1, 1, 'moodle/course:enrolreview', 1, [[timestamp]], 0),
(112, 1, 3, 'moodle/course:enrolconfig', 1, [[timestamp]], 0),
(113, 1, 1, 'moodle/course:enrolconfig', 1, [[timestamp]], 0),
(114, 1, 3, 'moodle/course:reviewotherusers', 1, [[timestamp]], 0),
(115, 1, 1, 'moodle/course:reviewotherusers', 1, [[timestamp]], 0),
(116, 1, 4, 'moodle/course:bulkmessaging', 1, [[timestamp]], 0),
(117, 1, 3, 'moodle/course:bulkmessaging', 1, [[timestamp]], 0),
(118, 1, 1, 'moodle/course:bulkmessaging', 1, [[timestamp]], 0),
(119, 1, 4, 'moodle/course:viewhiddenuserfields', 1, [[timestamp]], 0),
(120, 1, 3, 'moodle/course:viewhiddenuserfields', 1, [[timestamp]], 0),
(121, 1, 1, 'moodle/course:viewhiddenuserfields', 1, [[timestamp]], 0),
(122, 1, 2, 'moodle/course:viewhiddencourses', 1, [[timestamp]], 0),
(123, 1, 4, 'moodle/course:viewhiddencourses', 1, [[timestamp]], 0),
(124, 1, 3, 'moodle/course:viewhiddencourses', 1, [[timestamp]], 0),
(125, 1, 1, 'moodle/course:viewhiddencourses', 1, [[timestamp]], 0),
(126, 1, 3, 'moodle/course:visibility', 1, [[timestamp]], 0),
(127, 1, 1, 'moodle/course:visibility', 1, [[timestamp]], 0),
(128, 1, 3, 'moodle/course:managefiles', 1, [[timestamp]], 0),
(129, 1, 1, 'moodle/course:managefiles', 1, [[timestamp]], 0),
(130, 1, 1, 'moodle/course:ignoreavailabilityrestrictions', 1, [[timestamp]], 0),
(131, 1, 2, 'moodle/course:ignoreavailabilityrestrictions', 1, [[timestamp]], 0),
(132, 1, 3, 'moodle/course:ignoreavailabilityrestrictions', 1, [[timestamp]], 0),
(133, 1, 4, 'moodle/course:ignoreavailabilityrestrictions', 1, [[timestamp]], 0),
(134, 1, 3, 'moodle/course:manageactivities', 1, [[timestamp]], 0),
(135, 1, 1, 'moodle/course:manageactivities', 1, [[timestamp]], 0),
(136, 1, 3, 'moodle/course:activityvisibility', 1, [[timestamp]], 0),
(137, 1, 1, 'moodle/course:activityvisibility', 1, [[timestamp]], 0),
(138, 1, 4, 'moodle/course:viewhiddenactivities', 1, [[timestamp]], 0),
(139, 1, 3, 'moodle/course:viewhiddenactivities', 1, [[timestamp]], 0),
(140, 1, 1, 'moodle/course:viewhiddenactivities', 1, [[timestamp]], 0),
(141, 1, 5, 'moodle/course:viewparticipants', 1, [[timestamp]], 0),
(142, 1, 4, 'moodle/course:viewparticipants', 1, [[timestamp]], 0),
(143, 1, 3, 'moodle/course:viewparticipants', 1, [[timestamp]], 0),
(144, 1, 1, 'moodle/course:viewparticipants', 1, [[timestamp]], 0),
(145, 1, 5, 'moodle/course:viewoverview', 1, [[timestamp]], 0),
(146, 1, 4, 'moodle/course:viewoverview', 1, [[timestamp]], 0),
(147, 1, 3, 'moodle/course:viewoverview', 1, [[timestamp]], 0),
(148, 1, 1, 'moodle/course:viewoverview', 1, [[timestamp]], 0),
(149, 1, 3, 'moodle/course:changefullname', 1, [[timestamp]], 0),
(150, 1, 1, 'moodle/course:changefullname', 1, [[timestamp]], 0),
(151, 1, 3, 'moodle/course:changeshortname', 1, [[timestamp]], 0),
(152, 1, 1, 'moodle/course:changeshortname', 1, [[timestamp]], 0),
(153, 1, 1, 'moodle/course:changelockedcustomfields', 1, [[timestamp]], 0),
(154, 1, 3, 'moodle/course:renameroles', 1, [[timestamp]], 0),
(155, 1, 1, 'moodle/course:renameroles', 1, [[timestamp]], 0),
(156, 1, 3, 'moodle/course:changeidnumber', 1, [[timestamp]], 0),
(157, 1, 1, 'moodle/course:changeidnumber', 1, [[timestamp]], 0),
(158, 1, 3, 'moodle/course:changecategory', 1, [[timestamp]], 0),
(159, 1, 1, 'moodle/course:changecategory', 1, [[timestamp]], 0),
(160, 1, 3, 'moodle/course:changesummary', 1, [[timestamp]], 0),
(161, 1, 1, 'moodle/course:changesummary', 1, [[timestamp]], 0),
(162, 1, 3, 'moodle/course:setforcedlanguage', 1, [[timestamp]], 0),
(163, 1, 1, 'moodle/course:setforcedlanguage', 1, [[timestamp]], 0),
(164, 1, 1, 'moodle/site:viewparticipants', 1, [[timestamp]], 0),
(165, 1, 5, 'moodle/course:isincompletionreports', 1, [[timestamp]], 0),
(166, 1, 5, 'moodle/course:viewscales', 1, [[timestamp]], 0),
(167, 1, 4, 'moodle/course:viewscales', 1, [[timestamp]], 0),
(168, 1, 3, 'moodle/course:viewscales', 1, [[timestamp]], 0),
(169, 1, 1, 'moodle/course:viewscales', 1, [[timestamp]], 0),
(170, 1, 3, 'moodle/course:managescales', 1, [[timestamp]], 0),
(171, 1, 1, 'moodle/course:managescales', 1, [[timestamp]], 0),
(172, 1, 3, 'moodle/course:managegroups', 1, [[timestamp]], 0),
(173, 1, 1, 'moodle/course:managegroups', 1, [[timestamp]], 0),
(174, 1, 4, 'moodle/course:viewhiddengroups', 1, [[timestamp]], 0),
(175, 1, 3, 'moodle/course:viewhiddengroups', 1, [[timestamp]], 0),
(176, 1, 1, 'moodle/course:viewhiddengroups', 1, [[timestamp]], 0),
(177, 1, 3, 'moodle/course:reset', 1, [[timestamp]], 0),
(178, 1, 1, 'moodle/course:reset', 1, [[timestamp]], 0),
(179, 1, 3, 'moodle/course:viewsuspendedusers', 1, [[timestamp]], 0),
(180, 1, 1, 'moodle/course:viewsuspendedusers', 1, [[timestamp]], 0),
(181, 1, 1, 'moodle/course:tag', 1, [[timestamp]], 0),
(182, 1, 3, 'moodle/course:tag', 1, [[timestamp]], 0),
(183, 1, 6, 'moodle/blog:view', 1, [[timestamp]], 0),
(184, 1, 7, 'moodle/blog:view', 1, [[timestamp]], 0),
(185, 1, 5, 'moodle/blog:view', 1, [[timestamp]], 0),
(186, 1, 4, 'moodle/blog:view', 1, [[timestamp]], 0),
(187, 1, 3, 'moodle/blog:view', 1, [[timestamp]], 0),
(188, 1, 1, 'moodle/blog:view', 1, [[timestamp]], 0),
(189, 1, 6, 'moodle/blog:search', 1, [[timestamp]], 0),
(190, 1, 7, 'moodle/blog:search', 1, [[timestamp]], 0),
(191, 1, 5, 'moodle/blog:search', 1, [[timestamp]], 0),
(192, 1, 4, 'moodle/blog:search', 1, [[timestamp]], 0),
(193, 1, 3, 'moodle/blog:search', 1, [[timestamp]], 0),
(194, 1, 1, 'moodle/blog:search', 1, [[timestamp]], 0),
(195, 1, 1, 'moodle/blog:viewdrafts', 1, [[timestamp]], 0),
(196, 1, 7, 'moodle/blog:create', 1, [[timestamp]], 0),
(197, 1, 1, 'moodle/blog:create', 1, [[timestamp]], 0),
(198, 1, 4, 'moodle/blog:manageentries', 1, [[timestamp]], 0),
(199, 1, 3, 'moodle/blog:manageentries', 1, [[timestamp]], 0),
(200, 1, 1, 'moodle/blog:manageentries', 1, [[timestamp]], 0),
(201, 1, 5, 'moodle/blog:manageexternal', 1, [[timestamp]], 0),
(202, 1, 7, 'moodle/blog:manageexternal', 1, [[timestamp]], 0),
(203, 1, 4, 'moodle/blog:manageexternal', 1, [[timestamp]], 0),
(204, 1, 3, 'moodle/blog:manageexternal', 1, [[timestamp]], 0),
(205, 1, 1, 'moodle/blog:manageexternal', 1, [[timestamp]], 0),
(206, 1, 7, 'moodle/calendar:manageownentries', 1, [[timestamp]], 0),
(207, 1, 1, 'moodle/calendar:manageownentries', 1, [[timestamp]], 0),
(208, 1, 4, 'moodle/calendar:managegroupentries', 1, [[timestamp]], 0),
(209, 1, 3, 'moodle/calendar:managegroupentries', 1, [[timestamp]], 0),
(210, 1, 1, 'moodle/calendar:managegroupentries', 1, [[timestamp]], 0),
(211, 1, 4, 'moodle/calendar:manageentries', 1, [[timestamp]], 0),
(212, 1, 3, 'moodle/calendar:manageentries', 1, [[timestamp]], 0),
(213, 1, 1, 'moodle/calendar:manageentries', 1, [[timestamp]], 0),
(214, 1, 1, 'moodle/user:editprofile', 1, [[timestamp]], 0),
(215, 1, 6, 'moodle/user:editownprofile', -1000, [[timestamp]], 0),
(216, 1, 7, 'moodle/user:editownprofile', 1, [[timestamp]], 0),
(217, 1, 1, 'moodle/user:editownprofile', 1, [[timestamp]], 0),
(218, 1, 6, 'moodle/user:changeownpassword', -1000, [[timestamp]], 0),
(219, 1, 7, 'moodle/user:changeownpassword', 1, [[timestamp]], 0),
(220, 1, 1, 'moodle/user:changeownpassword', 1, [[timestamp]], 0),
(221, 1, 5, 'moodle/user:readuserposts', 1, [[timestamp]], 0),
(222, 1, 4, 'moodle/user:readuserposts', 1, [[timestamp]], 0),
(223, 1, 3, 'moodle/user:readuserposts', 1, [[timestamp]], 0),
(224, 1, 1, 'moodle/user:readuserposts', 1, [[timestamp]], 0),
(225, 1, 5, 'moodle/user:readuserblogs', 1, [[timestamp]], 0),
(226, 1, 4, 'moodle/user:readuserblogs', 1, [[timestamp]], 0),
(227, 1, 3, 'moodle/user:readuserblogs', 1, [[timestamp]], 0),
(228, 1, 1, 'moodle/user:readuserblogs', 1, [[timestamp]], 0),
(229, 1, 1, 'moodle/user:editmessageprofile', 1, [[timestamp]], 0),
(230, 1, 6, 'moodle/user:editownmessageprofile', -1000, [[timestamp]], 0),
(231, 1, 7, 'moodle/user:editownmessageprofile', 1, [[timestamp]], 0),
(232, 1, 1, 'moodle/user:editownmessageprofile', 1, [[timestamp]], 0),
(233, 1, 3, 'moodle/question:managecategory', 1, [[timestamp]], 0),
(234, 1, 1, 'moodle/question:managecategory', 1, [[timestamp]], 0),
(235, 1, 3, 'moodle/question:add', 1, [[timestamp]], 0),
(236, 1, 1, 'moodle/question:add', 1, [[timestamp]], 0),
(237, 1, 3, 'moodle/question:editmine', 1, [[timestamp]], 0),
(238, 1, 1, 'moodle/question:editmine', 1, [[timestamp]], 0),
(239, 1, 3, 'moodle/question:editall', 1, [[timestamp]], 0),
(240, 1, 1, 'moodle/question:editall', 1, [[timestamp]], 0),
(241, 1, 3, 'moodle/question:viewmine', 1, [[timestamp]], 0),
(242, 1, 1, 'moodle/question:viewmine', 1, [[timestamp]], 0),
(243, 1, 3, 'moodle/question:viewall', 1, [[timestamp]], 0),
(244, 1, 1, 'moodle/question:viewall', 1, [[timestamp]], 0),
(245, 1, 4, 'moodle/question:usemine', 1, [[timestamp]], 0),
(246, 1, 3, 'moodle/question:usemine', 1, [[timestamp]], 0),
(247, 1, 1, 'moodle/question:usemine', 1, [[timestamp]], 0),
(248, 1, 4, 'moodle/question:useall', 1, [[timestamp]], 0),
(249, 1, 3, 'moodle/question:useall', 1, [[timestamp]], 0),
(250, 1, 1, 'moodle/question:useall', 1, [[timestamp]], 0),
(251, 1, 3, 'moodle/question:movemine', 1, [[timestamp]], 0),
(252, 1, 1, 'moodle/question:movemine', 1, [[timestamp]], 0),
(253, 1, 3, 'moodle/question:moveall', 1, [[timestamp]], 0),
(254, 1, 1, 'moodle/question:moveall', 1, [[timestamp]], 0),
(255, 1, 1, 'moodle/question:config', 1, [[timestamp]], 0),
(256, 1, 5, 'moodle/question:flag', 1, [[timestamp]], 0),
(257, 1, 4, 'moodle/question:flag', 1, [[timestamp]], 0),
(258, 1, 3, 'moodle/question:flag', 1, [[timestamp]], 0),
(259, 1, 1, 'moodle/question:flag', 1, [[timestamp]], 0),
(260, 1, 3, 'moodle/question:tagmine', 1, [[timestamp]], 0),
(261, 1, 1, 'moodle/question:tagmine', 1, [[timestamp]], 0),
(262, 1, 3, 'moodle/question:tagall', 1, [[timestamp]], 0),
(263, 1, 1, 'moodle/question:tagall', 1, [[timestamp]], 0),
(264, 1, 4, 'moodle/site:doclinks', 1, [[timestamp]], 0),
(265, 1, 3, 'moodle/site:doclinks', 1, [[timestamp]], 0),
(266, 1, 1, 'moodle/site:doclinks', 1, [[timestamp]], 0),
(267, 1, 3, 'moodle/course:sectionvisibility', 1, [[timestamp]], 0),
(268, 1, 1, 'moodle/course:sectionvisibility', 1, [[timestamp]], 0),
(269, 1, 3, 'moodle/course:useremail', 1, [[timestamp]], 0),
(270, 1, 1, 'moodle/course:useremail', 1, [[timestamp]], 0),
(271, 1, 3, 'moodle/course:viewhiddensections', 1, [[timestamp]], 0),
(272, 1, 1, 'moodle/course:viewhiddensections', 1, [[timestamp]], 0),
(273, 1, 3, 'moodle/course:setcurrentsection', 1, [[timestamp]], 0),
(274, 1, 1, 'moodle/course:setcurrentsection', 1, [[timestamp]], 0),
(275, 1, 3, 'moodle/course:movesections', 1, [[timestamp]], 0),
(276, 1, 1, 'moodle/course:movesections', 1, [[timestamp]], 0),
(277, 1, 4, 'moodle/grade:viewall', 1, [[timestamp]], 0),
(278, 1, 3, 'moodle/grade:viewall', 1, [[timestamp]], 0),
(279, 1, 1, 'moodle/grade:viewall', 1, [[timestamp]], 0),
(280, 1, 5, 'moodle/grade:view', 1, [[timestamp]], 0),
(281, 1, 4, 'moodle/grade:viewhidden', 1, [[timestamp]], 0),
(282, 1, 3, 'moodle/grade:viewhidden', 1, [[timestamp]], 0),
(283, 1, 1, 'moodle/grade:viewhidden', 1, [[timestamp]], 0),
(284, 1, 3, 'moodle/grade:import', 1, [[timestamp]], 0),
(285, 1, 1, 'moodle/grade:import', 1, [[timestamp]], 0),
(286, 1, 4, 'moodle/grade:export', 1, [[timestamp]], 0),
(287, 1, 3, 'moodle/grade:export', 1, [[timestamp]], 0),
(288, 1, 1, 'moodle/grade:export', 1, [[timestamp]], 0),
(289, 1, 3, 'moodle/grade:manage', 1, [[timestamp]], 0),
(290, 1, 1, 'moodle/grade:manage', 1, [[timestamp]], 0),
(291, 1, 3, 'moodle/grade:edit', 1, [[timestamp]], 0),
(292, 1, 1, 'moodle/grade:edit', 1, [[timestamp]], 0),
(293, 1, 3, 'moodle/grade:managegradingforms', 1, [[timestamp]], 0),
(294, 1, 1, 'moodle/grade:managegradingforms', 1, [[timestamp]], 0),
(295, 1, 1, 'moodle/grade:sharegradingforms', 1, [[timestamp]], 0),
(296, 1, 1, 'moodle/grade:managesharedforms', 1, [[timestamp]], 0),
(297, 1, 3, 'moodle/grade:manageoutcomes', 1, [[timestamp]], 0),
(298, 1, 1, 'moodle/grade:manageoutcomes', 1, [[timestamp]], 0),
(299, 1, 3, 'moodle/grade:manageletters', 1, [[timestamp]], 0),
(300, 1, 1, 'moodle/grade:manageletters', 1, [[timestamp]], 0),
(301, 1, 3, 'moodle/grade:hide', 1, [[timestamp]], 0),
(302, 1, 1, 'moodle/grade:hide', 1, [[timestamp]], 0),
(303, 1, 3, 'moodle/grade:lock', 1, [[timestamp]], 0),
(304, 1, 1, 'moodle/grade:lock', 1, [[timestamp]], 0),
(305, 1, 3, 'moodle/grade:unlock', 1, [[timestamp]], 0),
(306, 1, 1, 'moodle/grade:unlock', 1, [[timestamp]], 0),
(307, 1, 7, 'moodle/my:manageblocks', 1, [[timestamp]], 0),
(308, 1, 4, 'moodle/notes:view', 1, [[timestamp]], 0),
(309, 1, 3, 'moodle/notes:view', 1, [[timestamp]], 0),
(310, 1, 1, 'moodle/notes:view', 1, [[timestamp]], 0),
(311, 1, 4, 'moodle/notes:manage', 1, [[timestamp]], 0),
(312, 1, 3, 'moodle/notes:manage', 1, [[timestamp]], 0),
(313, 1, 1, 'moodle/notes:manage', 1, [[timestamp]], 0),
(314, 1, 1, 'moodle/tag:manage', 1, [[timestamp]], 0),
(315, 1, 1, 'moodle/tag:edit', 1, [[timestamp]], 0),
(316, 1, 7, 'moodle/tag:flag', 1, [[timestamp]], 0),
(317, 1, 4, 'moodle/tag:editblocks', 1, [[timestamp]], 0),
(318, 1, 3, 'moodle/tag:editblocks', 1, [[timestamp]], 0),
(319, 1, 1, 'moodle/tag:editblocks', 1, [[timestamp]], 0),
(320, 1, 6, 'moodle/block:view', 1, [[timestamp]], 0),
(321, 1, 7, 'moodle/block:view', 1, [[timestamp]], 0),
(322, 1, 5, 'moodle/block:view', 1, [[timestamp]], 0),
(323, 1, 4, 'moodle/block:view', 1, [[timestamp]], 0),
(324, 1, 3, 'moodle/block:view', 1, [[timestamp]], 0),
(325, 1, 3, 'moodle/block:edit', 1, [[timestamp]], 0),
(326, 1, 1, 'moodle/block:edit', 1, [[timestamp]], 0),
(327, 1, 7, 'moodle/portfolio:export', 1, [[timestamp]], 0),
(328, 1, 5, 'moodle/portfolio:export', 1, [[timestamp]], 0),
(329, 1, 4, 'moodle/portfolio:export', 1, [[timestamp]], 0),
(330, 1, 3, 'moodle/portfolio:export', 1, [[timestamp]], 0),
(331, 1, 8, 'moodle/comment:view', 1, [[timestamp]], 0),
(332, 1, 6, 'moodle/comment:view', 1, [[timestamp]], 0),
(333, 1, 7, 'moodle/comment:view', 1, [[timestamp]], 0),
(334, 1, 5, 'moodle/comment:view', 1, [[timestamp]], 0),
(335, 1, 4, 'moodle/comment:view', 1, [[timestamp]], 0),
(336, 1, 3, 'moodle/comment:view', 1, [[timestamp]], 0),
(337, 1, 1, 'moodle/comment:view', 1, [[timestamp]], 0),
(338, 1, 7, 'moodle/comment:post', 1, [[timestamp]], 0),
(339, 1, 5, 'moodle/comment:post', 1, [[timestamp]], 0),
(340, 1, 4, 'moodle/comment:post', 1, [[timestamp]], 0),
(341, 1, 3, 'moodle/comment:post', 1, [[timestamp]], 0),
(342, 1, 1, 'moodle/comment:post', 1, [[timestamp]], 0),
(343, 1, 3, 'moodle/comment:delete', 1, [[timestamp]], 0),
(344, 1, 1, 'moodle/comment:delete', 1, [[timestamp]], 0),
(345, 1, 1, 'moodle/webservice:createtoken', 1, [[timestamp]], 0),
(346, 1, 7, 'moodle/webservice:createmobiletoken', 1, [[timestamp]], 0),
(347, 1, 7, 'moodle/rating:view', 1, [[timestamp]], 0),
(348, 1, 5, 'moodle/rating:view', 1, [[timestamp]], 0),
(349, 1, 4, 'moodle/rating:view', 1, [[timestamp]], 0),
(350, 1, 3, 'moodle/rating:view', 1, [[timestamp]], 0),
(351, 1, 1, 'moodle/rating:view', 1, [[timestamp]], 0),
(352, 1, 7, 'moodle/rating:viewany', 1, [[timestamp]], 0),
(353, 1, 5, 'moodle/rating:viewany', 1, [[timestamp]], 0),
(354, 1, 4, 'moodle/rating:viewany', 1, [[timestamp]], 0),
(355, 1, 3, 'moodle/rating:viewany', 1, [[timestamp]], 0),
(356, 1, 1, 'moodle/rating:viewany', 1, [[timestamp]], 0),
(357, 1, 7, 'moodle/rating:viewall', 1, [[timestamp]], 0),
(358, 1, 5, 'moodle/rating:viewall', 1, [[timestamp]], 0),
(359, 1, 4, 'moodle/rating:viewall', 1, [[timestamp]], 0),
(360, 1, 3, 'moodle/rating:viewall', 1, [[timestamp]], 0),
(361, 1, 1, 'moodle/rating:viewall', 1, [[timestamp]], 0),
(362, 1, 7, 'moodle/rating:rate', 1, [[timestamp]], 0),
(363, 1, 5, 'moodle/rating:rate', 1, [[timestamp]], 0),
(364, 1, 4, 'moodle/rating:rate', 1, [[timestamp]], 0),
(365, 1, 3, 'moodle/rating:rate', 1, [[timestamp]], 0),
(366, 1, 1, 'moodle/rating:rate', 1, [[timestamp]], 0),
(367, 1, 4, 'moodle/course:markcomplete', 1, [[timestamp]], 0),
(368, 1, 3, 'moodle/course:markcomplete', 1, [[timestamp]], 0),
(369, 1, 1, 'moodle/course:markcomplete', 1, [[timestamp]], 0),
(370, 1, 4, 'moodle/course:overridecompletion', 1, [[timestamp]], 0),
(371, 1, 3, 'moodle/course:overridecompletion', 1, [[timestamp]], 0),
(372, 1, 1, 'moodle/course:overridecompletion', 1, [[timestamp]], 0),
(373, 1, 1, 'moodle/badges:manageglobalsettings', 1, [[timestamp]], 0),
(374, 1, 7, 'moodle/badges:viewbadges', 1, [[timestamp]], 0),
(375, 1, 7, 'moodle/badges:manageownbadges', 1, [[timestamp]], 0),
(376, 1, 7, 'moodle/badges:viewotherbadges', 1, [[timestamp]], 0),
(377, 1, 7, 'moodle/badges:earnbadge', 1, [[timestamp]], 0),
(378, 1, 1, 'moodle/badges:createbadge', 1, [[timestamp]], 0),
(379, 1, 3, 'moodle/badges:createbadge', 1, [[timestamp]], 0),
(380, 1, 1, 'moodle/badges:deletebadge', 1, [[timestamp]], 0),
(381, 1, 3, 'moodle/badges:deletebadge', 1, [[timestamp]], 0),
(382, 1, 1, 'moodle/badges:configuredetails', 1, [[timestamp]], 0),
(383, 1, 3, 'moodle/badges:configuredetails', 1, [[timestamp]], 0),
(384, 1, 1, 'moodle/badges:configurecriteria', 1, [[timestamp]], 0),
(385, 1, 3, 'moodle/badges:configurecriteria', 1, [[timestamp]], 0),
(386, 1, 1, 'moodle/badges:configuremessages', 1, [[timestamp]], 0),
(387, 1, 3, 'moodle/badges:configuremessages', 1, [[timestamp]], 0),
(388, 1, 1, 'moodle/badges:awardbadge', 1, [[timestamp]], 0),
(389, 1, 4, 'moodle/badges:awardbadge', 1, [[timestamp]], 0),
(390, 1, 3, 'moodle/badges:awardbadge', 1, [[timestamp]], 0),
(391, 1, 1, 'moodle/badges:revokebadge', 1, [[timestamp]], 0),
(392, 1, 4, 'moodle/badges:revokebadge', 1, [[timestamp]], 0),
(393, 1, 3, 'moodle/badges:revokebadge', 1, [[timestamp]], 0),
(394, 1, 1, 'moodle/badges:viewawarded', 1, [[timestamp]], 0),
(395, 1, 4, 'moodle/badges:viewawarded', 1, [[timestamp]], 0),
(396, 1, 3, 'moodle/badges:viewawarded', 1, [[timestamp]], 0),
(397, 1, 6, 'moodle/search:query', 1, [[timestamp]], 0),
(398, 1, 7, 'moodle/search:query', 1, [[timestamp]], 0),
(399, 1, 5, 'moodle/search:query', 1, [[timestamp]], 0),
(400, 1, 4, 'moodle/search:query', 1, [[timestamp]], 0),
(401, 1, 3, 'moodle/search:query', 1, [[timestamp]], 0),
(402, 1, 1, 'moodle/search:query', 1, [[timestamp]], 0),
(403, 1, 1, 'moodle/competency:competencymanage', 1, [[timestamp]], 0),
(404, 1, 7, 'moodle/competency:competencyview', 1, [[timestamp]], 0),
(405, 1, 3, 'moodle/competency:competencygrade', 1, [[timestamp]], 0),
(406, 1, 4, 'moodle/competency:competencygrade', 1, [[timestamp]], 0),
(407, 1, 1, 'moodle/competency:competencygrade', 1, [[timestamp]], 0),
(408, 1, 3, 'moodle/competency:coursecompetencymanage', 1, [[timestamp]], 0),
(409, 1, 1, 'moodle/competency:coursecompetencymanage', 1, [[timestamp]], 0),
(410, 1, 1, 'moodle/competency:coursecompetencyconfigure', 1, [[timestamp]], 0),
(411, 1, 5, 'moodle/competency:coursecompetencygradable', 1, [[timestamp]], 0),
(412, 1, 7, 'moodle/competency:coursecompetencyview', 1, [[timestamp]], 0),
(413, 1, 1, 'moodle/competency:planmanage', 1, [[timestamp]], 0),
(414, 1, 1, 'moodle/competency:planmanagedraft', 1, [[timestamp]], 0),
(415, 1, 1, 'moodle/competency:planview', 1, [[timestamp]], 0),
(416, 1, 1, 'moodle/competency:planviewdraft', 1, [[timestamp]], 0),
(417, 1, 7, 'moodle/competency:planviewown', 1, [[timestamp]], 0),
(418, 1, 1, 'moodle/competency:planrequestreview', 1, [[timestamp]], 0),
(419, 1, 7, 'moodle/competency:planrequestreviewown', 1, [[timestamp]], 0),
(420, 1, 1, 'moodle/competency:planreview', 1, [[timestamp]], 0),
(421, 1, 1, 'moodle/competency:plancomment', 1, [[timestamp]], 0),
(422, 1, 7, 'moodle/competency:plancommentown', 1, [[timestamp]], 0),
(423, 1, 1, 'moodle/competency:usercompetencyview', 1, [[timestamp]], 0),
(424, 1, 3, 'moodle/competency:usercompetencyview', 1, [[timestamp]], 0),
(425, 1, 4, 'moodle/competency:usercompetencyview', 1, [[timestamp]], 0),
(426, 1, 1, 'moodle/competency:usercompetencyrequestreview', 1, [[timestamp]], 0),
(427, 1, 7, 'moodle/competency:usercompetencyrequestreviewown', 1, [[timestamp]], 0),
(428, 1, 1, 'moodle/competency:usercompetencyreview', 1, [[timestamp]], 0),
(429, 1, 1, 'moodle/competency:usercompetencycomment', 1, [[timestamp]], 0),
(430, 1, 7, 'moodle/competency:usercompetencycommentown', 1, [[timestamp]], 0),
(431, 1, 1, 'moodle/competency:templatemanage', 1, [[timestamp]], 0),
(432, 1, 4, 'moodle/analytics:listinsights', 1, [[timestamp]], 0),
(433, 1, 3, 'moodle/analytics:listinsights', 1, [[timestamp]], 0),
(434, 1, 1, 'moodle/analytics:listinsights', 1, [[timestamp]], 0),
(435, 1, 1, 'moodle/analytics:managemodels', 1, [[timestamp]], 0),
(436, 1, 1, 'moodle/competency:templateview', 1, [[timestamp]], 0),
(437, 1, 1, 'moodle/competency:userevidencemanage', 1, [[timestamp]], 0),
(438, 1, 7, 'moodle/competency:userevidencemanageown', 1, [[timestamp]], 0),
(439, 1, 1, 'moodle/competency:userevidenceview', 1, [[timestamp]], 0),
(440, 1, 4, 'moodle/site:messageanyuser', 1, [[timestamp]], 0),
(441, 1, 3, 'moodle/site:messageanyuser', 1, [[timestamp]], 0),
(442, 1, 1, 'moodle/site:messageanyuser', 1, [[timestamp]], 0),
(443, 1, 7, 'moodle/course:togglecompletion', 1, [[timestamp]], 0),
(444, 1, 7, 'moodle/analytics:listowninsights', 1, [[timestamp]], 0),
(445, 1, 3, 'moodle/h5p:setdisplayoptions', 1, [[timestamp]], 0),
(446, 1, 1, 'moodle/h5p:deploy', 1, [[timestamp]], 0),
(447, 1, 3, 'moodle/h5p:deploy', 1, [[timestamp]], 0),
(448, 1, 1, 'moodle/h5p:updatelibraries', 1, [[timestamp]], 0),
(449, 1, 1, 'moodle/course:recommendactivity', 1, [[timestamp]], 0),
(450, 1, 1, 'moodle/contentbank:access', 1, [[timestamp]], 0),
(451, 1, 2, 'moodle/contentbank:access', 1, [[timestamp]], 0),
(452, 1, 3, 'moodle/contentbank:access', 1, [[timestamp]], 0),
(453, 1, 1, 'moodle/contentbank:upload', 1, [[timestamp]], 0),
(454, 1, 2, 'moodle/contentbank:upload', 1, [[timestamp]], 0),
(455, 1, 3, 'moodle/contentbank:upload', 1, [[timestamp]], 0),
(456, 1, 1, 'moodle/contentbank:deleteanycontent', 1, [[timestamp]], 0),
(457, 1, 2, 'moodle/contentbank:deleteanycontent', 1, [[timestamp]], 0),
(458, 1, 7, 'moodle/contentbank:deleteowncontent', 1, [[timestamp]], 0),
(459, 1, 1, 'moodle/contentbank:manageanycontent', 1, [[timestamp]], 0),
(460, 1, 2, 'moodle/contentbank:manageanycontent', 1, [[timestamp]], 0),
(461, 1, 1, 'moodle/contentbank:manageowncontent', 1, [[timestamp]], 0),
(462, 1, 2, 'moodle/contentbank:manageowncontent', 1, [[timestamp]], 0),
(463, 1, 3, 'moodle/contentbank:manageowncontent', 1, [[timestamp]], 0),
(464, 1, 1, 'moodle/contentbank:useeditor', 1, [[timestamp]], 0),
(465, 1, 2, 'moodle/contentbank:useeditor', 1, [[timestamp]], 0),
(466, 1, 3, 'moodle/contentbank:useeditor', 1, [[timestamp]], 0),
(467, 1, 1, 'moodle/contentbank:downloadcontent', 1, [[timestamp]], 0),
(468, 1, 2, 'moodle/contentbank:downloadcontent', 1, [[timestamp]], 0),
(469, 1, 3, 'moodle/contentbank:downloadcontent', 1, [[timestamp]], 0),
(470, 1, 1, 'moodle/contentbank:copyanycontent', 1, [[timestamp]], 0),
(471, 1, 2, 'moodle/contentbank:copyanycontent', 1, [[timestamp]], 0),
(472, 1, 1, 'moodle/contentbank:copycontent', 1, [[timestamp]], 0),
(473, 1, 2, 'moodle/contentbank:copycontent', 1, [[timestamp]], 0),
(474, 1, 3, 'moodle/contentbank:copycontent', 1, [[timestamp]], 0),
(475, 1, 1, 'moodle/contentbank:configurecustomfields', 1, [[timestamp]], 0),
(476, 1, 1, 'moodle/contentbank:changelockedcustomfields', 1, [[timestamp]], 0),
(477, 1, 5, 'moodle/course:downloadcoursecontent', 1, [[timestamp]], 0),
(478, 1, 4, 'moodle/course:downloadcoursecontent', 1, [[timestamp]], 0),
(479, 1, 3, 'moodle/course:downloadcoursecontent', 1, [[timestamp]], 0),
(480, 1, 1, 'moodle/course:downloadcoursecontent', 1, [[timestamp]], 0),
(481, 1, 3, 'moodle/course:configuredownloadcontent', 1, [[timestamp]], 0),
(482, 1, 1, 'moodle/course:configuredownloadcontent', 1, [[timestamp]], 0),
(483, 1, 1, 'moodle/contentbank:viewunlistedcontent', 1, [[timestamp]], 0),
(484, 1, 2, 'moodle/contentbank:viewunlistedcontent', 1, [[timestamp]], 0),
(485, 1, 7, 'moodle/reportbuilder:view', 1, [[timestamp]], 0),
(486, 1, 1, 'moodle/reportbuilder:edit', 1, [[timestamp]], 0),
(487, 1, 3, 'moodle/moodlenet:shareactivity', 1, [[timestamp]], 0),
(488, 1, 1, 'moodle/moodlenet:shareactivity', 1, [[timestamp]], 0),
(489, 1, 3, 'moodle/course:configurecoursecommunication', 1, [[timestamp]], 0),
(490, 1, 1, 'moodle/course:configurecoursecommunication', 1, [[timestamp]], 0),
(491, 1, 3, 'moodle/moodlenet:sharecourse', 1, [[timestamp]], 0),
(492, 1, 1, 'moodle/moodlenet:sharecourse', 1, [[timestamp]], 0),
(493, 1, 3, 'moodle/course:editcoursewelcomemessage', 1, [[timestamp]], 0),
(494, 1, 1, 'moodle/course:editcoursewelcomemessage', 1, [[timestamp]], 0),
(495, 1, 7, 'moodle/ai:fetchanyuserpolicystatus', 1, [[timestamp]], 0),
(496, 1, 7, 'moodle/ai:acceptpolicy', 1, [[timestamp]], 0),
(497, 1, 7, 'moodle/ai:fetchpolicy', 1, [[timestamp]], 0),
(498, 1, 1, 'moodle/ai:viewaipolicyacceptancereport', 1, [[timestamp]], 0),
(499, 1, 1, 'moodle/ai:viewaiusagereport', 1, [[timestamp]], 0),
(500, 1, 1, 'aiplacement/courseassist:summarise_text', 1, [[timestamp]], 0),
(501, 1, 3, 'aiplacement/courseassist:summarise_text', 1, [[timestamp]], 0),
(502, 1, 4, 'aiplacement/courseassist:summarise_text', 1, [[timestamp]], 0),
(503, 1, 5, 'aiplacement/courseassist:summarise_text', 1, [[timestamp]], 0),
(504, 1, 1, 'aiplacement/courseassist:explain_text', 1, [[timestamp]], 0),
(505, 1, 3, 'aiplacement/courseassist:explain_text', 1, [[timestamp]], 0),
(506, 1, 4, 'aiplacement/courseassist:explain_text', 1, [[timestamp]], 0),
(507, 1, 5, 'aiplacement/courseassist:explain_text', 1, [[timestamp]], 0),
(508, 1, 1, 'aiplacement/editor:generate_image', 1, [[timestamp]], 0),
(509, 1, 3, 'aiplacement/editor:generate_image', 1, [[timestamp]], 0),
(510, 1, 4, 'aiplacement/editor:generate_image', 1, [[timestamp]], 0),
(511, 1, 5, 'aiplacement/editor:generate_image', 1, [[timestamp]], 0),
(512, 1, 1, 'aiplacement/editor:generate_text', 1, [[timestamp]], 0),
(513, 1, 3, 'aiplacement/editor:generate_text', 1, [[timestamp]], 0),
(514, 1, 4, 'aiplacement/editor:generate_text', 1, [[timestamp]], 0),
(515, 1, 5, 'aiplacement/editor:generate_text', 1, [[timestamp]], 0),
(516, 1, 6, 'mod/assign:view', 1, [[timestamp]], 0),
(517, 1, 5, 'mod/assign:view', 1, [[timestamp]], 0),
(518, 1, 4, 'mod/assign:view', 1, [[timestamp]], 0),
(519, 1, 3, 'mod/assign:view', 1, [[timestamp]], 0),
(520, 1, 1, 'mod/assign:view', 1, [[timestamp]], 0),
(521, 1, 5, 'mod/assign:submit', 1, [[timestamp]], 0),
(522, 1, 4, 'mod/assign:grade', 1, [[timestamp]], 0),
(523, 1, 3, 'mod/assign:grade', 1, [[timestamp]], 0),
(524, 1, 1, 'mod/assign:grade', 1, [[timestamp]], 0),
(525, 1, 4, 'mod/assign:exportownsubmission', 1, [[timestamp]], 0),
(526, 1, 3, 'mod/assign:exportownsubmission', 1, [[timestamp]], 0),
(527, 1, 1, 'mod/assign:exportownsubmission', 1, [[timestamp]], 0),
(528, 1, 5, 'mod/assign:exportownsubmission', 1, [[timestamp]], 0),
(529, 1, 3, 'mod/assign:addinstance', 1, [[timestamp]], 0),
(530, 1, 1, 'mod/assign:addinstance', 1, [[timestamp]], 0),
(531, 1, 4, 'mod/assign:grantextension', 1, [[timestamp]], 0),
(532, 1, 3, 'mod/assign:grantextension', 1, [[timestamp]], 0),
(533, 1, 1, 'mod/assign:grantextension', 1, [[timestamp]], 0),
(534, 1, 3, 'mod/assign:revealidentities', 1, [[timestamp]], 0),
(535, 1, 1, 'mod/assign:revealidentities', 1, [[timestamp]], 0),
(536, 1, 3, 'mod/assign:reviewgrades', 1, [[timestamp]], 0),
(537, 1, 1, 'mod/assign:reviewgrades', 1, [[timestamp]], 0),
(538, 1, 3, 'mod/assign:releasegrades', 1, [[timestamp]], 0),
(539, 1, 1, 'mod/assign:releasegrades', 1, [[timestamp]], 0),
(540, 1, 3, 'mod/assign:managegrades', 1, [[timestamp]], 0),
(541, 1, 1, 'mod/assign:managegrades', 1, [[timestamp]], 0),
(542, 1, 3, 'mod/assign:manageallocations', 1, [[timestamp]], 0),
(543, 1, 1, 'mod/assign:manageallocations', 1, [[timestamp]], 0),
(544, 1, 3, 'mod/assign:viewgrades', 1, [[timestamp]], 0),
(545, 1, 1, 'mod/assign:viewgrades', 1, [[timestamp]], 0),
(546, 1, 4, 'mod/assign:viewgrades', 1, [[timestamp]], 0),
(547, 1, 1, 'mod/assign:viewblinddetails', 1, [[timestamp]], 0),
(548, 1, 4, 'mod/assign:receivegradernotifications', 1, [[timestamp]], 0),
(549, 1, 3, 'mod/assign:receivegradernotifications', 1, [[timestamp]], 0),
(550, 1, 1, 'mod/assign:receivegradernotifications', 1, [[timestamp]], 0),
(551, 1, 3, 'mod/assign:manageoverrides', 1, [[timestamp]], 0),
(552, 1, 1, 'mod/assign:manageoverrides', 1, [[timestamp]], 0),
(553, 1, 4, 'mod/assign:showhiddengrader', 1, [[timestamp]], 0),
(554, 1, 3, 'mod/assign:showhiddengrader', 1, [[timestamp]], 0),
(555, 1, 1, 'mod/assign:showhiddengrader', 1, [[timestamp]], 0),
(556, 1, 5, 'mod/assign:viewownsubmissionsummary', 1, [[timestamp]], 0),
(557, 1, 3, 'mod/bigbluebuttonbn:addinstance', 1, [[timestamp]], 0),
(558, 1, 1, 'mod/bigbluebuttonbn:addinstance', 1, [[timestamp]], 0),
(559, 1, 3, 'mod/bigbluebuttonbn:addinstancewithmeeting', 1, [[timestamp]], 0),
(560, 1, 1, 'mod/bigbluebuttonbn:addinstancewithmeeting', 1, [[timestamp]], 0),
(561, 1, 3, 'mod/bigbluebuttonbn:addinstancewithrecording', 1, [[timestamp]], 0),
(562, 1, 1, 'mod/bigbluebuttonbn:addinstancewithrecording', 1, [[timestamp]], 0),
(563, 1, 1, 'mod/bigbluebuttonbn:join', 1, [[timestamp]], 0),
(564, 1, 3, 'mod/bigbluebuttonbn:join', 1, [[timestamp]], 0),
(565, 1, 4, 'mod/bigbluebuttonbn:join', 1, [[timestamp]], 0),
(566, 1, 5, 'mod/bigbluebuttonbn:join', 1, [[timestamp]], 0),
(567, 1, 6, 'mod/bigbluebuttonbn:join', 1, [[timestamp]], 0),
(568, 1, 5, 'mod/bigbluebuttonbn:view', 1, [[timestamp]], 0),
(569, 1, 4, 'mod/bigbluebuttonbn:view', 1, [[timestamp]], 0),
(570, 1, 3, 'mod/bigbluebuttonbn:view', 1, [[timestamp]], 0),
(571, 1, 1, 'mod/bigbluebuttonbn:view', 1, [[timestamp]], 0),
(572, 1, 1, 'mod/bigbluebuttonbn:managerecordings', 1, [[timestamp]], 0),
(573, 1, 3, 'mod/bigbluebuttonbn:managerecordings', 1, [[timestamp]], 0),
(574, 1, 1, 'mod/bigbluebuttonbn:viewallrecordingformats', 1, [[timestamp]], 0),
(575, 1, 3, 'mod/bigbluebuttonbn:viewallrecordingformats', 1, [[timestamp]], 0),
(576, 1, 1, 'mod/bigbluebuttonbn:publishrecordings', 1, [[timestamp]], 0),
(577, 1, 3, 'mod/bigbluebuttonbn:publishrecordings', 1, [[timestamp]], 0),
(578, 1, 1, 'mod/bigbluebuttonbn:unpublishrecordings', 1, [[timestamp]], 0),
(579, 1, 3, 'mod/bigbluebuttonbn:unpublishrecordings', 1, [[timestamp]], 0),
(580, 1, 1, 'mod/bigbluebuttonbn:protectrecordings', 1, [[timestamp]], 0),
(581, 1, 3, 'mod/bigbluebuttonbn:protectrecordings', 1, [[timestamp]], 0),
(582, 1, 1, 'mod/bigbluebuttonbn:unprotectrecordings', 1, [[timestamp]], 0),
(583, 1, 3, 'mod/bigbluebuttonbn:unprotectrecordings', 1, [[timestamp]], 0),
(584, 1, 1, 'mod/bigbluebuttonbn:deleterecordings', 1, [[timestamp]], 0),
(585, 1, 3, 'mod/bigbluebuttonbn:deleterecordings', 1, [[timestamp]], 0),
(586, 1, 1, 'mod/bigbluebuttonbn:importrecordings', 1, [[timestamp]], 0),
(587, 1, 3, 'mod/bigbluebuttonbn:importrecordings', 1, [[timestamp]], 0),
(588, 1, 1, 'mod/bigbluebuttonbn:seepresentation', 1, [[timestamp]], 0),
(589, 1, 4, 'mod/bigbluebuttonbn:seepresentation', 1, [[timestamp]], 0),
(590, 1, 3, 'mod/bigbluebuttonbn:seepresentation', 1, [[timestamp]], 0),
(591, 1, 3, 'mod/book:addinstance', 1, [[timestamp]], 0),
(592, 1, 1, 'mod/book:addinstance', 1, [[timestamp]], 0),
(593, 1, 6, 'mod/book:read', 1, [[timestamp]], 0),
(594, 1, 8, 'mod/book:read', 1, [[timestamp]], 0),
(595, 1, 5, 'mod/book:read', 1, [[timestamp]], 0),
(596, 1, 4, 'mod/book:read', 1, [[timestamp]], 0),
(597, 1, 3, 'mod/book:read', 1, [[timestamp]], 0),
(598, 1, 1, 'mod/book:read', 1, [[timestamp]], 0),
(599, 1, 4, 'mod/book:viewhiddenchapters', 1, [[timestamp]], 0),
(600, 1, 3, 'mod/book:viewhiddenchapters', 1, [[timestamp]], 0),
(601, 1, 1, 'mod/book:viewhiddenchapters', 1, [[timestamp]], 0),
(602, 1, 3, 'mod/book:edit', 1, [[timestamp]], 0),
(603, 1, 1, 'mod/book:edit', 1, [[timestamp]], 0),
(604, 1, 3, 'mod/choice:addinstance', 1, [[timestamp]], 0),
(605, 1, 1, 'mod/choice:addinstance', 1, [[timestamp]], 0),
(606, 1, 5, 'mod/choice:choose', 1, [[timestamp]], 0),
(607, 1, 4, 'mod/choice:choose', 1, [[timestamp]], 0),
(608, 1, 3, 'mod/choice:choose', 1, [[timestamp]], 0),
(609, 1, 4, 'mod/choice:readresponses', 1, [[timestamp]], 0),
(610, 1, 3, 'mod/choice:readresponses', 1, [[timestamp]], 0),
(611, 1, 1, 'mod/choice:readresponses', 1, [[timestamp]], 0),
(612, 1, 4, 'mod/choice:deleteresponses', 1, [[timestamp]], 0),
(613, 1, 3, 'mod/choice:deleteresponses', 1, [[timestamp]], 0),
(614, 1, 1, 'mod/choice:deleteresponses', 1, [[timestamp]], 0),
(615, 1, 4, 'mod/choice:downloadresponses', 1, [[timestamp]], 0),
(616, 1, 3, 'mod/choice:downloadresponses', 1, [[timestamp]], 0),
(617, 1, 1, 'mod/choice:downloadresponses', 1, [[timestamp]], 0),
(618, 1, 7, 'mod/choice:view', 1, [[timestamp]], 0),
(619, 1, 6, 'mod/choice:view', 1, [[timestamp]], 0),
(620, 1, 3, 'mod/data:addinstance', 1, [[timestamp]], 0),
(621, 1, 1, 'mod/data:addinstance', 1, [[timestamp]], 0),
(622, 1, 8, 'mod/data:viewentry', 1, [[timestamp]], 0),
(623, 1, 6, 'mod/data:viewentry', 1, [[timestamp]], 0),
(624, 1, 5, 'mod/data:viewentry', 1, [[timestamp]], 0),
(625, 1, 4, 'mod/data:viewentry', 1, [[timestamp]], 0),
(626, 1, 3, 'mod/data:viewentry', 1, [[timestamp]], 0),
(627, 1, 1, 'mod/data:viewentry', 1, [[timestamp]], 0),
(628, 1, 5, 'mod/data:writeentry', 1, [[timestamp]], 0),
(629, 1, 4, 'mod/data:writeentry', 1, [[timestamp]], 0),
(630, 1, 3, 'mod/data:writeentry', 1, [[timestamp]], 0),
(631, 1, 1, 'mod/data:writeentry', 1, [[timestamp]], 0),
(632, 1, 4, 'mod/data:rate', 1, [[timestamp]], 0),
(633, 1, 3, 'mod/data:rate', 1, [[timestamp]], 0),
(634, 1, 1, 'mod/data:rate', 1, [[timestamp]], 0),
(635, 1, 4, 'mod/data:viewrating', 1, [[timestamp]], 0),
(636, 1, 3, 'mod/data:viewrating', 1, [[timestamp]], 0),
(637, 1, 1, 'mod/data:viewrating', 1, [[timestamp]], 0),
(638, 1, 4, 'mod/data:viewanyrating', 1, [[timestamp]], 0),
(639, 1, 3, 'mod/data:viewanyrating', 1, [[timestamp]], 0),
(640, 1, 1, 'mod/data:viewanyrating', 1, [[timestamp]], 0),
(641, 1, 4, 'mod/data:viewallratings', 1, [[timestamp]], 0),
(642, 1, 3, 'mod/data:viewallratings', 1, [[timestamp]], 0),
(643, 1, 1, 'mod/data:viewallratings', 1, [[timestamp]], 0),
(644, 1, 4, 'mod/data:approve', 1, [[timestamp]], 0),
(645, 1, 3, 'mod/data:approve', 1, [[timestamp]], 0),
(646, 1, 1, 'mod/data:approve', 1, [[timestamp]], 0),
(647, 1, 4, 'mod/data:manageentries', 1, [[timestamp]], 0),
(648, 1, 3, 'mod/data:manageentries', 1, [[timestamp]], 0),
(649, 1, 1, 'mod/data:manageentries', 1, [[timestamp]], 0),
(650, 1, 3, 'mod/data:managetemplates', 1, [[timestamp]], 0),
(651, 1, 1, 'mod/data:managetemplates', 1, [[timestamp]], 0),
(652, 1, 4, 'mod/data:viewalluserpresets', 1, [[timestamp]], 0),
(653, 1, 3, 'mod/data:viewalluserpresets', 1, [[timestamp]], 0),
(654, 1, 1, 'mod/data:viewalluserpresets', 1, [[timestamp]], 0),
(655, 1, 1, 'mod/data:manageuserpresets', 1, [[timestamp]], 0),
(656, 1, 1, 'mod/data:exportentry', 1, [[timestamp]], 0),
(657, 1, 4, 'mod/data:exportentry', 1, [[timestamp]], 0),
(658, 1, 3, 'mod/data:exportentry', 1, [[timestamp]], 0),
(659, 1, 1, 'mod/data:exportownentry', 1, [[timestamp]], 0),
(660, 1, 4, 'mod/data:exportownentry', 1, [[timestamp]], 0),
(661, 1, 3, 'mod/data:exportownentry', 1, [[timestamp]], 0),
(662, 1, 5, 'mod/data:exportownentry', 1, [[timestamp]], 0),
(663, 1, 1, 'mod/data:exportallentries', 1, [[timestamp]], 0),
(664, 1, 4, 'mod/data:exportallentries', 1, [[timestamp]], 0),
(665, 1, 3, 'mod/data:exportallentries', 1, [[timestamp]], 0),
(666, 1, 1, 'mod/data:exportuserinfo', 1, [[timestamp]], 0),
(667, 1, 4, 'mod/data:exportuserinfo', 1, [[timestamp]], 0),
(668, 1, 3, 'mod/data:exportuserinfo', 1, [[timestamp]], 0),
(669, 1, 6, 'mod/data:view', 1, [[timestamp]], 0),
(670, 1, 5, 'mod/data:view', 1, [[timestamp]], 0),
(671, 1, 4, 'mod/data:view', 1, [[timestamp]], 0),
(672, 1, 3, 'mod/data:view', 1, [[timestamp]], 0),
(673, 1, 1, 'mod/data:view', 1, [[timestamp]], 0),
(674, 1, 3, 'mod/feedback:addinstance', 1, [[timestamp]], 0),
(675, 1, 1, 'mod/feedback:addinstance', 1, [[timestamp]], 0),
(676, 1, 6, 'mod/feedback:view', 1, [[timestamp]], 0),
(677, 1, 8, 'mod/feedback:view', 1, [[timestamp]], 0),
(678, 1, 5, 'mod/feedback:view', 1, [[timestamp]], 0),
(679, 1, 4, 'mod/feedback:view', 1, [[timestamp]], 0),
(680, 1, 3, 'mod/feedback:view', 1, [[timestamp]], 0),
(681, 1, 1, 'mod/feedback:view', 1, [[timestamp]], 0),
(682, 1, 8, 'mod/feedback:complete', 1, [[timestamp]], 0),
(683, 1, 5, 'mod/feedback:complete', 1, [[timestamp]], 0),
(684, 1, 5, 'mod/feedback:viewanalysepage', 1, [[timestamp]], 0),
(685, 1, 3, 'mod/feedback:viewanalysepage', 1, [[timestamp]], 0),
(686, 1, 1, 'mod/feedback:viewanalysepage', 1, [[timestamp]], 0),
(687, 1, 3, 'mod/feedback:deletesubmissions', 1, [[timestamp]], 0),
(688, 1, 1, 'mod/feedback:deletesubmissions', 1, [[timestamp]], 0),
(689, 1, 1, 'mod/feedback:mapcourse', 1, [[timestamp]], 0),
(690, 1, 3, 'mod/feedback:edititems', 1, [[timestamp]], 0),
(691, 1, 1, 'mod/feedback:edititems', 1, [[timestamp]], 0),
(692, 1, 3, 'mod/feedback:createprivatetemplate', 1, [[timestamp]], 0),
(693, 1, 1, 'mod/feedback:createprivatetemplate', 1, [[timestamp]], 0),
(694, 1, 3, 'mod/feedback:createpublictemplate', 1, [[timestamp]], 0),
(695, 1, 1, 'mod/feedback:createpublictemplate', 1, [[timestamp]], 0),
(696, 1, 3, 'mod/feedback:deletetemplate', 1, [[timestamp]], 0),
(697, 1, 1, 'mod/feedback:deletetemplate', 1, [[timestamp]], 0),
(698, 1, 4, 'mod/feedback:viewreports', 1, [[timestamp]], 0),
(699, 1, 3, 'mod/feedback:viewreports', 1, [[timestamp]], 0),
(700, 1, 1, 'mod/feedback:viewreports', 1, [[timestamp]], 0),
(701, 1, 4, 'mod/feedback:receivemail', 1, [[timestamp]], 0),
(702, 1, 3, 'mod/feedback:receivemail', 1, [[timestamp]], 0),
(703, 1, 3, 'mod/folder:addinstance', 1, [[timestamp]], 0),
(704, 1, 1, 'mod/folder:addinstance', 1, [[timestamp]], 0),
(705, 1, 6, 'mod/folder:view', 1, [[timestamp]], 0),
(706, 1, 7, 'mod/folder:view', 1, [[timestamp]], 0),
(707, 1, 3, 'mod/folder:managefiles', 1, [[timestamp]], 0),
(708, 1, 3, 'mod/forum:addinstance', 1, [[timestamp]], 0),
(709, 1, 1, 'mod/forum:addinstance', 1, [[timestamp]], 0),
(710, 1, 8, 'mod/forum:viewdiscussion', 1, [[timestamp]], 0),
(711, 1, 6, 'mod/forum:viewdiscussion', 1, [[timestamp]], 0),
(712, 1, 5, 'mod/forum:viewdiscussion', 1, [[timestamp]], 0),
(713, 1, 4, 'mod/forum:viewdiscussion', 1, [[timestamp]], 0),
(714, 1, 3, 'mod/forum:viewdiscussion', 1, [[timestamp]], 0),
(715, 1, 1, 'mod/forum:viewdiscussion', 1, [[timestamp]], 0),
(716, 1, 4, 'mod/forum:viewhiddentimedposts', 1, [[timestamp]], 0),
(717, 1, 3, 'mod/forum:viewhiddentimedposts', 1, [[timestamp]], 0),
(718, 1, 1, 'mod/forum:viewhiddentimedposts', 1, [[timestamp]], 0),
(719, 1, 5, 'mod/forum:startdiscussion', 1, [[timestamp]], 0),
(720, 1, 4, 'mod/forum:startdiscussion', 1, [[timestamp]], 0),
(721, 1, 3, 'mod/forum:startdiscussion', 1, [[timestamp]], 0),
(722, 1, 1, 'mod/forum:startdiscussion', 1, [[timestamp]], 0),
(723, 1, 5, 'mod/forum:replypost', 1, [[timestamp]], 0),
(724, 1, 4, 'mod/forum:replypost', 1, [[timestamp]], 0),
(725, 1, 3, 'mod/forum:replypost', 1, [[timestamp]], 0),
(726, 1, 1, 'mod/forum:replypost', 1, [[timestamp]], 0),
(727, 1, 4, 'mod/forum:addnews', 1, [[timestamp]], 0),
(728, 1, 3, 'mod/forum:addnews', 1, [[timestamp]], 0),
(729, 1, 1, 'mod/forum:addnews', 1, [[timestamp]], 0),
(730, 1, 4, 'mod/forum:replynews', 1, [[timestamp]], 0),
(731, 1, 3, 'mod/forum:replynews', 1, [[timestamp]], 0),
(732, 1, 1, 'mod/forum:replynews', 1, [[timestamp]], 0),
(733, 1, 5, 'mod/forum:viewrating', 1, [[timestamp]], 0),
(734, 1, 4, 'mod/forum:viewrating', 1, [[timestamp]], 0),
(735, 1, 3, 'mod/forum:viewrating', 1, [[timestamp]], 0),
(736, 1, 1, 'mod/forum:viewrating', 1, [[timestamp]], 0),
(737, 1, 4, 'mod/forum:viewanyrating', 1, [[timestamp]], 0),
(738, 1, 3, 'mod/forum:viewanyrating', 1, [[timestamp]], 0),
(739, 1, 1, 'mod/forum:viewanyrating', 1, [[timestamp]], 0),
(740, 1, 4, 'mod/forum:viewallratings', 1, [[timestamp]], 0),
(741, 1, 3, 'mod/forum:viewallratings', 1, [[timestamp]], 0),
(742, 1, 1, 'mod/forum:viewallratings', 1, [[timestamp]], 0),
(743, 1, 4, 'mod/forum:rate', 1, [[timestamp]], 0),
(744, 1, 3, 'mod/forum:rate', 1, [[timestamp]], 0),
(745, 1, 1, 'mod/forum:rate', 1, [[timestamp]], 0),
(746, 1, 4, 'mod/forum:postprivatereply', 1, [[timestamp]], 0),
(747, 1, 3, 'mod/forum:postprivatereply', 1, [[timestamp]], 0),
(748, 1, 1, 'mod/forum:postprivatereply', 1, [[timestamp]], 0),
(749, 1, 4, 'mod/forum:readprivatereplies', 1, [[timestamp]], 0),
(750, 1, 3, 'mod/forum:readprivatereplies', 1, [[timestamp]], 0),
(751, 1, 1, 'mod/forum:readprivatereplies', 1, [[timestamp]], 0),
(752, 1, 5, 'mod/forum:createattachment', 1, [[timestamp]], 0),
(753, 1, 4, 'mod/forum:createattachment', 1, [[timestamp]], 0),
(754, 1, 3, 'mod/forum:createattachment', 1, [[timestamp]], 0),
(755, 1, 1, 'mod/forum:createattachment', 1, [[timestamp]], 0),
(756, 1, 5, 'mod/forum:deleteownpost', 1, [[timestamp]], 0),
(757, 1, 4, 'mod/forum:deleteownpost', 1, [[timestamp]], 0),
(758, 1, 3, 'mod/forum:deleteownpost', 1, [[timestamp]], 0),
(759, 1, 1, 'mod/forum:deleteownpost', 1, [[timestamp]], 0),
(760, 1, 4, 'mod/forum:deleteanypost', 1, [[timestamp]], 0),
(761, 1, 3, 'mod/forum:deleteanypost', 1, [[timestamp]], 0),
(762, 1, 1, 'mod/forum:deleteanypost', 1, [[timestamp]], 0),
(763, 1, 4, 'mod/forum:splitdiscussions', 1, [[timestamp]], 0),
(764, 1, 3, 'mod/forum:splitdiscussions', 1, [[timestamp]], 0),
(765, 1, 1, 'mod/forum:splitdiscussions', 1, [[timestamp]], 0),
(766, 1, 4, 'mod/forum:movediscussions', 1, [[timestamp]], 0),
(767, 1, 3, 'mod/forum:movediscussions', 1, [[timestamp]], 0),
(768, 1, 1, 'mod/forum:movediscussions', 1, [[timestamp]], 0),
(769, 1, 4, 'mod/forum:pindiscussions', 1, [[timestamp]], 0),
(770, 1, 3, 'mod/forum:pindiscussions', 1, [[timestamp]], 0),
(771, 1, 1, 'mod/forum:pindiscussions', 1, [[timestamp]], 0),
(772, 1, 4, 'mod/forum:editanypost', 1, [[timestamp]], 0),
(773, 1, 3, 'mod/forum:editanypost', 1, [[timestamp]], 0),
(774, 1, 1, 'mod/forum:editanypost', 1, [[timestamp]], 0),
(775, 1, 4, 'mod/forum:viewqandawithoutposting', 1, [[timestamp]], 0),
(776, 1, 3, 'mod/forum:viewqandawithoutposting', 1, [[timestamp]], 0),
(777, 1, 1, 'mod/forum:viewqandawithoutposting', 1, [[timestamp]], 0),
(778, 1, 4, 'mod/forum:viewsubscribers', 1, [[timestamp]], 0),
(779, 1, 3, 'mod/forum:viewsubscribers', 1, [[timestamp]], 0),
(780, 1, 1, 'mod/forum:viewsubscribers', 1, [[timestamp]], 0),
(781, 1, 4, 'mod/forum:managesubscriptions', 1, [[timestamp]], 0),
(782, 1, 3, 'mod/forum:managesubscriptions', 1, [[timestamp]], 0),
(783, 1, 1, 'mod/forum:managesubscriptions', 1, [[timestamp]], 0),
(784, 1, 4, 'mod/forum:postwithoutthrottling', 1, [[timestamp]], 0),
(785, 1, 3, 'mod/forum:postwithoutthrottling', 1, [[timestamp]], 0),
(786, 1, 1, 'mod/forum:postwithoutthrottling', 1, [[timestamp]], 0),
(787, 1, 4, 'mod/forum:exportdiscussion', 1, [[timestamp]], 0),
(788, 1, 3, 'mod/forum:exportdiscussion', 1, [[timestamp]], 0),
(789, 1, 1, 'mod/forum:exportdiscussion', 1, [[timestamp]], 0),
(790, 1, 4, 'mod/forum:exportforum', 1, [[timestamp]], 0),
(791, 1, 3, 'mod/forum:exportforum', 1, [[timestamp]], 0),
(792, 1, 1, 'mod/forum:exportforum', 1, [[timestamp]], 0),
(793, 1, 4, 'mod/forum:exportpost', 1, [[timestamp]], 0),
(794, 1, 3, 'mod/forum:exportpost', 1, [[timestamp]], 0),
(795, 1, 1, 'mod/forum:exportpost', 1, [[timestamp]], 0),
(796, 1, 4, 'mod/forum:exportownpost', 1, [[timestamp]], 0),
(797, 1, 3, 'mod/forum:exportownpost', 1, [[timestamp]], 0),
(798, 1, 1, 'mod/forum:exportownpost', 1, [[timestamp]], 0),
(799, 1, 5, 'mod/forum:exportownpost', 1, [[timestamp]], 0),
(800, 1, 4, 'mod/forum:addquestion', 1, [[timestamp]], 0),
(801, 1, 3, 'mod/forum:addquestion', 1, [[timestamp]], 0),
(802, 1, 1, 'mod/forum:addquestion', 1, [[timestamp]], 0),
(803, 1, 5, 'mod/forum:allowforcesubscribe', 1, [[timestamp]], 0),
(804, 1, 4, 'mod/forum:allowforcesubscribe', 1, [[timestamp]], 0),
(805, 1, 3, 'mod/forum:allowforcesubscribe', 1, [[timestamp]], 0),
(806, 1, 8, 'mod/forum:allowforcesubscribe', 1, [[timestamp]], 0),
(807, 1, 4, 'mod/forum:canposttomygroups', 1, [[timestamp]], 0),
(808, 1, 3, 'mod/forum:canposttomygroups', 1, [[timestamp]], 0),
(809, 1, 1, 'mod/forum:canposttomygroups', 1, [[timestamp]], 0),
(810, 1, 4, 'mod/forum:canoverridediscussionlock', 1, [[timestamp]], 0),
(811, 1, 3, 'mod/forum:canoverridediscussionlock', 1, [[timestamp]], 0),
(812, 1, 1, 'mod/forum:canoverridediscussionlock', 1, [[timestamp]], 0),
(813, 1, 4, 'mod/forum:canoverridecutoff', 1, [[timestamp]], 0),
(814, 1, 3, 'mod/forum:canoverridecutoff', 1, [[timestamp]], 0),
(815, 1, 1, 'mod/forum:canoverridecutoff', 1, [[timestamp]], 0),
(816, 1, 7, 'mod/forum:cantogglefavourite', 1, [[timestamp]], 0),
(817, 1, 4, 'mod/forum:grade', 1, [[timestamp]], 0),
(818, 1, 3, 'mod/forum:grade', 1, [[timestamp]], 0),
(819, 1, 1, 'mod/forum:grade', 1, [[timestamp]], 0),
(820, 1, 5, 'mod/forum:canmailnow', 1, [[timestamp]], 0),
(821, 1, 4, 'mod/forum:canmailnow', 1, [[timestamp]], 0),
(822, 1, 3, 'mod/forum:canmailnow', 1, [[timestamp]], 0),
(823, 1, 1, 'mod/forum:canmailnow', 1, [[timestamp]], 0),
(824, 1, 3, 'mod/glossary:addinstance', 1, [[timestamp]], 0),
(825, 1, 1, 'mod/glossary:addinstance', 1, [[timestamp]], 0),
(826, 1, 8, 'mod/glossary:view', 1, [[timestamp]], 0),
(827, 1, 6, 'mod/glossary:view', 1, [[timestamp]], 0),
(828, 1, 5, 'mod/glossary:view', 1, [[timestamp]], 0),
(829, 1, 4, 'mod/glossary:view', 1, [[timestamp]], 0),
(830, 1, 3, 'mod/glossary:view', 1, [[timestamp]], 0),
(831, 1, 1, 'mod/glossary:view', 1, [[timestamp]], 0),
(832, 1, 5, 'mod/glossary:write', 1, [[timestamp]], 0),
(833, 1, 4, 'mod/glossary:write', 1, [[timestamp]], 0),
(834, 1, 3, 'mod/glossary:write', 1, [[timestamp]], 0),
(835, 1, 1, 'mod/glossary:write', 1, [[timestamp]], 0),
(836, 1, 4, 'mod/glossary:manageentries', 1, [[timestamp]], 0),
(837, 1, 3, 'mod/glossary:manageentries', 1, [[timestamp]], 0),
(838, 1, 1, 'mod/glossary:manageentries', 1, [[timestamp]], 0),
(839, 1, 4, 'mod/glossary:managecategories', 1, [[timestamp]], 0),
(840, 1, 3, 'mod/glossary:managecategories', 1, [[timestamp]], 0),
(841, 1, 1, 'mod/glossary:managecategories', 1, [[timestamp]], 0),
(842, 1, 5, 'mod/glossary:comment', 1, [[timestamp]], 0),
(843, 1, 4, 'mod/glossary:comment', 1, [[timestamp]], 0),
(844, 1, 3, 'mod/glossary:comment', 1, [[timestamp]], 0),
(845, 1, 1, 'mod/glossary:comment', 1, [[timestamp]], 0),
(846, 1, 4, 'mod/glossary:managecomments', 1, [[timestamp]], 0),
(847, 1, 3, 'mod/glossary:managecomments', 1, [[timestamp]], 0),
(848, 1, 1, 'mod/glossary:managecomments', 1, [[timestamp]], 0),
(849, 1, 4, 'mod/glossary:import', 1, [[timestamp]], 0),
(850, 1, 3, 'mod/glossary:import', 1, [[timestamp]], 0),
(851, 1, 1, 'mod/glossary:import', 1, [[timestamp]], 0),
(852, 1, 4, 'mod/glossary:export', 1, [[timestamp]], 0),
(853, 1, 3, 'mod/glossary:export', 1, [[timestamp]], 0),
(854, 1, 1, 'mod/glossary:export', 1, [[timestamp]], 0),
(855, 1, 4, 'mod/glossary:approve', 1, [[timestamp]], 0),
(856, 1, 3, 'mod/glossary:approve', 1, [[timestamp]], 0),
(857, 1, 1, 'mod/glossary:approve', 1, [[timestamp]], 0);
INSERT INTO `[[dbprefix]]role_capabilities` VALUES
(858, 1, 4, 'mod/glossary:rate', 1, [[timestamp]], 0),
(859, 1, 3, 'mod/glossary:rate', 1, [[timestamp]], 0),
(860, 1, 1, 'mod/glossary:rate', 1, [[timestamp]], 0),
(861, 1, 4, 'mod/glossary:viewrating', 1, [[timestamp]], 0),
(862, 1, 3, 'mod/glossary:viewrating', 1, [[timestamp]], 0),
(863, 1, 1, 'mod/glossary:viewrating', 1, [[timestamp]], 0),
(864, 1, 4, 'mod/glossary:viewanyrating', 1, [[timestamp]], 0),
(865, 1, 3, 'mod/glossary:viewanyrating', 1, [[timestamp]], 0),
(866, 1, 1, 'mod/glossary:viewanyrating', 1, [[timestamp]], 0),
(867, 1, 4, 'mod/glossary:viewallratings', 1, [[timestamp]], 0),
(868, 1, 3, 'mod/glossary:viewallratings', 1, [[timestamp]], 0),
(869, 1, 1, 'mod/glossary:viewallratings', 1, [[timestamp]], 0),
(870, 1, 4, 'mod/glossary:exportentry', 1, [[timestamp]], 0),
(871, 1, 3, 'mod/glossary:exportentry', 1, [[timestamp]], 0),
(872, 1, 1, 'mod/glossary:exportentry', 1, [[timestamp]], 0),
(873, 1, 4, 'mod/glossary:exportownentry', 1, [[timestamp]], 0),
(874, 1, 3, 'mod/glossary:exportownentry', 1, [[timestamp]], 0),
(875, 1, 1, 'mod/glossary:exportownentry', 1, [[timestamp]], 0),
(876, 1, 5, 'mod/glossary:exportownentry', 1, [[timestamp]], 0),
(877, 1, 6, 'mod/h5pactivity:view', 1, [[timestamp]], 0),
(878, 1, 5, 'mod/h5pactivity:view', 1, [[timestamp]], 0),
(879, 1, 4, 'mod/h5pactivity:view', 1, [[timestamp]], 0),
(880, 1, 3, 'mod/h5pactivity:view', 1, [[timestamp]], 0),
(881, 1, 1, 'mod/h5pactivity:view', 1, [[timestamp]], 0),
(882, 1, 3, 'mod/h5pactivity:addinstance', 1, [[timestamp]], 0),
(883, 1, 1, 'mod/h5pactivity:addinstance', 1, [[timestamp]], 0),
(884, 1, 5, 'mod/h5pactivity:submit', 1, [[timestamp]], 0),
(885, 1, 4, 'mod/h5pactivity:reviewattempts', 1, [[timestamp]], 0),
(886, 1, 3, 'mod/h5pactivity:reviewattempts', 1, [[timestamp]], 0),
(887, 1, 1, 'mod/h5pactivity:reviewattempts', 1, [[timestamp]], 0),
(888, 1, 6, 'mod/imscp:view', 1, [[timestamp]], 0),
(889, 1, 7, 'mod/imscp:view', 1, [[timestamp]], 0),
(890, 1, 3, 'mod/imscp:addinstance', 1, [[timestamp]], 0),
(891, 1, 1, 'mod/imscp:addinstance', 1, [[timestamp]], 0),
(892, 1, 3, 'mod/label:addinstance', 1, [[timestamp]], 0),
(893, 1, 1, 'mod/label:addinstance', 1, [[timestamp]], 0),
(894, 1, 7, 'mod/label:view', 1, [[timestamp]], 0),
(895, 1, 6, 'mod/label:view', 1, [[timestamp]], 0),
(896, 1, 3, 'mod/lesson:addinstance', 1, [[timestamp]], 0),
(897, 1, 1, 'mod/lesson:addinstance', 1, [[timestamp]], 0),
(898, 1, 3, 'mod/lesson:edit', 1, [[timestamp]], 0),
(899, 1, 1, 'mod/lesson:edit', 1, [[timestamp]], 0),
(900, 1, 4, 'mod/lesson:grade', 1, [[timestamp]], 0),
(901, 1, 3, 'mod/lesson:grade', 1, [[timestamp]], 0),
(902, 1, 1, 'mod/lesson:grade', 1, [[timestamp]], 0),
(903, 1, 4, 'mod/lesson:viewreports', 1, [[timestamp]], 0),
(904, 1, 3, 'mod/lesson:viewreports', 1, [[timestamp]], 0),
(905, 1, 1, 'mod/lesson:viewreports', 1, [[timestamp]], 0),
(906, 1, 4, 'mod/lesson:manage', 1, [[timestamp]], 0),
(907, 1, 3, 'mod/lesson:manage', 1, [[timestamp]], 0),
(908, 1, 1, 'mod/lesson:manage', 1, [[timestamp]], 0),
(909, 1, 3, 'mod/lesson:manageoverrides', 1, [[timestamp]], 0),
(910, 1, 1, 'mod/lesson:manageoverrides', 1, [[timestamp]], 0),
(911, 1, 7, 'mod/lesson:view', 1, [[timestamp]], 0),
(912, 1, 6, 'mod/lesson:view', 1, [[timestamp]], 0),
(913, 1, 5, 'mod/lti:view', 1, [[timestamp]], 0),
(914, 1, 4, 'mod/lti:view', 1, [[timestamp]], 0),
(915, 1, 3, 'mod/lti:view', 1, [[timestamp]], 0),
(916, 1, 1, 'mod/lti:view', 1, [[timestamp]], 0),
(917, 1, 3, 'mod/lti:addinstance', 1, [[timestamp]], 0),
(918, 1, 1, 'mod/lti:addinstance', 1, [[timestamp]], 0),
(919, 1, 4, 'mod/lti:manage', 1, [[timestamp]], 0),
(920, 1, 3, 'mod/lti:manage', 1, [[timestamp]], 0),
(921, 1, 1, 'mod/lti:manage', 1, [[timestamp]], 0),
(922, 1, 3, 'mod/lti:addcoursetool', 1, [[timestamp]], 0),
(923, 1, 1, 'mod/lti:addcoursetool', 1, [[timestamp]], 0),
(924, 1, 3, 'mod/lti:addpreconfiguredinstance', 1, [[timestamp]], 0),
(925, 1, 1, 'mod/lti:addpreconfiguredinstance', 1, [[timestamp]], 0),
(926, 1, 3, 'mod/lti:requesttooladd', 1, [[timestamp]], 0),
(927, 1, 1, 'mod/lti:requesttooladd', 1, [[timestamp]], 0),
(928, 1, 6, 'mod/page:view', 1, [[timestamp]], 0),
(929, 1, 7, 'mod/page:view', 1, [[timestamp]], 0),
(930, 1, 3, 'mod/page:addinstance', 1, [[timestamp]], 0),
(931, 1, 1, 'mod/page:addinstance', 1, [[timestamp]], 0),
(932, 1, 4, 'mod/qbank:view', 1, [[timestamp]], 0),
(933, 1, 3, 'mod/qbank:view', 1, [[timestamp]], 0),
(934, 1, 1, 'mod/qbank:view', 1, [[timestamp]], 0),
(935, 1, 3, 'mod/qbank:addinstance', 1, [[timestamp]], 0),
(936, 1, 1, 'mod/qbank:addinstance', 1, [[timestamp]], 0),
(937, 1, 6, 'mod/quiz:view', 1, [[timestamp]], 0),
(938, 1, 5, 'mod/quiz:view', 1, [[timestamp]], 0),
(939, 1, 4, 'mod/quiz:view', 1, [[timestamp]], 0),
(940, 1, 3, 'mod/quiz:view', 1, [[timestamp]], 0),
(941, 1, 1, 'mod/quiz:view', 1, [[timestamp]], 0),
(942, 1, 3, 'mod/quiz:addinstance', 1, [[timestamp]], 0),
(943, 1, 1, 'mod/quiz:addinstance', 1, [[timestamp]], 0),
(944, 1, 5, 'mod/quiz:attempt', 1, [[timestamp]], 0),
(945, 1, 5, 'mod/quiz:reviewmyattempts', 1, [[timestamp]], 0),
(946, 1, 3, 'mod/quiz:manage', 1, [[timestamp]], 0),
(947, 1, 1, 'mod/quiz:manage', 1, [[timestamp]], 0),
(948, 1, 3, 'mod/quiz:manageoverrides', 1, [[timestamp]], 0),
(949, 1, 1, 'mod/quiz:manageoverrides', 1, [[timestamp]], 0),
(950, 1, 4, 'mod/quiz:viewoverrides', 1, [[timestamp]], 0),
(951, 1, 3, 'mod/quiz:viewoverrides', 1, [[timestamp]], 0),
(952, 1, 1, 'mod/quiz:viewoverrides', 1, [[timestamp]], 0),
(953, 1, 4, 'mod/quiz:preview', 1, [[timestamp]], 0),
(954, 1, 3, 'mod/quiz:preview', 1, [[timestamp]], 0),
(955, 1, 1, 'mod/quiz:preview', 1, [[timestamp]], 0),
(956, 1, 4, 'mod/quiz:grade', 1, [[timestamp]], 0),
(957, 1, 3, 'mod/quiz:grade', 1, [[timestamp]], 0),
(958, 1, 1, 'mod/quiz:grade', 1, [[timestamp]], 0),
(959, 1, 4, 'mod/quiz:regrade', 1, [[timestamp]], 0),
(960, 1, 3, 'mod/quiz:regrade', 1, [[timestamp]], 0),
(961, 1, 1, 'mod/quiz:regrade', 1, [[timestamp]], 0),
(962, 1, 4, 'mod/quiz:viewreports', 1, [[timestamp]], 0),
(963, 1, 3, 'mod/quiz:viewreports', 1, [[timestamp]], 0),
(964, 1, 1, 'mod/quiz:viewreports', 1, [[timestamp]], 0),
(965, 1, 3, 'mod/quiz:deleteattempts', 1, [[timestamp]], 0),
(966, 1, 1, 'mod/quiz:deleteattempts', 1, [[timestamp]], 0),
(967, 1, 3, 'mod/quiz:reopenattempts', 1, [[timestamp]], 0),
(968, 1, 1, 'mod/quiz:reopenattempts', 1, [[timestamp]], 0),
(969, 1, 6, 'mod/resource:view', 1, [[timestamp]], 0),
(970, 1, 7, 'mod/resource:view', 1, [[timestamp]], 0),
(971, 1, 3, 'mod/resource:addinstance', 1, [[timestamp]], 0),
(972, 1, 1, 'mod/resource:addinstance', 1, [[timestamp]], 0),
(973, 1, 3, 'mod/scorm:addinstance', 1, [[timestamp]], 0),
(974, 1, 1, 'mod/scorm:addinstance', 1, [[timestamp]], 0),
(975, 1, 4, 'mod/scorm:viewreport', 1, [[timestamp]], 0),
(976, 1, 3, 'mod/scorm:viewreport', 1, [[timestamp]], 0),
(977, 1, 1, 'mod/scorm:viewreport', 1, [[timestamp]], 0),
(978, 1, 5, 'mod/scorm:skipview', 1, [[timestamp]], 0),
(979, 1, 5, 'mod/scorm:savetrack', 1, [[timestamp]], 0),
(980, 1, 4, 'mod/scorm:savetrack', 1, [[timestamp]], 0),
(981, 1, 3, 'mod/scorm:savetrack', 1, [[timestamp]], 0),
(982, 1, 1, 'mod/scorm:savetrack', 1, [[timestamp]], 0),
(983, 1, 5, 'mod/scorm:viewscores', 1, [[timestamp]], 0),
(984, 1, 4, 'mod/scorm:viewscores', 1, [[timestamp]], 0),
(985, 1, 3, 'mod/scorm:viewscores', 1, [[timestamp]], 0),
(986, 1, 1, 'mod/scorm:viewscores', 1, [[timestamp]], 0),
(987, 1, 4, 'mod/scorm:deleteresponses', 1, [[timestamp]], 0),
(988, 1, 3, 'mod/scorm:deleteresponses', 1, [[timestamp]], 0),
(989, 1, 1, 'mod/scorm:deleteresponses', 1, [[timestamp]], 0),
(990, 1, 3, 'mod/subsection:addinstance', 1, [[timestamp]], 0),
(991, 1, 1, 'mod/subsection:addinstance', 1, [[timestamp]], 0),
(992, 1, 6, 'mod/url:view', 1, [[timestamp]], 0),
(993, 1, 7, 'mod/url:view', 1, [[timestamp]], 0),
(994, 1, 3, 'mod/url:addinstance', 1, [[timestamp]], 0),
(995, 1, 1, 'mod/url:addinstance', 1, [[timestamp]], 0),
(996, 1, 3, 'mod/wiki:addinstance', 1, [[timestamp]], 0),
(997, 1, 1, 'mod/wiki:addinstance', 1, [[timestamp]], 0),
(998, 1, 6, 'mod/wiki:viewpage', 1, [[timestamp]], 0),
(999, 1, 8, 'mod/wiki:viewpage', 1, [[timestamp]], 0),
(1000, 1, 5, 'mod/wiki:viewpage', 1, [[timestamp]], 0),
(1001, 1, 4, 'mod/wiki:viewpage', 1, [[timestamp]], 0),
(1002, 1, 3, 'mod/wiki:viewpage', 1, [[timestamp]], 0),
(1003, 1, 1, 'mod/wiki:viewpage', 1, [[timestamp]], 0),
(1004, 1, 5, 'mod/wiki:editpage', 1, [[timestamp]], 0),
(1005, 1, 4, 'mod/wiki:editpage', 1, [[timestamp]], 0),
(1006, 1, 3, 'mod/wiki:editpage', 1, [[timestamp]], 0),
(1007, 1, 1, 'mod/wiki:editpage', 1, [[timestamp]], 0),
(1008, 1, 5, 'mod/wiki:createpage', 1, [[timestamp]], 0),
(1009, 1, 4, 'mod/wiki:createpage', 1, [[timestamp]], 0),
(1010, 1, 3, 'mod/wiki:createpage', 1, [[timestamp]], 0),
(1011, 1, 1, 'mod/wiki:createpage', 1, [[timestamp]], 0),
(1012, 1, 5, 'mod/wiki:viewcomment', 1, [[timestamp]], 0),
(1013, 1, 4, 'mod/wiki:viewcomment', 1, [[timestamp]], 0),
(1014, 1, 3, 'mod/wiki:viewcomment', 1, [[timestamp]], 0),
(1015, 1, 1, 'mod/wiki:viewcomment', 1, [[timestamp]], 0),
(1016, 1, 5, 'mod/wiki:editcomment', 1, [[timestamp]], 0),
(1017, 1, 4, 'mod/wiki:editcomment', 1, [[timestamp]], 0),
(1018, 1, 3, 'mod/wiki:editcomment', 1, [[timestamp]], 0),
(1019, 1, 1, 'mod/wiki:editcomment', 1, [[timestamp]], 0),
(1020, 1, 4, 'mod/wiki:managecomment', 1, [[timestamp]], 0),
(1021, 1, 3, 'mod/wiki:managecomment', 1, [[timestamp]], 0),
(1022, 1, 1, 'mod/wiki:managecomment', 1, [[timestamp]], 0),
(1023, 1, 4, 'mod/wiki:managefiles', 1, [[timestamp]], 0),
(1024, 1, 3, 'mod/wiki:managefiles', 1, [[timestamp]], 0),
(1025, 1, 1, 'mod/wiki:managefiles', 1, [[timestamp]], 0),
(1026, 1, 4, 'mod/wiki:overridelock', 1, [[timestamp]], 0),
(1027, 1, 3, 'mod/wiki:overridelock', 1, [[timestamp]], 0),
(1028, 1, 1, 'mod/wiki:overridelock', 1, [[timestamp]], 0),
(1029, 1, 4, 'mod/wiki:managewiki', 1, [[timestamp]], 0),
(1030, 1, 3, 'mod/wiki:managewiki', 1, [[timestamp]], 0),
(1031, 1, 1, 'mod/wiki:managewiki', 1, [[timestamp]], 0),
(1032, 1, 6, 'mod/workshop:view', 1, [[timestamp]], 0),
(1033, 1, 5, 'mod/workshop:view', 1, [[timestamp]], 0),
(1034, 1, 4, 'mod/workshop:view', 1, [[timestamp]], 0),
(1035, 1, 3, 'mod/workshop:view', 1, [[timestamp]], 0),
(1036, 1, 1, 'mod/workshop:view', 1, [[timestamp]], 0),
(1037, 1, 3, 'mod/workshop:addinstance', 1, [[timestamp]], 0),
(1038, 1, 1, 'mod/workshop:addinstance', 1, [[timestamp]], 0),
(1039, 1, 4, 'mod/workshop:switchphase', 1, [[timestamp]], 0),
(1040, 1, 3, 'mod/workshop:switchphase', 1, [[timestamp]], 0),
(1041, 1, 1, 'mod/workshop:switchphase', 1, [[timestamp]], 0),
(1042, 1, 3, 'mod/workshop:editdimensions', 1, [[timestamp]], 0),
(1043, 1, 1, 'mod/workshop:editdimensions', 1, [[timestamp]], 0),
(1044, 1, 5, 'mod/workshop:submit', 1, [[timestamp]], 0),
(1045, 1, 5, 'mod/workshop:peerassess', 1, [[timestamp]], 0),
(1046, 1, 4, 'mod/workshop:manageexamples', 1, [[timestamp]], 0),
(1047, 1, 3, 'mod/workshop:manageexamples', 1, [[timestamp]], 0),
(1048, 1, 1, 'mod/workshop:manageexamples', 1, [[timestamp]], 0),
(1049, 1, 4, 'mod/workshop:allocate', 1, [[timestamp]], 0),
(1050, 1, 3, 'mod/workshop:allocate', 1, [[timestamp]], 0),
(1051, 1, 1, 'mod/workshop:allocate', 1, [[timestamp]], 0),
(1052, 1, 4, 'mod/workshop:publishsubmissions', 1, [[timestamp]], 0),
(1053, 1, 3, 'mod/workshop:publishsubmissions', 1, [[timestamp]], 0),
(1054, 1, 1, 'mod/workshop:publishsubmissions', 1, [[timestamp]], 0),
(1055, 1, 5, 'mod/workshop:viewauthornames', 1, [[timestamp]], 0),
(1056, 1, 4, 'mod/workshop:viewauthornames', 1, [[timestamp]], 0),
(1057, 1, 3, 'mod/workshop:viewauthornames', 1, [[timestamp]], 0),
(1058, 1, 1, 'mod/workshop:viewauthornames', 1, [[timestamp]], 0),
(1059, 1, 4, 'mod/workshop:viewreviewernames', 1, [[timestamp]], 0),
(1060, 1, 3, 'mod/workshop:viewreviewernames', 1, [[timestamp]], 0),
(1061, 1, 1, 'mod/workshop:viewreviewernames', 1, [[timestamp]], 0),
(1062, 1, 4, 'mod/workshop:viewallsubmissions', 1, [[timestamp]], 0),
(1063, 1, 3, 'mod/workshop:viewallsubmissions', 1, [[timestamp]], 0),
(1064, 1, 1, 'mod/workshop:viewallsubmissions', 1, [[timestamp]], 0),
(1065, 1, 5, 'mod/workshop:viewpublishedsubmissions', 1, [[timestamp]], 0),
(1066, 1, 4, 'mod/workshop:viewpublishedsubmissions', 1, [[timestamp]], 0),
(1067, 1, 3, 'mod/workshop:viewpublishedsubmissions', 1, [[timestamp]], 0),
(1068, 1, 1, 'mod/workshop:viewpublishedsubmissions', 1, [[timestamp]], 0),
(1069, 1, 5, 'mod/workshop:viewauthorpublished', 1, [[timestamp]], 0),
(1070, 1, 4, 'mod/workshop:viewauthorpublished', 1, [[timestamp]], 0),
(1071, 1, 3, 'mod/workshop:viewauthorpublished', 1, [[timestamp]], 0),
(1072, 1, 1, 'mod/workshop:viewauthorpublished', 1, [[timestamp]], 0),
(1073, 1, 4, 'mod/workshop:viewallassessments', 1, [[timestamp]], 0),
(1074, 1, 3, 'mod/workshop:viewallassessments', 1, [[timestamp]], 0),
(1075, 1, 1, 'mod/workshop:viewallassessments', 1, [[timestamp]], 0),
(1076, 1, 4, 'mod/workshop:overridegrades', 1, [[timestamp]], 0),
(1077, 1, 3, 'mod/workshop:overridegrades', 1, [[timestamp]], 0),
(1078, 1, 1, 'mod/workshop:overridegrades', 1, [[timestamp]], 0),
(1079, 1, 4, 'mod/workshop:ignoredeadlines', 1, [[timestamp]], 0),
(1080, 1, 3, 'mod/workshop:ignoredeadlines', 1, [[timestamp]], 0),
(1081, 1, 1, 'mod/workshop:ignoredeadlines', 1, [[timestamp]], 0),
(1082, 1, 4, 'mod/workshop:deletesubmissions', 1, [[timestamp]], 0),
(1083, 1, 3, 'mod/workshop:deletesubmissions', 1, [[timestamp]], 0),
(1084, 1, 1, 'mod/workshop:deletesubmissions', 1, [[timestamp]], 0),
(1085, 1, 1, 'mod/workshop:exportsubmissions', 1, [[timestamp]], 0),
(1086, 1, 4, 'mod/workshop:exportsubmissions', 1, [[timestamp]], 0),
(1087, 1, 3, 'mod/workshop:exportsubmissions', 1, [[timestamp]], 0),
(1088, 1, 5, 'mod/workshop:exportsubmissions', 1, [[timestamp]], 0),
(1089, 1, 7, 'auth/oauth2:managelinkedlogins', 1, [[timestamp]], 0),
(1090, 1, 3, 'communication/matrix:moderator', 1, [[timestamp]], 0),
(1091, 1, 1, 'communication/matrix:moderator', 1, [[timestamp]], 0),
(1092, 1, 4, 'communication/matrix:moderator', 1, [[timestamp]], 0),
(1093, 1, 1, 'enrol/category:config', 1, [[timestamp]], 0),
(1094, 1, 3, 'enrol/category:config', 1, [[timestamp]], 0),
(1095, 1, 3, 'enrol/cohort:config', 1, [[timestamp]], 0),
(1096, 1, 1, 'enrol/cohort:config', 1, [[timestamp]], 0),
(1097, 1, 1, 'enrol/cohort:unenrol', 1, [[timestamp]], 0),
(1098, 1, 1, 'enrol/database:unenrol', 1, [[timestamp]], 0),
(1099, 1, 1, 'enrol/database:config', 1, [[timestamp]], 0),
(1100, 1, 3, 'enrol/database:config', 1, [[timestamp]], 0),
(1101, 1, 1, 'enrol/fee:config', 1, [[timestamp]], 0),
(1102, 1, 1, 'enrol/fee:manage', 1, [[timestamp]], 0),
(1103, 1, 3, 'enrol/fee:manage', 1, [[timestamp]], 0),
(1104, 1, 1, 'enrol/fee:unenrol', 1, [[timestamp]], 0),
(1105, 1, 1, 'enrol/guest:config', 1, [[timestamp]], 0),
(1106, 1, 3, 'enrol/guest:config', 1, [[timestamp]], 0),
(1107, 1, 1, 'enrol/imsenterprise:config', 1, [[timestamp]], 0),
(1108, 1, 3, 'enrol/imsenterprise:config', 1, [[timestamp]], 0),
(1109, 1, 1, 'enrol/ldap:manage', 1, [[timestamp]], 0),
(1110, 1, 1, 'enrol/lti:config', 1, [[timestamp]], 0),
(1111, 1, 3, 'enrol/lti:config', 1, [[timestamp]], 0),
(1112, 1, 1, 'enrol/lti:unenrol', 1, [[timestamp]], 0),
(1113, 1, 3, 'enrol/lti:unenrol', 1, [[timestamp]], 0),
(1114, 1, 1, 'enrol/manual:config', 1, [[timestamp]], 0),
(1115, 1, 1, 'enrol/manual:enrol', 1, [[timestamp]], 0),
(1116, 1, 3, 'enrol/manual:enrol', 1, [[timestamp]], 0),
(1117, 1, 1, 'enrol/manual:manage', 1, [[timestamp]], 0),
(1118, 1, 3, 'enrol/manual:manage', 1, [[timestamp]], 0),
(1119, 1, 1, 'enrol/manual:unenrol', 1, [[timestamp]], 0),
(1120, 1, 3, 'enrol/manual:unenrol', 1, [[timestamp]], 0),
(1121, 1, 1, 'enrol/meta:config', 1, [[timestamp]], 0),
(1122, 1, 3, 'enrol/meta:config', 1, [[timestamp]], 0),
(1123, 1, 1, 'enrol/meta:selectaslinked', 1, [[timestamp]], 0),
(1124, 1, 1, 'enrol/meta:unenrol', 1, [[timestamp]], 0),
(1125, 1, 1, 'enrol/paypal:config', 1, [[timestamp]], 0),
(1126, 1, 1, 'enrol/paypal:manage', 1, [[timestamp]], 0),
(1127, 1, 3, 'enrol/paypal:manage', 1, [[timestamp]], 0),
(1128, 1, 1, 'enrol/paypal:unenrol', 1, [[timestamp]], 0),
(1129, 1, 3, 'enrol/self:config', 1, [[timestamp]], 0),
(1130, 1, 1, 'enrol/self:config', 1, [[timestamp]], 0),
(1131, 1, 3, 'enrol/self:manage', 1, [[timestamp]], 0),
(1132, 1, 1, 'enrol/self:manage', 1, [[timestamp]], 0),
(1133, 1, 5, 'enrol/self:unenrolself', 1, [[timestamp]], 0),
(1134, 1, 3, 'enrol/self:unenrol', 1, [[timestamp]], 0),
(1135, 1, 1, 'enrol/self:unenrol', 1, [[timestamp]], 0),
(1136, 1, 7, 'enrol/self:enrolself', 1, [[timestamp]], 0),
(1137, 1, 7, 'message/airnotifier:managedevice', 1, [[timestamp]], 0),
(1138, 1, 3, 'block/accessreview:addinstance', 1, [[timestamp]], 0),
(1139, 1, 1, 'block/accessreview:addinstance', 1, [[timestamp]], 0),
(1140, 1, 3, 'block/accessreview:view', 1, [[timestamp]], 0),
(1141, 1, 1, 'block/accessreview:view', 1, [[timestamp]], 0),
(1142, 1, 3, 'block/activity_modules:addinstance', 1, [[timestamp]], 0),
(1143, 1, 1, 'block/activity_modules:addinstance', 1, [[timestamp]], 0),
(1144, 1, 3, 'block/activity_results:addinstance', 1, [[timestamp]], 0),
(1145, 1, 1, 'block/activity_results:addinstance', 1, [[timestamp]], 0),
(1146, 1, 7, 'block/admin_bookmarks:myaddinstance', 1, [[timestamp]], 0),
(1147, 1, 3, 'block/admin_bookmarks:addinstance', 1, [[timestamp]], 0),
(1148, 1, 1, 'block/admin_bookmarks:addinstance', 1, [[timestamp]], 0),
(1149, 1, 3, 'block/badges:addinstance', 1, [[timestamp]], 0),
(1150, 1, 1, 'block/badges:addinstance', 1, [[timestamp]], 0),
(1151, 1, 7, 'block/badges:myaddinstance', 1, [[timestamp]], 0),
(1152, 1, 3, 'block/blog_menu:addinstance', 1, [[timestamp]], 0),
(1153, 1, 1, 'block/blog_menu:addinstance', 1, [[timestamp]], 0),
(1154, 1, 3, 'block/blog_recent:addinstance', 1, [[timestamp]], 0),
(1155, 1, 1, 'block/blog_recent:addinstance', 1, [[timestamp]], 0),
(1156, 1, 3, 'block/blog_tags:addinstance', 1, [[timestamp]], 0),
(1157, 1, 1, 'block/blog_tags:addinstance', 1, [[timestamp]], 0),
(1158, 1, 7, 'block/calendar_month:myaddinstance', 1, [[timestamp]], 0),
(1159, 1, 3, 'block/calendar_month:addinstance', 1, [[timestamp]], 0),
(1160, 1, 1, 'block/calendar_month:addinstance', 1, [[timestamp]], 0),
(1161, 1, 7, 'block/calendar_upcoming:myaddinstance', 1, [[timestamp]], 0),
(1162, 1, 3, 'block/calendar_upcoming:addinstance', 1, [[timestamp]], 0),
(1163, 1, 1, 'block/calendar_upcoming:addinstance', 1, [[timestamp]], 0),
(1164, 1, 7, 'block/comments:myaddinstance', 1, [[timestamp]], 0),
(1165, 1, 3, 'block/comments:addinstance', 1, [[timestamp]], 0),
(1166, 1, 1, 'block/comments:addinstance', 1, [[timestamp]], 0),
(1167, 1, 3, 'block/completionstatus:addinstance', 1, [[timestamp]], 0),
(1168, 1, 1, 'block/completionstatus:addinstance', 1, [[timestamp]], 0),
(1169, 1, 7, 'block/course_list:myaddinstance', 1, [[timestamp]], 0),
(1170, 1, 3, 'block/course_list:addinstance', 1, [[timestamp]], 0),
(1171, 1, 1, 'block/course_list:addinstance', 1, [[timestamp]], 0),
(1172, 1, 3, 'block/course_summary:addinstance', 1, [[timestamp]], 0),
(1173, 1, 1, 'block/course_summary:addinstance', 1, [[timestamp]], 0),
(1174, 1, 3, 'block/feedback:addinstance', 1, [[timestamp]], 0),
(1175, 1, 1, 'block/feedback:addinstance', 1, [[timestamp]], 0),
(1176, 1, 7, 'block/globalsearch:myaddinstance', 1, [[timestamp]], 0),
(1177, 1, 3, 'block/globalsearch:addinstance', 1, [[timestamp]], 0),
(1178, 1, 1, 'block/globalsearch:addinstance', 1, [[timestamp]], 0),
(1179, 1, 7, 'block/glossary_random:myaddinstance', 1, [[timestamp]], 0),
(1180, 1, 3, 'block/glossary_random:addinstance', 1, [[timestamp]], 0),
(1181, 1, 1, 'block/glossary_random:addinstance', 1, [[timestamp]], 0),
(1182, 1, 7, 'block/html:myaddinstance', 1, [[timestamp]], 0),
(1183, 1, 3, 'block/html:addinstance', 1, [[timestamp]], 0),
(1184, 1, 1, 'block/html:addinstance', 1, [[timestamp]], 0),
(1185, 1, 3, 'block/login:addinstance', 1, [[timestamp]], 0),
(1186, 1, 1, 'block/login:addinstance', 1, [[timestamp]], 0),
(1187, 1, 3, 'block/lp:addinstance', 1, [[timestamp]], 0),
(1188, 1, 1, 'block/lp:addinstance', 1, [[timestamp]], 0),
(1189, 1, 7, 'block/lp:myaddinstance', 1, [[timestamp]], 0),
(1190, 1, 7, 'block/mentees:myaddinstance', 1, [[timestamp]], 0),
(1191, 1, 3, 'block/mentees:addinstance', 1, [[timestamp]], 0),
(1192, 1, 1, 'block/mentees:addinstance', 1, [[timestamp]], 0),
(1193, 1, 7, 'block/myoverview:myaddinstance', 1, [[timestamp]], 0),
(1194, 1, 7, 'block/myprofile:myaddinstance', 1, [[timestamp]], 0),
(1195, 1, 3, 'block/myprofile:addinstance', 1, [[timestamp]], 0),
(1196, 1, 1, 'block/myprofile:addinstance', 1, [[timestamp]], 0),
(1197, 1, 7, 'block/navigation:myaddinstance', 1, [[timestamp]], 0),
(1198, 1, 3, 'block/navigation:addinstance', 1, [[timestamp]], 0),
(1199, 1, 1, 'block/navigation:addinstance', 1, [[timestamp]], 0),
(1200, 1, 7, 'block/news_items:myaddinstance', 1, [[timestamp]], 0),
(1201, 1, 3, 'block/news_items:addinstance', 1, [[timestamp]], 0),
(1202, 1, 1, 'block/news_items:addinstance', 1, [[timestamp]], 0),
(1203, 1, 7, 'block/online_users:myaddinstance', 1, [[timestamp]], 0),
(1204, 1, 3, 'block/online_users:addinstance', 1, [[timestamp]], 0),
(1205, 1, 1, 'block/online_users:addinstance', 1, [[timestamp]], 0),
(1206, 1, 7, 'block/online_users:viewlist', 1, [[timestamp]], 0),
(1207, 1, 6, 'block/online_users:viewlist', -1, [[timestamp]], 0),
(1208, 1, 5, 'block/online_users:viewlist', 1, [[timestamp]], 0),
(1209, 1, 4, 'block/online_users:viewlist', 1, [[timestamp]], 0),
(1210, 1, 3, 'block/online_users:viewlist', 1, [[timestamp]], 0),
(1211, 1, 1, 'block/online_users:viewlist', 1, [[timestamp]], 0),
(1212, 1, 7, 'block/private_files:myaddinstance', 1, [[timestamp]], 0),
(1213, 1, 3, 'block/private_files:addinstance', 1, [[timestamp]], 0),
(1214, 1, 1, 'block/private_files:addinstance', 1, [[timestamp]], 0),
(1215, 1, 3, 'block/recent_activity:addinstance', 1, [[timestamp]], 0),
(1216, 1, 1, 'block/recent_activity:addinstance', 1, [[timestamp]], 0),
(1217, 1, 7, 'block/recent_activity:viewaddupdatemodule', 1, [[timestamp]], 0),
(1218, 1, 7, 'block/recent_activity:viewdeletemodule', 1, [[timestamp]], 0),
(1219, 1, 7, 'block/recentlyaccessedcourses:myaddinstance', 1, [[timestamp]], 0),
(1220, 1, 7, 'block/recentlyaccesseditems:myaddinstance', 1, [[timestamp]], 0),
(1221, 1, 7, 'block/rss_client:myaddinstance', 1, [[timestamp]], 0),
(1222, 1, 3, 'block/rss_client:addinstance', 1, [[timestamp]], 0),
(1223, 1, 1, 'block/rss_client:addinstance', 1, [[timestamp]], 0),
(1224, 1, 4, 'block/rss_client:manageownfeeds', 1, [[timestamp]], 0),
(1225, 1, 3, 'block/rss_client:manageownfeeds', 1, [[timestamp]], 0),
(1226, 1, 1, 'block/rss_client:manageownfeeds', 1, [[timestamp]], 0),
(1227, 1, 1, 'block/rss_client:manageanyfeeds', 1, [[timestamp]], 0),
(1228, 1, 3, 'block/search_forums:addinstance', 1, [[timestamp]], 0),
(1229, 1, 1, 'block/search_forums:addinstance', 1, [[timestamp]], 0),
(1230, 1, 3, 'block/selfcompletion:addinstance', 1, [[timestamp]], 0),
(1231, 1, 1, 'block/selfcompletion:addinstance', 1, [[timestamp]], 0),
(1232, 1, 7, 'block/settings:myaddinstance', 1, [[timestamp]], 0),
(1233, 1, 3, 'block/settings:addinstance', 1, [[timestamp]], 0),
(1234, 1, 1, 'block/settings:addinstance', 1, [[timestamp]], 0),
(1235, 1, 3, 'block/site_main_menu:addinstance', 1, [[timestamp]], 0),
(1236, 1, 1, 'block/site_main_menu:addinstance', 1, [[timestamp]], 0),
(1237, 1, 3, 'block/social_activities:addinstance', 1, [[timestamp]], 0),
(1238, 1, 1, 'block/social_activities:addinstance', 1, [[timestamp]], 0),
(1239, 1, 7, 'block/starredcourses:myaddinstance', 1, [[timestamp]], 0),
(1240, 1, 3, 'block/tag_flickr:addinstance', 1, [[timestamp]], 0),
(1241, 1, 1, 'block/tag_flickr:addinstance', 1, [[timestamp]], 0),
(1242, 1, 3, 'block/tag_youtube:addinstance', 1, [[timestamp]], 0),
(1243, 1, 1, 'block/tag_youtube:addinstance', 1, [[timestamp]], 0),
(1244, 1, 7, 'block/tags:myaddinstance', 1, [[timestamp]], 0),
(1245, 1, 3, 'block/tags:addinstance', 1, [[timestamp]], 0),
(1246, 1, 1, 'block/tags:addinstance', 1, [[timestamp]], 0),
(1247, 1, 7, 'block/timeline:myaddinstance', 1, [[timestamp]], 0),
(1248, 1, 4, 'report/completion:view', 1, [[timestamp]], 0),
(1249, 1, 3, 'report/completion:view', 1, [[timestamp]], 0),
(1250, 1, 1, 'report/completion:view', 1, [[timestamp]], 0),
(1251, 1, 4, 'report/courseoverview:view', 1, [[timestamp]], 0),
(1252, 1, 3, 'report/courseoverview:view', 1, [[timestamp]], 0),
(1253, 1, 1, 'report/courseoverview:view', 1, [[timestamp]], 0),
(1254, 1, 4, 'report/log:view', 1, [[timestamp]], 0),
(1255, 1, 3, 'report/log:view', 1, [[timestamp]], 0),
(1256, 1, 1, 'report/log:view', 1, [[timestamp]], 0),
(1257, 1, 4, 'report/log:viewtoday', 1, [[timestamp]], 0),
(1258, 1, 3, 'report/log:viewtoday', 1, [[timestamp]], 0),
(1259, 1, 1, 'report/log:viewtoday', 1, [[timestamp]], 0),
(1260, 1, 4, 'report/loglive:view', 1, [[timestamp]], 0),
(1261, 1, 3, 'report/loglive:view', 1, [[timestamp]], 0),
(1262, 1, 1, 'report/loglive:view', 1, [[timestamp]], 0),
(1263, 1, 4, 'report/outline:view', 1, [[timestamp]], 0),
(1264, 1, 3, 'report/outline:view', 1, [[timestamp]], 0),
(1265, 1, 1, 'report/outline:view', 1, [[timestamp]], 0),
(1266, 1, 4, 'report/outline:viewuserreport', 1, [[timestamp]], 0),
(1267, 1, 3, 'report/outline:viewuserreport', 1, [[timestamp]], 0),
(1268, 1, 1, 'report/outline:viewuserreport', 1, [[timestamp]], 0),
(1269, 1, 4, 'report/participation:view', 1, [[timestamp]], 0),
(1270, 1, 3, 'report/participation:view', 1, [[timestamp]], 0),
(1271, 1, 1, 'report/participation:view', 1, [[timestamp]], 0),
(1272, 1, 1, 'report/performance:view', 1, [[timestamp]], 0),
(1273, 1, 4, 'report/progress:view', 1, [[timestamp]], 0),
(1274, 1, 3, 'report/progress:view', 1, [[timestamp]], 0),
(1275, 1, 1, 'report/progress:view', 1, [[timestamp]], 0),
(1276, 1, 1, 'report/security:view', 1, [[timestamp]], 0),
(1277, 1, 4, 'report/stats:view', 1, [[timestamp]], 0),
(1278, 1, 3, 'report/stats:view', 1, [[timestamp]], 0),
(1279, 1, 1, 'report/stats:view', 1, [[timestamp]], 0),
(1280, 1, 1, 'report/status:view', 1, [[timestamp]], 0),
(1281, 1, 6, 'report/usersessions:manageownsessions', -1000, [[timestamp]], 0),
(1282, 1, 7, 'report/usersessions:manageownsessions', 1, [[timestamp]], 0),
(1283, 1, 1, 'report/usersessions:manageownsessions', 1, [[timestamp]], 0),
(1284, 1, 4, 'gradeexport/ods:view', 1, [[timestamp]], 0),
(1285, 1, 3, 'gradeexport/ods:view', 1, [[timestamp]], 0),
(1286, 1, 1, 'gradeexport/ods:view', 1, [[timestamp]], 0),
(1287, 1, 1, 'gradeexport/ods:publish', 1, [[timestamp]], 0),
(1288, 1, 4, 'gradeexport/txt:view', 1, [[timestamp]], 0),
(1289, 1, 3, 'gradeexport/txt:view', 1, [[timestamp]], 0),
(1290, 1, 1, 'gradeexport/txt:view', 1, [[timestamp]], 0),
(1291, 1, 1, 'gradeexport/txt:publish', 1, [[timestamp]], 0),
(1292, 1, 4, 'gradeexport/xls:view', 1, [[timestamp]], 0),
(1293, 1, 3, 'gradeexport/xls:view', 1, [[timestamp]], 0),
(1294, 1, 1, 'gradeexport/xls:view', 1, [[timestamp]], 0),
(1295, 1, 1, 'gradeexport/xls:publish', 1, [[timestamp]], 0),
(1296, 1, 4, 'gradeexport/xml:view', 1, [[timestamp]], 0),
(1297, 1, 3, 'gradeexport/xml:view', 1, [[timestamp]], 0),
(1298, 1, 1, 'gradeexport/xml:view', 1, [[timestamp]], 0),
(1299, 1, 1, 'gradeexport/xml:publish', 1, [[timestamp]], 0),
(1300, 1, 3, 'gradeimport/csv:view', 1, [[timestamp]], 0),
(1301, 1, 1, 'gradeimport/csv:view', 1, [[timestamp]], 0),
(1302, 1, 3, 'gradeimport/direct:view', 1, [[timestamp]], 0),
(1303, 1, 1, 'gradeimport/direct:view', 1, [[timestamp]], 0),
(1304, 1, 3, 'gradeimport/xml:view', 1, [[timestamp]], 0),
(1305, 1, 1, 'gradeimport/xml:view', 1, [[timestamp]], 0),
(1306, 1, 1, 'gradeimport/xml:publish', 1, [[timestamp]], 0),
(1307, 1, 1, 'gradepenalty/duedate:manage', 1, [[timestamp]], 0),
(1308, 1, 4, 'gradereport/grader:view', 1, [[timestamp]], 0),
(1309, 1, 3, 'gradereport/grader:view', 1, [[timestamp]], 0),
(1310, 1, 1, 'gradereport/grader:view', 1, [[timestamp]], 0),
(1311, 1, 4, 'gradereport/history:view', 1, [[timestamp]], 0),
(1312, 1, 3, 'gradereport/history:view', 1, [[timestamp]], 0),
(1313, 1, 1, 'gradereport/history:view', 1, [[timestamp]], 0),
(1314, 1, 4, 'gradereport/outcomes:view', 1, [[timestamp]], 0),
(1315, 1, 3, 'gradereport/outcomes:view', 1, [[timestamp]], 0),
(1316, 1, 1, 'gradereport/outcomes:view', 1, [[timestamp]], 0),
(1317, 1, 7, 'gradereport/overview:view', 1, [[timestamp]], 0),
(1318, 1, 3, 'gradereport/singleview:view', 1, [[timestamp]], 0),
(1319, 1, 1, 'gradereport/singleview:view', 1, [[timestamp]], 0),
(1320, 1, 3, 'gradereport/summary:view', 1, [[timestamp]], 0),
(1321, 1, 4, 'gradereport/summary:view', 1, [[timestamp]], 0),
(1322, 1, 1, 'gradereport/summary:view', 1, [[timestamp]], 0),
(1323, 1, 5, 'gradereport/user:view', 1, [[timestamp]], 0),
(1324, 1, 4, 'gradereport/user:view', 1, [[timestamp]], 0),
(1325, 1, 3, 'gradereport/user:view', 1, [[timestamp]], 0),
(1326, 1, 1, 'gradereport/user:view', 1, [[timestamp]], 0),
(1327, 1, 7, 'repository/areafiles:view', 1, [[timestamp]], 0),
(1328, 1, 2, 'repository/contentbank:view', 1, [[timestamp]], 0),
(1329, 1, 3, 'repository/contentbank:view', 1, [[timestamp]], 0),
(1330, 1, 1, 'repository/contentbank:view', 1, [[timestamp]], 0),
(1331, 1, 2, 'repository/contentbank:accesscoursecontent', 1, [[timestamp]], 0),
(1332, 1, 3, 'repository/contentbank:accesscoursecontent', 1, [[timestamp]], 0),
(1333, 1, 1, 'repository/contentbank:accesscoursecontent', 1, [[timestamp]], 0),
(1334, 1, 2, 'repository/contentbank:accesscoursecategorycontent', 1, [[timestamp]], 0),
(1335, 1, 1, 'repository/contentbank:accesscoursecategorycontent', 1, [[timestamp]], 0),
(1336, 1, 7, 'repository/contentbank:accessgeneralcontent', 1, [[timestamp]], 0),
(1337, 1, 2, 'repository/coursefiles:view', 1, [[timestamp]], 0),
(1338, 1, 4, 'repository/coursefiles:view', 1, [[timestamp]], 0),
(1339, 1, 3, 'repository/coursefiles:view', 1, [[timestamp]], 0),
(1340, 1, 1, 'repository/coursefiles:view', 1, [[timestamp]], 0),
(1341, 1, 7, 'repository/dropbox:view', 1, [[timestamp]], 0),
(1342, 1, 7, 'repository/equella:view', 1, [[timestamp]], 0),
(1343, 1, 2, 'repository/filesystem:view', 1, [[timestamp]], 0),
(1344, 1, 4, 'repository/filesystem:view', 1, [[timestamp]], 0),
(1345, 1, 3, 'repository/filesystem:view', 1, [[timestamp]], 0),
(1346, 1, 1, 'repository/filesystem:view', 1, [[timestamp]], 0),
(1347, 1, 7, 'repository/flickr:view', 1, [[timestamp]], 0),
(1348, 1, 7, 'repository/flickr_public:view', 1, [[timestamp]], 0),
(1349, 1, 7, 'repository/googledocs:view', 1, [[timestamp]], 0),
(1350, 1, 2, 'repository/local:view', 1, [[timestamp]], 0),
(1351, 1, 4, 'repository/local:view', 1, [[timestamp]], 0),
(1352, 1, 3, 'repository/local:view', 1, [[timestamp]], 0),
(1353, 1, 1, 'repository/local:view', 1, [[timestamp]], 0),
(1354, 1, 7, 'repository/merlot:view', 1, [[timestamp]], 0),
(1355, 1, 7, 'repository/nextcloud:view', 1, [[timestamp]], 0),
(1356, 1, 7, 'repository/onedrive:view', 1, [[timestamp]], 0),
(1357, 1, 7, 'repository/recent:view', 1, [[timestamp]], 0),
(1358, 1, 7, 'repository/s3:view', 1, [[timestamp]], 0),
(1359, 1, 7, 'repository/upload:view', 1, [[timestamp]], 0),
(1360, 1, 7, 'repository/url:view', 1, [[timestamp]], 0),
(1361, 1, 7, 'repository/user:view', 1, [[timestamp]], 0),
(1362, 1, 2, 'repository/webdav:view', 1, [[timestamp]], 0),
(1363, 1, 4, 'repository/webdav:view', 1, [[timestamp]], 0),
(1364, 1, 3, 'repository/webdav:view', 1, [[timestamp]], 0),
(1365, 1, 1, 'repository/webdav:view', 1, [[timestamp]], 0),
(1366, 1, 7, 'repository/wikimedia:view', 1, [[timestamp]], 0),
(1367, 1, 7, 'repository/youtube:view', 1, [[timestamp]], 0),
(1368, 1, 3, 'moodle/question:commentmine', 1, [[timestamp]], 0),
(1369, 1, 1, 'moodle/question:commentmine', 1, [[timestamp]], 0),
(1370, 1, 3, 'moodle/question:commentall', 1, [[timestamp]], 0),
(1371, 1, 1, 'moodle/question:commentall', 1, [[timestamp]], 0),
(1372, 1, 1, 'qbank/customfields:changelockedcustomfields', 1, [[timestamp]], 0),
(1373, 1, 3, 'qbank/customfields:viewhiddencustomfields', 1, [[timestamp]], 0),
(1374, 1, 1, 'qbank/customfields:viewhiddencustomfields', 1, [[timestamp]], 0),
(1375, 1, 4, 'tool/brickfield:viewcoursetools', 1, [[timestamp]], 0),
(1376, 1, 3, 'tool/brickfield:viewcoursetools', 1, [[timestamp]], 0),
(1377, 1, 1, 'tool/brickfield:viewcoursetools', 1, [[timestamp]], 0),
(1378, 1, 1, 'tool/brickfield:viewsystemtools', 1, [[timestamp]], 0),
(1379, 1, 1, 'tool/customlang:view', 1, [[timestamp]], 0),
(1380, 1, 1, 'tool/customlang:edit', 1, [[timestamp]], 0),
(1381, 1, 1, 'tool/customlang:export', 1, [[timestamp]], 0),
(1382, 1, 7, 'tool/dataprivacy:downloadownrequest', 1, [[timestamp]], 0),
(1383, 1, 7, 'tool/dataprivacy:requestdelete', 1, [[timestamp]], 0),
(1384, 1, 1, 'tool/lpmigrate:frameworksmigrate', 1, [[timestamp]], 0),
(1385, 1, 7, 'tool/mfa:mfaaccess', 1, [[timestamp]], 0),
(1386, 1, 4, 'tool/monitor:subscribe', 1, [[timestamp]], 0),
(1387, 1, 3, 'tool/monitor:subscribe', 1, [[timestamp]], 0),
(1388, 1, 1, 'tool/monitor:subscribe', 1, [[timestamp]], 0),
(1389, 1, 4, 'tool/monitor:managerules', 1, [[timestamp]], 0),
(1390, 1, 3, 'tool/monitor:managerules', 1, [[timestamp]], 0),
(1391, 1, 1, 'tool/monitor:managerules', 1, [[timestamp]], 0),
(1392, 1, 1, 'tool/monitor:managetool', 1, [[timestamp]], 0),
(1393, 1, 7, 'tool/policy:accept', 1, [[timestamp]], 0),
(1394, 1, 1, 'tool/policy:managedocs', 1, [[timestamp]], 0),
(1395, 1, 1, 'tool/policy:viewacceptances', 1, [[timestamp]], 0),
(1396, 1, 3, 'tool/recyclebin:deleteitems', 1, [[timestamp]], 0),
(1397, 1, 1, 'tool/recyclebin:deleteitems', 1, [[timestamp]], 0),
(1398, 1, 3, 'tool/recyclebin:restoreitems', 1, [[timestamp]], 0),
(1399, 1, 1, 'tool/recyclebin:restoreitems', 1, [[timestamp]], 0),
(1400, 1, 4, 'tool/recyclebin:viewitems', 1, [[timestamp]], 0),
(1401, 1, 3, 'tool/recyclebin:viewitems', 1, [[timestamp]], 0),
(1402, 1, 1, 'tool/recyclebin:viewitems', 1, [[timestamp]], 0),
(1403, 1, 1, 'tool/uploadcourse:use', 1, [[timestamp]], 0),
(1404, 1, 1, 'tool/uploaduser:uploaduserpictures', 1, [[timestamp]], 0),
(1405, 1, 1, 'tool/usertours:managetours', 1, [[timestamp]], 0),
(1406, 1, 1, 'contenttype/h5p:access', 1, [[timestamp]], 0),
(1407, 1, 2, 'contenttype/h5p:access', 1, [[timestamp]], 0),
(1408, 1, 3, 'contenttype/h5p:access', 1, [[timestamp]], 0),
(1409, 1, 1, 'contenttype/h5p:upload', 1, [[timestamp]], 0),
(1410, 1, 2, 'contenttype/h5p:upload', 1, [[timestamp]], 0),
(1411, 1, 3, 'contenttype/h5p:upload', 1, [[timestamp]], 0),
(1412, 1, 1, 'contenttype/h5p:useeditor', 1, [[timestamp]], 0),
(1413, 1, 2, 'contenttype/h5p:useeditor', 1, [[timestamp]], 0),
(1414, 1, 3, 'contenttype/h5p:useeditor', 1, [[timestamp]], 0),
(1415, 1, 3, 'booktool/importhtml:import', 1, [[timestamp]], 0),
(1416, 1, 1, 'booktool/importhtml:import', 1, [[timestamp]], 0),
(1417, 1, 6, 'booktool/print:print', 1, [[timestamp]], 0),
(1418, 1, 8, 'booktool/print:print', 1, [[timestamp]], 0),
(1419, 1, 5, 'booktool/print:print', 1, [[timestamp]], 0),
(1420, 1, 4, 'booktool/print:print', 1, [[timestamp]], 0),
(1421, 1, 3, 'booktool/print:print', 1, [[timestamp]], 0),
(1422, 1, 1, 'booktool/print:print', 1, [[timestamp]], 0),
(1423, 1, 4, 'forumreport/summary:view', 1, [[timestamp]], 0),
(1424, 1, 3, 'forumreport/summary:view', 1, [[timestamp]], 0),
(1425, 1, 1, 'forumreport/summary:view', 1, [[timestamp]], 0),
(1426, 1, 4, 'forumreport/summary:viewall', 1, [[timestamp]], 0),
(1427, 1, 3, 'forumreport/summary:viewall', 1, [[timestamp]], 0),
(1428, 1, 1, 'forumreport/summary:viewall', 1, [[timestamp]], 0),
(1429, 1, 4, 'quiz/grading:viewstudentnames', 1, [[timestamp]], 0),
(1430, 1, 3, 'quiz/grading:viewstudentnames', 1, [[timestamp]], 0),
(1431, 1, 1, 'quiz/grading:viewstudentnames', 1, [[timestamp]], 0),
(1432, 1, 4, 'quiz/grading:viewidnumber', 1, [[timestamp]], 0),
(1433, 1, 3, 'quiz/grading:viewidnumber', 1, [[timestamp]], 0),
(1434, 1, 1, 'quiz/grading:viewidnumber', 1, [[timestamp]], 0),
(1435, 1, 4, 'quiz/statistics:view', 1, [[timestamp]], 0),
(1436, 1, 3, 'quiz/statistics:view', 1, [[timestamp]], 0),
(1437, 1, 1, 'quiz/statistics:view', 1, [[timestamp]], 0),
(1438, 1, 1, 'quizaccess/seb:managetemplates', 1, [[timestamp]], 0),
(1439, 1, 1, 'quizaccess/seb:bypassseb', 1, [[timestamp]], 0),
(1440, 1, 3, 'quizaccess/seb:bypassseb', 1, [[timestamp]], 0),
(1441, 1, 1, 'quizaccess/seb:manage_seb_requiresafeexambrowser', 1, [[timestamp]], 0),
(1442, 1, 3, 'quizaccess/seb:manage_seb_requiresafeexambrowser', 1, [[timestamp]], 0),
(1443, 1, 1, 'quizaccess/seb:manage_seb_configuremanually', 1, [[timestamp]], 0),
(1444, 1, 3, 'quizaccess/seb:manage_seb_configuremanually', 1, [[timestamp]], 0),
(1445, 1, 1, 'quizaccess/seb:manage_seb_usesebclientconfig', 1, [[timestamp]], 0),
(1446, 1, 3, 'quizaccess/seb:manage_seb_usesebclientconfig', 1, [[timestamp]], 0),
(1447, 1, 1, 'quizaccess/seb:manage_seb_templateid', 1, [[timestamp]], 0),
(1448, 1, 3, 'quizaccess/seb:manage_seb_templateid', 1, [[timestamp]], 0),
(1449, 1, 1, 'quizaccess/seb:manage_filemanager_sebconfigfile', 1, [[timestamp]], 0),
(1450, 1, 3, 'quizaccess/seb:manage_filemanager_sebconfigfile', 1, [[timestamp]], 0),
(1451, 1, 1, 'quizaccess/seb:manage_seb_showsebdownloadlink', 1, [[timestamp]], 0),
(1452, 1, 3, 'quizaccess/seb:manage_seb_showsebdownloadlink', 1, [[timestamp]], 0),
(1453, 1, 1, 'quizaccess/seb:manage_seb_allowedbrowserexamkeys', 1, [[timestamp]], 0),
(1454, 1, 3, 'quizaccess/seb:manage_seb_allowedbrowserexamkeys', 1, [[timestamp]], 0),
(1455, 1, 1, 'quizaccess/seb:manage_seb_linkquitseb', 1, [[timestamp]], 0),
(1456, 1, 3, 'quizaccess/seb:manage_seb_linkquitseb', 1, [[timestamp]], 0),
(1457, 1, 1, 'quizaccess/seb:manage_seb_userconfirmquit', 1, [[timestamp]], 0),
(1458, 1, 3, 'quizaccess/seb:manage_seb_userconfirmquit', 1, [[timestamp]], 0),
(1459, 1, 1, 'quizaccess/seb:manage_seb_allowuserquitseb', 1, [[timestamp]], 0),
(1460, 1, 3, 'quizaccess/seb:manage_seb_allowuserquitseb', 1, [[timestamp]], 0),
(1461, 1, 1, 'quizaccess/seb:manage_seb_quitpassword', 1, [[timestamp]], 0),
(1462, 1, 3, 'quizaccess/seb:manage_seb_quitpassword', 1, [[timestamp]], 0),
(1463, 1, 1, 'quizaccess/seb:manage_seb_allowreloadinexam', 1, [[timestamp]], 0),
(1464, 1, 3, 'quizaccess/seb:manage_seb_allowreloadinexam', 1, [[timestamp]], 0),
(1465, 1, 1, 'quizaccess/seb:manage_seb_showsebtaskbar', 1, [[timestamp]], 0),
(1466, 1, 3, 'quizaccess/seb:manage_seb_showsebtaskbar', 1, [[timestamp]], 0),
(1467, 1, 1, 'quizaccess/seb:manage_seb_showreloadbutton', 1, [[timestamp]], 0),
(1468, 1, 3, 'quizaccess/seb:manage_seb_showreloadbutton', 1, [[timestamp]], 0),
(1469, 1, 1, 'quizaccess/seb:manage_seb_showtime', 1, [[timestamp]], 0),
(1470, 1, 3, 'quizaccess/seb:manage_seb_showtime', 1, [[timestamp]], 0),
(1471, 1, 1, 'quizaccess/seb:manage_seb_showkeyboardlayout', 1, [[timestamp]], 0),
(1472, 1, 3, 'quizaccess/seb:manage_seb_showkeyboardlayout', 1, [[timestamp]], 0),
(1473, 1, 1, 'quizaccess/seb:manage_seb_showwificontrol', 1, [[timestamp]], 0),
(1474, 1, 3, 'quizaccess/seb:manage_seb_showwificontrol', 1, [[timestamp]], 0),
(1475, 1, 1, 'quizaccess/seb:manage_seb_enableaudiocontrol', 1, [[timestamp]], 0),
(1476, 1, 3, 'quizaccess/seb:manage_seb_enableaudiocontrol', 1, [[timestamp]], 0),
(1477, 1, 1, 'quizaccess/seb:manage_seb_muteonstartup', 1, [[timestamp]], 0),
(1478, 1, 3, 'quizaccess/seb:manage_seb_muteonstartup', 1, [[timestamp]], 0),
(1479, 1, 1, 'quizaccess/seb:manage_seb_allowcapturecamera', 1, [[timestamp]], 0),
(1480, 1, 3, 'quizaccess/seb:manage_seb_allowcapturecamera', 1, [[timestamp]], 0),
(1481, 1, 1, 'quizaccess/seb:manage_seb_allowcapturemicrophone', 1, [[timestamp]], 0),
(1482, 1, 3, 'quizaccess/seb:manage_seb_allowcapturemicrophone', 1, [[timestamp]], 0),
(1483, 1, 1, 'quizaccess/seb:manage_seb_allowspellchecking', 1, [[timestamp]], 0),
(1484, 1, 3, 'quizaccess/seb:manage_seb_allowspellchecking', 1, [[timestamp]], 0),
(1485, 1, 1, 'quizaccess/seb:manage_seb_activateurlfiltering', 1, [[timestamp]], 0),
(1486, 1, 3, 'quizaccess/seb:manage_seb_activateurlfiltering', 1, [[timestamp]], 0),
(1487, 1, 1, 'quizaccess/seb:manage_seb_filterembeddedcontent', 1, [[timestamp]], 0),
(1488, 1, 3, 'quizaccess/seb:manage_seb_filterembeddedcontent', 1, [[timestamp]], 0),
(1489, 1, 1, 'quizaccess/seb:manage_seb_expressionsallowed', 1, [[timestamp]], 0),
(1490, 1, 3, 'quizaccess/seb:manage_seb_expressionsallowed', 1, [[timestamp]], 0),
(1491, 1, 1, 'quizaccess/seb:manage_seb_regexallowed', 1, [[timestamp]], 0),
(1492, 1, 3, 'quizaccess/seb:manage_seb_regexallowed', 1, [[timestamp]], 0),
(1493, 1, 1, 'quizaccess/seb:manage_seb_expressionsblocked', 1, [[timestamp]], 0),
(1494, 1, 3, 'quizaccess/seb:manage_seb_expressionsblocked', 1, [[timestamp]], 0),
(1495, 1, 1, 'quizaccess/seb:manage_seb_regexblocked', 1, [[timestamp]], 0),
(1496, 1, 3, 'quizaccess/seb:manage_seb_regexblocked', 1, [[timestamp]], 0),
(1497, 1, 7, 'tiny/accessibilitychecker:use', 1, [[timestamp]], 0),
(1498, 1, 7, 'tiny/autosave:use', 1, [[timestamp]], 0),
(1499, 1, 7, 'tiny/equation:use', 1, [[timestamp]], 0),
(1500, 1, 3, 'tiny/h5p:addembed', 1, [[timestamp]], 0),
(1501, 1, 3, 'tiny/h5p:use', 1, [[timestamp]], 0),
(1502, 1, 7, 'tiny/html:use', 1, [[timestamp]], 0),
(1503, 1, 7, 'tiny/link:use', 1, [[timestamp]], 0),
(1504, 1, 7, 'tiny/media:use', 1, [[timestamp]], 0),
(1505, 1, 7, 'tiny/noautolink:use', 1, [[timestamp]], 0),
(1506, 1, 7, 'tiny/premium:use', 1, [[timestamp]], 0),
(1507, 1, 7, 'tiny/premium:usea11ychecker', 1, [[timestamp]], 0),
(1508, 1, 7, 'tiny/premium:useadvtable', 1, [[timestamp]], 0),
(1509, 1, 7, 'tiny/premium:usetypography', 1, [[timestamp]], 0),
(1510, 1, 7, 'tiny/premium:usecasechange', 1, [[timestamp]], 0),
(1511, 1, 7, 'tiny/premium:usechecklist', 1, [[timestamp]], 0),
(1512, 1, 7, 'tiny/premium:useeditimage', 1, [[timestamp]], 0),
(1513, 1, 7, 'tiny/premium:useexport', 1, [[timestamp]], 0),
(1514, 1, 7, 'tiny/premium:usefootnotes', 1, [[timestamp]], 0),
(1515, 1, 7, 'tiny/premium:useformatpainter', 1, [[timestamp]], 0),
(1516, 1, 7, 'tiny/premium:uselinkchecker', 1, [[timestamp]], 0),
(1517, 1, 7, 'tiny/premium:usepageembed', 1, [[timestamp]], 0),
(1518, 1, 7, 'tiny/premium:usepermanentpen', 1, [[timestamp]], 0),
(1519, 1, 7, 'tiny/premium:usepowerpaste', 1, [[timestamp]], 0),
(1520, 1, 7, 'tiny/premium:usetinymcespellchecker', 1, [[timestamp]], 0),
(1521, 1, 7, 'tiny/premium:useautocorrect', 1, [[timestamp]], 0),
(1522, 1, 7, 'tiny/premium:usetableofcontents', 1, [[timestamp]], 0),
(1523, 1, 7, 'tiny/premium:usemath', 1, [[timestamp]], 0),
(1524, 1, 7, 'tiny/recordrtc:recordaudio', 1, [[timestamp]], 0),
(1525, 1, 7, 'tiny/recordrtc:recordvideo', 1, [[timestamp]], 0),
(1526, 1, 7, 'tiny/recordrtc:recordscreen', 1, [[timestamp]], 0),
(1527, 1, 7, 'tiny/recordrtc:use', 1, [[timestamp]], 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]role_context_levels`
--

CREATE TABLE `[[dbprefix]]role_context_levels` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `roleid` bigint NOT NULL,
  `contextlevel` bigint NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]rolecontleve_conrol_uix` (`contextlevel`,`roleid`),
  KEY `[[dbprefix]]rolecontleve_rol_ix` (`roleid`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Lists which roles can be assigned at which context levels. T' AUTO_INCREMENT=12 ;

--
-- Dumping data for table `[[dbprefix]]role_context_levels`
--

INSERT INTO `[[dbprefix]]role_context_levels` VALUES
(1, 1, 10),
(4, 2, 10),
(2, 1, 40),
(5, 2, 40),
(3, 1, 50),
(6, 3, 50),
(8, 4, 50),
(10, 5, 50),
(7, 3, 70),
(9, 4, 70),
(11, 5, 70);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]role_names`
--

CREATE TABLE `[[dbprefix]]role_names` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `roleid` bigint NOT NULL DEFAULT '0',
  `contextid` bigint NOT NULL DEFAULT '0',
  `name` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]rolename_rolcon_uix` (`roleid`,`contextid`),
  KEY `[[dbprefix]]rolename_rol_ix` (`roleid`),
  KEY `[[dbprefix]]rolename_con_ix` (`contextid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='role names in native strings' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]scale`
--

CREATE TABLE `[[dbprefix]]scale` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `courseid` bigint NOT NULL DEFAULT '0',
  `userid` bigint NOT NULL DEFAULT '0',
  `name` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `scale` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `description` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `descriptionformat` tinyint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]scal_cou_ix` (`courseid`),
  KEY `[[dbprefix]]scal_use_ix` (`userid`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Defines grading scales' AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]scale`
--

INSERT INTO `[[dbprefix]]scale` VALUES
(1, 0, 0, 'Separate and Connected ways of knowing', 'Mostly separate knowing,Separate and connected,Mostly connected knowing', 'The scale based on the theory of separate and connected knowing. This theory describes two different ways that we can evaluate and learn about the things we see and hear.<ul><li><strong>Separate knowers</strong> remain as objective as possible without including feelings and emotions. In a discussion with other people, they like to defend their own ideas, using logic to find holes in opponent''s ideas.</li><li><strong>Connected knowers</strong> are more sensitive to other people. They are skilled at empathy and tend to listen and ask questions until they feel they can connect and "understand things from their point of view". They learn by trying to share the experiences that led to the knowledge they find in other people.</li></ul>', 0, [[timestamp]]),
(2, 0, 0, 'Default competence scale', 'Not yet competent,Competent', 'A binary rating scale that provides no further information beyond whether someone has demonstrated proficiency or not.', 0, [[timestamp]]);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]scale_history`
--

CREATE TABLE `[[dbprefix]]scale_history` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `action` bigint NOT NULL DEFAULT '0',
  `oldid` bigint NOT NULL,
  `source` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `timemodified` bigint DEFAULT NULL,
  `loggeduser` bigint DEFAULT NULL,
  `courseid` bigint NOT NULL DEFAULT '0',
  `userid` bigint NOT NULL DEFAULT '0',
  `name` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `scale` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `description` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]scalhist_act_ix` (`action`),
  KEY `[[dbprefix]]scalhist_tim_ix` (`timemodified`),
  KEY `[[dbprefix]]scalhist_old_ix` (`oldid`),
  KEY `[[dbprefix]]scalhist_cou_ix` (`courseid`),
  KEY `[[dbprefix]]scalhist_log_ix` (`loggeduser`),
  KEY `[[dbprefix]]scalhist_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='History table';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]scorm`
--

CREATE TABLE `[[dbprefix]]scorm` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `course` bigint NOT NULL DEFAULT '0',
  `name` varchar(1333) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `scormtype` varchar(50) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT 'local',
  `reference` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `intro` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `introformat` smallint NOT NULL DEFAULT '0',
  `version` varchar(9) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `maxgrade` double NOT NULL DEFAULT '0',
  `grademethod` tinyint NOT NULL DEFAULT '0',
  `whatgrade` bigint NOT NULL DEFAULT '0',
  `maxattempt` bigint NOT NULL DEFAULT '1',
  `forcecompleted` tinyint(1) NOT NULL DEFAULT '0',
  `forcenewattempt` tinyint(1) NOT NULL DEFAULT '0',
  `lastattemptlock` tinyint(1) NOT NULL DEFAULT '0',
  `masteryoverride` tinyint(1) NOT NULL DEFAULT '1',
  `displayattemptstatus` tinyint(1) NOT NULL DEFAULT '1',
  `displaycoursestructure` tinyint(1) NOT NULL DEFAULT '0',
  `updatefreq` tinyint(1) NOT NULL DEFAULT '0',
  `sha1hash` varchar(40) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `md5hash` varchar(32) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `revision` bigint NOT NULL DEFAULT '0',
  `launch` bigint NOT NULL DEFAULT '0',
  `skipview` tinyint(1) NOT NULL DEFAULT '1',
  `hidebrowse` tinyint(1) NOT NULL DEFAULT '0',
  `hidetoc` tinyint(1) NOT NULL DEFAULT '0',
  `nav` tinyint(1) NOT NULL DEFAULT '1',
  `navpositionleft` bigint DEFAULT '-100',
  `navpositiontop` bigint DEFAULT '-100',
  `auto` tinyint(1) NOT NULL DEFAULT '0',
  `popup` tinyint(1) NOT NULL DEFAULT '0',
  `options` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `width` bigint NOT NULL DEFAULT '100',
  `height` bigint NOT NULL DEFAULT '600',
  `timeopen` bigint NOT NULL DEFAULT '0',
  `timeclose` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  `completionstatusrequired` tinyint(1) DEFAULT NULL,
  `completionscorerequired` bigint DEFAULT NULL,
  `completionstatusallscos` tinyint(1) DEFAULT NULL,
  `autocommit` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]scor_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='each table is one SCORM module and its configuration' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]scorm_aicc_session`
--

CREATE TABLE `[[dbprefix]]scorm_aicc_session` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `userid` bigint NOT NULL DEFAULT '0',
  `scormid` bigint NOT NULL DEFAULT '0',
  `hacpsession` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `scoid` bigint DEFAULT '0',
  `scormmode` varchar(50) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `scormstatus` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `attempt` bigint DEFAULT NULL,
  `lessonstatus` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `sessiontime` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `timecreated` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]scoraiccsess_sco_ix` (`scormid`),
  KEY `[[dbprefix]]scoraiccsess_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Used by AICC HACP to store session information';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]scorm_attempt`
--

CREATE TABLE `[[dbprefix]]scorm_attempt` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `userid` bigint NOT NULL,
  `scormid` bigint NOT NULL,
  `attempt` bigint NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]scoratte_use_ix` (`userid`),
  KEY `[[dbprefix]]scoratte_sco_ix` (`scormid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='List of SCORM attempts made by user.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]scorm_element`
--

CREATE TABLE `[[dbprefix]]scorm_element` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `element` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]scorelem_ele_uix` (`element`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='List of scorm elements.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]scorm_scoes`
--

CREATE TABLE `[[dbprefix]]scorm_scoes` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `scorm` bigint NOT NULL DEFAULT '0',
  `manifest` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `organization` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `parent` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `identifier` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `launch` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `scormtype` varchar(5) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `title` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `sortorder` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]scorscoe_sco_ix` (`scorm`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='each SCO part of the SCORM module';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]scorm_scoes_data`
--

CREATE TABLE `[[dbprefix]]scorm_scoes_data` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `scoid` bigint NOT NULL DEFAULT '0',
  `name` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `value` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]scorscoedata_sco_ix` (`scoid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Contains variable data get from packages';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]scorm_scoes_value`
--

CREATE TABLE `[[dbprefix]]scorm_scoes_value` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `scoid` bigint NOT NULL,
  `attemptid` bigint NOT NULL,
  `elementid` bigint NOT NULL,
  `value` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `timemodified` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]scorscoevalu_sco_ix` (`scoid`),
  KEY `[[dbprefix]]scorscoevalu_att_ix` (`attemptid`),
  KEY `[[dbprefix]]scorscoevalu_ele_ix` (`elementid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Values passed from SCORM package';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]scorm_seq_mapinfo`
--

CREATE TABLE `[[dbprefix]]scorm_seq_mapinfo` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `scoid` bigint NOT NULL DEFAULT '0',
  `objectiveid` bigint NOT NULL DEFAULT '0',
  `targetobjectiveid` bigint NOT NULL DEFAULT '0',
  `readsatisfiedstatus` tinyint(1) NOT NULL DEFAULT '1',
  `readnormalizedmeasure` tinyint(1) NOT NULL DEFAULT '1',
  `writesatisfiedstatus` tinyint(1) NOT NULL DEFAULT '0',
  `writenormalizedmeasure` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]scorseqmapi_scoidobj_uix` (`scoid`,`id`,`objectiveid`),
  KEY `[[dbprefix]]scorseqmapi_sco_ix` (`scoid`),
  KEY `[[dbprefix]]scorseqmapi_obj_ix` (`objectiveid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='SCORM2004 objective mapinfo description';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]scorm_seq_objective`
--

CREATE TABLE `[[dbprefix]]scorm_seq_objective` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `scoid` bigint NOT NULL DEFAULT '0',
  `primaryobj` tinyint(1) NOT NULL DEFAULT '0',
  `objectiveid` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `satisfiedbymeasure` tinyint(1) NOT NULL DEFAULT '1',
  `minnormalizedmeasure` float(11,4) NOT NULL DEFAULT '0.0000',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]scorseqobje_scoid_uix` (`scoid`,`id`),
  KEY `[[dbprefix]]scorseqobje_sco_ix` (`scoid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='SCORM2004 objective description';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]scorm_seq_rolluprule`
--

CREATE TABLE `[[dbprefix]]scorm_seq_rolluprule` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `scoid` bigint NOT NULL DEFAULT '0',
  `childactivityset` varchar(15) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `minimumcount` bigint NOT NULL DEFAULT '0',
  `minimumpercent` float(11,4) NOT NULL DEFAULT '0.0000',
  `conditioncombination` varchar(3) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT 'all',
  `action` varchar(15) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]scorseqroll_scoid_uix` (`scoid`,`id`),
  KEY `[[dbprefix]]scorseqroll_sco_ix` (`scoid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='SCORM2004 sequencing rule';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]scorm_seq_rolluprulecond`
--

CREATE TABLE `[[dbprefix]]scorm_seq_rolluprulecond` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `scoid` bigint NOT NULL DEFAULT '0',
  `rollupruleid` bigint NOT NULL DEFAULT '0',
  `operator` varchar(5) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT 'noOp',
  `cond` varchar(25) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]scorseqroll_scorolid_uix` (`scoid`,`rollupruleid`,`id`),
  KEY `[[dbprefix]]scorseqroll_sco2_ix` (`scoid`),
  KEY `[[dbprefix]]scorseqroll_rol_ix` (`rollupruleid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='SCORM2004 sequencing rule';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]scorm_seq_rulecond`
--

CREATE TABLE `[[dbprefix]]scorm_seq_rulecond` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `scoid` bigint NOT NULL DEFAULT '0',
  `ruleconditionsid` bigint NOT NULL DEFAULT '0',
  `refrencedobjective` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `measurethreshold` float(11,4) NOT NULL DEFAULT '0.0000',
  `operator` varchar(5) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT 'noOp',
  `cond` varchar(30) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT 'always',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]scorseqrule_idscorul_uix` (`id`,`scoid`,`ruleconditionsid`),
  KEY `[[dbprefix]]scorseqrule_sco2_ix` (`scoid`),
  KEY `[[dbprefix]]scorseqrule_rul_ix` (`ruleconditionsid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='SCORM2004 rule condition';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]scorm_seq_ruleconds`
--

CREATE TABLE `[[dbprefix]]scorm_seq_ruleconds` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `scoid` bigint NOT NULL DEFAULT '0',
  `conditioncombination` varchar(3) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT 'all',
  `ruletype` tinyint NOT NULL DEFAULT '0',
  `action` varchar(25) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]scorseqrule_scoid_uix` (`scoid`,`id`),
  KEY `[[dbprefix]]scorseqrule_sco_ix` (`scoid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='SCORM2004 rule conditions';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]search_index_requests`
--

CREATE TABLE `[[dbprefix]]search_index_requests` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `contextid` bigint NOT NULL,
  `searcharea` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `timerequested` bigint NOT NULL,
  `partialarea` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `partialtime` bigint NOT NULL,
  `indexpriority` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]searinderequ_indtim_ix` (`indexpriority`,`timerequested`),
  KEY `[[dbprefix]]searinderequ_con_ix` (`contextid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Records requests for (re)indexing of specific contexts. Entr';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]search_simpledb_index`
--

CREATE TABLE `[[dbprefix]]search_simpledb_index` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `docid` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `itemid` bigint NOT NULL,
  `title` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `content` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `contextid` bigint NOT NULL,
  `areaid` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `type` tinyint(1) NOT NULL,
  `courseid` bigint NOT NULL,
  `owneruserid` bigint DEFAULT NULL,
  `modified` bigint NOT NULL,
  `userid` bigint DEFAULT NULL,
  `description1` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `description2` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]searsimpinde_doc_uix` (`docid`),
  KEY `[[dbprefix]]searsimpinde_owncon_ix` (`owneruserid`,`contextid`),
  KEY `[[dbprefix]]searsimpinde_con_ix` (`contextid`),
  KEY `[[dbprefix]]searsimpinde_cou_ix` (`courseid`),
  KEY `[[dbprefix]]searsimpinde_are_ix` (`areaid`),
  FULLTEXT KEY `[[dbprefix]]search_simpledb_index_index` (`title`,`content`,`description1`,`description2`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='search_simpledb table containing the index data.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]sessions`
--

CREATE TABLE `[[dbprefix]]sessions` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `state` bigint NOT NULL DEFAULT '0',
  `sid` varchar(128) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `userid` bigint NOT NULL,
  `sessdata` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  `firstip` varchar(45) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `lastip` varchar(45) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]sess_sid_uix` (`sid`),
  KEY `[[dbprefix]]sess_sta_ix` (`state`),
  KEY `[[dbprefix]]sess_tim_ix` (`timecreated`),
  KEY `[[dbprefix]]sess_tim2_ix` (`timemodified`),
  KEY `[[dbprefix]]sess_use_ix` (`userid`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Database based session storage - now recommended' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]shortlink`
--

CREATE TABLE `[[dbprefix]]shortlink` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `shortcode` varchar(12) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `userid` bigint NOT NULL,
  `component` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `linktype` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `identifier` varchar(1333) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]shor_usesho_uix` (`userid`,`shortcode`),
  KEY `[[dbprefix]]shor_sho_ix` (`shortcode`),
  KEY `[[dbprefix]]shor_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Short codes for user short links';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]sms_gateways`
--

CREATE TABLE `[[dbprefix]]sms_gateways` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `gateway` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `enabled` tinyint NOT NULL DEFAULT '1',
  `config` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Instances of SMS gateways' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]sms_messages`
--

CREATE TABLE `[[dbprefix]]sms_messages` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `recipientnumber` varchar(30) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `content` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `component` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `messagetype` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `recipientuserid` bigint DEFAULT NULL,
  `issensitive` tinyint NOT NULL DEFAULT '0',
  `gatewayid` bigint DEFAULT NULL,
  `status` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `timecreated` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]smsmess_gat_ix` (`gatewayid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='SMS Messages sent via the SMS subsystem';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]stats_daily`
--

CREATE TABLE `[[dbprefix]]stats_daily` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `courseid` bigint NOT NULL DEFAULT '0',
  `timeend` bigint NOT NULL DEFAULT '0',
  `roleid` bigint NOT NULL DEFAULT '0',
  `stattype` varchar(20) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT 'activity',
  `stat1` bigint NOT NULL DEFAULT '0',
  `stat2` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]statdail_cou_ix` (`courseid`),
  KEY `[[dbprefix]]statdail_tim_ix` (`timeend`),
  KEY `[[dbprefix]]statdail_rol_ix` (`roleid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='to accumulate daily stats';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]stats_monthly`
--

CREATE TABLE `[[dbprefix]]stats_monthly` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `courseid` bigint NOT NULL DEFAULT '0',
  `timeend` bigint NOT NULL DEFAULT '0',
  `roleid` bigint NOT NULL DEFAULT '0',
  `stattype` varchar(20) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT 'activity',
  `stat1` bigint NOT NULL DEFAULT '0',
  `stat2` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]statmont_cou_ix` (`courseid`),
  KEY `[[dbprefix]]statmont_tim_ix` (`timeend`),
  KEY `[[dbprefix]]statmont_rol_ix` (`roleid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='To accumulate monthly stats';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]stats_user_daily`
--

CREATE TABLE `[[dbprefix]]stats_user_daily` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `courseid` bigint NOT NULL DEFAULT '0',
  `userid` bigint NOT NULL DEFAULT '0',
  `roleid` bigint NOT NULL DEFAULT '0',
  `timeend` bigint NOT NULL DEFAULT '0',
  `statsreads` bigint NOT NULL DEFAULT '0',
  `statswrites` bigint NOT NULL DEFAULT '0',
  `stattype` varchar(30) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]statuserdail_cou_ix` (`courseid`),
  KEY `[[dbprefix]]statuserdail_use_ix` (`userid`),
  KEY `[[dbprefix]]statuserdail_rol_ix` (`roleid`),
  KEY `[[dbprefix]]statuserdail_tim_ix` (`timeend`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='To accumulate daily stats per course/user';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]stats_user_monthly`
--

CREATE TABLE `[[dbprefix]]stats_user_monthly` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `courseid` bigint NOT NULL DEFAULT '0',
  `userid` bigint NOT NULL DEFAULT '0',
  `roleid` bigint NOT NULL DEFAULT '0',
  `timeend` bigint NOT NULL DEFAULT '0',
  `statsreads` bigint NOT NULL DEFAULT '0',
  `statswrites` bigint NOT NULL DEFAULT '0',
  `stattype` varchar(30) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]statusermont_cou_ix` (`courseid`),
  KEY `[[dbprefix]]statusermont_use_ix` (`userid`),
  KEY `[[dbprefix]]statusermont_rol_ix` (`roleid`),
  KEY `[[dbprefix]]statusermont_tim_ix` (`timeend`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='To accumulate monthly stats per course/user';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]stats_user_weekly`
--

CREATE TABLE `[[dbprefix]]stats_user_weekly` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `courseid` bigint NOT NULL DEFAULT '0',
  `userid` bigint NOT NULL DEFAULT '0',
  `roleid` bigint NOT NULL DEFAULT '0',
  `timeend` bigint NOT NULL DEFAULT '0',
  `statsreads` bigint NOT NULL DEFAULT '0',
  `statswrites` bigint NOT NULL DEFAULT '0',
  `stattype` varchar(30) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]statuserweek_cou_ix` (`courseid`),
  KEY `[[dbprefix]]statuserweek_use_ix` (`userid`),
  KEY `[[dbprefix]]statuserweek_rol_ix` (`roleid`),
  KEY `[[dbprefix]]statuserweek_tim_ix` (`timeend`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='To accumulate weekly stats per course/user';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]stats_weekly`
--

CREATE TABLE `[[dbprefix]]stats_weekly` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `courseid` bigint NOT NULL DEFAULT '0',
  `timeend` bigint NOT NULL DEFAULT '0',
  `roleid` bigint NOT NULL DEFAULT '0',
  `stattype` varchar(20) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT 'activity',
  `stat1` bigint NOT NULL DEFAULT '0',
  `stat2` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]statweek_cou_ix` (`courseid`),
  KEY `[[dbprefix]]statweek_tim_ix` (`timeend`),
  KEY `[[dbprefix]]statweek_rol_ix` (`roleid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='To accumulate weekly stats';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]stored_progress`
--

CREATE TABLE `[[dbprefix]]stored_progress` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `idnumber` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `timestart` bigint DEFAULT NULL,
  `lastupdate` bigint DEFAULT NULL,
  `percentcompleted` decimal(5,2) DEFAULT '0.00',
  `message` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `haserrored` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]storprog_idn_ix` (`idnumber`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Records for any long running tasks we want to poll for progr';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]subsection`
--

CREATE TABLE `[[dbprefix]]subsection` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `course` bigint NOT NULL DEFAULT '0',
  `name` varchar(1333) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `timemodified` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]subs_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Stores the delegated subsection instances.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tag`
--

CREATE TABLE `[[dbprefix]]tag` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `userid` bigint NOT NULL,
  `tagcollid` bigint NOT NULL,
  `name` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `rawname` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `isstandard` tinyint(1) NOT NULL DEFAULT '0',
  `description` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `descriptionformat` tinyint NOT NULL DEFAULT '0',
  `flag` smallint DEFAULT '0',
  `timemodified` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]tag_tagnam_uix` (`tagcollid`,`name`),
  KEY `[[dbprefix]]tag_tagiss_ix` (`tagcollid`,`isstandard`),
  KEY `[[dbprefix]]tag_use_ix` (`userid`),
  KEY `[[dbprefix]]tag_tag_ix` (`tagcollid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Tag table - this generic table will replace the old "tags" t' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tag_area`
--

CREATE TABLE `[[dbprefix]]tag_area` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `component` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `itemtype` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `enabled` tinyint(1) NOT NULL DEFAULT '1',
  `tagcollid` bigint NOT NULL,
  `callback` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `callbackfile` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `showstandard` tinyint(1) NOT NULL DEFAULT '0',
  `multiplecontexts` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]tagarea_comite_uix` (`component`,`itemtype`),
  KEY `[[dbprefix]]tagarea_tag_ix` (`tagcollid`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Defines various tag areas, one area is identified by compone' AUTO_INCREMENT=14 ;

--
-- Dumping data for table `[[dbprefix]]tag_area`
--

INSERT INTO `[[dbprefix]]tag_area` VALUES
(1, 'core', 'user', 1, 1, 'user_get_tagged_users', '/user/lib.php', 2, 0),
(2, 'core', 'course', 1, 1, 'course_get_tagged_courses', '/course/lib.php', 0, 0),
(3, 'core_question', 'question', 1, 1, NULL, NULL, 0, 1),
(4, 'core', 'post', 1, 1, 'blog_get_tagged_posts', '/blog/lib.php', 0, 0),
(5, 'core', 'blog_external', 1, 1, NULL, NULL, 0, 0),
(6, 'core', 'course_modules', 1, 1, 'course_get_tagged_course_modules', '/course/lib.php', 0, 0),
(7, 'core_badges', 'badge', 1, 1, 'badge_get_tagged_badges', '/badges/lib.php', 0, 0),
(8, 'core_reportbuilder', 'reportbuilder_report', 1, 1, 'core_reportbuilder_get_tagged_reports', '/reportbuilder/lib.php', 0, 0),
(9, 'mod_book', 'book_chapters', 1, 1, 'mod_book_get_tagged_chapters', '/mod/book/locallib.php', 0, 0),
(10, 'mod_data', 'data_records', 1, 1, 'mod_data_get_tagged_records', '/mod/data/locallib.php', 0, 0),
(11, 'mod_forum', 'forum_posts', 1, 1, 'mod_forum_get_tagged_posts', '/mod/forum/locallib.php', 0, 0),
(12, 'mod_glossary', 'glossary_entries', 1, 1, 'mod_glossary_get_tagged_entries', '/mod/glossary/locallib.php', 0, 0),
(13, 'mod_wiki', 'wiki_pages', 1, 1, 'mod_wiki_get_tagged_pages', '/mod/wiki/locallib.php', 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tag_coll`
--

CREATE TABLE `[[dbprefix]]tag_coll` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `isdefault` tinyint NOT NULL DEFAULT '0',
  `component` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `sortorder` mediumint NOT NULL DEFAULT '0',
  `searchable` tinyint NOT NULL DEFAULT '1',
  `customurl` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='Defines different set of tags' AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]tag_coll`
--

INSERT INTO `[[dbprefix]]tag_coll` VALUES
(1, NULL, 1, NULL, 0, 1, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tag_correlation`
--

CREATE TABLE `[[dbprefix]]tag_correlation` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `tagid` bigint NOT NULL,
  `correlatedtags` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]tagcorr_tag_ix` (`tagid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='The rationale for the ''tag_correlation'' table is performance';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tag_instance`
--

CREATE TABLE `[[dbprefix]]tag_instance` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `tagid` bigint NOT NULL,
  `component` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `itemtype` varchar(100) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `itemid` bigint NOT NULL,
  `contextid` bigint DEFAULT NULL,
  `tiuserid` bigint NOT NULL DEFAULT '0',
  `ordering` bigint DEFAULT NULL,
  `timecreated` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]taginst_comiteitecon_uix` (`component`,`itemtype`,`itemid`,`contextid`,`tiuserid`,`tagid`),
  KEY `[[dbprefix]]taginst_itecomtagcon_ix` (`itemtype`,`component`,`tagid`,`contextid`),
  KEY `[[dbprefix]]taginst_tag_ix` (`tagid`),
  KEY `[[dbprefix]]taginst_con_ix` (`contextid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='tag_instance table holds the information of associations bet' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]task_adhoc`
--

CREATE TABLE `[[dbprefix]]task_adhoc` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `component` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `classname` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `nextruntime` bigint NOT NULL,
  `faildelay` bigint DEFAULT NULL,
  `customdata` longtext CHARACTER SET [[utf8]] COLLATE [[collate]],
  `userid` bigint DEFAULT NULL,
  `timecreated` bigint NOT NULL DEFAULT '0',
  `timestarted` bigint DEFAULT NULL,
  `hostname` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `pid` bigint DEFAULT NULL,
  `attemptsavailable` tinyint DEFAULT NULL,
  `firststartingtime` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]taskadho_nex_ix` (`nextruntime`),
  KEY `[[dbprefix]]taskadho_tim_ix` (`timestarted`),
  KEY `[[dbprefix]]taskadho_use_ix` (`userid`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='List of adhoc tasks waiting to run.' AUTO_INCREMENT=3 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]task_log`
--

CREATE TABLE `[[dbprefix]]task_log` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `type` smallint NOT NULL,
  `component` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `classname` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `userid` bigint NOT NULL,
  `timestart` decimal(20,10) NOT NULL,
  `timeend` decimal(20,10) NOT NULL,
  `dbreads` bigint NOT NULL,
  `dbwrites` bigint NOT NULL,
  `result` tinyint NOT NULL,
  `output` longtext CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL,
  `hostname` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `pid` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]tasklog_cla_ix` (`classname`),
  KEY `[[dbprefix]]tasklog_tim_ix` (`timestart`),
  KEY `[[dbprefix]]tasklog_use_ix` (`userid`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='The log table for all tasks' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]task_scheduled`
--

CREATE TABLE `[[dbprefix]]task_scheduled` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `component` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `classname` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `lastruntime` bigint DEFAULT NULL,
  `nextruntime` bigint DEFAULT NULL,
  `minute` varchar(200) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `hour` varchar(70) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `day` varchar(90) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `month` varchar(30) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `dayofweek` varchar(25) CHARACTER SET [[utf8]] COLLATE [[collate]] NOT NULL DEFAULT '',
  `faildelay` bigint DEFAULT NULL,
  `customised` tinyint NOT NULL DEFAULT '0',
  `disabled` tinyint(1) NOT NULL DEFAULT '0',
  `timestarted` bigint DEFAULT NULL,
  `hostname` varchar(255) CHARACTER SET [[utf8]] COLLATE [[collate]] DEFAULT NULL,
  `pid` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]tasksche_cla_uix` (`classname`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[collate]] [[row_format]] COMMENT='List of scheduled tasks to be run by cron.' AUTO_INCREMENT=116 ;

--
-- Dumping data for table `[[dbprefix]]task_scheduled`
--

INSERT INTO `[[dbprefix]]task_scheduled` VALUES
(1, 'moodle', '\\core\\task\\session_cleanup_task', [[timestamp]], [[timestamp]], '*', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(2, 'moodle', '\\core\\task\\delete_unconfirmed_users_task', 0, [[timestamp]], '0', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(3, 'moodle', '\\core\\task\\delete_incomplete_users_task', 0, [[timestamp]], '5', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(4, 'moodle', '\\core\\task\\backup_cleanup_task', 0, [[timestamp]], '10', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(5, 'moodle', '\\core\\task\\tag_cron_task', 0, [[timestamp]], '0', '3', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(6, 'moodle', '\\core\\task\\context_cleanup_task', 0, [[timestamp]], '25', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(7, 'moodle', '\\core\\task\\cache_cleanup_task', 0, [[timestamp]], '30', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(8, 'moodle', '\\core\\task\\messaging_cleanup_task', 0, [[timestamp]], '35', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(9, 'moodle', '\\core\\task\\send_new_user_passwords_task', [[timestamp]], [[timestamp]], '*', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(10, 'moodle', '\\core\\task\\send_failed_login_notifications_task', [[timestamp]], [[timestamp]], '*', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(11, 'moodle', '\\core\\task\\create_contexts_task', 0, [[timestamp_nextday]], '0', '0', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(12, 'moodle', '\\core\\task\\grade_cron_task', [[timestamp]], [[timestamp]], '*', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(13, 'moodle', '\\core\\task\\grade_history_cleanup_task', 0, [[timestamp_nextday]], '*', '0', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(14, 'moodle', '\\core\\task\\completion_regular_task', [[timestamp]], [[timestamp]], '*', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(15, 'moodle', '\\core\\task\\completion_daily_task', 0, [[timestamp_nextday]], '3', '13', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(16, 'moodle', '\\core\\task\\portfolio_cron_task', [[timestamp]], [[timestamp]], '*', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(17, 'moodle', '\\core\\task\\plagiarism_cron_task', [[timestamp]], [[timestamp]], '*', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(18, 'moodle', '\\core\\task\\calendar_cron_task', [[timestamp]], [[timestamp]], '*', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(19, 'moodle', '\\core\\task\\blog_cron_task', [[timestamp]], [[timestamp]], '*', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(20, 'moodle', '\\core\\task\\question_preview_cleanup_task', [[timestamp]], [[timestamp]], '*', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(21, 'moodle', '\\core\\task\\registration_cron_task', 0, [[timestamp_nextday]], '2', '20', '*', '*', '3', 0, 0, 0, NULL, NULL, NULL),
(22, 'moodle', '\\core\\task\\check_for_updates_task', 0, [[timestamp_nextday]], '33', '20', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(23, 'moodle', '\\core\\task\\cache_cron_task', 0, [[timestamp]], '50', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(24, 'moodle', '\\core\\task\\automated_backup_task', 0, [[timestamp]], '50', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(25, 'moodle', '\\core\\task\\badges_cron_task', [[timestamp]], [[timestamp]], '*/5', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(26, 'moodle', '\\core\\task\\badges_message_task', [[timestamp]], [[timestamp]], '*/5', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(27, 'moodle', '\\core\\task\\file_temp_cleanup_task', 0, [[timestamp]], '55', '*/6', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(28, 'moodle', '\\core\\task\\file_trash_cleanup_task', 0, [[timestamp]], '55', '*/6', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(29, 'moodle', '\\core\\task\\search_index_task', 0, [[timestamp]], '*/30', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(30, 'moodle', '\\core\\task\\search_optimize_task', 0, [[timestamp_nextday]], '15', '*/12', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(31, 'moodle', '\\core\\task\\stats_cron_task', 0, [[timestamp_nextday]], '0', '0', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(32, 'moodle', '\\core\\task\\password_reset_cleanup_task', 0, [[timestamp]], '0', '*/6', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(33, 'moodle', '\\core\\task\\complete_plans_task', [[timestamp]], [[timestamp]], '41', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(34, 'moodle', '\\core\\task\\sync_plans_from_template_cohorts_task', 0, [[timestamp]], '32', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(35, 'moodle', '\\core_files\\task\\conversion_cleanup_task', 0, [[timestamp_nextday]], '13', '2', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(36, 'moodle', '\\core\\oauth2\\refresh_system_tokens_task', 0, [[timestamp]], '30', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(37, 'moodle', '\\core\\task\\analytics_cleanup_task', [[timestamp]], [[timestamp]], '42', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(38, 'moodle', '\\core\\task\\task_log_cleanup_task', 0, [[timestamp_nextday]], '37', '16', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(39, 'moodle', '\\core\\task\\h5p_get_content_types_task', 0, [[timestamp_nextday]], '34', '22', '1', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(40, 'moodle', '\\core\\task\\h5p_clean_orphaned_records_task', 0, [[timestamp_nextday]], '48', '0', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(41, 'moodle', '\\core\\task\\antivirus_cleanup_task', 0, [[timestamp_nextday]], '45', '0', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(42, 'moodle', '\\core_reportbuilder\\task\\send_schedules', [[timestamp]], [[timestamp]], '*', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(43, 'moodle', '\\core\\task\\task_lock_cleanup_task', [[timestamp]], [[timestamp]], '*/10', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(44, 'moodle', '\\core_xapi\\task\\state_cleanup_task', 0, [[timestamp_nextday]], '41', '0', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(45, 'moodle', '\\core\\task\\show_started_courses_task', 0, [[timestamp_nextday]], '00', '01', '*', '*', '*', 0, 0, 1, NULL, NULL, NULL),
(46, 'moodle', '\\core\\task\\hide_ended_courses_task', 0, [[timestamp_nextday]], '00', '01', '*', '*', '*', 0, 0, 1, NULL, NULL, NULL),
(47, 'moodle', '\\core_communication\\task\\synchronise_providers_task', 0, [[timestamp_nextday]], '19', '6', '*', '*', '5', 0, 0, 0, NULL, NULL, NULL),
(48, 'moodle', '\\core\\task\\automated_backup_report_task', [[timestamp]], [[timestamp]], '*', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(49, 'moodle', '\\core\\task\\update_geoip2file_task', 0, [[timestamp_nextday]], '0', '3', '*', '*', '4', 0, 0, 1, NULL, NULL, NULL),
(50, 'moodle', '\\core\\task\\stored_progress_bar_cleanup_task', 0, [[timestamp_nextday]], '00', '01', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(51, 'mod_assign', '\\mod_assign\\task\\cron_task', [[timestamp]], [[timestamp]], '*', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(52, 'mod_assign', '\\mod_assign\\task\\queue_all_assignment_due_soon_notification_tasks', 0, [[timestamp]], '34', '*/2', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(53, 'mod_assign', '\\mod_assign\\task\\queue_all_assignment_overdue_notification_tasks', 0, [[timestamp]], '31', '*/1', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(54, 'mod_assign', '\\mod_assign\\task\\queue_all_assignment_due_digest_notification_tasks', 0, [[timestamp_nextday]], '49', '1', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(55, 'mod_bigbluebuttonbn', '\\mod_bigbluebuttonbn\\task\\check_pending_recordings', 0, [[timestamp]], '*/5', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(56, 'mod_bigbluebuttonbn', '\\mod_bigbluebuttonbn\\task\\check_dismissed_recordings', 0, [[timestamp_nextday]], '*', '*', '*/10', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(57, 'mod_forum', '\\mod_forum\\task\\cron_task', [[timestamp]], [[timestamp]], '*', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(58, 'mod_lti', '\\mod_lti\\task\\clean_access_tokens', 0, [[timestamp]], '58', '5', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(59, 'mod_quiz', '\\mod_quiz\\task\\update_overdue_attempts', [[timestamp]], [[timestamp]], '*', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(60, 'mod_quiz', '\\mod_quiz\\task\\quiz_notify_attempt_manual_grading_completed', 0, [[timestamp]], '14', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(61, 'mod_quiz', '\\mod_quiz\\task\\queue_all_quiz_open_notification_tasks', 0, [[timestamp]], '3', '*/2', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(62, 'mod_quiz', '\\mod_quiz\\task\\precreate_attempts', 0, [[timestamp]], '35', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(63, 'mod_scorm', '\\mod_scorm\\task\\cron_task', [[timestamp]], [[timestamp]], '*/5', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(64, 'mod_workshop', '\\mod_workshop\\task\\cron_task', [[timestamp]], [[timestamp]], '*', '*', '*', '*', '*', 0, 0, 0, NULL, NULL, NULL),
(65, 'auth_db', '\\auth_db\\task\\sync_users', 0, [[timestam