<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'turnitintool', language 'af', version '5.1'.
 *
 * @package     turnitintool
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['add_turnitintool'] = 'Voeg Turnitin-opdrag by';
$string['addcomment'] = 'Voeg Kommentaar by';
$string['addeditcomment'] = 'Voeg by / Wysig Kommentaar';
$string['addsubmission'] = 'Voeg Indiening by';
$string['advancedoptions'] = 'Turnitin Gevorderde Opsies';
$string['allowlate'] = 'Laat Laat Indienings toe';
$string['allowlate_help'] = 'Hierdie verstelling laat toe dat die instrukteur kies of hulle laat indienings van die opdrag sal toelaat. Indien na ja gestel, sal studente die opdrag ná die sperdatum kan inhandig, as hulle nie voorheen \'n indiening gemaak het nie. Indien na nee gestel, sal studente nie ná die opdrag se sperdatum kan inhandig nie.';
$string['allstudents'] = 'Alle Studente';
$string['allsubmissions'] = 'Inmandjie van Indienings';
$string['allsubmissionsmade'] = 'Alle moontlike indienings is gedoen';
$string['alreadysubmitted'] = 'Indiening is nie aanvaar nie, aangesien daar reeds aan daardie deel van die opdrag \'n indiening gemaak is.';
$string['anon'] = 'Anoniem';
$string['anonenabled'] = 'Anonieme Nasien is Ontsper';
$string['anytype'] = 'Enige Indieningstipe';
$string['apiunavailable'] = 'Turnitin API-basis-URL verkeerd of nie beskikbaar nie';
$string['assigndtdue'] = 'Sperdatum van Opdrag';
$string['assigndtpost'] = 'Plasingsdatum van Opdrag';
$string['assigndtstart'] = 'Aanvangsdatum van Opdrag';
$string['assigngeterror'] = 'Kon nie Turnitin-hulpmiddeldata kry nie';
$string['assignmentdeleteprocess'] = 'Opdragdeel {$a} word uitgewis';
$string['assignmentdoesnotexist'] = 'Die opdrag bestaan nie in Turnitin nie';
$string['assignmentindividualise'] = 'Opdragdeel {$a} word verwerk';
$string['assignmentprocess'] = 'Opdragdeel {$a} word geïnisialiseer';
$string['assignmentupdate'] = 'Opdragdeel {$a} word bygewerk';
$string['autorefreshgrades'] = 'Outoverfris Punte';
$string['autorefreshgrades_help'] = 'By verstek, ná elke oproep na Turnitin, sal die Moodle-integrasie-invoegtoepassing probeer om veranderinge wat binne Turnitin gemaak is, outomaties af te trek. Jy kan hierdie opsie gebruik om hierdie funksie af te skakel,
maar om sinchronisering tussen die twee stelsels te handhaaf, sal jy egter punte en oorspronkliheidspunte gereeld per hand vanuit Moodle moet verfris.';
$string['autosubmit'] = 'Outo-indien';
$string['autosubmit_help'] = 'Om gebruikerindienings outomaties met oplaai aan Turnitin in te dien, stel hierdie opsie na \'Dien met Oplaai dadelik aan Turnitin in\'. Anders kan jy die opsie stel om te vereis dat die indiening in Moodle geberg word en per hand na Turnitin opgelaai word deur die opsie \'Hersien Oplaai voor Indiening aan Turnitin\' te kies.';
$string['autosubmitoff'] = 'Hersien Oplaai voor Indiening aan Turnitin';
$string['autosubmiton'] = 'Dien met Oplaai dadelik aan Turnitin in';
$string['bulkupload'] = 'Bondeloplaai-indienings';
$string['ced'] = 'Einddatum van Klas';
$string['changeowner'] = 'Verander Eienaar ...';
$string['changingowner'] = 'Verander Klaseienaar van Turnitin';
$string['characters'] = 'Karakters';
$string['classcreationerror'] = 'Turnitin Klasskepping het misluk';
$string['classprocess'] = 'Klasdata word verwerk';
$string['classupdateerror'] = 'Kon nie Turnitin Klasdata bywerk nie';
$string['comment'] = 'Kommentaar';
$string['commentby'] = 'Kommentaar deur';
$string['commentdeleteerror'] = 'Kon nie kommentaar uit databasis verwyder nie';
$string['commenteditwindow'] = 'Kommentaar Bly Wysigbaar';
$string['commenteditwindow_help'] = 'Hierdie opsie laat toe dat jy die tydperk stel waarin \'n gebruiker die kommentaar wat hulle aangaande \'n indiening gemaak het, kan wysig. Gebruikers met die vermoë om indienings na te sien, bv. tutor, kan hul eie kommentaar enige tyd verander.';
$string['commentgeterror'] = 'Kon nie kommentaar vanuit databasis verkry nie';
$string['commentsgeterror'] = 'Fout met verkry van kommentaardata';
$string['commentssettings'] = 'Kommentaarverstellings';
$string['configureerror'] = 'Jy moet hierdie module ten volle as Administrateur konfigureer voordat jy dit in \'n kursus gebruik. Kontak asseblief jou Moodle-administrateur.';
$string['connecttest'] = 'Loop Konnektiwiteittoets';
$string['connecttestcommerror'] = 'Kon nie aan Turnitin konnekteer nie. Maak dubbeld seker van jou API URL-verstelling.';
$string['connecttesterror'] = 'Daar was \'n fout met koppeling aan Turnitin. Die terugkeer-foutboodskap is hieronder:<br /><br /><i><b>{$a}</b></i>';
$string['connecttesting'] = 'Konnektiwiteittoets word Geloop';
$string['connecttestsuccess'] = 'Moodle het suksesvol aan Turnitin gekoppel.';
$string['connecttimeouterror'] = 'Kon nie aan Turnitin koppel nie / konneksietyd is verstreke. Probeer asseblief weer.';
$string['copyassigndata'] = 'Kopieer Turnitin-opdragdata';
$string['copyassigndataerror'] = 'Kopieer Turnitin-opdragdatafout';
$string['copyrightagreement'] = 'Deur hierdie boks te merk,
bevestig ek dat hierdie indiening my eie werk is, en ek aanvaar alle verantwoordelikheid vir enige kopieregskending wat as gevolg van hierdie indiening kan voorkom.';
$string['correctingovergrade'] = 'Oorgegradeerde Vraestel word Gekorrigeer';
$string['coursegeterror'] = 'Kon nie kursusdata verkry nie';
$string['courseiderror'] = 'Kursus-ID is verkeerd';
$string['created'] = 'Geskep';
$string['dateformat'] = 'Datumformaat';
$string['dateformat_help'] = 'Gebruik hierdie verstelling om die datumformaat te stel wat gebruik word om datums aan gebruikers te vertoon.';
$string['defaultdtdue'] = 'Verstek Sperdatum';
$string['defaultdtpost'] = 'Verstek Plasingsdatum';
$string['defaultdtstart'] = 'Verstek Aanvangsdatum';
$string['defaults'] = 'Verstek verstellings';
$string['defaults_desc'] = 'Die volgende verstellings sal die verstek verstellings wees wat vir nuwe eksemplare van die Moodle Direct Turnitin-opdrag gebruik word';
$string['defaultsoverwrite'] = 'Skryf Datums Oorheen';
$string['defaultsoverwrite_help'] = 'Hierdie verstelling sal vertoon word wanneer \'n opdrag bygewerk word. Deur ja hier te kies, sal die opdrag se aanvangsdatum, sperdatum en plasingsdatum van alle opdragdele herstel word na dieselfde waardes wat jy in die verstek datumverstellings ingevoer het.';
$string['deletable'] = 'Uitwisbaar';
$string['delete'] = 'Wis uit';
$string['delete_turnitintool'] = 'Wis Turnitin-opdrag uit';
$string['deletecomment'] = 'Wis Kommentaar uit';
$string['deletecommentconfirm'] = 'Is jy seker jy wil hierdie kommentaar uitwis?\\n\\nDit kan nie ongedaan gemaak word nie.';
$string['deleteconfirm'] = 'Is jy seker jy wil hierdie indiening uitwis?\\n\\nHierdie aksie kan nie ongedaan gemaak word nie.';
$string['deleteerror'] = 'Uitwissingsfout';
$string['deletesubmission'] = 'Wis Indiening uit';
$string['deletingsubmission'] = 'Turnitin-indiening word uitgewis';
$string['displaygradesas'] = 'Puntvertoon';
$string['displaygradesas_help'] = 'Hierdie opsie stel die vertoonmodus van punte. Die opsies is Vertoon as persentasie of Vertoon as breuk, d.w.s. 45/60.';
$string['displaygradesasfraction'] = 'Vertoon punte as Breuk (bv. 89/100)';
$string['displaygradesaspercent'] = 'Vertoon punte as Persentasie (bv. 89%)';
$string['dorequesterror'] = 'Kon nie bladsyversoek verwerk nie';
$string['downloadexport'] = 'Voer uit';
$string['downloadgradexls'] = 'Puntuitvoere (XLS)';
$string['downloadingfile'] = 'Dokument word Afgelaai';
$string['downloadingfileerror'] = 'Fout met Aflaai van Dokument';
$string['downloadorigzip'] = 'ZIP-dokument (Oorspronklike formaat)';
$string['downloadpdfzip'] = 'ZIP-dokument (PDF)';
$string['downloadsubmission'] = 'Laai Indiening af';
$string['dtdue'] = 'Sperdatum';
$string['dtpost'] = 'Plasingsdatum';
$string['dtstart'] = 'Aanvangsdatum';
$string['duplicatesfound'] = 'Duplikaat kopieë van dieselfde Turnitin-opdrag is gevind. Duplikate kom voor wanneer een of meer Moodle Direct-opdragte aan dieselfde enkele Turnitin-opdrag via die Turnitin-API gekoppel word. Dit is bekend daarvoor dat dit probleme veroorsaak, vernaamlik indienings wat aan een van die duplikate gemaak is, sal in die indieninginkas van die ander verskyn. Om dit reg te stel, moet jy óf die duplikaat opdragte uitwis, of die kursus waar die duplikaat opdragte is, terugstel.<br /><br />Die volgende duplikate is gevind:';
$string['edit'] = 'Wysig';
$string['editcomment'] = 'Wysig Kommentaar';
$string['edituntil'] = 'Plasing kan uitgewis of gewysig word tot';
$string['editwindow'] = 'Wysigbaar vir';
$string['enablepseudo'] = 'Ontsper Studentprivaatheid';
$string['enablepseudo_desc'] = 'As hierdie opsie geselekteer is, sal student-e-posadresse omgeskakel word na \'n skynekwivalent van Turnitin-API-oproepe.<br /><i>(<b>Let wel:</b> Hierdie opsie kan nie verander word as enige Moodle-gebruikerdata reeds met Turnitin gesinchroniseer is nie.)</i>';
$string['erater'] = 'Ontsper e-rater grammatikatoetser';
$string['erater_categories'] = 'e-rater Kategorieë';
$string['erater_dictionary'] = 'e-rater Woordeboek';
$string['erater_dictionary_en'] = 'Beide VSA- en VK-woordeboeke';
$string['erater_dictionary_engb'] = 'VK Engels Woordeboek';
$string['erater_dictionary_enus'] = 'VSA Engels Woordeboek';
$string['erater_grammar'] = 'Grammatika';
$string['erater_handbook'] = 'ETS&kopie-handboek';
$string['erater_handbook_advanced'] = 'Gevorderd';
$string['erater_handbook_elementary'] = 'Laerskool';
$string['erater_handbook_highschool'] = 'Hoërskool';
$string['erater_handbook_learners'] = 'Engelse Leerders';
$string['erater_handbook_middleschool'] = 'Middelskool';
$string['erater_help'] = 'Wanneer hierdie verstelling ontsper is, sal indienings wat binne GradeMark besigtig is, ook terugvoerpunte vir grammatika en ander skryfeienskappe bevat.';
$string['erater_mechanics'] = 'Meganika';
$string['erater_spelling'] = 'Spelling';
$string['erater_style'] = 'Styl';
$string['erater_usage'] = 'Gebruik';
$string['estimatingtime'] = 'Beraming van die oorblywende tyd';
$string['excludebiblio'] = 'Sluit Bibliografie uit';
$string['excludebiblio_help'] = 'Hierdie verstelling laat die instrukteur kies om teks wat in die bibliografie voorkom, werke aangehaal, of bronverwysingafdelings van studentvraestelle daarvan uit te sluit om vir ooreenstemmings nagegaan te word wanneer Oorspronklikheidsverslae gegeneer word.';
$string['excludepercent'] = 'Persentasie';
$string['excludequoted'] = 'Sluit Aangehaalde Materiaal uit';
$string['excludequoted_help'] = 'Hierdie verstelling laat die instrukteur kies om teks, wat in die aanhalings voorkom, daarvan uit te sluit om vir ooreenstemming nagegaan te word wanneer Oorspronklikheidsverslae gegenereer word.';
$string['excludevalue'] = 'Sluit Klein Ooreenstemmings uit';
$string['excludevalue_help'] = 'Hierdie verstelling laat die instrukteur kies om ooreenstemmings, wat nie lank genoeg is nie (word deur die instrukteur bepaal), van oorweging uit te sluit wanneer Oorspronklikheidsverslae gegenereer word. Hierdie verstelling kan in individuele Oorspronklikheidsverslae oorheengeskryf word.';
$string['excludewords'] = 'Woorde';
$string['feedback'] = 'Kommentaar';
$string['file'] = 'Dokument';
$string['filebrowser'] = 'Moodle Direkte Dokumentblaaier';
$string['filedeleteconfirm'] = 'Is jy seker jy wil hierdie dokument uitwis? Hierdie aksie kan nie ongedaan gemaak word nie.';
$string['filename'] = 'Dokumentnaam';
$string['filenotfound'] = 'Dokument vir inhandiging is nie op Moodle-bediener gevind nie. Dit kan korrup of verlore wees. Hierdie Turnitin-indiening sal uitgewis word.';
$string['files'] = 'Dokumente';
$string['filetosubmit'] = 'Dokument om In te Dien';
$string['filetosubmit_help'] = 'Wanneer \'n dokument aan \'n opdragdeel ingedien word,
blaai met hierdie vormelement deur jou rekenaar vir die dokument om op te laai.';
$string['fileupload'] = 'Dokumentoplaai';
$string['fileuploaderror'] = 'Dokumentoplaaifout';
$string['filewriteerror'] = 'Kon nie data na dokument skryf nie';
$string['genduedate'] = 'Genereer verslae op sperdatum';
$string['generalsettings'] = 'Algemene Verstellings';
$string['genimmediately1'] = 'Genereer verslae dadelik, eerste verslag is finaal';
$string['genimmediately2'] = 'Genereer verslae dadelik, verslae kan tot sperdatum oorheengeskryf word';
$string['genspeednote'] = 'Let wel: Generering van Oorspronklikheidsverslag vir herindienings is onderhewig aan \'n vertraging van 24 uur.';
$string['goback'] = 'Gaan Terug';
$string['gradessettings'] = 'Nasienverstellings';
$string['hideall'] = 'Versteek Alles';
$string['hidesubmissions'] = 'Versteek Indienings';
$string['hours'] = 'Ure';
$string['hrs'] = 'Ure';
$string['inactive'] = 'Onaktief';
$string['inserterror'] = 'Invoegfout';
$string['institutionalrepository'] = 'Instellingsbewaararea (waar van toepassing)';
$string['instructor'] = 'Instrukteur';
$string['internetcheck'] = 'Kontroleer teen internet';
$string['internetcheck_help'] = 'Hierdie verstelling laat die instrukteur kies teen watter Turnitin-bewaarareas studente se indienings nagegaan sal word wanneer Oorspronklikheidsverslae vir vraestelle verwerk word. Die soortgelykheidsindekspersentasie kan verminder as \'n bewaararea-opsie gedeselekteer word.';
$string['joiningclass'] = 'Sluit aan by Turnitin-klas {$a}';
$string['journalcheck'] = 'Kontroleer teen joernale,<br />vaktydskrifte en publikasies';
$string['journalcheck_help'] = 'Hierdie verstelling laat die instrukteur toe om te kies teen watter Turnitin-bewaarareas studente se indienings nagegaan sal word wanneer Oorspronklikheidsverslae vir vraestelle verwerk word. Die soortgelykheidsindekspersentasie kan verminder as \'n bewaararea-opsie gedeselekteer word.';
$string['list_turnitintool'] = 'Lys Turnitin-opdragte';
$string['marks'] = 'Punte';
$string['matches'] = 'Ooreenkomste';
$string['maxcommenterror'] = 'Hierdie kommentaar is te lank ({$a->actual} karakters). Maksimum aantal karakters toegelaat {$a->allowed}.';
$string['maxcommentjserror'] = 'Hierdie kommentaar is te lank. Maksimum aantal karakters toegelaat {$a}.';
$string['maxcommentsize'] = 'Maksimum kommentaarlengte';
$string['maxcommentsize_help'] = 'Hierdie opsie stel die maksimum aantal karakters wat in \'n kommentaar toegelaat word. Die verstek verstelling vir hierdie opsie is 800 karakters.';
$string['maxfilesize'] = 'Maksimum Dokumentgrootte';
$string['maxfilesize_help'] = 'Hierdie verstelling bepaal die maksimum dokumentgrootte vir gebruikerindienings van elke opdragdeel. Die maksimum waarde waarop jy hierdie waarde kan stel, word bepaal deur die waarde wat in kursusverstellings gestel is; hierdie waarde word verder beperk tot \'n maksimum dokumentgrootte van 40 MB, wat die maksimum toegelate dokumentgrootte van dokumentoplaaie aan Turnitin is.';
$string['maxlength'] = 'Die maksimum lengte vir {$a->field} is {$a->length} karakters';
$string['maxmarks'] = 'Maks. Punte';
$string['mins'] = 'Min.';
$string['minutes'] = 'Minute';
$string['modulename'] = 'Turnitin-opdrag';
$string['modulename_help'] = 'Skep \'n Turnitin-Moodle-direkte opdrag wat \'n aktiwiteit in Moodle aan \'n opdrag(te) op Turnitin koppel. Wanneer dit gekoppel is, laat die aktiwiteit instrukteurs toe om studente se geskrewe werk te assesseer en terugvoer daarvoor te verskaf d.m.v. die assesseringshulpmiddels wat in Turnitin se Dokumentbesigtiger beskikbaar is.';
$string['modulenameplural'] = 'Turnitin-opdragte';
$string['moduleversion'] = 'Weergawe';
$string['moodle2only'] = 'Hierdie funksie word slegs deur Moodle 2+ ondersteun.';
$string['moreallowed'] = 'Meer Toegelaat';
$string['mysubmissions'] = 'My Indienings';
$string['namedparts'] = 'Benoemde Dele';
$string['no'] = 'Nee';
$string['nocommenterror'] = 'Jy moet kommentaar invoer';
$string['nocomments'] = 'Daar is geen kommentaar vir hierdie indiening nie';
$string['noenrolledstudents'] = 'Daar is tans geen studente in hierdie kursus ingeskryf nie';
$string['nogrademark'] = 'Nee, gebruik Moodle om indienings te merk';
$string['nogrades'] = 'Nee, ek sal oorspronklikheidspunte en punte per hand verfris';
$string['nolimit'] = 'Geen Beperking nie';
$string['nonmoodlestudents'] = 'Nie-Moodle-studente';
$string['nonmoodleuser'] = 'Nie-Moodle-gebruiker';
$string['nonorsubmission'] = 'Nie-OR-indiening';
$string['norepository'] = 'Geen Bewaararea';
$string['nosubmission'] = 'Geen Indiening';
$string['nosubmissions'] = 'Geen indienings is gemaak nie';
$string['nosubmissionsdue'] = 'Daar is geen aktiewe dele aan hierdie opdrag nie, d.w.s. sperdatums is verstreke of begindatums is nog nie bereik nie.';
$string['notavailableyet'] = 'Nie beskikbaar nie';
$string['notes'] = 'Kommentaar en Terugvoer';
$string['notyetsubmitted'] = 'Nog nie Ingedien nie';
$string['numberofparts'] = 'Aantal Dele';
$string['numberofparts_help'] = 'Laat die skepping van \'n multi-opdrag toe,
individuele gebruikers kan een werkstuk vir elke deel indien.';
$string['objectid'] = 'Vraestel-ID';
$string['of'] = 'van';
$string['oneclasspercourse'] = 'Daar was \'n fout met skakeling na jou Turnitin-klas. Jy kan net een Turnitin-klas hê wat met een Moodle-kursus geassosieer word, en geen twee Moodle-kursusse kan aan dieselfde Turnitin-klas koppel nie.';
$string['onepartdeleteerror'] = 'Jy kan nie die enigste deel van \'n opdrag uitwis nie';
$string['options'] = 'Opsies';
$string['optionsupdateerror'] = 'Kon nie opsiedata bywerk nie';
$string['optionsupdatesaved'] = 'Opsiedata is suksesvol bygewerk';
$string['overallgrade'] = 'Algehele Punt';
$string['overallgrade_help'] = 'Die algehele punt bepaal die maksimum toegelate punt vir die algehele opdrag,
elke deel van \'n opdrag het \'n maksimum punt daaraan toegewys, wat proporsioneel gebruik word om die punte te versprei, sodat die algehele punt bereken kan word.';
$string['partdberror'] = 'Daar was \'n probleem met die invoer van Deel {$a} in die databasis<br />';
$string['partdeleteerror'] = 'Kon nie opdragdeeldata uitwis nie';
$string['partdeletewarning'] = 'Die opdragdeel wat jy probeer uitwis, bevat indienings. Jy sal hierdie indienings verloor as jy hierdie opdragdeel uitwis.\\n\\nIs jy seker jy wil voortgaan?';
$string['partdueerror'] = 'Aanvangsdatum moet voor plasingsdatum wees.<br />';
$string['parterror'] = 'Daar was foute met jou indienings:<br /><br />';
$string['partgeterror'] = 'Kon nie opdragdeeldata verkry nie';
$string['partmarkserror'] = 'Punte moet \'n getal wees.<br />';
$string['partname'] = 'Opdragdeel';
$string['partnameerror'] = 'Deelnaam kan nie blanko gelaat word nie.<br />';
$string['partnames'] = 'Opdragdele';
$string['partnames_help'] = '<p>Bepaal of die Dele van hierdie opdrag Benoemde Dele is, of of hierdie opdrag \'n Portefeulje-opdrag is.</p>';
$string['partnaming'] = 'Deelname';
$string['partstarterror'] = 'Aanvangsdatum moet voor sperdatum wees.<br />';
$string['partweighterror'] = 'Deel {$a} se gewig kan nie leeg wees nie<br />';
$string['pending'] = 'Hangende';
$string['permissiondeniederror'] = 'Jy beskik nie oor die korrekte toestemming om die versoekte aksie te voltooi nie';
$string['pleasenote'] = 'Let Asseblief';
$string['pluginadministration'] = 'Turnitin-opdragadministrasie';
$string['pluginname'] = 'Turnitin-opdrag';
$string['portfolio'] = 'Portefeulje';
$string['posted'] = 'Ingedien';
$string['previewtextsubmission'] = 'Besigtig teksindiening vooraf';
$string['previewwebpage'] = 'Beskou Webblad vooraf';
$string['privacy:metadata:core_files'] = 'Turnitin-opdrag berg dokumente wat na Moodle opgelaai is om \'n Turnitin-indiening te vorm.';
$string['privacy:metadata:turnitintool_client'] = 'Om \'n indiening aan Turnitin suksesvol te voltooi, moet spesifieke gebruikerdata tussen Moodle en Turnitin uitgeruil word.';
$string['privacy:metadata:turnitintool_client:email'] = 'Die gebruiker se e-posadres word deur Moodle gedeel om die skep van \'n Turnitin-rekening toe te laat.';
$string['privacy:metadata:turnitintool_client:firstname'] = 'Die gebruiker se voornaam word aan Turnitin gestuur, sodat die gebruiker geïdentifiseer kan word.';
$string['privacy:metadata:turnitintool_client:lastname'] = 'Die gebruiker se van word aan Turnitin gestuur, sodat die gebruiker geïdentifiseer kan word.';
$string['privacy:metadata:turnitintool_client:submission_filename'] = 'Die naam van die ingediende dokument word aan Turnitin gestuur sodat dit identifiseerbaar is.';
$string['privacy:metadata:turnitintool_client:submission_title'] = 'Die titel van die indiening word aan Turnitin gestuur sodat dit identifiseerbaar is.';
$string['privacy:metadata:turnitintool_comments'] = 'Kommentaar oor \'n indiening wat aan Turnitin gestuur is.';
$string['privacy:metadata:turnitintool_comments:commenttext'] = 'Kommentaar wat aan \'n indiening vasgeheg is.';
$string['privacy:metadata:turnitintool_comments:userid'] = 'Die ID van die gebruiker wat kommentaar gelewer het.';
$string['privacy:metadata:turnitintool_submissions'] = 'Inligting oor \'n indiening wat aan Turnitin gestuur is.';
$string['privacy:metadata:turnitintool_submissions:submission_attempts'] = '\'n Tydstempel wat aandui wanneer die gebruiker terugvoer oor hul indiening besigtig het.';
$string['privacy:metadata:turnitintool_submissions:submission_filename'] = 'Die naam van die dokument wat aan Turnitin ingedien is.';
$string['privacy:metadata:turnitintool_submissions:submission_grade'] = 'Die punt wat deur \'n instrukteur op die indiening toegepas is.';
$string['privacy:metadata:turnitintool_submissions:submission_hash'] = '\'n Indiening-spesifieke huts wat die gebruiker se ID bevat.';
$string['privacy:metadata:turnitintool_submissions:submission_modified'] = '\'n Tydstempel wat aandui wanneer die gebruiker hul indiening laaste gewysig het.';
$string['privacy:metadata:turnitintool_submissions:submission_objectid'] = 'Die ID wat deur Turnitin gebruik word om na die indiening te verwys.';
$string['privacy:metadata:turnitintool_submissions:submission_score'] = 'Die soortgelykheidspunt van die indiening.';
$string['privacy:metadata:turnitintool_submissions:submission_title'] = 'Die titel van die indiening.';
$string['privacy:metadata:turnitintool_submissions:submission_transmatch'] = 'Dui aan of Turnitin vertaalpassing gebruik het om \'n Soortgelykheidsverslag vir die indiening te produseer.';
$string['privacy:metadata:turnitintool_submissions:submission_unanon'] = 'Dui aan dat die anonimiteit van \'n indiening verwyder is, wat die outeur se identiteit aan die instrukteur beskikbaar maak.';
$string['privacy:metadata:turnitintool_submissions:submission_unanonreason'] = '\'n Verduideliking van die verwydering van \'n outeur se anonimiteit, wat deur hul instrukteur verskaf word.';
$string['privacy:metadata:turnitintool_submissions:userid'] = 'Die ID van die gebruiker wat \'n indiening gemaak het.';
$string['privacy:metadata:turnitintool_users'] = 'Inligting wat \'n Moodle-gebruiker aan \'n Turnitin-gebruikerrekening koppel, asook aan enige voorkeure spesifiek tot Turnitin. Dit sluit in verstek opdragverstellings en enige Turnitin-rubrieke wat deur hulle besit word.';
$string['privacy:metadata:turnitintool_users:instructor_defaults'] = 'Die instrukteur se verstek opdragverstellings';
$string['privacy:metadata:turnitintool_users:instructor_rubrics'] = 'Die Turnitin-rubriekpuntekaarte wat aan die instrukteur behoort';
$string['privacy:metadata:turnitintool_users:turnitin_uid'] = 'Die gebruiker se Turnitin-rekening-ID.';
$string['privacy:metadata:turnitintool_users:user_agreement_accepted'] = 'Dui aan of hierdie gebruiker die Turnitin Lisensie-ooreenkoms vir eindgebruikers (EULA) aanvaar het.';
$string['privacy:metadata:turnitintool_users:userid'] = 'Die ID van die gebruiker wat aan \'n Turnitin-rekening gekoppel word.';
$string['processed'] = 'Opdrag is verwerk';
$string['proxypassword'] = 'Proxywagwoord';
$string['proxypassword_desc'] = '<b>[Opsioneel]</b><br />As jou proxy Magtiging vereis, voer die wagwoord hier in.';
$string['proxyport'] = 'Proxypoort';
$string['proxyport_desc'] = '<b>[Opsioneel]</b><br />As jou bediener van \'n Proxy gebruik maak om aan die internet te koppel, voer die proxypoort hier in.';
$string['proxyurl'] = 'Proxy-URL';
$string['proxyurl_desc'] = '<b>[Opsioneel]</b><br />As jou bediener van \'n Proxy gebruik maak om aan die internet te koppel, voer die proxyadres hier in.';
$string['proxyuser'] = 'Proxygebruikernaam';
$string['proxyuser_desc'] = '<b>[Opsioneel]</b><br />As jou proxy Validasie vereis, voer die gebruikernaam hier in.';
$string['pseudoemailaddress'] = 'Pseudo-e-posadres';
$string['pseudoemaildomain'] = 'Pseudo-e-posdomein';
$string['pseudoemaildomain_desc'] = '<b>[Opsioneel]</b><br />\'n Opsionele domein vir pseudo-e-posadresse. (Keer by verstek terug na @tiimoodle.com indien leeg gelaat)';
$string['pseudoemailsalt'] = 'Pseudo-enkripsiesalt';
$string['pseudoemailsalt_desc'] = '<b>[Opsioneel]</b><br />\'n Opsionele salt om die kompleksiteit van die gegenereerde Pseudo-Student-e-posadres te vergroot.<br />(<b>Let wel:</b> Die salt behoort onveranderd te bly om konsekwente pseudo-e-posadresse te handhaaf.';
$string['pseudofirstname'] = 'Student-pseudo-voornaam';
$string['pseudofirstname_desc'] = '<b>[Opsioneel]</b><br />Die student se voornaam om in die Turnitin-dokumentbeskouer te vertoon';
$string['pseudolastname'] = 'Student-pseudo-van';
$string['pseudolastname_desc'] = 'Die student se van om in die Turnitin-dokumentbeskouer te vertoon';
$string['pseudolastnamegen'] = 'Outogenereer Van';
$string['pseudolastnamegen_desc'] = 'Indien na ja gestel en die pseudo-van na \'n gebruikerprofielveld gestel is, sal die veld outomaties met \'n unieke identifiseerder bevolk word.';
$string['pushinggrade'] = 'Punt {$a->num} van {$a->total} word aan Turnitin opgelaai';
$string['redirect'] = 'As jy nie outomaties herlei word nie, kliek hier.';
$string['reducepartserror'] = 'Jy kan nie die aantal toegelate indienings verminder as daar reeds indienings gemaak is nie. Verwyder asseblief die Opdragdeel deur die opdragopsommingsblad te gebruik. Let asseblief daarop dat jy nie die aantal toegelate indienings in \'n Portefeulje-opdrag kan wysig sonder om eers alle indienings uit te wis nie.';
$string['refresh'] = 'Verfris';
$string['refreshmatches'] = 'Verfris Ooreenstemmings';
$string['relinkusers'] = 'Herkoppel Gebruikers';
$string['remaining'] = 'Ongeveer {$a} Bly oor';
$string['removecoursedata'] = 'Verwyder Turnitin-kursusdata';
$string['removesubmissiondata'] = 'Verwyder Turnitin-indieningsdata';
$string['removeturnitinassign'] = 'Wis Opdragdata uit Turnitin uit';
$string['replaceassigndata'] = 'Vervang Turnitin-opdragdata';
$string['replaceassigndataerror'] = 'Vervang Turnitin-opdragdatafout';
$string['reportgenspeed'] = 'Meld Generasiespoed aan';
$string['reportgenspeed_help'] = 'Daar is drie opsies vir hierdie opdragverstelling: "Genereer verslae dadelik (herindienings word nie toegelaat nie)", "Genereer verslae dadelik (herindienings word tot sperdatum toegelaat)" en "Genereer verslae op sperdatum (herindienings word tot sperdatum toegelaat)".<br><br>Die opsie "onmiddellik, eerste verslag is finaal" genereer die Oorspronklikheidsverslag dadelik wanneer \'n student \'n indiening maak. As hierdie opsie gekies is, sal jou studente nie die opdrag kan herindien nie.<br><br>Om herindienings toe te laat, kies "dadelik (kan verslae tot sperdatum oorheenskryf)"-opsie. Dit laat studente toe om deurlopend indienings van die opdrag tot met die sperdatum te herindien. Dit kan tot 24 uur neem om Oorspronklikheidsverslae vir herindienings te verwerk.<br><br>Die opsie "op sperdatum" sal slegs \'n Oorspronklikheidsverslag op die opdrag se sperdatum gegeneer. Hierdie verstelling sal dit só maak dat alle indienings van die opdrag wat ingedien word, met mekaar vergelyk sal word wanneer die Oorspronklikheidsverslae geskep word.';
$string['resubmission'] = 'Herindiening';
$string['resubmissiongradewarn'] = 'Herindienings word vir hierdie opdrag toegelaat totdat die sperdatum verby is. Enige en alle punte sal uitgewis word wanneer of as die indiening heringedien word. Wil jy graag voortgaan?';
$string['resubmissionnotenabled'] = 'Herindienings is nie Ontsper nie';
$string['resubmit'] = 'Dien weer in';
$string['resultsperpage'] = 'Uitslae per Bladsy';
$string['resultsperpage_help'] = 'Stel die aantal uitslae om in die Indieningsboks te vertoon.';
$string['reveal'] = 'Onthul';
$string['revealerror'] = 'Jy moet \'n geldige rede insluit vir die onthulling van \'n student se naam.';
$string['revealreason'] = 'Rede vir Ontmaskering';
$string['savechanges'] = 'Berg Veranderinge';
$string['saveusage'] = 'Berg Datastorting';
$string['scorenotavailable'] = 'Oorspronklikheidspunt is nog nie beskikbaar nie.';
$string['secs'] = 'Sekondes';
$string['selectoption'] = 'Kies Opsie';
$string['semptytable'] = 'Geen resultate gevind nie.';
$string['showall'] = 'Vertoon Alle';
$string['shownonsubmissions'] = 'Lys alle studente';
$string['showonlysubmissions'] = 'Lys slegs studente wat indienings gemaak het';
$string['showusage'] = 'Vertoon Datastorting';
$string['sinfo'] = '{$a->start} tot {$a->end} van {$a->total} indienings word vertoon.';
$string['slengthmenu'] = 'Vertoon {$a} Indienings';
$string['snext'] = 'Volgende';
$string['spapercheck'] = 'Kontroleer teen gebergde studentindienings';
$string['spapercheck_help'] = 'Deur hierdie opsie te kies, word Turnitin opdrag gegee om slegs ingediende dokumente by \'n bewaararea, wat uitsluitlik aan jou instelling behoort, by te voeg. Soortgelykheidskontroles met die ingediende dokumente sal deur ander instrukteurs binne jou instelling gemaak word.';
$string['sprevious'] = 'Vorige';
$string['sprocessing'] = 'Word verwerk ...';
$string['ssearch'] = 'Soek:';
$string['stage'] = 'Fase';
$string['standardrepository'] = 'Standaard Bewaararea';
$string['status'] = 'Status';
$string['string'] = '{$a}';
$string['student'] = 'Student';
$string['student_notread'] = 'Die student het nie hierdie vraestel beskou nie.';
$string['student_read'] = 'Die student het die vraestel besigtig op:';
$string['studentdataprivacy'] = 'Privaatheidsverstellings van Studentdata';
$string['studentdataprivacy_desc'] = 'Die volgende verstellings kan gekonfigureer word om te verseker dat die student se persoonlike data nie via die API aan Turnitin oorgedra word nie.';
$string['studentdeleteconfirm'] = 'Deur hierdie vraestel uit te wis, sal jy in staat wees om \'n nuwe indiening in stede daarvan in te dien.\\nJy sal nie jou indiening kan herwin nadat dit uitgewis is nie.\\n\\nIs jy seker jy wil hierdie opdrag uitwis?';
$string['studentnotallowed'] = '<b>Let wel:</b> Studente kan nie oorspronklikheidsverslae vir hierdie opdrag besigtig nie.';
$string['studentreports'] = 'Oorspronkliheidsverslae van Studente';
$string['studentreports_help'] = 'Laat jou toe om Turnitin-oorspronklikheidsverslae aan studentgebruikers te vertoon. Indien na ja gestel, is die oorspronklikheidsverslag wat deur Turnitin gegenereer is, aan die student beskikbaar.';
$string['studentsname'] = 'Studentnaam';
$string['studentsname_help'] = 'Wanneer \'n indiening namens \'n gebruiker gemaak word, behoort jy hierdie keuseboks te gebruik om die naam van die gebruiker te kies vir wie die werk ingedien word.';
$string['studentstatus'] = 'Ingedien {$a->modified} (Vraestel-ID: {$a->objectid})';
$string['submission'] = 'Indiening';
$string['submissionagreementerror'] = 'Jy moet die ooreenkoms vir hierdie indiening aanvaar';
$string['submissionconnecterror'] = 'Daar was \'n fout met die konneksie aan Turnitin. Indiening is opgelyn.';
$string['submissiondelete'] = 'Wis uit\';';
$string['submissiondeleteerror'] = 'Kon nie indienings uitwis nie';
$string['submissionfileerror'] = 'Jy moet \'n dokument vir indiening aanheg';
$string['submissionfiletypeerror'] = 'Dokumenttipe nie toegelaat nie. Toegelate tipes is ({$a})';
$string['submissionfinalgrade'] = 'Finale punt vir hierdie opdrag';
$string['submissionframeseterror'] = 'Dit kom voor asof hierdie bladsy rame bevat, en nie ingedien kan word nie.';
$string['submissiongeterror'] = 'Kon nie indieningsdata verkry nie';
$string['submissiongrade'] = 'Punt';
$string['submissiongradetoohigh'] = 'Punt wat jy vir \'{$a->fullname}\' - \'{$a->part}\' was te hoog. Maksimum is {$a->maximum}.<br />';
$string['submissioniframeerror'] = 'Dit kom voor asof hierdie bladsy iframes bevat, en nie ingedien kan word nie.';
$string['submissionlist'] = 'Indieningslys';
$string['submissionlist_help'] = 'Hierdie opsie laat jou toe om alle ingeskrewe gebruikers te lys, ongeag of hulle \'n indiening gemaak het.';
$string['submissionnotyetuploaded'] = 'Nog Nie Aan Turnitin Ingedien Nie';
$string['submissionorig'] = 'Soortgelykheid';
$string['submissionpart'] = 'Indieningdeel';
$string['submissionpart_help'] = 'Kies die deel van die Turnitin-opdrag waaraan hierdie indiening gemaak is.';
$string['submissionprotocolerror'] = 'Jy moet die http:// of https:// deel van die URL van hierdie webbladindiening insluit.';
$string['submissions'] = 'Indienings';
$string['submissionstudent'] = 'Studentindiening';
$string['submissiontexterror'] = 'Jy moet die teks van hierdie indiening insluit';
$string['submissiontitle'] = 'Indieningstitel';
$string['submissiontitle_help'] = 'Voer die indieningstitel van die werkstuk wat jy indien, in.';
$string['submissiontitleduplicate'] = 'Jy moet \'n ander titel vir elke indiening invoer';
$string['submissiontitleerror'] = 'Jy moet \'n titel vir hierdie indiening insluit';
$string['submissiontype'] = 'Indieningstipe';
$string['submissiontype_help'] = '<p>Dui die indieningstipe(s) wat jy aan Turnitin mag indien aan. Die opsies is:</p>';
$string['submissionupdateerror'] = 'Kon nie indieningsdata bywerk nie';
$string['submissionuploadsuccess'] = 'Indiening is suksesvol na Turnitin opgelaai.';
$string['submissionurlerror'] = 'Jy moet die URL vir hierdie webbladindiening insluit';
$string['submit'] = 'Voeg Indiening By';
$string['submitpaper'] = 'Dien Indiening in';
$string['submitpapersto'] = 'Berg Studentindienings';
$string['submitpapersto_help'] = '<strong>Geen Bewaararea: </strong><br />Turnitin ontvang opdrag om nie ingediende dokumente in enige bewaararea te berg nie. Ons berg slegs die indiening om die aanvanklike soortgelykheidskontrole te doen.<br /><br /><strong>Standaard Bewaararea: </strong><br />Turnitin sal \'n kopie van die ingediende dokument slegs in die Standaard Bewaararea berg. Deur hierdie opsie te kies, word Turnitin opdrag gegee om slegs gebergde dokumente te gebruik om soortgelykheidskontroles teenoor enige dokumente wat in die toekoms ingedien word, uit te voer.<br /><br /><strong>Institusionele Bewaararea (Waar van Toepassing): </strong><br />Deur hierdie opsie te kies, word Turnitin opdrag gegee om slegs ingediende dokumente in \'n privaat bewaararea van jou instelling by te voeg. Soortgelykheidskontroles op die ingediende dokumente sal slegs deur ander instrukteurs binne jou instelling gemaak word.';
$string['submitted'] = 'Gewysig';
$string['submittedmax'] = 'Jy het die maksimum aantal toegelate indienings gemaak.';
$string['submittoturnitin'] = 'Dien aan Turnitin in';
$string['synchallconfirm'] = 'Jy is op die punt om alle indienings vir hierdie stel indieningsdele te sinchroniseer met die indienings wat op Turnitin geberg is. Dit sal enige indienings wat nie deur Moodle ingedien is nie, aftrek. Vir groot getalle studente met \'n groot, multideel-opdrag kan dit \'n lang tyd neem. Moet asseblief nie die proses stop wanneer dit eers begin het nie.\\n\\nIs jy seker jy wil voortgaan?';
$string['synchallsubmissions'] = 'Herwin Alle Studentdata van Turnitin';
$string['synchassignments'] = 'Herwin Opdragdata van Turnitin';
$string['synchronisingturnitin'] = 'Turnitin-data word gesinchroniseer';
$string['synchstudentsubmissions'] = 'Herwin Studentindienings van Turnitin';
$string['synchyoursubmissions'] = 'Aan Turnitin ingedien? Kliek hier om te herwin.';
$string['szerorecords'] = 'Geen rekords om te vertoon nie.';
$string['textsubmission'] = 'Teksindiening';
$string['texttosubmit'] = 'Teks om in te Dien';
$string['texttosubmit_help'] = 'Kopieer en plak die teks van jou indiening in hierdie boks.';
$string['title'] = 'Titel';
$string['transmatch'] = 'Vertaalpassing';
$string['transmatch_desc'] = 'Bepaal of Vertaalpassing beskikbaar sal wees as verstelling op die opdrag-opstelskerm.<br /><i>(Ontsper hierdie opsie slegs as Vertaalpassing op jou Turnitin-rekening ontsper is)</i>';
$string['transmatch_help'] = 'Wanneer Vertaalpassing ontsper is, sal Turnitin \'n aparte Oorspronklikheidsverslag genereer, wat op Engelse vertalings van studente se nie-Engelstalige indienings gebaseer is. Die volgende tale word vir Vertaalpassing ondersteun:<br><br>Tsjeggies, Deens, Nederlands, Fins, Frans, Duits, Grieks, Hongaars, Italiaans, Pools, Portugees, Romaans, Spaans, Sweeds en Turks.';
$string['turnitinaccountid'] = 'Turnitin-Rekening-ID';
$string['turnitinaccountid_desc'] = '<b>[Vereis]</b><br />Voer jou Turnitin Primêre Rekening-ID in';
$string['turnitinanon'] = 'Anonieme Nasien';
$string['turnitinanon_help'] = 'Jy kan jou Turnitin-opdrag konfigureer om Anonieme Nasien te gebruik deur hierdie waarde na Ja te stel. Wanneer anonieme nasien op \'n opdrag ontsper is, kan dit nie versper word nie.';
$string['turnitinapiurl'] = 'Turnitin API-URL';
$string['turnitinapiurl_desc'] = '<b>[Vereis]</b><br />Voer die Turnitin API-URL in<br /><i>(bv. https://api.turnitin.com/api.asp)<br />(e.g. https://api.turnitinuk.com/api.asp)</i>';
$string['turnitincommunicationerror'] = 'Daar het \'n fout voorgekom met kommunikasie met die Turnitin-bediener. Probeer asseblief later weer.';
$string['turnitindeleteconfirm'] = 'Deur indienings uit te wis, word dit uit jou indieningslys en inkassie verwyder, maar word dit nie heeltemal\\nuit die Turnitin-databasis verwyder nie.\\n\\nIs jy seker jy wil hierdie indiening uitwis? Hierdie aksie kan nie ongedaan gemaak word nie.';
$string['turnitindeletionerror'] = 'Uitwissing van Turnitin-indiening het misluk. Die plaaslike VLE-kopie is verwyder, maar die indiening in Turnitin kon nie uitgewis word nie.';
$string['turnitindiagnostic'] = 'Ontsper Diagnostiese Modus';
$string['turnitindiagnostic_desc'] = '<b>[Pasop]</b><br />Ontsper Diagnostiese modus slegs om probleme met die Turnitin-API op te spoor.';
$string['turnitinenrollstudents'] = 'Skryf Alle Studente in';
$string['turnitinid'] = 'Turnitin-ID';
$string['turnitinloading'] = 'Data word gesinchroniseer';
$string['turnitinpart'] = 'Deel {$a}';
$string['turnitinpartname'] = 'Deelnaam';
$string['turnitinreceiptemail'] = 'Ontvangste-e-posse';
$string['turnitinreceiptemail_desc'] = 'Stel of studente digitale ontvangste-e-posse moet ontvang wanneer hulle werk aan Turnitin via die VLE indien.';
$string['turnitinrefreshsubmissions'] = 'Verfris Indienings';
$string['turnitinsecretkey'] = 'Turnitin Gedeelde Sleutel';
$string['turnitinsecretkey_desc'] = '<b>[Vereis]</b><br />Voer jou Turnitin Gedeelde Sleutel in<br /><i>(gestel deur jou Turnitin-administrateur)</i>';
$string['turnitinstudentemail'] = 'Student-e-posse';
$string['turnitinstudentemail_desc'] = 'Stel of studente e-posse met rekeningbesonderhede moet ontvang wanneer \'n nuwe Turnitin-rekening vir hulle deur die VLE opgestel word.';
$string['turnitinsubaccountid'] = 'Turnitin Subrekening-ID';
$string['turnitinsubaccountid_desc'] = '<b>[Opsioneel]</b><br />Voer jou Turnitin Subrekening-ID in<br /><i>(Gebruik dit slegs as \'n Subrekening gekonfigureer word)</i>';
$string['turnitintool'] = 'Turnitin-hulpmiddel';
$string['turnitintool:addinstance'] = 'Voeg Turnitin-hulpmiddelaktiwiteit by';
$string['turnitintool:admin'] = 'Bestuur Turnitin-hulpmiddel';
$string['turnitintool:grade'] = 'Sien Turnitin-hulpmiddelopdragte na';
$string['turnitintool:submit'] = 'Dien aan Turnitin-hulpmiddelopdragte in';
$string['turnitintool:view'] = 'Besigtig Turnitin-hulpmiddelopdragte';
$string['turnitintooladministration'] = 'Turnitin-opdragadministrasie';
$string['turnitintoolagreement'] = 'Vrywaring / Ooreenkoms';
$string['turnitintoolagreement_default'] = 'Deur hierdie boks te merk, bevestig ek dat hierdie indiening my eie werk is en ek aanvaar alle verantwoordelikheid vir enige kopieregskending wat as gevolg van hierdie indiening kan voorkom.';
$string['turnitintoolagreement_desc'] = '<b>[Opsioneel]</b><br />Vul \'n ooreenkomsbevestigingstelliing vir indienings in.<br />(<b>Let wel:</b> As die ooreenkoms heeltemal leeg gelaat word, sal geen ooreenkomsbevestiging tydens indiening van studente vereis word nie)';
$string['turnitintooldeleteerror'] = 'Kon nie turnitin-hulpmiddeldata uitwis nie';
$string['turnitintoolgeterror'] = 'Kon nie turnitin-hulpmiddeldata verkry nie';
$string['turnitintoolintro'] = 'Opsomming';
$string['turnitintoolname'] = 'Turnitin-opdragnaam';
$string['turnitintoolowner'] = 'Turnitin-klaseienaar';
$string['turnitintoolowner_help'] = 'Dui die \'eienaar\' of skepper van die Turnitin-klas aan. Alle opdragte en indienings sal by hierdie \'eienaar\' se Turnitin-rekening gevoeg word.';
$string['turnitintoolresetdata0'] = 'Kopieer Turnitin-opdragte <i>(skep Duplikate, Nuwe Turnitin-klas)</i>';
$string['turnitintoolresetdata1'] = 'Vervang Turnitin-opdragte <i>(Vervang Opdragdele, Hergebruik Turnitin-klas)</i>';
$string['turnitintoolresetdata2'] = 'Laat Turnitin-opdragte onaangeraak';
$string['turnitintoolresetinfo'] = 'Kies \'n opsie hieronder vir die Turnitin-opdragte in hierdie kursus:';
$string['turnitintoolupdateerror'] = 'Kon nie Turnitin-hulpmiddeldata bywerk nie';
$string['turnitintutoremail'] = 'Instrukteur-e-posse';
$string['turnitintutoremail_desc'] = 'Stel of instrukteurs e-posse met rekeningbesonderhede moet ontvang wanneer \'n nuwe Turnitin-rekening vir hulle deur die VLE opgestel is.';
$string['turnitintutors'] = 'Turnitin-tutors';
$string['turnitintutors_desc'] = 'Die gekose Tutors hieronder is ingeskryf as tutors van hierdie Turnitin-klas. Ingeskrewe tutors kan toegang tot hierdie klas verkry deur op die Turnitin-webwerf in te teken.';
$string['turnitintutorsadd'] = 'Voeg Turnitin-tutor by';
$string['turnitintutorsadding'] = '\'n Turnitin-tutor word bygevoeg';
$string['turnitintutorsallenrolled'] = 'Alle Tutors is op Turnitin ingeskryf';
$string['turnitintutorsremove'] = 'Verwyder Turnitin-tutors';
$string['turnitintutorsremove_errorlast'] = 'Fout: Jy moet minstens een tutor vir die kursus op Turnitin ingeskryf hê';
$string['turnitintutorsremoving'] = 'Turnitin-tutors word verwyder';
$string['turnitintutorsretrieving'] = 'Turnitin-tutors word herwin';
$string['turnitinuseanon'] = 'Gebruik Anonieme Nasien';
$string['turnitinuseanon_desc'] = 'Kies of Anonieme Nasien toegelaat moet word wanneer indienings gemerk word.<br /><i>(Dit is net beskikbaar aan dié wat Anonieme Nasien vir hul rekenaar gekonfigureer het)</i>';
$string['turnitinuseerater'] = 'Ontsper ETS&kopieer;';
$string['turnitinuseerater_desc'] = 'Kies of ETS&kopieer; grammatikakontrole ontsper moet wees.<br /><i>(Ontsper hierdie opsie slegs as ETS&kopieer; e-rater op jou Turnitin-rekening ontsper is)</i>';
$string['turnitinusegrademark'] = 'Gebruik GradeMark';
$string['turnitinusegrademark_desc'] = 'Kies of GradeMark of Moodle gebruik moet word om indienings na te sien.<br /><i>(Dit is slegs beskikbaar aan diegene wat GradeMark vir hul rekening gekonfigureer het)</i>';
$string['turnitinusegrademark_help'] = 'Gebruik hierdie verstelling om te kies of Turnitin GradeMark of Moodle gebruik moet word om die indienings na te sien.';
$string['turnitinuserepository'] = 'Ontsper Instellingsbewaararea';
$string['turnitinuserepository_desc'] = 'Kies of die gebruik van Instellingsbewaarareas in Turnitin-opdragte gebruik mag word.<br /><i>(Dit is slegs beskikbaar aan diegene wat \'n Instellingsbewaararea vir hul rekening ontsper het)</i>';
$string['turnitinuserepository_help'] = 'Gebruik hierdie verstelling om die Instellingsbewaararea-opsie in die opdragopstelskerm te ontsper.';
$string['tutorgeterror'] = 'Kon nie Tutordata van opdrag  verkry nie';
$string['tutorstatus'] = '{$a->submitted}/{$a->total} Studentindienings, {$a->graded} Indiening {$a->gplural} Nagesien';
$string['type'] = 'Indieningstipe';
$string['types'] = 'Indieningstipes';
$string['types_help'] = '<p>Indienings kan in drie verskillende formate gemaak word.</p>';
$string['unlinkedusers'] = 'Niegekoppelde Gebruikers';
$string['unlinkinfo'] = 'Gebruik hierdie vorm om die koppeling tussen Moodle- en Turnitin-gebruikers te verbreek. Dit sal die Gebergde Turnitin-gebruiker-ID van die Moodle-stelsel verwyder, wat Moodle sal dwing om die gebruikers met die volgende oproep na Turnitin te probeer herkoppel.';
$string['unlinkrelinkusers'] = 'Ontkoppel / Herkoppel Turnitin-gebruikers';
$string['unlinkusers'] = 'Ontkoppel Gebruikers';
$string['update'] = 'Werk by';
$string['update_turnitintool'] = 'Werk Turnitin-opdrag by';
$string['updateerror'] = 'Werk Fout by';
$string['updatestudent'] = 'Indiening {$a->from} van {$a->to} word bygewerk';
$string['updatinggrade'] = 'Turnitin-punt word herwin';
$string['updatingreport'] = 'Turnitin-verslagpunt word herwin';
$string['updatingscores'] = 'Data vir gebruiker {$a->user} / Opdragdeel {$a->proc} word herwin';
$string['upgradeavailable'] = 'Bywerking Beskikbaar';
$string['uploadingtoturnitin'] = 'Dokument word na Turnitin opgelaai';
$string['urlsnapshot'] = 'URL-flitsbeeld word geneem';
$string['urltosubmit'] = 'Webblad-URL om in te dien';
$string['urltosubmit_url'] = 'Voer die adres in van die webblad wat jy indien. Slegs enkele webblaaie kan ingedien word. \'n Flitsbeeld van die bladsy sal geneem word en die html sal op Turnitin gelaai word.';
$string['useaverage'] = 'Merk deur indieningsgemiddeld te gebruik';
$string['user'] = 'Gebruiker';
$string['usercreationerror'] = 'Skepping van Turnitin-gebruiker het misluk';
$string['userdeleteerror'] = 'Kon nie gebruikerdata uitwis nie';
$string['usergeterror'] = 'Kon nie gebruikerdata verkry nie';
$string['userprocess'] = 'Gebruikerdata word Verwerk';
$string['userstounlink'] = 'Gebruikers om te Ontkoppel';
$string['usersunlinkrelink'] = 'Gebruikers om te Ontkoppel / Herkoppel';
$string['userupdateerror'] = 'Kon nie gebruikerdata bywerk nie';
$string['view'] = 'Besigtig';
$string['view_turnitintool'] = 'Besigtig Turnitin-opdrag';
$string['viewdelete'] = 'Besigtig/Wis uit';
$string['viewreport'] = 'Besigtig Verslag';
$string['viewsubmissions'] = 'Besigting Indienings';
$string['webpage'] = 'Webblad';
$string['weight'] = 'Punteverhouding';
$string['wrongaccountid'] = 'Daar was \'n fout met die koppeling van jou Turnitin-klas. Die rekening wat jy gekonfigureer het, is rekening {$a->current). Die rekening vanwaar hierdie klas is, is {$a->backupid}. Jy kan slegs klasse herstel wat uit dieselfde Turnitin-rekening afkomstig is.';
$string['yes'] = 'Ja';
$string['yesgrademark'] = 'Ja, gebruik GradeMark om indienings te merk';
$string['yesgrades'] = 'Ja, verfris oorspronklikheidstelling en punte outomaties';
