<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_intelliboard', language 'ar', version '5.1'.
 *
 * @package     local_intelliboard
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['a0'] = 'لوحة بيانات الكفاءة';
$string['a1'] = 'الكفاءات';
$string['a10'] = 'المتعلمين المسجلين';
$string['a11'] = 'قائمة الكفاءات المعينة في الحقيبة التدريبية';
$string['a12'] = 'حالة المتعلم';
$string['a13'] = 'اسم الكفاءة';
$string['a14'] = 'تم الإنشاء في';
$string['a15'] = 'تم التعيين في';
$string['a16'] = 'الماهر المشار إليه';
$string['a17'] = 'التقييم';
$string['a18'] = 'الماهر في الكفاءات';
$string['a19'] = 'تاريخ تقييم الكفاءة';
$string['a2'] = 'المهارة';
$string['a20'] = 'مقيم الكفاءة';
$string['a21'] = 'أنشطة المستخدم المعينة';
$string['a22'] = 'المهارة المحققة';
$string['a23'] = 'تقييم الكفاءة';
$string['a24'] = '#الأدلة';
$string['a25'] = 'المتعلمون المكتملون';
$string['a26'] = 'يعرض هذا الجدول عدد الكفاءات المخصصة للحقيبة، والمتعلمين الذين تم تقييمهم (سواء أكانوا ماهرين أم لا) ، والمتعلمين الذين تم تعيينهم ماهرين في الكفاءة.';
$string['a27'] = 'من';
$string['a28'] = 'التفاصيل';
$string['a29'] = 'تفعيل لوحة بيانات الكفاءة';
$string['a3'] = 'النشاطات المحددة';
$string['a30'] = 'تشغيل تقارير الكفاءة';
$string['a31'] = 'الأطر';
$string['a32'] = 'خطط التدريب';
$string['a33'] = 'تم التقييم: ماهر';
$string['a34'] = 'تم التقييم:غير ماهر';
$string['a35'] = 'غير مقيم';
$string['a36'] = 'نظرة عامة على الكفاءة';
$string['a37'] = 'لم يتم إنشاء الكفاءة. من فضلك تواصل مع مسؤول نظامك';
$string['a38'] = 'حقائب تدريبية مرتبطة بالكفاءات';
$string['a39'] = 'إجماليات الكفاءة';
$string['a4'] = 'تقدم المهارة';
$string['a40'] = 'الحقائب التدريبية المرتبطة';
$string['a5'] = 'الكفاءات المقيّمة';
$string['a6'] = '# الأدلة';
$string['a7'] = 'المتعلمين المقيّمين';
$string['a8'] = 'التقدم';
$string['a9'] = 'المتعلمين البارعين';
$string['account'] = 'معلومات الإشتراك';
$string['actions'] = 'الإجراءات';
$string['active'] = 'نشط';
$string['activities'] = 'الأنشطة';
$string['activities_resources'] = 'الأنشطة/ المصادر';
$string['activity'] = 'نشاط';
$string['activity_grades'] = 'تقديرات النشاط';
$string['activity_name'] = 'اسم النشاط';
$string['activity_participation'] = 'المشاركة في النشاط';
$string['activity_progress'] = 'تقدم النشاط';
$string['address'] = 'العنوان';
$string['adm_dshb_adm_dashb_totals'] = 'الإجماليات';
$string['adm_dshb_course_enrollments_types'] = 'أنواع التسجيل في الحقيبة التدريبية';
$string['adm_dshb_user_enr_sess_compl_act_lvls'] = 'تسجيل المستخدم ، الجلسة ، مستويات إكمال النشاط';
$string['adm_dshb_user_enrol_with_compl_overview'] = 'عمليات التسجيل في الحقيبة التدريبية مع نظرة عامة على الإنجاز';
$string['adm_dshb_user_map'] = 'خريطة المستخدم';
$string['adm_dshb_user_site_summary_details'] = 'تفاصيل ملخص موقع المستخدم';
$string['admin_dashboard'] = 'لوحة بيانات مسؤول الموقع';
$string['adv_settings'] = 'إعدادات متقدمة';
$string['ajax'] = 'التكرار';
$string['ajax_desc'] = 'تكرار تخزين الجلسة عبر AJAX. 0 - تعطيل AJAX (بالثواني)';
$string['all_cohorts'] = 'كل الدفعات';
$string['all_courses'] = 'جميع الحقائب التدريبية';
$string['all_data'] = 'جميع البيانات';
$string['all_fields_required'] = 'جميع الحقول مطلوبة';
$string['all_modules'] = 'جميع الوحدات';
$string['all_time'] = 'جميع الأوقات';
$string['allmod'] = 'جميع الأنشطة';
$string['analityc_3_name'] = 'نظرة عامة على الاختبار وتفاصيل السؤال';
$string['analytics'] = 'التحليلات';
$string['answers'] = 'الإجابات';
$string['api'] = 'واجهة برمجة التطبيقات البديلة';
$string['api_desc'] = 'استخدم خادم واجة برمجة التطبيقات البديل (لتجنب حظر جدار الحماية)';
$string['assignment_name'] = 'اسم الواجب';
$string['assignments'] = 'الواجبات';
$string['attendance'] = 'الحضور';
$string['attendanceapibase'] = 'المسار الأساسي لواجهة برمجة تطبيقات الحضور';
$string['attendanceapikey'] = 'مفتاح واجهة برمجة تطبيقات الحضور';
$string['attendanceapisecret'] = 'مفتاح سر  واجهة برمجة تطبيقات الحضور';
$string['attendanceconsumerkey'] = 'مفتاح العميل';
$string['attendancesharedsecret'] = 'السر المشترك';
$string['attendancetoolurl'] = 'عنوان موقع الأداة';
$string['authentication'] = 'إنشاء حساب';
$string['authorized_user_descr'] = 'يتطلب IntelliBoard مستخدمًا معتمدًا. من المحتمل أن يكون المستخدم المعتمد مسؤول موقع ويجب أن يكون لديه امتيازات لإدارة خدمات الويب والبروتوكولات والرموز المميزة. للحصول على مراجعة إضافية ، انتقل إلى إدارة الموقع> الإضافات> خدمات الويب> الخدمات الخارجية> خدمة IntelliBoard> مستخدم معتمد';
$string['average_grade'] = 'متوسط الدرجة';
$string['avg_score'] = 'متوسط الدرجة';
$string['avg_time_spent_per_stud'] = 'متوسط الوقت الذي يقضيه الطالب';
$string['avg_visits_per_stud'] = 'متوسط عدد الزيارات لكل طالب';
$string['bb_col_api_endpoint'] = 'نقطة نهاية واجهة برمجة التطبيقاتBlackBoard Collaborate';
$string['bb_col_consumer_key'] = 'مفتاح عميل BlackBoard Collaborate';
$string['bb_col_meetings'] = 'اجتماعات BlackBoard Collaborate';
$string['bb_col_secret'] = 'مفتاح سر BlackBoard Collaborate';
$string['bbbapiendpoint'] = 'نقط نهاية واجهة برمجة تطبيقات BBB';
$string['bbbmeetings'] = 'اجتماعات BigBlueButton';
$string['bbbserversecret'] = 'سر خادم BBB';
$string['billingcycles'] = 'دورات الفواتير';
$string['cache_compresstracking'] = 'حفظ في خبء مودل';
$string['cachedef_bb_collaborate_access_token'] = 'رمز الوصول التعاوني BB';
$string['cachedef_instructor_course_data'] = 'ذاكرة تخزين مؤقتة لبيانات الحقيبة التدريبية';
$string['cachedef_reports_list'] = 'ذاكرة التخزين المؤقت لقائمة التقارير';
$string['cachedef_track_config'] = 'تتبع Intelliboard لإجمالي بيانات';
$string['cachedef_tracking'] = 'تتبع Intelliboard للبيانات';
$string['cancel_subscription'] = 'إلغاء الاشتراك';
$string['canceled'] = 'تم الإلغاء';
$string['categories'] = 'فئات';
$string['category'] = 'فئة';
$string['check_active_bb_col_meetings'] = 'تحقق من اجتماع BlackBoard Collaborate النشط';
$string['check_active_meetings'] = 'تحقق من الاجتماعات النشطة';
$string['cipherlist'] = 'قائمة التشفير CURLOPT SSL';
$string['cipherlist_desc'] = 'حدد الأصفار لاستخدامها مع TLS';
$string['city'] = 'المدينة/ البلدة';
$string['class_average'] = 'متوسط درجات الصف';
$string['click_link_below_support_pages'] = 'انقر فوق الارتباط أدناه للوصول إلى صفحات دعم IntelliBoard:';
$string['close'] = 'إغلاق';
$string['closed'] = 'مغلق';
$string['cohorts'] = 'الدفعات';
$string['completed'] = 'مكتمل';
$string['completed_activities'] = 'الأنشطة المكتملة';
$string['completed_activities_resources'] = 'الأنشطة / الموارد المكتملة';
$string['completed_activities_resourses'] = 'الأنشطة / الموارد المكتملة';
$string['completed_courses'] = 'الحقائب التدريبية المكتملة';
$string['completed_on'] = 'مكتمل في {$a}';
$string['completion'] = 'الإكمال';
$string['completion_is_not_enabled'] = 'لم يتم تفعيل  الإكمال لهذه الحقيبة التدريبية';
$string['completion_not_enabled'] = 'الإكمال غير مفعل';
$string['completion_status'] = 'حالة الإكمال';
$string['completions'] = 'حالة اكتمال النشاط';
$string['completions_completed'] = 'حالة الإكمال (مكتمل)';
$string['completions_desc'] = '1) أكمل المستخدم هذا النشاط. لم يتم تحديد ما إذا كانوا قد اجتازوه أو فشلوا فيه. <br> 2) أكمل المستخدم هذا النشاط بدرجة أعلى من علامة النجاح. <br> 3) أكمل المستخدم هذا النشاط ولكن درجته أقل من علامة النجاح.';
$string['completions_fail'] = 'حالة الإكمال (فشل)';
$string['completions_pass'] = 'حالة الإكمال(النجاح)';
$string['compresstracking'] = 'تتبع الضغط';
$string['compresstracking_desc'] = 'كتابة بيانات تتبع الوقت إلى ملف أو redis ونقل البيانات إلى قاعدة البيانات باستخدام وظيفة cron (الوقت افتراضي: كل 15 دقيقة)';
$string['confirm_and_sign_up'] = 'قم بالتأكيد والتسجيل';
$string['congratulations_intb_register'] = 'تهانينا';
$string['congratulations_intb_register_msg'] = 'شكرًا لك على بدء تجربة الإصدار التجريبي المجاني لمدة 15 يومًا مع IntelliBoard! يرجى التحقق من بريدك الإلكتروني لتأكيد حساب IntelliBoard الخاص بك. للبدء ، استخدم رابط الدخول الموحّد (SSO) ، إذا تم تمكينه من إدارة الموقع> IntelliBoard أو سجّل الدخول <a href="https://app.intelliboard.net/signin"> هنا </a>. يُقرأ ارتباط SSO على أنه "INTELLIBOARD.NET" ويقع في الركن الأيمن العلوي من لوحة المعلومات. للأسئلة ، يرجى الاتصال Support@IntelliBoard.net.';
$string['cor_incor_answers'] = 'الإجابات الصحيحة/الخاطئة';
$string['correct'] = 'صحيح';
$string['correct_number'] = '{$a} صحيح';
$string['correlations'] = 'الارتباطات';
$string['country'] = 'البلد';
$string['course'] = 'الحقيبة التدريبية';
$string['course_activities'] = 'تفعيل أنشطة الحقيبة';
$string['course_category'] = 'فئة الحقيبة التدريبية';
$string['course_chart'] = 'تفعيل جدول الحقيبة التدريبية';
$string['course_completion_status'] = 'حالة إكمال الحقيبة التدريبية';
$string['course_completions'] = 'إكمال الحقيبة التدريبية';
$string['course_enrollment_types'] = 'أنواع التسجيل في الحقيبة التدريبية';
$string['course_enrollments_with_completion_overview'] = 'عمليات التسجيل في الحقيبة التدريبية مع نظرة عامة على الإنجاز';
$string['course_grade'] = 'علامة الحقيبة التدريبية';
$string['course_idnumber'] = 'رقم المُعرَّف';
$string['course_max_grade'] = 'الدرجة  القصوى للحقيبة التدريبية';
$string['course_name'] = 'اسم الحقيبة التدريبية';
$string['course_name_a'] = 'الحقيبة التدريبية : {$a}';
$string['course_overview'] = 'نظرة عامة على الحقيبة التدريبية';
$string['course_progress'] = 'تقدم الحقيبة التدريبية';
$string['course_short_name'] = 'الاسم المختصر للحقيبة التدريبية';
$string['course_start_date'] = 'تاريخ بدء الحقيبة التدريبية';
$string['course_started'] = 'الحقيبة التدريبية بدأت';
$string['course_status'] = 'حالة';
$string['course_success'] = 'نجاح الحقيبة التدريبية';
$string['courseaverage'] = 'متوسط الحقيبة التدريبية';
$string['courses'] = 'الحقائب التدريبية';
$string['courses_avg_grade'] = 'متوسط درجة الحقائب التدريبية';
$string['courses_in_progress'] = 'الحقائب التدريبية قيد التنفيذ';
$string['courses_sum_grade'] = 'درجة مجموع المساق مقسومة على قيمة مقياس الدرجة';
$string['coursessessions'] = 'جلسات الحقائب التدريبية';
$string['coursessessionspage'] = 'صفحة جلسات الحقائب التدريبية';
$string['created'] = 'تم الإنشاء';
$string['criteria_all_courses'] = 'يجب إكمال جميع الحقائب التدريبية التالية';
$string['criteria_any_course'] = 'يجب إكمال أي من الحقائب التدريبية التالية';
$string['criteria_method'] = 'نظام المعايير';
$string['csv'] = 'ملف مفصول بفواصل';
$string['current_grade'] = 'الدرجة الحالية';
$string['customod'] = 'الأنشطة المخصصة';
$string['daily'] = 'الأيام 10 الأخيرة';
$string['dashboard'] = 'لوحة البيانات';
$string['dashboard_settings'] = 'إعدادات لوحة البيانات';
$string['date_created'] = 'تاريخ الإنشاء';
$string['date_format'] = 'صيغة التاريخ';
$string['debug'] = 'طلبات التصحيح CURL';
$string['delete_message'] = 'هل تريد حذف تقرير SQL؟';
$string['department'] = 'قسم';
$string['details'] = 'تفاصيل';
$string['disable_time_and_visits_users_overview'] = 'تعطيل الوقت المنقضي والزيارات في نظرة عامة على المستخدمين';
$string['disabled'] = 'معطل';
$string['do_not_use_compresstracking'] = 'لا تستخدم تتبع الضغط';
$string['done'] = 'تم!';
$string['downloadinvoice'] = 'تحميل فاتورة';
$string['due_date'] = 'تاريخ التسليم';
$string['email'] = 'البريد الإلكتروني';
$string['email_is_required'] = 'البريد الإلكتروني مطلوب';
$string['email_subscr'] = 'البريد الإلكتروني للإشتراك';
$string['enable_badges_report'] = 'تفعيل تقرير "الشارات"';
$string['enable_bb_col_debug'] = 'تفعيل تصحيح أخطاء BlackBoard Collaborate';
$string['enable_bb_col_meetings'] = 'قم بتمكين اجتماعات BlackBoard Collaborate';
$string['enable_sso'] = 'تفعيل ارتباط تسجيل الدخول الأحادي (SSO)';
$string['enable_sso_descr'] = 'قم بتمكين ارتباط تسجيل الدخول الأحادي للوصول بنقرة واحدة لمسؤولي الموقع إلى الوصول إلى IntelliBoard Super Admin على التطبيق.';
$string['enable_time_and_visits_users_overview'] = 'تمكين الوقت المنقضي والزيارات في نظرة عامة على المستخدمين';
$string['enable_time_tracking'] = 'تفعيل تعقب الوقت';
$string['enable_time_tracking_descr'] = 'قم بتفعيل تتبع الوقت للحصول على رؤى إضافية حول وصول المستخدم والزيارات والوقت الذي يقضيه. يوفر IntelliBoard رؤى إضافية حول تتبع الوقت بشكل منفصل عن جداول الوقت المستغرق في Moodle.';
$string['enable_transcripts'] = 'تفعيل النصوص';
$string['enable_webservice'] = 'تفعيل خدمات الويب';
$string['enableattendance'] = 'تفعيل خاصية الحضور';
$string['enablebbbdebug'] = 'وضع تصحيح BigBlueButton';
$string['enablebbbmeetings'] = 'تفعيل مراقبة اجتماعات BigBlueButton';
$string['enabled'] = 'تم تفعيل التعقب';
$string['enabled_desc'] = 'تفعيل التعقب';
$string['enablesyncattendance'] = 'قم بتفعيل مزامنة جلسات BB Collaborate مع InAttendance';
$string['enroled_on'] = 'تاريخ التسجيل';
$string['enrolled'] = 'مسجل';
$string['enrolled_completed'] = 'مسجل: {$a->courses} ، مكتمل: {$ a-> complete_courses}';
$string['enrolled_completed_learners'] = 'المتعلمون المسجلون / المكتملون';
$string['enrolled_date'] = 'تاريخ التسجيل';
$string['enrolled_users_completed'] = 'المستخدمون المسجلون: {$ a-> users} ، المكتمل: {$ a-> complete}';
$string['enrollments'] = 'التسجيلات';
$string['enrolment_expiration'] = 'انتهاء التسجيل';
$string['enrolment_method'] = 'طريقة التسجيل';
$string['enter_course_and_quiz'] = 'لطفاً، إختر حقيبتك التدريبية واختبارك.';
$string['enter_quiz'] = 'لطفاً، إختر اختبارك.';
$string['excel'] = 'إكسل';
$string['expired'] = 'منتهي';
$string['failed'] = 'فشل';
$string['failed_on'] = 'اكتمل (فشل) في {$ a}';
$string['file_compresstracking'] = 'حفظ في MoodleData';
$string['filter1'] = 'المستخدمون المحذوفون';
$string['filter1_desc'] = 'إظهار المستخدمين المحذوفين';
$string['filter2'] = 'المستخدمون الموقوفون مؤقتا';
$string['filter2_desc'] = 'إظهار المستخدمين الموقوفين مؤقتا';
$string['filter3'] = 'حساب زائر';
$string['filter3_desc'] = 'إظهار المستخدم [ضيف] في التقارير';
$string['filter4'] = 'مرشح الحقيبة التدريبية';
$string['filter4_desc'] = 'إظهار الحقائب التدريبية غير المرئية';
$string['filter5'] = 'مرشح طريقة التسجيل';
$string['filter5_desc'] = 'إظهار طرق التسجيل غير النشطة';
$string['filter6'] = 'مرشح تسجيل المستخدم';
$string['filter6_desc'] = 'اظهار المستخدمين الذين هم في حالة تسجيل غير نشطة';
$string['filter7'] = 'مرشح الأنشطة/ الموارد';
$string['filter7_desc'] = 'إظهار الأنشطة / الموارد غير المرئية';
$string['filter8'] = 'مرشح المستخدمين المسجلين';
$string['filter8_desc'] = 'إظهار المستخدمين المسجلين فقط (لا يوصى به)';
$string['filter_all_time'] = 'مرشح الوقت: كل الوقت';
$string['filter_dates'] = 'مرشح التواريخ:';
$string['filter_last_year'] = 'مرشح الوقت: العام الماضي';
$string['filter_this_year'] = 'مرشح الوقت: هذا العام';
$string['filters'] = 'مرشحات لوحة البيانات';
$string['first_access'] = 'أول وصول';
$string['first_name'] = 'الاسم الأول';
$string['firstname_lastname'] = '{First Name} {Last Name}';
$string['goal_grade'] = 'الدرجة الهدف';
$string['grade'] = 'الدرجة';
$string['grade_activities_overview'] = 'نظرة عامة على الأنشطة المصححة';
$string['graded'] = 'مصحح';
$string['grades'] = 'التقديرات';
$string['grades_alt_text'] = 'نص بديل لقائمة التنقل';
$string['grid_view'] = 'عرض شبكي';
$string['group_aggregation'] = 'إجمالي المجموعة';
$string['help'] = 'بحاجة الى مساعدة؟';
$string['highest_grade'] = 'أعلى درجة';
$string['hosting_provider'] = 'مزود استضافة';
$string['ianalytics'] = 'تحليلات IntelliBoard';
$string['id_number'] = 'رقم المُعرَّف';
$string['import'] = 'استيراد';
$string['importing_logs'] = 'استيراد السجلات';
$string['importing_totals'] = 'استيراد الإجماليات';
$string['importtrackingtask'] = 'مهمة تتبع الاستيراد';
$string['in1'] = 'نظرة عامة';
$string['in10'] = 'استخدام الحدث';
$string['in11'] = 'تقدم المتعلم';
$string['in12'] = 'تقدم الدرجة';
$string['in13'] = 'الوقت المنقضي (٪)';
$string['in14'] = '٪ تقدم';
$string['in15'] = 'إكمالات المتعلم';
$string['in16'] = 'آخر وصول';
$string['in17'] = 'إجمالي الوقت المنقضي';
$string['in18'] = 'إجمالي الزيارات';
$string['in19'] = 'متوسط. .الدرجة';
$string['in2'] = 'التقدم الحالي';
$string['in20'] = 'العودة إلى المتعلمين';
$string['in201'] = 'العودة إلى الأنشطة';
$string['in21'] = 'متوسط. .علامة الحقيبة التدريبية';
$string['in22'] = 'تم التفعيل';
$string['in23'] = 'ليس لديك متعلمين لعرضهم.';
$string['in24'] = 'وحدة';
$string['in25'] = 'علامة النجاح';
$string['in26'] = 'مشاركة المتعلم';
$string['in27'] = 'إجمالي الطلاب';
$string['in28'] = 'متوسط الوقت المستغرق';
$string['in29'] = 'الطلاب النشطون';
$string['in3'] = 'إجمالي الحقائب التدريبية';
$string['in30'] = 'الطلاب غير النشطين';
$string['in31'] = 'استخدام النشاط';
$string['in32'] = 'متوسط الوقت خلال الفترة المحددة';
$string['in33'] = 'استخدام الموضوع';
$string['in34'] = 'تطور علامة الطالب';
$string['in4'] = 'إجمالي المتعلمين';
$string['in5'] = 'إجمالي تقديرات المساق';
$string['in6'] = 'المتعلمون المكملون';
$string['in7'] = 'المتعلمين الغير مكتملين';
$string['in8'] = 'متوسط علامة الطالب';
$string['in9'] = 'الارتباطات';
$string['inactivity'] = 'الخمول';
$string['inactivity_desc'] = 'خمول المستخدم( بالثواني)';
$string['incomplete'] = 'غير مكتمل';
$string['incorrect'] = 'غير صحيح';
$string['incorrect_number'] = '{$a} غير صحيح';
$string['initial_reports'] = 'التقارير الأولية';
$string['initial_reports_warning'] = 'لإرسال هذه التقارير بالبريد الإلكتروني وجدولتها وإضفاء الطابع الشخصي عليها ، انقر على "<a href="{$a}"> اتصال و تحسين</a>".';
$string['inprogress'] = 'قيد التنفيذ';
$string['institution'] = 'مؤسسة';
$string['instructor_course_shortname'] = 'إظهار الاسم المختصر للحقيبة التدريبية بدلا من الاسم الكامل للحقيبة';
$string['instructor_course_visibility'] = 'إظهار المقررات الدراسية المخفية/المعلقة لـ [المعلم]';
$string['instructor_courses_table_name'] = 'تقديرات المساق';
$string['instructor_courses_table_name_activities'] = 'أنشطة الحقيبة التدريبية {$a->fullname}';
$string['instructor_courses_table_name_activity'] = 'تقديرات النشاط {$a->name} في المساق {$a->course}';
$string['instructor_courses_table_name_learner'] = 'تقديرات المتعلم {$a->learner} في المساق {$a->course}';
$string['instructor_courses_table_name_learners'] = 'متعلمي الحقيبة التدريبية {$a->fullname}';
$string['instructor_custom_groups'] = 'مجموعات المعلم المخصصة';
$string['instructor_hide_need_help'] = 'إخفاء الزر" بحاجة إلى مساعدة"';
$string['instructor_mode'] = 'إظهار كل المقررات الدراسية المتاحة لـ [المعلم]';
$string['instructor_mode_access'] = 'إظهار كل المقررات الدراسية المتاحة لـ [المعلم] مع [تحديث] الصلاحيات';
$string['instructor_redirect'] = 'إعادة توجيه المعلم';
$string['instructor_show_suspended_enrollments'] = 'إظهار التسجيلات الموقوفة مؤقتا';
$string['intb_settings_descr'] = 'يتطلب IntelliBoard بريدًا إلكترونيًا رئيسيًا وفريدًا للاشتراك. الرجاء إدخال البريد الإلكتروني الذي ترغب في استخدامه كبريد إلكتروني للاشتراك أدناه. يجب التحقق من البريد الإلكتروني مرتين من خلال تأكيد البريد الإلكتروني قبل الاستخدام. للأسئلة ، يرجى الاتصال <a href=\'mailto:Support@IntelliBoard.net\'> Support@IntelliBoard.net </a>. للحصول على قائمة كاملة بإعدادات IntelliBoard ، انتقل إلى إدارة الموقع> الإضافات> الإضافات المحلية> IntelliBoard';
$string['intelliBoard_migration_tool'] = 'أداة ترحيل IntelliBoard';
$string['intelliBoard_migration_tool_info'] = 'تُستعمل أداة ترحيل IntelliBoard لترحيل البيانات التاريخية من جدول وقوعات مودل إلى تنسيق جديد. يرجى ملاحظة أن إجراء تخزين وقوعات مودل لن يتغير. بمجرد ترحيل البيانات التاريخية إلى تنسيق جديد، ستتوفر القيم التاريخية مثل \'الوقت المصروف\' و \'الزيارات\' للمعاينة في IntelliBoard.net.';
$string['intelliboard:attendanceadmin'] = 'مشرف الحضور';
$string['intelliboard:browseallcohorts'] = 'IntelliBoard [استعراض كل الدفعات]';
$string['intelliboard:competency'] = 'IntelliBoard
[الكفاءة]';
$string['intelliboard:instructors'] = 'IntelliBoard [المعلم]';
$string['intelliboard:manage'] = '[إدارة ]IntelliBoard';
$string['intelliboard:students'] = '[طالب ]IntelliBoard';
$string['intelliboard:view'] = '[عرض] IntelliBoard';
$string['intelliboard_logs'] = 'سجلات IntelliBoard';
$string['intelliboard_reports'] = 'تقارير IntelliBoard';
$string['intelliboard_settings'] = 'إعدادات IntelliBoard';
$string['intelliboard_start_tracking'] = 'بدء التعقب IntelliBoard';
$string['intelliboard_terms'] = 'إتفاقيات IntelliBoard';
$string['intelliboard_totals'] = 'إجماليات IntelliBoard';
$string['intelliboard_tracking'] = 'تعقب IntelliBoard';
$string['intelliboardaccess'] = 'ليست لديك صلاحية معاينة هذه الصفحة. يرجى التواصل مع مشرفك للحصول على المساعدة.';
$string['intelliboardnet'] = 'IntelliBoard.net';
$string['intelliboardroot'] = 'IntelliBoard';
$string['intellicart'] = 'تكامل IntelliCart';
$string['intellicart_app_reports_integration'] = 'التكامل مع تقارير IntelliBoard';
$string['intellicart_desc'] = 'اسمح للطلاب بمشاهدة تقارير IntelliCart.';
$string['intellicart_instructor_integration'] = 'التكامل مع دفة قيادة المعلم';
$string['intellicart_student_integration'] = 'التكامل مع لوحة بيانات الطالب';
$string['invalid_email'] = 'بريد إلكتروني غير صالح';
$string['invalid_user'] = 'مستخدم غير صالح';
$string['issuer'] = 'المُصدر';
$string['items_per_query'] = 'العناصر لكل استعلام';
$string['join_a_webinar'] = 'انضم إلى ندوة عبر الإنترنت';
$string['key'] = 'مفتاح';
$string['last_access'] = 'آخر وصول';
$string['last_access_on_course'] = 'آخر وصول إلى الحقيبة التدريبية: {$ a}';
$string['last_day'] = 'يوم';
$string['last_hour'] = 'ساعة';
$string['last_month'] = 'الأيام 30 الأخيرة';
$string['last_name'] = 'اسم العائلة';
$string['last_quarter'] = 'الأشهر  3 الأخيرة';
$string['last_semester'] = 'الأشهر  6 الأخيرة';
$string['last_week'] = 'الأيام 7 الأخيرة';
$string['last_year'] = 'العام الماضي';
$string['lastname_firstname'] = '{Last Name} {First Name}';
$string['learner_menu'] = 'إظهار "لوحة بيانات  المتعلم" في قائمة كتلة التنقل فقط للمتعلمين المنضمين';
$string['learner_name'] = 'اسم المتعلم';
$string['learner_tf_last_week'] = 'مرشح الوقت: 7 أيام';
$string['learners'] = 'المتعلمين';
$string['learners_enrolled'] = 'المتعلمين المسجلين';
$string['learners_enrolled_period'] = 'المتعلمين المسجلين خلال الفترة المحددة';
$string['learning'] = 'التعلم';
$string['learning_plan_filter'] = 'مرشح خطة التعلم';
$string['learning_plan_viewer_role'] = 'دور" عارض خطة التعلم"';
$string['learning_progress'] = 'تقدم التعلم';
$string['letter'] = 'رسالة';
$string['list_view'] = 'عرض القائمة';
$string['load'] = 'الأداء';
$string['loading'] = 'جاري التحميل...';
$string['loading2'] = 'جاري التحميل، يرجى الانتظار...';
$string['log_values_include'] = 'قِيَم السجلات تتضمن سجلات الوقوعات لكل مستخدم كل يوم.';
$string['logs'] = 'أداة الترحيل';
$string['logs_to_process'] = 'السجلات المطلوبة معالجتها {$a}';
$string['lowest_grade'] = 'أدنى علامة';
$string['messageprovider:intelliboard_notification'] = 'إشعارات Intelliboard';
$string['messages'] = 'الرسائل';
$string['modulename'] = 'اسم الوحدة';
$string['modules'] = 'الوحدات';
$string['monitors'] = 'الشاشات';
$string['monitorselect'] = 'يرجى تحديد شاشة واحدة على الأقل من App.IntelliBoard.net. انقر على الشاشات ، ثم إعدادات الشاشات ، وحددها في "مرئي في مودل".';
$string['monthly'] = 'الأيام 365 الأخيرة';
$string['moodle'] = 'مودل';
$string['moodle_logs'] = 'سجلات مودل';
$string['moodle_settings'] = 'إعدادات مودل';
$string['more_courses'] = 'المزيد من حقائب تدريبية';
$string['more_users'] = 'المزيد من المستخدمين';
$string['my_course_average_all'] = 'متوسط حقيبتي التدريبية ( جميع الحقائب)';
$string['mygrade'] = 'علامتي';
$string['myorders'] = 'الطلبات';
$string['myprogress'] = 'التقدم في علامتي';
$string['myseats'] = 'المقاعد';
$string['mysqldaymonth'] = '%d %b %Y';
$string['mysqldayshortmonthyear'] = '%d %b, %Y';
$string['mysqlhour'] = '%h:%i %p';
$string['mysqlmonth'] = '%c';
$string['mysqlmonthdayyear'] = '%m/%d/%Y';
$string['mysqlmonthyear'] = '%M %Y';
$string['mysqlmonthyearday'] = '%M %Y, %d';
$string['mysqlquarter'] = 'ربع';
$string['mysqltimedate'] = '%h:%i%p, %d %b %Y';
$string['mysqltimemonthdayyear'] = '%H %m/%d/%Y';
$string['mysqlweek'] = '%Y, week %v';
$string['mysqlyear'] = '%Y';
$string['mysubscriptions'] = 'الإشتراكات';
$string['mywaitlist'] = 'قائمة الإنتظار';
$string['n1'] = 'نظرة عامة [تقدم المتعلم]';
$string['n10'] = 'دفة قيادة المعلم';
$string['n101'] = 'تمكين دفة قيادة المعلم';
$string['n11'] = 'النص البديل لقائمة كتلة التنقل';
$string['n12'] = 'نظرة عامة [نظرة عامة على الحقيبة التدريبية]';
$string['n13'] = 'إجمالي الطلاب';
$string['n14'] = 'المتحكم : مشاركة المتعلم';
$string['n15'] = 'المتحكم: استخدام النشاط';
$string['n16'] = 'المتحكم: موضوع الاستخدام';
$string['n17'] = 'صفحة التحليلات';
$string['n18'] = 'المتحكم: تقدم علامة الطالب';
$string['n19'] = 'رابط التنقل في الحقيبة للتقارير';
$string['n2'] = 'نظرة عامة [التقدم في الدرجة]';
$string['n3'] = 'نظرة عامة [التقدم في النشاط]';
$string['n4'] = 'نظرة عامة [الإجماليات]';
$string['n5'] = 'التقدم الحالي';
$string['n6'] = 'المتحكم: الارتباطات';
$string['n7'] = 'المتحكم: استخدام الحدث';
$string['n8'] = 'صفحة الحقائب التدريبية';
$string['n9'] = 'صفحة التقارير';
$string['name'] = 'الاسم';
$string['names_order'] = 'ترتيب الأسماء';
$string['next'] = 'التالي';
$string['no_competency'] = 'يبدو أنه ليس لديك كفاءات مفعلّة في موقع مودل الخاص بك.';
$string['no_data'] = 'لا يوجد بيانات';
$string['no_data_notification'] = 'لا توجد بيانات جديدة لـ [التاريخ]';
$string['not_connected'] = 'غير متصل';
$string['not_quiz'] = 'يا للعبوس، يبدو أنه ليس لديك أي اختبارات في الحقيبة التدريبية المحددة.';
$string['notstarted'] = 'لم يبدأ';
$string['num_attempts'] = 'عدد المحاولات';
$string['num_completed_activity'] = 'عدد المستخدمين الذين أكملوا هذا النشاط';
$string['number_of_completed_learners'] = 'عدد المستخدم(المستخدمين) المكتملين';
$string['number_of_learners'] = 'عدد المستخدم ( المستخدمين )المسجلين';
$string['number_of_modules'] = 'عدد النشاط( الأنشطة)';
$string['number_of_sessions'] = 'عدد الجلسات';
$string['number_of_visits'] = 'الزيارة (الزيارات)';
$string['number_this_week'] = '{$ a} هذا الأسبوع';
$string['number_today'] = '{$a} هذا اليوم';
$string['numberofseats'] = 'عدد المقاعد';
$string['ok'] = 'حسنا';
$string['overall_course_average'] = 'المعدل العام للحقيبة التدريبية (جميع المتعلمين ؛ جميع الحقائب التدريبية)';
$string['participation'] = 'المشاركة';
$string['passed'] = 'ناجح';
$string['passed_on'] = 'مكتمل(ناجح) في {$a}';
$string['passing_score_for'] = 'علامة النجاح ل {$a}';
$string['password'] = 'كلمة المرور';
$string['pdf'] = 'PDF';
$string['percentage_completed_learners'] = 'نسبة المتعلمين المكتملين';
$string['please_accept_terms_and_conditions'] = 'الرجاء قبول الشروط والأحكام';
$string['please_wait_or_cancel'] = 'يرجى الانتظار للمتابعة أو <a href="{$a}"> إلغاء </a>';
$string['pluginname'] = 'ملحق IntelliBoard.net';
$string['postgredaymonth'] = 'DD Mon YYYY';
$string['postgredayshortmonthyear'] = 'DD Mon, YYYY';
$string['postgrehour'] = 'HH12:MI AM';
$string['postgremonth'] = 'MM';
$string['postgremonthdayyear'] = 'MM/DD/YYYY';
$string['postgremonthyear'] = 'Month YYYY';
$string['postgremonthyearday'] = 'Month YYYY, DD';
$string['postgrequarter'] = 'ربع';
$string['postgrequarteryear'] = 'Q YYYY';
$string['postgretimedate'] = 'HH12:MIAM, DD Mon YYYY';
$string['postgretimemonthdayyear'] = 'HH24 MM/DD/YYYY';
$string['postgreweek'] = 'YYYY, "week" WW';
$string['postgreyear'] = 'YYYY';
$string['powered_by'] = 'بدعم من <a href="https://intelliboard.net/"> IntelliBoard.net </a>';
$string['price'] = 'السعر';
$string['privacy:metadata:local_intelliboard_assign'] = 'جدول تعيين-حسابات Intelliboard  الفرعية';
$string['privacy:metadata:local_intelliboard_assign:instance'] = 'معرف مثيل مودل المتصل';
$string['privacy:metadata:local_intelliboard_assign:rel'] = 'نوع السجل';
$string['privacy:metadata:local_intelliboard_assign:timecreated'] = 'الطابع الزمني للسجلات';
$string['privacy:metadata:local_intelliboard_assign:type'] = 'نوع مثيل مودل';
$string['privacy:metadata:local_intelliboard_assign:userid'] = 'معرف المستخدم المسجل';
$string['privacy:metadata:local_intelliboard_att_sync'] = 'قائمة الجلسات المتزامنة';
$string['privacy:metadata:local_intelliboard_att_sync:data'] = 'بيانات المزامنة الإضافية';
$string['privacy:metadata:local_intelliboard_att_sync:id'] = 'معرف سجل المزامنة';
$string['privacy:metadata:local_intelliboard_att_sync:instance'] = 'معرف جلسة مودل';
$string['privacy:metadata:local_intelliboard_att_sync:type'] = 'نوع الجلسة';
$string['privacy:metadata:local_intelliboard_bb_partic'] = 'قائمة المشاركين في جلسة تعاونية';
$string['privacy:metadata:local_intelliboard_bb_partic:display_name'] = 'اسم المستخدم';
$string['privacy:metadata:local_intelliboard_bb_partic:duration'] = 'الوقت المنقضي في الجلسة';
$string['privacy:metadata:local_intelliboard_bb_partic:external_user_id'] = 'معرف المستخدم(مودل)';
$string['privacy:metadata:local_intelliboard_bb_partic:first_join_time'] = 'أول انضمام إلى الجلسة';
$string['privacy:metadata:local_intelliboard_bb_partic:id'] = 'معرف المشاركة في الجلسة';
$string['privacy:metadata:local_intelliboard_bb_partic:last_left_time'] = 'آخر مغادرة من الجلسة';
$string['privacy:metadata:local_intelliboard_bb_partic:rejoins'] = 'عدد مرات  إعادة الانضمام إلى الجلسة';
$string['privacy:metadata:local_intelliboard_bb_partic:role'] = 'دور الجلسة';
$string['privacy:metadata:local_intelliboard_bb_partic:sessionuid'] = 'المعرف الفريد العالمي(UUID) للجلسة';
$string['privacy:metadata:local_intelliboard_bb_partic:useruid'] = 'المعرف الفريد العالمي( UUID) للمستخدم (خدمة BlackBoard Collaborate)';
$string['privacy:metadata:local_intelliboard_bb_trck_m'] = 'قائمة الجلسات المتعقبة';
$string['privacy:metadata:local_intelliboard_bb_trck_m:id'] = 'معرف تتبع السجل';
$string['privacy:metadata:local_intelliboard_bb_trck_m:sessionuid'] = 'المعرف الفريد العالمي(UUID) للجلسة';
$string['privacy:metadata:local_intelliboard_bb_trck_m:track_time'] = 'تتبع الوقت';
$string['privacy:metadata:local_intelliboard_bbb_atten'] = 'سجل حول حضور اجتماعات BigBlueButton';
$string['privacy:metadata:local_intelliboard_bbb_atten:arrivaltime'] = 'الوقت الذي انضم فيه المستخدم إلى الاجتماع';
$string['privacy:metadata:local_intelliboard_bbb_atten:departuretime'] = 'الوقت الذي قطع فيه المستخدم اتصاله بالاجتماع';
$string['privacy:metadata:local_intelliboard_bbb_atten:fullname'] = 'الاسم الكامل للحضور في الاجتماع';
$string['privacy:metadata:local_intelliboard_bbb_atten:hasjoinedvoice'] = 'علامة. لقد قام أحد الحضور بتوصيل ميكروفون';
$string['privacy:metadata:local_intelliboard_bbb_atten:hasvideo'] = 'علامة. لقد قام أحد الحاضرين بتوصيل كاميرا الويب';
$string['privacy:metadata:local_intelliboard_bbb_atten:id'] = 'معرف الحضور';
$string['privacy:metadata:local_intelliboard_bbb_atten:islisteningonly'] = 'علامة. الضيف ليس لديه ميكروفون أو كاميرا ويب متصلة';
$string['privacy:metadata:local_intelliboard_bbb_atten:ispresenter'] = 'علامة. الحاضر هو المقدم';
$string['privacy:metadata:local_intelliboard_bbb_atten:localmeetingid'] = 'معرف الاجتماع (المعرف في الجدول local_intelliboard_bbb_meet)';
$string['privacy:metadata:local_intelliboard_bbb_atten:meetingid'] = 'معرف الاجتماع (المعرف في خادم BigBlueButton)';
$string['privacy:metadata:local_intelliboard_bbb_atten:role'] = 'دور حضور الاجتماع';
$string['privacy:metadata:local_intelliboard_bbb_atten:userid'] = 'معرف المستخدم (صف في الجدول "المستخدم")';
$string['privacy:metadata:local_intelliboard_bbb_meet'] = 'سجل حول اجتماعات BigBlueButton';
$string['privacy:metadata:local_intelliboard_bbb_meet:attendeepw'] = 'كلمة المرور التي ستكون مطلوبة للحاضرين للانضمام إلى الاجتماع';
$string['privacy:metadata:local_intelliboard_bbb_meet:bigbluebuttonbnid'] = 'معرف الصف في الجدول bigbluebuttonbn';
$string['privacy:metadata:local_intelliboard_bbb_meet:cmid'] = 'معرف وحدة الحقيبة التدريبية';
$string['privacy:metadata:local_intelliboard_bbb_meet:courseid'] = 'معرف الحقيبة التدريبية';
$string['privacy:metadata:local_intelliboard_bbb_meet:createdate'] = 'إنشاء التاريخ(نص)';
$string['privacy:metadata:local_intelliboard_bbb_meet:createtime'] = 'إنشاء الوقت (الطابع الزمني)';
$string['privacy:metadata:local_intelliboard_bbb_meet:dialnumber'] = 'رقم الاتصال الهاتفي الذي يمكن للمشاركين الاتصال به باستخدام الهاتف العادي.';
$string['privacy:metadata:local_intelliboard_bbb_meet:duration'] = 'مدة الإجتماع';
$string['privacy:metadata:local_intelliboard_bbb_meet:endtime'] = 'وقت انتهاء الاجتماع';
$string['privacy:metadata:local_intelliboard_bbb_meet:hasbeenforciblyended'] = 'علامة. تم إنهاء الاجتماع بالقوة';
$string['privacy:metadata:local_intelliboard_bbb_meet:hasuserjoined'] = 'علامة. انضم المستخدمون إلى الاجتماع';
$string['privacy:metadata:local_intelliboard_bbb_meet:id'] = 'معرف سجل الإجتماع';
$string['privacy:metadata:local_intelliboard_bbb_meet:internalmeetingid'] = 'معرف الاجتماع الداخلي (في خادم BBB)';
$string['privacy:metadata:local_intelliboard_bbb_meet:listenercount'] = 'عدد المستمعين';
$string['privacy:metadata:local_intelliboard_bbb_meet:maxusers'] = 'أقصى عدد من المشاركين';
$string['privacy:metadata:local_intelliboard_bbb_meet:meetingid'] = 'معرف الإجتماع';
$string['privacy:metadata:local_intelliboard_bbb_meet:meetingname'] = 'اسم الإجتماع';
$string['privacy:metadata:local_intelliboard_bbb_meet:moderatorcount'] = 'عدد المشرفين';
$string['privacy:metadata:local_intelliboard_bbb_meet:moderatorpw'] = 'كلمة المرور المطلوبة للمشرفين للانضمام إلى الاجتماع أو لبعض الإجراءات الإدارية';
$string['privacy:metadata:local_intelliboard_bbb_meet:ownerid'] = 'معرف صاحب الإجتماع (المستخدم الذي أنشأ الاجتماع)';
$string['privacy:metadata:local_intelliboard_bbb_meet:participantcount'] = 'عدد الحضور';
$string['privacy:metadata:local_intelliboard_bbb_meet:recording'] = 'علامة. سيتم تسجيل الاجتماع';
$string['privacy:metadata:local_intelliboard_bbb_meet:running'] = 'حالة الاجتماع (نشط | متوقف)';
$string['privacy:metadata:local_intelliboard_bbb_meet:starttime'] = 'وقت بدء الاجتماع';
$string['privacy:metadata:local_intelliboard_bbb_meet:videocount'] = 'عدد المشاركين الذين لديهم كاميرا فيديو متصلة';
$string['privacy:metadata:local_intelliboard_bbb_meet:voicebridge'] = 'الرقم الداخلي للجسر الصوتي (استخدمه إذا كان متصلاً بنظام الهاتف)';
$string['privacy:metadata:local_intelliboard_bbb_meet:voiceparticipantcount'] = 'عدد المشاركين مع ميكروفون متصل';
$string['privacy:metadata:local_intelliboard_details'] = 'السجلات/Intelliboard alt / جدول بالساعة';
$string['privacy:metadata:local_intelliboard_details:logid'] = 'معرف الجدول [local_intelliboard_logs]';
$string['privacy:metadata:local_intelliboard_details:timepoint'] = 'الساعة';
$string['privacy:metadata:local_intelliboard_details:timespend'] = 'مقدار الوقت المستغرق في الساعة';
$string['privacy:metadata:local_intelliboard_details:visits'] = 'عدد الزيارات ، نقرات الفأرة، في اليوم';
$string['privacy:metadata:local_intelliboard_logs'] = 'السجلات/Intelliboard alt / جدول باليوم';
$string['privacy:metadata:local_intelliboard_logs:timepoint'] = 'الطابع الزمني لليوم في السنة';
$string['privacy:metadata:local_intelliboard_logs:timespend'] = 'الوقت المستغرق،  في اليوم';
$string['privacy:metadata:local_intelliboard_logs:trackid'] = 'معرّف الجدول [local_intelliboard_tracking]';
$string['privacy:metadata:local_intelliboard_logs:visits'] = 'عدد الزيارات ، نقرات الفأرة، في اليوم';
$string['privacy:metadata:local_intelliboard_ntf'] = 'الجدول الرئيسي لإشعارات Intelliboard';
$string['privacy:metadata:local_intelliboard_ntf:attachment'] = 'مرفق  الإشعار';
$string['privacy:metadata:local_intelliboard_ntf:cc'] = 'نسخة الإشعار';
$string['privacy:metadata:local_intelliboard_ntf:email'] = 'البريد الإلكتروني للإشعار';
$string['privacy:metadata:local_intelliboard_ntf:externalid'] = 'المعرف الخارجي للإشعار';
$string['privacy:metadata:local_intelliboard_ntf:id'] = 'معلرف الإشعار';
$string['privacy:metadata:local_intelliboard_ntf:message'] = 'رسالة الإشعار';
$string['privacy:metadata:local_intelliboard_ntf:state'] = 'حالة الإشعار';
$string['privacy:metadata:local_intelliboard_ntf:subject'] = 'موضوع الإشعار';
$string['privacy:metadata:local_intelliboard_ntf:tags'] = 'وسوم الإشعار';
$string['privacy:metadata:local_intelliboard_ntf:type'] = 'نوع الإشعار';
$string['privacy:metadata:local_intelliboard_ntf:userid'] = 'معرف التطبيق الخارجي للإشعار';
$string['privacy:metadata:local_intelliboard_ntf_hst'] = 'جدول سجل إشعارات Intelliboard';
$string['privacy:metadata:local_intelliboard_ntf_hst:email'] = 'سجل الإشعار بالبريد الإلكتروني';
$string['privacy:metadata:local_intelliboard_ntf_hst:id'] = 'معرف سجل الإشعار';
$string['privacy:metadata:local_intelliboard_ntf_hst:notificationid'] = 'معرف الإشعار';
$string['privacy:metadata:local_intelliboard_ntf_hst:notificationname'] = 'إسم الإشعار';
$string['privacy:metadata:local_intelliboard_ntf_hst:timesent'] = 'الطابع الزمني لسجل الإشعار';
$string['privacy:metadata:local_intelliboard_ntf_hst:userid'] = 'معرف التطبيق الخارجي للإشعار';
$string['privacy:metadata:local_intelliboard_ntf_pms'] = 'جدول  إشعارات Intelliboard للمعلمات الديناميكية';
$string['privacy:metadata:local_intelliboard_reports'] = 'جدول تقارير SQL المخصص لـ Intelliboard';
$string['privacy:metadata:local_intelliboard_reports:name'] = 'اسم التقرير المخصص';
$string['privacy:metadata:local_intelliboard_reports:sqlcode'] = 'ترميز Base64 كود SQL';
$string['privacy:metadata:local_intelliboard_reports:status'] = 'حالة التقرير - مفعل / غير مفعل';
$string['privacy:metadata:local_intelliboard_reports:timecreated'] = 'وقت الإنشاء';
$string['privacy:metadata:local_intelliboard_totals'] = 'Intelliboard alt/ السجلات / جدول الإجمالي';
$string['privacy:metadata:local_intelliboard_totals:courses'] = 'مجموع الحقائب التدريبية في مودل';
$string['privacy:metadata:local_intelliboard_totals:sessions'] = 'إجمالي عدد جلسات المستخدم في مودل';
$string['privacy:metadata:local_intelliboard_totals:timepoint'] = 'الطابع الزمني لليوم في السنة';
$string['privacy:metadata:local_intelliboard_totals:timespend'] = 'إجمالي الوقت الذي يقضيه المستخدمون في مودل';
$string['privacy:metadata:local_intelliboard_totals:visits'] = 'إجمالي عدد الزيارات لجميع المستخدمين في مودل';
$string['privacy:metadata:local_intelliboard_tracking'] = 'Intelliboard alt/ السجلات / الجدول لكل الأوقات';
$string['privacy:metadata:local_intelliboard_tracking:courseid'] = 'معرف الحقيبة التدريبية التي يزورها المستخدم';
$string['privacy:metadata:local_intelliboard_tracking:firstaccess'] = 'أول وصول للمستخدم';
$string['privacy:metadata:local_intelliboard_tracking:lastaccess'] = 'آخر وصول للمستخدم';
$string['privacy:metadata:local_intelliboard_tracking:page'] = 'نوع الصفحة [حقيبة تدريبية ، وحدة ، ملف شخصي ، موقع]';
$string['privacy:metadata:local_intelliboard_tracking:param'] = 'نوع مُعرَّف الصفحة';
$string['privacy:metadata:local_intelliboard_tracking:timespend'] = 'الوقت الذي قضاه المستخدمون في الصفحة';
$string['privacy:metadata:local_intelliboard_tracking:useragent'] = 'نوع متصفح المستخدمين';
$string['privacy:metadata:local_intelliboard_tracking:userid'] = 'مُعرَّف المستخدم الذي زار صفحة مودل';
$string['privacy:metadata:local_intelliboard_tracking:userip'] = 'عنوان IP الأخير للمستخدمين';
$string['privacy:metadata:local_intelliboard_tracking:userlang'] = 'لغة متصفح المستخدمين';
$string['privacy:metadata:local_intelliboard_tracking:useros'] = 'نظام تشغيل المستخدمين';
$string['privacy:metadata:local_intelliboard_tracking:visits'] = 'زيارات المستخدمين للصفحة';
$string['privacy:metadata:local_intelliboard_trns_c'] = 'نصوص سجلات الحقائب التدريبية';
$string['privacy:metadata:local_intelliboard_trns_c:completeddate'] = 'تاريخ الإكتمال';
$string['privacy:metadata:local_intelliboard_trns_c:courseid'] = 'معرف الحقيبة التدريبية';
$string['privacy:metadata:local_intelliboard_trns_c:coursename'] = 'الإسم الكامل للحقيبة التدريبية';
$string['privacy:metadata:local_intelliboard_trns_c:enroldate'] = 'تاريخ التسجيل';
$string['privacy:metadata:local_intelliboard_trns_c:enrolid'] = 'تسجيل معرف التسجيل';
$string['privacy:metadata:local_intelliboard_trns_c:enroltype'] = 'طريقة التسجيل';
$string['privacy:metadata:local_intelliboard_trns_c:finalgrade'] = 'الدرجة النهائية';
$string['privacy:metadata:local_intelliboard_trns_c:firstname'] = 'الاسم الأول للمستخدم';
$string['privacy:metadata:local_intelliboard_trns_c:formattedgrade'] = 'الدرجة المنسقة';
$string['privacy:metadata:local_intelliboard_trns_c:gradeid'] = 'معرف الدرجة';
$string['privacy:metadata:local_intelliboard_trns_c:gradeitemid'] = 'معرف عنصر الدرجة';
$string['privacy:metadata:local_intelliboard_trns_c:grademax'] = 'الدرجة العليا';
$string['privacy:metadata:local_intelliboard_trns_c:grademin'] = 'الدرجة الأدنى';
$string['privacy:metadata:local_intelliboard_trns_c:groupsids'] = 'مجموعات المستخدم';
$string['privacy:metadata:local_intelliboard_trns_c:lastname'] = 'اسم عائلة المستخدم';
$string['privacy:metadata:local_intelliboard_trns_c:rolesids'] = 'أدوار المستخدم';
$string['privacy:metadata:local_intelliboard_trns_c:status'] = 'حالة النص';
$string['privacy:metadata:local_intelliboard_trns_c:timecreated'] = 'الطابع الزمني عند إنشاء السجل';
$string['privacy:metadata:local_intelliboard_trns_c:timemodified'] = 'الطابع الزمني عندما تم تحديث السجل آخر مرة';
$string['privacy:metadata:local_intelliboard_trns_c:unenroldate'] = 'تاريخ إلغاء التسجيل';
$string['privacy:metadata:local_intelliboard_trns_c:useremail'] = 'البريد الإلكتروني للمستخدم';
$string['privacy:metadata:local_intelliboard_trns_c:userenrolid'] = 'نصوص معرّف تسجيل المستخدم';
$string['privacy:metadata:local_intelliboard_trns_c:userid'] = 'معرّف المستخدم';
$string['privacy:metadata:local_intelliboard_trns_m'] = 'نصوص سجلات الحقائب التدريبية';
$string['privacy:metadata:local_intelliboard_trns_m:cmid'] = 'معرف وحدة الحقيبة التدريبية';
$string['privacy:metadata:local_intelliboard_trns_m:completeddate'] = 'تاريخ الإكتمال';
$string['privacy:metadata:local_intelliboard_trns_m:courseid'] = 'معرف الحقيبة التدريبية';
$string['privacy:metadata:local_intelliboard_trns_m:finalgrade'] = 'الدرجة النهائية';
$string['privacy:metadata:local_intelliboard_trns_m:formattedgrade'] = 'الدرجة المنسقة';
$string['privacy:metadata:local_intelliboard_trns_m:gradeid'] = 'معرف الدرجة';
$string['privacy:metadata:local_intelliboard_trns_m:gradeitemid'] = 'معرف عنصر الدرجة';
$string['privacy:metadata:local_intelliboard_trns_m:grademax'] = 'الدرجة العليا';
$string['privacy:metadata:local_intelliboard_trns_m:grademin'] = 'الدرجة الأدنى';
$string['privacy:metadata:local_intelliboard_trns_m:moduleid'] = 'معرف الوحدة';
$string['privacy:metadata:local_intelliboard_trns_m:modulename'] = 'اسم النشاط';
$string['privacy:metadata:local_intelliboard_trns_m:moduletype'] = 'نوع الوحدة';
$string['privacy:metadata:local_intelliboard_trns_m:startdate'] = 'تاريخ البدء';
$string['privacy:metadata:local_intelliboard_trns_m:status'] = 'الحالة';
$string['privacy:metadata:local_intelliboard_trns_m:timecreated'] = 'الطابع الزمني عند إنشاء السجل';
$string['privacy:metadata:local_intelliboard_trns_m:timemodified'] = 'الطابع الزمني عندما تم تحديث السجل آخر مرة';
$string['privacy:metadata:local_intelliboard_trns_m:userenrolid'] = 'نصوص معرّف تسجيل المستخدم';
$string['privacy:metadata:local_intelliboard_trns_m:userid'] = 'معرف المستخدم';
$string['privacy_msg'] = 'من خلال تحديد هذا المربع ، فإنك تؤكد أنك قد قرأت ووافقت على سياسة الخصوصية الخاصة بنا.';
$string['privacy_policy'] = 'سياسة الخصوصية';
$string['privacy_shield_policy'] = 'ملحق معالجة البيانات';
$string['process'] = 'معالجة';
$string['product'] = 'المنتج';
$string['progress'] = 'التقدم';
$string['protocol'] = 'بروتوكول';
$string['protocol_descr'] = 'يتطلب IntelliBoard تمكين إما بروتوكول REST أو SOAP. لأغراض أمنية ، يجب تمكين البروتوكولات قيد الاستخدام فقط. للحصول على مراجعة إضافية ، انتقل إلى إدارة الموقع> الإضافات> خدمات الويب> إدارة البروتوكولات';
$string['protocols_descr'] = 'يتطلب IntelliBoard تمكين إما بروتوكول REST أو SOAP. لأغراض أمنية ، يجب تمكين البروتوكولات قيد الاستخدام فقط. للحصول على مراجعة إضافية ، انتقل إلى إدارة الموقع> الإضافات > خدمات الويب> إدارة البروتوكولات';
$string['ques_breakdown'] = 'تفصيل السؤال';
$string['quiz_finished'] = 'انتهى الإختبار';
$string['quiz_grades'] = 'تقديرات الاختبار';
$string['quiz_name'] = 'اسم الاختبار';
$string['quiz_name_a'] = 'الاختبار: {$a}';
$string['quizzes'] = 'الاختبارات';
$string['recurringperiod'] = 'فترة متكررة';
$string['registered'] = 'ملتحق';
$string['registrations'] = 'الالتحاقات';
$string['remove_message'] = 'تم حذف تقرير SQL';
$string['report'] = 'تقرير';
$string['report1_name'] = 'حالة المستخدم';
$string['report2_name'] = 'احصائيات الحقيبة التدريبية';
$string['report3_name'] = 'ملخص احصائيات النشاط';
$string['report45_name'] = 'تفاصيل نشاط الاختبار';
$string['report_activity_stats_summary'] = 'ملخص احصائيات النشاط';
$string['report_user_profile_information'] = 'معلومات الملف الشخصي للمستخدم';
$string['reports'] = 'تقارير';
$string['reportselect'] = 'الرجاء تحديد تقرير واحد على الأقل من App.IntelliBoard.net. انقر على تقرير ، ثم تقرير الإعدادات ، وحدده في "مرئي في مودل".';
$string['rest'] = 'REST';
$string['return_to_courses'] = 'العودة إلى الحقائب التدريبية';
$string['return_to_grades'] = 'عودة إلى التقديرات';
$string['return_to_home'] = 'عودة إلى الصفحة الرئيسية';
$string['return_to_sessions'] = 'عودة إلى الجلسات';
$string['review_support_doc'] = 'مراجعة وثائق الدعم';
$string['role1'] = 'الدور الأول';
$string['role2'] = 'الدور الثاني';
$string['s25'] = 'الوقت المستغرق في النشاط';
$string['s45'] = 'النشاط';
$string['s46'] = 'النسبة المئوية للطلاب الذين يحاولون';
$string['s47'] = 'موضوع';
$string['s48'] = 'الوقت المستغرق في الموضوع';
$string['save'] = 'حفظ';
$string['scale_percentage'] = 'النسبة المئوية';
$string['scale_percentage_round'] = 'جولة النسبة المئوية';
$string['scale_raw'] = 'تعطيل المقياس';
$string['scale_real'] = 'إظهار العلامة الحقيقية بدلا من النسبة';
$string['scale_total'] = 'العلامة الإجمالية';
$string['scale_value'] = 'القيمة';
$string['scales'] = 'تفعيل المقياس المخصص';
$string['scalesettings'] = 'إعدادات المقياس';
$string['score'] = 'التقدير';
$string['seatnumber'] = 'عدد المقاعد';
$string['seatscode'] = 'رمز المقاعد';
$string['seatsused'] = 'المقعد المستخدم';
$string['section'] = 'القسم';
$string['sections'] = 'الأقسام';
$string['select'] = 'تحديد';
$string['select_course'] = 'تحديد الحقيبة التدريبية';
$string['select_date'] = 'تحديد التاريخ';
$string['select_manager_role'] = 'تحديد دور المدير';
$string['select_quiz'] = 'تحديد الإختبار';
$string['select_user'] = 'تحديد المستخدم';
$string['selectall'] = 'تحديد الكل';
$string['self_hosted'] = 'الاستضافة الذاتية';
$string['server'] = 'خادم IntelliBoard';
$string['server_au'] = 'IntelliBoard أستراليا';
$string['server_error'] = 'يا للأسف! حدث شيء غير متوقع. يرجى الاتصال بنا على support@intelliboard.net';
$string['server_eu'] = 'IntelliBoard أوروبا';
$string['server_usa'] = 'IntelliBoard الولايات المتحدة الأمريكية';
$string['session_name'] = 'اسم الجلسة';
$string['session_time'] = 'وقت الجلسة';
$string['settings'] = 'الإعدادات';
$string['setup'] = 'تواصل الآن';
$string['setup_subheading'] = 'اتصل لتجربة قوة بياناتك. لا توجد بطاقة ائتمان. لا يوجد التزام. فقط 15 يومًا مجانيًا من نعيم البيانات.';
$string['shield_msg'] = 'بتحديد هذا المربع ، فأنت تؤكد أنك قد قرأت ووافقت على ملحق معالجة البيانات الخاص بنا.';
$string['show_dashboard_tab'] = 'صفحة لوحة البيانات';
$string['showing_1_to_10'] = 'عرض ١ إلى ١٠';
$string['sign_in'] = 'تسجيل الدخول';
$string['sign_up'] = 'اشتراك';
$string['sizemode'] = 'نمط الحجم: كبير ( > 5000 مستخدم)';
$string['soap'] = 'SOAP';
$string['sqlreport'] = 'تقرير SQL';
$string['sqlreportactive'] = 'مفعَّل';
$string['sqlreportcode'] = 'SQL';
$string['sqlreportcreate'] = 'إنشاء تقرير';
$string['sqlreportdate'] = 'تم إنشاؤه في';
$string['sqlreportinactive'] = 'معطَّل';
$string['sqlreportname'] = 'اسم التقرير';
$string['sqlreports'] = 'تقارير SQL';
$string['sslversion'] = 'إصدار CURLOPT SSL';
$string['sslversion_desc'] = 'قم بتمرير معلمة طويلة للتحكم في نطاق إصدار إصدارات SSL / TLS المراد استخدامها';
$string['sso'] = 'رابط الدخول الموحد';
$string['sso_desc'] = 'رابط الدخول الموحد إلى IntelliBoard.net';
$string['ssodomain'] = 'الدخول الموحد للنطاق الفرعي';
$string['ssodomain_desc'] = 'الدخول الموحد مع خادم / حساب منفصل';
$string['ssomenu'] = 'عنصر قائمة الدخول الموحد';
$string['ssomenu_desc'] = 'رابط الدخول الموحد في قائمة كتلة التنقل (لغير المتعلمين / غير المعلمين)';
$string['status'] = 'الحالة';
$string['student_course_visibility'] = 'إظهار الحقائب التدريبية المخفية / الموقوفة مؤقتا لـ [طالب]';
$string['student_grades'] = 'تقديرات الطالب';
$string['student_redirect'] = 'إعادة توجيه الطالب';
$string['subscriptiondate'] = 'تاريخ الإشتراك';
$string['success_message'] = 'تم حفظ تقرير SQL';
$string['successfull_connected'] = 'تم الاتصال بنجاح';
$string['support'] = 'دعم';
$string['support_close'] = 'إغلاق';
$string['support_connect'] = 'أنقر على أزرار التقرير داخل المستطيل أدناه. إحصل على لمحة عن قوة IntelliBoard: زر واحد للوصول إلى رؤى نظام إدارة التعلم الخاصة بك. هل تريد المزيد؟ أنقر على "أنقر لمعاينة التحليلات". هل ما زلت تريد المزيد؟ <a href="{$a->connect_link}">"الاتصال والترقية"</a> أعلى اليسار، أو في أي مكان ترى فيه الرابط.';
$string['support_demo'] = 'جدولة عرض تجريبي';
$string['support_info1'] = 'يمكنك الانضمام إلى <a target=\'_blank\' href=\'https://intelliboard.net/events\'> الندوات عبر الإنترنت </a> بينما نأخذك في جولة عبر تقارير وتحليلات IntelliBoard 5.0!';
$string['support_info2'] = 'انضم إلى <a target=\'_blank\' href=\'https://intelliboard.net/events\'> البرامج التعليمية على الويب </a> ، أو حدد موعدًا لجولة شخصية لبياناتك الخاصة. من خلال الدعم والخدمة على مستوى عالمي ، سترى نظام إدارة التعلم الخاص بك في ضوء جديد تمامًا.';
$string['support_page'] = 'مراجعة الوثائق';
$string['support_terms'] = 'كل الحقوق محفوظة.';
$string['support_text1'] = 'كل بيانات مودل الخاصة بك: سهلة، قابلة للمشاركة، مفهومة وجذابة. IntelliBoard هو ملحق لمودل يضع بين يديك أكثر من <strong>120+</strong> من التقارير وأدوات المراقبة .';
$string['support_text2'] = 'كل بيانات مودل الخاصة بك: سهلة، قابلة للمشاركة، مفهومة وجذابة. إن IntelliBoard هو حلك لإعداد التقارير والتحليلات في مودل، حيث يمنحك أكثر من 120 تقريرًا وتحليلاً للمساعدة في اتخاذ قرارات أعمالك التعليمية.';
$string['support_text3'] = 'مرحبًا بك في IntelliBoard! تستخدم المؤسسات في جميع أنحاء العالم IntelliBoard لمراقبة الاحتفاظ والتقدم والإنجاز والمشاركة. جميع بيانات LMS الخاصة بك في تقارير ورسوم بيانية سهلة الاسترداد وبديهية وقابلة للمشاركة ومفهومة وجذابة.';
$string['support_text4'] = 'يُعلم الإضافة IntelliBoard قرارات عملك التعليمية ببيانات مباشرة من LMS الخاص بك ، في الوقت الفعلي.';
$string['support_text6'] = 'بحاجة الى مزيد من المعلومات؟ انقر فوق أي من الأزرار الزرقاء للتواصل معنا.';
$string['support_trial'] = 'الاتصال والتحسين';
$string['suspended'] = 'موقوف مؤقتا';
$string['sync_data_with_attendance'] = 'مزامنة البيانات مع الحضور';
$string['synctranscriptstask'] = 'مهمة مزامنة النصوص';
$string['t01'] = 'مرشح الوقت: الأيام 30 الأخيرة';
$string['t02'] = 'مرشح الوقت: الأشهر 3 الأخيرة';
$string['t03'] = 'مرشح الوقت: الأشهر 6 الأخيرة';
$string['t04'] = 'تمكين [رأس] الحقائب التدريبية المكتملة';
$string['t05'] = 'تمكين [رأس] الحقائب التدريبية قيد التنفيذ';
$string['t06'] = 'تمكين [رأس] متوسط علامة الحقائب التدريبية';
$string['t07'] = 'تمكين [رأس] الرسائل';
$string['t08'] = 'تمكين مجموع علامة  الحقائب التدريبية [رأس].';
$string['t09'] = 'يمكن للمعلم رؤية طلابه';
$string['t1'] = 'تفعيل لوحة بيانات المتعلم';
$string['t10'] = 'تمكين عنصر الواجهة [الاختبارات]';
$string['t11'] = 'تمكين عنصر الواجهة  [تقدم الحقيبة التدريبية]';
$string['t12'] = 'تمكين  عنصر الواجهة [المشاركة في النشاط]';
$string['t13'] = 'تمكين  عنصر الواجهة  [التعلم]';
$string['t14'] = 'تمكين عنصر الواجهة [نجاح الحقيبة التدريبية]';
$string['t15'] = 'تمكين عنصر الواجهة [الارتباطات]';
$string['t16'] = 'تمكين حقيبة تدريبية المعلم';
$string['t17'] = 'تمكين فئة الحقيبة تدريبية';
$string['t18'] = 'تمكين إكمال الحقيبة التدريبية';
$string['t19'] = 'تمكين علامة الحقيبة التدريبية';
$string['t2'] = 'تمكين لوحة البيانات';
$string['t20'] = 'تمكين معدل الحقيبة التدريبية للصف';
$string['t21'] = 'تمكين الوقت المقضي في الحقيبة التدريبية';
$string['t22'] = 'تمكين تاريخ بدء الحقيبة التدريبية';
$string['t23'] = 'تمكين العمود [تاريخ بدء الحقيبة التدريبية]';
$string['t24'] = 'تمكين عمود [تاريخ التسجيل]';
$string['t25'] = 'تمكين عمود [التقدم]';
$string['t26'] = 'تمكين عمود [الرسالة]';
$string['t27'] = 'تمكين عمود [الأنشطة المكتملة]';
$string['t28'] = 'تمكين عمود [الدرجة]';
$string['t29'] = 'تمكين عمود [حالة إكمال الحقيبة التدريبية]';
$string['t3'] = 'تمكين الحقائب التدريبية';
$string['t30'] = 'تمكين عمود [تقديرات النشاط]';
$string['t31'] = 'تمكين عمود عنصر الواجهة[الواجبات] [الدرجة ]';
$string['t32'] = 'تمكين عمود عنصر الواجهة [الواجبات][تاريخ تسليم]';
$string['t33'] = 'تمكين عمود عنصر الواجهة [الاختبارات] [الدرجة]';
$string['t34'] = 'تمكين عمود  عنصر الواجهة [الاختبارات] [تاريخ التسليم]';
$string['t35'] = 'تمكين عمود عنصر الواجهة [تقدم الحقيبة التدريبية][التقدم]';
$string['t36'] = 'تمكين عمود عنصر الواجهة [تقدم الحقيبة التدريبية] [الدرجة]';
$string['t37'] = 'تمكين عمود عنصر الواجهة [تقدم الحقيبة التدريبية] [مسجل]';
$string['t38'] = 'تمكين عمود عنصر الواجهة [تقدم الحقيبة التدريبية] [مكتمل]';
$string['t39'] = 'تمكين الخيار[التقدم] [الدرجة الهدف]';
$string['t4'] = 'تمكين التقديرات';
$string['t40'] = 'تمكين خيار [التقدم] [متوسط الصف]';
$string['t41'] = 'تمكين [رأس تقديرات النشاط] إكتمل في';
$string['t42'] = 'تمكين [رأس تقديرات النشاط] آخر وصول إلى المساق';
$string['t43'] = 'تمكين عمود النوع [تقديرات النشاط]';
$string['t44'] = 'تمكين عمود التقدير [تقديرات النشاط]';
$string['t45'] = 'تمكين عمود ما تم تقييمه [تقديرات النشاط]';
$string['t46'] = 'تمكين عمود المكتمل [تقديرات النشاط]';
$string['t47'] = 'لون خلفية [شبكة] الحقائب التدريبية';
$string['t48'] = 'تمكين التقارير';
$string['t49'] = 'أعمدة مرشح التقرير';
$string['t5'] = 'تمكين الرسم البياني[تقدم النشاط]';
$string['t50'] = 'أدوار المعلم';
$string['t51'] = 'ادوار الطالب';
$string['t52'] = 'تمكين صفوف عنصر الواجهة [تقدم الحقيبة التدريبية] [الفئة]';
$string['t53'] = 'تفعيل على خط متوسط الرسم البياني [تقدم النشاط]';
$string['t54'] = 'تمكين عمود الوقت المنقضي [تقديرات النشاط]';
$string['t6'] = 'تمكين الرسم البياني [تقدم الحقيبة التدريبية]';
$string['t7'] = 'تمكين [متوسط الحقيبة التدريبية]';
$string['t8'] = 'تمكين [المعدل العام للحقيبة التدريبية]';
$string['t9'] = 'تمكين عنصر الواجهة [الواجبات]';
$string['table_set_iag'] = 'مساق المعلم  > النشاطات';
$string['table_set_iag1'] = 'مساقات المرشد > النشاطات > التقديرات';
$string['table_set_iag1_c1'] = 'اسم المتعلم';
$string['table_set_iag1_c2'] = 'عنوان البريد الإلكتروني';
$string['table_set_iag1_c3'] = 'الحالة';
$string['table_set_iag1_c4'] = 'الدرجة';
$string['table_set_iag1_c5'] = 'مصحح';
$string['table_set_iag1_c6'] = 'الزيارات';
$string['table_set_iag1_c7'] = 'الوقت المقضي';
$string['table_set_iag_c1'] = 'اسم النشاط';
$string['table_set_iag_c2'] = 'النوع';
$string['table_set_iag_c3'] = 'المتعلمين المكملين';
$string['table_set_iag_c4'] = 'علامة متوسطه';
$string['table_set_iag_c5'] = 'الزيارات';
$string['table_set_iag_c6'] = 'الوقت المقضي';
$string['table_set_iag_c7'] = 'الإجراءات';
$string['table_set_icg'] = 'مساقات المعلم';
$string['table_set_icg_c1'] = 'اسم الحقيبة التدريبية';
$string['table_set_icg_c11'] = 'الإجراءات-الأنشطة';
$string['table_set_icg_c12'] = 'الإجراءات- المتعلمين';
$string['table_set_icg_c2'] = 'اسم مختصر';
$string['table_set_icg_c3'] = 'فئة';
$string['table_set_icg_c4'] = 'المتعلمون المسجلون / المكتملون';
$string['table_set_icg_c5'] = 'متوسط علامة الحقيبة التدريبية';
$string['table_set_icg_c6'] = 'الأقسام';
$string['table_set_icg_c7'] = 'الأنشطة/الموارد';
$string['table_set_icg_c8'] = 'الزيارات';
$string['table_set_icg_c9'] = 'الوقت المقضي';
$string['table_set_ilg'] = 'مساقات المعلم > المتعلمون';
$string['table_set_ilg1'] = 'مساقات المرشد > المتعلمون > التقديرات';
$string['table_set_ilg1_c1'] = 'اسم النشاط';
$string['table_set_ilg1_c2'] = 'النوع';
$string['table_set_ilg1_c3'] = 'الدرجة';
$string['table_set_ilg1_c4'] = 'مصحح';
$string['table_set_ilg1_c5'] = 'الحالة';
$string['table_set_ilg1_c6'] = 'الزيارات';
$string['table_set_ilg1_c7'] = 'الوقت المقضي';
$string['table_set_ilg_c1'] = 'اسم المتعلم';
$string['table_set_ilg_c10'] = 'الإجراءات';
$string['table_set_ilg_c2'] = 'عنوان البريد الإلكتروني';
$string['table_set_ilg_c3'] = 'مسجل';
$string['table_set_ilg_c4'] = 'آخر وصول';
$string['table_set_ilg_c5'] = 'الحالة';
$string['table_set_ilg_c6'] = 'الدرجة';
$string['table_set_ilg_c7'] = 'الأنشطة/ الموارد المكتملة';
$string['table_set_ilg_c8'] = 'الزيارات';
$string['table_set_ilg_c9'] = 'الوقت المقضي';
$string['te1'] = 'البريد الإلكتروني';
$string['te12'] = 'الاسم الأول';
$string['te13'] = 'اسم العائلة';
$string['te1_desc'] = 'أدخل البريد الالكتروني المستعمل مع اشتراك IntelliBoard.net. إذا لم يكن لديك اشتراك نشط، فالرجاء التسجيل في <a target="_blank" href="https://intelliboard.net">IntelliBoard.net</a>. تتوفر دفة قيادة المتعلم والمعلم مع اشتراك من المستوى 4 وما فوق.';
$string['teacher'] = 'المعلم';
$string['telephone1'] = 'الهاتف 1';
$string['telephone2'] = 'الهاتف 2';
$string['term_of_use'] = 'شروط الاستخدام';
$string['terms_msg'] = 'من خلال تحديد هذا المربع ، فإنك تؤكد أنك قد قرأت ووافقت على شروط الاستخدام الخاصة بنا.';
$string['tex1'] = 'لم يتم تمكين لوحة بيانات متعلم IntelliBoard';
$string['this_year'] = 'العام الحالي';
$string['time'] = 'الوقت';
$string['time_1'] = 'صباحا';
$string['time_2'] = 'بعد الظهيرة';
$string['time_3'] = 'مساءا';
$string['time_4'] = 'ساعات الفراغ';
$string['time_period_due'] = 'فترة زمنية( تاريخ التسليم)';
$string['time_spent'] = 'الوقت المقضي';
$string['timespent'] = '------ الوقت المقضي----';
$string['tls12'] = 'TLS v1.2';
$string['tls12_desc'] = 'إعدادات متقدمة :TLS v1.2';
$string['topics'] = 'المواضيع';
$string['total'] = 'إجمالي';
$string['total_activities_resources'] = 'إجمالي الأنشطة / الموارد';
$string['total_numbers'] = 'التاريخ: {$ a-> timepoint} ، الجلسات: {$ a-> Session} ، الزيارات: {$ a-> visit} ، الوقت المنقضي: {$ a-> timespend}';
$string['total_numbers2'] = 'المستخدم: {$a->userid}، الصفحة: {$a->page}، المعامل:{$a->param}، الزيارات: {$a->visits}، الوقت المنقضي: {$a->timespend}';
$string['total_numbers3'] = '---- التاريخ: {$ a-> timecreated} ، معرف المتعقب: {$ a-> trackid} ، الزيارات: {$ a-> visit} ، الوقت المنقضي: {$ a-> timespend}';
$string['total_time_spent'] = 'إجمالي الوقت المنقضي';
$string['total_time_spent_enrolled_learners'] = 'إجمالي الوقت الذي يقضيه المتعلمون المسجلون في الحقيبة التدريبية';
$string['total_values_include'] = 'القيَم الإجمالية تتضمن الجلسات الفريدة، الحقائب التدريبية، الزيارات، الوقت المنقضي.';
$string['total_visits_enrolled_learners'] = 'إجمالي عدد الزيارات من قبل المتعلمين المسجلين في الحقيبة التدريبية';
$string['totara'] = 'Totara';
$string['trackadmin'] = 'تتبع مسؤولي الموقع';
$string['trackadmin_desc'] = 'تمكين تتبع الوقت للمستخدمين الإداريين (غير موصى به)';
$string['trackdetails'] = 'تتبع الوقت حسب المستخدم - كل ساعة';
$string['tracking'] = 'تتبع الجلسة';
$string['tracking_title'] = 'تتبع الوقت';
$string['tracklogs'] = 'تتبع الوقت حسب المستخدم - يوميا';
$string['trackmedia'] = 'تتبع وسائط HTML5';
$string['trackmedia_desc'] = 'تتبع فيديو وصوت HTML5';
$string['tracktotals'] = 'إجمالي تتبع الوقت - يوميًا';
$string['transcripts'] = 'النصوص';
$string['transcriptssyncrecordsnum'] = 'حجم معالجة النصوص';
$string['transcriptssyncrecordsnum_desc'] = 'عدد سجلات تسجيل المستخدمين التي ستتم معالجتها مرة واحدة';
$string['ts1'] = 'لوحة بيانات المتعلم';
$string['ts2'] = 'صفحة  لوحة بيانات المتعلم';
$string['ts3'] = 'لوحة بيانات الحقائب التدريبية للمتعلم';
$string['ts4'] = 'لوحة بيانات تقديرات المتعلم';
$string['ts5'] = 'لوحة بيانات تقارير المتعلم';
$string['type'] = 'نوع';
$string['type_here'] = 'اكتب هنا...';
$string['used'] = 'مستخدم';
$string['user_enrollments_sessions_completion'] = 'تسجيل المستخدم ، الجلسة ، مستويات إكمال النشاط';
$string['user_enrolments'] = 'تسجيلات المستخدم';
$string['user_grade_avg'] = '{$ a-> user} الدرجة : {$ a-> grade} ، متوسط الدرجة : {$ a-> avg_grade site})';
$string['user_map'] = 'خريطة المستخدم';
$string['user_site_summary_detail'] = 'تفصيل ملخص موقع المستخدم';
$string['user_time_avg'] = '{$ a-> user} الوقت: {$ a-> timespend} ، متوسط الوقت : {$ a-> avg_timespend_site}';
$string['user_visit_avg'] = 'زيارات {$ a-> user}: {$ a-> calling}، متوسط الزيارات: {$ a-> avg_visits_site}';
$string['username'] = 'اسم المستخدم';
$string['users'] = 'المستخدمين';
$string['users_activity'] = 'نشاط المستخدمين';
$string['users_overview'] = 'نظرة عامة على المستخدمين';
$string['verifyhost'] = 'CURLOPT SSL VERIFYHOST';
$string['verifyhost_desc'] = 'يحدد هذا الخيار ما إذا كان libcurl يتحقق من أن شهادة الخادم للخادم المعروف بها.';
$string['verifypeer'] = 'CURLOPT SSL VERIFYPEER';
$string['verifypeer_desc'] = 'يحدد هذا الخيار ما إذا كان curl يتحقق من صحة شهادة النظير.';
$string['view_course_details'] = 'عرض تفاصيل الخقيبة التدريبية';
$string['viewed'] = 'شوهد';
$string['visits'] = 'الزيارات';
$string['web_services_descr'] = 'يتطلب IntelliBoard تمكين خدمات الويب. تمكّن خدمات الويب الأنظمة الأخرى (مثل IntelliBoard) من الوصول إلى نظام إدارة التعلم هذا وإجراء عمليات التشغيل. لأغراض أمنية ، يجب تعطيل هذا عندما لا يكون قيد الاستخدام. للحصول على مراجعة إضافية ، انتقل إلى إدارة الموقع> الميزات المتقدمة> خدمات الويب';
$string['weekday_0'] = 'الإثنين';
$string['weekday_1'] = 'الثلاثاء';
$string['weekday_2'] = 'الأربعاء';
$string['weekday_3'] = 'الخميس';
$string['weekday_4'] = 'الجمعة';
$string['weekday_5'] = 'السبت';
$string['weekday_6'] = 'الأحد';
$string['weekly'] = 'الأيام 90 الأخيرة';
$string['widget_name27'] = 'الاشتراكات التراكمية';
$string['widget_name28'] = 'المشاركة';
$string['widget_name29'] = 'تسجيلات دخول فريدة';
$string['widget_name30'] = 'التسجيلات حسب الحقيبة التدريبية';
$string['widget_name31'] = 'استيعاب المسجلين و المشرف';
$string['x_completions'] = 'الإكتمالات {$a}';
$string['you_have_certificates'] = 'لديك {$a} من الشهادات';
$string['you_need_to_enable_at_least_one_protocol'] = 'تحتاج إلى تمكين بروتوكول واحد على الأقل';
