<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'hotquestion', language 'ar', version '5.1'.
 *
 * @package     hotquestion
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['ago'] = 'قبل {$a}';
$string['allowanonymouspost'] = 'السماح بطرح السؤال بصفة مجهول الهوية';
$string['allowanonymouspost_descr'] = 'عند تمكينه، يمكن طرح الأسئلة بدون الكشف عن هوية أصحابها، وعند الموافقة على معاينتها، التصويتات الحارة يمكن تقديمها من قبل أي شخص.';
$string['allowanonymouspost_help'] = 'عند تمكينه، يمكن طرح الأسئلة بدون الكشف عن هوية أصحابها، وعند الموافقة على معاينتها، التصويتات الحارة يمكن تقديمها من قبل أي شخص.';
$string['allowauthorinfohide'] = 'السماح بإخفاء أسماء المؤلفين';
$string['allowauthorinfohide_descr'] = 'عند تمكينه، اسم كاتب الأسئلة يمكن أن يكون مرئيًا للمعلمين لكن مخفيًا عن الطلاب.';
$string['allowauthorinfohide_help'] = 'عند تمكينه، اسم كاتب الأسئلة يمكن أن يكون مرئيًا للمعلمين لكن مخفيًا عن الطلاب.';
$string['allowcomments'] = 'السماح بالتعليقات في المُدخلات';
$string['allowcomments_help'] = 'عند تمكينه، كل المستخدمين الذين لديهم صلاحية إنشاء التعليقات سيتمكنون من إضافة تعليقاتهم إلى مُدخلات الأسئلة الساخنة.';
$string['alwaysshowdescription'] = 'إظهار الوصف دائمًا';
$string['alwaysshowdescription_help'] = 'عند تعطيله، وصف السؤال الساخن لن يكون مرئيًا للطلاب.';
$string['anonymous'] = 'غير مشخصن';
$string['approvallabel'] = 'عبارة ملصق عمود الموافقة مطلوبة';
$string['approvallabel_descr'] = 'أدخل العبارة الافتراضية لملصق عمود الموافقة مطلوبة';
$string['approvedno'] = 'غير موافق عليه';
$string['approvedyes'] = 'موافق عليه';
$string['authorinfo'] = 'منشور من قبل {$a->user} في {$a->time}';
$string['authorinfohide'] = 'منشور {$a->time}';
$string['calendarend'] = '{$a} يُغلق';
$string['calendarstart'] = '{$a} يُفتح';
$string['cnfallowcomments'] = 'حدد ما إذا كان السؤال الساخن سيقبل التعليقات على المُدخلات إفتراضيًا';
$string['completiondetail:pass'] = 'درجة النجاح: {$a}';
$string['completiondetail:post'] = 'طرح الأسئلة: {$a}';
$string['completiondetail:vote'] = 'يمنح حرارة: {$a}';
$string['completionpass'] = 'على الطالب أن ينجح';
$string['completionpassdesc'] = 'ينبغي أن يتلقى الطالب درجة النجاح البالغة {$a}';
$string['completionpassgroup'] = 'يتطلب النجاح:';
$string['completionpost'] = 'ينبغي على الطالب إضافة أسئلة:';
$string['completionpostdesc'] = 'على الطالب إنشاء ما لا يقل عن {$a} من الأسئلة';
$string['completionpostgroup'] = 'يتطلب أسئلة';
$string['completionvote'] = 'ينبغي على الطالب إضافة حرارة:';
$string['completionvotedesc'] = 'على الطالب أن يمنح/يصوت حرارة إلى ما لا يقل عن {$a} من المنشورات';
$string['completionvotegroup'] = 'يتطلب حرارة';
$string['connectionerror'] = 'خطأ في الاتصال';
$string['content'] = 'المحتوى';
$string['crontask'] = 'المعالجة في الخلفية لوحدة السؤال الساخن';
$string['csvexport'] = 'التصدير بصيغة csv';
$string['deleteentryconfirm'] = 'تأكيد رغبتك في حذف المُدخل';
$string['deleteroundconfirm'] = 'تأكيد رغبتك في حذف الجولة';
$string['description'] = 'الوصف';
$string['displayasanonymous'] = 'إعرضه بمثابة مجهول';
$string['entries'] = 'المُدخلات';
$string['eventaddquestion'] = 'سؤال أضافه';
$string['eventaddround'] = 'جولة جديدة تم افتتاحها';
$string['eventdownloadquestions'] = 'أسئلة تم تنزيلها';
$string['evententriesviewed'] = 'الأسئلة المعاينة';
$string['evententryupdated'] = 'الأسئلة المحدثة';
$string['eventremovequestion'] = 'سؤال تمت إزالته';
$string['eventremoveround'] = 'جولة تمت إزالتها';
$string['eventremovevote'] = 'تصويت تمت إزالته';
$string['eventupdatevote'] = 'تصويت تم تحديثه';
$string['exportfilename'] = 'الأسئلة.csv';
$string['exportfilenamep1'] = 'كل_الموقع_';
$string['exportfilenamep2'] = 'الأسئلة_الساخنة_المصدرة_في_';
$string['factorheat'] = 'عامل الحرارة المتلقاة';
$string['factorheat_help'] = 'العامل المطبق على الأسئلة لتحديد درجة التقييم بناءً على سخونة السؤال.
كلما زادت سخونة السؤال، زادت أهمية التقييم.
يُحتسب سؤال الطالب بنقطة واحدة بالإضافة إلى رصيد إضافي.

النقاط = (عدد الأصوات) × معامل/١٠٠.

عادةً ما يكون معامل السخونة ٥٪ كافيًا، أي أنه إذا صوّت ٢٠ شخصًا على سؤال، تُضاعف قيمته.
قد تحتاج إلى تعديله حسب عدد المشاركين وتفاعلهم.';
$string['factorpriority'] = 'عامل أولوية المعلم';
$string['factorpriority_help'] = 'عامل لحساب الأسئلة التي لا تُحدد أولوية المعلم.
يُحتسب كل سؤال ضمن مجموع أسئلة الطالب كقيمة أولوية (1، 2 ...).

للأسئلة التي لا تُحدد أولوية (0)، تُحتسب القيمة المحددة (كنسبة مئوية).

يعني عامل 100% أن السؤال غير ذي الأولوية يُحتسب تمامًا كالسؤال ذي الأولوية 1.';
$string['factorvote'] = 'عامل الحرارة المعطاة';
$string['factorvote_help'] = 'عامل يُطبّق على عدد أصوات الطلاب عند حساب الدرجات.

بالإضافة إلى كتابة أسئلة جديدة، يمكن للطالب الحصول على رصيد مشاركة بالتصويت على أسئلة طلاب آخرين.

هذا الرصيد هو عدد الأصوات الصادرة مضروبًا في هذا العامل / ١٠٠.

الرصيد = الأصوات × العامل / ١٠٠

يجب تعديل هذا العامل بناءً على إجمالي الأصوات التي يمكن للطالب إصدارها والوزن المطلوب لهذا النوع من المشاركة.

على سبيل المثال، إذا كان بإمكان الطالب إصدار ٥ أصوات كحرارة، فإن عامل ٢٠٪ يعني أن التصويت على ٥ أسئلة أخرى يُحتسب كسؤال واحد كتبه هذا الطالب. أما عامل ١٠٠٪ فيعني أن التصويت على أسئلة أخرى يُحتسب بنفس قيمة كتابة سؤال جديد.';
$string['finalgrade'] = 'الدرجة النهائية';
$string['for'] = 'للموقع:';
$string['grading'] = 'الدرجة الخام';
$string['heat'] = 'الحرارة';
$string['heaterror'] = 'عدد كبير من الأصوات';
$string['heatgiven'] = 'الحرارة المعطاة';
$string['heatlabel'] = 'عبارة ملصق عمود الحرارة';
$string['heatlabel_descr'] = 'أدخل العبارة الافتراضية لملصق عمود الحرارة';
$string['heatlimit'] = 'الحد الافتراضي للحرارة';
$string['heatlimit_descr'] = 'أدخل العدد الافتراضي للمرات التي يمكن للمستخدمين أن يمنحوا الحرارة/التصويت لكل جولة. صفر يؤدي إلى إخفاء عمود الحرارة.';
$string['heatlimit_help'] = 'أدخل العدد الافتراضي للمرات التي يمكنك أن تمنح الحرارة/التصويت لكل جولة. صفر يؤدي إلى إخفاء عمود الحرارة.';
$string['heatreceived'] = 'الحرارة المتلقاة';
$string['heatvisibility'] = 'حالة إظهار عمود الحرارة';
$string['heatvisibility_descr'] = 'عند تمكينه، يكون عمود الحرارة مرئيًا، بخلاف ذلك يكون مخفيًا.';
$string['heatvisibility_help'] = 'عند تمكينه، يكون عمود الحرارة مرئيًا.';
$string['hotquestion'] = 'السؤال الساخن';
$string['hotquestion:addinstance'] = 'إضافة سؤال ساخن جديد';
$string['hotquestion:ask'] = 'إطرح الأسئلة';
$string['hotquestion:comment'] = 'كتابة التعليقات';
$string['hotquestion:manage'] = 'إدارة الأسئلة';
$string['hotquestion:manageentries'] = 'معاينة قائمة بالنشاطات';
$string['hotquestion:rate'] = 'تقييم الأسئلة';
$string['hotquestion:view'] = 'معاينة الأسئلة';
$string['hotquestion:vote'] = 'التصويت على الأسئلة';
$string['hotquestionclosed'] = 'هذا النشاط أُغلق في {$a}.';
$string['hotquestionclosetime'] = 'وقت الإغلاق';
$string['hotquestionintro'] = 'الموضوع';
$string['hotquestionname'] = 'اسم النشاط';
$string['hotquestionopen'] = 'هذا النشاط سيُفتح في {$a}.';
$string['hotquestionopentime'] = 'وقت الفتح';
$string['id'] = 'المُعرَّف';
$string['improperuseviewgradesclass'] = 'استعمال خاطئ لفئة معاينة التقديرات. يتعذر تحميل عنصر التقييم.';
$string['incorrectmodule'] = 'مُعرَّف وحدة المساق لم يكن صحيحًا';
$string['inputapprovallabel'] = 'موافق عليه';
$string['inputapprovallabel_descr'] = 'غيِّر اسم عمود الموافق عليه إلى ما تريده أن يكون.';
$string['inputapprovallabel_help'] = 'غيِّر اسم عمود الموافق عليه ليوائم الغرض من استعمال هذا النشاط.';
$string['inputheatlabel'] = 'الحرارة';
$string['inputheatlabel_descr'] = 'غيِّر اسم عمود الحرارة إلى ما تريده أن يكون.';
$string['inputheatlabel_help'] = 'غيِّر اسم عمود الحرارة ليوائم الغرض من استعمال هذا النشاط.';
$string['inputquestion'] = 'قم بتسليم سؤالك هنا:';
$string['inputquestion_descr'] = 'غيِّر توجيهات التسليم إلى ما تريده أن تكون عليه.';
$string['inputquestion_help'] = 'غيِّر توجيهات التسليم إلى ما تريده أن تكون عليه.';
$string['inputquestionlabel'] = 'الأسئلة';
$string['inputquestionlabel_descr'] = 'قم بتغيير تسمية عمود الأسئلة إلى ما تريده.';
$string['inputquestionlabel_help'] = 'غيِّر تسمية عمود الأسئلة لتلائم بشكل أفضل الغاية من استعمال هذا النشاط.';
$string['inputremovelabel'] = 'إزالة';
$string['inputremovelabel_descr'] = 'غيِّر تسمية إزالة العمود إلى ما تريده أن تكون عليه.';
$string['inputremovelabel_help'] = 'غيِّر تسمية إزالة العمود لتلائم بشكل أفضل الغاية من استعمال هذا النشاط.';
$string['inputteacherprioritylabel'] = 'الأولوية';
$string['inputteacherprioritylabel_descr'] = 'غيِّر تسمية عمود ألأولوية إلى ما تريده أن تكون عليه.';
$string['inputteacherprioritylabel_help'] = 'غيِّر تسمية عمود الأولوية لتلائم بشكل أفضل الغاية من استعمال هذا النشاط.';
$string['invalidquestion'] = 'الأسئلة الفارغة يتم تجاهلها.';
$string['modulename'] = 'السؤال الساخن';
$string['modulename_help'] = 'نشاط السؤال الساخن يسمح للطلاب بطرح المنشورات والتصويت عليها، من خلال الاستجابة للأسئلة المقدمة من قبل معلمي المساق.';
$string['modulename_link'] = 'mod/hotquestion/view';
$string['modulenameplural'] = 'الأسئلة الساخنة';
$string['newround'] = 'فتح جولة جديدة';
$string['newroundconfirm'] = 'أتريد تأكيد رغبتك في بدء جولة جديدة؟ (ستتم أرشفة الأسئلة والتصويتات الحالية ولن تتمكن من الإضافة إليها!)';
$string['newroundsuccess'] = 'لقد فتحت بنجاح جولة جديدة.';
$string['nextround'] = 'الجولة التالية';
$string['noquestions'] = 'لا مُدخلات بعد.';
$string['notapproved'] = '<b>هذا المُدخل غير موافق عليه بعد لمعاينته.<br></b>';
$string['notavailable'] = '<b>غير متاح حاليًا!<br></b>';
$string['pluginadministration'] = 'إدارة السؤال الساخن';
$string['pluginname'] = 'السؤال الساخن';
$string['postbutton'] = 'أنقر للنشر';
$string['postmaxgrade'] = 'الأسئلة للتقييم الأعلى';
$string['postmaxgrade_help'] = 'عدد الأسئلة المطلوبة للحصول على أعلى درجة.

هذا عددٌ نظريٌّ للأسئلة، ولكن يمكن تحسين الدرجة التي يحصل عليها المستخدم من خلال عامل الحرارة (الأسئلة ذات الحرارة الأعلى تُحتسب أكبر) والتصويت على أسئلة أخرى (يمكن للمستخدم تحسين الدرجة من خلال المشاركة في التصويت على أسئلة الطلاب الآخرين).';
$string['previousround'] = 'الجولة السابقة';
$string['privacy:metadata:hotquestion_grades'] = 'بيانات التقييم لعيِّنات السؤال الساخن';
$string['privacy:metadata:hotquestion_grades:rawrating'] = 'التقييم الخام';
$string['privacy:metadata:hotquestion_grades:userid'] = 'مُعرَّف المستخدم الذي نشر هذا التقدير';
$string['privacy:metadata:hotquestion_questions'] = 'معلومات عن مُدخلات المستخدم لنشاط سؤال ساخن معين';
$string['privacy:metadata:hotquestion_questions:anonymous'] = 'هل هذا المُدخل منشور بشكل غير مشخصن؟';
$string['privacy:metadata:hotquestion_questions:approved'] = 'هل السؤال مصرح بعرضه على العامة؟';
$string['privacy:metadata:hotquestion_questions:content'] = 'محتوى السؤال';
$string['privacy:metadata:hotquestion_questions:hotquestion'] = 'مُعرَّف نشاط السؤال الساخن الذي تم فيه نشر المحتوى';
$string['privacy:metadata:hotquestion_questions:id'] = 'مُعرَّف الإدخال';
$string['privacy:metadata:hotquestion_questions:time'] = 'وقت طرح السؤال';
$string['privacy:metadata:hotquestion_questions:tpriority'] = 'هل أعطى المعلم الأولوية لهذا المُدخل؟';
$string['privacy:metadata:hotquestion_questions:userid'] = 'مُعرَّف المستخدم الذي نشر هذا المُدخل';
$string['privacy:metadata:hotquestion_votes'] = 'معلومات عن التصويتات على الأسئلة';
$string['privacy:metadata:hotquestion_votes:id'] = 'مُعرَّف الإدخال';
$string['privacy:metadata:hotquestion_votes:question'] = 'مُعرَّف الإدخال لهذا التصويت';
$string['privacy:metadata:hotquestion_votes:voter'] = 'مُعرَّف المستخدم الذي قام بالتصويت';
$string['question'] = 'السؤال';
$string['questionlabel'] = 'عنوان عمود الأسئلة';
$string['questionlabel_descr'] = 'أدخل العنوان الافتراضي لعمود الأسئلة.';
$string['questionremove'] = 'إزالة';
$string['questionremovesuccess'] = 'لقد أزلت ذلك السؤال بنجاح.';
$string['questions'] = 'الأسئلة';
$string['questionsubmitted'] = 'تم تسليم منشورك بنجاح.';
$string['rawgrade'] = 'الدرجة الخام {$a->rawgrade} / {$a->max}';
$string['removedround'] = 'لقد أزلت هذه الجولة بنجاح.';
$string['removelabel'] = 'إزالة ملصق العمود';
$string['removelabel_descr'] = 'أدخل عبارة الملصق الافتراضية لإزالة العمود';
$string['removeround'] = 'إزالة هذه الجولة';
$string['removevote'] = 'إزالة تصويتي';
$string['requireapproval'] = 'الموافقة مطلوبة';
$string['requireapproval_descr'] = 'عند تمكينه، تتطلب الأسئلة موافقة المعلم قبل أن تكون قابلة للمعاينة من قبل الآخرين.';
$string['requireapproval_help'] = 'عند تمكينه، تتطلب الأسئلة موافقة المعلم قبل أن تكون قابلة للمعاينة من قبل الآخرين.';
$string['resethotquestion'] = 'حذف كل الأسئلة والتصويتات';
$string['returnto'] = 'عودة إلى {$a}';
$string['round'] = 'الجولة {$a}';
$string['showrecentactivity'] = 'إظهار النشاط الأخير';
$string['showrecentactivityconfig'] = 'الكل يمكنهم مشاهدة الإشعارات في تقارير النشاطات الأخيرة.';
$string['teacherpriority'] = 'الأولوية';
$string['teacherprioritylabel'] = 'ملصق عمود الأولوية';
$string['teacherprioritylabel_descr'] = 'أدخل عبارة الملصق الافتراضية لعمود الأولوية.';
$string['teacherpriorityvisibility'] = 'رؤية عمود أولوية المعلم';
$string['teacherpriorityvisibility_descr'] = 'عند تمكينه، يكون عمود أولوية المعلم مرئيًا، بخلاف ذلك يكون مخفيًا.';
$string['teacherpriorityvisibility_help'] = 'عند تمكينه، يكون عمود أولوية المعلم مرئيًا،';
$string['time'] = 'الوقت';
$string['totalcomments'] = 'إجمالي التعليقات';
$string['unapprovedquestionhide'] = 'إخفاء الأسئلة غير الموافق عليها';
$string['unapprovedquestionnotset'] = 'التفضيل غير مهيأ';
$string['unapprovedquestionsee'] = 'مشاهدة الأسئلة غير الموافق عليها';
$string['unapprovedquestionvisibility'] = 'رؤية الأسئلة غير الموافق عليها';
$string['userid'] = 'مُعرَّف المستخدم';
$string['valueinterror'] = 'العامل ينبغي أن يكون رقمًا صحيحًا موجبًا';
$string['viewaftertimeclose'] = 'المعاينة بعد وقت الإغلاق';
$string['viewaftertimeclose_descr'] = 'عند تمكينه، سيتمكن الطلاب من معاينة، بدون القدرة على تعديل، الأسئلة والحرارة بعد وقت الإغلاق، بخلاف ذلك، ستكون مخفية.';
$string['viewaftertimeclose_help'] = 'عند تمكينه، سيتمكن الطلاب من معاينة، بدون القدرة على تعديل، الأسئلة والحرارة بعد وقت الإغلاق، بخلاف ذلك، ستكون مخفية.';
$string['viewaftertimeclosevalidation'] = 'إذا لم يتم وضع تاريخ الإغلاق، فإن المعاينة بعد وقت الإغلاق ينبغي وضعه على، لا.';
$string['viewallentries'] = '{$a->ucount} من المستخدمين نشروا {$a->qcount} من الأسئلة.';
$string['viewallhotquestions'] = 'معاينة الأسئلة الساخنة لكل المساقات';
$string['viewentries'] = 'المشاركة في الجولة الحالية';
$string['viewgrades'] = 'معاينة التقديرات';
$string['vote'] = 'تصويت';
$string['xofn'] = 'من';
