<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'badges', language 'et', version '5.1'.
 *
 * @package     badges
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actions'] = 'Toimingud';
$string['activate'] = 'Luba juurdepääs';
$string['activatesuccess'] = 'Juurdepääs õpimärkidele on lubatud.';
$string['addalignment'] = 'Lisa väline oskus või standard';
$string['addbadge'] = 'Lisage märgid';
$string['addbadge_help'] = 'Valige kõik märgid, mis tuleks selle märgi nõudele lisada. Mitme üksuse valimiseks hoidke all CTRL-klahvi.';
$string['addbadgecriteria'] = 'Lisa õpimärgi kriteerium';
$string['addcohort'] = 'Lisa kohort';
$string['addcohort_help'] = 'Valige kõik kohordid, mis tuleks selle märgi nõudele lisada. Mitme üksuse valimiseks hoidke all CTRL-klahvi.';
$string['addcompetency'] = 'Lisa kompetens';
$string['addcompetency_help'] = 'Valige kõik kompetentsid, mis tuleks selle märgi nõudele lisada. Mitme üksuse valimiseks hoidke all CTRL-klahvi.';
$string['addcourse'] = 'Lisa kursused';
$string['addcourse_help'] = 'Valige kõik kursused, mis on vaja lisada selle õpimärgi kriteeriumide hulka. Kui soovite valida mitu kursust, hoidke all juhtklahvi (CTRL).';
$string['addcriteria'] = 'Lisa kriteerium';
$string['addcriteriatext'] = 'Kriteeriumide lisamise alustamiseks valige rippmenüüst vastav käsk.';
$string['addedtobackpack'] = 'Seljakotile on lisatud märk';
$string['addrelated'] = 'Lisa seotud märk';
$string['addtobackpack'] = 'Lisa seljakotti';
$string['adminonly'] = 'Sellele lehele pääsevad juurde üksnes saidi administraatorid.';
$string['after'] = 'peale väljaandmiskuupäeva.';
$string['aggregationmethod'] = 'Koondamismeetod';
$string['alignment'] = 'Joondamine';
$string['all'] = 'Kõik';
$string['allmethod'] = 'Kõik valitud tingimused on täidetud';
$string['allmethodactivity'] = 'Kõik valitud tegevused on lõpule viidud';
$string['allmethodbadges'] = 'Kõik valitud märgid on välja teenitud';
$string['allmethodcohort'] = 'Kõigi valitud rühmade liikmelisus';
$string['allmethodcompetencies'] = 'Kõik valitud kompetentsid on täidetud';
$string['allmethodcourseset'] = 'Kõik valitud kursused on läbitud';
$string['allmethodmanual'] = 'Kõik valitud rollid saavad seda õpimärki välja anda';
$string['allmethodprofile'] = 'Kõik valitud profiiliväljad on täidetud';
$string['allowcoursebadges'] = 'Luba kursuse tasemel õpimärgid';
$string['allowcoursebadges_desc'] = 'Saate lubada õpimärkide loomise ja väljaandmise kursuse kontekstis.';
$string['allowexternalbackpack'] = 'Luba ühenduse loomine väliste seljakottidega';
$string['allowexternalbackpack_desc'] = 'Saate kasutajatel lubada luua ühendusi ja vaadata väliste seljakotipakkujate käest saadud õpimärke.

Märkus. See säte tasub keelata, kui saidile ei pääse avalikust Internetist juurde (näiteks tulemüüripiirangute tõttu).';
$string['any'] = 'Mis tahes';
$string['anymethod'] = 'Vastab vähemalt ühele valitud tingimusele';
$string['anymethodactivity'] = 'Vähemalt üks valitud tegevustest on lõpetatud';
$string['anymethodbadges'] = 'Kõik valitud märgid on teenitud';
$string['anymethodcohort'] = 'Liikmelisus ükskõik millises valitud kohordis';
$string['anymethodcompetencies'] = 'Kõik valitud kompetentsid on täidetud';
$string['anymethodcourseset'] = 'Vähemalt üks valitud kursus on lõpetatud';
$string['anymethodmanual'] = 'Ükskõik milline valitud rollidest saab õpimärki välja anda';
$string['anymethodprofile'] = 'Vähemalt üks valitud profiili väli on täidetud';
$string['apiversion'] = 'Toetatud API versioon';
$string['archivebadge'] = 'Kas soovite kustutada õpimärgi \'{$a}\', kuid säilitada olemasolevad välja antud õpimärgid?';
$string['archiveconfirm'] = 'Kustuta ja säilita olemasolevad väljaantud õpimärgid';
$string['archivehelp'] = '<p>Selle valiku korral märgitakse õpimärgi olekuks „pole enam kasutusel“ ning seda ei kuvata enam õpimärkide loendis. Kasutajad ei saa seda õpimärki enam teenida, kuid olemasolevad õpimärgisaajad saavad seda õpimärki oma profiililehel endiselt kuvada ja välistesse seljakottidesse saata.</p>
<p>Kui soovite, et teie kasutajad säilitaksid juurdepääsu teenitud õpimärkidele, tehke kindlasti see valik, selmet õpimärgid täielikult kustutada.</p>';
$string['attachment'] = 'Lisa õpimärk sõnumile';
$string['attachment_help'] = 'Kui see säte on lubatud, siis manustatakse väljaantud õpimärgi fail saaja meilisõnumile. (Selle valiku kasutamiseks peavad olema lubatud manused asukohas Õpikeskkonna haldus > Moodulid > Sõnumiväljundid > E-post.)';
$string['award'] = 'Anna õpimärk välja';
$string['awardedtoyou'] = 'Mulle välja antud';
$string['awardoncron'] = 'Juurdepääs õpimärkidele on lubatud. Selle õpimärgi saajate arv on liiga suur. Süsteemi ülekoormuse vältimiseks toimub õpimärgi väljaandmine kõigile õppijatele järk-järgult ja võtab veidi aega.';
$string['awards'] = 'Saajad';
$string['backpackapiurl'] = 'Seljakoti API URL';
$string['backpackavailability'] = 'Väline õpimärgi kinnitamine';
$string['backpackavailability_help'] = 'Selleks et õpimärgisaajad saaksid tõestada, et nad teenisid õpimärgid teie käest, peab välise seljakoti teenus omama juurdepääsu teie õpikeskkonnale ja kinnitama selle kaudu väljastatud õpimärgid. Näib, et teie õpikeskkond pole praegu juurdepääsetav, mis tähendab, et õpimärke, mille olete juba väljastanud või mida edaspidi väljastate, ei saa kinnitada.

**Miks see sõnum kuvatakse?**

Võimalik, et teie tulemüür takistab juurdepääsu võrguvälistelt kasutajatelt, teie õpikeskkond on parooliga kaitstud või käitate õpikeskkonda arvutis, mis pole Interneti kaudu saadaval (nt kohalik arendusarvuti).

**Kas see on probleem?**

Peaksite selle probleemi lahendama tootmisõpikeskkonnas, kus kavatsete õpimärke väljastada. Vastasel juhul ei saa õpimärgisaajad tõestada, et teenisid märgid teie käest. Kui teie õpikeskkond pole veel aktiivne, aga on juurdepääsetav, saate luua ja väljastada testimiseks mõeldud õpimärke.

**Mida teha, kui ma ei saa kogu õpikeskkonda avalikult juurdepääsetavaks muuta?**

Ainus URL, mida kinnitamiseks nõutakse on [teie-õpikeskkonna-url]/badges/assertion.php, nii et kui saate tulemüüri sätteid muuta ja lubada välisjuurdepääsu sellele failile, toimib õpimärgi kinnitamine ikkagi.';
$string['backpackbadgessettings'] = 'Muuda seljakoti seadistusi';
$string['backpackbadgessummary'] = 'Sul on {$a->totalbadges} märk (i), mis kuvatakse kogudest {$a->totalcollections}.';
$string['backpackcannotsendverification'] = 'Kinnitussõnumit ei saa saata';
$string['backpackconnected'] = 'Seljakott on ühendatud';
$string['backpackconnection'] = 'Ühendus seljakotiga';
$string['backpackconnection_help'] = 'Sellel lehel saate häälestada ühenduse välise seljakoti pakkujaga. Seljakotiga ühenduse loomine võimaldab teil kuvada väliseid õpimärke selles õpikeskkonnas ja saata siin teenitud õpimärke oma seljakotti.

Praegu on toetatud ainult <a href="http://backpack.openbadges.org">Mozilla OpenBadges Backpack</a>. Enne kui üritate sellel lehel seljakotiühendust häälestada, peate registreeruma seljakotiteenuse kasutajaks.';
$string['backpackconnectioncancelattempt'] = 'Loo ühendus mõne muu meiliaadressi abil';
$string['backpackconnectionconnect'] = 'Loo ühendus seljakotiga';
$string['backpackconnectionnottested'] = 'Ühendust ei saa selle seljakoti puhul testida, kuna seda toetavad ainult Open Badges v2.0 seljakotid.';
$string['backpackconnectionok'] = 'Seljakoti ühendus on edukalt loodud';
$string['backpackconnectionresendemail'] = 'Saada kinnitussõnum uuesti';
$string['backpackconnectionunexpectedmessage'] = 'Seljakott tagas vea:"{$a}".';
$string['backpackconnectionunexpectedresult'] = 'Teie seljakotiga ühenduse loomisel ilmnes probleem. Proovige uuesti.<br><br>Kui probleem ei lahene, pöörduge oma administraatori poole.';
$string['backpackdetails'] = 'Seljakoti sätted';
$string['backpackdisconnected'] = 'Seljakoti ühendus on katkenud';
$string['backpackemailverificationpending'] = 'Kinnitus on ootel';
$string['backpackemailverifyemailbody'] = 'Tere!

Teie meiliaadressi kasutades taotleti aadressilt {$a->sitename} teie OpenBadges-seljakotiga uue ühenduse loomist.

Kinnitamiseks ja seljakotiühenduse aktiveerimiseks avage link

{$a->link}

Enamikus meilirakendustes kuvatakse see sinise klõpsatava lingina. Kui see ei toimi, siis kleepige aadress brauseri akna ülaservas olevale aadressiribale.

Kui vajate abi, võtke ühendust saidi administraatoriga
{$a->admin}';
$string['backpackemailverifyemailsubject'] = '{$a}: OpenBadges-seljakoti meiliaadressi kinnitamine';
$string['backpackemailverifypending'] = 'Aadressile <strong>{$a}</strong> saadeti kinnitussõnum. Klõpsake seljakotiühenduse aktiveerimiseks meilis sisalduvat kinnituslinki.';
$string['backpackemailverifysuccess'] = 'Täname teid meiliaadressi kinnitamise eest. Olete loonud ühenduse oma seljakotiga.';
$string['backpackemailverifytokenmismatch'] = 'Klõpsatud lingi tõend ei vasta salvestatud tõendile. Veenduge, et klõpsasite uusimas meilisõnumis sisalduvat linki.';
$string['backpackexporterror'] = 'Märki ei saa seljakotti eksportida';
$string['backpackimport'] = 'Õpimärgi importimise sätted';
$string['backpackimport_help'] = 'Kui ühendus seljakotiga on loodud, saab teie seljakotist pärit õpimärke kuvada teie õpimärkide lehel ja profiililehel.

Sellel alal saate valida oma seljakotist pärit õpimärkide kogumid, mida soovite oma profiilil kuvada.';
$string['backpackprovider'] = 'Seljakoti pakkuja';
$string['backpacksettings'] = 'Seljakoti seadistused';
$string['backpackweburl'] = 'Seljakoti URL';
$string['badgedetails'] = 'Õpimärgi üksikasjad';
$string['badgeimage'] = 'Pilt';
$string['badgeimage_help'] = 'Seda pilti kasutatakse selle õpimärgi väljastamisel.

Uue pildi lisamiseks sirvige ja valige vastav pilt (JPG või PNG-vormingus) ning klõpsake nuppu Salvesta muudatused. Kujutise fail lõigatakse ruudukujuliseks ning selle suurus muudetakse õpimärgi pildi nõuetele vastavaks.';
$string['badgeprivacysetting'] = 'Õpimärgi privaatsuse sätted';
$string['badgeprivacysetting_help'] = 'Teenitud õpimärke saab kuvada teie konto profiililehel. See säte võimaldab teil automaatselt määrata äsja teenitud õpimärkide nähtavuse.

Saate üksikute õpimärkide privaatsussätteid endiselt reguleerida õpimärkide lehel.';
$string['badgeprivacysetting_str'] = 'Kuva mulle antud õpimärke automaatselt minu profiililehel';
$string['badges'] = 'Õpimärgid';
$string['badgesalt'] = 'Adressaadi meiliaadressi räsisool';
$string['badgesalt_desc'] = 'Räsiväärtuse kasutamine võimaldab seljakotiteenustel kinnitada õpimärgi saaja ilma tema meiliaadressi avaldamata. Selle sätte puhul tuleks kasutada ainult numbreid ja tähti.

Märkus. Selleks et saajaid kinnitada, ärge muutke seda sätet pärast seda, kui olete õpimärkide väljastamist alustanud.';
$string['badgesdisabled'] = 'Õpimärgid pole sellel saidil lubatud.';
$string['badgesearned'] = 'Saadud õpimärke: {$a}';
$string['badgesettings'] = 'Õpimärkide sätted';
$string['badgestatus_0'] = 'Pole kasutajate jaoks saadaval';
$string['badgestatus_1'] = 'Kasutajatele saadaval';
$string['badgestatus_2'] = 'Kasutajatele mittesaadaval';
$string['badgestatus_3'] = 'Kasutajatele saadaval';
$string['badgestatus_4'] = 'Arhiivitud';
$string['badgestoearn'] = 'Saadaolevate õpimärkide arv: {$a}';
$string['badgesview'] = 'Kursuse õpimärgid';
$string['badgeurl'] = 'Välja antud õpimärgi link';
$string['balignment'] = 'Joondused ({$a})';
$string['bawards'] = 'Saajad ({$a})';
$string['bcriteria'] = 'Kriteerium';
$string['bdetails'] = 'Muuda üksikasju';
$string['bendorsement'] = 'Kinnitus';
$string['bmessage'] = 'Sõnum';
$string['boverview'] = 'Ülevaade';
$string['brelated'] = 'Seotud märgid ({$a})';
$string['bydate'] = 'lõpetamiskuupäev';
$string['claim'] = 'Nõue';
$string['claimcomment'] = 'Toetav kommentaar';
$string['claimid'] = 'Nõude URL';
$string['clearsettings'] = 'Kustuta sätted';
$string['completioninfo'] = 'See õpimärk on välja antud järgmise puhul:';
$string['completionnotenabled'] = 'Kursuse lõpetamise jälgimine pole selle kursuse puhul võimaldatud ja seega ei saa seda kursust õpimärgi välja andmise kriteeriumite hulka lisada. Kursuse lõpetamise saab aktiveerida kursuse sätetes';
$string['configenablebadges'] = 'Kui see säte on lubatud, saate õpimärke luua ja välja anda kõigile saidi kasutajatele.';
$string['configuremessage'] = 'Õpimärgi sõnum';
$string['connect'] = 'Ühenda';
$string['connected'] = 'Ühendatud';
$string['connecting'] = 'Ühenduse loomine...';
$string['contact'] = 'Kontakt';
$string['contact_help'] = 'Õpimärgi väljaandjaga seotud meiliaadress.';
$string['copyof'] = 'Õpimärgi {$a} koopia';
$string['coursebadges'] = 'Õpimärgid';
$string['coursebadgesdisabled'] = 'Kursuse taseme õpimärgid pole selles õpikeskkonnas lubatud.';
$string['coursecompletion'] = 'Kasutaja peab selle kursuse lõpetama.';
$string['create'] = 'Uus õpimärk';
$string['createbutton'] = 'Loo õpimärk';
$string['creatorbody'] = '<p>{$a->user} on täitnud kõik õpimärgi saamise tingimused ja talle on välja antud õpimärk. Vaata välja antud õpimärki veebilehel {$a->link} </p>';
$string['creatorsubject'] = '\'{$a}\' on välja antud!';
$string['criteria_0'] = 'See õpimärk antakse välja, kui...';
$string['criteria_1'] = 'Tegevuse lõpetatus';
$string['criteria_1_help'] = 'Võimaldab kasutajatele õpimärgi anda kursuse tegevuste kogumi lõpuleviimise põhjal.';
$string['criteria_2'] = 'Käsitsi väljaandmine teatud rollis oleva isiku poolt';
$string['criteria_2_help'] = 'Saate lubada õpimärgi käsitsi väljaandmise süsteemis või kursusel teatud rollis olevate isikute poolt.';
$string['criteria_3'] = 'Sotsiaalne osalus';
$string['criteria_3_help'] = 'Sotsiaalne';
$string['criteria_4'] = 'Kursuse lõpetamise jälgimine';
$string['criteria_4_help'] = 'Saate lubada õpimärgi väljaandmise kasutajatele, kes on kursuse lõpetanud. Sellele kriteeriumile saab lisada lisatingimusi, nagu näiteks minimaalne hinne ja kursuse lõpetamise kuupäev.';
$string['criteria_5'] = 'Valitud arvu kursuste eduka lõpetamise eest';
$string['criteria_5_help'] = 'Lubab õpimärgi väljaandmise kasutajatele, kes on sooritanud teatud arvu kursuseid. Igale kursusele saab lisada lisatingimusi, nagu näiteks minimaalne hinne ja kursuse lõpetamise kuupäev.';
$string['criteria_6'] = 'Profiili täitmine';
$string['criteria_6_help'] = 'Võimaldab kasutajatele õpimärgi anda nende profiili teatud väljade täitmise eest. Saate valida vaikeprofiili ja kohandatud profiili väljade seast, mis on kasutajatele saadaval.';
$string['criteria_7'] = 'Autasustatud märgid';
$string['criteria_7_help'] = 'Lubab kasutajatele anda märgi teiste teenitud märkide alusel.';
$string['criteria_8'] = 'Kohorti kuulumine';
$string['criteria_8_help'] = 'Lubab kasutajatele anda märgi kohorti kuulumise alusel.';
$string['criteria_9'] = 'Kompetentsid.';
$string['criteria_9_help'] = 'Lubab kasutajatele anda märgi nende saavutatud kompetentside alusel.';
$string['criteria_descr'] = 'Õppija saab selle õpimärgi, kui ta täidab järgmised nõuded:';
$string['criteria_descr_0'] = 'Kasutaja saab selle õpimärgi, kui ta täidab <strong>{$a}</strong> loetletud nõuetest.';
$string['criteria_descr_1'] = '<strong>{$a}</strong> järgmistest tegevustest on lõpule viidud:';
$string['criteria_descr_2'] = 'Selle õpimärgi saavad välja anda <strong>{$a}</strong> järgmise rolliga kasutajad:';
$string['criteria_descr_4'] = 'Kasutaja peab kursuse lõpetama';
$string['criteria_descr_5'] = '<strong>{$a}</strong> järgmistest kursustest peab olema lõpetatud:';
$string['criteria_descr_6'] = '<strong>{$a}</strong> järgmistest kasutajaprofiili väljadest peab olema täidetud:';
$string['criteria_descr_7'] = 'Tuleb teenida <strong>{$a}</strong> järgmistest märkidest:';
$string['criteria_descr_8'] = 'Järgmiste kohortide<strong> {$a}</strong>liikmelisus on vajalik:';
$string['criteria_descr_9'] = 'Järgmistest kompetentsidest tuleb täita <strong>{$a}</strong>:';
$string['criteria_descr_bydate'] = 'kuupäevaks <em>{$a}</em>';
$string['criteria_descr_grade'] = 'minimaalse hindega <em>{$a}</em>';
$string['criteria_descr_short0'] = 'Lõpeta <strong>{$a}</strong>:';
$string['criteria_descr_short1'] = 'Lõpeta <strong>{$a}</strong>:';
$string['criteria_descr_short2'] = 'Välja andnud <strong>{$a}</strong>:';
$string['criteria_descr_short4'] = 'Lõpeta kursus';
$string['criteria_descr_short5'] = 'Lõpeta <strong>{$a}</strong>:';
$string['criteria_descr_short6'] = 'Lõpeta <strong>{$a}</strong>:';
$string['criteria_descr_short7'] = 'Täida<strong>{$a}</strong>järgmist:';
$string['criteria_descr_short8'] = 'Kohordi liikmesus <strong>{$a}</strong>hulgas:';
$string['criteria_descr_short9'] = 'Täida<strong>{$a}</strong>järgmist:';
$string['criteria_descr_single_1'] = 'Järgmine tegevuse peab olema lõpetatud:';
$string['criteria_descr_single_2'] = 'Selle õpimärgi saab välja anda järgmise rolliga kasutaja:';
$string['criteria_descr_single_4'] = 'Kasutaja peab kursuse lõpetama';
$string['criteria_descr_single_5'] = 'Järgmine kursuse peab olema lõpetatud:';
$string['criteria_descr_single_6'] = 'Järgmine kasutajaprofiili väli peab olema täidetud:';
$string['criteria_descr_single_7'] = 'Järgnev märk tuleb teenida.';
$string['criteria_descr_single_8'] = 'Järgneva kohordi liikmelisus on nõutud:';
$string['criteria_descr_single_9'] = 'Järgnevad kompetentsid peavad olema saavutatud';
$string['criteria_descr_single_short1'] = 'Lõpeta:';
$string['criteria_descr_single_short2'] = 'Välja andnud:';
$string['criteria_descr_single_short4'] = 'Lõpeta kursus';
$string['criteria_descr_single_short5'] = 'Lõpeta:';
$string['criteria_descr_single_short6'] = 'Lõpeta:';
$string['criteria_descr_single_short7'] = 'Valmis:';
$string['criteria_descr_single_short8'] = 'Liikmelisus';
$string['criteria_descr_single_short9'] = 'Valmis:';
$string['criteriacreated'] = 'Õpimärgi kriteerium on loodud';
$string['criteriadeleted'] = 'Õpimärgi kriteerium on kustutatud';
$string['criteriasummary'] = 'Kriteeriumide kokkuvõte';
$string['criteriaupdated'] = 'Õpimärgi kriteerium on värskendatud';
$string['criterror'] = 'Praegused parameetritega seotud probleemid';
$string['criterror_help'] = 'Sellel väljakogumil on kuvatud kõik parameetrid, mis algselt selle õpimärgi nõuete hulka lisati, kuid pole enam saadaval. Soovitatav on nende parameetrite ruudud tühjendada, et kasutajad saaksid seda õpimärki tulevikus teenida.';
$string['currentimage'] = 'Praegune pilt';
$string['currentstatus'] = 'Praegune olek:';
$string['dateawarded'] = 'Väljaandmise kuupäev';
$string['dateearned'] = 'Kuupäev: {$a}';
$string['day'] = 'Päev(a)';
$string['deactivate'] = 'Keela juurdepääs';
$string['deactivatesuccess'] = 'Juurdepääs õpimärkidele on nüüd keelatud.';
$string['defaultissuercontact'] = 'Õpimärgi väljaandja kontaktandmed (vaikimisi)';
$string['defaultissuercontact_desc'] = 'Õpimärgi väljaandjaga seotud meiliaadress.';
$string['defaultissuername'] = 'Õpimärgi väljaandja nimi (vaikimisi)';
$string['defaultissuername_desc'] = 'Välja andva asutuse nimi.';
$string['defaultissuerpassword'] = 'Märgi väljaandja parool';
$string['defaultissuerpassword_help'] = 'Seljakoti saidil on vaja kontot, mille e-posti aadress on määratud saidi halduse / märkide / märkide sätetes märgi väljaandja e-posti aadressi seadistuses. Siia tuleks sisestada konto parool.';
$string['delbadge'] = 'Kas soovite kustutada õpimärgi \'{$a}\' ja eemaldada kõik olemasolevad välja antud õpimärgid?';
$string['delconfirm'] = 'Kustuta ja eemalda olemasolevad välja antud õpimärgid';
$string['delcritconfirm'] = 'Kas soovite selle kriteeriumi kindlasti kustutada?';
$string['deletehelp'] = '<p>Õpimärgi täielik kustutamine tähendab, et kogu selle teave ja kriteeriumide kirjed eemaldatakse jäädavalt. Kasutajad, kes on selle õpimärgi teeninud, ei pääse sellele enam juurde ja ei saa seda oma profiililehtedel kuvada.</p>
<p>Märkus: Kasutajatele, kes on selle õpimärgi teeninud ja on selle juba oma välisesse seljakotti saatnud, jääb see õpimärk välisesse seljakotti alles. Nad ei pääse aga juurde kriteeriumide ja tõendite lehtedele, mis viivad tagasi sellele veebisaidile.</p>';
$string['delexternalbackpack'] = 'Kustuta saidi seljakott';
$string['delexternalbackpackconfirm'] = 'Kas soovid saidi seljakoti \'{$a}\' kustutada?';
$string['delparamconfirm'] = 'Kas soovite selle parameetri kindlasti kustutada?';
$string['description'] = 'Kirjeldus';
$string['disconnect'] = 'Katkesta ühendus';
$string['donotaward'] = 'See õpimärk pole praegu aktiivne, mistõttu ei saa seda kasutajatele välja anda. Kui soovite selle õpimärgi välja anda, määrake selle olekuks Aktiivne.';
$string['enablebadges'] = 'Luba õpimärgid';
$string['endorsement'] = 'Kinnitus';
$string['error:backpackdatainvalid'] = 'Seljakotist tagastatud andmed ei sobi.';
$string['error:backpackemailnotfound'] = 'Meiliaadress {$a} pole seljakotiga seotud. Peate selle konto jaoks <a href="http://backpack.openbadges.org">looma seljakoti</a> või logima sisse teise meiliaadressiga.';
$string['error:badgeawardnotfound'] = 'Väljaantud õpimärki ei saanud kinnitada. Õpimärk võib olla tühistatud.';
$string['error:badgenotfound'] = 'Õpimärki ei leitud';
$string['error:cannotact'] = 'Seda õpimärki ei saa aktiveerida.';
$string['error:cannotawardbadge'] = 'Seda õpimärki ei saa kasutajale anda.';
$string['error:cannotdeletecriterion'] = 'Kriteeriumi ei saa kustutada.';
$string['error:cannotrevokebadge'] = 'Kasutaja õpimärki ei saa tühistada.';
$string['error:clone'] = 'Seda õpimärki ei saa kloonida.';
$string['error:connectionunknownreason'] = 'Ühenduse loomine nurjus, kuid selle põhjust ei avaldatud.';
$string['error:duplicatename'] = 'Sama nimega õpimärk on juba süsteemis olemas.';
$string['error:externalbadgedoesntexist'] = 'Õpimärki ei leitud';
$string['error:guestuseraccess'] = 'Olete sisenenud külaliskasutajana. Õpimärkide vaatamiseks peate sisse logima oma kasutajakontoga.';
$string['error:invalidcriteriatype'] = 'Kriteeriumi tüüp ei sobi.';
$string['error:invalidexpiredate'] = 'Aegumisekuupäev peab olema tulevikus.';
$string['error:invalidexpireperiod'] = 'Aegumisperiood ei või olla negatiivne ega võrdne nulliga.';
$string['error:invalidparambadge'] = 'Märk ei eksisteeri.';
$string['error:invalidparamcohort'] = 'Kohorti ei eksisteeri';
$string['error:noactivities'] = 'Sellel kursusel pole ühtegi tegevust, mille puhul on lõpetamise kriteeriumid lubatud.';
$string['error:nobadges'] = 'Praegu pole ühtegi märki, millel oleks kriteeriumidena lubatud juurdepääs. Saidi märgi kriteeriumid võivad olla ainult muud saidi märgid. Kursuse märgi kriteeriumideks võivad olla muud kursuse märgid või saidi märgid.';
$string['error:nocohorts'] = 'Kohorte pole';
$string['error:nocourses'] = 'Kursuse lõpetamise jälgimine pole lubatud mitte ühegi selle õpikeskkonna kursuse puhul – seega ei saa neist mitte ühtegi kuvada. Kursuse lõpetamise saab aktiveerida kursuse sätetes';
$string['error:nogroupslink'] = '<p>Kuvatakse ainult avalikud kogud. <a href="{$a}" target="_blank" rel="nofollow"> Külasta oma seljakotti</a>, et luua mõned avalikud kollektsioonid.</p>';
$string['error:nogroupssummary'] = '<p>Sinu seljakotis pole ühtegi avalikku märkide kogu.</p>';
$string['error:nopermissiontoview'] = 'Teil pole õpimärgi saajate vaatamise õigust';
$string['error:nosuchbadge'] = 'Õpimärki ID-ga {$a} pole olemas.';
$string['error:nosuchcohort'] = 'Hoiatus: See kohort ei ole enam saadaval.';
$string['error:nosuchcourse'] = 'Hoiatus. See kursus pole enam saadaval.';
$string['error:nosuchfield'] = 'Hoiatus. See kasutajaprofiili väli pole enam saadaval.';
$string['error:nosuchmod'] = 'Hoiatus. See tegevus pole enam saadaval.';
$string['error:nosuchrole'] = 'Hoiatus. See roll pole enam saadaval.';
$string['error:nosuchuser'] = 'Selle meiliaadressiga kasutajal pole praeguse seljakoti pakkuja juures kontot.';
$string['error:notifycoursedate'] = 'Hoiatus. Kursuse ja tegevuste lõpetamisega seotud õpimärke ei väljastata enne kursuse alguskuupäeva.';
$string['error:parameter'] = 'Hoiatus. Õpimärkide väljastamise õige töövoo tagamiseks tuleb valida vähemalt üks parameeter.';
$string['error:relatedbadgedoesntexist'] = 'Sellel identifikaatoril puudub avalik märk.';
$string['error:requesterror'] = 'Ühendustaotlus nurjus (tõrkekood {$a}).';
$string['error:requesttimeout'] = 'Ühendustaotlus aegus enne selle lõpuleviimist.';
$string['error:save'] = 'Õpimärki ei saa salvestada.';
$string['error:userdeleted'] = '{$a->user} (Seda kasutajat pole enam õpikeskkonnas {$a->site})';
$string['eventbadgearchived'] = 'Õpimärk arhiiviti';
$string['eventbadgeawarded'] = 'Õpimärk on välja antud';
$string['eventbadgecreated'] = 'Õpimärk loodi';
$string['eventbadgecriteriacreated'] = 'Õpimärgi kriteerium loodi';
$string['eventbadgecriteriadeleted'] = 'Õpimärgi kriteerium kustutati';
$string['eventbadgecriteriaupdated'] = 'Õpimärgi kriteerium värskendati';
$string['eventbadgedeleted'] = 'Õpimärk kustutati';
$string['eventbadgedisabled'] = 'Õpimärk keelati';
$string['eventbadgeduplicated'] = 'Õpimärk dubleeriti';
$string['eventbadgeenabled'] = 'Õpimärk lubati';
$string['eventbadgelistingviewed'] = 'Õpimärgi loendit vaadati';
$string['eventbadgerevoked'] = 'Õpimärk tühistati';
$string['eventbadgeupdated'] = 'Õpimärk on uuendatud';
$string['eventbadgeviewed'] = 'Õpimärki vaadati';
$string['existingrecipients'] = 'Olemasolevad õpimärgisaajad';
$string['existsinbackpack'] = 'Märk on seljakotis juba olemas.';
$string['expired'] = 'Aegunud';
$string['expiredate'] = 'See õpimärk aegub {$a}.';
$string['expireddate'] = 'See õpimärk aegus {$a}.';
$string['expireperiod'] = 'See õpimärk aegub {$a} päev(a) pärast väljaandmist.';
$string['expireperiodh'] = 'See õpimärk aegub {$a} tund(i) pärast väljaandmist.';
$string['expireperiodm'] = 'See õpimärk aegub {$a} minut(it) pärast väljaandmist.';
$string['expireperiods'] = 'See õpimärk aegub {$a} sekund(it) pärast väljaandmist.';
$string['expirydate'] = 'Aegumiskuupäev';
$string['expirydate_help'] = 'Soovi korral võivad õpimärgid aeguda kindlal kuupäeval või kuupäeva võib arvutada selle kuupäeva põhjal, mil õpimärk kasutajale väljastati.';
$string['externalbadges'] = 'Minu õpimärgid muudelt veebilehtedelt';
$string['externalbadges_help'] = 'Selles alas kuvatakse välisest seljakotist pärit õpimärgid.';
$string['externalbadgesp'] = 'Õpimärgid muudel veebilehtedelt:';
$string['externalconnectto'] = 'Väliste õpimärkide nägemiseks peate <a href="{$a}">seljakotiga ühenduse looma</a>.';
$string['fixed'] = 'Fikseeritud kuupäev';
$string['hidden'] = 'Peidetud';
$string['hiddenbadge'] = 'Kahjuks pole õpimärgi omanik seda teavet avalikuks teinud.';
$string['imageauthoremail'] = 'Pildi autori epost';
$string['imageauthoremail_help'] = 'Kui see on täpsustatud, kuvatakse rmärgi lehel märgi pildi autori e-posti aadress.';
$string['imageauthorname'] = 'Pildi autori nimi';
$string['imageauthorname_help'] = 'Kui see on täpsustatud, kuvatakse märgi lehel märgi pildi autori nimi.';
$string['imageauthorurl'] = 'Pildi autori URL';
$string['imageauthorurl_help'] = 'Kui see on täpsustatud, kuvatakse märkide lehel link märkide autori veebisaidile. URL-il peaks olema eesliide http:// või https://.';
$string['imagecaption'] = 'Pildi pealdis';
$string['imagecaption_help'] = 'Kui see on täpsustatud, kuvatakse märkide lehel pildi pealdis.';
$string['includeauthdetails'] = 'Lisa seljakoti autentimise üksikasjad';
$string['invalidurl'] = 'Kehtetu URL';
$string['issuancedetails'] = 'Õpimärgi aegumine';
$string['issuedbadge'] = 'Välja antud õpimärgi teave';
$string['issuerdetails'] = 'Väljaandja üksikasjad';
$string['issueremail'] = 'Epost';
$string['issueremail_help'] = 'Heakskiidu andnud organisatsiooni kontakt-e-posti aadress.';
$string['issuername'] = 'Väljaandja nimi';
$string['issuername_endorsement'] = 'Heakskiitja nimi';
$string['issuername_endorsement_help'] = 'Heakskiitja nimi';
$string['issuername_help'] = 'Välja andva asutuse nimi.';
$string['issuerurl'] = 'Väljaandja URL';
$string['issuerurl_help'] = 'Heakskiidu andnud organisatsiooni veebileht. URL-il peaks olema eesliide http:// või https://.';
$string['language'] = 'Keel';
$string['language_help'] = 'Märgi lehel kasutatud keel';
$string['listbackpacks'] = 'Seljakottide nimekiri';
$string['localbadges'] = 'Minu õpimärgid veebilehelt {$a}';
$string['localbadgesh'] = 'Minu õpimärgid sellelt veebilehelt';
$string['localbadgesh_help'] = 'Kõik sellel veebisaidil kursuste ja kursuse tegevuste lõpetamise ning muude nõuete täitmise eest teenitud õpimärgid.

Saate oma õpimärke hallata siin, muutes need profiililehel avalikuks või privaatseks.

Saate kõik õpimärgid korraga või iga õpimärgi eraldi alla laadida ja oma arvutisse salvestada. Allalaaditud õpimärgid saab lisada välise seljakoti teenusesse.';
$string['localbadgesp'] = 'Õpimärgid väljaandjalt {$a}:';
$string['localconnectto'] = 'Nende õpimärkide jagamiseks väljaspoole seda veebilehte peate <a href="{$a}">seljakotiga ühenduse looma</a>.';
$string['makeprivate'] = 'Muuda privaatseks';
$string['makepublic'] = 'Muuda avalikuks';
$string['managebackpacks'] = 'Halda seljakotte';
$string['managebadges'] = 'Halda õpimärke';
$string['message'] = 'Sõnumi sisu';
$string['messagebody'] = '<p>Teile on antud õpimärk „%badgename%“!</p>
<p>Lisateavet selle õpimärgi kohta leiate õpimärgi teabelehelt %badgelink%.</p>
<p>Saate õpimärki hallata ja selle alla laadida lehe {$a} kaudu.</p>';
$string['messagesubject'] = 'Õnnitleme! Teenisite praegu uue õpimärgi!';
$string['method'] = 'See kriteerium on täidetud kui...';
$string['mingrade'] = 'Nõutav miinimumhinne';
$string['month'] = 'Kuu(d)';
$string['moredetails'] = 'Täpsemalt';
$string['mybackpack'] = 'Minu seljakoti sätted';
$string['mybadges'] = 'Minu õpimärgid';
$string['never'] = 'Mitte kunagi';
$string['newbackpack'] = 'Lisa uus seljakott';
$string['newbadge'] = 'Lisa uus õpimärk';
$string['newimage'] = 'Uus pilt';
$string['noalignment'] = 'Sellel märgil pole täpsustatud mingeid väliseid oskusi ega standardeid.';
$string['noawards'] = 'Keegi pole seda õpimärki veel välja teeninud.';
$string['nobackpack'] = 'Selle kontoga pole seotud ükski seljakotiteenus.<br/>';
$string['nobackpackbadgessummary'] = 'Sinu valitud kollektsioonides pole ühtegi märki.';
$string['nobackpackcollectionssummary'] = 'Ühtegi märgi kollektsiooni pole valitud.';
$string['nobackpacks'] = 'Ühtegi seljakotti pole saadaval';
$string['nobadges'] = 'Ühtegi õpimärki pole saadaval.';
$string['nocompetencies'] = 'Ühtegi kompetentsi pole valitud';
$string['nocriteria'] = 'Selle õpimärgi kriteeriumid pole veel häälestatud.';
$string['noendorsement'] = 'Märgil puudub heakskiit';
$string['noexpiry'] = 'Selle õpimärgi aegumiskuupäeva pole märgitud.';
$string['noparamstoadd'] = 'Saadaval pole ühtegi täiendavat parameetrit, mida sellele õpimärginõudele lisada.';
$string['norelated'] = 'Märkgil puuduvad seotud märgid.';
$string['notacceptedrole'] = 'Teile praegu määratud roll ei luba teil seda õpimärki käsitsi väljastada.<br/>
Kui soovite vaadata kasutajaid, kes on selle õpimärgi juba teeninud, külastage lehte {$a}.';
$string['notconnected'] = 'Pole ühendatud';
$string['notealignment'] = 'Võib täpsustada väliseid oskusi või standardeid, millega märk on vastavusse viidud. Kõik välised oskused või standardid kuvatakse märkide lehel.';
$string['noteendorsement'] = 'Märgile väärtuse lisamiseks võib kasutada kolmanda osapoole kinnitust.';
$string['noterelated'] = 'Ühendusega märgid võidakse märkida seotuks. Näiteks võidakse märkida seotuteks ühesuguste kriteeriumidega märgid, mis kuvatakse erinevates keeltes. Kõik seotud märgid kuvatakse märgi lehel.';
$string['nothingtoadd'] = 'Lisatavad kriteeriumid puuduvad.';
$string['notification'] = 'Teavita õpimärgi loojat';
$string['notification_help'] = 'Selle sättega hallatakse teatisi, mis saadetakse õpimärgi loojale, et teavitada teda õpimärgi väljastamisest.

Saadaval on järgmised valikud.

* **MITTE KUNAGI** – teatisi ei saadeta kunagi.

* **IGA KORD** – teatis saadetakse iga kord, kui õpimärk välja antakse.

* **IGA PÄEV** – teatisi saadetakse kord päevas.

* **KORD NÄDALAS** – teatisi saadetakse kord nädalas.

* **KORD KUUS** – teatisi saadetakse kord kuus.';
$string['notifydaily'] = 'Iga päev';
$string['notifyevery'] = 'Iga kord';
$string['notifymonthly'] = 'Iga kuu';
$string['notifyweekly'] = 'Iga nädal';
$string['numawards'] = 'See õpimärk on välja antud <a href="{$a->link}">{$a->count}</a> kasutajale.';
$string['numawardstat'] = 'See õpimärk on välja antud {$a} kasutajale.';
$string['oauth2issuer'] = 'OAuth 2 teenused';
$string['openbadgesv1'] = 'Avatud märgid v1.0';
$string['openbadgesv2'] = 'Avage märkide v2.0';
$string['openbadgesv2p1'] = 'Avage märkide v2.1';
$string['overallcrit'] = 'valitud kriteeriumidest on täidetud.';
$string['potentialrecipients'] = 'Võimalikud õpimärgisaajad';
$string['preferences'] = 'Õpimärkide eelistused';
$string['privacy:metadata:backpack'] = 'Kasutaja seljakottide register';
$string['privacy:metadata:backpack:backpackuid'] = 'Seljakoti kordumatu tunnus';
$string['privacy:metadata:backpack:email'] = 'Seljakotiga seotud e-posti aadress';
$string['privacy:metadata:backpack:externalbackpackid'] = 'Seljakoti ID';
$string['privacy:metadata:backpack:userid'] = 'Selle kasutaja ID, kellele see seljakott kuulub';
$string['privacy:metadata:backpackoauth2'] = 'OAuth 2 teave, kui kasutaja loob ühenduse välise seljakotiga';
$string['privacy:metadata:backpackoauth2:issuerid'] = 'OAuth 2 teenuse ID';
$string['privacy:metadata:backpackoauth2:scope'] = 'Loetle seljakoti ühendamise ulatus';
$string['privacy:metadata:backpackoauth2:token'] = 'Seljakoti ühendamise märk';
$string['privacy:metadata:backpackoauth2:userid'] = 'Seljakotiga ühendatava kasutaja ID';
$string['privacy:metadata:backpackoauth2:usermodified'] = 'Kasutaja muudetud ühenduse ID';
$string['privacy:metadata:badge'] = 'Märkide kogu';
$string['privacy:metadata:badge:timecreated'] = 'Märgi loomise aeg';
$string['privacy:metadata:badge:timemodified'] = 'Märgi muutmise aeg';
$string['privacy:metadata:badge:usercreated'] = 'Märgi loonud kasutaja ID';
$string['privacy:metadata:badge:usermodified'] = 'Märki muutnud kasutaja ID';
$string['privacy:metadata:criteriamet'] = 'Täidetud kriteeriumide kogu';
$string['privacy:metadata:criteriamet:datemet'] = 'Kriteeriumide täitmise kuupäev';
$string['privacy:metadata:criteriamet:userid'] = 'Kriteeriumidele vastanud kasutaja ID';
$string['privacy:metadata:external:backpacks'] = 'Teave, mida jagatakse, kui kasutajad esitavad oma märgid välisele seljakotile';
$string['privacy:metadata:external:backpacks:badge'] = 'Märgi  nimi';
$string['privacy:metadata:external:backpacks:description'] = 'Märgi kirjeldus';
$string['privacy:metadata:external:backpacks:image'] = 'Märgi pilt';
$string['privacy:metadata:external:backpacks:issuer'] = 'Natuke informatsiooni väljaandja kohta';
$string['privacy:metadata:external:backpacks:url'] = 'Moodle\'i URL, kus väljastatud märgi teavet saab vaadata';
$string['privacy:metadata:issued'] = 'Hinnatud märkide kaart';
$string['privacy:metadata:issued:dateexpire'] = 'Märgi aegumiskuupäev';
$string['privacy:metadata:issued:dateissued'] = 'Auhinna kuupäev';
$string['privacy:metadata:issued:userid'] = 'Märki auhinnanud kasutaja ID';
$string['privacy:metadata:manualaward'] = 'Käsitsi antud auhindade nimekiri';
$string['privacy:metadata:manualaward:datemet'] = 'Kuupäev, mil kasutajale märk anti';
$string['privacy:metadata:manualaward:issuerid'] = 'Märgi omistanud kasutaja ID';
$string['privacy:metadata:manualaward:issuerrole'] = 'Aumärki omistava kasutaja roll';
$string['privacy:metadata:manualaward:recipientid'] = 'Manuaalselt märgi saanud kasutaja ID';
$string['recipients'] = 'Õpimärgi saajad';
$string['recipientvalidationproblem'] = 'Praegust kasutajat ei saa selle õpimärgi saajana kinnitada.';
$string['relatedbages'] = 'Seotud märgid';
$string['relative'] = 'Suhteline kuupäev';
$string['requiredbadge'] = 'Märgi kriteeriumile tuleks lisada vähemalt üks märk.';
$string['requiredcohort'] = 'Kohordi kriteeriumile tuleks lisada vähemalt üks kohort.';
$string['requiredcompetency'] = 'Pädevuskriteeriumile tuleks lisada vähemalt üks pädevus.';
$string['requiredcourse'] = 'Kursusekogumi kriteeriumide hulka tuleb lisada vähemalt üks kursus.';
$string['reviewbadge'] = 'Õpimärgile juurdepääsu muudatused';
$string['reviewconfirm'] = '<p>See muudab teie õpimärgi kasutajatele nähtavaks ja võimaldab neil hakata seda teenima.</p>

<p>Võimalik, et mõned kasutajad vastavad juba selle õpimärgi kriteeriumidele ja neile väljastatakse see õpimärk kohe, kui olete selle lubanud.</p>

<p>Õpimärgi väljastamise järel on see <strong>lukustatud</strong> – teatud sätteid, sh kriteeriume ja aegumissätteid ei saa enam muuta.</p>

<p>Kas olete kindel, et soovite lubada juurdepääsu õpimärgile {$a}?</p>';
$string['revoke'] = 'Tühista õpimärk';
$string['save'] = 'Salvesta';
$string['searchname'] = 'Otsi nime järgi';
$string['selectaward'] = 'Valige õpimärgi väljaandmiseks roll:';
$string['selectgroup_end'] = 'Kuvatakse üksnes avalikud kogumid. Uued avalikud kogumid saate luua <a href="http://backpack.openbadges.org">seljakotis</a>.';
$string['selectgroup_start'] = 'Valige oma seljakotist kogumid, mis kuvatakse sellel saidil:';
$string['selecting'] = 'Valitud õpimärkidega...';
$string['setup'] = 'Häälesta ühendus';
$string['sitebackpackdeleted'] = 'Saidi seljakott on kustutatud';
$string['sitebackpacknotdeleted'] = 'Seda seljakotti ei saanud kustutada, kuna see on saidi vaikevalik.';
$string['sitebackpackwarning'] = 'Seljakotiga ei saanud ühendust luua. <br/><br/> Kontrolli, kas administraatori seade "Märgi väljaandja e-posti aadress" on seljakoti veebisaidil oleva konto kehtiv e-posti aadress.
<br/><br/> Veendu, et saidi seljakoti seadete lehel <a href="{$a->url}">saidi seljakoti seadete </a> Märgi väljaandja parool "oleks õige konto parool. seljakoti veebisait. <br/><br/>Seljakott tagastas: "{$a->warning}"';
$string['sitebadges'] = 'Saidi õpimärgid';
$string['sitebadges_help'] = 'Saidi õpimärke saab kasutajatele anda vaid saidiga seotud tegevuste eest. Nende hulka kuuluvad valitud arvu kursuste edukas lõpetamine või kasutajaprofiili teatud osade täitmine. Kasutajad saavad saidi õpimärke ka teistele kasutajatele käsitsi väljastada.

Kursusega seotud tegevuste õpimärgid tuleb luua kursuse tasemel. Kursuse õpimärkidele juurdepääsemiseks valige Kursuse haldamine > Õpimärgid.';
$string['status'] = 'Õpimärgi olek';
$string['status_help'] = 'Õpimärgi olek määrab selle käitumise süsteemis.

* **SAADAVAL** – tähendab, et kasutajad võivad selle õpimärgi teenida. Kui õpimärk on kasutajatele saadaval, ei saa selle kriteeriume muuta.

* **POLE SAADAVAL** – tähendab, et see õpimärk pole kasutajatele saadaval ning seda ei saa teenida ega käsitsi väljastada. Kui taolist õpimärki pole kunagi varem väljastatud, saab selle kriteeriume muuta.

Kui õpimärk on vähemalt ühele kasutajale väljastatud, muutub selle olekuks automaatselt **LUKUSTATUD**. Kasutajad saavad lukustatud õpimärke endiselt teenida, kuid nende kriteeriume ei saa enam muuta. Kui teil on vaja lukustatud õpimärgi üksikasju või kriteeriume muuta, saate luua selle õpimärgi duplikaadi ja teha kõik vajalikud muudatused.

*Miks me õpimärke lukustame?*

Soovime tagada, et kõik kasutajad täidaksid õpimärgi teenimiseks samad nõuded. Praegu pole võimalik õpimärke tühistada. Kui me lubaksime õpimärkide nõudeid kogu aeg muuta, saaksid kasutajad tõenäoliselt sama õpimärgi täiesti erinevatele nõuetele vastamise eest.';
$string['statusmessage_0'] = 'See õpimärk pole praegu kasutajatele saadaval. Lubage juurdepääs, kui soovite, et kasutajad selle õpimärgi teeniksid.';
$string['statusmessage_1'] = 'See õpimärk on praegu kasutajatele saadaval. Muudatuste tegemiseks keelake juurdepääs.';
$string['statusmessage_2'] = 'See õpimärk pole praegu kasutajatele saadaval ja selle kriteeriumid on lukustatud. Lubage juurdepääs, kui soovite, et kasutajad selle õpimärgi teeniksid.';
$string['statusmessage_3'] = 'See õpimärk on praegu kasutajatele saadaval ja selle kriteeriumid on lukustatud.';
$string['statusmessage_4'] = 'See õpimärk on praegu arhiivitud.';
$string['subject'] = 'Sõnumi teema';
$string['targetcode'] = 'Kood';
$string['targetcode_help'] = 'Ainulaadne stringitunnus välise oskuse või standardi viitamiseks selles raamistikus.';
$string['targetdescription'] = 'Kirjeldus';
$string['targetdescription_help'] = 'Välise oskuse või standardi lühikirjeldus.';
$string['targetframework'] = 'Raamistik';
$string['targetframework_help'] = 'Välise oskuse või standardraamistiku nimi.';
$string['targetname'] = 'Nimi';
$string['targetname_help'] = 'Väline oskus või standard, millega märk on joondatud.';
$string['targeturl'] = 'URL';
$string['targeturl_help'] = 'Link lehele, mis kirjeldab välist oskust või standardit. URL-il peaks olema eesliide http:// või https://.';
$string['testbackpack'] = 'Test seljakott \'{$a}\'';
$string['testsettings'] = 'Testi seaded';
$string['type'] = 'Tüüp';
$string['variablesubstitution'] = 'Muutujate asendamine sõnumites.';
$string['variablesubstitution_help'] = 'Õpimärgi sõnumi puhul saab sõnumi teemasse ja/või sisusse lisada teatud muutujad, mis asendatakse sõnumi saatmisel tegelike väärtustega. Muutujad tuleb teksti lisada täpselt nii, nagu need on kuvatud allpool. Kasutada saab järgmisi muutujaid.

%badgename%
: see asendatakse õpimärgi täisnimega.

%username%
: see asendatakse saaja täisnimega.

%badgelink%:
: see asendatakse avaliku URL-iga, mis sisaldab teavet väljastatud õpimärgi kohta.';
$string['version'] = 'Versioon';
$string['version_help'] = 'Versiooni välja võib kasutada märgi arengu jälgimiseks. Kui see on täpsustatud, kuvatakse versioon märgi lehel.';
$string['viewbadge'] = 'Vaata välja antud õpimärke';
$string['visible'] = 'Nähtavus';
$string['warnexpired'] = '(See õpimärk on aegunud.)';
$string['year'] = 'Aasta(t)';
