<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'ai', language 'pt_br', version '5.1'.
 *
 * @package     ai
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['acceptai'] = 'Aceitar e continuar';
$string['action'] = 'Ação';
$string['action_explain_text'] = 'Explicar texto';
$string['action_explain_text_desc'] = 'Explica o conteúdo de texto em uma página do curso.';
$string['action_explain_text_help'] = 'Fornece uma explicação que expande ideias-chave, simplifica conceitos complexos e adiciona contexto para tornar o texto mais fácil de entender.';
$string['action_explain_text_instruction'] = 'Você receberá um texto de entrada do usuário. Sua tarefa é explicar o texto fornecido. Siga estas diretrizes:
    1. Elaborar: Expanda as ideias e conceitos principais, garantindo que a explicação agregue profundidade significativa e evite apenas reformular o texto.
    2. Simplificar: Divida termos ou ideias complexas em componentes mais simples, facilitando o entendimento para uma ampla audiência, incluindo estudantes.
    3. Fornecer contexto: Explique por que algo acontece, como funciona ou qual é seu propósito. Inclua exemplos ou analogias relevantes para melhorar a compreensão quando apropriado.
    4. Organizar logicamente: Estruture sua explicação para que tenha um fluxo natural, começando com ideias fundamentais antes de avançar para detalhes mais específicos.

Instruções importantes:
    1. Retorne o resumo apenas em texto simples.
    2. Não inclua formatação em markdown, saudações ou cortesias.
    3. Foque na clareza, concisão e acessibilidade.

Garanta que a explicação seja fácil de ler e transmita de forma eficaz os pontos principais do texto original.';
$string['action_generate_image'] = 'Gerar imagem';
$string['action_generate_image_desc'] = 'Gera uma imagem com base em um prompt de texto.';
$string['action_generate_image_help'] = 'Cria uma imagem a partir de um prompt.';
$string['action_generate_text'] = 'Gerar texto';
$string['action_generate_text_desc'] = 'Gera texto com base em um prompt de texto.';
$string['action_generate_text_help'] = 'Cria um texto a partir de um prompt.';
$string['action_generate_text_instruction'] = 'Você receberá uma entrada de texto do usuário. Sua tarefa é gerar um texto com base na solicitação deles. Siga estas instruções importantes:
    1. Retorne o resumo apenas em texto simples.
    2. Não inclua nenhuma formatação markdown, saudações ou formalidades.';
$string['action_summarise_text'] = 'Resumir texto';
$string['action_summarise_text_desc'] = 'Resume o conteúdo textual em uma página de curso';
$string['action_summarise_text_help'] = 'Cria um breve resumo do conteúdo em uma página.';
$string['action_summarise_text_instruction'] = 'Você receberá uma entrada de texto do usuário. Sua tarefa é resumir o texto fornecido. Siga estas diretrizes:
    1. Condensar: Resuma longas passagens em pontos-chave.
    2. Simplificar: Torne informações complexas mais fáceis de entender, especialmente para aprendizes.

Instruções Importantes:
    1. Retorne o resumo apenas em texto simples.
    2. Não inclua qualquer formatação em markdown, saudações ou clichês.
    3. Foque na clareza, concisão e acessibilidade.

Garanta que o resumo seja fácil de ler e transmita efetivamente os principais pontos do texto original.';
$string['action_translate_text'] = 'Traduzir texto';
$string['action_translate_text_desc'] = 'Traduz o texto fornecido de um idioma para outro.';
$string['actionsettingprovider'] = 'Configurações de ação {$a}';
$string['actionsettingprovider_desc'] = 'Essas configurações controlam como o {$a->providername} executa a ação {$a->actionname}.';
$string['actionsettings'] = 'Configurações de ação';
$string['actionsettings_desc'] = 'Essas configurações controlam como a IA atua para esta instância do provedor.';
$string['ai'] = 'IA';
$string['aiactionregister'] = 'Registro de ações de IA';
$string['aiactionshdr'] = 'Selecione os recursos de IA para esta atividade:';
$string['aiplacements'] = 'Posicionamentos de IA';
$string['aipolicyacceptance'] = 'Aceitação da política de IA';
$string['aipolicyregister'] = 'Registro da política de IA';
$string['aiproviders'] = 'Provedores de IA';
$string['aireports'] = 'Relatórios de IA';
$string['aitools'] = 'Ferramentas de IA';
$string['aitoolsincourseactivitydesc'] = 'Se marcado como Sim, você pode definir quais recursos de IA estarão disponíveis.';
$string['aitoolsincoursedesc'] = 'Se marcado como Sim, as ferramentas de IA estarão disponíveis para atividades neste curso. As ferramentas de IA podem ser configuradas nas configurações de cada atividade.';
$string['aitoolsnotenabled'] = 'Para definir quais recursos de IA você deseja que estejam disponíveis nesta atividade, vá para as configurações do curso e permita Ferramentas de IA.';
$string['aiusage'] = 'Uso de IA';
$string['aiusagepolicy'] = 'Política de uso de IA';
$string['availableplacements'] = 'Escolha onde as ações de IA estão disponíveis';
$string['availableplacements_desc'] = 'Os posicionamentos definem como e onde as ações de IA podem ser usadas no seu site. Você pode escolher quais ações estão disponíveis em cada posicionamento através das configurações.';
$string['availableproviders'] = 'Gerencie os provedores de IA conectados ao seu LMS';
$string['availableproviders_desc'] = 'Os provedores de IA adicionam funcionalidades de IA ao seu site por meio de "ações", como resumo de texto ou geração de imagens.
Você pode gerenciar as ações de cada provedor em suas configurações.';
$string['btninstancecreate'] = 'Criar instância';
$string['btninstanceupdate'] = 'Atualizar instância';
$string['completiontokens'] = 'Tokens de conclusão';
$string['completiontokens_help'] = 'Os tokens de conclusão são as unidades de texto geradas pelo modelo de IA como resposta à sua entrada. Respostas mais longas usam mais tokens, o que normalmente aumenta o custo.';
$string['configureprovider'] = 'Configurar instância do provedor';
$string['contentwatermark'] = 'Gerado por IA';
$string['createnewprovider'] = 'Criar nova instância do provedor';
$string['dateaccepted'] = 'Data de aceitação';
$string['declineaipolicy'] = 'Recusar';
$string['enableaitoolsincourse'] = 'Permitir ferramentas de IA para este curso';
$string['enableaitoolsincourseactivity'] = 'Permitir ferramentas de IA nesta atividade';
$string['enableglobalratelimit'] = 'Definir limite de taxa para todo o site';
$string['enableglobalratelimit_help'] = 'Número limite de solicitações que o provedor da API OpenAI pode receber em todo o site a cada hora.';
$string['enableuserratelimit'] = 'Definir limite de taxa de usuário';
$string['enableuserratelimit_help'] = 'Número limite de solicitações que cada usuário pode fazer ao provedor da API OpenAI a cada hora.';
$string['error:400'] = 'Erro na solicitação';
$string['error:401'] = 'Não autorizado';
$string['error:401:upstreamless'] = 'Não foi possível conectar ao serviço de IA. Tente novamente mais tarde.';
$string['error:404'] = 'Não encontrado';
$string['error:404:upstreamless'] = 'O serviço de IA está temporariamente indisponível. Tente novamente mais tarde.';
$string['error:429'] = 'Muitas solicitações';
$string['error:429:internalsitewide'] = 'A IA atingiu o número máximo de solicitações por hora em todo o site. Tente novamente mais tarde.';
$string['error:429:internaluser'] = 'Você atingiu o número máximo de solicitações de IA que pode fazer em uma hora. Tente novamente mais tarde.';
$string['error:429:upstreamless'] = 'Este serviço de IA atingiu seu limite de solicitações. Tente novamente mais tarde.';
$string['error:500'] = 'Erro Interno do Servidor';
$string['error:503'] = 'Serviço indisponível';
$string['error:actionnotfound'] = 'A ação "{$a}" não é suportada.';
$string['error:defaultmessage'] = 'Ocorreu um erro ao processar sua solicitação. Tente novamente mais tarde.';
$string['error:defaultmessageshort'] = 'Tente novamente mais tarde';
$string['error:defaultname'] = 'Algo deu errado';
$string['error:noproviders'] = 'Nenhum provedor disponível para processar a ação.';
$string['error:providernotfound'] = 'A instância do provedor de IA não foi encontrada.';
$string['error:unknown'] = 'Erro desconhecido';
$string['globalratelimit'] = 'Número máximo de solicitações em todo o site';
$string['globalratelimit_help'] = 'O número de solicitações em todo o site permitido por hora.';
$string['manageaiplacements'] = 'Gerenciar posicionamentos de IA';
$string['manageaiproviders'] = 'Gerenciar provedores de IA';
$string['noproviders'] = 'Esta ação não está disponível. Nenhum <a href="{$a}">provedor de IA</a> está configurado para esta ação.';
$string['off'] = 'Inativo';
$string['on'] = 'Ativo';
$string['placement'] = 'Posicionamento';
$string['placementactionsettings'] = 'Ações';
$string['placementactionsettings_desc'] = 'As ações de IA disponíveis para este posicionamento.';
$string['placementsettings'] = 'Configurações específicas de localização';
$string['placementsettings_desc'] = 'Essas configurações controlam como este posicionamento de IA se conecta ao serviço de IA e operações relacionadas.';
$string['privacy:metadata:ai_action_explain_text'] = 'Uma tabela armazenando as solicitações de explicação de texto feitas pelos usuários.';
$string['privacy:metadata:ai_action_explain_text:completiontoken'] = 'Os tokens de conclusão usados para explicar o texto.';
$string['privacy:metadata:ai_action_explain_text:fingerprint'] = 'O hash único que representa o estado/versão do modelo e do conteúdo.';
$string['privacy:metadata:ai_action_explain_text:generatedcontent'] = 'O texto gerado pelo modelo de IA com base no prompt de entrada.';
$string['privacy:metadata:ai_action_explain_text:prompt'] = 'O prompt para a solicitação de explicação de texto.';
$string['privacy:metadata:ai_action_explain_text:prompttokens'] = 'Os tokens do prompt usados para explicar o texto.';
$string['privacy:metadata:ai_action_explain_text:responseid'] = 'O ID da resposta.';
$string['privacy:metadata:ai_action_generate_image'] = 'Uma tabela que armazena as solicitações de geração de imagens feitas pelos usuários.';
$string['privacy:metadata:ai_action_generate_image:aspectratio'] = 'A proporção das imagens geradas.';
$string['privacy:metadata:ai_action_generate_image:numberimages'] = 'O número de imagens geradas.';
$string['privacy:metadata:ai_action_generate_image:prompt'] = 'O prompt para o pedido de geração de imagem.';
$string['privacy:metadata:ai_action_generate_image:quality'] = 'A qualidade das imagens geradas.';
$string['privacy:metadata:ai_action_generate_image:revisedprompt'] = 'O prompt revisado das imagens geradas.';
$string['privacy:metadata:ai_action_generate_image:sourceurl'] = 'A URL de origem das imagens geradas.';
$string['privacy:metadata:ai_action_generate_image:style'] = 'O estilo das imagens geradas.';
$string['privacy:metadata:ai_action_generate_text'] = 'Uma tabela que armazena as solicitações de geração de texto feitas pelos usuários.';
$string['privacy:metadata:ai_action_generate_text:completiontoken'] = 'Os tokens de conclusão usados para gerar o texto.';
$string['privacy:metadata:ai_action_generate_text:fingerprint'] = 'O hash único representando o estado/versão do modelo e conteúdo.';
$string['privacy:metadata:ai_action_generate_text:generatedcontent'] = 'O texto real gerado pelo modelo de IA com base no prompt de entrada.';
$string['privacy:metadata:ai_action_generate_text:prompt'] = 'O prompt para o pedido de geração de texto.';
$string['privacy:metadata:ai_action_generate_text:prompttokens'] = 'Os tokens de prompt usados para gerar o texto.';
$string['privacy:metadata:ai_action_generate_text:responseid'] = 'O ID da resposta.';
$string['privacy:metadata:ai_action_register'] = 'Uma tabela armazenando os pedidos de ação feitos pelos usuários.';
$string['privacy:metadata:ai_action_register:actionid'] = 'O ID do pedido de ação.';
$string['privacy:metadata:ai_action_register:actionname'] = 'O nome da ação da solicitação.';
$string['privacy:metadata:ai_action_register:model'] = 'O modelo usado para gerar a resposta.';
$string['privacy:metadata:ai_action_register:provider'] = 'O nome do provedor que processou a solicitação.';
$string['privacy:metadata:ai_action_register:success'] = 'O estado da solicitação de ação.';
$string['privacy:metadata:ai_action_register:timecompleted'] = 'O horário de conclusão da solicitação.';
$string['privacy:metadata:ai_action_register:timecreated'] = 'O horário de criação da solicitação.';
$string['privacy:metadata:ai_action_register:userid'] = 'O ID do usuário que fez a solicitação.';
$string['privacy:metadata:ai_action_summarise_text'] = 'Uma tabela que armazena as solicitações de resumo de texto feitas pelos usuários.';
$string['privacy:metadata:ai_action_summarise_text:completiontoken'] = 'Os tokens de conclusão usados para resumir o texto.';
$string['privacy:metadata:ai_action_summarise_text:fingerprint'] = 'O hash único que representa o estado/versão do modelo e do conteúdo.';
$string['privacy:metadata:ai_action_summarise_text:generatedcontent'] = 'O texto real gerado pelo modelo de IA com base no prompt de entrada.';
$string['privacy:metadata:ai_action_summarise_text:prompt'] = 'O prompt para a solicitação de resumo de texto.';
$string['privacy:metadata:ai_action_summarise_text:prompttokens'] = 'Os tokens do prompt usados para resumir o texto.';
$string['privacy:metadata:ai_action_summarise_text:responseid'] = 'O ID da resposta.';
$string['privacy:metadata:ai_policy_register'] = 'Uma tabela que armazena o status de aceitação da política de IA para cada usuário.';
$string['privacy:metadata:ai_policy_register:contextid'] = 'O ID do contexto cujos dados foram salvos.';
$string['privacy:metadata:ai_policy_register:timeaccepted'] = 'O momento em que o usuário aceitou a política de IA.';
$string['privacy:metadata:ai_policy_register:userid'] = 'O ID do usuário cujos dados foram salvos.';
$string['prompttokens'] = 'Tokens de prompt';
$string['prompttokens_help'] = 'Os tokens do prompt são as unidades de texto individuais que compõem a entrada enviada para um modelo de IA. Entradas mais longas usam mais tokens, o que geralmente leva a custos mais altos.';
$string['provider'] = 'Provedor';
$string['provideractionsettings'] = 'Ações do provedor';
$string['provideractionsettings_desc'] = 'Escolha e configure as ações que o {$a} pode executar no seu site.';
$string['providerinstanceactionupdated'] = '{$a} configurações de ação atualizadas';
$string['providerinstancecreated'] = 'Instância {$a} criada do Provedor de IA';
$string['providerinstancedelete'] = 'Excluir instância do Provedor de IA';
$string['providerinstancedeleteconfirm'] = 'Tem certeza que você quer excluir a instância do Provedor de IA: "{$a->name} ({$a->provider})" ?';
$string['providerinstancedeleted'] = 'Instância {$a} do Provedor de IA excluída';
$string['providerinstancedeletefailed'] = 'Não é possível excluir a instância {$a} do Provedor de IA. O provedor está em uso ou há um problema no banco de dados. Verifique se o privado está ativo ou entre em contato com o administrador do banco de dados para obter ajuda.';
$string['providerinstancedisablefailed'] = 'Não é possível desabilitar a instância do AI Provider. O provedor está em uso ou há um problema no banco de dados. Verifique se o provedor está ativo ou entre em contato com o administrador do banco de dados para obter ajuda.';
$string['providerinstanceupdated'] = 'Instância {$a} do Provedor de IA atualizada';
$string['providermoveddown'] = '{$a} movido para baixo.';
$string['providermovedup'] = '{$a} movido para cima.';
$string['providername'] = 'Nome da instância';
$string['providers'] = 'Provedores';
$string['providersettings'] = 'Configurações';
$string['providertype'] = 'Escolha o plugin do provedor de IA';
$string['timegenerated'] = 'Tempo que foi gerado';
$string['unknownvalue'] = '—';
$string['userpolicy'] = '<h4><strong>Bem-vindo ao novo recurso de IA!</strong></h4>
<p>Este recurso de Inteligência Artificial (IA) é baseado exclusivamente em Modelos de Linguagem de Grande Escala (LLM) externos para melhorar sua experiência de ensino e aprendizagem. Antes de começar a usar esses serviços de IA, leia esta política de uso.</p>
<h4><strong>Precisão do conteúdo gerado por IA</strong></h4>
<p>A IA pode fornecer sugestões e informações úteis, mas sua precisão pode variar. Você sempre deve verificar as informações fornecidas para garantir que são precisas, completas e adequadas à sua situação específica.</p>
<h4><strong>Como seus dados são processados</strong></h4>
<p>Este recurso de IA usa Modelos de Linguagem de Grande Escala (LLM) externos. Se você usar este recurso, qualquer informação ou dado pessoal que você compartilhar será tratado de acordo com a política de privacidade desses LLMs. Recomendamos que você leia a política de privacidade deles para entender como eles tratarão seus dados. Além disso, um registro de suas interações com os recursos de IA pode ser salvo neste site.</p>
<p>Se você tiver dúvidas sobre como seus dados são processados, entre em contato com seus professores ou com a organização de ensino.</p>
<p>Ao continuar, você reconhece que entende e concorda com esta política.</p>';
$string['userratelimit'] = 'Número máximo de solicitações por usuário';
$string['userratelimit_help'] = 'O número de solicitações permitidas por hora, por usuário.';
