<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'glossary', language 'uk', version '5.1'.
 *
 * @package     glossary
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addcategory'] = 'Додати категорію';
$string['addcomment'] = 'Додати коментар';
$string['addentry'] = 'Додати новий запис';
$string['addingcomment'] = 'Додати коментар';
$string['addsingleentry'] = 'Додати запис';
$string['alias'] = 'Ключове слово';
$string['aliases'] = 'Ключові слова';
$string['aliases_help'] = 'Кожен запис глосарія може мати набір ключових слів (синонімів). Якщо запис має автозв’язування, тоді всі його ключові слова також будуть автоматично зв’язуватися.

Вказуйте кожне з ключових слів (або виразів) у новому рядку (не розділяйте комами).';
$string['allcategories'] = 'Всі категорії';
$string['allentries'] = 'Все';
$string['allowcomments'] = 'Дозволені коментарі до записів';
$string['allowcomments_help'] = 'Якщо включено, то учасники з правом писати коментарі можуть залишати свої коментарі до записів глосарію.';
$string['allowduplicatedentries'] = 'Дозволити дублювати записи';
$string['allowduplicatedentries_help'] = 'Якщо включено, то на один і той же термін може бути кілька різних записів.';
$string['allowprintview'] = 'Дозволити версію для друку';
$string['allowprintview_help'] = 'Якщо включено, то учасники отримують посилання на сторінку з версією глосарію готовою для друку. Для викладачів таке посилання доступне завжди.';
$string['andmorenewentries'] = 'та ще {$a} нових записів.';
$string['answer'] = 'Відповідь';
$string['approvaldisplayformat'] = 'Схвалення формату показу';
$string['approvaldisplayformat_help'] = 'При схваленні записів глосарію ви можете використовувати інший формат показу';
$string['approve'] = 'Схвалити';
$string['areaattachment'] = 'Прикріплення';
$string['areaentry'] = 'Визначення';
$string['areyousuredelete'] = 'Ви впевнені, що хочете видалити цей запис?';
$string['areyousuredeletecomment'] = 'Ви впевнені, що хочете видалити цей коментар?';
$string['areyousureexport'] = 'Ви впевнені, що хочете експортувати цей запис?';
$string['ascending'] = '(за зростанням)';
$string['attachment'] = 'Вкладення';
$string['attachment_help'] = 'Ви можете також вкласти один або більше файлів до запису глосарію.';
$string['author'] = 'автор';
$string['authorview'] = 'Огляд по авторах';
$string['back'] = 'Назад';
$string['cachedef_concepts'] = 'Концепція прив’язки';
$string['cantinsertcat'] = 'Неможливо вставити категорію';
$string['cantinsertrec'] = 'Неможливо вставити запис';
$string['cantinsertrel'] = 'Неможливо вставити відношення категорія-запис';
$string['casesensitive'] = 'Це слово чутливе до регістру';
$string['casesensitive_help'] = 'Це налаштування визначає, чи важливе співвідношення великих та малих літер у записі глосарія при його автозв’язування.';
$string['cat'] = 'кат.';
$string['categories'] = 'Категорії';
$string['category'] = 'Категорія';
$string['categorydeleted'] = 'Категорія видалена';
$string['categoryview'] = 'Огляд за категоріями';
$string['changeto'] = 'змінити до {$a}';
$string['cnfallowcomments'] = 'Типово дозволити коментування записів';
$string['cnfallowdupentries'] = 'Типово дозволити дублювання записів';
$string['cnfapprovalstatus'] = 'Типово схвалювати записи студентів';
$string['cnfcasesensitive'] = 'Типово слова будуть чутливі до регістру';
$string['cnfdefaulthook'] = 'При першому показі глосарія виділити';
$string['cnfdefaultmode'] = 'При першому показі глосарія використовувати фрейм';
$string['cnffullmatch'] = 'Типово слова повинні будуть автозв\'язуватися тільки цілком';
$string['cnflinkentry'] = 'Типово слова повинні будуть автозв\'язуватись';
$string['cnflinkglossaries'] = 'Типово глосарії повинні бути з включеним автозв\'язуванням';
$string['cnfrelatedview'] = 'Виберіть формат показу запису, який буде використовуватись при автозв\'язуванні';
$string['cnfshowgroup'] = 'Поділяти на групи?';
$string['cnfsortkey'] = 'Типовий ключ сортування.';
$string['cnfsortorder'] = 'Типовий порядок сортування';
$string['cnfstudentcanpost'] = 'Студенти можуть відправляти записи?';
$string['cnftabs'] = 'Виберіть видимі вкладки для цього формату глосарію';
$string['comment'] = 'Коментар';
$string['commentdeleted'] = 'Коментар було вилучено.';
$string['comments'] = 'Коментарі';
$string['commentson'] = 'Коментарі про';
$string['commentupdated'] = 'Коментар було змінено.';
$string['completiondetail:entries'] = 'Зробіть записи: {$a}';
$string['completionentries'] = 'Студент повинен додати записи:';
$string['completionentriesdesc'] = 'Студент повинен створити принаймні {$a} запису/записів';
$string['concept'] = 'Поняття';
$string['concepts'] = 'Поняття';
$string['configenablerssfeeds'] = 'Це налагодження дозволяє включити можливість відображення змін в форматі RSS для глосаріїв. Для кожного глосарія вмикати RSS все ще потрібно буде вручну.';
$string['current'] = 'Відсортовано за {$a}';
$string['currentglossary'] = 'Поточний глосарій';
$string['date'] = 'дата';
$string['dateview'] = 'Огляд за датою';
$string['defaultapproval'] = 'Доданий студентом запис схвалено автоматично';
$string['defaultapproval_help'] = 'Якщо встановлено в "Ні", то записи, додані студентами, вимагають схвалення викладача до того як вони стануть доступними іншим студентам.';
$string['defaulthook'] = 'Типове зв\'язування';
$string['defaultmode'] = 'Типовий режим';
$string['defaultsortkey'] = 'Типовий ключ сортування';
$string['defaultsortorder'] = 'Типовий напрям сортування';
$string['definition'] = 'Визначення';
$string['definitions'] = 'Визначення';
$string['deletecategory'] = 'Видалити категорію';
$string['deleteentry'] = 'Вилучити запис';
$string['deleteentrya'] = 'Видалити запис: {$a}';
$string['deletenotenrolled'] = 'Вилучити записи незареєстрованих користувачів';
$string['deletingcomment'] = 'Вилучення коментаря';
$string['deletingnoneemptycategory'] = 'Вилучення категорії не вилучить записи, які до неї відносилися, - вони просто будуть відмічені як записи, що не відносяться до категорій.';
$string['descending'] = '(за спаданням)';
$string['destination'] = 'Призначення імпортованих записів';
$string['destination_help'] = 'Записи можуть бути імпортованими та доданими або до поточного глосарія, або до нового глосарію, який буде створено на основі інформації в XML файлі.';
$string['disapprove'] = 'Скасувати схвалення';
$string['displayformat'] = 'Формат показу';
$string['displayformat_help'] = 'Є 7 форматів показу:

* Простий, ніби словник - Без показу авторів та долучення показуються у вигляді посилань
* Безперервний, без автора - Записи відображаються один за одним без будь-якого поділу, крім значків редагування
* Повний, з вказівкою автора - Форумний формат показу із зазначенням даних про авторів, долучення показуються як посилання
* Повний, без вказівки автора - Форумний формат показу без зазначення даних про авторів, долучення показуються як посилання
* Енциклопедія - Показується так як "Повний, з вказівкою автора" але картинки долучення показуються в тексті
* Список записів - Записи відображаються у виді списку посилань
* ЧаПи - Список ЧАстих ПИтань, які доповняються відповідями.';
$string['displayformatcontinuous'] = 'Безперервний, без автора';
$string['displayformatdefault'] = 'Типово так само, як формат відображення';
$string['displayformatdictionary'] = 'Простий, ніби словник';
$string['displayformatencyclopedia'] = 'Енциклопедія';
$string['displayformatentrylist'] = 'Список записів';
$string['displayformatfaq'] = 'ЧаПи';
$string['displayformatfullwithauthor'] = 'Повний, з вказівкою автора';
$string['displayformatfullwithoutauthor'] = 'Повний, без вказівки автора';
$string['displayformats'] = 'Формати показу';
$string['displayformatssetup'] = 'Налаштування форматів показу';
$string['duplicatecategory'] = 'Здублювати категорію';
$string['duplicateentry'] = 'Дубльований запис';
$string['editalways'] = 'Редагувати без обмежень';
$string['editalways_help'] = 'Це налаштування визначає чи будуть записи доступні для редагування авторами у будь-який час, чи тільки протягом вказаного часу (зазвичай 30 хв.). Зауважте, що на викладачів це не розповсюджується.';
$string['editcategories'] = 'Редагувати категорії';
$string['editcategory'] = 'Редагувати категорію';
$string['editentry'] = 'Редагувати запис';
$string['editentrya'] = 'Редагувати запис: {$a}';
$string['editingcomment'] = 'Редагування коментаря';
$string['entbypage'] = 'Записів на сторінку';
$string['entries'] = 'Записи';
$string['entrieswithoutcategory'] = 'Записи без категорії';
$string['entry'] = 'Запис';
$string['entryalreadyexist'] = 'Такий запис вже існує';
$string['entryapproved'] = 'Цей запис схвалено';
$string['entrydeleted'] = 'Запис вилучено';
$string['entryexported'] = 'Запис експортовано';
$string['entryishidden'] = '(цей запис зараз заховано)';
$string['entryleveldefaultsettings'] = 'Типові налаштування для запису';
$string['entrylink'] = 'Посилання на вступ: {$a}';
$string['entrynotapproved'] = 'Запис не затверджено';
$string['entrysaved'] = 'Запис збережено';
$string['entryupdated'] = 'Запис оновлено';
$string['entryusedynalink'] = 'Цей запис повинен автоматично зв\'язуватись';
$string['entryusedynalink_help'] = 'Якщо глосарій рівня сайту включено адміністратором на автозв’язування та встановлено цей прапорець, запис буде автоматично зв’язуватися зі словами або фразами по всьому курсу.';
$string['errcannoteditothers'] = 'Ви не можете редагувати записи інших.';
$string['errconceptalreadyexists'] = 'Цей термін вже існує. Дублювати записи в глосарії не дозволено.';
$string['errdeltimeexpired'] = 'Ви не можете це вилучити. Закінчився час!';
$string['erredittimeexpired'] = 'Час для редагування запису закінчився.';
$string['errorparsingxml'] = 'Виникла помилка в процесі розбору файлу. Впевніться, що використано правильний XML синтаксис.';
$string['errreservedkeywords'] = 'Одне або кілька ключових слів містять спеціальний символ, який не можна використовувати.';
$string['eventcategorycreated'] = 'Створено категорію';
$string['eventcategorydeleted'] = 'Вилучено категорію';
$string['eventcategoryupdated'] = 'Оновлено категорію';
$string['evententryapproved'] = 'Схвалено запис';
$string['evententrycreated'] = 'Створено запис';
$string['evententrydeleted'] = 'Вилучено запис';
$string['evententrydisapproved'] = 'Відхилено запис';
$string['evententryupdated'] = 'Оновлено запис';
$string['evententryviewed'] = 'Переглянуто запис';
$string['explainaddentry'] = 'Додати новий запис.<br/> Поняття і визначення - поля обов’язкові.';
$string['explainall'] = 'Показати всі записи на одній сторінці';
$string['explainalphabet'] = 'Огляд глосарія за абеткою';
$string['explainexport'] = 'Файл був створений. <br/> Завантажте та збережіть його. Ви можете імпортувати його куди завгодно, в цьому або іншому курсі.';
$string['explainimport'] = 'Вкажіть файл для імпорту та визначте інші параметри.<br/> Потім натисніть <B>Зберегти</B> і перевірте результат.';
$string['explainspecial'] = 'Покажіть записи, які не починаються з літери';
$string['export'] = 'Експорт';
$string['exportedentry'] = 'Експортований запис';
$string['exportentries'] = 'Експорт записів';
$string['exportentriestoxml'] = 'Експорт записів до XML-файлу';
$string['exportfile'] = 'Експорт записів у файл';
$string['exportglossary'] = 'Експорт глосарію';
$string['exporttomainglossary'] = 'Експортувати в головний глосарій';
$string['filetoimport'] = 'Файл для імпорту';
$string['filetoimport_help'] = 'Знайдіть і виберіть файл XML на вашому комп\'ютері, який містить записи для імпорту.';
$string['fillfields'] = 'Поняття та визначення - поля обов’язкові.';
$string['filtername'] = 'Автозв’язування глосарію';
$string['fullmatch'] = 'Визначати відповідність тільки повним словам';
$string['fullmatch_help'] = 'Це налаштування буде визначати, що тільки цілі слова будуть зв’язуватися посиланням з термінами, наприклад, термін глосарія "форма" не створить зв’язок в середині слова "форматування".';
$string['glossary:addinstance'] = 'Додавати нові глосарії';
$string['glossary:approve'] = 'Схвалювати не схвалені записи';
$string['glossary:comment'] = 'Додавати коментарі';
$string['glossary:export'] = 'Експортувати записи';
$string['glossary:exportentry'] = 'Експортувати один запис';
$string['glossary:exportownentry'] = 'Експортувати один ваш запис';
$string['glossary:import'] = 'Імпортувати записи';
$string['glossary:managecategories'] = 'Управляти категоріями';
$string['glossary:managecomments'] = 'Управляти коментарями';
$string['glossary:manageentries'] = 'Управляти записами';
$string['glossary:rate'] = 'Оцінювати записи';
$string['glossary:view'] = 'Переглядати глосарій';
$string['glossary:viewallratings'] = 'Переглядати всі оцінювання індивідуально';
$string['glossary:viewanyrating'] = 'Переглядати оцінки будь-кого';
$string['glossary:viewrating'] = 'Переглядати оцінки';
$string['glossary:write'] = 'Додавати нові записи';
$string['glossaryleveldefaultsettings'] = 'Типові налаштування для глосарію';
$string['glossarytype'] = 'Тип глосарію';
$string['glossarytype_help'] = 'Основний глосарій — це глосарій, до якого можна імпортувати записи із вторинних глосаріїв. У курсі може бути лише один основний глосарій. Якщо імпорт глосарію не потрібен, усі глосарії курсу можуть бути вторинними.';
$string['guestnoedit'] = 'Гостю не дозволяється редагувати глосарії';
$string['importcategories'] = 'Імпортувати категорії';
$string['importedcategories'] = 'Імпортовані категорії';
$string['importedentries'] = 'Імпортовані записи';
$string['importentries'] = 'Імпорт записів';
$string['importentriesfromxml'] = 'Імпортування записів з XML файлу';
$string['includegroupbreaks'] = 'Включити розриви групи';
$string['indicator:cognitivedepth'] = 'Глосарій: пізнавальний аспект';
$string['indicator:cognitivedepth_help'] = 'Цей показник базується на глибині пізнання, досягнутої студентом під час роботи зі глосарію.';
$string['indicator:cognitivedepthdef'] = 'Словник пізнавальний';
$string['indicator:cognitivedepthdef_help'] = 'Учасник досяг цього відсотка когнітивної активності, запропонованої діяльністю глосарію, протягом цього інтервалу аналізу (Рівні = Немає перегляду, Перегляд, Подання)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Глосарій: соціальний аспект';
$string['indicator:socialbreadth_help'] = 'Цей показник ґрунтується на соціальному розширенні, досягнутому студентом у глосарії.';
$string['indicator:socialbreadthdef'] = 'Словник соц';
$string['indicator:socialbreadthdef_help'] = 'Учасник досяг цього відсотка соціальної залученості, запропонованої діяльністю глосарію, протягом цього інтервалу аналізу (Рівні = Без участі, лише учасник)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['isglobal'] = 'Цей глосарій глобальний?';
$string['isglobal_help'] = 'Глобальний глосарій має записи пов’язані зі всім сайтом. Тільки адміністратори можуть призначати глосарії як глобальні.';
$string['letter'] = 'буква';
$string['linkcategory'] = 'Автозв\'язувати ім\'я цієї категорії';
$string['linkcategory_help'] = 'Якщо для глосарія включено авто-зв’язування та встановлений цей прапорець, то назва категорії буде автоматично зв’язуватися у всіх ресурсах курсу. Коли учасники будуть переходити за таким посиланням, вони будуть попадати на сторінку глосарію "Перегляд за категоріями".';
$string['linking'] = 'Автозв\'язування';
$string['mainglossary'] = 'Головний глосарій';
$string['maxtimehaspassed'] = 'Вибачте, але максимальний час для редагування цього коментаря ({$a}) вичерпано';
$string['modulename'] = 'Глосарій';
$string['modulename_help'] = '<p>Діяльність <b>Глосарій</b> дозволяє учасникам створювати та підтримувати список визначень, подібний до словника або збирати та систематизувати ресурси та інформацію.</p>
<p>Викладач може дозволити прикріплювати різні файли до записів глосарію. Передбачено пошук та перегляд записів за алфавітом, категорією, датою або автором. Записи можуть бути схвалені за замовчуванням, або вони повинні бути схвалені викладачем, перш ніж будуть доступні для перегляду.</p>
<p>Якщо в глосарії увімкнена функція автозв\'язування, запис буде автоматично пов\'язаний в курсі зі словом і/або фразою, в яких зустрічається цей термін, у вигляді гіперпосилання.</p>
<p>Викладач може дозволити коментарі для запису. Записи можуть бути оцінені викладачами або студентами (незалежне оцінювання). Бали можуть бути об\'єднані, щоб сформувати підсумкову оцінку, яка записується до журналу оцінок.</p>
<p><b>Глосарії</b> мають багато застосувань, таких як:</p>
<ul>
  <li>Спільний банк ключових термінів</li>
  <li>Простір для знайомства, де нові студенти додають своє ім\'я та персональні дані</li>
  <li>Ресурс для обміну практичним досвідом у вигляді корисних порад</li>
  <li>В якості репозиторію для зберігання корисного відео, зображень та звукових файлів</li>
  <li>Ресурс для перевірки фактів, які потребують запам\'ятовування</li>
</ul>';
$string['modulename_link'] = 'mod/glossary/view';
$string['modulenameplural'] = 'Глосарії';
$string['newentries'] = 'Нові записи глосарія';
$string['newglossary'] = 'Новий глосарій';
$string['newglossarycreated'] = 'Новий глосарій створено';
$string['newglossaryentries'] = 'Нові записи глосарію:';
$string['nocomment'] = 'Коментарів не знайдено';
$string['nocomments'] = '(Коментарів для цього запису не знайдено)';
$string['noconceptfound'] = 'Не знайдено понять і визначень';
$string['noentries'] = 'В цій секції записів не знайдено';
$string['noentry'] = 'Записів не знайдено';
$string['nopermissiontodelcomment'] = 'Ви не можете видаляти коментарі інших!';
$string['nopermissiontodelinglossary'] = 'Ви не можете коментувати у цьому глосарії!';
$string['nopermissiontoviewresult'] = 'Ви можете тільки переглядати результати для ваших власних записів';
$string['notapproved'] = 'запис ще не схвалено.';
$string['notcategorised'] = 'Поза категоріями';
$string['numberofentries'] = 'Кількість записів';
$string['onebyline'] = '(один на рядок)';
$string['page-mod-glossary-edit'] = 'Сторінка додавання/редагування запису глосарія';
$string['page-mod-glossary-view'] = 'Сторінка редагування глосарія';
$string['page-mod-glossary-x'] = 'Будь-яка сторінка модуля Глосарій';
$string['pendingapproval'] = 'Очікує підтвердження';
$string['pluginadministration'] = 'Керування глосарієм';
$string['pluginname'] = 'Глосарій';
$string['popupformat'] = 'Виринаючий формат';
$string['print'] = 'Друкувати';
$string['printerfriendly'] = 'Версія для друку';
$string['printviewnotallowed'] = 'Не дозволено версію для друку';
$string['privacy'] = 'Конфіденційність результатів';
$string['privacy:metadata:core_comments'] = 'Коментарі, зроблені до визначень глосарію, зберігаються за допомогою системи core_comment';
$string['privacy:metadata:core_files'] = 'Файли, пов’язані з визначеннями глосарію, зберігаються за допомогою системи core_files';
$string['privacy:metadata:core_rating'] = 'Оцінки, додані до статей глосарію, зберігаються за допомогою системи core_rating';
$string['privacy:metadata:core_tag'] = 'Теги, додані до визначень глосарію, зберігаються за допомогою системи core_tag';
$string['privacy:metadata:glossary_entries'] = 'Інформація про записи користувача для певної діяльності глосарію';
$string['privacy:metadata:glossary_entries:attachment'] = 'Вкладення запису, яке додав користувач';
$string['privacy:metadata:glossary_entries:concept'] = 'Концепцію запису додав користувач';
$string['privacy:metadata:glossary_entries:definition'] = 'Визначення запису, який додав користувач';
$string['privacy:metadata:glossary_entries:glossaryid'] = 'Ідентифікатор дії глосарію';
$string['privacy:metadata:glossary_entries:timemodified'] = 'Позначка часу, яка вказує, коли користувач змінив запис глосарію';
$string['privacy:metadata:glossary_entries:userid'] = 'Ідентифікатор користувача, який додає цей запис глосарію';
$string['question'] = 'Запитання';
$string['rejectedentries'] = 'Відхилені записи';
$string['rejectionrpt'] = 'Звіт про відхилені записи';
$string['removeallglossarytags'] = 'Видаліть усі теги глосарію';
$string['resetglossaries'] = 'Вилучити записи від';
$string['resetglossariesall'] = 'Вилучити записи зі всіх глосаріїв';
$string['rssarticles'] = 'Кількість останніх записів у RSS стрічці';
$string['rssarticles_help'] = 'Це налаштування визначає кількість останніх записів глосарію, які будуть включатися до RSS стрічки. Нормальне значення - від 5 до 20.';
$string['rssfeed'] = 'RSS-канал';
$string['rsssubscriberss'] = 'Показувати зміни в RRS форматі для \'{$a}\' концепцій';
$string['rsstype'] = 'RSS стрічка для цієї діяльності';
$string['rsstype_help'] = 'Щоб включити RSS стрічку для цієї діяльності, потрібно тип з автором або без автора включити до стрічки.';
$string['search:activity'] = 'Глосарій - інформація про діяльність';
$string['search:entry'] = 'Глосарій - запити';
$string['searchindefinition'] = 'Повнотекстовий пошук';
$string['secondaryglossary'] = 'Вторинний глосарій';
$string['showall'] = 'Показувати посилання \'Усі\'';
$string['showall_help'] = 'Якщо включено, то учасники можуть переглядати всі записи за раз.';
$string['showalphabet'] = 'Показувати алфавіт';
$string['showalphabet_help'] = 'Якщо включено, то користувачі можуть переглядати записи глосарію з першими літерами абетки.';
$string['showspecial'] = 'Показувати посилання "Спеціальні"';
$string['showspecial_help'] = 'Якщо включено, то користувачі можуть переглядати терміни глосарію, які починаються зі спеціальних символів, наприклад, @ та #.';
$string['sortby'] = 'Сортувати за';
$string['sortbycreation'] = 'За датою створення';
$string['sortbylastupdate'] = 'За датою останнього оновлення';
$string['sortchronogically'] = 'Хронологічне сортування';
$string['special'] = 'Спеціальні';
$string['standardview'] = 'Огляд за алфавітом';
$string['studentcanpost'] = 'Студенти можуть додавати записи';
$string['tagarea_glossary_entries'] = 'Записи глосарію';
$string['tagsdeleted'] = 'Теги глосарію видалено';
$string['totalentries'] = 'Всього записів';
$string['usedynalink'] = 'Автоматичне зв\'язування записів глосарію';
$string['usedynalink_help'] = 'Якщо адміністратор дозволив авто-зв’язування в глосарії рівня сайту, а також включено це налаштування, форма "Додавання нового запису" включатиме опцію автоматичного зв’язування запису зі словами та фразами, які з’являтимуться на всьому курсі.';
$string['visibletabs'] = 'Видимі вкладки';
$string['warningstudentcapost'] = '(Доступно тільки, якщо глосарій не головний)';
$string['withauthor'] = 'Поняття з автором';
$string['withoutauthor'] = 'Поняття без автора';
$string['writtenby'] = 'автор';
$string['youarenottheauthor'] = 'Ви - не автор цього коментаря. Ви не можете його редагувати.';
