<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_almondb', language 'es_mx', version '5.1'.
 *
 * @package     theme_almondb
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['advancedsettings'] = 'Configuraciones avanzadas';
$string['almondbpage'] = 'Páginas de Información';
$string['almondbpagecaption'] = 'Subtítulo de página';
$string['almondbpagecaptiondesc'] = 'Añadir un subtítulo para su página';
$string['almondbpagecaptionsimple'] = 'Subtítulo de página';
$string['almondbpagecaptionsimpledesc'] = 'Añadir un subtítulo para su página';
$string['almondbpagecount'] = 'Número de páginas';
$string['almondbpagecountdesc'] = 'Seleccione cuantas páginas quiere añadir y <strong>después elija GUARDAR</strong> para cargar los campos para entrada de datos..';
$string['almondbpagecountsimple'] = 'Número de páginas';
$string['almondbpagecountsimpledesc'] = 'Seleccione cuantas páginas quiere añadir y <strong>después elija GUARDAR</strong> para cargar los campos para entrada de datos..';
$string['almondbpagecss'] = 'CSS de página';
$string['almondbpagecssdesc'] = 'Añadir un CSS para su página';
$string['almondbpagecsslink'] = 'Enlace a CSS de página';
$string['almondbpagecsslinkdesc'] = 'Añadir un enlace a CSS para su página,
            Ejemplo : "https://www.ejemplo.com/abc.css"';
$string['almondbpagedesign'] = 'Diseño de página';
$string['almondbpagedesigndesc'] = 'Seleccionar el diseño de página que desea añadir. Usted puede crear rápidamente sus páginas usando un diseño simple.
En un diseño simple, use solamente la parte del subtítulo y la imagen.';
$string['almondbpageenabled'] = 'Habilitar almondbpage';
$string['almondbpageenableddesc'] = 'Habilitar un almondbpage en la parte superior de su página de inicio';
$string['almondbpageenabledsimple'] = 'Habilitar almondbpage';
$string['almondbpageenabledsimpledesc'] = 'Habilitar un almondbpage en la parte superior de su página de inicio';
$string['almondbpageend'] = '--*/*--';
$string['almondbpageenddesc'] = '';
$string['almondbpagefooter'] = 'Pie de página';
$string['almondbpagefooterdesc'] = 'Añadir pie de página a página de información';
$string['almondbpagefootersimple'] = 'Pie de página';
$string['almondbpagefootersimpledesc'] = 'Añadir pie de página a página de información';
$string['almondbpageheader'] = 'Encabezado de página';
$string['almondbpageheaderdesc'] = 'Añadir encabezado de página a página de información';
$string['almondbpageheadersimple'] = 'Encabezado de página';
$string['almondbpageheadersimpledesc'] = 'Añadir encabezado de página a página de información';
$string['almondbpageheading'] = ': Configuraciones Avanzadas de Página';
$string['almondbpageheadingdesc'] = 'Esto crea hasta seis páginas de información para que usted promocione elementos importantes de su sitio.';
$string['almondbpageheadingsimple'] = '! Configuraciones de Página Simple';
$string['almondbpageheadingsimpledesc'] = 'Esto crea hasta seis páginas de información para que usted promocione elementos importantes de su sitio.';
$string['almondbpageimage'] = 'Imagen de página';
$string['almondbpageimagedesc'] = 'Añadir una imagen para su página';
$string['almondbpageimagesimple'] = 'Imagen de página';
$string['almondbpageimagesimpledesc'] = 'Añadir una imagen para su página';
$string['almondbpageimglink'] = 'Enlace a carpeta de imagen de página';
$string['almondbpageimglinkdesc'] = 'Añada un enlace a carpeta IMG para su página, Copie sus imágenes que use en HTML en esta carpeta.
           Si usted llena el campo de la carpeta de imagen, no escriba la ruta hacia la imagen en HTML.
            solamente escríbala como demo-1.png (o jpg).
            Ejemplo: http://www.ejemplo.com/img/ , (img src= demo-1.jpg)';
$string['almondbpageimgpositionsimple'] = 'Posición de imagen de página';
$string['almondbpageimgpositionsimpledesc'] = 'Donde estará localizada la imagen subida en la página.';
$string['almondbpagenavbar'] = 'Barra de Navegación de página';
$string['almondbpagenavbardesc'] = 'Añadir Barra de Navegación a página de información';
$string['almondbpageno'] = '! Página-{$a->almondbpage}';
$string['almondbpagenodesc'] = 'Ingrese las configuraciones para página {$a->almondbpage}. <b><i>ENLACE DE PÁGINA: www.susitio/local/almondbpage/?id=s{$a->almondbpage}</i></b>';
$string['almondbpagenosimple'] = '! Página-{$a->almondbpage}';
$string['almondbpagenosimpledesc'] = 'Ingrese las configuraciones para página {$a->almondbpage}. <b><i>ENLACE DE PÁGINA: www.susitio/local/almondbpage/?id=s{$a->almondbpage}</i></b>';
$string['almondbpagenotfound'] = '¡Página no encontrada; por favor compruebe la URL!';
$string['almondbpagestart'] = 'Configuraciones de Página de Información';
$string['almondbpagestartdesc'] = '';
$string['almondbpagetitle'] = 'Título de página';
$string['almondbpagetitledesc'] = 'Añadir el título de la página';
$string['almondbpagetitlesimple'] = 'Título de página';
$string['almondbpagetitlesimpledesc'] = 'Añadir el título de la página';
$string['backcolor'] = 'Color Fondo';
$string['backcolor_desc'] = 'Color del fondo';
$string['backgroundimage'] = 'Imagen del fondo';
$string['backgroundimage_desc'] = 'La imagen a mostrar como un fondo del sitio. La imagen del fondo que usted suba sobre-escribirá la imagen de fondo en los archivos de pre-configuración de sus tema.';
$string['block01button'] = 'Bloque 1 botón';
$string['block01buttondesc'] = 'Añadir un botón para su bloque 1';
$string['block01buttonlink'] = 'Bloque 1 URL';
$string['block01buttonlinkdesc'] = 'Añadir una URL para su bloque 1';
$string['block01caption'] = 'Bloque 1 subtítulo';
$string['block01captiondefault'] = '<h2 class="white">Temas Premium Destacados</h2><br>
<p class="white">Los temas son construidos sin trastornar el diseño de Moodle, por lo que harán su trabajo más fácil. Vea algunas de las principales características de los Temas.</p>';
$string['block01captiondesc'] = 'Añadir un subtítulo para su bloque 1';
$string['block01color'] = 'Bloque 1 color del fondo';
$string['block01colordesc'] = 'Añadir un Color del fondo para su bloque 1';
$string['block01enabled'] = 'Habilitar bloque 1';
$string['block01enableddesc'] = 'Habilitar o deshabilitar el bloque 1 en su página de inicio';
$string['block01info'] = ': Bloque-1 CAJA del TÍTULO';
$string['block01infodesc'] = 'CAJA del TÍTULO - Ingresar las configuraciones para el bloque 1';
$string['block02button'] = 'Botón del bloque {$a->block}';
$string['block02buttondesc'] = 'Añadir un botón para su bloque';
$string['block02buttonlink'] = 'URL de bloque {$a->block}';
$string['block02buttonlinkdesc'] = 'Añadir una URL para su bloque';
$string['block02caption'] = 'Subtítulo bloque {$a->block}';
$string['block02captiondefault'] = 'Disfrute de nuestros cursos gratuitos en línea,
dondequiera que esté y cuando quiera que desee. Acceda a contenidos del curso en teléfono móvil, tableta o PC de escritorio';
$string['block02captiondesc'] = 'Añadir un subtítulo para su bloque';
$string['block02count'] = 'Bloques 2 Número';
$string['block02countdesc'] = 'Seleccionar el número de cajas y presionar el botón para GUARDAR cambios';
$string['block02enabled'] = 'Habilitar bloque 2';
$string['block02enableddesc'] = 'Habilitar o deshabilitar el bloque 2 en su página de inicio';
$string['block02icon'] = 'Bloque ícono {$a->block}';
$string['block02icondefault'] = '';
$string['block02icondefault1'] = 'core:i/report';
$string['block02icondefault2'] = 'core:i/settings';
$string['block02icondefault3'] = 'core:i/stats';
$string['block02icondefault4'] = 'core:i/notifications';
$string['block02icondesc'] = '<a href="https://fontawesome.com/v4.7/icons/" target="_blank">Clic para ver los íconos</a>';
$string['block02imgdesc'] = 'Añadir una imagen para su bloque';
$string['block02info'] = '! Bloque-2 CAJA de ÍCONO';
$string['block02infodesc'] = 'CAJA de ÍCONO - Ingresar las configuraciones para bloque 2';
$string['block02title'] = 'Bloque título {$a->block}';
$string['block02titledefault'] = 'Asesores Superiores de Inversión';
$string['block02titledesc'] = 'Añadir un  título para su bloque';
$string['block03caption'] = 'Bloque 3 subtítulo {$a->block}';
$string['block03captiondefault'] = 'Vestibulum non diam quis nisl dignissim posuere a vulputate urna nunc velit';
$string['block03captiondesc'] = 'Añadir un subtítulo para su bloque 3';
$string['block03design'] = 'Diseño del bloque 3';
$string['block03designdesc'] = 'Seleccionar el diseño del bloque 3 que desea añadir';
$string['block03enabled'] = 'Habilitar bloque 3';
$string['block03enableddesc'] = 'Habilitar o deshabilitar el bloque 3 en su página de inicio';
$string['block03header'] = 'Bloque 3 encabezado';
$string['block03headerdefault'] = 'SOMOS TEMAS ALMOND';
$string['block03headerdesc'] = 'Bloque 3 encabezado';
$string['block03icon'] = 'Bloque 3 ícono {$a->block}';
$string['block03icondefault'] = 'core:i/categoryevent';
$string['block03icondefault1'] = 'core:t/download';
$string['block03icondefault2'] = 'core:a/setting';
$string['block03icondefault3'] = 'core:docs';
$string['block03icondefault4'] = 'core:i/duration';
$string['block03icondefault5'] = 'core:i/checked';
$string['block03icondefault6'] = 'core:e/visual_aid';
$string['block03icondesc'] = '<a href="https://fontawesome.com/v4.7/icons/" target="_blank">Clic  para ver íconos</a>';
$string['block03info'] = '! Bloque-3 CARACTERÍSTICAS';
$string['block03infodesc'] = 'CARACTERÍSTICAS - Ingresar las configuraciones para bloque 3';
$string['block03link'] = 'Bloque 3 URL {$a->block}';
$string['block03linkdesc'] = 'Añadir una URL para su bloque 3';
$string['block03title'] = 'Bloque 3 título {$a->block}';
$string['block03titledefault'] = 'Diseño Responsivo';
$string['block03titledesc'] = 'Añadir un título para su bloque 3';
$string['block04button'] = 'Bloque 4 texto del botón';
$string['block04buttondefault'] = 'Ver todos los cursos';
$string['block04buttondesc'] = 'Bloque 4 texto del botón';
$string['block04buttonlink'] = 'Bloque 4 enlace del botón';
$string['block04buttonlinkdefault'] = 'course/index.php';
$string['block04buttonlinkdesc'] = 'Bloque 4 enlace del botón';
$string['block04caption'] = 'Bloque 4 subtítulo {$a->block}';
$string['block04captiondesc'] = 'Añadir un subtítulo para su bloque 4';
$string['block04design'] = 'Diseño del bloque 4';
$string['block04designdesc'] = 'Seleccionar el diseño del bloque 4 que desea añadir';
$string['block04enabled'] = 'Habilitar bloque 4';
$string['block04enableddesc'] = 'Habilitar o deshabilitar el bloque 4 en su página de inicio';
$string['block04header'] = 'Bloque 4 encabezado';
$string['block04headerdefault'] = 'PROYECTOS MÁS RECIENTES';
$string['block04headerdesc'] = 'Bloque 4 texto del botón';
$string['block04imgdesc'] = 'Añadir una imagen para su bloque';
$string['block04info'] = '! Bloque-4 LO ÚLTIMO';
$string['block04infodesc'] = 'Lo ÚLTIMO - Ingresar las configuraciones para bloque 4';
$string['block04link'] = 'Bloque 4 URL {$a->block}';
$string['block04linkdesc'] = 'Añadir una URL para su bloque 4';
$string['block04title'] = 'Bloque 4 título {$a->block}';
$string['block04titledesc'] = 'Añadir un título para su bloque 4';
$string['block05caption'] = 'Bloque 5 subtítulo {$a->block}';
$string['block05captiondesc'] = 'Añadir un subtítulo para su bloque 5';
$string['block05design'] = 'Diseño del bloque 5';
$string['block05designdesc'] = 'Seleccionar el diseño del bloque 5 que desea añadir';
$string['block05enabled'] = 'Habilitar bloque 5';
$string['block05enableddesc'] = 'Habilitar o deshabilitar el bloque 5 en su página de inicio';
$string['block05header'] = 'Bloque 5 encabezado';
$string['block05headerdefault'] = 'PORQUÉ ELEGIRNOS A NOSOTROS';
$string['block05headerdesc'] = 'Bloque 5 encabezado';
$string['block05icon'] = 'Bloque 5 ícono {$a->block}';
$string['block05icondefault'] = 'core:i/categoryevent';
$string['block05icondefault1'] = 'core:i/settings';
$string['block05icondefault2'] = 'core:i/hide';
$string['block05icondefault3'] = 'core:i/bullhorn';
$string['block05icondesc'] = '<a href="https://fontawesome.com/v4.7/icons/" target="_blank">Clic para ver íconos</a>';
$string['block05imgdesc'] = 'Añadir una imagen para su bloque';
$string['block05info'] = '! Bloque-5 PORQUÉ NOSOTROS';
$string['block05infodesc'] = 'PORQUÉ NOSOTROS - Ingresar las configuraciones para bloque 5';
$string['block05link'] = 'Bloque 5 URL {$a->block}';
$string['block05linkdesc'] = 'Añadir una URL para su bloque 5';
$string['block05title'] = 'Bloque 5 título {$a->block}';
$string['block05titledesc'] = 'Añadir un título para su bloque 6';
$string['block06button'] = 'Bloque 6 URL';
$string['block06buttondesc'] = 'Añadir una URL para su bloque 6';
$string['block06buttonlink'] = 'Bloque 6 URL';
$string['block06buttonlinkdesc'] = 'Añadir una URL para su bloque 6';
$string['block06caption'] = 'Bloque 6 subtítulo';
$string['block06captiondefault'] = 'Añadir un subtítulo para su bloque 6';
$string['block06captiondesc'] = 'Añadir un subtítulo para su bloque 6';
$string['block06color'] = 'Bloque 6 color del fondo';
$string['block06colordesc'] = 'Añadir un color del fondo del bloque 6';
$string['block06design'] = 'Diseño del bloque 6';
$string['block06designdesc'] = 'Seleccionar el diseño del bloque 6 que desea añadir';
$string['block06enabled'] = 'Habilitar bloque 6';
$string['block06enableddesc'] = 'Habilitar o deshabilitar el bloque 6 en su página de inicio';
$string['block06header'] = 'Bloque 6 encabezado';
$string['block06headerdefault'] = 'TRABAJANDO CON NOSOTROS';
$string['block06headerdesc'] = 'Bloque 6 encabezado';
$string['block06imgdesc'] = 'Añadir una imagen para su bloque';
$string['block06info'] = '! Bloque-6 TRABAJANDO CON NOSOTROS';
$string['block06infodesc'] = 'TRABAJANDO CON NOSOTROS - Ingrese las configuraciones para bloque 6';
$string['block07button'] = 'Bloque 7 URL';
$string['block07buttondesc'] = 'Añadir una URL para su bloque 7';
$string['block07buttonlink'] = 'Bloque 7 URL';
$string['block07buttonlinkdesc'] = 'Añadir una URL para su bloque 7';
$string['block07count'] = 'Bloques 7 número';
$string['block07countdefault'] = '8';
$string['block07countdesc'] = 'Número de cursos a mostrar';
$string['block07design'] = 'Diseño del bloque 7';
$string['block07designdesc'] = 'Seleccionar el diseño del bloque 77 que desea añadir';
$string['block07enabled'] = 'Habilitar bloque 7';
$string['block07enableddesc'] = 'Habilitar o deshabilitar el bloque 7 en su página de inicio';
$string['block07enrol'] = 'Gratuito';
$string['block07header'] = 'Bloque 7 encabezado';
$string['block07headerdefault'] = 'CURSOS DISPONIBLES';
$string['block07headerdesc'] = 'Bloque 7 encabezado';
$string['block07info'] = '! Bloque-7 CURSOS DISPONIBLES';
$string['block07infodesc'] = 'CURSOS DISPONIBLES - ingresar las configuraciones para bloque 7';
$string['block07priceshow'] = 'Mostrar precio de inscripción del curso';
$string['block07priceshowdesc'] = 'Habilitar/deshabilitar precio de inscripción curso';
$string['block07studentrole'] = 'Bloque 7 rol de estudiante';
$string['block07studentroledesc'] = 'Seleccionar rol de estudiante';
$string['block07teacherenabled'] = 'Bloque 7 profesor habilitado';
$string['block07teacherenableddesc'] = '¿Mostrar profesor?';
$string['block07teacherrole'] = 'Bloque 7 rol de profesor';
$string['block07teacherroledesc'] = 'Seleccionar rol de profesor';
$string['block07title'] = 'Bloque 7 título';
$string['block07titledefault'] = 'nombrecorto';
$string['block07titledesc'] = 'Tipo de título de curso';
$string['block07tooltipcategory'] = 'Categoría';
$string['block07tooltipenrolled'] = 'Estudiantes Inscritos';
$string['block07tooltiplastdate'] = 'Fecha de Última Modificación';
$string['block08caption'] = 'Bloque 8 subtítulo';
$string['block08captiondefault'] = 'Continuamos sirviendo con nuestro profesorado distinguido. Conozca a nuestros profesores.';
$string['block08captiondesc'] = 'Bloque 8 subtítulo';
$string['block08count'] = 'Bloques 8 número';
$string['block08countdefault'] = '8';
$string['block08countdesc'] = 'Número de profesores a mostrar';
$string['block08description'] = 'Bloque 8 Descripción';
$string['block08descriptiondesc'] = 'Mostrar descripción de usuario a página.';
$string['block08design'] = 'Diseño del bloque 8';
$string['block08designdesc'] = 'Seleccionar el diseño del bloque 8 que desea añadir';
$string['block08enabled'] = 'Habilitar bloque 8';
$string['block08enableddesc'] = 'Habilitar o deshabilitar el bloque 8 en su página de inicio';
$string['block08header'] = 'Bloque 8 encabezado';
$string['block08headerdefault'] = 'PROFESORES';
$string['block08headerdesc'] = 'Bloque 8 encabezado';
$string['block08info'] = '! Bloque-8 PROFESOR';
$string['block08infodesc'] = 'PROFESORES - Introducir las configuraciones para bloque 8';
$string['block08showrole'] = 'Bloque 8 Mostrar Rol';
$string['block08showroledesc'] = 'Rol de usuario a mostrar en bloque 8';
$string['block08studentrole'] = 'Bloque 8 Rol de Estudiante';
$string['block08studentroledesc'] = 'Rol de estudiante';
$string['block08tooltipcourse'] = 'Número total de cursos del profesor';
$string['block08tooltipstudents'] = 'Número de estudiantes totales del profesor';
$string['block08total'] = 'Bloque 8 Total';
$string['block08totaldesc'] = 'Mostrar número total de cursos y estudiantes';
$string['block09background'] = 'Bloque 9 Fondo';
$string['block09backgrounddesc'] = 'Seleccionar la imagen o color del fondo de caja del bloque 9';
$string['block09boxshadow'] = 'Bloque 9 Sombra de Caja';
$string['block09boxshadowdesc'] = 'Seleccionar la sombra de Caja de Bloque 9 habilitada';
$string['block09caption'] = 'Bloque 9 subtítulo';
$string['block09captiondefault'] = 'Lista de categorías registradas';
$string['block09captiondesc'] = 'Bloque 9 subtítulos';
$string['block09count'] = 'Bloques 9 número';
$string['block09countdefault'] = '8';
$string['block09countdesc'] = 'Número de categorías a mostrar';
$string['block09ctgid'] = 'Bloque 9 ID de categoría';
$string['block09ctgiddesc'] = 'Bloque 9 seleccionar ID de categoría  (ejem:  id = 1  o id = 2 o id = 3 ........), vaciar toda la categoría.';
$string['block09design'] = 'Diseño del bloque 9';
$string['block09designdesc'] = 'Seleccionar el diseño del bloque 9 que desea añadir';
$string['block09enabled'] = 'Habilitar bloque 9';
$string['block09enableddesc'] = 'Habilitar o deshabilitar el bloque 9 en su página de inicio';
$string['block09header'] = 'Bloque 9 Encabezado';
$string['block09headerdefault'] = 'Categorías Disponibles';
$string['block09headerdesc'] = 'Bloque 9 Descripción de Encabezado';
$string['block09info'] = '! Bloque-9 CATEGORÍAS';
$string['block09infodesc'] = 'CATEGORÍAS - Ingresar las configuraciones para bloque 9';
$string['block10caption'] = 'Bloque subtítulo {$a->block}';
$string['block10captiondesc'] = 'Añadir un subtítulo para su bloque';
$string['block10count'] = 'Bloques 10 Número';
$string['block10countdesc'] = 'Seleccionar el número de cajas y presionar el botón para GUARDAR cambios';
$string['block10design'] = 'Diseño del bloque 10';
$string['block10designdesc'] = 'Seleccionar el diseño del bloque 10 que desea añadir';
$string['block10enabled'] = 'Habilitar bloque 10';
$string['block10enableddesc'] = 'Habilitar o deshabilitar el bloque 10 en su página de inicio';
$string['block10header'] = 'Bloque 10 encabezado';
$string['block10headerdefault'] = 'TESTIMONIALES';
$string['block10headerdesc'] = 'Bloque 10 encabezado';
$string['block10imgdesc'] = 'Añadir una imagen para su bloque';
$string['block10info'] = '! Bloque-10 TESTIMONIALES';
$string['block10infodesc'] = 'TESTIMONIALES - Ingresar las configuraciones para bloque 10';
$string['block10job'] = 'Bloque 10 trabajo {$a->block}';
$string['block10jobdesc'] = 'Bloque 10 trabajo';
$string['block10link'] = 'URL de bloque {$a->block}';
$string['block10linkdesc'] = 'Añadir una URL para su bloque';
$string['block10name'] = 'Bloque 10 nombre {$a->block}';
$string['block10namedesc'] = 'Bloque 10 nombre';
$string['block11caption'] = 'Bloque 11 subtítulo';
$string['block11captiondefault'] = 'Bienvenido a publicaciones de BLOG de Almondb.';
$string['block11captiondesc'] = 'Bloque 11 subtítulo';
$string['block11count'] = 'Bloques 11 Número';
$string['block11countdesc'] = 'Seleccionar el número de blogs a mostrar';
$string['block11design'] = 'Diseño del bloque 11';
$string['block11designdesc'] = 'Seleccionar el diseño del bloque 11 que desea añadir';
$string['block11enabled'] = 'Habilitar bloque 11';
$string['block11enableddesc'] = 'Habilitar o deshabilitar el bloque 11 en su página de inicio';
$string['block11header'] = 'Bloque 11 encabezado';
$string['block11headerdefault'] = 'BLOG ALMOND';
$string['block11headerdesc'] = 'Bloque 11 encabezado';
$string['block11info'] = '! BloQUE-11 BLOG PUBLICACIONES';
$string['block11infodesc'] = 'BLOG POST - Ingrese las configuraciones para bloque 11';
$string['block12info'] = '! Bloque-12 Vacío';
$string['block13info'] = '! Bloque-13 Vacío';
$string['block14info'] = '! Bloque-14 Vacío';
$string['block15info'] = '! Bloque-15 Vacío';
$string['block16info'] = '! Bloque-16 Vacío';
$string['block17info'] = '! Bloque-17 Vacío';
$string['block18caption'] = 'Bloque 18 subtítulo';
$string['block18captiondesc'] = 'Bloque 18 subtítulo';
$string['block18css'] = 'Bloque 18 CSS';
$string['block18cssdesc'] = 'Bloque 18 añada un CSS para su bloque';
$string['block18csslink'] = 'Bloque 18 enlace a CSS';
$string['block18csslinkdesc'] = 'Bloque 18 añada un enlace a CSS para su bloque';
$string['block18enabled'] = 'Habilitar bloque 18';
$string['block18enableddesc'] = 'Habilitar o deshabilitar el bloque 18 en su página de inicio';
$string['block18info'] = '! Bloque-18 BLOQUE HTML';
$string['block18infodesc'] = 'BLOQUE HTML - Ingrese las configuraciones para bloque 18';
$string['block18title'] = 'Bloque 18 Título';
$string['block18titledesc'] = 'Seleccionar el diseño del bloque 18 que desea añadir';
$string['block19caption'] = 'Bloque 19 subtítulo';
$string['block19captiondefault'] = 'Es un hecho conocido que un lector será distraído por el contenido que se pueda leer de una página cuando vea su diseño.';
$string['block19captiondesc'] = 'Bloque 19 subtítulo';
$string['block19design'] = 'Diseño del bloque 19';
$string['block19designdesc'] = 'Seleccionar el diseño del bloque 19 que desea añadir';
$string['block19enabled'] = 'Habilitar bloque 19';
$string['block19enableddesc'] = 'Habilitar o deshabilitar el bloque 19 en su página de inicio';
$string['block19header'] = 'Bloque 19 encabezado';
$string['block19headerdefault'] = 'NUESTROS SOCIOS';
$string['block19headerdesc'] = 'Bloque 19 encabezado';
$string['block19headerenabled'] = 'Encabezado habilitar bloque 19';
$string['block19headerenableddesc'] = 'Habilitar/deshabilitar encabezado bloque 19';
$string['block19imgdesc'] = 'Añadir una imagen para su bloque';
$string['block19info'] = '! Block-19 MARCAS';
$string['block19infodesc'] = 'MARCAS - Ingresar las configuraciones para bloque 19';
$string['block19link'] = 'Bloque 19 URL de imagen {$a->block}';
$string['block19linkdesc'] = 'Añadir una URL de imagen para su bloque 19';
$string['block20col1caption'] = 'Bloque 20 col 1 subtítulo';
$string['block20col1captiondefault'] = 'Es un hecho conocido que un lector será distraído por el contenido que se pueda leer de una página cuando vea su diseño.';
$string['block20col1captiondesc'] = 'Bloque 20 col 1 subtítulo';
$string['block20col1header'] = 'Bloque 20 col 1 encabezado';
$string['block20col1headerdesc'] = 'Bloque 20 col 1 encabezado';
$string['block20col2header'] = 'Bloque 20 col 2 encabezado';
$string['block20col2headerdesc'] = 'Bloque 20 col 2 ingresar encabezado';
$string['block20col2link'] = 'Bloque 20 col 2 enlace';
$string['block20col2linkdefault'] = 'Acerca de nosotros|https://themesalmond.com
                                    Nuestra historia|https://moodle.org/support
                                    Términos y condiciones|https://moodle.org/development
                                    Política de Privacidad|http://docs.moodle.org|Moodle Docs
                                    Mapa del sitio|http://docs.moodle.org/en|Documentación en inglés|en
                                    Moodle.com|http://moodle.com/';
$string['block20col2linkdesc'] = 'Bloque 20 col 2 área enlace';
$string['block20col3header'] = 'Bloque 20 col 3 encabezado';
$string['block20col3headerdesc'] = 'Bloque 20 col 3 ingresar encabezado';
$string['block20col3link'] = 'Bloque 20 col 3 enlace';
$string['block20col3linkdefault'] = 'Acerca de nosotros|https://themesalmond.com
                                    Nuestra historia|https://moodle.org/support
                                    Términos y condiciones|https://moodle.org/development
                                    Política de Privacidad|http://docs.moodle.org|Moodle Docs
                                    Mapa del sitio|http://docs.moodle.org/es|Documentación en español|es
                                    Moodle.com|http://moodle.com/';
$string['block20col3linkdesc'] = 'Bloque 20 col 3 área del enlace';
$string['block20col4caption'] = 'Bloque 20 col 4 subtítulo';
$string['block20col4captiondefault'] = '<p>Dirección<p>';
$string['block20col4captiondesc'] = 'Bloque 20 col 4 subtítulo ingresar';
$string['block20col4header'] = 'Bloque 20 col 4 encabezado';
$string['block20col4headerdesc'] = 'Bloque 20 col 4 ingresar encabezado';
$string['block20copyright'] = 'Bloque 20 Copyright (Derechos de autor)';
$string['block20copyrightdesc'] = 'Bloque 20 Copyright';
$string['block20enabled'] = 'Habilitar bloque 20';
$string['block20enableddesc'] = 'Habilitar o deshabilitar el bloque 20 en su página de inicio';
$string['block20info'] = '! Bloque-20 PIE DE PÁGINA';
$string['block20infodesc'] = 'PIE DE PÁGINA - Ingresar las configuraciones para bloque 20';
$string['block20logo'] = 'Seleccionar el  logo del bloque 20';
$string['block20logodesc'] = 'Bloque 20 selección de logo';
$string['block20moodle'] = 'Habilitar botón en Portada';
$string['block20moodledesc'] = 'Habilitar o deshabilitar la Portada original de Moodle en el bloque 20';
$string['block20social'] = 'Bloque 20 Redes sociales';
$string['block20socialdefault'] = '<ul>
<li><a href="#" target="_blank"><i class="fa fa-facebook-f"></i></a></li>
<li><a href="#" target="_blank"><i class="fa fa-twitter"></i></a></li>
<li><a href="#" target="_blank"><i class="fa fa-pinterest"></i></a></li>
<li><a href="#" target="_blank"><i class="fa fa-linkedin"></i></a></li>
<li><a href="#" target="_blank"><i class="fa fa-instagram"></i></a></li>
<li><a href="#" target="_blank"><i class="fa fa-youtube-play"></i></a></li>
</ul>';
$string['block20socialdesc'] = 'Bloque 20 redes sociales';
$string['bootswatch'] = 'Bootswatch';
$string['bootswatch_desc'] = 'Un bootswatch es un conjunto de variables de Bootstrap y CSS para estilizar Bootstrap';
$string['brandcolor'] = 'Color de la marca';
$string['brandcolor_desc'] = 'El color del acento.';
$string['button'] = 'Botón';
$string['buttonlink'] = 'https://themesalmond.com/';
$string['choosereadme'] = 'Almondb es un tema moderno altamente personalizable. Este tema se pretende que se use directamente, o como un tema paterno al crear nuevos temas que usan Bootstrap 4.';
$string['configtitle'] = 'Almondb';
$string['coursesection'] = 'Secciones de Curso';
$string['coursesummary'] = 'Resumen del Curso';
$string['dashboardnavchoice'] = 'NAV página Tablero';
$string['dashboardnavchoicedesc'] = 'Seleccionar NAV página del Tablero a mostrar';
$string['div'] = '</div>';
$string['divdiv'] = '</div></div></div>';
$string['footerbackgroundcolor'] = 'Color del fondo del pie de página';
$string['footerbackgroundcolordesc'] = 'Usted puede cambiar el color del fondo del pie de página';
$string['footerselect'] = 'Pie de página del Tablero';
$string['footerselectdesc'] = 'Seleccionar el estilo de pie de página del formato del Tablero';
$string['frontpagealmondb'] = 'Portada';
$string['frontpagechoice'] = 'Seleccionar Portada';
$string['frontpagechoicedesc'] = 'Seleccionar la Portada a mostrar';
$string['frontpagecolor'] = 'Seleccionar color predeterminado de portada';
$string['frontpagecolordesc'] = '<div class="row pb-3">
                                    <div class="col p-1 text-center" style="background-color:#4272d7;"> 1-#4272d7</div>
                                    <div class="col p-1 text-center" style="background-color:#f98012;"> 2-#f98012</div>
                                    <div class="col p-1 text-center" style="background-color:#fa4251;"> 3-#fa4251</div>
                                    <div class="col p-1 text-center" style="background-color:#c45e28;"> 4-#c45e28</div>
                                    <div class="col p-1 text-center" style="background-color:#63c76a;"> 5-#63c76a</div>
                                    <div class="col p-1 text-center" style="background-color:#024E64;"> 6-#024E64</div>
                                </div>';
$string['frontpagedesc'] = 'Seleccionar Portada a mostrar';
$string['frontpageend'] = '--*/*--';
$string['frontpageenddesc'] = '';
$string['frontpageheading'] = '! Elección de Portada';
$string['frontpageheading1'] = '! Portada SECCIÓN';
$string['frontpageheadingdesc1'] = 'Selección número uno en Portada
<br><a href="./../theme/almondb/pix/almondb/slide_01.jpg" target="_blank">Clic para ver bloques</a>';
$string['frontpagenav'] = ': Elección de Encabezado de Portada';
$string['frontpagenavchoice'] = 'Navegación de Portada';
$string['frontpagenavchoicedesc'] = 'Seleccionar Navegación de Portada a mostrar';
$string['frontpagenavdesc'] = 'Seleccionar encabezado de Portada a mostrar';
$string['frontpagenavlightdark'] = 'Portada clara-oscura';
$string['frontpagenavlightdarkdesc'] = 'Si elige el color oscuro de arriba, seleccionar "navbar-oscura".';
$string['frontpagenavlink'] = 'Enlace de NAV de Portada';
$string['frontpagenavlinkdefault'] = 'Cursos

-Todos los cursos|/course/
-Buscar curso|/course/search.php|_blank
Smooth
-Caja de título|#block01
-Caja de ícono|#block02
-Características|#block03
-Último|#block04
-PORQUÉ nosotros|#block05
-Trabajando con nosotros|#block06
-Curso|#block07
-Profesor|#block08
-Categoría|#block09
-Testimoniales|#block10|_self
-Blog publicaciones|#block11|_self
-Bloque HTML|#block18|_self
-Marcas|#block19
-Pie de página|#block20
Profesores|#block08
Blog|/blog/
Documentación|https://themesalmond.com/documents/|_blank';
$string['frontpagenavlinkdesc'] = 'Ingresar enlaces de barra de navegación de Portada';
$string['frontpagesection1_1'] = 'Sección 1';
$string['frontpagesection1_10'] = 'Sección 10';
$string['frontpagesection1_2'] = 'Sección 2';
$string['frontpagesection1_3'] = 'Sección 3';
$string['frontpagesection1_4'] = 'Sección 4';
$string['frontpagesection1_5'] = 'Sección 5';
$string['frontpagesection1_6'] = 'Sección 6';
$string['frontpagesection1_7'] = 'Sección 7';
$string['frontpagesection1_8'] = 'Sección 8';
$string['frontpagesection1_9'] = 'Sección 9';
$string['frontpagesectiondesc1_1'] = 'Sección 1 de Portada';
$string['frontpagesectiondesc1_10'] = 'Sección 10 de Portada';
$string['frontpagesectiondesc1_2'] = 'Sección 2 de Portada';
$string['frontpagesectiondesc1_3'] = 'Sección 3 de Portada';
$string['frontpagesectiondesc1_4'] = 'Sección 4 de Portada';
$string['frontpagesectiondesc1_5'] = 'Sección 5 de Portada';
$string['frontpagesectiondesc1_6'] = 'Sección 6 de Portada';
$string['frontpagesectiondesc1_7'] = 'Sección 7 de Portada';
$string['frontpagesectiondesc1_8'] = 'Sección 8 de Portada';
$string['frontpagesectiondesc1_9'] = 'Sección 9 de Portada';
$string['generalsettings'] = 'Configuraciones generales';
$string['header3phone'] = 'Número telefónico';
$string['header3phonedesc'] = 'Número telefónico de contacto a mostrar en la Barra de Navegación';
$string['headerlogo'] = 'Seleccionar el logo de Barra de Navegación';
$string['headerlogodesc'] = 'Seleccionar logo de NAV de Portada a mostrar';
$string['imgloginbackground'] = 'Imagen del fondo para página para ingresar';
$string['imgloginbackground_desc'] = 'Descripción de imagen del fondo para página para ingresar';
$string['loggedinnot'] = 'Ingresar.';
$string['loginbackgroundimage'] = 'Imagen del fondo para página para ingresar';
$string['loginbackgroundimage_desc'] = 'La imagen a mostrar como fondo para la página para ingresar.';
$string['loginposition'] = 'Posición de formato para ingresar';
$string['loginpositiondesc'] = 'Seleccionar la posición en la pantalla del formato para ingresar';
$string['navbarcolor'] = 'Color fondo Barra de Navegación';
$string['navbarcolor_desc'] = 'Color del fondo de Barra de Navegación';
$string['navbarcontainer'] = 'Contenedor añadir';
$string['navbarcontainerdesc'] = 'Usted puede arrojar la Barra de Navegación adentro del contenedor';
$string['nobootswatch'] = 'Ninguno';
$string['over'] = 'Sobre';
$string['pluginname'] = 'Almondb';
$string['preset'] = 'Pre-configuración del tema';
$string['preset_desc'] = 'Elija una pre-configuración para cambiar ampliamente el aspecto del tema.';
$string['presetfiles'] = 'Archivos de pre-configuración adicionales del tema';
$string['presetfiles_desc'] = 'Los archivos de preconfiguración pueden usarse para alterar dramáticamente la apariencia del tema. Vea <a href="https://docs.moodle.org/dev/Almondb_Presets">Almondb presets</a> para información sobre como crear y compartir sus propios archivos de preconfiguración,  y vea <a href="https://moodle.net/search?q=boost+presets">Presets repository</a> para preconfiguraciones que otros han compartido.';
$string['privacy:drawerblockclosed'] = 'La preferencia actual para el cajón del bloque es cerrado.';
$string['privacy:drawerblockopen'] = 'La preferencia actual para el cajón del bloque es abierto.';
$string['privacy:drawerindexclosed'] = 'La preferencia actual para el cajón del índice es cerrado.';
$string['privacy:drawerindexopen'] = 'La preferencia actual para el cajón del índice es abierto.';
$string['privacy:metadata'] = 'El tema Amondb no almacena ningún dato personal de ningún usuario.';
$string['privacy:metadata:preference:draweropenblock'] = 'La preferencia del usuario para ocultar o mostrar el cajón con bloques.';
$string['privacy:metadata:preference:draweropenindex'] = 'La preferencia del usuario para ocultar o mostrar el cajón con índice del curso.';
$string['privacy:metadata:preference:draweropennav'] = 'La preferencia del usuario para ocultar o mostrar la navegación por menú del cajón.';
$string['rawscss'] = 'SCSS crudo';
$string['rawscss_desc'] = 'Use este campo para proporcionar código CSS o SCSS que será inyectado al fin de la hoja de estilo.';
$string['rawscsspre'] = 'SCSS crudo inicial';
$string['rawscsspre_desc'] = 'En este campo usted puede proporcionar código inicializador SCSS. Será inyectado antes de todo lo demás. La mayoría de las veces usted usará esta configuración para definir variables.';
$string['region-side-pre'] = 'Derecha';
$string['showfooter'] = 'Mostrar pie de página';
$string['sitecolor'] = 'Seleccionar color de Portada';
$string['sitecolor-1'] = '#4272d7';
$string['sitecolor-2'] = '#f98012';
$string['sitecolor-3'] = '#fa4251';
$string['sitecolor-4'] = '#c45e28';
$string['sitecolor-5'] = '#63c76a';
$string['sitecolor-6'] = '#024E64';
$string['sitecolor_desc'] = 'Usted puede elegir el color que quiera excepto el predeterminado';
$string['slideno'] = '! Página-{$a->slide}';
$string['slidenodesc'] = 'Ingresar las configuraciones para página {$a->slide}.';
$string['sliderbutton'] = 'Botón del deslizador';
$string['sliderbuttondesc'] = 'Ingresar el destino del texto del botón de imagen del deslizador, ya sea la clave del idioma o Texto. Por ejemplo: lang:display o Display';
$string['sliderbuttonurl'] = 'Enlace a botón del deslizador';
$string['sliderbuttonurldesc'] = 'Escribir el destino del enlace del botón de imagen del deslizador';
$string['slidercaption'] = 'Subtítulo del deslizador';
$string['slidercaptiondesc'] = 'Añadir un subtítulo para su página';
$string['slidercount'] = 'Número de deslizadores';
$string['slidercountdesc'] = 'Seleccionar cuantas páginas quiere añadir <strong> y entonces haga clic en GUARDAR</strong> para cargar los campos para entrada.';
$string['sliderdesign'] = 'Diseño del deslizador';
$string['sliderdesigndesc'] = 'Seleccionar el diseño del deslizador que desea añadir';
$string['sliderenabled'] = 'Habilitar deslizador';
$string['sliderenableddesc'] = 'Habilitar un deslizador en la parte superior de su página de inicio';
$string['sliderimage'] = 'Imagen del deslizador';
$string['sliderimageblock02img'] = 'Imagen de bloque {$a->block}';
$string['sliderimageblock04img'] = 'Imagen de bloque {$a->block}';
$string['sliderimageblock05img'] = 'Imagen de bloque';
$string['sliderimageblock06img'] = 'Imagen de bloque';
$string['sliderimageblock10img'] = 'Imagen de bloque {$a->block}';
$string['sliderimageblock19img'] = 'Bloque 19 img {$a->block}';
$string['sliderimagedesc'] = 'Añadir una imagen a su página. El tamaño recomendado es 1500px x 500px o mayor.';
$string['slideropacity'] = 'Opacidad del deslizador';
$string['slideropacitydesc'] = 'Opacidad del color de Portada a deslizador';
$string['slidershowheight'] = 'Altura del carrusel';
$string['slidershowheight_desc'] = 'Ajustar la altura del carrusel en las páginas del Inicio del Sitio.';
$string['slidertitle'] = 'Título de página';
$string['slidertitledesc'] = 'Añadir el título de la página';
$string['slideshow'] = 'Deslizador';
$string['slideshowend'] = '--*/*--';
$string['slideshowenddesc'] = '';
$string['slideshowheading'] = ': Deslizador en la Página de Inicio';
$string['slideshowheadingdesc'] = 'Esto crea una presentación de hasta seis páginas para que usted promocione elementos importantes de su sitio. La presentación es responsiva, donde la altura de la imagen es configurada de acuerdo al tamaño de la pantalla. Si no se selecciona una imagen para una página, se usarán las imágenes de la carpeta pix.';
$string['slideshowstart'] = 'Configuraciones del Deslizador de Página de Inicio';
$string['slideshowstartdesc'] = '';
$string['theme_almondb_frontpageblock'] = 'Bloque';
$string['theme_almondb_frontpageblockdesc'] = 'Configuraciones de bloques HTML en Portada';
$string['theme_almondb_frontpageblockend'] = '--*/*--';
$string['theme_almondb_frontpageblockenddesc'] = '';
$string['theme_almondb_frontpageblockheading'] = 'Bloques de Portada';
$string['themesettings'] = 'Configuraciones del tema';
$string['totop'] = 'Ir a superior';
$string['unaddableblocks'] = 'Bloques innecesarios';
$string['unaddableblocks_desc'] = 'Los bloques especificados no son necesarios cuando se usa este tema y no estarán enlistados en el menú para \'Añadir un bloque\'';
$string['underline'] = '<div style="margin-bottom: 10px; border-bottom:3px solid blue;width:100%;"></div><br>';
