<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'qtype_musictheory', language 'es_mx', version '5.1'.
 *
 * @package     qtype_musictheory
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abmajor'] = 'A♭ mayor';
$string['abminor'] = 'A♭ menor';
$string['acc_b'] = '♭';
$string['acc_bb'] = '♭♭';
$string['acc_n'] = '♮';
$string['acc_sharp'] = '♯';
$string['acc_x'] = 'x';
$string['alto'] = 'Clave alto (de do en tercera)';
$string['altoclef'] = 'Clave alto (de do en tercera)';
$string['anmajor'] = 'A mayor';
$string['anminor'] = 'A menor';
$string['answerlbl'] = 'Respuesta';
$string['asharpminor'] = 'La♯ menor';
$string['aug10'] = 'Décima aumentada';
$string['aug11'] = 'Décima_primera aumentada';
$string['aug12'] = 'Décima_segunda aumentada';
$string['aug13'] = 'Décima_tercera aumentada';
$string['aug2'] = 'Segunda aumentada';
$string['aug3'] = 'Tercera aumentada';
$string['aug4'] = 'Cuarta aumentada';
$string['aug5'] = 'Quinta aumentada';
$string['aug6'] = 'Sexta aumentada';
$string['aug6thfr'] = 'Sexta Francesa aumentada';
$string['aug6thgr'] = 'Sexta Alemana aumentada';
$string['aug6thit'] = 'Sexta Italiana aumentada';
$string['aug7'] = 'Séptima aumentada';
$string['aug8'] = 'Octava aumentada';
$string['aug9'] = 'Novena aumentada';
$string['augmented'] = 'Aumentada';
$string['bass'] = 'Clave bass (de fa en cuarta)';
$string['bassclef'] = 'Clave bass (de fa en cuarta)';
$string['bbmajor'] = 'B♭ mayor';
$string['bbminor'] = 'B♭ menor';
$string['bnmajor'] = 'B mayor';
$string['bnminor'] = 'B menor';
$string['cbmajor'] = 'C♭ mayor';
$string['chordquality'] = 'Calidad del acorde';
$string['chordquality-random'] = 'Cualidades posibles del acorde';
$string['chordquality_write_questionastext'] = 'Entrada de respuesta de calidad del acorde';
$string['chordquality_write_questionastext_help'] = '<p>Ingrese una lista de notas separada por comas, sin espacios, usando la sintaxis siguiente:</p><p>[Nombre de letra MAYÚSCULA][Accidental
("n" = natural, "#" = sostenido, "b" = bemol, "x" = doble-sostenido, "bb" = doble-bemol)]4, ... </p>
<p>Ejemplo aleatorio: <b>answer=>Cn4,En4,G#4</b></p>';
$string['chordquality_write_questionasui'] = 'Entrada de respuesta de función harmónica';
$string['chordquality_write_questionasui_help'] = '<p>Ingresar la nota al hacer clic en el pentagrama, después de seleccionar el tipo de accidental en la barra de herramientas a mano derecha. Para eliminar la nota, hacer clic nuevamente.</p>';
$string['chordroot'] = 'Raíz del acorde';
$string['clef'] = 'Clave';
$string['clef-random'] = 'Claves posibles';
$string['cnmajor'] = 'C mayor';
$string['cnminor'] = 'C menor';
$string['considerregister'] = 'Incluir registro';
$string['considerregister_help'] = 'Indica si es que el registro de la nota será incluido como parte de la pregunta.';
$string['correctansweris'] = 'La respuesta correcta es:';
$string['correctansweris_morethanone'] = 'Una respuesta correcta posible es:';
$string['csharpmajor'] = 'C♯ mayor';
$string['csharpminor'] = 'C♯ menor';
$string['dbmajor'] = 'D♭ mayor';
$string['dim10'] = 'Décima disminuída';
$string['dim11'] = 'Décimo_primera disminuída';
$string['dim12'] = 'Décimo_segunda disminuída';
$string['dim13'] = 'Décimo_tercera disminuída';
$string['dim2'] = 'Segunda disminuída';
$string['dim3'] = 'Tercera disminuída';
$string['dim4'] = 'Cuarta disminuída';
$string['dim5'] = 'Quinta disminuída';
$string['dim6'] = 'Sexta disminuída';
$string['dim7'] = 'Séptima disminuída';
$string['dim8'] = 'Octava disminuída';
$string['dim9'] = 'Novena disminuída';
$string['diminished'] = 'Disminuída';
$string['dirasc'] = 'Arriba de la nota dada';
$string['dirdesc'] = 'Abajo de la nota dada';
$string['direction'] = 'Dirección';
$string['displaykeysignature'] = 'Mostrar armadura de tonalidad';
$string['dnmajor'] = 'D mayor';
$string['dnminor'] = 'D menor';
$string['dsharpminor'] = 'D♯ menor';
$string['ebmajor'] = 'E♭ mayor';
$string['ebminor'] = 'E♭ menor';
$string['emptykeysignature'] = 'Armadura de tonalidad vacía';
$string['enmajor'] = 'E mayor';
$string['enminor'] = 'E minor';
$string['fnmajor'] = 'F mayor';
$string['fnminor'] = 'F menor';
$string['fsharpmajor'] = 'F♯ mayor';
$string['fsharpminor'] = 'F♯ menor';
$string['gbmajor'] = 'G♭ mayor';
$string['givennoteelementgroup'] = 'Nota dada';
$string['gnmajor'] = 'G mayor';
$string['gnminor'] = 'G menor';
$string['grandstaff'] = 'Grand Staff (Sistema de 2 pentagramas)';
$string['gsharpminor'] = 'G♯ menor';
$string['harmonicfunction_write_questionastext'] = 'Entrada respuesta función harmónica';
$string['harmonicfunction_write_questionastext_help'] = '<p>Ingrese una lista de notas separada por comas, sin espacios, usando la sintaxis siguiente:</p><p>[Nombre de letra MAYÚSCULA][Accidental
("n" = natural, "#" = sostenido, "b" = bemol, "x" = doble-sostenido, "bb" = doble-bemol)]4, ... </p>
<p>Ejemplo aleatorio: <b>answer=>Cn4,En4,G#4</b></p>';
$string['harmonicfunction_write_questionasui'] = 'Entrada respuesta función harmónica';
$string['harmonicfunction_write_questionasui_help'] = '<p>Ingresar la nota al hacer clic en el pentagrama, después de seleccionar el tipo de accidental en la barra de herramientas a mano derecha. Para eliminar la nota, hacer clic nuevamente.</p>';
$string['harmonicfunctiontype-random'] = 'Funciones harmónicas posibles';
$string['hfidentifyresponsetypes'] = 'Funciones harmónicas posibles en la respuesta';
$string['hftype_aug6th'] = 'Sexta aumentada';
$string['hftype_diatonictriad'] = 'Triada diatónica';
$string['hftype_dom7th'] = 'Séptima dominante';
$string['hftype_extendeddom'] = 'Dominante extendida (9, 11 o 13)';
$string['hftype_leadingtone7thfullydim'] = 'Tono de séptima de dominante (disminuída)';
$string['hftype_leadingtone7thhalfdim'] = 'Tono de séptima de dominante (semidisminuída)';
$string['hftype_neapolitan'] = 'Napolitana';
$string['hftype_nondom7th'] = 'Séptima no_dominante';
$string['hftype_secdom7th'] = 'Dominante secundaria (séptima)';
$string['hftype_secdomtriad'] = 'Dominante secundaria (triada)';
$string['hftype_secltfullydim'] = 'Tono de séptima de dominante secundaria (disminuída)';
$string['hftype_seclthalfdim'] = 'Tono de séptima de dominante secundaria (semidisminuída)';
$string['hftype_seclttriad'] = 'Tono dominante de secundaria (triada)';
$string['hftype_secnondom7th'] = 'No_dominante secundaria (séptima)';
$string['hftype_secnondomtriad'] = 'No_dominante secundaria (triada)';
$string['includealterations'] = 'Incluir alteraciones';
$string['includealterations_help'] = 'Indica si es que las accideentales van a ser incluidas como parte de la pregunta.';
$string['includestaticnote'] = 'Incluir nota dada';
$string['interval_write_questionastext'] = 'Entrada respuesta intervalo';
$string['interval_write_questionastext_help'] = '<p>Ingrese la nota de respuesta, sin espacios, usando la sintaxis siguinte:</p><p>[Nombre de letra MAYÚSCULA][Accidental ("n" = natural, "#" = sostenido,
"b" = bemol, "x" = doble-sostenido, "bb" = doble-bemol)] [Registro (un dígito entre 1 y 6, siguiendo la notación científica de tono)]</p><p>Ejemplos:
</p><ul><li><b>Gn5</b></li><li><b>A#4</b></li><li><b>Ebb3</b></li></ul>';
$string['interval_write_questionasui'] = 'Escritura de respuesta de intervalo';
$string['interval_write_questionasui_help'] = '<p>Ingresar la nota al hacer clic en el pentagrama, después de seleccionar el tipo de accidental en la barra de herramientas a mano derecha. Para eliminar la nota, hacer clic nuevamente.</p>';
$string['javascriptrequired'] = 'El texto va a ser remplazado por una interfaz gráfica del usuario, lo que requiere que JavaScript sea habilitado en su navegador.';
$string['keyboard_input_questionasui'] = 'Escritura de respuesta por teclado';
$string['keyboard_input_questionasui_help'] = '<p>Ingresar notas al hacer clic en el teclado. Para eliminar una nota, haga clic en ella nuevamente.</p>';
$string['keymode'] = 'Tono';
$string['keysignature_write_questionastext'] = 'Entrada de respuesta de armadura de tonalidad';
$string['keysignature_write_questionastext_help'] = '<p>Ingrese una lista de accidentales separadas por coma
(entre 1 y 7 de ellas), sin espacios, usando la sintaxis siguiente:</p><p>[Nombre de letra MAYÚSCULA]
[Accidental ("#" = sostenido, "b" = bemol)][Registro (un dígito entre 1 y 6, siguiendo la notación científica de tono)], ... </p><p>Ejemplo: <b>A#4,F#4,G#4</b></p>';
$string['keysignature_write_questionasui'] = 'Entrada de respuesta de armadura de tonalidad';
$string['keysignature_write_questionasui_help'] = '<p>Ingrese accidentales al hacer clic en el pentagrama, después de seleccionar el tipo de accidental en la barra de herramientas a mano derecha. Para eliminar una accidental, haga clic nuevamente.</p>';
$string['lbl_harmonicfunction'] = 'Función harmónica';
$string['maj10'] = '10a Mayor';
$string['maj13'] = '13a Mayor';
$string['maj2'] = '2a Mayor';
$string['maj3'] = '3a Mayor';
$string['maj6'] = '6a Mayor';
$string['maj7'] = '7a Mayor';
$string['maj9'] = '9a Mayor';
$string['major'] = 'Mayor';
$string['min10'] = '10a menor';
$string['min13'] = '13a menor';
$string['min2'] = '2a menor';
$string['min3'] = '3a menor';
$string['min6'] = '6a menor';
$string['min7'] = '7a menor';
$string['min9'] = '9a menor';
$string['minor'] = 'Menor';
$string['mode-random'] = 'Modos posibles';
$string['musicqtype'] = 'Tipo de pregunta de música';
$string['musictheory_gradingstrategy'] = 'Estrategia de calificación';
$string['musictheory_gradingstrategy_help'] = '<p>La estrategia de calificación especifica como será calificada la pregunta</p>
<p><b>Todo o nada</b>: La respuesta es comparada con la respuesta correcta. Si la respuesta  es correcta, se dan puntos totales. Si la respuesta es incorrecta, se da puntaje de cero.</p>';
$string['musictheory_gradingstrategy_scale-write'] = 'Estrategia de calificación';
$string['musictheory_gradingstrategy_scale-write_help'] = '<p>La estrategia de calificación especifica como será calificada la pregunta</p>
<p><b>Todo o nada</b>: La respuesta es comparada con la respuesta correcta. Si la respuesta  es correcta, se dan puntos totales. Si la respuesta es incorrecta, se da puntaje de cero.</p>
<p><b>Crédito parcial para cada nota correcta</b>:
Una escala de calificación que divide la calificación uniformemente por el número de notas de escala que el usuario tiene que ingresar, y otorga calificación parcial por cada nota correcta.</p>';
$string['musictheory_intervalelementgroup'] = 'Intervalo';
$string['musictheory_intervalelementgroup_help'] = 'Indica el tipo de intervalo';
$string['musictheory_intervalelementgroup_random'] = 'Intervalos posibles';
$string['nosectonic'] = '[sin tónica secundaria]';
$string['note_write_questionastext'] = 'Entrada respuesta nota';
$string['note_write_questionastext_help'] = '<p>Ingrese la nota de respuesta, sin espacios, usando la sintaxis siguinte:</p><p>[Nombre de letra MAYÚSCULA][Accidental ("n" = natural, "#" = sostenido,
"b" = bemol, "x" = doble-sostenido, "bb" = doble-bemol)] [Registro (un dígito entre 1 y 6, siguiendo la notación científica de tono)]</p><p>Ejemplos:
</p><ul><li><b>Gn5</b></li><li><b>A#4</b></li><li><b>Ebb3</b></li></ul>';
$string['note_write_questionasui'] = 'Entrada respuesta nota';
$string['note_write_questionasui_help'] = '<p>Ingresar la nota al hacer clic en el pentagrama, después de seleccionar el tipo de accidental en la barra de herramientas a mano derecha. Para eliminar la nota, hacer clic nuevamente.</p>';
$string['notea'] = 'A';
$string['noteb'] = 'B';
$string['notec'] = 'C';
$string['noted'] = 'D';
$string['notee'] = 'E';
$string['notef'] = 'F';
$string['noteg'] = 'G';
$string['notelbl'] = 'Nota';
$string['per11'] = 'Décimo_primera perfecta';
$string['per12'] = 'Décimo_segunda perfecta';
$string['per4'] = 'Cuarta perfecta';
$string['per5'] = 'Quinta perfecta';
$string['per8'] = 'Octava perfecta';
$string['perfect'] = 'Perfecta';
$string['pluginname'] = 'Teoría Musical';
$string['pluginname_help'] = 'Este tipo de pregunta habilita la creación de varios tipos de ejercicios sobre teoría musical usando una interfaz gráfica.';
$string['pluginnameadding'] = 'Añadiendo una pregunta sobre teoría musical';
$string['pluginnameediting'] = 'Editando una pregunta sobre teoría musical';
$string['pluginnamesummary'] = 'Habilita la creación de varios tipos de ejercicios sobre teoría musical.';
$string['possiblescalesinresponse'] = 'Tipos de escala posible';
$string['privacy:metadata'] = 'El plugin del tipo de pregunta Teoría Musical no almacena ningún dato personal.';
$string['qtype_chordquality-identify'] = 'Identificación de calidad del acorde';
$string['qtype_chordquality-identify-random'] = 'Identificación de calidad del acorde (aleatoria)';
$string['qtype_chordquality-write'] = 'Escritura de calidad del acorde';
$string['qtype_chordquality-write-random'] = 'Escritura de calidad del acorde (aleatoria)';
$string['qtype_harmonicfunction-identify'] = 'Identificación de función harmónica';
$string['qtype_harmonicfunction-identify-random'] = 'Identificación de función harmónica (aleatoria)';
$string['qtype_harmonicfunction-write'] = 'Excritura de funció  harmónica';
$string['qtype_harmonicfunction-write-random'] = 'Excritura de funció  harmónica (aleatoria)';
$string['qtype_interval-identify'] = 'Identificación de intervalo';
$string['qtype_interval-identify-random'] = 'Identificación de intervalo (aleatorio)';
$string['qtype_interval-write'] = 'Escritura de intervalo';
$string['qtype_interval-write-random'] = 'Escritura de intervalo (aleatorio)';
$string['qtype_keyboard-input'] = 'Entrada (respuesta) por teclado';
$string['qtype_keysignature-identify'] = 'Identificación de armadura de tonalidad';
$string['qtype_keysignature-identify-random'] = 'Identificación de armadura de tonalidad (aleatoria)';
$string['qtype_keysignature-write'] = 'Escritura de armadura de tonalidad';
$string['qtype_keysignature-write-random'] = 'Escritura de armadura de tonalidad (aleatoria)';
$string['qtype_musictheory_strategy_all_or_nothing'] = 'Todo o  nada';
$string['qtype_musictheory_strategy_chordqualitywrite_allornothing'] = 'Todo o  nada';
$string['qtype_musictheory_strategy_harmonicfunctionid_allornothing'] = 'Todo o  nada';
$string['qtype_musictheory_strategy_harmonicfunctionwrite_allornothing'] = 'Todo o  nada';
$string['qtype_musictheory_strategy_keyboard_allornothing'] = 'Todo o  nada';
$string['qtype_musictheory_strategy_note_allornothing'] = 'Todo o  nada';
$string['qtype_musictheory_strategy_scale_creditbynote'] = 'Crédito parcial por cada nota correcta';
$string['qtype_note-identify'] = 'Identificación de nota';
$string['qtype_note-identify-random'] = 'Identificación de nota (aleatoria)';
$string['qtype_note-write'] = 'Escritura de nota';
$string['qtype_note-write-random'] = 'Escritura de nota (aleatoria)';
$string['qtype_scale-identify'] = 'Identificación de escala';
$string['qtype_scale-identify-random'] = 'Identificación de escala (aleatoria)';
$string['qtype_scale-write'] = 'Escritura de escala';
$string['qtype_scale-write-random'] = 'Escritura de escala (aleatoria)';
$string['quality-random'] = 'Cualidades posibles';
$string['qualityaug'] = 'Aumentada';
$string['qualitydim'] = 'Disminuída';
$string['qualitymaj'] = 'Mayor';
$string['qualitymin'] = 'Menor';
$string['qualityper'] = 'Perfecta';
$string['questionoptions'] = 'Opciones de las preguntas';
$string['questiontext'] = 'Texto de la pregunta';
$string['questiontext_chordquality_identify'] = 'Identificar la raíz y calidad del acorde siguiente';
$string['questiontext_chordquality_write'] = 'Ingrese el  acorde siguient';
$string['questiontext_harmonicfunction_identify'] = 'Identifique la función siguiente';
$string['questiontext_harmonicfunction_write'] = 'Ingrese la función harmónica siguiente';
$string['questiontext_help'] = 'Este campo no es necesario. Si se deja vacío, se mostrará automáticameente un texto de pregunta apropiado para el tipo de pregunta musical dada dentro de las actividades. Si Usted  ingresa texto en este campo, remplazará al texto generado automáticamente de la pregunta.';
$string['questiontext_interval_identify'] = 'Identifique el intervalo siguiente';
$string['questiontext_interval_write_above'] = 'Ingrese el intervalo siguiente <b>arriba de</b> la nota dada';
$string['questiontext_interval_write_below'] = 'Ingrese el intervalo siguiente <b>debajo de</b> la nota dada';
$string['questiontext_keyboard_input'] = 'Ingrese la nota siguiente en el teclado';
$string['questiontext_keysignature_identify_major'] = 'Determinar la nota mayor representada por la siguiente armadura de nota';
$string['questiontext_keysignature_identify_minor'] = 'Determinar la nota menor representada por la siguiente armadura de nota';
$string['questiontext_keysignature_write'] = 'Ingresar la siguiente armadura de nota';
$string['questiontext_note_identify'] = 'Identifique la nota siguiente';
$string['questiontext_note_write'] = 'Ingrese la nota siguient';
$string['questiontext_scale_identify'] = 'Identifique la escala siguiente';
$string['questiontext_scale_write'] = 'Escriba la escala siguiente en dirección ascendent';
$string['questiontext_scale_write_melodic'] = 'Escriba la siguiente escala, tanto en dirección ascendente como descendente';
$string['rootposition'] = '[raíz]';
$string['scale_write_questionastext'] = 'Entrada respuesta escala';
$string['scale_write_questionastext_help'] = '<p>Ingrese una lista deparada por comas de notas, incluyendo la tónica especificada, sin espacios, usando la siguiente sintaxis:</p><p>[Nombre de letra MAYÚSCULA]
[Accidental ("n" = natural, "#" = sostenido, "b" = bemol, "x" = doble-sostenido, "bb" = doble-bemol)]
[Registro (un dígito entre 1 y 6, siguiendo la notación científica de tono)], ... </p>
<p>Ejemplo aleatorio: <b>Tónica = An4 respuesta=>An4,Bb4,C#5,D#5,E#5,F#5,G#5,An5</b></p>';
$string['scale_write_questionasui'] = 'Entrada respuesta escala';
$string['scale_write_questionasui_help'] = '<p>Ingresar la nota al hacer clic en el pentagrama, después de seleccionar el tipo de accidental en la barra de herramientas a mano derecha. Para eliminar la nota, hacer clic nuevamente.</p>
<p>Tenga en cuenta que las accidentales se continúan a las notas subsecuentes.</p>';
$string['scaletype'] = 'Tipo de escala';
$string['scaletype-random'] = 'Tipos de escalas posibles';
$string['scaletype_harmonic'] = 'Harmónica menor';
$string['scaletype_major'] = 'Mayor';
$string['scaletype_melodic'] = 'Melódica menor';
$string['scaletype_natural'] = 'Natural menor';
$string['selectakey'] = 'Seleccionar una nota';
$string['selectanoption'] = 'Seleccionar';
$string['selectaquality'] = 'Seleccionar una calidad';
$string['selectasize'] = 'Seleccionar un tamaño';
$string['size-random'] = 'Tamaños posibles';
$string['size10'] = '10a';
$string['size11'] = '11a';
$string['size12'] = '12a';
$string['size13'] = '13a';
$string['size2'] = '2a';
$string['size3'] = '3a';
$string['size4'] = '4a';
$string['size5'] = '5a';
$string['size6'] = '6a';
$string['size7'] = '7a';
$string['size8'] = '8a';
$string['size9'] = '9a';
$string['tenor'] = 'Tenor';
$string['tenorclef'] = 'Clave tenor (de do en cuarta)';
$string['tonic'] = 'Tónica';
$string['treble'] = 'Clave treble (de sol en segunda)';
$string['trebleclef'] = 'Clave de Sol';
$string['updatemusicqtype'] = 'Actualizar opciones';
$string['validation_harmonicfunctionnotsupported'] = 'Esta función harmónica no está soportada o es inválida.';
$string['validation_harmonicfunctiontypenotselected'] = 'El tipo de función para la función harmónica especificada debe ser seleccionado.';
$string['validation_interval_novalidcombo'] = 'Las calidades y tamaños posibles seleccionados  no producen al menos un intervalo válido';
$string['validation_intervaloutsidestaff'] = 'El registro dado de la nota produce un intervalo que no cabe dentro del pentagrama en la clave especificada.';
$string['validation_invalidchordquality'] = 'Este tipo de acorde no puede construirse en la raíz especificada.';
$string['validation_invalidinterval_above'] = 'El intervalo no puede ser escrito por arriba de la nota dada.';
$string['validation_invalidinterval_below'] = 'El intervalo no puede ser escrito por debajo de la nota dada.';
$string['validation_noteoutsidekeyboard'] = 'La nota está afuera del rango del teclado del piano.';
$string['validation_noteoutsidestaff'] = 'El registro de la nota no cabe dentro del pentagrama en la clave especificada.';
$string['validation_possiblescaletypenotselected'] = 'El tipo de escala para el tipo especificado de escala debe ser seleccionado.';
$string['validation_possiblescaletypesnotselected_random'] = 'Los tipos posibles de escala en la respuesta deben de incluir todos los tipos posibles de escala en la pregunta.';
$string['validation_qualitymismatch'] = 'Esta combinación de calidad y tamaño de intervalo es inválida.';
$string['validation_samestaticandgivennote'] = 'La nota dada y la respuesta no pueden corresponder a la misma tecla en el teclado.';
$string['validation_scale_invalidtonic'] = 'Tónica inválida para el tipo especificado de escala.';
$string['validation_scaleoutsidestaff'] = 'El registro tónico dado produce una escala que no cabe dentro del pentagrama en la clave especificada.';
$string['validationerror_chordquality_identify'] = 'Respuesta incompleta. Debe de seleccionars la letra, accidental y calidad del acorde.';
$string['validationerror_empty'] = 'No se preoporcionó respuesta alguna.';
$string['validationerror_harmonicfunction_identify'] = 'Respuesta incompleta. Deben seleccionarse todos los menús desplegables.';
$string['validationerror_incompletechordquality'] = 'Respuesta incompleta. Número de notas en este acorde';
$string['validationerror_incompleteharmonicfunction'] = 'Respuesta incompleta. Número de notas en esta función harmónica';
$string['validationerror_interval_identify'] = 'Respuesta incompleta. Deben seleccionarse ambos: calidad y tamaño.';
$string['validationerror_invalidsyntax'] = 'Sintaxis de respuesta inválida';
$string['validationerror_note_identify'] = 'Respuesta incompleta. Debe de seleccionarse el nombre de la letra, su accidental y su registro.';
$string['validationerror_note_identify_ltr_acc'] = 'Respuesta incompleta. Tanto el nombre de la letra y la accidental deben ser seleccionados.';
$string['validationerror_note_identify_ltr_reg'] = 'Respuesta incompleta. Tanto el nombre de la letra y el registro deben ser seleccionados.';
$string['validationerror_notewrite_twonotesingrandstaff'] = 'Se escribieron dos notas. Por favor, escriba solamente una nota.';
$string['validationerror_scale_identify'] = 'Respuesta incompleta. Todos los meeenúes desplegables deben ser seleccionados.';
$string['validationerror_scale_incomplete'] = 'Respuesta incompleta. Es necesario un total de 8 notas, incluyendo la tónica dada.';
$string['validationerror_scale_incomplete_melodic'] = 'Respuesta incompleta. Es necesario un total de 15 notas, incluyendo la tónica dada.';
$string['validationerror_whitespace'] = 'Sintaxis de respuesta inválida: quite todos los espacios de su respuesta.';
