<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_alternative_file_system', language 'es_mx', version '5.1'.
 *
 * @package     local_alternative_file_system
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['instruction_install'] = 'Debes agregar el código siguiente a config.php:<pre>$CFG->alternative_file_system_class = "\\local_alternative_file_system\\external_file_system";</pre>';
$string['instruction_title'] = 'Instrucciones de instalación';
$string['migrate_link'] = '<p><a class="btn btn-success" href="?execute=1">Ejecutar ahora (puede tardar mucho tiempo)</a></p>';
$string['migrate_title'] = 'Migrar almacenamiento local a remoto';
$string['migrate_total'] = '<p>Tiene archivos locales <strong>{$a->missing}</strong> en espera de migración, mientras que los archivos <strong>{$a->sending}</strong> ya se han migrado al entorno remoto.</p>';
$string['pluginname'] = 'Sistema de archivos alternativo';
$string['privacy:no_data_reason'] = 'El plugin Sistema de archivos alternativo no almacena ningún dato personal.';
$string['settings_bucketname'] = '{$a->local} Nombre del depósito';
$string['settings_bucketnamedesc'] = 'El nombre único asignado al depósito en {$a->local}.';
$string['settings_destino'] = 'Destino de almacenamiento';
$string['settings_destinodesc'] = 'Seleccione el destino de almacenamiento y guarde para cargar datos relacionados con el almacenamiento.';
$string['settings_gcs_keyfile'] = 'Contenido de Google-storage.json';
$string['settings_gcs_keyfiledesc'] = 'Pegue aquí el contenido del archivo "google-storage.json".';
$string['settings_local'] = 'Archivos locales en Moodle';
$string['settings_migrate'] = 'Utilice el servicio <a target="_blank" href="{$a->url}">move-to-external.php</a> para migrar datos locales a {$a->local}.';
$string['settings_path'] = 'Ruta del objeto {$a->local}';
$string['settings_pathdesc'] = 'La ruta dentro del contenedor donde se almacenarán los objetos. Solo se aceptan letras y números.';
$string['settings_s3_credentials_key'] = 'Clave de acceso {$a->local}';
$string['settings_s3_credentials_keydesc'] = 'La clave de acceso utilizada para autenticarse con el servicio {$a->local}.';
$string['settings_s3_credentials_secret'] = 'Clave secreta {$a->local}';
$string['settings_s3_credentials_secretdesc'] = 'La clave secreta utilizada para autenticarse con el servicio {$a->local}.';
$string['settings_s3_region'] = 'Región {$a->local}';
$string['settings_s3_regiondesc'] = 'La región donde se encuentra el depósito {$a->local}, por ejemplo, "{$a->ex_region}".';
$string['settings_success'] = '<h2>Los datos son correctos.</h2>Tenga cuidado al modificar la configuración, ya que cualquier cambio incorrecto puede provocar la inaccesibilidad de los archivos almacenados.';
