<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'dataplus', language 'es_mx', version '5.1'.
 *
 * @package     dataplus
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['Alttag'] = 'Etiqueta alterna';
$string['actionfailed'] = 'Falló la acción';
$string['actions'] = 'Acciones';
$string['add'] = 'Añadir';
$string['addactionstocomment'] = 'Añadir acciones a su plantilla de comentario';
$string['addactionstorecord'] = 'Añadir acciones a su registro';
$string['addadditionaltocomment'] = 'Añadir información adicional a su plantilla de comentario';
$string['addadditionaltorecord'] = 'Añadir información adicional a su registro';
$string['addcomment'] = 'Añadir comentario';
$string['addfields'] = 'Añadir a su base de datos';
$string['addfieldstorecord'] = 'Añadir campos a su registro';
$string['addinfo'] = 'Añadir información adicional a su registro';
$string['addrecord'] = 'Añadir registro';
$string['addrecordfunctions'] = 'Añadir registro funciones';
$string['addrecordtablabel'] = 'Etiqueta de pestaña de añadir registro';
$string['addrecordtabvisible'] = 'Pestaña de añadir registro visible';
$string['advancedsearch'] = 'Búsqueda avanzada';
$string['allowcomments'] = 'Permitir comentarios';
$string['allowcomments_help'] = 'Permitirle a los usuarios dejar comentarios en registros desde la base de datos por medio de la pantalla de \'vista única\'.';
$string['allowmultiple'] = 'Permitir selecciones múltiples';
$string['alttag'] = 'etiqueta alterna';
$string['amendsearch'] = 'Modificar búsqueda';
$string['ascending'] = 'ascendente';
$string['availablefromdate'] = 'Disponible desde';
$string['availablepast'] = 'Lo siento, esta actividad dejó de estar disponible en {$a}';
$string['availabletodate'] = 'Disponible para';
$string['availableyet'] = 'Lo siento, esta actividad no estará disponible sino hasta después de {$a}';
$string['before'] = 'antes';
$string['boo_ignore'] = 'ignorar';
$string['cancel'] = 'Cancelar';
$string['cancelbuttonlabel'] = 'Etiqueta botón cancelar';
$string['cancelbuttonlabel_help'] = 'Etiqueta para el botón cancelar en formatos de añadir registro. <em>Nota: esta etiqueta no es usada para la opción deprecada addcancel</em>.';
$string['capablilty_delete_database'] = 'Lo siento, su cuenta no tiene las capacidades requeridas para eliminar registros de la base de datos.';
$string['capablilty_delete_record'] = 'Lo siento, su cuenta no tiene las capacidades requeridas para eliminar este registro.';
$string['capablilty_edit_record'] = 'Lo siento, su cuenta no tiene las capacidades requeridas para editar este registro.';
$string['capablilty_edit_template'] = 'Lo siento, su cuenta no tiene las capacidades requeridas para editar plantillas.';
$string['capablilty_insert_database'] = 'Lo siento, su cuenta no tiene las capacidades requeridas para editar registros de la base de datos.';
$string['capablilty_manage_database'] = 'Lo siento, su cuenta no tiene las capacidades requeridas para gestionar la base de datos.';
$string['capablilty_view_database'] = 'Lo siento, su cuenta no tiene las capacidades requeridas para ver registros.';
$string['capablilty_view_export'] = 'Lo siento, su cuent no tiene las capacidades rqueridas para ver la pantalla de exportación.';
$string['cleardatacancelled'] = 'Se canceló la eliminación de datos';
$string['cleardatadone'] = 'Todos los datos han sido eliminados de la base de datos';
$string['cleardatafailed'] = 'Ha fallado la eliminación de datos.';
$string['cleardatawarning'] = 'Al elegir este botón se eliminan todos los registros de la base de datos pero se deja intacta la estructura de los datos. Esta acción no puede revertirse y no debería de usarse sin hacer primero un respaldo del contenido del módulo (sea con la opción de duplicar o la de exportar).';
$string['comment'] = 'Comentario';
$string['comments'] = 'Comentarios';
$string['confirmcleardata'] = 'Confirmar eliminación de datos';
$string['confirmdelete'] = 'Confirmar eliminación';
$string['contains'] = 'contiene';
$string['created'] = 'Creada';
$string['creator'] = 'Creador';
$string['creatorid'] = 'ID del creador';
$string['css'] = 'plantilla CSS';
$string['css_hide'] = 'Ocultar CSS';
$string['css_show'] = 'Mostrar CSS';
$string['database'] = 'Base de datos';
$string['databasenotsetup'] = 'Esta base de datos aún no ha sido configurada.';
$string['databasesetup'] = 'Configurar base de datos';
$string['dataplus:addinstance'] = 'Añadir una nueva instancia DataPlus';
$string['dataplus:databaseedit'] = 'Editar estructura de base de datos';
$string['dataplus:dataeditothers'] = 'Editar otros registros de base de datos';
$string['dataplus:dataeditown'] = 'Editar registros propis de base de datos';
$string['dataplus:downloadfull'] = 'Descargar base de datos';
$string['dataplus:export'] = 'Ver pantalla de exportación';
$string['dataplus:rate'] = 'Valorar entadas';
$string['dataplus:view'] = 'Ver base de datos';
$string['dataplus:viewallratings'] = 'Ver todas las valoraciones crudas dadas por individuos';
$string['dataplus:viewanyrating'] = 'Ver valoraciones totales que cualquiera recibió';
$string['dataplus:viewrating'] = 'Ver la valoraciones totales que Usted recibió';
$string['dbempty'] = 'Esta base de datos está actualmente vacía';
$string['dbnotfound'] = 'No se encontró el registro especificado.';
$string['delete'] = 'eliminar';
$string['deletecomment'] = 'Eliminar comentario';
$string['deleterecord'] = 'Eliminar registro';
$string['descending'] = 'descendiente';
$string['disable_editor'] = 'Deshabilitar editor';
$string['downloadcsv'] = 'Descargar en formato CSV';
$string['downloadcsvhelp'] = 'Compatible con Microsoft Excel, Microsoft Access, StarOffice, etc.';
$string['downloaddb'] = 'Descargar base de datos SQLite';
$string['downloaddbhelp'] = 'Compatible con programas disponibles gratuitamente: SQLite Manager para Firefox, SQLiteTool, etc.';
$string['downloadfulldb'] = 'Descargar base de datos DataPlus totalmente compatible';
$string['downloadfulldbhelp'] = 'Apropiada para importar hacia otra instancia de DataPlus. Puede contener información identificable de estudiantes.';
$string['edit'] = 'editar';
$string['editfield'] = 'Editar campo';
$string['editrecord'] = 'Editar registro';
$string['enable_editor'] = 'Habilitar editor';
$string['equals'] = 'igual a';
$string['export'] = 'Exportar';
$string['exportdb'] = 'Exportar base de datos';
$string['exporttablabel'] = 'Etiqueta de pestaña de Exportar';
$string['exporttabvisible'] = 'Pestaña de Exportar visible';
$string['false'] = 'falso';
$string['field_boolean'] = 'Verdadero / falso';
$string['field_date'] = 'Fecha';
$string['field_datetime'] = 'Fecha / hora';
$string['field_file'] = 'Archivo';
$string['field_image'] = 'Imagen';
$string['field_longtext'] = 'Texto (líneas múltiples)';
$string['field_menu'] = 'Menú';
$string['field_menumultiple'] = 'Menú (selecciones múltiples)';
$string['field_menusingle'] = 'Menú (selección única)';
$string['field_number'] = 'Número';
$string['field_smalltext'] = 'Texto (una línea)';
$string['field_url'] = 'URL';
$string['fielddelete'] = 'Eliminar campo';
$string['fielddeleted'] = 'Campo exitosamente eliminado.';
$string['fieldedited'] = 'Campo exitosamente editado.';
$string['fieldname'] = 'Nombre del campo';
$string['fieldtype'] = 'Tipo de campo';
$string['first'] = 'primero';
$string['footer'] = 'Pie de  página';
$string['greaterthan'] = 'mayor que';
$string['group'] = 'Grupo';
$string['group_delete_record'] = 'Lo siento, Usted no está en el grupo correcto para borrar este registro.';
$string['group_edit_record'] = 'Lo siento, Usted no está en el grupo correcto para editar este registro.';
$string['groupid'] = 'ID del grupo';
$string['groupmember'] = 'Lo siento, Usted no es miembro del grupo necesario para realizar esta función o el modo de grupo ha sido configurado de forma erronea.';
$string['header'] = 'Encabezado';
$string['id'] = 'id';
$string['import'] = 'Importar';
$string['importcomplete'] = 'Importación completa. La base de datos está disponible para usarse.';
$string['importdb'] = 'Importar dase de datos DataPlus';
$string['importremovegroup'] = 'Remover configuraciones de grupo <em>(Nota: las configuraciones de grupo existentes pueden ser incompatibles con los grupos configurados en este curso)</em>';
$string['importwarning'] = '<em>Advertencia:</em> Las bases de datos importadas deben ser compatibles con SQLite3 y tener una estructura de tabla compatible con  DataPlus. Cualquier dato en esta instancia de  DataPlus se perderá.';
$string['intro'] = 'Introducción';
$string['javascript'] = 'Plantilla JavaScript';
$string['javascript_hide'] = 'Ocultar JavaScript';
$string['javascript_show'] = 'Mostrar JavaScript';
$string['jsinit'] = 'Funciones JavaScript a ejecutar cuando carga la página (dejar vacío si no está seguro)';
$string['label'] = 'etiqueta';
$string['labelexists'] = 'Ya existe un campo con esa etiqueta, por favor corríjala';
$string['labels'] = 'tiquetas';
$string['last'] = 'última';
$string['lessthan'] = 'menor que';
$string['listperpage'] = 'Número de registros por página';
$string['listperpage_help'] = 'Configurar el número de registros a mostrar en una plantilla de lista.';
$string['lockerror'] = 'No pudo bloquearse la base de datos. Acción cancelada.';
$string['manage_cleardata'] = 'Eliminar datos';
$string['manage_manage'] = 'Gestionar';
$string['maxentries'] = 'Máximo de registros';
$string['maxentries_help'] = 'El número máximo de registros que puede contener la base de datos.';
$string['maxentriesperuser'] = 'Máximo de registros por usuario';
$string['maxentriesperuser_help'] = 'El número máximo de registros que un usuario puede introducir en la base de datos.';
$string['maxentriesreached'] = 'Solamente pueden añadirse {$a} registros a esta base de datos. Este límite se ha alcanzado. No pueden añadirse más registros.';
$string['modulename'] = 'DataPlus';
$string['modulenameplural'] = 'Bases de datos de cursos';
$string['more'] = 'más';
$string['na'] = 'N\\A';
$string['navigationlimit'] = 'Límite de navegación';
$string['navigationlimit_help'] = 'El número máximo de ligas de navegación que pueden aparecer en el encabezado o el pie de página de un apantalla generada en una vista.';
$string['next'] = 'siguiente';
$string['none'] = 'ninguno';
$string['numnotapproved'] = 'Pendiente';
$string['options'] = 'Opciones - una por línea';
$string['pluginadministration'] = 'Administración de DataPlus';
$string['pluginname'] = 'DataPlus';
$string['previous'] = 'previo';
$string['rate'] = 'valorar';
$string['record'] = 'Registro';
$string['record_count'] = 'Conteo de registros';
$string['record_navigation'] = 'Navegación de registro';
$string['record_no'] = 'Número de registro';
$string['recordadded'] = 'Registro añadido.Añadir otro...';
$string['recordaddedaddanother'] = 'Registro añadido. Añadir otro...';
$string['recordcount'] = 'registros {$a->start} - {$a->end} de {$a->total}';
$string['recordcountsingle'] = 'registro {$a->start} de {$a->end}';
$string['recorddeleted'] = 'Registro exitosamente eliminado.';
$string['requiredentries'] = 'Registros requeridos';
$string['requiredentries_help'] = 'El número de registros que se le pide a un participante que suba. Los usuarios verán un mensaje recordatorio mostrado mientras vean en el caso de que no hayan enviado el número requerido de registros. La actividad no se considerará completa hasta que el usuario haya enviado el número de registros requerido.';
$string['requiredentriesreminder'] = 'A Usted se le ha requerido crear {$a->total} registros en la base de datos para completar este ejercicio. Hasta ahora lleva creados {$a->created} registros.';
$string['requiredentriestoview'] = 'Registros requeridos antes de vista';
$string['requiredentriestoview_help'] = 'El número de registros que debe enviar un participante antes de que se le permita ver algún registro en esta actividad de base de datos.';
$string['requiredentriestoviewdone'] = 'Usted ha ingresado {$a} registros en la base de datos. Ahora puede ver registros.';
$string['requiredentriestoviewreminder'] = 'Usted debe crear {$a->total} registros en la base de datos para que puedar ver registros. Hasta hora lleva creeados {$a->created} registros.';
$string['reserved'] = '{$a} es un nombre de campo reservado. Por favor use otro.';
$string['reset'] = 'Reiniciar';
$string['resettemplate'] = 'Reiniciar plantilla';
$string['returntofields'] = 'Regresar a lista de campos';
$string['samename'] = 'Ya existe un campo con el mismo nombre o uno muy similar. Por favor altere el nombre del campo e inténtelo de nuevo.';
$string['save'] = 'Guardar';
$string['saveandview'] = 'Añadir y ver';
$string['saveandviewbuttonlabel'] = 'Añadir y ver etiqueta de botón';
$string['saveandviewbuttonlabel_help'] = 'El texto del botón para enviar para añadir una entrada en la base de datos y después verla inmediatamente.';
$string['savebuttonlabel'] = 'Etiqueta de botón guardar';
$string['savebuttonlabel_help'] = 'El texto del botón para enviar su entrada en la base de datos.';
$string['search'] = 'Buscar';
$string['searchempty'] = 'Su búsqueda no arrojó resultados';
$string['searchtablabel'] = 'Etiqueta de pestaña Buscar';
$string['searchtabvisible'] = 'Pestaña Buscar visible';
$string['simplesearch'] = 'Búsqueda simple';
$string['since'] = 'desde';
$string['single_record'] = 'Registro único';
$string['singlerecordtablabel'] = 'Etiqueta de pestaña registro único';
$string['singlerecordtabvisible'] = 'Pestaña registro único visible';
$string['size'] = 'Tamaño';
$string['sort'] = 'Ordenar';
$string['sort1'] = 'Ordenar nivel 1';
$string['sort2'] = 'Ordenar nivel 2';
$string['sort3'] = 'Ordenar nivel 3';
$string['sortorder'] = 'Ordenar en órden';
$string['suppdesc'] = '{$a} descriptor';
$string['tablabel'] = 'Etiqueta de pestaña';
$string['tablabel_help'] = 'Especifica la etiqueta usada para esta pestaña y la navegación del módulo.';
$string['tabvisible'] = 'Pestaña visible';
$string['tabvisible_help'] = 'Especifica si es que esta pestaña debería estar visible para los estudiantes y maestros. Tome nota de que las configuraciones previas de estudiantes y maestros pueden anular esta configuración.';
$string['templates'] = 'Plantillas';
$string['templates_addrecord'] = 'Añadir / editar plantilla de registro';
$string['templates_hooks'] = 'Ganchos de Plantilla DataPlus';
$string['templates_hookshelp'] = 'Ayuda con ganchos de plantilla';
$string['templates_hookstext'] = '<h1>Gachos de Plantilla DataPlus</h1> <p>Las plantillas DataPlus le permiten a los autores de plantilla añadir ganchos que hacen que los datos se añadan a la salida de una plantilla. Esto puede ser útil para mostrar datos en pantalla o incluirlos en JavaScript. La mayoría de los ganchos se muestran en los menús del editor de plantillas, pero actualmente hay demasiados de estos para que se vean todos. aquellos que no se ven en el menú se pueden escribir en la caja relevante.</p>

<p>No todos los ganchos son apropiados para usarse en cada una de las secciones de la plantilla (CSS, JavaScript, funciones JavaScript, Header, Record, Footer). Las secciones en donde puede mostrarse un gancho se muestran debajo.</p>

<h2>Campos de la Base de Datos</h2> <p>Estos ganchos se usan para mostrar los campos que Usted haya creado en su base de datos empleando la pantalla de gestión. Remplace <em>fieldname</em> con el nombre del campo que quiera exponer.</p>

<p><strong>Gancho: </strong>[[<em>fieldname</em>]]<br/> <strong>Descripción: </strong>El contenido del campo de la base de datos con el HTML apropiado. El contenido de del tipo de campo imagen está incluido en una marca (tag) HTML img. Los archivos están dsponibles como un enlace usando el HTML como marca (tag). Las URLs están incluídas dentro de una marca (tag). En las plantillas de añadir registro, esto crea una entrada para datos y muestra dichos datos en modo de edición.<br/> <strong>Secciones: </strong>Record</p> <p><strong>Hook: </strong>[[<em>fieldname</em>_esca]]<br/> <strong>Descripción: </strong>El contenido de un campo de base de datos como en [[<em>fieldname</em>]] con apóstrrofes escapados. No disponible en plantillas de añadir registro.<br/>

<strong>Secciones: </strong>Record</p> <p><strong>Hook: </strong>[[comment]]<br/> <strong>Descripción: </strong>Esto muestra un comentario de registro. Solamente disponible en la plantilla de registro sencillo.<br/> <strong>Secciones: </strong>Record</p> <h2>Record Actions</h2> <p>No disponible en plantillas de añadir registro.</p>

<p><strong>Hook: </strong>**editar**<br/> <strong>Descripción: </strong>Enlace hacia una pantalla de edición para un registro.<br/> <strong>Secciones: </strong>Record</p>

<p><strong>Hook: </strong>**eliminar**<br/> <strong>Descripción: </strong>Enlace hacia una pantalla de eliminar para un registro.<br/> <strong>Secciones: </strong>Record</p>

<p><strong>Hook: </strong>**valuar**<br/> <strong>Descripción: </strong>Muestra un desplegado para valuar y/o un enlace a pantalla emergente de valoraciones. Los usuarios requieren las capacidades correctas para valorar.<br/> <strong>Secciones: </strong>Record</p>

<h2>Información de Registro Adicional</h2> <p>La información de creador y actualizador puede ser la misma si el registro no sido actualizado nunca. No está disponible para plantillas de añadir registros.</p>

 <p><strong>Hook: </strong>##id##<br/> <strong>Descripción: </strong>La clave primaria del registro actual.<br/> <strong>Secciones: </strong>Record</p>

<p><strong>Hook: </strong>##Creador##<br/> <strong>Descripción: </strong>El nombre del usuario que creó el registro.<br/> <strong>Secciones: </strong>Record</p>

<p><strong>Hook: </strong>##ID del Creador##<br/> <strong>Descripción: </strong>La ID de Moodle del usuario que creó el registro.<br/> <strong>Secciones: </strong>Record</p>

<p><strong>Hook: </strong>##Creado##<br/> <strong>Descripción: </strong>La fecha y hora cuando el registro fue creado.<br/> <strong>Sections: </strong>Record</p>

<p><strong>Hook: </strong>##Actualizador##<br/> <strong>Descripción: </strong>El nombre del usuario que actualizó or última vez el registro.<br/> <strong>Secciones: </strong>Record</p>

<p><strong>Hook: </strong>##Updater id##<br/> <strong>Description: </strong>The Moodle user id of the user who last updated the record.<br/> <strong>Sections: </strong>Record</p> <p><strong>Hook: </strong>##Updated##<br/> <strong>Description: </strong>The date on which the record was last updated.<br/> <strong>Sections: </strong>Record</p> <p><strong>Hook: </strong>##Group id##<br/> <strong>Description: </strong>The group with which the record is associated. Set to 0 if the record is associated with all participants.<br/> <strong>Sections: </strong>Record</p> <p><strong>Hook: </strong>##Record number##<br/> <strong>Description: </strong>Number of the current record on the page.<br/> <strong>Sections: </strong>Record</p> <h2>Header / Footer Functions</h2> <p>Not available in add record templates.</p> <p><strong>Hook: </strong>##Record count##<br/> <strong>Description: </strong>The number/s of the records shown on the current screen and total in the database.<br/> <strong>Sections: </strong>Header, Footer</p> <p><strong>Hook: </strong>##Record navigation##<br/> <strong>Description: </strong>Links to pages of records (does nothing if all records can be displayed on one screen).<br/> <strong>Sections: </strong>Header, Footer</p> <h2>Moodle Information</h2> <p><strong>Hook: </strong>--username--<br/> <strong>Description: </strong>The username of the current Moodle user.<br/> <strong>Sections: </strong>All</p> <p><strong>Hook: </strong>--firstname--<br/> <strong>Description: </strong>The first name of the current Moodle user.<br/> <strong>Sections: </strong>All</p> <p><strong>Hook: </strong>--lastname--<br/> <strong>Description: </strong>The last name of the current Moodle user.<br/> <strong>Sections: </strong>All</p> <p><strong>Hook: </strong>--courseid--<br/> <strong>Description: </strong>The id of the current Moodle course.<br/> <strong>Sections: </strong>All</p> <p><strong>Hook: </strong>--coursename--<br/> <strong>Description: </strong>The full name of the current Moodle course.<br/> <strong>Sections: </strong>All</p> <p><strong>Hook: </strong>--courseshortname--<br/> <strong>Description: </strong>The short name of the current Moodle course.<br/> <strong>Sections: </strong>All</p> <p><strong>Hook: </strong>--roles--<br/> <strong>Description: </strong>The short names of the current user’s Moodle roles in a comma delimited list.<br/> <strong>Sections: </strong>All</p> <p><strong>Hook: </strong>--rolesjs--<br/> <strong>Description: </strong>The short names of the current user’s Moodle roles in a JavaScript array.<br/> <strong>Sections: </strong>All</p> <p><strong>Hook: </strong>--groupids--<br/> <strong>Description: </strong>The ids of the current user’s Moodle groups in a comma delimited list.<br/> <strong>Sections: </strong>All</p> <p><strong>Hook: </strong>--groupidsjs--<br/> <strong>Description: </strong>The ids of the current user’s Moodle groups in a JavaScript array.<br/> <strong>Sections: </strong>All</p> <p><strong>Hook: </strong>--groupnames--<br/> <strong>Description: </strong>The names of the current user’s Moodle groups in a comma delimited list.<br/> <strong>Sections: </strong>All</p> <p><strong>Hook: </strong>--groupnamesjs--<br/> <strong>Description: </strong>The names of the current user’s Moodle groups in a JavaScript array.<br/> <strong>Sections: </strong>All</p>';
$string['templates_single'] = 'Plantilla de registro único';
$string['templates_view'] = 'Ver plantilla';
$string['templateupdated'] = 'plantilla actualizada';
$string['templateupdatednot'] = 'Ha ocurrido un problema. La plantilla no fue actualizada';
$string['true'] = 'verdadero';
$string['twosame'] = 'Dos o más campos tienen la misma etiqueta. Las etiquetas deben ser únicas. Por favor corrija esto antes de proceder.';
$string['unlimited'] = 'ilimitada';
$string['updated'] = 'Actualizada';
$string['updater'] = 'Actualizador';
$string['updaterid'] = 'ID del actualizador';
$string['updatinggrades'] = 'Actualizando calificaciones DataPlus ({$a}).';
$string['usercompleted_deleted'] = 'Número de registros eliminados: {$a}';
$string['usercompleted_insert'] = 'Número de registros creados: {$a}';
$string['usercompleted_updated'] = 'Número de registros actualizados: {$a}';
$string['usercompleted_view'] = 'Número de registros vistos: {$a}';
$string['useroutline_createcolumn'] = 'Número de nuevos campos creados:';
$string['useroutline_delete'] = 'Número de registros eliminados:';
$string['useroutline_deletecolumn'] = 'Número de campos eliminados:';
$string['useroutline_editcolumn'] = 'Número de campos editados:';
$string['useroutline_insert'] = 'Número de nuevos registros creados:';
$string['useroutline_noactivity'] = 'No se encontró actividad para este usuario.';
$string['useroutline_search'] = 'Número de búsquedas:';
$string['useroutline_templatesaved'] = 'Número de veces que una plantilla ha sido actualizada:';
$string['useroutline_update'] = 'Número de registros actualizados:';
$string['useroutline_view'] = 'Número de registros vistos:';
$string['validate_file_suffix'] = 'Falló la subida - El archivo debe ser de tipo ZIP.';
$string['validate_no_db'] = 'Falló la subida -  no se encontró base de datos dentro del archivo ZIP.';
$string['validate_table_column'] = 'Falló la validación de base de datos - no existe la tabla de columna.';
$string['validate_table_content'] = 'Falló la validación de base de datos - no existe la tabla de contenido.';
$string['validate_table_supportinginfo'] = 'Falló la validación de base de datos - no existe la tabla de información de soporte.';
$string['validate_table_templates'] = 'Falló la validación de base de datos - no existe la tabla de plantillas.';
$string['validate_toomanytables'] = 'Falló la validación de base de datos - la base de datos subida contiene demasiadas tablas para usarse en Base de datos 2.';
$string['view'] = 'Vista';
$string['viewdb'] = 'Ver base de datos';
$string['viewfromdate'] = 'Visible desde';
$string['viewtablabel'] = 'Etiqueta de pestaña Ver';
$string['viewtabvisible'] = 'Pestaña Ver visible';
$string['viewtodate'] = 'Visible para';
