<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'block_disealytics', language 'es_mx', version '5.1'.
 *
 * @package     block_disealytics
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['Apr'] = 'Abril';
$string['Aug'] = 'Agosto';
$string['Dec'] = 'Diciembre';
$string['Feb'] = 'Febrero';
$string['Friday'] = 'Viernes';
$string['Jan'] = 'Enero';
$string['Jul'] = 'Julio';
$string['Jun'] = 'Junio';
$string['Mar'] = 'Marzo';
$string['May'] = 'Mayo';
$string['Monday'] = 'Lunes';
$string['Nov'] = 'Noviembre';
$string['Oct'] = 'Octubre';
$string['Saturday'] = 'Sábado';
$string['Sep'] = 'Septiembre';
$string['Sunday'] = 'Domingo';
$string['Thursday'] = 'Jueves';
$string['Tuesday'] = 'Martes';
$string['Wednesday'] = 'Miércoles';
$string['activity-view'] = 'Actividad';
$string['activity-view_help_info_text'] = '¡Echa un vistazo a su tiempo de aprendizaje! Los segmentos de colores representan diferentes actividades y su altura indica la duración de cada actividad. En el diagrama de actividades se agrupan varios valores según tus actividades en Moodle. Estos valores pueden variar según la actividad. El sistema analiza todas las actividades y las agrupa, y las actividades con mayor duración se muestran en el diagrama de actividades.';
$string['activity-view_help_info_text_expanded'] = 'En la vista de detalles de la tarjeta de actividad, usted puede ver el diagrama familiar de resúmenes de su curso y gráficos adicionales de sus actividades con información extra.';
$string['activity_view_axislabel_y'] = 'eje Y: minutos';
$string['activity_view_detail_axislabel_x'] = 'eje X: semanascalendario';
$string['activity_view_expanded_subtitle'] = 'Ingresos mensuales';
$string['activity_view_main_axislabel_x'] = 'eje X: días';
$string['activity_view_refresh'] = 'Última actualización';
$string['activityview'] = 'Vista general de actividad';
$string['activityviewsetting'] = 'Mostrar Vista general de actividad';
$string['add-learning-material'] = 'Añadir material de aprendizaje del curso';
$string['add_activity_view'] = 'Añadir \'Actividad\'';
$string['add_assignment_view'] = 'Añadir \'Tareas\'';
$string['add_learning_goals_view'] = 'Añadir \'Objetivos de aprendizaje\'';
$string['add_planner_view'] = 'Añadir \'Asistente de planeación\'';
$string['add_progress_bar_view'] = 'Añadir \'Barra de progreso\'';
$string['add_statistic-insights_view'] = 'Añadir \'intuiciones (predicciones) estadísticas\'';
$string['add_study_progress_view'] = 'Añadir \'Progreso del Estudio\'';
$string['add_success_chance_view'] = 'Añadir \'PVL-Probabilidad\'';
$string['add_view_button'] = 'Añadir tarjeta';
$string['agree'] = '<strong>Acepto</strong> que mis datos de registro de Moodle, así como los datos de los exámenes, se transmitan al proyecto DiSEA, se almacenen y se utilicen para fines de investigación.';
$string['analytics_at_risk:explanation'] = 'Estudiante en riesgo de abandonar el curso';
$string['analytics_at_risk:explanation_help'] = 'El modelo analítico predice la probabilidad de que un estudiante abandone un curso en función de su actividad y participación. Analiza factores como inicios de sesión, publicaciones en foros, envíos de tareas y otras interacciones para proporcionar una estimación de su nivel de participación. Esta es sólo una predicción y debe utilizarse como guía en lugar de un resultado definitivo, animando a los estudiantes a mantenerse activos y buscar apoyo si es necesario.';
$string['analytics_at_risk:explanation_link'] = 'Estudiantes_en_riesgo_de abandonar_el_curso';
$string['analytics_completion:explanation'] = 'Finalización del curso';
$string['analytics_completion:explanation_help'] = 'La finalización del curso está habilitada en este curso. Vea su progreso actual al completar el curso a continuación.';
$string['analytics_completion:explanation_link'] = 'Finalización_del_curso';
$string['analytics_daysaccum'] = 'Todos los días anteriores';
$string['analytics_daysaccum_help'] = 'Este intervalo de análisis divide el curso en días, y cada predicción se basa en los datos acumulados de todos los días anteriores.';
$string['analytics_pastday'] = 'Día anterior';
$string['analytics_pastday_help'] = 'Este análisis de intervalo genera predicciones todos los días. Los cálculos de los indicadores se basarán en el día anterior.';
$string['assignment'] = 'Tarea';
$string['assignment-view'] = 'Tareas';
$string['assignment-view_help_info_text'] = '<p>La tarjeta \'Tareas\' muestra todas las tareas del curso disponibles para ti y el estado actual de la tarea. Cuando haga clic en el enlace de una tarea, será redirigido a la página con los detalles de esa tarea.</p> <p style=\'color: var(--primary)\'>Significados de los símbolos:</p> <p> <span style=\'color: var(--primary)\'>Estado neutral (círculo gris):</span> El círculo gris representa el estado neutral de la tarea. No se requiere ninguna acción. <p> <span style=\'color: var(--primary)\'>No aprobada (\'X\' roja):</span> La \'X\' roja indica que la tarea respectiva ha sido evaluada pero no aprobada. Para obtener más detalles, haga clic en el enlace de la tarea. <p> <span style=\'color: var(--primary)\'>Aún no se ha intentado (\\\'X\\\' gris):</span> La \\\'X\\\' gris indica que la tarea respectiva aún no se ha enviado/intentado. Para obtener más detalles, haga clic en el enlace de la tarea. <p><span style=\'color: var(--primary)\'>Incompleto (señal de advertencia amarilla):</span> La señal de advertencia amarilla indica que la tarea está incompleta, no se puede intentar aún debido a que faltan requisitos o es posible que se haya enviado después de la fecha de entrega. Además, puede indicar que la tarea no se ha aprobado, pero es posible realizar más intentos. Para obtener más detalles, haga clic en el enlace de la tarea. <p><span style=\'color: var(--primary)\'>Enviado a tiempo (marca de verificación gris):</span> La marca de verificación gris indica que la entrega se realizó a tiempo. Para obtener más detalles, haga clic en el enlace de la tarea. <p> <span style=\'color: var(--primary)\'>Incompleto/Advertencia (señal de advertencia amarilla):</span> La señal de advertencia amarilla indica que la tarea está incompleta, no se puede intentar todavía debido a que faltan requisitos o puede haberse enviado después de la fecha de entrega. Además, puede indicar que la tarea no se ha aprobado, pero que es posible realizar más intentos. Para obtener más detalles, haga clic en el enlace de la tarea. <p> <span style=\'color: var(--primary)\'>Enviado a tiempo (marca de verificación gris): </span> La marca de verificación gris indica que la entrega se realizó a tiempo. Para obtener más detalles, haga clic en el enlace de la tarea. <p> <span style=\'color: var(--primary)\'>Marcado como completado por usted mismo (marca de verificación amarilla): </span> La marca de verificación amarilla indica que el estudiante ha marcado la tarea como completa, pero es posible que aún deba ser revisada por el instructor. Para obtener más detalles, haga clic en el enlace de la tarea. <p><span style=\'color: var(--primary)\'>Aprobado (marca de verificación verde): </span> La marca de verificación verde indica que se aprobó la tarea. Para obtener más detalles, haga clic en el enlace de la tarea.';
$string['assignment-view_help_info_text_expanded'] = '<p>La tarjeta \'Tareas\' muestra todas las tareas del curso disponibles para ti y el estado actual de la tarea. Cuando hagas clic en el enlace de una tarea, usted será redirigido a la página con los detalles de esa tarea.</p> <p style=\'color: var(--primary)\'>Significados de los símbolos:</p> <p> <span style=\'color: var(--primary)\'>Estado neutral (círculo gris):</span> El círculo gris representa el estado neutral de la tarea. No se requiere ninguna acción. <p> <span style=\'color: var(--primary)\'>No aprobada (\'X\' roja):</span> La \'X\' roja indica que la tarea respectiva ha sido evaluada pero no aprobada. Para obtener más detalles, haga clic en el enlace de la tarea. <p> <span style=\'color: var(--primary)\'>Aún no se ha intentado (\\\'X\\\' gris):</span> La \\\'X\\\' gris indica que la tarea respectiva aún no se ha enviado/intentado. Para obtener más detalles, haga clic en el enlace de la tarea. <p><span style=\'color: var(--primary)\'>Incompleto (señal de advertencia amarilla):</span> La señal de advertencia amarilla indica que la tarea está incompleta, no se puede intentar aún debido a que faltan requisitos o es posible que se haya enviado después de la fecha de entrega. Además, puede indicar que la tarea no se ha aprobado, pero es posible realizar más intentos. Para obtener más detalles, haga clic en el enlace de la tarea. <p><span style=\'color: var(--primary)\'>Enviado a tiempo (marca de verificación gris):</span> La marca de verificación gris indica que la entrega se realizó a tiempo. Para obtener más detalles, haga clic en el enlace de la tarea. <p> <span style=\'color: var(--primary)\'>Incompleto/Advertencia (señal de advertencia amarilla):</span> La señal de advertencia amarilla indica que la tarea está incompleta, no se puede intentar todavía debido a que faltan requisitos o puede haberse enviado después de la fecha de entrega. Además, puede indicar que la tarea no se ha aprobado, pero que es posible realizar más intentos. Para obtener más detalles, haga clic en el enlace de la tarea. <p> <span style=\'color: var(--primary)\'>Enviado a tiempo (marca de verificación gris): </span> La marca de verificación gris indica que la entrega se realizó a tiempo. Para obtener más detalles, haga clic en el enlace de la tarea. <p> <span style=\'color: var(--primary)\'>Marcado como completado por usted mismo (marca de verificación amarilla): </span> La marca de verificación amarilla indica que el estudiante ha marcado la tarea como completa, pero es posible que aún deba ser revisada por el instructor. Para obtener más detalles, haga clic en el enlace de la tarea. <p><span style=\'color: var(--primary)\'>Aprobado (marca de verificación verde): </span> La marca de verificación verde indica que se aprobó la tarea. Para obtener más detalles, haga clic en el enlace de la tarea.';
$string['assignment_info_text'] = 'Aquí usted puede ver el estado de las tareas disponibles en el curso.';
$string['assignment_view'] = 'Tareas';
$string['assignment_view_hover_failed'] = 'Tarea falló';
$string['assignment_view_hover_incomplete'] = 'Tarea incompleta, enviada después de la fecha límite, con requisitos faltantes o reprobada en primer intento.';
$string['assignment_view_hover_neutral'] = 'Estado neutral. No se requiere acción';
$string['assignment_view_hover_notsubmitted'] = 'Tarea aun no enviada';
$string['assignment_view_hover_okay'] = 'Tarea pasada';
$string['assignment_view_hover_selfcheck'] = 'Tarea ha sido auto-marcada como completada, pero podría necesitar ser revisada por el instructor.';
$string['assignment_view_hover_submitted'] = 'Tarea enviada pero aun no evaluada';
$string['assignment_view_load-less-assignments'] = 'Mostrar menos';
$string['assignment_view_no_assignments_available'] = 'Usted no está inscrito en el semestre seleccionado en ningún curso que contenga tareas.';
$string['assignment_view_specific_scale'] = 'reprobado, retrabajar, pasado';
$string['assignmentscore'] = 'Valoraciones de Tarea';
$string['assignmentviewsetting'] = 'Mostrar vista general de tarea';
$string['back'] = 'Regresar';
$string['calendarweeks'] = 'Semanas calendario';
$string['change-to-expandable-view'] = 'Ir a vista de detalles ...';
$string['choice_no'] = 'Usted ha declinado el consentimiento';
$string['choice_yes'] = 'Usted ha aceptado el consentimiento';
$string['cognitive_indicators'] = 'Cognitivo';
$string['config_componentlist_text'] = 'Esta configuración le permite subir un archivo CSV con nombres de componentes a ser reemplazados.';
$string['config_componentlist_title'] = 'CSV de componente para re-definición de componente';
$string['config_consent_description'] = 'Por favor escriba su declaración de consentimiento aquí como un texto con formato HTML.';
$string['config_consent_text'] = 'Su declaración de consentimiento';
$string['config_counter_text'] = 'Este contador puede ser usado para controlar cuando debería ser mostrada la declaración de consentimiento a los estudiantes.';
$string['config_counter_title'] = 'Contador para mostrar la declaración de consentimiento';
$string['config_filterfile_text'] = 'Esta configuración le permite subir un archivo CSV con evento, destino y nombres de acción a ser filtrada.';
$string['config_filterfile_title'] = 'Archivo CSV para filtrado de evento';
$string['consent_config_btn_cancel'] = 'Cancelar';
$string['consent_config_btn_delete'] = 'Eliminar datos y revocar consentimiento';
$string['consent_config_btn_save'] = 'Conservar datos y revocar consentimiento';
$string['consent_config_desc'] = '¿Desea revocar su consentimiento para el tratamiento de datos? En ese caso, el Tablero del Estudiante ya no podrá utilizarse y se eliminarán los siguientes datos:';
$string['consent_config_link'] = 'Leer política de privacidad';
$string['consent_config_list_item_1'] = 'Objetivos de aprendizaje auto-definidos';
$string['consent_config_list_item_2'] = 'Configuraciones de la barra de progreso (ingresar materiales de aprendizaje)';
$string['consent_config_list_item_3'] = 'Fechas del \'Aistente de Planeación\'';
$string['consent_config_title'] = 'Procesamiento de Datos';
$string['consent_start_btn'] = 'Dar consentimiento y usar plugin';
$string['consent_start_msg'] = 'Por favor de su consentimiento para procesamiento de datos para poder usar el plugin.';
$string['course_alert'] = 'El Tablero del Estudiante solo puede ser mostrado en la página principal del curso.';
$string['courseviews'] = 'Vistas de curso';
$string['courseviewsAM'] = 'Vistas de curso AM';
$string['courseviewsPM'] = 'Vistas de curso PM';
$string['courseviewsperday'] = 'Vistas de curso por día';
$string['courseviewsperweek'] = 'Vistas de curso por semana';
$string['current_semester'] = 'Semestre actual';
$string['data_entry_view'] = 'Entrada de datos';
$string['database_insert'] = 'Registrado exitosamente en la base de datos';
$string['database_update'] = 'Base de datos actualizada exitosamente';
$string['delete'] = 'Eliminar';
$string['disagree'] = '<strong>No doy mi consentimiento</strong> para que mis datos de registro de Moodle, así como los datos de los exámenes, se transmitan al proyecto DiSEA, se almacenen y se utilicen para fines de investigación.';
$string['disea'] = 'Tablero del Estudiante';
$string['disealytics:addinstance'] = 'Añadir unnuevo bloque de Tablero del Estudiante';
$string['disealytics:editlearnerdashboard'] = 'Editar el Tablero del Estudiante';
$string['disealytics:myaddinstance'] = 'Añadir un nuevo Tablero del Estudiante a mi tablero';
$string['diseasettings'] = 'Configuraciones del Tablero del Estudiante';
$string['download'] = 'Descargar';
$string['due'] = 'Vencimiento hasta';
$string['edit'] = 'Editar';
$string['editing_mode_setting'] = 'Activar modo de edición';
$string['editingno'] = 'Modo de edición desactivado en el Tablero del Estudiante.';
$string['editingyes'] = 'Modo de edición activado en el Tablero del Estudiante.';
$string['exit_editing_mode'] = 'Salir del modo de edición';
$string['expandedno'] = 'Ninguna vista en el Tablero del Estudiante está expandida.';
$string['general_indicators'] = 'Resumen';
$string['goal_date_input'] = 'Fecha';
$string['goal_date_missing'] = 'Por favor escriba una fecha para el objetivo de aprendizaje';
$string['goal_editing'] = 'Desactivar edición';
$string['goal_input_cancel'] = 'Cancelar';
$string['goal_input_save'] = 'Añadir objetivo de aprendizaje';
$string['goal_input_update'] = 'Actualizar';
$string['goal_limit'] = 'Usted ha alcanzado el número máximo de objetivos de aprendizaje.';
$string['goal_name_invalid'] = 'Por favor use solamente letras, números, espacios y los caracteres especiales "?!".';
$string['goal_name_missing'] = 'Por favor escriba un título para el objetivo de aprendizaje.';
$string['goal_placeholder'] = 'Nuevo objetivo de aprendizaje...';
$string['goals_finished_past'] = 'Logrado';
$string['goals_infuture'] = 'En el futuro';
$string['goals_reached'] = 'Objetivos de aprendizaje alcanzados.';
$string['goals_thismonth'] = 'Este mes';
$string['goals_thisweek'] = 'Esta semana';
$string['goals_today'] = 'Hoy';
$string['goals_tomorrow'] = 'Mañana';
$string['grade'] = 'CAlificación';
$string['last_refresh'] = 'Últimos datos de {$a}';
$string['learning-goals-view'] = 'Objetivos de Aprendizaje';
$string['learning-goals-view_help_info_text'] = 'En la tarjeta “Objetivos de aprendizaje” se muestran los objetivos individuales de los estudios. Pulsando el botón “Nuevo objetivo de aprendizaje” en la parte superior, usted puede introducir una breve descripción del objetivo y fijar una fecha concreta para alcanzarlo. Una vez alcanzado el objetivo, usted puede marcarlo como completado mediante la casilla de verificación. Los objetivos se encuentran ordenados cronológicamente en las pestañas “Hoy”, “Mañana”, “Esta semana”, “Este mes” y “En el futuro”. En la pestaña “Alcanzado” encontrará todos los objetivos que ya están marcados y podrá eliminarlos de la lista.';
$string['learning-goals-view_help_info_text_expanded'] = 'En la tarjeta “Objetivos de aprendizaje” se muestran los objetivos individuales de los estudios. Pulsando el botón “Nuevo objetivo de aprendizaje” en la parte superior, se puede introducir una breve descripción del objetivo y fijar una fecha individual para alcanzarlo. Una vez alcanzado el objetivo, se puede marcar como completado mediante la casilla de verificación. Los objetivos se pueden encontrar en orden cronológico en las pestañas “Hoy”, “Mañana”, “Esta semana”, “Este mes” y “En el futuro”. En la pestaña “Alcanzado” se encuentran todos los objetivos que ya están marcados y se pueden eliminar de la lista.';
$string['learning-goals_add_goal'] = 'Nuevo objetivo de aprendizaje';
$string['learning-goals_info_text'] = 'Configurar objetivos de aprendizaje individuales que usted quiere alcanzar para una fecha fija.';
$string['learning-materials-view'] = 'Añadir material de aprendizaje';
$string['learning_material_all_inputs_set'] = 'Usted añadió todos los materiales de aprendizaje disponibles del curso.';
$string['learning_material_cancel'] = 'Cancelar';
$string['learning_material_current_page'] = 'Página actual';
$string['learning_material_delete'] = 'Eliinar';
$string['learning_material_delete_success'] = 'El progreso de lectura fue eliminado exitosamente.';
$string['learning_material_document'] = 'Seleccionar documento';
$string['learning_material_edit'] = 'Editar';
$string['learning_material_expenditure_of_time_overflow_error'] = 'No se pueden guardar gastos de tiempo superiores a 500.';
$string['learning_material_expenditureoftime'] = 'Gasto de tiempo (en horas)';
$string['learning_material_last_page'] = 'Última página';
$string['learning_material_negative_page_error'] = 'Los números negativos no se pueden guardar como números de página ni como gasto de tiempo.';
$string['learning_material_no_document_selected_error'] = 'Por favor seleccione un documento antes de guardarlo.';
$string['learning_material_no_selection'] = 'Sin selección';
$string['learning_material_page_error'] = 'La página actual no puede ser mayor que la última página.';
$string['learning_material_page_overflow_error'] = 'Números de página mayores de 1000 no pueden ser guardados.';
$string['learning_material_page_zero_error'] = 'La última página no puede ser 0.';
$string['learning_material_pages'] = 'Páginas leídas';
$string['learning_material_pattern_error'] = 'Por favor use soplo números.';
$string['learning_material_save'] = 'Guardar';
$string['learning_material_save_success'] = 'El progreso de lectura fue guardado exitosamente.';
$string['learning_materials-view_help_info_text'] = '<p>Manténgase al día con su progreso de aprendizaje e indique su progreso aquí en los documentos del curso proporcionados. Para agregar un documento, haga clic en el botón debajo de "Agregar materiales de aprendizaje del curso".</p><p><strong>Documento:</strong > Seleccione un documento proporcionado en el curso.<p><strong>Página actual:</strong> Ingrese la página en la que se encuentra en el documento.<p><strong>Última página:</strong> Ingrese aquí cuántas páginas tiene el documento en total.</p><p><strong>Tiempo requerido (en horas):</strong> Ingrese aquí el tiempo requerido estimado.</p>
<p>Use el botón "Guardar" para completar el proceso y guardar el progreso en su área personal.</p>

<p>En "Gestionar materiales de aprendizaje del curso" puede editar los materiales que ya ha ingresado o eliminar el progreso de lectura individual de su área personal.</p>';
$string['login_alert'] = 'Por favor ingrese para usar el Tablero del Estudiante.';
$string['logins'] = 'Ingresos';
$string['loginspermonth'] = 'Ingresos por mes';
$string['loginsperweek'] = 'Ingresos por semana';
$string['main_add_view_info_text'] = 'Seleccionar las tarjetas que le gustaría que se mostraran en el Tablero del Estudiante.';
$string['main_add_view_info_text_empty'] = 'Usted ha añadido todas las tarjetas disponibles.';
$string['main_add_view_title'] = 'Añadir tarjetas';
$string['main_config_consent_desc'] = 'Usted ha dado consentimiento al procesamiento de datos.';
$string['main_config_consent_title'] = 'Procesamiento de datos';
$string['main_config_desc'] = 'Usted ha configurado aquí el Tablero del Estudiante.';
$string['main_config_title'] = 'Configuración';
$string['main_help_activity-view'] = 'La tarjeta <span style="color:var(--primary)">Actividad</span> muestra tu tiempo de aprendizaje de un vistazo. Los segmentos de colores representan diferentes actividades y su altura muestra la duración de cada actividad.';
$string['main_help_add_remove_summary'] = 'Para agregar o eliminar tarjetas en el Tablero del Estudiante, puede proceder de la siguiente manera:<br>
1. Haga clic en el ícono del lápiz para activar el modo de edición.<br>
2. Para eliminar una tarjeta: busque la tarjeta deseada y haga clic en el símbolo X en la esquina superior derecha de la tarjeta.<br>
3. Para agregar nuevas tarjetas: desplácese hacia abajo de las tarjetas que ya ha seleccionado. Allí, encontrará la opción para agregar tarjetas adicionales al Tablero Seleccione las tarjetas deseadas y agréguelas a su Tablerol.';
$string['main_help_add_remove_title'] = 'Añadiendo o quitando tarjetas';
$string['main_help_assignment-view'] = 'La tarjeta <span style="color:var(--primary)">Tareas</span> enumera todas las tareas de entrega que están disponibles para usted en los módulos correspondientes y muestra el estado actual de la tarea.';
$string['main_help_edit_summary'] = 'Haga clic en el icono del lápiz para iniciar la función de edición para añadir o eliminar tarjetas en el Tablerol. Puede utilizar esta función para personalizar su Tablero con las tarjetas que sean relevantes para usted. Haga clic en la X roja de la tarjeta correspondiente para eliminarla. Puede añadir una nueva tarjeta seleccionando el botón «Añadir tarjeta». Este botón abre un nuevo diálogo con las tarjetas disponibles.';
$string['main_help_edit_title'] = 'Editando función';
$string['main_help_functionality_summary'] = '<strong>Icono de ayuda en el Tablero</strong><br>
Hay un icono de ayuda en todo el Tablero, al que se puede acceder a través de un <span style="color:var(--primary)">icono “?”</span>. Este icono proporciona a los usuarios un acceso rápido a la ayuda relacionada con el contexto y a explicaciones sobre cómo funciona el panel de control.
<br><br><strong>Símbolo de ayuda en las tarjetas</strong><br>
Cada tarjeta individual del Tablero también tiene un símbolo de ayuda. Al hacer clic en este icono en una tarjeta específica, se abre una vista detallada. Esta vista proporciona información detallada sobre el contenido de la tarjeta respectiva.';
$string['main_help_functionality_title'] = 'Funciones recurrentes dentro de las tarjetas';
$string['main_help_learning-goals-view'] = 'En la tarjeta <span style="color:var(--primary)">Objetivos de aprendizaje</span> puedes registrar cualquier objetivo de aprendizaje. También puedes utilizar esta función en todos los semestres.';
$string['main_help_planner-view'] = 'The card <span style="color:var(--primary)">Planning Assistent</span> shows you an overview of your upcoming web conference, submission tasks or other activities.';
$string['main_help_progress-bar-view'] = 'En la tarjeta <span style="color:var(--primary)">Barra de progreso</span> puedes agregar materiales de aprendizaje manualmente y recibir el progreso de lectura actual de tu lectura actual en forma de diagrama.';
$string['main_help_study-progress-view'] = 'El velocímetro de la tarjeta <span style="color:var(--primary)">Progreso del estudio</span> te muestra tu progreso de aprendizaje y cuánto te has acercado a tu objetivo. El cálculo se basa en las evaluaciones de las tareas que se te asignan en el curso.';
$string['main_help_success-chance-view'] = 'En la tarjeta <span style="color:var(--primary)">Probabilidad PVL</span> se muestran todos los trabajos presentados (incluidos los puntos de evaluación). La probabilidad PVL correspondiente se calcula a partir de los puntos de evaluación de cada trabajo presentado y se muestra como porcentaje.';
$string['main_help_title'] = 'Página de ayuda para el Tablero del Estudiante';
$string['main_help_viewmodes_summary'] = 'En el Tablero del Estudiante, usted puede ver todo el contenido en la vista <span style="color:var(--primary)">por módulo, semestre</span> o en la vista <span style="color:var(--primary)">completa</span><br><br><strong>Vista por módulo</strong><br>En la vista por módulo, se muestra el contenido específico del módulo en el que se encuentra actualmente. Obtiene una descripción detallada de todos los recursos y actividades que pertenecen a este módulo.<br><br><strong>Vista por semestre</strong><br>La vista por semestre le muestra todo el contenido de los módulos que está cursando en el semestre actual. Esta vista le permite obtener una visión integral de su semestre actual.<br><br><strong>Vista completa</strong><br>En la vista completa, puede acceder a todo el contenido de su programa de grado. Esto incluye todos los módulos y actividades que ha completado o está completando actualmente durante todo su programa de grado.';
$string['main_help_viewmodes_title'] = 'Vistas diferentes';
$string['main_help_views_summary'] = 'El Tablero del Estudiante (LD) contiene las llamadas <span style="color:var(--primary)">tarjetas</span> con diferentes informaciones y funciones. Puede <span style="color:var(--primary)">agregar</span> o <span style="color:var(--primary)">eliminar</span> tarjetas de tu LD. Hay numerosos temas entre los que elegir para crear su LD personal.<br><br>Puede obtener más información sobre los temas individuales a través de los <span style="color:var(--primary)">mensajes de ayuda</span> en las tarjetas correspondientes.';
$string['main_help_views_title'] = 'Clasificación de tarjetas';
$string['messageprovider'] = 'Proveedor de mensaje DISEA';
$string['messageprovider:logdata_disea'] = 'Proveedor de mensaje DISEA';
$string['missing_points'] = 'Puntos no alcanzados';
$string['mod_indicators'] = 'Estado de participación en las actividades del curso';
$string['mod_indicators_subtitle'] = 'Participación';
$string['modal_info_title'] = 'Información acerca de la tarjeta';
$string['modal_remove_cancel'] = 'Cancelar';
$string['modal_remove_check'] = 'Quitar tarjeta del Tablero del Estudiante';
$string['modal_remove_text_1'] = '¿Está seguro de querer quitar la tarjeta';
$string['modal_remove_text_2'] = 'del tablero? Usted puede añadirla de vuelta a su Tablero del Estudiante en cualquier momento.';
$string['modal_remove_title'] = 'Quitar tarjeta del Tablero';
$string['months'] = 'Meses';
$string['no-view-exists'] = 'Inicie el modo de edición para agregar tarjetas haciendo clic en el ícono del lápiz.';
$string['no_choice'] = 'Por favor decídase sobre una respuesta';
$string['nodata'] = 'No hay datos disponibles.';
$string['nouserconsent'] = 'DAr consentimiento al procesamiento de datos requerido.';
$string['pages_left'] = 'Páginas restantes';
$string['pages_read'] = 'Páginas leidas';
$string['planner-view'] = 'Asistente de Planeación';
$string['planner-view_friday_short'] = 'Vie';
$string['planner-view_global_label'] = 'Fechas en el mes';
$string['planner-view_help_info_text'] = 'Esta tarjeta le ofrece una descripción general de sus próximas conferencias web, tareas u otras actividades. Puede agregar más citas para el curso que se muestra actualmente simplemente haciendo clic en el día que desee. Puede ver todas las citas en la vista detallada.';
$string['planner-view_help_info_text_expanded'] = 'Esta tarjeta le ofrece una descripción general de sus próximas conferencias web, tareas u otras actividades. Puede agregar más citas para el curso que se muestra actualmente simplemente haciendo clic en el día que desee. Puede ver todas las citas en la vista detallada.';
$string['planner-view_infuture_label'] = 'En el futuro';
$string['planner-view_monday_short'] = 'Lu';
$string['planner-view_saturday_short'] = 'Sa';
$string['planner-view_sunday_short'] = 'Do';
$string['planner-view_thismonth_label'] = 'Este mes';
$string['planner-view_thursday_short'] = 'Jue';
$string['planner-view_today_label'] = 'Hoy';
$string['planner-view_tomorrow_label'] = 'Mañana';
$string['planner-view_tuesday_short'] = 'Mar';
$string['planner-view_wednesday_short'] = 'Mié';
$string['planner_add_event_modal'] = 'Añadir eventos al Asistente de Planeación';
$string['planner_add_event_modal_desc'] = 'Usted puede añadir un evento al Asistente de Planeación aquí';
$string['planner_cancel_event'] = 'Cancelar';
$string['planner_date_invalid'] = 'Por favor ingrese una hora correcta para el evento.';
$string['planner_delete_event'] = 'Eliminar';
$string['planner_edit_event'] = 'Editar';
$string['planner_event-details-activity'] = 'Acerca del evento';
$string['planner_event_course_label'] = 'Curso asociado';
$string['planner_event_date_label'] = 'Fecha';
$string['planner_event_duration-in-min_label'] = 'Duración en minutos';
$string['planner_event_duration_label'] = 'Duración';
$string['planner_event_location_label'] = 'Lugar';
$string['planner_event_location_placeholder'] = 'Este es el lugar';
$string['planner_event_name_label'] = 'Título';
$string['planner_event_name_placeholder'] = 'Nuevo evento';
$string['planner_event_no-end_label'] = 'Sin especificación de hora';
$string['planner_event_repetitions_label'] = 'Repetición semanal, generación automática';
$string['planner_event_repetitions_text'] = 'Repetir evento';
$string['planner_event_type_label'] = 'Tipo de evento';
$string['planner_event_type_value_1'] = 'Conferencia web';
$string['planner_event_type_value_2'] = 'Evento en-persona';
$string['planner_event_type_value_3'] = 'Misceláneo';
$string['planner_event_until_label'] = 'Hasta';
$string['planner_input_invalid'] = 'El evento no pudo ser creado. Por favor compruebe sus datos.';
$string['planner_name_invalid'] = 'Por favor use solamente letras, números, espacios y los caracteres especiales "?!.:-/@".';
$string['planner_name_missing'] = 'Por favor escriba un título para el evento.';
$string['planner_repetition_invalid'] = 'Por favor escriba un número correcto para las repeticiones.';
$string['planner_required_attribute'] = 'necesario';
$string['planner_save_event'] = 'Guardar';
$string['plannerdateno'] = 'El valor predeterminado del asistente de planeación,  ahora.';
$string['plugin-title'] = 'Tablero del Estudiante';
$string['pluginname'] = 'Tablero del Estudiante';
$string['privacy:metadata:block_disealytics_consent'] = 'Acuerdo con la política de privacidad';
$string['privacy:metadata:block_disealytics_statistics'] = 'Estadísticas de uso generadas por la tarea de estadísticas.';
$string['privacy:metadata:block_disealytics_user_dates'] = 'Eventos creados por el usuario para el asistente de planificación.';
$string['privacy:metadata:block_disealytics_user_goals'] = 'Objetivos de aprendizaje creados por los usuarios del Tablero del Estudiante.';
$string['privacy:metadata:block_disealytics_user_pages'] = 'Información sobre las páginas de documentos leídos, creadas por los usuarios del Tablero del Estudiante.';
$string['privacy:metadata:block_disealytics_user_tasks'] = 'Información de tarea creada por la tarea tasktransform, agrupando actividades en datos de registro.';
$string['privacy:metadata:consent_choice'] = 'La elección del usuario, 0 para rechazado 1 para aceptado.';
$string['privacy:metadata:consent_counter'] = 'Un contador para realizar un seguimiento de cuándo restablecer la información de consentimiento.';
$string['privacy:metadata:consent_timecreated'] = 'La hora en que se creó este registro de consentimiento.';
$string['privacy:metadata:consent_timemodified'] = 'La hora en que se modificó este registro de consentimiento.';
$string['privacy:metadata:consent_userid'] = 'La identificación del usuario con esta información de consentimiento.';
$string['privacy:metadata:preference:block_disealytics_editing'] = 'Indica si el usuario activó el modo de edición en el Tablero de aprendizaje.';
$string['privacy:metadata:preference:block_disealytics_expanded_view'] = 'La vista en la que el usuario ve detalles en el Tablero del Estudiante.';
$string['privacy:metadata:preference:block_disealytics_planner_currentdate'] = 'La fecha que la vista de planeador usa para seleccionar el mes mostrado.';
$string['privacy:metadata:preference:block_disealytics_viewmode'] = 'Almacena el modo de vista que el usuario seleccionó en el menú desplegable de modo de vista.';
$string['privacy:metadata:preference:block_disealytics_views'] = 'Almacena cuales vistas están activas en el Tablero del Estudiante.';
$string['privacy:metadata:preference:block_disealytics_viewsdescription'] = 'Datos serializados que describen qué vista se muestra en el Tablero del Estudiante. Se almacenan como objetos que contienen el nombre de la vista y si esa vista está habilitada (\'1\') o deshabilitada (\'0\').';
$string['privacy:metadata:user_dates_courseid'] = 'El ID del curso en el que se creó el registro de fechas.';
$string['privacy:metadata:user_dates_eventtype'] = 'El tipo de evento.';
$string['privacy:metadata:user_dates_location'] = 'La localización del evento.';
$string['privacy:metadata:user_dates_name'] = 'El nombre de la entrada.';
$string['privacy:metadata:user_dates_repeatid'] = 'El ID utilizado para realizar un seguimiento de eventos que se repiten periódicamente.';
$string['privacy:metadata:user_dates_timecreated'] = 'La hora en la que se creó este registro de fechas.';
$string['privacy:metadata:user_dates_timeduration'] = 'La duración del evento.';
$string['privacy:metadata:user_dates_timemodified'] = 'La última vez que este registro de fechas fue modificado.';
$string['privacy:metadata:user_dates_timestart'] = 'La hora de cuando inicia el evento.';
$string['privacy:metadata:user_dates_userid'] = 'El ID del usuario con esta información de fecha del planificador.';
$string['privacy:metadata:user_dates_usermodified'] = 'El ID del usuario que modificó el registro de fechas.';
$string['privacy:metadata:user_goal_courseid'] = 'El ID del curso en el que se creó el registro del objetivo.';
$string['privacy:metadata:user_goal_description'] = 'Una descripción del objetivo.';
$string['privacy:metadata:user_goal_duedate'] = 'La hora esperada para completar este objetivo está vencida.';
$string['privacy:metadata:user_goal_finished'] = 'Indica si el objetivo está terminado.';
$string['privacy:metadata:user_goal_timecompleted'] = 'La hora de cuando el usuario marcó este objetivo como completado.';
$string['privacy:metadata:user_goal_timecreated'] = 'La hora de cuando este registro de objetivo fue creado.';
$string['privacy:metadata:user_goal_timemodified'] = 'La hora de cuando este registro de objetivo fue modificado por última vez.';
$string['privacy:metadata:user_goal_userid'] = 'El ID del usuario con esta información de objetivo.';
$string['privacy:metadata:user_goal_usermodified'] = 'El ID del usuario que modificó el registro de objetivos.';
$string['privacy:metadata:user_pages_courseid'] = 'El ID del curso en el que se creó el registro de las páginas.';
$string['privacy:metadata:user_pages_currentpage'] = 'El número de páginas que leyó el usuario.';
$string['privacy:metadata:user_pages_expenditureoftime'] = 'El tiempo que el usuario empleó leyendo el documento.';
$string['privacy:metadata:user_pages_lastpage'] = 'El número total de páginas que tiene el documento.';
$string['privacy:metadata:user_pages_name'] = 'el nombre del documento que leyó el usuario.';
$string['privacy:metadata:user_pages_timecompleted'] = 'La hora de cuando el usuario marcó esta entrada de páginas como completada.';
$string['privacy:metadata:user_pages_timecreated'] = 'La hora en que se creó este registro de páginas.';
$string['privacy:metadata:user_pages_timemodified'] = 'La última vez que se modificó el registro de esta página.';
$string['privacy:metadata:user_pages_userid'] = 'La ID del usuario con esta información de página.';
$string['privacy:metadata:user_pages_usermodified'] = 'El ID del usuario que modificó el registro de las páginas.';
$string['privacy:metadata:user_tasks_action'] = 'La acción, tomada de las bitácoras.';
$string['privacy:metadata:user_tasks_component'] = 'El componente, tomado de las bitácoras.';
$string['privacy:metadata:user_tasks_courseid'] = 'El ID del curso en el que se creó el registro de trabajos.';
$string['privacy:metadata:user_tasks_duration'] = 'La duración del trabajo en segundos.';
$string['privacy:metadata:user_tasks_eventname'] = 'El nombre del evento; combina nombres de  componente, objetivo y acción.';
$string['privacy:metadata:user_tasks_n_events'] = 'El número de eventos agrupados en el trabajo.';
$string['privacy:metadata:user_tasks_target'] = 'El objetivo, tomado de las bitácoras';
$string['privacy:metadata:user_tasks_timecreated'] = 'La hora en que se creó este registro de trabajos.';
$string['privacy:metadata:user_tasks_timestart'] = 'La hora de cuando sucedió el primer evento del trabajo.';
$string['privacy:metadata:user_tasks_userid'] = 'El ID del usuario con esta información de trabajo.';
$string['progress-bar-view'] = 'Barra de progreso';
$string['progress-bar-view_help_info_text'] = '<p>La tarjeta \'Barra de progreso\' te muestra el progreso de lectura de su material de aprendizaje actual.</p><p style=\'color: var(--primary)\'>Añadir material de aprendizaje</p><p>De forma predeterminada, la tarjeta está vacía. Usted puede añadir el progreso de los materiales de aprendizaje pertenecientes a este curso a la tarjeta a través del icono de engranaje en la esquina superior derecha.</p><p style=\'color: var(--primary)\'>Visualización de datos gráficos</p><p>Esto le mostrará una tabla detallada de los materiales de aprendizaje que ha enviado.';
$string['progress-bar_nodata'] = 'No hay progreso de lectura actualmente grabado. Añada el progreso de lectura de su material educativo ahora.';
$string['progress_bar_add_learning_material'] = 'Añadir material de aprendizaje del curso';
$string['progress_bar_additional_help'] = 'Más ayuda con la gestión de materiales de aprendizaje';
$string['progress_bar_manage_learning_material'] = 'Gestionar el material de aprendizaje del curso';
$string['progress_bar_modal_intro'] = 'Aquí puede agregar documentos, vídeos o enlaces que se hayan cargado en el curso seleccionado como material de aprendizaje.';
$string['progress_bar_title'] = 'Progreso de lectura';
$string['progress_config_help_title'] = 'Barradeprogreso de lectura: Añadir material educativo';
$string['progress_config_title'] = 'Barradeprogreso';
$string['pvl_assignment_info_text_failed'] = 'tareas no están pasadas.';
$string['pvl_assignment_info_text_incomplete'] = 'tareas están incompletas.';
$string['pvl_assignment_info_text_notsubmitted'] = 'tareas aun no han sido enviadas.';
$string['pvl_assignment_info_text_okay'] = 'tareas han sido pasadas.';
$string['pvl_assignment_info_text_selfcheck'] = 'tareas están marcadas como incompletas.';
$string['pvl_assignment_info_text_submitted'] = 'tareas han sido enviadas.';
$string['pvl_assignment_info_text_summary_global'] = 'Su Probabilidad-PVL  global es como sigue:';
$string['pvl_assignment_info_text_summary_modul'] = 'Su Probabilidad-PVL para el módulo actual es como sigue:';
$string['pvl_assignment_info_text_summary_semester'] = 'Su Probabilidad-PVL para el semestre actual es como sigue:';
$string['pvl_assignment_view_hover_incomplete'] = 'las tareas aún no están completas';
$string['pvl_assignment_view_hover_okay'] = 'las tareas están completas';
$string['pvl_success-chance-chart-text'] = 'Probabilidad-PVL';
$string['select_timeframe'] = 'Selección de período de tiempo';
$string['select_view'] = 'Seleccionar vista';
$string['social_indicators'] = 'Social';
$string['statistic-insights-view'] = 'Intuiciones (predicciones) estadísticas';
$string['statistic-insights-view_activitiesdue'] = '<p style="color: var(--white);"><i class="fa fa-warning"></i></p><p>¡Usted tiene actividades pendientes en este curso!</p>';
$string['statistic-insights-view_anywriteincourse'] = '<p style="color: var(--green);"><i class="fa fa-check-circle"></i></p><p>Usted ha completado una acción de "escritura" (contenido guardado) en este curso.</p>';
$string['statistic-insights-view_at_risk'] = '<span style="color: var(--danger)"><i class="fa fa-warning" style="color: var(--danger);"></i> Actualmente usted corre el riesgo de no aprobar este curso.</span>';
$string['statistic-insights-view_completion_title'] = 'Estado de finalización del curso';
$string['statistic-insights-view_course_prediction_not_initialized'] = '<span style="color: var(--gray);"><i class="fa fa-warning"></i> No hay predicciones disponibles sobre su progreso actual en este curso o no han sido iniciadas por el administrador.</span>';
$string['statistic-insights-view_global_additional_info'] = 'Nota: Las predicciones sólo se pueden generar para los cursos actualmente en curso. Por lo tanto, la vista completa en esta tarjeta corresponde a la vista del semestre.';
$string['statistic-insights-view_help_info_text'] = '<p>
 La tarjeta \'Intuición (predicción) estadística\' proporciona una descripción general de sus cálculos del modelo de análisis de aprendizaje de Moodle.
 \'estudiantes en riesgo de abandonar el curso\'. Se divide en las siguientes secciones:
</p>
<p style=\'color: var(--primary)\'>Estado de riesgo del estudiante:</p>
<p>
 Muestra si se prevé que usted esté "en riesgo" según los análisis. Si es así, un icono de ayuda adjunto ofrece  contexto y orientación adicionales.
</p>
<p style=\'color: var(--primary)\'>Información de finalización del curso:</p>
<p>
 Si el seguimiento de finalización del curso está habilitado, la tarjeta muestra el progreso actual y los criterios detallados, lo que le permite ver qué tan cerca está usted de cumplir con los requisitos del curso.
</p>
<p style=\'color: var(--primary)\'>Métricas generales de participación:</p>
<p>
 Resume medidas clave como actividades pendientes, acciones de lectura y compromiso con la escritura. Estos indicadores le ayudan
a usted a evaular rápidamente su participación general.
</p>
<p style=\'color: var(--primary)\'>Información específica del módulo:</p>
<p>
 Para cada módulo del curso, la tarjeta muestra datos de rendimiento adicionales, en particular cognitivos y sociales.
 Indicadores: ofrecen un análisis más profundo de áreas específicas de su progreso.
</p>';
$string['statistic-insights-view_help_info_text_expanded'] = '<p>
 La tarjeta \'Intuición (predicción) estadística\' proporciona una descripción general de sus cálculos del modelo de análisis de aprendizaje de Moodle  \'estudiantes en riesgo de abandonar los estudios\'. Se divide en las siguientes secciones:
</p>
<p style=\'color: var(--primary)\'>Estado de riesgo del estudiante:</p>
<p>
 Muestra si se prevé que usted esté "en riesgo" según los análisis. Si es así, un icono de ayuda adjunto ofrece  contexto y orientación adicionales.
</p>
<p style=\'color: var(--primary)\'>Información de finalización del curso:</p>
<p>
 Si el seguimiento de finalización del curso está habilitado, la tarjeta muestra el progreso actual y los criterios detallados, lo que le permite ver qué tan cerca está de cumplir con los requisitos del curso.
</p>
<p style=\'color: var(--primary)\'>Métricas generales de participación:</p>
<p>
 Resume medidas clave como actividades pendientes, acciones de lectura y compromiso con la escritura. Estos indicadores ayudan
 Evalúa rápidamente su participación general.
</p>
<p style=\'color: var(--primary)\'>Información específica del módulo:</p>
<p>
 Para cada módulo del curso, la tarjeta muestra datos de rendimiento adicionales, en particular cognitivos y sociales.
 Indicadores: ofrecen un análisis más profundo de áreas específicas de su progreso.
</p>';
$string['statistic-insights-view_no_course_available'] = 'No hay intuiciones (predicciones) disponibles porque usted no está inscrito en ningún curso este semestre.';
$string['statistic-insights-view_noactivitiesdue'] = '<p style="color: var(--white);"><i class="fa fa-check-circle"></i></p><p>Usted no tiene ninguna actividad pendiente actualmente.</p>';
$string['statistic-insights-view_not_at_risk'] = '<p style="color: var(--gray);"><i class="fa fa-check-circle" style="color: var(--green);"></i>Su progreso en el curso hasta ahora es bueno.</p>';
$string['statistic-insights-view_nowriteincourse'] = '<p style="color: var(--gray);"><i class="fa fa-warning"></i></p><p>Usted aún no ha completado una acción de "escritura" (contenido guardado) en este curso.</p>';
$string['status'] = 'Estado';
$string['study-progress-view'] = 'Progreso del Estudio';
$string['study-progress-view_help_info_text'] = 'El velocímetro le muestra el progreso de sus estudios y cuánto se hasacercado a su objetivo. El cálculo se basa en las evaluaciones de las tareas que le asignan en el curso.';
$string['study-progress-view_help_info_text_expanded'] = 'El velocímetro le muestra el progreso de sus estudios y cuánto se hasacercado a su objetivo. El cálculo se basa en las evaluaciones de las tareas que le asignan en el curso. Debajo del velocímetro encontrará una lista en la que se basa este cálculo.';
$string['study-progress_activity'] = 'Actividades Moodle';
$string['study-progress_activity_weight'] = '% actividades Moodle';
$string['study-progress_assign'] = 'tareas';
$string['study-progress_assign_weight'] = '% progreso en tareas';
$string['study-progress_doc'] = 'materiales educativos';
$string['study-progress_doc_weight'] = '% progreso en materiales educativos';
$string['study-progress_eval_course'] = 'Evaluación para este curso';
$string['study-progress_eval_global'] = 'Evaluación para sus estudios';
$string['study-progress_eval_halfyear'] = 'Evaluación para este semestre';
$string['study-progress_expanded_desc'] = 'La evaluación general del semestre actual se basa en varios valores y tiene diferente ponderación:';
$string['study-progress_expanded_info_text'] = 'La calificación de la tarea se calcula en función de las tareas asignadas en este curso. A cada tarea se le asigna un valor según su estado: “negativa (X roja)”, “neutral (círculo gris o triángulo amarillo)” o “positiva (marca de verificación verde)”.';
$string['study-progress_expanded_title'] = 'Evaluación para los factores que influyen';
$string['study-progress_infotext_average'] = 'El progreso del estudio actualmente es <span style="color: var(--primary)">promedio</span>.';
$string['study-progress_infotext_bad'] = 'El progreso del estudio no es óptimo en este momento.';
$string['study-progress_infotext_good'] = 'El progreso del estudio actualmente es muy bueno.';
$string['study-progress_score_is'] = 'El puntaje es';
$string['study_progress_setting'] = 'Mostrar vista general de progreso del estudio';
$string['submitted'] = 'Enviado';
$string['success-chance-failed-text'] = 'reprobado';
$string['success-chance-incomplete-text'] = 'incompleto';
$string['success-chance-label-failed'] = 'Probabilidad-PVL';
$string['success-chance-notsubmitted-text'] = 'no-enviado';
$string['success-chance-okay-text'] = 'aprobado';
$string['success-chance-selfcheck-text'] = 'está marcado como completado, podría aun necesitar ser revisado por el profesor.';
$string['success-chance-submitted-text'] = 'enviado';
$string['success-chance-view'] = 'Probabilidad-PVL';
$string['success-chance-view_help_info_text'] = '<p>Todas las tareas entregadoa (incluidos los puntos de evaluación) se muestran en su totalidad en la tarjeta "Probabilidad PVL". La probabilidad PVL respectiva se calcula a partir del estado de los trabajos enviados individualmente y se representa como un porcentaje.</p><p><span style="color: var(--primary)">NOTA</span><br> Tenga en cuenta que el valor de la probabilidad PVL solo se calcula en función de las tareas entregadas anteriormente. Es importante entender que una probabilidad PVL alta no significa una garantía de éxito y que existe cierta incertidumbre. En última instancia, su éxito depende de muchos factores, incluidos sus esfuerzos y circunstancias fuera de nuestro control. Utilice la probabilidad PVL como guía, pero no se desanime si sus resultados reales difieren.';
$string['success-chance-view_help_info_text_expanded'] = 'En la vista detallada de la tarjeta \'Probabilidad PVL\' encontrará una lista completa de las tareas entregadas y su estado, que contribuyen al cálculo de la Probabilidad PVL.';
$string['success-chance_info_text'] = 'Vea la probabilidad PVL: La probabilidad PVL le muestra cuántos puntos de evaluación ha recibido.';
$string['success-chance_info_text_expanded'] = 'La Probabilidad-PVL le muestra el estado de las tareas enviadas.';
$string['success-chance_no_course_available'] = 'No está inscrito en ningún curso este semestre para el que se pueda calcular la probabilidad PVL.';
$string['task_statistics'] = 'Estadísticas de uso de tareas';
$string['task_tasktransform'] = 'Transformación de trabajo';
$string['testcontent'] = 'Esto es contenido del examen';
$string['testfooter'] = 'El Tablero del Estudiante está cargando';
$string['title_detail_name'] = 'Vista detallada';
$string['total_study_period'] = 'Programa de estudio completo';
$string['viewmode_global'] = 'Vista completa';
$string['viewmode_halfyear'] = 'Vista del semestre';
$string['viewmode_module'] = 'Vista del módulo';
$string['viewmode_selected'] = 'es el modo de vista seleccionado actualmente del TTablero del Estudiante.';
