<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'aiprovider_deepseek', language 'es_mx', version '5.1'.
 *
 * @package     aiprovider_deepseek
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action:explain_text:endpoint'] = 'Punto final de API';
$string['action:explain_text:model'] = 'Modelo de explicación de texto';
$string['action:explain_text:model_help'] = 'El modelo utilizado para explicar el texto proporcionado.';
$string['action:explain_text:systeminstruction'] = 'Instrucción del sistema';
$string['action:explain_text:systeminstruction_help'] = 'Esta instrucción se envía al modelo de IA junto con el prompt (la solicitud) del usuario. No se recomienda editarla a menos que sea absolutamente necesario.';
$string['action:generate_text:endpoint'] = 'Punto final de API';
$string['action:generate_text:model'] = 'Modelo de IA';
$string['action:generate_text:model_help'] = 'El modelo utilizado para generar la respuesta de texto.';
$string['action:generate_text:systeminstruction'] = 'Instrucción del sistema';
$string['action:generate_text:systeminstruction_help'] = 'Esta instrucción se envía al modelo de IA junto con el prompt (la solicitud) del usuario. No se recomienda editarla a menos que sea absolutamente necesario.';
$string['action:summarise_text:endpoint'] = 'Punto final de API';
$string['action:summarise_text:model'] = 'Modelo de IA';
$string['action:summarise_text:model_help'] = 'El modelo utilizado para resumir el texto proporcionado.';
$string['action:summarise_text:systeminstruction'] = 'Instrucción del sistema';
$string['action:summarise_text:systeminstruction_help'] = 'Esta instrucción se envía al modelo de IA junto con el prompt (la solicitud) del usuario. No se recomienda editarla a menos que sea absolutamente necesario.';
$string['apikey'] = 'Clave API de DeepSeek';
$string['apikey_help'] = 'Obtener una clave de sus <a href="https://platform.deepseek.com/api_keys" target="_blank">claves de API de DeepSeek</a>.';
$string['custom_model_name'] = 'Nombre del modelo personalizado';
$string['extraparams'] = 'Parámetros extra';
$string['extraparams_help'] = 'Aquí se pueden configurar parámetros adicionales. Se admite el formato JSON. Por ejemplo:
<pre>
{
"temperature": 0.5,
"max_tokens": 100
}
</pre>';
$string['invalidjson'] = 'Cadena JSON inválida';
$string['pluginname'] = 'Proveedor API de DeepSeek';
$string['privacy:metadata'] = 'El plugin del proveedor de API DeepSeek no almacena ningún dato personal.';
$string['privacy:metadata:aiprovider_deepseek:externalpurpose'] = 'Esta información se envía a la API de DeepSeek para generar una respuesta. La configuración de su cuenta de DeepSeek puede modificar la forma en que DeepSeek almacena y conserva estos datos. Este plugin no envía ni almacena datos de usuario en Moodle LMS.';
$string['privacy:metadata:aiprovider_deepseek:model'] = 'el modelo usado para generar la respuesta.';
$string['privacy:metadata:aiprovider_deepseek:prompttext'] = 'El usuario ingresó el texto que se utilizó para generar la respuesta.';
$string['settings'] = 'Configuraciones';
$string['settings_frequency_penalty'] = 'frequency_penalty';
$string['settings_frequency_penalty_help'] = 'Número entre -2.0 y 2.0. Los valores positivos penalizan los nuevos tokens según su frecuencia en el texto, lo que reduce la probabilidad de que el modelo repita la misma línea textualmente.';
$string['settings_help'] = 'Ajuste la configuración a continuación para personalizar la forma en que se envían las solicitudes a DeepSeek.';
$string['settings_logprobs'] = 'logprobs';
$string['settings_logprobs_help'] = 'Si se devuelven o no las probabilidades logarítmicas de los tokens de salida. Si es verdadero, devuelve las probabilidades logarítmicas de cada token de salida devuelto en el contenido del mensaje.';
$string['settings_logprobs_label'] = 'Habilitar';
$string['settings_max_tokens'] = 'max_tokens';
$string['settings_max_tokens_help'] = 'Número entero entre 1 y 8192. El número máximo de tokens que se pueden generar al completar el chat. La longitud total de los tokens de entrada y los tokens generados está limitada por la longitud del contexto del modelo. Si no se especifica max_tokens, se utiliza el valor predeterminado 4096.';
$string['settings_presence_penalty'] = 'presence_penalty';
$string['settings_presence_penalty_help'] = 'Número entre -2.0 y 2.0. Los valores positivos penalizan los nuevos tokens según su aparición en el texto, lo que aumenta la probabilidad de que el modelo aborde nuevos temas.';
$string['settings_temperature'] = 'temperatura';
$string['settings_temperature_help'] = 'Temperatura de muestreo a utilizar, entre 0 y 2. Valores altos, como 0,8, harán que la salida sea más aleatoria, mientras que valores bajos, como 0,2, la harán más específica y determinista. Generalmente recomendamos modificar esto o top_p, pero no ambos.';
$string['settings_top_logprobs'] = 'top_logprobs';
$string['settings_top_logprobs_help'] = 'Un número entero entre 0 y 20 que especifica la cantidad de tokens con mayor probabilidad de retorno en cada posición de token, cada uno con una probabilidad de registro asociada. logprobs debe establecerse en verdadero si se utiliza este parámetro.';
$string['settings_top_p'] = 'top_p';
$string['settings_top_p_help'] = 'Una alternativa al muestreo con temperatura, denominada muestreo de núcleo, donde el modelo considera los resultados de los tokens con la masa de probabilidad top_p. Por lo tanto, 0,1 significa que solo se consideran los tokens que comprenden el 10 % superior de masa de probabilidad. Generalmente recomendamos modificar esto o la temperatura, pero no ambos.';
