<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'workshop', language 'cs', version '5.1'.
 *
 * @package     workshop
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activitydate:assessmentsclose'] = 'Uzavření hodnocení:';
$string['activitydate:assessmentsclosed'] = 'Uzavřená hodnocení:';
$string['activitydate:assessmentsopen'] = 'Otevřená hodnocení:';
$string['activitydate:assessmentsopened'] = 'Otevřená hodnocení:';
$string['activitydate:submissionsclose'] = 'Uzavření příspěvků:';
$string['activitydate:submissionsclosed'] = 'Uzavřené příspěvky:';
$string['activitydate:submissionsopen'] = 'Otevřené příspěvky:';
$string['activitydate:submissionsopened'] = 'Otevřené příspěvky:';
$string['aggregategrades'] = 'Přepočítat známky';
$string['aggregation'] = 'Výpočet souhrnných známek';
$string['allocate'] = 'Přidělit práce k hodnocení';
$string['allocatedetails'] = 'očekáváno: {$a->expected}<br />odevzdáno: {$a->submitted}<br />zbývá přidělit: {$a->allocate}';
$string['allocation'] = 'Přidělování odevzdaných prací k hodnocení';
$string['allocationconfigured'] = 'Přidělení prací nastaveno';
$string['allocationdone'] = 'Přidělování ukončeno';
$string['allocationerror'] = 'Chyba při přidělování prací';
$string['allowedfiletypesforoverallfeedback'] = 'Přílohy komentáře povolují soubory typu';
$string['allowedfiletypesforoverallfeedback_help'] = 'Přílohy komentáře povolují soubory typu lze omezit zadáním seznamu povolených typů souborů. Pokud je pole ponecháno prázdné, pak jsou povoleny všechny typy souborů.';
$string['allowedfiletypesforoverallfeedback_link'] = 'admin/tool/filetypes/index';
$string['allowedfiletypesforsubmission'] = 'Přílohy odevzdaných prací povolují soubory typu';
$string['allowedfiletypesforsubmission_help'] = 'Přílohy odevzdaných prací povolují soubory typu lze omezit zadáním povolených typů souborů. Pokud je pole ponecháno prázdné, pak jsou povoleny všechny typy souborů.';
$string['allowedfiletypesforsubmission_link'] = 'admin/tool/filetypes/index';
$string['allsubmissions'] = 'Všechny odevzdané práce ({$a})';
$string['alreadygraded'] = 'Ohodnoceno';
$string['areaconclusion'] = 'Závěr';
$string['areainstructauthors'] = 'Pokyny k vypracování odevzdávaných prací';
$string['areainstructreviewers'] = 'Pokyny k hodnocení';
$string['areaoverallfeedbackattachment'] = 'Přílohy doplňujících komentářů';
$string['areaoverallfeedbackcontent'] = 'Texty doplňujících komentářů';
$string['areasubmissionattachment'] = 'Přílohy odevzdaných prací';
$string['areasubmissioncontent'] = 'Texty odevzdaných prací';
$string['assess'] = 'Hodnotit';
$string['assessedexample'] = 'Ohodnocená ukázka práce';
$string['assessedsubmission'] = 'Ohodnocená odevzdaná práce';
$string['assessingexample'] = 'Hodnocení ukázek prací';
$string['assessingsubmission'] = 'Hodnocení odevzdané práce';
$string['assessment'] = 'Hodnocení';
$string['assessmentby'] = '- <a href="{$a->url}">{$a->name}</a>';
$string['assessmentbyfullname'] = 'Hodnocení od {$a}';
$string['assessmentbyyourself'] = 'Vaše hodnocení';
$string['assessmentdeleted'] = 'Zrušeno přidělení práce k hodnocení';
$string['assessmentend'] = 'Konec hodnocení';
$string['assessmentendbeforestart'] = 'Konec hodnocení nemůže předcházet začátku hodnocení.';
$string['assessmentenddatetime'] = 'Lhůta pro hodnocení: {$a->daydatetime} ({$a->distanceday})';
$string['assessmentendevent'] = '{$a} lhůta pro hodnocení';
$string['assessmentform'] = 'Hodnotící formulář';
$string['assessmentofsubmission'] = '<a href="{$a->assessmenturl}">Hodnocení</a> práce <a href="{$a->submissionurl}">{$a->submissiontitle}</a>';
$string['assessmentreference'] = 'Referenční hodnocení';
$string['assessmentreferenceconflict'] = 'Nemůžete hodnotit ukázku práce, pro niž jste poskytli referenční hodnocení.';
$string['assessmentreferenceneeded'] = 'Nyní musíte tuto ukázku práce objektivně ohodnotit a poskytnout tak tzv. referenční hodnocení. Stisknutím tlačítka "Pokračovat" můžete práci ihned ohodnotit.';
$string['assessments'] = 'Hodnocení';
$string['assessmentsettings'] = 'Podrobnosti hodnocení';
$string['assessmentstart'] = 'Začátek hodnocení';
$string['assessmentstartdatetime'] = 'Hodnocení možné od: {$a->daydatetime} ({$a->distanceday})';
$string['assessmentstartevent'] = '{$a} zahájení hodnocení';
$string['assessmentweight'] = 'Váha hodnocení';
$string['assignedassessments'] = 'Přidělené práce k hodnocení';
$string['assignedassessmentsnone'] = 'Nebyly vám přiděleny žádné práce k hodnocení';
$string['backtoeditform'] = 'Zpět k úpravě formuláře';
$string['byfullname'] = '- <a href="{$a->url}">{$a->name}</a>';
$string['byfullnamewithoutlink'] = 'od {$a}';
$string['calculategradinggrades'] = 'Vypočítat známky za hodnocení';
$string['calculategradinggradesdetails'] = 'očekáváno: {$a->expected}<br />vypočítáno: {$a->calculated}';
$string['calculatesubmissiongrades'] = 'Vypočítat známky za odevzdané práce';
$string['calculatesubmissiongradesdetails'] = 'očekáváno: {$a->expected}<br />vypočítáno: {$a->calculated}';
$string['chooseuser'] = 'Vyberte uživatele...';
$string['clearaggregatedgrades'] = 'Vymazat všechny vypočítané souhrnné známky';
$string['clearaggregatedgrades_help'] = 'Hodnoty vypočítávaných souhrnných známek za odevzdané práce a za hodnocení budou nastaveny na prázdnou hodnotu. Tyto známky lze nechat znovu vypočítat ve fázi Evaluace hodnocení.';
$string['clearaggregatedgradesconfirm'] = 'Jste si jisti, že chcete vymazat všechny vypočítané souhrnné známky za odevzdané práce a za hodnocení?';
$string['clearassessments'] = 'Odstranit hodnocení';
$string['clearassessments_help'] = 'Vypočítané známky za odevzdané práce a známky za hodnocení budou nastaveny na prázdnou hodnotu. Informace o tom, jak jsou vyplněna jednotlivá pole hodnotících formulářů není odstraněna, ale všichni hodnotitelé musejí otevřít hodnotící formuláře všech jim přidělených prací a znovu je uložit. Teprve pak budou jimi navrhované známky znovu vypočítány.';
$string['clearassessmentsconfirm'] = 'Jste si opravdu jistí, že chcete odstranit všechny udělené známky za odevzdané práce? Sami nebudete moci tuto informaci obnovit - hodnotitelé budou muset znovu hodnotit jim přidělené práce.';
$string['conclusion'] = 'Závěr';
$string['conclusion_help'] = 'Závěrečné shrnutí, které se zobrazí účastníkům workshopu na jeho konci.';
$string['configexamplesmode'] = 'Výchozí režim používání ukázek prací ve workshopech';
$string['configgrade'] = 'Výchozí hodnota nejvyšší možné známky za odevzdanou práci ve workshopech';
$string['configgradedecimals'] = 'Výchozí počet desetinných míst při zobrazování známek';
$string['configgradinggrade'] = 'Výchozí hodnota nejvyšší možné známky za hodnocení ve workshopech';
$string['configmaxbytes'] = 'Výchozí největší povolená velikost souborů ve workshopech (může být ještě ovlivněna nastavením limitů v kurzu a dalšími parametry)';
$string['configstrategy'] = 'Výchozí strategie hodnocení ve workshopech';
$string['createsubmission'] = 'Přidat práci';
$string['crontask'] = 'Zpracování pro modul workshop na pozadí';
$string['daysago'] = 'před {$a} dny';
$string['daysleft'] = 'zbývá {$a} dnů';
$string['daystoday'] = 'dnes';
$string['daystomorrow'] = 'zítra';
$string['daysyesterday'] = 'včera';
$string['deadline'] = 'Termín pro fázi';
$string['deadlinesignored'] = 'Časová omezení se na vás nevztahují';
$string['deletesubmission'] = 'Odstranit odevzdanou práci';
$string['editassessmentform'] = 'Upravit hodnotící formulář';
$string['editassessmentformstrategy'] = 'Upravit hodnotící formulář ({$a})';
$string['editingassessmentform'] = 'Úprava hodnotícího formuláře';
$string['editingsubmission'] = 'Úprava odevzdané práce';
$string['editsubmission'] = 'Upravit odevzdanou práci';
$string['err_multiplesubmissions'] = 'Zatímco byl upravován tento formulář, byla odevzdána jiná verze této práce. Každý uživatel může ve workshopu odevzdat jen jednu práci.';
$string['err_removegrademappings'] = 'Chyba při odstraňování nepoužitého mapování známek';
$string['evaluategradeswait'] = 'Prosím vyčkejte na evaluaci všech hodnocení a přepočítání známek';
$string['evaluation'] = 'Evaluace hodnocení';
$string['evaluationmethod'] = 'Metoda evaluace hodnocení';
$string['evaluationmethod_help'] = 'Metoda evaluace hodnocení určuje, jak se vypočítávají známky za hodnocení všech hodnotitelů. Známky můžete nechat vypočítat opakovaně s různým nastavením, dokud nebudete spokojeni s výsledkem.';
$string['evaluationsettings'] = 'Nastavení evaluace';
$string['eventassessableuploaded'] = 'Práce odevzdána.';
$string['eventassessmentevaluated'] = 'Hodnocení evaluováno';
$string['eventassessmentevaluationsreset'] = 'Evaluace hodnocení resetována';
$string['eventassessmentreevaluated'] = 'Hodnocení znovu evaluována';
$string['eventphaseautomaticallyswitched'] = 'Fáze se automaticky přepne';
$string['eventphaseswitched'] = 'Přepnuta fáze';
$string['eventsubmissionassessed'] = 'Příspěvek hodnocen';
$string['eventsubmissionassessmentsreset'] = 'Smazány hodnocení příspěvků';
$string['eventsubmissioncreated'] = 'Vytvořeno hodnocení';
$string['eventsubmissiondeleted'] = 'Práce odstraněna';
$string['eventsubmissionreassessed'] = 'Příspěvek přehodnocen';
$string['eventsubmissionupdated'] = 'Příspěvek aktualizován';
$string['eventsubmissionviewed'] = 'Příspěvek zobrazen';
$string['example'] = 'Ukázka práce';
$string['exampleadd'] = 'Přidat ukázku práce';
$string['exampleassess'] = 'Hodnotit ukázku práce';
$string['exampleassessments'] = 'Ukázky prací k ohodnocení';
$string['exampleassesstask'] = 'Ohodnotit ukázky prací';
$string['exampleassesstaskdetails'] = 'očekáváno: {$a->expected}<br />ohodnoceno: {$a->assessed}';
$string['examplecomparing'] = 'Porovnání hodnocení této ukázkové práce';
$string['exampledelete'] = 'Odstranit ukázku práce';
$string['exampledeleteconfirm'] = 'Jste si opravdu jistí, že chcete odstranit následující ukázkovou práci? Stisknutím tlačítka \'Pokračovat\' bude ukázka odstraněna.';
$string['exampleedit'] = 'Upravit ukázku práce';
$string['exampleediting'] = 'Úprava ukázky práce';
$string['exampleneedassessed'] = 'Nejprve musíte ohodnotit všechny ukázky prací';
$string['exampleneedsubmission'] = 'Nejprve musíte odevzdat vlastní práci a poté ohodnotit všechny ukázky prací';
$string['examplesbeforeassessment'] = 'Ukázky jsou dostupné až po odevzdání vlastní práce a musejí být ohodnoceny před hodnocením přidělených prací';
$string['examplesbeforesubmission'] = 'Ukázky musejí být ohodnoceny před odevzdáním vlastní práce';
$string['examplesmode'] = 'Režim hodnocení ukázek prací';
$string['examplesubmissions'] = 'Ukázky prací';
$string['examplesvoluntary'] = 'Hodnocení ukázek prací je dobrovolné';
$string['exportsubmission'] = 'Exportovat tuto stránku';
$string['feedbackauthor'] = 'Zpětná vazba pro autora práce';
$string['feedbackauthorattachment'] = 'Příloha';
$string['feedbackby'] = 'Komentář od  {$a}';
$string['feedbackreviewer'] = 'Zpětná vazba pro hodnotitele';
$string['feedbacksettings'] = 'Hodnocení';
$string['formataggregatedgrade'] = '{$a->grade}';
$string['formataggregatedgradeover'] = '<del>{$a->grade}</del><br /><ins>{$a->over}</ins>';
$string['formatpeergrade'] = '<span class="grade">{$a->grade}</span> <span class="gradinggrade">({$a->gradinggrade})</span>';
$string['formatpeergradeover'] = '<span class="grade">{$a->grade}</span> <span class="gradinggrade">(<del>{$a->gradinggrade}</del> / <ins>{$a->gradinggradeover}</ins>)</span>';
$string['formatpeergradeoverweighted'] = '<span class="grade">{$a->grade}</span> <span class="gradinggrade">(<del>{$a->gradinggrade}</del> / <ins>{$a->gradinggradeover}</ins>)</span> @ <span class="weight">{$a->weight}</span>';
$string['formatpeergradeweighted'] = '<span class="grade">{$a->grade}</span> <span class="gradinggrade">({$a->gradinggrade})</span> @ <span class="weight">{$a->weight}</span>';
$string['givengrades'] = 'Udělené známky';
$string['grade_grading_name'] = 'Hodnocení';
$string['grade_submission_name'] = 'Odevzdaná práce';
$string['gradecalculated'] = 'Vypočítaná známka za odevzdanou práci';
$string['gradedecimals'] = 'Počet desetinných míst ve známkách';
$string['gradegivento'] = '&gt;';
$string['gradeinfo'] = 'Známka: {$a->received} z {$a->max}';
$string['gradeitemassessment'] = '{$a->workshopname} (hodnocení)';
$string['gradeitemsubmission'] = '{$a->workshopname} (práce)';
$string['gradeover'] = 'Přepsat vypočítanou známku za odevzdanou práci';
$string['gradereceivedfrom'] = '&lt;';
$string['gradesreport'] = 'Přehled známek';
$string['gradetopassgrading'] = 'Potřebná známka za hodnocení';
$string['gradetopasssubmission'] = 'Potřebná známka za odevzdanou práci';
$string['gradinggrade'] = 'Známka za hodnocení';
$string['gradinggrade_help'] = 'Určuje nejvyšší možnou známku, kterou bude moci hodnotitel získat za provedená hodnocení přidělených prací.';
$string['gradinggradecalculated'] = 'Vypočítaná známka za hodnocení';
$string['gradinggradeof'] = 'Známka za hodnocení (z {$a})';
$string['gradinggradeover'] = 'Přepsat známku za hodnocení';
$string['gradingsettings'] = 'Nastavení známkování';
$string['groupnoallowed'] = 'V tomto workshopu nemáme povolen přístup do žádné skupiny';
$string['iamsure'] = 'Ano, jsem si jistý / jistá';
$string['indicator:cognitivedepth'] = 'Kognitivní Workshop';
$string['indicator:cognitivedepth_help'] = 'Tento ukazatel je založen na studentem získané kognitivní hloubce v aktivitě Workshop.';
$string['indicator:cognitivedepthdef'] = 'Kognitivní Workshop';
$string['indicator:cognitivedepthdef_help'] = 'Během tohoto intervalu analýzy dosáhl účastník tohoto procenta kognitivní angažovanosti nabízené aktivitami Workshop (Úrovně = Bez zobrazení, Zobrazení, Příspěvek, Zobrazení zpětné vazby, Komentář ke zpětné vazbě, Nový příspěvek po zobrazení zpětné vazby)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Sociální Workshop';
$string['indicator:socialbreadth_help'] = 'Tento ukazatel je založen na studentem získané sociální šířce v aktivitě Workshop.';
$string['indicator:socialbreadthdef'] = 'Sociální Workshop';
$string['indicator:socialbreadthdef_help'] = 'Během tohoto intervalu analýzy dosáhl účastník tohoto procenta sociální angažovanosti nabízené aktivitou Workshop (Úrovně = Bez účasti, Účastník sám, Účastník s ostatními)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['info'] = 'Info';
$string['instructauthors'] = 'Pokyny pro vypracování odevzdávaných prací';
$string['instructreviewers'] = 'Pokyny pro hodnocení přidělených prací';
$string['introduction'] = 'Popis';
$string['latesubmissions'] = 'Pozdní odevzdání';
$string['latesubmissions_desc'] = 'Povolit odevzdávání prací po termínu';
$string['latesubmissions_help'] = 'Je-li povoleno, autoři mohou odevzdávat své práce až po termínu odevzdávání nebo dokonce až ve fázi vzájemného hodnocení. Takto pozdě odevzdané práce však již nebude možno upravovat.';
$string['latesubmissionsallowed'] = 'Pozdní odevzdání je povoleno';
$string['maxbytes'] = 'Nejvyšší možná velikost přílohy odevzdané práce';
$string['modulename'] = 'Workshop';
$string['modulename_help'] = 'Modul Workshop umožňuje sběr a vzájemné hodnocení prácí studentů.

Studenti mohou odevzdat libovolný digitální obsah, např. textové dokumenty, obrázky nebo soubory tabulkového procesoru. Také mohou odevzdávat text psaný přímo v textového editoru na stránce.

Odevzdaná řešení jsou hodnocena pomocí formuláře pro vícekriteriální hodnocení. Podobu těchto hodnotících formulářů nastavuje učitel. Proces vzájemného hodnocení a pochopení hodnotícího formuláře může být procvičován předem na příkladech, které poskytl učitel spolu s referenčním hodnocení. Studenti mají možnost hodnotit jednu nebo více přidělených prací. Odevzdaná řešení i jejich hodnocení mohou být v případě potřeby anonymní.

Studenti získají v modulu Workshop dvě známky - jednu za své vlastní řešení, druhou za hodnocení přidělených prací. Obě známky jsou zapsány v klasifikaci.';
$string['modulename_link'] = 'mod/workshop/view';
$string['modulenameplural'] = 'Workshopy';
$string['myassessments'] = 'Moje hodnocení';
$string['mysubmission'] = 'Moje práce';
$string['nattachments'] = 'Nejvyšší povolený počet přiložených souborů';
$string['noexamples'] = 'Tento workshop zatím neobsahuje žádné ukázky prací';
$string['noexamplesformready'] = 'Před vložením ukázek prací musíte definovat hodnotící formulář';
$string['nogradeyet'] = 'Zatím bez známky';
$string['nosubmissionfound'] = 'Tento uživatel zatím neodevzdal svou práci';
$string['nosubmissions'] = 'Tento workshop zatím neobsahuje žádné odevzdané práce';
$string['nosubmissiontype'] = 'Musí být k dispozici alespoň jeden typ příspěvku';
$string['notassessed'] = 'Zatím nehodnoceno';
$string['nothingfound'] = 'Nic k zobrazení';
$string['nothingtoreview'] = 'Nic k prohlédnutí';
$string['notoverridden'] = 'Nepřepisovat';
$string['noworkshops'] = 'Tento kurz neobsahuje žádné workshopy';
$string['noyoursubmission'] = 'Zatím jste neodevzdali svou práci';
$string['nullgrade'] = '-';
$string['overallfeedback'] = 'Doplňující komentář';
$string['overallfeedbackfiles'] = 'Nejvyšší možný počet příloh ke komentáři';
$string['overallfeedbackmaxbytes'] = 'Nejvyšší možná velikost přílohy komentáře';
$string['overallfeedbackmode'] = 'Režim doplňujících komentářů';
$string['overallfeedbackmode_0'] = 'Vypnuto';
$string['overallfeedbackmode_1'] = 'Volitelné';
$string['overallfeedbackmode_2'] = 'Povinné';
$string['overallfeedbackmode_help'] = 'Doplňující komentáře umožňují recenzentům vložit celkové hodnocení posuzované práce do textového pole zobrazeného na konci hodnotícího komentáře, či vysvětlit podrobněji důvody svého hodnocení.

Toto nastavení určuje, zda je funkce doplňujících komentářů povolena a (pokud ano) zda je vyplnění volitelné či povinné.';
$string['overview_assessment_grade'] = 'Stupeň hodnocení';
$string['overview_submission_grade'] = 'Hodnocení odevzdané práce';
$string['page-mod-workshop-x'] = 'Jakákoliv stránka workshopu';
$string['participant'] = 'Účastník';
$string['participantrevierof'] = 'Účastník bude hodnotit';
$string['participantreviewedby'] = 'Účastník bude hodnocen';
$string['phase'] = 'Fáze';
$string['phaseassessment'] = 'Hodnocení';
$string['phaseclosed'] = 'Uzavřeno';
$string['phaseevaluation'] = 'Evaluace';
$string['phasesetup'] = 'Nastavení';
$string['phasesoverlap'] = 'Fáze odevzdávání a fáze hodnocení se nesmí překrývat';
$string['phasesubmission'] = 'Odevzdávání';
$string['pluginadministration'] = 'Správa workshopu';
$string['pluginname'] = 'Workshop';
$string['prepareexamples'] = 'Připravit ukázky prací';
$string['previewassessmentform'] = 'Náhled';
$string['privacy:metadata:aggregatedgradinggrade'] = 'Souhrnná známka pro všechna hodnocení provedená uživatelem v dané činnosti workshop';
$string['privacy:metadata:assessmentgrade'] = 'Souhrnná známka odevzdaného řešení navržená tímto hodnocením';
$string['privacy:metadata:assessmentgradinggrade'] = 'Známka získaná z hodnocení';
$string['privacy:metadata:assessmentgradinggradeover'] = 'Ručně přepisovaná hodnota známka získaná z tohoto hodnocení';
$string['privacy:metadata:assessmentid'] = 'ID Identifikátor hodnocení';
$string['privacy:metadata:authorid'] = 'ID Identifikátor autora řešení';
$string['privacy:metadata:dimensiongrade'] = 'Známka  v daném rozměru hodnocení';
$string['privacy:metadata:dimensionid'] = 'ID Identifikátor rozměru hodnocení';
$string['privacy:metadata:example'] = 'Zda tento záznam představuje příklad řešení';
$string['privacy:metadata:feedbackauthor'] = 'Zpětná vazba pro autora práce';
$string['privacy:metadata:feedbackauthorformat'] = 'Textový formát zpětné vazby pro autora';
$string['privacy:metadata:feedbackreviewer'] = 'Komentář pro uživatele, který poskytuje hodnocení';
$string['privacy:metadata:feedbackreviewerformat'] = 'Textový formát komentáře pro uživatele, který poskytuje hodnocení';
$string['privacy:metadata:late'] = 'Zda bylo řešení odevzdáno po uplynutí lhůty';
$string['privacy:metadata:peercomment'] = 'Komentář k danému hodnocení uživatelem, který posouzení hodnotí';
$string['privacy:metadata:peercommentformat'] = 'Textový formát komentáře k dané známce';
$string['privacy:metadata:preference:perpage'] = 'Počet příspěvků, které uživatel upřednostňuje na jedné stránce';
$string['privacy:metadata:preference:viewlet-allexamples-collapsed'] = 'Sbalené/rozšířené zobrazení „Příklad odevzdané práce“.';
$string['privacy:metadata:preference:viewlet-allsubmissions-collapsed'] = 'Sbalené/rozšířené zobrazení „Zpráva o odevzdaných pracích“.';
$string['privacy:metadata:preference:viewlet-assessmentform-collapsed'] = 'Sbalené/rozšířené zobrazení „Hodnotící formulář“.';
$string['privacy:metadata:preference:viewlet-assignedassessments-collapsed'] = 'Sbalené/rozšířené zobrazení „Odevzdané práce k posouzení“.';
$string['privacy:metadata:preference:viewlet-cleargrades-collapsed'] = 'Sbalené/rozšířené zobrazení „Nástroje workshopu“.';
$string['privacy:metadata:preference:viewlet-conclusion-collapsed'] = 'Sbalené/rozšířené zobrazení „Závěr“.';
$string['privacy:metadata:preference:viewlet-examples-collapsed'] = 'Sbalené/rozšířené zobrazení „Příklad odevzdané práce k posouzení“.';
$string['privacy:metadata:preference:viewlet-examplesfail-collapsed'] = 'Sbalené/rozšířené zobrazení „Příklad odevzdané práce k posouzení“.';
$string['privacy:metadata:preference:viewlet-gradereport-collapsed'] = 'Sbalené/rozšířené zobrazení „Přehled známek“.';
$string['privacy:metadata:preference:viewlet-instructauthors-collapsed'] = 'Sbalené/rozšířené zobrazení „Pokyny k odevzdání“.';
$string['privacy:metadata:preference:viewlet-instructreviewers-collapsed'] = 'Sbalené/rozšířené zobrazení „Pokyny pro hodnocení“.';
$string['privacy:metadata:preference:viewlet-intro-collapsed'] = 'Sbalené/rozšířené zobrazení „Úvod“.';
$string['privacy:metadata:preference:viewlet-overallfeedback-collapsed'] = 'Sbalené/rozšířené zobrazení „Celková zpětná vazba“.';
$string['privacy:metadata:preference:viewlet-ownsubmission-collapsed'] = 'Sbalené/rozšířené zobrazení „Vaše odevzdaná práce“.';
$string['privacy:metadata:preference:viewlet-publicsubmissions-collapsed'] = 'Sbalené/rozšířené zobrazení „Zveřejněné práce“.';
$string['privacy:metadata:preference:viewlet-yourgrades-collapsed'] = 'Sbalené/rozšířené zobrazení „Vaše známky“.';
$string['privacy:metadata:published'] = 'Zda má být řešení zveřejněno všem účastníkům po uzavření workshopu';
$string['privacy:metadata:reviewerid'] = 'ID Identifikátor uživatele poskytujícího hodnocení';
$string['privacy:metadata:strategy'] = 'Název podprocesu strategie hodnocení, který interpretuje hodnoty záznamu';
$string['privacy:metadata:submissioncontent'] = 'Obsah řešení';
$string['privacy:metadata:submissioncontentformat'] = 'Textový formát obsahu řešení';
$string['privacy:metadata:submissiongrade'] = 'Souhrnná známka řešení napsaná jako desetinné číslo z intervalu 0..100';
$string['privacy:metadata:submissiongradeover'] = 'Ručně přepisovaná hodnota souhrnné známky';
$string['privacy:metadata:submissionid'] = 'ID řešení';
$string['privacy:metadata:submissiontitle'] = 'Název řešení';
$string['privacy:metadata:subsystem:corefiles'] = 'Modul Workshop ukládá soubory vložené do / připojené k textu řešení';
$string['privacy:metadata:subsystem:coreplagiarism'] = 'Modul Workshop má zabudovanou podporu systémů prevence plagiátorství';
$string['privacy:metadata:timeaggregated'] = 'Kdy byla souhrnná známka naposledy vypočtena';
$string['privacy:metadata:timecreated'] = 'Kdy byl tento záznam v databázi vytvořen';
$string['privacy:metadata:timemodified'] = 'Kdy byl tento záznam v databázi změněn';
$string['privacy:metadata:userid'] = 'ID uživatele, pro který je souhrnná známka vypočítána';
$string['privacy:metadata:weight'] = 'Váha hodnocení';
$string['privacy:metadata:workshopaggregations'] = 'Uchovává souhrnné známky pro hodnocení';
$string['privacy:metadata:workshopassessments'] = 'Uchovává informace o přiřazených hodnoceních řešení modulu workshop';
$string['privacy:metadata:workshopgrades'] = 'Uchovává informace o tom, jak byly formuláře pro hodnocení vyplněny známkami a komentáři';
$string['privacy:metadata:workshopid'] = 'ID činnosti workshop';
$string['privacy:metadata:workshopsubmissions'] = 'Uchovává informace o řešení modulu workshop';
$string['privacy:request:delete:content'] = 'Obsah byl odstraněn (na žádost uživatele nebo skončila platnost)';
$string['privacy:request:delete:title'] = '[Odstraněno]';
$string['publishedsubmissions'] = 'Zveřejněné práce';
$string['publishsubmission'] = 'Zveřejnit práci';
$string['publishsubmission_help'] = 'Zveřejněné práce jsou dostupné ostatním účastníkům poté, co je workshop uzavřen.';
$string['reassess'] = 'Přehodnotit';
$string['receivedgrades'] = 'Obdržené známky';
$string['recentassessments'] = 'Hodnocení ve workshopech:';
$string['recentsubmissions'] = 'Odevzdané práce ve workshopech:';
$string['resetassessments'] = 'Všechna hodnocení';
$string['resetassessments_help'] = 'Můžete odstranit pouze přidělené hodnocení bez vlivu na příspěvky. Budou-li příspěvky odstraněny, bude rovněž odstraněno jejich hodnocení, a tato volba bude ignorována. Toto zahrnuje také hodnocení v ukázkovém příspěvku.';
$string['resetphase'] = 'Přepnout do fáze nastavení';
$string['resetphase_help'] = 'Je-li zaškrtnuto, všechny workshopy se přepnou do úvodní fáze nastavení.';
$string['resetsubmissions'] = 'Všechny příspěvky';
$string['resetsubmissions_help'] = 'Všechny odevzdané práce a jejich hodnocení budou odstraněny. Toto neovlivní ukázkové práce.';
$string['saveandclose'] = 'Uložit a zavřít';
$string['saveandcontinue'] = 'Uložit a pokračovat v úpravách';
$string['saveandpreview'] = 'Uložit a ukázat náhled';
$string['saveandshownext'] = 'Uložit a zobrazit další';
$string['search:activity'] = 'Workshop - informace';
$string['selfassessmentdisabled'] = 'Sebehodnocení není povoleno';
$string['showingperpage'] = 'Zobrazuje se {$a} položek na stránce';
$string['showingperpagechange'] = 'Změnit ...';
$string['someuserswosubmission'] = 'Nejméně jeden uživatel dosud neodevzdal svou práci';
$string['sortasc'] = 'Vzestupně';
$string['sortdesc'] = 'Sestupně';
$string['strategy'] = 'Strategie hodnocení';
$string['strategy_help'] = 'Strategie hodnocení ovlivňuje podobu hodnotícího formuláře a způsob vypočítávání známky za odevzdanou práci. Dostupné jsou následující možnosti:

* Akumulační hodnocení - hodnotitel vkládá dílčí známky a komentáře k jednotlivým aspektům práce, celková známka je váženým průměrem dílčích
* Komentáře - hodnotitel pouze vkládá dílčí komentáře, známku nelze ovlivnit
* Počet chyb - hodnotitel rozhoduje o pravdivosti dílčích výroků, známka se určuje podle převodní tabulky na základě váženého počtu negativních odpovědí
* Rubrika - hodnotící rubrika s libovolným počtem úrovní u jednotlivých kritérií';
$string['strategyhaschanged'] = 'V průběhu úprav tohoto formuláře byla strategie hodnocení v tomto workshopu změněna';
$string['submission'] = 'Odevzdaná práce';
$string['submissionattachment'] = 'Příloha';
$string['submissionby'] = 'Odevzdaná práce od {$a}';
$string['submissioncontent'] = 'Obsah práce';
$string['submissiondeleteconfirm'] = 'Jste si jisti, že chcete smazat následující odevzdané práce?';
$string['submissiondeleteconfirmassess'] = 'Jste si jisti, že chcete smazat následující odevzdané práce? Poznámka: To také odstraníte {$a->count} hodnocení spojené s touto prací, což může ovlivnit známky recenzentů.';
$string['submissionend'] = 'Konec odevzdávání';
$string['submissionendbeforestart'] = 'Konec odevzdávání nelze nastavit před datem začátku odevzdávání';
$string['submissionenddatetime'] = 'Konec odevzdávání: {$a->daydatetime} ({$a->distanceday})';
$string['submissionendevent'] = '{$a} lhůta pro odevzdávání';
$string['submissionendswitch'] = 'Přepnout do další fáze po termínu odevzdávání';
$string['submissionendswitch_help'] = 'Je-li nastaven termín odevzdávání prací a toto pole je zaškrtnuto, workshop se automaticky přepne do fáze hodnocení po vypršení termínu odevzdávání.

Pokud tuto funkci povolíte, doporučuje se zároveň povolit naplánované přidělování odevzdaných prací. Odevzdané práce, které nejsou přiřazeny k hodnocení, nemohou být hodnoceny.';
$string['submissiongrade'] = 'Známka za odevzdanou práci';
$string['submissiongrade_help'] = 'Určuje nejvyšší možnou známku, kterou je možno získat za odevzdanou práci';
$string['submissiongradeof'] = 'Známka za odevzdanou práci (z {$a})';
$string['submissionlastmodified'] = 'Naposledy změněno';
$string['submissionrequiredcontent'] = 'Musíte zadat nějaký text nebo přidat soubor.';
$string['submissionrequiredfile'] = 'Musíte přidat soubor nebo zadat nějaký text.';
$string['submissions'] = 'Odevzdané práce';
$string['submissionsallocation'] = 'Přidělení řešení úkolů';
$string['submissionsettings'] = 'Nastavení odevzdávání';
$string['submissionsreport'] = 'Přehled odevzdaných praci';
$string['submissionstart'] = 'Začátek odevzdávání';
$string['submissionstartdatetime'] = 'Začátek odevzdávání: {$a->daydatetime} ({$a->distanceday})';
$string['submissionstartevent'] = '{$a} zahájení odevzdávání';
$string['submissiontitle'] = 'Název';
$string['submissiontypedisabled'] = 'Tento typ práce je pro tento workshop zakázán.';
$string['submissiontypefileavailable'] = 'Soubor příloh<span class="accesshide"> povolen</span>';
$string['submissiontypefilerequired'] = '<span class="accesshide">Soubor příloh </span>Vyžadován';
$string['submissiontypes'] = 'Typy odevzdané práce';
$string['submissiontypetextavailable'] = 'Online text<span class="accesshide"> dostupný</span>';
$string['submissiontypetextrequired'] = '<span class="accesshide">Online text </span>Povinné';
$string['submittednotsubmitted'] = 'Odevzdáno ({$a->submitted}) / neodevzdáno ({$a->notsubmitted})';
$string['subplugintype_workshopallocation'] = 'Metoda přidělování prací k hodnocení';
$string['subplugintype_workshopallocation_plural'] = 'Metody přidělování prací k hodnocení';
$string['subplugintype_workshopeval'] = 'Metoda evaluace hodnocení';
$string['subplugintype_workshopeval_plural'] = 'Metody evaluace hodnocení';
$string['subplugintype_workshopform'] = 'Strategie hodnocení';
$string['subplugintype_workshopform_plural'] = 'Strategie hodnocení';
$string['switchingphase'] = 'Přepínání fáze workshopu';
$string['switchphase'] = 'Přepnout fázi workshopu';
$string['switchphase10'] = 'Přepnout do fáze nastavení';
$string['switchphase10info'] = 'Chystáte se přepnout workshop do fáze <strong>Nastavení</strong>. Během této fáze nemohou studenti upravovat ani své práce ani přidělená hodnocení. Učitelé mohou používat tuto fázi ke změnám nastavení workshopu, úpravám hodnotící strategie nebo úpravám hodnotících formulářů.';
$string['switchphase20'] = 'Přepnout do fáze odevzdávání';
$string['switchphase20info'] = 'Chystáte se přepnout workshop do fáze <strong>Odevzdávání</strong>. Studenti budou odevzdat své práce (v rámci případných termínů, jsou-li nastaveny). Učitelé mohou přidělovat práce ke vzájemnému hodnocení.';
$string['switchphase30'] = 'Přepnout do fáze hodnocení';
$string['switchphase30auto'] = 'Workshop se přepne automaticky do fáze hodnocení po  {$a->daydatetime} ({$a->distanceday})';
$string['switchphase30info'] = 'Chystáte se přepnout workshop do fáze <strong>Hodnocení</strong>. V této fázi budou hodnotitelé hodnotit jim přidělené práce (v rámci případných termínů, jsou-li nastaveny).';
$string['switchphase40'] = 'Přepnout do fáze evaluace';
$string['switchphase40info'] = 'Chystáte se přepnout workshop do fáze <strong>Evaluace</strong>. Studenti již nebudou moci upravovat ani své odevzdané práce, ani vzájemná hodnocení. Učitelé mohou revidovat hodnocení prací, použít nástroje pro výpočet celkových známek a poskytnout studentům zpětnou vazbu.';
$string['switchphase50'] = 'Uzavřít workshop';
$string['switchphase50info'] = 'Chystáte se uzavřít workshop. Při uzavření budou celkové známky zapsány do klasifikace v kurzu. Studenti budou mít k dispozici své práce a jejich hodnocení.';
$string['switchphaseauto'] = 'Bylo naplánováno přepnutí';
$string['switchphasenext'] = 'Přepnout do další fáze';
$string['taskassesspeers'] = 'Ohodnotit přidělené práce';
$string['taskassesspeersdetails'] = 'celkem: {$a->total}<br />zbývá: {$a->todo}';
$string['taskassessself'] = 'Ohodnotit sebe sama';
$string['taskconclusion'] = 'Poskytnout závěrečné shrnutí';
$string['taskdone'] = 'Úkol hotov';
$string['taskfail'] = 'Úkol se nezdařil';
$string['taskinfo'] = 'Informace o úkolu';
$string['taskinstructauthors'] = 'Poskytnout pokyny k vypracování';
$string['taskinstructreviewers'] = 'Poskytnout pokyny k hodnocení';
$string['taskintro'] = 'Nastavit popis workshopu';
$string['tasksubmit'] = 'Odevzdat vlastní práci';
$string['tasktodo'] = 'Plánované úkoly';
$string['toolbox'] = 'Nástroje workshopu';
$string['undersetup'] = 'Tento workshop je momentálně ve fázi nastavení. Prosím, vyčkejte, dokud nebude přepnut do další fáze.';
$string['useexamples'] = 'Používat ukázky';
$string['useexamples_desc'] = 'Ukázky prací je možno využít k nácviku hodnocení nanečisto';
$string['useexamples_help'] = 'Je-li povoleno, studentům budou předloženy připravené ukázky různých prací, které si budou moci zkusmo ohodnotit a porovnat své hodnocení s tzv. referenčním hodnocením. Hodnocení ukázek nijak neovlivňuje výsledné známky za hodnocení.';
$string['usepeerassessment'] = 'Používat vzájemné hodnocení';
$string['usepeerassessment_desc'] = 'Studenti budou moci hodnotit práce ostatních studentů';
$string['usepeerassessment_help'] = 'Je-li povoleno, studentům bude možno přidělit práce ostatních ke vzájemnému hodnocení. Vedle známky za jejich vlastní odevzdanou práci získají ve workshopu i známku za kvalitu hodnocení prací ostatních.';
$string['userdatecreated'] = 'odevzdáno <span>{$a}</span>';
$string['userdatemodified'] = 'upraveno <span>{$a}</span>';
$string['userplan'] = 'Plán workshopu';
$string['userplan_help'] = 'Plán workshopu zobrazuje všechny fáze této činnosti a seznam úkolů daného uživatele v každé fázi. Momentálně aktuální fáze je zvýrazněna a stav splnění úkolů je indikován příslušným symbolem.';
$string['userplanaccessibilityskip'] = 'Přeskočit na aktuální úkoly';
$string['userplanaccessibilitytitle'] = 'Časová osa Workshopu s fází {$a}';
$string['userplancurrentphase'] = 'Aktuální fáze';
$string['useselfassessment'] = 'Používat sebehodnocení';
$string['useselfassessment_desc'] = 'Studenti mohou hodnotit vlastní práci';
$string['useselfassessment_help'] = 'Je-li povoleno, studentům bude moci být přidělena i jejich vlastní práce k ohodnocení, úplně stejně jako by se jednalo o práci jiného studenta.';
$string['viewworkshopsummary'] = 'Zobrazit shrnutí workshopu';
$string['weightinfo'] = 'Váha: {$a}';
$string['withoutsubmission'] = 'Hodnotitel bez vlastní odevzdané práce';
$string['workshop:addinstance'] = 'Přidat nový workshop';
$string['workshop:allocate'] = 'Přidělovat odevzdané práce k ohodnocení';
$string['workshop:deletesubmissions'] = 'Odstranit odevzdané práce';
$string['workshop:editdimensions'] = 'Upravovat hodnotící formuláře';
$string['workshop:exportsubmissions'] = 'Export prací';
$string['workshop:ignoredeadlines'] = 'Ignorovat časová omezení';
$string['workshop:manageexamples'] = 'Spravovat ukázky prací';
$string['workshop:overridegrades'] = 'Přepisovat vypočítané známky';
$string['workshop:peerassess'] = 'Hodnotit přidělené práce';
$string['workshop:publishsubmissions'] = 'Zveřejňovat odevzdané práce';
$string['workshop:submit'] = 'Odevzdávat vlastní práci';
$string['workshop:switchphase'] = 'Přepínat fázi workshopu';
$string['workshop:view'] = 'Zobrazit workshop';
$string['workshop:viewallassessments'] = 'Zobrazit všechna hodnocení';
$string['workshop:viewallsubmissions'] = 'Zobrazit všechny odevzdané práce';
$string['workshop:viewauthornames'] = 'Zobrazit jména autorů odevzdaných prací';
$string['workshop:viewauthorpublished'] = 'Zobrazit autory zveřejněných prací';
$string['workshop:viewpublishedsubmissions'] = 'Zobrazit zveřejněné práce';
$string['workshop:viewreviewernames'] = 'Zobrazit jména hodnotitelů';
$string['workshopname'] = 'Název workshopu';
$string['yourassessmentfor'] = 'Vaše hodnocení {$a}';
$string['yourgrades'] = 'Vaše známky';
$string['yoursubmission'] = 'Vaše práce';
$string['yoursubmissionwithassessments'] = 'Vaše řešení úkolu s hodnoceními';
