<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'question', language 'cs', version '5.1'.
 *
 * @package     question
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Akce';
$string['addanotherhint'] = 'Přidat další nápovědu';
$string['addcategory'] = 'Přidat kategorii';
$string['addmorechoiceblanks'] = 'Přidat další {no} odpovědi';
$string['adminreport'] = 'Přehled možných problémů s vaší databází úloh.';
$string['advancedsearchoptions'] = 'Možnosti hledání';
$string['alltries'] = 'Všechny pokusy';
$string['alwayslatest'] = 'Vždy nejnovější';
$string['answer'] = 'Odpověď';
$string['answers'] = 'Odpovědi';
$string['answersaved'] = 'Odpověď uložena';
$string['answerx'] = 'Odpověď {$a}';
$string['attemptfinished'] = 'Pokus ukončen';
$string['attemptfinishedsubmitting'] = 'Pokus skončil odesláním: {$a}';
$string['attemptoptions'] = 'Možnosti pokusu';
$string['availableq'] = 'Dostupná?';
$string['badbase'] = 'Neplatný základ mocniny: {$a}**';
$string['banksincourse'] = 'Banka úloh v tomto kurzu';
$string['behaviour'] = 'Chování';
$string['behaviourbeingused'] = 'Je použito chování: {$a}';
$string['broken'] = 'Toto je neplatný odkaz - ukazuje na neexistující soubor';
$string['byandon'] = '<em>{$a->user}</em> - <em>{$a->time}</em>';
$string['cannotcopybackup'] = 'Nelze kopírovat soubor zálohy';
$string['cannotcreate'] = 'Není možné vytvořit nový záznam v tabulce pokusů';
$string['cannotcreatepath'] = 'Nelze vytvořit cestu: {$a}';
$string['cannotdeletebehaviourinuse'] = 'Nelze smazat chování úloh \'{$a}\', protože již bylo použito v pokusech o zvládnutí testu.';
$string['cannotdeletecate'] = 'Nelze odstranit výchozí kategorii v daném kontextu';
$string['cannotdeleteneededbehaviour'] = 'Nelze smazat chování úloh \'{$a}\', protože na něm závisí jiné chování úloh.';
$string['cannotdeleteqtypeinuse'] = 'Nelze odstranit typ úlohy \'{$a}\'. V bance otázek existují úlohy tohoto typu.';
$string['cannotdeleteqtypeneeded'] = 'Nelze odstranit typ úlohy "{$a}". Existují další typy úloh, které jsou na něm závislé.';
$string['cannotdeletetopcat'] = 'Nejvyšší kategorie nelze odstranit.';
$string['cannotedittopcat'] = 'Nejvyšší kategorie nelze upravovat.';
$string['cannotenable'] = 'Typ testové úlohy {$a} nemůže být vytvořen přímo.';
$string['cannotenablebehaviour'] = 'Chování úloh "{$a}" nemůže být použito přímo, protože je určeno pouze pro vnitřní potřebu systému.';
$string['cannotfindcate'] = 'Nelze najít záznam kategorie';
$string['cannotfindquestionfile'] = 'Nelze najít data úlohy v ZIP souboru';
$string['cannotgetdsfordependent'] = 'Nelze načíst určenou datovou sadu pro tuto úlohu! (úloha {$a->id}, položka datové sady: {$a->item})';
$string['cannotgetdsforquestion'] = 'Nelze načíst určenou datovou sadu pro vypočítávanou úlohu! (úloha: {$a})';
$string['cannothidequestion'] = 'Úlohu nebylo možné skrýt';
$string['cannotimportformat'] = 'Bohužel, import z tohoto formátu není dosud implementován';
$string['cannotinsertquestion'] = 'Není možné vložit novou úlohu!';
$string['cannotinsertquestioncatecontext'] = 'Nelze vytvořit novou kategorii testových úloh {$a->cat} z důvodu neplatného contextid {$a->ctx}';
$string['cannotloadquestion'] = 'Nelze načíst testovou úlohu';
$string['cannotmovequestion'] = 'Nemůžete použít tento skript k přesunout testových úloh, s nimiž jsou asociovány soubory z různých oblastí.';
$string['cannotopenforwriting'] = 'Nelze otevřít pro zápis: {$a}';
$string['cannotpreview'] = 'Nelze zobrazit náhled těchto testových úloh!';
$string['cannotread'] = 'Nelze načíst soubor pro import (nebo je soubor prázdný)';
$string['cannotregradedifferentqtype'] = 'Nelze přehodnotit úlohou  jiného typu.';
$string['cannotretrieveqcat'] = 'Nelze načíst kategorie testové úlohy';
$string['cannotunhidequestion'] = 'Nepodařilo se odkrýt úlohu.';
$string['cannotunzip'] = 'Nepodařilo se dekomprimovat soubor.';
$string['cannotwriteto'] = 'Nelze zapsat vyexportované úlohy do {$a}';
$string['categories'] = 'Kategorie';
$string['category'] = 'Kategorie';
$string['categorycurrent'] = 'Aktuální kategorie';
$string['categorycurrentuse'] = 'Použít tuto kategorii';
$string['categorydoesnotexist'] = 'Tato kategorie neexistuje';
$string['categoryinfo'] = 'Informace o kategorii';
$string['categorymove'] = 'Kategorie \'{$a->name}\' obsahuje {$a->count} úloh (některé z nich mohou být  skryté úlohy nebo náhodné, které jsou nadále používané v některém ze stávajících testů). <br />Vyberte prosím jinou kategorii, do níž chcete úlohy přesunout.';
$string['categorymoveto'] = 'Uložit do kategorie';
$string['categorynamecantbeblank'] = 'Název kategorie nemůže být prázdný.';
$string['categorynamewithcount'] = '{$a->name} ({$a->questioncount})';
$string['categorynamewithidnumber'] = '{$a->name} [{$a->idnumber}]';
$string['categorynamewithidnumberandcount'] = '{$a->name} [{$a->idnumber}] ({$a->questioncount})';
$string['changeoptions'] = 'Změna nastavení';
$string['changepublishstatuscat'] = 'Stav sdílení <a href="{$a->caturl}">kategorie "{$a->name}"</a> v kurzu "{$a->coursename}" bude změněn z <strong>{$a->changefrom} na {$a->changeto}</strong>.';
$string['check'] = 'Zkontrolovat';
$string['chooseqtypetoadd'] = 'Zvolte typ testové úlohy';
$string['clearwrongparts'] = 'Odebrat nesprávné odpovědi';
$string['clickflag'] = 'Úloha s vlaječkou';
$string['clicktoflag'] = 'Označení testové úlohy vlaječkou pro další použití';
$string['clicktounflag'] = 'Odebrání vlaječky';
$string['clickunflag'] = 'Klikněte pro odebrání vlaječky';
$string['closepreview'] = 'Uzavřít náhled';
$string['combinedfeedback'] = 'Kombinovaná zpětná vazba';
$string['comment'] = 'Komentář';
$string['commented'] = 'Komentoval: {$a}';
$string['commentormark'] = 'Okomentovat nebo přepsat známku';
$string['comments'] = 'Komentáře';
$string['commentx'] = 'Komentář: {$a}';
$string['complete'] = 'Hotovo';
$string['contexterror'] = 'Sem byste se neměli dostat, pokud nepřesouváte kategorii do jiného kontextu';
$string['copy'] = 'Zkopíruj z {$a} a změň odkazy.';
$string['correct'] = 'Správně';
$string['correctfeedback'] = 'Za jakoukoliv správnou odpověď';
$string['correctfeedbackdefault'] = 'Vaše odpověď je správná.';
$string['courserestore'] = 'Obnovení kurzu';
$string['created'] = 'Vytvořeno';
$string['createdby'] = 'Vytvořeno uživatelem';
$string['createdefault'] = 'Vytvořit výchozí banku úloh';
$string['createdmodifiedheader'] = 'Vytvořeno / naposledy upraveno';
$string['createnewquestion'] = 'Vytvořit novou testovou úlohu ...';
$string['cwrqpfs'] = 'Náhodné úlohy vybírající úlohy z podkategorií';
$string['cwrqpfsinfo'] = '<p>V průběhu upgrade na Moodle 1.9 dojde k rozdělení kategorií úloh do různých kontextů. U některých kategorií a úloh dojde ke změně stavu jejich sdílení. Tato změna se děje zřídka, ale je nezbytná v případě, kdy je jedna nebo více náhodně vybíraných úloh v testu nastaveno tak, že náhodně vybírají úlohy jak ze sdílených, tak z nesdílených kategorií (jako je tomu v případě tohoto serveru). K této situaci dochází, když náhodně vybíraná úloha vybírá úlohy i z podkategorií a jedna nebo více těchto podkategorií má jiný stav sdílení než má nadřazená kategorie, ve které je náhodně vybíraná úloha vytvořena.</p>
<p>U následujících kategorií, z nichž jsou vybírány úlohy náhodně pomocí úlohy umístěné v nadřazené kategorii, bude změněn stav sdílení na stejnou hodnotu, jakou má kategorie, v níž je "Náhodně vybíraná úloha" uložena. Tato změna proběhne v průběhu upgrade na Moodle 1.9 a bude se týkat následujících kategorií. Úlohy, jichž se změna dotýká, budou i nadále fungovat ve všech testech, do nichž byly vloženy dokud je z těchto testů neodeberete.</p>';
$string['cwrqpfsnoprob'] = 'Žádná kategorie úloh nebude ovlivněna problémem s náhodně vybíranými úlohami z podkategorií.';
$string['decimalplacesingrades'] = 'Počet desetinných míst ve známkách';
$string['defaultbank'] = '{$a->coursename} banka úloh kurzu';
$string['defaultcreated'] = 'Byla vytvořena výchozí banka úloh kurzu.';
$string['defaultfor'] = 'Výchozí v {$a}';
$string['defaultinfofor'] = 'Výchozí kategorie pro úlohy sdílené v kontextu "{$a}".';
$string['defaultmark'] = 'Výchozí známka';
$string['defaultmarkmustbepositive'] = 'Standardní známka musí být kladné číslo.';
$string['deletecoursecategorywithquestions'] = 'V bance úloh jsou úlohy asociovány s touto kategorií kurzů. Budete-li pokračovat, budou tyto úlohy odstraněny. Možná si přejete je nejprve někam přesunout pomocí rozhraní banky úloh.';
$string['deletequestioncheck'] = 'Tímto smažete následující úlohy a všechny její verze:<br /><br />{$a}';
$string['deletequestionscheck'] = 'Tímto odstraníte následující úlohy a všechny jejich verze:<br /><br />{$a}';
$string['deletequestiontitle'] = 'Smazat úlohu?';
$string['deletequestiontitle_plural'] = 'Smazat úlohy?';
$string['deleteselectedquestioncheck'] = 'Tímto smažete vybrané verze následující úlohy:<br /><br />{$a}';
$string['deleteversiontitle'] = 'Smazat vybranou verzi?';
$string['deleteversiontitle_plural'] = 'Smazat vybrané verze?';
$string['deletingbehaviour'] = 'Odstranit chování úloh "{$a}"';
$string['deletingqtype'] = 'Odstraňování typu testové úlohy "{$a}"';
$string['didnotmatchanyanswer'] = '[Nebyly nalezeny žádné odpovědi]';
$string['disabled'] = 'Zakázáno';
$string['disabledbanks'] = 'Všechny typy modulů banky úloh jsou zakázány.';
$string['displayoptions'] = 'Možnosti zobrazení';
$string['disterror'] = 'Distribuce {$} způsobila problémy';
$string['donothing'] = 'Nekopírovat a nepřesouvat soubory, ani neměnit odkazy.';
$string['editcategories'] = 'Upravit kategorie';
$string['editcategories_help'] = 'Místo aby bylo vše v jednom velkém seznamu, mohou být úlohy uspořádány do kategorií a podkategorií.

Kategorie se také používají pro náhodné úlohy, protože úlohy jsou vybírány z určité kategorie.';
$string['editcategories_link'] = 'question/category';
$string['editcategory'] = 'Upravit kategorii';
$string['editingcategory'] = 'Úprava kategorie';
$string['editingquestion'] = 'Úprava testové úlohy';
$string['editquestion'] = 'Upravit úlohu';
$string['editquestions'] = 'Upravit úlohy';
$string['editthiscategory'] = 'Upravit tuto kategorii';
$string['emptyxml'] = 'Neznámý chyba - prázdný soubor imsmanifest.xml';
$string['enabled'] = 'Povoleno';
$string['erroraccessingcontext'] = 'Kontext není dostupný';
$string['errordeletingquestionsfromcategory'] = 'Chyba při odstraňování úloh z kategorie {$a}';
$string['errorduringpost'] = 'Došlo k chybě po zpracování!';
$string['errorduringpre'] = 'Došlo k chybě při předzpracování!';
$string['errorduringproc'] = 'Došlo k chybě při zpracování!';
$string['errorduringregrade'] = 'Nelze znovu oznámkovat úlohu {$a->qid}, přepnuto do stavu {$a->stateid}.';
$string['errorfilecannotbecopied'] = 'Chyba - nelze kopírovat soubor {$a}';
$string['errorfilecannotbemoved'] = 'Chyba - nelze přesunout soubor {$a}';
$string['errorfileschanged'] = 'Chyba - soubory odkazované z této úlohy byly změněny od doby posledního zobrazení formuláře pro úpravy';
$string['erroritemappearsmorethanoncewithdifferentweight'] = 'Úloha ({$a}) se vyskytuje na více místech v testu s rozličnými váhami. Toto v není současnosti podporováno statistickým výkazem a může být pro tuto úlohu nespolehlivé.';
$string['errormanualgradeoutofrange'] = 'Bodová známka {$a->grade} neleží mezi 0 a {$a->maxgrade} u úlohy "{$a->name}". Získaný skór ani komentář nebyl uložen.';
$string['errormovingquestions'] = 'Chyba při přesunu úloh s identifikátory {$a}';
$string['errorpostprocess'] = 'Došlo k chybě při následném zpracování!';
$string['errorpreprocess'] = 'Došlo k chybě při předzpracování!';
$string['errorprocess'] = 'Došlo k chybě při zpracování!';
$string['errorprocessingresponses'] = 'Vyskytla se chyba při zpracování vašich odpovědí \'{$a}\'. Klikněte pro návrat na předchozí stránku a pokuste se je odeslat znovu.';
$string['errorsavingcomment'] = 'Chyba při ukládání komentáře u otázky {$a->name} do databázi.';
$string['errorsavingflags'] = 'Chyba při označování vlaječkou.';
$string['errorupdatingattempt'] = 'Chyba při aktualizaci pokusu id {$a->id} v databázi.';
$string['eventqbankdisabled'] = 'Doplněk banky úloh deaktivován';
$string['eventqbankenabled'] = 'Doplněk banky úloh povolen';
$string['eventquestioncategorycreated'] = 'Vytvořena kategorie úloh';
$string['eventquestioncategorydeleted'] = 'Kategorie úloh byla smazána';
$string['eventquestioncategorymoved'] = 'Kategorie úloh byla přesunuta';
$string['eventquestioncategoryupdated'] = 'Kategorie úloh byla aktualizována';
$string['eventquestioncategoryviewed'] = 'Kategorie úloh byla zobrazena';
$string['eventquestioncreated'] = 'Úloha byla vytvořena';
$string['eventquestiondeleted'] = 'Úloha byla odstraněna';
$string['eventquestionmoved'] = 'Úloha byla přesunuta';
$string['eventquestionsexported'] = 'Úloha byla exportována';
$string['eventquestionsimported'] = 'Úloha byla importována';
$string['eventquestionupdated'] = 'Úloha byla aktualizována';
$string['eventquestionviewed'] = 'Úloha byla zobrazena';
$string['export'] = 'Export';
$string['exportasxml'] = 'Exportovat jako Moodle XML';
$string['exportcategory'] = 'Exportovat kategorii';
$string['exportcategory_help'] = 'Toto nastavení určuje kategorii, ze které budou úlohy exportovány.

Některé formáty, jako například GIFT nebo Moodle XML, umožňují uložit i informaci o původní kategorii a kontextu úloh. Ty pak mohou být opět vytvořeny při importu z daného souboru. Je-li tato funkce požadována, zaškrtněte odpovídající volby.';
$string['exporterror'] = 'došlo k chybě v průběhu exportu!';
$string['exportfilename'] = 'test';
$string['exportnameformat'] = '%Y-%m-%d-%H-%M';
$string['exportonequestion'] = 'Stáhnout tuto otázku ve formátu XML Moodle';
$string['exportquestions'] = 'Exportovat úlohy do souboru';
$string['exportquestions_help'] = 'Tato funkce vám umožní exportovat celou kategorii úloh (včetně podkategorií) do textového souboru. Mějte na paměti, že v závislosti na použitém formátu nemusejí být některá data o úloze či dokonce celé úlohy exportovány.';
$string['exportquestions_link'] = 'question/export';
$string['feedback'] = 'Reakce';
$string['fieldinquestion'] = '{$a->fieldname} {$a->questionindentifier}';
$string['fieldinquestionpre'] = '{$a->questionindentifier} {$a->fieldname}';
$string['filecantmovefrom'] = 'Soubory pro tyto testové úlohy nemohou být přesunuty, protože nemáte oprávnění odstraňovat soubory v místě, odkud úlohy přesouváte.';
$string['filecantmoveto'] = 'Soubory pro tyto testové úlohy nemohou být přesunuty ani zkopírovány, protože nemáte oprávnění přidávat soubory do místa, kam úlohy přesouváte.';
$string['fileformat'] = 'Formát souboru';
$string['filesareacourse'] = 'prostoru pro soubory v tomto kurzu';
$string['filesareasite'] = 'prostoru pro soubory na titulní stránce';
$string['filestomove'] = 'Přesunout / zkopírovat do {$a}?';
$string['fillincorrect'] = 'Vyplňte správné odpovědi';
$string['filterbytags'] = 'Filtrovat podle štítků ...';
$string['firsttry'] = 'První pokus';
$string['flagged'] = 'Označeno vlaječkou';
$string['flagthisquestion'] = 'Označit tuto úlohu vlaječkou';
$string['formquestionnotinids'] = 'Formulář obsahuje úlohu, jejíž identifikátor není uveden ve questionids';
$string['fractionsnomax'] = 'Jedna nebo více odpovědí má mít bodování 100%, aby bylo možno docílit plného bodování za tuto úlohu!';
$string['generalfeedback'] = 'Obecná reakce';
$string['generalfeedback_help'] = 'Obecná zpětná vazba je zobrazena studentovi po vyřešení úlohy. Na rozdíl od specifické zpětné vazby, která se liší dle typu úlohy a odpovědi studenta, je obecná zpětná vazba zobrazena všem studentům. Může např. obsahovat vysvětlení správné odpovědi, odkaz na další informace pro zájemce apod.';
$string['getcategoryfromfile'] = 'Získat kategorii ze souboru';
$string['getcontextfromfile'] = 'Získat kontext ze souboru';
$string['hintn'] = 'Nápověda {no}';
$string['hintnoptions'] = 'Možnosti nápovědy {no}';
$string['hinttext'] = 'Text nápovědy';
$string['howquestionsbehave'] = 'Jak se úlohy chovají';
$string['howquestionsbehave_help'] = 'Existuje několik možností chování testových úloh popsaných níže.

Adaptivní režim: Umožňuje studentům vyřešit několikrát danou úlohu, než se přesunou k úloze další. Úloha se může přizpůsobit odpovědím studenta, např. mu může poskytnout nápovědu před dalším pokusem. Varianta „bez penalizace“ nestanovuje žádné penalizace za opakované pokusy.

Interaktivní s vícero pokusy: Po odeslání odpovědi a přečtení zpětné vazby student musí kliknout na tlačítko „Zkontrolovat“. Teprve poté může znovu odpovídat. Každý pokus o něco snižuje hodnotu dosažené známky za úlohu. Jakmile student odpoví správně, nemůže již svou volbu změnit. Odpoví-li špatně příliš častokrát, je úloha vyhodnocená jako špatná (či částečně správná), volbu již nelze změnit a je zobrazena zpětná vazba. Zpětná vazba může být po každém pokusu jiná.

Odložený výsledek: Student musí odpovědět na všechny otázky a odeslat kompletní test. Teprve poté je provedeno vyhodnocení a jsou zobrazeny výsledky a zpětná vazba. Toto bude pravděpodobně nejčastěji používané nastavení.

Okamžitý výsledek: Stejně jako u interaktivního režimu i zde student okamžitě po odpovědi uvidí vyhodnocení dané úlohy. Nemůže však svou volbu již změnit.

Ruční známkování: Vyhodnocení testu neprovede Moodle, ale ručně učitel, který musí každou úlohu zvlášť oznámkovat.

Varianty „s mírou jistoty“ přidávají ke každé úloze řádek s volbou, jak moc si je student jistý svou odpovědí. Je-li si jistý málo, jeho známka za úlohu bude pokrácena příslušným koeficientem. U špatné odpovědi tak neriskuje velkou bodovou ztrátu, leč u správné odpovědi dostane jen jednu třetinu bodů za úlohu. Je-li si jistý hodně, může při správné odpovědi získat plný počet bodů, leč špatná odpověď znamená dvojnásobnou ztrátu bodů! Hodnocení s mírou jistoty pomáhají výrazněji separovat dobré a špatné žáky, mohou však snadno vést k záporným výsledkům testu.';
$string['howquestionsbehave_link'] = 'question/behaviour';
$string['idnumber'] = 'ID identifikační číslo';
$string['idnumber_help'] = 'Je-li použito, číslo ID musí být v každé kategorii otázky jedinečné. Poskytuje jiný způsob, jak identifikovat otázku, která je někdy užitečná, ale může být zpravidla prázdná.';
$string['ignorebroken'] = 'Ignorovat neplatné odkazy';
$string['import'] = 'Import';
$string['importcategory'] = 'Importovat kategorii';
$string['importcategory_help'] = 'Toto nastavení určuje, do které kategorie budou úlohy naimportovány.

Některé formáty, jako např. GIFT nebo Moodle XML, mohou obsahovat informace o původní kategorii a kontextu, odkud byly úlohy vyexportovány. Pokud si přejete použít tyto údaje namísto výběru kategorie, zaškrtněte příslušné volby. Pokud nebudou kategorie uvedené v souboru existovat, budou automaticky vytvořeny.';
$string['importerror'] = 'Došlo k chybě při zpracování importu';
$string['importerrorquestion'] = 'Chyba při importu úlohy';
$string['importfromcoursefiles'] = '... nebo si vyberte kurz, který chcete importovat.';
$string['importfromupload'] = 'Vyberte soubor, který chcete nahrát ...';
$string['importingquestions'] = 'Import {$a} otázek ze souboru';
$string['importparseerror'] = 'Při importu souboru došlo k jedné či více chybám. Pro import alespoň některých otázek se vraťte a změňte nastavení „Zastavit při chybě“ na „Ne“.';
$string['importquestions'] = 'Importovat úlohy ze souboru';
$string['importquestions_help'] = 'Tato funkce umožňuje importovat úlohy ze souborů v různých formátech. Soubory musí používat kódování UTF-8.';
$string['importquestions_link'] = 'question/import';
$string['importwrongfileencoding'] = 'Vybraný soubor není v kódování UFT-8. Soubory {$a} musí používat UTF-8.';
$string['importwrongfiletype'] = 'Typ souboru ({$a->actualtype}) neodpovídá očekávanému typu ({$a->expectedtype}).';
$string['impossiblechar'] = 'Byl zjištěn nepodporovaný znak {$a} použitý jako závorka.';
$string['includesubcategories'] = 'Zobrazit také úlohy z podkategorií
';
$string['incorrect'] = 'Nesprávně';
$string['incorrectfeedback'] = 'Za jakoukoliv nesprávnou odpověď';
$string['incorrectfeedbackdefault'] = 'Vaše odpověď je chybná.';
$string['information'] = 'Informace';
$string['invalidanswer'] = 'Neúplná odpověď';
$string['invalidarg'] = 'Nebyly poskytnuty platné argumenty nebo je nesprávná konfigurace serveru';
$string['invalidcategoryidforparent'] = 'Neplatný identifikátor nadřazené kategorie!';
$string['invalidcategoryidtomove'] = 'Neplatný identifikátor cílové kategorie!';
$string['invalidconfirm'] = 'Potvrzovací řetězec byl nesprávný';
$string['invalidcontextinhasanyquestions'] = 'Funkci question_context_has_any_questions() byl předán neplatný parametr context';
$string['invalidgrade'] = 'Známky ({$a}) neodpovídají očekávanému typu známek. Tato úloha byla přeskočena.';
$string['invalidgradequestion'] = 'Známky ({$a->grades}) neodpovídají možnostem hodnocení – otázka \'{$a->question}\' byla přeskočena.';
$string['invalidpenalty'] = 'Neplatná penalizace';
$string['invalidquestiontype'] = 'Neplatný typ úlohy: {$a}';
$string['invalidwizardpage'] = 'Určena nesprávná stránka průvodce!';
$string['lastmodifiedby'] = 'Naposledy změněno uživatelem';
$string['lasttry'] = 'Poslední pokus';
$string['linkedfiledoesntexist'] = 'Odkazovaný soubor {$a} neexistuje';
$string['makechildof'] = 'Vytvořit potomka "{$a}"';
$string['makecopy'] = 'Vytvořit kopii';
$string['maketoplevelitem'] = 'Přesunout úplně nahoru';
$string['manualgradeinvalidformat'] = 'Není platné číslo.';
$string['manualgradeoutofrange'] = 'Tato známka je mimo povolený rozsah.';
$string['manuallygraded'] = 'Ručně oznámkováno {$a->mark} s poznámkou: {$a->comment}';
$string['mark'] = 'Počet bodů';
$string['markedoutof'] = 'Počet bodů z';
$string['markedoutofmax'] = 'Počet bodů z {$a}';
$string['markoutofmax'] = 'Bodů {$a->mark} / {$a->max}';
$string['marks'] = 'Body';
$string['matchgrades'] = 'Mapování známek';
$string['matchgrades_help'] = 'Bodové ohodnocení importovaných úloh musí odpovídat některé z hodnot 100, 90, 80, 75, 70, 66.666, 60, 50, 40, 33.333, 30, 25, 20, 16.666, 14.2857, 12.5, 11.111, 10, 5, 0 (případně jejich záporným protějškům).

Tato volba určuje, jakým způsobem bude při importu naloženo s hodnotami, které neodpovídají žádné z hodnot v uvedeném seznamu:

* Nahlásit chybu - zobrazí se chybové hlášení a úloha nebude importována
* Použít nejbližší hodnotu - pokud známka neodpovídá žádné hodnotě na seznamu, bude změněna na nejbližší odpovídající hodnotu

Některé formáty mohou zapisovat známky přímo do
databáze a mohou tak obejít toto kontrolní nastavení.';
$string['matchgradeserror'] = 'Nahlásit chybu';
$string['matchgradesnearest'] = 'Použít nejbližší hodnotu';
$string['missingcourseorcmid'] = 'Funkce print_question() vyžaduje parametry courseid nebo cmid ';
$string['missingcourseorcmidtolink'] = 'Funkce get_question_edit_link() vyžaduje parametry courseid nebo cmid ';
$string['missingimportantcode'] = 'Tento typ úlohy postrádá důležitý kód: {$a}.';
$string['missingoption'] = 'V doplňovací úloze {$a} chybí její možnosti';
$string['modified'] = 'Naposledy uloženy';
$string['move'] = 'Přesunout z {$a} a změnit odkazy';
$string['movecategory'] = 'Přesunout kategorii';
$string['movedquestionsandcategories'] = 'Úlohy a kategorie přesunuty z {$a->oldplace} do {$a->newplace}.';
$string['movelinksonly'] = 'Změnit jenom odkazy, nepřesouvat ani nekopírovat.';
$string['moveq'] = 'Přesunout úlohu/-y';
$string['moveqtoanothercontext'] = 'Přesunout úlohu do jiného kontextu';
$string['moveto'] = 'Přesunout do';
$string['movingcategory'] = 'Přesun kategorie';
$string['movingcategoryandfiles'] = 'Jste si jisti, že chcete přesunout kategorii "{$a->name}" a všechny její podkategorie do kontextu "{$a->contextto}"?<br />Bylo zjištěno {$a->urlcount} odkazů na soubory uložené v {$a->fromareaname}. Přejete si tyto soubory přesunout nebo zkopírovat do {$a->toareaname}?';
$string['movingcategorynofiles'] = 'Jste si jisti, že chcete přesunout kategorii "{$a->name}" a všechny její podkategorie do kontextu "{$a->contextto}"?';
$string['movingquestions'] = 'Přesouvání úloh jakýchkoliv souborů';
$string['movingquestionsandfiles'] = 'Jste si jisti, že chcete přesunout úlohu/-y {$a->questions} do kontextu <strong>"{$a->tocontext}"</strong>? <br />Bylo zjištěno <strong>{$a->urlcount} odkazů</strong> na soubory uložené v {$a->fromareaname}. Přejete si tyto soubory přesunout nebo zkopírovat do {$a->toareaname}?';
$string['movingquestionsnofiles'] = 'Jste si jisti, že chcete přesunout úlohu/-y {$a->questions} do kontextu <strong>"{$a->tocontext}"</strong>? <br />Nebyly zjištěny žádné odkazy na soubory umístěné v {$a->fromareaname}.';
$string['needtochoosecat'] = 'Musíte zvolit kategorii, kam se má úloha přesunout, nebo stisknout "Zrušit".';
$string['nobanks'] = 'Tento kurz zatím nemá žádné banky úloh.';
$string['nocate'] = 'Není žádná taková kategorie {$a}!';
$string['noconditionspecified'] = 'Upřesněte prosím podmínku';
$string['nopermissionadd'] = 'Nemáte oprávnění přidávat zde úlohy.';
$string['nopermissionedit'] = 'Nemáte oprávnění odtud upravovat otázky.';
$string['noprobs'] = 'Nebyly nalezeny žádné problémy ve vaší databázi úloh.';
$string['noquestionbanks'] = 'Nebyl nalezen žádný doplněk banky úloh.';
$string['noquestions'] = 'Nenalezeny žádné úlohy k exportu. Vybrali jste správnou kategorii k exportu?';
$string['noquestionsinfile'] = 'Importovaný soubor neobsahuje žádné úlohy.';
$string['noresponse'] = '[Žádná odpověď]';
$string['notagfiltersapplied'] = 'Nebyly použity žádné filtry štítků';
$string['notanswered'] = 'Nezodpovězeno';
$string['notchanged'] = 'Od posledního pokusu beze změny';
$string['notenoughanswers'] = 'Tento typ úlohy vyžaduje nejméně {$a} odpovědí';
$string['notenoughdatatoeditaquestion'] = 'Nebyl specifikován ani identifikátor úlohy, ani identifikátor kategorie ani typ úlohy.';
$string['notenoughdatatomovequestions'] = 'Musíte poskytnout identifikátory úloh, které chcete přesunout.';
$string['notgraded'] = 'Není hodnoceno';
$string['notshown'] = 'Nezobrazeno';
$string['notyetanswered'] = 'Dosud nezodpovězeno';
$string['notyourpreview'] = 'Tento náhled nepatří vám';
$string['novirtualquestiontype'] = 'Pro úlohu typu {$a} neexistuje virtuální kategorie';
$string['numqas'] = 'Počet pokusů';
$string['numquestions'] = 'Počet úloh';
$string['numquestionsandhidden'] = '{$a->numquestions} (+{$a->numhidden} skrytých +{$a->numdraft} návrhů)';
$string['options'] = 'Možnosti';
$string['otherbanks'] = 'Další aktivity s úlohami';
$string['otherbanksdesc'] = 'Úlohy v bankách úloh těchto aktivit nelze použít jinde.';
$string['otherquestionbank'] = 'Všechny banky úloh';
$string['otherquestionbankstoomany'] = 'Více než {$a} výsledků. Je třeba upřesnit vyhledávání.';
$string['page-question-category'] = 'Stránka kategorie testové úlohy';
$string['page-question-edit'] = 'Stránka pro úpravu testové úlohy';
$string['page-question-export'] = 'Stránka pro export testové úlohy';
$string['page-question-import'] = 'Stránka pro import testové úlohy';
$string['page-question-x'] = 'Jakákoliv stránka testové úlohy';
$string['parent'] = 'Rodič';
$string['parentcategory'] = 'Nadřazená kategorie';
$string['parentcategory_help'] = 'Nadřazená kategorie je ta, pod kterou bude tato kategorie umístěna. "Nahoru" znamená, že tato kategorie nemá žádnou nadřazenou kategorii. Kontext kategorie je zvýrazněn tučně. V každém kontextu musí být alespoň jedna kategorie.';
$string['parentcategory_link'] = 'question/category';
$string['parenthesisinproperclose'] = 'Závorka v {$a}** není korektně uzavřena';
$string['parenthesisinproperstart'] = 'Závorka v {$a}** není korektně otevřena';
$string['parsingquestions'] = 'Zpracovávám úlohy z importního souboru.';
$string['partiallycorrect'] = 'Částečně správně';
$string['partiallycorrectfeedback'] = 'Za jakoukoliv částečně správnou odpověď';
$string['partiallycorrectfeedbackdefault'] = 'Vaše odpověď je částečně správná.';
$string['penaltyfactor'] = 'Penalizační faktor';
$string['penaltyfactor_help'] = 'Určuje, jak velká část dosaženého skóre má být odečtena za každou nesprávnou odpověď. Tato možnost je relevantní, pouze pokud test běží v adaptivním režimu.

Penalizační faktor by měl být číslo v intervalu 0 až 1. Hodnota 1 znamená, že student musí odpovědět
správně při prvním pokusu, aby za úlohu vůbec dostal nějaké body. Hodnota 0 znamená, že student může na danou úlohu odpovídat kolikrát chce a přesto dostane plný počet bodů.';
$string['penaltyforeachincorrecttry'] = 'Penalizace pro každý chybný pokus';
$string['penaltyforeachincorrecttry_help'] = 'Penalizace se uplatňuje pouze v testu, který má nastaven tzv. "Adaptivní režim" nebo "Interaktivní režim s vícero pokusy". Smyslem penalizace je snížit výsledný počet bodů za danou otázku tak, aby se zohlednilo, kolik pokusů student potřeboval k nalezení správné odpovědi. Tato volba pak určuje, nakolik jsou penalizováni za každý nesprávný pokus.

Penalizace je podíl celkové známky úlohy, takže v případě, že úloha je za tři body a penalizace je 0.3333333, pak student získá 3, pokud odpoví správně napoprvé, 2 body v případě, že bude správně druhý pokus, a 1 bod na třetí pokus.

Pro některé úlohy s více odpověďmi je tato bodovací logika aplikována odděleně na každou část úlohy. Podrobnosti závisí na typu úlohy a mohou být komplikované, ale principem je poskytnout studentům kredit za znalosti, které prokázali co nejpřesněji.';
$string['permissionedit'] = 'Upravit tuto úlohu';
$string['permissionmove'] = 'Přesunout tuto úlohu';
$string['permissionsaveasnew'] = 'Uložit jako novou úlohu';
$string['permissionto'] = 'Máte oprávnění:';
$string['previewbank'] = 'Náhled sdílené banky úloh';
$string['previewquestion'] = 'Náhled úlohy: {$a}';
$string['privacy:metadata:database:question'] = 'Podrobnosti o konkrétní úloze.';
$string['privacy:metadata:database:question:createdby'] = 'Osoba, která úlohu vytvořila.';
$string['privacy:metadata:database:question:generalfeedback'] = 'Obecná zpětná vazba pro tuto úlohu.';
$string['privacy:metadata:database:question:modifiedby'] = 'Osoba, která tuto úlohu naposledy aktualizovala.';
$string['privacy:metadata:database:question:name'] = 'Název úlohy.';
$string['privacy:metadata:database:question:questiontext'] = 'Text úlohy.';
$string['privacy:metadata:database:question:timecreated'] = 'Datum a čas vytvoření úlohy.';
$string['privacy:metadata:database:question:timemodified'] = 'Datum a čas úpravy úlohy.';
$string['privacy:metadata:database:question_attempt_step_data'] = 'Kroky pokusu úlohy mohou mít k tomuto kroku další údaje. Data jsou uložena v tabulce step_data.';
$string['privacy:metadata:database:question_attempt_step_data:name'] = 'Název datové položky.';
$string['privacy:metadata:database:question_attempt_step_data:value'] = 'Hodnota datové položky.';
$string['privacy:metadata:database:question_attempt_steps'] = 'Každý pokus úlohy má řadu kroků k označení jednotlivých fází od začátku až po dokončení. Tato tabulka ukládá informace pro každý z těchto kroků.';
$string['privacy:metadata:database:question_attempt_steps:fraction'] = 'Známka, která byla udělena této úloze, byla změněna na hodnotu z hodnoty 1.';
$string['privacy:metadata:database:question_attempt_steps:state'] = 'Stav tohoto kroku pokusu úlohy na konci kroku přechodu.';
$string['privacy:metadata:database:question_attempt_steps:timecreated'] = 'Datum a čas, kdy začal tento krok přechodu.';
$string['privacy:metadata:database:question_attempt_steps:userid'] = 'Uživatel, který provedl krok přechodu.';
$string['privacy:metadata:database:question_attempts'] = 'Informace o pokusu o konkrétní úlohu.';
$string['privacy:metadata:database:question_attempts:flagged'] = 'Označení, že uživatel tuto úlohu v rámci pokusu označil.';
$string['privacy:metadata:database:question_attempts:responsesummary'] = 'Shrnutí odpovědi na úlohu.';
$string['privacy:metadata:database:question_attempts:timemodified'] = 'Čas aktualizace úlohy pokusu.';
$string['privacy:metadata:database:question_bank_entries'] = 'Podrobnosti o konkrétním záznamu úlohy banky.';
$string['privacy:metadata:database:question_bank_entries:ownerid'] = 'Osoba, která vlastní záznam úlohy banky.';
$string['privacy:metadata:link:qbehaviour'] = 'Subsystém Úlohy používá modul Chování úloh.';
$string['privacy:metadata:link:qformat'] = 'Subsystém Úlohy používá modul Formát úloh pro import a export úloh za účelem importu a exportu v různých formátech.';
$string['privacy:metadata:link:qtype'] = 'Subsystém Úlohy spolupracuje s modulem Typy úloh, který obsahuje různé typy úloh.';
$string['published'] = 'sdílená';
$string['qbanknotfound'] = 'Doplněk banky úloh „{$a}“ neexistuje nebo není rozpoznán.';
$string['qtypeveryshort'] = 'T';
$string['question_version'] = 'Verze úlohy';
$string['question_versionshort'] = 'v{$a}';
$string['questionaffected'] = '<a href="{$a->qurl}">Úloha "{$a->name}" ({$a->qtype})</a> je v této kategorii úloh, ale je též zařazena do <a href="{$a->qurl}">testu "{$a->quizname}"</a> v kurzu "{$a->coursename}".';
$string['questionbank'] = 'Banka úloh';
$string['questionbank_plural'] = 'Banky úloh';
$string['questionbanknavigation'] = 'Terciární navigace banky úloh';
$string['questionbehaviouradminsetting'] = 'Nastavení chování úlohy';
$string['questionbehavioursdisabled'] = 'Deaktivováno chování úlohy';
$string['questionbehavioursdisabledexplained'] = 'Zadejte čárkou oddělený seznam chování úloh, která nechcete zobrazit v menu.';
$string['questionbehavioursorder'] = 'Pořadí chování úloh';
$string['questionbehavioursorderexplained'] = 'Zadejte čárkou oddělený seznam chování úloh v pořadí, v jakém se mají objevit v menu.';
$string['questioncategories'] = 'Kategorie úloh';
$string['questioncategory'] = 'Kategorie úloh';
$string['questioncatsfor'] = 'Kategorie úloh v kontextu "{$a}"';
$string['questiondefaultssave'] = 'Uložit možnosti úlohy jako výchozí předvolby uživatele';
$string['questiondefaultssave_desc'] = 'Zda jsou možnosti úlohy jako "Výchozí známka", "Jedna nebo více odpovědí?" atd. by měly být uloženy jako uživatelské preference při odeslání formuláře pro úpravu úloh, aby se mohly použít jako výchozí při příštím přístupu uživatele k formuláři.';
$string['questiondoesnotexist'] = 'Tato testová úloha neexistuje';
$string['questionediting'] = 'Úprava úlohy';
$string['questionediting_desc'] = 'Tato nastavení řídí aspekty formulářů pro úpravy úloh.';
$string['questionformtagheader'] = '{$a} štítky';
$string['questionidmismatch'] = 'Nesouhlasí identifikátory úloh';
$string['questionloaderror'] = 'Nepodařilo se načíst možnosti úloh.';
$string['questionname'] = 'Název úlohy';
$string['questionnameandquestionversion'] = '{$a->name} v{$a->version}';
$string['questionnamecopy'] = '{$a} (kopie)';
$string['questionno'] = 'Úloha {$a}';
$string['questionpreviewdefaults'] = 'Výchozí náhled úloh';
$string['questionpreviewdefaults_desc'] = 'Při prvním náhledu úlohy z banky úloh jsou použity tyto výchozí hodnoty. Po prvním zobrazení náhledu úlohy, jsou jeho osobní preference uloženy jako uživatelské předvolby.';
$string['questions'] = 'Úlohy';
$string['questionsaveerror'] = 'Při ukládání úlohy ({$a}) nastala chyba';
$string['questionsinuse'] = '* Označuje úlohy, které nelze smazat, protože se používají. Místo toho budou skryty v bance úloh, pokud nezvolíte "Zobrazit skryté úlohy" na "Ano".';
$string['questionsmovedto'] = 'Úlohy, které jsou stále používány, byly přesunuty do "{$a}" v nadřazené kategorii kurzů.';
$string['questionsrescuedfrom'] = 'Úlohy uložené z kontextu {$a}.';
$string['questionsrescuedfrominfo'] = 'Tyto úlohy (z nichž některé mohou být skryté) byly uloženy při odstraňování kontextu {$a}, protože jsou stále používány v některých testech či jiných modulech činností.';
$string['questiontags'] = 'Štítky otázek';
$string['questiontext'] = 'Text úlohy';
$string['questiontype'] = 'Typ úlohy';
$string['questionuse'] = 'Použij úlohu v této činnosti';
$string['questionvariant'] = 'Varianta úlohy';
$string['questionx'] = 'Úloha {$a}';
$string['quizquestionbank'] = 'Banky úloh tohoto testu';
$string['recentlyviewedquestionbanks'] = 'Nedávno zobrazené banky úloh';
$string['requiresgrading'] = 'Vyžaduje hodnocení';
$string['responsehistory'] = 'Historie odpovědí';
$string['restart'] = 'Začít znovu';
$string['restartwiththeseoptions'] = 'Uložit možnosti náhledu a začít znovu';
$string['restoremultipletopcats'] = 'Záložní soubor obsahuje více než jednu kategorii nejvyšší úrovně pro kontext {$a}.';
$string['reviewresponse'] = 'Náhled odpovědi';
$string['rightanswer'] = 'Správná odpověď';
$string['rightanswer_help'] = 'Automaticky zobrazené shrnutí správné odpovědi. Jeho rozsah bývá zpravidla omezený, a pokud nepostačuje, je vhodné místo toho zvážit podání zevrubného vysvětlení v rámci "Obecné reakce" a tuto možnost vypnout.';
$string['save'] = 'Uložit';
$string['savechangesandcontinueediting'] = 'Uložit změny a pokračovat v úpravách';
$string['saved'] = 'Uloženo: {$a}';
$string['saveflags'] = 'Uložit stav vlaječek';
$string['selectacategory'] = 'Vyberte kategorii:';
$string['selectaqtypefordescription'] = 'Zvolte typ úlohy k zobrazení jejího popisu';
$string['selectcategoryabove'] = 'Vyberte výše kategorii';
$string['selectquestionsforbulk'] = 'Označte úlohy pro hromadné zpracování';
$string['settingsformultipletries'] = 'Nastavení pro vícero pokusů';
$string['shareincontext'] = 'Sdílet v kontextu {$a}';
$string['shortversioninfo'] = 'v{$a->version} (of {$a->latestversion})';
$string['shortversioninfolatest'] = 'v{$a->version} (latest)';
$string['showhidden'] = 'Zobrazovat také skryté úlohy';
$string['showmarkandmax'] = 'Zobrazit získané a nejvyšší možné body';
$string['showmaxmarkonly'] = 'Zobrazit jen nejvyšší možné body';
$string['shown'] = 'Zobrazit';
$string['shownumpartscorrect'] = 'Zobrazit počet správných odpovědí';
$string['shownumpartscorrectwhenfinished'] = 'Zobrazit počet správných odpovědí';
$string['showquestiontext'] = 'Zobrazit text úlohy v seznamu úloh?';
$string['showquestiontext_full'] = 'Ano, s obrázky, médii atd.';
$string['showquestiontext_off'] = 'Ne';
$string['showquestiontext_plain'] = 'Ano, pouze text';
$string['specificfeedback'] = 'Konkrétní reakce';
$string['specificfeedback_help'] = 'Zpětná vazba, která závisí na odpovědi studenta.';
$string['started'] = 'Zahájeno';
$string['state'] = 'Stav';
$string['step'] = 'Krok';
$string['steps'] = 'Kroky';
$string['stoponerror'] = 'Zastavit při chybě';
$string['stoponerror_help'] = 'Určuje, zda se má při výskytu chyby proces importování zastavit a žádná úloha se nemá naimportovat. Nebo zda se mají chybné úlohy přeskočit a všechny platné se mají naimportovat normálně.';
$string['submissionoutofsequence'] = 'Přístup mimo pořadí. Při řešení testu prosím neklikejte na tlačítko zpět.';
$string['submissionoutofsequencefriendlymessage'] = 'Zadali jste vstup mimo pořadí. Tato situace může nastat, když používáte tlačítka prohlížeče Dozadu nebo Dopředu; během testu je prosím nepoužívejte. Může se také stát, pokud kliknete na něco při načítání. Pokračujte kliknutím na tlačítko <strong> Pokračovat </strong> .';
$string['submit'] = 'Odeslat';
$string['submitandfinish'] = 'Odeslat vše a ukončit  pokus';
$string['submitted'] = 'Odevzdáno: {$a}';
$string['switchbank'] = 'Přepnout banku';
$string['systembank'] = 'Systémem sdílená banka úloh';
$string['systembankdescription'] = 'Tento typ banky úloh byla vytvořena automaticky při upgradu stránek.';
$string['tagarea_question'] = 'Úlohy';
$string['technicalinfo'] = 'Technické informace';
$string['technicalinfo_help'] = 'Tato technická informace je pravděpodobně užitečné pouze pro vývojáře, kteří pracují na nových typech úloh. Může to být také užitečné při diagnostice problémů s úlohami.';
$string['technicalinfomaxfraction'] = 'Maximální podíl: {$a}';
$string['technicalinfominfraction'] = 'Minimální podíl: {$a}';
$string['technicalinfoquestionsummary'] = 'Shrnutí úlohy: {$a}';
$string['technicalinforesponsesummary'] = 'Přehled odpovědí : {$a}';
$string['technicalinforightsummary'] = 'Shrnutí správné odpovědi: {$a}';
$string['technicalinfostate'] = 'Stav úlohy: {$a}';
$string['technicalinfovariant'] = 'Varianta úlohy: {$a}';
$string['tofilecategory'] = 'Zapsat kategorii do souboru';
$string['tofilecontext'] = 'Zapsat kontext do souboru';
$string['topfor'] = 'Nejlépe pro {$a}';
$string['uninstallbehaviour'] = 'Odinstalovat toto chování úloh.';
$string['uninstallqtype'] = 'Odinstalovat tento typ testové úlohy';
$string['unknown'] = 'Neznámý';
$string['unknownbehaviour'] = 'Neznámé chování: {$a}.';
$string['unknownorunhandledtype'] = 'Neznámý nebo neošetřený typ úlohy: {$a}';
$string['unknownquestion'] = 'Neznámá úloha: {$a}.';
$string['unknownquestioncatregory'] = 'Neznámá kategorie úlohy: {$a}.';
$string['unknownquestiontype'] = 'Neznámý typ úlohy: {$a}.';
$string['unknowntolerance'] = 'Neznámý typ tolerance {$a}';
$string['unpublished'] = 'nesdílená';
$string['unusedcategorydeleted'] = 'Tato kategorie byla odstraněna, neboť po odstranění kurzu nebyly jeho úlohy jinde na serveru používány.';
$string['updatedisplayoptions'] = 'Aktualizovat možnosti zobrazení';
$string['upgradeproblemcategoryloop'] = 'Byl zjištěn problém při upgrade kategorií úloh. Strom kategorií obsahuje smyčku. Identifikátory postižených kategorií jsou {$a}.';
$string['upgradeproblemcouldnotupdatecategory'] = 'Není možno aktualizovat kategorii {$a->name} ({$a->id}).';
$string['upgradeproblemunknowncategory'] = 'Byl zjištěn problém při upgrade kategorií úloh. Kategorie {$a->id} má spadat pod kategorii {$a->parent}, ale ta neexistuje. Reference na nadřazenou kategorii byla opravena.';
$string['version_selection'] = 'Verze {$a->version}';
$string['versioninfo'] = 'Verze {$a->version} (z {$a->latestversion})';
$string['versioninfolatest'] = 'Verze {$a->version} (nejnovější)';
$string['versioninfolatestshort'] = 'v{$a} (nejnovější)';
$string['whethercorrect'] = 'Zda je správně';
$string['whethercorrect_help'] = 'Týká se informací o správnosti odpovědi ("Správně", "Částečně správně" a "Špatně") a jakéhokoliv zvýrazněného textu, který poskytuje tutéž informaci.';
$string['whichtries'] = 'Který pokus';
$string['withselected'] = 'S označenými';
$string['wrongprefix'] = 'Nesprávně formátovaný prefix názvu {$a}';
$string['xoutofmax'] = '{$a->mark} / {$a->max}';
$string['yougotnright'] = 'Vybrali jste správně {$a->num}.';
$string['youmustselectaqtype'] = 'Musíte zvolit typ úlohy.';
$string['yourfileshoulddownload'] = 'Vyexportovaný soubor by se měl začít okamžitě stahovat. Pokud se tak nestane, <a href="{$a}">klikněte sem</a>.';
