<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'pdfannotator', language 'cs', version '5.1'.
 *
 * @package     pdfannotator
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actiondropdown'] = 'Volby';
$string['activities'] = 'Činnosti';
$string['addAComment'] = 'Přidat komentář';
$string['add_private_comment'] = 'Přidejte komentář k osobní poznámce';
$string['add_protected_comment'] = 'Přidejte komentář k soukromé otázce';
$string['ago'] = 'před {$a}';
$string['all'] = 'všechno';
$string['all_answers'] = 'Všechny odpovědi';
$string['all_questions'] = 'Všechny otázky';
$string['allanswers'] = 'vše';
$string['allquestions'] = 'vše';
$string['allquestionsimgtitle'] = 'Zobrazit všechny otázky v tomto dokumentu';
$string['allquestionstitle'] = 'Všechny otázky v';
$string['allreports'] = 'všechny zprávy';
$string['annotationDeleted'] = 'Anotace byla smazána';
$string['anonymous'] = 'Anonymní';
$string['answer'] = 'Odpověď';
$string['answerButton'] = 'Odpověď';
$string['answerSolved'] = 'Tato odpověď byla manažerem označena jako správná.';
$string['answercounthelpicon'] = 'Počet odpovědí';
$string['answercounthelpicon_help'] = 'Tento sloupec uvádí, kolik odpovědí na otázku obdržel.';
$string['answers'] = 'odpovědi';
$string['answerstab'] = 'Odpovědi';
$string['answerstabicon'] = 'Odpovědi';
$string['answerstabicon_help'] = 'Tato stránka vám může zobrazit všechny odpovědi nebo pouze odpovědi na otázky, které jste odebírali*. Seznam pokrývá všechny anotátory v tomto kurzu.<br>*Když sami odešlete otázku, jste automaticky přihlášeni k jejímu odběru, pokud odběr neodhlásíte.';
$string['author'] = 'Autor';
$string['average'] = 'průměr';
$string['average_answers'] = 'Průměrné odpovědi';
$string['average_help'] = 'Do výpočtu průměru (aritmetický průměr) jsou zahrnuti pouze uživatelé, kteří napsali alespoň jeden komentář';
$string['average_questions'] = 'Průměrné otázky';
$string['by'] = 'od';
$string['by_other_users'] = 'jinými uživateli';
$string['bynameondate'] = 'od {$a->name} - {$a->date}';
$string['cancelButton'] = 'Zrušit';
$string['chart_title'] = 'Otázky a odpovědi v anotátorech tohoto kurzu';
$string['clicktoopen2'] = 'Kliknutím na odkaz {$a} zobrazíte soubor.';
$string['closedquestions'] = 'vyřešeno';
$string['colorPicker'] = 'Vybrat barvu';
$string['comment'] = 'Komentář';
$string['commentDeleted'] = 'Komentář byl smazán';
$string['comments'] = 'Komentáře';
$string['comments_icon_private'] = 'Tento komentář je soukromý';
$string['comments_icon_public'] = 'Tento komentář je veřejný';
$string['comments_text_all'] = 'Zobrazit všechny komentáře';
$string['comments_text_private'] = 'Zobrazit pouze soukromé komentáře (oranžové)';
$string['comments_text_public'] = 'Zobrazit pouze veřejné komentáře (modré)';
$string['configmaxbytes'] = 'Maximální velikost souboru';
$string['correct'] = 'správně';
$string['count'] = 'počet';
$string['createAnnotation'] = 'Vytvořit anotaci';
$string['currentPage'] = 'číslo aktuální stránky';
$string['day'] = 'den';
$string['days'] = 'dny';
$string['decision'] = 'Rozhodnout se';
$string['decision:overlappingAnnotation'] = 'Klikli jste na oblast, ve které je více než jedna anotace. Rozhodněte se, na kterou chcete kliknout.';
$string['delete'] = 'Smazat';
$string['deleteComment'] = 'Smazat komentář';
$string['deletedComment'] = 'smazaný komentář';
$string['deletedQuestion'] = 'smazaná otázka';
$string['deletingAnnotation_manager'] = 'Anotace a všechny odpovídající komentáře budou smazány.';
$string['deletingAnnotation_student'] = 'Anotace a všechny odpovídající komentáře budou smazány.<br>Své vlastní anotace můžete smazat, pokud je nekomentovali jiní uživatelé.';
$string['deletingComment'] = 'Komentář bude smazán. Bude zobrazen jako smazaný, pokud se nejedná o poslední komentář v jeho vláknu.';
$string['deletingCommentTitle'] = 'Jsi si jisti?';
$string['deletingQuestion_manager'] = 'Komentář bude smazán.<br>Tip: Pokud chcete smazat i všechny odpovědi, smažte anotaci v dokumentu.';
$string['deletingQuestion_student'] = 'Otázka bude smazána.<br>Pokud nebude zodpovězena, bude smazána i anotace, jinak bude otázka zobrazena jako smazaná';
$string['deletionForbidden'] = 'Smazání není povoleno';
$string['didyouknow'] = 'Věděl jsi?';
$string['dnduploadpdfannotator'] = 'Vytvořte soubor pro PDF anotaci';
$string['document'] = 'Dokument';
$string['drawing'] = 'Nakreslit do dokumentu perem.';
$string['edit'] = 'Upravit';
$string['editAnnotation'] = 'Anotace bude přesunuta. <br>To může změnit kontext otázky.';
$string['editAnnotationTitle'] = 'Jsi si jisti?';
$string['editButton'] = 'Uložit';
$string['editNotAllowed'] = 'Posouvání není dovoleno!';
$string['editedComment'] = 'naposledy upraveno';
$string['emptypdf'] = 'V tomto anotátoru nejsou momentálně žádné komentáře.';
$string['enterText'] = 'Vložit text';
$string['entity_helptitle'] = 'Pomoc pro';
$string['error'] = 'Chyba!';
$string['error:addAnnotation'] = 'Při přidávání anotace došlo k chybě.';
$string['error:addComment'] = 'Při přidávání komentáře došlo k chybě.';
$string['error:closequestion'] = 'Při zavírání/otevírání otázky došlo k chybě.';
$string['error:deleteAnnotation'] = 'Při mazání anotace došlo k chybě.';
$string['error:editAnnotation'] = 'Při úpravě anotace došlo k chybě.';
$string['error:editcomment'] = 'Při pokusu o úpravu komentáře došlo k chybě.';
$string['error:findimage'] = 'Při pokusu o nalezení obrázku {$a} došlo k chybě.';
$string['error:forwardquestion'] = 'Při přeposílání otázky došlo k chybě.';
$string['error:forwardquestionnorecipient'] = 'Při přeposílání otázky došlo k chybě.: Žádná osoba v tomto kurzu nemá schopnost přijímat přeposlané otázky.';
$string['error:getAllQuestions'] = 'Při získávání otázek tohoto dokumentu došlo k chybě.';
$string['error:getAnnotation'] = 'Při získávání anotace došlo k chybě.';
$string['error:getAnnotations'] = 'Při získávání všech anotací došlo k chybě.';
$string['error:getComments'] = 'Při získávání komentářů došlo k chybě.';
$string['error:getQuestions'] = 'Při získávání otázek pro tuto stránku došlo k chybě.';
$string['error:getimageheight'] = 'Při získávání výšky obrázku {$a} došlo k chybě.';
$string['error:getimagewidth'] = 'Při získávání šířky obrázku {$a} došlo k chybě.';
$string['error:hideComment'] = 'Při pokusu o skrytí komentáře z pohledu účastníků došlo k chybě.';
$string['error:markasread'] = 'Položku nelze označit jako přečtenou.';
$string['error:markasunread'] = 'Položku nelze označit jako nepřečtenou.';
$string['error:markcorrectanswer'] = 'Při označování odpovědi jako správné došlo k chybě.';
$string['error:maximalsizeoffile'] = 'Váš soubor {$a->filename}, protože překračuje {$a->filesize} jako maximální velikost souborů. K jednomu komentáři můžete připojit soubor(y) s nejvýše {$a->maxfilesize}.';
$string['error:missingAnnotationtype'] = 'Typ anotace neexistuje. Položka v tabulce pdfannotator_annotationtypes možná chybí.';
$string['error:openingPDF'] = 'Při otevírání souboru PDF došlo k chybě.';
$string['error:openprintview'] = 'Při pokusu o otevření souboru pdf v aplikaci Acrobat Reader došlo k chybě.';
$string['error:printcomments'] = 'Při pokusu o otevření komentářů v pdf došlo k chybě.';
$string['error:printcommentsdata'] = 'Chyba s daty ze serveru.';
$string['error:printlatex'] = 'Při pokusu o přidání vzorce LaTeX do souboru pdf došlo k chybě.';
$string['error:redihideCommentsplayComment'] = 'Při opětovném vkládání komentáře pro účastníky došlo k chybě.';
$string['error:redisplayComment'] = 'Při opětovném zobrazení komentáře došlo k chybě.';
$string['error:renderPage'] = 'Při vykreslování stránky došlo k chybě.';
$string['error:reportComment'] = 'Při ukládání přehledu došlo k chybě.';
$string['error:subscribe'] = 'Při přihlašování k odběru otázky došlo k chybě.';
$string['error:unsubscribe'] = 'Při odhlašování dotazu došlo k chybě.';
$string['error:unsupportedextension'] = 'Rozšíření odeslaných dat není podporováno. Vyberte prosím jiné rozšíření.';
$string['error:voteComment'] = 'Při ukládání hlasování došlo k chybě.';
$string['eventreport_added'] = 'Byl nahlášen komentář';
$string['export_comments_csv'] = 'Exportovat jako CSV';
$string['export_comments_csv_tooltip'] = 'Stáhnout komentáře jako soubor CSV';
$string['export_comments_pdf'] = 'Exportovat jako PDF';
$string['export_comments_pdf_tooltip'] = 'Stáhnout komentáře jako PDF soubor';
$string['filenotfound'] = 'Soubor nenalezen, omlouváme se.';
$string['forward'] = 'Přeposlat';
$string['forwardedquestionhtml'] = '{$a->sender} vám přeposlal následující otázku: <br /> <br />
"{$a->obsah otázky" <br /> <br />
 se zprávou: <br /> <br />
"{$a->zpráva" <br /> <br />
Otázka je k dispozici <a href="{$a->urltoquestion}">zde</a>.';
$string['forwardedquestiontext'] = '{$a->sender} vám přeposlal následující otázku:

"{$a->questioncontent}"

se zprávou:

"{$a->message}"

Otázka je dostupná na: {$a->urltoquestion}';
$string['fullscreen'] = 'Celá obrazovka';
$string['fullscreenBack'] = 'Ukončit celou obrazovku';
$string['global_setting_anonymous'] = 'Povolit anonymní příspěvky?';
$string['global_setting_anonymous_desc'] = 'Pomocí této možnosti umožníte svému uživateli anonymně přidávat komentáře. Tato možnost aktivuje anonymní odesílání globálně';
$string['global_setting_attobuttons'] = 'Konfigurace panelu nástrojů editoru Atto';
$string['global_setting_attobuttons_desc'] = 'Zde lze konfigurovat seznam pluginů a pořadí jejich zobrazení. Konfigurace se skládá ze skupin (jedna na řádek), za nimiž následuje seřazený seznam pluginů pro danou skupinu. Skupina se od zásuvných modulů odděluje znakem rovná se a zásuvné moduly se oddělují čárkami. Názvy skupin musí být jedinečné a měly by naznačovat, co mají tlačítka společné. Názvy tlačítek a skupin by se neměly opakovat a mohou obsahovat pouze alfanumerické znaky.';
$string['global_setting_latexapisetting'] = 'LaTeX na PNG API';
$string['global_setting_latexapisetting_desc'] = 'API pro převod Latexu do PNG pro stahování PDF.<br>
Poznámka: Pokud používáte Google Chart API, Google získá všechny vzorce v dokumentu, pokud se někdo rozhodne používat LaTeX<br>
Pokud používáte Moodle API, potřebujete na vašem serveru nainstalovaný latex, dvips a convert binární.
(Viz <a href="https://docs.moodle.org/38/en/TeX_notation_filter">Dokumentace Moodle</a>)
PŘELOŽIT TUTO STRÁNKU';
$string['global_setting_latexusegoogle'] = 'Google Chart API';
$string['global_setting_latexusemoodle'] = 'Interní API Moodle';
$string['global_setting_use_private_comments'] = 'Povolit osobní poznámky?';
$string['global_setting_use_private_comments_desc'] = 'Umožněte účastníkům psát osobní poznámky a osobní poznámky';
$string['global_setting_use_protected_comments'] = 'Povolit soukromé komentáře?';
$string['global_setting_use_protected_comments_desc'] = 'Umožněte účastníkům psát soukromé poznámky a soukromé komentáře. Tento komentář vidí pouze autor a správce.';
$string['global_setting_use_studentdrawing'] = 'Povolit nákresy pro účastníky?';
$string['global_setting_use_studentdrawing_desc'] = 'Vezměte prosím na vědomí, že kresby jsou anonymní a nelze je komentovat ani nahlásit.';
$string['global_setting_use_studenttextbox'] = 'Povolit textová pole pro účastníky?';
$string['global_setting_use_studenttextbox_desc'] = 'Upozorňujeme, že anotace textového pole jsou anonymní a nelze je komentovat ani nahlásit.';
$string['global_setting_useprint'] = 'Povolit ukládání a tisk?';
$string['global_setting_useprint_comments'] = 'Povolit ukládání/tisk komentářů?';
$string['global_setting_useprint_comments_desc'] = 'Umožníte účastníkům ukládat a tisknout anotace a komentáře';
$string['global_setting_useprint_desc'] = 'Umožníte účastníkům uložit a vytisknout dokument PDF a jeho komentáře';
$string['global_setting_useprint_document'] = 'Povolit ukládání/tisk dokumentu?';
$string['global_setting_useprint_document_desc'] = 'Umožníte účastníkům uložit a vytisknout dokument pdf';
$string['global_setting_usevotes'] = 'Povolit lajkování komentářů?';
$string['global_setting_usevotes_desc'] = 'Pomocí této možnosti mohou uživatelé lajkovat / hlasovat pro jiné než jejich vlastní příspěvky.';
$string['hiddenComment'] = 'skrytý komentář';
$string['hiddenforparticipants'] = 'Skryto před studenty';
$string['hideAnnotations'] = 'Skrýt poznámky';
$string['highlight'] = 'Zvýraznit text a přidat komentář.';
$string['hour'] = 'hodina';
$string['hours'] = 'hodiny';
$string['in_course'] = 'v tomto kurzu';
$string['in_document'] = 'v tomto dokumentu';
$string['infonocomments'] = 'Tento dokument v současné době neobsahuje žádné komentáře.';
$string['iscorrecthelpicon'] = 'Správně';
$string['iscorrecthelpicon_help'] = 'Když učitel nebo manažer označil odpověď jako správnou, objeví se vedle ní zelené zaškrtnutí.';
$string['itemsperpage'] = 'Položek na stránce';
$string['justnow'] = 'právě teď';
$string['lastanswered'] = 'Poslední odpověď';
$string['lastedited'] = 'naposledy upraveno';
$string['legacyfiles'] = 'Migrace starého souboru kurzu';
$string['legacyfilesactive'] = 'Aktivní';
$string['legacyfilesdone'] = 'Hotovo';
$string['like'] = 'líbí se';
$string['likeAnswer'] = 'užitečný';
$string['likeAnswerForbidden'] = 'již označeno jako užitečné';
$string['likeCountAnswer'] = 'lidé si myslí, že tato odpověď je užitečná';
$string['likeCountQuestion'] = 'lidé se o tuto otázku také zajímají';
$string['likeForbidden'] = 'Nemáte povoleno lajkovat tento komentář';
$string['likeOwnComment'] = 'vlastní komentář';
$string['likeQuestion'] = 'zajímavá otázka';
$string['likeQuestionForbidden'] = 'již označeno jako užitečné';
$string['loading'] = 'Načítání!';
$string['markCorrect'] = 'Označit jako správné';
$string['markSolved'] = 'Zavřít otázku';
$string['markUnsolved'] = 'Znovu otevřít otázku';
$string['markasread'] = 'Označit jako přečtené';
$string['markasunread'] = 'Označit jako nepřečtené';
$string['markhidden'] = 'Skrýt';
$string['maximumfilesize'] = 'Maximální velikost souboru';
$string['maximumfilesize_help'] = 'Soubory nahrané uživateli mohou mít až tuto velikost.';
$string['me'] = 'mé';
$string['messageforwardform'] = 'Vaše zpráva pro příjemce/příjemce';
$string['messageprovider:forwardedquestion'] = 'Když vám byl předán dotaz';
$string['messageprovider:newanswer'] = 'Když byla zodpovězena otázka, kterou jste odebírali';
$string['messageprovider:newquestion'] = 'Kdy byla položena nová otázka';
$string['messageprovider:newreport'] = 'Kdy byl nahlášen komentář';
$string['min0Chars'] = 'Prázdná otázka nebo komentář nejsou povoleny.';
$string['minute'] = 'minut';
$string['minutes'] = 'minut';
$string['missingAnnotation'] = 'Odpovídající anotace nebyla nalezena!';
$string['modifiedby'] = 'od';
$string['modulename'] = 'Anotace PDF';
$string['modulename_help'] = 'Tento nástroj umožňuje společné označování dokumentů PDF. Uživatelé mohou anotovat konkrétní části PDF a diskutovat o nich s ostatními uživateli.';
$string['modulename_link'] = 'mod/pdfannotator/view';
$string['modulenameplural'] = 'Anotace PDF';
$string['month'] = 'měsíc';
$string['months'] = 'měsíce';
$string['myanswers'] = 'Moje odpovědi';
$string['mypost'] = 'Můj příspěvek';
$string['myprivate'] = 'Moje osobní poznámky';
$string['myprotectedanswers'] = 'Moje soukromé odpovědi';
$string['myprotectedquestions'] = 'Moje soukromé otázky';
$string['mypublicanswers'] = 'Moje veřejné odpovědi';
$string['mypublicquestions'] = 'Moje veřejné otázky';
$string['myquestion'] = 'Otázka';
$string['myquestions'] = 'Moje otázky';
$string['newanswerhtml'] = 'Na vaši odebíranou otázku "{$a->question}" odpověděl {$a->answeruser} komentářem: <br /> <br /> "{$a->content}"<br /><br / > Odpověď je k dispozici <a href="{$a->urltoanswer}">zde</a>.';
$string['newanswertext'] = 'Na vaši odebíranou otázku „{$a->question}“ odpověděl {$a->answeruser} komentářem:

"{$a->content}"

Odpověď je dostupná pod: {$a->urltoanswer}';
$string['newquestionhtml'] = 'Uživatel {$a->answeruser} přidal nové otázky s obsahem: <br /> <br /> "{$a->content}"<br /><br />
Otázka je <a href="{$a->urltoanswer}">výše</a> dostupná.';
$string['newquestions'] = 'Nedávno se zeptal';
$string['newquestiontext'] = '{$a->answeruser} přidal nové otázky s obsahem:

"{$a->content}"

Otázka je dostupná pod: {$a->urltoanswer}';
$string['nextPage'] = 'Další strana';
$string['noCommentsupported'] = 'Tento druh anotace nepodporuje komentáře.';
$string['noanswers'] = 'V tomto kurzu momentálně nejsou žádné odpovědi.';
$string['noanswerssubscribed'] = 'V tomto kurzu momentálně nejsou žádné odpovědi na přihlášené otázky.';
$string['nomyposts'] = 'V tomto kurzu jste dosud nezveřejnili žádnou otázku ani odpověď.';
$string['noquestions'] = 'Na této stránce nejsou žádné otázky!';
$string['noquestions_overview'] = 'V tomto kurzu momentálně nejsou žádné otázky.';
$string['noquestions_view'] = 'V tomto dokumentu nejsou momentálně žádné otázky.';
$string['noquestionsclosed_overview'] = 'V tomto kurzu momentálně nejsou žádné uzavřené otázky.';
$string['noquestionsopen_overview'] = 'V tomto kurzu momentálně nejsou žádné otevřené otázky.';
$string['noreadreports'] = 'V tomto kurzu momentálně nejsou žádné zprávy o přečtení.';
$string['noreports'] = 'V současné době nejsou v tomto kurzu žádné zprávy.';
$string['nosearchresults'] = 'Nebyly nalezeny žádné výsledky vyhledávání.';
$string['notificationsubject:forwardedquestion'] = 'Přeposlaná otázka v {$a}';
$string['notificationsubject:newanswer'] = 'Nová odpověď na přihlášenou otázku v {$a}';
$string['notificationsubject:newquestion'] = 'Nová otázka v {$a}';
$string['notificationsubject:newreport'] = 'Komentář byl nahlášen v {$a}';
$string['nounreadreports'] = 'V tomto kurzu momentálně nejsou žádné nepřečtené zprávy.';
$string['on'] = 'na';
$string['onlyDeleteOwnAnnotations'] = ', protože patří jinému uživateli.';
$string['onlyDeleteUncommentedPosts'] = ', protože komentáře ostatních uživatelů by byly také smazány.';
$string['openquestions'] = 'nevyřešené';
$string['overview'] = 'Přehled';
$string['overviewactioncolumn'] = 'Spravovat';
$string['ownpoststab'] = 'Moje příspěvky';
$string['ownpoststabicon'] = 'Moje příspěvky';
$string['ownpoststabicon_help'] = 'Tato stránka zobrazuje všechny komentáře, které jste zveřejnili v tomto kurzu.';
$string['page'] = 'stránka';
$string['pdfButton'] = 'Dokument';
$string['pdfannotator'] = 'Dokument';
$string['pdfannotator:addinstance'] = 'přidat instanci';
$string['pdfannotator:administrateuserinput'] = 'Spravovat komentáře';
$string['pdfannotator:closeanyquestion'] = 'Zavřít jakoukoli otázku';
$string['pdfannotator:closequestion'] = 'Zavřít vlastní otázky';
$string['pdfannotator:create'] = 'Vytvořit poznámky a komentáře';
$string['pdfannotator:deleteany'] = 'Smazat všechny poznámky a komentáře';
$string['pdfannotator:deleteown'] = 'Smazat své vlastní poznámky a komentáře';
$string['pdfannotator:edit'] = 'Upravit své vlastní poznámky a komentáře';
$string['pdfannotator:editanypost'] = 'Upravit libovolnou poznámku a komentář';
$string['pdfannotator:forwardquestions'] = 'Přeposlat otázky';
$string['pdfannotator:getforwardedquestions'] = 'Přijímat přeposlané otázky';
$string['pdfannotator:hidecomments'] = 'Skrýt komentáře pro účastníky';
$string['pdfannotator:markcorrectanswer'] = 'Označit odpovědi jako správné';
$string['pdfannotator:printcomments'] = 'Stáhnout komentáře (i když je tato možnost pro anotátor PDF zakázána)';
$string['pdfannotator:printdocument'] = 'Stáhnout dokument (i když je tato možnost pro anotátor PDF zakázána)';
$string['pdfannotator:recievenewquestionnotifications'] = 'Dostávat upozornění na nové otázky';
$string['pdfannotator:report'] = 'Nahlásit nevhodné komentáře vedoucímu kurzu';
$string['pdfannotator:seehiddencomments'] = 'Zobrazit skryté komentáře';
$string['pdfannotator:subscribe'] = 'Přihlásit se k odběru otázky';
$string['pdfannotator:usedrawing'] = 'Použít kresbu (i když je tato možnost pro anotátor PDF zakázána)';
$string['pdfannotator:usetextbox'] = 'Použít textové pole (i když je tato možnost pro anotátor PDF zakázána)';
$string['pdfannotator:view'] = 'Zobrazit anotaci PDF';
$string['pdfannotator:viewanswers'] = 'Zobrazit odpovědi na přihlášené otázky (stránka s přehledem)';
$string['pdfannotator:viewposts'] = 'Zobrazit vlastní komentáře (stránka s přehledem)';
$string['pdfannotator:viewprotectedcomments'] = 'Zobrazit soukromé komentáře';
$string['pdfannotator:viewquestions'] = 'Zobrazit otevřené otázky (stránka s přehledem)';
$string['pdfannotator:viewreports'] = 'Zobrazit nahlášené komentáře (stránka s přehledem)';
$string['pdfannotator:viewstatistics'] = 'Zobrazit stránku statistik';
$string['pdfannotator:viewteacherstatistics'] = 'Další informace naleznete na stránce statistik';
$string['pdfannotator:vote'] = 'Hlasovat pro zajímavou otázku nebo užitečnou odpověď';
$string['pdfannotator:writeprivatecomments'] = 'Udělat si osobní poznámky';
$string['pdfannotator:writeprotectedcomments'] = 'Napsat soukromé komentáře';
$string['pdfannotatorcolumn'] = 'Dokument';
$string['pdfannotatorcontent'] = 'Soubory a podsložky';
$string['pdfannotatorname'] = 'Nástroj pro anotaci PDF';
$string['pdfannotatorpost'] = 'Komentáře a dotazy';
$string['pluginadministration'] = 'Správa anotací PDF';
$string['pluginname'] = 'Anotace PDF';
$string['point'] = 'Přidat špendlík do dokumentu a napište komentář.';
$string['prevPage'] = 'Předchozí stránka';
$string['print'] = 'stáhnout dokument';
$string['printButton'] = 'Stáhnout';
$string['printviewtitle'] = 'Komentáře';
$string['printwithannotations'] = 'stáhnout komentáře';
$string['privacy:metadata:core_files'] = 'Pdfannotator ukládá soubory, které uživatel nahrál, jako základ pro anotaci a diskusi.';
$string['privacy:metadata:pdfannotator_annotations'] = 'Informace o anotacích uživatele. To zahrnuje typ anotace (např. zvýraznění nebo kresba), její umístění v konkrétním souboru a také čas vytvoření.';
$string['privacy:metadata:pdfannotator_annotations:annotationid'] = 'ID anotace, která byla vytvořena. Odkazuje na údaje uvedené výše.';
$string['privacy:metadata:pdfannotator_annotations:userid'] = 'ID uživatele, který vytvořil tuto anotaci.';
$string['privacy:metadata:pdfannotator_comments'] = 'Informace o komentářích uživatele. To zahrnuje obsah a čas vytvoření komentáře a také podkladovou anotaci.';
$string['privacy:metadata:pdfannotator_comments:annotationid'] = 'ID podkladové anotace.';
$string['privacy:metadata:pdfannotator_comments:content'] = 'Doslovný komentář.';
$string['privacy:metadata:pdfannotator_comments:userid'] = 'ID autora komentáře.';
$string['privacy:metadata:pdfannotator_reports'] = 'Uživatelé mohou nahlásit komentáře ostatních uživatelů jako nevhodné. Tyto zprávy uloženy. To zahrnuje ID nahlášeného komentáře a také autora, obsah a čas zprávy.';
$string['privacy:metadata:pdfannotator_reports:commentid'] = 'ID nahlášeného komentáře.';
$string['privacy:metadata:pdfannotator_reports:message'] = 'Textový obsah zprávy.';
$string['privacy:metadata:pdfannotator_reports:userid'] = 'Autor zprávy.';
$string['privacy:metadata:pdfannotator_subscriptions'] = 'Informace o odběru jednotlivých otázek/diskuzí.';
$string['privacy:metadata:pdfannotator_subscriptions:annotationid'] = 'ID dotazu/diskuze, k jehož odběru jste se přihlásili.';
$string['privacy:metadata:pdfannotator_subscriptions:userid'] = 'ID uživatele s tímto předplatným.';
$string['privacy:metadata:pdfannotator_votes'] = 'Informace o otázkách a komentářích, které byly označeny jako zajímavé nebo užitečné.';
$string['privacy:metadata:pdfannotator_votes:commentid'] = 'ID komentáře.';
$string['privacy:metadata:pdfannotator_votes:userid'] = 'ID uživatele, který označil komentář jako zajímavý nebo užitečný. Ukládá se, aby uživatelé nemohli opakovaně hlasovat pro stejný komentář.';
$string['private_comments'] = 'Osobní poznámky';
$string['private_comments_help'] = 'Viditelné pouze pro vás.';
$string['protected_answers'] = 'Soukromé odpovědi';
$string['protected_comments'] = 'Soukromé komentáře';
$string['protected_comments_help'] = 'Viditelné pouze pro vás a učitele.';
$string['protected_questions'] = 'Soukromé otázky';
$string['public_comments'] = 'Veřejné komentáře';
$string['publicanswers'] = 'Veřejné odpovědi';
$string['publicquestions'] = 'Veřejné otázky';
$string['question'] = 'Otázka';
$string['questionSolved'] = 'Otázky jsou uzavřeny. Stále však můžete vytvářet nové komentáře.';
$string['questionsimgtitle'] = 'Zobrazit všechny otázky na této stránce';
$string['questionstab'] = 'Otázky';
$string['questionstabicon'] = 'Otázky';
$string['questionstabicon_help'] = 'Tato stránka zobrazuje všechny nevyřešené otázky, které byly položeny v tomto kurzu. Můžete si také vybrat, zda chcete zobrazit všechny nebo všechny vyřešené otázky v tomto kurzu.';
$string['questionstitle'] = 'Otázky na stránce';
$string['read'] = 'Číst';
$string['reason'] = 'Vysvětlení';
$string['recievenewquestionnotifications'] = 'Informovat o nových otázkách';
$string['recipient'] = 'Příjemce/i';
$string['recipient_help'] = 'Chcete-li vybrat několik osob, podržte "Ctrl"';
$string['recipientforwardform'] = 'Přeposlat';
$string['recipientrequired'] = 'Vyberte příjemce/příjemce';
$string['rectangle'] = 'Přidat do dokumentu obdélník a napište komentář.';
$string['removeCorrect'] = 'Odstranit označení jako správné';
$string['removehidden'] = 'Zobrazit';
$string['report'] = 'Zpráva';
$string['reportaddedhtml'] = '{$a->reportinguser} nahlásil(a) komentář se zprávou: <br /><br /> "{$a->introduction}"<br /><br />
Je <a href="{$a->urltoreport}">dostupný na webových stránkách</a>.';
$string['reportaddedtext'] = '{$a->reportinguser} nahlásil komentář se zprávou:

 "{$a->introduction}"

Je k dispozici pod: {$a->urloreport}';
$string['reportedby'] = 'od / dne';
$string['reportedcomment'] = 'Nahlášený komentář';
$string['reports'] = 'Nahlášené komentáře';
$string['reportsendbutton'] = 'Poslat';
$string['reportstab'] = 'Nahlášené komentáře';
$string['reportstabicon'] = 'Nahlášené komentáře';
$string['reportstabicon_help'] = 'Tato stránka zobrazuje komentáře, které byly v tomto kurzu nahlášeny jako nevhodné. Můžete si vybrat, zda chcete zobrazit pouze nepřečtené/přečtené* zprávy nebo všechny zprávy.<br>* Každý manažer tohoto kurzu může označit zprávu jako přečtenou.';
$string['reportwassentoff'] = 'Komentář byl nahlášen.';
$string['search'] = 'Vyhledat';
$string['searchresults'] = 'Výsledky vyhledávání';
$string['second'] = 'vteřina';
$string['seconds'] = 'Vteřiny';
$string['seenreports'] = 'pouze ke čtení';
$string['send'] = 'Poslat';
$string['sendAnonymous'] = 'zveřejnit anonymně';
$string['sendPrivate'] = 'zveřejnit osobní poznámku';
$string['sendProtected'] = 'zveřejnit soukromý komentář';
$string['setting_alternative_name'] = 'Název';
$string['setting_alternative_name_desc'] = 'Zadat alternativní název pro PDF. Pokud je prázdné, název pdf bude považován za reprezentativní název';
$string['setting_alternative_name_help'] = 'Je-li název delší než 20 znaků, budou zbývající znaky nahrazeny znakem „...“ ve vnitřní navigaci anotátoru.';
$string['setting_anonymous'] = 'Povolit anonymní příspěvky?';
$string['setting_fileupload'] = 'Vybrat soubor pdf';
$string['setting_fileupload_help'] = 'Vybraný soubor můžete změnit pouze do vytvoření anotátoru kliknutím na \'Uložit\'.';
$string['setting_use_private_comments'] = 'Povolit osobní poznámky';
$string['setting_use_private_comments_help'] = 'Povolit účastníkům psát osobní poznámky. Jiná osoba tento komentář nevidí.';
$string['setting_use_protected_comments'] = 'Povolit soukromé komentáře';
$string['setting_use_protected_comments_help'] = 'Povolit účastníkům psát soukromé komentáře. Tento komentář vidí pouze autor a učitelé.';
$string['setting_use_studentdrawing'] = 'Kreslení';
$string['setting_use_studentdrawing_help'] = 'Povolit účastníkům uložit a vytisknout dokument PDF bez anotací a komentářů';
$string['setting_use_studenttextbox'] = 'Textové pole';
$string['setting_use_studenttextbox_help'] = 'Upozorňujeme, že anotace textového pole nejsou anonymní a nelze je komentovat ani nahlásit.';
$string['setting_useprint'] = 'uložit a vytisknout';
$string['setting_useprint_comments'] = 'Uložit a vytisknout komentáře';
$string['setting_useprint_comments_help'] = 'Povolit účastníkům ukládat a tisknout anotace a komentáře';
$string['setting_useprint_document'] = 'Uložit a vytisknout dokument pdf';
$string['setting_useprint_document_help'] = 'Povolit účastníkům uložit a vytisknout dokument pdf';
$string['setting_useprint_help'] = 'Vezměte prosím na vědomí, že kresby nejsou anonymní a nelze je komentovat ani nahlásit.';
$string['setting_usevotes'] = 'Hlasy/Líbí se';
$string['setting_usevotes_help'] = 'Pokud je tato možnost povolena, uživatelé mohou lajkovat / hlasovat pro jiné než jejich vlastní příspěvky.';
$string['show'] = 'Zobrazit';
$string['showAnnotations'] = 'Zobrazit poznámky';
$string['showless'] = 'méně';
$string['showmore'] = 'více';
$string['slotdatetimelabel'] = 'Datum a čas';
$string['startDiscussion'] = 'Zahájit diskuzi';
$string['statistic'] = 'Statistika';
$string['strftimedatetime'] = '%d %b %Y, %I:%M %p';
$string['strikeout'] = 'Přeškrtnout text a přidat komentář.';
$string['studentdrawingforbidden'] = 'Tento anotátor pro vaši uživatelskou roli nepodporuje výkresy.';
$string['studenttextboxforbidden'] = 'Tento anotátor pro vaši uživatelskou roli nepodporuje textová pole.';
$string['subscribe'] = 'Přihlásit se k odběru těchto anotací';
$string['subscribeQuestion'] = 'Přihlásit se k odběru';
$string['subscribed'] = 'Odebíráno';
$string['subscribedanswers'] = 'na mé přihlášené otázky';
$string['subtitleforreportcommentform'] = 'Vaše zpráva pro manažera kurzu';
$string['successfullyEdited'] = 'Změny uloženy';
$string['successfullyHidden'] = 'Účastníci nyní vidí tento komentář jako skrytý.';
$string['successfullyRedisplayed'] = 'Komentář je pro účastníky znovu viditelný';
$string['successfullySubscribed'] = 'Přihlášen k odběru otázky.';
$string['successfullySubscribednotify'] = 'Vaše přihlášení k odběru otázky bylo zaregistrováno.';
$string['successfullyUnsubscribed'] = 'Vaše předplatné bylo zrušeno.';
$string['successfullyUnsubscribedPlural'] = 'Vaše předplatné bylo zrušeno. Všechny {$a} odpovědi na otázku byly odstraněny z této tabulky.';
$string['successfullyUnsubscribedSingular'] = 'Vaše přihlášení k odběru otázky bylo zrušeno a jediná odpověď odstraněna z této tabulky.';
$string['successfullyUnsubscribedTwo'] = 'Vaše předplatné bylo zrušeno. Obě odpovědi na otázku byly z této tabulky odstraněny.';
$string['successfullymarkedasread'] = 'Zpráva byla označena jako přečtená.';
$string['successfullymarkedasreadandnolongerdisplayed'] = 'Zpráva byla označena jako přečtená a odstraněna z tabulky.';
$string['successfullymarkedasunread'] = 'Zpráva byla označena jako nepřečtená.';
$string['successfullymarkedasunreadandnolongerdisplayed'] = 'Zpráva byla označena jako nepřečtená a odstraněna z tabulky.';
$string['sumPages'] = 'Počet stran';
$string['text'] = 'Přidat text do dokumentu.';
$string['titleforreportcommentform'] = 'Nahlásit komentář';
$string['titleforwardform'] = 'Přeposlat otázku';
$string['toreport'] = 'Zpráva';
$string['unseenreports'] = 'pouze nepřečtené';
$string['unsolvedquestionstitle'] = 'Nevyřešené otázky';
$string['unsolvedquestionstitle_help'] = 'Všechny nevyřešené otázky v tomto kurzu jsou uvedeny v seznamu.';
$string['unsubscribe'] = 'Odhlásit odběr těchto anotací';
$string['unsubscribeQuestion'] = 'Odhlásit odběr';
$string['unsubscribe_notification'] = 'Chcete-li zrušit odběr oznámení, klikněte prosím <a href="{$a}">sem</a>.';
$string['unsubscribingDidNotWork'] = 'Odběr se nepodařilo zrušit.';
$string['use_private_comments'] = 'Povolit účastníkům psát osobní poznámky?';
$string['use_protected_comments'] = 'Povolit účastníkům psát soukromé komentáře?';
$string['use_studentdrawing'] = 'Povolit účastníkům kreslení?';
$string['use_studenttextbox'] = 'Povolit účastníkům nástroj textového pole?';
$string['useprint'] = 'Poskytnout účastníkům přístup k PDF?';
$string['useprint_comments'] = 'Poskytnout účastníkům přístup k PDF a jeho komentářům?';
$string['useprint_document'] = 'Poskytnout účastníkům přístup k PDF?';
$string['usevotes'] = 'Povolit uživatelům lajkovat komentáře.';
$string['view'] = 'Dokument';
$string['votes'] = 'Líbí se';
$string['voteshelpicon'] = 'Líbí se';
$string['voteshelpicon_help'] = 'Tento sloupec vám řekne, kolik dalších lidí se o otázku zajímá.';
$string['voteshelpicontwo'] = 'Líbí se';
$string['voteshelpicontwo_help'] = 'Tento sloupec uvádí, jak často se vaše příspěvky <em>líbí</em>.';
$string['week'] = 'týden';
$string['weeks'] = 'týdnů';
$string['year'] = 'rok';
$string['years'] = 'let';
$string['yesButton'] = 'Ano';
$string['zoom'] = 'Zvětšit';
$string['zoomin'] = 'přiblížit';
$string['zoomout'] = 'oddálit';
