<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'cachestore_memcached', language 'cs', version '5.1'.
 *
 * @package     cachestore_memcached
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['bufferwrites'] = 'Vyrovnávací paměť (buffer) je zapisovatelná';
$string['bufferwrites_help'] = 'Aktivuje nebo deaktivuje I/O s vyrovnávací pamětí. Aktivování I/O s vyrovnávací pamětí způsobí, že příkazy budou ukládány do "vyrovnávací paměti" namísto toho, aby byly odeslány. Jakákoliv akce, která znovu získá data způsobí, že se tato vyrovnávací paměť odešle na vzdálené připojení. Ukončení nebo uzavření připojení také způsobí, že data uložena do vyrovnávací paměti budou posunuty na vzdálené připojení.';
$string['clustered'] = 'Povolit servery v clusteru';
$string['clustered_help'] = 'Používá se k povolení funkcionality - načíst z jednoho a nastavit na mnohé. Nastavení umožňuje zlepšit použití paměti pro konfigurace se stejnoměrným rozdělením výkonu. Paměť se vyvolá z jednoho serveru (obvykle localhost), ale nastaví na mnohé (všechny servery v úložišti se stejnoměrně rozděleným výkonem). Pro vyrovnávací paměti s velmi vysokými poměry čtení a nastavení šetří toto nastavení významný objem režie sítě. Když je toto nastavení aktivováno, server uveden jako první se bude používat k vyvolání.';
$string['clusteredheader'] = 'Rozdělit servery';
$string['hash'] = 'Hash metoda';
$string['hash_crc'] = 'CRC';
$string['hash_default'] = 'Výchozí (jeden po druhém)';
$string['hash_fnv1_32'] = 'FNV1_32';
$string['hash_fnv1_64'] = 'FNV1_64';
$string['hash_fnv1a_32'] = 'FNV1A_32';
$string['hash_fnv1a_64'] = 'FNV1A_64';
$string['hash_help'] = 'Specifikuje algoritmus transformace klíčů použitý pro klíče položky. Každý algoritmus má svoje výhody a nevýhody. Použijte standardní nastavení, jestli je neznáte nebo je toto nastavení pro vás irelevantní.';
$string['hash_hsieh'] = 'Hsieh';
$string['hash_md5'] = 'MD5';
$string['hash_murmur'] = 'Murmur';
$string['isshared'] = 'Sdílené vyrovnávací paměti';
$string['isshared_help'] = 'Je váš server s memcached používán také jinými aplikacemi?

Je-li vyrovnávací paměť sdílená jinými aplikacemi, pak každý klíč bude vymazán jednotlivě, aby se zajistilo, že se vyčistí pouze údaje vlastněné touto aplikací (výstupní externí data mezipaměti aplikace zůstane beze změny). To může mít za následek, v závislosti na konfiguraci serveru, snížení výkonu při uvolňování vyrovnávací paměti.

Pokud je spuštěna pro tuto aplikaci vyhrazená vyrovnávací paměť, pak může být celá vyrovnávací paměť bezpečně odstraněna bez jakéhokoliv rizika zničení dat mezipaměti ostatních aplikací. To by mělo vést ke zvýšení výkonu při uvolňování mezipaměti.';
$string['pluginname'] = 'Memcached';
$string['prefix'] = 'Předpona klíče';
$string['prefix_help'] = 'Tato volba se může použít k vytvoření "domény" pro klíče vaší položky, které vám umožní vytvořit více memcached uložení na jedné memcached instalaci. Nemůže být delší jako 16 znaků, aby bylo zajištěno, že se neobjaví problémy s délkou klíčů.';
$string['prefixinvalid'] = 'Neplatný prefix. Můžete použít pouze a-z A-Z 0-9-_.';
$string['privacy:metadata:memcached'] = 'Modul Memcached cachestore ukládá data krátce jako součást své funkce ukládání do mezipaměti. Tato data jsou uložena na serveru Memcache, kde jsou data pravidelně odstraňována.';
$string['privacy:metadata:memcached:data'] = 'Různá data uložená v mezipaměti';
$string['serialiser_igbinary'] = 'igbinary serializér';
$string['serialiser_json'] = 'JSON serializér';
$string['serialiser_php'] = 'Standardní PHP serializér';
$string['servers'] = 'Servery';
$string['servers_help'] = 'Tato možnost nastaví servery, které by měly být využívány tímto adaptérem memcache. Servery by měly být definovány po jednom na každý řádek a skládají se z adresy serveru a volitelně portu a váhy.
Není-li poskytnut žádný port, použije se standardní port (11211).

Například:

<pre>
server.url.com
ipaddress:port
servername:port:weight
</pre>

Když je níže aktivováno *Aktivovat sdružené servery*, na tomto místě musí být uveden pouze jeden server. Toto by obvykle měl být název, který se vždy vztahuje k lokálnímu počítači, např.127.0.0.1 nebo localhost.';
$string['serversclusterinvalid'] = 'Když je aktivováno sdružování (clustering), je požadován přesně jeden server.';
$string['sessionhandlerconflict'] = 'UPOZORNĚNÍ: Instance memcache ({$a}) byla konfigurována tak, aby používala stejný memcached server jako relace. Vyčištění všech vyrovnávacích pamětí povede k tomu, že se odstraní i relace.';
$string['setservers'] = 'Nastavit servery';
$string['setservers_help'] = 'Toto je seznam serverů, který se aktualizuje při modifikaci dat ve vyrovnávací paměti. Zpravidla plně kvalifikovaný název každého serveru v úložišti. **Musí** obsahovat server uvedený v *Serverech* výše, dokonce i když mají různé názvy hostitelů (hostname).
Servery by měly být definovány po jednom na každý řádek a skládají se z adresy serveru a volitelně portu.
Není-li poskytnut žádný port, použije se standardní port (11211).

Například:
<pre>
server.url.com
ipaddress:port
</pre>';
$string['testservers'] = 'Toto je seznam serverů, který se aktualizuje při modifikaci dat ve vyrovnávací paměti. Zpravidla plně kvalifikovaný název každého serveru v úložišti. **Musí** obsahovat server uvedený v *Serverech* výše, dokonce i když mají různé názvy hostitelů (hostname). Servery by měly být definovány po jednom na každý řádek a skládají se z adresy serveru a volitelně portu. Není-li poskytnut žádný port, použije se standardní port (11211). Například:: <pre> server.url.com ipaddress:port </pre>';
$string['testservers_desc'] = 'Jeden nebo více řetězců připojení pro memcache servery pro otestování. Byl-li specifikován testovací server, potom lze výkon memcache otestovat použitím stránky výkonu vyrovnávací paměti v bloku administrace.
Například: 127.0.0.1:11211';
$string['upgrade200recommended'] = 'Doporučujeme vám upgradovat Memcached rozšíření PHP verze 2.0.0 nebo vyšší.
Verze rozšíření Memcached PHP, který právě používáte neposkytuje funkčnost Moodle, používá k zajištění izolovanou mezipaměť. Do upgradu doporučujeme nekonfigurovat všechny ostatní aplikace používající stejné Memcached servery, jak je nakonfigurován Moodle.';
$string['usecompression'] = 'Použít kompresi';
$string['usecompression_help'] = 'Aktivuje nebo deaktivuje kompresi užitečného zatížení. Je-li tato možnost aktivována, hodnoty nad určitý limit (aktuálně 100 bytů) budou přehledně zkomprimovány během ukládání a dekomprimovány během obnovování.';
$string['useserialiser'] = 'Použít serializér';
$string['useserialiser_help'] = 'Specifikuje serializér, který bude použit na serializování neskalárních hodnot. Platné serializéry jsou Memcached::SERIALIZER_PHP nebo Memcached::SERIALIZER_IGBINARY.
Druhý je podporován pouze tehdy, když je spolu s ním nakonfigurován memcached - načte se možnost enable-memcached-igbinary a rozšíření igbinary.';
