<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'aiprovider_deepseek', language 'cs', version '5.1'.
 *
 * @package     aiprovider_deepseek
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action:explain_text:endpoint'] = 'Koncový bod API';
$string['action:explain_text:model'] = 'Model vysvětlení textu';
$string['action:explain_text:model_help'] = 'Model použitý k vysvětlení poskytnutého textu.';
$string['action:explain_text:systeminstruction'] = 'Systémový návod';
$string['action:explain_text:systeminstruction_help'] = 'Tento návod je odeslán do modelu umělé inteligence spolu s výzvou uživatele. Úprava tohoto návodu se nedoporučuje, pokud to není nezbytně nutné.';
$string['action:generate_text:endpoint'] = 'Koncový bod API';
$string['action:generate_text:model'] = 'Model AI';
$string['action:generate_text:model_help'] = 'Model použitý ke generování textové odpovědi.';
$string['action:generate_text:systeminstruction'] = 'Systémový návod';
$string['action:generate_text:systeminstruction_help'] = 'Tento návod je odeslán do modelu umělé inteligence spolu s výzvou uživatele. Úprava tohoto návodu se nedoporučuje, pokud to není nezbytně nutné.';
$string['action:summarise_text:endpoint'] = 'Koncový bod API';
$string['action:summarise_text:model'] = 'Model AI';
$string['action:summarise_text:model_help'] = 'Model použitý ke generování textové odpovědi.';
$string['action:summarise_text:systeminstruction'] = 'Systémový návod';
$string['action:summarise_text:systeminstruction_help'] = 'Tento návod je odeslán do modelu umělé inteligence spolu s výzvou uživatele. Úprava tohoto návodu se nedoporučuje, pokud to není nezbytně nutné.';
$string['apikey'] = 'Klíč API DeepSeek';
$string['apikey_help'] = 'Získejte klíč ze svých <a href="https://platform.deepseek.com/api_keys" target="_blank">klíčů DeepSeek API</a>.';
$string['custom_model_name'] = 'Název vlastního modelu';
$string['extraparams'] = 'Další parametry';
$string['extraparams_help'] = 'Zde lze nakonfigurovat další parametry. Podporujeme formát JSON. Například:
<pre>
 {
     "temperature": 0.5,
     "max_tokens": 100
}
 </pre>';
$string['invalidjson'] = 'Neplatný řetězec JSON';
$string['pluginname'] = 'Poskytovatel Deepseek API';
$string['privacy:metadata'] = 'Doplněk poskytovatele DeepSeek API neukládá žádné osobní údaje.';
$string['privacy:metadata:aiprovider_deepseek:externalpurpose'] = 'Tyto informace se odesílají do rozhraní Deepseek API za účelem vygenerování odpovědi. Nastavení vašeho účtu Deepseek může změnit způsob, jakým Deepseek tato data ukládá a uchovává. Tento plugin explicitně neodesílá do Deepseeku ani neukládá do systému Moodle LMS žádná uživatelská data.';
$string['privacy:metadata:aiprovider_deepseek:model'] = 'Model použitý ke generování odpovědi.';
$string['privacy:metadata:aiprovider_deepseek:prompttext'] = 'Uživatelem zadaný textový prompt použitý ke generování odpovědi.';
$string['settings'] = 'Nastavení';
$string['settings_frequency_penalty'] = 'frequency_penalty';
$string['settings_frequency_penalty_help'] = 'Číslo mezi -2,0 a 2,0. Kladné hodnoty penalizují nové tokeny na základě jejich dosavadní četnosti v textu, čímž snižují pravděpodobnost, že model doslovně zopakuje stejný řádek.';
$string['settings_help'] = 'Upravte níže uvedená nastavení a přizpůsobte si způsob odesílání požadavků do Deepseeku.';
$string['settings_logprobs'] = 'logprobs';
$string['settings_logprobs_help'] = 'Zda se mají vracet pravděpodobnosti protokolu výstupních tokenů, či nikoli. Pokud je hodnota true, vrací se pravděpodobnosti protokolu každého výstupního tokenu vráceného v obsahu zprávy.';
$string['settings_logprobs_label'] = 'Povolit';
$string['settings_max_tokens'] = 'max_tokens';
$string['settings_max_tokens_help'] = 'Celé číslo mezi 1 a 8192. Maximální počet tokenů, které lze vygenerovat při dokončení chatu. Celková délka vstupních tokenů a vygenerovaných tokenů je omezena délkou kontextu modelu. Pokud není zadána hodnota max_tokens, použije se výchozí hodnota 4096.';
$string['settings_presence_penalty'] = 'presence_penalty';
$string['settings_presence_penalty_help'] = 'Číslo mezi -2,0 a 2,0. Kladné hodnoty penalizují nové tokeny na základě toho, zda se doposud objevily v textu, čímž zvyšují pravděpodobnost, že model bude hovořit o nových tématech.';
$string['settings_temperature'] = 'teplota';
$string['settings_temperature_help'] = 'Vzorkovací teplota, kterou použít, mezi 0 a 2. Vyšší hodnoty, například 0,8, způsobí, že výstup bude náhodnější, zatímco nižší hodnoty, například 0,2, ho učiní více zaostřeným a deterministickým. Obecně doporučujeme změnit toto nebo top_p, ale ne obojí.';
$string['settings_top_logprobs'] = 'top_logprobs';
$string['settings_top_logprobs_help'] = 'Celé číslo mezi 0 a 20 určující počet tokenů s největší pravděpodobností vrácených na každé pozici tokenu, každý s přidruženou pravděpodobností logaritmu. Pokud je tento parametr použit, musí být logprobs nastaven na hodnotu true.';
$string['settings_top_p'] = 'top_p';
$string['settings_top_p_help'] = 'Alternativa k vzorkování s teplotou, nazývaná vzorkování jádra, kde model zohledňuje výsledky tokenů s pravděpodobnostní hmotností top_p. Hodnota 0,1 tedy znamená, že se berou v úvahu pouze tokeny tvořící horních 10 % pravděpodobnostní hmotnost. Obecně doporučujeme změnit toto nebo teplotu, ale ne obojí.';
