<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'search_solr', language 'da', version '5.1'.
 *
 * @package     search_solr
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['check_indextoobig'] = 'Indeks større end den angivne størrelse';
$string['check_nocore'] = 'Kan ikke finde indeks på Solr-serveren';
$string['check_nosize'] = 'Det er ikke muligt at bestemme indeksstørrelsen på Solr-serveren';
$string['check_notconnected'] = 'Kan ikke oprette forbindelse til Solr-serveren';
$string['check_time'] = 'Serveren svarede med status i {$a}';
$string['connectionerror'] = 'Den angivne Solr-server er ikke tilgængelig, eller den angivne indeks eksisterer ikke';
$string['connectionsettings'] = 'Forbindelsesindstillinger';
$string['errorcreatingschema'] = 'Fejl ved oprettelse af Solr-skemaet: {$a}';
$string['errorsolr'] = 'Solr søgemaskinen rapporterede en fejl: {$a}';
$string['errorvalidatingschema'] = 'Fejl ved validering af Solr-skema: felt {$a->fieldname} eksisterer ikke. Venligst <a href="{$a->setupurl}">følg dette link</a> for at opsætte de nødvendige felter.';
$string['extensionerror'] = 'Apache Solr PHP-udvidelsen er ikke installeret. Venligst tjek dokumentationen.';
$string['fileindexing'] = 'Aktiver filindeksering';
$string['fileindexing_help'] = 'If your Solr install supports it, this feature allows Moodle to send files to be indexed.<br/>
You will need to reindex all site contents after enabling this option for all files to be added.';
$string['fileindexsettings'] = 'Indstillinger for filindeksering';
$string['indexsize'] = 'Indekset bruger {$a} på Solr-serveren.';
$string['indexsizelimit'] = 'Grænse for indeksstørrelse';
$string['indexsizelimit_desc'] = 'Viser en fejl på statusrapportsiden, hvis søgeindekset vokser sig større end denne størrelse (i bytes), og en advarsel, hvis det overstiger 90 %. Indstil til nul for ingen indeksstørrelsesgrænse.';
$string['maxindexfilekb'] = 'Maksimal filstørrelse til indeksering (kB)';
$string['maxindexfilekb_help'] = 'Filer, der er større end dette antal kilobyte, vil ikke blive inkluderet i søgeindeksering. Hvis det er indstillet til nul, vil filer af enhver størrelse blive indekseret.';
$string['minimumsolr4'] = 'Solr 4.0 er den minimale version, der kræves for Moodle';
$string['missingconfig'] = 'Din Apache Solr-server er endnu ikke konfigureret i Moodle.';
$string['multivaluedfield'] = 'Feltet "{$a}" returnerede et array i stedet for en skalar. Venligst slet den nuværende indeks, opret en ny og kør setup_schema.php før indeksering af data i Solr.';
$string['nodatafromserver'] = 'Ingen data fra serveren';
$string['pluginname'] = 'Solr';
$string['privacy:metadata'] = 'Denne plugin sender data eksternt til en tilknyttet Solr søgemaskine. Den gemmer ikke data lokalt.';
$string['privacy:metadata:data'] = 'Personlige data overført fra søgesubsystemet.';
$string['schemafieldautocreated'] = 'Feltet "{$a}" eksisterer allerede i Solr-skemaet. Du har sandsynligvis glemt at køre dette script før indeksering af data, og felterne blev automatisk oprettet af Solr. Venligst slet den nuværende indeks, opret en ny og kør setup_schema.php igen før indeksering af data i Solr.';
$string['schemasetupfromsolr5'] = 'Din Solr-server version er lavere end 5.0. Dette script kan kun indstille dit skema, hvis din Solr-version er 5.0 eller højere. Du skal manuelt indstille felterne i dit skema i henhold til \\search_solr\\document::get_default_fields_definition().';
$string['searchinfo'] = 'Søgeforespørgsler';
$string['searchinfo_help'] = 'The field to be searched may be specified by prefixing the search query with \'title:\', \'content:\', \'name:\', or \'intro:\'. For example, searching for \'title:news\' would return results with the word \'news\' in the title.

Boolean operators (\'AND\', \'OR\', \'NOT\') may be used to combine or exclude keywords.

Wildcard characters (\'*\' or \'?\' ) may be used to represent characters in the search query.';
$string['setupok'] = 'Skemaet er klar til at blive brugt.';
$string['solrauthpassword'] = 'HTTP godkendelsesadgangskode';
$string['solrauthuser'] = 'HTTP autentificering brugernavn';
$string['solrhttpconnectionport'] = 'Port';
$string['solrhttpconnectiontimeout'] = 'Timeout';
$string['solrhttpconnectiontimeout_desc'] = 'HTTP-forbindelsestidsgrænsen er den maksimale tid i sekunder, der er tilladt for HTTP-datatansferoperationen.';
$string['solrindexname'] = 'Indeksnavn';
$string['solrinfo'] = 'Solr';
$string['solrnotselected'] = 'Solr-motoren er ikke den konfigurerede søgemaskine';
$string['solrsecuremode'] = 'Sikker tilstand';
$string['solrserverhostname'] = 'Værtsnavn';
$string['solrserverhostname_desc'] = 'Domænenavn på Solr-serveren.';
$string['solrsetting'] = 'Solr indstillinger';
$string['solrsslcainfo'] = 'SSL CA certifikatnavn';
$string['solrsslcainfo_desc'] = 'Filnavn der indeholder et eller flere CA-certifikater til at verificere peer med';
$string['solrsslcapath'] = 'SSL CA certifikatsti';
$string['solrsslcapath_desc'] = 'Sti til mappe med flere CA-certifikater til at verificere peer med';
$string['solrsslcert'] = 'SSL certifikat';
$string['solrsslcert_desc'] = 'Filnavn til et PEM-formateret privat certifikat';
$string['solrsslkey'] = 'SSL nøgle';
$string['solrsslkey_desc'] = 'Filnavn til en PEM-formateret privat nøgle';
$string['solrsslkeypassword'] = 'SSL nøgleadgangskode';
$string['solrsslkeypassword_desc'] = 'Adgangskode til PEM-formateret privat nøglefil';
