<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'question', language 'da', version '5.1'.
 *
 * @package     question
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Handling';
$string['addanotherhint'] = 'Tilføj et hint mere';
$string['addcategory'] = 'Tilføj kategori';
$string['addmorechoiceblanks'] = 'Felter til {no} ekstra valgmuligheder';
$string['adminreport'] = 'Rapport om eventuelle problemer i din spørgsmålsdatabase.';
$string['advancedsearchoptions'] = 'Søgemuligheder';
$string['alltries'] = 'Alle forsøg';
$string['alwayslatest'] = 'Altid seneste';
$string['answer'] = 'Svar';
$string['answers'] = 'Svar';
$string['answersaved'] = 'Besvaret';
$string['answerx'] = 'Svar {$a}';
$string['attemptfinished'] = 'Besvarelse afsluttet';
$string['attemptfinishedsubmitting'] = 'Besvarelse afsluttet, indsender: {$a}';
$string['attemptoptions'] = 'Valgmuligheder for besvarelse';
$string['availableq'] = 'Tilgængelig?';
$string['badbase'] = 'Dårligt udgangspunkt før **: {$a}**';
$string['banksincourse'] = 'Spørgsmålsbanker i dette kursus';
$string['behaviour'] = 'Opførsel';
$string['behaviourbeingused'] = 'Anvendt opførsel: {$a}';
$string['broken'] = 'Linket virker ikke, det peger på en fil, der ikke eksisterer.';
$string['byandon'] = 'af <em>{$a->user}</em> <em>{$a->time}</em>';
$string['cannotcopybackup'] = 'Kunne ikke kopiere backup-filen';
$string['cannotcreate'] = 'Kunne ikke oprette ny post i tabellen question_attempts';
$string['cannotcreatepath'] = 'Kan ikke oprette stien: {$a}';
$string['cannotdeletebehaviourinuse'] = 'Du kan ikke slette opførslen "{$a}". Den bruges af spørgsmålsbesvarelser.';
$string['cannotdeletecate'] = 'Du kan ikke slette den kategori, det er standardkategorien i denne kontekst.';
$string['cannotdeleteneededbehaviour'] = 'Kan ikke slette spørgsmålstypen "{$a}". Der er andre installerede opførsler, der beror på den.';
$string['cannotdeleteqtypeinuse'] = 'Du kan ikke slette spørgsmålstypen "{$a}". Der er spørgsmål af denne type i spørgsmålsbanken.';
$string['cannotdeleteqtypeneeded'] = 'Du kan ikke slette spørgsmålstypen "{$a}". Der er andre spørgsmål, der beror på den';
$string['cannotdeletetopcat'] = 'Topkategorier kan ikke slettes.';
$string['cannotedittopcat'] = 'Topkategorier kan ikke redigeres.';
$string['cannotenable'] = 'Spørgsmålstypen {$a} kan ikke oprettes direkte.';
$string['cannotenablebehaviour'] = 'Spørgsmålsopførsel {$a} kan ikke bruges direkte. Den er kun til intern brug.';
$string['cannotfindcate'] = 'Kunne ikke finde kategoriposten';
$string['cannotfindquestionfile'] = 'Kunne ikke finde spørgsmåls-data-fil i zip-pakken';
$string['cannotgetdsfordependent'] = 'Fandt ikke det angivne datasæt til et datasætafhængigt spørgsmål! (spørgsmål: {$a->id}, datasæt: {$a->item})';
$string['cannotgetdsforquestion'] = 'Fandt ikke det angivne datasæt til et beregnet spørgsmål!  (spørgsmål: {$a})';
$string['cannothidequestion'] = 'Det lykkedes ikke at skjule spørgsmålet.';
$string['cannotimportformat'] = 'Beklager, import af dette format er endnu ikke implementeret!';
$string['cannotinsertquestion'] = 'Det lykkedes ikke at indsætte et nyt spørgsmål.';
$string['cannotinsertquestioncatecontext'] = 'Kunne ikke indsætte den nye spørgsmålskategori {$a->cat}, ugyldig kontekst-id {$a->ctx}';
$string['cannotloadquestion'] = 'Kunne ikke indlæse spørgsmålet';
$string['cannotmovequestion'] = 'Du kan ikke bruge dette script til at flytte spørgsmål, der er filer i associeret med dem fra forskellige områder.';
$string['cannotopenforwriting'] = 'Kan ikke åbne for redigering: {$a}';
$string['cannotpreview'] = 'Du kan ikke prøvese disse spørgsmål!';
$string['cannotread'] = 'Kan ikke læse importfilen (eller filen er tom)';
$string['cannotregradedifferentqtype'] = 'Kan ikke genvurdere med et spørgsmål af en anden type.';
$string['cannotretrieveqcat'] = 'Kunne ikke hente spørgsmålskategori';
$string['cannotunhidequestion'] = 'Mislykkedes at vise spørgsmål.';
$string['cannotunzip'] = 'Kunne ikke udpakke filen.';
$string['cannotwriteto'] = 'Kan ikke skrive eksporterede spørgsmål til {$a}';
$string['categories'] = 'Kategorier';
$string['category'] = 'Kategori';
$string['categorycurrent'] = 'Denne kategori';
$string['categorycurrentuse'] = 'Anvend denne kategori';
$string['categorydoesnotexist'] = 'Denne kategori eksisterer ikke';
$string['categoryinfo'] = 'Kategori-info';
$string['categorymove'] = 'Kategorien "{$a->name}" indeholder {$a->count} spørgsmål (hvoraf nogle kan være  gamle eller skjulte, som stadig er i brug i en quiz). Vælg en anden kategori at flytte dem til.';
$string['categorymoveto'] = 'Gem i kategorien';
$string['categorynamecantbeblank'] = 'Kategorinavn skal udfyldes.';
$string['categorynamewithcount'] = '{$a->name} ({$a->questioncount})';
$string['categorynamewithidnumber'] = '{$a->name} [{$a->idnumber}]';
$string['categorynamewithidnumberandcount'] = '{$a->name} [{$a->idnumber}] ({$a->questioncount})';
$string['changeoptions'] = 'Skift indstillinger';
$string['changepublishstatuscat'] = '<a href="{$a->caturl}">Kategorien "{$a->name}"</a> på kurset "{$a->coursename}" får sin delt-status ændret fra {$a->changefrom} til {$a->changeto}.';
$string['check'] = 'Tjek';
$string['chooseqtypetoadd'] = 'Vælg en spørgsmålstype at tilføje';
$string['clearwrongparts'] = 'Slet forkerte svar';
$string['clickflag'] = 'Marker spørgsmål';
$string['clicktoflag'] = 'Marker dette spørgsmål til fremtidig reference';
$string['clicktounflag'] = 'Fjern markering';
$string['clickunflag'] = 'Fjern markering';
$string['closepreview'] = 'Luk forhåndsvisning';
$string['combinedfeedback'] = 'Samlet feedback';
$string['comment'] = 'Kommentar';
$string['commented'] = 'Kommenteret: {$a}';
$string['commentormark'] = 'Kommenter eller overskriv point';
$string['comments'] = 'Kommentarer';
$string['commentx'] = 'Kommentar: {$a}';
$string['complete'] = 'Gennemført';
$string['contexterror'] = 'Du skulle ikke være kommer hertil, hvis ikke du flytter en kategori til en anden kontekst.';
$string['copy'] = 'Kopier fra {$a} og ret links.';
$string['correct'] = 'Rigtigt';
$string['correctfeedback'] = 'For hvert rigtigt svar';
$string['correctfeedbackdefault'] = 'Dit svar er rigtigt.';
$string['courserestore'] = 'Gendan kursus.';
$string['created'] = 'Oprettet';
$string['createdby'] = 'Oprettet af';
$string['createdefault'] = 'Opret standardspørgsmålsbank';
$string['createdmodifiedheader'] = 'Oprettet/sidst ændret';
$string['createnewquestion'] = 'Opret et nyt spørgsmål...';
$string['cwrqpfs'] = 'Tilfældige spørgsmål vælger spørgsmål fra underkategorier.';
$string['cwrqpfsinfo'] = '<p>Under opgradering til Moodle 1.9 vil vi opdele spørgsmålskategorierne i forskellige kontekster. Nogle spørgsmålskategorier på dit site vil få deres status ændret for hvordan/om de må deles. Dette er nødvendigt i de sjældne tilfælde hvor et eller flere "tilfældige" spørgsmål i en quiz er sat op til at vælge fra et mix af delte og ikke delte kategorier (som på dette site). Dette sker når et tilfældigt spørgsmål skal vælge fra underkategorier og et eller flere underkategorier har forskellige delingsstatus i forhold til den overordnede kategori hvori det tilfældige spørgsmål er oprettet.</p>
<p>De følgende spørgsmålskategorier, hvorfra tilfældige spørgsmål i overordnede kategorier vælger spørgsmål, vil få deres delingsstatus ændret til det samme som kategorien med det tilfældige spørgsmål i under opgraderingen til Moodle 1.9. De følgende kategorier vil få deres delingsstatus ændret. Spørgsmål som påvirkes vil fortsætte med at virke i alle eksisterende quizzer indtil du fjerner dem fra disse quizzer.</p>';
$string['cwrqpfsnoprob'] = 'Ingen spørgsmålskategorier på dit site berøres af "Tilfældige spørgsmål vælger spørgsmål fra underkategorier".';
$string['decimalplacesingrades'] = 'Decimaler i karakterer';
$string['defaultbank'] = '{$a->coursename} kursusspørgsmålsbank';
$string['defaultcreated'] = 'Standardspørgsmålsbank oprettet';
$string['defaultfor'] = 'Standard for {$a}';
$string['defaultinfofor'] = 'Standardkategorien for delte spørgsmål i konteksten "{$a}".';
$string['defaultmark'] = 'Standardpoint';
$string['defaultmarkmustbepositive'] = 'Standardkarakteren skal være positiv';
$string['deletecoursecategorywithquestions'] = 'Der er spørgsmål i spørgsmålsbanken, som er associeret med denne kursuskategori. Fortsætter du, bliver de slettet. Du kan gå ind i spørgsmålsbanken og flytte dem først.';
$string['deletequestioncheck'] = 'Dette vil slette det følgende spørgsmål og alle dets versioner:<br /><br />{$a}';
$string['deletequestionscheck'] = 'Dette vil slette følgende spørgsmål og alle deres versioner<br /><br />{$a}';
$string['deletequestiontitle'] = 'Slet spørgsmål?';
$string['deletequestiontitle_plural'] = 'Slet spørgsmål?';
$string['deleteselectedquestioncheck'] = 'Dette vil slette de valgte versioner af følgende spørgsmål:<br /><br />{$a}';
$string['deleteversiontitle'] = 'Slet valgte version?';
$string['deleteversiontitle_plural'] = 'Slet valgte versioner?';
$string['deletingbehaviour'] = 'Sletter spørgsmålsopførsel "{$a}"';
$string['deletingqtype'] = 'Sletter spørgsmålstypen "{$a}"';
$string['didnotmatchanyanswer'] = '[Passede ikke med noget svar]';
$string['disabled'] = 'Deaktiveret';
$string['disabledbanks'] = 'Alle spørgsmålsbankmodultyper er deaktiveret';
$string['displayoptions'] = 'Vis indstillinger';
$string['disterror'] = 'Distributionen {$a} gav problemer';
$string['donothing'] = 'Kopier eller flyt ikke filer eller lav ændringer i links.';
$string['editcategories'] = 'Rediger kategorier';
$string['editcategories_help'] = 'I stedet for at holde alt på én stor liste, kan spørgsmål arrangeres i kategorier og underkategorier.

Kategorier bruges også til tilfældige spørgsmål, da spørgsmål vælges fra en bestemt kategori.';
$string['editcategories_link'] = 'question/category';
$string['editcategory'] = 'Rediger kategori';
$string['editingcategory'] = 'Rediger en kategori';
$string['editingquestion'] = 'Redigerer et spørgsmål';
$string['editquestion'] = 'Rediger spørgsmål';
$string['editquestions'] = 'Rediger spørgsmål';
$string['editthiscategory'] = 'Rediger denne kategori';
$string['emptyxml'] = 'Ukendt fejl - tomt imsmanifest.xml';
$string['enabled'] = 'Aktiveret';
$string['erroraccessingcontext'] = 'Kan ikke tilgå konsteksten';
$string['errordeletingquestionsfromcategory'] = 'Fejl ved sletning af spørgsmål fra kategorien {$a}.';
$string['errorduringpost'] = 'Fejl i efterbehandling!';
$string['errorduringpre'] = 'Fejl i forbehandling!';
$string['errorduringproc'] = 'Fejl under behandling!';
$string['errorduringregrade'] = 'Kunne ikke bedømme spøgsmål {$a->qid} igen, går til tilstanden {$a->stateid}.';
$string['errorfilecannotbecopied'] = 'Fejl, kan ikke kopiere filen {$a}.';
$string['errorfilecannotbemoved'] = 'Fejl, kan ikke flytte filen {$a}.';
$string['errorfileschanged'] = 'Fejl: Filer der er linket til fra spørgsmål er ændret siden formularen blev indlæst.';
$string['erroritemappearsmorethanoncewithdifferentweight'] = 'Spørgsmålet ({$a}) forekommer mere end en gang med forskellig vægtning forskellige steder i teksten. Dette understøttes i øjeblikket ikke af statistikrapporten og kan gøre statistik over dette spørgsmål upålidelig.';
$string['errormanualgradeoutofrange'] = 'Karakteren {$a->grade} er ikke mellem 0 og {$a->maxgrade} for spørgsmålet {$a->name}. Scoren og kommentaren blev ikke gemt.';
$string['errormovingquestions'] = 'Fejl under flytning af spørgsmål med id\'er {$a}.';
$string['errorpostprocess'] = 'Der opstod en fejl under efterbehandlingen!';
$string['errorpreprocess'] = 'Der opstod en fejl under forbehandlingen!';
$string['errorprocess'] = 'Der opstod en fejl under behandlingen!';
$string['errorprocessingresponses'] = 'En fejl opstod under behandling af din respons ({$a}). Klik fortsæt for at returnere til siden du kom fra, og forsøg igen.';
$string['errorsavingcomment'] = 'En fejl opstod under forsøg på at gemme spørgsmålet {$a->name} i databasen.';
$string['errorsavingflags'] = 'En fejl opstod under forsøg på at gemme markeringstilstanden.';
$string['errorupdatingattempt'] = 'Der opstod en fejl ved opdatering af {$a->id} i databasen.';
$string['eventqbankdisabled'] = 'Spørgsmålsbank plugin deaktiveret';
$string['eventqbankenabled'] = 'Spørgsmålsbank plugin aktiveret';
$string['eventquestioncategorycreated'] = 'Spørgsmålskategori oprettet';
$string['eventquestioncategorydeleted'] = 'Spørgsmålskategorien er slettet';
$string['eventquestioncategorymoved'] = 'Spørgsmålskategorien er flyttet';
$string['eventquestioncategoryupdated'] = 'Spørgsmålskategorien er opdateret';
$string['eventquestioncategoryviewed'] = 'Spørgsmålskategorien er set';
$string['eventquestioncreated'] = 'Spørgsmålet er oprettet';
$string['eventquestiondeleted'] = 'Spørgsmålet er slettet';
$string['eventquestionmoved'] = 'Spørgsmålet er flyttet';
$string['eventquestionsexported'] = 'Spørgsmålene er eksporteret';
$string['eventquestionsimported'] = 'Spørgsmålene er importeret';
$string['eventquestionupdated'] = 'Spørgsmålet er opdateret';
$string['eventquestionviewed'] = 'Spørgsmålet er set';
$string['export'] = 'Eksporter';
$string['exportasxml'] = 'Eksporter som Moodle XML';
$string['exportcategory'] = 'Eksporter kategori';
$string['exportcategory_help'] = 'Her styres fra hvilken kategori de eksporterede spørgsmål skal tages.

Visse formater som f.eks. GIFT og Moodle XML, kan indeholde kategori- og kontekstdata i eksportfilen som kan genskabes ved import (valgfrit). Om nødvendigt skal de relevante felter markeres.';
$string['exporterror'] = 'Der opstod en fejl under eksporten!';
$string['exportfilename'] = 'spørgsmål';
$string['exportnameformat'] = '%Y%m%d-%H%M';
$string['exportonequestion'] = 'Download dette spørgsmål i formatet Moodle XML';
$string['exportquestions'] = 'Eksporter spørgsmål til en fil';
$string['exportquestions_help'] = 'Denne funktion gør det muligt at eksportere alle spørgsmål fra en kategori (og underkategorier) til en fil. Bemærk at afhængig af det valgte format, kan nogle spørgsmål og visse oplysninger fra spørgsmålstyper ikke eksporteres.';
$string['exportquestions_link'] = 'question/export';
$string['feedback'] = 'Feedback';
$string['fieldinquestion'] = '{$a->fieldname} {$a->questionindentifier}';
$string['fieldinquestionpre'] = '{$a->questionindentifier} {$a->fieldname}';
$string['filecantmovefrom'] = 'Spørgsmålsfilerne kan ikke flyttes, da du ikke har tilladelse til at fjerne filer fra det sted, du forsøger at flytte spørgsmål fra.';
$string['filecantmoveto'] = 'Spørgsmålsfilerne kan ikke flyttes eller kopieres, da du ikke har tilladelse til at føje filer til det sted, du forsøger at flytte dem til.';
$string['fileformat'] = 'Filformat';
$string['filesareacourse'] = 'kursusfilområdet';
$string['filesareasite'] = 'sitefilområdet';
$string['filestomove'] = 'Flyt/kopier filer til {$a}?';
$string['fillincorrect'] = 'Vis de rigtige svar';
$string['filterbytags'] = 'Filtrer efter tags...';
$string['firsttry'] = 'Første forsøg';
$string['flagged'] = 'Markeret';
$string['flagthisquestion'] = 'Marker dette spørgsmål';
$string['formquestionnotinids'] = 'Formularen indeholdt et spørgsmål, der ikke er i spørgsmåls-id\'er';
$string['fractionsnomax'] = 'Et af svarene skal have en score på 100%.';
$string['generalfeedback'] = 'Generel feedback';
$string['generalfeedback_help'] = 'Generel feedback vises til de studerende efter spørgsmålet er afleveret. I modsætning til specifik feedback, der bygger på spørgsmålstypen og den studerendes svar, gives den generelle feedback til alle studerende.

Du kan bruge den generelle feedback til at give et tilbundsgående svar og måske link til yderligere information de kan læse, hvis ikke de forstod spørgsmålene.';
$string['getcategoryfromfile'] = 'Hent kategorien fra filen';
$string['getcontextfromfile'] = 'Hent konteksten fra filen';
$string['hintn'] = 'Hint {no}';
$string['hintnoptions'] = 'Hint {no} muligheder';
$string['hinttext'] = 'Hint-text';
$string['howquestionsbehave'] = 'Spørgsmålenes \'opførsel\'';
$string['howquestionsbehave_help'] = 'De studerende kan interagere med spørgsmålene i quizzen på flere forskellige måder. Du kan for eksempel lade de studerende svare på alle spørgsmål og aflevere alle svar inden spørgsmålene vurderes og inden der vises feedback. Det gøres med tilstanden \'Udskudt feedback\'.

Alternativt kan du vælge at feedbacken skal komme umiddelbart efter hvert afgivet svar, og, hvis ikke det er rigtigt i første forsøg, lade dem få et forsøg mere mod færre point. Det gøres med tilstanden \'Interaktiv med flere forsøg\'.

Dette er nok de to mest benyttede former for \'spørgsmålsadfærd\'.';
$string['howquestionsbehave_link'] = 'question/behaviour';
$string['idnumber'] = 'Id-nummer';
$string['idnumber_help'] = 'Er id-nummer i brug, skal det være unikt indenfor hver spørgsmålskategori. Det giver en anden måde at identificere et spørgsmål på der sommetider kan være en fordel, men feltet kan som regel efterlades tomt.';
$string['ignorebroken'] = 'Ignorer defekte links';
$string['import'] = 'Importer';
$string['importcategory'] = 'Importer til kategorien';
$string['importcategory_help'] = 'Indstillingen styrer hvilken kategori importerede spørgsmål skal placeres i.

Visse formater som f.eks. GIFT og Moodle-XML, kan indeholde kategori- og kontekstdata i importfilen. Skal disse data bruges i stedet for den valgte kategori, skal de relevante felter markeres. Findes importfilens kategorier ikke i forvejen, vil de blive oprettet.';
$string['importerror'] = 'Der opstod en fejl under forsøg på at behandle importen';
$string['importerrorquestion'] = 'Fejl i import af spørgsmål';
$string['importfromcoursefiles'] = '... eller vælg en kursusfil at importere.';
$string['importfromupload'] = 'Vælg en fil at uploade...';
$string['importingquestions'] = 'Importerer {$a} spørgsmål fra fil';
$string['importparseerror'] = 'Fejl fundet under gennemlæsning af importfilen. Der er ikke importeret nogen spørgsmål. For at importere et gyldigt spørgsmål, kan du prøve igen og ændre \'Stop ved fejl\' til \'Nej\'';
$string['importquestions'] = 'Importer spørgsmål fra en fil';
$string['importquestions_help'] = 'Med denne funktion kan spørgsmål importeres fra forskellige formater via en tekstfil. Bemærk at filen skal være UTF-8-kodet.';
$string['importquestions_link'] = 'question/import';
$string['importwrongfileencoding'] = 'Den fil, du valgte, bruger ikke UTF-8 tegnkodning. {$a} filer skal bruge UTF-8.';
$string['importwrongfiletype'] = 'Den filtype, du har valgt ({$a->actualtype}), passer ikke til den type, der forventes af dette importformat ({$a->expectedtype}).';
$string['impossiblechar'] = 'Umuligt tegn {$a} fundet som parentestegn';
$string['includesubcategories'] = 'Vis også spørgsmål fra underkategorier';
$string['incorrect'] = 'Forkert';
$string['incorrectfeedback'] = 'For hvert forkert svar';
$string['incorrectfeedbackdefault'] = 'Dit svar er forkert.';
$string['information'] = 'Information';
$string['invalidanswer'] = 'Ufuldstændigt svar';
$string['invalidarg'] = 'Ingen gyldige argumenter leveret eller ukorrekt serverkonfiguration';
$string['invalidcategoryidforparent'] = 'Ugyldig id for overliggende kategori!';
$string['invalidcategoryidtomove'] = 'Ugyldig kategori-id at flytte!';
$string['invalidconfirm'] = 'Bekræftelsesstrengen var ikke korrekt';
$string['invalidcontextinhasanyquestions'] = 'Ugyldig kontekst overgået til question_context_has_any_questions.';
$string['invalidgrade'] = 'Karaktererne ({$a}) passer ikke til karaktermulighederne - spørgsmål sprunget over.';
$string['invalidgradequestion'] = 'Karakterer ({$a->grades}) matcher ikke karakterindstillingerne - spørgsmål \'{$a->question}\' udeladt.';
$string['invalidpenalty'] = 'Ugyldig straf';
$string['invalidquestiontype'] = 'Ugyldig spørgsmålstype: {$a}';
$string['invalidwizardpage'] = 'Ukorrekt eller ingen guide specificeret!';
$string['lastmodifiedby'] = 'Senest ændret af';
$string['lasttry'] = 'Seneste forsøg';
$string['linkedfiledoesntexist'] = 'Den linkede fil {$a} eksisterer ikke';
$string['makechildof'] = 'Opret underkategori til "{$a}"';
$string['makecopy'] = 'Gem en kopi';
$string['maketoplevelitem'] = 'Flyt til øverste niveau';
$string['manualgradeinvalidformat'] = 'Dette er ikke et gyldigt nummer.';
$string['manualgradeoutofrange'] = 'Denne karakter ligger uden for det gældende område.';
$string['manuallygraded'] = 'Manuelt bedømt til {$a->mark}, kommentar: {$a->comment}';
$string['mark'] = 'Point';
$string['markedoutof'] = 'Vægt';
$string['markedoutofmax'] = 'Vægter med {$a}';
$string['markoutofmax'] = '{$a->mark} point ud af {$a->max}';
$string['marks'] = 'Point';
$string['matchgrades'] = 'Match karakterer';
$string['matchgrades_help'] = 'Importerede karakterer skal matche en af de gyldige faste karakterer - 100, 90, 80, 75, 70, 66,666, 60, 50, 40, 33,333, 30, 25, 20, 16,666, 14,2857, 12,5, 11,111, 10, 5 , 0 (også negative værdier). Hvis ikke, er der to muligheder:

* Fejl hvis karakteren ikke er opført - Hvis et spørgsmål indeholder karakterer der ikke findes på listen vises en fejl, og spørgsmålet vil ikke blive importeret
* Nærmeste ikke opførte karakter - Hvis en karakter er fundet, der ikke matcher en værdi på listen, ændres karakteren til nærmeste værdi på listen';
$string['matchgradeserror'] = 'Fejl hvis karakter ikke er nævnt';
$string['matchgradesnearest'] = 'Nærmeste karakter, hvis ikke nævnt';
$string['missingcourseorcmid'] = 'Du skal oplyse kursus-id eller cm-id til print_question.';
$string['missingcourseorcmidtolink'] = 'Du skal oplyse kursus-id eller cm-id til get_question_edit_link';
$string['missingimportantcode'] = 'Denne spørgsmålstype mangler en vigtig kode: {$a}.';
$string['missingoption'] = 'Spørgsmålet {$a} mangler sine valgmuligheder';
$string['modified'] = 'Senest gemt';
$string['move'] = 'Flyt fra {$a} og ret links.';
$string['movecategory'] = 'Flyt kategori';
$string['movedquestionsandcategories'] = 'Spørgsmål og spørgsmålkategorier blev flyttet fra {$a->oldplace} til {$a->newplace}.';
$string['movelinksonly'] = 'Ret kun hvor link peger hen, flyt eller kopier ikke filer.';
$string['moveq'] = 'Flyt spørgsmål';
$string['moveqtoanothercontext'] = 'Flyt spørgsmål til en anden kontekst.';
$string['moveto'] = 'Flyt til';
$string['movingcategory'] = 'Flytter kategorien';
$string['movingcategoryandfiles'] = 'Er du sikker på at du vil flytte kategorien {$a->name} og alle underkategorier til konteksten for "{$a->contextto}"?<br /> Vi har fundet {$a->urlcount} filer hvortil der er linket fra spørgsmål i {$a->fromareaname}, vil du flytte eller kopiere disse til {$a->toareaname}?';
$string['movingcategorynofiles'] = 'Er du sikker på at du vil flytte kategorien "{$a->name}" og alle underkategorier til konteksten for "{$a->contextto}"?';
$string['movingquestions'] = 'Flytter spørgsmål og filer';
$string['movingquestionsandfiles'] = 'Er du sikker på at du vil flytte spørgsmål(ene) {$a->questions} til konteksten <strong>"{$a->tocontext}"</strong>?<br /> Vi har fundet <strong>{$a->urlcount} filer</strong> der er linket til fra disse spørgsmål i {$a->fromareaname}, vil du kopiere eller flytte disse til {$a->toareaname}?';
$string['movingquestionsnofiles'] = 'Er du sikker på at du vil flytte spørgsmål(ene) {$a->questions} til konteksten <strong>"{$a->tocontext}"</strong>?<br /> Der er <strong>ingen filer</strong> der linkes til fra disse spørgsmål i {$a->fromareaname}.';
$string['needtochoosecat'] = 'Du skal vælge en kategori at flytte spørgsmålet til eller klik på "annuller".';
$string['nobanks'] = 'Dette kursus har endnu ingen spørgsmålsbanker.';
$string['nocate'] = 'Kategorien {$a} findes ikke!';
$string['noconditionspecified'] = 'Angiv venligst en betingelse';
$string['nopermissionadd'] = 'Du har ikke tilladelse til at tilføje spørgsmål her.';
$string['nopermissionedit'] = 'Du har ikke tilladelse til at redigere spørgsmål herfra.';
$string['noprobs'] = 'Der er ikke fundet nogen problemer i din database med spørgsmål.';
$string['noquestionbanks'] = 'Intet spørgsmålsbank plugin fundet';
$string['noquestions'] = 'Der var ingen spørgsmål, som kunne eksporteres. Sørg for at vælge en kategori til eksport, der indeholder spørgsmål.';
$string['noquestionsinfile'] = 'Ingen spørgsmål i importfilen';
$string['noresponse'] = '[Ingen respons]';
$string['notagfiltersapplied'] = 'Der er ikke angivet nogen tags-filtre';
$string['notanswered'] = 'Ikke besvaret';
$string['notchanged'] = 'Ikke ændret siden sidste forsøg på besvarelse';
$string['notenoughanswers'] = 'Denne type spørgsmål kræver mindst {$a} svar';
$string['notenoughdatatoeditaquestion'] = 'Der var hverken angivet spørgsmåls-id, kategori-id eller spørgsmålstype.';
$string['notenoughdatatomovequestions'] = 'Du skal angive spørgsmåls-id på de spørgsmål du vil flytte.';
$string['notgraded'] = 'Ikke bedømt';
$string['notshown'] = 'Ikke vist';
$string['notyetanswered'] = 'Ikke besvaret';
$string['notyourpreview'] = 'Denne forhåndsvisning tilhører ikke dig';
$string['novirtualquestiontype'] = 'Ingen virtuel spørgsmålstype til spørgsmålstypen {$a}';
$string['numqas'] = 'Antal forsøg på besvarelse';
$string['numquestions'] = 'Antal spørgsmål';
$string['numquestionsandhidden'] = '{$a->numquestions} (+{$a->numhidden} skjult +{$a->numdraft} kladde)';
$string['options'] = 'Valgmuligheder';
$string['otherbanks'] = 'Andre aktiviteter med spørgsmål.';
$string['otherbanksdesc'] = 'Spørgsmål i spørgsmålsbankerne for disse aktiviteter kan ikke bruges andre steder';
$string['otherquestionbank'] = 'Alle spørgsmålsbanker';
$string['otherquestionbankstoomany'] = 'Mere end {$a} resultater. Du skal præcisere din søgning..';
$string['page-question-category'] = 'Spørgsmålskategori-side';
$string['page-question-edit'] = 'Spørgsmålsredigeringsside';
$string['page-question-export'] = 'Spørgsmålseksport-side';
$string['page-question-import'] = 'Spørgsmålsimport-side';
$string['page-question-x'] = 'En hvilken som helst spørgsmålsside';
$string['parent'] = 'Overordnet';
$string['parentcategory'] = 'Overordnet kategori';
$string['parentcategory_help'] = 'Den overordnede kategori er den, som den nye kategori vil blive placeret i. "Top" betyder at kategorien ikke er en del af andre kategorier. Kategorikontekster vises med fed skrift. Der skal være mindst en kategori i hver kontekst.';
$string['parentcategory_link'] = 'question/category';
$string['parenthesisinproperclose'] = 'Parentes før ** er ikke behørigt lukket i {$a}**';
$string['parenthesisinproperstart'] = 'Parentes før ** er ikke korrekt startet i {$a}**';
$string['parsingquestions'] = 'Gennemsøger spørgsmål fra importfil.';
$string['partiallycorrect'] = 'Delvis rigtigt';
$string['partiallycorrectfeedback'] = 'For hvert delvis rigtigt svar';
$string['partiallycorrectfeedbackdefault'] = 'Dit svar er delvis rigtigt';
$string['penaltyfactor'] = 'Straffaktor';
$string['penaltyfactor_help'] = 'Indstillingen styrer hvilken brøkdel af den opnåede score der trækkes fra for et forkert svar. Er kun relevant når quizzen er i adaptiv tilstand.

Straffaktoren skal være mellem 0 og 1. En straffaktor på 1 betyder at den studerende skal svare rigtigt første gang for at få point for svaret. En straffaktor på 0 betyder at der altid vil gives fuld score for et rigtigt svar uanset tidligere antal forkerte svar.';
$string['penaltyforeachincorrecttry'] = 'Strafpoint ved hvert forkert svar';
$string['penaltyforeachincorrecttry_help'] = 'Når du i en quiz bruger indstillingerne "Interaktiv med flere forsøg" eller "Adaptiv tilstand", således at den studerende har flere forsøg på at svare rigtigt, styrer denne indstilling hvor stor straffen skal være hver gang der svares forkert.

Straffen er en procentdel af de totale point, så hvis spørgsmålet er 3 point værd og straffen er 33,3333%, vil det give 3 point at svare rigtigt første gang, 2 for anden gang og 1 point for at svare rigtigt i 3. forsøg.

Denne logik anvendes separat på hver del i spørgsmål med flere dele. Detaljerne afhænger af spørgsmålstypen og kan være komplicerede, men princippet er så godt som muligt at honorere de studerende for den viden de har demonstreret.';
$string['permissionedit'] = 'Rediger dette spørgsmål';
$string['permissionmove'] = 'Flyt spørgsmålet';
$string['permissionsaveasnew'] = 'Gem som et nyt spørgsmål';
$string['permissionto'] = 'Du har tilladelse til:';
$string['previewbank'] = 'Preview af delt spørgsmålsbank';
$string['previewquestion'] = 'Forhåndsvis spørgsmål: {$a}';
$string['privacy:metadata:database:question'] = 'Detaljerne om et specifikt spørgsmål.';
$string['privacy:metadata:database:question:createdby'] = 'Personen der har oprettet spørgsmålet';
$string['privacy:metadata:database:question:generalfeedback'] = 'Den generelle feedback på dette spørgsmål';
$string['privacy:metadata:database:question:modifiedby'] = 'Personen der sidst opdaterede spørgsmålet';
$string['privacy:metadata:database:question:name'] = 'Navnet på spørgsmålet';
$string['privacy:metadata:database:question:questiontext'] = 'Spørgsmålsteksten';
$string['privacy:metadata:database:question:timecreated'] = 'Dato og tid på hvornår spørgsmålet blev lavet.';
$string['privacy:metadata:database:question:timemodified'] = 'Dato og tid på hvornår spørgsmålet blev opdateret';
$string['privacy:metadata:database:question_attempt_step_data'] = 'Spørgsmålsforsøgs trin kan have yderligere data specifikke for det trin. Dataene gemmes i tabellen step_data.';
$string['privacy:metadata:database:question_attempt_step_data:name'] = 'Navnet på dataelementet.';
$string['privacy:metadata:database:question_attempt_step_data:value'] = 'Værdien af dataelementet.';
$string['privacy:metadata:database:question_attempt_steps'] = 'Hvert spørgsålsforsøg har et antal trin for at indikere de forskellige faser fra start til afslutning til bedømmelse. Denne tabel gemmer informationen for hvert af disse trin.';
$string['privacy:metadata:database:question_attempt_steps:fraction'] = 'Den karakter, der blev givet til dette spørgsålsforsøg, skaleret til en værdi ud af 1.';
$string['privacy:metadata:database:question_attempt_steps:state'] = 'Tilstanden for dette spørgsålsforsøgstrin ved afslutningen af trinovergangen.';
$string['privacy:metadata:database:question_attempt_steps:timecreated'] = 'Datoen og tidspunktet for begyndelsen af denne trinovergang.';
$string['privacy:metadata:database:question_attempt_steps:userid'] = 'Brugeren, der udførte trinovergangen.';
$string['privacy:metadata:database:question_attempts'] = 'Informationen om et forsøg på et specifikt spørgsmål.';
$string['privacy:metadata:database:question_attempts:flagged'] = 'En indikation på, at brugeren har markeret dette spørgsmål inden for forsøget.';
$string['privacy:metadata:database:question_attempts:responsesummary'] = 'En oversigt over spørgsmålssvaret.';
$string['privacy:metadata:database:question_attempts:timemodified'] = 'Tidspunktet for opdateringen af spørgsålsforsøget.';
$string['privacy:metadata:database:question_bank_entries'] = 'Detaljerne om en specifik indgang i spørgsmålbanken.';
$string['privacy:metadata:database:question_bank_entries:ownerid'] = 'Personen, der ejer indgangen i spørgsmålbanken.';
$string['privacy:metadata:link:qbehaviour'] = 'Spørgsmålsubsystemet gør brug af plugintypen Question Behaviour.';
$string['privacy:metadata:link:qformat'] = 'Spørgsmålsubsystemet gør brug af plugintypen Question Format til import og eksport af spørgsmål i forskellige formater.';
$string['privacy:metadata:link:qtype'] = 'Spørgsmålsubsystemet interagerer med plugintypen Question Type, som indeholder de forskellige typer af spørgsmål.';
$string['published'] = 'delt';
$string['qbanknotfound'] = 'Modulet "{$a}" til spørgsmålsbanken findes ikke eller blev ikke genkendt.';
$string['qtypeveryshort'] = 'T';
$string['question_version'] = 'Spørgsmålsversion';
$string['question_versionshort'] = 'v{$a}';
$string['questionaffected'] = '<a href="{$a->qurl}">Spørgsmålet "{$a->name}" ({$a->qtype})</a> er i denne kategori, men det bruges også i <a href="{$a->qurl}">quizzen "{$a->quizname}"</a> på et andet kursus "{$a->coursename}".';
$string['questionbank'] = 'Spørgsmålsbank';
$string['questionbank_plural'] = 'Spørgsmålsbanker';
$string['questionbanknavigation'] = 'Tertiær navigering i spørgsmålbanken';
$string['questionbehaviouradminsetting'] = 'Indstilling for spørgsmålsopførsel';
$string['questionbehavioursdisabled'] = 'Spørgsmålsopførsel, der skal sættes ud af funktion';
$string['questionbehavioursdisabledexplained'] = 'Indsæt en kommasepareret liste med opførsler, du ikke vil have til at forekomme i rullemenuen';
$string['questionbehavioursorder'] = 'Spørgsmålsopførsels-rækkefølge';
$string['questionbehavioursorderexplained'] = 'Indsæt en kommasepareret liste med opførsler i den rækkefølge, du vil have dem til at stå i rullemenuen';
$string['questioncategories'] = 'Spørgsmålskategorier';
$string['questioncategory'] = 'Spørgsmålskategori';
$string['questioncatsfor'] = 'Spørgsmålskategorier for "{$a}"';
$string['questiondefaultssave'] = 'Gem spørgsmålsmuligheder som standard brugerpræferencer';
$string['questiondefaultssave_desc'] = 'Om spørgsmålsmuligheder såsom \'Standardkarakter\', \'Et eller flere svar?\' osv. skal gemmes som brugerpræferencer, når redigeringsformularen for spørgsmål indsendes, til brug som standard næste gang brugeren tilgår formularen.';
$string['questiondoesnotexist'] = 'Spørgsmålet eksisterer ikke';
$string['questionediting'] = 'Redigering af spørgsmål';
$string['questionediting_desc'] = 'Disse indstillinger gælder for redigeringsformularer for spørgsmål.';
$string['questionformtagheader'] = '{$a} tags';
$string['questionidmismatch'] = 'Spørgsmåls-id\'er matcher ikke';
$string['questionloaderror'] = 'Kunne ikke indlæse spørgsmålsindstillingerne.';
$string['questionname'] = 'Spørgsmålsnavn';
$string['questionnameandquestionversion'] = '{$a->name} v{$a->version}';
$string['questionnamecopy'] = '{$a} (kopi)';
$string['questionno'] = 'Spørgsmål {$a}';
$string['questionpreviewdefaults'] = 'Standardforhåndsvisninger af spørgsmål';
$string['questionpreviewdefaults_desc'] = 'Disse standarder bruges når en bruger først får vist et spørgsmål i spørgsmålsbanken. Når en bruger har fået vist et spørgsmål, gemmes brugerens personlige indstillinger som brugerindstillinger.';
$string['questions'] = 'Spørgsmål';
$string['questionsaveerror'] = 'Fejl opstår under forsøg på at gemme spørgsmål - ({$a})';
$string['questionsinuse'] = '* Angiver spørgsmål, som ikke kan slettes, fordi de er i brug. I stedet vil de blive skjult i spørgsmålbanken, medmindre du sætter \'Vis skjulte spørgsmål\' til \'Ja\'.';
$string['questionsmovedto'] = 'Spørgsmål der stadig er i brug, er flyttet til "{$a}" i kursuskategorien ovenover.';
$string['questionsrescuedfrom'] = 'Spørgsmål er gemt fra konteksten {$a}.';
$string['questionsrescuedfrominfo'] = 'Disse spørgsmål (hvoraf nogle kan være skjulte) blev gemt da konteksten {$a} blev slettet fordi de stadig bliver brugt i quizzer eller andre aktiviteter.';
$string['questiontags'] = 'Spørgsmålstags';
$string['questiontext'] = 'Spørgsmålstekst';
$string['questiontype'] = 'Spørgsmålstype';
$string['questionuse'] = 'Brug spørgsmål i denne aktivitet';
$string['questionvariant'] = 'Spørgsmålsvariant';
$string['questionx'] = 'Spørgsmål {$a}';
$string['quizquestionbank'] = 'Denne quiz\' spørgsmålsbank';
$string['recentlyviewedquestionbanks'] = 'Senest viste spørgsmålsbanker';
$string['requiresgrading'] = 'Kræver bedømmelse';
$string['responsehistory'] = 'Svarhistorik';
$string['restart'] = 'Start forfra';
$string['restartwiththeseoptions'] = 'Gem indstillinger for forhåndsvisning og start forfra';
$string['restoremultipletopcats'] = 'Backupfilen har mere end en topkategori til spørgsmål i konteksten {$a}';
$string['reviewresponse'] = 'Vis svar igen';
$string['rightanswer'] = 'Det rigtige svar';
$string['rightanswer_help'] = 'Et automatisk genereret resumé af det korrekte svar. Dette kan være begrænset, så du kan overveje at forklare den korrekte løsning i den generelle feedback på spørgsmålet og slå denne valgmulighed fra.';
$string['save'] = 'Gem';
$string['savechangesandcontinueediting'] = 'Gem ændringer og fortsæt med at redigere';
$string['saved'] = 'Gemt: {$a}';
$string['saveflags'] = 'Gem flag-status';
$string['selectacategory'] = 'Vælg en kategori:';
$string['selectaqtypefordescription'] = 'Vælg den type spørgsmål du vil se en beskrivelse af';
$string['selectcategoryabove'] = 'Vælg en kategori ovenfor';
$string['selectquestionsforbulk'] = 'Vælg spørgsmål til samlet behandling';
$string['settingsformultipletries'] = 'Flere forsøg';
$string['shareincontext'] = 'Del i kontekst for {$a}';
$string['shortversioninfo'] = 'v{$a->version} (af {$a->latestversion})';
$string['shortversioninfolatest'] = 'v{$a->version} (nyeste)';
$string['showhidden'] = 'Vis skjulte spørgsmål';
$string['showmarkandmax'] = 'Vis karakter og maksimum';
$string['showmaxmarkonly'] = 'Vis kun karakter';
$string['shown'] = 'Vist';
$string['shownumpartscorrect'] = 'Vis antal rigtige svar';
$string['shownumpartscorrectwhenfinished'] = 'Vis antal rigtige svar når spørgsmålet er afsluttet';
$string['showquestiontext'] = 'Vis spørgsmålsteksten i listen over spørgsmål?';
$string['showquestiontext_full'] = 'Ja, med billeder, medier osv.';
$string['showquestiontext_off'] = 'Nej';
$string['showquestiontext_plain'] = 'Ja, kun tekst';
$string['specificfeedback'] = 'Specifik feedback';
$string['specificfeedback_help'] = 'Feedback, der afhænger af det svar, den studerende har givet.';
$string['started'] = 'Startet';
$string['state'] = 'Status';
$string['step'] = 'Trin';
$string['steps'] = 'Trin';
$string['stoponerror'] = 'Stop ved fejl';
$string['stoponerror_help'] = 'Indstillingen styrer om importen standser når en fejl opdages og ingen spørgsmål importeres, eller om spørgsmål der indeholder fejl ignoreres og alle gyldige spørgsmål importeres.';
$string['submissionoutofsequence'] = 'Adgang uden for rækkefølgen. Klik ikke på browserens tilbage-knap, når du arbejder med quiz-spørgsmål.';
$string['submissionoutofsequencefriendlymessage'] = 'Du har indtastet data uden for den normale rækkefølge. Dette kan ske hvis du bruger browserens tilbage- eller frem-knapper. Brug ikke disse knapper under testen. Det kan også ske hvis du klikker på noget mens en side er ved at blive hentet. Klik på <strong>Fortsæt</strong> for at gå videre.';
$string['submit'] = 'Aflever';
$string['submitandfinish'] = 'Aflever og afslut';
$string['submitted'] = 'Aflever: {$a}';
$string['switchbank'] = 'Skift bank';
$string['systembank'] = 'Systemdelt spørgsmålsbank';
$string['systembankdescription'] = 'Denne spørgsmålsbank blev oprettet automatisk, da webstedet blev opgraderet.';
$string['tagarea_question'] = 'Spørgsmål';
$string['technicalinfo'] = 'Teknisk information';
$string['technicalinfo_help'] = 'Denne tekniske information er sandsynligvis kun brugbar for udviklere, der arbejder på nye spørgsmålstyper. Den kan også være til hjælp, når man forsøger at diagnosticere problemer med spørgsmål.';
$string['technicalinfomaxfraction'] = 'Højeste brøkdel: {$a}';
$string['technicalinfominfraction'] = 'Laveste brøkdel: {$a}';
$string['technicalinfoquestionsummary'] = 'Spørgsmålsresumé: {$a}';
$string['technicalinforesponsesummary'] = 'Svarresumé: {$a}';
$string['technicalinforightsummary'] = 'Resumé over rigtige svar: {$a}';
$string['technicalinfostate'] = 'Spørgsmålstilstand: {$a}';
$string['technicalinfovariant'] = 'Spørgsmålsvariant: {$a}';
$string['tofilecategory'] = 'Skriv kategori til fil';
$string['tofilecontext'] = 'Skriv kontekst til fil';
$string['topfor'] = 'Top for {$a}';
$string['uninstallbehaviour'] = 'Afinstaller denne spørgsmålsopførsel.';
$string['uninstallqtype'] = 'Afinstaller denne spørgsmålstype.';
$string['unknown'] = 'Ukendt';
$string['unknownbehaviour'] = 'Ukendt opførsel: {$a}.';
$string['unknownorunhandledtype'] = 'Ukendt eller ikke behandlet spørgsmålstype: {$a}';
$string['unknownquestion'] = 'Ukendt spørgsmål: {$a}.';
$string['unknownquestioncatregory'] = 'Ukendt spørgsmålskategori: {$a}.';
$string['unknownquestiontype'] = 'Ukendt spørgsmålstype: {$a}';
$string['unknowntolerance'] = 'Ukendt tolerancetype {$a}';
$string['unpublished'] = 'Ikke delt';
$string['unusedcategorydeleted'] = 'Denne kategori er blevet slettet efter at kurset blev slettet, spørgsmålene blev ikke brugt mere.';
$string['updatedisplayoptions'] = 'Opdater visningsindstillinger';
$string['upgradeproblemcategoryloop'] = 'Et problem blev fundet under opgradering af spørgsmålskategorier. Der er en loop i kategoritræet. Det drejer sig om kategorien(erne) {$a}';
$string['upgradeproblemcouldnotupdatecategory'] = 'Det kunne ikke lade sig gøre at opdatere kategorien {$a->name} ({$a->id}).';
$string['upgradeproblemunknowncategory'] = 'Et problem blev fundet under opgradering af spørgsmålskategorier. Kategorien {$a->id} refererer til en overkategori {$a->parent}, som ikke eksisterer. Den overordnede kategori er ændret for at klare problemet.';
$string['version_selection'] = 'Version {$a->version}';
$string['versioninfo'] = 'Version {$a->version} (of {$a->latestversion})';
$string['versioninfolatest'] = 'Version {$a->version} (nyeste)';
$string['versioninfolatestshort'] = 'v{$a} (seneste)';
$string['whethercorrect'] = 'Om besvarelsen er rigtig';
$string['whethercorrect_help'] = 'Dette dækker både beskrivelsen \'Rigtigt\', \'Delvis rigtigt\' og \'Forkert\' og enhver farvet fremhævning, som viderebringer samme information.';
$string['whichtries'] = 'Hvilke forsøg';
$string['withselected'] = 'Handling for markerede';
$string['wrongprefix'] = 'Forkert formateret navnepræfiks {$a}';
$string['xoutofmax'] = '{$a->mark} ud af {$a->max}';
$string['yougotnright'] = 'Du har {$a->num} rigtig(e).';
$string['youmustselectaqtype'] = 'Du skal vælge en spørgsmålstype.';
$string['yourfileshoulddownload'] = 'Eksport af din fil vil starte om et øjeblik. Gør den ikke det, så <a href="{$a}">klik her</a>.';
