<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'lesson', language 'da', version '5.1'.
 *
 * @package     lesson
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accesscontrol'] = 'Adgangskontrol';
$string['actionaftercorrectanswer'] = 'Handling efter rigtigt svar';
$string['actionaftercorrectanswer_help'] = 'Efter rigtigt svar på et spørgsmål er der 3 muligheder for den følgende side:

* Normal - Følger lektionens rækkefølge
* Vis en endnu ikke vist side - Sider vises i tilfældig rækkefølge uden gentagelse af tidligere viste sider
* Vis en ubesvaret side - Sider vises i tilfældig rækkefølge af sider med ubesvarede spørgsmål.';
$string['actions'] = 'Hændelser';
$string['activitylink'] = 'Link til næste aktivitet';
$string['activitylink_help'] = 'Vil du have et link sidst i lektionen til en anden aktivitet på kurset, kan du vælge aktiviteten i rullemenuen her.';
$string['activitylinkname'] = 'Gå til {$a}';
$string['activityoverview'] = 'Du har lektioner, som skal afleveres';
$string['addabranchtable'] = 'Tilføj en indholdsside';
$string['addanendofbranch'] = 'Tilføj slutning på forgrening';
$string['addanewpage'] = 'Tilføj side';
$string['addaquestionpage'] = 'Gem';
$string['addaquestionpagehere'] = 'Tilføj spørgsmålsside her';
$string['addbranchtable'] = 'Tilføj en indholdsside';
$string['addcluster'] = 'Tilføj klynge';
$string['addedabranchtable'] = 'Indholdsside tilføjet';
$string['addedanendofbranch'] = 'Afslutning på forgrening tilføjet';
$string['addedaquestionpage'] = 'Spørgsmålsside tilføjet';
$string['addedcluster'] = 'Klynge tilføjet';
$string['addedendofcluster'] = 'Slutning på klynge tilføjet';
$string['addendofbranch'] = 'Tilføj slutning på forgrening';
$string['addendofcluster'] = 'Tilføj slutning på klynge';
$string['addessay'] = 'Opret en side med et tekstsvar-spørgsmål';
$string['addmatching'] = 'Opret en side med match-spørgsmål';
$string['addmultichoice'] = 'Opret en side med multiple-choice-spørgsmål';
$string['addnewgroupoverride'] = 'Tilføj gruppeundtagelse';
$string['addnewuseroverride'] = 'Tilføj brugerundertagelser';
$string['addnumerical'] = 'Opret en side med numerisk spørgsmål';
$string['addpage'] = 'Tilføj';
$string['addshortanswer'] = 'Opret en side med kort svar-spørgsmål';
$string['addtruefalse'] = 'Opret en side med sand/falsk-spørgsmål';
$string['allotheranswers'] = 'Alle andre svar';
$string['allotheranswersjump'] = 'Alle andre svars hop';
$string['allotheranswersscore'] = 'Alle andre svars score';
$string['allowedattempts'] = 'Tilladte forsøg pr. studerende';
$string['allowofflineattempts'] = 'Tillad lektionen at blive kørt offline i mobilappen';
$string['allowofflineattempts_help'] = 'Er indstillingen aktiveret, kan en bruger af mobilappen downloade lektionen og køre den offline. Alle mulige svar og korrekte responser vil også blive downloadet. Bemærk: Det er ikke muligt at køre en lektion med tidsbegrænsning offline.';
$string['anchortitle'] = 'Start på hovedindhold';
$string['and'] = 'OG';
$string['answer'] = 'Svar';
$string['answeredcorrectly'] = 'Rigtigt besvaret.';
$string['answersfornumerical'] = 'Svar på numeriske spørgsmål skal være par af maksimum- og minimumsværdier.';
$string['arrangebuttonshorizontally'] = 'Arranger forgreningsknapper vandret under visning af diasshow?';
$string['attempt'] = 'Forsøg: {$a}';
$string['attemptheader'] = 'Forsøg';
$string['attemptinfonograde'] = '{$a->timestart} ({$a->duration})';
$string['attemptinfowithgrade'] = '{$a->grade}% {$a->timestart} ({$a->duration})';
$string['attempts'] = 'Forsøg';
$string['attemptsdeleted'] = 'Slettede forsøg';
$string['attemptsremaining'] = 'Du har {$a} forsøg endnu';
$string['available'] = 'Tilgængelig fra';
$string['averageattempts'] = 'Gennemsnitlige forsøg pr. studerende';
$string['averagescore'] = 'Gennemsnitlig score';
$string['averagetime'] = 'Gennemsnitstid';
$string['branch'] = 'Indhold';
$string['branchtable'] = 'Indhold';
$string['cachedef_overrides'] = 'Bruger- og gruppeoverskriftsinformation';
$string['cancel'] = 'Annuller';
$string['cannotfindanswer'] = 'Fejl: Fandt ikke svaret';
$string['cannotfindattempt'] = 'Fejl: kunne ikke finde forsøget';
$string['cannotfindessay'] = 'Fejl: kunne ikke finde tekstsvar';
$string['cannotfindfirstgrade'] = 'Fejl: kunne ikke finde karakterer';
$string['cannotfindfirstpage'] = 'Kunne ikke finde den første side';
$string['cannotfindgrade'] = 'Fejl: kunne ikke finde karakterer';
$string['cannotfindnewestgrade'] = 'Fejl: kunne ikke finde nyeste karakterer';
$string['cannotfindnextpage'] = 'Lektionsbackup: Næste side blev ikke fundet!';
$string['cannotfindpagerecord'] = 'Tilføj slutning på forgrening: sideposten blev ikke fundet';
$string['cannotfindpages'] = 'Kunne ikke finde lektionssider';
$string['cannotfindpagetitle'] = 'Bekræft sletning: sidens titel blev ikke fundet';
$string['cannotfindpreattempt'] = 'Registreringen af det forrige forsøg blev ikke fundet';
$string['cannotfindrecords'] = 'Fejl: kunne ikke finde lektionsposter';
$string['cannotfindtimer'] = 'Fejl: kunne ikke finde lesson_timer-poster';
$string['cannotfinduser'] = 'Fejl: kunne ikke finde brugere';
$string['canretake'] = '{$a} kan prøve igen';
$string['casesensitive'] = 'Brug regulære udtryk';
$string['casesensitive_help'] = 'Marker tjekboksen for at bruge regulære udtryk til analyse for respons.';
$string['checkbranchtable'] = 'Tjek indholdsside';
$string['checkedthisone'] = 'Tjekkede denne';
$string['checknavigation'] = 'Tjek navigation';
$string['checkquestion'] = 'Tjek spørgsmål';
$string['classstats'] = 'Klassestatistik';
$string['clicktodownload'] = 'Download filen ved klik på følgende link.';
$string['closebeforeopen'] = 'Kunne ikke opdatere lektionen. Du har sat den til at lukke før den åbner.';
$string['cluster'] = 'Klynge';
$string['clusterjump'] = 'Usete spørgsmål i en klynge';
$string['clustertitle'] = 'Klynge';
$string['collapsed'] = 'Sammenfoldet';
$string['comments'] = 'Dine kommentarer';
$string['completed'] = 'Gennemført';
$string['completederror'] = 'Afslut lektionen';
$string['completethefollowingconditions'] = 'Du skal besvare følgende spørgsmål i <b>{$a}</b> inden du kan fortsætte.';
$string['completiondetail:reachend'] = 'Gå gennem aktiviteten til slutningen';
$string['completiondetail:timespent'] = 'Brug mindst {$a} minutter på denne aktivitet';
$string['completionendreached'] = 'Kræv at slutningen nås';
$string['completionendreached_desc'] = 'Den studerende skal nå sidste side i lektionen for at gennemføre den.';
$string['completiontimespentdesc'] = 'Den studerende skal bruge mindst {$a} til lektionen';
$string['completiontimespentgroup'] = 'Kræv tidsforbrug';
$string['conditionsfordependency'] = 'Betingelse(r) herfor';
$string['configintro'] = 'Disse værdier styrer standardværdierne der bruges i indstillingsformularen når en ny lektion oprettes. De indstillinger der markeres som avanceret, vises kun når der klikkes på "Vis mere...".';
$string['configmaxanswers'] = 'Standard for højeste antal svar på hver side';
$string['configmediaclose'] = 'Viser en lukkeknap som en del af pop op\'en når der er linket til en mediefil';
$string['configmediaheight'] = 'Angiver højden af pop op\'en når der er linket til en mediefil';
$string['configmediawidth'] = 'Angiver bredden af pop op\'en når der er linket til en mediefil';
$string['configpassword_desc'] = 'Hvorvidt der kræves adgangskode til lektionen';
$string['configslideshowbgcolor'] = 'Baggrundsfarve på diasshowet, hvis det er aktiveret';
$string['configslideshowheight'] = 'Angiv højden på diasshowet hvis det er aktiveret';
$string['configslideshowwidth'] = 'Angiv bredden på diasshowet hvis det er aktiveret';
$string['configtimelimit_desc'] = 'Er der tidsbegrænsning på lektionen vises en advarsel i begyndelsen og der er et nedtællingsur. Sættes indstillingen til 0, vil der ikke være tidsbegrænsning på.';
$string['confirmdelete'] = 'Slet side';
$string['confirmdeletionofthispage'] = 'Bekræft sletning af denne side.';
$string['congratulations'] = 'Tillykke - Denne lektion er slut.';
$string['continue'] = 'Fortsæt';
$string['continuetoanswer'] = 'Fortsæt for at ændre svar';
$string['continuetonextpage'] = 'Fortsæt til næste side.';
$string['correctanswerjump'] = 'Spring ved rigtigt svar';
$string['correctanswerscore'] = 'Score for rigtigt svar';
$string['correctresponse'] = 'Respons på rigtigt svar';
$string['createaquestionpage'] = 'Opret en spørgsmålsside';
$string['credit'] = 'Point';
$string['customscoring'] = 'Spørgsmålsspecifikke point';
$string['customscoring_help'] = 'Hvis aktiveret, kan en hel talværdi (positiv eller negativ) indtastes for hvert svar.';
$string['deadline'] = 'Afleveringsfrist';
$string['defaultessayresponse'] = 'Din tekst vil blive vurderet af din lærer på kurset.';
$string['deleteallattempts'] = 'Alle lektionforsøg';
$string['deletedefaults'] = 'Slettet {$a} x lektionsstandard';
$string['deletedpage'] = 'Slettet side';
$string['deletepagenamed'] = 'Slet siden: {$a}';
$string['deleting'] = 'Sletter';
$string['deletingpage'] = 'Sletter side: {$a}';
$string['dependencyon'] = 'Adgang afhængig af';
$string['dependencyon_help'] = 'Denne indstilling sætter adgang til denne lektion afhængig af en studerendes præstation i en anden lektion på samme kursus. Enhver kombination af tidsforbrug, gennemført eller "karakter bedre end" kan anvendes.';
$string['description'] = 'Beskrivelse';
$string['deselectallattempts'] = 'Slet alle besvarelser';
$string['detailedstats'] = 'Detaljeret statistik';
$string['didnotanswerquestion'] = 'Besvarede ikke dette spørgsmål.';
$string['didnotreceivecredit'] = 'Fik ingen point';
$string['disabled'] = 'Deaktiveret';
$string['displaydefaultfeedback'] = 'Brug standardfeedback';
$string['displaydefaultfeedback_help'] = 'Er indstillingen aktiveret, vises hhv. "Rigtigt svar! :-)" eller "Desværre, svaret er forkert" som respons på korrekte og forkerte svar.';
$string['displayinleftmenu'] = 'Vis i menuen?';
$string['displayleftif'] = 'Minimumskarakter til visning af menu';
$string['displayleftif_help'] = 'Indstillingen styrer om de studerende skal opnå en bestemt karakter før lektionsmenuen vises. Det tvinger de studerende til at gå gennem hele lektionen i første forsøg, derpå kan de efter at have opnået den nødvendige karakter, bruge menuen til venstre til gennemsyn af lektionen.';
$string['displayleftmenu'] = 'Vis menu';
$string['displayleftmenu_help'] = 'Hvis indstillingen er aktiveret, vises en menu til navigation mellem siderne.';
$string['displaymode'] = 'Visningstilstand';
$string['displayofgrade'] = 'Vis bedømmelse (for studerende)';
$string['displayreview'] = 'Vis knap til at prøve igen';
$string['displayreview_help'] = 'Når indstillingen er aktiveret, vil brugere med forkerte svar få mulighed for enten at prøve igen uden at få point eller at fortsætte lektionen. Klikker den studerende videre til et andet spørgsmål vil det valgte (forkerte) svar blive fulgt. Som standard er spring ved forkert svar sat til "denne side" og har en score på 0, så det anbefales at sætte det forkerte svar-spring til en anden side for at undgå forvirring.';
$string['displayscorewithessays'] = '<p>Du fik {$a->score} ud af {$a->tempmaxgrade} for de automatisk rettede spørgsmål.</p> <p>Dit/dine {$a->essayquestions} tekstsvar vil blive bedømt og lagt til scoren senere.</p> <p>Din nuværende karakter uden tekstsvarene er {$a->score} ud af {$a->grade}.</p>';
$string['displayscorewithoutessays'] = 'Din score er {$a->score} (ud af {$a->grade}).';
$string['duedate'] = 'Afleveringsfrist';
$string['duplicatepagenamed'] = 'Duplikeret side: {$a}';
$string['edit'] = 'Rediger';
$string['editbranchtable'] = 'Redigering af indholdsside';
$string['editcluster'] = 'Redigering af en klynge';
$string['editendofbranch'] = 'Redigering af slut på forgreningsside';
$string['editendofcluster'] = 'Redigering af en klyngeside';
$string['editessay'] = 'Redigering af en tekstsvarside';
$string['editinglesson'] = 'Redigering af lektion';
$string['editingquestionpage'] = 'Redigering af spørgsmålssiden {$a}';
$string['editlesson'] = 'Rediger lektion';
$string['editlessonsettings'] = 'Rediger lektionsindstillinger';
$string['editmatching'] = 'Redigering af match-spørgsmålsside';
$string['editmultichoice'] = 'Redigering af en multiple choice-side';
$string['editnumerical'] = 'Redigering af en numerisk spørgsmålsside';
$string['editoverride'] = 'Rediger undertagelse';
$string['editpage'] = 'Rediger sideindhold';
$string['editpagecontent'] = 'Rediger sideindhold';
$string['editquestion'] = 'Redigering af en spørgsmålsside';
$string['editshortanswer'] = 'Redigering af en kort svar-side';
$string['edittruefalse'] = 'Redigering af en sand/falsk-side';
$string['email'] = 'E-mail';
$string['emailallgradedessays'] = 'Send meddelelser om bedømte opgaver';
$string['emailgradedessays'] = 'Send meddelelser om bedømte opgaver';
$string['emailsuccess'] = 'Meddelelser sendt';
$string['emptypassword'] = 'Adgangskode kan ikke være tom';
$string['enabled'] = 'Aktiveret';
$string['endofbranch'] = 'Slut på forgrening';
$string['endofcluster'] = 'Slut på klynge';
$string['endofclustertitle'] = 'Slut på klynge';
$string['endoflesson'] = 'Slut på lektion';
$string['enteredthis'] = 'gået ind i denne';
$string['enterpassword'] = 'Skriv adgangskoden';
$string['eolstudentoutoftime'] = 'Bemærk: Tiden er udløbet for denne lektion. Dit sidste svar tæller muligvis ikke hvis du afleverede det efter at tiden var udløbet.';
$string['eolstudentoutoftimenoanswers'] = 'Du besvarede ikke nogen af spørgsmålene. Du får 0 for denne lektion';
$string['essay'] = 'Tekstsvar';
$string['essayemailmessage2'] = '<p>Tekstsvar-prompt: {$a->question}</p><p>Din respons: <em>{$a->response}</em></p><p>Den bedømmendes kommentar: <em>{$a->comment}</em></p><p>Du har modtaget {$a->earned} ud af {$a->outof} or dette spørgsmål.</p><p>Din karakter for lektionen {$a->lesson}  er ændret til {$a->newgrade}%.</p>';
$string['essayemailmessagesmall'] = '<p>Du har opnået {$a->earned} ud af {$a->outof} for dette tekstsvar-spørgsmål.</p><p>Din karakter for lektionen {$a->lesson} er ændret til {$a->newgrade}%.</p>';
$string['essayemailsubject'] = 'Tilgængelig karakter for lektionsspørgsmål';
$string['essaynotgradedyet'] = 'Dette tekstsvar er ikke bedømt endnu';
$string['essayresponses'] = 'Respons på tekstsvar';
$string['essays'] = 'Tekstsvar';
$string['essayscore'] = 'Score for tekstsvar';
$string['eventcontentpageviewed'] = 'Indholdsside set';
$string['eventessayassessed'] = 'Tekstsvar vurderet';
$string['eventessayattemptviewed'] = 'Tekstbesvarelse set';
$string['eventhighscoreadded'] = 'Højeste point for lektion tilføjet';
$string['eventhighscoresviewed'] = 'Højeste point for lektion set';
$string['eventlessonended'] = 'Lektionen sluttede';
$string['eventlessonrestarted'] = 'Lektionen genstartet';
$string['eventlessonresumed'] = 'Lektionen fortsat';
$string['eventlessonstarted'] = 'Lektionen startet';
$string['eventoverridecreated'] = 'Undtagelse for lektion oprettet';
$string['eventoverridedeleted'] = 'Undtagelse for lektion slettet';
$string['eventoverrideupdated'] = 'Undtagelse for lektion opdateret';
$string['eventpagecreated'] = 'Side oprettet';
$string['eventpagedeleted'] = 'Side slettet';
$string['eventpagemoved'] = 'Side flyttet';
$string['eventpageupdated'] = 'Side opdateret';
$string['eventquestionanswered'] = 'Spørgsmål besvaret';
$string['eventquestionviewed'] = 'Spørgsmål set';
$string['false'] = 'Falsk';
$string['fileformat'] = 'Filformat';
$string['finalwrong'] = 'Ikke helt.';
$string['finish'] = 'Færdig';
$string['firstanswershould'] = 'Første svar skal springe til den "korrekte" side';
$string['firstwrong'] = 'Din besvarelse er ikke rigtig. Vil du prøve en gang mere? (Hvis du svarer rigtigt næste gang vil det ikke tælles med i din endelige karakter.)';
$string['flowcontrol'] = 'Forgreningskontrol';
$string['fractionsaddwrong'] = 'De positive bedømmelser giver ikke sammenlagt 100%
<br />I stedet giver de {$a}%
<br />Vil du vende tilbage og lave det om?';
$string['fractionsnomax'] = 'Et eller flere svar skal give 100%, så det er <br />muligt at få fuld bedømmelse for dette spørgsmål<br />Vil du vende tilbage og lave det om?';
$string['full'] = 'Udfoldet';
$string['general'] = 'Generelt';
$string['gotoendoflesson'] = 'Gå til slutningen af lektionen';
$string['gradebetterthan'] = 'Karakter højere end (&#37;)';
$string['gradebetterthanerror'] = 'Opnå en karakter bedre end {$a} procent';
$string['graded'] = 'Bedømt';
$string['gradeessay'] = 'Vurder tekstsvar ({$a->notgradedcount} ikke vurderet og {$a->notsentcount} ikke sendt)';
$string['gradeis'] = 'Vurderingen er {$a}';
$string['gradeoptions'] = 'Vurderingsindstillinger';
$string['groupoverrides'] = 'Gruppeundertagelser';
$string['groupoverridesdeleted'] = 'Gruppeundtagelser slettet';
$string['groupsnone'] = 'Der er ingen grupper du har adgang til';
$string['handlingofretakes'] = 'Bedømmelsesmetode';
$string['handlingofretakes_help'] = 'Hvordan karakteren beregnes, når studerende gennemfører lektionen mere end én gang:

* Højeste karakter fra alle forsøg
* Gennemsnitskarakter af alle forsøg';
$string['havenotgradedyet'] = 'Har endnu ikke vurderet.';
$string['here'] = 'her';
$string['highscore'] = 'Topscore';
$string['hightime'] = 'High time';
$string['importcount'] = 'Importerer {$a} spørgsmål';
$string['importquestions'] = 'Importer spørgsmål';
$string['importquestions_help'] = 'Denne funktion muliggør import af spørgsmål i en række formater via en tekst-fil.';
$string['inactiveoverridehelp'] = '* Denne tilsidesættelse er inaktiv fordi den studerendes adgang til aktiviteten er begrænset. Det kan skyldes gruppe- eller rolletildelinger, andre adgangsbegrænsninger, eller at aktiviteten er skjult.';
$string['indicator:cognitivedepth'] = 'Lektion kognitiv';
$string['indicator:cognitivedepth_help'] = 'Denne indikator er baseret på den kognitive dybde, som studenten har opnået i en lektionsaktivitet.';
$string['indicator:cognitivedepthdef'] = 'Lektion kognitiv';
$string['indicator:cognitivedepthdef_help'] = 'Deltageren har nået denne procentdel af det kognitive engagement, der tilbydes af lektionsaktiviteterne i løbet af denne analyseperiode (Niveauer = Ingen visning, Visning, Indsend, Se feedback, Kommenter på feedback, Genindsend efter at have set feedback)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Lektion social';
$string['indicator:socialbreadth_help'] = 'Denne indikator er baseret på den sociale bredde, som studenten har opnået i en lektionsaktivitet.';
$string['indicator:socialbreadthdef'] = 'Lektion social';
$string['indicator:socialbreadthdef_help'] = 'Deltageren har nået denne procentdel af det sociale engagement, der tilbydes af lektionsaktiviteterne i løbet af denne analyseperiode (Niveauer = Ingen deltagelse, Deltager alene, Deltager med andre)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['insertedpage'] = 'Indsat side';
$string['invalidfile'] = 'Ugyldig fil';
$string['invalidid'] = 'Intet kursusmodul-id eller leksions-id blev godkendt';
$string['invalidlessonid'] = 'lektion-id var forkert';
$string['invalidoverrideid'] = 'Ugyldig undtagelses-id';
$string['invalidpageid'] = 'Ugyldig side-ID';
$string['jump'] = 'Spring';
$string['jumps'] = 'Spring';
$string['jumps_help'] = 'Hvert svar (på spørgsmål) eller beskrivelse (på indholdssider) har et tilhørende spring. Springet kan være relativt, såsom "denne side" eller "næste side", eller absolut, med angivelse af en af siderne i lektionen.';
$string['jumpsto'] = 'Spring til <em>{$a}</em>';
$string['leftduringtimed'] = 'Du har forladt en tidsbegrænset lektion<br />Klik på fortsæt for genstarte lektionen.';
$string['leftduringtimednoretake'] = 'Du har forladt en tidsbegrænset lektion<br />Du kan ikke begynde forfra eller fortsætte lektionen.';
$string['leftduringtimedsession'] = 'Du har forladt en lektion med et krævet tidsforbrug.';
$string['lesson:addinstance'] = 'Tilføj en ny lektion';
$string['lesson:edit'] = 'Rediger en lektion';
$string['lesson:grade'] = 'Bedøm tekstsvar-spørgsmål';
$string['lesson:manage'] = 'Administrer en lektionsaktivitet';
$string['lesson:manageoverrides'] = 'Håndter lektionsundtagelser';
$string['lesson:view'] = 'Vis lektion';
$string['lesson:viewreports'] = 'Vis lektionsrapporter';
$string['lessonbeingpreviewed'] = 'Lektion forhåndsvises i øjeblikket.';
$string['lessonclosed'] = 'Denne lektion lukkede d. {$a}';
$string['lessoncloses'] = 'Lektionen lukker';
$string['lessoneventcloses'] = '{$a} lukker';
$string['lessoneventopens'] = '{$a} åbner';
$string['lessonformating'] = 'Lektionsformatering';
$string['lessonmenu'] = 'Lektionsmenu';
$string['lessonnotready'] = 'Denne lektion er endnu ikke klar. Kontakt din {$a}.';
$string['lessonnotready2'] = 'Denne lektion er ikke klar endnu.';
$string['lessonopen'] = 'Denne lektion vil åbne d. {$a}';
$string['lessonopens'] = 'Lektionen åbnes';
$string['lessonpagelinkingbroken'] = 'Første side mangler. Kontakt administrator.';
$string['lessonstats'] = 'Lektionsstatistik';
$string['linkedmedia'] = 'Linket mediefil';
$string['loginfail'] = 'Login fejlede, prøv igen..';
$string['lowscore'] = 'Lav score';
$string['lowtime'] = 'Kort tid';
$string['manageoverrides'] = 'Administrer overskridelser';
$string['manualgrading'] = 'Bedøm tekstsvar';
$string['matchesanswer'] = 'Passer med svar';
$string['matching'] = 'Matchende';
$string['matchingpair'] = 'Matchende par {$a}';
$string['maxgrade'] = 'Maksimal karakter';
$string['maxgrade_help'] = 'Indstillingen styrer den maksimale karakter for lektionen. Sættes den til 0, vil lektionen ikke optræde på karaktersiden.';
$string['maximumnumberofanswersbranches'] = 'Højeste antal svar';
$string['maximumnumberofanswersbranches_help'] = 'Indstillingen sætter højeste antal svar der kan forekomme i lektionen. Hvis der kun anvendes sand/falsk-spørgsmål er det kun nødvendigt med 2. Indstillingen kan ændres når som helst da den kun påvirker hvad læreren ser, ikke selve dataene.';
$string['maximumnumberofattempts'] = 'Maksimalt antal forsøg pr. spørgsmål';
$string['maximumnumberofattempts_help'] = 'Hvor mange gange en studerende kan forsøge at besvare hvert spørgsmål. Hvis grænsen nås uden et korrekt svar, fortsætter lektionen til næste side';
$string['maximumnumberofattemptsreached'] = 'Du har nået det maksimale antal forsøg for dette spørgsmål. Lektionen fortsætter nu til næste side';
$string['mediaclose'] = 'Vis lukke-knap';
$string['mediafile'] = 'Linket mediefil';
$string['mediafile_help'] = 'En mediefil kan uploades til brug i lektionen. Et "Klik her for at se mediefil"-link vil blive vist i en blok kaldet "Linket mediefil" på hver side i lektionen.';
$string['mediafilepopup'] = 'Klik her for at se mediefil';
$string['mediaheight'] = 'Højde på pop op-vindue';
$string['mediawidth'] = 'Bredde på pop op-vindue';
$string['messageprovider:graded_essay'] = 'Underretning om bedømt tekstsvar';
$string['minimumnumberofquestions'] = 'Mindste antal spørgsmål';
$string['minimumnumberofquestions_help'] = 'Denne indstilling styrer det mindste antal spørgsmål der vil blive brugt til beregning af karakteren for aktiviteten.';
$string['missingname'] = 'Skriv et kælenavn';
$string['modattempts'] = 'Tillad gennemsyn for studerende';
$string['modattempts_help'] = 'Er indstillingen aktiveret, kan studerende gennemse lektionen igen fra begyndelsen.';
$string['modattemptsnoteacher'] = 'Det er kun studerende der kan gennemse';
$string['modulename'] = 'Lektion';
$string['modulename_help'] = 'I lektionsmodulet kan lærere oprette undervisningsmateriale og/eller praktiske aktiviteter på interessante og fleksible måder.

En lærer kan bruge lektionsmodulet til at oprette et sæt lineære sider eller vejledninger, der tilbyder forskellige spørgsmål såsom multiple choice, match og kortsvar. Afhængig af den studerendes svar og hvordan læreren udvikler lektionen, kan studerende fortsætte til den næste side, føres tilbage til en foregående side eller til en helt anden gren.

En lektion kan vurderes og karakterer gemmes i karakterbogen.

Lektioner egner sig til

* Selvstudier
* Til scenarier eller simulationer/øvelser i beslutningstagning
* Til differentieret revision med forskellige sæt med revisionsspørgsmål afhængig af svar givet på indledende spørgsmål';
$string['modulename_link'] = 'mod/lesson/view';
$string['modulenameplural'] = 'Lektioner';
$string['move'] = 'Flyt siden';
$string['movedpage'] = 'Siden er flyttet';
$string['movepagehere'] = 'Flyt side hertil';
$string['movepagenamed'] = 'Flyt siden: {$a}';
$string['moving'] = 'Flytter side: {$a}';
$string['multianswer'] = 'Flere svar';
$string['multianswer_help'] = 'Marker afkrydsningsfeltet, hvis der er mere end ét rigtigt svar.';
$string['multichoice'] = 'Multichoice';
$string['multipleanswer'] = 'Flere svar';
$string['nameapproved'] = 'Navn godkendt';
$string['namereject'] = 'Dit navn er desværre blevet afvist af filteret<br />Prøv med et andet navn.';
$string['new'] = 'ny';
$string['nextpage'] = 'Næste side';
$string['noanswer'] = 'Et eller flere spørgsmål er ikke besvaret. Gå tilbage og aflever en besvarelse.';
$string['noattemptrecordsfound'] = 'Ingen forsøg fundet: Ingen vurdering givet.';
$string['nobranchtablefound'] = 'Ingen indholdsside fundet';
$string['noclose'] = 'Ingen lukkedato';
$string['nocommentyet'] = 'Ingen kommentarer endnu.';
$string['nocoursemods'] = 'Ingen aktiviteter er fundet';
$string['nocredit'] = 'Ingen point';
$string['nodeadline'] = 'Ingen afleveringsfrist';
$string['noessayquestionsfound'] = 'Der er ikke fundet spørgsmål af typen tekstsvar i denne lektion';
$string['nohighscores'] = 'Ingen topscore';
$string['nolessonattempts'] = 'Ingen har prøvet denne lektion';
$string['nolessonattemptsgroup'] = 'Ingen forsøg er udført af {$a} gruppemedlemmer i denne lektion';
$string['none'] = 'Ingen';
$string['nooneansweredcorrectly'] = 'Ingen korrekte svar.';
$string['nooneansweredthisquestion'] = 'Ingen har besvaret dette spørgsmål.';
$string['noonecheckedthis'] = 'Ingen har afkrydset dette.';
$string['nooneenteredthis'] = 'Ingen har skrevet noget';
$string['noonehasanswered'] = 'Ingen har endnu afleveret et tekstsvar';
$string['noonehasansweredgroup'] = 'Ingen i {$a} har endnu besvaret et tekstspørgsmål.';
$string['noopen'] = 'Ingen åbningsdato';
$string['nooverridecreated'] = 'Ingen overskridelser oprettet.';
$string['nooverridedata'] = 'Du skal overskrive mindst en indstilling i lektionen';
$string['noretake'] = 'Du har ikke mulighed for at gentage denne lektion';
$string['normal'] = 'Normal - følg lektionsplan';
$string['notcompleted'] = 'Ikke færdiggjort';
$string['notcompletedwithdate'] = 'Ikke gennemført ({$a})';
$string['notdefined'] = 'Ikke defineret';
$string['notenoughsubquestions'] = 'Der er ikke oprettet tilstrækkelige underspørgsmål';
$string['notenoughtimespent'] = 'Du har færdiggjort denne lektion på {$a->timespent}, det er mindre end den krævede tid på {$a->timerequired}. Du kan være nødt til at tage lektionen igen.';
$string['notgraded'] = 'Ikke bedømt';
$string['notitle'] = 'Ingen titel';
$string['notyetcompleted'] = 'Lektionen er påbegyndt, men endnu ikke gennemført';
$string['numberofcorrectanswers'] = 'Antal rigtige svar: {$a}';
$string['numberofcorrectanswersheader'] = 'Antal rigtige svar';
$string['numberofcorrectmatches'] = 'Antal korrekte match: {$a}';
$string['numberofpagestoshow'] = 'Antal sider der skal vises';
$string['numberofpagestoshow_help'] = 'Denne indstilling angiver antallet af sider der vises i en lektion. Indstillingen gælder kun lektioner med sider vist i en tilfældig rækkefølge (når "Handling efter rigtigt svar" er sat til "Vis en side der ikke har været vist før" eller "Vis en ubesvaret side"). Hvis værdien er sat til nul, vises alle sider.';
$string['numberofpagesviewed'] = 'Antal sider vist: {$a}';
$string['numberofpagesviewedheader'] = 'Antal besvarede spørgsmål';
$string['numberofpagesviewednotice'] = 'Antal besvarede spørgsmål: {$a->nquestions} (Du skal mindst besvare {$a->minquestions})';
$string['numerical'] = 'Numerisk';
$string['numericanswer'] = 'Numerisk svar';
$string['numericanswer_help'] = 'Du kan angive et enkelt tal eller et talområde ved at bruge kolon. For eksempel betyder 2:5, at ethvert svar mellem 2 og 5, inklusive 2 og 5, er korrekt.';
$string['offlinedatamessage'] = 'Du har arbejdet med dette forsøg ved brug af en mobil enhed. Data blev sidst gemt her på webstedet for {$a} siden. Tjek om du har arbejde der ikke er gemt.';
$string['ongoing'] = 'Vis løbende score';
$string['ongoing_help'] = 'Er indstillingen aktiveret, vil hver side vise den studerendes aktuelle point ud af det samlede mulige antal.';
$string['ongoingcustom'] = 'Du har indtil videre opnået {$a->score} ud af {$a->currenthigh} point';
$string['ongoingnormal'] = 'Du har besvaret {$a->correct} spørgsmål rigtigt ud af  {$a->viewed} viste.';
$string['onpostperpage'] = 'Kun et indlæg pr. karakter';
$string['openafterclose'] = 'Du har lagt åbningensdagen efter lukkedagen';
$string['options'] = 'Valgmuligheder';
$string['or'] = 'ELLER';
$string['ordered'] = 'Orden';
$string['other'] = 'Andre';
$string['outof'] = 'Ud af {$a}';
$string['override'] = 'Tilsidesæt';
$string['overridedeletegroupsure'] = 'Bekræft at du vil slette undtagelsen for gruppen {$a}.';
$string['overridedeleteusersure'] = 'Bekræft at du vil slette undtagelsen for brugeren {$a}.';
$string['overridegroup'] = 'Undtagelse for gruppe';
$string['overridegroupeventname'] = '{$a->lesson} - {$a->group}';
$string['overrides'] = 'Undtagelser';
$string['overrideuser'] = 'Undtagelse for bruger';
$string['overrideusereventname'] = '{$a->lesson} - Undtagelse';
$string['overview'] = 'Oversigt';
$string['overview_help'] = 'En lektion består af et antal sider og eventuelt "indholdssider".
Indholdet på en side ender som regel med et spørgsmål. Til hvert spørgsmål er knyttet et spring. Springet kan være relativt såsom denne side/næste side, eller det kan være absolut til en specifik anden side i lektionen.
En indholdside er en side med links til andre sider i lektionen, for eksempel en side med indholdsfortegnelse.';
$string['page'] = 'Side: {$a}';
$string['page-mod-lesson-edit'] = 'Rediger lektionsside';
$string['page-mod-lesson-view'] = 'Vis eller forhåndsvis lektionssiden';
$string['page-mod-lesson-x'] = 'Enhver lektionsside';
$string['pageanswers'] = 'Sidesvar';
$string['pagecontents'] = 'Sideindhold';
$string['pageresponses'] = 'Sideresponser';
$string['pages'] = 'Sider';
$string['pagetitle'] = 'Sidetitel';
$string['password'] = 'Adgangskode';
$string['passwordprotectedlesson'] = '{$a} er beskyttet af en kode';
$string['pleasecheckoneanswer'] = 'Vælg et svar';
$string['pleasecheckoneormoreanswers'] = 'Afkryds et eller flere svar';
$string['pleaseenteryouranswerinthebox'] = 'Skriv dit svar i feltet';
$string['pleasematchtheabovepairs'] = 'Match de ovenstående par';
$string['pluginadministration'] = 'Lektionsadministration';
$string['pluginname'] = 'Lektion';
$string['pointsearned'] = 'Optjente point';
$string['postprocesserror'] = 'Der opstod en fejl under efterbehandlingen!';
$string['postsuccess'] = 'Sendt';
$string['practice'] = 'Øvelseslektion';
$string['practice_help'] = 'En øvelseslektion vil ikke figurere i karakterbogen.';
$string['preprocesserror'] = 'Der opstod en fejl under forbehandlingen!';
$string['prerequisiteisobsolete'] = 'Kravene til at deltage i en lektion vil blive slettet. Brug betinget adgang i stedet.';
$string['prerequisitelesson'] = 'Lektionsforudsætninger';
$string['preview'] = 'Forhåndsvisning';
$string['previewlesson'] = 'Forhåndsvis {$a}';
$string['previewpagenamed'] = 'Forhåndsvis side: {$a}';
$string['previouspage'] = 'Forrige side';
$string['privacy:metadata:attempts'] = 'En registrering af sideforsøg';
$string['privacy:metadata:attempts:answerid'] = 'Svar-id';
$string['privacy:metadata:attempts:correct'] = 'Hvorvidt svaret var korrekt';
$string['privacy:metadata:attempts:pageid'] = 'Side-id';
$string['privacy:metadata:attempts:retry'] = 'Forsøgsnummer';
$string['privacy:metadata:attempts:timeseen'] = 'Hvornår der blev besvaret';
$string['privacy:metadata:attempts:useranswer'] = 'Data om brugerens svar';
$string['privacy:metadata:attempts:userid'] = 'Bruger-id';
$string['privacy:metadata:branch'] = 'Fortegnelse over sete sider';
$string['privacy:metadata:branch:flag'] = 'Hvorvidt næste side blev tilfældigt beregnet';
$string['privacy:metadata:branch:nextpageid'] = 'Næste side-id';
$string['privacy:metadata:branch:pageid'] = 'Side-id';
$string['privacy:metadata:branch:retry'] = 'Nummer på forsøg på besvarelse';
$string['privacy:metadata:branch:timeseen'] = 'Hvornår siden blev set';
$string['privacy:metadata:branch:userid'] = 'Bruger-id';
$string['privacy:metadata:grades'] = 'Fortegnelse med karakterer for hver lektion';
$string['privacy:metadata:grades:completed'] = 'Hvornår karakteren blev givet';
$string['privacy:metadata:grades:grade'] = 'Opnået karakter';
$string['privacy:metadata:grades:userid'] = 'Bruger-id';
$string['privacy:metadata:overrides'] = 'En registrering af overskridelser per lektion';
$string['privacy:metadata:overrides:available'] = 'Hvornår besvarelser i lektionen kan påbegyndes';
$string['privacy:metadata:overrides:deadline'] = 'Deadline for færdiggørelse af lektionen.';
$string['privacy:metadata:overrides:maxattempts'] = 'Højeste antal besvarelsesforsøg';
$string['privacy:metadata:overrides:password'] = 'Adgangskode til lektionen';
$string['privacy:metadata:overrides:retake'] = 'Hvorvidt gentagne besvarelsesforsøg accepteres';
$string['privacy:metadata:overrides:review'] = 'Hvorvidt et spørgsmål kan forsøges besvaret mere end en gang';
$string['privacy:metadata:overrides:timelimit'] = 'Tidsgrænse i sekunder for færdiggørelse af lektionen.';
$string['privacy:metadata:overrides:userid'] = 'Bruger-id';
$string['privacy:metadata:timer'] = 'En post med et besvarelsesforsøg i lektionen';
$string['privacy:metadata:timer:completed'] = 'Hvorvidt lektionen er færdiggjort';
$string['privacy:metadata:timer:lessontime'] = 'Hvornår vi sidst registrerede aktivitet';
$string['privacy:metadata:timer:starttime'] = 'Hvornår besvarelsen blev påbegyndt';
$string['privacy:metadata:timer:timemodifiedoffline'] = 'Hvornår vi sidst registrerede aktivitet i mobilappen';
$string['privacy:metadata:timer:userid'] = 'Bruger-id';
$string['privacy:metadata:userpref:lessonview'] = 'Den foretrukne visning ved redigering af lektioner';
$string['privacy:path:essayanswers'] = 'Essaysvar';
$string['privacy:path:essayresponses'] = 'Tekst-svar';
$string['privacy:path:pages'] = 'Sider';
$string['processerror'] = 'Der opstod en fejl under behandlingen!';
$string['progressbar'] = 'Vis progressionslinje';
$string['progressbar_help'] = 'Hvis indstillingen er aktiveret, vil hver side nederst have en linje der viser den omtrentlige aktuelle procentdel der er gjort færdig.';
$string['progressbarteacherwarning'] = 'Progressionslinje vises ikke for {$a}';
$string['progressbarteacherwarning2'] = 'Du kan ikke se progressionslinjen da ud kan redigere lektionen';
$string['progresscompleted'] = 'Du har gennemført {$a}% af lektionen';
$string['qtype'] = 'Sidetype';
$string['question'] = 'Spørgsmål';
$string['questionoption'] = 'Spørgsmålsmuligheder';
$string['questiontype'] = 'Spørgsmålstype';
$string['randombranch'] = 'Tilfældig indholdsside';
$string['randompageinbranch'] = 'Tilfældigt spørgsmål på en indholdsside';
$string['rank'] = 'Rank';
$string['rawgrade'] = 'Rå point';
$string['receivedcredit'] = 'Optjente point';
$string['redisplaypage'] = 'Vis siden igen';
$string['removeallgroupoverrides'] = 'Alle gruppeoverskridelser';
$string['removealluseroverrides'] = 'Alle brugerundtagelser';
$string['report'] = 'Rapport';
$string['reports'] = 'Rapporter';
$string['response'] = 'Respons';
$string['retakesallowed'] = 'Tillad flere forsøg';
$string['retakesallowed_help'] = 'Tillad studerende at gennemføre lektionen mere end én gang';
$string['retakesallowedinfo'] = 'Denne lektion tillader studerende at gennemføre den mere end én gang';
$string['returnto'] = 'Returner til {$a}';
$string['returntocourse'] = 'Returner til kurset';
$string['reverttodefaults'] = 'Vend tilbage til standarder for lektioner';
$string['review'] = 'Prøv igen';
$string['reviewlesson'] = 'Prøv en gang mere';
$string['reviewquestionback'] = 'Ja, jeg vil gerne prøve igen';
$string['reviewquestioncontinue'] = 'Nej, jeg vil bare videre til næste spørgsmål';
$string['sanitycheckfailed'] = 'Der er noget helt galt!!! Dette besvarelse er blevet slettet.';
$string['save'] = 'Gem';
$string['savechanges'] = 'Gem ændringer';
$string['savechangesandeol'] = 'Gem alle ændringer og gå til slutningen på lektionen';
$string['saveoverrideandstay'] = 'Gem og opret en ny undtagelse';
$string['savepage'] = 'Gem side';
$string['score'] = 'Score';
$string['score_help'] = 'Hvis tilpasset scoring er aktiveret i lektionsindstillingerne, kan en hel talværdi (positiv eller negativ) indtastes for hvert svar.';
$string['scores'] = 'Score';
$string['search:activity'] = 'Lektion - aktivitetsinformation';
$string['secondpluswrong'] = 'Ikke rigtigt. Vil du prøve en gang mere?';
$string['selectallattempts'] = 'Vælg alle besvarelser';
$string['selectaqtype'] = 'Vælg en spørgsmålstype';
$string['selectreport'] = 'Vælg rapport';
$string['sent'] = 'Sendt';
$string['shortanswer'] = 'Kort-svar';
$string['showanunansweredpage'] = 'Vis en ubesvaret side';
$string['showanunseenpage'] = 'Vis en side der ikke har været vist før';
$string['singleanswer'] = 'Enkelt svar';
$string['skip'] = 'Udelad navigation';
$string['slideshow'] = 'Diasshow';
$string['slideshow_help'] = 'Er indstillingen aktiveret, vises lektionen som et lysbilledshow med fast bredde og højde.';
$string['slideshowbgcolor'] = 'Diasshow, baggrundsfarve';
$string['slideshowheight'] = 'Diasshow, højde';
$string['slideshowwidth'] = 'Diasshow, bredde';
$string['startlesson'] = 'Start lektion';
$string['studentattemptlesson'] = '{$a->firstname} {$a->lastname}s forsøg nummer {$a->attempt}';
$string['studentname'] = '{$a} Navn';
$string['studentoneminwarning'] = 'Bemærk: Du har et minut til at færdiggøre lektionen.';
$string['studentoutoftimeforreview'] = 'OBS: Du udløb for tid til gennemsyn af lektionen';
$string['studentresponse'] = '{$a}s respons';
$string['studentswhoattempted'] = 'Studerende der har forsøgt';
$string['submit'] = 'Aflever';
$string['submitname'] = 'Gem navn';
$string['teacherjumpwarning'] = 'Et {$a->cluster}-spring eller et {$a->unseen}-spring bliver benyttet i denne lektion. Springet "Næste side" vil blive brugt i stedet. Log ind som studerende for at teste disse spring.';
$string['teacherongoingwarning'] = 'Løbende score vises kun for den studerende. Log ind som studerende for at teste løbende score.';
$string['teachertimerwarning'] = 'Timeren virker kun for studerende. Du kan teste det ved at logge ind som studerende.';
$string['thatsthecorrectanswer'] = 'Rigtigt svar!  :-)';
$string['thatsthewronganswer'] = 'Desværre, svaret er forkert.';
$string['thefollowingpagesjumptothispage'] = 'De følgende sider linker til denne side';
$string['thispage'] = 'Denne side';
$string['timeisup'] = 'Tiden er gået';
$string['timelimit'] = 'Tidsgrænse';
$string['timelimit_help'] = 'Er indstillingen aktiveret, gives en advarsel om tidsbegrænsningen i begyndelsen af lektionen og et nedtællingsur vises. Svar afgivet efter tidens udløb bedømmes ikke.';
$string['timelimitwarning'] = 'Du har {$a} til at færdiggøre lektionen';
$string['timeremaining'] = 'Tid tilbage';
$string['timespenterror'] = 'Brug mindst {$a} minutter på lektionen';
$string['timespentminutes'] = 'Antal minutter brugt';
$string['timetaken'] = 'Varighed';
$string['totalattepmts'] = 'Samlede forsøg';
$string['totalpagesviewedheader'] = 'Antal sider set';
$string['true'] = 'Sandt';
$string['truefalse'] = 'Sand/Falsk';
$string['unabledtosavefile'] = 'Din uploadede fil kunne ikke gemmes';
$string['unknownqtypesnotimported'] = '{$a} spørgsmål med ikke-understøttede spørgsmålstyper er ikke importeret';
$string['unseenpageinbranch'] = 'Usete spørgsmål på en indholdsside';
$string['unsupportedqtype'] = 'Spørgsmålstypen er ikke understøttet ({$a})';
$string['updatedpage'] = 'Side opdateret';
$string['updatefailed'] = 'Opdatering fejlede';
$string['updatepagenamed'] = 'Opdaterer siden: {$a}';
$string['usemaximum'] = 'Højeste karakter fra alle forsøg';
$string['usemean'] = 'Gennemsnitskarakter af alle forsøg';
$string['usepassword'] = 'Kodebeskyttet lektion';
$string['usepassword_help'] = 'Er indstillingen aktiveret, vil adgang til lektionen kræve en adgangskode.';
$string['useroverrides'] = 'Brugerundtagelser';
$string['useroverridesdeleted'] = 'Brugerundtagelser er slettet';
$string['usersnone'] = 'Ingen studerende har adgang til denne lektion';
$string['view'] = 'Vis';
$string['viewessayanswers'] = 'Se tekstsvar';
$string['viewgrades'] = 'Vis karakterer';
$string['viewreports'] = 'Vis {$a->attempts} gennemførte {$a->student} forsøg';
$string['viewreports2'] = 'Vis {$a} afsluttede forsøg';
$string['warning'] = 'Advarsel';
$string['welldone'] = 'Flot klaret!';
$string['whatdofirst'] = 'Hvad vil du gøre først?';
$string['withselectedattempts'] = 'Med valgte besvarelser...';
$string['wronganswerjump'] = 'Spring ved forkert svar';
$string['wronganswerscore'] = 'Forkert svarscore';
$string['wrongresponse'] = 'Respons på forkert svar';
$string['youhaveseen'] = 'Du har allerede set mere end en side af denne lektion. <br />Ønsker du at starte på den sidste side du så?';
$string['youranswer'] = 'Dit svar';
$string['yourcurrentgradeis'] = 'Den nuværende karakter er: {$a}';
$string['yourcurrentgradeisoutof'] = 'Din totale score er {$a->grade} ud af {$a->total}';
$string['youshouldview'] = 'Du skulle se mindst: {$a}';
