<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'data', language 'da', version '5.1'.
 *
 * @package     data
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Handling';
$string['actionsmenu'] = 'Handlingsmenu';
$string['add'] = 'Tilføj indtastning';
$string['addcomment'] = 'Tilføj kommentar';
$string['addtemplate'] = 'Tilføj skabelon for indtastning';
$string['advancedsearch'] = 'Avanceret søgning';
$string['allowcomments'] = 'Tillad kommentarer på indlæg';
$string['alttext'] = 'Alternativ tekst';
$string['approvalstatus'] = 'Godkendelsesstatus';
$string['approve'] = 'Godkend';
$string['approved'] = 'Godkendt';
$string['areacontent'] = 'Felter';
$string['ascending'] = 'Stigende';
$string['asearchtemplate'] = 'Avanceret søgeskabelon';
$string['atmaxentry'] = 'Du har indtastet det maksimale antal tilladte indtastninger!';
$string['authorfirstname'] = 'Fornavn';
$string['authorlastname'] = 'Efternavn';
$string['autogenallforms'] = 'Generer alle standard skabeloner';
$string['autolinkurl'] = 'Autolink URL\'en';
$string['availablefromdate'] = 'Tilgængelig fra';
$string['availabletags'] = 'Tilgængelige tags';
$string['availabletags_help'] = 'Variable er pladsholdere der vil blive erstattet af data eller andet, f.eks. et redigeringsikon, når poster vises.

Datafelter har formatet [[feltnavn]].  Andre variable har formatet ##variabelnavn##.

Kun variable, der er i listen med "Tilgængelige variable", kan bruges i skabelonen.';
$string['availabletodate'] = 'Tilgængelig for';
$string['availabletodatevalidation'] = 'Den tilgængelige slutdato kan ikke være før den tilgængelige startdato.';
$string['bynameondate'] = 'af {$a->name} - {$a->date}';
$string['calendarend'] = '{$a} lukker';
$string['calendarstart'] = '{$a} åbner';
$string['cancel'] = 'Annuller';
$string['cannotaccesspresentsother'] = 'Du har ikke tilladelse til at få adgang til præferencer fra andre brugere';
$string['cannotadd'] = 'Kan ikke tilføje poster!';
$string['cannotapplypreset'] = 'Fejl ved anvendelse af forudindstillingen.';
$string['cannotdeletepreset'] = 'Fejl ved sletning af forudindstilling';
$string['cannotoverwritepreset'] = 'Fejl ved overskrivning af forudindstilling';
$string['cannotunziptopreset'] = 'Kan ikke udpakkes til den forudindstillede mappe';
$string['checkbox'] = 'Afkrydsningsfelter';
$string['chooseexportfields'] = 'Vælg de felter, du ønsker at eksportere';
$string['chooseexportformat'] = 'Vælg det format, du ønsker at eksportere til';
$string['chooseorupload'] = 'Vælg fil';
$string['choosepreset'] = 'Prækonfigureret fil';
$string['closebeforeopen'] = 'Du har angivet en slutdato før startdatoen.';
$string['columns'] = 'kolonner';
$string['comment'] = 'Kommentar';
$string['commentdeleted'] = 'Kommentar slettet';
$string['commentempty'] = 'Kommentaren var tom';
$string['comments'] = 'Kommentarer';
$string['commentsaved'] = 'Kommentar gemt';
$string['commentsn'] = '{$a} kommentar(er)';
$string['commentsoff'] = 'Kommentarfunktionen er ikke aktiveret';
$string['completiondetail:entries'] = 'Lav indtastninger: {$a}';
$string['completionentriescount'] = 'Tilføj poster';
$string['completionentriesdesc'] = 'Minimum antal indtastninger krævet: {$a}';
$string['configenablerssfeeds'] = 'Denne kontakt vil muliggøre RSS-feeds for alle databaser. Du skal stadig aktivere feeds manuelt i indstillingerne for hver database.';
$string['confirmdeletefield'] = 'Du er ved at slette dette felt, er du sikker?';
$string['confirmdeleterecord'] = 'Er du sikker på, at du vil slette denne post?';
$string['confirmdeleterecords'] = 'Er du sikker på, at du vil slette disse poster?';
$string['createactivity'] = 'Opret dine egne felter til at indsamle data, eller brug en forudindstilling som allerede inkluderer felter.';
$string['createfields'] = 'Opret felter til at indsamle forskellige typer data.';
$string['createtemplates'] = 'Skabeloner definerer grænsefladen for din aktivitet. Når du opretter felter, vil skabeloner blive oprettet automatisk. Alternativt kan du bruge en forudindstilling, som inkluderer felter og skabeloner.';
$string['csstemplate'] = 'Brugerdefineret CSS';
$string['csvfailed'] = 'Det er ikke muligt at læse de rå data fra CSV-filen';
$string['csvfile'] = 'CSV eller ZIP der indeholder en CSV-fil';
$string['csvimport'] = 'Import af CSV-fil';
$string['csvimport_help'] = 'Posteringer kan importeres via en almindelig tekstfil med en liste over feltnavne som den første linje, derefter dataene, med én post pr. linje.';
$string['csvwithselecteddelimiter'] = '<abbr title="Comma Separated Values">CSV</abbr>';
$string['data:addinstance'] = 'Tilføj en ny database';
$string['data:approve'] = 'Godkend og fortryd godkendte indtastninger';
$string['data:comment'] = 'Skriv kommentarer';
$string['data:exportallentries'] = 'Eksporter alle databaseposter';
$string['data:exportentry'] = 'Eksportér en databasepost';
$string['data:exportownentry'] = 'Eksporter egen databasepost';
$string['data:exportuserinfo'] = 'Eksportér brugerinformation';
$string['data:managecomments'] = 'Administrer kommentarer';
$string['data:manageentries'] = 'Administrer indtastninger';
$string['data:managetemplates'] = 'Administrer skabeloner';
$string['data:manageuserpresets'] = 'Administrer forudindstillinger';
$string['data:rate'] = 'Vurder indtastninger';
$string['data:readentry'] = 'Læs indlæg';
$string['data:view'] = 'Vis databaseaktivitet';
$string['data:viewallratings'] = 'Se alle rå vurderinger givet af enkeltpersoner';
$string['data:viewalluserpresets'] = 'Vis præferencer fra alle brugere';
$string['data:viewanyrating'] = 'Se de samlede vurderinger, som nogen har modtaget';
$string['data:viewentry'] = 'Vis indlæg';
$string['data:viewrating'] = 'Se den samlede bedømmelse, du har modtaget';
$string['data:writeentry'] = 'Skriv indlæg';
$string['date'] = 'Dato';
$string['dateentered'] = 'Dato indtastet';
$string['datemodified'] = 'Sidst redigeret:';
$string['defaultfielddelimiter'] = '(standard er komma-tegnet)';
$string['defaultfieldenclosure'] = '(standard er ingen)';
$string['defaultsortfield'] = 'Standard sorteringsfelt';
$string['delcheck'] = 'Bulk sletningsafkrydsningsfelt';
$string['delete'] = 'Slet';
$string['deleteallentries'] = 'Alle indtastninger';
$string['deletecomment'] = 'Er du sikker på, at du vil slette denne kommentar?';
$string['deleteconfirm'] = 'Slet forudindstilling {$a}?';
$string['deleted'] = 'slettet';
$string['deleteentry'] = 'Slet post';
$string['deletefield'] = 'Slet felt';
$string['deletenotenrolled'] = 'Indlæg fra brugere, der ikke er tilmeldt';
$string['deletewarning'] = 'Sletning af en forudindstilling fjerner den fra listen over tilgængelige forudindstillinger i alle kurser.';
$string['descending'] = 'Faldende';
$string['directorynotapreset'] = '{$a->directory} Ikke en forudindstilling: manglende filer: {$a->missing_files}';
$string['disapprove'] = 'Fortryd godkendelse';
$string['download'] = 'Download';
$string['duedate'] = 'Afleveringsfrist';
$string['edit'] = 'Rediger';
$string['editcomment'] = 'Rediger kommentar';
$string['editentry'] = 'Rediger indlæg';
$string['editfield'] = 'Rediger felt';
$string['editordisable'] = 'Deaktiver editor';
$string['editorenable'] = 'Aktiver kodeeditor';
$string['editpreset'] = 'Rediger forudindstilling';
$string['emptyadd'] = 'Skabelonen til tilføjelse er tom, der genereres en standardformular...';
$string['emptyaddform'] = 'Du udfyldte ikke nogle felter!';
$string['emptypresetname'] = 'Navnet på præindstillingen eller filen kan ikke være tomt';
$string['enabletemplateeditorcheck'] = 'Er du sikker på, at du vil aktivere redaktøren? Dette kan medføre, at indholdet ændres, når skabelonen gemmes.';
$string['entries'] = 'Indtastninger';
$string['entrieslefttoadd'] = 'Du skal tilføje {$a->entriesleft} flere indlæg for at fuldføre denne aktivitet.';
$string['entrieslefttoaddtoview'] = 'Du skal tilføje {$a->entrieslefttoview} flere indlæg, før du kan se andre deltageres indlæg.';
$string['entry'] = 'Indgang';
$string['entrysaved'] = 'Din indtastning er blevet gemt';
$string['errordatafilenotfound'] = 'Filen kunne ikke importeres. Accepterede filtyper er CSV eller en ZIP, der indeholder en CSV-fil i det format, der anvendes til eksport af poster.';
$string['errormustbeteacher'] = 'Du skal være lærer for at bruge denne side!';
$string['errormustsupplyvalue'] = 'Du skal angive en værdi her.';
$string['errorpresetexists'] = 'En forudindstilling med dette navn eksisterer allerede.';
$string['errorpresetexistsbutnotoverwrite'] = 'Der findes allerede en forudindstilling med dette navn. Vælg et andet navn.';
$string['errorpresetnotfound'] = 'Forudindstilling med navnet {$a} blev ikke fundet.';
$string['eventfieldcreated'] = 'Felt oprettet';
$string['eventfielddeleted'] = 'Felt slettet';
$string['eventfieldupdated'] = 'Felt opdateret';
$string['eventrecordcreated'] = 'Posten er oprettet';
$string['eventrecorddeleted'] = 'Posten er slettet';
$string['eventrecordupdated'] = 'Posten er opdateret';
$string['eventtemplateupdated'] = 'Skabelon opdateret';
$string['eventtemplateviewed'] = 'Skabeloner vist';
$string['example'] = 'Eksempel på database modul';
$string['excel'] = 'Excel';
$string['expired'] = 'Beklager, denne aktivitet lukkede den {$a} og er ikke længere tilgængelig';
$string['export'] = 'Eksport';
$string['exportaszip'] = 'Eksporter som zip';
$string['exportaszip_help'] = 'Funktionen til eksport som zip giver dig mulighed for at gemme skabelonerne og felterne som en forudindstillet zip til download. Zip-filen kan derefter importeres til et andet kursus.';
$string['exportedtozip'] = 'Eksporteret til midlertidig zip...';
$string['exportentries'] = 'Eksportér poster';
$string['exportformat'] = 'Eksportformat';
$string['exportoptions'] = 'Eksportmuligheder';
$string['exportownentries'] = 'Eksporter kun dine egne indtastninger? ({$a->mine}/{$a->all})';
$string['exportpreset'] = 'Eksportforudindstilling';
$string['failedpresetdelete'] = 'Der opstod en fejl under forsøget på at slette præindstillingen.';
$string['fieldadded'] = 'Felt tilføjet';
$string['fieldallowautolink'] = 'Tillad autolink';
$string['fielddeleted'] = 'Felt slettet';
$string['fielddelimiter'] = 'Feltseparator';
$string['fielddescription'] = 'Feltbeskrivelse';
$string['fieldenclosure'] = 'Feltindhegning';
$string['fieldheight'] = 'Højde';
$string['fieldheightlistview'] = 'Højde (i pixels) i listevisning';
$string['fieldheightsingleview'] = 'Højde (i pixels) i enkelt visning';
$string['fieldmappings'] = 'Feltkortlægninger';
$string['fieldmappings_help'] = 'Denne menu giver dig mulighed for at bevare data fra den eksisterende database. For at bevare data i et felt skal du først knytte det til et nyt felt, hvor data vises. Alle felter kan også efterlades tomme uden data kopieret ind i dem. Ethvert gammelt felt som ikke er tilknyttet et nyt, vil gå tabt og alle data fjernes.
Du kan kun tilknytte felter af samme type, så hver rullemenu vil have forskellige felter. Du skal også være varsom med ikke at tilknytte et gammelt felt til mere end et nyt felt.';
$string['fieldname'] = 'Felt navn';
$string['fieldnametype'] = '{$a->name} ({$a->type})';
$string['fieldnotmatched'] = 'Følgende felter i din fil er ikke kendt i denne database: {$a}';
$string['fieldoptions'] = 'Muligheder (en pr. linje)';
$string['fields'] = 'Felter';
$string['fieldshelp'] = 'Opret felter for at indsamle forskellige typer data. Felter definerer strukturen af indlæggene i din database.';
$string['fieldsinformationtags'] = 'Feltinformation';
$string['fieldsnavigation'] = 'Felter til tertiær navigation';
$string['fieldtagdescription'] = '{$a} beskrivelse';
$string['fieldtagid'] = '{$a} ID';
$string['fieldtagname'] = '{$a} navn';
$string['fieldupdated'] = 'Felt opdateret';
$string['fieldwidth'] = 'Bredde';
$string['fieldwidthlistview'] = 'Bredde (i pixels) i listevisning';
$string['fieldwidthsingleview'] = 'Bredde (i pixels) i enkeltvisning';
$string['file'] = 'Fil';
$string['fileencoding'] = 'Kodning';
$string['filesnotgenerated'] = 'Ikke alle filer blev genereret: {$a}';
$string['filtername'] = 'Automatisk linking af database';
$string['footer'] = 'Footer';
$string['forcelinkname'] = 'Tvangsnavn for linket';
$string['foundnorecords'] = 'Ingen poster fundet. <a href="{$a->reseturl}">Ryd alt</a>';
$string['foundrecords'] = 'Fundet {$a->num} ud af {$a->max} poster. <a href="{$a->reseturl}">Ryd alle</a>';
$string['fromfile'] = 'Importér fra zip-fil';
$string['fromfile_help'] = 'Funktionen til import fra zip-fil giver dig mulighed for at gennemse og uploade en forudindstillet zip med skabeloner og felter.';
$string['generateerror'] = 'Ikke alle filer blev genereret!';
$string['header'] = 'Overskrift';
$string['headeraddtemplate'] = 'Definer grænsefladen for at tilføje eller redigere poster.';
$string['headerasearchtemplate'] = 'Definer grænsefladen for den avancerede søgning.';
$string['headercsstemplate'] = 'Tilføj brugerdefineret CSS til skabeloner.';
$string['headerjstemplate'] = 'Tilføj brugerdefineret JavaScript til skabelonerne for Liste, Enkelt eller Tilføj post.';
$string['headerlisttemplate'] = 'Definer udseendet af listevisning.';
$string['headerrsstemplate'] = 'Definer udseendet af poster i RSS-feeds.';
$string['headersingletemplate'] = 'Definer udseendet af enkeltvisning.';
$string['id'] = 'Indgangs-ID';
$string['importandapply'] = 'Importer forudindstilling og anvend';
$string['importapreset'] = 'Importer en forudindstilling';
$string['importentries'] = 'Importér poster';
$string['importpreset'] = 'Importer forudindstilling';
$string['importpreset_desc'] = 'The preset will be applied to this activity, creating fields and templates.
 It won\'t appear in the list of presets.';
$string['importpresetmissingcapability'] = 'Du har ikke tilladelse til at importere en forudindstilling.';
$string['importsuccess'] = 'Præindstilling anvendt.';
$string['includeapproval'] = 'Inkluder godkendelsesstatus';
$string['includefiles'] = 'Inkluder filer i eksport';
$string['includetags'] = 'Inkluder tags';
$string['includetime'] = 'Inkluder tid tilføjet/ændret';
$string['includeuserdetails'] = 'Inkluder brugeroplysninger';
$string['indicator:cognitivedepth'] = 'Database kognitiv';
$string['indicator:cognitivedepth_help'] = 'Denne indikator er baseret på den kognitive dybde, som eleven har nået i en Database-aktivitet.';
$string['indicator:cognitivedepthdef'] = 'Database kognitiv';
$string['indicator:cognitivedepthdef_help'] = 'Deltageren har nået denne procentdel af den kognitive engagement, der tilbydes af Database-aktiviteterne i løbet af dette analyseinterval (Niveauer = Ingen visning, Visning, Aflevering)';
$string['indicator:cognitivedepthdef_link'] = 'Læringsanalyseindikatorer#Kognitiv_dybde';
$string['indicator:socialbreadth'] = 'Database social';
$string['indicator:socialbreadth_help'] = 'Denne indikator er baseret på den sociale bredde, som eleven har opnået i en Database aktivitet.';
$string['indicator:socialbreadthdef'] = 'Database social';
$string['indicator:socialbreadthdef_help'] = 'Deltageren har nået denne procentdel af den sociale engagement, der tilbydes af Database-aktiviteterne i løbet af dette analyseinterval (Niveauer = Ingen deltagelse, Deltager alene)';
$string['indicator:socialbreadthdef_link'] = 'Læringsanalyseindikatorer#Social_bredde';
$string['insufficiententries'] = 'flere poster er nødvendige for at se denne database';
$string['intro'] = 'Beskrivelse';
$string['invalidaccess'] = 'Denne side blev ikke tilgået korrekt';
$string['invalidfieldid'] = 'Feltnummeret er forkert';
$string['invalidfieldname'] = 'Vær venlig at vælge et andet navn til dette felt';
$string['invalidfieldtype'] = 'Feltetype er forkert';
$string['invalidid'] = 'Ugyldigt data-ID';
$string['invalidpreset'] = '{$a} er ikke en forudindstilling.';
$string['invalidrecord'] = 'Forkert post';
$string['invalidurl'] = 'Den URL, du lige har indtastet, er ikke gyldig';
$string['jstemplate'] = 'Brugerdefineret JavaScript';
$string['latitude'] = 'Breddegrad';
$string['latlong'] = 'Koordinater';
$string['latlongboth'] = 'Både breddegrad og længdegrad er påkrævet.';
$string['latlongdownloadallhint'] = 'Download link til alle indtastninger som KML';
$string['latlongkmllabelling'] = 'Sådan mærker du elementer i KML-filer (Google Earth)';
$string['latlonglinkservicesdisplayed'] = 'Link-out tjenester til visning';
$string['latlongotherfields'] = 'Andre felter';
$string['list'] = 'Vis liste';
$string['listtemplate'] = 'Skabelon til listevisning';
$string['listview'] = 'Listevisning';
$string['longitude'] = 'Længdegrad';
$string['manageapproved'] = 'Tillad redigering af godkendte indtastninger';
$string['manageapproved_help'] = 'Tillad studerende at redigere eller slette deres indlæg, efter de er blevet godkendt. Redigerede indlæg skal gen-godkendes.';
$string['managefields'] = 'Administrer felter';
$string['mapexistingfield'] = 'Kortlæg til {$a}';
$string['mapnewfield'] = 'Opret et nyt felt';
$string['mapping:applypresets'] = 'Anvend forudindstilling';
$string['mapping:dialogtitle:usepreset'] = 'Anvend forudindstilling {$a}?';
$string['mapping:fieldstocreate'] = 'Felter der skal oprettes: {$a}';
$string['mapping:fieldstodelete'] = 'Eksisterende felter der skal slettes: {$a}';
$string['mapping:mapfields'] = 'Kortlæg felter';
$string['mapping:warningmessagedelete'] = 'Hvis felterne, der skal slettes, er af samme type som de nye felter i den forudindstillede skabelon, du anvender, kan du muligvis kortlægge dem i Kortlæg felter.';
$string['mapping:warningmessagedeleteandcreate'] = 'Hvis felterne, der skal slettes, er af samme type som felterne, der skal oprettes, kan du muligvis kortlægge dem i Kortlæg felter.';
$string['mappingwarning'] = 'Alle gamle felter, der ikke er kortlagt til et nyt felt, vil gå tabt, og alle data i det felt vil blive fjernet.';
$string['maxentries'] = 'Maksimalt antal indlæg';
$string['maxentries_help'] = 'Det maksimale antal afleveringer, en studerende har lov til at indsende til denne aktivitet.';
$string['maxsize'] = 'Maksimal størrelse';
$string['menu'] = 'Menu';
$string['menuchoose'] = 'Vælg...';
$string['missingdata'] = 'Data-ID eller objekt skal angives for feltklassen.';
$string['missingfield'] = 'Programfejl: Du skal angive felt og/eller data, når du definerer feltklassen.';
$string['missingfieldtype'] = 'Felt type for {$a->name} blev ikke fundet';
$string['missingfieldtypeimport'] = 'Følgende felter blev ikke importeret, fordi deres tilsvarende felttyper ikke er installeret:';
$string['missingfieldtypes'] = 'De følgende felter har ikke deres tilsvarende felttyper installeret og vil ikke blive inkluderet i formularen til at tilføje en post. Du skal kontrollere skabelonen til at tilføje en post og fjerne eventuelle feltnavne.';
$string['modulename'] = 'Database';
$string['modulename_help'] = 'Database giver deltagerne mulighed for at oprette, vedligeholde og søge i en samling af poster.

Posternes struktur defineres ved hjælp af forskellige typer felter, f.eks. kort tekst, rullemenu, tekstboks, URL, billede eller fil.

Som lærer kan du kommentere og bedømme poster. Du kan også give de studerende mulighed for at bedømme og kommentere posterne (peer-evaluering). Vurderinger kan lægges sammen til en endelig karakter, som registreres i karakterbogen.

Hvis filteret Database auto-linking er aktiveret, vil alle poster i en database automatisk blive knyttet til de steder, hvor ordene eller sætningerne forekommer på kurset.

Du kan bruge Database til at:

* Oprette en fælles samling af links, bøger, boganmeldelser, tidsskriftsreferencer osv.
* Vise fotos, plakater, websteder eller digte, som de studerende har skabt, så de kan kommentere og gennemgå dem.';
$string['modulename_link'] = 'mod/data/view';
$string['modulenameplural'] = 'Databaser';
$string['more'] = 'Mere';
$string['moreurl'] = 'Mere URL';
$string['movezipfailed'] = 'Kan ikke flytte zip';
$string['multientry'] = 'Gentagen indtastning';
$string['multimenu'] = 'Menu (Flere valg)';
$string['multipletags'] = 'Flere tags fundet! Skabelonen blev ikke gemt';
$string['myentries'] = 'Mine indtastninger';
$string['newentry'] = 'Ny post';
$string['newfield'] = 'Opret et felt';
$string['newfield_help'] = 'Et felt giver mulighed for input af data. Hver post i en database kan have flere felter af flere typer som f.eks. et datofelt, som giver deltagerne mulighed for at vælge en dag, måned og år fra en rullemenu, et billedfelt, som giver deltagerne mulighed for at uploade en billedfil, eller et område med afkrydsningsfelter, som giver deltagerne mulighed for at vælge en eller flere muligheder.

Hvert felt skal have et unikt feltnavn. Beskrivelsesfeltet er valgfrit at udfylde.';
$string['noaccess'] = 'Du har ikke adgang til denne side';
$string['nodefinedfields'] = 'Den nye forudindstilling har ingen definerede felter!';
$string['nofieldcontent'] = 'Indholdet af feltet blev ikke fundet';
$string['nofieldindatabase'] = 'Der er ingen felter defineret for denne database.';
$string['nofields'] = 'Ingen felter endnu';
$string['nolisttemplate'] = 'Skabelonen for listevisning er endnu ikke defineret';
$string['nomatch'] = 'Ingen matchende poster fundet!';
$string['nomaximum'] = 'Ingen maksimum';
$string['nopreviewavailable'] = 'Ingen forhåndsvisning tilgængelig for {$a}';
$string['norecords'] = 'Ingen indtastninger endnu';
$string['notapproved'] = 'Afventer godkendelse';
$string['notapprovederror'] = 'Indgangen er endnu ikke godkendt.';
$string['notemplates'] = 'Ingen skabeloner endnu';
$string['notinjectivemap'] = 'Ikke en injektiv funktion';
$string['notopenyet'] = 'Beklager, denne aktivitet er ikke tilgængelig før {$a}';
$string['number'] = 'Nummer';
$string['numberofentriestoapprove'] = 'Indtastninger, der skal godkendes: {$a}';
$string['numberrssarticles'] = 'Indlæg i RSS-feedet';
$string['numnotapproved'] = 'Afventende';
$string['numrecords'] = '{$a} indlæg';
$string['ods'] = '<abbr title="OpenDocument Spreadsheet">ODS</abbr>&nbsp;(OpenOffice)';
$string['openafterclose'] = 'Du har angivet en åbningsdato efter lukningsdatoen';
$string['optionaldescription'] = 'Kort beskrivelse (valgfrit)';
$string['optionalfilename'] = 'Filnavn (valgfrit)';
$string['other'] = 'Andet';
$string['otherfields'] = 'Alle andre felter';
$string['overrwritedesc'] = 'Erstat den eksisterende forudindstilling med dette navn og overskriv dens indhold';
$string['overwrite'] = 'Overskriv';
$string['overwritesettings'] = 'Overskriv nuværende indstillinger såsom kommentarer, vurderinger osv.';
$string['page-mod-data-x'] = 'Enhver side for databaseaktivitetsmodulet';
$string['pagesize'] = 'Indlæg pr. side';
$string['participants'] = 'Deltagere';
$string['picture'] = 'Billede';
$string['pluginadministration'] = 'Administration af databaseaktivitet';
$string['pluginname'] = 'Database';
$string['portfolionotfile'] = 'Eksporter til en portefølje i stedet for en fil (kun csv og leap2a)';
$string['presetdeleted'] = 'Præindstilling slettet.';
$string['presetinfo'] = 'At gemme som en forudindstilling vil offentliggøre denne skabelon. Andre brugere vil muligvis kunne bruge den i deres databaser.';
$string['presetnotselected'] = 'Ingen forudindstilling er blevet valgt.';
$string['presets'] = 'Forudindstillinger';
$string['presetshelp'] = 'Vælg en forudindstilling som udgangspunkt.';
$string['preview'] = 'Forhåndsvisning af {$a}';
$string['previewaction'] = 'Forhåndsvisning';
$string['privacy:metadata:commentpurpose'] = 'Kommentarer på databasenotater';
$string['privacy:metadata:data_content'] = 'Indholdet af et felt';
$string['privacy:metadata:data_content:content'] = 'Indhold';
$string['privacy:metadata:data_content:content1'] = 'Yderligere indhold 1';
$string['privacy:metadata:data_content:content2'] = 'Yderligere indhold 2';
$string['privacy:metadata:data_content:content3'] = 'Yderligere indhold 3';
$string['privacy:metadata:data_content:content4'] = 'Yderligere indhold 4';
$string['privacy:metadata:data_content:fieldid'] = 'Feltdefinitions-ID';
$string['privacy:metadata:data_records'] = 'Posteringer i databaseaktiviteten';
$string['privacy:metadata:data_records:approved'] = 'Godkendelsesstatus';
$string['privacy:metadata:data_records:groupid'] = 'Gruppe';
$string['privacy:metadata:data_records:timecreated'] = 'Tidspunkt for oprettelse af posten';
$string['privacy:metadata:data_records:timemodified'] = 'Tidspunktet for hvornår posten sidst blev ændret';
$string['privacy:metadata:data_records:userid'] = 'Bruger der oprettede posten';
$string['privacy:metadata:datafieldnpluginsummary'] = 'Felter til database aktivitetsmodul';
$string['privacy:metadata:filepurpose'] = 'Fil vedhæftet databaseposten';
$string['privacy:metadata:ratingpurpose'] = 'Vurderinger på databaserede poster';
$string['privacy:metadata:tagpurpose'] = 'Tags på databaseposter';
$string['radiobutton'] = 'Radioknapper';
$string['recordapproved'] = 'Indtastning godkendt';
$string['recorddeleted'] = 'Posten er slettet';
$string['recorddisapproved'] = 'Indtastning ikke godkendt';
$string['recordsnotsaved'] = 'Ingen indtastning blev gemt. Venligst kontroller formatet på den uploadede fil.';
$string['recordssaved'] = 'poster gemt';
$string['removealldatatags'] = 'Alle databasetags';
$string['requireapproval'] = 'Godkendelse påkrævet';
$string['requireapproval_help'] = 'En lærer skal godkende indlæg, før de er synlige for alle.';
$string['required'] = 'Påkrævet';
$string['requiredentries'] = 'Indtastninger krævet for fuldførelse (gammel)';
$string['requiredentries_help'] = 'Hvis indstillingen er aktiveret, vises en besked om hvor mange poster der kræves for gennemførelse. Bemærk at indstillingen ikke er forbundet med aktivitetsfuldførelse.

Der er en ny indstilling til poster krævet for aktivitetsfuldførelse, "Krævede poster". Fjern denne indstilling ved at sætte den til 0 og gem. Brug i stedet indstillingen "Krævede poster".';
$string['requiredentriestoview'] = 'Indtastninger kræves før visning';
$string['requiredentriestoview_help'] = 'Det antal poster, en studerende skal tilføje, før han/hun kan se poster fra andre studerende.

Dette er ikke kompatibelt med filteret til automatisk linking i databasen.';
$string['requiredentrieswarning'] = 'Denne indstilling er blevet erstattet af en aktivitetsfuldførelsesindstilling \'Krav om indtastninger\'';
$string['requiredfield'] = 'Obligatorisk felt';
$string['resetalltemplates'] = 'Nulstil alle skabeloner';
$string['resetalltemplatesconfirm'] = 'Du er ved at fjerne alle skabeloner for din nuværende prækonfiguration. Hvis du ønsker at gendanne skabelonerne senere, skal du vælge prækonfigurationen igen i fanen \'Prækonfigurationer\'.';
$string['resetalltemplatesconfirmtitle'] = 'Nulstil alle skabeloner?';
$string['resetsettings'] = 'Nulstil filtre';
$string['resettemplate'] = 'Nulstil nuværende skabelon';
$string['resettemplateconfirm'] = 'Dette vil permanent fjerne {$a} for din nuværende prækonfiguration.';
$string['resettemplateconfirmtitle'] = 'Nulstil skabelon?';
$string['resizingimages'] = 'Ændrer størrelsen på billede-miniaturer...';
$string['rows'] = 'rækker';
$string['rssglobaldisabled'] = 'Deaktiveret. Se konfigurationsvariabler for siden.';
$string['rsstemplate'] = 'RSS skabelon';
$string['rsstitletemplate'] = 'RSS titel skabelon';
$string['rsstype'] = 'RSS-feed til denne aktivitet';
$string['save'] = 'Gem';
$string['saveandadd'] = 'Gem og tilføj en anden';
$string['saveandview'] = 'Gem og vis';
$string['saveaspreset'] = 'Publicer præindstilling på dette site';
$string['saveaspreset_help'] = 'Funktionen gemme som forudindstilling offentliggør skabelonerne og felterne som en forudindstilling, som andre på siden derefter kan bruge. (Du kan slette den fra listen over forudindstillinger når som helst.)';
$string['saveaspresetmissingcapability'] = 'Brugeren har ikke tilladelse til at gemme databasen som en forudindstilling.';
$string['savedataaspreset'] = 'Gem alle felter og skabeloner og publicer som forudindstilling på dette site';
$string['savesettings'] = 'Gem indstillinger';
$string['savesuccess'] = 'Præindstilling gemt. <a href="{$a->url}">Forhåndsvis præindstilling</a>';
$string['search'] = 'Søg';
$string['search:activity'] = 'Database - aktivitetsinformation';
$string['search:entry'] = 'Database - poster';
$string['searchresults'] = 'Indtastninger der indeholder "{$a}"';
$string['selectedrequired'] = 'Alle valgte er påkrævede';
$string['selectexportoptions'] = 'Vælg eksportmuligheder';
$string['selectfields'] = 'Vælg felter';
$string['selectfordeletion'] = 'Vælg post til sletning';
$string['showall'] = 'Vis alle indtastninger';
$string['showmore'] = 'Vis mere';
$string['single'] = 'Vis enkelt';
$string['singletemplate'] = 'Enkelt visningsskabelon';
$string['singleview'] = 'Enkeltvisning';
$string['startbuilding'] = 'Begynd at opbygge din aktivitet';
$string['subplugintype_datafield'] = 'Databasens felt type';
$string['subplugintype_datafield_plural'] = 'Databasens felttyper';
$string['subplugintype_datapreset'] = 'Forudindstilling';
$string['subplugintype_datapreset_plural'] = 'Forudindstillinger';
$string['tagarea_data_records'] = 'Dataoptegnelser';
$string['tags'] = 'Tags';
$string['tagsdeleted'] = 'Database-tags er blevet slettet';
$string['teachersandstudents'] = '{$a->teachers} og {$a->students}';
$string['templatereset'] = 'Skabelon nulstilling';
$string['templateresetall'] = 'Alle skabeloner nulstillet';
$string['templates'] = 'Skabeloner';
$string['templatesaved'] = 'Skabelon gemt';
$string['templatesnavigation'] = 'Skabeloner til tertiær navigation';
$string['text'] = 'Tekst';
$string['textarea'] = 'Tekstområde';
$string['timeadded'] = 'Tid tilføjet';
$string['timemodified'] = 'Tid ændret';
$string['totalentries'] = 'Samlede indtastninger';
$string['type'] = 'Felt type';
$string['undefinedprocessactionmethod'] = 'Ingen handlingsmetode er defineret i Data_Preset til at håndtere handlingen "{$a}".';
$string['unknown'] = 'Ukendt felt';
$string['unsupportedfields'] = 'Ikke-understøttede felter';
$string['unsupportedfieldslist'] = 'Følgende felter kan ikke eksporteres:';
$string['updatefield'] = 'Opdater et eksisterende felt';
$string['uploadfile'] = 'Upload fil';
$string['uploadrecords'] = 'Importér poster';
$string['uploadrecords_help'] = 'Importer poster, som du har eksporteret fra en anden database, enten via CSV eller en ZIP-fil, der indeholder en CSV-fil (hvis filer er inkluderet i eksporten).

Alternativt kan du oprette en CSV-fil til import ved at tilføje en post til databasen og derefter eksportere den. Rediger CSV-filen, og tilføj flere poster.';
$string['uploadrecords_link'] = 'mod/data/import';
$string['url'] = 'URL';
$string['usedate'] = 'Inkluder i søgning.';
$string['usepredefinedset'] = 'Brug foruddefineret sæt';
$string['usepreset'] = 'Brug denne forudindstilling';
$string['usestandard'] = 'Brug en forudindstilling';
$string['usestandard_help'] = 'For at bruge en forudindstilling, der er tilgængelig for hele sitet, skal du vælge den fra listen. (Hvis du har tilføjet en forudindstilling til listen ved hjælp af funktionen gem som forudindstilling, har du mulighed for at slette den.)';
$string['viewentries'] = 'Vis indtastninger';
$string['viewfromdate'] = 'Kun læse fra';
$string['viewnavigation'] = 'Visningsmode tertiær navigation';
$string['viewtemplates'] = 'Vis skabeloner';
$string['viewtodate'] = 'Kun læse til';
$string['viewtodatevalidation'] = 'Datoen for læsning kun til kan ikke være før datoen for læsning kun fra.';
$string['wrongdataid'] = 'Forkert data-ID angivet';
