<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'aiprovider_deepseek', language 'da', version '5.1'.
 *
 * @package     aiprovider_deepseek
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action:explain_text:endpoint'] = 'API-endpoint';
$string['action:explain_text:model'] = 'Tekstforklaringsmodel';
$string['action:explain_text:model_help'] = 'Modellen, der bruges til at forklare den angivne tekst';
$string['action:explain_text:systeminstruction'] = 'Systeminstruktion';
$string['action:explain_text:systeminstruction_help'] = 'Denne instruktion sendes til AI-modellen sammen med brugerens prompt. Redigering af denne instruktion anbefales ikke, medmindre det er absolut nødvendigt';
$string['action:generate_text:endpoint'] = 'API-endpoint';
$string['action:generate_text:model'] = 'AI-model';
$string['action:generate_text:model_help'] = 'Modellen, der bruges til at generere tekstsvaret';
$string['action:generate_text:systeminstruction'] = 'Systeminstruktion';
$string['action:generate_text:systeminstruction_help'] = 'Denne instruktion sendes til AI-modellen sammen med brugerens prompt. Redigering af denne instruktion anbefales ikke, medmindre det er absolut nødvendigt';
$string['action:summarise_text:endpoint'] = 'API-endpoint';
$string['action:summarise_text:model'] = 'AI-model';
$string['action:summarise_text:model_help'] = 'Modellen, der bruges til at opsummere den angivne tekst';
$string['action:summarise_text:systeminstruction'] = 'Systeminstruktion';
$string['action:summarise_text:systeminstruction_help'] = 'Denne instruktion sendes til AI-modellen sammen med brugerens prompt. Redigering af denne instruktion anbefales ikke, medmindre det er absolut nødvendigt';
$string['apikey'] = 'DeepSeek API-nøgle';
$string['apikey_help'] = 'Hent en nøgle fra dine <a href="https://platform.deepseek.com/api_keys" target="_blank">DeepSeek API-nøgler</a>';
$string['custom_model_name'] = 'Brugerdefineret modelnavn';
$string['extraparams'] = 'Ekstra parametre';
$string['extraparams_help'] = 'Ekstra parametre kan konfigureres her. Vi understøtter JSON-format. For eksempel:
<pre>
{
    "temperature": 0.5,
    "max_tokens": 100
}
</pre>';
$string['invalidjson'] = 'Ugyldig JSON-streng';
$string['pluginname'] = 'DeepSeek API-udbyder';
$string['privacy:metadata'] = 'DeepSeek API-udbyder-plugin’et gemmer ingen personlige data';
$string['privacy:metadata:aiprovider_deepseek:externalpurpose'] = 'Disse oplysninger sendes til DeepSeek API’et for at generere et svar. Dine DeepSeek-kontoinstillinger kan påvirke, hvordan DeepSeek gemmer og opbevarer disse data. Ingen brugerdata sendes eksplicit til DeepSeek eller gemmes i Moodle LMS af dette plugin';
$string['privacy:metadata:aiprovider_deepseek:model'] = 'Modellen, der bruges til at generere svaret';
$string['privacy:metadata:aiprovider_deepseek:prompttext'] = 'Den brugerindtastede tekstprompt, der bruges til at generere svaret';
$string['settings'] = 'Indstillinger';
$string['settings_frequency_penalty'] = 'frequency_penalty';
$string['settings_frequency_penalty_help'] = 'Tal mellem -2.0 og 2.0. Positive værdier straffer nye tokens baseret på deres eksisterende frekvens i teksten indtil videre, hvilket reducerer modellens sandsynlighed for at gentage den samme linje ordret';
$string['settings_help'] = 'Juster indstillingerne nedenfor for at tilpasse, hvordan requests sendes til DeepSeek';
$string['settings_logprobs'] = 'logprobs';
$string['settings_logprobs_help'] = 'Om log-sandsynlighederne for outputtokens skal returneres eller ej. Hvis sand, returneres log-sandsynlighederne for hvert outputtoken, der returneres i beskedens indhold';
$string['settings_logprobs_label'] = 'Aktivér';
$string['settings_max_tokens'] = 'max_tokens';
$string['settings_max_tokens_help'] = 'Heltal mellem 1 og 8192. Det maksimale antal tokens, der kan genereres i chat-fuldførelsen. Den samlede længde af inputtokens og genererede tokens er begrænset af modellens kontekstdybde. Hvis max_tokens ikke er angivet, bruges standardværdien 4096';
$string['settings_presence_penalty'] = 'presence_penalty';
$string['settings_presence_penalty_help'] = 'Tal mellem -2.0 og 2.0. Positive værdier straffer nye tokens baseret på, om de forekommer i teksten indtil videre, hvilket øger modellens sandsynlighed for at tale om nye emner';
$string['settings_temperature'] = 'temperature';
$string['settings_temperature_help'] = 'Den samplingstemperatur, der skal bruges, mellem 0 og 2. Højere værdier som 0,8 vil gøre outputtet mere tilfældigt, mens lavere værdier som 0,2 vil gøre det mere fokuseret og deterministisk. Det anbefales generelt at ændre denne eller top_p, men ikke begge';
$string['settings_top_logprobs'] = 'top_logprobs';
$string['settings_top_logprobs_help'] = 'Et heltal mellem 0 og 20, der angiver antallet af mest sandsynlige tokens, der skal returneres ved hver tokenposition, hver med en tilhørende log-sandsynlighed. logprobs skal være sat til sand, hvis denne parameter bruges';
$string['settings_top_p'] = 'top_p';
$string['settings_top_p_help'] = 'Et alternativ til sampling med temperature, kaldet nucleus sampling, hvor modellen overvejer resultaterne af tokens med top_p sandsynlighedsmængde. Så 0,1 betyder, at kun tokens, der udgør de øverste 10 % af sandsynlighedsmængden, tages i betragtning. Det anbefales generelt at ændre denne eller temperature, men ikke begge';
