<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_certificate', language 'pt', version '5.1'.
 *
 * @package     tool_certificate
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addcertpage'] = 'Nova página';
$string['addelement'] = 'Adicionar elemento';
$string['addelementwithname'] = 'Adicionar elemento \'{$a}\'';
$string['after'] = 'Depois';
$string['aissueswerecreated'] = '{$a} certificados foram emitidos';
$string['aligncentre'] = 'Centro';
$string['alignleft'] = 'Esquerda';
$string['alignment'] = 'Alinhamento do texto';
$string['alignment_help'] = 'O alinhamento do texto à direita significará que as coordenadas do elemento (posição X e posição Y) referir-se-ão ao canto superior direito da caixa de texto, no alinhamento central referir-se-ão ao canto superior médio e no alinhamento à esquerdo ao canto superior esquerdo';
$string['alignright'] = 'Direita';
$string['allowfilters'] = 'Filtros permitidos para o conteúdo do PDF';
$string['allowfilters_desc'] = 'Apenas os filtros selecionados (se ativados) serão aplicados aos textos dentro dos PDF do certificado';
$string['archived'] = 'Arquivado';
$string['availableincourses'] = 'Disponível nas sub-categorias e disciplinas';
$string['availableincourses_help'] = 'Se ativar esta opção, os utilizadores (com permissão de emissão) poderão utilizar este modelo em cada disciplina dentro da categoria selecionada e as disciplinas dentro das suas sub-categorias também. Se esta opção estiver desativada, este modelo estará disponível exclusivamente para os utilizadores com permissão de edição na categoria selecionada.';
$string['certificate'] = 'Certificado';
$string['certificate:image'] = 'Gerir imagens de certificados';
$string['certificate:issue'] = 'Emitir certificados aos utilizadores';
$string['certificate:manage'] = 'Gerir certificados';
$string['certificate:verify'] = 'Verificar qualquer certificado';
$string['certificate:viewallcertificates'] = 'Ver todos os certificados e modelos emitidos';
$string['certificate_customfield'] = 'Certificar campos personalizados';
$string['certificatecopy'] = '{$a} (cópia)';
$string['certificateelement'] = 'Elemento do certificado';
$string['certificateimages'] = 'Imagens do certificado';
$string['certificates'] = 'Certificados';
$string['certificatesettings'] = 'Configurações dos certificados';
$string['certificatesissues'] = 'Certificados emitidos';
$string['certificatetemplate'] = 'Modelo de certificado';
$string['certificatetemplatename'] = 'Nome do modelo de certificado';
$string['certificatetemplates'] = 'Modelos de certificados';
$string['changeelementsequence'] = 'Trazer para a frente ou enviar para trás';
$string['code'] = 'Código';
$string['codewithlink'] = 'Código com hiperligação';
$string['coursecategorywithlink'] = 'Categoria da disciplina com hiperligação';
$string['createtemplate'] = 'Novo modelo de certificado';
$string['customfield_previewvalue'] = 'Valor da pré-visualização';
$string['customfield_previewvalue_help'] = 'Valor apresentado ao pré-visualizar o modelo de certificado';
$string['customfield_visible'] = 'Visível';
$string['customfield_visible_help'] = 'Permite selecionar este campo no modelo do certificado';
$string['customfieldsettings'] = 'Configuração de campos personalizados de certificados comuns';
$string['deleteelement'] = 'Apagar elemento';
$string['deleteelementconfirm'] = 'Tem a certeza de que pretende apagar o elemento \'{$a}\'?';
$string['deletepage'] = 'Apagar página';
$string['deletepageconfirm'] = 'Tem a certeza de que pretende apagar esta página do certificado?';
$string['deletetemplateconfirm'] = 'Tem a certeza de que pretende apagar o modelo de certificado \'{$a}\' e todos os dados associados? Esta ação não pode ser desfeita.';
$string['demotmpl'] = 'Modelo de demonstração de certificado';
$string['demotmplawardedon'] = 'Concedido em';
$string['demotmplawardedto'] = 'Este certificado é concedido a';
$string['demotmplbackground'] = 'Imagem de fundo';
$string['demotmplcoursefullname'] = 'Nome completo da disciplina';
$string['demotmpldirector'] = 'Diretor da escola';
$string['demotmplforcompleting'] = 'Por completar o curso';
$string['demotmplissueddate'] = 'Data de emissão';
$string['demotmplqrcode'] = 'Código QR';
$string['demotmplsignature'] = 'Assinatura';
$string['demotmplusername'] = 'Nome do utilizador';
$string['do_not_show'] = 'Não mostrar';
$string['duplicate'] = 'Duplicar';
$string['duplicatetemplateconfirm'] = 'Tem a certeza de que pretende duplicar o modelo \'{$a}\'?';
$string['editcertificate'] = 'Editar modelo de certificado \'{$a}\'.';
$string['editelement'] = 'Editar \'{$a}\'';
$string['editelementname'] = 'Editar o nome do elemento';
$string['editpage'] = 'Editar página {$a}';
$string['edittemplatename'] = 'Editar o nome do modelo';
$string['elementname'] = 'Nome do modelo';
$string['elementname_help'] = 'Este será o nome utilizado para identificar este elemento ao editar um certificado. Note que este não será exibido no PDF.';
$string['elementwidth'] = 'Comprimento';
$string['elementwidth_help'] = 'Especificar a largura do elemento. Zero (0) significa não haver restrição de largura.';
$string['entitycertificate'] = 'Certificado';
$string['entitycertificateissue'] = 'Certificado foi emitido';
$string['eventcertificateissued'] = 'Certificado emitido';
$string['eventcertificateregenerated'] = 'Certificado regenerado';
$string['eventcertificaterevoked'] = 'Certificado revogado';
$string['eventcertificateverified'] = 'Certificado verificado';
$string['eventtemplatecreated'] = 'Modelo criado';
$string['eventtemplatedeleted'] = 'Modelo apagado';
$string['eventtemplateupdated'] = 'Modelo atualizado';
$string['expired'] = 'Expirado';
$string['expiredcertificate'] = 'Este certificado expirou';
$string['expirydate'] = 'Data de validade';
$string['expirydatetype'] = 'Tipo de data de validade';
$string['font'] = 'Tipo de letra';
$string['font_help'] = 'O tipo de letra usado na geração deste elemento.';
$string['fontcolour'] = 'Cor';
$string['fontcolour_help'] = 'A cor do tipo de letra';
$string['fontsize'] = 'Tamanho';
$string['fontsize_help'] = 'O tamanho do tipo de letra em pontos.';
$string['hideshow'] = 'Ocultar/mostrar';
$string['invalidcolour'] = 'Cor inválida escolhida. Por favor, indique um nome de cor HTML válido, uma cor hexadecimal de seis dígitos ou uma cor hexadecimal de três dígitos.';
$string['invalidelementwidth'] = 'Por favor, introduza um número positivo.';
$string['invalidheight'] = 'A altura tem de ser um número válido maior que 0.';
$string['invalidmargin'] = 'A margem tem de ser um número válido maior que 0.';
$string['invalidposition'] = 'Por favor, selecione um número positivo para a posição {$a}.';
$string['invalidwidth'] = 'A largura tem de ser um número válido maior que 0.';
$string['issuecertificates'] = 'Emitir certificados';
$string['issuedcertificates'] = 'Certificados emitidos';
$string['issueddate'] = 'Data de emissão';
$string['issuelang'] = 'Emitir certificados no idioma do utilizador';
$string['issuelangdesc'] = 'Em sites multilingues, quando o idioma do utilizador difere do idioma do site, os certificados serão gerados no idioma do utilizador, caso contrário, todos os certificados serão gerados no idioma predefinido do site.';
$string['issuenewcertificate'] = 'Emitir certificados deste modelo';
$string['issuenotallowed'] = 'Não está autorizado a emitir certificados deste modelo.';
$string['issueormangenotallowed'] = 'Não está autorizado a emitir certificados deste modelo ou a geri-lo.';
$string['leftmargin'] = 'Margem esquerda';
$string['leftmargin_help'] = 'Esta é a margem esquerda do PDF do certificado em mm.';
$string['linkedinorganizationid'] = 'ID de organização LinkedIn';
$string['linkedinorganizationid_desc'] = 'O ID da organização LinkedIn que emite certificados.

Onde posso encontrar a minha identificação de organização LinkedIn?

1.    Inicie sessão no LinkedIn como administrador da página da organização da sua empresa
2.    Verifique o URL utilizado quando estiver ligado como administrador (o URL deve assemelhar-se a "https://linkedin.com/company/xxxxxxx/admin").
3.    O seu ID de organização LinkedIn é o número de sete dígitos no URL (mostrado como "xxxxxxx" no passo acima)';
$string['manageelementplugins'] = 'Gerir módulos de elementos de certificado';
$string['managetemplates'] = 'Gerir modelos de certificado';
$string['messageprovider:certificateissued'] = 'Certificado recebido';
$string['milimeter'] = 'mm';
$string['mycertificates'] = 'Os meus certificados';
$string['mycertificatesdescription'] = 'Os certificados que lhe foram emitidos e enviados por e-mail ou descarregados manualmente.';
$string['name'] = 'Nome';
$string['nametoolong'] = 'Excedeu o tamanho máximo permitido para o nome';
$string['never'] = 'Nunca';
$string['noimage'] = 'Sem imagem';
$string['noissueswerecreated'] = 'Não foram emitidos certificados';
$string['nopermissionform'] = 'Não tem permissão para aceder a este formulário.';
$string['notificationmsgcertificateissued'] = 'Olá {$a->fullname},<br /><br />O seu certificado já está disponível! Pode consultar aqui:
<a href="{$a->url}">Os meus certificados</a>';
$string['notificationsubjectcertificateissued'] = 'O seu certificado está disponível!';
$string['notverified'] = 'Não verificado';
$string['numberofpages'] = 'Número de páginas';
$string['oneissuewascreated'] = 'Uma emissão foi criada';
$string['page'] = 'Página {$a}';
$string['pageheight'] = 'Altura da página';
$string['pageheight_help'] = 'Esta é a altura do PDF do certificado em mm. Para referência, uma folha de papel A4 tem 297 mm de altura e o tamanho Letter tem 279 mm de altura.';
$string['pagewidth'] = 'Largura da página';
$string['pagewidth_help'] = 'Esta é a largura do PDF do certificado em mm. Para referência, uma folha de papel A4 tem 210 mm de largura e o tamanho Letter tem 216 mm de largura.';
$string['pluginname'] = 'Gestor de certificados';
$string['posx'] = 'Posição X';
$string['posx_help'] = 'Esta é a posição em mm a partir do canto superior esquerdo que se pretende que o ponto de referência do elemento se localize na direção x.';
$string['posy'] = 'Posição Y';
$string['posy_help'] = 'Esta é a posição em mm a partir do canto superior esquerdo que se pretende que o ponto de referência do elemento se localize na direção y.';
$string['privacy:metadata:tool_certificate:issues'] = 'Lista de certificados emitidos';
$string['privacy:metadata:tool_certificate_issues:code'] = 'O código que pertence ao certificado';
$string['privacy:metadata:tool_certificate_issues:expires'] = 'O registo cronológico quando o certificado expira. 0 se não expirar.';
$string['privacy:metadata:tool_certificate_issues:templateid'] = 'O ID do certificado';
$string['privacy:metadata:tool_certificate_issues:timecreated'] = 'A data/hora que o certificado foi emitido';
$string['privacy:metadata:tool_certificate_issues:userid'] = 'O ID do utilizador a quem foi emitido o certificado';
$string['reg_wpcertificates'] = 'Número de certificados ({$a})';
$string['reg_wpcertificatesissues'] = 'Número de certificados emitidos ({$a})';
$string['regenerate'] = 'Regenerar';
$string['regeneratefileconfirm'] = 'Tem a certeza de que pretende regenerar o certificado emitido a este utilizador?';
$string['regenerateissuefile'] = 'Regenerar ficheiro de emissão';
$string['revoke'] = 'Revogar';
$string['revokecertificateconfirm'] = 'Tem a certeza de que pretende revogar este certificado emitido por este utilizador?';
$string['rightmargin'] = 'Margem direita';
$string['rightmargin_help'] = 'Esta é a margem direita do certificado PDF em mm.';
$string['selectdate'] = 'Selecione a data';
$string['selectuserstoissuecertificatefor'] = 'Selecione utilizadores para emitir certificado';
$string['shared'] = 'Partilhado';
$string['shareonlinkedin'] = 'Partilhar no LinkedIn';
$string['show_link_to_certificate_page'] = 'Mostrar atalho para a página do certificado';
$string['show_link_to_verification_page'] = 'Mostrar atalho para página de verificação';
$string['show_shareonlinkedin'] = 'Ver partilha no LinkedIn';
$string['show_shareonlinkedin_desc'] = 'Se o botão "Partilhar no LinkedIn" deve ser mostrado na página dos meus certificados. A ligação direta para o PDF do certificado é mais visual, mas pode mostrar erros para certificados expirados.';
$string['status'] = 'Estado';
$string['subplugintype_certificateelement'] = 'Módulo de elemento de certificado';
$string['subplugintype_certificateelement_plural'] = 'Módulos de elemento de certificado';
$string['template'] = 'Modelo';
$string['templatepermission'] = 'Permissão para aceder ao modelo';
$string['templatepermissionany'] = 'Não verificar';
$string['templatepermissionyes'] = 'Verificar a permissão do utilizador atual';
$string['timecreated'] = 'Data/hora de criação';
$string['uploadimage'] = 'Carregar imagem';
$string['valid'] = 'Válido';
$string['validcertificate'] = 'Este certificado é válido';
$string['verified'] = 'Verificado';
$string['verify'] = 'Verificar';
$string['verifycertificates'] = 'Verificar certificados';
$string['verifynotallowed'] = 'Não está autorizado a verificar certificados.';
$string['viewcertificate'] = 'Ver certificado';
