<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'forum', language 'pt', version '5.1'.
 *
 * @package     forum
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actionsforgraderinterface'] = 'Ações para a interface do avaliador';
$string['actionsforpost'] = 'Ações para publicar';
$string['activitydate:due'] = 'Fim do prazo:';
$string['activityoverview'] = 'Existem novas mensagens no fórum';
$string['addanewdiscussion'] = 'Criar um novo tópico';
$string['addanewquestion'] = 'Criar uma nova pergunta';
$string['addanewtopic'] = 'Criar um novo tópico';
$string['addreply'] = 'Adicionar resposta';
$string['addtofavourites'] = 'Marcar este tópico com estrela';
$string['advancedsearch'] = 'Pesquisa avançada';
$string['alldiscussions'] = 'Todos os tópicos';
$string['allforums'] = 'Todos os fóruns';
$string['allowdiscussions'] = '{$a} pode criar novos tópicos?';
$string['allowsallsubscribe'] = 'Este fórum permite a todos optar por subscrever ou não.';
$string['allowsdiscussions'] = 'Este fórum permite que cada participante crie um tópico de discussão.';
$string['allsubscribe'] = 'Subscrever todos os fóruns';
$string['allunsubscribe'] = 'Cancelar a subscrição de todos os fóruns';
$string['allusers'] = 'Todos os utilizadores';
$string['alreadyfirstpost'] = 'Este já é o primeiro tópico da discussão';
$string['announcementsettings'] = 'Configurações predefinidas dos anúncios do fórum';
$string['announcementsettings_help'] = 'Estas configurações definem os valores predefinidos para todos os fóruns Anúncios.';
$string['anyfile'] = 'Qualquer ficheiro';
$string['areaattachment'] = 'Anexos';
$string['areapost'] = 'Mensagens';
$string['attachment'] = 'Anexo';
$string['attachment_help'] = 'Poderá anexar um ou mais ficheiros a uma mensagem do fórum. Se anexar uma imagem, esta será exibida após a mensagem.';
$string['attachmentname'] = 'Anexo {$a}';
$string['attachmentnameandfilesize'] = '{$a->name} ({$a->size})';
$string['attachmentnopost'] = 'Não pode exportar anexos sem o ID da mensagem';
$string['attachments'] = 'Anexos';
$string['attachmentswordcount'] = 'Anexos e contagem de palavras';
$string['authorreplyingprivatelytoauthor'] = '{$a->respondant} a responder em privado a {$a->author}';
$string['authorreplyingtoauthor'] = '{$a->respondant} a responder a {$a->author}';
$string['availability'] = 'Disponibilidade';
$string['blockafter'] = 'Número limite de mensagens';
$string['blockafter_help'] = 'Especifica o número máximo de mensagens que cada utilizador pode submeter num determinado intervalo de tempo. Utilizadores com a permissão \'mod/forum:postwithoutthrottling\' não são afetados por estes limites.';
$string['blockperiod'] = 'Intervalo de tempo';
$string['blockperiod_help'] = 'Os alunos podem ser impedidos de submeter mais do que um determinado número de mensagens no intervalo de tempo aqui especificado. Os utilizadores com a permissão \'mod/forum:postwithoutthrottling\' não são afetados por estes limites.';
$string['blockperioddisabled'] = 'Não bloquear';
$string['blogforum'] = 'Fórum standard em formato blogue';
$string['bynameondate'] = 'por {$a->name} - {$a->date}';
$string['cachedef_forum_count_discussions'] = 'Número de tópicos de fórum';
$string['cachedef_forum_is_tracked'] = 'Estado do seguimento do fórum para o utilizador';
$string['calendardue'] = 'Termina o prazo de {$a}';
$string['cancelreply'] = 'Cancelar resposta';
$string['cannotadd'] = 'Não foi possível adicionar o tópico a este fórum';
$string['cannotadddiscussion'] = 'Criar novos tópicos neste fórum requer adesão a um grupo.';
$string['cannotadddiscussionall'] = 'Não tem permissão para criar um novo tópico disponível para todos os participantes';
$string['cannotadddiscussiongroup'] = 'Não pode criar um tópico de discussão porque não é membro de qualquer grupo.';
$string['cannotaddsubscriber'] = 'Não foi possível subscrever o utilizador com o ID {$a} a este fórum.';
$string['cannotaddteacherforumto'] = 'Não foi possível criar o fórum de professores convertido na secção 0 da disciplina.';
$string['cannotcreatediscussion'] = 'Não foi possível criar o novo tópico de discussão';
$string['cannotcreateinstanceforteacher'] = 'Não foi possível criar a instância do novo módulo da disciplina para o fórum de professores';
$string['cannotdeletepost'] = 'Não pode apagar esta mensagem';
$string['cannoteditposts'] = 'Não pode editar mensagens de outros utilizadores';
$string['cannotexportforum'] = 'Não pode exportar este fórum';
$string['cannotfavourite'] = 'Não tem permissão para marcar tópicos com estrela.';
$string['cannotfinddiscussion'] = 'Não foi possível localizar o tópico neste fórum';
$string['cannotfindfirstpost'] = 'Não foi possível localizar o primeiro tópico deste fórum';
$string['cannotfindorcreateforum'] = 'Não foi possível localizar ou criar um fórum de anúncios para o site';
$string['cannotfindparentpost'] = 'Não foi possível localizar o tópico da mensagem  {$a}';
$string['cannotmovefromsingleforum'] = 'Não é possível mover tópicos de um fórum de um único tópico de discussão';
$string['cannotmovenotvisible'] = 'O fórum não está visível';
$string['cannotmovetonotexist'] = 'Não é possível mover para esse fórum pois não existe';
$string['cannotmovetonotfound'] = 'O fórum de destino não foi localizado nesta disciplina.';
$string['cannotmovetosingleforum'] = 'Não é possível mover a discussão para um fórum de um único tópico de discussão';
$string['cannotpindiscussions'] = 'Não tem permissão para destacar tópicos.';
$string['cannotpurgecachedrss'] = 'Não foi possível apagar a cache das listas RSS para os fóruns original e/ou de destino - reveja as suas permissões nos fóruns';
$string['cannotremovesubscriber'] = 'Não foi possível cancelar a subscrição do utilizador com ID {$a}';
$string['cannotreply'] = 'Não pode responder a esta mensagem';
$string['cannotsplit'] = 'Os tópicos neste fórum não podem ser divididos';
$string['cannotsubscribe'] = 'Necessita de estar inscrito num grupo para subscrever o fórum';
$string['cannottrack'] = 'Não foi possível parar de assinalar as mensagens não lidas neste fórum';
$string['cannotunsubscribe'] = 'Não foi possível cancelar a sua subscrição';
$string['cannotupdatepost'] = 'Não pode atualizar esta mensagem';
$string['cannotuseseperategroupsandsingletopic'] = 'Grupos separados não podem ser usados num único tópico de discussão.';
$string['cannotusesingletopicandseperategroups'] = 'Um único tópico de discussão não pode ser usado com grupos separados.';
$string['cannotviewpostyet'] = 'Não pode ver as respostas a esta pergunta porque ainda não respondeu à mesma.';
$string['cannotviewusersposts'] = 'Não existem mensagens deste participante que possa visualizar.';
$string['charactercount'] = 'Número de caracteres';
$string['cleanreadtime'] = 'Hora para marcar mensagens antigas como lidas';
$string['clicktofavourite'] = 'Não marcou este tópico com estrela. Clique para marcar.';
$string['clicktolockdiscussion'] = 'Clique para bloquear este tópico';
$string['clicktosubscribe'] = 'Não tem subscrição ativa para este tópico. Clique para subscrever.';
$string['clicktounfavourite'] = 'Marcou o tópico com estrela. Clique para remover a estrela.';
$string['clicktounlockdiscussion'] = 'Clique para desbloquear este tópico';
$string['clicktounsubscribe'] = 'Tem subscrição ativa para este tópico. Clique para cancelar a subscrição.';
$string['close'] = 'Fechar';
$string['closegrader'] = 'Fechar avaliador';
$string['completiondetail:discussions'] = 'Iniciar tópicos: {$a}';
$string['completiondetail:posts'] = 'Adicionar mensagens: {$a}';
$string['completiondetail:replies'] = 'Adicionar respostas: {$a}';
$string['completiondiscussions'] = 'Criar tópicos';
$string['completiondiscussionsdesc'] = 'O aluno deve criar pelo menos {$a} tópico(s) de discussão';
$string['completionposts'] = 'Criar tópicos ou publicar respostas';
$string['completionpostsdesc'] = 'O aluno deve criar ou responder a pelo menos {$a} tópico(s) de discussão';
$string['completionpostshelp'] = 'número de tópicos ou respostas requeridos para concluir a atividade';
$string['completionpostsinforums'] = 'Publicar em fóruns';
$string['completionreplies'] = 'Publicar respostas';
$string['completionrepliesdesc'] = 'O aluno deve responder a pelo menos {$a}';
$string['configcleanreadtime'] = 'Hora do dia em que as mensagens antigas serão apagadas da tabela de \'não lidas\'.';
$string['configdigestmailtime'] = 'Será enviado um resumo por dia aos utilizadores que optarem por receber resumos do fórum por e-mail. Esta configuração define a hora do envio do e-mail (a mensagem será enviada quando for executado o cron após a hora definida).';
$string['configdisplaymode'] = 'Modo predefinido de apresentação dos tópicos.';
$string['configenablerssfeeds'] = 'Esta opção permite a criação de listas RSS a partir de qualquer fórum. É ainda necessário configurar cada fórum para que sejam geradas as listas correspondentes.';
$string['configenabletimedposts'] = 'Se ativar esta opção, será possível ativar a configuração de \'Período de visualização\' ao publicar um novo tópico de discussão.';
$string['configlongpost'] = 'Qualquer mensagem acima deste tamanho (número de caracteres, sem incluir HTML) será considerada longa. Mensagens exibidas na página principal do site, páginas com formato social ou perfis de utilizadores são truncadas para um tamanho entre os valores definidos em \'forum_shortpost\' e \'forum_longpost\'.';
$string['configmanydiscussions'] = 'Número máximo de tópicos exibidos por página no fórum';
$string['configmaxattachments'] = 'Número máximo predefinido de anexos permitidos por mensagem.';
$string['configmaxbytes'] = 'Tamanho máximo predefinido para todos os anexos de uma mensagem do fórum (sujeito a outros limites impostos na configuração da disciplina e do servidor).';
$string['configoldpostdays'] = 'Número de dias para uma mensagem ser considerada como lida.';
$string['configreplytouser'] = 'Quando um tópico de fórum é enviado por e-mail, deverá conter o endereço de e-mail do autor para que os destinatários possam responder diretamente em vez de usarem o fórum? Se selecionar \'Sim\', os utilizadores poderão, a partir do seu perfil, optar por manter o seu endereço de e-mail privado.';
$string['configrssarticlesdefault'] = 'Se as listas RSS estiverem ativas, esta configuração define o número de artigos (tanto discussões como mensagens).';
$string['configrsstypedefault'] = 'Se as listas RSS estiverem ativas, esta configuração define o tipo de atividade predefinida.';
$string['configshortpost'] = 'Qualquer mensagem abaixo deste tamanho (número de caracteres, sem incluir HTML) será considerada curta.';
$string['configsubscriptiontype'] = 'Configuração predefinida para o modo de subscrição.';
$string['configtrackingtype'] = 'Configuração predefinida para "Assinalar mensagens não lidas".';
$string['configtrackreadposts'] = 'Se ativar esta opção, será permitido aos utilizadores assinalar mensagens não lidas.';
$string['configusermarksread'] = 'Se ativar esta opção, o utilizador tem de marcar manualmente as mensagens como lidas. Se desativada, as mensagens serão marcadas como lidas após a sua visualização.';
$string['confirmsubscribe'] = 'Tem a certeza de que pretende subscrever o fórum \'{$a}\'?';
$string['confirmsubscribediscussion'] = 'Tem a certeza de que pretende subscrever o tópico de discussão \'{$a->discussion}\' no fórum \'{$a->forum}\'?';
$string['confirmunsubscribe'] = 'Tem a certeza de que pretende cancelar a subscrição do fórum \'{$a}\'?';
$string['confirmunsubscribediscussion'] = 'Tem a certeza de que pretende cancelar a subscrição do tópico de discussão \'{$a->discussion}\' no fórum \'{$a->forum}\'?';
$string['couldnotadd'] = 'Não foi possível inserir a mensagem que submeteu devido a um erro desconhecido';
$string['couldnotdeletereplies'] = 'Lamentamos mas não é possível apagar pois já existem respostas.';
$string['couldnotupdate'] = 'Não foi possível atualizar a mensagem devido a um erro desconhecido';
$string['created'] = 'Criada';
$string['crontask'] = 'Envio das mensagens de fóruns e tarefas de manutenção';
$string['cutoffdate'] = 'Data de fecho';
$string['cutoffdate_help'] = 'Se definida, o fórum não aceitará publicações após esta data.';
$string['cutoffdatereached'] = 'A data de fecho do fórum já foi ultrapassada, por isso, não é possível publicar neste fórum.';
$string['cutoffdatevalidation'] = 'Data de fecho não pode ser anterior à data limite.';
$string['delete'] = 'Apagar';
$string['deleteddiscussion'] = 'O tópico foi apagado';
$string['deletedpost'] = 'A mensagem foi apagada';
$string['deletedposts'] = 'Estas mensagens foram apagadas';
$string['deleteduser'] = 'Utilizador apagado';
$string['deletesure'] = 'Tem a certeza de que pretende apagar esta mensagem?';
$string['deletesureplural'] = 'Tem a certeza de cque pretende apagar esta mensagem e todas as suas respostas? (número de respostas: {$a})';
$string['digestmailheader'] = 'Este é o seu resumo diário de novas mensagens nos fóruns de {$a->sitename}. Pode alterar as suas preferências de e-mail em {$a->userprefs}.';
$string['digestmailpost'] = 'Alterar as suas preferências do resumo de fóruns';
$string['digestmailpostlink'] = 'Alterar tipo de resumo de fóruns: {$a}';
$string['digestmailprefs'] = 'o seu perfil do utilizador';
$string['digestmailsubject'] = '{$a}: resumo do fórum';
$string['digestmailtime'] = 'Hora para enviar e-mails com resumo do fórum';
$string['digestsentusers'] = 'Resumo do fórum enviado com sucesso para {$a} utilizadores.';
$string['digesttype'] = 'Tipo de resumo';
$string['disallowsubscribe'] = 'Não é possível subscrever';
$string['disallowsubscribeteacher'] = 'Não é possível subscrever (exceto professores)';
$string['disallowsubscription'] = 'Subscrição';
$string['disallowsubscription_help'] = 'Este fórum foi configurado para que não seja possível subscrever os respetivos tópicos de discussão.';
$string['discussion'] = 'Tópico';
$string['discussionlistsortbycreatedasc'] = 'Ordenar a lista de tópicos por ordem crescente da data de criação';
$string['discussionlistsortbycreateddesc'] = 'Ordenar a lista de tópicos por ordem decrescente da data de criação';
$string['discussionlistsortbydiscussionasc'] = 'Ordenar por nome do tópico em ordem crescente';
$string['discussionlistsortbydiscussiondesc'] = 'Ordenar por nome do tópico em ordem decrescente';
$string['discussionlistsortbygroupasc'] = 'Ordenar por grupo em ordem crescente';
$string['discussionlistsortbygroupdesc'] = 'Ordenar por grupo em ordem decrescente';
$string['discussionlistsortbylastpostasc'] = 'Ordenar a lista de tópicos por ordem crescente da data da última mensagem';
$string['discussionlistsortbylastpostdesc'] = 'Ordenar a lista de tópicos por ordem decrescente da data da última mensagem';
$string['discussionlistsortbyrepliesasc'] = 'Ordenar a lista de tópicos por ordem crescente do número de respostas';
$string['discussionlistsortbyrepliesdesc'] = 'Ordenar a lista de tópicos por ordem decrescente do número de respostas';
$string['discussionlistsortbystarterasc'] = 'Ordenar por nome do autor do tópico em ordem crescente';
$string['discussionlistsortbystarterdesc'] = 'Ordenar por nome do autor do tópico em ordem decrescente';
$string['discussionlocked'] = 'Este tópico de discussão está bloqueado. Já não pode responder ao mesmo.';
$string['discussionlockingdisabled'] = 'Não bloquear tópicos de discussão';
$string['discussionlockingheader'] = 'Bloqueio de tópico de discussão';
$string['discussionmoved'] = 'Este tópico foi transferido para \'{$a}\'.';
$string['discussionmovedpost'] = 'Este tópico foi transferido para <a href="{$a->discusshref}">aqui</a> no fórum <a href="{$a->forumhref}">{$a->forumname}</a>';
$string['discussionname'] = 'Designação da discussão';
$string['discussionnownotsubscribed'] = '{$a->name} NÃO será notificado(a) sobre os novos tópicos em \'{$a->discussion}\' do fórum \'{$a->forum}\'';
$string['discussionnowsubscribed'] = 'Será notificado sobre os novos tópicos em \'{$a->discussion}\' do fórum \'{$a->forum}\'.';
$string['discussionpin'] = 'Destacar';
$string['discussionpinned'] = 'Destacado';
$string['discussionpinned_help'] = 'As discussões em destaque irão aparecer no topo do fórum.';
$string['discussions'] = 'Tópicos';
$string['discussionsplit'] = 'A discussão foi dividida';
$string['discussionsstartedby'] = 'Tópicos iniciados por {$a}';
$string['discussionsstartedbyrecent'] = 'Tópicos iniciados recentemente por {$a}';
$string['discussionsstartedbyuserincourse'] = 'Discussões iniciadas por {$a->fullname} em {$a->coursename}';
$string['discussionsstartedincourse'] = 'Tópicos iniciados em {$a}';
$string['discussionstartedby'] = 'Tópico iniciado por {$a}';
$string['discussionsubscribed'] = 'Está subscrito neste tópico.';
$string['discussionsubscribestart'] = 'Envie-me notificações de novos tópicos desta discussão';
$string['discussionsubscribestop'] = 'Não quero receber notificações de novos tópicos desta discussão';
$string['discussionsubscription'] = 'Subscrição da discussão';
$string['discussionsubscription_help'] = 'Subscrever um tópico de discussão significa que irá receber notificações dos novos tópicos publicados nessa discussão.';
$string['discussionunpin'] = 'Remover destaque';
$string['discussionunsubscribed'] = 'Não está subscrito neste tópico.';
$string['discussthistopic'] = 'Discutir este tópico';
$string['discusstopicname'] = 'Discutir o tópico: {$a}';
$string['displayend'] = 'Visível até';
$string['displayend_help'] = 'Esta configuração permite ocultar um tópico a partir de uma determinada data. Os administradores podem sempre visualizar estes tópicos.';
$string['displayenddate'] = 'Visível até: {$a}.';
$string['displaymode'] = 'Modo de visualização';
$string['displayperiod'] = 'Período de visualização';
$string['displaystart'] = 'Visível a partir de';
$string['displaystart_help'] = 'Esta configuração permite mostrar um tópico apenas a partir de uma determinada data. Os administradores podem sempre visualizar estes tópicos.';
$string['displaystartdate'] = 'Visível a partir de: {$a}.';
$string['displaywordcount'] = 'Exibir contagem de palavras';
$string['displaywordcount_help'] = 'Especifica se é, ou não, exibida a contagem de palavras de cada publicação.';
$string['duedate'] = 'Data limite para publicar';
$string['duedate_help'] = 'Se definida, será a data limite para publicação no fórum. Embora esta data seja exibida no calendário como a data de fim do prazo para publicar no fórum, ainda será possível publicar no fórum após esta data. Para evitar publicações no fórum após uma determinada data, defina a data de fecho do fórum.';
$string['duedatetodisplayincalendar'] = 'Data limite a exibir no calendário';
$string['eachuserforum'] = 'Cada participante cria um tópico';
$string['edit'] = 'Editar';
$string['editdiscussion'] = 'Editar tópico';
$string['editdiscussiontopic'] = 'Editar tópico de discussão';
$string['editedby'] = 'Editado por {$a->name} - {$a->date}';
$string['editedpostupdated'] = 'A mensagem de {$a} foi atualizada';
$string['editing'] = 'A editar';
$string['emaildigestcompleteshort'] = 'Completo';
$string['emaildigestdefault'] = 'Predefinido ({$a})';
$string['emaildigestoffshort'] = 'Sem resumo';
$string['emaildigestsubjectsshort'] = 'Assuntos';
$string['emaildigesttype'] = 'Opções do resumo de fóruns';
$string['emaildigesttype_help'] = 'Tipos de resumos que vai receber diariamente para cada fórum:

*Predefinido: de acordo com a configuração do resumo de fóruns do seu perfil do utilizador. Se atualizar o seu perfil, essa alteração também se vai refletir aqui;

*Sem resumo: irá receber um e-mail por cada mensagem publicada no fórum;

*Completo: irá receber um e-mail diário com o conteúdo completo de cada mensagem publicada no fórum;

*Assuntos: irá receber um e-mail diário com os assuntos de cada mensagem publicada no fórum.';
$string['emptymessage'] = 'Foi encontrado um erro na sua mensagem. Ou estava em branco ou continha um anexo demasiado grande. As suas alterações não foram guardadas.';
$string['errorcannotlock'] = 'Não tem permissão para bloquear tópicos.';
$string['errordiscussionnotfound'] = 'O tópico não foi encontrado';
$string['erroremptymessage'] = 'O texto da mensagem não pode estar em branco';
$string['erroremptysubject'] = 'A assunto da mensagem não pode estar em branco';
$string['errorenrolmentrequired'] = 'Tem de estar inscrito nesta disciplina para aceder a este conteúdo';
$string['errorforumnotfound'] = 'Não foi encontrado o fórum ao qual pertence este tópico';
$string['errorwhiledelete'] = 'Ocorreu um erro ao apagar';
$string['eventassessableuploaded'] = 'Foi publicado algum conteúdo.';
$string['eventcoursesearched'] = 'Disciplina procurada';
$string['eventdiscussioncreated'] = 'Discussão criada';
$string['eventdiscussiondeleted'] = 'Discussão eliminada';
$string['eventdiscussionlockupdated'] = 'Bloqueio de tópico de discussão atualizado';
$string['eventdiscussionmoved'] = 'Discussão movida';
$string['eventdiscussionpinned'] = 'Tópico de discussão destacado';
$string['eventdiscussionsubscriptioncreated'] = 'Subscrição da discussão criada';
$string['eventdiscussionsubscriptiondeleted'] = 'Subscrição da discussão apagada';
$string['eventdiscussionunpinned'] = 'Foi removido o destaque do tópico de discussão';
$string['eventdiscussionupdated'] = 'Discussão atualizada';
$string['eventdiscussionviewed'] = 'Discussão visualizada';
$string['eventforumsubscriptionupdated'] = 'Modo de subscrição atualizado';
$string['eventpostcreated'] = 'Tópico criado';
$string['eventpostdeleted'] = 'Tópico eliminado';
$string['eventpostupdated'] = 'Tópico atualizado';
$string['eventreadtrackingdisabled'] = 'Sinalização de mensagens não lidas desativada';
$string['eventreadtrackingenabled'] = 'Sinalização de mensagens não lidas ativada';
$string['eventsubscribersviewed'] = 'Subscritores visualizados';
$string['eventsubscriptioncreated'] = 'Subscrição criada';
$string['eventsubscriptiondeleted'] = 'Subscrição eliminada';
$string['eventuserreportviewed'] = 'Relatório do utilizador visualizado';
$string['everyonecanchoose'] = 'Todos podem optar por subscrever';
$string['everyonecannowchoose'] = 'Todos podem optar por subscrever, a partir deste momento';
$string['everyoneisnowsubscribed'] = 'Todos estão agora subscritos';
$string['everyoneissubscribed'] = 'Todos têm subscrição ativa neste fórum';
$string['existingsubscribers'] = 'Subscrições ativas';
$string['export'] = 'Exportar';
$string['exportattachmentname'] = 'Exportar anexo {$a} para o portefólio';
$string['exportdiscussion'] = 'Exporta toda a discussão para o portefólio';
$string['exporthumandates'] = 'Datas legíveis por humanos';
$string['exporthumandates_help'] = 'Se as datas devem, ou não, ser exportadas num formato legível por humanos ou como um \'timestamp\' (sequência de números).';
$string['exportoptions'] = 'Opções de exportação';
$string['exportstriphtml'] = 'Remover HTML';
$string['exportstriphtml_help'] = 'Se as tags HTML, como por exemplo, p e br, devem, ou não, ser removidas das mensagem publicadas no fórum.';
$string['favourites'] = 'Com estrela';
$string['favouriteupdated'] = 'A opção de marcar com estrela foi atualizada.';
$string['firstpost'] = 'Primeiro tópico';
$string['forcedreadtracking'] = 'Permitir sinalização obrigatória de mensagens não lidas';
$string['forcedreadtracking_desc'] = 'Se ativar esta opção, será permitido que os fóruns sejam configurados para assinalar obrigatoriamente as mensagens não lidas. Esta opção pode influenciar o desempenho do Moodle, particularmente em disciplinas com muitos fóruns/tópicos. Se desativada, quaisquer fóruns previamente definidos com sinalização obrigatória são tratados como se tivessem sinalização opcional.';
$string['forcesubscribed'] = 'Este fórum é de subscrição obrigatória.';
$string['forcesubscribed_help'] = 'Este fórum foi configurado para que não seja possível cancelar a subscrição dos tópicos de discussão.';
$string['forum'] = 'Fórum';
$string['forum:addinstance'] = 'Adicionar novo fórum';
$string['forum:addnews'] = 'Adicionar anúncios';
$string['forum:addquestion'] = 'Adicionar pergunta';
$string['forum:allowforcesubscribe'] = 'Permitir forçar a subscrição';
$string['forum:canmailnow'] = 'Pode publicar no fórum de perguntas e respostas sem atraso no tempo de edição';
$string['forum:canoverridecutoff'] = 'Publicar em fóruns após a data limite';
$string['forum:canoverridediscussionlock'] = 'Responder a tópicos de discussão bloqueados';
$string['forum:canposttomygroups'] = 'Publicar para todos os grupos a que tem acesso';
$string['forum:cantogglefavourite'] = 'Marcar tópicos com estrela';
$string['forum:createattachment'] = 'Criar anexos';
$string['forum:deleteanypost'] = 'Apagar qualquer mensagem (em qualquer altura)';
$string['forum:deleteownpost'] = 'Apagar as suas próprias mensagens (dentro do prazo)';
$string['forum:editanypost'] = 'Editar qualquer mensagem';
$string['forum:exportdiscussion'] = 'Exportar toda a discussão';
$string['forum:exportforum'] = 'Exportar fórum';
$string['forum:exportownpost'] = 'Exportar mensagem do próprio';
$string['forum:exportpost'] = 'Exportar mensagem';
$string['forum:grade'] = 'Avaliar fórum';
$string['forum:managesubscriptions'] = 'Gerir subscritores';
$string['forum:movediscussions'] = 'Mover tópicos';
$string['forum:pindiscussions'] = 'Destacar tópicos de discussão';
$string['forum:postprivatereply'] = 'Responder aos tópicos em privado';
$string['forum:postwithoutthrottling'] = 'Isento do bloqueio por ultrapassar limite de mensagens submetidas';
$string['forum:rate'] = 'Avaliar mensagens';
$string['forum:readprivatereplies'] = 'Ver respostas privadas';
$string['forum:replynews'] = 'Responder a anúncios';
$string['forum:replypost'] = 'Responder a mensagens';
$string['forum:splitdiscussions'] = 'Separar tópicos';
$string['forum:startdiscussion'] = 'Criar novos tópicos de discussão';
$string['forum:viewallratings'] = 'Ver as avaliações atribuídas por cada participante';
$string['forum:viewanyrating'] = 'Ver a avaliação global de cada participante';
$string['forum:viewdiscussion'] = 'Ver tópicos de discussão';
$string['forum:viewhiddentimedposts'] = 'Ver mensagens fora do período de visualização';
$string['forum:viewqandawithoutposting'] = 'Ver sempre mensagens perguntas-resposta';
$string['forum:viewrating'] = 'Ver a avaliação global que recebeu';
$string['forum:viewsubscribers'] = 'Ver lista de subscritores';
$string['forumauthorhidden'] = 'Autor (oculto)';
$string['forumblockingalmosttoomanyposts'] = 'Esta a aproximar-se do número limite de mensagens submetidas. Enviou {$a->numposts} mensagens no período de {$a->blockperiod} e o limite é de {$a->blockafter} mensagens.';
$string['forumbodydeleted'] = 'O conteúdo deste tópico do fórum foi removido e não pode voltar a ser acedido.';
$string['forumbodyhidden'] = 'De momento, não pode visualizar esta mensagem, provavelmente porque ainda não submeteu uma mensagem no tópico de discussão e as notificações do fórum ainda não foram enviadas. Outra possibilidade é que a data/hora atual não esteja dentro do período de exibição definido para a mensagem.';
$string['forumgrader'] = 'Avaliador do fórum';
$string['forumgradingnavigation'] = 'Navegação da avaliação do fórum';
$string['forumgradingpanel'] = 'Painel de avaliação do fórum';
$string['forumintro'] = 'Descrição';
$string['forumname'] = 'Designação';
$string['forumposts'] = 'Mensagens no fórum';
$string['forums'] = 'Fóruns';
$string['forumsubjectdeleted'] = 'Este tópico do fórum foi eliminado';
$string['forumsubjecthidden'] = 'Assunto (oculto)';
$string['forumtracked'] = 'As mensagens não lidas estão a ser assinaladas';
$string['forumtrackednot'] = 'As mensagens não lidas não estão a ser assinaladas';
$string['forumtype'] = 'Tipo de fórum';
$string['forumtype_help'] = 'Existem 5 tipos de fóruns:

* Um único tópico de discussão - Discussão com um só tópico ao qual todos podem responder (não pode ser usado com grupos separados)
* Cada participante cria um tópico - Cada aluno pode colocar apenas um tópico de discussão ao qual todos podem responder
* Fórum de perguntas e respostas - O aluno tem de responder primeiro à pergunta antes de poder visualizar as respostas dos colegas
* Fórum standard em formato blogue - Fórum aberto no qual todos os participantes podem criar novos tópicos e em que cada tópico de discussão é exibido numa página com a hiperligação "Discutir este tópico"
* Fórum standard para utilização geral - Fórum aberto no qual todos os participantes podem criar novos tópicos';
$string['generalforum'] = 'Fórum standard para utilização geral';
$string['generalforums'] = 'Fóruns gerais';
$string['grade_forum_header'] = 'Avaliação global do fórum';
$string['grade_forum_name'] = 'Todo o fórum';
$string['grade_forum_title'] = 'Nota';
$string['grade_rating_name'] = 'Avaliação';
$string['graded'] = 'Avaliada';
$string['gradedby'] = 'Avaliado por';
$string['gradeforrating'] = 'Nota da avaliação: {$a->str_long_grade}';
$string['gradeforratinghidden'] = 'Nota da avaliação oculta';
$string['gradeforwholeforum'] = 'Nota do fórum: {$a->str_long_grade}';
$string['gradeforwholeforumhidden'] = 'Nota do fórum oculta';
$string['gradeitem:forum'] = 'Fórum';
$string['gradeitemnameforrating'] = 'Avaliação de {$a->name}';
$string['gradeitemnameforwholeforum'] = 'Avaliação de {$a->name} no fórum';
$string['grades:gradesavedfor'] = 'Foi guardada a nota de {$a->fullname}';
$string['grades:gradesavefailed'] = 'Não foi possível guardar a nota de {$a->fullname}: {$a->error}';
$string['gradeusers'] = 'Avaliar utilizadores';
$string['grading'] = 'A avaliar';
$string['gradingstatus'] = 'Estado da avaliação:';
$string['hiddenforumpost'] = 'Tópico do fórum oculto';
$string['hidegraderpanel'] = 'Ocultar painel do avaliador';
$string['hidepreviousrepliescount'] = 'Ocultar respostas anteriores ({$a})';
$string['hideusersearch'] = 'Ocultar pesquisa de utilizador';
$string['indexoutoftotal'] = '{$a->index} de {$a->total}';
$string['indicator:cognitivedepth'] = 'Compreensão do Fórum';
$string['indicator:cognitivedepth_help'] = 'Este indicador é baseado na capacidade cognitiva alcançada pelo aluno na atividade Fórum.';
$string['indicator:cognitivedepthdef'] = 'Compreensão do Fórum';
$string['indicator:cognitivedepthdef_help'] = 'O participante alcançou esta percentagem da capacidade cognitiva oferecida pelas atividades Fórum durante esse intervalo de análise (Níveis = Não visualizado, Visualizado, Submetido, Feedback visualizado, Comentários ao feedback, Voltar a submeter após visualizar feedback)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Socialização do Fórum';
$string['indicator:socialbreadth_help'] = 'Este indicador é baseado na extensão social alcançada pelo aluno na atividade Fórum.';
$string['indicator:socialbreadthdef'] = 'Socialização do Fórum';
$string['indicator:socialbreadthdef_help'] = 'O participante alcançou esta percentagem do relacionamento social oferecido pelas atividades Fórum durante esse intervalo de análise (Níveis = Sem participação, Participante individual, Participante com outros)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['inforum'] = 'em {$a}';
$string['inreplyto'] = 'Em resposta a \'{$a}\'';
$string['introblog'] = 'As mensagens neste fórum foram copiadas automaticamente de blogues de utilizadores desta disciplina e já não se encontram disponíveis';
$string['intronews'] = 'Notícias gerais e anúncios';
$string['introsocial'] = 'Um fórum aberto para conversar sobre qualquer assunto';
$string['introteacher'] = 'Um fórum reservado aos professores';
$string['invalidaccess'] = 'Esta página não foi acedida corretamente';
$string['invaliddigestsetting'] = 'Foi fornecida uma configuração inválida para a opção de e-mail com resumo';
$string['invaliddiscussionid'] = 'O ID do tópico estava incorreto ou já não existe';
$string['invalidforcesubscribe'] = 'Modo de subscrição obrigatória inválido';
$string['invalidforumid'] = 'O ID do fórum estava incorreto';
$string['invalidparentpostid'] = 'ID da mensagem ascendente é inválido';
$string['invalidpostid'] = 'ID da mensagem inválido - {$a}';
$string['lastpost'] = 'Última mensagem';
$string['learningforums'] = 'Fóruns de aprendizagem';
$string['lockdiscussion'] = 'Bloquear este tópico';
$string['lockdiscussionafter'] = 'Bloquear tópicos de discussão após período de inatividade';
$string['lockdiscussionafter_help'] = 'Os tópicos de discussão podem ser bloqueados automaticamente após decorrer um intervalo de tempo especificado desde a última resposta.

Os utilizadores com permissão para responder a tópicos de discussão bloqueados podem desbloquear um tópico se adicionarem uma resposta ao tópico.';
$string['locked'] = 'Bloqueado';
$string['lockupdated'] = 'A opção de bloquear foi atualizada.';
$string['longpost'] = 'Mensagem longa';
$string['mailnow'] = 'Enviar imediatamente a notificação por e-mail';
$string['managesubscriptionsoff'] = 'Terminar a gestão de subscrições';
$string['managesubscriptionson'] = 'Gerir subscritores';
$string['manydiscussions'] = 'Tópicos por página';
$string['markalldread'] = 'Marcar como lidas todas as mensagens deste tópico.';
$string['markallread'] = 'Marcar como lidas todas as mensagens deste fórum.';
$string['markasread'] = 'Marcar como lido';
$string['markasreadonnotification'] = 'Ao enviar notificações de mensagens do fórum';
$string['markasreadonnotification_help'] = 'Ao receber uma notificação de uma mensagem de um fórum, pode escolher se a mensagem fica, ou não, marcada como lida para fins de sinalização de mensagens do fórum.';
$string['markasreadonnotificationno'] = 'Não marcar a mensagem como lida';
$string['markasreadonnotificationyes'] = 'Marcar a mensagem como lida';
$string['markread'] = 'Marcar como lido';
$string['markreadbutton'] = 'Marcar<br />lido';
$string['markunread'] = 'Marcar como não lida';
$string['markunreadbutton'] = 'Marcar<br /> não lido';
$string['maxattachments'] = 'Número máximo de anexos';
$string['maxattachments_help'] = 'Número máximo de ficheiros que pode ser anexado a uma mensagem do fórum.';
$string['maxattachmentsize'] = 'Tamanho máximo dos anexos';
$string['maxattachmentsize_help'] = 'Esta configuração determina o tamanho máximo de cada ficheiro que pode ser anexado às mensagens do fórum.';
$string['maxtimehaspassed'] = 'Lamentamos mas ultrapassou o tempo máximo ({$a}) para editar esta mensagem!';
$string['message'] = 'Mensagem';
$string['messageinboundattachmentdisallowed'] = 'Não é possível publicar a sua resposta, uma vez que inclui um anexo e o fórum não permite anexos.';
$string['messageinboundfilecountexceeded'] = 'Não é possível publicar a sua resposta, uma vez que ultrapassa o número máximo de anexos permitidos no fórum ({$a->forum->maxattachments}).';
$string['messageinboundfilesizeexceeded'] = 'Não é possível publicar a sua resposta, uma vez que o tamanho total de anexos ({$a->filesize}) é maior do que o tamanho máximo permitido para o fórum ({$a->maxbytes}).';
$string['messageinboundforumhidden'] = 'Não é possível publicar a sua resposta, uma vez que o fórum se encontra atualmente indisponível.';
$string['messageinboundnopostforum'] = 'Não é possível publicar a sua resposta, uma vez que não tem permissão para publicar no fórum {$a->forum->name}.';
$string['messageinboundthresholdhit'] = 'Não é possível publicar a sua resposta. Excedeu o número máximo de mensagens definido para este fórum.';
$string['messageprovider:digests'] = 'Fóruns com subscrição ativa';
$string['messageprovider:posts'] = 'Resumos de fóruns com subscrição ativa';
$string['missingsearchterms'] = 'Os termos de pesquisa que se seguem só foram encontrados no código HTML desta mensagem:';
$string['modeflatnewestfirst'] = 'Mostrar respostas por ordem, a começar pela mais recente';
$string['modeflatoldestfirst'] = 'Mostrar respostas por ordem, a começar pela mais antiga';
$string['modenested'] = 'Mostrar respostas em lista encadeada';
$string['modenestedv2'] = 'Mostrar respostas em lista encadeada (experimental)';
$string['modethreaded'] = 'Mostrar respostas em lista contraída';
$string['modulename'] = 'Fórum';
$string['modulename_help'] = 'A atividade Fórum permite aos participantes ter discussões em modo assíncrono.

Existem vários tipos de fórum, como o fórum standard onde qualquer participante pode começar uma nova discussão, o fórum onde cada aluno pode colocar apenas um tópico de discussão ou o fórum de perguntas e respostas no qual os alunos devem primeiro responder a um tópico (pergunta) para conseguirem ver as respostas dos colegas. O professor pode optar por permitir que sejam anexados ficheiros às mensagens, cujo conteúdo, quando são imagens, é exibido na própria mensagem.

Os participantes podem subscrever um fórum de forma a receber notificações sempre que são submetidas novas mensagens no mesmo. O professor pode configurar a subscrição para o modo opcional, obrigatória ou opcional (ativa no início) ou desativá-la. Se necessário, os alunos podem ser impedidos de inserir mais do que um determinado número de mensagens num determinado período de tempo, no sentido de impedir que alguns alunos dominem as discussões.

As mensagens podem ser avaliadas por professores ou alunos (avaliação pelos pares). As avaliações são convertidas numa nota final que é registada na pauta da disciplina.

Os fóruns podem ser utilizados com várias finalidades, tais como:

* Espaço introdutório para possibilitar interação social entre os participantes;
* Local para divulgar informação relativa à disciplina (usando o fórum de anúncios, que tem subscrição obrigatória);
* Um meio de ajuda, onde professores e alunos podem dar conselhos;
* Um método informal de partilha de documentos entre alunos;
* Para continuar a discussão de um assunto iniciado presencialmente na sala de aula;
* Um local de discussão entre professores (usando um fórum oculto);
* Para as atividades de estudos de caso, onde os alunos refletem e partilham opiniões sobre a sua solução;
* Um espaço social de partilha de ideias.';
$string['modulename_link'] = 'fórum';
$string['modulenameplural'] = 'Fóruns';
$string['more'] = 'mais';
$string['movedmarker'] = '(Movido)';
$string['movethisdiscussionlabel'] = 'Mover a conversação atual para o fórum especificado';
$string['movethisdiscussionto'] = 'Mover este tópico de discussão para...';
$string['mustprovidediscussionorpost'] = 'Tem de fornecer o ID do tópico ou o ID da mensagem para exportar.';
$string['myprofileotherdis'] = 'Tópicos de discussão';
$string['myprofileowndis'] = 'Os meus tópicos de discussão';
$string['myprofileownpost'] = 'As minhas mensagens em fóruns';
$string['namenews'] = 'Anúncios';
$string['namenews_help'] = 'O fórum Anúncios da disciplina é um fórum especial, criado automaticamente aquando da criação da disciplina. Apenas pode existir um fórum Anúncios por disciplina e apenas os utilizadores com papel de professor ou de administrador podem publicar tópicos de discussão neste fórum. O bloco "Últimos Anúncios" exibe os últimos tópicos adicionados ao fórum Anúncios.';
$string['namesocial'] = 'Fórum social';
$string['nameteacher'] = 'Fórum de professores';
$string['newforumposts'] = 'Novas mensagens no fórum';
$string['nextdiscussiona'] = 'Próximo tópico de discussão: {$a}';
$string['nextuser'] = 'Guardar as alterações e prosseguir para o utilizador seguinte';
$string['noattachments'] = 'Esta mensagem não tem anexos';
$string['nodiscussions'] = 'Ainda não existem tópicos de discussão neste fórum.';
$string['nodiscussionsstartedby'] = '{$a} não iniciou nenhum tópico de discução';
$string['nodiscussionsstartedbyyou'] = 'Ainda não começou nenhuma discussão';
$string['noguestpost'] = 'Apenas utilizadores autenticados podem submeter mensagens neste fórum.';
$string['noguestpost:title'] = 'Autentique-se para continuar';
$string['noguestsubscribe'] = 'Os convidados não têm permissão para subscrever um fórum.';
$string['noguesttracking'] = 'Lamentamos mas como visitante não pode assinalar mensagens não lidas.';
$string['nomorepostscontaining'] = 'Não foram encontradas mais mensagens contendo \'{$a}';
$string['nonews'] = 'Ainda não foram publicados anúncios';
$string['noonecansubscribenow'] = 'A partir de agora, não há subscrições ativas';
$string['nopermissiontosubscribe'] = 'Não tem permissão para ver os subscritores do fórum';
$string['nopermissiontoview'] = 'Não tem permissões para ver esta mensagem';
$string['nopostforum'] = 'Não tem permissão para publicar mensagens neste fórum';
$string['noposts'] = 'Nenhuma mensagem';
$string['nopostsmadebyuser'] = '{$a} não inseriu mensagens';
$string['nopostsmadebyyou'] = 'Ainda não publicou nenhuma mensagem';
$string['noquestions'] = 'Ainda não existem questões neste fórum.';
$string['nosubscribers'] = 'Ainda não existem subscritores neste fórum.';
$string['notexists'] = 'O tópico já não existe';
$string['notgraded'] = 'Não avaliado';
$string['nothingnew'] = 'Nenhuma novidade em {$a}';
$string['notingroup'] = 'Tem de pertencer a algum grupo para poder visualizar este fórum.';
$string['notinstalled'] = 'O módulo Fórum não está instalado';
$string['notlocked'] = 'Bloquear';
$string['notpartofdiscussion'] = 'Esta mensagem não faz parte de um tópico de discussão!';
$string['notrackforum'] = 'Não assinalar mensagens não lidas';
$string['notsubscribed'] = 'Subscrever';
$string['nousersmatch'] = 'Não foi encontrado nenhum utilizador para os critérios definidos';
$string['noviewdiscussionspermission'] = 'Não tem as permissão para ver os tópicos deste fórum.';
$string['nowallsubscribed'] = 'Foi efetuada a subscrição em todos os fóruns de {$a}.';
$string['nowallunsubscribed'] = 'Foi cancelada a subscrição em todos os fóruns de {$a}.';
$string['nowgradinguser'] = 'A avaliar {$a}';
$string['nownotsubscribed'] = '{$a->name} NÃO receberá cópias do fórum \'{$a->forum}\' por e-mail.';
$string['nownottracking'] = 'Já não serão assinaladas as mensagens não lidas por {$a->name} em \'{$a->forum}\'.';
$string['nowsubscribed'] = 'Será notificado sobre novas mensagens no fórum \'{$a->forum}\'.';
$string['nowtracking'] = 'As mensagens não lidas por {$a->name} em \'{$a->forum}\' passarão a ser assinaladas.';
$string['numberofreplies'] = 'Número de respostas: {$a}';
$string['numposts'] = '{$a} mensagens';
$string['olderdiscussions'] = 'Tópicos de discussão mais antigos';
$string['oldertopics'] = 'Tópicos mais antigos';
$string['oldpostdays'] = 'Mensagem considerada lida após n.º de dias';
$string['page-mod-forum-discuss'] = 'Página de discussão do fórum';
$string['page-mod-forum-view'] = 'Página principal do fórum';
$string['page-mod-forum-x'] = 'Qualquer página da atividade fórum';
$string['parent'] = 'Mostrar mensagem ascendente';
$string['parentofthispost'] = 'Ascendente desta mensagem';
$string['permalink'] = 'Hiperligação permanente';
$string['permanentlinktoparentpost'] = 'Hiperligação permanente para a mensagem inicial deste tópico';
$string['permanentlinktopost'] = 'Hiperligação permanente para este tópico';
$string['pindiscussion'] = 'Destacar este tópico';
$string['pinupdated'] = 'A opção de destacar foi atualizada.';
$string['pluginadministration'] = 'Administração do Fórum';
$string['pluginname'] = 'Fórum';
$string['post'] = 'Tópico';
$string['postadded'] = '<p>A sua mensagem foi submetida com sucesso.</p><p>Tem {$a} para a editar, caso pretenda fazer alterações.</p>';
$string['postaddedsuccess'] = 'A sua mensagem foi submetida com sucesso.';
$string['postaddedtimeleft'] = 'Caso pretenda fazer alterações, tem {$a} para editar.';
$string['postbymailsuccess'] = 'A sua resposta "{$a->subject}" foi publicada com sucesso: {$a->discussionurl}.';
$string['postbymailsuccess_html'] = 'A sua resposta <a href="{$a->discussionurl}">{$a->subject}</a> foi publicada com sucesso.';
$string['postbyuser'] = '{$a->post} por {$a->user}';
$string['postincontext'] = 'Ver esta mensagem no contexto';
$string['postisprivatereply'] = 'Esta mensagem é uma resposta privada. (Os professores, e qualquer utilizador com a permissão de visualizar respostas privadas, também poderão visualizar).';
$string['postmailinfo'] = 'Esta é uma cópia de uma mensagem publicada em {$a}';
$string['postmailnow'] = '<p>Esta mensagem será enviada imediatamente a todos os subscritores do fórum.</p>';
$string['postmailreply'] = 'Para responder, clique nesta hiperligação: {$a}';
$string['postmailsubject'] = '{$a->courseshortname}: {$a->subject}';
$string['posts'] = 'Mensagens';
$string['postsfrom'] = 'Desde';
$string['postsmadebyuser'] = 'Mensagens colocadas por {$a}';
$string['postsmadebyuserincourse'] = 'Mensagens colocadas por {$a->fullname} em {$a->coursename}';
$string['postsmadeincourse'] = 'Mensagens publicadas em {$a}';
$string['poststo'] = 'Até';
$string['posttoforum'] = 'Submeter';
$string['posttomygroups'] = 'Submeter uma cópia em todos os grupos';
$string['posttomygroups_help'] = 'Submete uma cópia desta mensagem em todos os grupos a que tem acesso. Os utilizadores que pertençam a grupos a que não tem acesso não irão ver esta mensagem.';
$string['postupdated'] = 'A sua mensagem foi atualizada';
$string['potentialsubscribers'] = 'Potenciais subscritores';
$string['prevdiscussiona'] = 'Tópico de discussão anterior: {$a}';
$string['previoususer'] = 'Guardar as alterações e prosseguir para o utilizador anterior';
$string['privacy:digesttypenone'] = 'Não mantemos dados relacionados com preferências dos resumos de fóruns para este fórum.';
$string['privacy:digesttypepreference'] = 'Escolheu receber o resumo de fóruns do seguinte tipo: "{$a->type}".';
$string['privacy:discussionsubscriptionpreference'] = 'Escolheu este tipo de preferência de subscrição de discussão deste fórum: "{$a->preference}"';
$string['privacy:metadata:core_rating'] = 'O fórum utiliza o subsistema de avaliação para suportar a avaliação dos tópicos.';
$string['privacy:metadata:core_tag'] = 'O fórum utiliza o subsistema de palavras-chave para suportar as palavras chave dos tópicos.';
$string['privacy:metadata:forum_digests'] = 'Informação sobre preferências do resumo para cada fórum.';
$string['privacy:metadata:forum_digests:forum'] = 'O fórum subscrito.';
$string['privacy:metadata:forum_digests:maildigest'] = 'Preferência do resumo';
$string['privacy:metadata:forum_digests:userid'] = 'ID do utilizador com a preferência do resumo.';
$string['privacy:metadata:forum_discussion_subs'] = 'Informação sobre subscrições a fóruns de discussão individuais';
$string['privacy:metadata:forum_discussion_subs:discussionid'] = 'O ID da discussão que foi subscrita.';
$string['privacy:metadata:forum_discussion_subs:preference'] = 'A hora de início da subscrição';
$string['privacy:metadata:forum_discussion_subs:userid'] = 'ID do utilizador com subscrição da discussão.';
$string['privacy:metadata:forum_discussions'] = 'Informação sobre o fórum de discussão individual que o utilizador criou';
$string['privacy:metadata:forum_discussions:assessed'] = 'TODOD - o que este campo armazena';
$string['privacy:metadata:forum_discussions:name'] = 'O nome da discussão, conforme escolhido pelo autor.';
$string['privacy:metadata:forum_discussions:timemodified'] = 'Data e hora da última modificação da discussão.';
$string['privacy:metadata:forum_discussions:userid'] = 'ID do utilizador que criou a discussão';
$string['privacy:metadata:forum_discussions:usermodified'] = 'O ID do utilizador que modificou pela última vez a discussão de alguma forma.';
$string['privacy:metadata:forum_grades'] = 'Dados da nota do fórum';
$string['privacy:metadata:forum_grades:forum'] = 'O fórum que foi avaliado';
$string['privacy:metadata:forum_grades:grade'] = 'A nota obtida';
$string['privacy:metadata:forum_grades:userid'] = 'O utilizador avaliado';
$string['privacy:metadata:forum_posts'] = 'Informação sobre preferências do resumo para cada fórum.';
$string['privacy:metadata:forum_posts:created'] = 'A data e hora a que o tópico foi criado.';
$string['privacy:metadata:forum_posts:discussion'] = 'A discussão em que o tópico está.';
$string['privacy:metadata:forum_posts:message'] = 'A mensagem do tópico do fórum.';
$string['privacy:metadata:forum_posts:modified'] = 'A data e hora em que o tópico foi modificado pela última vez.';
$string['privacy:metadata:forum_posts:parent'] = 'A publicação principal que foi respondida.';
$string['privacy:metadata:forum_posts:privatereplyto'] = 'O ID do utilizador para o qual esta resposta foi enviada.';
$string['privacy:metadata:forum_posts:subject'] = 'O assunto do tópico do fórum';
$string['privacy:metadata:forum_posts:totalscore'] = 'A mensagem do tópico do fórum';
$string['privacy:metadata:forum_posts:userid'] = 'O ID do utilizador que criou o tópico no fórum.';
$string['privacy:metadata:forum_queue'] = 'Registo temporário dos tópicos que serão enviados na forma de resumo';
$string['privacy:metadata:forum_queue:discussionid'] = 'ID da discussão do fórum';
$string['privacy:metadata:forum_queue:postid'] = 'ID do tópico do fórum';
$string['privacy:metadata:forum_queue:timemodified'] = 'A hora de modificação do tópico original';
$string['privacy:metadata:forum_queue:userid'] = 'Utilizador que precisa de ser notificado sobre o tópico';
$string['privacy:metadata:forum_read'] = 'Informação sobre que tópicos foram lidos pelo utilizador.';
$string['privacy:metadata:forum_read:discussionid'] = 'A discussão em que o tópico está.';
$string['privacy:metadata:forum_read:firstread'] = 'A primeira vez que o tópico foi lido.';
$string['privacy:metadata:forum_read:lastread'] = 'A hora em que o tópico foi lido mais recentemente.';
$string['privacy:metadata:forum_read:postid'] = 'O tópico que foi lido.';
$string['privacy:metadata:forum_read:userid'] = 'O ID de utilizador relacionado com este registo.';
$string['privacy:metadata:forum_subscriptions'] = 'Informação sobre que fóruns o utilizador subscreveu.';
$string['privacy:metadata:forum_subscriptions:forum'] = 'O fórum que foi subscrito.';
$string['privacy:metadata:forum_subscriptions:userid'] = 'O ID do utilizador relacionado com esta subscrição de fórum.';
$string['privacy:metadata:forum_track_prefs'] = 'Informação sobre que fóruns o utilizador escolheu assinalar mensagens não lidas.';
$string['privacy:metadata:forum_track_prefs:forumid'] = 'O fórum que tem a sinalização de mensagens ativa.';
$string['privacy:metadata:forum_track_prefs:userid'] = 'O ID do utilizador com que se relacionam as preferências de sinalização de mensagens.';
$string['privacy:metadata:preference:autosubscribe'] = 'Se subscreve a discussão quando responde a tópicos da discussão.';
$string['privacy:metadata:preference:forum_discussionlistsortorder'] = 'A ordem predefinida da lista de tópicos.';
$string['privacy:metadata:preference:maildigest'] = 'A preferência global dos resumos de fóruns.';
$string['privacy:metadata:preference:markasreadonnotification'] = 'Se deve marcar os tópicos dos fóruns como lidos quando os recebe como mensagens.';
$string['privacy:metadata:preference:trackforums'] = 'Se ativa, ou não, a sinalização de mensagens nos fóruns.';
$string['privacy:postwasread'] = 'Este tópico foi lido primeiro em  {$a->firstread} e mais recentemente em {$a->lastread}';
$string['privacy:readtrackingdisabled'] = 'Escolheu não assinalar os tópicos que já leu neste fórum';
$string['privacy:request:delete:discussion:name'] = 'Apagado a pedido do autor';
$string['privacy:request:delete:post:message'] = 'O conteúdo deste tópico foi apagado a pedido do autor.';
$string['privacy:request:delete:post:subject'] = 'Apagado a pedido do autor';
$string['privacy:subscribedtoforum'] = 'Está subscrito neste fórum';
$string['privatereply'] = 'Responder em privado';
$string['privatereply_help'] = 'Quando responde em privado, a sua resposta também fica visível para utilizadores com a permissão de visualizar respostas privadas, como por exemplo, os professores.';
$string['processingdigest'] = 'A processar resumos para o utilizador {$a}';
$string['processingpost'] = 'A processar a mensagem {$a}';
$string['prune'] = 'Separar';
$string['prunediscussion'] = 'Dividir tópico';
$string['prunedpost'] = 'Foi criado um novo tópico, a partir desta mensagem';
$string['pruneheading'] = 'Separar esta mensagem e as suas respostas para um novo tópico deste fórum';
$string['qandaforum'] = 'Fórum de perguntas e respostas';
$string['qandanotify'] = 'Este é um fórum de perguntas e respostas. Para poder ver as outras respostas, tem de enviar primeiro a sua resposta.';
$string['re'] = 'Re:';
$string['readtherest'] = 'Ler o resto deste tópico';
$string['removeallforumtags'] = 'Todas as palavras-chave do fórum';
$string['removefromfavourites'] = 'Remover estrela deste tópico';
$string['replies'] = 'Respostas';
$string['repliesmany'] = '{$a} respostas';
$string['repliesone'] = '{$a} resposta';
$string['reply'] = 'Responder';
$string['reply_handler'] = 'Responder a tópicos de fórum via e-mail.';
$string['reply_handler_name'] = 'Responder a tópicos de fórum';
$string['replyauthorself'] = '{$a} (tu)';
$string['replyforum'] = 'Responder para o fórum';
$string['replyingtoauthor'] = 'A responder a {$a}...';
$string['replyplaceholder'] = 'Escreva a sua resposta...';
$string['replypostdiscussion'] = 'Responder ao tópico';
$string['replytopostbyemail'] = 'Pode responder a esta mensagem via e-mail.';
$string['replytouser'] = 'Usar e-mail na resposta';
$string['resetdigests'] = 'Todas as preferências dos utilizadores para os "Resumos de fóruns"';
$string['resetforums'] = 'Apagar todas as mensagens de';
$string['resetforumsall'] = 'Todas as mensagens';
$string['resetsubscriptions'] = 'Todas as subscrições ao fórum';
$string['resettrackprefs'] = 'Todas as preferências de assinalar mensagens não lidas dos fóruns';
$string['rssarticles'] = 'Número de artigos recentes na lista RSS';
$string['rssarticles_help'] = 'Esta opção especifica o número de artigos a incluir na lista RSS (mensagens ou tópicos). O número mais adequado deverá estar entre 5 e 20.';
$string['rsssubscriberssdiscussions'] = 'Lista RSS de tópicos de discussão';
$string['rsssubscriberssposts'] = 'Lista RSS de tópicos de mensagens';
$string['rsstype'] = 'Lista RSS para esta atividade';
$string['rsstype_help'] = 'Para ativar as listas RSS para esta atividade, selecione discussões ou mensagens para serem incluídas na lista RSS.';
$string['rsstypedefault'] = 'Tipo de lista RSS';
$string['search'] = 'Pesquisar';
$string['search:activity'] = 'Fórum - informações da atividade';
$string['search:post'] = 'Fórum - mensagens';
$string['searchdatefrom'] = 'Mensagens posteriores a';
$string['searchdateto'] = 'Mensagens anteriores a';
$string['searchforumintro'] = 'Por favor, insira os termos da pesquisa num, ou mais, dos seguintes campos:';
$string['searchforums'] = 'Pesquisar nos fóruns';
$string['searchfullwords'] = 'Palavras que devem aparecer inteiras';
$string['searchnotwords'] = 'Palavras que não devem estar na mensagem';
$string['searcholderposts'] = 'Pesquisar mensagens antigas...';
$string['searchphrase'] = 'Frase exata que deve estar na mensagem';
$string['searchresults'] = 'Resultados da procura';
$string['searchsubject'] = 'Palavras que devem estar no assunto';
$string['searchtags'] = 'Com a palavra-chave';
$string['searchuser'] = 'Nome que deve corresponder ao autor';
$string['searchuserid'] = 'O código Moodle de identificação do autor';
$string['searchusers'] = 'Pesquisar utilizadores';
$string['searchwhichforums'] = 'Escolha os fóruns a pesquisar';
$string['searchwords'] = 'Palavras que podem aparecer em qualquer parte da mensagem';
$string['seeallposts'] = 'Ver todas as mensagens deste utilizador';
$string['sendstudentnotificationsdefault'] = 'Configuração predefinida de "Notificar alunos"';
$string['sendstudentnotificationsdefault_help'] = 'Defina o valor predefinido para a caixa de seleção "Notificar alunos" no formulário de avaliação.';
$string['sendstudentnotificationsno'] = 'Não enviar notificação';
$string['sendstudentnotificationsyes'] = 'Sim, enviar uma notificação ao aluno';
$string['settings'] = 'Configurações';
$string['shortpost'] = 'Mensagem curta';
$string['showgraderpanel'] = 'Mostrar painel do avaliador';
$string['showingcountoftotaldiscussions'] = 'Lista de tópicos. A mostrar {$a->count} de {$a->total} tópicos';
$string['showmoreusers'] = 'Mostrar mais utilizadores';
$string['showpreviousrepliescount'] = 'Mostrar respostas anteriores ({$a})';
$string['showsubscribers'] = 'Mostrar/editar subscritores atuais';
$string['showusersearch'] = 'Mostrar pesquisa de utilizador';
$string['singleforum'] = 'Um único tópico de discussão';
$string['smallmessage'] = '{$a->user} submeteu uma mensagem em \'{$a->forumname}\'';
$string['smallmessagedigest'] = 'O resumo do fórum contém {$a} mensagens';
$string['starredonly'] = 'Pesquisar apenas tópicos marcados com estrela';
$string['startedby'] = 'Iniciado por';
$string['subject'] = 'Assunto';
$string['subplugintype_forumreport'] = 'Relatório de fórum';
$string['subplugintype_forumreport_plural'] = 'Relatórios de fórum';
$string['subscribe'] = 'Subscrever este fórum';
$string['subscribeall'] = 'Subscrever todos a este fórum';
$string['subscribed'] = 'Com subscrição ativa';
$string['subscribediscussion'] = 'Subscrever este tópico de discussão';
$string['subscribedtoforum'] = 'Subscrito o fórum {$a}';
$string['subscribeenrolledonly'] = 'Lamentamos mas apenas os utilizadores autenticados podem se inscrever para receber mensagens do fórum por e-mail.';
$string['subscribenone'] = 'Cancelar a subscrição de todos neste fórum';
$string['subscribers'] = 'Subscritores';
$string['subscriberstowithcount'] = 'Subscritores de {$a->name} ({$a->count})';
$string['subscribestart'] = 'Envie-me notificações de novos tópicos neste fórum';
$string['subscribestop'] = 'Não quero receber notificações de novos tópicos neste fórum';
$string['subscribetoforum'] = 'Subscrever o fórum {$a}';
$string['subscription'] = 'Subscrição';
$string['subscription_help'] = 'Subscrever um fórum significa que receberá notificações por e-mail dos novos tópicos publicados no fórum. Normalmente, pode optar por subscrever, ou não, um fórum. No entanto, em alguns fóruns a subscrição é obrigatória para que todos recebam as notificações.';
$string['subscriptionandtracking'] = 'Subscrever e assinalar mensagens';
$string['subscriptionauto'] = 'Subscrição opcional (ativa no início)';
$string['subscriptiondisabled'] = 'Subscrição desativada';
$string['subscriptionforced'] = 'Subscrição obrigatória';
$string['subscriptionmode'] = 'Modo de subscrição';
$string['subscriptionmode_help'] = 'Quando um participante tem a subscrição ativa num fórum, significa que irá receber notificações das publicações desse fórum. Existem 4 opções de subscrição:

* Subscrição opcional - Os participantes podem escolher se pretendem ativar a subscrição;
* Subscrição obrigatória - Todos têm a subscrição ativa e não podem cancelar;
* Subscrição opcional - Todos têm a subscrição ativa no início mas podem cancelá-la a qualquer momento;
* Subscrição desativada - Não é permitido subscrever o fórum.';
$string['subscriptionmodeconfirm'] = 'Tem a certeza de que pretende alterar o modo de subscrição para \'{$a}\'?';
$string['subscriptionoptional'] = 'Subscrição opcional';
$string['subscriptions'] = 'Subscrições';
$string['tagarea_forum_posts'] = 'Mensagens do fórum';
$string['tagsdeleted'] = 'As palavras-chave do fórum foram apagadas';
$string['thisforumhasduedate'] = 'A data limite para publicar neste fórum é {$a}.';
$string['thisforumisdue'] = 'A data limite para publicar neste fórum era {$a}.';
$string['thisforumisthrottled'] = 'Este fórum possui um número limite de mensagens que pode submeter num determinado intervalo de tempo. Está atualmente configurado para {$a->blockafter} mensagem(s) em {$a->blockperiod}';
$string['timed'] = 'Com prazo de visualização';
$string['timeddiscussion'] = 'Tópico com prazo de visualização';
$string['timedhidden'] = 'Estado do período de visualização: Oculto para os alunos';
$string['timedposts'] = 'Mensagens com período de visualização';
$string['timedvisible'] = 'Estado do período de visualização: Visível para todos os utilizadores';
$string['timestartenderror'] = 'A data de fim não pode ser anterior à data de início';
$string['togglediscussionmenu'] = 'Alternar o menu de conversação';
$string['togglefullscreen'] = 'Mostrar em ecrã completo';
$string['togglesettingsdrawer'] = 'Alternar configurações';
$string['trackedforforum'] = 'Sinalização ativada para {$a}';
$string['trackforforum'] = 'Sinalizar novas mensagens do fórum {$a}';
$string['trackforum'] = 'Assinalar mensagens não lidas';
$string['tracking'] = 'Assinalar';
$string['trackingoff'] = 'Desativada';
$string['trackingon'] = 'Obrigatória';
$string['trackingoptional'] = 'Opcional';
$string['trackingtype'] = 'Assinalar mensagens não lidas';
$string['trackingtype_help'] = 'A sinalização de mensagens permite que os participantes identifiquem os tópicos do fórum que ainda não leram, uma vez que estes aparecem assinalados.

Se selecionar a opção "Opcional", os participantes podem optar por ligar ou desligar a sinalização de mensagens do fórum. Os utilizadores deverão ativar a opção "Assinalar mensagens não lidas nos fóruns" nas suas preferências do fórum.

A opção "Obrigatória" só estará disponível se um administrador do site a ativar. Se selecionar esta opção, a configuração "Assinalar mensagens não lidas nos fóruns" estará sempre ativada, independentemente das preferências do fórum escolhidas pelos utilizadores.';
$string['trackreadposts_header'] = 'Assinalar mensagens não lidas nos fóruns';
$string['unlockdiscussion'] = 'Desbloquear este tópico';
$string['unpindiscussion'] = 'Remover destaque deste tópico';
$string['unread'] = 'Não lidas';
$string['unreadpost'] = 'Tópicos não lidos';
$string['unreadposts'] = 'Mensagens não lidas';
$string['unreadpostsnumber'] = '{$a} mensagens não lidas';
$string['unreadpostsone'] = '1 mensagem não lida';
$string['unsubscribe'] = 'Cancelar a subscrição deste fórum';
$string['unsubscribeall'] = 'Cancelar subscrição de todos os fóruns';
$string['unsubscribeallconfirm'] = 'Tem subscrição ativa em {$a->forums} fóruns e {$a->discussions} discussões. Tem a certeza de que pretende cancelar a subscrição de todos os fóruns e desativar a auto-subscrição de discussões?';
$string['unsubscribeallconfirmdiscussions'] = 'Atualmente está a subscrever {$a->discussions} tópicos de discussões. Pretende realmente cancelar a subscrição de todas as discussões e desativar a subscrição automática?';
$string['unsubscribeallconfirmforums'] = 'Atualmente está a subscrever {$a->forums} fóruns. Pretende realmente cancelar a subscrição de todos os fóruns e desativar a subscrição automática?';
$string['unsubscribealldone'] = 'Todas as suas subscrições foram canceladas, irá continuar a receber e-mails dos fóruns de subscrição obrigatória. Se não pretender receber esses e-mails desative o seu e-mail no seu perfil.';
$string['unsubscribeallempty'] = 'Não tem subscrição ativa em nenhum fórum. Se não pretender receber nenhum e-mail desative o seu e-mail no seu perfil.';
$string['unsubscribed'] = 'Subscrição cancelada';
$string['unsubscribedfromforum'] = 'Cancelada a subscrição de {$a}';
$string['unsubscribediscussion'] = 'Cancelar a subscrição desta discussão';
$string['unsubscribediscussionlink'] = 'Remover subscrição deste tópico de discussão: {$a}';
$string['unsubscribefromforum'] = 'Cancelar subscrição do fórum {$a}';
$string['unsubscribelink'] = 'Remover subscrição deste fórum: {$a}';
$string['unsubscribeshort'] = 'Cancelar subscrição';
$string['untrackedforforum'] = 'Sinalização desativada para {$a}';
$string['untrackforforum'] = 'Não assinalar novas mensagens do fórum {$a}';
$string['useexperimentalui'] = 'Usar visualização experimental de tópicos encadeados';
$string['usermarksread'] = 'Marcar manualmente as mensagens lidas';
$string['usernavigation'] = 'Navegação do utilizador';
$string['usersforumposts'] = 'Mensagens do utilizador no fórum';
$string['viewalldiscussions'] = 'Ver todos os tópicos';
$string['viewconversation'] = 'Ver tópico';
$string['viewgrades'] = 'Ver notas';
$string['viewparentpost'] = 'Ver tópico ascendente';
$string['viewthediscussion'] = 'Ver o tópico de discussão';
$string['warnafter'] = 'Número de mensagens que gera aviso';
$string['warnafter_help'] = 'Os alunos podem ser avisados que se aproximam do limite máximo de mensagens permitidas num determinado intervalo de tempo. Especifique aqui depois de quantos tópicos submetidos será o aluno avisado. Utilizadores com a permissão \'mod/forum:postwithoutthrottling\' estão isentos destes limites.';
$string['warnformorepost'] = 'Atenção! Há mais do que uma discussão neste fórum - está em uso a mais recente';
$string['wordcount'] = 'Número de palavras';
$string['yournewquestion'] = 'A sua nova questão';
$string['yournewtopic'] = 'O seu novo tópico de discussão';
$string['yourreply'] = 'A sua resposta';
