<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'format_kickstart', language 'pt', version '5.1'.
 *
 * @package     format_kickstart
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['automatictemplate'] = 'Modelo automático';
$string['automatictemplate_desc'] = 'Se apenas estiver disponível um modelo para o utilizador, ele será importado automaticamente. O utilizador será notificado na página quando isto acontecer.';
$string['automatictemplate_help'] = 'O modelo de disciplina foi aplicado automaticamente. Se precisar de um modelo diferente, contacte o administrador do sistema.';
$string['buypro'] = 'Comprar Kickstart Pro';
$string['buypromaxtemplates'] = 'Está a usar o número máximo de modelos (<b>4</b>) permitido na versão gratuita do Kickstart. Para criar mais modelos, compre o <a target="_blank" href="https://bdecent.de/products/moodle-plugins/kickstart-course-wizard-pro/">Kickstart Pro</a>.';
$string['buyprosummary'] = 'Para desbloquear todas as funcionalidades do Kickstart, adquira a versão Kickstart Pro.';
$string['confirmtemplate'] = 'Tem a certeza de que pretende usar este modelo "{$a->name}"?';
$string['course_backup'] = 'Ficheiro de cópia de segurança da disciplina (.mbz)';
$string['course_backup_help'] = 'Quando um utilizador selecionar este modelo para uma disciplina, esta cópia de segurança da disciplina (.mbz) será importada para a disciplina.';
$string['course_templates'] = 'Modelos de disciplina';
$string['coursebackupnotset'] = 'O modelo não tem conjunto de cópia de segurança da disciplina.';
$string['coursecreatorredirect'] = 'Redirecionamento para criador de disciplinas';
$string['coursecreatorredirect_desc'] = 'Forçar os criadores de disciplinas a usar a página "Criar a partir de modelo" do Kickstart quando pretenderem criar novas disciplinas. Por exemplo, quando um criador de uma disciplina clicar em "Adicionar nova disciplina", será redirecionado para o Kickstart.';
$string['create_template'] = 'Criar modelo';
$string['createcoursefromtemplate'] = 'Criar disciplina a partir de modelo';
$string['defaultteacherinstructions'] = 'Instruções predefinidas para o professor';
$string['defaultteacherinstructions_default'] = 'Atualmente, ainda não existe nada aqui. Comece a adicionar conteúdo. Se precisar de ajuda, veja o tutorial em vídeo sobre todas as opções disponíveis. Tornamos a criação de disciplinas mais fácil. Primeiro, escolha um modelo adequado à sua disciplina e depois comece a adicionar conteúdo.';
$string['defaultteacherinstructions_desc'] = 'Conteúdo predefinido a exibir aos professores antes da escolha de um modelo.';
$string['defaultuserinstructions'] = 'Instruções predefinidas para o aluno';
$string['defaultuserinstructions_default'] = 'O seu professor ainda não adicionou conteúdo a esta disciplina.
Se tiver alguma dúvida, contacte o professor.';
$string['defaultuserinstructions_desc'] = 'Conteúdo predefinido a exibir aos alunos antes de um modelo ser escolhido pelo professor.';
$string['delete'] = 'Apagar';
$string['delete_template'] = 'Apagar modelo';
$string['description'] = 'Descrição';
$string['edit'] = 'Editar';
$string['edit_template'] = 'Editar modelo';
$string['enrollmenthelp'] = 'Antes de continuar, pode inscrever professores (ou qualquer utilizador). Clique em <b>Continuar para o conteúdo da disciplina</b> para escolher um modelo para importar.';
$string['general_settings'] = 'Configurações gerais';
$string['getpro'] = 'Obtenha mais modelos com o Kickstart Pro';
$string['goprotoenable'] = 'Obter versão Pro para ativar';
$string['gotocourse'] = 'Ir para a disciplina';
$string['importcourse'] = 'Importar disciplina';
$string['importexplanation'] = 'Lista das disciplinas nos quais está inscrito como professor. Pode importar o conteúdo dessas disciplinas. Use a caixa de pesquisa para restringir a lista de disciplinas.';
$string['importtarget'] = 'Destino da importação';
$string['importtarget_desc'] = 'Escolha como os modelos do Kickstart devem ser importados para as disciplinas.';
$string['includesubcategories'] = 'Incluir subcategorias';
$string['includesubcategories_help'] = 'Se ativar esta opção, as subcategorias das categorias escolhidas também terão acesso a este modelo.';
$string['kickstart:import_from_template'] = 'Importar de modelos';
$string['kickstart:manage_templates'] = 'Gerir modelos';
$string['learnmore'] = 'Ler mais';
$string['manage_templates'] = 'Gerir modelos';
$string['migratefromcourses'] = 'Migrar conteúdo de outras disciplinas';
$string['notemplates'] = 'Ainda não existem modelos disponíveis.';
$string['pluginname'] = 'Formato Kickstart';
$string['previewurl'] = 'Pré-visualizar URL';
$string['previewurl_help'] = 'Se indicado, será mostrado um botão no modelo que abrirá este URL num novo separador';
$string['privacy:metadata'] = 'O módulo Formato Kickstart não armazena quaisquer dados pessoais.';
$string['restoretoexistingcourseadding'] = 'Incorporar modelos do Kickstart para as disciplinas';
$string['restoretoexistingcoursedeleting'] = 'Apagar o conteúdo existente ao importar modelos do Kickstart';
$string['restrictcategory'] = 'Restrição por categorias';
$string['restrictcohort'] = 'Restrição por Grupo global';
$string['restrictrole'] = 'Restrição por papel';
$string['searchterm'] = 'A mostrar resultados para "{$a->term}"';
$string['sectionname'] = 'Kickstart';
$string['showing'] = 'A mostrar {$a->count} disciplina(s)';
$string['tagarea_kickstart_template'] = 'Modelos do Kickstart';
$string['teacherinstructions'] = 'Instruções para os professores';
$string['teacherinstructions_help'] = 'Conteúdo exibido aos professores antes da escolha de um modelo.';
$string['template_created'] = 'Modelo criado com sucesso';
$string['template_deleted'] = 'Modelo apagado com sucesso';
$string['template_edited'] = 'Modelo editado com sucesso';
$string['templateaccess'] = 'Acesso ao modelo';
$string['title'] = 'Título';
$string['userinstructions'] = 'Instruções para os alunos';
$string['userinstructions_help'] = 'Conteúdo exibido aos alunos antes de um modelo ser escolhido pelo professor.';
$string['usetemplate'] = 'Usar modelo';
$string['welcometoyourcourse'] = 'Bem-vindo à sua nova disciplina';
