<?php

/* CLASS FILE
----------------------------------*/

class fieldManager {

  private function template($t) {
    $tmp = array(
      'option' => mswTmp(PATH . 'content/system/html/custom-fields/option.htm'),
      'select' => mswTmp(PATH . 'content/system/html/custom-fields/select.htm'),
      'checkbox' => mswTmp(PATH . 'content/system/html/custom-fields/checkbox.htm'),
      'input' => mswTmp(PATH . 'content/system/html/custom-fields/input.htm'),
      'calendar' => mswTmp(PATH . 'content/system/html/custom-fields/calendar.htm'),
      'textarea' => mswTmp(PATH . 'content/system/html/custom-fields/textarea.htm')
    );
    return $tmp[$t];
  }

  // Create select/drop down menu..
  public function buildSelect($text, $id, $options, $tabIndex, $value = '') {
    $option = fieldManager::template('option');
    $select = fieldManager::template('select');
    $html   = str_replace(array(
      '{value}','{selected}','{display}'
    ), array(
      'nothing-selected','',str_repeat('-', 7)
    ), $option);
    $sel = explode(mswNL(), $options);
    if (!empty($sel)) {
      foreach ($sel AS $o) {
        $html .= str_replace(array(
          '{value}','{selected}','{display}'
        ), array(
          mswSH($o),mswSelectedItem($value, $o),mswSH($o)
        ), $option);
      }
    }
    return mswNL() . '<div class="form-group"><label>' . $text . '</label>' . mswNL() . str_replace(array('{id}','{index}','{options}'), array($id, $tabIndex, $html), $select) . '</div>' . mswNL();
  }

  // Create checkbox..
  public function buildCheckBox($text, $id, $options, $values = '') {
    $html     = '';
    $checkbox = fieldManager::template('checkbox');
    $v        = [];
    $boxes    = explode(mswNL(), $options);
    if ($values) {
      $v = explode('#####', $values);
    }
    if (!empty($boxes)) {
      foreach ($boxes AS $cb) {
        $html .= '<div class="checkbox">';
        $html .= str_replace(array(
          '{id}','{value}','{checked}','{display}'
        ), array(
          $id, mswSH($cb), (in_array($cb, $v) ? ' checked="checked"' : ''), $cb
        ), $checkbox);
        $html .= '</div>' . mswNL();
      }
    }
    return ($html ? mswNL() . '<div class="form-group"><input type="hidden" name="hiddenBoxes[]" value="' . $id . '"><label>' . $text . '</label>' . $html . '</div>' : '');
  }

  // Create input box..
  public function buildInputBox($text, $id, $tabIndex, $value = '') {
    $input = fieldManager::template('input');
    return mswNL() . '<div class="form-group"><label>' . $text . '</label>' . mswNL() . str_replace(array('{index}','{id}','{value}'), array($tabIndex, $id, mswSH($value)), $input) . '</div>' . mswNL();
  }
  
  // Create calendar..
  public function buildCalBox($text, $id, $tabIndex, $value = '') {
    $input = fieldManager::template('calendar');
    return mswNL() . '<div class="form-group"><label>' . $text . '</label>' . mswNL() . str_replace(array('{index}','{id}','{value}'), array($tabIndex, $id, mswSH($value)), $input) . '</div>' . mswNL();
  }

  // Create textarea..
  public function buildTextArea($text, $id, $tabIndex, $value = '') {
    $textarea = fieldManager::template('textarea');
    return mswNL() . '<div class="form-group"><label>' . $text . '</label>' . mswNL() . str_replace(array('{index}','{id}','{value}'), array($tabIndex, $id, mswSH($value)), $textarea) . '</div>' . mswNL();
  }

}

?>