<?php

/* SOFTWARE LOADER
   DO NOT change this file
----------------------------------*/

header('Expires: Sun, 01 Jan 2014 00:00:00 GMT');
header('Cache-Control: no-store, no-cache, must-revalidate');
header('Cache-Control: post-check=0, pre-check=0', FALSE);
header('Pragma: no-cache');
header('Content-type: text/html; charset=utf-8');
if (isset($_SERVER['HTTP_USER_AGENT']) && (strpos($_SERVER['HTTP_USER_AGENT'], 'MSIE') !== false)) {
  header('X-UA-Compatible: IE=edge,chrome=1');
}

// SESSION
$ini_get = ini_get_all();
if (isset($ini_get['session.cookie_httponly'])) {
  ini_set('session.cookie_httponly', 1);
}
session_start();

// PREVENT DATE ERRORS
date_default_timezone_set('UTC');

define('PATH', __dir__ . '/');
define('PARENT', 1);

echo (!function_exists('json_decode') ? die('The JSON functions are not enabled on your server. Enable and restart server. If you are unsure please contact your host.') : '');

include(PATH . 'control/system/constants.php');

// AUTO LOADER > COMPOSER
include(PATH . 'control/lib/vendor/autoload.php');

// TRACY DEBUGGER
use Tracy\Debugger;
Debugger::$showBar = (defined('DEVELOPMENT_ENV') ? true : false);
Debugger::$strictMode = (defined('DEVELOPMENT_ENV') ? true : false);
Debugger::$errorTemplate = PATH . 'control/system/headers/500-debug.php';
Debugger::enable((defined('DEVELOPMENT_ENV') ? Debugger::DEVELOPMENT : Debugger::PRODUCTION), PATH . 'logs');

// LATTE TEMPLATE ENGINE
$latte = new Latte\Engine;
if (defined('DEVELOPMENT_ENV')) {
  $latte->setautoRefresh();
}

// START SESSION & FIRE SYSTEM
include(PATH . 'control/classes/system/class.session.php');
$SSN = new sessHandlr();

include(PATH . 'control/system/init.php');
include(PATH . 'control/index-parser.php');

?>