<?php

/* Admin - System Module
----------------------------------------------------------*/

if (!defined('PARENT')) {
  include(PATH . 'control/system/header/403.php');
}

define('TICKET_VIEW_LOADED', 1);
define('DROPZONE_LOADER', 1);

// Print mode?
if (isset($_GET['print'])) {
  $_GET['id'] = (int) $_GET['print'];
  define('PRINT_MODE_ENABLED', 1);
}

// Access..
if (!in_array('assign', $userAccess) && !in_array('open', $userAccess) &&
    !in_array('close', $userAccess) && !in_array('search', $userAccess) &&
    !in_array('odis', $userAccess) && !in_array('cdis', $userAccess) && USER_ADMINISTRATOR != 'yes') {
  include(PATH . 'control/system/header/403.php');
}

// Merge redirect?
if (isset($_GET['merged'])) {
  $title      = $msadminlang3_1adminviewticket[19];
  $ID         = (int) $_GET['merged'];
  $SUPTICK    = mswSQL_table('tickets', 'id', $ID);
  $metaReload = '<meta http-equiv="refresh" content="' . TICK_MERGE_RDR_TIME . ';url=index.php?p=view-ticket&id=' . $ID . '">';
  include(PATH . 'content/header.php');
  include(PATH . 'content/system/tickets/tickets-merge-msg.php');
  include(PATH . 'content/footer.php');
  exit;
}

// Add to history..
if (isset($_GET['addHis']) && $SETTINGS->ticketHistory == 'yes' && (USER_ADMINISTRATOR == 'yes' || $MSTEAM->ticketHistory == 'yes')) {
  mswVLDG($_GET['addHis'], true);
  // Does ticket exists..
  $SUPTICK = mswSQL_table('tickets', 'id', $_GET['addHis']);
  if (!isset($SUPTICK->id)) {
    include(PATH . 'control/system/header/404.php');
  }
  include(PATH . 'content/system/tickets/tickets-history-add.php');
  exit;
}

// Export history..
if (isset($_GET['exportHistory']) && $SETTINGS->ticketHistory == 'yes' && (USER_ADMINISTRATOR == 'yes' || $MSTEAM->ticketHistory == 'yes')) {
  mswVLDG($_GET['exportHistory'], true);
  // Does ticket exist..
  $SUPTICK = mswSQL_table('tickets', 'id', $_GET['exportHistory']);
  if (!isset($SUPTICK->id)) {
    include(PATH . 'control/system/header/404.php');
  }
  // Check permissions for this log..
  if (mswDeptPerms($SUPTICK->department, $userDeptAccess, array('assigned' => $SUPTICK->assignedto, 'team' => $MSTEAM->id)) == 'fail') {
    include(PATH . 'control/system/header/403.php');
  }
  include_once(BASE_PATH . 'control/classes/system/class.download.php');
  $MSDL = new msDownload();
  $MSTICKET->exportTicketHistory($MSDL, $MSDT);
}

// At this point id should exist..
if (!isset($_GET['id'])) {
  include(PATH . 'control/system/header/403.php');
}

// Check digit..
mswVLDG($_GET['id'], true);

// Enable lock mechanism..
if (!isset($_GET['quickView'])) {
  $MSTICKET->locker(array(
    'action' => 'lock',
    'ticket' => (int) $_GET['id'],
    'team' => $MSTEAM->id
  ));
}

// Load ticket data..
$SUPTICK = mswSQL_table('tickets', 'id', (int) $_GET['id']);

// Checks..
if (!isset($SUPTICK->id)) {
  include(PATH . 'control/system/header/404.php');
}

// Is ticket locked?
if ($SETTINGS->adminlock == 'yes' && $SUPTICK->lockteam > 0 && $SUPTICK->lockteam != $MSTEAM->id) {
  define('TICKET_TEAM_LOCK', 1);
}

// Edit notes..
if (isset($_GET['editNotes']) && ($MSTEAM->notePadEnable == 'yes' || USER_ADMINISTRATOR == 'yes')) {
  include(PATH . 'content/system/tickets/tickets-notes.php');
  exit;
}

// Edit visitor notes..
if (isset($_GET['editVisNotes']) && (in_array('accounts',$userAccess) ||  USER_ADMINISTRATOR == 'yes')) {
  $user = (int) $_GET['editVisNotes'];
  // Does user exist..
  $ACC = mswSQL_table('portal', 'id', $user);
  if (!isset($ACC->id)) {
    include(PATH . 'control/system/header/404.php');
  }
  include(PATH . 'content/system/tickets/tickets-notes-vis.php');
  exit;
}

// Show statuses..
if (isset($_GET['showStatuses'])) {
  include(PATH . 'content/system/tickets/tickets-other-statuses.php');
  exit;
}

// Move tickets..
if (USER_MOVE_PRIV == 'yes' && isset($_GET['move'])) {
  include(PATH . 'content/system/tickets/tickets-move.php');
  exit;
}

// Users in dispute..
if (isset($_GET['dis_users'])) {
  include(PATH . 'content/system/tickets/tickets-dispute-users-list.php');
  exit;
}

// Assigned staff..
if (isset($_GET['as_staff'])) {
  include(PATH . 'content/system/tickets/tickets-assigned-staff.php');
  exit;
}

// Quick view..
if (isset($_GET['quickView'])) {
  include(PATH . 'content/system/tickets/tickets-quick-view.php');
  exit;
}

// Department check..
if (mswDeptPerms($SUPTICK->department, $userDeptAccess, array('assigned' => $SUPTICK->assignedto, 'team' => $MSTEAM->id)) == 'fail') {
  include(PATH . 'control/system/header/403.php');
}

// Add reply..
if (isset($_POST['process'])) {
  define('TICKET_REPLY', 1);
  include(PATH . 'control/system/tickets/ticket-reply.php');
}

// Assign visitor name/email..
$VIS            = mswSQL_table('portal', 'id', $SUPTICK->visitorID);
$SUPTICK->name  = (isset($VIS->name) ? $VIS->name : $msg_script17);
$SUPTICK->email = (isset($VIS->email) ? $VIS->email : $msg_script17);

// Check for custom ticket status action..
if (isset($_GET['act']) && substr($_GET['act'], 0, 7) == 'status-') {
  $cstStatus = (int) substr($_GET['act'], 7);
  if (isset($ticketStatusSel[$cstStatus][0]) && $cstStatus > 3) {
    $_GET['act'] = 'status-change';
    $_GET['status-change-id'] = $cstStatus;
  }
}
// Update status..
if (!defined('TICKET_TEAM_LOCK') && isset($_GET['act']) && in_array($_GET['act'], array(
  'open',
  'close',
  'lock',
  'ticket',
  'dispute',
  'reopen',
  'spam-del',
  'to-spam',
  'status-change'
))) {
  switch($_GET['act']) {
    case 'spam-del':
      $_POST['del'] = array($_GET['id']);
      if (USER_DEL_PRIV == 'yes') {
        $MSTICKET->deleteTickets();
      }
      header("Location: index.php?p=spam");
      exit;
      break;
    default:
      switch($_GET['act']) {
        case 'to-spam':
          $action = str_replace('{user}', $MSTEAM->name, $msg_ticket_history['ticket-status-spam']);
          break;
        case 'status-change':
          $action = str_replace(array('{status}','{user}'), array($ticketStatusSel[$cstStatus][0],$MSTEAM->name), $msg_ticket_history['admin-custom-status-change']);
          break;
        default:
          $action = str_replace('{user}', $MSTEAM->name, $msg_ticket_history['ticket-status-' . $_GET['act']]);
          break;
      }
      if ($_GET['act'] == 'close' && USER_CLOSE_PRIV == 'no' && USER_ADMINISTRATOR == 'no') {
        include(PATH . 'control/system/header/403.php');
      }
      if ($_GET['act'] == 'lock' && USER_LOCK_PRIV == 'no' && USER_ADMINISTRATOR == 'no') {
        include(PATH . 'control/system/header/403.php');
      }
      if ($_GET['act'] == 'to-spam' && USER_ADMINISTRATOR == 'no' && !in_array('spam',$userAccess)) {
        include(PATH . 'control/system/header/403.php');
      }
      $rows = $MSTICKET->updateTicketStatus();
      // History if affected rows..
      if ($rows > 0) {
        $MSTICKET->historyLog($_GET['id'], str_replace(array(
          '{user}'
        ), array(
          $MSTEAM->name
        ), $action));
        $SUPTICK        = mswSQL_table('tickets', 'id', (int) $_GET['id']);
        $SUPTICK->name  = (isset($VIS->name) ? $VIS->name : $msg_script17);
        $SUPTICK->email = (isset($VIS->email) ? $VIS->email : $msg_script17);
        $em = [];
        switch($_GET['act']) {
          case 'dispute':
            $actionMsg = str_replace('{id}', $_GET['id'], $msg_ticket_actioned[$_GET['act']]);
            break;
          case 'to-spam':
            $actionMsg = str_replace('{id}', $_GET['id'], $msg_ticket_actioned['spam']);
            break;
          case 'status-change':
            $actionMsg = str_replace('{status}', mswSH($ticketStatusSel[$cstStatus][0]), $msg_ticket_actioned['status-changed']);
            // Are we sending email notification?
            if ($SETTINGS->notify_other == 'yes') {
               $em['subject'] = $actionMsg;
            }
            break;
          default:
            switch($_GET['act']) {
              case 'open':
              case 'reopen':
              case 'close':
              case 'lock':
                include_once(PATH . 'control/classes/class.statuses.php');
                $MSSTS = new statuses();
                $cstStatus = ($_GET['act'] == 'lock' ? 'closed' : ($_GET['act'] == 'reopen' ? 'open' : $_GET['act']));
                if (isset($ticketStatusSel[$cstStatus][0])) {
                  $actionMsg = str_replace(array('{status}','{user}'), array($ticketStatusSel[$cstStatus][0],$MSTEAM->name), $msg_ticket_actioned['status-changed']);
                } else {
                  $actionMsg = $MSSTS->setStatusText($msg_ticket_actioned[$_GET['act']], $_GET['act']);
                }
                // Are we sending email notification?
                if (in_array($_GET['act'], ['open','reopen']) && $SETTINGS->notify_open == 'yes') {
                  $em['subject'] = str_replace('{status}', $ticketStatusSel[$cstStatus][0], $msg_ticket_actioned['status-changed']);
                }
                if (in_array($_GET['act'], ['close','lock']) && $SETTINGS->notify_close == 'yes') {
                   $em['subject'] = str_replace('{status}', $ticketStatusSel[$cstStatus][0], $msg_ticket_actioned['status-changed']);
                }
                break;
              default:
                $actionMsg = $msg_ticket_actioned[$_GET['act']];
                break;
            }
            break;
        }
        // Send emails.
        if (isset($em['subject'])) {
          // Load mail params
          include(BASE_PATH . 'control/mail-init.php');
          $PORTAL = mswSQL_table('portal', 'id', $SUPTICK->visitorID);
          if (isset($PORTAL->name)) {
            $MSMAIL->addTag('{TICKET}', mswTicketNumber($SUPTICK->id, $SETTINGS->minTickDigits, $SUPTICK->tickno));
            $MSMAIL->addTag('{SUBJECT}', $SUPTICK->subject);
            $MSMAIL->addTag('{DEPT}', $MSYS->department($SUPTICK->department, $msg_script30));
            $MSMAIL->addTag('{PRIORITY}', $MSYS->levels($SUPTICK->priority));
            $MSMAIL->addTag('{COMMENTS}', $SUPTICK->comments);
            $MSMAIL->addTag('{STATUS}', $em['subject']);
            $MSMAIL->addTag('{SIGNATURE}', ($MSTEAM->emailSigs == 'yes' && $MSTEAM->signature ? $MSTEAM->signature : ''));
            $MSMAIL->addTag('{NAME}', $PORTAL->name);
            $MSMAIL->addTag('{ID}', $SUPTICK->id);
            // Pass ticket number as custom mail header..
            $MSMAIL->xheaders['X-TicketNo'] = mswTicketNumber($SUPTICK->id, $SETTINGS->minTickDigits, $SUPTICK->tickno);
            // If this ticket was opened by imap, the return address should be the imap address..
            if ($SUPTICK->source == 'imap') {
              $IDEPT = mswSQL_table('imap', 'im_dept', $SUPTICK->department, '', '`im_email`');
              if (isset($IDEPT->im_email) && $IDEPT->im_email) {
                $replyToAddr = $IDEPT->im_email;
              }
            }
            $MSMAIL->sendMSMail(array(
             'from_email' => $SETTINGS->email,
             'from_name' => $SETTINGS->website,
             'to_email' => $PORTAL->email,
             'to_name' => $PORTAL->name,
             'subject' => str_replace(array(
               '{website}',
               '{ticket}',
               '{subject}'
             ), array(
               $SETTINGS->website,
               mswTicketNumber($SUPTICK->id, $SETTINGS->minTickDigits, $SUPTICK->tickno),
               $SUPTICK->subject
             ), $em['subject']),
             'replyto' => array(
               'name' => $SETTINGS->website,
               'email' => (isset($replyToAddr) ? $replyToAddr : ($SETTINGS->replyto ? $SETTINGS->replyto : $SETTINGS->email))
             ),
             'template' => LANG_PATH . 'admin-ticket-status-change.txt',
             'language' => (defined('MSLNG_SET') ? MSLNG_SET : $SETTINGS->language)
            ));
          }
        }
      }
      break;
  }
}

$mswWysCfg = array(
  'lang' => ($msWysiwyg_cfg[0] != 'en' && file_exists(PATH . 'content/js/plugins/i18n-wysiwyg/' . $msWysiwyg_cfg[0] . '.min.js') ? $msWysiwyg_cfg[0] : ''),
  'textarea' => 'textarea[name="comments"]'
);
define('WYSIWYG_ED', 'yes');
$textareaFullScr = true;

if ($SSN->active('clear_draft_load') == 'yes' && $SSN->active('draft_' . $SUPTICK->id) == 'yes') {
  $SSN->delete([
    'draft_' . $SUPTICK->id,
    'time_' . $SUPTICK->id,
    'clear_draft_load'
  ]);
}

$title = str_replace('{ticket}', mswTicketNumber($_GET['id'], $SETTINGS->minTickDigits, $SUPTICK->tickno), ($SUPTICK->isDisputed == 'yes' ? $msg_viewticket80 : $msg_viewticket));

include(PATH . 'content/header.php');
include(PATH . 'content/system/tickets/tickets-view' . ($SUPTICK->isDisputed == 'yes' ? '-disputed' : '') . '.php');
include(PATH . 'content/footer.php');

?>