<!DOCTYPE html>
<html lang="{$LANG}" dir="{$DIR}">
	<head>
    <meta charset="{$CHARSET}">
    <meta name="x-header-csrf" content="{$CSRF_TOKEN}">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">

    <title>{$TITLE}</title>

    <link href="{$SYS_BASE_HREF}assets/css/bootstrap.css" rel="stylesheet">
    <link href="{$SYS_BASE_HREF}assets/css/theme.css" rel="stylesheet">
    <link href="{$SYS_BASE_HREF}assets/css/font-awesome/font-awesome.css" rel="stylesheet">

    <link href="{$SYS_BASE_HREF}assets/css/jquery-ui.css" rel="stylesheet">
    <link href="{$SYS_BASE_HREF}assets/css/fam-icons.css" rel="stylesheet">
    <link href="{$SYS_BASE_HREF}assets/css/plugins.css" rel="stylesheet">
    <link href="{$SYS_BASE_HREF}assets/css/mobile.css" rel="stylesheet">

    <link rel="icon" href="{$SYS_BASE_HREF}assets/images/favicon.ico">

	</head>

	<body>
	
	{* == MOBILE HEADER - SHOWS ONLY ON EXTRA SMALL SCREENS == *}

  <div class="mobiletopbar visible-xs push">
    <div>
     <i class="fa fa-{($LOAD_OFF_CANVAS_MENU == 'yes' ? 'bars fa-fw menu-btn' : ($LOGGED_IN == 'yes' ? 'lock fa-fw nocanvas' : 'life-ring fa-fw nocanvas'))}"></i>
    </div>
    <div class="website">
      <a href="{$SETTINGS->scriptpath}/{($LOGGED_IN == 'yes' ? '?p=dashboard' : '')}">{$TOP_BAR_TITLE}</a>
    </div>
    <div>
     <div class="btn-group">
        <button type="button" class="btn btn-sm btn-info dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
          <i class="fa fa-chevron-down fa-fw"></i>
        </button>
        <ul class="dropdown-menu dropdown-menu-right">
          
          {* == IS USER LOGGED IN? == *}
          
          {if $LOGGED_IN == 'yes'}
            <li><a href="{$SETTINGS->scriptpath}/?p=dashboard"><i class="fa fa-dashboard fa-fw"></i> {$TXT[2]}</a></li>
            
            {* == SHOW IF FAQ IS ENABLED == *}
            
            {if $SETTINGS->kbase == 'yes'}
              <li><a href="{$SETTINGS->scriptpath}/"><i class="fa fa-question-circle fa-fw"></i> {$TXT[0]}</a></li>
            {/if}

          {else}
            <li><a href="{$SETTINGS->scriptpath}/?p=open" rel="nofollow"><i class="fa fa-pencil fa-fw"></i> {$TXT[1]}</a></li>
              
              {* == IS ACCOUNT CREATION ENABLED? == *}
              
              {if $SETTINGS->createAcc == 'yes'}
                <li><a href="{$SETTINGS->scriptpath}/?p=create" rel="nofollow"><i class="fa fa-user fa-fw"></i> {$TXT[8]}</a></li>
              {/if}

            <li><a href="{$SETTINGS->scriptpath}/?p=login" rel="nofollow"><i class="fa fa-sign-in fa-fw"></i> {$TXT[4]}</a></li>
          {/if}

        </ul>
      </div>
    </div>
  </div>
    
  {* == STANDARD HEADER - SHOWS ON LARGER SCREENS == *}

  <div class="navbar push hidden-xs">
    <div class="navbar-inner">
      <div class="container">
        <div class="pull-right">
          
          {* == IS USER LOGGED IN? == *}
          
          {if $LOGGED_IN == 'yes'}
            <a href="{$SETTINGS->scriptpath}/?p=dashboard"><i class="fa fa-dashboard fa-fw"></i> {$TXT[2]}</a>
            
            {* == SHOW IF FAQ IS ENABLED == *}
            
            {if $SETTINGS->kbase == 'yes'}
              <a href="{$SETTINGS->scriptpath}/"><i class="fa fa-question-circle fa-fw"></i> {$TXT[0]}</a>
            {/if}
            
          {else}
            <a href="{$SETTINGS->scriptpath}/?p=open" rel="nofollow"><i class="fa fa-pencil fa-fw"></i> {$TXT[1]}</a>
            
            {* == IS ACCOUNT CREATION ENABLED? == *}
            
            {if $SETTINGS->createAcc == 'yes'}
              <a href="{$SETTINGS->scriptpath}/?p=create" rel="nofollow"><i class="fa fa-user fa-fw"></i> {$TXT[8]}</a>
            {/if}

            <a href="{$SETTINGS->scriptpath}/?p=login" rel="nofollow"><i class="fa fa-sign-in fa-fw"></i> {$TXT[4]}</a>
          {/if}

        </div>
        <i class="fa fa-{($LOAD_OFF_CANVAS_MENU == 'yes' ? 'bars fa-fw menu-btn' : ($LOGGED_IN == 'yes' ? 'lock fa-fw nocanvas' : 'life-ring fa-fw nocanvas'))}"></i> <span><a href="index.php">{$TOP_BAR_TITLE}</a></span>
      </div>
    </div>
  </div>