<?php

declare(strict_types=1);

/**
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

namespace OpenSearch\Endpoints\Ltr;

use OpenSearch\Exception\RuntimeException;
use OpenSearch\Endpoints\AbstractEndpoint;

/**
 * NOTE: This file is autogenerated using util/GenerateEndpoints.php
 */
class DeleteModel extends AbstractEndpoint
{
    protected $store;

    public function getURI(): string
    {
        if (!isset($this->id) || $this->id === '') {
            throw new RuntimeException('id is required for delete_model');
        }
        $id = $this->id;
        $store = $this->store ?? null;
        if (isset($store)) {
            return '/_ltr/' . rawurlencode($store) . '/_model/' . rawurlencode($id);
        }
        return '/_ltr/_model/' . rawurlencode($id);
    }

    public function getParamWhitelist(): array
    {
        return [
            'pretty',
            'human',
            'error_trace',
            'source',
            'filter_path'
        ];
    }

    public function getMethod(): string
    {
        return 'DELETE';
    }

    public function setStore($store): static
    {
        if (is_null($store)) {
            return $this;
        }
        $this->store = $store;

        return $this;
    }
}
