<?php

declare(strict_types=1);

/**
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

namespace OpenSearch\Endpoints\Cluster;

use OpenSearch\Exception\RuntimeException;
use OpenSearch\Endpoints\AbstractEndpoint;

/**
 * NOTE: This file is autogenerated using util/GenerateEndpoints.php
 */
class PutWeightedRouting extends AbstractEndpoint
{
    protected $attribute;

    public function getURI(): string
    {
        $attribute = $this->attribute ?? null;
        if (isset($attribute)) {
            return '/_cluster/routing/awareness/' . rawurlencode($attribute) . '/weights';
        }
        throw new RuntimeException('Missing parameter for the endpoint cluster.put_weighted_routing');
    }

    public function getParamWhitelist(): array
    {
        return [
            'pretty',
            'human',
            'error_trace',
            'source',
            'filter_path'
        ];
    }

    public function getMethod(): string
    {
        return 'PUT';
    }

    public function setBody($body): static
    {
        if (is_null($body)) {
            return $this;
        }
        $this->body = $body;

        return $this;
    }

    public function setAttribute($attribute): static
    {
        if (is_null($attribute)) {
            return $this;
        }
        $this->attribute = $attribute;

        return $this;
    }
}
