<?php

declare(strict_types=1);

/**
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

namespace OpenSearch\Endpoints\Security;

use OpenSearch\Common\Exceptions\RuntimeException;
use OpenSearch\Endpoints\AbstractEndpoint;

class DeleteRoleMapping extends AbstractEndpoint
{
    /**
     * @var string|null
     */
    protected $role;

    public function getParamWhitelist(): array
    {
        return [];
    }

    public function getURI(): string
    {
        if (!isset($this->role)) {
            throw new RuntimeException('Missing parameter for the endpoint security.delete_role_mapping');
        }

        return "/_plugins/_security/api/rolesmapping/$this->role";
    }

    public function getMethod(): string
    {
        return 'DELETE';
    }

    /**
     * @param string|null $role
     * @return DeleteRoleMapping
     */
    public function setRole(?string $role): DeleteRoleMapping
    {
        $this->role = $role;
        return $this;
    }
}
