<?php

declare(strict_types=1);

/**
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 *
 * OpenSearch PHP client
 *
 * @link      https://github.com/opensearch-project/opensearch-php/
 * @copyright Copyright (c) Elasticsearch B.V (https://www.elastic.co)
 * @license   http://www.apache.org/licenses/LICENSE-2.0 Apache License, Version 2.0
 * @license   https://www.gnu.org/licenses/lgpl-2.1.html GNU Lesser General Public License, Version 2.1
 *
 * Licensed to Elasticsearch B.V under one or more agreements.
 * Elasticsearch B.V licenses this file to you under the Apache 2.0 License or
 * the GNU Lesser General Public License, Version 2.1, at your option.
 * See the LICENSE file in the project root for more information.
 */

namespace OpenSearch\Namespaces;

use OpenSearch\Endpoints\Tasks\Cancel;
use OpenSearch\Endpoints\Tasks\Get;
use OpenSearch\Endpoints\Tasks\ListTasks;

/**
 * Class TasksNamespace
 *
 * NOTE: This file is autogenerated using util/GenerateEndpoints.php
 */
class TasksNamespace extends AbstractNamespace
{
    /**
     * Cancels a task, if it can be cancelled through an API.
     *
     * $params['task_id']             = (string) The task ID.
     * $params['actions']             = (any) A comma-separated list of actions that should be returned. Keep empty to return all.
     * $params['nodes']               = (array) A comma-separated list of node IDs or names used to limit the returned information. Use `_local` to return information from the node you're connecting to, specify the node name to get information from a specific node, or keep the parameter empty to get information from all nodes.
     * $params['parent_task_id']      = (string) Returns tasks with a specified parent task ID (`node_id:task_number`). Keep empty or set to -1 to return all.
     * $params['wait_for_completion'] = (boolean) Waits for the matching task to complete. When `true`, the request is blocked until the task has completed. (Default = false)
     * $params['pretty']              = (boolean) Whether to pretty-format the returned JSON response. (Default = false)
     * $params['human']               = (boolean) Whether to return human-readable values for statistics. (Default = false)
     * $params['error_trace']         = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']              = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path']         = (any) A comma-separated list of filters used to filter the response. Use wildcards to match any field or part of a field's name. To exclude fields, use `-`.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function cancel(array $params = [])
    {
        $task_id = $this->extractArgument($params, 'task_id');

        $endpoint = $this->endpointFactory->getEndpoint(Cancel::class);
        $endpoint->setParams($params);
        $endpoint->setTaskId($task_id);

        return $this->performRequest($endpoint);
    }

    /**
     * Returns information about a task.
     *
     * $params['task_id']             = (string) The task ID.
     * $params['timeout']             = (string) The amount of time to wait for a response.
     * $params['wait_for_completion'] = (boolean) Waits for the matching task to complete. When `true`, the request is blocked until the task has completed. (Default = false)
     * $params['pretty']              = (boolean) Whether to pretty-format the returned JSON response. (Default = false)
     * $params['human']               = (boolean) Whether to return human-readable values for statistics. (Default = false)
     * $params['error_trace']         = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']              = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path']         = (any) A comma-separated list of filters used to filter the response. Use wildcards to match any field or part of a field's name. To exclude fields, use `-`.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function get(array $params = [])
    {
        $task_id = $this->extractArgument($params, 'task_id');

        $endpoint = $this->endpointFactory->getEndpoint(Get::class);
        $endpoint->setParams($params);
        $endpoint->setTaskId($task_id);

        return $this->performRequest($endpoint);
    }

    /**
     * Returns a list of tasks.
     *
     * $params['actions']             = (any) A comma-separated list of actions that should be returned. Keep empty to return all.
     * $params['detailed']            = (boolean) When `true`, the response includes detailed information about shard recoveries. (Default = false)
     * $params['group_by']            = (enum) Groups tasks by parent/child relationships or nodes. (Options = nodes,none,parents)
     * $params['nodes']               = (array) A comma-separated list of node IDs or names used to limit the returned information. Use `_local` to return information from the node you're connecting to, specify the node name to get information from a specific node, or keep the parameter empty to get information from all nodes.
     * $params['parent_task_id']      = (string) Returns tasks with a specified parent task ID (`node_id:task_number`). Keep empty or set to -1 to return all.
     * $params['timeout']             = (string) The amount of time to wait for a response.
     * $params['wait_for_completion'] = (boolean) Waits for the matching task to complete. When `true`, the request is blocked until the task has completed. (Default = false)
     * $params['pretty']              = (boolean) Whether to pretty-format the returned JSON response. (Default = false)
     * $params['human']               = (boolean) Whether to return human-readable values for statistics. (Default = false)
     * $params['error_trace']         = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']              = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path']         = (any) A comma-separated list of filters used to filter the response. Use wildcards to match any field or part of a field's name. To exclude fields, use `-`.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function list(array $params = [])
    {
        $endpoint = $this->endpointFactory->getEndpoint(ListTasks::class);
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }

    /**
     * Proxy function to list() to prevent BC break since 7.4.0
     */
    public function tasksList(array $params = [])
    {
        return $this->list($params);
    }
}
