<?php

return [
    /*
    |--------------------------------------------------------------------------
    | All Settings
    |--------------------------------------------------------------------------
    */

    'documentation' => [
        'version' => 'Current version of Lychee',
        'check_for_updates' => 'Automatically check for new updates',
        'sorting_photos_col' => 'Default column used for sorting photos',
        'sorting_photos_order' => 'Default order used for sorting photos',
        'sorting_albums_col' => 'Default column used for sorting albums',
        'sorting_albums_order' => 'Default order used for sorting albums',
        'imagick' => 'Enable imagick processing',
        'dropbox_key' => 'Dropbox API key',
        'skip_duplicates' => 'Skip duplicate if found on import',
        'lang' => 'Language used by Lychee',
        'default_license' => 'Default license used for albums',
        'small_max_width' => 'Maximum width for small thumbs (album view)',
        'small_max_height' => 'Maximum height for small thumbs (album view)',
        'medium_max_width' => 'Maximum width for medium image (photo view)',
        'medium_max_height' => 'Maximum height for medium image (photo view)',
        'grants_full_photo_access' => 'Allows access to full resolution by default',
        'delete_imported' => 'When importing from server, delete originals',
        'mod_frame_enabled' => 'Enable Mod Frame',
        'mod_frame_refresh' => 'Refresh rate of the Frame',
        'image_overlay_type' => 'Default image overlay information',
        'compression_quality' => 'Compression percent when generating thumbs',
        'landing_page_enable' => 'Display the landing page',
        'site_owner' => 'Website Owner',
        'landing_title' => 'Title on the landing page',
        'landing_subtitle' => 'Subtitle on the landing page',
        'sm_facebook_url' => 'Url of facebook profile',
        'sm_flickr_url' => 'Url of flickr profile',
        'sm_twitter_url' => 'Url of X profile (formerly Twitter)',
        'sm_instagram_url' => 'Url of instagram profile',
        'sm_youtube_url' => 'Url of youtube profile',
        'thumb_2x' => 'Enable 2x size of square thumbs',
        'small_2x' => 'Enable 2x size of small thumbs',
        'medium_2x' => 'Enable 2x size of medium pictures',
        'site_title' => 'Website title',
        'footer_show_copyright' => 'Display copyright in footer.',
        'site_copyright_begin' => 'Initial year of copyright',
        'site_copyright_end' => 'Last year of copyright',
        'allow_online_git_pull' => 'Allow git pull via web interface',
        'footer_additional_text' => 'Additional text of the footer.',
        'footer_show_social_media' => 'Show socials media links in footer.',
        'search_public' => 'Allows anonymous user to use the Search bar',
        'hide_version_number' => 'Hide current version number',
        'recent_age' => 'Maximum age of pictures in Recent in days',
        'grants_download' => 'Grants download by default.',
        'photos_wraparound' => 'Once reaching last picture of an album, loop back to the start',
        'raw_formats' => 'Allowed extra formats, will not be processed',
        'map_display' => 'Display the map given GPS coordinates',
        'zip64' => 'Use Zip 64bits instead of 32 bits',
        'map_display_public' => 'Allow anonymous users to access the map',
        'map_provider' => 'Defines the map provider',
        'map_include_subalbums' => 'Includes pictures of the sub albums on the map',
        'update_check_every_days' => 'Frequency of Lychee update checks',
        'has_exiftool' => 'Defines whether exiftool processing is available',
        'share_button_visible' => 'Share button visibility in the header',
        'has_ffmpeg' => 'Defines whether ffmpeg processing is available',
        'import_via_symlink' => 'Use symbolic links instead of copying the original on import from server',
        'apply_composer_update' => 'Apply composer update on lychee update via web interface',
        'location_decoding' => 'Use GPS location decoding',
        'location_decoding_timeout' => 'Timeout for the GPS decoding queries',
        'location_show' => 'Show location extracted from GPS coordinates',
        'location_show_public' => 'Anonymous users can acess the extracted location from GPS coordinates',
        'rss_enable' => 'Enable RSS feed',
        'rss_recent_days' => 'Display the last X days in the RSS feed',
        'rss_max_items' => 'Max number of items in the RSS feed',
        'prefer_available_xmp_metadata' => 'Use sidecar if provided instead of exif metadata',
        'editor_enabled' => 'Enable manual rotation of images',
        'lossless_optimization' => 'Apply additional compression on images',
        'local_takestamp_video_formats' => 'Use local takestamp for the following video formats',
        'log_max_num_line' => 'Display the last X most recent lines in Logs',
        'unlock_password_photos_with_url_param' => 'Allow password to be passed as a URL parameter to unlock albums',
        'nsfw_visible' => 'Make sensitive albums visible by default',
        'nsfw_blur' => 'Blur sensitive albums',
        'nsfw_warning' => 'Enable sensitive albums warning',
        'nsfw_warning_admin' => 'Enable sensitive albums warning when logged in',
        'nsfw_banner_override' => 'Custom warning text instead of default.',
        'map_display_direction' => 'Display the direction of the picture on the map if available',
        'album_subtitle_type' => 'Defines the subtitle of album in albums view',
        'upload_processing_limit' => 'Maximum number of images processed in parallel',
        'new_photos_notification' => 'Enable notifications when new photos are added',
        'zip_deflate_level' => 'Zip compression level.',
        'default_album_protection' => 'Default protection for newly created albums',
        'allow_username_change' => 'Allow users to change their username.',
        'album_decoration' => 'Show decorations on album cover (sub-album and/or photo count)',
        'album_decoration_orientation' => 'Align album decorations horizontally or vertically',
        'auto_fix_orientation' => 'Automatically rotate imported images',
        'random_album_id' => 'Album id to be used by for random function.',
        'use_last_modified_date_when_no_exif_date' => 'Use the file\'s last modified time when Exif data has no creation date',
        'ffmpeg_path' => 'Path to the binary of ffmpeg',
        'ffprobe_path' => 'Path to the binary of ffprobe',
        'layout' => 'Layout for pictures',
        'date_format_photo_thumb' => 'Format the date for the photo thumbs.',
        'date_format_photo_overlay' => 'Format the date for the photo overlay.',
        'date_format_sidebar_uploaded' => 'Format the upload date for the photo sidebar.',
        'date_format_sidebar_taken_at' => 'Format the capture date for the photo sidebar.',
        'date_format_hero_min_max' => 'Format the date for the album hero.',
        'date_format_hero_created_at' => 'Format the created date for the album details.',
        'date_format_album_thumb' => 'Format the date for the album thumbs.',
        'upload_chunk_size' => 'Size of chunks when uploading in bytes: 0 is auto',
        'nsfw_banner_blur_backdrop' => 'Blur background instead of dark red opaque.',
        'search_pagination_limit' => 'Number of results to display per page.',
        'search_minimum_length_required' => 'Number of characters required to trigger search (default: 4).',
        'photo_layout_justified_row_height' => 'Heights of rows in Justified photo layout',
        'photo_layout_masonry_column_width' => 'Minimum column width in Masonry photo layout.',
        'photo_layout_grid_column_width' => 'Minimum column width in Grid photo layout.',
        'photo_layout_square_column_width' => 'Minimum column width in Square photo layout.',
        'photo_layout_gap' => 'Gap between columns in Square/Masonry/Grid photo layout.',
        'display_thumb_album_overlay' => 'Display the title and metadata on album thumbs',
        'display_thumb_photo_overlay' => 'Display the title and metadata on photo thumbs',
        'default_album_thumb_aspect_ratio' => 'Default aspect ratio for album thumbs',
        'use_album_compact_header' => 'Disable the header image in albums',
        'back_button_enabled' => 'Enable/disable back button on gallery',
        'back_button_text' => 'Text of the back button (will be positioned opposite to Login)',
        'back_button_url' => 'Link of the back button',
        'SA_random_thumbs' => 'Use random thumbs instead of stared/sorting order.',
        'login_required' => 'Require user to login to access gallery.',
        'enable_unsorted' => 'Enable Unsorted smart album.',
        'enable_starred' => 'Enable Starred smart album.',
        'enable_recent' => 'Enable Recent uploads smart album.',
        'enable_on_this_day' => 'Enable On this day smart album.',
        'oauth_create_user_on_first_attempt' => 'Allow user creation when oauth id does not exist.',
        'grant_new_user_upload_rights' => 'Newly created user are allowed to upload content.',
        'grant_new_user_modification_rights' => 'Newly created user are allowed to edit their profile.',
        'login_required_root_only' => 'Require user to login only on root. A user with a direct link to an album can still access it.',
        'exiftool_path' => 'Path to the binary of exiftool.',
        'thumb_min_max_order' => 'Set which date to display first in thumb.',
        'header_min_max_order' => 'Set which date to display first in header.',
        'autoplay_enabled' => 'Set autoplay attribute on videos.',
        'dark_mode_enabled' => 'Use dark mode for Lychee',
        'show_keybinding_help_popup' => 'Display keybinding help pop-up on login.',
        'show_keybinding_help_button' => 'Show keybinding help button in header.',
        'email' => 'Email used when requesting the license.',
        'license_key' => 'Lychee License key',
        'disable_se_call_for_actions' => 'Disable Lychee SE info',
        'enable_se_preview' => 'Preview Lychee SE features',
        'slideshow_timeout' => 'Refresh rate of the slideshow in seconds.',
        'keep_original_untouched' => 'Keep Original image untouched.',
        'default_user_quota' => 'Default space quota for new users.',
        'low_quality_image_placeholder' => 'Enable low quality image placeholders',
        'timeline_photos_enabled' => 'Enable timeline for photos',
        'timeline_photos_public' => 'Allow anonymous users to access the photo timeline',
        'timeline_photos_granularity' => 'Timeline granularity for photos',
        'timeline_photos_order' => 'Order photos on',
        'timeline_photos_layout' => 'Photo layout for timeline page',
        'timeline_photos_pagination_limit' => 'Number of photos to display per page in timeline',
        'timeline_albums_enabled' => 'Enable timeline for albums',
        'timeline_albums_public' => 'Display the albums timeline for anonymous users',
        'timeline_albums_granularity' => 'Timeline granularity for albums',
        'timeline_left_border_enabled' => 'Enable the left border line on timelines',
        'timeline_photo_date_format_year' => 'Format the date at year granularity for photos',
        'timeline_photo_date_format_month' => 'Format the date at month granularity for photos',
        'timeline_photo_date_format_day' => 'Format the date at day granularity for photos',
        'timeline_photo_date_format_hour' => 'Format the date at hour granularity for photos',
        'timeline_album_date_format_year' => 'Format the date at year granularity for albums',
        'timeline_album_date_format_month' => 'Format the date at month granularity for albums',
        'timeline_album_date_format_day' => 'Format the date at day granularity for albums',
        'hide_nsfw_in_smart_albums' => 'Do not show sensitive photos in Smart Albums',
        'hide_nsfw_in_frame' => 'Do not show sensitive photos in Frame',
        'hide_nsfw_in_map' => 'Do not show sensitive photos in Map',
        'hide_nsfw_in_search' => 'Do not show sensitive photos in Search',
        'search_photos_layout' => 'Photo layout for search page',
        'hide_nsfw_in_rss' => 'Do not show sensitive photos in RSS',
        'hide_nsfw_in_timeline' => 'Do not show sensitive photos in Timeline',
        'number_albums_per_row_mobile' => 'Number of albums per row on mobile view',
        'cache_enabled' => 'Enable caching of responses given requests.',
        'cache_event_logging' => 'Add log lines for events related to caching.',
        'cache_ttl' => 'Number of seconds responses should be cached.',
        'low_number_of_shoots_per_day' => 'Number of shoots per day to be considered as low.',
        'medium_number_of_shoots_per_day' => 'Number of shoots per day to be considered as medium.',
        'high_number_of_shoots_per_day' => 'Number of shoots per day to be considered as high.',
        'maintenance_processing_limit' => 'Number of maintenance operations to execute.',
        'disable_recursive_permission_check' => 'Disable recursive permission check.',
        'exif_disabled_for_all' => 'Disable details and overlay panels in front-end.',
        'file_name_hidden' => 'Do not show the photo title to anonymous users.',
        'client_side_favourite_enabled' => 'Allow visitors to mark pictures as their favourite.',
        'default_old_settings' => 'Settings view as text input by default.',
        'default_expert_settings' => 'Expert settings view enabled by default.',
        'default_all_settings' => 'Show all settings in one page.',
        'disable_thumb_download' => 'Disable the download of squared thumbs',
        'disable_thumb2x_download' => 'Disable the download of HiDPI squared thumbs',
        'disable_small_download' => 'Disable the download of thumbs',
        'disable_small2x_download' => 'Disable the download of HiDPI thumbs',
        'disable_medium_download' => 'Disable the download of Medium',
        'disable_medium2x_download' => 'Disable the download of HiDPI Medium',
        'landing_background_landscape' => 'URL of background image for landscape orientation',
        'landing_background_portrait' => 'URL of background image for portrait orientation',
        'metrics_enabled' => 'Enable statistics on photos & albums',
        'metrics_logged_in_users_enabed' => 'Enable statistics for logged-in users',
        'metrics_access' => 'Access level for statistics of the album/photo',
        'live_metrics_enabled' => 'Enable live statistics',
        'live_metrics_access' => 'Access level for live metrics',
        'live_metrics_max_time' => 'Max age for live metrics in days',
        'photo_thumb_info' => 'Select the info shown in photo thumbnail',
        'temporary_image_link_enabled' => 'Enable temporary image links',
        'temporary_image_link_when_logged_in' => 'Enable temporary image links for logged in users',
        'temporary_image_link_when_admin' => 'Enable temporary image links for admins',
        'temporary_image_link_life_in_seconds' => 'Maximum life time for temporary links in seconds (default is 86400s = 24 hours)',
        'secure_image_link_enabled' => 'Encrypt image links to protect them ',
        'photo_previous_next_size' => 'Select the size of the previous/next buttons in photo view.',
        'SA_override_visibility' => 'Smart album visibility overrides the photo visibility.',
        'TA_override_visibility' => 'Tag album visibility overrides the photo visibility.',
        'slideshow_enabled' => 'Enable the slideshow functionality.',
        'user_registration_enabled' => 'Enable user registration.',
        'enable_colour_extractions' => 'Extract the 5 most used colours from the image.',
        'colour_extraction_driver' => 'Driver for colour extraction.',
        'home_page_default' => 'Default home page after landing',
        'skip_duplicates_early' => 'Skip duplicate early if found on import via the sync command.',
        'sync_delete_missing_photos' => 'Photos in Lychee not present in the synced directory will be deleted from their target album.',
        'sync_delete_missing_albums' => 'Albums in Lychee not present in the synced directory will be deleted from the tree.',
        'sync_dry_run' => 'Run the destructive part of the sync command in dry-run mode.',
        'user_invitation_ttl' => 'Maximum life time for invitation links in days.',
        'flow_enabled' => 'Enable Flow display',
        'flow_public' => 'Allows anonymous user to access the Flow',
        'flow_base' => 'Base album id for the flow',
        'flow_min_max_order' => 'Set which min-max date to display first.',
        'flow_max_items' => 'Maximum number of items in the flow',
        'flow_strategy' => 'Flow strategy',
        'flow_include_sub_albums' => 'Include sub-albums in the flow',
        'flow_include_photos_from_children' => 'Include photos from children albums',
        'flow_open_album_on_click' => 'Open album on click',
        'flow_display_open_album_button' => 'Display open album button',
        'flow_highlight_first_picture' => 'Highlight first picture in the album instead of the album cover',
        'flow_min_max_enabled' => 'Enable min-max date in the flow',
        'flow_display_statistics' => 'Display album statistics in the flow',
        'flow_compact_mode_enabled' => 'Enable flow compact mode',
        'flow_image_header_enabled' => 'Enable image header in the flow',
        'flow_image_header_cover' => 'Image header display',
        'flow_image_header_height' => 'Image header height',
        'flow_carousel_enabled' => 'Enable image carousel in the flow',
        'flow_carousel_height' => 'Carousel height',
        'date_format_flow_published' => 'Format the date displayed in the flow',
        'date_format_flow_min_max' => 'Format the min-max date.',
        'flow_blur_nsfw_enabled' => 'Blur sensitive albums in Flow',
        'hide_nsfw_in_flow' => 'Do not show sensitive albums in Flow',
        'gallery_header_enabled' => 'Enable header image in the gallery view',
        'gallery_header_logged_in_enabled' => 'Enable header image in the gallery view when logged in',
        'gallery_header' => 'URL of header image in the gallery view',
        'gallery_header_bar_transparent' => 'Make the header bar transparent.',
        'gallery_header_bar_gradient' => 'Add a gradient background to the header bar.',
        'import_via_url_forbidden_localhost' => 'Import via URL must not use localhost',
        'import_via_url_forbidden_local_ip' => 'Import via URL must not use local IPs',
        'import_via_url_require_https' => 'Import via URL must use https',
        'import_via_url_forbidden_ports' => 'Import via URL must use port 80 or 443',
        'owner_id' => 'Owner of the installation',
        'details_links_enabled' => 'Enable image links in photo details',
        'details_links_public' => 'Allow anonymous users to acces image links in photo details',
        'is_scroll_to_navigate_photos_enabled' => 'Enable scrolling with mouse wheel to navigate between photos',
        'is_swipe_vertically_to_go_back_enabled' => 'Enable vertical swipe gesture on photos to return to album',
        'timeline_page_enabled' => 'Enable timeline page',
        'timeline_quick_access_date_format_year' => 'Format the quick access year granularity in the timeline page',
        'timeline_quick_access_date_format_month' => 'Format the quick access month granularity in the timeline page',
        'timeline_quick_access_date_format_day' => 'Format the quick access day granularity in the timeline page',
        'timeline_quick_access_date_format_hour' => 'Format the quick access hour granularity in the timeline page',
        'photo_thumb_tags_enabled' => 'Display the tags on the photo thumbnail in the album view',
        'hide_nsfw_in_tag_albums' => 'Do not show sensitive photos in Tag Albums',
        'hide_nsfw_in_tag_listing' => 'Do not show sensitive photos in tag listings',
        'sorting_pinned_albums_col' => 'Default column used for sorting featured albums',
        'sorting_pinned_albums_order' => 'Default order used for sorting featured albums',
        'copyright_text' => 'Copyright text (replaces default copyright notice)',
        'watermark_enabled' => 'Enable watermarking of photos',
        'watermark_photo_id' => 'Watermark photo id',
        'watermark_random_path' => 'Use random path for watermarked images',
        'watermark_public' => 'Show watermark on public photos',
        'watermark_logged_in_users_enabled' => 'Show watermark to logged in users',
        'watermark_original' => 'Also watermark the original photo',
        'watermark_size' => 'Watermark size on the image, from 1 to 100%',
        'watermark_opacity' => 'Watermark opacity ranging from 1 to 100%',
        'watermark_position' => 'Watermark position on the image',
        'watermark_shift_type' => 'Shift the watermark relatively to the size',
        'watermark_shift_x' => 'Horizontal shift',
        'watermark_shift_x_direction' => 'Direction of the horizontal shift',
        'watermark_shift_y' => 'Vertical shift',
        'watermark_shift_y_direction' => 'Direction of the vertical shift',
        'renamer_enabled' => 'Enable renamer rules',
        'renamer_enforced' => 'Enforce renamer rules',
        'renamer_enforced_before' => 'Enforce renamer rules before user rules',
        'renamer_enforced_after' => 'Enforce renamer rules after user rules',
        'renamer_photo_title_enabled' => 'Enable renamer rules on photo titles at import/upload',
        'renamer_album_title_enabled' => 'Enable renamer rules on album titles at creation',
        'extract_zip_on_upload' => 'Extract uploaded zip file and import content.',
        'webshop_enabled' => 'Enable webshop',
        'webshop_currency' => 'Purchasable currency',
        'webshop_default_description' => 'Default description for purchasable items',
        'webshop_allow_guest_checkout' => 'Allow guest checkout',
        'webshop_terms_url' => 'Terms and Conditions URL',
        'webshop_privacy_url' => 'Privacy Policy URL',
        'webshop_default_price_cents' => 'Default price in cents',
        'webshop_default_license' => 'Default license type',
        'webshop_default_size' => 'Default size variant',
        'enable_untagged' => 'Enable Untagged smart album.',
        'photos_pagination_limit' => 'Maximum number of photos to display per page in albums.',
        'webshop_offline' => 'Keep webshop offline',
        'deduplicate_pinned_albums' => 'Deduplicate featured albums.',
        'desktop_dock_full_transparency_enabled' => 'Enable dock full transparency for desktop.',
        'mobile_dock_full_transparency_enabled' => 'Enable dock transparency for mobile,',
    ],
    'details' => [
        'version' => '',
        'check_for_updates' => '',
        'sorting_photos_col' => '',
        'sorting_photos_order' => '',
        'sorting_albums_col' => '',
        'sorting_albums_order' => '',
        'imagick' => '',
        'dropbox_key' => 'Use value "disabled" to mark this setting as such.',
        'skip_duplicates' => '',
        'lang' => '',
        'default_license' => '',
        'small_max_width' => '',
        'small_max_height' => '',
        'medium_max_width' => '',
        'medium_max_height' => '',
        'grants_full_photo_access' => '',
        'delete_imported' => '',
        'mod_frame_enabled' => 'Note that access to the chosen album is required to view the frame.<br><i class="pi pi-exclamation-triangle text-orange-500"></i> The button will be visible only if the condition is satisfied.',
        'mod_frame_refresh' => '',
        'image_overlay_type' => '',
        'compression_quality' => '',
        'landing_page_enable' => '',
        'site_owner' => '',
        'landing_title' => '',
        'landing_subtitle' => '',
        'sm_facebook_url' => '',
        'sm_flickr_url' => '',
        'sm_twitter_url' => '',
        'sm_instagram_url' => '',
        'sm_youtube_url' => '',
        'thumb_2x' => '',
        'small_2x' => '',
        'medium_2x' => '',
        'site_title' => '',
        'footer_show_copyright' => '',
        'site_copyright_begin' => '',
        'site_copyright_end' => '',
        'allow_online_git_pull' => '',
        'footer_additional_text' => '<span class="pi pi-exclamation-triangle text-orange-500"></span> Unsanitized html field.',
        'footer_show_social_media' => '',
        'search_public' => '',
        'hide_version_number' => '',
        'recent_age' => '',
        'grants_download' => '',
        'photos_wraparound' => '',
        'raw_formats' => '',
        'map_display' => '',
        'zip64' => '',
        'map_display_public' => '',
        'map_provider' => '',
        'map_include_subalbums' => '',
        'update_check_every_days' => '',
        'has_exiftool' => '',
        'share_button_visible' => '',
        'has_ffmpeg' => '',
        'import_via_symlink' => '',
        'apply_composer_update' => '',
        'location_decoding' => '',
        'location_decoding_timeout' => '',
        'location_show' => '',
        'location_show_public' => '',
        'rss_enable' => '',
        'rss_recent_days' => '',
        'rss_max_items' => '',
        'prefer_available_xmp_metadata' => '',
        'editor_enabled' => '',
        'lossless_optimization' => '',
        'local_takestamp_video_formats' => '',
        'log_max_num_line' => '',
        'unlock_password_photos_with_url_param' => '',
        'nsfw_visible' => '',
        'nsfw_blur' => 'Blur the album cover.',
        'nsfw_warning' => 'Display a warning when the album is opened the first time.',
        'nsfw_warning_admin' => '',
        'nsfw_banner_override' => '<span class="pi pi-exclamation-triangle text-orange-500"></span> Unsanitized html field.',
        'map_display_direction' => '',
        'album_subtitle_type' => '',
        'upload_processing_limit' => '',
        'new_photos_notification' => '',
        'zip_deflate_level' => '-1 = disable compression (use STORE method), 0 = no compression (use DEFLATE method), 1 = minimal compression (fast), ... 9 = maximum compression (slow)',
        'default_album_protection' => '',
        'allow_username_change' => '',
        'album_decoration' => '',
        'album_decoration_orientation' => '',
        'auto_fix_orientation' => '<span class="pi pi-exclamation-triangle text-orange-500"></span> Original images will be overwritten and compressed.',
        'random_album_id' => 'Default album displayed, if left empty then all searchable photos will be used.',
        'use_last_modified_date_when_no_exif_date' => '',
        'ffmpeg_path' => '',
        'ffprobe_path' => '',
        'layout' => '',
        'date_format_photo_thumb' => 'See <a class="underline" href="https://www.php.net/manual/en/datetime.format.php">datetime.format.php</a>',
        'date_format_photo_overlay' => 'See <a class="underline" href="https://www.php.net/manual/en/datetime.format.php">datetime.format.php</a>',
        'date_format_sidebar_uploaded' => 'See <a class="underline" href="https://www.php.net/manual/en/datetime.format.php">datetime.format.php</a>',
        'date_format_sidebar_taken_at' => 'See <a class="underline" href="https://www.php.net/manual/en/datetime.format.php">datetime.format.php</a>',
        'date_format_hero_min_max' => 'See <a class="underline" href="https://www.php.net/manual/en/datetime.format.php">datetime.format.php</a>',
        'date_format_hero_created_at' => 'See <a class="underline" href="https://www.php.net/manual/en/datetime.format.php">datetime.format.php</a>',
        'date_format_album_thumb' => 'See <a class="underline" href="https://www.php.net/manual/en/datetime.format.php">datetime.format.php</a>',
        'upload_chunk_size' => '',
        'nsfw_banner_blur_backdrop' => 'Blur the backdrop of the warning.',
        'search_pagination_limit' => '',
        'search_minimum_length_required' => '',
        'photo_layout_justified_row_height' => '',
        'photo_layout_masonry_column_width' => '',
        'photo_layout_grid_column_width' => '',
        'photo_layout_square_column_width' => '',
        'photo_layout_gap' => '',
        'display_thumb_album_overlay' => '',
        'display_thumb_photo_overlay' => '',
        'default_album_thumb_aspect_ratio' => '',
        'use_album_compact_header' => '',
        'back_button_enabled' => '',
        'back_button_text' => '',
        'back_button_url' => '',
        'SA_random_thumbs' => '',
        'login_required' => '',
        'enable_unsorted' => '<span class="pi pi-exclamation-triangle text-orange-500"></span> Disabling this smart album will make pictures without an album invisible.',
        'enable_starred' => '',
        'enable_recent' => '',
        'enable_on_this_day' => '',
        'oauth_create_user_on_first_attempt' => '',
        'grant_new_user_upload_rights' => '',
        'grant_new_user_modification_rights' => '',
        'login_required_root_only' => '',
        'exiftool_path' => '',
        'thumb_min_max_order' => '',
        'header_min_max_order' => '',
        'autoplay_enabled' => '',
        'dark_mode_enabled' => '',
        'show_keybinding_help_popup' => '',
        'show_keybinding_help_button' => '',
        'email' => '',
        'license_key' => 'Get Supporter Edition here: <a class="underline" href="https://lycheeorg.github.io/get-supporter-edition">https://lycheeorg.github.io/get-supporter-edition</a>',
        'disable_se_call_for_actions' => '',
        'enable_se_preview' => '',
        'slideshow_timeout' => 'Show next picture after x seconds.',
        'keep_original_untouched' => 'In case of auto rotation, the original image will be kept untouched.',
        'default_user_quota' => 'Value in KB, keep at 0 to disable quota.',
        'low_quality_image_placeholder' => '',
        'timeline_photos_enabled' => 'Globally enable photo timelines in each albums. This can also be disabled/enabled per album.',
        'timeline_photos_public' => '',
        'timeline_photos_granularity' => '',
        'timeline_photos_order' => 'This determines whether the captured date or the upload date will be used to order the photos.',
        'timeline_photos_layout' => '',
        'timeline_photos_pagination_limit' => '',
        'timeline_albums_enabled' => 'Globally enable albums timelines in each albums (and root). This can also be disabled/enabled per album.',
        'timeline_albums_public' => '',
        'timeline_albums_granularity' => '',
        'timeline_left_border_enabled' => '',
        'timeline_photo_date_format_year' => 'See <a class="underline" href="https://www.php.net/manual/en/datetime.format.php">datetime.format.php</a>',
        'timeline_photo_date_format_month' => 'See <a class="underline" href="https://www.php.net/manual/en/datetime.format.php">datetime.format.php</a>',
        'timeline_photo_date_format_day' => 'See <a class="underline" href="https://www.php.net/manual/en/datetime.format.php">datetime.format.php</a>',
        'timeline_photo_date_format_hour' => 'See <a class="underline" href="https://www.php.net/manual/en/datetime.format.php">datetime.format.php</a>',
        'timeline_album_date_format_year' => 'See <a class="underline" href="https://www.php.net/manual/en/datetime.format.php">datetime.format.php</a>',
        'timeline_album_date_format_month' => 'See <a class="underline" href="https://www.php.net/manual/en/datetime.format.php">datetime.format.php</a>',
        'timeline_album_date_format_day' => 'See <a class="underline" href="https://www.php.net/manual/en/datetime.format.php">datetime.format.php</a>',
        'hide_nsfw_in_smart_albums' => 'Pictures placed in sensive albums will not be shown in Smart Albums.',
        'hide_nsfw_in_frame' => 'Pictures placed in sensive albums will not be shown on the Frame.',
        'hide_nsfw_in_map' => 'Pictures placed in sensive albums will not be shown on the Map.',
        'hide_nsfw_in_search' => 'Pictures placed in sensive albums will not be shown in Search.',
        'search_photos_layout' => '',
        'hide_nsfw_in_rss' => 'Pictures placed in sensive albums will not be shown in the RSS feed.',
        'hide_nsfw_in_timeline' => 'Pictures placed in sensive albums will not be shown in the timeline page.',
        'number_albums_per_row_mobile' => '',
        'cache_enabled' => 'This will significantly speed up the response time of Lychee. <span class="pi pi-exclamation-triangle text-orange-500"></span> If you are using password protected albums, you should not enable this.',
        'cache_event_logging' => 'This may result in large amount of logs',
        'cache_ttl' => 'Longer TTL will save more resources but may result in outdated responses.',
        'low_number_of_shoots_per_day' => 'This is used to determine the color in the punch card statistics.',
        'medium_number_of_shoots_per_day' => 'This is used to determine the color in the punch card statistics.',
        'high_number_of_shoots_per_day' => 'This is used to determine the color in the punch card statistics.',
        'maintenance_processing_limit' => 'Larger number will process more items in one go, but may cause timeouts.',
        'disable_recursive_permission_check' => 'Diagnostic page can be slow when there are many albums and photos. This option disables the recursive permission check for speed.',
        'exif_disabled_for_all' => '<span class="pi pi-exclamation-triangle text-orange-500"></span> This will not remove the data from the API end-point.',
        'file_name_hidden' => 'Logged in user will still have access to the title.',
        'client_side_favourite_enabled' => 'The favourites are persisted in the browser local storage.',
        'default_old_settings' => '',
        'default_expert_settings' => '',
        'default_all_settings' => '',
        'disable_thumb_download' => '',
        'disable_thumb2x_download' => '',
        'disable_small_download' => '',
        'disable_small2x_download' => '',
        'disable_medium_download' => '',
        'disable_medium2x_download' => '',
        'landing_background_landscape' => 'This image is also used when sharing the gallery link directly.',
        'landing_background_portrait' => '',
        'metrics_enabled' => 'If enabled, anonymours users will be measured.',
        'metrics_logged_in_users_enabed' => 'If enabled, logged-in users will be measured as well (admin users are not measured).',
        'metrics_access' => '',
        'live_metrics_enabled' => 'Live metrics provides you an activity history of your gallery.',
        'live_metrics_access' => 'If set to "admin", only admins can see the live metrics.',
        'live_metrics_max_time' => 'After this time, the live metrics will be deleted.',
        'photo_thumb_info' => 'If description is selected, the date will not be shown either.',
        'temporary_image_link_enabled' => 'All images will be served with a signed URL. This is a security feature to prevent hotlinking and unauthorized access to images.',
        'temporary_image_link_when_logged_in' => '',
        'temporary_image_link_when_admin' => '',
        'temporary_image_link_life_in_seconds' => '<i class="pi pi-exclamation-triangle text-orange-500"></i> If you are using request caching, set this value to a higher value than the cache expiration time.',
        'secure_image_link_enabled' => 'This ensures that the image links are not guessable.',
        'photo_previous_next_size' => 'Those buttons are hidden by default and only visible when the mouse get close to the left/right side of the screen.',
        'SA_override_visibility' => '<span class="pi pi-exclamation-triangle text-orange-500"></span> This will make any photos matching the smart album condition visible.',
        'TA_override_visibility' => '<span class="pi pi-exclamation-triangle text-orange-500"></span> This will make any photos matching the tag album condition visible.',
        'slideshow_enabled' => '',
        'user_registration_enabled' => 'If disabled, new users cannot register themselves.',
        'enable_colour_extractions' => '',
        'colour_extraction_driver' => 'Slower: league does a full sampling and use ciede2000DeltaE for colour distance calculation.<br>Faster: farzai uses spot sampling and k-mean distance.',
        'home_page_default' => '',
        'skip_duplicates_early' => 'Use the photo title to check for duplicate in the target album.',
        'sync_delete_missing_photos' => 'This option is only enabled if dry_run is disabled.',
        'sync_delete_missing_albums' => 'This option is only enabled if dry_run is disabled.',
        'sync_dry_run' => '<span class="pi pi-exclamation-triangle text-orange-500"></span> If disabled this will allow the sync command to delete albums/photos from your Lychee instance.',
        'user_invitation_ttl' => '<span class="pi pi-exclamation-triangle text-orange-500"></span> Invitation links cannot be revoked.',
        'flow_enabled' => '',
        'flow_public' => '',
        'flow_base' => 'All albums within this album will be included in the flow (leave empty for root).',
        'flow_min_max_order' => 'If set to "older_younger", the older date will be displayed first, otherwise the younger date will be displayed first.',
        'flow_max_items' => 'A lower number will require more requests, a higher number will consume more memory.',
        'flow_strategy' => 'Choose how the flow is generated. "auto" will include all albums, "opt-in" will only include albums that have the flow enabled.',
        'flow_include_sub_albums' => 'All the descendants of the base album will be included in the flow. If disabled, only the direct children of the base album will be included.',
        'flow_include_photos_from_children' => 'If an album has no photos, but has children, the photos from the children will be displayed.<br><span class="pi pi-exclamation-triangle text-orange-500"></span> This is NOT recommended. Consequences includes memory exhaution, slower loading time, crashes...',
        'flow_open_album_on_click' => 'Go to the album when clicked. If disabled, the photos will be displayed directly.',
        'flow_display_open_album_button' => 'A button to open the album will be displayed in the card.',
        'flow_highlight_first_picture' => 'The main picture displayed is the first picture in the album.',
        'flow_min_max_enabled' => 'Display the min-max date from the photos of the album in the flow.',
        'flow_display_statistics' => 'The number of views, shares, and downloads of the album will be displayed.',
        'flow_compact_mode_enabled' => 'Clamp the description to 3 lines and hides exttra information like the number of photos and children.<br>Also adds a "Show more" button to expand.',
        'flow_image_header_enabled' => 'The top of the card will highlight the cover of the album.',
        'flow_image_header_cover' => 'The image header can be displayed as a cover or fit. Cover will crop the image to fit the header, while fit will scale the image to fit the header.',
        'flow_image_header_height' => 'Heights of the image header in rem.',
        'flow_carousel_enabled' => 'Display a preview of the images in a carousel under the image header. This only applied if the image header is enabled.',
        'flow_carousel_height' => 'Heights of the image carousel in rem.',
        'date_format_flow_published' => 'See <a class="underline" href="https://www.php.net/manual/en/datetime.format.php">datetime.format.php</a>',
        'date_format_flow_min_max' => 'See <a class="underline" href="https://www.php.net/manual/en/datetime.format.php">datetime.format.php</a>',
        'flow_blur_nsfw_enabled' => 'Photos form albums marked as sensitive will be blurred in the flow. Users can unblur them by clicking on the album.',
        'hide_nsfw_in_flow' => 'Albums marked as sensitive will not be shown in the flow.',
        'gallery_header_enabled' => '',
        'gallery_header_logged_in_enabled' => '',
        'gallery_header' => '',
        'gallery_header_bar_transparent' => 'If enabled, the header bar will be transparent and the header image will be visible behind it.',
        'gallery_header_bar_gradient' => 'If enabled the header bar will have a gradient background aiming to improve the readability of the text, otherwise it will be transparent.',
        'import_via_url_forbidden_localhost' => '<span class="pi pi-exclamation-triangle text-orange-500"></span> Disabling this expose your localhost to the Import via URL functionality and lead to Server-Side Request Forgery (SSRF).',
        'import_via_url_forbidden_local_ip' => '<span class="pi pi-exclamation-triangle text-orange-500"></span> Disabling this expose your internal network to the Import via URL functionality and lead to Server-Side Request Forgery (SSRF).',
        'import_via_url_require_https' => '<span class="pi pi-exclamation-triangle text-orange-500"></span> Disabling this will lower the security of the Import via URL functionality.',
        'import_via_url_forbidden_ports' => '<span class="pi pi-exclamation-triangle text-orange-500"></span> Disabling this will allow the Import via URL to use any ports which may lead to Server-Side Request Forgery (SSRF).',
        'owner_id' => '<span class="pi pi-exclamation-triangle text-orange-500"></span> Changing this value will allow another admin to take over the server.',
        'details_links_enabled' => 'Add a small module to allow easy copying of the photo urls in the details panel.',
        'details_links_public' => '',
        'is_scroll_to_navigate_photos_enabled' => '',
        'is_swipe_vertically_to_go_back_enabled' => '',
        'timeline_page_enabled' => '',
        'timeline_quick_access_date_format_year' => 'See <a class="underline" href="https://www.php.net/manual/en/datetime.format.php">datetime.format.php</a>',
        'timeline_quick_access_date_format_month' => 'See <a class="underline" href="https://www.php.net/manual/en/datetime.format.php">datetime.format.php</a>',
        'timeline_quick_access_date_format_day' => 'See <a class="underline" href="https://www.php.net/manual/en/datetime.format.php">datetime.format.php</a>',
        'timeline_quick_access_date_format_hour' => 'See <a class="underline" href="https://www.php.net/manual/en/datetime.format.php">datetime.format.php</a>',
        'photo_thumb_tags_enabled' => 'If description is enabled on the photo thumbnail, the tags will not be displayed.',
        'hide_nsfw_in_tag_albums' => 'Pictures placed in sensive albums will not be shown in Tag Albums.',
        'hide_nsfw_in_tag_listing' => 'Pictures placed in sensive albums will not be shown on the phto listing of a given tag.',
        'sorting_pinned_albums_col' => '',
        'sorting_pinned_albums_order' => '',
        'copyright_text' => '',
        'watermark_enabled' => 'Uploaded photos will be watermarked with the configured watermark image.',
        'watermark_photo_id' => 'Photo Id (24 character sequence) of the image used for watermarking photos. We recommend png with transparency.',
        'watermark_random_path' => 'If disabled, the watermark image path will be the same as the current path but with a suffix.',
        'watermark_public' => 'Anonymous users will see watermarked photos.',
        'watermark_logged_in_users_enabled' => 'Logged-in users will see watermarked photos.',
        'watermark_original' => '',
        'watermark_size' => 'This represent the quantity of the image covered by the watermark.',
        'watermark_opacity' => '1 - nearly invisible, 100 - completely opaque. We recommend to not go under 25.',
        'watermark_position' => '',
        'watermark_shift_type' => 'When using relative, the watermark will be shifted proportionally to the size of the image.<br>When using absolute the watermark will be shifted by a quantity of pixels.',
        'watermark_shift_x' => 'Number of pixel/proportional translation applied horizontally to the watermark.',
        'watermark_shift_x_direction' => 'Direction of the translation applied to the watermark: to the left or to the right?',
        'watermark_shift_y' => 'Number of pixel/proportional translation applied vertically to the watermark.',
        'watermark_shift_y_direction' => 'Direction of the translation applied to the watermark: up or down?',
        'renamer_enabled' => 'This allows you to rename files based on rules defined in the renamer module.',
        'renamer_enforced' => 'Rules defined by the owner of the Lychee instance will be applied regardless of user settings.',
        'renamer_enforced_before' => 'Rules defined by the owner of the Lychee instance will be applied before the rules of the user.',
        'renamer_enforced_after' => 'Rules defined by the owner of the Lychee instance will be applied after the rules of the user.',
        'renamer_photo_title_enabled' => '',
        'renamer_album_title_enabled' => '',
        'extract_zip_on_upload' => 'Zip file will stay on your server unless it is properly extracted without faults (after which it is removed).',
        'webshop_enabled' => 'Albums and photos can be set as purchasable items.',
        'webshop_currency' => 'The currency in which the prices are displayed and charged. Must be a valid ISO 4217 currency code.',
        'webshop_default_description' => 'This description is used when no other description is provided for an album or photo.',
        'webshop_allow_guest_checkout' => 'Allow customers to checkout without creating an account.',
        'webshop_terms_url' => 'Optional URL to the Terms and Conditions page.',
        'webshop_privacy_url' => 'Optional URL to the Privacy Policy page.',
        'webshop_default_price_cents' => 'The default price (in cents) for new purchasable items.',
        'webshop_default_license' => 'The default license type for new purchasable items.',
        'webshop_default_size' => 'The default size variant for new purchasable items.',
        'enable_untagged' => 'If a smart album containing all the untagged photos will be available in the gallery.',
        'photos_pagination_limit' => '',
        'webshop_offline' => 'All payment processing will be skipped. Orders will be marked as OFFLINE instead of going through the payment flow..',
        'deduplicate_pinned_albums' => 'Featured albums will only appear once on the main gallery page.',
        'desktop_dock_full_transparency_enabled' => 'On the photo view, actions on top of the page are slightly transparent. Enable this to have them fully transparent and only appear on hover.',
        'mobile_dock_full_transparency_enabled' => '<span class="pi pi-exclamation-triangle text-orange-500"></span> This will impact usability on mobile. On the photo view, actions on top of the page are slightly transparent. Enable this to have them fully transparent and only appear on tap.',
    ],
];
