
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `litforum1129`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]akismet_rating`
--

CREATE TABLE `[[dbprefix]]akismet_rating` (
  `eid` int(11) NOT NULL,
  `spam` tinyint(1) NOT NULL DEFAULT '0',
  `spam_check_status` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`eid`),
  KEY `akismet_spam` (`spam`),
  KEY `spam_check_status` (`spam_check_status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]b8_rating`
--

CREATE TABLE `[[dbprefix]]b8_rating` (
  `eid` int(11) NOT NULL,
  `spam` tinyint(1) NOT NULL DEFAULT '0',
  `training_type` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`eid`),
  KEY `b8_spam` (`spam`),
  KEY `B8_training_type` (`training_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]b8_wordlist`
--

CREATE TABLE `[[dbprefix]]b8_wordlist` (
  `token` varchar(255) COLLATE utf8mb4_bin NOT NULL,
  `count_ham` int(10) unsigned DEFAULT NULL,
  `count_spam` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin;

--
-- Dumping data for table `[[dbprefix]]b8_wordlist`
--

INSERT INTO `[[dbprefix]]b8_wordlist` VALUES
('b8*dbversion', 3, NULL),
('b8*texts', 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]banlists`
--

CREATE TABLE `[[dbprefix]]banlists` (
  `name` varchar(255) NOT NULL,
  `list` text NOT NULL,
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `[[dbprefix]]banlists`
--

INSERT INTO `[[dbprefix]]banlists` VALUES
('ips', ''),
('user_agents', ''),
('words', '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]bookmarks`
--

CREATE TABLE `[[dbprefix]]bookmarks` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) unsigned NOT NULL,
  `posting_id` int(11) unsigned NOT NULL,
  `time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `subject` varchar(255) NOT NULL,
  `order_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQUE_uid_pid` (`user_id`,`posting_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]bookmark_tags`
--

CREATE TABLE `[[dbprefix]]bookmark_tags` (
  `bid` int(11) NOT NULL,
  `tid` int(11) NOT NULL,
  PRIMARY KEY (`bid`,`tid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]categories`
--

CREATE TABLE `[[dbprefix]]categories` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` int(11) NOT NULL DEFAULT '0',
  `category` varchar(255) NOT NULL DEFAULT '',
  `description` varchar(255) NOT NULL DEFAULT '',
  `accession` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]entries`
--

CREATE TABLE `[[dbprefix]]entries` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `pid` int(11) unsigned NOT NULL DEFAULT '0',
  `tid` int(11) unsigned NOT NULL DEFAULT '0',
  `uniqid` varchar(255) NOT NULL DEFAULT '',
  `time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `last_reply` timestamp NULL DEFAULT NULL,
  `edited` timestamp NULL DEFAULT NULL,
  `edited_by` int(11) unsigned DEFAULT NULL,
  `user_id` int(11) unsigned DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `subject` varchar(255) NOT NULL DEFAULT '',
  `category` int(11) unsigned NOT NULL DEFAULT '0',
  `email` varchar(255) NOT NULL DEFAULT '',
  `hp` varchar(255) NOT NULL DEFAULT '',
  `location` varchar(255) NOT NULL DEFAULT '',
  `ip` varchar(128) NOT NULL DEFAULT '',
  `text` text NOT NULL,
  `show_signature` tinyint(4) DEFAULT '0',
  `marked` tinyint(4) DEFAULT '0',
  `locked` tinyint(4) DEFAULT '0',
  `sticky` tinyint(4) DEFAULT '0',
  `views` int(11) unsigned DEFAULT '0',
  `edit_key` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `tid` (`tid`),
  KEY `category` (`category`),
  KEY `pid` (`pid`),
  KEY `sticky` (`sticky`),
  KEY `user_id` (`user_id`),
  KEY `time` (`time`),
  KEY `last_reply` (`last_reply`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]entries_cache`
--

CREATE TABLE `[[dbprefix]]entries_cache` (
  `cache_id` int(11) NOT NULL,
  `cache_text` mediumtext NOT NULL,
  PRIMARY KEY (`cache_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]entry_tags`
--

CREATE TABLE `[[dbprefix]]entry_tags` (
  `bid` int(11) NOT NULL,
  `tid` int(11) NOT NULL,
  PRIMARY KEY (`bid`,`tid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]logincontrol`
--

CREATE TABLE `[[dbprefix]]logincontrol` (
  `time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `ip` varchar(128) NOT NULL DEFAULT '',
  `logins` int(11) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]pages`
--

CREATE TABLE `[[dbprefix]]pages` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` int(11) NOT NULL,
  `title` varchar(255) NOT NULL DEFAULT '',
  `content` text NOT NULL,
  `menu_linkname` varchar(255) NOT NULL DEFAULT '',
  `access` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]read_entries`
--

CREATE TABLE `[[dbprefix]]read_entries` (
  `user_id` int(11) unsigned NOT NULL,
  `posting_id` int(11) unsigned NOT NULL,
  `time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`user_id`,`posting_id`),
  KEY `user_id` (`user_id`),
  KEY `posting_id` (`posting_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]settings`
--

CREATE TABLE `[[dbprefix]]settings` (
  `name` varchar(255) COLLATE utf8mb4_bin NOT NULL,
  `value` varchar(255) COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin;

--
-- Dumping data for table `[[dbprefix]]settings`
--

INSERT INTO `[[dbprefix]]settings` VALUES
('access_for_users_only', '0'),
('ajax_preview', '1'),
('akismet_entry_check', '0'),
('akismet_key', ''),
('akismet_mail_check', '0'),
('auto_delete_spam', '168'),
('auto_lock', '0'),
('auto_lock_old_threads', '0'),
('autolink', '1'),
('autologin', '1'),
('avatar_max_filesize', '20'),
('avatar_max_height', '80'),
('avatar_max_width', '80'),
('avatars', '0'),
('b8_auto_training', '1'),
('b8_entry_check', '1'),
('b8_mail_check', '0'),
('b8_spam_probability_threshold', '80'),
('bbcode', '1'),
('bbcode_code', '0'),
('bbcode_color', '1'),
('bbcode_img', '1'),
('bbcode_latex', '0'),
('bbcode_latex_uri', 'https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js'),
('bbcode_media', '0'),
('bbcode_size', '1'),
('captcha_email', '0'),
('captcha_posting', '0'),
('captcha_register', '0'),
('cookie_validity_days', '30'),
('count_users_online', '10'),
('count_views', '1'),
('daily_actions_time', '3:30'),
('data_privacy_agreement', '0'),
('data_privacy_statement_url', ''),
('deep_reply', '15'),
('default_email_contact', '0'),
('default_view', '0'),
('delete_inactive_users', '30'),
('delete_ips', '0'),
('dont_reg_edit_by_admin', '0'),
('dont_reg_edit_by_mod', '0'),
('edit_delay', '3'),
('edit_max_time_period', '60'),
('edit_min_time_period', '5'),
('email_maxlength', '70'),
('email_notification_unregistered', '0'),
('email_subject_maxlength', '100'),
('email_text_maxlength', '10000'),
('empty_postings_possible', '0'),
('entries_by_users_only', '0'),
('flood_prevention_minutes', '2'),
('fold_threads', '0'),
('forum_address', '[[softurl]]/'),
('forum_description', 'yet another little forum'),
('forum_disabled_message', ''),
('forum_email', '[[admin_email]]'),
('forum_enabled', '1'),
('forum_name', '[[site_name]]'),
('forum_readonly', '0'),
('home_linkaddress', '../'),
('home_linkname', ''),
('hp_maxlength', '70'),
('language_file', '[[language]].lang'),
('last_reply_link', '0'),
('latest_postings', '0'),
('link_open_target', ''),
('location_maxlength', '40'),
('location_word_maxlength', '30'),
('mail_parameter', ''),
('max_email_time', '10800'),
('max_posting_time', '10800'),
('max_register_time', '10800'),
('min_email_time', '5'),
('min_posting_time', '5'),
('min_pw_digits', '0'),
('min_pw_length', '8'),
('min_pw_lowercase_letters', '0'),
('min_pw_special_characters', '0'),
('min_pw_uppercase_letters', '0'),
('min_register_time', '5'),
('name_maxlength', '70'),
('name_word_maxlength', '30'),
('notify_inactive_users', '3'),
('page_browse_range', '10'),
('page_browse_show_last', '0'),
('php_mailer', '0'),
('profile_maxlength', '5000'),
('quote_symbol', '>'),
('read_state_expiration_method', '0'),
('read_state_expiration_value', '500'),
('register_mode', '0'),
('remember_last_visit', '1'),
('remember_userdata', '1'),
('rss_feed', '1'),
('rss_feed_max_items', '20'),
('save_spam', '1'),
('search_results_per_page', '20'),
('session_prefix', 'mlf2_'),
('show_if_edited', '1'),
('signature_maxlength', '255'),
('smilies', '1'),
('spam_check_registered', '0'),
('stop_forum_spam', '0'),
('subject_maxlength', '60'),
('subject_word_maxlength', '30'),
('syntax_highlighter', '0'),
('tag_cloud', '0'),
('tag_cloud_day_period', '30'),
('tag_cloud_scale_max', '6'),
('tag_cloud_scale_min', '0'),
('tags', '1'),
('temp_block_ip_after_repeated_failed_logins', '10'),
('terms_of_use_agreement', '0'),
('terms_of_use_url', ''),
('text_maxlength', '5000'),
('text_word_maxlength', '90'),
('theme', 'default'),
('threads_per_page', '30'),
('time_difference', '0'),
('time_zone', ''),
('upload_images', '0'),
('upload_max_img_height', '600'),
('upload_max_img_size', '60'),
('upload_max_img_width', '600'),
('uploads_per_page', '20'),
('user_area_access', '1'),
('user_edit', '1'),
('user_edit_if_no_replies', '0'),
('username_maxlength', '40'),
('users_per_page', '20'),
('very_deep_reply', '30');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]smilies`
--

CREATE TABLE `[[dbprefix]]smilies` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` int(11) NOT NULL DEFAULT '0',
  `file` varchar(100) NOT NULL DEFAULT '',
  `code_1` varchar(50) NOT NULL DEFAULT '',
  `code_2` varchar(50) NOT NULL DEFAULT '',
  `code_3` varchar(50) NOT NULL DEFAULT '',
  `code_4` varchar(50) NOT NULL DEFAULT '',
  `code_5` varchar(50) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=7 ;

--
-- Dumping data for table `[[dbprefix]]smilies`
--

INSERT INTO `[[dbprefix]]smilies` VALUES
(1, 1, 'smile.png', ':-)', '', '', '', '', ''),
(2, 2, 'wink.png', ';-)', '', '', '', '', ''),
(3, 3, 'tongue.png', ':-P', '', '', '', '', ''),
(4, 4, 'biggrin.png', ':-D', '', '', '', '', ''),
(5, 5, 'neutral.png', ':-|', '', '', '', '', ''),
(6, 6, 'frown.png', ':-(', '', '', '', '', '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]subscriptions`
--

CREATE TABLE `[[dbprefix]]subscriptions` (
  `user_id` int(12) unsigned DEFAULT NULL,
  `eid` int(12) unsigned NOT NULL,
  `unsubscribe_code` varchar(36) NOT NULL,
  `tstamp` datetime DEFAULT NULL,
  UNIQUE KEY `user_thread` USING HASH (`user_id`,`eid`),
  KEY `hash` (`unsubscribe_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tags`
--

CREATE TABLE `[[dbprefix]]tags` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `tag` varchar(128) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `tag` (`tag`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]temp_infos`
--

CREATE TABLE `[[dbprefix]]temp_infos` (
  `name` varchar(50) COLLATE utf8mb4_bin NOT NULL,
  `value` varchar(255) COLLATE utf8mb4_bin NOT NULL,
  `time` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin;

--
-- Dumping data for table `[[dbprefix]]temp_infos`
--

INSERT INTO `[[dbprefix]]temp_infos` VALUES
('access_permission_checks', '0', NULL),
('db_server_type', '[[server_type]]', '[[regtime]]'),
('db_server_version', '[[server_version]]', '[[regtime]]'),
('last_changes', '0', NULL),
('last_version_check', '20251129.1', '[[regtime]]'),
('last_version_uri', 'https://github.com/My-Little-Forum/mylittleforum/releases/tag/20251129.1', NULL),
('next_daily_actions', '[[next_daily_actions]]', '[[regtime]]'),
('php_version', '[[server_php_ver]]', '[[regtime]]'),
('version', '20251129.1', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]uploads`
--

CREATE TABLE `[[dbprefix]]uploads` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uploader` int(10) unsigned DEFAULT NULL,
  `pathname` varchar(128) COLLATE utf8mb4_bin NOT NULL,
  `tstamp` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `pathname` (`pathname`),
  KEY `smbl_[[dbprefix]]uploader` (`uploader`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]userdata`
--

CREATE TABLE `[[dbprefix]]userdata` (
  `user_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_type` tinyint(4) NOT NULL DEFAULT '0',
  `user_name` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `user_real_name` varchar(255) NOT NULL DEFAULT '',
  `gender` tinyint(4) NOT NULL DEFAULT '0',
  `birthday` date DEFAULT NULL,
  `user_pw` varchar(255) NOT NULL DEFAULT '',
  `user_email` varchar(255) NOT NULL,
  `email_contact` tinyint(4) DEFAULT '0',
  `user_hp` varchar(255) NOT NULL DEFAULT '',
  `user_location` varchar(255) NOT NULL DEFAULT '',
  `signature` varchar(255) NOT NULL DEFAULT '',
  `profile` text NOT NULL,
  `logins` int(11) NOT NULL DEFAULT '0',
  `last_login` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `last_logout` timestamp NULL DEFAULT NULL,
  `user_ip` varchar(128) NOT NULL DEFAULT '',
  `registered` timestamp NULL DEFAULT NULL,
  `category_selection` varchar(255) DEFAULT NULL,
  `thread_order` tinyint(4) NOT NULL DEFAULT '0',
  `user_view` tinyint(4) NOT NULL DEFAULT '0',
  `sidebar` tinyint(4) NOT NULL DEFAULT '1',
  `fold_threads` tinyint(4) NOT NULL DEFAULT '0',
  `thread_display` tinyint(4) NOT NULL DEFAULT '0',
  `new_posting_notification` tinyint(4) DEFAULT '0',
  `new_user_notification` tinyint(4) DEFAULT '0',
  `user_lock` tinyint(4) DEFAULT '0',
  `browser_window_target` tinyint(4) NOT NULL DEFAULT '0',
  `auto_login_code` varchar(50) NOT NULL DEFAULT '',
  `pwf_code` varchar(50) NOT NULL,
  `activate_code` varchar(50) NOT NULL DEFAULT '',
  `language` varchar(255) NOT NULL DEFAULT '',
  `time_zone` varchar(255) NOT NULL DEFAULT '',
  `time_difference` smallint(4) DEFAULT '0',
  `theme` varchar(255) NOT NULL DEFAULT '',
  `tou_accepted` datetime DEFAULT NULL,
  `dps_accepted` datetime DEFAULT NULL,
  `inactivity_notification` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`user_id`),
  UNIQUE KEY `key_user_name` (`user_name`),
  UNIQUE KEY `key_user_email` (`user_email`),
  KEY `key_user_type` (`user_type`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]userdata`
--

INSERT INTO `[[dbprefix]]userdata` VALUES
(1, 2, '[[admin_username]]', '', 0, NULL, '[[admin_pass]]', '[[admin_email]]', 1, '', '', '', '', 0, NULL, NULL, '', '[[regtime]]', NULL, 0, 0, 1, 0, 0, 0, 0, 0, 0, '', '', '', '', '', 0, '', NULL, NULL, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]userdata_cache`
--

CREATE TABLE `[[dbprefix]]userdata_cache` (
  `cache_id` int(11) NOT NULL,
  `cache_signature` text NOT NULL,
  `cache_profile` text NOT NULL,
  PRIMARY KEY (`cache_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]useronline`
--

CREATE TABLE `[[dbprefix]]useronline` (
  `ip` varchar(128) NOT NULL DEFAULT '',
  `time` int(14) NOT NULL DEFAULT '0',
  `user_id` int(11) unsigned DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `[[dbprefix]]useronline`
--

INSERT INTO `[[dbprefix]]useronline` VALUES
('[[clientip]]', [[timestamp]], 0);

--
-- Constraints for dumped tables
--

--
-- Constraints for table `[[dbprefix]]uploads`
--
ALTER TABLE `[[dbprefix]]uploads`
  ADD CONSTRAINT `smbl_[[dbprefix]]uploader` FOREIGN KEY (`uploader`) REFERENCES `[[dbprefix]]userdata` (`user_id`) ON DELETE SET NULL ON UPDATE CASCADE;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
