{config_load file=$language_file section="admin"}
{if $action=='settings'}
{if $saved}<p class="notice ok">{#settings_saved#}</p>{/if}
<form id="settings" action="index.php" method="post" accept-charset="{#charset#}">
<div>
<input type="hidden" name="mode" value="admin" />
<input type="hidden" name="csrf_token" value="{$CSRF_TOKEN}" />
<table class="normaltab descript">
<tbody>
<tr>
<td><strong>{#forum_name#}</strong><br /><span class="small">{#forum_name_desc#}</span></td>
<td><input type="text" name="forum_name" value="{$edSet.forum_name|escape}" size="40" /></td>
</tr>
<tr>
<td><strong>{#forum_description#}</strong><br /><span class="small">{#forum_description_desc#}</span></td>
<td><input type="text" name="forum_description" value="{$edSet.forum_description|escape}" size="40" /></td>
</tr>
<tr>
<td><strong>{#forum_address#}</strong><br /><span class="small">{#forum_address_desc#}</span></td>
<td><input type="text" name="forum_address" value="{$edSet.forum_address|escape}" size="40" /></td>
</tr>
<tr>
<td><strong>{#forum_email#}</strong><br /><span class="small">{#forum_email_desc#}</span></td>
<td><input type="text" name="forum_email" value="{$edSet.forum_email|escape}" size="40" /></td>
</tr>
<tr>
<td><strong>{#forum_target_name#}</strong><br /><span class="small">{#forum_target_name_desc#}</span></td>
<td><input type="text" name="link_open_target" value="{$edSet.link_open_target|escape}" size="20" /></td>
</tr>

{if $languages}
<tr>
<td><strong>{#default_language#}</strong><br /><span class="small">{#default_language_desc#}</span></td>
<td><select name="language_file" size="1">
{foreach from=$languages item=l}
<option value="{$l.identifier}"{if $l.identifier==$edSet.language_file} selected="selected"{/if}>{$l.title}</option>
{/foreach}
</select></td>
</tr>
{/if}

<tr>
<td><strong>{#default_time_zone#}</strong><br /><span class="small">{#default_time_zone_desc#}</span></td>
<td>
{if $time_zones}
<p>
<select id="time_zone" name="time_zone" size="1">
<option value=""{if $edSet.time_zone==''} selected="selected"{/if}></option>
{foreach from=$time_zones item=tz}
<option value="{$tz}"{if $tz==$edSet.time_zone} selected="selected"{/if}>{$tz}</option>
{/foreach}
</select>
</p>
{else}
<p><label for="time_difference">{#default_time_difference#}</label><br /><input id="time_difference" type="text" name="time_difference" value="{$edSet.time_difference}" size="5" /></p>
{/if}
</td>
</tr>

{if $themes}
<tr>
<td><strong>{#default_theme#}</strong><br /><span class="small">{#default_theme_desc#}</span></td>
<td><select name="theme" size="1">
{foreach from=$themes item=t}
<option value="{$t.identifier}"{if $t.identifier==$edSet.theme} selected="selected"{/if}>{$t.title}</option>
{/foreach}
</select></td>
</tr>
{/if}

<tr>
<td><strong>{#home_link#}</strong><br /><span class="small">{#home_link_desc#}</span></td>
<td><input type="text" name="home_linkaddress" value="{$edSet.home_linkaddress|escape}" size="40" /></td>
</tr>
<tr>
<td><strong>{#home_link_name#}</strong><br /><span class="small">{#home_link_name_desc#}</span></td>
<td><input type="text" name="home_linkname" value="{$edSet.home_linkname|escape}" size="40" /></td>
</tr>
<tr>
<td><strong>{#terms_of_use_settings#}</strong><br /><span class="small">{#terms_of_use_settings_desc#}</span></td>
<td>
 <ul>
  <li><input id="terms_of_use_agreement" type="checkbox" name="terms_of_use_agreement" value="1"{if $edSet.terms_of_use_agreement==1} checked="checked"{/if} /><label for="terms_of_use_agreement">{#terms_of_use_settings_enabled#}</label></li>
 </ul>
 <p><label for="terms_of_use_url">{#terms_of_use_url#}</label><br /><input id="terms_of_use_url" type="text" name="terms_of_use_url" value="{$edSet.terms_of_use_url|escape}" size="40" /></p>
</td>
</tr>
<tr>
<td><strong>{#data_privacy_statement#}</strong><br /><span class="small">{#data_privacy_statement_desc#}</span></td>
<td>
 <ul>
  <li><input id="data_privacy_agreement" type="checkbox" name="data_privacy_agreement" value="1"{if $edSet.data_privacy_agreement==1} checked="checked"{/if} /><label for="data_privacy_agreement">{#data_privacy_settings_enabled#}</label></li>
 </ul>
 <p><label for="data_privacy_statement_url">{#data_privacy_url#}</label><br /><input id="data_privacy_statement_url" type="text" name="data_privacy_statement_url" value="{$edSet.data_privacy_statement_url|escape}" size="40" /></p>
</td>
</tr>

<tr>
<td><strong>{#accession#}</strong><br /><span class="small">{#accession_desc#}</span></td>
<td>
 <ul>
  <li><input id="access_for_all" type="radio" name="access_for_users_only" value="0"{if $edSet.access_for_users_only==0} checked="checked"{/if} /><label for="access_for_all">{#all_users#}</label></li>
  <li><input id="access_for_users_only" type="radio" name="access_for_users_only" value="1"{if $edSet.access_for_users_only==1} checked="checked"{/if} /><label for="access_for_users_only">{#only_registered_users#}</label></li>
 </ul>
</td>
</tr>
<tr>
<td><strong>{#post_permission#}</strong><br /><span class="small">{#post_permission_desc#}</span></td>
<td>
 <ul>
  <li><input id="entries_by_all" type="radio" name="entries_by_users_only" value="0"{if $edSet.entries_by_users_only==0} checked="checked"{/if} /><label for="entries_by_all">{#all_users#}</label></li>
  <li><input id="entries_by_users" type="radio" name="entries_by_users_only" value="1"{if $edSet.entries_by_users_only==1} checked="checked"{/if} /><label for="entries_by_users">{#only_registered_users#}</label></li>
 </ul>
</td>
</tr>
<tr>
<td><strong>{#register_permission#}</strong><br /><span class="small">{#register_permission_desc#}</span></td>
<td>
 <ul>
  <li><input id="register_mode_0" type="radio" name="register_mode" value="0"{if $edSet.register_mode==0} checked="checked"{/if} /><label for="register_mode_0">{#register_self#}</label></li>
  <li><input id="register_mode_1" type="radio" name="register_mode" value="1"{if $edSet.register_mode==1} checked="checked"{/if} /><label for="register_mode_1">{#register_self_locked#}</label></li>
  <li><input id="register_mode_2" type="radio" name="register_mode" value="2"{if $edSet.register_mode==2} checked="checked"{/if} /><label for="register_mode_2">{#register_only_admin#}</label></li>
 </ul>
</td>
</tr>
<tr>
<td><strong>{#user_area#}</strong><br /><span class="small">{#user_area_desc#}</span></td>
<td>
 <ul>
  <li><input id="public" type="radio" name="user_area_access" value="2"{if $edSet.user_area_access==2} checked="checked"{/if} /><label for="public">{#public_accessible#}</label></li>
  <li><input id="restricted_2_users" type="radio" name="user_area_access" value="1"{if $edSet.user_area_access==1} checked="checked"{/if} /><label for="restricted_2_users">{#accessible_reg_users_only#}</label></li>
  <li><input id="restricted_2_team" type="radio" name="user_area_access" value="0"{if $edSet.user_area_access==0} checked="checked"{/if} /><label for="restricted_2_team">{#accessible_team_users_only#}</label></li>
 </ul>
</td>
</tr>
<tr>
<td><strong>{#latest_postings#}</strong><br /><span class="small">{#latest_postings_desc#}</span></td>
<td><input type="text" name="latest_postings" value="{$edSet.latest_postings|escape}" size="5" /></td>
</tr>
<tr>
<td><strong>{#tag_cloud#}</strong><br /><span class="small">{#tag_cloud_desc#}</span></td>
<td>
 <ul>
  <li><input id="tag_cloud" type="checkbox" name="tag_cloud" value="1"{if $edSet.tag_cloud==1} checked="checked"{/if} /><label for="tag_cloud">{#enable_tag_cloud#}</label></li>
 </ul>
</td>
</tr>
<tr>
<td><strong>{#edit_postings#}</strong><br /><span class="small">{#edit_postings_desc#}</span></td>
<td>
{assign var="settings_edit_delay" value=$edSet.edit_delay}
{assign var="input_edit_delay" value="<input type=\"text\" name=\"edit_delay\" value=\"$settings_edit_delay\" size=\"3\" />"}

<p><input id="show_if_edited" type="checkbox" name="show_if_edited" value="1"{if $edSet.show_if_edited==1} checked="checked"{/if} /><label for="show_if_edited">{#show_if_edited#|replace:"[minutes]":$input_edit_delay}</label><br />
<input id="dont_reg_edit_by_admin" type="checkbox" name="dont_reg_edit_by_admin" value="1"{if $edSet.dont_reg_edit_by_admin==1} checked="checked"{/if} /><label for="dont_reg_edit_by_admin">{#dont_show_edit_by_admin#}</label><br />
<input id="dont_reg_edit_by_mod" type="checkbox" name="dont_reg_edit_by_mod" value="1"{if $edSet.dont_reg_edit_by_mod==1} checked="checked"{/if} /><label for="dont_reg_edit_by_mod">{#dont_show_edit_by_mod#}</label></p>

<p><em>{#edit_own_postings#}</em></p>
<p><input id="edit_own_postings_all" type="radio" name="user_edit" value="2"{if $edSet.user_edit==2} checked="checked"{/if} /><label for="edit_own_postings_all">{#edit_own_postings_all#}</label><br />
<input id="edit_own_postings_users" type="radio" name="user_edit" value="1"{if $edSet.user_edit==1} checked="checked"{/if} /><label for="edit_own_postings_users">{#edit_own_postings_users#}</label><br />
<input id="edit_own_postings_disabled" type="radio" name="user_edit" value="0"{if $edSet.user_edit==0} checked="checked"{/if} /><label for="edit_own_postings_disabled">{#edit_own_postings_disabled#}</label></p>

<fieldset id="user_edit_details">
{assign var="settings_edit_max_time_period" value=$edSet.edit_max_time_period}
{assign var="input_edit_max_time_period" value="<input type=\"text\" id=\"edit_max_time_period\" name=\"edit_max_time_period\" value=\"$settings_edit_max_time_period\" size=\"3\" />"}
<p><label id="edit_max_time_period_label" for="edit_max_time_period">{#edit_max_time_period#|replace:"[minutes]":$input_edit_max_time_period}</label></p>
{assign var="settings_edit_min_time_period" value=$edSet.edit_min_time_period}
{assign var="input_edit_min_time_period" value="<input type=\"text\" name=\"edit_min_time_period\" value=\"$settings_edit_min_time_period\" size=\"3\" />"}
<p><input id="user_edit_if_no_replies" type="checkbox" name="user_edit_if_no_replies" value="1"{if $edSet.user_edit_if_no_replies==1} checked="checked"{/if} /><label for="user_edit_if_no_replies">{#user_edit_if_no_replies#|replace:"[minutes]":$input_edit_min_time_period}</label></p>
</fieldset>

</td>
</tr>
<tr>
<td><strong>{#bbcode#}</strong><br /><span class="small">{#bbcode_desc#}</span></td>
<td>
 <ul>
  <li><input id="bbcode" type="checkbox" name="bbcode" value="1"{if $edSet.bbcode==1} checked="checked"{/if} /><label for="bbcode">{#bbcodes_enabled#}</label></li>
  <li><input id="bbcode_img" type="checkbox" name="bbcode_img" value="1"{if $edSet.bbcode_img==1} checked="checked"{/if} /><label for="bbcode_img">{#bbcodes_img_enabled#}</label></li>
 </ul>
</td>
</tr>
<tr>
<td><strong>{#smilies#}</strong><br /><span class="small">{#smilies_desc#}</span></td>
<td>
 <ul>
  <li><input id="smilies" type="checkbox" name="smilies" value="1"{if $edSet.smilies==1} checked="checked"{/if} /><label for="smilies">{#smilies_enabled#}</label></li>
 </ul>
</td>
</tr>
<tr>
<td><strong>{#enamble_avatars#}</strong><br /><span class="small">{#enamble_avatars_desc#}</span></td>
<td>
 <ul>
  <li><input id="avatars_profiles_postings" type="radio" name="avatars" value="2"{if $edSet.avatars==2} checked="checked"{/if} /><label for="avatars_profiles_postings">{#avatars_profiles_postings#}</label></li>
  <li><input id="avatars_profiles" type="radio" name="avatars" value="1"{if $edSet.avatars==1} checked="checked"{/if} /><label for="avatars_profiles">{#avatars_profiles#}</label></li>
  <li><input id="avatars_disabled" type="radio" name="avatars" value="0"{if $edSet.avatars==0} checked="checked"{/if} /><label for="avatars_disabled">{#disabled#}</label></li>
 </ul>
{assign var="settings_avatar_max_width" value=$edSet.avatar_max_width}
{assign var="input_avatar_max_width" value="<input id=\"avatar_max_width\" type=\"text\" name=\"avatar_max_width\" value=\"$settings_avatar_max_width\" size=\"5\" />"}
{assign var="settings_avatar_max_height" value=$edSet.avatar_max_height}
{assign var="input_avatar_max_height" value="<input type=\"text\" name=\"avatar_max_height\" value=\"$settings_avatar_max_height\" size=\"5\" />"}
{assign var="settings_avatar_max_filesize" value=$edSet.avatar_max_filesize}
{assign var="input_avatar_max_filesize" value="<input type=\"text\" name=\"avatar_max_filesize\" value=\"$settings_avatar_max_filesize\" size=\"5\" />"}
 <p><label for="avatar_max_width">{#max_avatar_size#|replace:"[width]":$input_avatar_max_width|replace:"[height]":$input_avatar_max_height|replace:"[filesize]":$input_avatar_max_filesize}</label></p></td>
</tr>
<tr>
<td><strong>{#upload_images#}</strong><br /><span class="small">{#upload_images_desc#}</span></td>
<td>
 <ul>
  <li><input id="upload_images_all" type="radio" name="upload_images" value="3"{if $edSet.upload_images==3} checked="checked"{/if} /><label for="upload_images_all">{#upload_enabled_all#}</label></li>
  <li><input id="upload_images_users" type="radio" name="upload_images" value="2"{if $edSet.upload_images==2} checked="checked"{/if} /><label for="upload_images_users">{#upload_enabled_users#}</label></li>
  <li><input id="upload_images_admins_mods" type="radio" name="upload_images" value="1"{if $edSet.upload_images==1} checked="checked"{/if} /><label for="upload_images_admins_mods">{#upload_enabled_admins_mods#}</label></li>
  <li><input id="upload_images_disabled" type="radio" name="upload_images" value="0"{if $edSet.upload_images==0} checked="checked"{/if} /><label for="upload_images_disabled">{#disabled#}</label></li>
 </ul>
{assign var="settings_upload_max_width" value=$edSet.upload_max_img_width}
{assign var="input_upload_max_width" value="<input id=\"upload_max_img_width\" type=\"text\" name=\"upload_max_img_width\" value=\"$settings_upload_max_width\" size=\"5\" />"}
{assign var="settings_upload_max_height" value=$edSet.upload_max_img_height}
{assign var="input_upload_max_height" value="<input type=\"text\" name=\"upload_max_img_height\" value=\"$settings_upload_max_height\" size=\"5\" />"}
{assign var="settings_upload_max_img_size" value=$edSet.upload_max_img_size}
{assign var="input_upload_max_filesize" value="<input type=\"text\" name=\"upload_max_img_size\" value=\"$settings_upload_max_img_size\" size=\"5\" />"}
 <p><label for="upload_max_img_width">{#max_upload_size#|replace:"[width]":$input_upload_max_width|replace:"[height]":$input_upload_max_height|replace:"[filesize]":$input_upload_max_filesize}</label></p>
</td>
</tr>
<tr>
<td><strong>{#autolink#}</strong><br /><span class="small">{#autolink_desc#}</span></td>
<td>
 <ul>
  <li><input id="autolink" type="checkbox" name="autolink" value="1"{if $edSet.autolink==1} checked="checked"{/if} /><label for="autolink">{#autolink_enabled#}</label></li>
 </ul>
</td>
</tr>
<tr>
<td><strong>{#count_views#}</strong><br /><span class="small">{#count_views_desc#}</span></td>
<td>
 <ul>
  <li><input id="count_views" type="checkbox" name="count_views" value="1"{if $edSet.count_views==1} checked="checked"{/if} /><label for="count_views">{#views_counter_enabled#}</label></li>
 </ul>
</td>
</tr>
<tr>
<td><strong>{#rss_feed#}</strong><br /><span class="small">{#rss_feed_desc#}</span></td>
<td>
 <ul>
  <li><input id="rss_feed" type="checkbox" name="rss_feed" value="1"{if $edSet.rss_feed==1} checked="checked"{/if} /><label for="rss_feed">{#rss_feed_enabled#}</label></li>
 </ul>
</td>
</tr>
<tr>
<td><strong>{#threads_per_page#}</strong><br /><span class="small">{#threads_per_page_desc#}</span></td>
<td><input type="text" name="threads_per_page" value="{$edSet.threads_per_page|escape}" size="5" /></td>
</tr>
<tr>
<td><strong>{#reset_read_state#}</strong><br><span class="small">{#reset_read_state_desc#}</span></td>
<td>
 <ul>
  <li><input name="read_state_expiration_method" value="0" id="read_state_no_reset" type="radio"{if not isset($edSet.read_state_expiration_method) or $edSet.read_state_expiration_method==0} checked="checked"{/if} /><label for="read_state_no_reset">{#read_state_no_reset#}</label></li>
  <li><input id="read_state_number_reset" name="read_state_expiration_method" value="1" type="radio"{if $edSet.read_state_expiration_method==1} checked="checked"{/if} /><label for="read_state_number_reset">{#read_state_numbered_reset#}</label></li>
  <li><input name="read_state_expiration_method" value="2" id="read_state_age_reset" type="radio"{if $edSet.read_state_expiration_method==2} checked="checked"{/if} /><label for="read_state_age_reset">{#read_state_timeout_reset#}</label></li>
  <li><input name="read_state_expiration_method" value="3" id="read_state_lock_reset" type="radio"{if $edSet.read_state_expiration_method==3} checked="checked"{/if} /><label for="read_state_lock_reset">{#read_state_locktime_reset#}</label></li>
 </ul>
</td>
</tr>
<tr>
<td><strong>{#read_state_value#}</strong><br><span class="small">{#read_state_value_desc#}</span></td>
<td><input name="read_state_expiration_value" value="{$edSet.read_state_expiration_value|escape}" size="5" type="text"></td>
</tr>
<tr>
<td><strong>{#auto_lock_old_threads#}</strong><br /><span class="small">{#auto_lock_old_threads_desc#}</span></td>
<td><input type="text" name="auto_lock_old_threads" value="{$edSet.auto_lock_old_threads|escape}" size="5" /></td>
</tr>
<tr>
<td><strong>{#count_users_online#}</strong><br /><span class="small">{#count_users_online_desc#}</span></td>
<td><input type="text" name="count_users_online" value="{$edSet.count_users_online|escape}" size="5" /></td>
</tr>
<tr>
<td><strong>{#forum_enabled_marking#}</strong><br /><span class="small">{#forum_enabled_desc#}</span></td>
<td>
 <ul>
  <li><input id="forum_enabled" type="checkbox" name="forum_enabled" value="1"{if $edSet.forum_enabled==1} checked="checked"{/if} /><label for="forum_enabled">{#forum_enabled#}</label></li>
 </ul>
 <p><label for="forum_disabled_message">{#forum_disabled_message#}</label><br /><input id="forum_disabled_message" type="text" name="forum_disabled_message" value="{$edSet.forum_disabled_message|escape}" size="40" /></p>
</td>
</tr>
<tr>
<td>&nbsp;</td>
<td>
 <ul>
  <li><input id="clear_chache" type="checkbox" name="clear_cache" value="1" /><label for="clear_chache">{#clear_chache#}</label></li>
 </ul>
</td>
</tr>
</tbody>
</table>
<div class="buttonbar">
<button name="settings_submit" value="{#settings_submit_button#}">{#settings_submit_button#}</button>
</div>
</div>
</form>
<p style="margin-top:10px;"><a class="boldlink" href="index.php?mode=admin&amp;action=advanced_settings"><img class="icon wd-dependent" src="{$FORUM_ADDRESS}/{$THEMES_DIR}/{$theme}/images/arrow-bold-horizontal.svg" alt="" width="11" height="11" /><span>{#advanced_settings_link#}</span></a></p>
{elseif $action=='advanced_settings'}
{if $saved}<p class="notice ok">{#settings_saved#}</p>{/if}
<form action="index.php" method="post" accept-charset="{#charset#}">
<div>
<input type="hidden" name="mode" value="admin" />
<input type="hidden" name="return_to" value="advanced_settings" />
<input type="hidden" name="csrf_token" value="{$CSRF_TOKEN}" />
<table class="normaltab descript">
{section name=nr loop=$settings_sorted}
<tr>
<td><strong>{$settings_sorted[nr].key}</strong></td>
<td><input type="text" name="{$settings_sorted[nr].key}" value="{$settings_sorted[nr].val|escape}" /></td>
</tr>
{/section}
</table>
<div class="buttonbar">
<button name="settings_submit" value="{#settings_submit_button#}">{#settings_submit_button#}</button>
</div>
</div>
</form>
{elseif $action=='categories'}
{if $entries_in_not_existing_categories>0}
<form action="index.php" method="post" accept-charset="{#charset#}">
<div style="margin:0px 0px 20px 0px; padding:10px; border:1px dotted red;">
<input type="hidden" name="mode" value="admin" />
<p>{#entries_in_not_ex_cat#}</p>
<p><input type="radio" name="entry_action" value="delete" checked="checked" />{#entries_in_not_ex_cat_del#}<br />
<input type="radio" name="entry_action" value="move" />{#entries_in_not_ex_cat_mov#}
<select class="kat" size="1" name="move_category">
{foreach key=key item=val from=$categories}
{if $key!=0}<option value="{$key}">{$val}</option>{/if}
{/foreach}
</select>
</p>
<p><button name="entries_in_not_existing_categories_submit" value="{#submit_button_ok#}">{#submit_button_ok#}</button></p>
</div>
</form>
{/if}
{if $errors}
<p class="notice caution">{#error_headline#}</p>
<ul>
{section name=mysec loop=$errors}
{assign var="error" value=$errors[mysec]}
<li>{$smarty.config.$error}</li>
{/section}
</ul>
{/if}
{if $categories_count>0}
<table id="sortable" class="normaltab">
<thead>
<tr>
<th>{#category_name#}</th>
<th>{#category_accession#}</th>
<th>{#category_topics#}</th>
<th>{#category_entries#}</th>
<th>&#160;</th>
</tr>
</thead>
<tbody id="items">
{section name=row loop=$categories_list}
<tr id="id_{$categories_list[row].id}">
<td><strong>{$categories_list[row].name}</strong></td>
<td>{if $categories_list[row].accession==2}{#cat_accessible_admin_mod#}{elseif $categories_list[row].accession==1}{#cat_accessible_reg_users#}{else}{#cat_accessible_all#}{/if}</td>
<td>{$categories_list[row].threads_in_category}</td>
<td>{$categories_list[row].postings_in_category}</td>
<td>
 <span class="function-menu">
  <a href="index.php?mode=admin&amp;edit_category={$categories_list[row].id}"><img class="control" src="{$THEMES_DIR}/{$theme}/images/category-edit.svg" title="{#edit#}" alt="{#edit#}" width="18" height="18" /></a>
  <a href="index.php?mode=admin&amp;delete_category={$categories_list[row].id}"><img class="control" src="{$THEMES_DIR}/{$theme}/images/category-delete.svg" title="{#delete#}" alt="{#delete#}" width="18" height="18"/></a>
  <a href="index.php?mode=admin&amp;move_up_category={$categories_list[row].id}"><img class="control" src="{$THEMES_DIR}/{$theme}/images/arrow-up.svg" alt="{#up#}" title="{#up#}" width="18" height="18" /></a>
  <a href="index.php?mode=admin&amp;move_down_category={$categories_list[row].id}"><img class="control" src="{$THEMES_DIR}/{$theme}/images/arrow-down.svg" alt="{#down#}" title="{#down#}" width="18" height="18" /></a>
 </span>
</td>
</tr>
{/section}
</tbody>
</table>
{else}
<p>{#no_categories#}</p>
{/if}
<form action="index.php" method="post" class="normalform" accept-charset="{#charset#}">
 <input type="hidden" name="mode" value="admin" />
 <input type="hidden" name="csrf_token" value="{$CSRF_TOKEN}" />
 <div>
  <label for="new_category" class="main">{#new_category#}</label>
  <input id="new_category" type="text" name="new_category" size="25" value="{if $new_category}{$new_category}{/if}" required />
 </div>
 <div>
  <span class="like-label">{#category_accessible_by#}</span>
  <ul class="radiobar">
   <li><input id="cat_accessible_all" type="radio" name="accession" value="0"{if !$accession || acession==0} checked="checked"{/if} /><label for="cat_accessible_all">{#cat_accessible_all#}</label></li>
   <li><input id="cat_accessible_reg_users" type="radio" name="accession" value="1"{if acession==1} checked="checked"{/if} /><label for="cat_accessible_reg_users">{#cat_accessible_reg_users#}</label></li>
   <li><input id="cat_accessible_admin_mod" type="radio" name="accession" value="2"{if acession==2} checked="checked"{/if} /><label for="cat_accessible_admin_mod">{#cat_accessible_admin_mod#}</label></li>
  </ul>
 </div>
 <div class="buttonbar">
  <button value="{#submit_button_ok#}">{#submit_button_ok#}</button>
 </div>
</form>
{elseif $action=='edit_category'}
{if $errors}
<p class="notice caution">{#error_headline#}</p>
<ul>
{section name=mysec loop=$errors}
{assign var="error" value=$errors[mysec]}
<li>{$smarty.config.$error}</li>
{/section}
</ul>
{/if}
<form action="index.php" method="post" class="normalform" accept-charset="{#charset#}">
 <input type="hidden" name="mode" value="admin" />
 <input type="hidden" name="id" value="{$category_id}" />
 <input type="hidden" name="csrf_token" value="{$CSRF_TOKEN}" />
 <div>
  <label for="edit_category" class="main">{#edit_category#}</label>
  <input id="edit_category" type="text" name="category" value="{$edit_category}" size="25" required />
 </div>
 <div>
  <span class="like-label">{#category_accessible_by#}</span>
  <ul class="radiobar">
   <li><input id="cat_accessible_all" type="radio" name="accession" value="0"{if !$accession || acession==0} checked="checked"{/if} /><label for="cat_accessible_all">{#cat_accessible_all#}</label></li>
   <li><input id="cat_accessible_reg_users" type="radio" name="accession" value="1"{if acession==1} checked="checked"{/if} /><label for="cat_accessible_reg_users">{#cat_accessible_reg_users#}</label></li>
   <li><input id="cat_accessible_admin_mod" type="radio" name="accession" value="2"{if acession==2} checked="checked"{/if} /><label for="cat_accessible_admin_mod">{#cat_accessible_admin_mod#}</label></li>
  </ul>
 </div>
 <div class="buttonbar">
  <button name="edit_category_submit" value="{#submit_button_ok#}">{#submit_button_ok#}</button>
 </div>
</form>
{elseif $action=='delete_category'}
{if $errors}
<p class="notice caution">{#error_headline#}</p>
<ul>
{section name=mysec loop=$errors}
{assign var="error" value=$errors[mysec]}
<li>{$smarty.config.$error}</li>
{/section}
</ul>
{/if}
<h2>{#delete_category_hl#|replace:"[category]":$category_name}</h2>
<p class="notice caution">{#caution#}</p>
<form action="index.php" method="post" accept-charset="{#charset#}">
 <input type="hidden" name="mode" value="admin" />
 <input type="hidden" name="csrf_token" value="{$CSRF_TOKEN}" />
 <input type="hidden" name="category_id" value="{$category_id}" />
 <div>
  <ul class="radiolist">
   <li><input type="radio" id="del_mode_complete" name="delete_mode" value="complete" checked="checked" /><label for="del_mode_complete">{#delete_category_compl#}</label></li>
   <li><input type="radio" id="del_mode_keep" name="delete_mode" value="keep_entries" /><label for="del_mode_keep">{if $categories_count <= 1}{#del_cat_keep_entries#}
{else}{#del_cat_move_entries#}
<select class="kat" size="1" name="move_category">
<option value="0">&nbsp;</option>
{foreach key=key item=val from=$move_categories}
{if $key!=0}<option value="{$key}">{$val}</option>{/if}
{/foreach}
</select>
{/if}</label></li>
  </ul>
 </div>
 <div class="buttonbar">
  <button name="delete_category_submit" value="{#delete_category_submit#}">{#delete_category_submit#}</button>
 </div>
</form>
{elseif $action=='user'}
<h2 id="admin_header">{#user_list_header#}</h2>
{if $new_user && !$send_error}<p class="notice ok">{#new_user_registered#|replace:"[name]":$new_user}</p>{elseif $new_user && $send_error}<p class="notice caution">{#new_user_reg_send_error#|replace:"[name]":$new_user}</p>{/if}
{*<p>{#num_registerd_users#|replace:"[number]":$total_users}</p>*}

<div id="usersearch">
<form action="index.php" method="get" accept-charset="{#charset#}">
<input type="hidden" name="mode" value="admin" />
<input type="hidden" name="action" value="user" />
<div>
<label for="search-user">{#search_user#}</label>
<input id="search-user" type="search" name="search_user" value="{if $search_user}{$search_user}{/if}" placeholder="{#search_user_default_value#}" size="35" />
&nbsp;<button>{#go#}</button>
</div>
</form>
</div>
{if $pagination}
<ul class="pagination">
{if $pagination.previous}<li><a href="index.php?mode={$mode}{if $action}&amp;action={$action}{/if}{if $search_user_encoded}&amp;search_user={$search_user_encoded}{/if}{if $method && $method!='fulltext'}&amp;method={$method}{/if}{if $id}&amp;id={$id}{/if}{if $pagination.previous>1}&amp;page={$pagination.previous}{/if}{if $p_category && $p_category>0}&amp;p_category={$p_category}{/if}{if $order}&amp;order={$order}{/if}{if $descasc}&amp;descasc={$descasc}{/if}" title="{#previous_page_link_title#}">{#previous_page_link#}</a></li>{/if}
{foreach from=$pagination.items item=item}
{if $item==0}<li>&hellip;</li>{elseif $item==$pagination.current}<li><span class="current">{$item}</span></li>{else}<li><a href="index.php?mode={$mode}{if $action}&amp;action={$action}{/if}{if $search_user_encoded}&amp;search_user={$search_user_encoded}{/if}{if $method && $method!='fulltext'}&amp;method={$method}{/if}{if $id}&amp;id={$id}{/if}&amp;page={$item}{if $p_category && $p_category>0}&amp;p_category={$p_category}{/if}{if $order}&amp;order={$order}{/if}{if $descasc}&amp;descasc={$descasc}{/if}">{$item}</a></li>{/if}
{/foreach}
{if $pagination.next}<li><a href="index.php?mode={$mode}{if $action}&amp;action={$action}{/if}{if $search_user_encoded}&amp;search_user={$search_user_encoded}{/if}{if $method && $method!='fulltext'}&amp;method={$method}{/if}{if $id}&amp;id={$id}{/if}&amp;page={$pagination.next}{if $p_category && $p_category>0}&amp;p_category={$p_category}{/if}{if $order}&amp;order={$order}{/if}{if $descasc}&amp;descasc={$descasc}{/if}" title="{#next_page_link_title#}">{#next_page_link#}</a></li>{/if}
</ul>
{/if}

{if $result_count > 0}
{if $descasc=="ASC"}
{assign var=sorting_icon value="<img class=\"sa-icon\" src=\"{$THEMES_DIR}/{$theme}/images/order-asc.svg\" alt=\"[desc]\" width=\"11\" height=\"11\" />"}
{else}
{assign var=sorting_icon value="<img class=\"sa-icon\" src=\"{$THEMES_DIR}/{$theme}/images/order-desc.svg\" alt=\"[desc]\" width=\"11\" height=\"11\" />"}
{/if}
{if $no_users_in_selection}<p class="notice caution">{#no_users_in_sel#}</p>{/if}
<form action="index.php" method="post" accept-charset="{#charset#}">
<div>
<input type="hidden" name="mode" value="admin" />
<table id="itemlist" class="normaltab">
<thead>
<tr>
<th>&nbsp;</th>
<th><a href="index.php?mode=admin&amp;action=user{if $search_user_encoded}&amp;search_user={$search_user_encoded}{/if}&amp;order=user_id&amp;descasc={if $descasc=="ASC" && $order=="user_id"}DESC{else}ASC{/if}&amp;ul={$ul}" title="{#order_linktitle#}">{#user_id#}</a>
{if $order=="user_id"}{$sorting_icon}{/if}</th>
<th><a href="index.php?mode=admin&amp;action=user{if $search_user_encoded}&amp;search_user={$search_user_encoded}{/if}&amp;order=user_name&amp;descasc={if $descasc=="ASC" && $order=="user_name"}DESC{else}ASC{/if}&amp;ul={$ul}" title="{#order_linktitle#}">{#user_name#}</a>
{if $order=="user_name"}{$sorting_icon}{/if}</th>
<th><a href="index.php?mode=admin&amp;action=user{if $search_user_encoded}&amp;search_user={$search_user_encoded}{/if}&amp;order=user_email&amp;descasc={if $descasc=="ASC" && $order=="user_email"}DESC{else}ASC{/if}&amp;ul={$ul}" title="{#order_linktitle#}">{#user_email#}</a>
{if $order=="user_email"}{$sorting_icon}{/if}</th>
<th><a href="index.php?mode=admin&amp;action=user{if $search_user_encoded}&amp;search_user={$search_user_encoded}{/if}&amp;order=user_type&amp;descasc={if $descasc=="ASC" && $order=="user_type"}DESC{else}ASC{/if}&amp;ul={$ul}" title="{#order_linktitle#}">{#user_type#}</a>
{if $order=="user_type"}{$sorting_icon}{/if}</th>
<th><a href="index.php?mode=admin&amp;action=user{if $search_user_encoded}&amp;search_user={$search_user_encoded}{/if}&amp;order=registered&amp;descasc={if $descasc=="ASC" && $order=="registered"}DESC{else}ASC{/if}&amp;ul={$ul}" title="{#order_linktitle#}">{#user_registered#}</a>
{if $order=="registered"}{$sorting_icon}{/if}</th>
<th><a href="index.php?mode=admin&amp;action=user{if $search_user_encoded}&amp;search_user={$search_user_encoded}{/if}&amp;order=logins&amp;descasc={if $descasc=="ASC" && $order=="logins"}DESC{else}ASC{/if}&amp;ul={$ul}" title="{#order_linktitle#}">{#user_logins#}</a>
{if $order=="logins"}{$sorting_icon}{/if}</th>
<th><a href="index.php?mode=admin&amp;action=user{if $search_user_encoded}&amp;search_user={$search_user_encoded}{/if}&amp;order=last_login&amp;descasc={if $descasc=="ASC" && $order=="last_login"}DESC{else}ASC{/if}&amp;ul={$ul}" title="{#order_linktitle#}">{#last_login#}</a>
{if $order=="last_login"}{$sorting_icon}{/if}</th>
<th><a href="index.php?mode=admin&amp;action=user{if $search_user_encoded}&amp;search_user={$search_user_encoded}{/if}&amp;order=user_lock&amp;descasc={if $descasc=="ASC" && $order=="user_lock"}DESC{else}ASC{/if}&amp;ul={$ul}" title="{#order_linktitle#}">{#lock#}</a>
{if $order=="user_lock"}{$sorting_icon}{/if}</th>
<th colspan="2">&nbsp;</th>
</tr>
</thead>
<tbody>
{section name=row loop=$userdata}
<tr>
<td style="width:10px;"><input type="checkbox" name="selected[]" value="{$userdata[row].user_id}" /></td>
<td><span class="small">{$userdata[row].user_id}</span></td>
<td>{if $userdata[row].inactive}<span class="author-name inactive-user" title="{#user_inactive#}">{$userdata[row].user_name}</span>{else}<a href="index.php?mode=user&amp;show_user={$userdata[row].user_id}" title="{#show_userdata_linktitle#|replace:"[user]":$userdata[row].user_name}"><span class="author-name">{$userdata[row].user_name}</span></a>{/if}</td>
<td><span class="small"><a href="mailto:{$userdata[row].user_email}" title="{#mailto_user_lt#|replace:"[user]":$userdata[row].user_name}">{$userdata[row].user_email}</a></span></td>
<td><span class="small">{if $userdata[row].user_type==2}{#admin#}{elseif $userdata[row].user_type==1}{#mod#}{else}{#user#}{/if}</span></td>
<td><span class="small">{$userdata[row].registered_time}</span></td>
<td><span class="small">{$userdata[row].logins}</span></td>
<td><span class="small">{if $userdata[row].logins > 0}{$userdata[row].last_login_time}{else}&nbsp;{/if}</span></td>
<td><span class="small">{if $userdata[row].user_type>0}{if $userdata[row].user_lock==0}{#unlocked#}{else}{#locked#}{/if}{elseif $userdata[row].user_lock==0}<a href="index.php?mode=admin&amp;user_lock={$userdata[row].user_id}{if $search_user_encoded}&amp;search_user={$search_user_encoded}{/if}&amp;page={$page}&amp;order={$order}&amp;descasc={$descasc}" title="{#lock_title#}">{#unlocked#}</a>{else}<a style="color:red;" href="index.php?mode=admin&amp;user_lock={$userdata[row].user_id}{if $search_user_encoded}&amp;search_user={$search_user_encoded}{/if}&amp;page={$page}&amp;order={$order}&amp;descasc={$descasc}" title="{#unlock_title#}">{#locked#}</a>{/if}</span></td>
<td>
 <span class="function-menu">
  <a href="index.php?mode=admin&amp;edit_user={$userdata[row].user_id}"><img src="{$THEMES_DIR}/{$theme}/images/user-edit.svg" title="{#edit#}" alt="{#edit#}" width="18" height="18" /></a>
  <a href="index.php?mode=admin&amp;delete_user={$userdata[row].user_id}"><img src="{$THEMES_DIR}/{$theme}/images/user-delete.svg" title="{#delete#}" alt="{#delete#}" width="18" height="18" /></a>
 </span>
</td>
</tr>
{/section}
</tbody>
</table>

<div id="selectioncontrols" class="buttonbar">
<button type="button" id="select-all-entries" hidden data-status="unchecked"><img class="icon" src="{$THEMES_DIR}/{$theme}/images/tick.svg" alt="" width="18" height="18" /><span>{#select_all_entries#}</span></button>
<button name="delete_selected_users" value="{#delete_selected_users#}"><img class="icon" src="{$THEMES_DIR}/{$theme}/images/user-delete.svg" alt="" width="18" height="18" /><span>{#delete_selected_users#}</span></button>
</div>

</div>
</form>
{if $pagination}
<ul class="pagination">
{if $pagination.previous}<li><a href="index.php?mode={$mode}{if $action}&amp;action={$action}{/if}{if $search_user_encoded}&amp;search_user={$search_user_encoded}{/if}{if $method && $method!='fulltext'}&amp;method={$method}{/if}{if $id}&amp;id={$id}{/if}{if $pagination.previous>1}&amp;page={$pagination.previous}{/if}{if $p_category && $p_category>0}&amp;p_category={$p_category}{/if}{if $order}&amp;order={$order}{/if}{if $descasc}&amp;descasc={$descasc}{/if}" title="{#previous_page_link_title#}">{#previous_page_link#}</a></li>{/if}
{foreach from=$pagination.items item=item}
{if $item==0}<li>&hellip;</li>{elseif $item==$pagination.current}<li><span class="current">{$item}</span></li>{else}<li><a href="index.php?mode={$mode}{if $action}&amp;action={$action}{/if}{if $search_user_encoded}&amp;search_user={$search_user_encoded}{/if}{if $method && $method!='fulltext'}&amp;method={$method}{/if}{if $id}&amp;id={$id}{/if}&amp;page={$item}{if $p_category && $p_category>0}&amp;p_category={$p_category}{/if}{if $order}&amp;order={$order}{/if}{if $descasc}&amp;descasc={$descasc}{/if}">{$item}</a></li>{/if}
{/foreach}
{if $pagination.next}<li><a href="index.php?mode={$mode}{if $action}&amp;action={$action}{/if}{if $search_user_encoded}&amp;search_user={$search_user_encoded}{/if}{if $method && $method!='fulltext'}&amp;method={$method}{/if}{if $id}&amp;id={$id}{/if}&amp;page={$pagination.next}{if $p_category && $p_category>0}&amp;p_category={$p_category}{/if}{if $order}&amp;order={$order}{/if}{if $descasc}&amp;descasc={$descasc}{/if}" title="{#next_page_link_title#}">{#next_page_link#}</a></li>{/if}
</ul>
{/if}

{else}
<p><em>{#no_users#}</em></p>
{/if}
<ul class="adminmenu">
<li><a href="index.php?mode=admin&amp;action=register"><img src="{$THEMES_DIR}/{$theme}/images/user-add.svg" alt="" width="18" height="18" /><span>{#add_user#}</span></a></li>
<li><a href="index.php?mode=admin&amp;action=reset_tou"><img src="{$THEMES_DIR}/{$theme}/images/file-edit.svg" alt="" width="18" height="18" /><span>{#reset_terms_of_use#}</span></a></li>
<li><a href="index.php?mode=admin&amp;action=reset_dps"><img src="{$THEMES_DIR}/{$theme}/images/file-edit.svg" alt="" width="18" height="18" /><span>{#reset_data_privacy_statement#}</span></a></li>
<li><a href="index.php?mode=admin&amp;action=email_list"><img src="{$THEMES_DIR}/{$theme}/images/e-mail-envelope.svg" alt="" width="18" height="18" /><span>{#email_list#}</span></a></li>
<li><a href="index.php?mode=admin&amp;action=clear_userdata"><img src="{$THEMES_DIR}/{$theme}/images/delete-bin.svg" alt="" width="18" height="18" /><span>{#clear_userdata#}</span></a></li>
</ul>
{elseif $action=='edit_user'}
{config_load file=$language_file section="user_edit"}
{if $errors}
<p class="notice caution">{#error_headline#}</p>
<ul>
{section name=mysec loop=$errors}
{assign var="error" value=$errors[mysec]}
<li>{$smarty.config.$error|replace:"[profile_length]":$profil_length|replace:"[profile_maxlength]":$settings.profile_maxlength|replace:"[signature_length]":$signature_length|replace:"[signature_maxlength]":$settings.signature_maxlength|replace:"[word]":$word}</li>
{/section}
</ul>
{/if}
{if $inactive}<p class="notice caution">{#caution#}</p><p>{#activate_note#} <a href="index.php?mode=admin&amp;activate={$edit_user_id}">{#activate_link#}</a></p>{/if}
<form action="index.php" method="post" accept-charset="{#charset#}">
<div>
<input type="hidden" name="mode" value="admin" />
<input type="hidden" name="csrf_token" value="{$CSRF_TOKEN}" />
<input type="hidden" name="edit_user_id" value="{$edit_user_id}" />
<table class="normaltab descript">
<tr>
<td><strong>{#edit_user_name#}</strong></td>
<td><input type="text" size="40" name="edit_user_name" value="{$edit_user_name}" maxlength="{$settings.name_maxlength}" /></td>
</tr>
{if $avatar}
<tr>
<td><p class="userdata"><strong>{#edit_user_avatar#}</strong></p></td>
<td><p class="userdata"><img src="{$avatar.image}" alt="{#avatar_img_alt#}" width="{$avatar.width}" height="{$avatar.height}" /><br />
<input id="delete_avatar" type="checkbox" name="delete_avatar" value="1"{if $delete_avatar=="1"} checked="checked"{/if} /><label for="delete_avatar">{#delete_avatar#}</label></p>
</td>
</tr>
{/if}
<tr>
<td><strong>{#edit_user_type#}</strong></td>
<td>
 <ul>
  <li><input id="edit_user_type_0" type="radio" name="edit_user_type" value="0"{if $edit_user_type==0} checked="checked"{/if} /><label for="edit_user_type_0">{#user#}</label></li>
  <li><input id="edit_user_type_1" type="radio" name="edit_user_type" value="1"{if $edit_user_type==1} checked="checked"{/if} /><label for="edit_user_type_1">{#mod#}</label></li>
  <li><input id="edit_user_type_2" type="radio" name="edit_user_type" value="2"{if $edit_user_type==2} checked="checked"{/if} /><label for="edit_user_type_2">{#admin#}</label></li>
 </ul>
</td>
</tr>
<tr>
<td><strong>{#edit_user_email#}</strong></td>
<td><input type="text" size="40" name="user_email" value="{$user_email}" /><br />
<span class="small"><input id="email_contact" type="checkbox" name="email_contact" value="1"{if $email_contact==1} checked="checked"{/if} /><label for="email_contact">{#edit_user_email_contact#}</label></span></td>
</tr>
<tr>
<td><strong>{#edit_user_hp#}</strong></td>
<td><input type="text" size="40" name="user_hp" value="{$user_hp}" maxlength="{$settings.hp_maxlength}" /></td>
</tr>
<tr>
<td><strong>{#edit_user_real_name#}</strong></td>
<td><input type="text" size="40" name="user_real_name" value="{$user_real_name}" maxlength="{$settings.name_maxlength}" /></td>
</tr>
<tr>
<td><strong>{#edit_user_gender#}</strong></td>
<td>
<input id="no-gender" type="radio" name="user_gender" value="0"{if $user_gender=="0"} checked="checked"{/if} /><label for="no-gender">{#gender_not_specified#}</label><br />
<input id="user_gender_1" type="radio" name="user_gender" value="1"{if $user_gender=="1"} checked="checked"{/if} /><label for="user_gender_1">{#male#}</label><br />
<input id="user_gender_2" type="radio" name="user_gender" value="2"{if $user_gender=="2"} checked="checked"{/if} /><label for="user_gender_2">{#female#}</label>
</td>
</tr>
<tr>
<td><strong>{#edit_user_birthday#}</strong></td>
<td><input type="text" size="40" name="user_birthday" value="{$user_birthday}" /> <span class="small">({#birthday_format#})</span></td>
</tr>
<tr>
<td><strong>{#edit_user_location#}</strong></td>
<td><input type="text" size="40" name="user_location" value="{$user_location}" maxlength="{$settings.location_maxlength}" /></td>
</tr>
<tr>
<td><strong>{#edit_user_profile#}</strong></td>
<td><textarea cols="65" rows="4" name="profile">{$profile}</textarea></td>
</tr>
<tr>
<td><strong>{#edit_user_signature#}</strong></td>
<td><textarea cols="65" rows="4" name="signature">{$signature}</textarea></td>
</tr>

{if $languages}
<tr>
<td><strong><label for="user_language">{#edit_user_language#}</label></strong></td>
<td>
<select id="user_language" name="user_language" size="1">
<option value=""{if $user_language==''} selected="selected"{/if}></option>
{foreach from=$languages item=l}
<option value="{$l.identifier}"{if $l.identifier==$user_language} selected="selected"{/if}>{$l.title}</option>
{/foreach}
</select>
</td>
</tr>
{/if}

<tr>
<td><strong>{#edit_user_time_zone#}</strong></td>
<td>
{if $time_zones}
<p>
<select id="user_time_zone" name="user_time_zone" size="1">
<option value=""{if $user_time_zone==''} selected="selected"{/if}></option>
{foreach from=$time_zones item=tz}
<option value="{$tz}"{if $tz==$user_time_zone} selected="selected"{/if}>{$tz}</option>
{/foreach}
</select>
</p>
{/if}
<p><span class="small"><label for="user_time_difference">{#edit_user_time_difference#}</label></span><br /><input id="user_time_difference" type="text" size="6" name="user_time_difference" value="{$user_time_difference}" maxlength="6" /></p>
</td>
</tr>

{if $themes}
<tr>
<td><strong><label for="user_theme">{#edit_user_theme#}</label></strong></td>
<td>
<select id="user_theme" name="user_theme" size="1">
<option value=""{if $user_theme==''} selected="selected"{/if}></option>
{foreach from=$themes item=t}
<option value="{$t.identifier}"{if $t.identifier==$user_theme} selected="selected"{/if}>{$t.title}</option>
{/foreach}
</select>
</td>
</tr>
{/if}

{if $edit_user_type==2 || $edit_user_type==1}
<tr>
<td><strong>{#edit_user_notification#}</strong></td>
<td>
 <ul>
  <li><input id="new_posting_notification" type="checkbox" name="new_posting_notification" value="1"{if $new_posting_notification=="1"} checked="checked"{/if} /><label for="new_posting_notification">{#admin_mod_notif_posting#}</label></li>
  <li><input id="new_user_notification" type="checkbox" name="new_user_notification" value="1"{if $new_user_notification=="1"} checked="checked"{/if} /><label for="new_user_notification">{#admin_mod_notif_register#}</label></li>
 </ul>
</td>
</tr>
{/if}
</table>
<div class="buttonbar">
<button name="edit_user_submit" value="{#userdata_submit_button#}">{#userdata_submit_button#}</button>
</div>
</div>
</form>
{elseif $action=='delete_users'}
<p class="notice caution">{#caution#}</p>
<p>{if $selected_users_count>1}{#delete_users_confirmation#}{else}{#delete_user_confirmation#}{/if}</p>
<ul>
{section name=nr loop=$selected_users}
<li><a href="index.php?mode=user&amp;show_user={$selected_users[nr].id}"><strong>{$selected_users[nr].name}</strong></a></li>
{/section}
</ul>
<br />
<form action="index.php" method="post" accept-charset="{#charset#}">
<div>
<input type="hidden" name="mode" value="admin" />
<input type="hidden" name="csrf_token" value="{$CSRF_TOKEN}" />
{section name=nr loop=$selected_users}
<input type="hidden" name="selected_confirmed[]" value="{$selected_users[nr].id}" />
{/section}
<input type="submit" name="delete_confirmed" value="{#delete_submit#}" />
</div>
</form>
{elseif $action=='user_delete_entries'}
<p class="notice caution">{#caution#}</p>
<p>{#delete_entries_of_user_confirm#|replace:"[user]":$user_delete_entries['user']}</p>
<form action="index.php" method="post" accept-charset="{#charset#}">
<div>
<input type="hidden" name="mode" value="admin" />
<input type="hidden" name="csrf_token" value="{$CSRF_TOKEN}" />
<input type="hidden" name="user_delete_entries" value="{$user_delete_entries.id}" />
<input type="submit" name="delete_confirmed" value="{#delete_submit#}" />
</div>
</form>
{elseif $action=='register'}
{if $errors}
<p class="notice caution">{#error_headline#}</p>
<ul>
{section name=mysec loop=$errors}
{assign var="error" value=$errors[mysec]}
<li>{$smarty.config.$error|replace:"[word]":$ar_username}</li>
{/section}
</ul>
{/if}
<form action="index.php" method="post" accept-charset="{#charset#}">
<div>
<input type="hidden" name="mode" value="admin" />
<input type="hidden" name="csrf_token" value="{$CSRF_TOKEN}" />
<p><label for="ar_username" class="main">{#register_username#}</label><br />
<input id="ar_username" type="text" size="25" name="ar_username" value="{$ar_username|default:''}" maxlength="{$settings.name_maxlength}" /></p>
<p><label for="ar_email" class="main">{#register_email#}</label><br />
<input id="ar_email" type="text" size="25" name="ar_email" value="{$ar_email|default:''}" maxlength="{$settings.email_maxlength}" /></p>
<p><label for="ar_pw" class="main">{#register_pw#}</label><br />
<input id="ar_pw" type="password" spellcheck="false" autocomplete="off" writingsuggestions="false" size="25" name="ar_pw" maxlength="50" /></p>
<p><input id="ar_send_userdata" type="checkbox" name="ar_send_userdata" value="true"{if $ar_send_userdata} checked="checked"{/if} /> <label for="ar_send_userdata">{#register_send_userdata#}</label></p>
<p><input type="submit" name="register_submit" value="{#submit_button_ok#}" /></p>
</div>
</form>
<p class="small">{#register_exp#}</p>
{elseif $action=='smilies'}
{if $errors}
<p class="notice caution">{#error_headline#}</p>
<ul>
{section name=mysec loop=$errors}
{assign var="error" value=$errors[mysec]}
<li>{$smarty.config.$error}</li>
{/section}
</ul>
{/if}
{if $settings.smilies==1}
<table id="sortable" class="normaltab">
<thead>
<tr>
<th>{#smiley_image#}</th>
<th>{#smiley_codes#}</th>
<th>{#smiley_title#}</th>
<th>&#160;</th>
</tr>
</thead>
<tbody id="items">
{section name=row loop=$smilies}
<tr id="id_{$smilies[row].id}">
<td><img src="images/smilies/{$smilies[row].file}" alt="{$smilies[row].code_1}" /></td>
<td>{$smilies[row].codes}</td>
<td>{$smilies[row].title}</td>
<td>
 <span class="function-menu">
  <a href="index.php?mode=admin&amp;edit_smiley={$smilies[row].id}"><img class="control" src="{$THEMES_DIR}/{$theme}/images/smilies-edit.svg" title="{#edit#}" alt="{#edit#}" width="18" height="18" /></a>
  <a href="index.php?mode=admin&amp;delete_smiley={$smilies[row].id}"><img class="control" src="{$THEMES_DIR}/{$theme}/images/smilies-delete.svg" title="{#delete#}" alt="{#delete#}" width="18" height="18"/></a>
  <a href="index.php?mode=admin&amp;move_up_smiley={$smilies[row].id}"><img class="control" src="{$THEMES_DIR}/{$theme}/images/arrow-up.svg" alt="{#move_up#}" title="{#move_up#}" width="18" height="18" /></a>
  <a href="index.php?mode=admin&amp;move_down_smiley={$smilies[row].id}"><img class="control" src="{$THEMES_DIR}/{$theme}/images/arrow-down.svg" alt="{#move_down#}" title="{#move_down#}" width="18" height="18" /></a>
 </span>
</td>
</tr>
{/section}
</tbody>
</table>
{if $smiley_files}
<form action="index.php" method="post" class="normalform" accept-charset="{#charset#}">
<div>
<input type="hidden" name="mode" value="admin">
<input type="hidden" name="csrf_token" value="{$CSRF_TOKEN}" />
<table style="margin-top:20px;">
<tr>
<td><label for="add_smiley">{#add_smiley#}</label></td>
<td><label for="smiley_code">{#add_smiley_code#}</label></td>
<td>&nbsp;</td>
</tr>
<tr>
<td>
<select id="add_smiley" name="add_smiley" size="1">
{section name=nr loop=$smiley_files}
<option value="{$smiley_files[nr]}">{$smiley_files[nr]}</option>
{/section}
</select></td>
<td><input id="smiley_code" type="text" name="smiley_code" size="10" /></td>
<td><input type="submit" value="{#submit_button_ok#}" /></td>
</tr>
</table>
</div>
</form>
{else}
<p style="margin-top:20px;"><em>{#no_other_smilies_in_folder#}</em></p>
{/if}
{else}
<p><em>{#smilies_disabled#}</em></p>
{/if}
<ul class="adminmenu">
<li>{if $settings.smilies==1}<a href="index.php?mode=admin&amp;disable_smilies=true"><img src="{$THEMES_DIR}/{$theme}/images/smilies-disable.svg" alt="" width="18" height="18" class="icon" /><span>{#disable_smilies#}</span></a>{else}<a href="index.php?mode=admin&amp;enable_smilies=true"><img src="{$THEMES_DIR}/{$theme}/images/smilies.svg" alt="" width="18" height="18" class="icon" /><span>{#enable_smilies#}</span></a>{/if}</li>
</ul>
{elseif $action=='spam_protection'}
{if $errors}
<p class="notice caution">{#error_headline#}</p>
<ul>
{section name=mysec loop=$errors}
{assign var="error" value=$errors[mysec]}
<li>{$smarty.config.$error}</li>
{/section}
</ul>
{/if}
{if $saved}<p class="notice ok">{#spam_protection_saved#}</p>{/if}
<form action="index.php" method="post" accept-charset="{#charset#}">
<div>
<input type="hidden" name="mode" value="admin" />
<input type="hidden" name="csrf_token" value="{$CSRF_TOKEN}" />
<table class="normaltab descript">
<tr>
<td><strong>{#captcha#}</strong><br /><span class="small">{#captcha_desc#}{if !$graphical_captcha_available || !$font_available}<br />{#captcha_graphical_desc#}{/if}</span></td>
<td>
 <dl id="captcha-settings">
  <div>
   <dt><strong>{#captcha_posting#}</strong></dt>
   <dd><input id="captcha_posting_0" type="radio" name="captcha_posting" value="0"{if $captcha_posting==0} checked="checked"{/if} /><label for="captcha_posting_0">{#captcha_disabled#}</label></dd>
   <dd><input id="captcha_posting_1" type="radio" name="captcha_posting" value="1"{if $captcha_posting==1} checked="checked"{/if} /><label for="captcha_posting_1">{#captcha_mathematical#}</label></dd>
   <dd><input id="captcha_posting_2" type="radio" name="captcha_posting" value="2"{if $captcha_posting==2} checked="checked"{/if}{if !$graphical_captcha_available} disabled="disabled"{/if} /><label for="captcha_posting_2"{if !$graphical_captcha_available} class="unavailable"{/if}>{#captcha_graphical#}{if !$graphical_captcha_available || !$font_available}<sup>*</sup>{/if}</label></dd>
  </div>
  <div>
   <dt><strong>{#captcha_email#}</strong></dt>
   <dd><input id="captcha_email_0" type="radio" name="captcha_email" value="0"{if $captcha_email==0} checked="checked"{/if} /><label for="captcha_email_0">{#captcha_disabled#}</label></dd>
   <dd><input id="captcha_email_1" type="radio" name="captcha_email" value="1"{if $captcha_email==1} checked="checked"{/if} /><label for="captcha_email_1">{#captcha_mathematical#}</label></dd>
   <dd><input id="captcha_email_2" type="radio" name="captcha_email" value="2"{if $captcha_email==2} checked="checked"{/if}{if !$graphical_captcha_available} disabled="disabled"{/if} /><label for="captcha_email_2"{if !$graphical_captcha_available} class="unavailable"{/if}>{#captcha_graphical#}{if !$graphical_captcha_available || !$font_available}<sup>*</sup>{/if}</label></dd>
  </div>
  <div>
   <dt><strong>{#captcha_register#}</strong></dt>
   <dd><input id="captcha_register_0" type="radio" name="captcha_register" value="0"{if $captcha_register==0} checked="checked"{/if} /><label for="captcha_register_0">{#captcha_disabled#}</label></dd>
   <dd><input id="captcha_register_1" type="radio" name="captcha_register" value="1"{if $captcha_register==1} checked="checked"{/if} /><label for="captcha_register_1">{#captcha_mathematical#}</label></dd>
   <dd><input id="captcha_register_2" type="radio" name="captcha_register" value="2"{if $captcha_register==2} checked="checked"{/if}{if !$graphical_captcha_available} disabled="disabled"{/if} /><label for="captcha_register_2"{if !$graphical_captcha_available} class="unavailable"{/if}>{#captcha_graphical#}{if !$graphical_captcha_available || !$font_available}<sup>*</sup>{/if}</label></dd>
  </div>
 </dl>
 {if !$graphical_captcha_available || !$font_available}
 <p class="xsmall"><sup>*</sup> {if !$graphical_captcha_available}{#gr_captcha_not_available#}{elseif !$font_available}{#gr_captcha_no_font#}{/if}</p>
 {/if}
</td>
</tr>
<tr>
<td><strong>{#b8#}</strong><br /><span class="small">{#b8_desc#}</span></td>
<td>
 <ul>
  <li><input id="b8_entry_check" type="checkbox" name="b8_entry_check" value="1"{if $b8_entry_check==1} checked="checked"{/if} /><label for="b8_entry_check">{#b8_entry_check_enable#}</label></li>
  <li><input id="b8_mail_check" type="checkbox" name="b8_mail_check" value="1"{if $b8_mail_check==1} checked="checked"{/if} /><label for="b8_mail_check">{#b8_mail_check_enable#}</label></li>
  <li><input id="b8_auto_training" type="checkbox" name="b8_auto_training" value="1"{if $b8_auto_training==1} checked="checked"{/if} /><label for="b8_auto_training">{#b8_auto_training_enable#}</label></li>
 </ul>
 <p>{#b8_spam_probability_threshold#}<br />
  <input id="b8_spam_probability_threshold" type="input" name="b8_spam_probability_threshold" value="{$b8_spam_probability_threshold}" size="25" />
 </p>
</td>
</tr>
<tr>
<td><strong>{#stop_forum_spam#}</strong><br /><span class="small">{#stop_forum_spam_desc#}</span></td>
<td>
 <ul>
  <li><input id="stop_forum_spam" type="checkbox" name="stop_forum_spam" value="1"{if $stop_forum_spam==1} checked="checked"{/if} /><label for="stop_forum_spam">{#stop_forum_spam_enable#}</label></li>
 </ul>
</td>
</tr>
<tr>
<td><strong>{#akismet#}</strong><br /><span class="small">{#akismet_desc#}</span></td>
<td>
 <p>{#akismet_key#}<br /><input type="text" name="akismet_key" value="{$akismet_key}" size="25" /></p>
 <ul>
  <li><input id="akismet_entry_check" type="checkbox" name="akismet_entry_check" value="1"{if $akismet_entry_check==1} checked="checked"{/if} /><label for="akismet_entry_check">{#akismet_entry#}</label></li>
  <li><input id="akismet_mail_check" type="checkbox" name="akismet_mail_check" value="1"{if $akismet_mail_check==1} checked="checked"{/if} /><label for="akismet_mail_check">{#akismet_mail#}</label></li>
 </ul>
</td>
</tr>
<tr>
<td><strong>{#spam_check_registered#}</strong><br /><span class="small">{#spam_check_registered_desc#}</span></td>
<td>
 <ul>
  <li><input id="spam_check_registered" type="checkbox" name="spam_check_registered" value="1"{if $spam_check_registered==1} checked="checked"{/if} /><label for="spam_check_registered">{#spam_check_registered_enable#}</label></li>
 </ul>
</td>
</tr>
<tr>
<td><strong>{#auto_delete_spam#}</strong><br /><span class="small">{#auto_delete_spam_desc#}</span></td>
<td>
 <ul>
  <li><input id="save_spam" type="checkbox" name="save_spam" value="1"{if $save_spam==1} checked="checked"{/if} /><label for="save_spam">{#akismet_save_spam#}</label></li>
 </ul>
 <p>{#auto_delete_spam_timespan#}<br /><input type="text" name="auto_delete_spam" value="{$auto_delete_spam}" size="5" /></p>
</td>
</tr>
<tr>
<td><strong>{#not_accepted_words#}</strong><br /><span class="small">{#not_accepted_words_desc#}</span></td>
<td><textarea name="not_accepted_words" cols="35" rows="10">{$not_accepted_words}</textarea></td>
</tr>
<tr>
<td><strong>{#banned_ips#}</strong><br /><span class="small">{#banned_ips_desc#}</span></td>
<td><textarea name="banned_ips" cols="35" rows="5">{$banned_ips}</textarea></td>
</tr>
<tr>
<td><strong>{#banned_user_agents#}</strong><br /><span class="small">{#banned_user_agents_desc#}</span></td>
<td><textarea name="banned_user_agents" cols="35" rows="5">{$banned_user_agents}</textarea></td>
</tr>
</table>
<div class="buttonbar">
<button name="spam_protection_submit" value="{#spam_protection_submit#}">{#spam_protection_submit#}</button>
</div>
</div>
</form>
{elseif $action=='reset_uninstall'}
<p class="notice caution">{#caution#}</p>
{if $errors}{include file="$theme/subtemplates/errors.inc.tpl"}{/if}

<h2>{#reset_forum#}</h2>
<form action="index.php" method="post" accept-charset="{#charset#}">
 <input type="hidden" name="mode" value="admin" />
 <input type="hidden" name="csrf_token" value="{$CSRF_TOKEN}" />
 <div>
  <ul class="checkboxlist">
   <li><input id="delete_postings" type="checkbox" name="delete_postings" value="true" /><label for="delete_postings">{#delete_postings#}</label></li>
   <li><input id="delete_userdata" type="checkbox" name="delete_userdata" value="true" /><label for="delete_userdata">{#delete_userdata#}</label></li>
  </ul>
 </div>
 <div>
  <label for="confirm_pw_reset" class="main">{#admin_confirm_password#}</label>
  <input type="password" id="confirm_pw_reset" name="confirm_pw" spellcheck="false" autocomplete="off" writingsuggestions="false" size="20" />
 </div>
 <div class="buttonbar">
  <button name="reset_forum_confirmed" value="{#reset_forum_submit#}">{#reset_forum_submit#}</button>
 </div>
</form>

<hr style="margin:20px 0px 20px 0px; border-top: 1px dotted #808080; border-left: 0; border-right: 0; border-bottom: 0; height: 1px;"/>

<h2>{#uninstall_forum#}</h2>
<p>{#uninstall_forum_exp#}</p>
<form action="index.php" method="post" accept-charset="{#charset#}">
 <input type="hidden" name="mode" value="admin" />
 <input type="hidden" name="csrf_token" value="{$CSRF_TOKEN}" />
 <div>
  <label for="confirm_pw_uninstall" class="main">{#admin_confirm_password#}</label>
  <input type="password" id="confirm_pw_uninstall" name="confirm_pw" spellcheck="false" autocomplete="off" writingsuggestions="false" size="20" />
 </div>
 <div class="buttonbar">
  <button name="uninstall_forum_confirmed" value="{#uninstall_forum_submit#}">{#uninstall_forum_submit#}</button>
 </div>
</form>
{elseif $action=='update'}
<p style="margin-bottom:25px;"><span style="background:yellow; padding:5px;">{#update_current_version#|replace:"[version]":$settings.version}</span></p>

<h3>{#update_instructions_hl#}</h3>
<ul>
{foreach from=$smarty.config.update_instructions item=instruction}
<li>{$instruction}</li>
{/foreach}
</ul>

{if $errors}{include file="$theme/subtemplates/errors.inc.tpl"}{/if}
{if $message}<p class="notice ok">{$smarty.config.$message}</p>{/if}
{if $update_files}
<h3>{#update_available_files#}</h3>
<ul>
{foreach from=$update_files item=file}
<li><a href="index.php?mode=admin&amp;run_update={$file.filename}" title="{#update_file_title#}">{$file.filename}</a></li>
{/foreach}
</ul>
{else}
<p><em>{#update_no_files_available#}</em></p>
{/if}
{elseif $action=='run_update'}
<p class="notice caution">{#caution#}</p>
<p>{#update_confirm#}</p>
<p><strong>{$update_file}</strong>{if $update_from_version && $update_to_version} {#update_file_details#|replace:"[update_from_version]":$update_from_version|replace:"[update_to_version]":$update_to_version}{/if}</p>
<p style="color:red;font-weight:bold;">{#update_note#}</p>
{if $errors}{include file="$theme/subtemplates/errors.inc.tpl"}{/if}
<form action="index.php" method="post" accept-charset="{#charset#}">
 <input type="hidden" name="mode" value="admin" />
 <input type="hidden" name="update_file_submit" value="{$update_file}" />
 <input type="hidden" name="csrf_token" value="{$CSRF_TOKEN}" />
 <div>
  <label for="id_update_password">{#admin_confirm_password#}</label>
  <input type="password" name="update_password" id="id_update_password" spellcheck="false" autocomplete="off" writingsuggestions="false" size="25" />
 </div>
 <div class="buttonbar">
  <button name="update_submit" value="{#update_submit#}" onclick="document.getElementById('throbber-submit').removeAttribute('hidden');">{#update_submit#}</button>
  <img id="throbber-submit" src="{$THEMES_DIR}/{$theme}/images/throbber.svg" alt="" width="18" height="18" hidden />
 </div>
</form>
{elseif $action=='update_done'}
{if $update_errors}
<p class="notice caution">{#error_headline#}</p>
<ul>
{section name=mysec loop=$update_errors}
{assign var="error" value=$update_errors[mysec]}
<li>{$error}</li>
{/section}
</ul>
{else}
<p class="notice ok">{#update_successful#}</p>
{/if}
{if $upload_items}
<p>{#update_items_note#|replace:"[version]":$update_new_version}</p>
<ul class="filelist">
{foreach from=$upload_items item=item}
<li><img class="icon" src="{$THEMES_DIR}/{$theme}/images/{if $item.type==0}dir-open.svg{else}file.svg{/if}" alt="[{if $item.type==0}{#folder_alt#}{else}{#file_alt#}{/if}]" width="16" height="16" />{$item.name}</li>
{/foreach}
</ul>
{/if}
{if $delete_items}
<p>{#update_delete_note#}</p>
<ul class="filelist">
{foreach from=$delete_items item=item}
<li><img class="icon" src="{$THEMES_DIR}/{$theme}/images/{if $item.type==0}dir-open.svg{else}file.svg{/if}" alt="[{if $item.type==0}{#folder_alt#}{else}{#file_alt#}{/if}]" width="16" height="16" />{$item.name}</li>
{/foreach}
</ul>
{/if}
<p>{#update_reenabling_notice#}</p>
{if $update_download_url}<p class="small">{#update_download#|replace:"[[":"<a href=\"$update_download_url\">"|replace:"]]":"</a>"}</p>{/if}
{if $update_message}{$update_message}{/if}
{elseif $action == 'email_list'}
<textarea onfocus="this.select()" onclick="this.select()" readonly="readonly" cols="60" rows="15">{$email_list}</textarea>
{elseif $action == 'clear_userdata'}
{if $no_users_in_selection}<p class="notice caution">{#no_users_in_selection#}</p>{/if}
{assign var="input_logins" value="<input type=\"text\" name=\"logins\" value=\"$logins\" size=\"4\" />"}
{assign var="input_days" value="<input type=\"text\" name=\"days\" value=\"$days\" size=\"4\" />"}
<form action="index.php" method="post" accept-charset="{#charset#}">
<div>
<input type="hidden" name="mode" value="admin" />
<input type="hidden" name="csrf_token" value="{$CSRF_TOKEN}" />
<p>{$smarty.config.clear_userdata_condition|replace:"[logins]":$input_logins|replace:"[days]":$input_days} <input type="submit" name="clear_userdata" value="{#submit_button_ok#}" /></p>
</div>
</form>
<p class="small">{#clear_userdata_note#}</p>
{elseif $action == 'edit_smiley'}
{if $errors}
<p class="notice caution">{#error_headline#}</p>
<ul>
{section name=mysec loop=$errors}
{assign var="error" value=$errors[mysec]}
<li>{$smarty.config.$error}</li>
{/section}
</ul>
{/if}
<form action="index.php" method="post" accept-charset="{#charset#}">
<div>
<input type="hidden" name="mode" value="admin" />
<input type="hidden" name="id" value="{$id}" />
<input type="hidden" name="csrf_token" value="{$CSRF_TOKEN}" />
<table class="normaltab descript">
<tr>
<td><strong>{#edit_smilies_smiley#}</strong></td>
<td><select name="file" size="1">
{section name=nr loop=$smiley_files}
<option value="{$smiley_files[nr]}"{if $file==$smiley_files[nr]} selected="selected"{/if}>{$smiley_files[nr]}</option>
{/section}
</select></td>
</tr>
<tr>
<td><strong>{#edit_smilies_codes#}</strong></td>
<td><input type="text" name="code_1" size="7" value="{$code_1}" /> <input type="text" name="code_2" size="7" value="{$code_2}" /> <input type="text" name="code_3" size="7" value="{$code_3}" /> <input type="text" name="code_4" size="7" value="{$code_4}" /> <input type="text" name="code_5" size="7" value="{$code_5}" /></td>
</tr>
<tr>
<td><strong>{#edit_smilies_title#}</strong></td>
<td><input type="text" name="title" size="25" value="{$title}" /></td>
</tr>
</table>
<div class="buttonbar">
<button name="edit_smiley_submit" value="{#submit_button_ok#}">{#submit_button_ok#}</button>
</div>
</div>
</form>
{elseif $action=='pages'}
{if $pages}
<table id="sortable" class="normaltab">
<thead>
<tr>
<th>{#page_title#}</th>
<th>{#page_menu_linkname#}</th>
<th>{#page_access#}</th>
<th>&#160;</th>
</tr>
</thead>
<tbody id="items">
{section name=page loop=$pages}
<tr id="id_{$pages[page].id}">
<td><a href="index.php?mode=page&amp;id={$pages[page].id}" title="{$pages[page].title}"><strong class="control">{$pages[page].title}</strong></a></td>
<td><span class="small">{if $pages[page].menu_linkname!=''}{$pages[page].menu_linkname}{else}&nbsp;{/if}</span></td>
<td><span class="small">{if $pages[page].access==1}{#page_access_reg_users#}{elseif $pages[page].access==0}{#page_access_public#}{/if}</span></td>
<td>
 <span class="function-menu">
  <a href="index.php?mode=admin&amp;edit_page={$pages[page].id}"><img class="control" src="{$THEMES_DIR}/{$theme}/images/file-edit.svg" title="{#edit#}" alt="{#edit#}" width="18" height="18" /></a>
  <a href="index.php?mode=admin&amp;delete_page={$pages[page].id}"><img class="control" src="{$THEMES_DIR}/{$theme}/images/file-delete.svg" title="{#delete#}" alt="{#delete#}" width="18" height="18"/></a>
  <a href="index.php?mode=admin&amp;move_up_page={$pages[page].id}"><img class="control" src="{$THEMES_DIR}/{$theme}/images/arrow-up.svg" alt="{#move_up#}" title="{#move_up#}" width="18" height="18" /></a>
  <a href="index.php?mode=admin&amp;move_down_page={$pages[page].id}"><img class="control" src="{$THEMES_DIR}/{$theme}/images/arrow-down.svg" alt="{#move_down#}" title="{#move_down#}" width="18" height="18" /></a>
 </span>
</td>
</tr>
{/section}
</tbody>
</table>
{else}
<p>{#no_pages#}</p>
{/if}
<ul class="adminmenu"><li><a href="index.php?mode=admin&amp;action=edit_page"><img src="{$THEMES_DIR}/{$theme}/images/file-add.svg" alt="" width="18" height="18" /><span>{#add_page_link#}</span></a></li></ul>
{elseif $action=='edit_page'}
{if $errors}
<p class="notice caution">{#error_headline#}</p>
<ul>
{section name=mysec loop=$errors}
{assign var="error" value=$errors[mysec]}
<li>{$smarty.config.$error}</li>
{/section}
</ul>
{/if}
<form action="index.php" method="post" accept-charset="{#charset#}">
<div>
<input type="hidden" name="mode" value="admin" />
<input type="hidden" name="csrf_token" value="{$CSRF_TOKEN}" />
{if $id}<input type="hidden" name="id" value="{$id}" />{/if}
<table class="normaltab descript">
<tr>
<td><strong>{#page_title#}</strong></td>
<td><input type="text" name="title" value="{$title|default:""}" size="50" /></td>
</tr>
<tr>
<td><strong>{#page_content#}</strong><br /><span class="small">{#page_content_desc#}</span></td>
<td><textarea name="content" cols="70" rows="20">{$content|default:""}</textarea></td>
</tr>
<tr>
<td><strong>{#page_menu_linkname#}</strong><br /><span class="small">{#page_menu_linkname_desc#}</span></td>
<td><input type="text" name="menu_linkname" value="{$menu_linkname|default:""}" size="50" /></td>
</tr>
<tr>
<td><strong>{#page_access#}</strong></td>
<td>
 <ul>
  <li><input type="radio" name="access" value="0"{if $access==0} checked="checked"{/if} /><span class="small">{#page_access_public#}</span></li>
  <li><input type="radio" name="access" value="1"{if $access==1} checked="checked"{/if} /><span class="small">{#page_access_reg_users#}</span></li>
 </ul>
</td>
</tr>
</table>
<div class="buttonbar">
<button name="edit_page_submit" value="{#edit_page_submit#}">{#edit_page_submit#}</button>
</div>
</div>
</form>
{elseif $action=='delete_page'}
{if $page}
<p class="notice caution">{#caution#}</p>
<p>{#delete_page_confirm#}</p>
<p><strong>{$page.title}</strong></p>
<form action="index.php" method="post" accept-charset="{#charset#}">
<div>
<input type="hidden" name="mode" value="admin" />
<input type="hidden" name="csrf_token" value="{$CSRF_TOKEN}" />
<input type="hidden" name="id" value="{$page.id}" />
<div class="buttonbar">
<button name="delete_page_submit" value="{#delete_page_submit#}">{#delete_page_submit#}</button>
</div>
</div>
</form>
{else}
<p>{#page_doesnt_exist#}</p>
{/if}

{elseif $action=='list_uploads'}
<h2 id="admin_header">{#upload_administration#}</h2>

 <div>
  <form action="index.php" method="get" accept-charset="{#charset#}">
   <input type="hidden" name="mode" value="admin" />
   <input type="hidden" name="action" value="list_uploads" />
   <div>
    <button name="filter" value="not-managed-images">{#upload_filter_not_managed_images#}</button>
    <button name="filter" value="managed-images">{#upload_filter_managed_images#}</button>
    <button name="filter" value="all-images" class="active-filter">{#upload_filter_all_images#}</button>
   </div>
  </form>
 </div>
{if $images}
{if $pagination}
<ul class="pagination">
{if $pagination.previous}<li><a href="index.php?mode={$mode}{if $action}&amp;action={$action}{/if}{if $search_user_encoded}&amp;search_user={$search_user_encoded}{/if}{if $method && $method!='fulltext'}&amp;method={$method}{/if}{if $id}&amp;id={$id}{/if}{if $pagination.previous>1}&amp;page={$pagination.previous}{/if}{if $p_category && $p_category>0}&amp;p_category={$p_category}{/if}{if $order}&amp;order={$order}{/if}{if $descasc}&amp;descasc={$descasc}{/if}{if $filter}&amp;filter={$filter}{/if}" title="{#previous_page_link_title#}">{#previous_page_link#}</a></li>{/if}
{foreach from=$pagination.items item=item}
{if $item==0}<li>&hellip;</li>{elseif $item==$pagination.current}<li><span class="current">{$item}</span></li>{else}<li><a href="index.php?mode={$mode}{if $action}&amp;action={$action}{/if}{if $search_user_encoded}&amp;search_user={$search_user_encoded}{/if}{if $method && $method!='fulltext'}&amp;method={$method}{/if}{if $id}&amp;id={$id}{/if}&amp;page={$item}{if $p_category && $p_category>0}&amp;p_category={$p_category}{/if}{if $order}&amp;order={$order}{/if}{if $descasc}&amp;descasc={$descasc}{/if}{if $filter}&amp;filter={$filter}{/if}">{$item}</a></li>{/if}
{/foreach}
{if $pagination.next}<li><a href="index.php?mode={$mode}{if $action}&amp;action={$action}{/if}{if $search_user_encoded}&amp;search_user={$search_user_encoded}{/if}{if $method && $method!='fulltext'}&amp;method={$method}{/if}{if $id}&amp;id={$id}{/if}&amp;page={$pagination.next}{if $p_category && $p_category>0}&amp;p_category={$p_category}{/if}{if $order}&amp;order={$order}{/if}{if $descasc}&amp;descasc={$descasc}{/if}{if $filter}&amp;filter={$filter}{/if}" title="{#next_page_link_title#}">{#next_page_link#}</a></li>{/if}
</ul>
{/if}

<form action="index.php" method="post" accept-charset="{#charset#}">
<input type="hidden" name="mode" value="admin" />
<input type="hidden" name="csrf_token" value="{$CSRF_TOKEN}" />
{if $filter}
<input type="hidden" name="filter" value="{$filter}" />
{/if}
 <ul id="uploadlist">
{section name=nr loop=$images start=$start max=$images_per_page}
  <li>
   <p class="image_container"><img src="images/uploaded/{$images[nr].pathname}" alt="{$images[nr].pathname}" /></p>
   <ul class="management_container">
    <li class="information">{if $images[nr].status == 1}<img src="themes/{$settings.theme}/images/database.svg" alt="{#upload_database_entry_alt#}" width="16" height="16">{else}<img src="themes/{$settings.theme}/images/database-no.svg" alt="{#upload_database_no_entry_alt#}" width="16" height="16">{/if}</li>
    <li><input type="checkbox" id="id-{$images[nr].number}" name="manage_uploads[]" value="{$images[nr].pathname}" /><label for="id-{$images[nr].number}">{#mark_upload_for_managing#}</label></li>
   </ul>
  </li>
{/section}
 </ul>
 <div class="buttonbar">
  <button name="record_selected_uploads" value="record">{#upload_add_db_entry_button#}</button>
  <button name="delete_selected_uploads" value="{#delete#}">{#delete#}</button>
 </div>
</form>

{if $pagination}
<ul class="pagination">
{if $pagination.previous}<li><a href="index.php?mode={$mode}{if $action}&amp;action={$action}{/if}{if $search_user_encoded}&amp;search_user={$search_user_encoded}{/if}{if $method && $method!='fulltext'}&amp;method={$method}{/if}{if $id}&amp;id={$id}{/if}{if $pagination.previous>1}&amp;page={$pagination.previous}{/if}{if $p_category && $p_category>0}&amp;p_category={$p_category}{/if}{if $order}&amp;order={$order}{/if}{if $descasc}&amp;descasc={$descasc}{/if}{if $filter}&amp;filter={$filter}{/if}" title="{#previous_page_link_title#}">{#previous_page_link#}</a></li>{/if}
{foreach from=$pagination.items item=item}
{if $item==0}<li>&hellip;</li>{elseif $item==$pagination.current}<li><span class="current">{$item}</span></li>{else}<li><a href="index.php?mode={$mode}{if $action}&amp;action={$action}{/if}{if $search_user_encoded}&amp;search_user={$search_user_encoded}{/if}{if $method && $method!='fulltext'}&amp;method={$method}{/if}{if $id}&amp;id={$id}{/if}&amp;page={$item}{if $p_category && $p_category>0}&amp;p_category={$p_category}{/if}{if $order}&amp;order={$order}{/if}{if $descasc}&amp;descasc={$descasc}{/if}{if $filter}&amp;filter={$filter}{/if}">{$item}</a></li>{/if}
{/foreach}
{if $pagination.next}<li><a href="index.php?mode={$mode}{if $action}&amp;action={$action}{/if}{if $search_user_encoded}&amp;search_user={$search_user_encoded}{/if}{if $method && $method!='fulltext'}&amp;method={$method}{/if}{if $id}&amp;id={$id}{/if}&amp;page={$pagination.next}{if $p_category && $p_category>0}&amp;p_category={$p_category}{/if}{if $order}&amp;order={$order}{/if}{if $descasc}&amp;descasc={$descasc}{/if}{if $filter}&amp;filter={$filter}{/if}" title="{#next_page_link_title#}">{#next_page_link#}</a></li>{/if}
</ul>
{/if}
{else}
<p>{#no_uploads_found#}</p>
{/if}
{elseif $action=='delete_uploads'}
<h2 id="admin_header">{#upload_administration#}</h2>
<p class="notice caution">{#caution#}</p>
<p>{if $selected_uploads_count>1}{#delete_uploads_confirmation#}{else}{#delete_upload_confirmation#}{/if}</p>
<form action="index.php" method="post" accept-charset="{#charset#}">
<div>
 <input type="hidden" name="mode" value="admin" />
 <input type="hidden" name="csrf_token" value="{$CSRF_TOKEN}" />
 <ul class="confirm-selection">
{section name=nr loop=$selected_uploads}
  <li><input type="hidden" name="selected_confirmed[]" value="{$selected_uploads[nr].name}" />
   <p class="item"><img src="images/uploaded/{$selected_uploads[nr].name}" width="64" alt="" /></p><p class="info">{$selected_uploads[nr].name}</p></li>
{/section}
 </ul>
 <input type="submit" name="delete_uploads_confirmed" value="{#delete_submit#}" />
</div>
</form>
{else}
<div id="admin-main-menu">
<aside id="additional-admin-info">
{if $installed_version_MLF || $installed_version_PHP || $installed_type_db || $installed_version_db}
	<div id="admin-info-current-version" data-next-reload="{$next_possible_version_reload}">
		<h3>{#installed_versions_header#}</h3>
			<dl>
			{if $installed_version_MLF}
				<div>
					<dt>{#installed_version_mlf#}</dt>
					<dd>{$installed_version_MLF}</dd>
				</div>
			{/if}
			{if $installed_version_PHP}
				<div>
					<dt>{#installed_version_php#}</dt>
					<dd>{$installed_version_PHP}</dd>
				</div>
			{/if}
			{if $installed_type_db}
				<div>
					<dt>{#installed_database_type#}</dt>
					<dd>{$installed_type_db}</dd>
				</div>
			{/if}
			{if $installed_version_db}
				<div>
					<dt>{#installed_database_version#}</dt>
					<dd>{$installed_version_db}</dd>
				</div>
			{/if}
			</dl>
		<p id="renew-versioninfo">
			<a href="index.php?mode=admin&amp;action=versioninfo_renew&amp;csrf_token={$CSRF_TOKEN}">{#installed_versions_renew_info#}</a>
		</p>
	</div>
{/if}
	{if $install_script_exists}
	<div id="admin-info-install_script_exists">
		<h3><img src="{$THEMES_DIR}/{$theme}/images/general-caution.svg" alt="" width:"14" height="14" /><span>{#warning_header#}</span></h3>
		<p>{#warning_install_script_exists#}</p>
	</div>
	{/if}
	{if isset($latest_release_newer) && $latest_release_newer !== 0}
	<div id="admin-info-releases">
		<h3>{#releases_info_header#}</h3>
		{if $latest_release_newer === 1}
		<p><a href="{$latest_release_uri}">Download {$latest_release_version}</a></p>
		{else if $latest_release_newer === -1}
		<p><a href="https://github.com/My-Little-Forum/mylittleforum/releases/latest">{#releases_list_link#}</a></p>
		{/if}
	</div>
	{/if}
</aside>
<ul class="adminmenu">
<li><a href="index.php?mode=admin&amp;action=settings"><img src="{$THEMES_DIR}/{$theme}/images/settings.svg" alt="" width="18" height="18" class="icon" /><span>{#forum_settings_link#}</span></a></li>
<li><a href="index.php?mode=admin&amp;action=user"><img src="{$THEMES_DIR}/{$theme}/images/user.svg" alt="" width="18" height="18" class="icon" /><span>{#user_administr_link#}</span></a></li>
<li><a href="index.php?mode=admin&amp;action=categories"><img src="{$THEMES_DIR}/{$theme}/images/categories.svg" alt="" width="18" height="18" class="icon" /><span>{#category_administr_link#}</span></a></li>
<li><a href="index.php?mode=admin&amp;action=smilies"><img src="{$THEMES_DIR}/{$theme}/images/smilies.svg" alt="" width="18" height="18" class="icon" /><span>{#smilies_administr_link#}</span></a></li>
<li><a href="index.php?mode=admin&amp;action=list_uploads"><img src="{$THEMES_DIR}/{$theme}/images/images.svg" alt="" width="18" height="18" class="icon" /><span>{#upload_administr_link#}</span></a></li>
<li><a href="index.php?mode=admin&amp;action=pages"><img src="{$THEMES_DIR}/{$theme}/images/files.svg" alt="" width="18" height="18" class="icon" /><span>{#pages_administr_link#}</span></a></li>
<li><a href="index.php?mode=admin&amp;action=spam_protection"><img src="{$THEMES_DIR}/{$theme}/images/spam-shield.svg" alt="" width="18" height="18" class="icon" /><span>{#spam_protection_link#}</span></a></li>
<li><a href="index.php?mode=admin&amp;action=update"><img src="{$THEMES_DIR}/{$theme}/images/arrows-update.svg" alt="" width="18" height="18" class="icon" /><span>{#update_link#}</span></a></li>
<li><a href="index.php?mode=admin&amp;action=reset_uninstall"><img src="{$THEMES_DIR}/{$theme}/images/delete-cross.svg" alt="" width="18" height="18" class="icon" /><span>{#reset_uninstall_link#}</span></a></li>
</ul>
</div>
{/if}
