t``:
        whether we should raise an exception, or return a response,
        if status falls in ``status_forcelist`` range and retries have
        been exhausted.

    :param tuple history: The history of the request encountered during
        each call to :meth:`~Retry.increment`. The list is in the order
        the requests occurred. Each list item is of class :class:`RequestHistory`.

    :param bool respect_retry_after_header:
        Whether to respect Retry-After header on status codes defined as
        :attr:`Retry.RETRY_AFTER_STATUS_CODES` or not.

    :param iterable remove_headers_on_redirect:
        Sequence of headers to remove from the request when a response
        indicating a redirect is returned before firing off the redirected
        request.
    HEADGETPUTDELETEOPTIONSTRACEi  i  i  
Authorizationx   
   Nr   Tc             C   s   || _ || _|| _|| _|dks(|dkr0d}d}	|| _|p>t | _|| _|| _|	| _	|
| _
|pbt | _|| _
tdd |
D | _d S )NFr   c             S   s   g | ]}|  qS  )lower).0hr   r   /builddir/build/BUILDROOT/alt-python37-pip-20.2.4-6.el8.x86_64/opt/alt/python37/lib/python3.7/site-packages/pip/_vendor/urllib3/util/retry.py
<listcomp>   s    z"Retry.__init__.<locals>.<listcomp>)totalconnectreadr   redirectsetstatus_forcelistmethod_whitelistbackoff_factorraise_on_redirectraise_on_statustuplehistoryrespect_retry_after_header	frozensetremove_headers_on_redirect)selfr$   r%   r&   r'   r   r*   r)   r+   r,   r-   r/   r0   r2   r   r   r"   __init__   s"    zRetry.__init__c             K   sT   t | j| j| j| j| j| j| j| j| j	| j
| j| j| j
d
}|| t| f |S )N)
r$   r%   r&   r'   r   r*   r)   r+   r,   r-   r/   r2   r0   )dictr$   r%   r&   r'   r   r*   r)   r+   r,   r-   r/   r2   r0   updatetype)r3   kwparamsr   r   r"   new   s     

z	Retry.newc             C   sR   |dkr|dk	r|n| j }t|tr(|S t|o2d}| ||d}td|| |S )z4 Backwards-compatibility for the old retries format.N)r'   z!Converted retries value: %r -> %r)DEFAULT
isinstancer   boollogdebug)clsretriesr'   defaultnew_retriesr   r   r"   from_int   s    
zRetry.from_intc             C   sF   t ttdd t| j}|dkr(dS | jd|d   }t| j|S )zJ Formula for computing the current backoff

        :rtype: float
        c             S   s
   | j d kS )N)r   )xr   r   r"   <lambda>       z(Retry.get_backoff_time.<locals>.<lambda>   r   r   )lenlistr   reversedr/   r+   minBACKOFF_MAX)r3   consecutive_errors_len
backoff_valuer   r   r"   get_backoff_time   s    zRetry.get_backoff_timec             C   s\   t d|rt|}n6tj|}|d kr6td| t|}|t  }|dk rXd}|S )Nz^\s*[0-9]+\s*$zInvalid Retry-After header: %sr   )	rematchintemailutils	parsedater   timemktime)r3   retry_aftersecondsretry_date_tuple
retry_dater   r   r"   parse_retry_after   s    

zRetry.parse_retry_afterc             C   s    | d}|dkrdS | |S )z* Get the value of Retry-After in seconds. zRetry-AfterN)	getheaderr]   )r3   responserY   r   r   r"   get_retry_after
  s    
zRetry.get_retry_afterc             C   s    |  |}|rt| dS dS )NTF)r`   rW   sleep)r3   r_   rY   r   r   r"   sleep_for_retry  s
    

zRetry.sleep_for_retryc             C   s"   |   }|dkrd S t| d S )Nr   )rP   rW   ra   )r3   backoffr   r   r"   _sleep_backoff  s    zRetry._sleep_backoffc             C   s(   | j r|r| |}|rdS |   dS )aC   Sleep between retry attempts.

        This method will respect a server's ``Retry-After`` response header
        and sleep the duration of the time requested. If that is not present, it
        will use an exponential backoff. By default, the backoff factor is 0 and
        this method will return immediately.
        N)r0   rb   rd   )r3   r_   sleptr   r   r"   ra   "  s
    	

zRetry.sleepc             C   s   t |tr|j}t |tS )z{ Errors when we're fairly sure that the server did not receive the
        request, so it should be safe to retry.
        )r<   r   original_errorr   )r3   errr   r   r"   _is_connection_error2  s    
zRetry._is_connection_errorc             C   s   t |ttfS )z Errors that occur after the request has been started, so we should
        assume that the server began processing it.
        )r<   r	   r   )r3   rg   r   r   r"   _is_read_error:  s    zRetry._is_read_errorc             C   s   | j r| | j krdS dS )z| Checks if a given HTTP method should be retried upon, depending if
        it is included on the method whitelist.
        FT)r*   upper)r3   r   r   r   r"   _is_method_retryable@  s    zRetry._is_method_retryableFc             C   s<   |  |sdS | jr"|| jkr"dS | jo:| jo:|o:|| jkS )ax   Is this method/status code retryable? (Based on whitelists and control
        variables such as the number of total retries to allow, whether to
        respect the Retry-After header, whether this header is present, and
        whether the returned status code is on the list of status codes to
        be retried upon on the presence of the aforementioned header)
        FT)rk   r)   r$   r0   RETRY_AFTER_STATUS_CODES)r3   r   status_codehas_retry_afterr   r   r"   is_retryI  s    
zRetry.is_retryc             C   s:   | j | j| j| j| jf}ttd|}|s.dS t|dk S )z Are we out of retries? NFr   )r$   r%   r&   r'   r   rJ   filterrL   )r3   retry_countsr   r   r"   is_exhausted]  s
    zRetry.is_exhaustedc             C   s  | j dkr |r tt|||| j }|dk	r6|d8 }| j}| j}	| j}
| j}d}d}
d}|r| |r|dkrtt|||n|dk	r|d8 }n|r| 	|r|	dks| 
|stt|||n|	dk	r|	d8 }	np|r| r|
dk	r|
d8 }
d}| }|j}
n<tj
}|rL|jrL|dk	r6|d8 }tjj|jd}|j}
| jt||||
|f }| j|||	|
||d}| rt|||pt|td|| |S )	a   Return a new Retry object with incremented retry counters.

        :param response: A response object, or None, if the server did not
            return a response.
        :type response: :class:`~urllib3.response.HTTPResponse`
        :param Exception e