ZddgZedk	r&edg7 Zdddd	d
gZdNddZdd Zdd Z	dd Z
edd Zedd Z
dd Zdd Zdd  Zd!d" ZeejfZedk	reejf7 Zd#d$ Zd%d& Zed'd( ZdOd)d*ZdPd,d-Zed.d/ Zd0d1 ZdQd2d3Zd4d5 Z d6d7 Z!ed8d9 Z"d:d; Z#d<d= Z$d>d? Z%d@dA Z&dBdC Z'dDdE Z(dFdG Z)dRdHdIZ*dJdK Z+dLdM Z,dS )SHTTPResponsea  
    HTTP Response container.

    Backwards-compatible to httplib's HTTPResponse but the response ``body`` is
    loaded and decoded on-demand when the ``data`` property is accessed.  This
    class is also compatible with the Python standard library's :mod:`io`
    module, and can hence be treated as a readable object in the context of that
    framework.

    Extra parameters for behaviour not present in httplib.HTTPResponse:

    :param preload_content:
        If True, the response's body will be preloaded during construction.

    :param decode_content:
        If True, will attempt to decode the body based on the
        'content-encoding' header.

    :param original_response:
        When this HTTPResponse wrapper is generated from an httplib.HTTPResponse
        object, it's convenient to include the original for debug purposes. It's
        otherwise unused.

    :param retries:
        The retries contains the last :class:`~urllib3.util.retry.Retry` that
        was used during the request.

    :param enforce_content_length:
        Enforce content length checking. Body returned by server must match
        value of Content-Length header, if present. Otherwise, raise error.
    rK   deflateNrL   i-  i.  i/  i3  i4   r   TFc             C   s  t |tr|| _n
t|| _|| _|| _|| _|| _|| _|
| _|| _	|| _
d | _d | _d | _
|	| _d| _|| _|| _|rt |ttfr|| _|
| _|| _t|dr|| _
d| _d | _| jdd }dd |dD }d	|krd
| _| || _|r| js| j|d| _d S )Nr   readFztransfer-encodingrP   c             s   s   | ]}|  V  qd S )N)r@   )rA   encr   r   r    	<genexpr>   s    z(HTTPResponse.__init__.<locals>.<genexpr>rD   chunkedT)decode_content)
isinstancer   headersstatusversionreasonstrictrU   retriesenforce_content_length
auto_close_decoder_body_fp_original_response_fp_bytes_readmsg_request_url
basestringr5   _pool_connectionr;   rT   
chunk_leftgetlowerrE   _init_lengthlength_remainingrQ   )r   bodyrW   rX   rY   rZ   r[   preload_contentrU   original_responsepool
connectionrd   r\   r]   request_methodrequest_urlr^   tr_enc	encodingsr   r   r    r!      sB    


zHTTPResponse.__init__c             C   s   | j | jkr| jdS dS )a  
        Should we redirect and where to?

        :returns: Truthy redirect location string if we got a redirect status
            code and valid location. ``None`` if redirect status and no
            location. ``False`` if not a redirect status code.
        locationF)rX   REDIRECT_STATUSESrW   rj   )r   r   r   r    get_redirect_location  s    z"HTTPResponse.get_redirect_locationc             C   s(   | j r| jsd S | j | j d | _d S )N)rg   rh   	_put_conn)r   r   r   r    release_conn  s    zHTTPResponse.release_connc             C   s.   y|    W n ttttfk
r(   Y nX dS )z
        Read and discard any remaining HTTP response data in the response connection.

        Unread data in the HTTPResponse connection blocks the connection from being released back to the pool.
        N)rQ   r   SocketErrorr   r   )r   r   r   r    
drain_conn  s    zHTTPResponse.drain_connc             C   s"   | j r| j S | jr| jddS d S )NT)
cache_content)r`   ra   rQ   )r   r   r   r    r'   $  s    zHTTPResponse.datac             C   s   | j S )N)rh   )r   r   r   r    rr   -  s    zHTTPResponse.connectionc             C   s
   t | jS )N)r   ra   )r   r   r   r    isclosed1  s    zHTTPResponse.isclosedc             C   s   | j S )z
        Obtain the number of bytes pulled over the wire so far. May differ from
        the amount of content returned by :meth:``HTTPResponse.read`` if bytes
        are encoded on the wire (e.g, compressed).
        )rc   )r   r   r   r    tell4  s    zHTTPResponse.tellc             C   s   | j d}|dk	r| jr(td dS y<tdd |dD }t|dkrZtd| |	 }W n t
k
r|   d}Y nX |d	k rd}yt| j}W n t
k
r   d	}Y nX |d
ksd|  krdk sn |d
krd	}|S )zM
        Set initial length value for Response content if available.
        zcontent-lengthNzReceived response with both Content-Length and Transfer-Encoding set. This is expressly forbidden by RFC 7230 sec 3.3.2. Ignoring Content-Length and attempting to process response as Transfer-Encoding: chunked.c             S   s   g | ]}t |qS r   )int)rA   valr   r   r    rC   V  s    z-HTTPResponse._init_length.<locals>.<listcomp>rD   r   z8Content-Length contained multiple unmatching values (%s)r   )   i0  d      HEAD)
rW   rj   rT   logwarningsetrE   lenr   pop
ValueErrorr   rX   )r   rs   lengthlengthsrX   r   r   r    rl   <  s0    

&zHTTPResponse._init_lengthc                sh    j dd } jdkrd| jkr2t| _n2d|krd fdd|dD }t|rdt| _dS )z=
        Set-up the _decoder attribute if necessary.
        zcontent-encodingrP   NrD   c                s"   g | ]}|   jkr|  qS r   )r@   CONTENT_DECODERS)rA   e)r   r   r    rC   |  s   z.HTTPResponse._init_decoder.<locals>.<listcomp>)rW   rj   rk