S )zk
        Flushes the decoder. Should only be called if the decoder is actually
        being used.
        r   )r_   r%   r=   )r   bufr   r   r    r     s    zHTTPResponse._flush_decoderc          
   c   s   d}zy
dV  W n t k
r2   t| jddY np tk
rn } z dt|krP t| jddW dd}~X Y n4 ttfk
r } ztd| |W dd}~X Y nX d}W d|s| jr| j	  | j
r| j
	  | jr| j r|   X dS )z
        Catch low-level python exceptions, instead re-raising urllib3
        variants, so that low-level exceptions are not leaked in the
        high-level api.

        On exit, release the connection back to the pool.
        FNzRead timed out.zread operation timed outzConnection broken: %rT)

SocketTimeoutr   rg   r   strr   r|   r	   rb   closerh   r   r{   )r   
clean_exitr   r   r   r    _error_catcher  s(    	
 

zHTTPResponse._error_catcherc          	   C   s  |    |dkr| j}| jdkr$dS d}t| jdd}|  v |dkr`|sV| j nd}d}nPd}|st| j|nd}|dkr|s| j  d}| jr| jdkrt	| j
| jW dQ R X |r|  j
t|7  _
| jdk	r|  jt|8  _| |||}|r|| _
|S )aP  
        Similar to :meth:`httplib.HTTPResponse.read`, but with two additional
        parameters: ``decode_content`` and ``cache_content``.

        :param amt:
            How much of the content to read. If specified, caching is skipped
            because it doesn't make sense to cache partial content as the full
            response.

        :param decode_content:
            If True, will attempt to decode the body based on the
            'content-encoding' header.

        :param cache_content:
            If True, will save the returned data such that the same result is
            returned despite of the state of the underlying file object. This
            is useful if you want the ``.data`` property to continue working
            after having ``.read()`` the file object. (Overridden if ``amt`` is
            set.)
        NFclosedr   Tr   )r   N)r   rU   ra   r"   r   rQ   r   r]   rm   r
   rc   r   r   r`   )r   amtrU   r~   r   	fp_closedr'   r   r   r    rQ     s6    

	


zHTTPResponse.read   c             c   sZ   | j r.|  r.xF| j||dD ]
}|V  qW n(x&t| jsT| j||d}|r0|V  q0W dS )a_  
        A generator wrapper for the read() method. A call will block until
        ``amt`` bytes have been read from the connection or until the
        connection is closed.

        :param amt:
            How much of the content to read. The generator will return up to
            much data per iteration, but may return less. This is particularly
            likely when using compressed data. However, the empty string will
            never be returned.

        :param decode_content:
            If True, will attempt to decode the body based on the
            'content-encoding' header.
        )rU   )r   rU   N)rT   supports_chunked_readsread_chunkedr   ra   rQ   )r   r   rU   liner'   r   r   r    stream+  s    zHTTPResponse.streamc          
   K   s`   |j }t|ts,tr"t| }n
t|}t|dd}| f |||j|j|j	||d|}|S )a  
        Given an :class:`httplib.HTTPResponse` instance ``r``, return a
        corresponding :class:`urllib3.response.HTTPResponse` object.

        Remaining parameters are passed to the HTTPResponse constructor, along
        with ``original_response=r``.
        r[   r   )rn   rW   rX   rY   rZ   r[   rp   )
rd   rV   r   r   itemsfrom_httplibr"   rX   rY   rZ   )ResponseClsrresponse_k