 )a"   Get the value to use when setting a connection timeout.

        This will be a positive float or integer, the value None
        (never timeout), or the default system timeout.

        :return: Connect timeout.
        :rtype: int, float, :attr:`Timeout.DEFAULT_TIMEOUT` or None
        N)r
   r   r   min)r   r   r   r   connect_timeout   s
    

zTimeout.connect_timeoutc             C   s   | j dk	rX| j | jk	rX| jdk	rX| j| jk	rX| jdkr<| jS tdt| j |   | jS | j dk	r| j | jk	rtd| j |   S | jS dS )a   Get the value for the read timeout.

        This assumes some time has elapsed in the connection timeout and
        computes the read timeout appropriately.

        If self.total is set, the read timeout is dependent on the amount of
        time taken by the connect timeout. If the connection time has not been
        established, a :exc:`~urllib3.exceptions.TimeoutStateError` will be
        raised.

        :return: Value to use for the read timeout.
        :rtype: int, float, :attr:`Timeout.DEFAULT_TIMEOUT` or None
        :raises urllib3.exceptions.TimeoutStateError: If :meth:`start_connect`
            has not yet been called on this object.
        Nr   )r
   r   r
   r   maxr&   r%   )r   r   r   r   read_timeout   s    


zTimeout.read_timeout)r   
__module____qualname____doc__r   r   r   r   r   __str__classmethodr   r!   r"   r$   r%   propertyr'   r)   r   r   r   r   r      s   G	.r   )
__future__r   socketr   time
exceptionsr   objectr   getattrr#   r   r   r   r   r   <module>   s                                                                                                                                                                                                                                                                                                                                                    python3.7/site-packages/pip/_vendor/urllib3/util/__pycache__/retry.cpython-37.pyc                   0000644                 00000031271 15107360303 0023620 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    Re<                 @   s   d dl mZ d dlZd dlZd dlmZ d dlmZ d dlZd dl	Z	ddl
mZmZm
Z
mZmZmZmZ ddlmZ eeZedd	d
ddd
gZG dd deZede_dS )    )absolute_importN)
namedtuple)	takewhile   )ConnectTimeoutError
MaxRetryError
ProtocolErrorReadTimeoutError
ResponseError
InvalidHeader
ProxyError)sixRequestHistorymethodurlerrorstatusredirect_locationc            
   @   s   e Zd ZdZeddddddgZedd	d
gZedgZdZd
ddddeddddddef
ddZ	dd Z
ed2ddZdd Z
dd Zdd Zd3ddZdd  Zd4d!d"Zd#d$ Zd%d& Zd'd( Zd5d*d+Zd,d- Zd6d.d/Zd0d1 ZdS )7Retrya3   Retry configuration.

    Each retry attempt will create a new Retry object with updated values, so
    they can be safely reused.

    Retries can be defined as a default for a pool::

        retries = Retry(connect=5, read=2, redirect=5)
        http = PoolManager(retries=retries)
        response = http.request('GET', 'http://example.com/')

    Or per-request (which overrides the default for the pool)::

        response = http.request('GET', 'http://example.com/', retries=Retry(10))

    Retries can be disabled by passing ``False``::

        response = http.request('GET', 'http://example.com/', retries=False)

    Errors will be wrapped in :class:`~urllib3.exceptions.MaxRetryError` unless
    retries are disabled, in which case the causing exception will be raised.

    :param int total:
        Total number of retries to allow. Takes precedence over other counts.

        Set to ``None`` to remove this constraint and fall back on other
        counts. It's a good idea to set this to some sensibly-high value to
        account for unexpected edge cases and avoid infinite retry loops.

        Set to ``0`` to fail on the first retry.

        Set to ``False`` to disable and imply ``raise_on_redirect=False``.

    :param int connect:
        How many connection-related errors to retry on.

        These are errors raised before the request is sent to the remote server,
        which we assume has not triggered the server to process the request.

        Set to ``0`` to fail on the first retry of this type.

    :param int read:
        How many times to retry on read errors.

        These errors are raised after the request was sent to the server, so the
        request may have side-effects.

        Set to ``0`` to fail on the first retry of this type.

    :param int redirect:
        How many redirects to perform. Limit this to avoid infinite redirect
        loops.

        A redirect is a HTTP response with a status code 301, 302, 303, 307 or
        308.

        Set to ``0`` to fail on the first retry of this type.

        Set to ``False`` to disable and imply ``raise_on_redirect=False``.

    :param int status:
        How many times to retry on bad status codes.

        These are retries made on responses, where status code matches
        ``status_forcelist``.

        Set to ``0`` to fail on the first retry of this type.

    :param iterable method_whitelist:
        Set of uppercased HTTP method verbs that we should retry on.

        By default, we only retry on methods which are considered to be
        idempotent (multiple requests with the same parameters end with the
        same state). See :attr:`Retry.DEFAULT_METHOD_WHITELIST`.

        Set to a ``False`` value to retry on any verb.

    :param iterable status_forcelist:
        A set of integer HTTP status codes that we should force a retry on.
        A retry is initiated if the request method is in ``method_whitelist``
        and the response status code is in ``status_forcelist``.

        By default, this is disabled with ``None``.

    :param float backoff_factor:
        A backoff factor to apply between atte