  case-insensitively in order to maintain ``dict``'s api. For fields that
    compare equal, instead create a new ``HTTPHeaderDict`` and use ``.add``
    in a loop.

    If multiple fields that are equal case-insensitively are passed to the
    constructor or ``.update``, the behavior is undefined and some will be
    lost.

    >>> headers = HTTPHeaderDict()
    >>> headers.add('Set-Cookie', 'foo=bar')
    >>> headers.add('set-cookie', 'baz=quxx')
    >>> headers['content-length'] = '7'
    >>> headers['SET-cookie']
    'foo=bar, baz=quxx'
    >>> headers['Content-Length']
    '7'
    Nc                sP   t t|   t | _|d k	r>t|tr4| | n
| | |rL| | d S )N)superr   r    r   r   
isinstance
_copy_fromextend)r   headerskwargs)	__class__r   r   r       s    

zHTTPHeaderDict.__init__c             C   s    ||g| j | < | j |  S )N)r   lower)r   r"   valr   r   r   r-      s    zHTTPHeaderDict.__setitem__c             C   s    | j |  }d|dd  S )Nz, r   )r   r>   join)r   r"   r?   r   r   r   r$      s    zHTTPHeaderDict.__getitem__c             C   s   | j | = d S )N)r   r>   )r   r"   r   r   r   r.      s    zHTTPHeaderDict.__delitem__c             C   s   |  | jkS )N)r>   r   )r   r"   r   r   r   __contains__   s    zHTTPHeaderDict.__contains__c             C   s^   t |tst|dsdS t |t| s2t| |}tdd |  D tdd | D kS )Nr5   Fc             s   s   | ]\}}|  |fV  qd S )N)r>   ).0kvr   r   r   	<genexpr>   s    z(HTTPHeaderDict.__eq__.<locals>.<genexpr>c             s   s   | ]\}}|  |fV  qd S )N)r>   )rB   rC   rD   r   r   r   rE      s    )r8   r   hasattrtypedict
itermerged)r   otherr   r   r   __eq__   s    zHTTPHeaderDict.__eq__c             C   s   |  | S )N)rK   )r   rJ   r   r   r   __ne__   s    zHTTPHeaderDict.__ne__c             C   s
   t | jS )N)r(   r   )r   r   r   r   r/      s    zHTTPHeaderDict.__len__c             c   s"   x| j  D ]}|d V  qW d S )Nr   )r   r4   )r   valsr   r   r   r1      s    zHTTPHeaderDict.__iter__c             C   s<   y| | }W n  t k
r,   || jkr( |S X | |= |S dS )zD.pop(k[,d]) -> v, remove specified key and return the corresponding value.
          If key is not found, d is returned if given, otherwise KeyError is raised.
        N)KeyError_HTTPHeaderDict__marker)r   r"   defaultr*   r   r   r   r!      s    
zHTTPHeaderDict.popc             C   s$   y
| |= W n t k
r   Y nX d S )N)rN   )r   r"   r   r   r   discard   s    
zHTTPHeaderDict.discardc             C   s4   |  }||g}| j||}||k	r0|| dS )zAdds a (name, value) pair, doesn't overwrite the value if it already
        exists.

        >>> headers = HTTPHeaderDict(foo='bar')
        >>> headers.add('Foo', 'baz')
        >>> headers['foo']
        'bar, baz'
        N)r>   r   
setdefaultappend)r   r"   r?   	key_lowernew_valsrM   r   r   r   add   s
    	zHTTPHeaderDict.addc             O   s   t |dkrtdt |t |dkr2|d nd}t|trdx| D ]\}}| || qJW nvt|trxj|D ]}| |||  qtW nLt|drx@|	 D ]}| |||  qW nx|D ]\}}| || qW x |
 D ]\}}| || qW dS )zGeneric import function for any type of header-like object.
        Adapted version of MutableMapping.update in order to insert items
        with self.add instead of self.__setitem__
        r   z9extend() takes at most 1 positional arguments ({0} given)r   r   r5   N)r(   	TypeErrorformatr8   r   	iteritemsrV   r   rF   r5   items)r   argsr<   rJ   r"   r?   r*   r   r   r   r:      s$    



zHTTPHeaderDict.extendc             C   sF   y| j |  }W n" tk
r4   || jkr0g S |S X |dd S dS )zmReturns a list of all the values for the named field. Returns an
        empty list if the key doesn't exist.r   N)r   r>   rN   rO   )r   r"   rP   rM   r   r   r   getlist  s    
zHTTPHeaderDict.getlistc             C   s   dt | jt|  f S )Nz%s(%s))rG   r   rH   rI   )r   r   r   r   __repr__  s    zHTTPHeaderDict.__repr__c             C   sB   x<|D ]4}| |}t|tr&t|}|g| | j| < qW d S )N)r\   r8   r2   r   r>   )r   rJ   r"   r?   r   r   r   r9     s
    


zHTTPHeaderDict._copy_fromc             C   s   t |  }||  |S )N)rG   r9   )r   cloner   r   r   copy!  s    

zHTTPHeaderDict.copyc             c   sD   x>| D ]6}| j |  }x"|dd D ]}|d |fV  q&W qW dS )z8Iterate over all header lines, including duplicate ones.r   Nr   )r   r>   )r   r"   rM   r?   r   r   r   rY   &  s    
zHTTPHeaderDict.iteritemsc             c   s<   x6| D ].}| j |  }|d d|dd fV  qW dS )z:Iterate over all headers, merging duplicate ones together.r   z, r   N)r   r>   r@   )r   r"   r?   r   r   r   rI   -  s    
zHTTPHeaderDict.itermergedc             C   s   t |  S )N)r2   rY   )r   r   r   r   rZ   3  s    zHTTPHeaderDict.itemsc             C   s   d}g }xr|j D ]h}||rV|s0td| n&|d \}}||d |  f|d< q|dd\}}||| f qW | |S )z4Read headers from a Python 2 httplib message object.) 	z/Header continuation with no previous header: %sr`   :r   )r;   
startswithr   stripsplitrS   )clsmessageobs_fold_continued_leadersr;   liner"   r*   r   r   r   from_httplib6  s    
zHTTPHeaderDict.from_httplib)N)%r   r   r   r6   r    r-   r$   r.   rA   rK   rL   r   r   r   r   objectrO   r/   r1   r!   rQ   rV   r:   r\   
getheadersgetallmatchingheadersigetget_allr]   r9   r_   rY   rI   rZ   classmethodrk   
__classcell__r   r   )r=   r   r   j   s<    	
N)
__future__r   collections.abcr   r   ImportErrorcollections	threadingr   r   
exceptionsr   Zpackages.sixr   r   r   __all__rl   r&   r   r   r   r   r   r   <module>   s   L                                  python3.7/site-packages/pip/_vendor/urllib3/fields.py                                               0000644                 00000020551 15107360303 0016456 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       from __future__ import absolute_import
import email.utils
import mimetypes
import re

from .packages import six


def guess_content_type(filename, default="application/octet-stream"):
    """
    Guess the "Content-Type" of a file.

    :param filename:
        The filename to guess the "Content-Type" of using :mod:`mimetypes`.
    :param default:
        If no "Content-Type" can be guessed, default to `default`.
    """
    if filename:
        return mimetypes.guess_type(filename)[0] or default
    return default


def format_header_param_rfc2231(name, value):
    """
    Helper function to format and quote a single header parameter using the
    strategy defined in RFC 2231.

    Particularly useful for header parameters which might contain
    non-ASCII values, like file names. This follows RFC 2388 Section 4.4.

    :param name:
        The name of the parameter, a string expected to be ASCII only.
    :param value:
        The value of the parameter, provided as ``bytes`` or `str``.
    :ret:
        An RFC-2231-formatted unicode string.
    """
    if isinstance(value, six.binary_type):
        value = value.decode("utf-8")

    if not any(ch in value for ch in '"\\\r\n'):
        result = u'%s="%s"' % (name, value)
        try:
            resu