 r   r   r   r   r   r   r   )r0   r]   r1   r1   r2   
_prepare_conn  s    

z!HTTPSConnectionPool._prepare_connc             C   s    | | j| j| j |  dS )z
        Establish tunnel connection early, because otherwise httplib
        would improperly set Host: header to proxy's IP:port.
        N)
set_tunnelr.   r/   rL   connect)r0   r]   r1   r1   r2   ri     s    z"HTTPSConnectionPool._prepare_proxyc          
   C   s   |  j d7  _ td| j | j| jp$d | jr8| jtkr@td| j}| j}| jdk	rf| jj}| jj}| jf ||| j	j
| j| j| j
| jd| j}| |S )zB
        Return a fresh :class:`httplib.HTTPSConnection`.
        r   z)Starting new HTTPS connection (%d): %s:%s443zCCan't connect to HTTPS URL because the SSL module is not available.N)r,   r/   r   rD   r   r   r   )rO   rY   rZ   r,   r/   r[   r   r   rK   r   r\   rD   r   r   r   rQ   r   )r0   actual_hostactual_portr]   r1   r1   r2   r^     s0    

zHTTPSConnectionPool._new_connc                s@   t t| | t|dds$|  |js<td|j t	 dS )zU
        Called right before a request is made, after the socket is created.
        rv   NzUnverified HTTPS request is being made to host '%s'. Adding certificate verification is strongly advised. See: https://urllib3.readthedocs.io/en/latest/advanced-usage.html#ssl-warnings)
superr   rh   rc   r   is_verifiedwarningswarnr,   r   )r0   r]   )	__class__r1   r2   rh     s    z"HTTPSConnectionPool._validate_conn)r5   r=   r>   r?   r+   r   r[   r#   r~   r3   r   ri   r^   rh   
__classcell__r1   r1   )r   r2   r   B  s2   $r   c             K   sR   t | \}}}|pt|d}|dkr:t|fd|i|S t|fd|i|S dS )a  
    Given a url, return an :class:`.ConnectionPool` instance of its host.

    This is a shortcut for not having to parse out the scheme, host, and port
    of the url before creating an :class:`.ConnectionPool` instance.

    :param url:
        Absolute URL string that must include the scheme. Port is optional.

    :param \**kw:
        Passes additional parameters to the constructor of the appropriate
        :class:`.ConnectionPool`. Useful for specifying things like
        timeout, maxsize, headers, etc.

    Example::

        >>> conn = connection_from_url('http://google.com/')
        >>> r = conn.request('GET', '/')
    P   r   r/   N)r$   r   r`   r   rA   )rs   kwr+   r,   r/   r1   r1   r2   connection_from_url  s
    r   c             C   s.   t | |} | dr*| dr*| dd } | S )z?
    Normalize hosts for comparisons and use with sockets.
    []r   )normalize_hostr   endswith)r,   r+   r1   r1   r2   r'     s    
r'   )L
__future__r   rm   loggingr   r   r   r   r   r   rn   
exceptionsr   r   r   r	   r
   r   r   r
   r   r   r   r   r   Zpackages.ssl_match_hostnamer   packagesr   Zpackages.six.movesr   r   r   r   r   r   r   r   r   r|   r   r   r   Zutil.connectionr   Zutil.requestr    Z
util.responser!   Z
util.retryr"   Zutil.timeoutr#   Zutil.urlr$   r%   r&   r'   r   r(   Z
util.queuer)   movesrM   	getLoggerr5   rY   objectrj   r*   EAGAINEWOULDBLOCKrp   rA   r   r   r1   r1   r1   r2   <module>   sF   <$	
)     [                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        python3.7/site-packages/pip/_vendor/urllib3/__pycache__/fields.cpython-37.pyc                       0000644                 00000017701 15107360303 0022746 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    Rei!                 @   s   d dl mZ d dlZd dlZd dlZddlmZ dddZdd	 Z	d
dddZ
e
d
d ed dD  dd Z
dd ZeZG dd deZdS )    )absolute_importN   )sixapplication/octet-streamc             C   s   | rt | d p|S |S )z
    Guess the "Content-Type" of a file.

    :param filename:
        The filename to guess the "Content-Type" of using :mod:`mimetypes`.
    :param default:
        If no "Content-Type" can be guessed, default to `default`.
    r   )	mimetypes
guess_type)filenamedefault r
   /builddir/build/BUILDROOT/alt-python37-pip-20.2.4-6.el8.x86_64/opt/alt/python37/lib/python3.7/site-packages/pip/_vendor/urllib3/fields.pyguess_content_type	   s    	r   c          	      s   t  tjr d t fdddD sdd|  f }y|d W n ttfk
r^   Y nX |S tjrt d t	j
 d d|  f  tjr d  S )a  
    Helper function to format and quote a single header parameter using the
    strategy defined in RFC 2231.

    Particularly useful for header parameters which might contain
    non-ASCII values, like file names. This follows RFC 2388 Section 4.4.

    :param name:
        The name of the parameter, a string expected to be ASCII only.
    :param value:
        The value of the parameter, provided as ``bytes`` or `str``.
    :ret:
        An RFC-2231-formatted unicode string.
    zutf-8c             3   s   | ]}| kV  qd S )Nr
   ).0ch)valuer
   r   	<genexpr>)   s    z.format_header_param_rfc2231.<locals>.<genexpr>z"\
z%s="%s"asciiz%s*=%s)
isinstancer   binary_typedecodeanyencodeUnicodeEncodeErrorUnicodeDecodeErrorPY2emailutilsencode_rfc2231)namer   resultr
   )r   r   format_header_param_rfc2231   s     


r   z%22z\\)"\r!   c             C   s&   i | ]}|d krd |t|qS ))   z%{:02X})formatr   unichr)r
   ccr
   r
   r   
<dictcomp>I   s   r&       c                s:    fdd}t ddd   D }||| }|S )Nc                s    |  d S )Nr   )group)match)needles_and_replacementsr
   r   replacerR   s    z#_replace_multiple.<locals>.replacer|c             S   s   g | ]}t |qS r
   )reescape)r
   needler
   r
   r   
<listcomp>V   s    z%_replace_multiple.<locals>.<listcomp>)r-   compilejoinkeyssub)r   r*   r+   patternr   r
   )r*   r   _replace_multipleQ   s
    r6   c             C   s,   t |tjr|d}t|t}d| |f S )a  
    Helper function to format and quote a single header parameter using the
    HTML5 strategy.

    Particularly useful for header parameters which might contain
    non-ASCII values, like file names. This follows the `HTML5 Working Draft
    Section 4.10.22.7`_ and matches the behavior of curl and modern browsers.

    .. _HTML5 Working Draft Section 4.10.22.7:
        https://w3c.github.io/html/sec-forms.html#multipart-form-data

    :param name:
        The name of the parameter, a string expected to be ASCII only.
    :param value:
        The value of the parameter, provided as ``bytes`` or `str``.
    :ret:
        A unicode string, stripped of troublesome characters.
    zutf-8z%s="%s")r   r   r   r   r6   _HTML5_REPLACEMENTS)r   r   r
   r
   r   format_header_param_html5^   s    

r8   c               @   sR   e Zd ZdZddefddZeefddZdd Zd	d
 Z	dd Z
dd
dZdS )RequestFielda  
    A data container for request body parameters.

    :param name:
        The name of this request field. Must be unicode.
    :param data:
        The data/value body.
    :param filename:
        An optional filename of the request field. Must be unicode.
    :param headers:
        An optional dict-like object of headers to initially use for the field.
    :param header_formatter:
        An optional callable that is used to encode and format the headers. By
        default, this is :func:`format_header_param_html5`.
    Nc             C   s0   || _ || _|| _i | _|r&t|| _|| _d S )N)_name	_filenamedataheadersdictheader_formatter)selfr   r<   r   r=   r?   r
   r
   r   __init__   s    
zRequestField.__init__c             C   s`   t |tr4t|dkr"|\}}}q@|\}}t|}nd}d}|}| ||||d}|j|d |S )a  
        A :class:`~urllib3.fields.RequestField` factory from old-style tuple parameters.

        Supports constructing :class:`~urllib3.fields.RequestField` from
        parameter of key/value strings AND key/filetuple. A filetuple is a
        (filename, data, MIME type) tuple where the MIME type is optional.
        For example::

            'foo': 'bar',
            'fakefile': ('foofile.txt', 'contents of foofile'),
            'realfile': ('barfile.txt', open('realfile').read()),
            'typedfile': ('bazfile.bin', open('bazfile').read(), 'image/jpeg'),
            'nonamefile': 'contents of nonamefile field',

        Field names and filenames must be unicode.
           N)r   r?   )content_type)r   tuplelenr   make_multipart)cls	fieldnamer   r?   r   r<   rC   
request_paramr
   r
   r   from_tuples   s    

zRequestField.from_tuplesc             C   s   |  ||S )aI  
        Overridable helper function to format a single header parameter. By
        default, this calls ``self.header_formatter``.

        :param name:
            The name of the parameter, a string expected to be ASCII only.
        :param value:
            The value of the parameter, provided as a unicode string.
        )r?   )r@   r   r   r
   r
   r   _render_part   s    zRequestField._render_partc             C   sP   g }|}t |tr| }x*|D ]"\}}|dk	r || || q W d|S )aO  
        Helper function to format and quote a single header.

        Useful for single headers that are composed of multiple items. E.g.,
        'Content-Disposition' fields.

        :param header_parts:
            A sequence of (k, v) tuples or a :class:`dict` of (k, v) to format
            as `k1="v1"; k2="v2"; ...`.
        Nz; )r   r>   itemsappendrK   r2   )r@   header_partspartsiterabler   r   r
   r
   r   
_render_parts   s    
zRequestField._render_partsc             C   s   g }dddg}x2|D ]*}| j |dr|d|| j | f  qW x4| j  D ]&\}}||krN|rN|d||f  qNW |d d|S )z=
        Renders the headers for this request field.
        zContent-DispositionzContent-TypezContent-LocationFz%s: %sz
)r=   getrM   rL   r2   )r@   lines	sort_keyssort_keyheader_nameheader_valuer
   r
   r   render_headers   s    


zRequestField.render_headersc             C   sX   |pd| j d< | j d  dd| d| jfd| jffg7  < || j d< || j d< d	S )
a|  
        Makes this request field into a multipart request field.

        This method overrides "Con