timeout   )six)HTTPConnection)
HTTPExceptionc               @   s   e Zd ZdS )BaseSSLErrorN)__name__
__module____qualname__ r
   r
   /builddir/build/BUILDROOT/alt-python37-pip-20.2.4-6.el8.x86_64/opt/alt/python37/lib/python3.7/site-packages/pip/_vendor/urllib3/connection.pyr	      s   r	   c               @   s   e Zd ZdS )ConnectionErrorN)r
   r   r   r
   r
   r
   r   r      s   r   )NewConnectionErrorConnectTimeoutErrorSubjectAltNameWarningSystemTimeWarning)match_hostnameCertificateError)resolve_cert_reqsresolve_ssl_versionassert_fingerprintcreate_urllib3_contextssl_wrap_socket)
connection)HTTPHeaderDictP   i  )httphttpsi  z[^-!#$%&'*+.^_`|~0-9a-zA-Z]c               @   s   e Zd ZdZdS )DummyConnectionz-Used to detect a failed ConnectionCls import.N)r
   r   r   __doc__r
   r
   r
   r   r    A   s   r    c               @   sx   e Zd ZdZed ZejejdfgZ	dZ
dd Zedd Z
e
jd	d Z
d
d Zdd
 Zdd Zdd ZdddZdS )r   a$  
    Based on httplib.HTTPConnection but provides an extra constructor
    backwards-compatibility layer between older and newer Pythons.

    Additional keyword parameters are used to configure attributes of the connection.
    Accepted parameters include:

      - ``strict``: See the documentation on :class:`urllib3.connectionpool.HTTPConnectionPool`
      - ``source_address``: Set the source address for the current connection.
      - ``socket_options``: Set specific options on the underlying socket. If not specified, then
        defaults are loaded from ``HTTPConnection.default_socket_options`` which includes disabling
        Nagle's algorithm (sets TCP_NODELAY to 1) unless the connection is behind a proxy.

        For example, if you wish to enable TCP Keep Alive in addition to the defaults,
        you might pass::

            HTTPConnection.default_socket_options + [
                (socket.SOL_SOCKET, socket.SO_KEEPALIVE, 1),
            ]

        Or you may want to disable the defaults by passing an empty list (e.g., ``[]``).
    r   r   Fc             O   sD   t js|dd  |d| _|d| j| _tj| f|| d S )Nstrictsource_addresssocket_options)	r   PY2popgetr#   default_socket_optionsr$   _HTTPConnection__init__)selfargskwr
   r
   r   r*   h   s
    zHTTPConnection.__init__c             C   s   | j dS )a  
        Getter method to remove any trailing dots that indicate the hostname is an FQDN.

        In general, SSL certificates don't include the trailing dot indicating a
        fully-qualified domain name, and thus, they don't validate properly when
        checked against a domain name that includes the dot. In addition, some
        servers may not expect to receive the trailing dot when provided.

        However, the hostname with trailing dot is critical to DNS resolution; doing a
        lookup with the trailing dot will properly only resolve the appropriate FQDN,
        whereas a lookup without a trailing dot will search the system's search domain
        list. Thus, it's important to keep the original host around for use only in
        those cases where it's appropriate (i.e., when doing DNS lookup to establish the
        actual TCP connection across which we're going to send HTTP requests).
        .)	_dns_hostrstrip)r+   r
   r
   r   hostu   s    zHTTPConnection.hostc             C   s
   || _ dS )z
        Setter for the `host` property.

        We assume that only urllib3 uses the _dns_host attribute; httplib itself
        only uses `host`, and it seems reasonable that other libraries follow suit.
        N)r/   )r+   valuer
   r
   r   r1      s    c          
   C   s   i }| j r| j |d< | jr$| j|d< ytj| j| jf| jf|}W nX tk
rl   t| d| j	| jf Y n0 t
k
r } zt| d| W dd}~X Y nX |S )zp Establish a socket connection and set nodelay settings on it.

        :return: New socket connection.
        r#   r$   z0Connection to %s timed out. (connect timeout=%s)z(Failed to establish a new connection: %sN)r#   r$   r   create_connectionr/   portr   
SocketTimeoutr   r1   SocketErrorr   )r+   extra_kwconner
   r
   r   	_new_conn   s"    

zHTTPConnection._new_connc             C   s$   || _ t| dd r |   d| _d S )N_tunnel_hostr   )sockgetattr_tunnel	auto_open)r+   r8   r
   r
   r   
_prepare_conn   s    zHTTPConnection._prepare_connc             C   s   |   }| | d S )N)r:   r@   )r+   r8   r
   r
   r   connect   s    zHTTPConnection.connectc             O   s8   t |}|r"td|| f tj| ||f||S )zSend a request to the serverzAMethod cannot contain non-token characters %r (found at least %r))_CONTAINS_CONTROL_CHAR_REsearch
ValueErrorgroupr)   
putrequest)r+   methodurlr,   kwargsmatchr
   r
   r   rF      s    
zHTTPConnection.putrequestNc             C   s  t |dk	r|ni }d|k}d|k}| j||||d x | D ]\}}| || q@W d|krl| dd |   |dk	rtjtf }	t||	r|f}xh|D ]`}
|
sqt|
ts|
	d}
t
t|
d	d }| |	d
 | d | |
 | d qW | d dS )
z
        Alternative to the common request method, which sends the
        body with chunked encoding and not as one block
        Nzaccept-encodingr1   )skip_accept_encoding	skip_hostztransfer-encodingzTransfer-Encodingchunkedutf8   zutf-8s   
s   0

)
r   rF   items	putheader
endheadersr   string_typesbytes
isinstanceencodehexlensend)r+   rG   rH   bodyheadersrK   rL   headerr2   stringish_typeschunklen_strr
   r
   r   request_chunked   s2    






zHTTPConnection.request_chunked)NN)r
   r   r   r!   port_by_schemedefault_portsocketIPPROTO_TCPTCP_NODELAYr(   is_verifiedr*   propertyr1   setterr:   r@   rA   rF   r`   r
   r
   r
   r   r   G   s   

	r   c            	   @   sZ   e Zd Zed ZdZdZdZdZdZ	dZ
dddddejddfddZ
d	ddZdd ZdS )
HTTPSConnectionr   Nc
             K   sD   t j| ||f||d|
 || _|| _|| _|| _|	| _d| _d S )N)r"   r   r   )r   r*   key_file	cert_filekey_passwordssl_contextserver_hostname	_protocol)r+   r1   r4   rj   rk   rl   r"   r   rm   rn   r-   r
   r
   r   r*      s    zHTTPSConnection.__init__c
       
      C   sv   |dkr$| j dk	r| j j}ntd}|| _|| _|| _|| _|| _|| _|oVt	j
|| _|oht	j
|| _
|	| _dS )zX
        This method should only be called once, before the connection is used.
        N)rm   verify_moder   rj   rk   	cert_reqsrl   assert_hostnamer   ospath
expanduserca_certsca_cert_dirca_cert_data)
r+   rj   rk   rq   rl   rv   rr   r   rw   rx   r
   r
   r   set_cert  s    

zHTTPSConnection.set_certc             C   s  |   }| j}t| dd r4|| _|   d| _| j}|}| jd k	rH| j}tj	
 tk }|rlt
dtt d}| jd krd}tt| jt| jd| _| j}t| j|_| js| js| js|rt|dr|  t|| j| j| j| j| j| j||d	| _| j rt | jj!dd	| j  nd|jt"j#kr~t|d
ds~| j$dk	r~| j! }|%ddslt
d
|t& t'|| j$pz| |jt"j(kp| j d k	| _)d S )Nr;   r   zWSystem time is way off (before {0}). This will probably lead to SSL verification errorsFT)ssl_versionrq   load_default_certs)	r<   keyfilecertfilerl   rv   rw   rx   rn   rm   )binary_formcheck_hostnamesubjectAltNamer
   zCertificate for {0} has no `subjectAltName`, falling back to check for a `commonName` for now. This feature is being removed by major browsers and deprecated by RFC 2818. (See https://github.com/urllib3/urllib3/issues/497 for details.))*r:   r1   r=   r<   r>   r?   r;   rn   datetimedatetodayRECENT_DATEwarningswarnformatr   rm   r   r   rz   r   rq   rp   rv   rw   rx   hasattrr{   r   rj   rk   rl   r   getpeercertssl	CERT_NONErr   r'   r   _match_hostname
CERT_REQUIREDrf   )r+   r8   hostnamern   is_time_offdefault_ssl_contextcontextcertr
   r
   r   rA   2  sn    




zHTTPSConnection.connect)	NNNNNNNNN)r
   r   r   ra   rb   rq   rv   rw   rx   rz   r   rc   _GLOBAL_DEFAULT_TIMEOUTr*   ry   rA   r
   r
   r
   r   ri      s2           
ri   c          
   C   sL   yt | | W n8 tk
rF } ztd||  | |_ W d d }~X Y nX d S )Nz@Certificate did not match expected hostname: %s. Certificate: %s)r   r   logwarning
_peer_cert)r   asserted_hostnamer9   r
   r
   r   r     s    r   ):
__future__r   rer   loggingrs   rc   r   r6   r   r5   r   packagesr   Zpackages.six.moves.http_clientr   r)   r   r   SSLErrorr	   ImportErrorAttributeError
BaseExceptionr   	NameError	Exception
exceptionsr   r   r   r   Zpackages.ssl_match_hostnamer   r   Z	util.ssl_r   r   r   r   r   utilr   _collectionsr   	getLoggerr
   r   ra   r   r   compilerB   objectr    ri   r   VerifiedHTTPSConnectionr
   r
   r
   r   <module>   sL   
	


 ' (                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              python3.7/site-packages/pip/_vendor/urllib3/__pycache__/connectionpool.cpython-37.pyc               0000644                 00000057011 15107360303 0024527 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    Re                 @   s  d dl mZ d dlZd dlZd dlZd dlZd dlmZm	Z
 d dlZddlmZm
Z
mZmZmZmZmZmZmZmZmZmZmZ ddlmZ ddlmZ ddlmZ dd	lm Z m!Z!m"Z"m#Z#m$Z$m%Z%m&Z& dd
l'm(Z( ddl)m*Z* ddl+m,Z, dd
l-m.Z. ddl/m0Z0 ddl1m2Z2 ddl3m4Z4 ddl5m6Z6m7Z7m8Z8m9Z:m;Z; ddl<m=Z= ej>j?Z?e@eAZBeC ZDG dd deCZEejFejGhZHG dd deEe(ZIG dd deIZJdd ZKdd Z9dS )    )absolute_importN)errortimeout   )
ClosedPoolError
ProtocolErrorEmptyPoolErrorHeaderParsingErrorHostChangedErrorLocationValueError
MaxRetryError
ProxyErrorReadTimeoutErrorSSLErrorTimeoutErrorInsecureRequestWarningNewConnectionError)CertificateError)six)queue)port_by_schemeDummyConnectionHTTPConnectionHTTPSConnectionVerifiedHTTPSConnection
HTTPExceptionBaseSSLError)RequestMethods)HTTPResponse)is_connection_dropped)set_file_position)assert_header_parsing)Retry)Timeout)get_host	parse_urlUrl_normalize_host_encode_target)	LifoQueuec               @   sB   e Zd ZdZdZeZd
ddZdd Zdd Z	d	d
 Z
dd ZdS )ConnectionPoola;  
    Base class for all connection pools, such as
    :class:`.HTTPConnectionPool` and :class:`.HTTPSConnectionPool`.

    .. note::
       ConnectionPool.urlopen() does not normalize or percent-encode target URIs
       which is useful if your target server doesn't support percent-encoded
       target URIs.
    Nc             C   s0   |st dt|| jd| _| | _|| _d S )NzNo host specified.)scheme)r   r'   r+   hostlower_proxy_hostport)selfr,   r/    r1   /builddir/build/BUILDROOT/alt-python37-pip-20.2.4-6.el8.x86_64/opt/alt/python37/lib/python3.7/site-packages/pip/_vendor/urllib3/connectionpool.py__init__N   s
    
zConnectionPool.__init__c             C   s   dt | j| j| jf S )Nz%s(host=%r, port=%r))type__name__r,   r/   )r0   r1   r1   r2   __str__V   s    zConnectionPool.__str__c             C   s   | S )Nr1   )r0   r1   r1   r2   	__enter__Y   s    zConnectionPool.__enter__c             C   s   |    dS )NF)close)r0   exc_typeexc_valexc_tbr1   r1   r2   __exit__\   s    zConnectionPool.__exit__c             C   s   dS )zD
        Close all pooled connections and disable the pool.
        Nr1   )r0   r1   r1   r2   r8   a   s    zConnectionPool.close)N)r5   
__module____qualname____doc__r+   r)   QueueClsr3   r6   r7   r<   r8   r1   r1   r1   r2   r*   @   s   	
r*   c            
   @   s   e Zd ZdZdZeZeZdde	j
ddddddf	ddZdd	 Zd!d
dZ
dd
 Zdd Zdd Zdd Zdd ZedfddZdd Zdd Zdd Zdddddeddddf
dd ZdS )"HTTPConnectionPoolaN	  
    Thread-safe connection pool for one host.

    :param host:
        Host used for this HTTP Connection (e.g. "localhost"), passed into
        :class:`httplib.HTTPConnection`.

    :param port:
        Port used for this HTTP Connection (None is equivalent to 80), passed
        into :class:`httplib.HTTPConnection`.

    :param strict:
        Causes BadStatusLine to be raised if the status line can't be parsed
        as a valid HTTP/1.0 or 1.1 status line, passed into
        :class:`httplib.HTTPConnection`.

        .. note::
           Only works in Python 2. This parameter is ignored in Python 3.

    :param timeout:
        Socket timeout in seconds for each individual connection. This can
        be a float or integer, which sets the timeout for the HTTP request,
        or an instance of :class:`urllib3.util.Timeout` which gives you more
        fine-grained control over request timeouts. After the constructor has
        been parsed, this is always a `urllib3.util.Timeout` object.

    :param maxsize:
        Number of connections to save that can be reused. More than 1 is useful
        in multithreaded situations. If ``block`` is set to False, more
        connections will be created but they will not be saved once they've
        been used.

    :param block:
        If set to True, no more than ``maxsize`` connections will be used at
        a time. When no free connections are available, the call will block
        until a connection has been released. This is a useful side effect for
        particular multithreaded situations where one does not want to use more
        than maxsize connections per host to prevent flooding.

    :param headers:
        Headers to include with all requests, unless other headers are given
        explicitly.

    :param retries:
        Retry configuration to use by default with requests in this pool.

    :param _proxy:
        Parsed proxy URL, should not be used directly, instead, see
        :class:`urllib3.connectionpool.ProxyManager`"

    :param _proxy_headers:
        A dictionary with proxy headers, should not be used directly,
        instead, see :class:`urllib3.connectionpool.ProxyManager`"

    :param \**conn_kw:
        Additional parameters are used to create fresh :class:`urllib3.connection.HTTPConnection`,
        :class:`urllib3.connection.HTTPSConnection` instances.
    httpNFr   c       
      K   s   t | || t| | || _t|ts4t|}|d krBtj}|| _	|| _
| || _|| _
|	| _|
pli | _xt|D ]}| jd  qzW d| _d| _|| _| jr| jdg  d S )Nr   socket_options)r*   r3   r   strict
isinstancer#   
from_floatr"   DEFAULTr   retriesr@   poolblockproxy
proxy_headersxrangeputnum_connectionsnum_requestsconn_kw
setdefault)
r0   r,   r/   rD   r   maxsizerJ   headersrH   _proxy_proxy_headersrQ   _r1   r1   r2   r3      s(    


zHTTPConnectionPool.__init__c             C   sR   |  j d7  _ td| j | j| jp$d | jf | j| j| jj| jd| j	}|S )z9
        Return a fresh :class:`HTTPConnection`.
        r   z(Starting new HTTP connection (%d): %s:%s80)r,   r/   r   rD   )
rO   logdebugr,   r/   
ConnectionClsr   connect_timeoutrD   rQ   )r0   connr1   r1   r2   	_new_conn   s    
zHTTPConnectionPool._new_connc             C   s   d}y| j j| j|d}W nB tk
r8   t| dY n& tjk
r\   | jrXt| dY nX |rt|rt	
d| j |  t
|dddkrd}|p|  S )	a  
        Get a connection. Will return a pooled connection if one is available.

        If no connections are available and :prop:`.block` is ``False``, then a
        fresh connection is returned.

        :param timeout:
            Seconds to wait before giving up and raising
            :class:`urllib3.exceptions.EmptyPoolError` if the pool is empty and
            :prop:`.block` is ``True``.
        N)rJ   r   zPool is closed.z>Pool reached maximum size and no more connections are allowed.z Resetting dropped connection: %s	auto_openr   r   )rI   getrJ   AttributeErrorr   r   Emptyr   r   rY   rZ   r,   r8   getattrr^   )r0   r   r]   r1   r1   r2   	_get_conn   s"    zHTTPConnectionPool._get_connc             C   s\   y| j j|dd dS  tk
r(   Y n$ tjk
rJ   td| j Y nX |rX|  dS )a  
        Put a connection back into the pool.

        :param conn:
            Connection object for the current host and port as returned by
            :meth:`._new_conn` or :meth:`._get_conn`.

        If the pool is already full, the connection is closed and discarded
        because we exceeded maxsize. If connections are discarded frequently,
        then maxsize should be increased.

        If the pool is closed, then the connection will be closed and discarded.
        F)rJ   Nz2Connection pool is full, discarding connection: %s)	rI   rN   ra   r   