python3.7/site-packages/pip/_vendor/cachecontrol/caches/__pycache__/redis_cache.cpython-37.pyc      0000644                 00000003060 15107360303 0026240 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       B

    ReX                 @   s8   d dl mZ d dlmZ d dlmZ G dd deZdS )    )division)datetime)	BaseCachec               @   s>   e Zd Zdd Zdd ZdddZdd	 Zd
d Zdd
 ZdS )
RedisCachec             C   s
   || _ d S )N)conn)selfr    r   /builddir/build/BUILDROOT/alt-python37-pip-20.2.4-6.el8.x86_64/opt/alt/python37/lib/python3.7/site-packages/pip/_vendor/cachecontrol/caches/redis_cache.py__init__	   s    zRedisCache.__init__c             C   s   | j |S )N)r   get)r   keyr   r   r	   r      s    zRedisCache.getNc             C   s<   |s| j || n$|t  }| j |t| | d S )N)r   setr   utcnowsetexint
total_seconds)r   r   valueexpiresr   r   r	   r
      s    zRedisCache.setc             C   s   | j | d S )N)r   delete)r   r   r   r   r	   r      s    zRedisCache.deletec             C   s$   x| j  D ]}| j | qW dS )zIHelper for clearing all the keys in a database. Use with
        caution!N)r   keysr   )r   r   r   r   r	   clear   s    zRedisCache.clearc             C   s   dS )z?Redis uses connection pooling, no need to close the connection.Nr   )r   r   r   r	   close   s    zRedisCache.close)N)	__name__
__module____qualname__r
   r   r
   r   r   r   r   r   r   r	   r      s   
r   N)
__future__r   r   Zpip._vendor.cachecontrol.cacher   r   r   r   r   r	   <module>   s                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   python3.7/site-packages/pip/_vendor/cachecontrol/caches/redis_cache.py                              0000644                 00000001530 15107360303 0021753 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       from __future__ import division

from datetime import datetime
from pip._vendor.cachecontrol.cache import BaseCache


class RedisCache(BaseCache):

    def __init__(self, conn):
        self.conn = conn

    def get(self, key):
        return self.conn.get(key)

    def set(self, key, value, expires=None):
        if not expires:
            self.conn.set(key, value)
        else:
            expires = expires - datetime.utcnow()
            self.conn.setex(key, int(expires.total_seconds()), value)

    def delete(self, key):
        self.conn.delete(key)

    def clear(self):
        """Helper for clearing all the keys in a database. Use with
        caution!"""
        for key in self.conn.keys():
            self.conn.delete(key)

    def close(self):
        """Redis uses connection pooling, no need to close the connection."""
        pass
                                                                                                                                                                        python3.7/site-packages/pip/_vendor/cachecontrol/caches/file_cache.py                               0000644                 00000010071 15107360303 0021564 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       import hashlib
import os
from textwrap import dedent

from ..cache import BaseCache
from ..controller import CacheController

try:
    FileNotFoundError
except NameError:
    # py2.X
    FileNotFoundError = (IOError, OSError)


def _secure_open_write(filename, fmode):
    # We only want to write to this file, so open it in write only mode
    flags = os.O_WRONLY

    # os.O_CREAT | os.O_EXCL will fail if the file already exists, so we only
    #  will open *new* files.
    # We specify this because we want to ensure that the mode we pass is the
    # mode of the file.
    flags |= os.O_CREAT | os.O_EXCL

    # Do not follow symlinks to prevent someone from making a symlink that
    # we follow and insecurely open a cache file.
    if hasattr(os, "O_NOFOLLOW"):
        flags |= os.O_NOFOLLOW

    # On Windows we'll mark this file as binary
    if hasattr(os, "O_BINARY"):
        flags |= os.O_BINARY

    # Before we open our file, we want to delete any existing file that is
    # there
    try:
        os.remove(filename)
    except (IOError, OSError):
        # The file must not exist already, so we can just skip ahead to opening
        pass

    # Open our file, the use of os.O_CREAT | os.O_EXCL will ensure that if a
    # race condition happens between the os.remove and this line, that an
    # error will be raised. Because we utilize a lockfile this should only
    # happen if someone is attempting to attack us.
    fd = os.open(filename, flags, fmode)
    try:
        return os.fdopen(fd, "wb")

    except:
        # An error occurred wrapping our FD in a file object
        os.close(fd)
        raise


class FileCache(BaseCache):

    def __init__(
        self,
        directory,
        forever=False,
        filemode=0o0600,
        dirmode=0o0700,
        use_dir_lock=None,
        lock_class=None,
    ):

        if use_dir_lock is not None and lock_class is not None:
            raise ValueError("Cannot use use_dir_lock and lock_class together")

        try:
            from lockfile import LockFile
            from lockfile.mkdirlockfile import MkdirLockFile
        except ImportError:
            notice = dedent(
                """
            NOTE: In order to use the FileCache you must have
            lockfile installed. You can install it via pip:
              pip install lockfile
            """
            )
            raise ImportError(notice)

        else:
            if use_dir_lock:
                lock_class = MkdirLockFile

            elif lock_class is None:
                lock_class = LockFile

        self.directory = directory
        self.forever = forever
        self.filemode = filemode
        self.dirmode = dirmode
        self.lock_class = lock_class

    @staticmethod
    def encode(x):
        return hashlib.sha224(x.encode()).hexdigest()

    def _fn(self, name):
        # NOTE: This method should not change as some may depend on it.
        #       See: https://github.com/ionrock/cachecontrol/issues/63
        hashed = self.encode(name)
        parts = list(hashed[:5]) + [hashed]
        return os.path.join(self.directory, *parts)

    def get(self, key):
        name = self._fn(key)
        try:
            with open(name, "rb") as fh:
                return fh.read()

        except